/**
 * @author pritam.patil
 * This is used to show pop up of follow up details on click of follow up button 
 */
Ext.define('Academia.view.servicerequest.common.FollowUpDetailsPopUp', {
	extend: 'Ext.window.Window',
	alias: 'widget.followupdetailspopupwindow',
	modal: true,
	autoScroll: true,
	frame: true,
	maxHeight:600,
	title: getServiceRequestTranslation('FOLLOW_UP_DETAILS'),
	plugins: "formlabelrequired",
	items: [{
		xtype: 'form',
		itemId: 'followUpDetailsForm',
		items: [{
			xtype:'hidden',
			itemId:'isAutoApprove',
			name:'whetherAutoApprove',
			value:false
		},{
			xtype: 'hidden',
			itemId: 'fp_version_field',
			name: 'serviceRequestId'
		}, {
			xtype: 'fieldcontainer',
			layout: 'vbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'displayfield',
				itemId: 'user',
				fieldLabel: getServiceRequestTranslation('USER_NAME'),
				name: 'user'           
			}]},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [ {
					xtype: 'datefield',
					fieldLabel: getServiceRequestTranslation('PLANNED_FOLLOW_UP_DATE'),
					name: 'plannedFollowupDate',
					itemId: 'plannedFollowupDate',
					allowBlank: false,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					// minValue: new Date(),
					disabled: true
				}, {
					xtype: 'datefield',
					fieldLabel: getServiceRequestTranslation('ACTUAL_FOLLOW_UP_DATE'),
					name: 'actualFollowupDate',
					allowBlank: false,
					itemId: 'actualFollowupDate',
					//--submitFormat: CONSTANTS.DATE_FORMAT,
//					value: new Date(),
					vtype: 'daterange',
					endDateField: 'nextFollowUpDate',
					disabled: true,
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);						
							obj.setValue(new Date());
						}
					}
				}]},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel: getServiceRequestTranslation('FOLLOW_UP_STATUS'),
						name: 'requestStatusId',
						itemId: 'followUpStatus',
						store: 'servicerequest.common.FollowUpStatus',
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						editable: false
					}, {
						xtype: 'customcombobox',
						fieldLabel: getServiceRequestTranslation('DOCUMENT_PROOF_GIVEN'),
						name: 'documentProofStatus',
						itemId: 'documentProof',
						store: 'servicerequest.common.DocumentProofs',
						valueField: 'id',
						displayField: 'value',
						allowBlank: false,
						editable: false,
						querymode: 'local'
					}]
				}, {
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 450
					},
					items: [{
						xtype: 'textareafield',
						name: 'remarks',
						maxLength : 255,
						enforceMaxLength : true,
						fieldLabel: getServiceRequestTranslation('FOLLOW_UP_REMARKS'),
						allowBlank: false
					}]
				}, {
					xtype: 'fieldcontainer',
					width: '100%',
					itemId: 'radioButtonsrPanel',
					items: [{
						xtype: 'radiogroup',
						itemId: 'isOriginalRadio',
						allowBlank: false,
						items: [{
							boxLabel:getServiceRequestTranslation('SCHEDULE_NEXT_FOLLOW_UP'),
							name: 'isSendForApproval',
							inputValue: false,
							itemId : 'ScheduleRadioBtn',
							checked : true
						}, {
							boxLabel: getServiceRequestTranslation('SEND_FOR_APPROVAL'),
							name: 'isSendForApproval',
							itemId : 'SendForRadioBtn',
							inputValue:true
						}]
					}]
				}, {
					xtype: 'fieldcontainer',
					width: '100%',
					itemId: 'schedulePanel',
					// hidden: true,
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'datefield',
						fieldLabel: getServiceRequestTranslation('NEXT_FOLLOW_UP_DATE'),
						name: 'nextFollowupDate',
						allowBlank: false,
						itemId: 'nextFollowUpDate',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						editable : false,
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						minValue: new Date()               
					}, {
						xtype: 'customcombobox',
						fieldLabel: getServiceRequestTranslation('ACADEMY_LOCATION'),
						name: 'academyLocation',
						itemId: 'academyLocationItemId',
						store: 'servicerequest.common.ALOnFollowUpPopUp',
						valueField: 'id',
						displayField: 'value',
						//allowBlank: false,
						editable: false,
						hidden: true,
					}]
				},{
					xtype: 'fieldcontainer',
					width: '100%',
					itemId: 'schedulePanel1',
					// hidden: true,
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'livesearchcombo',
						fieldLabel: getServiceRequestTranslation('SELECT_NEW_ASSIGNEE'),                
						name: 'assignee',
						allowBlank: false,
						itemId : 'newAssigneeId',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						/*listConfig:{
						    cls: 'clsNewAssigneeHeight',
						    listeners: {
		            			beforeshow: function(picker) {
		            				picker.width = picker.up('combobox').getSize().width;
		            			}
		            		}
						}*/
					}]
				}, {
					xtype: 'fieldcontainer',
					width: '100%',
					itemId: 'sendPanel',
					hidden: true,
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'livesearchcombo',
						fieldLabel: getServiceRequestTranslation('SELECT_APPROVER'),                
						name: 'approver',
						itemId : 'approverID',       
						allowBlank: false,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listeners: {
							change: function(obj) {
								var form = obj.up().up().getForm();
								form.checkValidity();
							}
						}
					},{
			            xtype: 'customcombobox',
			            fieldLabel: getTranslation('AGENDA_NUMBER_CSM'),
			            name: 'agendaNumber',
			            itemId: 'agendaNumber',
			            store: 'servicerequest.feerequest.FollowupAgendaNumberStore',
			            valueField: 'id',
			            displayField: 'value',
			            labelAlign:'top',
			            hidden:true,
			            matchFieldWidth :true,
			            width:226,
			            editable: false,
			            querymode: 'local'
			        }]
				}, {
					xtype: 'fieldcontainer',
					width: '100%',
					items: [{
						xtype: 'fieldcontainer',
						itemId: 'studentTransferFollwupDocumentContainer',
						width: '100%',
						hidden:true,
						layout: {
							type: 'hbox'
						},
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [{
							xtype:'studenttransferfollwupdocumentgrid',
							itemId:'studentTransferFollwupDocumentGridItemId'
						}]
					},{
						xtype: 'button',
						text: getServiceRequestTranslation('SUBMIT'),
						itemId: 'followUpDetailsSubmitButtonId',
						buttonAlign: 'right',
						ui: 'CustomBtnSubmit',
						formBind : true,
						scale: CONSTANTS.BUTTONSIZE              
					},{
						xtype: 'button',
						name: 'studentTransferFollwupDocument',
						hidden:true,
						text:getCommonTranslation('UPLOAD_DOC'),
						itemId: 'studentTransferFollwupDocument',
						ui: 'CustomBtnThird',
						scale : CONSTANTS.BUTTONSIZE
					}, {
						xtype: 'button',
						text: getServiceRequestTranslation('CANCEL'),
						ui: 'CustomBtnCancel',
						itemId: 'followUpDetailsCancelButtonId',
						scale: CONSTANTS.BUTTONSIZE

					}]
				}]
	}]
});