/**
 * @author pritam.patil
 * This is used for complain details Form
 */
Ext.define('Academia.view.servicerequest.complaintrequest.StudentComplaintDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentcomplaintdetailsform',
    frame: false,
    border: false,
    autoScroll: true,
    margin: 10,
    plugins: "formlabelrequired",
    bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,	
    items: [{
    	xtype:'panel',
    	items:[{
		xtype:'hidden',			
    	name:'id',
    	itemId:'id'
    },{
       	xtype:'hidden',			
      	name:'version'
  	},{
		xtype:'nestedJsonCombo',
		name:'complaintTypeSetting',
		itemId:'settingId',
		hidden:true
	},{
        xtype: 'displayfield',
        hideLabel:true,
        itemId: 'pendingDaysMessageField',
        name: 'pendingDaysMessage',
        hidden : true
    },{
        xtype: 'form',
        title: getServiceRequestTranslation('GRIEVANCE_DETAILS'),
        collapsed: false,
        frame:true,
        margin: 0,
        /*style: {
            marginLeft: '17px',
            marginTop: '41px ! important'
        },*/
        items: [{
        xtype: 'fieldcontainer',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
            store: 'servicerequest.complaintrequest.ComplaintTypes',
            valueField: 'id',
            name : 'complaintTypeId',
            itemId: 'complaintTypeId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_DATE'),
            name: 'requestDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'complainDateId',
            allowBlank: false,
//            value:new Date(),
            maxValue: new Date(),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
          }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [ {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_AGAINST'),
            store: 'servicerequest.complaintrequest.ComplaintAgainsts',
            name : 'against',
            valueField: 'id',
            itemId: 'complaintAgainstId',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },{
            xtype: 'livesearchcombo',
            labelAlign: 'top',
            displayField: 'value', 
        	valueField: 'id', 
            name: 'complaintAgainstPerson',
            fieldLabel: getServiceRequestTranslation('SELECT_PERSON'),
            store: 'Academia.store.servicerequest.complaintrequest.ComplaintPersons',
            itemId: 'selectPersonId',
            allowBlank: false,
            disabled : true,
            displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["value"]]}' +
             		'</tpl>'
             		)
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId : 'complaintByFieldContainer',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [/*{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('COMPLAINT_BY'),
            store: 'servicerequest.complaintrequest.ComplaintBy',
            name : 'complaintBy',
            valueField: 'id',
            itemId: 'complaintById',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },{
                xtype: 'livesearchcombo',
                labelAlign: 'top',
                name: 'complainant',
                fieldLabel: getServiceRequestTranslation('SELECT_COMPLAINTANT'),
                store: 'Academia.store.servicerequest.complaintrequest.Complaintant',
                itemId: 'selectComplaintantId',
                allowBlank: false,
                disabled : true,
                displayTpl: new Ext.XTemplate(
                 		'<tpl for="."between=" ">',
                 		'{[typeof values === "string" ? values : values["value"]]}' +
                 		'</tpl>'
                 		)
        }*/]},{
            xtype: 'fieldcontainer',
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            layout: 'vbox',
            items: [{
                xtype: 'customcombobox',
                labelAlign: 'top',
                name: 'internalResourceId',
                store : 'servicerequest.complaintrequest.FacilityCodes',
                fieldLabel: getServiceRequestTranslation('FACILITY_CODE'),
                itemId: 'facilityCodeId',
                //allowBlank: false,
                valueField: 'id',
                displayField: 'valueCode',
                queryParam:'name',
				minChars:3,
				typeAhead:true,
	            hideTrigger:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            triggerAction: 'all',
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'  +
		                    '</div>';
		                }
		            }
            },/*{
                xtype: 'textareafield',
                fieldLabel: getServiceRequestTranslation('FACILITY_DESCRIPTION'),
                name: 'facilityDescription',
                width : 400,
                maxLength : 255,
                //allowBlank: false,
                itemId: 'facilityDescriptionId'
            },*/{
                xtype: 'textareafield',
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_REMARKS'),
                name: 'remarks',
                width : 460,
                maxLength : 255,
                enforceMaxLength : true,
                itemId: 'complaintRemarksId',
                allowBlank: false
            }]
        },{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            itemId: 'btnSaveComplaint',
            text: getCommonTranslation('SUBMIT'), 
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            ui:'CustomBtnCancel',
            itemId: 'cancelIdComplaint',
            style:{
            	marginLeft:'10px'
            },
            handler : function(){
            	this.up('form').getForm().reset();
            },
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
    }]}]
});