/**
 * @author Deepak S
 */
var gridStore = Ext.create('Academia.store.setup.campaignmaster.ManageSchoolStore');
Ext.define('Academia.view.setup.campaignmaster.ManageSchoolGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageschoolgrid',
	store:Ext.create('Academia.store.setup.campaignmaster.ManageSchoolStore'),
	collapsible: false,
	border: true,
	viewConfig: {
		stripeRows: true
	},
	isGridConfigurable : true,
	enableColumnHide: false,
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [ {
		header: getCommonTranslation('SCHOOL_CODE'),
		dataIndex: 'code',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('SCHOOL_CATEGORY'),
		dataIndex: 'schoolCategory.value',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('NUMBER'),
		dataIndex: 'number',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('EXAM_BOARD'),
		dataIndex: 'examBoardMaster.value',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('EDUCATION_DEPARTMENT'),
		dataIndex: 'educationDepartment.value',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('COUNTRY'),
		dataIndex: 'country.value',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('COUNTRY_REGION'),
		dataIndex: 'countryRegion.value',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('CITY'),
		dataIndex: 'city.value',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('SCHOOL_NAME'),
		dataIndex: 'value',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('SCHOOL_NAME_AFR'),
		dataIndex: 'schoolNameAfr',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('ADDRESS'),
		dataIndex: 'address',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('EMAIL_ID'),
		dataIndex: 'emailAddress',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('URL'),
		dataIndex: 'url',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('TELEPHONE'),
		dataIndex: 'telephoneNumber',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('FAX'),
		dataIndex: 'fax',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'active',
		sortable: true,
		flex: .2,
		hidden:true,
		renderer:function(val){
			if(!isNullOrEmpty(val)){
				if(val){
					return 'Active';
				}else{
					return 'Inactive';
				}
			}else{
				return '';
			}
		}
	},{
		header: getCommonTranslation('MARKETER'),
		dataIndex: 'marketer.value',
		sortable: true,
		flex: .2,
		hidden:true
	},{
		header: getCommonTranslation('WAIVE_APPLICATION_FEES'),
		dataIndex: 'waiveApplicationFees',
		sortable: true,
		flex: .2,
		hidden:true
	}],
	initComponent: function() {
		var this$ = this;
		var store = Ext.create('Academia.store.setup.campaignmaster.ManageSchoolStore');
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	}
});