/**
 *  @author Amit Gupta
 */
Ext.define('Academia.view.setup.dashboard.AlumniLicenseDetailsReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.alumnilicensedetailsreportgrid',
	title: getCommonTranslation('ALUMNI_LICENSE_DETAILS'),
	border: true,
	refreshStoreData:true,
	//isGridConfigurable: true,
	//enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getCommonTranslation('ACTIVE_STUDENT_COUNT_AS_PER_LICENSE'),
		dataIndex: 'activeStudentCountAsPerLicense',
		flex:1,
		sortable:true
	},{
		header: getCommonTranslation('ACTIVE_STUDENT_COUNT_IN_SYSTEM'),
		dataIndex: 'activeStudentCountInSystem',
		flex:1,
		sortable:true
	},{
		header: getCommonTranslation('BALANCE_ACTIVE_STUDENT_COUNT'),
		dataIndex: 'balanceActiveStudentCount',
		flex:1,
		sortable:true
	},{
		header: getCommonTranslation('APPLICATION_VALIDITY_TO_DATE'),
		dataIndex: 'applicationValidityToDate',
		flex:1,
		sortable:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{
		header: getCommonTranslation('APPLICATION_VALIDITY_NUMBER_OF_DAYS_LEFT'),
		dataIndex: 'applicationValidityNumberOfDaysLeft'
	},{
		header: getCommonTranslation('HOSTING_VALIDITY_TO_DATE'),
		dataIndex: 'hostingValidityToDate',
		flex:1,
		sortable:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{
		header: getCommonTranslation('HOSTING_VALIDITY_NUMBER_OF_DAYS_LEFT'),
		dataIndex: 'hostingValidityNumberOfDaysLeft',
		flex:1,
		sortable:true
	},{
		header: getCommonTranslation('AMC_VALADITY_TO_DATE'),
		dataIndex: 'amcValadityToDate',
		flex:1,
		sortable:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{
		header: getCommonTranslation('AMC_VALADITY_NUMBER_OF_DAYS_LEFT'),
		dataIndex: 'amcValadityNumberOfDaysLeft',
		flex:1,
		sortable:true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();

		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.setup.dashboard.AlumniLicenseDetailsReportStore');
	}
});