/**
 * @author Amit G
 * 
 * This component is used for to show Number Of Sponsored Students for selected sponsorship in grid 
 */
Ext.define('Academia.view.sponsorship.SponsorshipBillingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.sponsorshipbillinggrid',	
	closeAction: 'destroy',
//	title :getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	title: getCommonTranslation('SPONSORSHIP_BILLING_REPORT'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS		
	},		
	isGridConfigurable: true,
	enableColumnHide: false,
	border: true,	
	columns :[{
			header:  getCommonTranslation('SPONSOR_Id'),
			dataIndex: 'sponsorCode',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('SPONSOR_NAME'),
			dataIndex: 'sponsorName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('STUDENT_ID'),
			dataIndex: 'studentCode',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'studentPrintName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('STUDENT_FIRST_NAME'),
			dataIndex: 'studentFirstName',
			flex:1,
			hidden:true,
			sortable:true
		},{
			header:  getCommonTranslation('STUDENT_MIDDLE_NAME'),
			dataIndex: 'studentMiddleName',
			flex:1,
			hidden:true,
			sortable:true
		},{
			header:  getCommonTranslation('STUDENT_LAST_NAME'),
			dataIndex: 'studentLastName',
			flex:1,
			hidden:true,
			sortable:true
		},{
			header:  getCommonTranslation('NATIONAL_ID'),
			dataIndex: 'nationalID',
			flex:1,
			hidden:true,
			sortable:true
		},{
			header:  getCommonTranslation('ACADEMY'),
			dataIndex: 'academyLocationName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('BATCH'),
			dataIndex: 'batchName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('SECTION'),
			dataIndex: 'sectionsName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('BILL_NO'),
			dataIndex: 'billNo',
			flex:1,
			sortable:true
		},{
			header:  getFeeAndPaymentCommonTranslation('BILLING_DATE'),
			dataIndex: 'billingDate',
			flex:1,
			sortable:true,
			renderer : function(value){
				return  dateRender(value);
			}
		},{
			header:  getCommonTranslation('STAGE_TYPE'),
			dataIndex: 'billStageName',
			flex:1,
			sortable:true
		},{
			header:  getFeeAndPaymentCommonTranslation('FEE_HEAD_NAME'),
			dataIndex: 'feeHeadName',
			flex:1,
			sortable:true
		},{
			header:  getCommonTranslation('FEE_HEAD_TOTAL_AMT_PAYBLE'),
			dataIndex: 'feeHeadAmount',
			flex:2,
			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			renderer:function(value,meta,record){
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},{
			header:  getCommonTranslation('AMOUNT_SPONSORED'),
			dataIndex: 'amountSponsored',
			flex:1,
			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			renderer:function(value,meta,record){
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},{
			header:  getCommonTranslation('AMOUNT_TYPE'),
			dataIndex: 'amountType',
			flex:1,
			sortable:true,
			renderer:function(value,meta){
				if(!isNullOrEmpty(value)) {
					if(value == getFeeAndPaymentCommonTranslation('PERCENTAGE')){
						return getCommonTranslation('PERCENTAGE');
					}
					else if(value == getFeeAndPaymentCommonTranslation('FIXED_AMOUNT')){
						return getCommonTranslation('FIXED_AMOUNT');
					}
				}                       
			} 
		}/*,{
		header:  getCommonTranslation('CURRENCY_NAME'),
		dataIndex: 'currencyName',
		flex:1
	}*/,{
		header:  getCommonTranslation('SPONSOR_SHIP_PERCENTAGE'),
		dataIndex: 'sponsorshipPercentage',
		flex:1
	}] ,
	initComponent: function() {
		var this$ = this;
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});

		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.sponsorship.SponsoredBillingStudentSearchStore');
	}
});