/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show sponsor company details in form  
 */
Ext.define('Academia.view.sponsorship.SponsorshipMasterSponsorCompanyDetails', {
    extend: 'Ext.window.Window',
    alias: 'widget.sponsorcompanydetailswindow',
    title: getCommonTranslation('SPONSOR_COMPANY_DETAILS'), //Sponsor Company Details
	
    autoScroll: true,    
    modal : true,
    items: [{
        xtype: 'idgeneratorformwin',
        formCode:'sponsorshipForm',
        plugins : "formlabelrequired",
        itemId: 'addSponsorshipform',
        method: 'POST',
        standardSubmit: false,
        layout: {
                type: 'vbox',
                	
            },
        defaults: {
                labelAlign: 'top',
                margin:1,
                width: 226
            },
   items:[{
        xtype: 'hidden',
        name: 'id',
        itemId : 'Hidden_id'
    },{
    	xtype : 'hidden',
		name : 'version'
    },  
	{
		xtype : 'textfield',
		name : 'sponsorshipCode',		
		fieldLabel : getCommonTranslation('SPONSOR_Id'),  //Sponsor Id
		allowBlank: false,
		enforceMaxLength:true,
		emptyText: getCommonTranslation('ID_AUTOGENERATE'),
        maxLength:10,
		itemId : 'sponsorID',
		//readOnly :true,
        maskRe:/^[a-z0-9]+$/i
	},{
		xtype : 'textfield',
		name : 'sponsorName',
		fieldLabel : getCommonTranslation('SPONSOR_NAME'), //Sponsor Name
		allowBlank: false,
		//vtype:'NospaceAsInput'
		vtype: 'spaceAndSpecialCharactersAsInput'
	},
	{
		xtype : 'textfield',
		name : 'sponsorNameInOtherLanguage',
		itemId:'sponsorNameInOtherLanguage',
		fieldLabel : getFeeAndPaymentCommonTranslation('SPONSOR_NAME_IN_OTHER_LANGUAGE'), //Sponsor Name
		//allowBlank: true,
		hidden:true,
		maxLength:255
		
	},
	{
        xtype: 'statusCombo',
        fieldLabel : getCommonTranslation('SPONSOR_STATUS'), //Sponsor Status
        editable: false,
        allowBlank: false,
        name: 'sponsorStatus'
    }, {
        xtype: 'customcombobox',
        name: 'sponsorType',
        itemId: 'cmbSponsorType',
        fieldLabel: getCommonTranslation('SPONSOR_TYPE'), //Sponsor Type
        store: 'sponsorship.SponsorTypes',
        valueField: 'id',
        displayField: 'value',
        editable: false,
         //Select a sponsor type
        queryMode: 'local',
        triggerAction: 'all',
        forceSelection: true,
        allowBlank: false
    },{
		xtype : 'textfield',
		name : 'vatNumber',
		itemId: 'vatNumber',
		fieldLabel : getCommonTranslation('VAT_NUMBER'),
		maxLength:100
	},{
		xtype : 'textfield',
		name : 'companyRegistrationNumber',
		itemId: 'companyRegistrationNumber',
		fieldLabel : getCommonTranslation('COMPANY_REGISTRATION_NUMBER'), 
		maxLength:100
	},
    {
        xtype: 'checkboxfield',
        boxLabel: getCommonTranslation('WHETHER_SUSPENSE_ACCOUNT'), //Allow Consolidation of student bills
        name: 'isSuspenseAccount',
        inputValue: 'true',
        width: 'auto',
        uncheckedValue: 'false',
        itemId: 'isSuspenseAccount'
    },{
        xtype: 'checkboxfield',
        boxLabel: getCommonTranslation('ALLOW_CONSOLIDATION_BILLS'), //Allow Consolidation of student bills
        name: 'consolidationAllowed',
        inputValue: 'true',
        width: 'auto',
        uncheckedValue: 'false',
        itemId: 'chkAllowConsolidation'
    },{
                    xtype: 'fieldcontainer',
                    
                    items: [{
                        xtype: 'button',
                        itemId: 'btnSaveCompanyDetails',
                        text: getCommonTranslation('SAVE'), //Submit
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }, {
                        xtype: 'button',
                        itemId: 'btnCancelCompanyDetails',
                        text: getCommonTranslation('CANCEL'), //Cancel
                        ui: 'CustomBtnCancel',
                        scale: CONSTANTS.BUTTONSIZE
                    }]
                }]
        }]

});