/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Number Of Sponsored Students for selected sponsorship in grid 
 */
Ext.define('Academia.view.sponsorship.SponsorshipMasterViewSponsoredStudentsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.sponsorshipmasterviewsponsoredstudentsgrid',	
	closeAction: 'destroy',
	title :getCommonTranslation('LIST_OF_SPONSORED_STUDENTS'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS		
	},		  
	border: true,	
	autoScroll:false,
    features: [{
        id: 'group',
        ftype: 'groupingsummary',
        groupHeaderTpl: '{name}',
        hideGroupedHeader: false,
        enableGroupingMenu: true
    }/*,{
        ftype: 'summary',
        dock: 'bottom'
    }*/],
	columns :[
    {
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		itemId: 'studentCodeColumn',
		sortable : true,
		flex:.2,
		renderer: function(value) {
        	if(!isNullOrEmpty(value))
            	   value="<a href='#'>"+value+"</a>";
            return value;
        },
        summaryRenderer: function(value, summaryData, data) {
        	var text = "Total";
        	if(data.internalId.indexOf('summary') > 0){
        		text = "Grand Total";
        	}
            return text;
        }
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',		
		flex:.2
	},{
		header : getCommonTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',		
		flex:.2
	},{
		header : getCommonTranslation('FEE_PLAN_STAGES'),
		dataIndex : 'feePlanRuleStageName',		
		flex:.2
	},{
		header : getCommonTranslation('FEE_HEAD_TYPE'),
		dataIndex : 'feeHeadName',		
		flex:.2
	},{
		header : getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex : 'totalAmount',		
		flex:.2,
		summaryType: 'sum',
   		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getCommonTranslation('AMOUNT_SPONSORED'),
		dataIndex : 'amountSponsored',		
		flex:.2,
		summaryType: 'sum',
   		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	}] ,
     initComponent: function() {
         var this$ = this;
         var store = this$.buildStore();
         Ext.apply(this$, {
             store: store,
             dockedItems: [{
                 xtype: 'toolbar',
                 dock: 'bottom',
                 items: [{
                     xtype: 'custompagingtoolbar',
                     plugins: ['pagesize'],
                     store: store,
                     emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                     displayInfo: true
                 }]
             }]
         });

         this$.callParent(arguments);
     },
     buildStore: function() {
         return Ext.create('Academia.store.sponsorship.SponsoredStudents');
     }
});