/**
 * @author priyanshi sharma
 *
 */
Ext.define('Academia.view.sponsorship.invoice.SponsorInvoiceDocumentListWin', {
	extend: 'Ext.window.Window',
	alias : 'widget.sponsorinvoicedocumentlistwin',
	border: true,
	modal : true,
	title: getCommonTranslation('DOCUMENTS'),
	overflowX:'hidden',
	overflowY:'auto',
	height: 500,
	width: 600,
	resizable: false,
	bodyPadding: 10,
	items: [{
		xtype: 'grid',
		itemId: 'docListGridId',
		columnLines: true,
		store:'sponsorship.invoice.SponsorInvoiceDocumentStore',
		border:true,
		selType:'checkboxmodel',
		selModel: {
			multiSelect :true,
			mode:'SIMPLE',
			checkOnly : false
		},
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS,
			deferEmptyText: false,
			emptyText: getCommonTranslation('NORESULTSNMESSAGE')
		},
		tbar: ['->',{
			xtype : 'button',
			itemId : 'downloadDocumentItemId',
			tooltip : getCommonTranslation('DOWNLOAD_ALL'),
			text : getCommonTranslation('DOWNLOAD_ALL'),
			cls:'submitBtnCls'
		}],
		columns: [{
			header : getCommonTranslation('DOCMENT_NAME'),
			dataIndex : 'name',
			flex:1,
			sortable: false,
			renderer:function(value, metadata, record){
				if(value){
					return '<a href="#">'+value+'</a>';
				}else{
					return '';
				}
				
			}
		},{
			header : getCommonTranslation('UPLOADED_ON'),
			dataIndex : 'submissionDate',
			flex:1,
			sortable: false,
			renderer: function(value, metadata, record) {
				return dateRender(value);
			}
		}]
	}]
});