/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.standardMaster.ActivePaymentGateWayWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.activepaymentgatewaywin',
	title: getCommonTranslation('ACTIVE_PAYMENT_GATEWAY'),
	closeAction: 'hide', 
	//autoScroll:true,
	overflowY:'auto',
	border: true,
	modal:true,
	height:350,
	width: 600,
	items: [{
        xtype: 'grid',
        border:true,
        itemId:'paymentGatewayGridId',
        store:'standardMaster.OSMAllPaymentGateWayStore',
        style:{
        	marginTop:'-28px !important',
        	minWidth: '523px'
        },
    	refreshStoreData:true,
    	viewConfig: {
    		stripeRows: CONSTANTS.STRIPEROWS
    	},
    	cls:'no-column-separator',
        columns: [{
    		header:  getCommonTranslation("PAYMENT_GATEWAY"),
    		dataIndex:'value',
    		flex:2
    	},{
    		xtype: 'checkcolumn',
    		header:  getCommonTranslation("STATUS"),
    		dataIndex: 'activeStatus',
    		flex:1,
    		renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
                var cssClass = value ? 'custom-checked-icon' : 'custom-unchecked-icon';
                metaData.tdCls = cssClass;
                var grid =  view.up('grid');
                var store = grid.getStore();
        		var allRecords = store.getRange();
        		var sumbitBtn = grid.up('activepaymentgatewaywin').down('#submitBtn');
        		var enableBtn=false;
        		Ext.each(allRecords, function(rec) {
        			if(rec.data.activeStatus){
        				enableBtn=true;
        			}
        		});
        		sumbitBtn.setDisabled(!enableBtn);
                return Ext.grid.column.CheckColumn.prototype.renderer.apply(this, arguments);
            },
            listeners: {
            	checkchange: function (checkColumn, rowIndex, checked, record, eOpts) {
            		var grid = checkColumn.up('grid');
            		var store = grid.getStore();
            		var allRecords = store.getRange();
            		var sumbitBtn = grid.up('activepaymentgatewaywin').down('#submitBtn');
            		var enableBtn=false;
            		Ext.each(allRecords, function(rec) {
            			if(rec.data.activeStatus){
            				enableBtn=true;
            			}
            		});
            		sumbitBtn.setDisabled(!enableBtn);
            	}
            }
    	}]
	},{
		xtype:'fieldcontainer',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('SUBMIT'),
			formBind: true,
			itemId: 'submitBtn',
			ui: 'CustomBtnSubmit',
            style:{
                marginLeft: '11px'
            },
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]	
});