/**
 * @author Amit G

 */
var MedicalDetailReportStore = Ext.create('Academia.store.student.report.StudentMedicalDetailsReportStore');
Ext.define('Academia.view.student.medicalDetailsReport.StudentMedicalDetailsReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentmedicaldetailsreportgrid',
	title: getCommonTranslation('STUDENT_MEDICAL_DETAILS_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable : true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: MedicalDetailReportStore,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: MedicalDetailReportStore,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this.callParent(arguments);
	},
	buildStore: function() {
		return MedicalDetailReportStore;
	},
	columns: [{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocation',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex: 'studentFirstName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex: 'studentMiddleName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('STUDENT_SURNAME'),
		dataIndex: 'studentSurname',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex:.1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batch',
		flex:.1
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'section',
		flex:.1
	},{
		header:  getCommonTranslation('SCHEME'),
		dataIndex: 'scheme',
		flex:.1
	},{
		header:  getCommonTranslation('OPTION'),
		dataIndex: 'option',
		flex:.1
	},{
		header:  getCommonTranslation('PRINCIPAL_MEMBER'),
		dataIndex: 'principalMember',
		flex:.1
	},{
		header:  getCommonTranslation('MEMBERSHIP_NO'),
		dataIndex: 'membershipNo',
		flex:.1
	},{
		header:  getCommonTranslation('Valid_Till'),
		dataIndex: 'validTill',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('BLOOD_TYPE'),
		dataIndex: 'bloodType',
		flex:.1
	},{
		header:  getCommonTranslation('CHILD_DEPENDENT_CODE'),
		dataIndex: 'childDependentCode',
		flex:.1
	},{
		header:  getCommonTranslation('PRACTITIONER_NAME'),
		dataIndex: 'practitionerName',
		flex:.1
	},{
		header:  getCommonTranslation('PRACTITIONER_CONTACT_NO'),
		dataIndex: 'practitionerContactNo',
		flex:.1
	}]
});
