/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.student.report.StudentTransferReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studenttransferreportgrid',
	title: getCommonTranslation('STUDENTTRANSFERREPORT'),
	store: 'student.report.StudentTransferReportGridStore',
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.StudentTransferReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('STUDENT_CODE'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM_NAME'),
		dataIndex: 'fromProgramName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH_NAME'),
		dataIndex: 'fromBatchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD_NAME'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('TRANSFER_FROM'),
		dataIndex: 'transferFrom',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('TRANSFER_TO'),
		dataIndex: 'transferTo',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('TRANSFER_DATE'),
		dataIndex: 'transferDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('APPROVED_BY'),
		dataIndex: 'approvedBy',
		flex:.1,
		sortable:true
	}]
});

