/**
 * @author Amit G
 */
Ext.define('Academia.view.student.studentDeletedReport.StudentDeletedReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentdeletedreportgrid',
	title: getCommonTranslation('DELETED_STUDENT_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.report.StudentDeletedReportStore');
	},
	columns: [{
		header: getCommonTranslation('ARCHIVED_STUDENT_ID'),
		dataIndex: 'archivedStudentId',
		flex:.1
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex:.1
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batch',
		flex:.1
	},{
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'period',
		flex:.1
	},{
		header: getCommonTranslation('STUDENT_DELETION_DATE'),
		dataIndex: 'lastUpdate',
		flex:.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('STUDENT_DELETED_BY'),
		dataIndex: 'deletedByFirstName',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_CONTACT_NO'),
		dataIndex: 'contactNo',
		flex:.1
	},{
		header: getCommonTranslation('EMAIL'),
		dataIndex: 'emailId',
		flex:.1,
		hidden:true
	},{
		header: getExaminationTranslation('STUDENT_STATUS'),
		dataIndex: 'statusUpdated',
		flex:.1,
		hidden:true
	}]
});
