/**
 * @author Prakash Sharma
 */
var feepayerStore = Ext.create('Academia.store.student.report.StudentFeePayerReportGridStore');
Ext.define('Academia.view.student.studentFeePayerReport.StudentFeePayerReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentfeepayerreportgrid',
	store: feepayerStore,
	title: getPersonModuleTranslation('STUDENT_FEE_PAYER_DETAILS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	isGridConfigurable : true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId : 'dockedItemId',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.StudentFeePayerReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],*/
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid, false);
		var this$ = this;
       // var store = feepayerStore;
        Ext.apply(this$, {
            store: feepayerStore,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: feepayerStore,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionId',
		flex:1,
		sortable : true,
		hidden:true
	},{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_FEE_PAYER_TYPE'),
		dataIndex : 'feePayerType',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_EMPLOYEE_ID'),
		dataIndex : 'employeeId',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('FPD_NAME_OF_COMPANY'),
		dataIndex : 'nameOfCompany',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_FEE_PAYER_NAME'),
		dataIndex : 'feePayerFirstName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'feePayerLastName',
		flex : 1,
		sortable : true,
		hidden : true
	},{
		header : getCommonTranslation('FEE_PAYER_CONSENT_TO_CREDIT_CHECK'),
		dataIndex : 'consentCreditCheck',
		flex : 1,
		sortable : true,
		hidden:true,
		renderer : function(value){
			console.log("value :"+value);
			return value != null && value ? 'Yes' : 'No';
		}
	},{
		header : getCommonTranslation('TELEPHONE'),
		dataIndex : 'telephone',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('MOBILE_NUMBER'),
		dataIndex : 'mobile',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_NATIONAL_ALTERNATE_ID'),
		dataIndex : 'nationalId',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_WORK_EMAIL'),
		dataIndex : 'workEmail',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_HOME_EAMIL'),
		dataIndex : 'homeEmail',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_COMPANY_ADDRESS'),
		dataIndex : 'companyAddress',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_PAYMENT_MODE'),
		dataIndex : 'paymentMode',
		flex : 1,
		sortable : true,
		renderer : function(value){
			if(value!=null){
				return value;
			}
		}
	},{
		header : getCommonTranslation('FPD_DEBIT_ORDER_DATE'),
		dataIndex : 'debitOrderDate',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_ACCOUNT_TYPE'),
		dataIndex : 'accountType',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ACCOUNT_NUMBER'),
		dataIndex : 'accountNo',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_ACCOUNT_NAME'),
		dataIndex : 'accountName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_BANK_NAME'),
		dataIndex : 'bankName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FPD_BRANCH_CODE'),
		dataIndex : 'branchCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('STD_FEE_PAYER_ID'),
		dataIndex : 'feePayerId',
		flex : 1,
		sortable : true,
		renderer : function(value){
			return value != null && value !='' ? 'Yes' : 'No';
		}
	},{
		header : getCommonTranslation('LATEST_PAYSLIP'),
		dataIndex : 'latestPayslip',
		flex : 1.2,
		sortable : true,
		renderer : function(value){
			return value != null && value !='' ? 'Yes' : 'No';
		}
	},{
		header : getCommonTranslation('LAST_UPDATED_BY'),
		dataIndex : 'lastUpdatedBy',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('LAST_UPDATED_DATE'),
		dataIndex : 'lastUpdate',
		flex : 1,
		hidden:true,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});
