/**
 * @author Amit G
 */
Ext.define('Academia.view.student.studentLeaversReport.StudentLeaversReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentleaversreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'multiselectcombofield',
				name : 'academyLocation',
				itemId:'academyLocationId',
				autoloadStore: false,
				width: 694,
				fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				queryParam:'qry',
				minChars:3,
				typeAhead:true,
				cls:'receiptHeaderMultiselect',
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
	     	}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: 'student.report.InactiveAdmissionStudentIdStore',
	     		fieldLabel : getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
	     		valueField: 'id',
	 			displayField: 'valueCode',
	 			queryParam:'name',
	     		minChars:3,
	     		typeAhead:false,
	     		width:460,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width:226,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:226
				},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name : 'academicTerm',
					itemId : 'academicTerm',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : false,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.AcademicTermStore');
							combo.bindStore(store)
						}
					}
				},{
					xtype : 'customcombobox',
					name : 'programGroupCombo',
					itemId: 'programGroupCombo',
					fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
					valueField: 'id',
		            displayField: 'value',
		            queryParam:'programGroupName',
		            typeAhead:false,
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                forceSelection:true,
	                listeners: {
						render: function(combo) {
	                    	  //var store = Ext.create('Academia.store.student.report.ProgramGroupWithAcademicTermStore');
	                    	  var store = Ext.create('Academia.store.personinfo.common.personalinfo.MappedProgramGroupByALStore');
	                         combo.bindStore(store);
	                     }
					}
				},{
	            	 xtype: 'customcombobox',
		    			name:'PROGRAM_NAME',
		    			itemId:'programId',
		    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    			valueField: 'id',
		    			displayField: 'valueCode',
		    			queryParam:'programName',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		                listeners: {
    						render: function(combo) {
		                    	  var store = Ext.create('Academia.store.student.report.ProgramWithAcademicTermStore');
		                         combo.bindStore(store);
		                     }
    					},
    					listConfig: {
    						listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    						loadingText: getCommonTranslation('SEARCHING'),
    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    						getInnerTpl: function() {
    							return '<div class="search-item">' +
    							'{code}'  +
    							'</div>';
    						}
    					}
		    		
		            }]
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:226
				},
				items:[{
	                 xtype: 'customcombobox',
	                 name: 'BATCH_NAME',
	                 itemId: 'batchId',
	                 fieldLabel: getPersonModuleTranslation('BATCH'),
	                 disabled:true,
	                 editable: false,
	                 queryMode: 'local',
	                 displayField: 'value',
	                 valueField: 'id',
	                 listeners: {
	                     render: function(combo) {
	                    	 var store = Ext.create('Academia.store.common.CurrentBatchStore');
	                         combo.bindStore(store);
	                     }
	                 }
	             },{
	                 xtype: 'customcombobox',
	                 itemId:'periodId',
	                 disabled:true,
	                 editable: false,
	                 displayField: 'value',
	                 valueField: 'id',
	                 queryMode: 'local',
	                 fieldLabel: getPersonModuleTranslation('PERIOD'),
	                 name: 'PERIOD_NAME',
	                 listeners: {
	                     render: function(combo) {
	                         var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
	                         combo.bindStore(store);
	                     }
	                 }
	             },{
	                 xtype: 'statusCombo',
	                 name: 'studentStatus',
	                 itemId: 'studentStatus',
	                 fieldLabel: getExaminationTranslation('STUDENT_STATUS'),
	                 value:''
	             }]
			}]
		
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:226
				},
				items:[{
					xtype: 'datefield',
					name: 'FROM_DATE',
					itemId: 'FROM_DATE',
					vtype: 'daterange',
					endDateField: 'TO_DATE',
					fieldLabel: getAdmissionTranslation('FROM_DATE'),
					listeners: {
						render: function(field) {
							field.setMaxValue(new Date());
							return dateFormatRender(field);
						}
					},
					vtype : 'daterange'
				}, {
					xtype: 'datefield',
					name: 'TO_DATE',
					itemId: 'TO_DATE',
					vtype: 'daterange',
					startDateField: 'FROM_DATE',
					fieldLabel: getAdmissionTranslation('TO_DATE'),
					listeners: {
						render: function(field) {
							field.setMaxValue(new Date());
							return dateFormatRender(field);
						}
					},
					vtype : 'daterange'
	             }]
			}]
		
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});