/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.student.studentprofile.AcademicTopicUrlGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.academictopicurlgrid',
	store :'student.studentprofile.AcademicTopicUrlsStore',
	border: true,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_ACADEMIC_TOPIC_URLS'),
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.studentprofile.AcademicTopicUrlsStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],*/
	initComponent: function() {
		var grid=this;
		this.callParent(arguments);
	},

	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH

	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'name',
		flex:1,
		renderer:function(value, metaData, record){
			if(record){
				/*var pathSplit=record.data.path.split('/');
				var newPath=pathSplit[2];
				var newvalue=!isNullOrEmpty(value)?value:newPath;
				return "<a href='#'>"+newvalue+"</a>";*/
				var value1=!isNullOrEmpty(value)?value:record.data.name;
                var newPath=record.data.path;    
                var val=!isNullOrEmpty(value1)?value1:newPath;
                return "<a href="+newPath+" target='_blank'>"+val;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	}]
});