Ext.define('Academia.view.student.studentprofile.StudentPostDocInfoGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentpostinfogrid',
	title: getPersonModuleTranslation('STUDENT_POST_DOC_INFO'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode:true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		var grid=this$;                   
		grid.addExportToolBarItems(grid);
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
					displayInfo: true
				}]
			}]
		});
		this$.callParent(arguments);
	},
	columns : [ {
		header: getPersonModuleTranslation('CONTRACT_START_DATE'),
		dataIndex: 'contractStartDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('CONTRACT_END_DATE'),
		dataIndex: 'contractEndDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getPersonModuleTranslation('POST_DOC_QUALILFICATION_NAME'),
		dataIndex : 'qualificationName',
		flex:1,
		sortable:true
	},{
		header : getPersonModuleTranslation('POST_DOC_QUALILFICATION_INSTITUTION'),
		dataIndex : 'qualificationInstitution',
		flex:1,
		sortable:true
	},{
		header : getPersonModuleTranslation('OBTAINED_DOCTORATE_FIELD_OF_STUDY'),
		dataIndex : 'obtainedDoctorateFieldOfStudy',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.obtainedDoctorateFieldOfStudy.value
			}                        
		}
	},{
		header: getPersonModuleTranslation('DOCTORATE_OBTAINED_DATE'),
		dataIndex: 'doctorateObtainedDate',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getPersonModuleTranslation('POST_DOC_FIELD_OF_STUDY'),
		dataIndex : 'postDocFieldOfStudy',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.postDocFieldOfStudy.value
			}                        
		}
	},{
		header: getPersonModuleTranslation('POST_DOC_DEPARTMENT'),
		dataIndex: 'department',
		flex: 1,
		sortable: true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.department.value
			}                        
		}
	},{
		header : getPersonModuleTranslation('FINANCIAL_RESOURCE_ONE'),
		dataIndex : 'financialResourceOne',
		flex:1,
		sortable:true,
		hidden:false,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.financialResourceOne.value
			}                        
		}
	},{
		header : getPersonModuleTranslation('FINANCIAL_RESOURCE_TWO'),
		dataIndex : 'financialResourceTwo',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header : getPersonModuleTranslation('FINANCIAL_RESOURCE_THREE'),
		dataIndex : 'financialResourceThree',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header : getPersonModuleTranslation('FINANCIAL_RESOURCE_FOUR'),
		dataIndex : 'financialResourceFour',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header: getCommonTranslation('DATE_OF_TERMINATION'),
		dataIndex: 'dateOfTermination',
		ItemId: 'dateOfTermination',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getPersonModuleTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'studentPostDocInfoDocuments',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.studentPostDocInfoDocuments.length>1) {					
					return '<a href=#>'+record.data.studentPostDocInfoDocuments.length+'<a>';
				} else if(record.data.studentPostDocInfoDocuments.length==1) {
					return '<a href=#>'+record.data.studentPostDocInfoDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getPersonModuleTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}],
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.pasthistory.StudentPostDocInfoStore');
	}
});