/**
 * Deepak Nigam
 */
Ext.define('Academia.view.studentPortal.examinationDocuments.GenerateHallTicketGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.generatehallticketgrid',
	store: 'personinfo.student.GenerateHallTicketGridStore',
	title: getExaminationTranslation('HALL_TICKETS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'personinfo.student.GenerateHallTicketGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[/*{
			xtype: 'button',
			itemId: 'btnApproveId',
			disabled:true,
			text:getExaminationTranslation('APPROVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}*/]
	},/*{
		xtype: 'button',
		itemId: 'btnWithdrawnId',
		text: getExaminationTranslation('WITHDRAWN'),
		disabled:true,
	}, {
		xtype: 'button',
		itemId: 'btnHallTicketRegenerationId',
		text: getExaminationTranslation('REGENERATE_HALL_TICKET'),
		disabled:true,
	}, {
		xtype: 'button',
		itemId: 'btnPublishHallTicket',
		text: getExaminationTranslation('PUBLISH_HALL_TICKET'),
		disabled:true,
	}*/,'->',{
		xtype: 'button',
		itemId: 'btnDownloadAllHallTickets',
		disabled:true,
		text:getExaminationTranslation('DOWNLOAD_ALL_HALL_TICKETS')
	}],
	columns: [{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('TOTAL_OUTSTANDING'),
		dataIndex: 'totalOutstanding',
		flex:.3,
		sortable: true,
		renderer: function(currency) {
			if(!isNullOrEmpty(currency)) {
				return "INR. "+currencyRender(currency);
			} else {
				return "<b>N/A</b>";
			}
		}
	},/*{
		header: getExaminationTranslation('APPLICATION_STATUS'),
		dataIndex: 'applicationStatus',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value))
				return capitaliseEnumValue(value);
		}
	},*/ {
		header: getExaminationTranslation('HALL_TICKET_NO'),
		dataIndex: 'hallticket',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value!=null) {
				return '<a href=#>'+value+'</a>';
			}
		}
	}/*, {
		header: getExaminationTranslation('CENTER_ALLOTED'),
		dataIndex: 'centerAllotted',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)){
				return capitaliseEnumValue(value);
			}

		}
	},{
		header: getExaminationTranslation('NON_APPROVAL_REASON'),
		dataIndex: 'reasonForNonApproval',
		flex:.3,
		sortable: true,
		renderer: function(value){
			if(!isNullOrEmpty(value)) {
				return getExaminationTranslation(value);
			}

		}
	}*/]
});