/**
 * @author Dharmendra G
 */
Ext.define('Academia.view.studentjourneysetup.StudentJourneySetupWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentjourneysetupwin',
	autoScroll: true,
	title:getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'customform',
		customFieldEntity:CONSTANTS.SECTION_CUSTOM_FIELD,
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
	            xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
	            name: 'academyLocation',
	            itemId:'academyLocationId',
	            store: 'user.UserAcademyLocationStore',
	            displayField: 'value',
	            valueField: 'id',
	            queryParam:'qry',
				minChars:3,
				typeAhead:false,
				allowBlank:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
	            forceSelection:true,
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
				name: 'program',
				itemId: 'programId',
				autoload: false,
				store: 'scholarships.AssociateProgramStore',
				valueField: 'id',
				displayField: 'valueCode',
				//queryParam:'qry',
				allowBlank:false,
				disabled:true,
	            forceSelection:true,
	            hideTrigger:false,
	             triggerAction: 'all',
	           // minChars:3,
	           // emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'+ 
		                    '</div>';
		                }
		            }
			
	        }]
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype: 'customcombobox',
				name: 'batch',
				fieldLabel: getCourseTxCommonTranslation('BATCH'),
				itemId:'batchId',
				store: 'common.CurrentBatchStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				typeAhead:true,
				disabled:true,
				forceSelection:true
			},{
	  			xtype : 'numberfield',
	  			name : 'academicTermSequence',
	  			itemId:'academicTermSequenceId',
	  			allowBlank:false,
	  			fieldLabel: getCommonTranslation('PROGRAM_SEQUENCES'),
	  			maxValue: 100000,
	  			minValue:1
				
			}]
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [
				{
		  			xtype : 'numberfield',
		  			name : 'minAcademicTerm',
		  			itemId:'minAcademicTermId',
		  			allowBlank:false,
		  			fieldLabel: getCommonTranslation('MIN_ACADEMIC_TERM'),
		  			maxValue: 10,
		  			minValue:1
					
				},{
		  			xtype : 'numberfield',
		  			name : 'maxAcademicTerm',
		  			itemId:'maxAcademicTermId',
		  			allowBlank:false,
		  			fieldLabel: getCommonTranslation('MAX_ACADEMIC_TERM'),
		  			maxValue: 10,
		  			minValue:1
					
				}
				
			]
		},{
			
			xtype:'fieldcontainer',
			layout:'hbox',
			style:{
				marginLeft:'-03px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'studentJourneySetupSubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'studentJourneySetupCancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		
		}]
	}]     
});
