


/**
 * @author Shashi Kumara
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleApplyToCourseGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.businessruleapplytocoursegrid',
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);
	},
	store: 'sunsuccess.BusinessRuleApplyToCourseGridStore',
	title: getCourseTxCommonTranslation('SEARCH_RESULT'),
	border: true,
	refreshStoreData: true,
	selType:'checkboxmodel',
	selModel: {
		checkOnly : false,
		multiSelect :true,
	    mode: 'SIMPLE'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
//		hidden:true,
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'sunsuccess.BusinessRuleApplyToCourseGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},/* {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},*/ {
		xtype: 'button',
		itemId: 'btnView',
		disabled: true,
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled: true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getExaminationTranslation('MODULE_CODE'),
		dataIndex: 'courseCode',
		sortable: true,
		flex: 1
	}, {
		header: getExaminationTranslation('MODULE'),
		dataIndex: 'courseName',
		sortable: true,
		flex: 1
	},{
		header: getExaminationTranslation('MODULE_VARIENT'),
		dataIndex: 'courseVariantName',
		sortable: true,
		flex: 1
	}, {
		header: getExaminationTranslation('TEACHER_NAME'),
		dataIndex: 'facultyName',
		sortable: true,
		flex: 1
	}]
});