Ext.define('Academia.view.sunsuccess.businessrules.BusinessRulesListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.businessruleslistgrid',
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);
	},
	store: 'sunsuccess.BusinessRuleGridStore',
	title: getExaminationTranslation('LIST_OF_BUSINESS_RULES'),
	border: true,
	refreshStoreData: true,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'businessbulessearchtab': 1
		}
	},
	selModel: {
		mode: 'SINGLE'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: [ 'pagesize' ],
			store: 'sunsuccess.BusinessRuleGridStore',
			emptyMsg: getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		hidden: true,
		menu:[{
			text: getCommonTranslation('Approve'),
			itemId: 'btnApprove',
			hidden: true
		}, {
			text: getExaminationTranslation('APPLY_TO'),
			itemId: 'btnApplyTo',
			hidden: true
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header: getExaminationTranslation('BUSINESS_RULES_ID'),
		dataIndex: 'codeValue',
		sortable: true,
		flex: 1
	}, {
		header: getExaminationTranslation('BUSINESS_RULES_NAME'),
		dataIndex: 'nameValue',
		sortable: true,
		flex: 1
	}, {
		header: getExaminationTranslation('MAPPED_FLAG'),
		dataIndex: 'mappedFlags',
		sortable: true,
		flex: 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value) && value != 0) {
				return '<a href="#">'+value+'</a>';
			}
			else if(!isNullOrEmpty(value) && value == 0) {
				return value;
			}
			else {
				return "-";
			}                     
		}
	}, {
		header: getExaminationTranslation('BUSINESS_RULES_APPROVAL_STATUS'),
		dataIndex: 'approvalStatus',
		sortable: true,
		flex: 1,
		renderer: function(value) {
			if(value) {
				return getCommonTranslation("APROVED");
			}
			return getCommonTranslation("PENDING");
		}
	}, {
		header: getExaminationTranslation('BUSINESS_RULES_STATUS'),
		dataIndex: 'businessRuleStatus',
		sortable: true,
		flex: 1,
		renderer: function(value) {
			if(value) {
				return "Active";
			}
			return "Inactive";
		}
	}]
});