
Ext.define('Academia.view.systemUsage.SystemUsageGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.systemusagegrid',
	store: 'systemusage.UserLoginDetailsStore',
	title : getCommonTranslation('AVERAGE_TIME_USERS'),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'systemusage.UserLoginDetailsStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header : getCommonTranslation('USER_ID'),
		dataIndex : 'userCode',
		flex:1
	},{
		header : getCommonTranslation('NAME'),
		dataIndex : 'userName',
		flex:1
	},{
		header : getCommonTranslation('GROUP_NAME'),
		dataIndex : 'userGroup',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_TIME_SPENT'),
		dataIndex : 'timeSpent',
		flex:1,
		renderer:function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return minuteToTimeRender(value);
			}
			return '0:0';
		}
	},{
		header : getCommonTranslation('AVG_TIME'),
		dataIndex : 'averageTime',
		flex:1,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return minuteToTimeRender(value);
			}
			return '0:0';
		}
	},{
		header : getCommonTranslation('NO_OF_SESSION'),
		dataIndex : 'noOfSession',
		flex:1,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return value;
			}
			return '0';
		}
	},{
		header : getCommonTranslation('NO_OF_AUTOLOGOUT'),
		dataIndex : 'numberAutoLogout',
		flex : 1
		//hidden:true,
		/*renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}*/
	},{
		header : getCommonTranslation('NO_OF_FAILED_LOGIN'),
		dataIndex : 'noOfLoginFailed',
		flex:1,
		sortable:true
		/*renderer:function(){
			return "<a href='#'>View</a>";
		}*/
	}]
});
