/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.taskmanagement.TaskManagementGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.taskmanagementgrid',
	store: 'taskmanagement.TaskManagementStore',
	title: getServiceRequestTranslation('TM_TASKS'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'taskmanagement.TaskManagementStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getServiceRequestTranslation('FD_DATE'),
		dataIndex: 'minuteDate',
		flex: 1,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getServiceRequestTranslation('TM_TASK_TITLE'),
		dataIndex: 'minuteSubject',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('TM_TASK_TAKER'),
		dataIndex: 'minuteTakerName',
		flex: 1,
		sortable: true
	}, {
		header: getServiceRequestTranslation('TM_TOTAL_TASKS'),
		dataIndex: 'totalNoOfMinute',
		flex: 1,
		sortable: true,
		renderer: function(value) {
			return "<span style = 'color:#2b78e4;'>" + value + "</span>";
		}
	}, {
		header: getServiceRequestTranslation('TM_PENDING_TASKS'),
		dataIndex: 'totalNoOfPendingMinute',
		flex: 1,
		sortable: true,
		renderer: function(value) {
			return "<span style = 'color:#cc0000;'>" + value + "</span>";
		}
	}, {
		header: getServiceRequestTranslation('TM_COMPLETED_TASKS'),
		dataIndex: 'totalNoOfCompletedMinute',
		flex: 1,
		sortable: true,
		renderer: function(value) {
			return "<span style = 'color:#009e0f;'>" + value + "</span>";
		}
	}]
});