/**
 * @author sumit.meena
 */
Ext.define('Academia.view.transport.reports.TransportDuesReportFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.transportduesreportfilter',
	autoScroll: false,
	frame: false,
	border:false,
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	defaults: {
		//width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			itemId: 'serviceRoute',
			name: 'serviceRoute',
			fieldLabel: getTransportTranslation('SERVICE_ROUTE'),
			store:'transport.serviceRoute.TransportDuesServiceRouteName',	    
			valueField: 'id',
			displayField: 'value',
			allowBlank: true
		},{
			xtype: 'customcombobox',
			name: 'STUDENT_ID',
			itemId: 'STUDENT_ID',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'transport.reports.TransportDuesStudentDetailsStore',
			valueField: 'userId',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_FILTERS'),
		titleCollapse: true,
		defaults : {
			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
         	 marginTop: '33px!important'
        },
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
		items: [{
            xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            name: 'PROGRAM_ID',
            itemId:'program_transportDcombo',
            //store: 'feeandpayment.ProgramSmartSearchStore',
            store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
            displayField: 'valueCode',
            valueField: 'id',
            //width:226,
            forceSelection:true,
            queryParam:'qry',
    	    minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        },{
			 xtype: 'customcombobox',
			 name: 'BATCH_ID',
			 itemId:'batch_transportDcombo',
			 store:'program.programbatchdetail.BatchByProgramIdSSStore',
			 fieldLabel: getCommonTranslation('BATCH'),
			 valueField: 'id',
			 displayField: 'value'
			 //disabled:true,
		},{
            xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PERIOD'),
            name: 'PERIOD_ID',
            itemId:'period_transportDcombo',
            store: 'program.programbatchdetail.PeriodByBatchIdSSStore',
            displayField: 'value',
            valueField: 'id',
            //width:226,
            hideTrigger:false
            //disabled:true,
        },{
            xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('SECTION'),
            name: 'SECTION_ID',
            itemId:'section_transportDcombo',
            store:'attendance.SectionAndFacultyByPeriodID',
            displayField : 'sectionCode',
			valueField : 'sectionId',
            //width:226,
            hideTrigger:false,
            typeAhead : true,
			disabled:true,
			forceSelection : true
            //disabled:true,
        }
	]}],
	listeners:{
		render: function(myfieldset){
			myfieldset.setMargin('-10px');
		}
	}
	},{
		xtype: 'panel',
		width: '100%',
		style:{marginLeft:'-12px',marginBottom:'-5px'},
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SEARCH'),
			formBind: true,
			itemId: 'searchBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getTransportTranslation('RESET'),
			itemId: 'resetBtn',	
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
