/**
 * @author Deepak Nigam
 */
Ext.define('Academia.view.transport.reports.TransportDuesReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.transportduesreportgrid',
    store: 'transport.reports.TransportDuesReportStore',
    title: getServiceRequestTranslation('TRANSPORT_DUES_REPORT'),
    style: {overflowX: 'auto', overflowY: 'hidden'},
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    features: [{
        ftype: 'summary',
        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    }],
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'transport.reports.TransportDuesReportStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
    tbar: [],
    columns: [{
        header: getPersonModuleTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex: 1,
        sortable: true,
        renderer: function(value, metaData, record, rowIndex, colIndex, view) {
			metaData.style = "white-space: normal;";
			return value;
		},
		/*summaryRenderer: function(value,store, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL('+store.raw.currencyId+')');
	      },*/
	      summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
				var a= store.data.items[0].data.baseCurrencyName;
				return getFeeAndPaymentCommonTranslation('Total (In'+' '+a+')');
		     }
    }, {
        header: getPersonModuleTranslation('STUDENT_ID'),
        dataIndex: 'studentId',
        flex: 1,
        renderer: function(value, metaData, record, rowIndex, colIndex, view) {
			return '<a href="#">'+value+'</a>';
		}
    }, {
        header: getPersonModuleTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: 1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('Program'),
        dataIndex: 'programName',
        flex: 2,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('PERIOD'),
        dataIndex: 'programPeriodName',
        flex: 2,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('SECTION'),
        dataIndex: 'sectionCode',
        flex: 1,
        sortable: true,
        hidden: true
    }, {
        header: getTransportTranslation('SERVICE_ROUTE_NAME'),
        dataIndex: 'serviceRouteName',
        flex: 2,
        sortable: true
    }, {
        header: getFeeAndPaymentCommonTranslation('TRANS_CURRENCY_EXCHANGE_RATE'),
        dataIndex: 'currencyExchangeRate',
        flex: 1,
        sortable: true,
    },{
        header: getFeeAndPaymentCommonTranslation('TOTAL_FEES'),
        dataIndex: 'billableAmount',
        flex: 1,
        sortable: true,
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        /*summaryType: 'sum',
        summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
    }, {
        header: getFeeAndPaymentCommonTranslation('CURRENCY_CONVERTED_FEE'),
        dataIndex: 'currencyConvertedFee',
        flex: 1,
        sortable: true,
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        summaryType: 'sum',
        /*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
        summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
        	if(!isNullOrEmpty(store.data.items[0])){
        		return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
        	}
			},
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.raw.baseCurrencyId);
			}
		},
    },{
        header: getFeeAndPaymentCommonTranslation('TOTAL_PAID'),
        dataIndex: 'adjustedAmount',
        flex: 1,
        sortable: true,
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        /*summaryType: 'sum',
        summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.raw.currencyId);
			}
		}
    },{
        header: getFeeAndPaymentCommonTranslation('CURRENCY_CONVERTED_PAID'),
        dataIndex: 'currencyConvertedPaid',
        flex: 1,
        sortable: true,
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        summaryType: 'sum',
        /*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
        summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
        	if(!isNullOrEmpty(store.data.items[0])){
        		return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
        	}
			},
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.raw.baseCurrencyId);
			}
		}
    },{
        header: getFeeAndPaymentCommonTranslation('DUES'),
        dataIndex: 'balanceAmount',
        flex: 1,
        sortable: true,
        align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
        summaryType: 'sum',
        /*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		},*/
        summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
        	if(!isNullOrEmpty(store.data.items[0])){
        		return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
        	}
        },
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(record.raw.acadLocBaseCurrencyId!=null){
					return currencyRenderer(value,record.raw.baseCurrencyId);
				}else{
					return currencyRenderer(value,record.raw.currencyId);
				}
				
			}
		}
    }]
});