/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.serviceRoute.PeopleCoveredWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.peoplecoveredwindow',
	title: getTransportTranslation('PEOPLE_COVERED'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	layout: {
		type: 'vbox'
	},
	items: [{
		xtype: 'form',
		itemId:'peoplecoveredwindowId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'userType',
				itemId:'userType',
				fieldLabel: getTransportTranslation('USER_TYPE'),
				store: 'transport.vehicle.TransportUserTypeStore',
				valueField: 'id',
			//	value: 3,
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true,
				editable: false
			},{	
				xtype:'textfield',
				name:'userName',
				allowBlank: false,
				hidden:true,
				itemId:'userName',
				fieldLabel: getTransportTranslation('USER')
			},{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('USER'),
				name: 'userId',
				itemId:'userId',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				//store: 'transport.serviceRoute.InternalUser',
				store : 'transport.serviceRoute.ServiceOptaUser',
				valueField: 'id',
				displayField: 'value',
				queryParam:'userName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				hidden:false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('SERVICE_ROUTE_STOP'),
				name: 'transServiceRouteStop',
				itemId:'srviceRouteStop',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store: 'transport.serviceRoute.ServiceRouteStop',
				valueField: 'id',
				displayField: 'value',
				queryParam:'routeStopsName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				allowBlank: false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name:'usageStatus',
				itemId:'usageStatus',
				store:'transport.vehicle.VehicleYesNoEnum',
				fieldLabel: getTransportTranslation('USAGE_STATUS'),
				displayField : 'value',
				valueField : 'id',
				allowBlank: false,
				editable: false
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'addtionEffectiveFrom',
				itemId:'addtionEffectiveFrom',
				allowBlank: false,
				vtype: 'daterange',
    			endDateField: 'removalEffectiveForm',
    			editable:false,
				fieldLabel: getTransportTranslation('ADDITION_EFFECTIVE_FROM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			},{
				xtype: 'datefield',
				name: 'dateAdded',
				itemId:'dateAdded',
				//value:new Date(),
				readOnly:true,
				fieldLabel: getTransportTranslation('DATE_ADDED'),
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
//						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'removalEffectiveForm',
				itemId:'removalEffectiveForm',
				vtype: 'daterange',
    			startDateField: 'addtionEffectiveFrom',
    			editable:false,
				fieldLabel: getTransportTranslation('REMOVAL_EFFECTIVE_FORM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			},{
				xtype: 'datefield',
				name: 'dateRemoved',
				itemId:'dateRemoved',
				readOnly:true,
				//value:new Date(),
				fieldLabel: getTransportTranslation('DATE_REMOVED'),
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
//						obj.setValue(new Date());
					}
				}

			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});