/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.serviceRoute.ServiceRouteDetailForm', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.serviceroutedetailform',
	modal: true,
	autoScroll:true,
	bodyPadding: '10 10 10 10',
	frame:false,
	layout: {
		type: 'vbox'
	},
	defaults: {
		labelAlign: 'top',
		autoScroll:true
	},
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	plugins:"formlabelrequired",
	standardSubmit: false,
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'hidden',
		itemId:'transServiceRouteId',
		name:'transServiceRouteId'
	},{
		xtype:'hidden',
		itemId:'buttonId',
		name:'buttonId'
	},{
		xtype:'hidden',
		itemId:'distanceInKmItemId',
		name:'distanceInKm'
	},/*{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'route',
			itemId:'route',
			store:'transport.route.RouteInfoStore',
			fieldLabel: getTransportTranslation('ROUTE_NAME'),
			displayField : 'routeName',
			valueField : 'id',
			allowBlank: false
		},{
			xtype:'textfield',
			name:'responsiblePersonName',
			itemId:'responsiblePersonName',
			readOnly:true,
			fieldLabel: getTransportTranslation('RESPONSIBLE_PERSON')
		},{
			xtype:'textfield',
			name:'whetherRoundTrip',
			readOnly:true,
			itemId:'whetherRoundTrip',
			fieldLabel: getTransportTranslation('IS_ROUND_TRIP')
		}]
	}*//*{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top',
			xtype:'textfield',
			readOnly:true
		},
		items:[{
			name:'startsFrom',
			itemId:'startsFromItemId',
			fieldLabel: getTransportTranslation('STARTS_FROM')
		},{
			name:'endsAt',
			itemId:'endsAtItemId',
			fieldLabel: getTransportTranslation('ENDS_AT')
		},{
			name:'academyLocationValue',
			itemId:'academyLocationValue',
			fieldLabel: getTransportTranslation('ROOT_ACADEMY_LOCATION')
		},{
			xtype:'hidden',
			name:'startsFromIdItemId',
			itemId:'startsFromIdItemId'
		},{
			xtype:'hidden',
			name:'endsAtIdItemId',
			itemId:'endsAtIdItemId'
		},{
			xtype:'hidden',
			name:'academyLocationId',
			itemId:'academyLocationId'
		}]
	},*/{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype:'hidden',
			name:'academyLocationId',
			itemId:'academyLocationId'
		},{
			xtype:'hidden',
			name:'startsFromIdItemId',
			itemId:'startsFromIdItemId'
		},{
			xtype:'hidden',
			name:'endsAtIdItemId',
			itemId:'endsAtIdItemId'
		},{
			xtype: 'textfield',
			name:'serviceName',
			fieldLabel: getTransportTranslation('SERVICE_ROUTE_NAME'),
			itemId:'serviceName',
			allowBlank: false,
			maxLength:255
		},{
			xtype: 'multiselectcombofield',
			itemId: 'allAcademyLocationId',
			name: 'academyLocations',
			fieldLabel: getTransportTranslation('SERVICE_ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			cls:'multiBrandCampusCls',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			width: 460
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'route',
			itemId:'route',
			store:'transport.route.RouteInfoStore',
			fieldLabel: getTransportTranslation('ROUTE_NAME'),
			displayField : 'routeName',
			valueField : 'id',
			allowBlank: false,
			forceSelection : true

		},{
			xtype: 'customcombobox',
			name:'userType',
			itemId:'userType',
			store:'transport.route.RouteUserTypeStore',
			fieldLabel: getTransportTranslation('USER_TYPE'),
			displayField : 'value',
			valueField : 'id',
			allowBlank: false,
			editable:false,
			forceSelection:true
		},{
			xtype:'textfield',
			name:'serviceResponsiblePersonName',
			itemId:'serviceResponsiblePersonName',
			fieldLabel: getTransportTranslation('SERVICE_RESPONSIBLE_PERSON'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('SERVICE_RESPONSIBLE_PERSON'),
			name: 'responsiblePersonId',
			itemId:'responsiblePersonId',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),			
			store: Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			hidden:true,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype : 'timefield',
			name:'startTime',
			fieldLabel: getTransportTranslation('START_TIME'),
			itemId:'startTime',
			allowBlank: false,
			//format:'g:i A',
			format:CONSTANTS.DISPLAY_TIME_FORMAT,
			vtype: 'timerange',
			endTimeField : 'reachEndLocationAt',
			listeners: {
				renderer: function(time) {        	
					return timeRender(time);
				}
			}
		},{
			xtype : 'timefield',
			name:'reachTime',
			fieldLabel: getTransportTranslation('REACH_END_LOCATION_AT'),
			itemId:'reachEndLocationAt',
			allowBlank: false,
			//format:'g:i A',
			format:CONSTANTS.DISPLAY_TIME_FORMAT,
			vtype: 'timerange',
			startTimeField : 'startTime',
			listeners: {
				renderer: function(time) {        	
					return timeRender(time);
				}
			}
		},{
			xtype: 'customcombobox',
			name:'recordStopListWithTimes',
			itemId:'recordStopListWithTimesId',
			store:'transport.vehicle.VehicleYesNoEnum',
			fieldLabel: getTransportTranslation('RECORD_STOP_LIST_WITH_TIMES'),
			displayField : 'value',
			editable:false,
			valueField : 'id',
			allowBlank: false
		}/*,{
			xtype: 'numberfield',
			name:'distanceInKm',
			fieldLabel: getTransportTranslation('DISTANCE_IN_KMS'),
			itemId:'distanceInKmItemId',
			minValue : 0,
			readOnly:true,
			hideTrigger:true,
			mouseWheelEnabled:false,
			allowBlank: false,
			allowDecimals:false,
			allowExponential:false
		}*/]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype: 'datefield',
			name:'startDate',
			itemId:'startDate',
			vtype: 'daterange',
			allowBlank:false,
			endDateField: 'endDate',
			fieldLabel:getTransportTranslation('SERVICE_ROUTE_APPLICABLE_FROM'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT
		},{
			xtype: 'datefield',
			name:'endDate',
			itemId:'endDate',
			allowBlank:true,
			vtype: 'daterange',
			startDateField: 'startDate',
			fieldLabel:getTransportTranslation('SERVICE_ROUTE_APPLICABLE_TILL'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		//--submitFormat: CONSTANTS.DATE_FORMAT
		},{
			xtype: 'customcombobox',
			name:'isActive',
			store:'transport.vehicle.VehicleYesNoEnum',
			fieldLabel: getTransportTranslation('IS_ACTIVE'),
			displayField : 'value',
			editable:false,
			valueField : 'id',
			allowBlank: false
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items:[{
	        xtype: 'customcombobox',
	        fieldLabel: getTransportTranslation('TRANSPORT_PROVIDER_NAME'),
	        name: 'transportProviderName',
	        itemId:'transportProviderName',
	        store: 'transport.route.TransportProviderStore',
	        displayField: 'value',
	        valueField: 'id',
	        forceSelection:true
	        //columnWidth: 1
	    },{
			xtype: 'multiselectcombofield',
			name: 'runOnDays',
			width:460,
			allowBlank: false,
			maxHeight:200,
			itemId: 'runOnDays',
			autoScroll:true,
			store:'transport.serviceRoute.WeekDays',
			cls:'multiBrandCampusCls',
			displayField: 'value',
			valueField: 'value',
			fieldLabel: getTransportTranslation('RUN_ON_DAYS')
		}]
	}/*{
		xtype:'fieldcontainer',
		itemId:'serviceStopPanelId',
//		itemId:'stopPanelId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			//itemId:'stopContainer',
			itemId:'serviceStopContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype:'hidden',
				name:'routeStopId',
				itemId:'startRouteStopId'
			},{
				xtype : 'customcombobox',
				name : 'location',	
				itemId:'startLocation',
				store: 'transport.route.LocationName',
				displayField: 'locationName',
				width: 226,
				valueField: 'id',		
				editable:false,
				fieldLabel:getTransportTranslation('STOP_LOCATION'),
				allowBlank:false
			},{
				xtype : 'numberfield',
				name : 'distance',	
				itemId:'startDistance',
				width: 226,
				fieldLabel:getTransportTranslation('DISTANCE'),
				value:0,
				minValue : 0,
				hideTrigger:true,
				readOnly:true,
				allowBlank:false
			},{
				xtype : 'timefield',
				name : 'arrivalTime',	
				itemId : 'startArrivalTime',
				fieldLabel:getTransportTranslation('ARRIVAL_TIME'),
//				format:'g:i A',
				allowBlank:false,
				width: 105,
				submitFormat : 'g:i A',
				//vtype: 'timerange',
				//endTimeField : 'departureTime',
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}
			},{
				xtype : 'timefield',
				name : 'departureTime',
				itemId : 'startDepartureTime',
				fieldLabel:getTransportTranslation('DEPARTURE_TIME'),
//				format:'g:i A',
				allowBlank: false,
				submitFormat : 'g:i A',
				width: 125,
				//vtype: 'timerange',
				//startTimeField : 'arrivalTime',
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}
			},{
				xtype:'hidden',
				name:'routeStopType',
				value:getTransportTranslation('START')
			},{
				xtype: 'button',
				itemId: 'stopBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				}
			}]
			}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top'
		},
		items:[{
			xtype:'hidden',
			name:'routeStopId',
			itemId:'endRouteStopId'
		},{
			xtype : 'customcombobox',
			name : 'location',	
			itemId:'endLocation',
			store: 'transport.route.LocationName',
			displayField: 'locationName',
			width: 226,
			editable:false,
			valueField: 'id',		
			allowBlank:false
		},{
			xtype : 'numberfield',
			name : 'distance',
			itemId:'endDistance',
			width: 226,
			minValue : 0,
			hideTrigger:true,
			readOnly:true,
			allowBlank:false
		},{
			xtype : 'timefield',
			name : 'arrivalTime',	
			itemId : 'endArrivalTime',
			format:'g:i A',
			allowBlank: false,
			width: 105,
			submitFormat : 'g:i A'
			//vtype: 'timerange',
			//endTimeField : 'departureTime'
		},{
			xtype : 'timefield',
			name : 'departureTime',
			itemId:'endDepartureTime',
			format:'g:i A',
			allowBlank: false,
			width: 125,
			submitFormat : 'g:i A'
			//vtype: 'timerange',
			//startTimeField : 'arrivalTime'
		},{
			xtype:'hidden',
			name:'routeStopType',
			itemId:'endRouteStopType',
			value:getTransportTranslation('END')
		}]
	}*/,
	{
		xtype:'tabpanel',		
		itemId:'serviceRouteTabpanel',		
		plain: true,
		frame:false,
		autoScroll: false,
		style:{
			'margin-top':'25px',
			'margin-left':'0px',
		},
		activeTab: 0,
		//border:true,
		width: '100%',
		name:'tabPanels',
		items : [{
			xtype: 'container',
			width: '100%',
			title : getTransportTranslation('TO_SCHOOL'),   
			items:[{
				xtype:'fieldcontainer',
				itemId:'serviceStopPanelId',
				items:[{
					xtype : 'fieldcontainer',
					width: '100%',
					//itemId:'stopContainer',
					itemId:'serviceStopContainer',
					layout : 'hbox',
					style:{'margin':'20px'},
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype:'hidden',
						name:'routeStopId',
						itemId:'startRouteStopId'
					},{
						xtype : 'customcombobox',
						name : 'location',	
						itemId:'startLocation',
						store: 'transport.route.LocationName',
						displayField: 'locationName',
						width: 226,
						valueField: 'id',		
						editable:false,
						fieldLabel:getTransportTranslation('STOP_LOCATION'),
						allowBlank:false
					},{
						xtype : 'numberfield',
						name : 'distance',	
						itemId:'startDistance',
						width: 226,
						fieldLabel:getTransportTranslation('DISTANCE'),
						value:0,
						minValue : 0,
						hideTrigger:true,
						readOnly:true,
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'arrivalTime',	
						itemId : 'startArrivalTime',
						fieldLabel:getTransportTranslation('ARRIVAL_TIME'),
//						format:'g:i A',
						//allowBlank:false,
						width: 105,
						submitFormat : 'g:i A',
						//vtype: 'timerange',
						//endTimeField : 'departureTime',
						listeners: {
							render: function(field) {
								return timeFormatRender(field);
							}
						}
					},{
						xtype : 'timefield',
						name : 'departureTime',
						itemId : 'startDepartureTime',
						fieldLabel:getTransportTranslation('DEPARTURE_TIME'),
//						format:'g:i A',
						//allowBlank: false,
						submitFormat : 'g:i A',
						width: 125,
						//vtype: 'timerange',
						//startTimeField : 'arrivalTime',
						listeners: {
							render: function(field) {
								return timeFormatRender(field);
							}
						}
					},{
						xtype:'hidden',
						name:'routeStopType',
						value:getTransportTranslation('START')
					},{
						xtype:'hidden',
						name:'toSchoolStart',
						itemId:'toSchoolStart',
						value:'TO_SCHOOL'
					},{
						xtype: 'button',
						itemId: 'stopBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}]
				},{

					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					style:{'margin':'20px'},
					defaults :{
						labelAlign:'top'
					},
					items:[{
						xtype:'hidden',
						name:'routeStopId',
						itemId:'endRouteStopId'
					},{
						xtype : 'customcombobox',
						name : 'location',	
						itemId:'endLocation',
						store: 'transport.route.LocationName',
						displayField: 'locationName',
						width: 226,
						editable:false,
						valueField: 'id',		
						allowBlank:false
					},{
						xtype : 'numberfield',
						name : 'distance',
						itemId:'endDistance',
						width: 226,
						minValue : 0,
						hideTrigger:true,
						//readOnly:true,
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'arrivalTime',	
						itemId : 'endArrivalTime',
						format:'g:i A',
						allowBlank: false,
						width: 105,
						submitFormat : 'g:i A'
							//vtype: 'timerange',
							//endTimeField : 'departureTime'
					},{
						xtype : 'timefield',
						name : 'departureTime',
						itemId:'endDepartureTime',
						format:'g:i A',
						//allowBlank: false,
						width: 125,
						submitFormat : 'g:i A'
							//vtype: 'timerange',
							//startTimeField : 'arrivalTime'
					},{
						xtype:'hidden',
						name:'routeStopType',
						itemId:'endRouteStopType',
						value:getTransportTranslation('END')
					},{
						xtype:'hidden',
						name:'toSchoolEnd',
						itemId:'toSchoolEnd',
						value:'TO_SCHOOL'
					}]

				}]
			}]

		}, {

			xtype: 'container',
			width: '100%',
			title : getTransportTranslation('FROM_SCHOOL'),   
			items:[{
				xtype:'fieldcontainer',
				itemId:'fromSchlServiceStopPanelId',
				items:[{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					style:{'margin':'20px'},
					defaults :{
						labelAlign:'top'
					},
					items:[{
						xtype:'hidden',
						name:'fromSchlEndRouteStopId',
						itemId:'fromSchlEndRouteStopId'
					},{
						xtype : 'customcombobox',
						name : 'fromSchlLocation',	
						itemId:'fromSchlEndLocation',
						store: 'transport.route.LocationName',
						displayField: 'locationName',
						width: 226,
						editable:false,
						valueField: 'id',		
						//allowBlank:false,
						fieldLabel:getTransportTranslation('STOP_LOCATION'),
					},{
						xtype : 'numberfield',
						name : 'fromSchlEndDistance',
						itemId:'fromSchlEndDistance',
						width: 226,
						minValue : 0,
						value:0,
						hideTrigger:true,
						fieldLabel:getTransportTranslation('DISTANCE'),
						readOnly:true,
						//allowBlank:false
					},{
						xtype : 'timefield',
						name : 'fromSchlArrivalTime',	
						itemId : 'fromSchlEndArrivalTime',
						format:'g:i A',
						//allowBlank: false,
						width: 105,
						submitFormat : 'g:i A',
						fieldLabel:getTransportTranslation('ARRIVAL_TIME'),
							//vtype: 'timerange',
							//endTimeField : 'departureTime'
					},{
						xtype : 'timefield',
						name : 'fromSchlDepartureTime',
						itemId:'fromSchlEndDepartureTime',
						format:'g:i A',
						fieldLabel:getTransportTranslation('DEPARTURE_TIME'),
						//allowBlank: false,
						width: 125,
						submitFormat : 'g:i A'
							//vtype: 'timerange',
							//startTimeField : 'arrivalTime'
					},{
						xtype:'hidden',
						name:'fromSchlEndRouteStopType',
						itemId:'fromSchlEndRouteStopType',
						value:getTransportTranslation('END')
					},{
						xtype:'hidden',
						name:'fromSchoolEnd',
						itemId:'fromSchoolEnd',
						value:'FROM_SCHOOL'
					},{
						xtype: 'button',
						itemId: 'fromSchlStopBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}]
				},{
					xtype : 'fieldcontainer',
					width: '100%',
					//itemId:'stopContainer',
					itemId:'fromSchlServiceStopContainer',
					layout : 'hbox',
					style:{'margin':'20px'},
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype:'hidden',
						name:'fromSchlStartRouteStopId',
						itemId:'fromSchlStartRouteStopId'
					},{
						xtype : 'customcombobox',
						name : 'fromSchlLocation',	
						itemId:'fromSchlStartLocation',
						store: 'transport.route.LocationName',
						displayField: 'locationName',
						width: 226,
						valueField: 'id',		
						editable:false
						//fieldLabel:getTransportTranslation('STOP_LOCATION'),
					},{
						xtype : 'numberfield',
						name : 'fromSchlStartDistance',	
						itemId:'fromSchlStartDistance',
						width: 226,
						//fieldLabel:getTransportTranslation('DISTANCE'),
						//value:0,
						minValue : 0,
						hideTrigger:true,
						//readOnly:true,
					},{
						xtype : 'timefield',
						name : 'fromSchlArrivalTime',	
						itemId : 'fromSchlStartArrivalTime',
						//fieldLabel:getTransportTranslation('ARRIVAL_TIME'),
//						format:'g:i A',
						width: 105,
						submitFormat : 'g:i A',
						//vtype: 'timerange',
						//endTimeField : 'departureTime',
						listeners: {
							render: function(field) {
								return timeFormatRender(field);
							}
						}
					},{
						xtype : 'timefield',
						name : 'fromSchlDepartureTime',
						itemId : 'fromSchlStartDepartureTime',
						//fieldLabel:getTransportTranslation('DEPARTURE_TIME'),
//						format:'g:i A',
						submitFormat : 'g:i A',
						width: 125,
						//vtype: 'timerange',
						//startTimeField : 'arrivalTime',
						listeners: {
							render: function(field) {
								return timeFormatRender(field);
							}
						}
					},{
						xtype:'hidden',
						name:'fromSchlRouteStopType',
						value:getTransportTranslation('START')
					},{
						xtype:'hidden',
						name:'fromSchoolStart',
						itemId:'fromSchoolStart',
						value:'FROM_SCHOOL'
					}/*{
						xtype: 'button',
						itemId: 'fromSchlStopBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}*/]
				}]
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			action : 'Submit',
			text: getCommonTranslation('SAVE'),
			itemId: 'btnSave',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'btnReset',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
