/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.vehicle.RoadTaxHistoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.roadtaxhistorydetailwin',
	title: getTransportTranslation('ROAD_TAX_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'roadtaxhistorydetailwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'roadTaxVendor',
				itemId:'roadTaxVendor',
				fieldLabel: getTransportTranslation('ROAD_TAX_AUTHORITY'),
				maxLength:100,
				enforceMaxLength : true,
			},{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('ROAD_TAX_DOCUMENT_WITH'),
				name: 'roadTaxWith',
				itemId:'roadTaxWith',
				maxLength:100,
				enforceMaxLength : true,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'validFrom',
				itemId:'validFrom',
				endDateField: 'validTill',
				maxValue: new Date(),
				allowBlank : false,
				fieldLabel: getTransportTranslation('ROAD_TAX_VALID_FROM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					select: function(field, value, e) {
						e.blur(field);
					},
					blur: function(field) {
						var roadTaxValidFrom = field;
						var roadTaxValidTill = field.up().down('#validTill').getValue();
						var currentDate = new Date();
						currentDate.setHours(0);
						currentDate.setMinutes(0);
						currentDate.setSeconds(0);
						if (!isNullOrEmpty(roadTaxValidTill)) {
							if (roadTaxValidTill >= currentDate) {
								roadTaxValidFrom.setMaxValue(currentDate);
							} else {
								roadTaxValidFrom.setMaxValue(roadTaxValidTill);
							}
						} else {
							roadTaxValidFrom.setMaxValue(currentDate);
						}
					}
				},
				vtype: 'daterange',
			},{
				xtype: 'datefield',
				name: 'validTill',
				itemId:'validTill',
				allowBlank : false,
				fieldLabel: getTransportTranslation('ROAD_TAX_VALID_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					blur: function(field) {
						var roadTaxValidFrom = field.up().down('#validFrom');
						var roadTaxValidTill = field.getValue();
						var currentDate = new Date();
						currentDate.setHours(0);
						currentDate.setMinutes(0);
						currentDate.setSeconds(0);
						if (!isNullOrEmpty(roadTaxValidTill)) {
							if (roadTaxValidTill >= currentDate) {
								roadTaxValidFrom.setMaxValue(currentDate);
							} else {
								roadTaxValidFrom.setMaxValue(roadTaxValidTill);
							}
						} else {
							roadTaxValidFrom.setMaxValue(currentDate);
						}
					}
				},
				startDateField: 'validFrom',
				vtype: 'daterange'
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'roadTaxCurrency',
				itemId:'roadTaxCurrency',
				fieldLabel: getTransportTranslation('ROAD_TAX_CURRENCY'),
				store: 'organization.BaseCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'numberfield',
				name: 'roadTaxCost',
				itemId:'roadTaxCost',
				fieldLabel: getTransportTranslation('ROAD_TAX_COST'),
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowDecimals:false,
				allowExponential:false,
				minValue:0,
				maxLength: 8
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'roadTaxPaidOn',
				itemId:'roadTaxPaidOn',
				fieldLabel: getTransportTranslation('ROAD_TAX_PAID_ON'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});