/**
 * @author Ankur.Jaiswal
 */
Ext.define('Academia.view.transport.vehicle.VehicleLicenceRegistrationDocumentGridWin', {
	extend: 'Ext.window.Window',
	alias : 'widget.vehiclelicenceregistrationdocumentgridwin',
	border: true,
	modal : true,
	title: getProgramandcourseTranslation('DOWNLOAD_DOCUMENT'),
	autoScroll: true,
	maxHeight: 350,
	width: '40%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	items:[{
		xtype: 'form',
		plugins:"formlabelrequired",
		items: [{
			xtype: 'grid',
			itemId:'vehiclelicenceregistrationdocumentgridwinId',
			border:true,
			store : 'transport.vehicle.LicenceRegistrationDocumentStore',
			tbar: [{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),
				iconCls: 'icon-Delete',
				cls:'iconDelete'		
			}],
			columns :[{
				header : getCommonTranslation('DOCMENT_NAME'),
				dataIndex : 'documentName',
				flex:1,
				renderer:function(value,rec){
					if(!isNullOrEmpty(value)){
						return '<a href="#">'+value+'</a>';
					}
				}
			}]
		}]
	}],
	listeners: {
		afterlayout: function() {
			var height = Ext.getBody().getViewSize().height;
			if (this.getHeight() > height) {
				this.setHeight(height);
			}
			this.center();
		}
	}
});


