/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.transport.vehicle.VehicleList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.vehiclelist',
	store : 'transport.vehicle.VehicleGridData',
	title: getTransportTranslation('VEHICLE_LIST'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'vehiclestructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.VehicleGridData',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		hidden:true,
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	}/*,{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}*/,{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getTransportTranslation('LICENCE_HISTORY'),
			itemId:'licenceHistoryLink'
		},{
			text:getTransportTranslation('INSURANCE_HISTORY'),
			itemId:'insuranceHistoryLink'
		},{
			text:getTransportTranslation('EMISSION_HISTORY'),
			itemId:'emissionHistoryLink'
		},{
			text:getTransportTranslation('ROAD_TAX_HISTORY'),
			itemId:'roadTaxHistoryLink'
		},{
			text:getTransportTranslation('FUEL_CONSUMPTION'),
			itemId:'fuelConsumptionLink'
		},{
			text:getPersonModuleTranslation('SERVICE_HISTORY'),
			itemId:'serviceHistoryLink'
		},{
			text:getTransportTranslation('JOURNEY_ASSIGNMENT'),
			itemId:'journeyAssignmentLink'
		},{
			text:getTransportTranslation('FITNESS_CERTIFICATE'),
			itemId:'fitnessCertificateLink'
		},{
			text:getTransportTranslation('VEHICLE_PERMIT'),
			itemId:'vehiclePermit'
		},{
			text:getTransportTranslation('VIEW_VEHICLE_LOCATION_STATUS'),
			itemId:'viewVehicleLocationStatusLink'
		}],
		listeners: { click: function() { this.showMenu(); }}
	}],
	columns: [{
		header : getTransportTranslation('VEHICLE_CODE'),
		dataIndex : 'resourceCode',
		flex:1
	},{
		header : getTransportTranslation('VEHICLE_NO'),
		dataIndex : 'vehicleNumber',
		flex:1
	},{
		header : getTransportTranslation('VEHICLE_TYPE'),
		dataIndex : 'vehicleSubTypeName',
		flex:1
	},{
		header : getTransportTranslation('CAPACITY'),
		dataIndex : 'capacity',
		flex:1
	},{
		header : getTransportTranslation('LICENCE_DATE_OF_EXPIRY'),
		dataIndex : 'expiryDateOfLicense',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('INSURANCE_TILL'),
		dataIndex : 'insuranceTill',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('ROAD_TAX_TILL'),
		dataIndex : 'roadTaxTill',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('EMISSION_CHECK_DATE'),   //​Emission Check Valid Till
		dataIndex : 'emissionCheckDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('NO_OF_SERVICE_ROUTES'),
		dataIndex : 'numberOfServiceRoutes',
		flex:1
	},{
		header : getTransportTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value=='ACTIVE'){
					return getCommonTranslation('ACTIVE');
				}else{
					return getCommonTranslation('INACTIVE');
				}
			}
		}
	}]
});