/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.transport.vehicleType.VehicleTypeFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.vehicletypeformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('VEHICLE_TYPE'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'vehicleTypeFormItemId',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'hidVehicleTypeId',
            name: 'id'
        },   {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('VEHICLE_TYPE_CODE'),
                xtype: 'textfield',
                itemId: 'codeItemId',
                name: 'code',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('VEHICLE_TYPE'),
                xtype: 'textfield',
                itemId: 'itemValueItemId',
                name: 'value',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'btnSaveVehicleTypeForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelVehicleTypeForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
