/*
CryptoJS v3.1.2
code.google.com/p/crypto-js
(c) 2009-2013 by Jeff Mott. All rights reserved.
code.google.com/p/crypto-js/wiki/License
*/
var CryptoJS = CryptoJS || function(q, r) {
  var k = {}, g = k.lib = {}, p = function() {
  }, t = g.Base = {extend:function(b) {
    p.prototype = this;
    var j = new p;
    b && j.mixIn(b);
    j.hasOwnProperty("init") || (j.init = function() {
      j.$super.init.apply(this, arguments)
    });
    j.init.prototype = j;
    j.$super = this;
    return j
  }, create:function() {
    var b = this.extend();
    b.init.apply(b, arguments);
    return b
  }, init:function() {
  }, mixIn:function(b) {
    for(var j in b) {
      b.hasOwnProperty(j) && (this[j] = b[j])
    }
    b.hasOwnProperty("toString") && (this.toString = b.toString)
  }, clone:function() {
    return this.init.prototype.extend(this)
  }}, n = g.WordArray = t.extend({init:function(b, j) {
    b = this.words = b || [];
    this.sigBytes = j != r ? j : 4 * b.length
  }, toString:function(b) {
    return(b || u).stringify(this)
  }, concat:function(b) {
    var j = this.words, a = b.words, l = this.sigBytes;
    b = b.sigBytes;
    this.clamp();
    if(l % 4) {
      for(var h = 0;h < b;h++) {
        j[l + h >>> 2] |= (a[h >>> 2] >>> 24 - 8 * (h % 4) & 255) << 24 - 8 * ((l + h) % 4)
      }
    }else {
      if(65535 < a.length) {
        for(h = 0;h < b;h += 4) {
          j[l + h >>> 2] = a[h >>> 2]
        }
      }else {
        j.push.apply(j, a)
      }
    }
    this.sigBytes += b;
    return this
  }, clamp:function() {
    var b = this.words, j = this.sigBytes;
    b[j >>> 2] &= 4294967295 << 32 - 8 * (j % 4);
    b.length = q.ceil(j / 4)
  }, clone:function() {
    var b = t.clone.call(this);
    b.words = this.words.slice(0);
    return b
  }, random:function(b) {
    for(var j = [], a = 0;a < b;a += 4) {
      j.push(4294967296 * q.random() | 0)
    }
    return new n.init(j, b)
  }}), v = k.enc = {}, u = v.Hex = {stringify:function(b) {
    var a = b.words;
    b = b.sigBytes;
    for(var h = [], l = 0;l < b;l++) {
      var m = a[l >>> 2] >>> 24 - 8 * (l % 4) & 255;
      h.push((m >>> 4).toString(16));
      h.push((m & 15).toString(16))
    }
    return h.join("")
  }, parse:function(b) {
    for(var a = b.length, h = [], l = 0;l < a;l += 2) {
      h[l >>> 3] |= parseInt(b.substr(l, 2), 16) << 24 - 4 * (l % 8)
    }
    return new n.init(h, a / 2)
  }}, a = v.Latin1 = {stringify:function(b) {
    var a = b.words;
    b = b.sigBytes;
    for(var h = [], l = 0;l < b;l++) {
      h.push(String.fromCharCode(a[l >>> 2] >>> 24 - 8 * (l % 4) & 255))
    }
    return h.join("")
  }, parse:function(b) {
    for(var a = b.length, h = [], l = 0;l < a;l++) {
      h[l >>> 2] |= (b.charCodeAt(l) & 255) << 24 - 8 * (l % 4)
    }
    return new n.init(h, a)
  }}, s = v.Utf8 = {stringify:function(b) {
    try {
      return decodeURIComponent(escape(a.stringify(b)))
    }catch(h) {
      throw Error("Malformed UTF-8 data");
    }
  }, parse:function(b) {
    return a.parse(unescape(encodeURIComponent(b)))
  }}, h = g.BufferedBlockAlgorithm = t.extend({reset:function() {
    this._data = new n.init;
    this._nDataBytes = 0
  }, _append:function(b) {
    "string" == typeof b && (b = s.parse(b));
    this._data.concat(b);
    this._nDataBytes += b.sigBytes
  }, _process:function(b) {
    var a = this._data, h = a.words, l = a.sigBytes, m = this.blockSize, k = l / (4 * m), k = b ? q.ceil(k) : q.max((k | 0) - this._minBufferSize, 0);
    b = k * m;
    l = q.min(4 * b, l);
    if(b) {
      for(var g = 0;g < b;g += m) {
        this._doProcessBlock(h, g)
      }
      g = h.splice(0, b);
      a.sigBytes -= l
    }
    return new n.init(g, l)
  }, clone:function() {
    var b = t.clone.call(this);
    b._data = this._data.clone();
    return b
  }, _minBufferSize:0});
  g.Hasher = h.extend({cfg:t.extend(), init:function(b) {
    this.cfg = this.cfg.extend(b);
    this.reset()
  }, reset:function() {
    h.reset.call(this);
    this._doReset()
  }, update:function(b) {
    this._append(b);
    this._process();
    return this
  }, finalize:function(b) {
    b && this._append(b);
    return this._doFinalize()
  }, blockSize:16, _createHelper:function(b) {
    return function(a, h) {
      return(new b.init(h)).finalize(a)
    }
  }, _createHmacHelper:function(b) {
    return function(a, h) {
      return(new m.HMAC.init(b, h)).finalize(a)
    }
  }});
  var m = k.algo = {};
  return k
}(Math);

(function (Math) {
    // Shortcuts
    var C = CryptoJS;
    var C_lib = C.lib;
    var WordArray = C_lib.WordArray;
    var Hasher = C_lib.Hasher;
    var C_algo = C.algo;

    // Constants table
    var T = [];

    // Compute constants
    (function () {
        for (var i = 0; i < 64; i++) {
            T[i] = (Math.abs(Math.sin(i + 1)) * 0x100000000) | 0;
        }
    }());

    /**
     * MD5 hash algorithm.
     */
    var MD5 = C_algo.MD5 = Hasher.extend({
        _doReset: function () {
            this._hash = new WordArray.init([
                0x67452301, 0xefcdab89,
                0x98badcfe, 0x10325476
            ]);
        },

        _doProcessBlock: function (M, offset) {
            // Swap endian
            for (var i = 0; i < 16; i++) {
                // Shortcuts
                var offset_i = offset + i;
                var M_offset_i = M[offset_i];

                M[offset_i] = (
                    (((M_offset_i << 8)  | (M_offset_i >>> 24)) & 0x00ff00ff) |
                    (((M_offset_i << 24) | (M_offset_i >>> 8))  & 0xff00ff00)
                );
            }

            // Shortcuts
            var H = this._hash.words;

            var M_offset_0  = M[offset + 0];
            var M_offset_1  = M[offset + 1];
            var M_offset_2  = M[offset + 2];
            var M_offset_3  = M[offset + 3];
            var M_offset_4  = M[offset + 4];
            var M_offset_5  = M[offset + 5];
            var M_offset_6  = M[offset + 6];
            var M_offset_7  = M[offset + 7];
            var M_offset_8  = M[offset + 8];
            var M_offset_9  = M[offset + 9];
            var M_offset_10 = M[offset + 10];
            var M_offset_11 = M[offset + 11];
            var M_offset_12 = M[offset + 12];
            var M_offset_13 = M[offset + 13];
            var M_offset_14 = M[offset + 14];
            var M_offset_15 = M[offset + 15];

            // Working varialbes
            var a = H[0];
            var b = H[1];
            var c = H[2];
            var d = H[3];

            // Computation
            a = FF(a, b, c, d, M_offset_0,  7,  T[0]);
            d = FF(d, a, b, c, M_offset_1,  12, T[1]);
            c = FF(c, d, a, b, M_offset_2,  17, T[2]);
            b = FF(b, c, d, a, M_offset_3,  22, T[3]);
            a = FF(a, b, c, d, M_offset_4,  7,  T[4]);
            d = FF(d, a, b, c, M_offset_5,  12, T[5]);
            c = FF(c, d, a, b, M_offset_6,  17, T[6]);
            b = FF(b, c, d, a, M_offset_7,  22, T[7]);
            a = FF(a, b, c, d, M_offset_8,  7,  T[8]);
            d = FF(d, a, b, c, M_offset_9,  12, T[9]);
            c = FF(c, d, a, b, M_offset_10, 17, T[10]);
            b = FF(b, c, d, a, M_offset_11, 22, T[11]);
            a = FF(a, b, c, d, M_offset_12, 7,  T[12]);
            d = FF(d, a, b, c, M_offset_13, 12, T[13]);
            c = FF(c, d, a, b, M_offset_14, 17, T[14]);
            b = FF(b, c, d, a, M_offset_15, 22, T[15]);

            a = GG(a, b, c, d, M_offset_1,  5,  T[16]);
            d = GG(d, a, b, c, M_offset_6,  9,  T[17]);
            c = GG(c, d, a, b, M_offset_11, 14, T[18]);
            b = GG(b, c, d, a, M_offset_0,  20, T[19]);
            a = GG(a, b, c, d, M_offset_5,  5,  T[20]);
            d = GG(d, a, b, c, M_offset_10, 9,  T[21]);
            c = GG(c, d, a, b, M_offset_15, 14, T[22]);
            b = GG(b, c, d, a, M_offset_4,  20, T[23]);
            a = GG(a, b, c, d, M_offset_9,  5,  T[24]);
            d = GG(d, a, b, c, M_offset_14, 9,  T[25]);
            c = GG(c, d, a, b, M_offset_3,  14, T[26]);
            b = GG(b, c, d, a, M_offset_8,  20, T[27]);
            a = GG(a, b, c, d, M_offset_13, 5,  T[28]);
            d = GG(d, a, b, c, M_offset_2,  9,  T[29]);
            c = GG(c, d, a, b, M_offset_7,  14, T[30]);
            b = GG(b, c, d, a, M_offset_12, 20, T[31]);

            a = HH(a, b, c, d, M_offset_5,  4,  T[32]);
            d = HH(d, a, b, c, M_offset_8,  11, T[33]);
            c = HH(c, d, a, b, M_offset_11, 16, T[34]);
            b = HH(b, c, d, a, M_offset_14, 23, T[35]);
            a = HH(a, b, c, d, M_offset_1,  4,  T[36]);
            d = HH(d, a, b, c, M_offset_4,  11, T[37]);
            c = HH(c, d, a, b, M_offset_7,  16, T[38]);
            b = HH(b, c, d, a, M_offset_10, 23, T[39]);
            a = HH(a, b, c, d, M_offset_13, 4,  T[40]);
            d = HH(d, a, b, c, M_offset_0,  11, T[41]);
            c = HH(c, d, a, b, M_offset_3,  16, T[42]);
            b = HH(b, c, d, a, M_offset_6,  23, T[43]);
            a = HH(a, b, c, d, M_offset_9,  4,  T[44]);
            d = HH(d, a, b, c, M_offset_12, 11, T[45]);
            c = HH(c, d, a, b, M_offset_15, 16, T[46]);
            b = HH(b, c, d, a, M_offset_2,  23, T[47]);

            a = II(a, b, c, d, M_offset_0,  6,  T[48]);
            d = II(d, a, b, c, M_offset_7,  10, T[49]);
            c = II(c, d, a, b, M_offset_14, 15, T[50]);
            b = II(b, c, d, a, M_offset_5,  21, T[51]);
            a = II(a, b, c, d, M_offset_12, 6,  T[52]);
            d = II(d, a, b, c, M_offset_3,  10, T[53]);
            c = II(c, d, a, b, M_offset_10, 15, T[54]);
            b = II(b, c, d, a, M_offset_1,  21, T[55]);
            a = II(a, b, c, d, M_offset_8,  6,  T[56]);
            d = II(d, a, b, c, M_offset_15, 10, T[57]);
            c = II(c, d, a, b, M_offset_6,  15, T[58]);
            b = II(b, c, d, a, M_offset_13, 21, T[59]);
            a = II(a, b, c, d, M_offset_4,  6,  T[60]);
            d = II(d, a, b, c, M_offset_11, 10, T[61]);
            c = II(c, d, a, b, M_offset_2,  15, T[62]);
            b = II(b, c, d, a, M_offset_9,  21, T[63]);

            // Intermediate hash value
            H[0] = (H[0] + a) | 0;
            H[1] = (H[1] + b) | 0;
            H[2] = (H[2] + c) | 0;
            H[3] = (H[3] + d) | 0;
        },

        _doFinalize: function () {
            // Shortcuts
            var data = this._data;
            var dataWords = data.words;

            var nBitsTotal = this._nDataBytes * 8;
            var nBitsLeft = data.sigBytes * 8;

            // Add padding
            dataWords[nBitsLeft >>> 5] |= 0x80 << (24 - nBitsLeft % 32);

            var nBitsTotalH = Math.floor(nBitsTotal / 0x100000000);
            var nBitsTotalL = nBitsTotal;
            dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 15] = (
                (((nBitsTotalH << 8)  | (nBitsTotalH >>> 24)) & 0x00ff00ff) |
                (((nBitsTotalH << 24) | (nBitsTotalH >>> 8))  & 0xff00ff00)
            );
            dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 14] = (
                (((nBitsTotalL << 8)  | (nBitsTotalL >>> 24)) & 0x00ff00ff) |
                (((nBitsTotalL << 24) | (nBitsTotalL >>> 8))  & 0xff00ff00)
            );

            data.sigBytes = (dataWords.length + 1) * 4;

            // Hash final blocks
            this._process();

            // Shortcuts
            var hash = this._hash;
            var H = hash.words;

            // Swap endian
            for (var i = 0; i < 4; i++) {
                // Shortcut
                var H_i = H[i];

                H[i] = (((H_i << 8)  | (H_i >>> 24)) & 0x00ff00ff) |
                       (((H_i << 24) | (H_i >>> 8))  & 0xff00ff00);
            }

            // Return final computed hash
            return hash;
        },

        clone: function () {
            var clone = Hasher.clone.call(this);
            clone._hash = this._hash.clone();

            return clone;
        }
    });

    function FF(a, b, c, d, x, s, t) {
        var n = a + ((b & c) | (~b & d)) + x + t;
        return ((n << s) | (n >>> (32 - s))) + b;
    }

    function GG(a, b, c, d, x, s, t) {
        var n = a + ((b & d) | (c & ~d)) + x + t;
        return ((n << s) | (n >>> (32 - s))) + b;
    }

    function HH(a, b, c, d, x, s, t) {
        var n = a + (b ^ c ^ d) + x + t;
        return ((n << s) | (n >>> (32 - s))) + b;
    }

    function II(a, b, c, d, x, s, t) {
        var n = a + (c ^ (b | ~d)) + x + t;
        return ((n << s) | (n >>> (32 - s))) + b;
    }

    /**
     * Shortcut function to the hasher's object interface.
     *
     * @param {WordArray|string} message The message to hash.
     *
     * @return {WordArray} The hash.
     *
     * @static
     *
     * @example
     *
     *     var hash = CryptoJS.MD5('message');
     *     var hash = CryptoJS.MD5(wordArray);
     */
    C.MD5 = Hasher._createHelper(MD5);

    /**
     * Shortcut function to the HMAC's object interface.
     *
     * @param {WordArray|string} message The message to hash.
     * @param {WordArray|string} key The secret key.
     *
     * @return {WordArray} The HMAC.
     *
     * @static
     *
     * @example
     *
     *     var hmac = CryptoJS.HmacMD5(message, key);
     */
    C.HmacMD5 = Hasher._createHmacHelper(MD5);
}(Math));
