<?php
header('Access-Control-Allow-Origin: *');
$fileName = generateRandomFileName();
$returnArray = array();

// Sanitize and validate inputs
$language = 'default';
if (isset($_POST['language'])) {
    $language = filter_var($_POST['language'], FILTER_SANITIZE_STRING);
}

if(!empty($fileName)){
    //--- START --- read & write current index.html
		$fileContents=file_get_contents('index.html');
		
		$fileContentsArray = explode("\n", $fileContents);
		
		$newFileContents = '';
		
		$stringToFind = '--translations';
		$stringFound = 0;
		
		
		for($line=0;$line<count($fileContentsArray);$line++){
			if ((strpos($fileContentsArray[$line], $stringToFind) > 0) && $stringFound==0) {
				$stringFound = 1;
				$fileContentsArray[$line] = '"--'.$fileName.'",';
			}
			if($line==0){
				$newFileContents = $fileContentsArray[$line];
			}
			else{
				$newFileContents = $newFileContents."\n".$fileContentsArray[$line];
			}
		}
		
		file_put_contents('index.html',$newFileContents);
    //--- END --- read & write current index.html
	
    if($language!="default"){
        $uploadedFileName = $language."_".$fileName;
    }else {
    	$uploadedFileName = $fileName;
	}
	
	
	// Validate file upload
    if ($_FILES["file"]["error"] !== UPLOAD_ERR_OK) {
        $returnArray = array("success" => false, "message" => "File upload error.");
        echo json_encode($returnArray);
        exit;
    }
	
    $maxFileSize = 5 * 1024 * 1024;
    if ($_FILES["file"]["size"] > $maxFileSize) {
        $returnArray = array("success" => false, "message" => "Invalid file size.");
        echo json_encode($returnArray);
        exit;
    }


    if (move_uploaded_file($_FILES["file"]["tmp_name"], $uploadedFileName)) {
        $returnArray = array(
            "success" => true
        );
        
        //---rename all language files
        $fileNameString = $fileName;
        //exit;
        $languages = 'default';
        if(isset($_POST['languages'])){
            $languages = $_POST['languages'];
        }
        $languagesArray = explode(',',$languages);
        
        function scan_dir($dir) {
            $ignored = array('.', '..', '.svn', '.htaccess');
            
            $files = array();
            foreach (scandir($dir) as $file) {
                if (in_array($file, $ignored)) continue;
                $files[$file] = filemtime($dir . '/' . $file);
            }
            
            arsort($files);
            $files = array_keys($files);
            
            return ($files) ? $files : false;
        }
        
        $dir    = './';
        $dirFiles = scan_dir($dir);
		
        $languageFileArray = array();
        foreach ($languagesArray as $key=>$currentLanguageName) {
            if($currentLanguageName=="default"){
                $currentLanguageNameNew = "";
            }
            else{
                $currentLanguageNameNew = $currentLanguageName."_";
            }
            $currentLanguageFileName = $currentLanguageNameNew."translation";
            foreach ($dirFiles as $currentDirFile) {
				if (pathinfo($currentDirFile, PATHINFO_EXTENSION) !== "js") {
					continue;
				}
                if($currentLanguageNameNew != "" && strpos($currentDirFile, $currentLanguageFileName) !== false){
                    $languageFileArray[$currentLanguageName]=$currentDirFile;
                    break;
				}elseif(strpos($currentDirFile, $currentLanguageFileName) === 0){
                    $languageFileArray[$currentLanguageName]=$currentDirFile;
                    break;
	            }elseif(strpos($currentDirFile, $currentLanguageFileName) === 0){	
					$languageFileArray[$currentLanguageName]=$currentDirFile;	
	                break;			
				}
            }
        }
		
		
        foreach($languageFileArray as $languageKey => $languageFileName){
            if($languageKey=="default"){
                $newName = $fileNameString;
            }
            else{
                $newName = $languageKey."_".$fileNameString;
            }
            rename($languageFileName,$newName);
        }
    } else {
        $returnArray = array(
            "success" => false
        );
    }
}
else{
    $returnArray = array(
        "success" => false
    ); 
}

function generateRandomFileName($prefix = 'translations') {
    // Generate a random string of 10 characters
    $randomString = bin2hex(random_bytes(5)); // 5 bytes = 10 characters

    // Construct the file name with the provided prefix and random string
    $fileName = $prefix . '_' . $randomString . '.js';

    return $fileName;
}
echo json_encode($returnArray);
?>