/*
    This file is generated and updated by Sencha Cmd. You can edit this file as
    needed for your application, but these edits will have to be merged by
    Sencha Cmd when upgrading.
 */
Ext.Loader.setConfig({
	enabled: true,
	disableCaching: false,
	paths: {
		'Ext.calendar': 'app/utilities/calendar'
	}
});
Ext.application({
	name: 'Academia', // application name that becomes the namespace
	extend: 'Academia.Application',
	init: function(){
		Academia.enumStore = {};
		Academia.dataStore = {};
	},
	autoCreateViewport: false, //// automatically refer Viewport.js
	controllers: ['Academia.controller.menu.CoreERPNavigationController',
		'Academia.controller.base.BaseController',
		'Academia.controller.authentication.AuthenticationController',
		'Academia.controller.dashboard.DashboardController',
		'Academia.controller.criteriabuilder.CriteriaBuilderController',
		'Academia.controller.criteriabuilder.SavedAdvanceSearchCriteriaController',
		'Academia.controller.datasetting.IdGeneratorController',
		'Academia.controller.webcam.ImageCaptureController',
		'Academia.controller.personinfo.common.PersonCommonController',
		'Academia.controller.portal.StudentPortalController',
		'Academia.controller.portal.FacultyPortalController',
		'Academia.controller.portal.ApplicantPortalController',
		'Academia.controller.portal.ParentPortalController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseMasterController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentEnrollmentDetailTabController',
		'Academia.controller.coursetransaction.studentcourseenrollment.courseGroup.StudentCourseGroupController',
		'Academia.controller.attendance.LeaveReportController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController',
		'Academia.controller.portal.MasterScheduleController',
		'Academia.controller.personinfo.student.StudentCourseExecutionController',
		'Academia.controller.personinfo.common.PersonCourseExecutionController',
		'Academia.controller.feeandpayment.FeeAndPaymentController',
		'Academia.controller.personinfo.faculty.FacultyCourseExecutionController',
		'Academia.controller.portal.StudentAttendanceReportController',
		'Academia.controller.admission.admissionCycle.AdmissionCycleController',
		'Academia.controller.admission.selectionStage.SelectionStageController',
		'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
		'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
		//'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.AppProgMainGridToolBarButtonConfiguration',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentController',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentListController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.MasterTimeTableController',
		'Academia.controller.examinationcenters.manageEvaluation.ManageEvalResultSearchController',
		'Academia.controller.coursetransaction.homework.HomeworkSubmissionController',
		'Academia.controller.coursetransaction.homework.HomeworkAssignmentController',
		'Academia.controller.coursetransaction.homework.HomeworkEvaluationController',
		'Academia.controller.program.SpecializationEnollmentController',
		'Academia.controller.coursetransaction.studentperiodenrollment.StudentPeriodRegistrationController',
		'Academia.controller.program.sessionReport.SessionReportController',
		'Academia.controller.personinfo.student.StudentPersonalController',
		'Academia.controller.personinfo.common.PersonInfoController',
		'Academia.controller.organization.AddressController',
		'Academia.controller.personinfo.student.StudentListController',
		'Academia.controller.examinationcenters.ExaminationCentersController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.applicationdetail.ApplicationDetailController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentSubmitController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAlllocationController',
		'Academia.controller.examinationcenters.roomallocation.RoomAllocationController',
		'Academia.controller.examinationcenters.evaluationresult.EvaluationResultController',
		'Academia.controller.personinfo.student.StudentExaminationDocumentsController',
		'Academia.controller.examinationcenters.studentportal.revaluation.RevaluationSPController',
		'Academia.controller.examinationcenters.studentportal.SPStudentAssessmentReportController',
		'Academia.controller.examinationcenters.studentresultreport.StudentResultReportController',
		'Academia.controller.personinfo.common.PersonPaymentRefundController',
		'Academia.controller.personinfo.student.StudentPaymentRefundController',
		'Academia.controller.personinfo.faculty.FacultyPaymentRefundController',
		'Academia.controller.scholarship.ScholarshipMasterController',
		'Academia.controller.feeandpayment.feerequest.StudentPortalFeeRequestController',
		'Academia.controller.feeandpayment.FeeAndPaymentReportController',
		'Academia.controller.placement.placementcampus.PlacementCampusController',
		'Academia.controller.placement.placementjobapplication.PlacementJobApplicationController',
		'Academia.controller.servicerequest.ServiceRequestController',
		'Academia.controller.servicerequest.ServiceRequestBaseController',
		'Academia.controller.reports.complaints.ComplaintsDashboardReportController',
		'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
		'Academia.controller.personinfo.student.StudentComplaintController',
		'Academia.controller.attendance.FacultyAttendanceController',
		'Academia.controller.attendance.AttendanceMasterController',
		'Academia.controller.admission.applications.applicantService.ApplicantServiceController',
		'Academia.controller.personinfo.common.PersonServiceController',
		'Academia.controller.personinfo.student.StudentServiceController',
		'Academia.controller.personinfo.faculty.FacultyServiceController',
		'Academia.controller.personinfo.common.PersonPastHistoryController',
		'Academia.controller.personinfo.student.StudentPastHistoryController',
		'Academia.controller.personinfo.faculty.FacultyPastHistoryController',
		'Academia.controller.committee.committee.StudentCommitteeController',
		'Academia.controller.personinfo.faculty.FacultyPersonalController',
		'Academia.controller.personinfo.faculty.FacultyListController',
		'Academia.controller.personinfo.student.StudentKYSController',
		'Academia.controller.personinfo.student.StudentDocumentController',
		'Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController',
		'Academia.controller.servicerequest.infirmarymanage.InfirmaryManageController',
		'Academia.controller.personinfo.student.StudentDisciplinaryController',
		'Academia.controller.personinfo.common.PersonDisciplinaryController',
		'Academia.controller.personinfo.faculty.FacultyDisciplinaryController',
		'Academia.controller.sgappointment.sgappointment.SGStudentAppointmentController',
		'Academia.controller.facilitiesresources.managegallery.ManageGalleryController',
		'Academia.controller.personinfo.dashlet.PersonInfoDashboardController',
		'Academia.controller.feeandpayment.payment.PaymentController',
		'Academia.controller.feeandpayment.AccountStatementReportController',
		'Academia.controller.fdmanagement.FDManagementController',
		'Academia.controller.servicerequest.PersonalDataChangeRequestController',
		'Academia.controller.examinationdegreeremark.ExaminationDegreeRemarkController',
		'Academia.controller.DMSController.DMSCommonController',
		'Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController',
		'Academia.controller.scholarship.ScholarshipListingController',
	    'Academia.controller.hostel.manageallocation.ManageAllocationController',
		'Academia.controller.examinationcenters.thesisManagement.studentThesisManagementController',
        'Academia.controller.election.election.ElectionController',
        'Academia.controller.personinfo.student.StudentManageHoldController',
        'Academia.controller.powerBI.AnalyticsCommonController',
        'Academia.controller.personinfo.student.StudentJourneyController',
        'Academia.controller.examinationtimetable.ExamTimetableController'
	],
	views: [
		'common.StatusCombo','common.StatusCombos',
		'Academia.view.baselayout.contentarea.ContentPanel',
		'Academia.view.CustomAlerts',
		// from base controller
		'reports.admission.admsnDataNullReport',
		'common.LiveSearchCombo',
		'Academia.view.common.AcadLocProgBatchSeattypeComponent',
		'common.NestedTextField',
		'common.IdGeneratorCustomForm',
		'common.DynamicFieldForm',
		'common.DynamicFieldFormWin',
		'common.IdGeneratorCustomFormWin',
		'common.IdGeneratorFormWin',
		'common.AddressDetailPanel',
		'common.CustomFieldForm',
		'messaging.sendmessage.SendMessageWindow',
		// form CoreERPNavigationController
		'Academia.view.organization.OrganizationStructure',
        'Academia.utilities.ux.CustomTopPagingToolBar'
	],
	stores: [
		'common.StatusComboStore',
		'common.LiveSearchCombos',
		'Academia.store.common.AcademyStore',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.LocationStore',
		'Academia.store.common.ProgramsByAcademyIdLocationId',
		'Academia.store.common.BatchesByProgramId',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.Checklist',
		'Academia.store.common.DocumentTypeStore',
		'common.ActiveUserStore',
		'Academia.store.messaging.MessageTemplate'
	],
    models:[
    	'customfields.CustomFieldDataModel',
    	'singleton.Organization',
    	'menu.MegaMenuDataModel',
    	'Academia.model.common.OrgSettingDateTimeModel'
    ],
	requires:[
		'Academia.constants.CurrencyFormatConstants',
		'Academia.utilities.CommonUtil',
		'Academia.utilities.vTypeValidations.Validation',
		'Academia.utilities.ErrorHandler',
		'Academia.utilities.plugins.AsteriskPlugin',
		'Academia.utilities.CustomAlerts',
		'Academia.utilities.JsonAjaxRequest',
		'Academia.utilities.ImageActionColumn',
		'Academia.utilities.accessControl.AccessControlManager',
		'Academia.utilities.accessControl.FeaturePrivilegeManager',
		// from base controller
		'Academia.utilities.plugins.TreeFilter',
		'Academia.utilities.ckEditor.CkEditor',
		'Academia.utilities.gridExporter',
		'Academia.utilities.DisplayFormatMap',
		'Academia.utilities.CurrencyFormatMap',
		'Academia.utilities.plugins.SessionMonitor',
		'Academia.utilities.currency.CurrencyManager',
		'Academia.utilities.date.DateHelper',
		'Academia.utilities.ux.PageSize', 
		'Academia.utilities.ux.CustomPagingToolBar',
		'Academia.utilities.ux.AutoGroupedColumn',
		'Academia.utilities.ux.GroupingComboBox',
		'Academia.utilities.ux.CustomCheckboxField',
		'Academia.utilities.reader.CacheRest',
		'Academia.utilities.reader.CustomArrayReader',
        'Academia.config.Runtime',
        'Academia.utilities.AllOverrides',
	],
	launch :function(){
		Ext.app.autoCallAPIs = true;
		//--- code for separating tabs ---//
		setTabId();

		initGoogleAnalytics();
		var getParams = document.URL.split("?");
		var params = Ext.urlDecode(getParams[getParams.length - 1]);
		localStorage.setItem('userHash','');
		if(params["userHash"])
		{
			localStorage.setItem('userHash',params["userHash"]);
			window.history.pushState("", "", getParams[0]);
		}
		/**
		 * @ravi.patidar login check and reload app
		 */
		
		if (typeof localStorage.getItem('tokenApiResponse') != "string"){
			var tokenApiResponse = localStorage.getItem('tokenApiResponse');
			var academylocationid = localStorage.getItem('academylocationid');
			var wheatherSchool = localStorage.getItem('wheatherSchool');
		}else{
			var tokenApiResponse = JSON.parse(localStorage.getItem('tokenApiResponse'));
    	    var academylocationid = JSON.parse(localStorage.getItem('academylocationid'));
    	    var wheatherSchool = JSON.parse(localStorage.getItem('wheatherSchool'));
		}
		
		if(isNullOrEmpty(localStorage.getItem('maxLength'))){
			localStorage.setItem('maxLength',160);
		}
		if(!isNullOrEmpty(localStorage.getItem('defaultPage'))){
			var defaultPage = localStorage.getItem('defaultPage');
			setTimeout(function(){
				try{
					var defaultPageSplitted = defaultPage.split('-');
					this$.openTab(getMegaMenuTranslation(defaultPageSplitted[0]), defaultPageSplitted[1] );
					localStorage.setItem('defaultPage','');
				}
				catch(e){
					localStorage.setItem('defaultPage','');
				}
			},5000);
		}
		if(!isNullOrEmpty(tokenApiResponse) && !isNullOrEmpty(tokenApiResponse.Authorization) && !isNullOrEmpty(academylocationid)){
			Ext.Ajax.defaultHeaders = {
					Authorization: "Bearer " + tokenApiResponse.access_token,
					expires_in: tokenApiResponse.expires_in,
					access_token: tokenApiResponse.access_token,
					refresh_token: tokenApiResponse.refresh_token
			};
			var userInfo = Academia.model.authentication.UserInfoModel;

			userInfo.set("accessToken", tokenApiResponse.access_token);
			userInfo.set("refreshToken", tokenApiResponse.refresh_token);
			userInfo.set("expiryTimeForAccessToken", tokenApiResponse.expires_in);

			Academia.app.getController('Academia.controller.authentication.AuthenticationController').loginAccessLoadMainPanel();
			/*setTimeout(function(){
				Academia.app.getController('Academia.controller.authentication.AuthenticationController').loadDataAfterLogin(); 
			},2000);*/
			loadApisFunction();
		}
		var style = document.createElement('style');
		style.type = 'text/css';
		var fullWidth = window.innerWidth;
		//style.innerHTML = '.x-grid .x-header-text { margin-left: 494px !important; } .x-grid .x-header-text-container { left: 0 !important; }';4
		style.innerHTML = '.x-grid .x-header-text-container { width: '+fullWidth+'px !important;left: -245px !important; } .x-grid .x-header-text { margin-left: 110px !important; }';
		document.getElementsByTagName('head')[0].appendChild(style);
		var style2 = document.createElement('style');
        style2.type = 'text/css';
        style2.innerHTML='.centerAlignTitle.x-grid .x-header-text-container { width: inherit !important;;left: unset!important; text-align: left !important; }';
        document.getElementsByTagName('head')[0].appendChild(style2);
        var style3 = document.createElement('style');
        style3.type = 'text/css';
        style3.innerHTML='.parallelGridCenterAlignTitle.x-grid .x-header-text { margin-left: 145px !important; }';
        document.getElementsByTagName('head')[0].appendChild(style3);
        
        //var mainSearchBoxPos = (window.innerWidth - 540) / 2;
        //var style4 = document.createElement('style');
        //style4.type = 'text/css';
        //style4.innerHTML='.searchComboBoxPosCls { left: '+mainSearchBoxPos+'px !important; }';
        //document.getElementsByTagName('head')[0].appendChild(style4);
        
        var style5 = document.createElement('style');
        style5.type = 'text/css';
        style5.innerHTML='.centerAlignTitle.x-grid .x-header-text-container .x-header-text { margin-left: 0 !important; left: 0px !important;letter-spacing: 0px;font: var(--title-regular-font-style);color: var(--text-icon-color-primary); }';
        document.getElementsByTagName('head')[0].appendChild(style5);
        
		window.addEventListener('keydown', function(e) {
    		if(e.keyCode == 32 && e.target == document.body) {
    	    	e.preventDefault();
    	  	}
    	});
		
		if(sessionStorage.getItem(window.name+'_registrationPortalToken') || sessionStorage.getItem('registrationPortalToken') || sessionStorage.registrationPortalToken){
			sessionStorage.removeItem(window.name+'_registrationPortalToken');
			sessionStorage.removeItem('registrationPortalToken');
		}
	},
	runAction:function(controllerName, actionName){
		var controller = this.getController(controllerName);
	},
	ctrls: []                              
});

Ext.Msg.on('show', function (msg) {
    msg.maxWidth=900;
    msg.setWidth(400);
    msg.center();
});