/*
 																																																* @author prathamesh.sheth
 * 
 * This controller is used for Admission Details and Mid-Term Admission Details tab.
 *    
 */
Ext.define('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController', {

	mixins: {
 		AdmissionFormCommonController: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
 		ApplicationBaseController:'Academia.controller.admission.applications.applicationBase.ApplicationBaseController'
	},
 
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

    alias: "widget.admissionandmidtermadmissioncontroller",

    models: [
    				'admission.applications.applicantProfileBase.ApplicationProgramGridModel', 
    				'admission.applications.admissionAndMidTermAdmission.MidTermAdmissionCourseModel',
    				'admission.applicationFormSale.ExistingStudentDetailModel'
    			  ],

    stores: [
    				'admission.applications.admissionAndMidTermAdmission.AdmissionProgramGridStore', 
    				'admission.applications.admissionAndMidTermAdmission.TypeOfAdmissionComboStore', 
    				'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
    				'admission.applications.admissionAndMidTermAdmission.MidTermAdmMainCourseGridStore', 
    				'admission.applications.admissionAndMidTermAdmission.MidTermStatusComboStore', 
    				'admission.applications.admissionAndMidTermAdmission.MidTermAdmOtherCourseGridStore',
    				'admission.applicationFormSale.ProgramGroupComboStore',
    				'admission.applicationFormSale.ActiveProgramGroupComboStore',
    				'common.UsersComboStore','admission.applicationFormSale.AddProgramGridStore',
    				'common.YesNoClientSideComboStore','common.ActiveUserStore',
    				'coursetransaction.sectionmanagement.SectionsStore',
    				'user.UserAcademyLocationStore','program.ProgramGroupStore','program.ProgramByGroupIdStore',
    				'program.programbatchdetail.BatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
    				'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore',
    				'admission.admissionCommon.ProvisionalAdmissionReasonStore','program.ProgramGroupByProgramIdStore',
    				'admission.applicationFormSale.ExistingStudentGridStore'
    			],

    views: [
    				'admission.applications.admissionAndMidTermAdmission.MidTermAdmission',
    				'admission.applications.admissionAndMidTermAdmission.MidTermMainCoursesGrid', 
    				'admission.applications.admissionAndMidTermAdmission.MidTermOtherCoursesGrid', 
    				'admission.applications.admissionAndMidTermAdmission.OtherCourseFormWindow', 
    				'admission.applications.admissionAndMidTermAdmission.AdmissionProgramGrid', 
    				'admission.applications.admissionAndMidTermAdmission.ConfirmOrDenyAdmissionWindow', 
    				'admission.applications.admissionAndMidTermAdmission.ConfirmOrWithdrawAdmissionWindow', 
    				'admission.applications.admissionAndMidTermAdmission.AddAdmissionProgramWindow',
    				'admission.applications.admissionAndMidTermAdmission.ViewAdmissionDetailsForm',
    				'admission.applications.admissionAndMidTermAdmission.AddDirectAdmissionProgramWindow',
    				'admission.applications.admissionAndMidTermAdmission.EditAdmissionProgramWindow',
    				'admission.applications.admissionAndMidTermAdmission.AddExistingStudentToAdmissionWindow',
    				'admission.applicationFormSale.ExistingStudentDetailGrid'
    			],

    refs: [
    /**************Mid-Term Admission Tab ********************/
    {
        ref: 'midTermOtherCoursesGrid',
        selector: 'midtermothercoursesgrid'
    }, {
        ref: 'otherCoursesFormWindow',
        selector: 'othercoursesformwindow[itemId=applicantOtherCoursesFormWindow]'
    }, {
        ref: 'otherCoursesWindowForm',
        selector: 'othercoursesformwindow form[itemId=othercoursesForm]'
    },

    /**************Admission Details Tab ********************/
    {
        ref: 'admissionProgramGrid',
        selector: 'admissionprogramgrid[itemId=admissionDetailGrid]'
    }, {
        ref: 'confirmDenyAdmissionWindow',
        selector: 'confirmordenyadmissionwindow[itemId=applicantConfirmDenyAdmission]'
    }, {
        ref: 'confirmWithdrawAdmissionWindow',
        selector: 'confirmorwithdrawadmissionwindow[itemId=applicantConfirmWithdrawAdmission]'
    }, {
        ref: 'addAdmissionProgramWindow',
        selector: 'addadmissionprogramwindow[itemId=addAdmissionProgramWindow]'
    },{
    	ref: 'viewAdmissionDetailsForm',
    	selector: 'viewadmissiondetailsform'
    },{
    	ref: 'adddirectadmissionprogramwindow',
    	selector: 'adddirectadmissionprogramwindow'
    }, {
        ref: 'editAdmissionProgramWindow',
        selector: 'editadmissionprogramwindow[itemId=editAdmissionProgramWindow]'
    }, {
        ref: 'addexistingstudenttoadmissionwindow',
        selector: 'addexistingstudenttoadmissionwindow[itemId=addexistingstudenttoadmissionwindow]'
    },{
    	 ref: 'existingstudentdetailgrid',
         selector: 'existingstudentdetailgrid'
    }],
    
    config: {
    	APPLICATIONS_ADMISSION_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_ADMISSION_DETAILS_PRIVILEGES'),
    	APPLICATIONS_MIDTERM_ADMISSION_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_MIDTERM_ADMISSION_DETAILS_PRIVILEGES'),
    	AC_APPLICATION_ADMISSION_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('AC_APPLICATION_ADMISSION_DETAILS_PRIVILEGES'),
    	ADMISSION_DETAILS_ADD_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_DETAILS_ADD_PROGRAM_PRIVILEGES'),
    	ADMISSION_DETAILS_EDIT_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_DETAILS_EDIT_PROGRAM_PRIVILEGES')

    },
    init: function(application) {

        this.CONFIRMED = 'CONFIRMED';
        this.DENIED = 'DENIED';
        this.WITHDRAWN = 'WITHDRAWN';

        this.control({
        
            /**************Mid-Term Admission Tab ********************/
        	'midtermadmission grid[itemId=applicantMidTermMainCoursesGrd]': {
                render: function(grid) {
                	this.doAccessControlValidation(grid, this.getAPPLICATIONS_MIDTERM_ADMISSION_DETAILS_PERMISSIONS());
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {                    	
                    	try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = me.getContentPanel().items.items[0];
                    	}
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode']||
                        		((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
                             ){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(grid);
                        	}
                    		me.loadMidTermCoursesByApplicationId();                    		                   		                    		
                    	}
                    }                    
                }
            },
            
            'midtermadmission[itemId=applicantMidTermAdmissionDetails]': {
                render: function(form) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode']){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(form,"midtermadmission[itemId=applicantMidTermAdmissionDetails]>fieldcontainer>button",applicantProfile);
                        	}                    		                    		
                    	}
                    }                    
                }
            },
            'midtermadmission[itemId=applicantMidTermAdmissionDetails] button[itemId=saveApplicationDetails]': {
                click: function() {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){                    		
                       		me.saveMidTermCourses();                        	                    		                    		
                    	}
                    }                    
                }
            },
            'adddirectadmissionprogramwindow combo[itemId=typeOfAdmission]': {
 			   select : function(obj,record){
 				   var $this=this;
 				   var typeOfAdmission = obj.getValue();
 				   var adddirectadmissionprogramwindow=$this.getAdddirectadmissionprogramwindow();
 				   var trialAdmissionContainer=adddirectadmissionprogramwindow.down('#trialAdmissionContainer');
 				   var trialStartDate= trialAdmissionContainer.down('#trialStartDate');
 				   var trialEndDate= trialAdmissionContainer.down('#trialEndDate');
 				   
 				   var provisionalAdmissionPanel=adddirectadmissionprogramwindow.down('#provisionalAdmissionPanel');
 				   var provisionalLastDate=provisionalAdmissionPanel.down('#provisionalLastDate');
 				   var provisionalAdmissionClosureReason=provisionalAdmissionPanel.down('#provisionalAdmissionClosureReason');
 				   
 				   if(typeOfAdmission.toLowerCase()===getAdmissionTranslation('TRIAL').toLowerCase())
 				   {
 					  trialAdmissionContainer.setVisible(true);
 					  provisionalAdmissionPanel.setVisible(false);
 					  trialStartDate.allowBlank = false;
 					  trialEndDate.allowBlank = false;
 					  provisionalLastDate.allowBlank = true;
 					  provisionalAdmissionClosureReason.allowBlank = true;
 				   }
 				   else if(typeOfAdmission.toLowerCase()===getAdmissionTranslation('PROVISIONAL').toLowerCase())
 				   {
 					 provisionalAdmissionPanel.setVisible(true);
 					 trialAdmissionContainer.setVisible(false);
 					 trialStartDate.allowBlank = true;
 					 trialEndDate.allowBlank = true;
 					 provisionalLastDate.allowBlank = false;
					 provisionalAdmissionClosureReason.allowBlank = false;
 					 
 				   }else if(typeOfAdmission.toLowerCase()===getAdmissionTranslation('CONFIRMED').toLowerCase()){
 					 provisionalAdmissionPanel.setVisible(false);
 					 trialAdmissionContainer.setVisible(false); 
 					 trialStartDate.allowBlank = true;
 					 trialEndDate.allowBlank = true;
 					 provisionalLastDate.allowBlank = true;
					 provisionalAdmissionClosureReason.allowBlank = true;
 				   }
 				   var form = adddirectadmissionprogramwindow.down('form');
 				   form.getForm().checkValidity();
 			   }
 		   },  
            'midtermadmission grid[itemId=applicantMidTermOtherCoursesGrd]': {
                render: function(grid) {
                	this.doAccessControlValidation(grid, this.getAPPLICATIONS_MIDTERM_ADMISSION_DETAILS_PERMISSIONS());
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = me.getContentPanel().items.items[0];
                    	}
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode'] ||
                        		((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                                 (applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                                 (applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                                 (applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
                               ){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(grid);
                        	}
                    		grid.getStore().load({
                                params: {
                                    applicationId: applicantProfile.getApplicationId()
                                }
                            });
                    		
                    		grid.getStore().on('beforeload', function(store, operation) {
                				if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                					store.proxy.extraParams = {
                							applicationId: applicantProfile.getApplicationId()
                                    };	
                				}                                                                        
                            });
                    	}
                    }                       
                }
            },
            'midtermadmission grid[itemId=applicantMidTermOtherCoursesGrd] button[itemId=btnAdd]': {
                click: function() {
                    this.addOthercourses();
                }
            },
            'midtermadmission grid[itemId=applicantMidTermOtherCoursesGrd] button[itemId=btnEdit]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var applicantMidTermOtherCoursesGrd = applicantProfile.down('#applicantMidTermOtherCoursesGrd');
                        me.editOthercourses(applicantMidTermOtherCoursesGrd, false);
                    }
                }
            },
            'midtermadmission grid[itemId=applicantMidTermOtherCoursesGrd] button[itemId=btnView]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var applicantMidTermOtherCoursesGrd = applicantProfile.down('#applicantMidTermOtherCoursesGrd');
                        me.editOthercourses(applicantMidTermOtherCoursesGrd, true);
                    }
                }
            },
            'midtermadmission grid[itemId=applicantMidTermOtherCoursesGrd] button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var applicantMidTermOtherCoursesGrd = applicantProfile.down('#applicantMidTermOtherCoursesGrd');
                        me.deleteOthercourses(applicantMidTermOtherCoursesGrd);
                    }
                }
            },
            'othercoursesformwindow button[itemId=btnSaveOtherCoursesForm]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var applicantMidTermOtherCoursesGrd = applicantProfile.down('#applicantMidTermOtherCoursesGrd');
                        var otherCoursesFormWindow = me.getOtherCoursesFormWindow();
                        me.saveOtherCoursesForm(applicantMidTermOtherCoursesGrd, otherCoursesFormWindow);
                    }
                }
            },
            'othercoursesformwindow button[itemId=btnCancelOtherCoursesForm]': {
                click: function() {
                    this.getOtherCoursesFormWindow().close();
                }
            },

            /**************Admission Details Tab ********************/
            'admissionprogramgrid[itemId=admissionDetailGrid]': {
                render: function(grid) {
                    var portalId = this.getCurrentLoggedPortalId();
                    if(portalId==6){
                    	this.disableMoreActionPivileges(grid, this.getAC_APPLICATION_ADMISSION_DETAILS_PERMISSIONS());
                    }else{
                    	this.disableMoreActionPivileges(grid, this.getAPPLICATIONS_ADMISSION_DETAILS_PERMISSIONS());
                    }
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    try{
                		applicantProfile.getApplicationId();
                	} catch(e){
                		applicantProfile = me.getContentPanel().items.items[0];
                	}
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode']){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(grid);
                        	}
                    		grid.getStore().getProxy().extraParams = {
                                applicationId: applicantProfile.getApplicationId()
                            }
                    		grid.getStore().load({
                                callback: function(records, operation, success) {
                                	var midTermAdmission = applicantProfile.getApplicationInfo()['applicationStatus'];
                                	if((applicantProfile.getApplicationInfo()['applicationStatus']==='MID_TERM_ADMISSION') ||
                                	   (applicantProfile.getApplicationInfo()['applicationStatus']==='DIRECT_ADMISSION')){
                                		if(records.length>0){
                                			if(midTermAdmission=='MID_TERM_ADMISSION'){
                                				grid.down('#btnAddPrograms').setDisabled(true);
                                			}else{
                                			for(var i=0; i< records.length; i++){
                                				var admissionStatusType =records[i].data.status;
                                			if(!(admissionStatusType === 'ADMISSION_IN_PROGRESS')){
                                				grid.down('#btnAddPrograms').setDisabled(false);
                                			}else{
                                				grid.down('#btnAddPrograms').setDisabled(true);
                                			}
                                			}
                                		}
                                		}else{
                                            grid.down('#btnAddPrograms').setDisabled(false);
                                        }
                                	}
                                }
                            });
                    	}
                    	//this.disableMoreActionPivileges(grid, this.getAPPLICATIONS_ADMISSION_DETAILS_PERMISSIONS());
                    }                     
                    
                },
                afterrender:function(grid){
            		var me = this;
            		me.addDataGridConfigButton(grid,me.getAPPLICATIONS_ADMISSION_DETAILS_PERMISSIONS());
            	},
                select: function(grid, record, index, eOpts) {
                    var me = this;                                
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	var admissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
                    	var confirmOrWithdrawTrialAdmissionBtn=admissionProgramGrid.down('#btnConfrimOrWithdraw');
                    	var getEditButton=admissionProgramGrid.down('#btnEdit');
	                    if (confirmOrWithdrawTrialAdmissionBtn) {                    	
	                    	if (!isEmpty(record.data) && !isNullOrEmpty(record.get('admissionType'))) {                            
	                            var admissionType = record.get('admissionType');
	                            var status = record.get('status');
	                            if(status === 'ADMISSION_IN_PROGRESS')
	                            {
	                            	getEditButton.setDisabled(false);
	                            }else
	                            {
	                            	getEditButton.setDisabled(true);
	                            }
	                            if(admissionType.toLowerCase()===getAdmissionTranslation('CONFIRMED').toLowerCase()){
	                            	confirmOrWithdrawTrialAdmissionBtn.setDisabled(true);
	                            }else if(admissionType.toLowerCase()===getAdmissionTranslation('TRIAL').toLowerCase() && status === 'ADMITTED_ON_TRIAL_BASIS'){
	                            	confirmOrWithdrawTrialAdmissionBtn.setDisabled(false);
	                            }else if(admissionType.toLowerCase()===getAdmissionTranslation('PROVISIONAL').toLowerCase() && status === 'ADMITTED_PROVISIONALLY'){
	                            	confirmOrWithdrawTrialAdmissionBtn.setDisabled(false);
	                            }                                                      
	                        }
	                    }
                    }    
                }
            },
            'admissionprogramgrid[itemId=admissionDetailGrid] button[itemId=btnView]': {
                click: function(button) {
                    var grid = button.up('grid');
                    if (grid.getSelectionModel().getCount() > 0) {
                        var window = this.getViewAdmissionDetailsForm();
                        if (!window) {
                            window = Ext.widget('viewadmissiondetailsform', {
                                itemId: 'viewadmissiondetailsformId'
                            });
                        }
                       window.show();
                       var me = this;
                	   var applicantProfile = me.getContentPanelActiveTab();
                	   try{
                   		applicantProfile.getApplicationId();
                   	   } catch(e){
                   		applicantProfile = me.getContentPanel().items.items[0];
                   	   }
                	   var applicationId = applicantProfile.getApplicationId();
                	   Ext.Ajax.request({
                           type: 'rest',
                           method: 'GET',
                           url: SERVERURL.APPLICATIONS_ADMISSION_GRID_DATA + '?applicationId=' + applicationId,
                           headers: {
                               'Content-Type': 'application/json'
                           },
                           success: function(form, action) {
                        	   var data = Ext.decode(form.responseText);
                        	   me.setAdmissionDetailsValue(window,data);
                           }
                       });
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                    }
                }
            },
            'admissionprogramgrid[itemId=admissionDetailGrid] button[itemId=btnAddPrograms]': {
                click: function() {
                	this.admissionProgramDataAdd();
                }
            },
            'admissionprogramgrid[itemId=admissionDetailGrid] button[itemId=btnEdit]': {
                click: function() {
                	this.admissionProgramDataUpdate();
                }
            },
//            'admissionprogramgrid[itemId=admissionDetailGrid] button[itemId=btnConfirmOrDeny]': {
//                click: function() {
//                    var me = this;
//                    var applicantProfile = me.getContentPanelActiveTab();
//                    if (applicantProfile) {
//                        var selectedAdmissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
//                        if (selectedAdmissionProgramGrid.getSelectionModel().getCount() > 0) {
//                            
//                        } else {
//                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
//                        }
//                    }
//                }
//            },
            'admissionprogramgrid[itemId=admissionDetailGrid] button[itemId=btnConfrimOrWithdraw]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var selectedAdmissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
                        if (selectedAdmissionProgramGrid.getSelectionModel().getCount() > 0) {
                        	var record = selectedAdmissionProgramGrid.getSelectionModel().getSelection()[0];
                        	if(record.data.admissionType === 'TRIAL'){
                        		  var confirmWithdrawAdmissionWindow = this.getConfirmWithdrawAdmissionWindow();
                                  if (!confirmWithdrawAdmissionWindow) {
                                      confirmWithdrawAdmissionWindow = Ext.widget('confirmorwithdrawadmissionwindow', {
                                          itemId: 'applicantConfirmWithdrawAdmission'
                                      });
                                  }
                                  confirmWithdrawAdmissionWindow.show();
                        	}else if (record.data.admissionType === 'PROVISIONAL') {
                        		var confirmDenyAdmissionWindow = this.getConfirmDenyAdmissionWindow();
                                if (!confirmDenyAdmissionWindow) {
                                    confirmDenyAdmissionWindow = Ext.widget('confirmordenyadmissionwindow', {
                                        itemId: 'applicantConfirmDenyAdmission'
                                    });
                                }
                                confirmDenyAdmissionWindow.show();
                        	}
                          
                        } else {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                        }
                    }
                }
            },
            'confirmordenyadmissionwindow[itemId=applicantConfirmDenyAdmission]': {
            	render:function(window){
            		var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode']){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(window);
                        	}
                    	}
                    }
            	}
            },
            'confirmordenyadmissionwindow[itemId=applicantConfirmDenyAdmission]  button[itemId=btnSaveConfirmOrDenyAdmissionForm]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var selectedAdmissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
                        var admissionClosureWindow = me.getConfirmDenyAdmissionWindow();
                        var admissionClosureForm = admissionClosureWindow.down('#confirmordenyadmissionForm');
                        me.updateAdmissionClosureStatus(selectedAdmissionProgramGrid, admissionClosureWindow, admissionClosureForm, getAdmissionTranslation('PROVISIONAL_ADMISSION_CLOSURE'), getAdmissionTranslation('ADMISSION_CLOSURE_MSG'));
                    }
                }
            },
            'confirmordenyadmissionwindow[itemId=applicantConfirmDenyAdmission]  button[itemId=btnCancelConfirmOrDenyAdmissionForm]': {
                click: function() {
                    this.getConfirmDenyAdmissionWindow().close();
                }
            },
            'confirmorwithdrawadmissionwindow[itemId=applicantConfirmWithdrawAdmission]  button[itemId=btnSaveConfirmOrWithdrawAdmForm]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var selectedAdmissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
                        var admissionClosureWindow = me.getConfirmWithdrawAdmissionWindow();
                        var admissionClosureForm = admissionClosureWindow.down('#confirmorwithdrawadmissionForm');
                        me.updateAdmissionClosureStatus(selectedAdmissionProgramGrid, admissionClosureWindow, admissionClosureForm, getAdmissionTranslation('TRIAL_ADMISSION_CLOSURE'), getAdmissionTranslation('ADMISSION_CLOSURE_MSG'));
                    }
                }
            },
            'confirmorwithdrawadmissionwindow[itemId=applicantConfirmWithdrawAdmission]  button[itemId=btnCancelConfirmOrWithdrawAdmForm]': {
                click: function() {
                    this.getConfirmWithdrawAdmissionWindow().close();
                }
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow]  button[itemId=addAdmissionBtn]': {
            	click: function(btn) {
            		if(!preventMultipleCalls(btn)){
                		return false;
                	}
            		var me = this;
            		var portalId = me.getCurrentLoggedPortalId();
            		if(portalId==6){
            			var applicantProfile = me.getContentPanel().items.items[0];
            		}else
            		{
            			var applicantProfile = me.getContentPanelActiveTab();
            		}

            		if (applicantProfile) {
            			if(portalId==6){
            				var admissionDetailGrid = me.getAdmissionProgramGrid();
            			}else
            			{
            				var admissionDetailGrid = applicantProfile.down('#admissionDetailGrid');
            			}
            			
            			var addAdmissionProgramWindow = me.getAddAdmissionProgramWindow();
            			if (addAdmissionProgramWindow && admissionDetailGrid) {
            				var applicantAdmissionDetailsForm = addAdmissionProgramWindow.down('#applicantAddAdmissionForm');
            				var applicantAdmissionProgramGrid = addAdmissionProgramWindow.down('#applicantAdmissionAddApplicationProgramGrid');                            
            				var applicationId=applicantProfile.getApplicationId();
            				var applicationInfoObject=applicantProfile.getApplicationInfo();
            				var applicationStatus=(!isNullOrEmpty(applicationInfoObject["applicationStatus"]))?applicationInfoObject["applicationStatus"]:null;                                                        
            				if(!isEmpty(applicationInfoObject) && (applicationInfoObject.isDirectAdmission==true || applicationInfoObject.isMidTermAdmission==true)){
            					if(applicationInfoObject.isDirectAdmission==true){                            			                            		
            						applicationStatus="DIRECT_ADMISSION";
            					}else if(applicationInfoObject.isMidTermAdmission==true){
            						applicationStatus="MID_TERM_ADMISSION";
            					}
            				}                                                        
            				me.addAdmission(addAdmissionProgramWindow,applicantAdmissionProgramGrid,applicantAdmissionDetailsForm,admissionDetailGrid,applicationId,applicationStatus,applicantProfile);
            			}
            		}                                        	
            	}
            },
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow]  button[itemId=editAdmissionBtn]': {
                click: function() {
                	var me = this;
                	var portalId = me.getCurrentLoggedPortalId();
                	if(portalId==6){
            			var applicantProfile = me.getContentPanel().items.items[0];
            		}else
            		{
            			var applicantProfile = me.getContentPanelActiveTab();
            		}
                    if (applicantProfile) {
                    	if(portalId==6){
            				var admissionDetailGrid = me.getAdmissionProgramGrid();
            			}else
            			{
            				var admissionDetailGrid = applicantProfile.down('#admissionDetailGrid');
            			}
                        var editAdmissionProgramWindow = this.getEditAdmissionProgramWindow();
                        if (editAdmissionProgramWindow && admissionDetailGrid) {
                            var applicantAdmissionDetailsForm = editAdmissionProgramWindow.down('#applicantEditAdmissionForm');
                            var applicantAdmissionProgramGrid = editAdmissionProgramWindow.down('#applicantAdmissionEditApplicationProgramGrid');                            
                            var applicationId=applicantProfile.getApplicationId();
                            var applicationInfoObject=applicantProfile.getApplicationInfo();
                            var applicationStatus=(!isNullOrEmpty(applicationInfoObject["applicationStatus"]))?applicationInfoObject["applicationStatus"]:null;                                                        
                            if(!isEmpty(applicationInfoObject) && (applicationInfoObject.isDirectAdmission==true || applicationInfoObject.isMidTermAdmission==true)){
                            		if(applicationInfoObject.isDirectAdmission==true){                            			                            		
                            			applicationStatus="DIRECT_ADMISSION";
                            		}else if(applicationInfoObject.isMidTermAdmission==true){
                            			applicationStatus="MID_TERM_ADMISSION";
                            		}
                            }                                                        
                            me.editAdmission(editAdmissionProgramWindow,applicantAdmissionProgramGrid,applicantAdmissionDetailsForm,admissionDetailGrid,applicationId,applicationStatus,applicantProfile);
                        }
                    }                                        	
                }
            },
            'adddirectadmissionprogramwindow  button[itemId=addAdmissionBtn]': {
                click: function(btn) {
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var admissionDetailGrid = applicantProfile.down('#admissionDetailGrid');
                        var addAdmissionProgramWindow=this.getAdddirectadmissionprogramwindow();
                       // var addAdmissionProgramWindow = this.getAddAdmissionProgramWindow();
                        if (addAdmissionProgramWindow && admissionDetailGrid) {
                            var applicantAdmissionDetailsForm = addAdmissionProgramWindow.down('#formId');
                            var applicantAdmissionProgramGrid = addAdmissionProgramWindow.down('#formId');
                            var record=new Object();
                            var academy=new Object();
                            record.academy=applicantAdmissionDetailsForm.down('#academyLocationCombo').valueModels[0].data;
                            record.academy.value=applicantAdmissionDetailsForm.down('#academyLocationCombo').getRawValue();
                            record.academy.academyLocationId=applicantAdmissionDetailsForm.down('#academyLocationCombo').getValue();
                            var batch=new Object();
                            record.batch=applicantAdmissionDetailsForm.down('#batch').valueModels[0].data;
                            batch.value=applicantAdmissionDetailsForm.down('#batch').getRawValue();
                            var location=new Object();
                            location=applicantAdmissionDetailsForm.down('#academyLocationCombo').valueModels[0].data;
                            location.value=applicantAdmissionDetailsForm.down('#academyLocationCombo').getRawValue();
                            var program=new Object();
                            record.program=applicantAdmissionDetailsForm.down('#program').valueModels[0].data;
                            program.value=applicantAdmissionDetailsForm.down('#program').getRawValue();
                            
                            var seatType=new Object();
                            record.seatType=applicantAdmissionDetailsForm.down('#seatType').valueModels[0].data;
                            seatType.value=applicantAdmissionDetailsForm.down('#seatType').valueModels[0].data;
                            
                            
                            var applicationId=applicantProfile.getApplicationId();
                            var applicationInfoObject=applicantProfile.getApplicationInfo();
                            var applicationStatus=(!isNullOrEmpty(applicationInfoObject["applicationStatus"]))?applicationInfoObject["applicationStatus"]:null;                                                        
                            if(!isEmpty(applicationInfoObject) && (applicationInfoObject.isDirectAdmission==true || applicationInfoObject.isMidTermAdmission==true)){
                            		if(applicationInfoObject.isDirectAdmission==true){                            			                            		
                            			applicationStatus="DIRECT_ADMISSION";
                            		}else if(applicationInfoObject.isMidTermAdmission==true){
                            			applicationStatus="MID_TERM_ADMISSION";
                            		}
                            }                                                        
                            me.addDirectAdmission(addAdmissionProgramWindow,record,applicantAdmissionDetailsForm,admissionDetailGrid,applicationId,applicationStatus,applicantProfile);
                        }
                    }                                        	
                }
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow]  button[itemId=cancelAdmissionBtn]': {
                click: function() {
                    this.getAddAdmissionProgramWindow().close();
                }
            },
            'adddirectadmissionprogramwindow  button[itemId=cancelAdmissionBtn]': {
                click: function() {
                    this.getAdddirectadmissionprogramwindow().close();
                }
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow]  datefield[itemId=trialStartDate]': {

                select: function(trialStartDate, value) {
                    var form = trialStartDate.up('form');
                    var trialEndDate = form.down('#trialEndDate');
                   // tillDate.reset();
                    if (trialStartDate.getValue() < new Date()) {
                    	trialEndDate.setMinValue(new Date());
                    } else {
                    	trialEndDate.setMinValue(trialStartDate.getValue());
                    }
                }

            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow] form[itemId=applicantAddAdmissionForm] combo[itemId=typeOfAdmission]': {
                change: function(cmb, records, eOpts) {
                    var addAdmissionProgramWindow = this.getAddAdmissionProgramWindow();
                    if (addAdmissionProgramWindow) {
                        var applicantAddAdmissionForm = addAdmissionProgramWindow.down('#applicantAddAdmissionForm');
                        var trialAdmissionContainer = applicantAddAdmissionForm.down('#trialAdmissionContainer');
                        var provisionalAdmissionPanel = applicantAddAdmissionForm.down('#provisionalAdmissionPanel');
                        var typeOfAdmission = cmb.getValue();
                        if (typeOfAdmission === 'CONFIRMED') {
                            trialAdmissionContainer.setVisible(false);
                            trialAdmissionContainer.setDisabled(true);
                            provisionalAdmissionPanel.setVisible(false);
                            provisionalAdmissionPanel.setDisabled(true);
                        } else if (typeOfAdmission === 'TRIAL') {
                            trialAdmissionContainer.setVisible(true);
                            trialAdmissionContainer.setDisabled(false);
                            provisionalAdmissionPanel.setVisible(false);
                            provisionalAdmissionPanel.setDisabled(true);
                        } else if (typeOfAdmission === 'PROVISIONAL') {
                            provisionalAdmissionPanel.setVisible(true);
                            provisionalAdmissionPanel.setDisabled(false);
                            trialAdmissionContainer.setVisible(false);
                            trialAdmissionContainer.setDisabled(true);
                        }
                        applicantAddAdmissionForm.isValid();
                    }
                }
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow] form[itemId=applicantAddAdmissionForm] checkboxfield[itemId=isExistingStudent]': {
            	change:function(obj, newValue, oldValue){
            		this.showHideExistingStudentDetails(obj, newValue, oldValue, 'SAVE');
            	}
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow] form[itemId=applicantAddAdmissionForm] button[itemId=searchStudentButtonItemId]': {
            	 click: function() {
                     this.openExistingStudentPopup('SAVE');
                 }
            },
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow] form[itemId=applicantEditAdmissionForm]  checkboxfield[itemId=isExistingStudent]': {
            	change:function(obj, newValue, oldValue){
            		this.showHideExistingStudentDetails(obj, newValue, oldValue, 'UPDATE');
            	}
            },
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow] form[itemId=applicantEditAdmissionForm] button[itemId=searchStudentButtonItemId]': {
            	 click: function() {
                     this.openExistingStudentPopup('UPDATE');
                 }
            },
            
            'existingstudentdetailgrid': {
            	afterrender: function(grid) {
            		var $this = this; 
            		var form=$this.getAddexistingstudenttoadmissionwindow();
            		if(form){
                    var NationalId=form.down('#nationalId').isVisible();
                    var ExternalSysRefOne=form.down('#externalSysRefOneId').isVisible();
                    var ImportExistingStudentId=form.down('#importExistingStudentId');
            		var gridStor = grid.getStore();
            		var applicantProfile = $this.getContentPanelActiveTab();
            		try{
            			applicantProfile.getApplicationId();
              	  	} catch(e){
              	  		applicantProfile = $this.getContentPanel().items.items[0];
              	  	}
            		var applicantPerson = applicantProfile.applicationDataObject.person;
            		if(NationalId&&ExternalSysRefOne&&!isNullOrEmpty(applicantPerson.nationalID)&&!isNullOrEmpty(applicantPerson.externalSysRefOne)) {
            			gridStor.getProxy().extraParams = {
                			nationalId:applicantPerson.nationalID,
                			externalSysRefOne:applicantPerson.externalSysRefOne
                		}
            			gridStor.load();
						setTimeout(function(){
            			if(gridStor.data.length>1){
							ImportExistingStudentId.setDisabled(false);
            				var count=0;
                			gridStor.data.items.forEach(function(itemObj){
    								if(!isNullOrEmpty(itemObj.data.externalSysRefOne)&&applicantPerson.externalSysRefOne==itemObj.data.externalSysRefOne){
    									count++;
    									if(count>1){
    										ImportExistingStudentId.setDisabled(true);
    										setTimeout(function(){
            									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUPLICATE_EXTERNAL_REFERENCE_NO_FOUND'));
    			                                },400);
    										}
    								}
                        	 });
                		}
                        },300);

            		}else if(NationalId&&!isNullOrEmpty(applicantPerson.nationalID)){
            			gridStor.getProxy().extraParams = {
                			nationalId:applicantPerson.nationalID
                		}
            			gridStor.load();
            		}else if(ExternalSysRefOne&&!isNullOrEmpty(applicantPerson.externalSysRefOne)){
            			gridStor.getProxy().extraParams = {
                		    externalSysRefOne:applicantPerson.externalSysRefOne
                		}
            			gridStor.load();
						setTimeout(function(){
            			if(gridStor.data.length>1){
							ImportExistingStudentId.setDisabled(false);
            				var count=0;
                			gridStor.data.items.forEach(function(itemObj){
    								if(!isNullOrEmpty(itemObj.data.externalSysRefOne)){
    									count++;
    									if(count>1){
    										ImportExistingStudentId.setDisabled(true);
    										setTimeout(function(){
            									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DUPLICATE_EXTERNAL_REFERENCE_NO_FOUND'));
    			                                },400);
    									}	
    								}
                        	 });
                		}
                        },300);
            		}else if(!ExternalSysRefOne&&!ExternalSysRefOne){
            			gridStor.removeAll();
						ImportExistingStudentId.setDisabled(true);
            		}
            	   }
            	}
            },
            'addexistingstudenttoadmissionwindow[itemId=addexistingstudenttoadmissionwindow] button[itemId=importExistingStudentId]':{
            	click: function(btn) {
            		var $this = this;
            		var existingStudentWindow = $this.getAddexistingstudenttoadmissionwindow();
            		var saveOrUpdate = existingStudentWindow.down('#saveOrUpdateHidden').getValue();
            		var addAdmissionProgramWindow = $this.getAddAdmissionProgramWindow();
            		if (saveOrUpdate == 'UPDATE') {
            			addAdmissionProgramWindow =  $this.getEditAdmissionProgramWindow();
					}
            		var grid = $this.getExistingstudentdetailgrid();
            		var gridSelection = grid.getSelectionModel().getSelection();
            		if (gridSelection.length > 0) {
            			var data =  gridSelection[0].data;
            			if (addAdmissionProgramWindow) {
            				var applicantAddAdmissionForm = addAdmissionProgramWindow.down('#applicantAddAdmissionForm');
            				if (saveOrUpdate == 'UPDATE') {
            					applicantAddAdmissionForm =  addAdmissionProgramWindow.down('#applicantEditAdmissionForm');
            				}
            				var studentIdField = applicantAddAdmissionForm.down('#existingStudentId').setValue(data.studentCode);
            				var studentIdHiddenField = applicantAddAdmissionForm.down('#studentIdHidden').setValue(data.id);
            			}
            			applicantAddAdmissionForm.getForm().checkValidity();
            		}

            		 var window = this.getAddexistingstudenttoadmissionwindow();
            		 if (!window) {
            			 window = Ext.widget('addexistingstudenttoadmissionwindow', {
            				 itemId: 'addexistingstudenttoadmissionwindow'
            			 });
            		 }
            		 window.close();
            	}
            },
            'addexistingstudenttoadmissionwindow[itemId=addexistingstudenttoadmissionwindow] button[itemId=cancelBtn]':{
            	click: function(btn) {
            		var $this = this;
            		 var window = $this.getAddexistingstudenttoadmissionwindow();
            		 if (!window) {
            			 window = Ext.widget('addexistingstudenttoadmissionwindow', {
            				 itemId: 'addexistingstudenttoadmissionwindow'
            			 });
            		 }
            		 window.close();
            	}
            },
            
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow] form[itemId=applicantEditAdmissionForm] combo[itemId=typeOfAdmission]': {
                change: function(cmb, records, eOpts) {
                    var editAdmissionProgramWindow = this.getEditAdmissionProgramWindow();
                    if (editAdmissionProgramWindow) {
                        var applicantEditAdmissionForm = editAdmissionProgramWindow.down('#applicantEditAdmissionForm');
                        var trialAdmissionContainer = applicantEditAdmissionForm.down('#trialAdmissionContainer');
                        var provisionalAdmissionPanel = applicantEditAdmissionForm.down('#provisionalAdmissionPanel');
                        var typeOfAdmission = cmb.getValue();
                        if (typeOfAdmission === 'CONFIRMED') {
                            trialAdmissionContainer.setVisible(false);
                            trialAdmissionContainer.setDisabled(true);
                            provisionalAdmissionPanel.setVisible(false);
                            provisionalAdmissionPanel.setDisabled(true);
                        } else if (typeOfAdmission === 'TRIAL') {
                            trialAdmissionContainer.setVisible(true);
                            trialAdmissionContainer.setDisabled(false);
                            provisionalAdmissionPanel.setVisible(false);
                            provisionalAdmissionPanel.setDisabled(true);
                        } else if (typeOfAdmission === 'PROVISIONAL') {
                            provisionalAdmissionPanel.setVisible(true);
                            provisionalAdmissionPanel.setDisabled(false);
                            trialAdmissionContainer.setVisible(false);
                            trialAdmissionContainer.setDisabled(true);
                        }
                        applicantEditAdmissionForm.isValid();
                    }
                }
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow] grid[itemId=applicantAdmissionAddApplicationProgramGrid] combo[itemId=cmbPgmGroup]': {
                select: function(combo, record) {
                    var addProgramWindowGrid = this.getAddAdmissionProgramWindow().down('#applicantAdmissionAddApplicationProgramGrid');
                    var selectedProgramGroup = record[0].get('id');
                    this.mixins.AdmissionFormCommonController.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,false,true);
                }
            },
            
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow] grid[itemId=applicantAdmissionAddApplicationProgramGrid]': {
                render: function(addProgramWindowGrid) {
                	addProgramWindowGrid.down('#quickSearchId').setVisible(false);                	
                	addProgramWindowGrid.down('#resetBtn').setVisible(false);
                	
					var column = Ext.Array.findBy(addProgramWindowGrid.headerCt.getGridColumns(), function(col) {
						return col.dataIndex === 'schoolAttendanceStartDate';
					});

					if (column) {
						column.editor = null;
						addProgramWindowGrid.getView().refresh();
					}
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    try{
                		applicantProfile.getApplicationId();
                	} catch(e){
                		applicantProfile = me.getContentPanel().items.items[0];
                	}
                    if (applicantProfile) {                        
                    	var selectedAdmissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
                        if(selectedAdmissionProgramGrid == null) {
                        	selectedAdmissionProgramGrid = me.getContentPanel().items.items[1].down('#admissionDetailGrid');
                        }
                    	var programGroup = addProgramWindowGrid.down('#cmbPgmGroup');
                        var applicationInfoObject=applicantProfile.getApplicationInfo();
                        var applicationDataObject=applicantProfile.getApplicationDataObject();
                        if( !isEmpty(applicationInfoObject) && 
                        	(applicationInfoObject.applicationStatus==="DIRECT_ADMISSION" || applicationInfoObject.applicationStatus==="MID_TERM_ADMISSION") &&
                            (applicationDataObject.saleRefType === 'ENQUIRED_EARLIER' )	&&
                            (!isNullOrEmpty(applicationDataObject.enquiryStudentDetailId))
                           ){                        	
                        	addProgramWindowGrid.getStore().getProxy().api.read = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_TAB_GRID_DATA; //URL-:rest/applicationProgram/findByApplicationId 
                        	//SERVERURL.APPLICATIONS_ADMISSION_OFFER_LETTER_ACCEPTED_DATA; //URL - :rest/applicationProgram/findOfferLetterAccepted
                    		addProgramWindowGrid.getStore().load({
                    			callback: function(records, operation, success) {
                                	var rowIndex = this.find('id', records[0].data.id);  //where 'id': the id field of your model, record.getId() is the method automatically created by Extjs. You can replace 'id' with your unique field.. And 'this' is your store.
                    		        addProgramWindowGrid.getView().select(rowIndex);
                                },
                                params: {
                                    applicationID: applicantProfile.getApplicationId()
                                }
                    		});
                        }else if(!isEmpty(applicationInfoObject) && (applicationInfoObject.applicationStatus==="DIRECT_ADMISSION" || applicationInfoObject.applicationStatus==="MID_TERM_ADMISSION")){
                        	programGroup.setVisible(true);                  
                        	programGroup.getStore().load();
                        	me.mixins.AdmissionFormCommonController.loadProgramGroupWithGridData(me, programGroup, addProgramWindowGrid, selectedAdmissionProgramGrid);
                        }else{      
                        	if (selectedAdmissionProgramGrid != null) {
                        		me.loadOfferLetterAcceptedProgram(me, addProgramWindowGrid, selectedAdmissionProgramGrid);
							}
                            
                        }                                                                    		                       	                    	
                    }
                },
                afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getADMISSION_DETAILS_ADD_PROGRAM_PERMISSIONS());
    			},
                beforeselect: function(rowModel, record, index, eOpts) {
                    var me = this;
                    var addadmssionProgramForm=this.getAddAdmissionProgramWindow();
                    var admissionDate = addadmssionProgramForm.down('#admissiondate');
                    var schoolAttendanceStartDate = addadmssionProgramForm.down('#schoolAttendanceStartDate');
                    
                    if (!isEmpty(record.data) && !isNullOrEmpty(record.get('isAdmissionDone')) && record.get('isAdmissionDone')) {
                    	showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('PLEASE_SELECT_ANOTHER_PROGRAM_FOR_ADMISSION')); //This Program has already assigned for admission,Please select another program                 	
                    	return false;
                    }else{
                    	if (!isEmpty(record.data) && !isEmpty(record.get('batch'))) {
                            if (!isNullOrEmpty(record.data.batch.id)) {
	                            schoolAttendanceStartDate.setValue(dateRender(record.data.schoolAttendanceStartDate));
                                var batchId = record.data.batch.id;
                                var periodCombo = me.getAddAdmissionProgramWindow().down('#cmbPeriod');
                                periodCombo.setDisabled(false);
                                if (periodCombo) {
                                    periodCombo.getStore().load({
                                        params: {
                                            id: batchId
                                        },
                                        callBack: function() {
                                            //periodCombo.setDisabled(false);
                                        }
                                    });
                                }
                                var progBatchSeatConfigurationId = record.data.programBatchSeatConfigurationId;
                                var submitUrl = SERVERURL.FIND_PROG_SELECTION_ADMCOFIG_BY_PBSID+"?progBatchSeatConfigurationId="+progBatchSeatConfigurationId;
                                if (!isNullOrEmpty(submitUrl)) {
                                    Ext.Ajax.request({
                                        type: 'rest',
                                        url: submitUrl,
                                        method: 'GET',
                                        //jsonData: jsonFormatFormData,
                                        success: function(success) {
                                            var data = Ext.decode(success.responseText);
                                        	var backDays = data.admissionBackDays;
                                            var isbackDays = data.whetherAllowBackDateAdmission	
                                        	if(isbackDays) {
                                        		var d = new Date();
                                        		 d.setDate(d.getDate()-backDays);
                                        		 admissionDate.setMinValue(d);
                                        		 admissionDate.validate();
                                        	} else {
                                        		 admissionDate.setMinValue(new Date());
                                        		 admissionDate.validate();
                                        	}
                                        }
                                    });

                                }
                            }
                        }
                    }                    
                },
                /*cellclick: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                	console.log('Record '+record);
                }*/
            },
            
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow] grid[itemId=applicantAdmissionEditApplicationProgramGrid]': {
            	afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getADMISSION_DETAILS_EDIT_PROGRAM_PERMISSIONS());
    			}
            },
            'addadmissionprogramwindow[itemId=addAdmissionProgramWindow] form[itemId=applicantAddAdmissionForm] combo[itemId=cmbPeriod]': {
            	select: function(periodCombo) {
            		var addadmssionProgramForm=this.getAddAdmissionProgramWindow();
               		var periodId = periodCombo.getValue();
            		var sectionCombo = addadmssionProgramForm.down('#section');
               		sectionCombo.setDisabled(false);
               		sectionCombo.clearValue();
            		var sectionStore = sectionCombo.getStore();
            		sectionCombo.getStore().getProxy().extraParams = {
               			periodId:periodId
               		}
               		sectionStore.load();
                }
            },
          //  'adddirectadmissionprogramwindow[itemId=addDirectAdmissionProgramWindow] combo[itemId=programGroupId]': {
            'adddirectadmissionprogramwindow combo[itemId=academyLocationCombo]': {
            	/*render: function(combo) {
                	var me = this;
                	this.loadAcadLocCombo(combo);
                    
                    var store = combo.getStore();
                	store.load({
            			callback:function(records,response,success){
            				combo.setValue(me.getCurrentAcademyLocation())
            			}
            		});
                },*/
            	select: function(combo) {
            		var me=this;
            		var adddirectadmission=me.getAdddirectadmissionprogramwindow();
            		var programCombo=adddirectadmission.down('#program');
            		//programGroupCombo.reset();
            		var programGroupCombo=adddirectadmission.down('#cmbPgmGroup');
            		programGroupCombo.setDisabled(false);
            		programGroupCombo.reset();
            		var programGroupValue = programGroupCombo.getValue();
            		var alValue = combo.getValue();
            		/*programCombo.setDisabled(false);
                	programCombo.getStore().getProxy().extraParams = {
                		programGroupId:programGroupValue,
                		academyLocationId:alValue
                	}
                	programCombo.getStore().load();*/
            		/*var store=storeField.getStore();
            		store.proxy.extraParams = {
  							 academyLocationId : programGroupCombo.getValue()
  					};
            		store.load();*/
            		//this$.mixins.AdmissionFormCommonController.loadDependentCombo(programCombo, programGroupCombo.getValue(), 'programGroupId');
            	}
            },
            'adddirectadmissionprogramwindow combo[itemId=cmbPgmGroup]': {
            	select: function(programGroupCombo) {
            		var this$ = this;
            		var adddirectadmission=this$.getAdddirectadmissionprogramwindow();
            		var programCombo = adddirectadmission.down('#program');
            		var batchCombo = adddirectadmission.down('#batch');
            		var programGroupValue = adddirectadmission.down('#cmbPgmGroup').getValue();
            		var alValue = adddirectadmission.down('#academyLocationCombo').getValue();
            		programCombo.setDisabled(false);
            	/*	programCombo.getStore().getProxy().extraParams = {
                		programGroupId:programGroupValue,
                		academyLocationId:alValue
                	}
                	programCombo.getStore().load();*/
            		//this.loadDependentCombo(programCombo, programGroupCombo.getValue(), 'programGroupId','academyLocationIds',alValue);
            		
            		//var programId = record[0].get("id");
            	//	 var programId = programCombo.getValue();
	  				  if (programGroupValue > 0) {
	  					  var store = programCombo.getStore();
	  					  store.getProxy().extraParams = {
	  						programGroupId:programGroupValue,
	                		academyLocationId:alValue,
	                	//	id: programId
	  					  };
	  					  store.load({
	  						 callback: function(records, operation, success) {
   							 if (success) {
   								 if(records.length == 1){
   									programCombo.setValue(records[0].data.id);
   									programCombo.fireEvent('select',batchCombo,records);
   								 }	
   							 }
   						 }
   					  });
	  				 }
            		
            	}
            },
            'adddirectadmissionprogramwindow combo[itemId=program]': {

            	select: function(programCombo, records, eOpts) {
            		var this$ = this;
            		var adddirectadmission=this$.getAdddirectadmissionprogramwindow();
            		var batchCombo = adddirectadmission.down('#batch');
            		batchCombo.setDisabled(false);
            		//this.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
            		
            		var periodCombo = adddirectadmission.down('#cmbPeriod');
            		var seatTypeComboField = adddirectadmission.down('#seatType');
            		
            		var programId = programCombo.getValue();
	  				  if (programId > 0) {
	  					  var store = batchCombo.getStore();
	  					  store.getProxy().extraParams = {
	  						  id: programId
	  					  };
	  					  //store.load();
	  					  store.load({
     						 callback: function(records, operation, success) {
     							 if (success) {
     								 if(records.length == 1){
     									 batchCombo.setValue(records[0].data.id);
     									 batchCombo.fireEvent('select',batchCombo,records);
     								 } else {
     									periodCombo.reset();
     									seatTypeComboField.reset();
     								 }
     							 }
     						 }
     					  });
	  				  }
            		
            	},
            	change: function(cmb, value, eOpts) {
            		var this$ = this;
            		var adddirectadmission=this$.getAdddirectadmissionprogramwindow();
            		var batchCombo = adddirectadmission.down('#batch');
            		batchCombo.reset();
	  			    var store = batchCombo.getStore();
	  					  store.getProxy().extraParams = {
	  						  id: value
	  					  };
	  					  store.load();
            	}
            },
            'adddirectadmissionprogramwindow combo[itemId=batch]': {

            	select: function(programCombo, records, eOpts) {
            		var this$ = this;
            		var adddirectadmission=this$.getAdddirectadmissionprogramwindow();
            		var periodCombo = adddirectadmission.down('#cmbPeriod');
            		//this$.loadDependentCombo(periodCombo, programCombo.getValue(), 'id');
            		var seatTypeComboField = adddirectadmission.down('#seatType');
            		//var comboValue = combo.getValue();
            		//this.loadDependentCombo(seatTypeComboField, programCombo.getValue(), 'batchId');
            		
            		if (programCombo.getValue() > 0) {
	  					  var store = periodCombo.getStore();
	  					  store.getProxy().extraParams = {
	  						  id: programCombo.getValue()
	  					  };
	  					  //store.load();
	  					  store.load({
   						  callback: function(records, operation, success) {
   							 if (success) {
   								 if(records.length == 1){
   									periodCombo.setValue(records[0].data.id);
   									periodCombo.fireEvent('select',periodCombo,records);
   								 }	
   							 }
   						 }
   					  });
	  				 }
            		
            		if (programCombo.getValue() > 0) {
	  					  var store = seatTypeComboField.getStore();
	  					  store.getProxy().extraParams = {
	  						 batchId: programCombo.getValue()
	  					  };
	  					  //store.load();
	  					  store.load({
 						  callback: function(records, operation, success) {
 							 if (success) {
 								 if(records.length == 1){
 									seatTypeComboField.setValue(records[0].data.seatType.id);
 									//seatTypeComboField.fireEvent('select',batchCombo,records);
 								 }	
 							 }
 						 }
 					  });
	  				 }
            		
            	}
            },

            'adddirectadmissionprogramwindow combo[itemId=cmbPeriod]': {
            	select: function(periodCombo) {
            		var this$ = this;
            		var adddirectadmission=this$.getAdddirectadmissionprogramwindow();
            		var courseCombo = adddirectadmission.down('#course');
            	//	this.loadDependentCombo(courseCombo, periodCombo.getValue(), 'period');
            		var sectionCombo = adddirectadmission.down('#section');
            		sectionCombo.setDisabled(false);
            		this.loadDependentCombo(sectionCombo, periodCombo.getValue(), 'periodId');
            	}
            },
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow]  button[itemId=cancelAdmissionBtn]': {
                click: function() {
                    this.getEditAdmissionProgramWindow().close();
                }
            },
            'editadmissionprogramwindow[itemId=editAdmissionProgramWindow] form[itemId=applicantEditAdmissionForm] combo[itemId=cmbPeriod]': {
            	select: function(periodCombo) {
            		var editadmssionProgramForm=this.getEditAdmissionProgramWindow();
               		var periodId = periodCombo.getValue();
            		var sectionCombo = editadmssionProgramForm.down('#section');
               		sectionCombo.setDisabled(false);
               		sectionCombo.clearValue();
            		var sectionStore = sectionCombo.getStore();
            		
            		sectionCombo.getStore().getProxy().extraParams = {
               			periodId:periodId
               		}
               		sectionStore.load();
                }
            }
        });
        this.callParent(arguments); 
    },

    /**************Mid-Term Admission Tab ********************/
    /*
     * This function is used for to show Other Courses Completed Details Dialog box after clicking on Add button   
     */
    addOthercourses: function() {
        var otherCoursesFormWindow = this.getOtherCoursesFormWindow();
        if (!otherCoursesFormWindow) {
            otherCoursesFormWindow = Ext.widget('othercoursesformwindow', {
                itemId: 'applicantOtherCoursesFormWindow'
            });
        }
        otherCoursesFormWindow.show();
    },

    /*
     * This function is used for to show other course Details Dialog box with values of selected record after clicking on edit button   
     */
    editOthercourses: function(grid, isView) {
        var me = this;
        if (grid.getSelectionModel().getCount() > 0) {
            me.addOthercourses(); //show other course Details Dialog box  
            var record = grid.getSelectionModel().getSelection()[0];
            var window = me.getOtherCoursesFormWindow();
            if (window) {
                var othercoursesForm = window.down('#othercoursesForm');
                if (!isEmpty(record) && !isEmpty(othercoursesForm)) {
                    var rec = new Academia.model.admission.applications.admissionAndMidTermAdmission.MidTermAdmissionCourseModel(record.data);
                    othercoursesForm.loadRecord(rec);
                    if (isView) {
                        window.down('#btnSaveOtherCoursesForm').setVisible(false);
                        toggleReadOnlyFormItems(othercoursesForm.getForm(), true);
                    }
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*  
     *   This function is used for to save other course Details after clicking on save button
     *       
     */
    saveOtherCoursesForm: function(grid, window) {
    	var me=this;
        var otherCoursesForm = window.down('#othercoursesForm');
        var applicantProfile = me.getContentPanelActiveTab();        
        var submitUrl = '',
            methodName = '',
            isUpdate = false;
        if (otherCoursesForm && applicantProfile) {            
            var applicationId = applicantProfile.getApplicationId();
            var otherCoursesFormData = otherCoursesForm.getValues();            
            otherCoursesFormData.applicationId = applicationId;

            var otherCoursesHiddenField = otherCoursesForm.down('#otherCoursesHiddenField');
            if (isNullOrEmpty(otherCoursesHiddenField.getSubmitValue())) {
                submitUrl = SERVERURL.APPLICATIONS_OTHER_COURSES_CREATE, //rest/applicationOtherCourses/create
                methodName = 'POST';
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.APPLICATIONS_OTHER_COURSES_UPDATE, //rest/applicationOtherCourses/update
                methodName = 'PUT';
                isUpdate = true;
            }
            var jsonFormatFormData = Ext.encode(otherCoursesFormData);
            if (!isNullOrEmpty(submitUrl) && !isNullOrEmpty(methodName) && !isNullOrEmpty(jsonFormatFormData)) {
                Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    method: methodName,
                    jsonData: jsonFormatFormData,
                    success: function(form, action) {
                        window.close();
                        grid.getStore().reload();
                        grid.getSelectionModel().deselectAll();
                        if (isUpdate) {
                            showSuccessMessage(getAdmissionTranslation('OTHER_COURSES'), getAdmissionTranslation('UPDATE_OTHER_COURSES_MSG')); //Other Course updated successfully												
                        } else {
                            showSuccessMessage(getAdmissionTranslation('OTHER_COURSES'), getAdmissionTranslation('ADD_OTHER_COURSES_MSG')); //Other Course added successfully												
                        }
                    }
                });

            }
        }
    },


    /*
     * This function is used for to delete other course after click on delete button.
     * 
     */
    deleteOthercourses: function(grid) {
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getAdmissionTranslation('OTHER_COURSES'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var otherCourseId = "",
                                url = '';
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                otherCourseId = records[count].get("id");
                                url = SERVERURL.APPLICATIONS_OTHER_COURSES_DELETE; //URL-rest/applicationOtherCourses/delete                                    
                                if (!isNullOrEmpty(otherCourseId) && !isNullOrEmpty(url)) {
                                    url = url.concat("/" + otherCourseId);
                                    Ext.Ajax.request({
                                        type: 'rest',
                                        method: 'DELETE',
                                        url: url,
                                        success: function(form, action) {
                                            showSuccessMessage(getAdmissionTranslation('OTHER_COURSES'), getAdmissionTranslation('DELETE_OTHER_COURSES_MSG')); //Other Course deleted successfully.
                                            grdStore.reload();
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },


    /**************Admission Details Tab ********************/
    /*
     * This function is used for to add admission details after clicking on Add Admission button   
     * Admission Types - 1.Confirmed Admission  2.Trial Admission  3.Provisional Admission
     * 
     */
    addAdmission: function(addAdmissionProgramWindow,applicantAdmissionProgramGrid,applicantAdmissionDetailsForm,admissionDetailGrid,applicationId,applicationStatus,applicantProfile) {
    	var me = this;    	
    	if(applicantAdmissionProgramGrid){
    		//var cmbPeriod=applicantAdmissionProgramGrid.down('#cmbPeriod');  old code
    		var cmbPeriod = addAdmissionProgramWindow.down('#cmbPeriod');  
    		var admissionDate = addAdmissionProgramWindow.down('#admissiondate');
    		var cmbProgramGroup =applicantAdmissionProgramGrid.down('#cmbPgmGroup');
    		var sectionCombo = addAdmissionProgramWindow.down('#section');
    		var admissiondate = addAdmissionProgramWindow.down('#admissiondate');
    		var isExistingStudent = addAdmissionProgramWindow.down('#isExistingStudent').getValue();
    		var existingStudentId = addAdmissionProgramWindow.down('#studentIdHidden').getValue();
    		var schoolAttendanceStartDate = addAdmissionProgramWindow.down('#schoolAttendanceStartDate');
    		if(applicationStatus==='DIRECT_ADMISSION'){
    			var record=applicantAdmissionProgramGrid;
    		}
    		var record = applicantAdmissionProgramGrid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
            	if(applicantAdmissionDetailsForm.getForm().isValid()){            		
            		
            		var addAdmissionJsonObject=new Object();
            		addAdmissionJsonObject.applicationId=applicationId;
            		if(applicationStatus==='DIRECT_ADMISSION' || applicationStatus==='MID_TERM_ADMISSION'){
            			if(cmbProgramGroup && !isNullOrEmpty(cmbProgramGroup.getValue())){            			
                			addAdmissionJsonObject.programGroupId=cmbProgramGroup.getValue();
                		}
            		}
            		//addAdmissionJsonObject.admissiondate = admissionDate.getValue();
            		addAdmissionJsonObject.applicationStatus=applicationStatus;
            		addAdmissionJsonObject.applicationProgramId=(!isNullOrEmpty(record.get('id')))?record.get('id'):null;
            		addAdmissionJsonObject.programBatchSeatConfigurationId=(!isNullOrEmpty(record.get('programBatchSeatConfigurationId')))?record.get('programBatchSeatConfigurationId'):null;
            		addAdmissionJsonObject.academyLocationId=(!isNullOrEmpty(record.get('academyLocationId')))?record.get('academyLocationId'):null;
            		addAdmissionJsonObject.programId =(!isNullOrEmpty(record.get('program')))?(!isNullOrEmpty(record.get('program').id)?(record.get('program').id):null):null;
            		addAdmissionJsonObject.status="ADMISSION_IN_PROGRESS";         		
            		addAdmissionJsonObject=me.getApplicantAdmissionDetailsFormData(me,applicantAdmissionDetailsForm,addAdmissionJsonObject);
            		
            		if(cmbPeriod && !isNullOrEmpty(cmbPeriod.getValue())){            			
            			addAdmissionJsonObject.programBatchPeriodConfigurationId=cmbPeriod.getValue();
            		}else if(cmbPeriod && isNullOrEmpty(cmbPeriod.getValue())){
            			showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('SELECT_PERIOD_VALUE')); //Please select period value
            			return 0;
            		}             		            		            		            		            	            		
            		
            		addAdmissionJsonObject.sectionId=sectionCombo.getValue();
            		addAdmissionJsonObject.admissiondate=admissiondate.getValue();
            		addAdmissionJsonObject.schoolAttendanceStartDate=schoolAttendanceStartDate.getValue();
            		
            		if (!isNullOrEmpty(isExistingStudent)) {
            			addAdmissionJsonObject.isExistingStudent = isExistingStudent;
            			addAdmissionJsonObject.existingStudentId = existingStudentId;
					}
            		
            		
            		if (!isEmpty(addAdmissionJsonObject)) {
                        var jsonFormatFormData = Ext.encode(addAdmissionJsonObject);
                        if (!isNullOrEmpty(jsonFormatFormData)) {
                        	var applicantProfile = me.getContentPanelActiveTab();
                    		try{
                    			applicantProfile.getApplicationId();
                      	  	} catch(e){
                      	  		applicantProfile = me.getContentPanel().items.items[0];
                      	  	}
                      	  	
                    		var applicantPerson = applicantProfile.applicationDataObject.person;
                    		var portalId = me.getCurrentLoggedPortalId();

                        	if((isNullOrEmpty(addAdmissionJsonObject.isExistingStudent) || addAdmissionJsonObject.isExistingStudent==false || addAdmissionJsonObject.isExistingStudent=='false') 
                        			&& !isNullOrEmpty(applicantPerson.nationalID) && portalId==1) {
                        		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                        		Ext.Ajax.request({
                                    type: 'rest',
                                    method: 'GET',
                                    url: SERVERURL.PATH_IS_STUDENT_EXISTS_BY_NATIONAL_ID + '?nationalId=' + applicantPerson.nationalID,
                                    success: function(success) {
                                        var data = Ext.decode(success.responseText);
                                    	if(data) {
                                    		Ext.getBody().unmask();
                                    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USE_EXISTING_STUDENT_ALERT'));
                                    		return false;
                                    	} else {
                                    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                                            Ext.Ajax.request({
                                                type: 'rest',                                
                                                url: SERVERURL.APPLICATIONS_ADMISSION_CREATE, //URL-: rest/applicationAdmissionDetails/create
                                                jsonData: jsonFormatFormData,
                                                method: 'POST',
                                                success: function(response, action) {                                	
                                                    admissionDetailGrid.getStore().reload();
                                                    addAdmissionProgramWindow.close();                                    
                                                    showSuccessMessage(getAdmissionTranslation('PROGRAM_ADD'), getAdmissionTranslation('PROGRAM_ADD_MSG')); //Admission added successfully
                                                    me.mixins.ApplicationBaseController.gettingDataInSummaryGrid(applicantProfile);
                                                    addAdmissionProgramWindow.down("#addAdmissionBtn").setDisabled(true);
                                                    /************* For Mid-Term Admission Flow call following function *******************/
                                                    if((applicantProfile.getApplicationInfo()['applicationStatus']==='MID_TERM_ADMISSION')){
                                                    	me.loadMidTermCoursesByApplicationId();
                                                    }
                                                    Ext.getBody().unmask();
                                                },
                                                failure: function(form, action) {
                                                	   addAdmissionProgramWindow.down("#addAdmissionBtn").setDisabled(false);
                                                	if(Ext.decode(form.responseText)[0].key == "ADMISSION_PROCESS_NOT_OPENED") {
                                                		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_PROCESS_NOT_OPENED'));
                                                	}
                                                } 
                                            });
                                    	}
                                    }
                    			});
                        	} else {
                        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                            Ext.Ajax.request({
                                type: 'rest',                                
                                url: SERVERURL.APPLICATIONS_ADMISSION_CREATE, //URL-: rest/applicationAdmissionDetails/create
                                jsonData: jsonFormatFormData,
                                method: 'POST',
                                success: function(response, action) {                                	
                                    admissionDetailGrid.getStore().reload();
                                    addAdmissionProgramWindow.close();                                    
                                    showSuccessMessage(getAdmissionTranslation('PROGRAM_ADD'), getAdmissionTranslation('PROGRAM_ADD_MSG')); //Admission added successfully
                                    me.mixins.ApplicationBaseController.gettingDataInSummaryGrid(applicantProfile);
                                    addAdmissionProgramWindow.down("#addAdmissionBtn").setDisabled(true);
                                    /************* For Mid-Term Admission Flow call following function *******************/
                                    if((applicantProfile.getApplicationInfo()['applicationStatus']==='MID_TERM_ADMISSION')){
                                    	me.loadMidTermCoursesByApplicationId();
                                    }
                                    Ext.getBody().unmask();
                                },
                                failure: function(form, action) {
                                	addAdmissionProgramWindow.down("#addAdmissionBtn").setDisabled(false);
                                	if(Ext.decode(form.responseText)[0].key == "ADMISSION_PROCESS_NOT_OPENED") {
                                		showWarningMessage(getCommonTranslation('ALERT'),getErrorTranslation('ADMISSION_PROCESS_NOT_OPENED'));
                                	}
                                } 
                            });
                        }
                        }
                    }            		
            	}else{
            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
            	}                
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
    	}    	
    },
    
    /**************Admission Details Tab ********************/
    /*
     * This function is used for to add admission details after clicking on Add  Admission button   
     * Admission Types - 1.Direct Admission
     * 
     */
    addDirectAdmission: function(addAdmissionProgramWindow,record,applicantAdmissionDetailsForm,admissionDetailGrid,applicationId,applicationStatus,applicantProfile) {
    	var me = this;    	
    	if(record){
    		//var cmbPeriod=applicantAdmissionProgramGrid.down('#cmbPeriod');  old code
    		var cmbPeriod = addAdmissionProgramWindow.down('#cmbPeriod');  
    		var admissionDate = addAdmissionProgramWindow.down('#admissiondate');
    		var cmbProgramGroup =addAdmissionProgramWindow.down('#cmbPgmGroup');
    		var sectionCombo = addAdmissionProgramWindow.down('#section');
    		var admissiondate = addAdmissionProgramWindow.down('#admissiondate');
    		var schoolAttendanceStartDate = addAdmissionProgramWindow.down('#schoolAttendanceStartDate');
    		//var record = applicantAdmissionProgramGrid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
            	if(applicantAdmissionDetailsForm.getForm().isValid()){            		
            		
            		var addAdmissionJsonObject=new Object();
            		addAdmissionJsonObject.applicationId=applicationId;
            		if(applicationStatus==='DIRECT_ADMISSION' || applicationStatus==='MID_TERM_ADMISSION'){
            			if(cmbProgramGroup && !isNullOrEmpty(cmbProgramGroup.getValue())){            			
                			addAdmissionJsonObject.programGroupId=cmbProgramGroup.getValue();
                		}
            		}
            		//addAdmissionJsonObject.admissiondate = admissionDate.getValue();
            		addAdmissionJsonObject.applicationStatus=applicationStatus;
            		addAdmissionJsonObject.applicationProgramId=(!isNullOrEmpty(record.id))?record.id:null;
            		addAdmissionJsonObject.programBatchSeatConfigurationId=(!isNullOrEmpty(record.seatType.id))?record.seatType.id:null;
            		addAdmissionJsonObject.academyLocationId=(!isNullOrEmpty(record.academy.academyLocationId))?record.academy.academyLocationId:null;
            		addAdmissionJsonObject.programId =(!isNullOrEmpty(record.program))?(!isNullOrEmpty(record.program.id)?(record.program.id):null):null;
            		addAdmissionJsonObject.status="ADMISSION_IN_PROGRESS";            		
            		addAdmissionJsonObject=me.getApplicantDirectAdmissionDetailsFormData(me,applicantAdmissionDetailsForm,addAdmissionJsonObject);
            		
            		if(cmbPeriod && !isNullOrEmpty(cmbPeriod.getValue())){            			
            			addAdmissionJsonObject.programBatchPeriodConfigurationId=cmbPeriod.getValue();
            		}else if(cmbPeriod && isNullOrEmpty(cmbPeriod.getValue())){
            			showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('SELECT_PERIOD_VALUE')); //Please select period value
            			return 0;
            		}             		            		            		            		            	            		
            		
            		addAdmissionJsonObject.sectionId=sectionCombo.getValue();
            		addAdmissionJsonObject.admissiondate=admissiondate.getValue();
            		addAdmissionJsonObject.schoolAttendanceStartDate=schoolAttendanceStartDate.getValue();
            		
            		if (!isEmpty(addAdmissionJsonObject)) {
                        var jsonFormatFormData = Ext.encode(addAdmissionJsonObject);
                        if (!isNullOrEmpty(jsonFormatFormData)) {
                        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                            Ext.Ajax.request({
                                type: 'rest',                                
                                url: SERVERURL.APPLICATIONS_ADMISSION_CREATE, //URL-: rest/applicationAdmissionDetails/create
                                jsonData: jsonFormatFormData,
                                method: 'POST',
                                success: function(response, action) {                                	
                                    admissionDetailGrid.getStore().reload();
                                    addAdmissionProgramWindow.close();                                    
                                    showSuccessMessage(getAdmissionTranslation('PROGRAM_ADD'), getAdmissionTranslation('PROGRAM_ADD_MSG')); //Admission added successfully
                                    me.mixins.ApplicationBaseController.gettingDataInSummaryGrid(applicantProfile);
                                    
                                    /************* For Mid-Term Admission Flow call following function *******************/
                                    if((applicantProfile.getApplicationInfo()['applicationStatus']==='MID_TERM_ADMISSION')){
                                    	me.loadMidTermCoursesByApplicationId();
                                    }
                                    Ext.getBody().unmask();
                                }
                            });
                        }
                    }            		
            	}else{
            		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
            	}                
            } else {
            	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
            }
    	}    	
    },
    
    /*
     * This function is used for to get applicant admission form details   
     *
     */
    getApplicantAdmissionDetailsFormData: function(me,applicantAdmissionDetailsForm,addAdmissionJsonObject) {
    	
    	if(applicantAdmissionDetailsForm){
    		var formData=applicantAdmissionDetailsForm.getForm().getValues();
    		if(!isEmpty(formData)){    		
    			addAdmissionJsonObject.advisiorId= (!isNullOrEmpty(formData.advisiorId)) ? formData.advisiorId : null;
    			addAdmissionJsonObject.admissionType = (!isNullOrEmpty(formData.admissionType)) ? formData.admissionType : null;
    			addAdmissionJsonObject.trialStartDate= (!isNullOrEmpty(formData.trialStartDate)) ? formData.trialStartDate :null;
    			addAdmissionJsonObject.trialEndDate=(!isNullOrEmpty(formData.trialEndDate)) ? formData.trialEndDate : null;
    			addAdmissionJsonObject.provisionalLastDate= (!isNullOrEmpty(formData.provisionalLastDate)) ? formData.provisionalLastDate :null;
    			addAdmissionJsonObject.confirmedAdmissionClosureReason = (!isNullOrEmpty(formData.confirmedAdmissionClosureReason)) ? formData.confirmedAdmissionClosureReason : null;
    			addAdmissionJsonObject.trialAdmissionClosureReason = (!isNullOrEmpty(formData.trialAdmissionClosureReason)) ? formData.trialAdmissionClosureReason : null;
    			addAdmissionJsonObject.provisionalAdmissionClosureReason = (!isNullOrEmpty(formData.provisionalAdmissionClosureReason)) ? formData.provisionalAdmissionClosureReason : null;
    			addAdmissionJsonObject = me.getAdmissionClosureStatus(formData.conclusion, addAdmissionJsonObject);
    		}
    	}
    	
    	return addAdmissionJsonObject; 
    }, 
    
    /*
     * This function is used for to get applicant admission form details  for Direct Admission 
     *
     */
    getApplicantDirectAdmissionDetailsFormData: function(me,applicantAdmissionDetailsForm,addAdmissionJsonObject) {
    	
    	if(applicantAdmissionDetailsForm){
    		var admissionWindow=this.getAdddirectadmissionprogramwindow();
    		var formData=applicantAdmissionDetailsForm.getForm().getValues();
    		//var formData=applicantAdmissionDetailsForm.getForm().getValues();
    		if(!isEmpty(formData)){    		
    			addAdmissionJsonObject.advisiorId= (!isNullOrEmpty(formData.advisiorId)) ? formData.advisiorId : null;
    			addAdmissionJsonObject.admissionType = (!isNullOrEmpty(formData.admissionType)) ? formData.admissionType : null;
    			addAdmissionJsonObject.trialStartDate= (!isNullOrEmpty(formData.trialStartDate)) ? formData.trialStartDate :null;
    			addAdmissionJsonObject.trialEndDate=(!isNullOrEmpty(formData.trialEndDate)) ? formData.trialEndDate : null;
    			addAdmissionJsonObject.provisionalLastDate= (!isNullOrEmpty(formData.provisionalLastDate)) ? formData.provisionalLastDate :null;
    			addAdmissionJsonObject.confirmedAdmissionClosureReason = (!isNullOrEmpty(formData.confirmedAdmissionClosureReason)) ? formData.confirmedAdmissionClosureReason : null;
    			addAdmissionJsonObject.trialAdmissionClosureReason = (!isNullOrEmpty(formData.trialAdmissionClosureReason)) ? formData.trialAdmissionClosureReason : null;
    			addAdmissionJsonObject.provisionalAdmissionClosureReason = (!isNullOrEmpty(formData.provisionalAdmissionClosureReason)) ? formData.provisionalAdmissionClosureReason : null;
    			addAdmissionJsonObject = me.getAdmissionClosureStatus(formData.conclusion, addAdmissionJsonObject);
    		}
    	}
    	
    	return addAdmissionJsonObject; 
    },

    /*
     * This function is used for to update admission closure status details
     *  Status are CONFIRMED , DENIED or WITHDRAWN
     */
    updateAdmissionClosureStatus: function(admissionDetailsGrid, admissionClosureWindow, admissionClosureForm, successMessageHeader, successMessage) {
        var me = this;
        var selectedRecordObject = new Object();
        var grdStore = admissionDetailsGrid.getStore();
        var btnConfrimOrWithdraw;
        if(!isNullOrEmpty(this.getAdmissionProgramGrid()))
        {	
         btnConfrimOrWithdraw = this.getAdmissionProgramGrid().down('#btnConfrimOrWithdraw');
        }
        var selectedRecord = admissionDetailsGrid.getSelectionModel().getSelection()[0];
        var formData = admissionClosureForm.getForm().getValues();
        if (!isEmpty(selectedRecord.data) && !isEmpty(formData)) {

            selectedRecordObject.admissionId = (!isNullOrEmpty(selectedRecord.get('id'))) ? selectedRecord.get('id') : null;
            selectedRecordObject.admissionType = (!isNullOrEmpty(selectedRecord.get('admissionType'))) ? selectedRecord.get('admissionType') : null;
            selectedRecordObject.confirmedAdmissionClosureReason = (!isNullOrEmpty(formData.confirmedAdmissionClosureReason)) ? formData.confirmedAdmissionClosureReason : null;
            selectedRecordObject.trialAdmissionClosureReason = (!isNullOrEmpty(formData.trialAdmissionClosureReason)) ? formData.trialAdmissionClosureReason : null;
            selectedRecordObject.provisionalAdmissionClosureReason = (!isNullOrEmpty(formData.provisionalAdmissionClosureReason)) ? formData.provisionalAdmissionClosureReason : null;
            selectedRecordObject = me.getAdmissionClosureStatus(formData.conclusion, selectedRecordObject);

        }
        if (!isEmpty(selectedRecordObject)) {
            var jsonFormatFormData = Ext.encode(selectedRecordObject);
            if (!isNullOrEmpty(jsonFormatFormData)) {
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.APPLICATIONS_ADMISSION_UPDATE_CLOSURE_STATUS, //URL-: rest/admission/updateAdmissionClosureStatus
                    jsonData: jsonFormatFormData,
                    method: 'PUT',
                    success: function(form, action) {
                        grdStore.reload();
                        admissionClosureWindow.close();
                        if(!isNullOrEmpty(btnConfrimOrWithdraw))
                    	{
                    	   btnConfrimOrWithdraw.setDisabled(true);
                    	}
                        showSuccessMessage(successMessageHeader, successMessage);
                    }
                });
            }
        }
    },

    /**
     *method used for to set program group and load grid data with selected program group
     * 
     */
    loadOfferLetterAcceptedProgram: function(me, addProgramWindowGrid, addProgramTabGrid) {            	    	
    	var me = this;
    	var addProgramTabGridStore = addProgramTabGrid.getStore();
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	if (addProgramTabGridStore.data.length > 0) { //More Than One Program
        		try{
            		applicantProfile.getApplicationId();
            	} catch(e){
            		applicantProfile = me.getContentPanel().items.items[0];
            	}
        		if(!isNullOrEmpty(applicantProfile.getApplicationId())){        		
            		addProgramWindowGrid.getStore().getProxy().api.read = SERVERURL.APPLICATIONS_ADMISSION_OFFER_LETTER_ACCEPTED_DATA; //URL - :rest/applicationProgram/findOfferLetterAccepted
            		addProgramWindowGrid.getStore().getProxy().extraParams = {
            			applicationID: applicantProfile.getApplicationId()
            		};
            		addProgramWindowGrid.getStore().load({
                        /*params: {
                            applicationID: applicantProfile.getApplicationId()
                        },*/
            			callback: function(records, operation, success) {
            				if(records.length!=0)
            				{
            					var rowIndex = this.find('id', records[0].data.id);  //where 'id': the id field of your model, record.getId() is the method automatically created by Extjs. You can replace 'id' with your unique field.. And 'this' is your store.
            					addProgramWindowGrid.getView().select(rowIndex);
            					//Show already added programs in disable mode                        	
            					addProgramTabGridStore.each(function(records) {

            						addProgramWindowGrid.getStore().each(function(visitedRecord) {
            							if (selectedRecord.data.programBatchSeatConfigurationId === visitedRecord.data.programBatchSeatConfigurationId) {
            								visitedRecord.data.isAdmissionDone=true;
            								return false;
            							}
            						});
            					});
            				}
            			}
                    });          		                    
            	}        
        	}else{
        		var applicantProfileId;
        		try{
        			applicantProfileId = applicantProfile.getApplicationId();
        		}catch(err){
        			applicantProfile = Ext.ComponentQuery.query('applicantprofile')[0];
        			applicantProfileId = applicantProfile.getApplicationId();
        		}
        		if(!isNullOrEmpty(applicantProfileId)){        		
            		addProgramWindowGrid.getStore().getProxy().api.read = SERVERURL.APPLICATIONS_ADMISSION_OFFER_LETTER_ACCEPTED_DATA; //URL - :rest/applicationProgram/findOfferLetterAccepted
            		addProgramWindowGrid.getStore().getProxy().extraParams = {
            			applicationID: applicantProfileId
            		};
            		addProgramWindowGrid.getStore().load({
            			callback: function(records, operation, success) {
            				if(records.length>0){
            					var rowIndex = this.find('id', records[0].data.id);  //where 'id': the id field of your model, record.getId() is the method automatically created by Extjs. You can replace 'id' with your unique field.. And 'this' is your store.
                		        addProgramWindowGrid.getView().select(rowIndex);
            				}
                        }
                      /*  params: {
                            applicationID: applicantProfile.getApplicationId()
                        }*/
                    });          		                    
            	}        		
        	}        	        	        
        }                   	    	    	        
        
    },

    /*
     * This function is used for to get admission closure staus in (true and false format) details   
     *
     */
    getAdmissionClosureStatus: function(admissionClosureStatus, selectedRecordObject) {
        if (!isNullOrEmpty(admissionClosureStatus)) {
        	var admissionStatus = null;
        	if(admissionClosureStatus.constructor === Array){
        		admissionStatus = admissionClosureStatus[0];
        	}
        	else{
        		admissionStatus = admissionClosureStatus;
        	}
            switch (admissionStatus) {
            case this.CONFIRMED:
                selectedRecordObject.whetherWithdrawl = false;
                selectedRecordObject.whetherDenied = false;
                selectedRecordObject.whetherConfirmed = true;
                break;
            case this.DENIED:
                selectedRecordObject.whetherWithdrawl = false;
                selectedRecordObject.whetherDenied = true;
                selectedRecordObject.whetherConfirmed = false;
                break;
            case this.WITHDRAWN:
                selectedRecordObject.whetherWithdrawl = true;
                selectedRecordObject.whetherDenied = false;
                selectedRecordObject.whetherConfirmed = false;
                break;
            }
        } else {
            selectedRecordObject.whetherWithdrawl = false;
            selectedRecordObject.whetherDenied = false;
            selectedRecordObject.whetherConfirmed = false;
        }
        return selectedRecordObject;
    },
    
    
    /*
     * This function is used for load midterm courses by applicationId    
     *
     */
    loadMidTermCoursesByApplicationId:function(){
    	var me = this;
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e){
        		applicantProfile = me.getContentPanel().items.items[0];
        	}
        	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        		var applicantMidTermMainCoursesGrd = applicantProfile.down('#applicantMidTermMainCoursesGrd');
                if(applicantMidTermMainCoursesGrd){
            		applicantMidTermMainCoursesGrd.getStore().getProxy().api.read=SERVERURL.APPLICATIONS_FINDALL_MIDTERM_COURSES_BY_APPLICATION_ID; //URL-:/rest/admissionProgramCourse/findAllAdmissionProgramCourse
        			applicantMidTermMainCoursesGrd.getStore().load({
                        params: {
                              applicationId: applicantProfile.getApplicationId()
                        }                    			
            		});             
        			
        			applicantMidTermMainCoursesGrd.getStore().on('beforeload', function(store, operation) {
        				if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        					store.proxy.extraParams = {
        							applicationId: applicantProfile.getApplicationId()
                            };	
        				}                                                                        
                    });
                }
        	}        	                               
        }        
    },
    
    
    /**
     * method used for to save mid term main courses
     * 
     */
    saveMidTermCourses: function() {
    	var me=this;
    	var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	var grid = applicantProfile.down('#applicantMidTermMainCoursesGrd');
        	var gridStore=grid.getStore();
        	if(gridStore.data.length>0){
        		var isEmptyStatus=me.checkMidTermStatusAvailability(gridStore);
        		if(!isEmptyStatus){
        			var jsonFormatFormData = me.getJsonDataForMidTermCourses(grid,gridStore,applicantProfile);
                    if (!isNullOrEmpty(jsonFormatFormData)) {
                        Ext.Ajax.request({
                            type: 'rest',                        
                            url: SERVERURL.APPLICATIONS_SAVE_UPDATE_MIDTERM_COURSES, //URL-:rest/admissionProgramCourse/saveOrUpdate
                            jsonData: jsonFormatFormData,
                            method: 'POST',
                            success: function(form, action) {                                                    	
                                showSuccessMessage(getAdmissionTranslation('MID_TERM_COURSES'), getAdmissionTranslation('MID_TERM_COURSES_MSG')); //Mid Term Courses saved successfully						                    
                            }
                        });
                    }
        		}else{
        			showWarningMessage(getAdmissionTranslation('MID_TERM_COURSES'), getAdmissionTranslation('SELECT_MID_TERM_COURSE_STATUS')); //Please Select mid term course status
        		}        		
        	}else{
        		showInfoMessage(getAdmissionTranslation('MID_TERM_COURSES'), getAdmissionTranslation('NO_MID_TERM_COURSES')); //Mid Term Courses are not available
        	}
        }             
    },

    /**
     * This function is used for to create json for Mid Term Courses
     *     
     */
    getJsonDataForMidTermCourses: function(grid,store,applicantProfile) {
        var midTermCoursesArray = new Array(); 
        
        for(var storeCount=0;storeCount<store.data.length;storeCount++){
        	var record=store.data.items[storeCount];
        	if(!isEmpty(record)){
        		var midTermCourseObject=new Object();
        		
        		midTermCourseObject.id=(!isNullOrEmpty(record.get('id'))) ? record.get('id') : null;   
        		midTermCourseObject.applicationId=(!isNullOrEmpty(applicantProfile.getApplicationId())) ? applicantProfile.getApplicationId() : null;
        		midTermCourseObject.period=(!isNullOrEmpty(record.get('period'))) ? record.get('period') : null;
        		midTermCourseObject.courseId=(!isNullOrEmpty(record.get('courseId'))) ? record.get('courseId') : null;
        		midTermCourseObject.courseName=(!isNullOrEmpty(record.get('courseName'))) ? record.get('courseName') : null;
        		midTermCourseObject.description=(!isNullOrEmpty(record.get('description'))) ? record.get('description') : null;
        		midTermCourseObject.grade=(!isNullOrEmpty(record.get('grade'))) ? record.get('grade') : null;
        		midTermCourseObject.marks=(!isNullOrEmpty(record.get('marks'))) ? record.get('marks') : null;
        		midTermCourseObject.status=(!isNullOrEmpty(record.get('status'))) ? record.get('status') : null;
        		
        		midTermCoursesArray.push(midTermCourseObject);
        	}
        }
        
        return Ext.encode(midTermCoursesArray);
    },
    
    /**
     * This function is used for to check mid term status 
     *     
     */
    checkMidTermStatusAvailability: function(store) {
    	var isEmptyStatus=false;    	
    	if(!isEmpty(store.data)){
    		for(var storeCount=0;storeCount<store.data.length;storeCount++){
            	var record=store.data.items[storeCount];
            	if(!isEmpty(record)){        		
            		var statusValue=record.get('status');
            		if(isNullOrEmpty(statusValue) ||  statusValue==='CLICK_HERE'){
            			isEmptyStatus=true;
            			break;
            		}              			
            	}             		
            }
        }
    	                
        return isEmptyStatus;
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var applicantProfile = this.getContentPanelActiveTab();
   		var grid = applicantProfile.down('#admissionDetailGrid');
   		var addProgramButton = grid.down("#btnAddPrograms");//itemId of split button
   		var confrimOrWithdrawButton = grid.down("#btnConfrimOrWithdraw");
   		var btnEdit = grid.down("#btnEdit");
   		
   		
   		addProgramButton.setVisible(false);
   		confrimOrWithdrawButton.setVisible(false);
   		btnEdit.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'EDIT') {
       			if(!isNullOrEmpty(btnEdit)){
       				btnEdit.setVisible(true);//enable btnEdit action button
           		}  	
       		}
       		if (privilege === 'ADDPROGRAM') {
           		if(!isNullOrEmpty(addProgramButton)){
           			addProgramButton.setVisible(true);//enable more action button
           		}        		
           	}else if(privilege === 'CONFIRMWITHDRAWADMISSION'){
           		if(!isNullOrEmpty(confrimOrWithdrawButton)){
           			confrimOrWithdrawButton.setVisible(true);
           		}
           	}
       	});
       },
       
       /**
        * This is used to set values of admission details
        */
       setAdmissionDetailsValue : function(window,formData){
    	   var form = window.down('#admissionDetailsForm');
           toggleReadOnlyFormItems(form.getForm(), true);
           var data = this.createJsonObject(formData);
    	   if(data[0].admissionType === 'Confirmed'){
    		   form.down('#trialAdmissionDateContainer').setVisible(false);
    		   form.down('#provisionalAdmissionPanel').setVisible(false);
    	   }
    	   else if(data[0].admissionType === 'Trial'){
    		   form.down('#trialAdmissionDateContainer').setVisible(true);
        	   form.down('#whetherDenied').setVisible(true);
    		   
    	   }else if(data[0].admissionType === 'Provisional'){
    		   form.down('#provisionalAdmissionPanel').setVisible(true);
    		   form.down('#trialAdmissionDateContainer').setVisible(false);
    	   }
          form.getForm().setValues(data[0]);
          
          if(data[0].admissionType === 'Trial'){
   		   form.getForm().findField('trialStartDate').setValue(dateRender(data[0].trialStartDate));
   		   form.getForm().findField('trialEndDate').setValue(dateRender(data[0].trialEndDate));
          } 
          else if(data[0].admissionType === 'Provisional'){
   		   form.getForm().findField('provisionalLastDate').setValue(dateRender(data[0].provisionalLastDate)); 
   	   	}
       },
       createJsonObject  : function(data){
    	   
    	   var acadLoc = data[0].academy.value + data[0].location.value;
           data[0].acadLoc = acadLoc;
    	   data[0].admissionType = getAdmissionTranslation(data[0].admissionType);
    	   data[0].status = getAdmissionTranslation(data[0].status);
    	   
    	   data[0].programVal = data[0].program.value ;
    	   data[0].batchVal = data[0].batch.value ;
    	   data[0].seatTypeVal = data[0].seatType.value ;
    	   
    	   delete data[0].program ;
    	   delete data[0].batch ;
    	   delete data[0].seatType ;
    	   
    	   return data;
       },
       
      /* 'adddirectadmissionprogramwindow[itemId=AddDirectAdmissionProgramWindow] grid[itemId=applicantAdmissionAddApplicationProgramGrid] combo[itemId=cmbPgmGroup]': {
           select: function(combo, record) {
               var addProgramWindowGrid = this.getAddAdmissionProgramWindow().down('#applicantAdmissionAddApplicationProgramGrid');
               var selectedProgramGroup = record[0].get('id');
               this.mixins.AdmissionFormCommonController.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,false,true);
           }
       },*/
       
       loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
       	var this$ = this;
       	   this$.resetOtherDropdowns(dependentCombo);
           dependentCombo.clearValue();
           dependentCombo.store.removeAll();
           var store = dependentCombo.getStore();
           var id = comboValue;
           if(!isNullOrEmpty(id)){
           	var url = store.getProxy().proxyConfig.api.read;
               if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                   url = url.concat('?' + parameter + '=' + id);
               } else {
                   url = url.concat('?' + parameter + '=' + id);
                   url = url.concat('&' + extraParameter + '=' + extraParamValue);
               }
               store.getProxy().api.read = url;
               store.reload();
           }
       },
       
       resetOtherDropdowns: function(combo) {
       	var form = this.getAdddirectadmissionprogramwindow();
           switch (combo.name) {
           case 'PROGRAM_NAME':
               break;
           case 'BATCH_NAME':
               this.clearCombo(combo, false);
               periodCombo = form.down('combo[name=PERIOD_NAME]');
               this.clearCombo(periodCombo, true);
               sectionCombo = form.down('combo[name=SECTION]');
               this.clearCombo(sectionCombo, true);
               break;
           case 'PERIOD_NAME':
               this.clearCombo(combo, false);
               sectionCombo = form.down('combo[name=SECTION]');
               this.clearCombo(sectionCombo, true);
               break;
           case 'COURSE_NAME':
               this.clearCombo(combo, false);
               sectionCombo = form.down('combo[name=SECTION]');
               this.clearCombo(sectionCombo, true);
               break;
           case 'SECTION':
               this.clearCombo(combo, false);
               break;
           case 'SEAT_TYPE':
               this.clearCombo(combo, false);
               break;
           }
       },
       loadAcadLocCombo: function(combo) {
           var store = combo.getStore();
           store.getProxy().extraParams = {
       		id: this.getCurrentlyLoggedInUser().id
       	};
           
       },
       admissionProgramDataAdd: function(){
    	   var me = this;
    	   var applicationStatus;
    	   var applicantProfile = me.getContentPanelActiveTab();
    	   try{
    		   applicantProfile.getApplicationId();
    	   } catch(e){
    		   applicantProfile = me.getContentPanel().items.items[0];
    	   }
    	   if (applicantProfile) {
    		   if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    			   applicationStatus=applicantProfile.getApplicationInfo()['applicationStatus'];
    		   }
    	   }
    	   var applicationDataObject=applicantProfile.getApplicationDataObject();
    	   if(applicationStatus==='DIRECT_ADMISSION'){
    		   if(applicationDataObject.saleRefType === 'ENQUIRED_EARLIER'){
    			   var window = this.getAddAdmissionProgramWindow();
    			   if (!window) {
    				   window = Ext.widget('addadmissionprogramwindow', {
    					   itemId: 'addAdmissionProgramWindow'
    				   });
    			   }
    			   window.show();
    		   }else{
    			   var window = this.getAdddirectadmissionprogramwindow();
    			   if (!window) {
    				   window = Ext.widget('adddirectadmissionprogramwindow', {
    					   itemId: 'adddirectadmissionprogramwindow'
    				   });
    			   }
    			   window.show();
    		   }
    	   }else{
    		   var window = this.getAddAdmissionProgramWindow();
    		   if (!window) {
    			   window = Ext.widget('addadmissionprogramwindow', {
    				   itemId: 'addAdmissionProgramWindow'
    			   });
    		   }
    		   window.show();
    	   }

//  	   var academyLocationId = this.getCurrentAcademyLocation();
//  	   var store = combo.getStore();
    	   if(Ext.isDefined(me.getAddAdmissionProgramWindow().down('addapplicationprogramform'))){
    		      me.getAddAdmissionProgramWindow().down('addapplicationprogramform').setVisible(false);
    		      }
    	   var academyloactionArray = []
    	   var academyLocationId = this.getCurrentAcademyLocation();
    	   academyloactionArray.push(academyLocationId);
    	   var store = this.getStore('common.ActiveUserStore');
    	   store.getProxy().extraParams = {
    		   academyLocationIds: academyloactionArray
    	   };
    	   store.load();

       },
       admissionProgramDataUpdate: function(){
    	   var me = this;
    	   var applicationStatus;
    	   var applicantProfile = me.getContentPanelActiveTab();
    	   try{
    		   applicantProfile.getApplicationId();
    	   } catch(e){
    		   applicantProfile = me.getContentPanel().items.items[0];
    	   }
    	   if (applicantProfile) {
    		   if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    			   applicationStatus=applicantProfile.getApplicationInfo()['applicationStatus'];
    		   }
    	   }
    	   var portalId = me.getCurrentLoggedPortalId();
    	   if(portalId==6){
    		   var selectedAdmissionProgramGrid = me.getAdmissionProgramGrid();
    	   }else
    	   {
    		   var selectedAdmissionProgramGrid = applicantProfile.down('#admissionDetailGrid');
    	   }
    	  
    	   if (selectedAdmissionProgramGrid.getSelectionModel().getCount() > 0) {
    	   var applicationDataObject=applicantProfile.getApplicationDataObject();
    	   var window = this.getEditAdmissionProgramWindow();
    	   if (!window) {
    		   window = Ext.widget('editadmissionprogramwindow', {
    			   itemId: 'editAdmissionProgramWindow'
    		   });
    	   }
    	   window.show();
    	   var editProgramWindowGrid = window.down('addprogramwindowgrid');
    	   editProgramWindowGrid.down('#quickSearchId').setVisible(false);
    	   editProgramWindowGrid.down('#resetBtn').setVisible(false);
			   var column = Ext.Array.findBy(editProgramWindowGrid.headerCt.getGridColumns(), function(col) {
				   return col.dataIndex === 'schoolAttendanceStartDate';
			   });
			   if (column) {
				   column.editor = null;
				   editProgramWindowGrid.getView().refresh();
			   }
    	   if (applicantProfile) { 
    		   var linkStudentId = applicantProfile.applicationDataObject.linkStudentId;
    		  var editAdmissionProgramWin =  me.getEditAdmissionProgramWindow();
        	   var record = selectedAdmissionProgramGrid.getSelectionModel().getSelection()[0];
        	   var winGridStore = editProgramWindowGrid.getStore();
        	   winGridStore.removeAll();
        	   winGridStore.add(record);
        	   editProgramWindowGrid.getView().select(0);
        	   
        	   if (!isEmpty(record.data) && !isEmpty(record.get('batch'))) {
        		   if (!isNullOrEmpty(record.data.batch.id)) {
        			   var batchId = record.data.batch.id;
        			   var periodCombo = editAdmissionProgramWin.down('#cmbPeriod');
        			   periodCombo.setDisabled(false);
        			   if (periodCombo) {
        				   periodCombo.getStore().load({
        					   params: {
                                   id: batchId
                               },
        					   callback:function(records,response,success){
        						   for(var i in records){
    								   if(record.data.programBatchPeriodConfigurationId==records[i].data.id){
    									   periodCombo.setValue(record.data.programBatchPeriodConfigurationId);
    								   }
    							   }
        					   }
        				   });
        			   }
        			   
        			   var sectionCombo = editAdmissionProgramWin.down('#section');
        			   sectionCombo.setDisabled(false);
        			   if (sectionCombo) {
        				   sectionCombo.getStore().load({
        					   params: {
                                   periodId: record.data.programBatchPeriodConfigurationId
                               },
        					   callback:function(records,response,success){
        						   for(var i in records){
    								   if(record.data.sectionId==records[i].data.id){
    									   sectionCombo.setValue(record.data.sectionId);
    								   }
    							   }
        					   }
        				   });
        			   }
        			   
        			   var advisiorCombo = editAdmissionProgramWin.down('#advisior');
        			   if (advisiorCombo) {
        				   advisiorCombo.getStore().load({
        					   callback:function(records,response,success){
        						   for(var i in records){
    								   if(record.data.advisiorId==records[i].data.id){
    									   advisiorCombo.setValue(record.data.advisiorId);
    								   }
    							   }
        					   }
        				   });
        			   }

        			   var typeOfAdmissionCombo = editAdmissionProgramWin.down('#typeOfAdmission');
        			   if (typeOfAdmissionCombo) {
        				   typeOfAdmissionCombo.getStore().load({
        					   callback:function(records,response,success){
        						   for(var i in records){
        							   if(record.data.admissionType===records[i].data.id){
        								   typeOfAdmissionCombo.setValue(getAdmissionTranslation(record.data.admissionType));
        							   }
        						   }
        					   }
        				   });
        			   }
        			   
        			   var trialAdmissionContainer=editAdmissionProgramWin.down('#trialAdmissionContainer');
        			   var trialStartDate= trialAdmissionContainer.down('#trialStartDate');
        			   var trialEndDate= trialAdmissionContainer.down('#trialEndDate');

        			   var provisionalAdmissionPanel=editAdmissionProgramWin.down('#provisionalAdmissionPanel');
        			   var provisionalLastDate=provisionalAdmissionPanel.down('#provisionalLastDate');
        			   var provisionalAdmissionClosureReason=provisionalAdmissionPanel.down('#provisionalAdmissionClosureReason');

        			   var applicantEditAdmissionForm = editAdmissionProgramWin.down('#applicantEditAdmissionForm');
        			   var trialAdmissionContainer = applicantEditAdmissionForm.down('#trialAdmissionContainer');
        			   var provisionalAdmissionPanel = applicantEditAdmissionForm.down('#provisionalAdmissionPanel');
        			   var typeOfAdmission = record.data.admissionType;
        			   if (typeOfAdmission === 'CONFIRMED') {
        				   trialAdmissionContainer.setVisible(false);
        				   trialAdmissionContainer.setDisabled(true);
        				   provisionalAdmissionPanel.setVisible(false);
        				   provisionalAdmissionPanel.setDisabled(true);

        				   trialStartDate.allowBlank = true;
        				   trialEndDate.allowBlank = true;
        				   provisionalLastDate.allowBlank = true;
        				   provisionalAdmissionClosureReason.allowBlank = true;

        			   } else if (typeOfAdmission === 'TRIAL') {
        				   trialAdmissionContainer.setVisible(true);
        				   trialAdmissionContainer.setDisabled(false);
        				   provisionalAdmissionPanel.setVisible(false);
        				   provisionalAdmissionPanel.setDisabled(true);

        				   provisionalLastDate.allowBlank = true;
        				   provisionalAdmissionClosureReason.allowBlank = true;

        				   trialStartDate.setValue(dateRender(record.data.trialStartDate));
        				   trialEndDate.setValue(dateRender(record.data.trialEndDate));

        				   provisionalLastDate.setValue(dateRender(record.data.provisionalLastDate));
        				   var trialradioGroup = editAdmissionProgramWin.down('#trialRadio');
        				   if (record.data.whetherConfirmed) {
        					   trialradioGroup.items.items[0].setValue(true);
        					   trialradioGroup.items.items[1].setValue(false);
        				   } else if (!record.data.whetherConfirmed) {
        					   trialradioGroup.items.items[0].setValue(false);
        					   trialradioGroup.items.items[1].setValue(true);
        				   }

        			   } else if (typeOfAdmission === 'PROVISIONAL') {
        				   provisionalAdmissionPanel.setVisible(true);
        				   provisionalAdmissionPanel.setDisabled(false);
        				   trialAdmissionContainer.setVisible(false);
        				   trialAdmissionContainer.setDisabled(true);
        				   trialStartDate.allowBlank = true;
        				   trialEndDate.allowBlank = true;
        				   if (provisionalAdmissionClosureReason) {
        					   provisionalAdmissionClosureReason.getStore().load({
        						   callback:function(records,response,success){
        							   provisionalAdmissionClosureReason.setValue(record.data.provisionalAdmissionClosureReason);
        						   }
        					   });
        				   }
        				   provisionalLastDate.setValue(dateRender(record.data.provisionalLastDate));
        				   var radioGroup = editAdmissionProgramWin.down('#provisionalRadio');
        				   if (record.data.whetherConfirmed) {
        					   radioGroup.items.items[0].setValue(true);
        					   radioGroup.items.items[1].setValue(false);
        				   } else if (!record.data.whetherConfirmed) {
        					   radioGroup.items.items[0].setValue(false);
        					   radioGroup.items.items[1].setValue(true);
        				   }

        			   }
        			   var admissiondate = editAdmissionProgramWin.down('#admissiondateEditId');
        			   admissiondate.setValue(dateRender(record.data.admissionDate));
        			   var schoolAttendanceStartDate = editAdmissionProgramWin.down('#schoolAttendanceStartDate');
        			   schoolAttendanceStartDate.setValue(dateRender(record.data.schoolAttendanceStartDate));
        			   editAdmissionProgramWin.down('#editAdmissionBtn').setDisabled(false);
        			   //applicantEditAdmissionForm.isValid();

        		   }
        	   }
        	   selectedAdmissionProgramGrid.getSelectionModel().deselectAll();
        	   if (!isNullOrEmpty(linkStudentId)) {
        		   var isExistingStudent = editAdmissionProgramWin.down('#isExistingStudent');
        		   isExistingStudent.setValue(true);
        	   }
        	   var applicantEditAdmissionForm = editAdmissionProgramWin.down('#applicantEditAdmissionForm');
        	   applicantEditAdmissionForm.getForm().checkValidity();
        	  
    	   }
    	   if(Ext.isDefined(me.getEditAdmissionProgramWindow().down('addapplicationprogramform'))){
  		      me.getEditAdmissionProgramWindow().down('addapplicationprogramform').setVisible(false);
  		      }
       }else{
    	   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));  
       }
       },
       
       /**************Admission Details Tab ********************/
       /*
        * This function is used for to Edit admission details after clicking on Edit Admission button   
        * Admission Types - 1.Confirmed Admission  2.Trial Admission  3.Provisional Admission
        * 
        */
       editAdmission: function(editAdmissionProgramWindow,applicantAdmissionProgramGrid,applicantAdmissionDetailsForm,admissionDetailGrid,applicationId,applicationStatus,applicantProfile) {
    	   var me = this;    	
    	   if(applicantAdmissionProgramGrid){
    		   //var cmbPeriod=applicantAdmissionProgramGrid.down('#cmbPeriod');  old code
    		   var cmbPeriod = editAdmissionProgramWindow.down('#cmbPeriod');  
    		   var admissionDate = editAdmissionProgramWindow.down('#admissiondateEditId');
    		   var cmbProgramGroup =applicantAdmissionProgramGrid.down('#cmbPgmGroup');
    		   var sectionCombo = editAdmissionProgramWindow.down('#section');
    		   var isExistingStudent = editAdmissionProgramWindow.down('#isExistingStudent').getValue();
       		   var existingStudentId = editAdmissionProgramWindow.down('#studentIdHidden').getValue();
    		   var schoolAttendanceStartDate = editAdmissionProgramWindow.down('#schoolAttendanceStartDate');
    		   var record = applicantAdmissionProgramGrid.getSelectionModel().getSelection()[0];
    		   if (!isEmpty(record)) {
    			   if(applicantAdmissionDetailsForm.getForm().isValid()){            		
    				   var editAdmissionJsonObject=new Object();
    				   editAdmissionJsonObject.id=(!isNullOrEmpty(record.get('id')))?record.get('id'):null;
    				   editAdmissionJsonObject.programBatchSeatConfigurationId=(!isNullOrEmpty(record.get('programBatchSeatConfigurationId')))?record.get('programBatchSeatConfigurationId'):null;
    				   editAdmissionJsonObject.academyLocationId=(!isNullOrEmpty(record.get('academyLocationId')))?record.get('academyLocationId'):null;
    				   editAdmissionJsonObject.status="ADMISSION_IN_PROGRESS";         		
    				   editAdmissionJsonObject=me.getApplicantAdmissionDetailsEditFormData(me,applicantAdmissionDetailsForm,editAdmissionJsonObject);

    				   if(cmbPeriod && !isNullOrEmpty(cmbPeriod.getValue())){            			
    					   editAdmissionJsonObject.programBatchPeriodConfigurationId=cmbPeriod.getValue();
    				   }else if(cmbPeriod && isNullOrEmpty(cmbPeriod.getValue())){
    					   showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('SELECT_PERIOD_VALUE')); //Please select period value
    					   return 0;
    				   }             		            		            		            		            	            		

    				   editAdmissionJsonObject.sectionId=sectionCombo.getValue();
    				   editAdmissionJsonObject.admissiondate=admissionDate.getValue();
    				   editAdmissionJsonObject.schoolAttendanceStartDate=schoolAttendanceStartDate.getValue();
    				   if (!isNullOrEmpty(isExistingStudent)) {
    					   editAdmissionJsonObject.isExistingStudent = isExistingStudent;
    					   editAdmissionJsonObject.existingStudentId = existingStudentId;
    				   }
               		
    				   if (!isEmpty(editAdmissionJsonObject)) {
    					   var jsonFormatFormData = Ext.encode(editAdmissionJsonObject);
    					   if (!isNullOrEmpty(jsonFormatFormData)) {
    						   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						   Ext.Ajax.request({
    							   type: 'rest',                                
    							   url: SERVERURL.PATH_UPDATE_APPLICATION_ADMISSION_DETAILS, 
    							   jsonData: jsonFormatFormData,
    							   method: 'POST',
    							   success: function(response, action) {
    								   applicantAdmissionProgramGrid.getSelectionModel().deselectAll();
    								   admissionDetailGrid.getSelectionModel().deselectAll();
    								   admissionDetailGrid.getStore().reload();
    								   editAdmissionProgramWindow.close();                                    
    								   showSuccessMessage(getAdmissionTranslation('EDIT_PROGRAMS'), getAdmissionTranslation('PROGRAM_EDIT_MSG')); //Admission added successfully
    								   me.mixins.ApplicationBaseController.gettingDataInSummaryGrid(applicantProfile);

    								   /************* For Mid-Term Admission Flow call following function *******************/
    								   /*if((applicantProfile.getApplicationInfo()['applicationStatus']==='MID_TERM_ADMISSION')){
    									   me.loadMidTermCoursesByApplicationId();
    								   }*/
    								   Ext.getBody().unmask();
    							   }
    						   });
    					   }
    				   }            		
    			   }else{
    				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_MANDATORY_FIELDS'));
    			   }                
    		   } else {
    			   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    		   }
    	   }    	
       },
       
       /*
        * This function is used for to get applicant admission form details   
       *
       */
      getApplicantAdmissionDetailsEditFormData: function(me,applicantAdmissionDetailsForm,editAdmissionJsonObject) {
      	
      	if(applicantAdmissionDetailsForm){
      		var formData=applicantAdmissionDetailsForm.getForm().getValues();
      		if(!isEmpty(formData)){    		
      			editAdmissionJsonObject.advisiorId= (!isNullOrEmpty(formData.advisiorId)) ? formData.advisiorId : null;
      			editAdmissionJsonObject.admissionType = (!isNullOrEmpty(formData.admissionType)) ? formData.admissionType.toUpperCase() : null;
      			editAdmissionJsonObject.trialStartDate= (!isNullOrEmpty(formData.trialStartDate)) ? formData.trialStartDate :null;
      			editAdmissionJsonObject.trialEndDate=(!isNullOrEmpty(formData.trialEndDate)) ? formData.trialEndDate : null;
      			editAdmissionJsonObject.provisionalLastDate= (!isNullOrEmpty(formData.provisionalLastDate)) ? formData.provisionalLastDate :null;
      			editAdmissionJsonObject.confirmedAdmissionClosureReason = (!isNullOrEmpty(formData.confirmedAdmissionClosureReason)) ? formData.confirmedAdmissionClosureReason : null;
      			editAdmissionJsonObject.trialAdmissionClosureReason = (!isNullOrEmpty(formData.trialAdmissionClosureReason)) ? formData.trialAdmissionClosureReason : null;
      			editAdmissionJsonObject.provisionalAdmissionClosureReason = (!isNullOrEmpty(formData.provisionalAdmissionClosureReason)) ? formData.provisionalAdmissionClosureReason : null;
      			editAdmissionJsonObject = me.getAdmissionClosureStatus(formData.conclusion, editAdmissionJsonObject);
      		}
      	}
      	
      	return editAdmissionJsonObject; 
      },
      showHideExistingStudentDetails: function(obj, newValue, oldValue, saveOrUpdate) {
    	  var $this = this;
    	  var applicationStatus;
    	  var applicantProfile = $this.getContentPanelActiveTab();
    	  var existingStudentDetails = applicantProfile.applicationDataObject.linkStudentId;
    	  
    	  var admissionProgramWindow = $this.getAddAdmissionProgramWindow();
    	  if (saveOrUpdate == 'UPDATE') {
    		  admissionProgramWindow = $this.getEditAdmissionProgramWindow();
    	  }
    	  if (admissionProgramWindow) {
    		  var applicantAddAdmissionForm = admissionProgramWindow.down('#applicantAddAdmissionForm');
    		  if (saveOrUpdate == 'UPDATE') {
    			  applicantAddAdmissionForm = admissionProgramWindow.down('#applicantEditAdmissionForm');
        	  }
    		  var studentIdField = applicantAddAdmissionForm.down('#existingStudentId');
    		  var existingStudentId = applicantAddAdmissionForm.down('#studentIdHidden');
    		  var searchStudentButton = applicantAddAdmissionForm.down('#searchStudentButtonItemId');
    		  if (newValue) {
    			  studentIdField.setVisible(true);
    			  studentIdField.allowBlank = false;
    			  searchStudentButton.setVisible(true);

    			  studentIdField.setFieldLabel(getPersonModuleTranslation('STUDENT_ID')+':'+'<span class="required" style="color:red"> *</span>');
    			  if (!isNullOrEmpty(existingStudentDetails)) {
    				  studentIdField.setValue(existingStudentDetails.code);
    				  existingStudentId.setValue(existingStudentDetails.id);
    				  
				}
    		  }else{
    			  studentIdField.setVisible(false);
    			  studentIdField.allowBlank = true;
    			  searchStudentButton.setVisible(false);
    			  studentIdField.setFieldLabel(getPersonModuleTranslation('STUDENT_ID'));
    			  studentIdField.setValue(null);
    			  existingStudentId.setValue(null);
    		  }
    		  applicantAddAdmissionForm.getForm().checkValidity();
    		 
    	  }
      },
      openExistingStudentPopup : function(saveOrUpdate) {
    	  var window = this.getAddexistingstudenttoadmissionwindow();
		   if (!window) {
			   window = Ext.widget('addexistingstudenttoadmissionwindow', {
				   itemId: 'addexistingstudenttoadmissionwindow'
			   });
		   }
		   window.show();
		   var applicantProfile = this.getContentPanelActiveTab();
		   var applicantPerson = applicantProfile.applicationDataObject.person;
		   if (!isNullOrEmpty(window)) {
			   window.down('#studentName').setValue(applicantPerson.printName);
			   window.down('#nationalId').setValue(applicantPerson.nationalID);
			   window.down('#externalSysRefOneId').setValue(applicantPerson.externalSysRefOne);
			   window.down('#saveOrUpdateHidden').setValue(saveOrUpdate);
			   
		   }
      }
});
