/*
 * @author prathamesh.sheth
 * 
 * This controller is used for applications tab.
 *    
 */
Ext.define('Academia.controller.admission.applications.applicationBase.ApplicationBaseController', {

	extend: 'Academia.controller.personinfo.common.PersonCommonController',

    alias: "widget.applicationbasecontroller",
    
    mixins: {
 		AdmissionFormCommonController: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
 		PersonDetailsLinkPanel:'Academia.view.personinfo.common.PersonDetailsLinkPanel',
 		ButtonPanelConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration', 		
 		LinkPanelConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
 		AppProgMainGridToolBarButtonConfiguration:'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.AppProgMainGridToolBarButtonConfiguration'
    },
 
    stores: [
    					'Academia.store.common.AcademyStore', 
    					'Academia.store.enquiry.FollowUpUserWithDepartment',
    					'Academia.store.organization.academylocations.LocationByAcademyStore', 
    					'admission.applicationFormSale.ActiveProgramGroupComboStore',
    					'Academia.store.admission.applicationFormSale.ProgramGroupComboStore', 
    					'Academia.store.common.ProgramStore', 'common.IntakeYearStore',
    					'Academia.store.admission.admissionCycle.SelectionProcesses',
    					'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore', 
    					'admission.applications.applicationBase.ApplicationStatusComboStore', 
    					'admission.applications.applicationBase.ApplicationProgramStatusComboStore', 
    					'admission.applications.applicationBase.ApplicationOfferStatusComboStore', 'common.DocumentStatusCSMStore','enquiry.EligibilityRecommendationForAdmissionSetupStore',
    					'admission.applications.applicationBase.AdmissionCommitFeeStatusStore',
    					'admission.applications.applicationBase.AdmissionStatusComboStore', 
    					'admission.applications.applicationBase.ApplicationListActionComboStore',
    					'Academia.store.common.BatchesByProgramId',
    					'admission.applications.applicationBase.ApplicationStageStatusComboStore',
    					'Academia.store.admission.admissionCycle.SelectionProcessStageStore','Academia.store.common.SeatTypesByBatchId',
    					'enquiry.EnquiryCodeSearchStore','user.UserAcademyLocationStore','feeandpayment.managebill.Applicant',
    					'enquiry.EnquiryCodeSearchByApplicationMadeForEnqStore',
    					'personinfo.faculty.FacultySurveyStr','enquiry.EnquiryStudentSmartSearchStore','importutility.ModuleName',
    					'admission.applications.applicationBase.ApplicationSourceTypeComboStore',
    					'importutility.ImportApplications','program.ProgramByGroupIdStore',
    					'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore',
    					'enquiry.OpenEnquiryCodeSearchAccessibleALStore','enquiry.EnquiryStudentSmartSearchAccessibleALStore','criteriabuilder.userquicksearch.QuickSearchName',
    					'admission.applications.applicationBase.BulkDocumentGroupStore',
    					'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
    					'importutility.ImportApplicantStore',
    					'importutility.ImportApplicaitonsNewStore',
    					'importutility.ImportBulkOfferStatusStore',
    					'admission.applications.applicationBase.OfferLetterDetailsStore',
    					'common.CountryStore','admission.applications.applicantProfileBase.ApplicationListExportReportStore','campaignnew.CampaignNameFilterStore',
    		            'Academia.store.common.RegistrationTypeStore','common.AssignReviewersToApplicationsStore',
    		            'campaignnew.RegistrationTypeStore','campaignnew.ModeOfDeliveryStore','common.ModeOfDeliveryStore','common.RegistrationTypeStore',
    		            'importutility.ImportApplicantPastHistoryTypeStore',
    		            'Academia.store.enquiry.ProgramBatchSeatTypeStore','setup.templatemapping.DocumentRequesDGMListFaculty',
    		            'personinfo.common.documents.DocumentStore','admission.applications.applicantdocuments.ApplicantDocumentStore',
    		            'common.DocumentStatusCSMAllStore','Academia.store.admission.selectionStage.SelectionStageFromSeatType',
    		            'Academia.store.admission.applications.applicationBase.FinalApprovalStore','common.IDTypeStore','Academia.store.department.DepartmentAcademyLocationWiseStore',
    		            'admission.applications.applicantdocuments.ApplicantAllDocumentStore',
    		            'admission.applications.applicationBase.ApplicationStatusRelationshipLoaderStore',
    		            'Academia.store.program.ConfiguredBatchListStore','Academia.store.program.ConfiguredSeatTypeListStore','enquiry.PopiaStatusStore',
    		            'Academia.store.program.ConfiguredProgramListStore','common.PopiaStatusDropdownValue','common.RaisePriorityStore',
    		            'enquiry.CurrentActivityStore','admission.applications.applicantProfileBase.ReasonsForWithdrawalComboStore',
    		            'importutility.ImportApplicationLoderStore','admission.applications.applicantdocuments.EligibilityPointerStore',
    		            'common.PendingOfferLetterCSMStore','common.OfferLetterAcceptedByStore','common.IntakeYearStore','program.ProgramGroupByAccessibleALStore',
    		            'admission.applications.applicationBase.ApplicationStatusLoaderComboStore','enquiry.AcademicBatchOnALIntakePeriodsStores',
    		            'common.SeatTypeByBatchIds','program.ProgramByProgramGroupIdsStore'
    			],

    views: [
            			'Academia.view.personinfo.common.PersonDetailsLinkPanel',
    					'Academia.view.criteriabuilder.grid.SearchResultGrid', 
    					'admission.applications.applicationBase.Applications', 
    					'admission.applications.applicationBase.QuickSearchPanel', 
    					'admission.applications.applicationBase.BasicSearch', 
    					'admission.applications.applicationBase.ProgramSearch', 
    					'admission.applications.applicationBase.AddAdmissionWindow', 
    					'admission.applications.applicationBase.ApplicantSearchComponent', 
    					'admission.applications.applicantProfileBase.ApplicantProfile',
    					'admission.applications.applicationBase.ApplicationSendSurvey',
    					'admission.applications.applicationBase.ApplicationUploaddownloadStructure',
    					'admission.applications.applicationBase.BulkOfferStatusUpdateStructure',
    					'admission.applications.applicationBase.ApplicationsDownloadForm',
    					'admission.applications.applicationBase.BulkOfferStatusUpdateDownloadForm',
    					'admission.applications.applicationBase.BulkOfferStatusUpdateUploadForm',
    					'admission.applications.applicationBase.ApplicationsUploadForm',
    					'importutility.ImportByModule.ImportListApplicant',
    					'importutility.ImportByModule.ImportListBulkOfferStatusUpdate',
    					'admission.applications.applicationBase.ApplicationsUploaddownloadStructure',
    					'admission.applications.applicationBase.ImportApplicationsDownloadForm',
    					'admission.applications.applicationBase.ImportApplicationsUploadForm',
    					'importutility.ImportByModule.ImportListApplications',
    					'admission.applications.applicationBase.ApplicantSendMessage',
    					'admission.applications.applicationBase.DuplicateApplicationDetails',
    					'admission.applications.applicationBase.ApplicantStaticDocumentAttachmentGrid',
    					'admission.applications.applicationBase.ApplicationsNewUploaddownloadStructure',
    					'admission.applications.applicationBase.ImportApplicationsNewUploadForm',
    					'admission.applications.applicationBase.ImportApplicationsNewDownloadForm',
    					'importutility.ImportByModule.ImportListNewApplicant',
    					'admission.applications.applicationBase.BulkDownloadDocumentWin',
    					'admission.applications.applicantProfileBase.AcceptOfferLetterWin',
    					'admission.applications.applicantProfileBase.OfferAcceptanceWin',
    					'admission.applications.applicantProfileBase.DeclineOfferLetterWin',
    					'UploadOptionRadioGroup','admission.applications.applicationBase.OfferLetterDetailsWindow',
    					'admission.applications.applicantProfileBase.ApplicationListExportReporWidow',
    					'admission.applications.applicationBase.ReassignApplicationForm',
    					'admission.applications.applicationBase.ApplicationAndAdmissionCommentForm',
    					'admission.applications.applicantProfileBase.ApplicationListExportAlWindow',
    					'admission.applications.applicationBase.ApplicationReviewWindow',
    					'common.ScrollableAlertWindow',
    					'admission.applications.applicationBase.ApplicantPastHistoryUploadDownloadStructure',
    					'importutility.ImportByModule.ImportListApplicantHistoryLoader',
    					'admission.applications.applicationBase.ApplicantCompetitivePastHistoryLoaderUploadForm',
    					'admission.applications.applicationBase.ApplicantCompetitivePastHistoryloaderDownloadForm',
    					'admission.applications.applicantProfileBase.ApplicationFormPrintWindow','personinfo.faculty.FacultyRequestDocumentWidow',
    					'UploadOptionRadioGroup','admission.applications.applicationBase.DocumentStatusWindow',
    					'admission.applications.applicationBase.DocumentStatusPopupGrid',
    					'admission.applications.applicationBase.AdmissionApprovalDetailsAdmWindow',
    					'admission.applications.applicationBase.BulkApplicationRejectionWindow',
    					'admission.applications.applicationBase.ReassignEscalationForm',
    					'admission.applications.applicationBase.ImportApplicantRelationshipStructure',
    					'admission.applications.applicationBase.ImportApplicantRelationshipUploadForm',
    					'admission.applications.applicationBase.ImportApplicantRelationshipDownloadForm',
    					'importutility.ImportByModule.ImportApplicantRelationshipGrid','admission.applications.applicationBase.ApplicationPopiaOption',
    					'admission.applications.applicationBase.RaisePriorityWindow','admission.applications.applicationBase.MarkApplicationOffTrackWindow',
    					'Academia.view.admission.applications.applicationBase.ImportTabStructure','admission.applications.applicationBase.EligibilityPointerWindow',
    					'admission.applications.applicationBase.EligibilityPointerPopupGrid','admission.applications.applicationBase.PendingOfferFlagWindow','admission.applications.applicationBase.ImportBulkAdmissionApprovalUploadForm','admission.applications.applicationBase.ImportBulkAdmissionApprovalDownloadForm',
    					'admission.applications.applicationBase.ImportBulkAdmissionApprovalUploadDownloadStructure','importutility.ImportByModule.ImportListAdmissionApproval',
    					'admission.applications.applicationBase.BulkUpdateApplicationStatusDownloadForm','admission.applications.applicationBase.BulkUpdateApplicationStatusUploadForm',
    					'importutility.ImportByModule.BulkUpdateApplicationStatusGrid','admission.applications.applicationBase.BulkUpdateApplicationStatusUploadDownloadStructure'
    			],

    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },
    {
        ref: 'applicationsListBasicSearchForm',
        selector: 'quicksearchpanel form[itemId=basicSearchPanel]'
    }, {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=applicationsListGrid]'
    }, {
    	 ref: 'basicsearch',
         selector: 'basicsearch'
    }, {
        ref: 'duplicateapplicationdetails',
        selector: 'searchresultgrid[itemId=duplicateapplicationdetailsgrid]'
    },{
        ref: 'searchresultgrid',
        selector: 'searchresultgrid[itemId=duplicateapplicationdetailsgrid]'
    },{
        ref: 'searchresultgrid',
        selector: 'searchresultgrid'
    }, {
        ref: 'addAdmissionWindow',
        selector: 'addadmissionwindow[itemId=addAdmissionWindow]'
    }, {
        ref: 'searchWindow',
        selector: 'addadmissionwindow[itemId=addAdmissionWindow]'
    }, {
        ref: 'applicantSearchForm',
        selector: 'addadmissionwindow[itemId=addAdmissionWindow] form[itemId=applicantSearchComponent]'
    },{
        ref: 'searchPanel',
        selector: 'searchpanel[itemId=searchPanel]'
    },{
    	ref: 'searchGridWindow',
    	selector: 'addadmissionwindow[itemId=addAdmissionWindow] grid[itemId=searchGrid]'
    },{
    	ref :'applicantsendmessage',
    	selector : 'applicantsendmessage[itemId=applicationSendMessageWindow]'
    },{
    	ref :'duplicateapplicationdetails',
    	selector : 'duplicateapplicationdetails'
    },{
    	ref :'applicationsendsurvey',
    	selector : 'applicationsendsurvey'
    },{
    	ref :'applicationSendsurvey',
    	selector : 'applicationsendsurvey form'
    },{
    	ref : 'applicationsuploadform',
    	selector :'applicationsuploadform'
    },{
    	ref : 'applicationsdownloadform',
    	selector : 'applicationsdownloadform'
    },{
    	ref : 'importapplicationsdownloadform',
    	selector : 'importapplicationsdownloadform'
    },{
    	ref : 'importapplicationsuploadform',
    	selector : 'importapplicationsuploadform'
    },{
    	ref : 'importlistapplicant',
    	selector : 'importlistapplicant'
    },{
    	ref : 'importlistapplications',
    	selector : 'importlistapplications'
    },{
        ref: 'adminresetpasswordwindow',
        selector: 'adminresetpasswordwindow[itemId=applicantlistadminresetpasswordwindow]'
    },{
        ref: 'offerletterdetailswindow',
        selector: 'offerletterdetailswindow[itemId=applicantofferletterdetailswindow]'
    },{
        ref: 'applications',
        selector: 'applications'
    },{
    	ref :'applicantstaticdocumentattachmentgrid',
    	selector : 'applicantstaticdocumentattachmentgrid'
    },{
    	ref :'applicationsnewuploaddownloadstructure',
    	selector : 'applicationsnewuploaddownloadstructure'
    },{
    	ref :'importapplicationsnewuploadform',
    	selector : 'importapplicationsnewuploadform'
    },{
    	ref :'importapplicationsnewdownloadform',
    	selector : 'importapplicationsnewdownloadform'
    },{
    	ref :'importlistnewapplicant',
    	selector : 'importlistnewapplicant'
    },{
        ref: 'bulkdownloaddocumentwin',
        selector: 'bulkdownloaddocumentwin[itemId=applicantbulkdownloaddocumentwin]'
    }, {
        ref: 'selectionSnapShotGrid',
        selector: 'selectionsnapshotgrid[itemId=selectionSnapShotGrid]'
    }, {
        ref: 'acceptofferletterwin',
        selector: 'acceptofferletterwin'
    }, {
        ref: 'offeracceptancewin',
        selector: 'offeracceptancewin'
    }, {
        ref: 'declineofferletterwin',
        selector: 'declineofferletterwin'
    },{
    	ref : 'applicationsUploaduploadoptionradiogroup',
    	selector : 'uploadoptionradiogroup[itemId=applicationsUploadOptionRadioGroupItemId]'
    },{
    	ref : 'importapplicationsUploaduploadoptionradiogroup',
    	selector : 'uploadoptionradiogroup[itemId=importapplicationsUploadOptionRadioGroupItemId]'
    },{
    	ref : 'importapplicationsnewUploaduploadoptionradiogroup',
    	selector : 'uploadoptionradiogroup[itemId=importapplicationsnewUploadOptionRadioGroupItemId]'
    },{
    	ref : 'applicationlistexportreporwidow',
    	selector : 'applicationlistexportreporwidow[itemId=applicationlistexportreporwidow]'
    },{
    	ref :'reassignapplicationform',
    	selector : 'reassignapplicationform'
    },{
    	ref : 'applicationlistexportalwindow',
    	selector : 'applicationlistexportalwindow[itemId=applicationlistexportalwindow]'
    },{
    	ref : 'applicationreviewwindow',
    	selector : 'applicationreviewwindow'
    },{
    	ref:'applicationformprintwindow',
    	selector:'applicationformprintwindow'
    },{
    	ref :'applicationformprintwindow',
    	selector : 'applicationformprintwindow form'
    },{
    	ref:'scrollablealertwindow',
    	selector:'scrollablealertwindow'
    },{
    	ref :'applicantpasthistoryuploaddownloadstructure',
    	selector : 'applicantpasthistoryuploaddownloadstructure'
    },{
    	ref :'applicantcompetitivepasthistoryloaderuploadform',
    	selector : 'applicantcompetitivepasthistoryloaderuploadform'
    },{
    	ref :'applicantcompetitivepasthistoryloaderdownloadform',
    	selector : 'applicantcompetitivepasthistoryloaderdownloadform'
    },{
    	ref : 'importlistapplicanthistoryloader',
    	selector : 'importlistapplicanthistoryloader'
    },{
    	ref : 'applicantpasthistoryuploadoptionradiogroup',
    	selector : 'uploadoptionradiogroup[itemId=applicantPastHistoryUploadOptionRadioGroupItemId]'
    },{
    	ref :'facultyrequestdocumentwidow',
    	selector : 'facultyrequestdocumentwidow[itemId=applicantRequestdocumentId]'
    },{
    	ref: 'documentstatuswindow',
        selector: 'documentstatuswindow[itemId=applicantdocumentstatuspopupwindow]'
  	},{
 		ref: 'bulkapplicationrejection',
 		selector: 'bulkapplicationrejection'
    },{
 		ref: 'applicationandadmissioncommentform',
 		selector: 'applicationandadmissioncommentform'
 	},{
    	ref :'reassignescalationform',
    	selector : 'reassignescalationform'
    },{
 		ref: 'applicationandadmissioncommentform',
 		selector: 'applicationandadmissioncommentform'
 	},{
    	ref :'reassignescalationform',
    	selector : 'reassignescalationform'
    },{
 		ref: 'applicationandadmissioncommentform',
 		selector: 'applicationandadmissioncommentform'
 	},{
    	ref :'reassignescalationform',
    	selector : 'reassignescalationform'
    },{
 		ref: 'applicationandadmissioncommentform',
 		selector: 'applicationandadmissioncommentform'
    },{
 		ref: 'bulkofferstatusupdatestructure',
 		selector: 'bulkofferstatusupdatestructure'
    },{
 		ref: 'bulkofferstatusupdatedownloadform',
 		selector: 'bulkofferstatusupdatedownloadform'
    },{
 		ref: 'bulkofferstatusupdateuploadform',
 		selector: 'bulkofferstatusupdateuploadform'
    },{
 		ref: 'importlistbulkofferstatusupdate',
 		selector: 'importlistbulkofferstatusupdate'
    },{
    	ref : 'importapplicantrelationshipuploadform',
    	selector :'importapplicantrelationshipuploadform'
    },{
    	ref : 'importapplicantrelationshipdownloadform',
    	selector : 'importapplicantrelationshipdownloadform'
    },{
    	ref : 'importapplicantrelationshipgrid',
    	selector : 'importapplicantrelationshipgrid'
    },{
 		ref: 'applicationpopiaoption',
 		selector: 'applicationpopiaoption'
    }, {
 		ref: 'pandadocpopup',
 		selector: 'pandadocpopup'
    },{
        ref: 'documentstatuspopupgrid',
        selector: 'documentstatuspopupgrid'
    },{
    	ref: 'documentpreviewwindow',
    	selector: 'documentpreviewwindow'
    },{
    	ref :'raiseprioritywindow',
    	selector : 'raiseprioritywindow[itemId=raiseprioritywindowId]'
    },{
    	ref :'markapplicationofftrackwindow',
    	selector : 'markapplicationofftrackwindow[itemId=markapplicationofftrackwindowId]'
    },{
    	ref :'importtabstructure',
    	selector : 'importtabstructure'
    },{
    	ref: 'eligibilitypointerwindow',
        selector: 'eligibilitypointerwindow[itemId=applicanteligibilitypointerpopupwindow]'
  	},{
        ref: 'eligibilitypointerpopupgrid',
        selector: 'eligibilitypointerpopupgrid'
    },{
    	ref :'pendingofferflagwindow',
    	selector : 'pendingofferflagwindow[itemId=pendingofferflagwindowId]'
    },{
    	ref :'applicationuploaddownloadstructure',
    	selector : 'applicationuploaddownloadstructure]'
    },{
        ref: 'importbulkadmissionapprovaldownloadform',
        selector: 'importbulkadmissionapprovaldownloadform[itemId=importbulkadmissionapprovaldownloadformItemId]'
    },{
    	ref :'importbulkadmissionapprovaluploadform',
    	selector : 'importbulkadmissionapprovaluploadform[itemId=importbulkadmissionapprovaluploadformItemId]'
    },{
    	ref :'uploadoptionradiogroup',
    	selector : 'uploadoptionradiogroup[itemId=importBulkAdmissionUploadOptionRadioGroupItemId]'
    },{
    	ref :'importlistadmissionapproval',
    	selector : 'importlistadmissionapproval[itemId=importlistadmissionapprovalId]'
    },{
        ref :'applicantprofile',
        selector : 'applicantprofile'
    },{
    	ref : 'importbulkadmissionuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=importBulkAdmissionUploadOptionRadioGroupItemId]'
    },{
    	ref : 'bulkupdateapplicationsstatusuploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=bulkUpdateApplicationStatusUploadOptionRadioGroupItemId]'
    },{
        ref: 'bulkupdateapplicationstatusdownloadform',
        selector: 'bulkupdateapplicationstatusdownloadform[itemId=bulkupdateapplicationstatusdownloadformItemId]'
    },{
    	ref :'bulkupdateapplicationstatusuploadform',
    	selector : 'bulkupdateapplicationstatusuploadform[itemId=bulkupdateapplicationstatusuploadformItemId]'
    },{
    	ref :'bulkupdateapplicationstatusgrid',
    	selector : 'bulkupdateapplicationstatusgrid[itemId=bulkupdateapplicationstatusgridId]'
    }
  	/*,{
		ref : 'applicantpasthistoryinneruploadoptionradiogroup',
		selector : 'uploadoptionradiogroup[itemId=applicantPastHistoryUploadOptionRadioGroupItemId]'
	}*/],
    config: {
    	APPLICANT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_PRIVILEGES'),
    	APPLICANT_DUPLICATE_GRID_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_DUPLICATE_GRID_PRIVILEGES'),
    	//APPLICATIONS_ADMISSION_IMPORT_UTILITY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATIONS_ADMISSION_IMPORT_UTILITY_PRIVILEGES')
    	APPLICANT_OFFER_LETTER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_OFFER_LETTER_PRIVILEGES'),
      	CORE_ERP_LOADER_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CORE_ERP_LOADER_PRIVILEGES'),
      	APPLICANT_SELECTION_SNAPSHOT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_SELECTION_SNAPSHOT_PRIVILEGES'),
      	APPLICATION_ELIGIBILITY_CALCULATION_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_ELIGIBILITY_CALCULATION_DETAILS_PRIVILEGES')
    },
    init: function(application) {
    
    	 this.DIRECT_ADMISSION = 'DIRECT_ADMISSION';
         this.MID_TERM_ADMISSION = 'MID_TERM_ADMISSION';
         this.NEW_APPLICATION = 'NEW_APPLICATION';
         this.FORM_SOLD_APPLICATION = 'FORM_SOLD_APPLICATION';

        this.control({
        	'searchresultgrid[itemId=applicationsListGrid]': {
        		render: function(grid) {
        			this.gridRenderFunction(grid);
        				// Bug : V2D-92517
        		        var ResultGrid = this.getSearchResultGrid();
        		        var buttonsToolBar = ResultGrid.query('toolbar')[0];
        		        buttonsToolBar.query('#exportToPdfBtn')[0].setDisabled(true);
        		        buttonsToolBar.query('#exportToPdfBtn')[0].setDisabled(true);
        			//var basicSearchForm=this.getApplicationsListBasicSearchForm();
        			//if(basicSearchForm){
        			//	basicSearchForm.down('#applicationsListBasicSearchBtn').fireEvent('click');
        			//}     
        			this.genericCBGridAccessControlValidation(grid, this.getAPPLICANT_PERMISSIONS());
        			this.disableMoreActionPivileges(grid,this.getAPPLICANT_PERMISSIONS());
        			if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
        				addBtn=grid.down('#searchResultGridBtnAdd');
        				addBtn.setVisible(false);
        			}
        			var grid = this.getSearchResultGrid();
        			grid.down('#reviewApplicationItemId').setDisabled(true);
        			grid.down('#calculateExamAggregateItemId').setDisabled(true);
        			grid.down('#documentRequest').setDisabled(true);
        			grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);

        		},
        		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts) {
               	 this.showEnquiryFormFromLink(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);               	
                },
        		select:function(rowModel, record, index, eOpts ){
        			var me=this;                	
        			if(!isEmpty(record)){                		            	        
        				var applicationId = record.get('APPLICATION_PRIMERY_ID');
        				var applicationStatus = record.get('APPLICATION_STATUS');
        				var programStatus = record.get('PROGRAM_STATUS');
        				var admissionStatus = record.get('ADMISSION_STATUS');
        				var searchResultGrid=me.getSearchResultGrid();
        				me.mixins.AppProgMainGridToolBarButtonConfiguration.enableDisableToolBarButtons(applicationId,searchResultGrid,applicationStatus,programStatus,admissionStatus);
        			}                	
        		},
        		select: function(grid, record, index, eOpts) {
        			var ResultGrid = this.getSearchResultGrid();
        			var gridCombo = ResultGrid.down('#applicationListAction');
        			gridCombo.reset();
        			var applStatus = record.get('APPLICATION_STATUS');
        			var prgmStatus = record.get('PROGRAM_STATUS');
        			var externalUserId = record.get('EXTERNAL_USER_ID');
        			var applicationSource = record.get('APPLICATION_CREATION_SOURCE');
        			var isOfferLetterApplicable = record.get('IS_OFFER_LETTER_APPLICABLE');
        			ResultGrid.down('#reactivateApplicationItemId').setDisabled(true);
        			ResultGrid.down('#printOfferLetterWordsItemId').setDisabled(true);
        			if ((ResultGrid.getSelectionModel().getCount() == 1) && !isNullOrEmpty(externalUserId)) {
        				
        				//ResultGrid.down('#applicationListAction').setDisabled(false);
        				ResultGrid.down('#offerLetterDetailsItemId').setDisabled(true);
        				
        				ResultGrid.down('#resetButtonItemId').setDisabled(false);
        				//ResultGrid.down('#offerLetterDetailsItemId').setDisabled(false);
        				
        				if( prgmStatus == "OFFER_LETTER_ISSUED" || prgmStatus == "OFFER_LETTER_ACCEPTED" ||  prgmStatus == "PROVISIONAL_OFFER_ISSUED"){
        					if( isOfferLetterApplicable == 'Applicable' ){
        						ResultGrid.down('#offerLetterDetailsItemId').setDisabled(false);
        					}
        				}
        				
        				if( prgmStatus == "ADMITTED"){
        					if( applicationSource == "Direct Admission" || applicationSource == "" || applicationSource == "Mid term admission" ){
        						ResultGrid.down('#offerLetterDetailsItemId').setDisabled(true);
        					} else {
        						if( isOfferLetterApplicable == 'Applicable' ){
        							ResultGrid.down('#offerLetterDetailsItemId').setDisabled(false);
        						}
        					}
        				}
        				
        				if(applStatus == 'REJECTED' || applStatus == 'WITHDRAWN') {
        					ResultGrid.down('#reactivateApplicationItemId').setDisabled(false);
        				}        				
        			}else{
        				ResultGrid.down('#resetButtonItemId').setDisabled(true);
        				ResultGrid.down('#offerLetterDetailsItemId').setDisabled(true);
        			//	ResultGrid.down('#applicationListAction').setDisabled(true);
        			}
        			
        			if (prgmStatus == 'OFFER_LETTER_DUE' || prgmStatus == 'PROVISIONAL_OFFER_DUE') {
        				gridCombo.store.clearFilter(true);
        				gridCombo.store.clearGrouping();
        				gridCombo.store.filter({
        					filterFn: function(record) {
        						var flag = true;
        						if (record.get('name') == 'ACCEPT_OFFER_LETTER' || record.get('name') == 'REJECT_OFFER_LETTER') {
        							flag = false;
        						} else {
        							flag = true;
        						}
        						return flag;
        					}
        				}, this);
        			} else if (prgmStatus == 'OFFER_LETTER_ISSUED' || prgmStatus == 'PROVISIONAL_OFFER_ISSUED' || prgmStatus == 'OFFER_EXPIRED'
        				|| prgmStatus == 'PROVISIONAL_OFFER_EXPIRED') {
        				gridCombo.store.clearFilter(true);
        				gridCombo.store.clearGrouping();

        				if(applStatus =='APPROVED'){
        					gridCombo.store.filter({
        						filterFn: function(record) {
        							var flag = true;
        							if (record.get('name') == 'ISSUE_OFFER_LETTER') {
        								flag = true;
        							} else {
        								flag = true;
        							}
        							return flag;
        						}
        					}, this);
        				}
        				else{
        					gridCombo.store.filter({
        						filterFn: function(record) {
        							var flag = true;
        							if (record.get('name') == 'ISSUE_OFFER_LETTER') {
        								flag = false;
        							} else {
        								flag = true;
        							}
        							return flag;
        						}
        					}, this);
        				}

        			} else if (prgmStatus == 'OFFER_LETTER_REJECTED' || prgmStatus == 'PROVISIONAL_OFFER_REJECTED') {
        			    gridCombo.store.clearFilter(true);
        			    gridCombo.store.clearGrouping();

        			    if (applStatus == 'APPROVED') {
        			        gridCombo.store.filter({
        			            filterFn: function(record) {
        			                var flag = true;
        			                if (record.get('name') == 'REJECT_OFFER_LETTER') {
        			                    flag = true;
        			                } else {
        			                    flag = true;
        			                }
        			                return flag;
        			            }
        			        }, this);
        			    } else {
        			        gridCombo.store.filter({
        			            filterFn: function(record) {
        			                var flag = true;
        			                if (record.get('name') == 'REJECT_OFFER_LETTER') {
        			                    flag = false;
        			                } else {
        			                    flag = true;
        			                }
        			                return flag;
        			            }
        			        }, this);
        			    }

        			} else if((prgmStatus !== 'OFFER_LETTER_ISSUED' || prgmStatus !== 'OFFER_LETTER_DUE' || prgmStatus != 'PROVISIONAL_OFFER_ISSUED' || prgmStatus != 'PROVISIONAL_OFFER_DUE'
        				|| prgmStatus !== 'OFFER_EXPIRED' || prgmStatus !== 'PROVISIONAL_OFFER_EXPIRED')){
        				gridCombo.store.clearFilter(true);
        				gridCombo.store.clearGrouping();
        				gridCombo.store.filter({
        					filterFn: function(record) {
        						var flag = true;
        						if (record.get('name') != 'ISSUE_OFFER_LETTER'&& record.get('name') != 'ACCEPT_OFFER_LETTER'
        							&& record.get('name') != 'REJECT_OFFER_LETTER') {
        							flag = true;
        						} else {
        							flag = false;
        						}
        						return flag;
        					}
        				}, this);
        			}
        		},
	         	selectionchange: function(column, selected,eOpts ){
                	this.disableApplicationGridExtraButton(column,selected);                	
                },
                afterrender:function(grid){
        			var me = this;
        			me.addDataGridConfigButton(grid, me.getAPPLICANT_PERMISSIONS());
        		}
        	},
        	'documentstatuspopupgrid': {
        		cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
        			 var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
        			 if(columnName=='documentType'){
        				 if (e.target.tagName == 'A') {
             				this.cellClickApplicantDocumentGrid(grid, td, cellIndex, record, tr, rowIndex, e, eOpts);
             			} 
        			 }
        			 
        				 
                		 if(e.target.tagName == "A" &&(columnName == "previewDoc") ){
                 			var previewWindow = this.getDocumentpreviewwindow();
     						if (!previewWindow) {
     							Ext.widget('documentpreviewwindow', {
     								documentRecord: record,
     								width: '100%',
     								height: Ext.getBody().getHeight(),
     								itemId: 'appDocPreviewWindow'
     							});
     							previewWindow = this.getDocumentpreviewwindow();
     						}

     						previewWindow.show();
                 		}
        		},
        	},
        	'documentpreviewwindow[itemId=appDocPreviewWindow]':{
            	afterrender: function(win){
            		var me = this;
            		var documentRecord = win.documentRecord;
            		var documentId = documentRecord.data.documentId;
            		var id = documentRecord.data.id;
            		var fileExtension = documentRecord.data.path.split('.').pop();
            		win.setTitle(documentRecord.data.documentName);
            		if(!isNullOrEmpty(documentId) && documentId){
            				Ext.Ajax.request({
            					type: 'rest',
            					url: SERVERURL.PATH_GET_BASE64_DOCUMENT_BY_DOCUMENT,
            					params: {
            						documentId: documentId
                                },
            					method: 'GET',
            					success: function(res, action) {
            						var responseTxt = res.responseText;
            						if(responseTxt != ''){
                						if(fileExtension.toUpperCase() == "PDF"){
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
                						}
                						else{
                							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
                						}
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
            						}
            					}
            				});
            		}else if(!isNullOrEmpty(id) && id){
        				Ext.Ajax.request({
        					type: 'rest',
        					url: SERVERURL.PATH_GET_BASE64_DYNAMIC_DOCUMENT_BY_ID + id,
        					method: 'GET',
        					success: function(res, action) {
        						var responseTxt = res.responseText;
        						if(responseTxt != ''){
            						if(fileExtension.toUpperCase() == "PDF"){
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<iframe width='100%' height='100%' src='data:application/pdf;base64, " + encodeURI(responseTxt) + "'></iframe>";
            						}
            						else{
            							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "<img src='data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "' />";
            						}
        						}
        						else{
        							Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Document Not Found";
        						}
        					}
        				});
        		     }
            	}
            },
            'quicksearchpanel': {
            	afterrender:function(structure){
        			var grid = structure.down('#applicationsListGrid');
        			this.getCBGridHeaderFreeze(grid,structure);
        		},
        		/*render:function(structure){
        			var appCombo = structure.down('#applicationID');
            		var appCombostore = appCombo.getStore();
            		appCombostore.getProxy().extraParams = {
            			academyLocationId: this.getCurrentAcademyLocation(),
            			isApplicationGrid:true
            		};
        		}*/
               /* tabchange:function(tabPanel,newCard,oldCard, eOpts ){
                	var me=this;
                	var searchForm=newCard.down('form');                	
                	if(searchForm){
                		me.loadGridAndSearchUsers(searchForm);
                	}                	                	                	
                }*/
            },
            'quicksearchpanel form[itemId=basicSearchPanel] button[itemId=applicationsListBasicSearchBtn]': {
                click: function() {
                    this.loadGridAndSearchUsers(this.getApplicationsListBasicSearchForm());
                }
            },
            'quicksearchpanel form[itemId=basicSearchPanel] checkboxfield[itemId=applicationPaymentPending]': {
            	change: function(obj) {
            		var this$ = this;
            		var form = obj.up('form');
            		var applicationPaymentPendingField = form.down('#applicationPaymentPending');
            		if( !isNullOrEmpty(applicationPaymentPendingField.getValue()) && applicationPaymentPendingField.getValue() ){
            			form.down('#applicationStatus').setDisabled(true);
            		} else {
            			form.down('#applicationStatus').setDisabled(false);
            		}
            	}
            },
           /* 'basicsearch[itemId=basicSearchPanel]  combo[itemId=applicationID]': {
            	change : function(selectionProcessCombo) {
            		var appCombostore = this.getApplicationsListBasicSearchForm().down('#applicationID').getStore();
            		appCombostore.getProxy().extraParams = {
            			academyLocationId: this.getUserAccessibleAL().join()
            		};
            	}
            }, */
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=applicantName]': {
            	change : function(selectionProcessCombo) {
            		var basicSearchForm = selectionProcessCombo.up('basicsearch');
            		var academyLocationCombo = basicSearchForm.down('#academyLocationCombo');
            		if(academyLocationCombo.getValue()){
            			var academyLocations = academyLocationCombo.getValue();
            		}
            		else{
            			var academyLocations = this.getUserAccessibleAL().join()
            		}
            		var appCombostore = this.getApplicationsListBasicSearchForm().down('#applicantName').getStore();
            		appCombostore.getProxy().extraParams = {
            			academyLocationId: academyLocations
            		};
            	}
            }, 
            
          /*  'basicsearch customcombobox[itemId=applicationID]': {
            	render: function(combo){
            		var appCombostore = combo.getStore();
            		appCombostore.getProxy().extraParams = {
            			academyLocationId: this.getCurrentAcademyLocation(),
            			isApplicationGrid:true
            		};
            	}
            },*/
            'basicsearch customcombobox[itemId=registrationTypeId]': {
                render: function() {
                	var $this = this;
                	var registrationTypeCombo = $this.getBasicsearch().down("#registrationTypeId");
					var registrationTypeComboStore = registrationTypeCombo.getStore();
					registrationTypeComboStore.getProxy().extraParams = {
					};
					registrationTypeComboStore.load();
                }
            },
            'basicsearch customcombobox[itemId=modeDeliveryId]': {
                render: function() {
                	var $this = this;
                	var modeDeliveryCombo = $this.getBasicsearch().down("#modeDeliveryId");
					var modeDeliveryComboStore = modeDeliveryCombo.getStore();
					modeDeliveryComboStore.getProxy().extraParams = {
					};
					modeDeliveryComboStore.load();
                }
            },
            'basicsearch customcombobox[itemId=academyLocationCombo]': {
                render: function(combo) {
                   
                	var me = this;
                	this.loadAcadLocCombo(combo);
                    
                    var store = combo.getStore();
                	store.load({
            			callback:function(records,response,success){
            				combo.setValue(me.getCurrentAcademyLocation())
            			}
            		});
                },
                select: function(combo, record) {
            		var appForm = combo.up('form');
            		var enqCombo = appForm.down('#enquiryNo');
            		//var acadLocId=combo.getValue();
            		var acadLocId = record[0].get('id');
            		var store = enqCombo.getStore();
            		store.getProxy().extraParams = {
            			academyLocationId: acadLocId
            		};
            		//var appCombo = appForm.down('#applicationID');
            		/*var appCombostore = appCombo.getStore();
            		appCombostore.getProxy().extraParams = {
            			academyLocationId: acadLocId,
            			isApplicationGrid:true
            		};*/
            		
            		var programGroupCombo = combo.up('form').down('#programGroup');
                	var programCombo = combo.up('form').down('#program');
                	
                	var programGroupValue = programGroupCombo.getValue();
                	var alValue = combo.getValue();
                	
                	var department = combo.up('form').down('#programDepartmentItemId');
            		var departmentStore = department.getStore();
            		departmentStore.getProxy().extraParams = {
            			academyLocationsIds: alValue
            		};
            		departmentStore.load();
            		
                	programCombo.setDisabled(false);
                	programCombo.getStore().getProxy().extraParams = {
                		programGroupId:programGroupValue,
                		academyLocationId:alValue
                	};
                	programCombo.getStore().load();
                	
                	var enquiryNo=combo.up('form').down('#enquiryNo');
                	enquiryNo.getStore().getProxy.extraParams={
                		academyLocationId: acadLocId
                	};
                /*select: function(combo) {
                    this.disableUsersWithoutALCheckbox(combo);
                }*/
                }
            },
            
            /*'basicsearch combo[itemId=academyLocationCombo]': {
            	select: function(combo,record) {
            		var appForm = combo.up('form');
            		var enqCombo = appForm.down('#enquiryNo');
            		var acadLocId=combo.getValue();
            		var store = enqCombo.getStore();
            		store.getProxy().extraParams = {
            			academyLocationId: acadLocId
            		};
            	}
            },*/
/*            'quicksearchpanel tabpanel[itemId=searchPanel] form[itemId=programSearchPanel] button[itemId=applicationsListProgramSearchBtn]': {
                click: function() {
                    this.loadGridAndSearchUsers(this.getApplicationsListProgramSearchForm());
                }
            },*/
            'searchresultgrid[itemId=applicationsListGrid] button[itemId=searchResultGridBtnAdd]': {
                click: this.showAddAdmissionWindow
            },          
            'searchresultgrid[itemId=applicationsListGrid] button[itemId=searchResultGridBtnEdit]': {
                click: function(){
                	this.editViewApplication(false);
                }
            },
            'searchresultgrid[itemId=applicationsListGrid] button[itemId=searchResultGridBtnView]': {
                click: function(){
                	this.editViewApplication(true);
                }
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=sendSurveyBtn]': {
            	click: function(obj) {
            		var grid = this.getSearchResultGrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			var this$ = this;
            			var window = this$.getApplicationsendsurvey();
            			if(!window){
            				window = Ext.widget('applicationsendsurvey');
            			}
            			window.show();
            		} else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}  
            	}
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=popiaOptionBtn]': {
            	click: function(obj) {
            		var grid = this.getSearchResultGrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			var this$ = this;
            			var window = this$.getApplicationpopiaoption();
            			if(!window){
            				window = Ext.widget('applicationpopiaoption');
            			}
            			window.show();
            		} else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}  
            	}
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=reassignApplicatioinItemId]': {
            	click: function(obj) {
            		var grid = this.getSearchResultGrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			var this$ = this;
            			var window = this$.getReassignapplicationform();
            			if(!window){
            				window = Ext.widget('reassignapplicationform');
            			}
            			window.show();
            		} else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}  
            	}
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=applicationAndAdmissionCommentsItemId]': {
            	click: function(obj) {
            		var grid = this.getSearchResultGrid();
            		if (grid.getSelectionModel().getCount() > 0) {
            			var this$ = this;
            			var window = this$.getApplicationandadmissioncommentform();
            			if(!window){
            				window = Ext.widget('applicationandadmissioncommentform');
            			}
            			window.show();
            		} else {
            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		}  
            	}
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=resetButtonItemId]': {
	            click: function() {
	            	var grid = this.getSearchResultGrid();
		        	if (grid.getSelectionModel().getCount() > 0) {
		        		var resetPswrdWindowItemId ="applicantlistadminresetpasswordwindow";
		                var resetPswrdFormWindow = Ext.widget('adminresetpasswordwindow', {
		                     itemId: resetPswrdWindowItemId
		                 });
		                resetPswrdFormWindow.show(); 
	        		} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
		       	     
	            }
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=markApplicationOffTrackItemId]': {
	         	   click: function(obj) {
	     		   var grid = this.getSearchResultGrid();
	     		   if (grid.getSelectionModel().getCount() > 0) {
	     			   var this$ = this;
	     			   var window = this$.getMarkapplicationofftrackwindow();
	     			   if(!window){
	     				   window = Ext.widget('markapplicationofftrackwindow');
	     			   }
	     			   window.show();
	     			   this.showAndHideTrackOffStatus(window);
	     		   } else {
	     			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	     		   }  
	         	   }
		        },
		     'markapplicationofftrackwindow button[itemId=saveBtn]' : {
	        		click : function(btn) {
						var form=btn.up('form');
						this.saveMarkApplicationOffTrack(form)
					}
		     },
		     'markapplicationofftrackwindow radiogroup[itemId=markApplicationOffTrackId]':{
     			change:this.showAndHideTrackOffStatus
     		 },
     		'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=pendingOfferFlagItemId]': {
          	   click: function(obj) {
      		   var grid = this.getSearchResultGrid();
      		   if (grid.getSelectionModel().getCount() > 0) {
      			   var this$ = this;
      			   var window = this$.getPendingofferflagwindow();
      			   if(!window){
      				   window = Ext.widget('pendingofferflagwindow');
      			   }
      			   window.show();
      		   } else {
      			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
      		   }  
          	   }
 	        },
 	       'pendingofferflagwindow button[itemId=saveBtn]' : {
       		click : function(btn) {
					var form=btn.up('form');
					this.savePendingOfferFlagWindow(form)
				}
			},
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=raisePriorityItemId]': {
         	   click: function(obj) {
     		   var grid = this.getSearchResultGrid();
     		   if (grid.getSelectionModel().getCount() > 0) {
     			   var this$ = this;
     			   var window = this$.getRaiseprioritywindow();
     			   if(!window){
     				   window = Ext.widget('raiseprioritywindow');
     			   }
     			   window.show();
     		   } else {
     			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     		   }  
         	   }
	        },
        	'raiseprioritywindow button[itemId=saveBtn]' : {
        		click : function(btn) {
					var form=btn.up('form');
					this.saveRaisePriority(form)
				}
			},
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=frozenItemId]': {
	        	click: function() {
	        		this.isFrozenApplicant(true);
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=unFrozenItemId]': {
	        	click: function() {
	        		this.isFrozenApplicant(false);
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=offerLetterDetailsItemId]': {
	        	click: function(btn) {
	        		this.openApplicantOfferLetterDetailsPopup(btn);
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=admissionApprovalDetailsItemId]': {
	        	click: function(btn) {
	        		this.openAdmAdmissionApprovalDetailsPopup(btn);
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=expireOfferLetterItemId]': {
	        	click: function() {
	        		this.expireOfferLetter();
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=reactivateApplicationItemId]': {
	        	click: function(grid) {
	        		this.applicationReactivationProcess(grid);
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=printOfferLetterWordsItemId]': {
	        	click: function(grid){
	        		this.applicationPrintOfferLetterInWords(grid);
                }},
	        
	        
	        'adminresetpasswordwindow[itemId=applicantlistadminresetpasswordwindow] ': {
                beforerender: function(formWindow) {
                	var form = formWindow.down('form');
					var randomPassword=form.down("#passwordTypeItemId");
                	randomPassword.setVisible(false);
        	    	this.getController('Academia.controller.authentication.AuthenticationController').getPasswordPolicy(form);
                }
            },
           
			'adminresetpasswordwindow[itemId=applicantlistadminresetpasswordwindow] form #resetPassword' :{ 
				blur:this.getController('Academia.controller.authentication.AuthenticationController').checkPasswordValidity
			},
			'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=checkDuplicateEmailItemId]': {
            	click: this.admCheckCommonDuplicateValue
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=preEligibilityItemId]': {
            	click: function(btn){
            		var me = this;
            		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	           		 Ext.defer(function(){
	             		me.preEligibilityCheck(btn);
	           		 },200);
            	}
            },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=calculateExamAggregateItemId]': {
            	click: this.calculateExamAggregate
            },
            
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=checkDuplicateNationalItemId]': {
            	click: this.admCheckCommonDuplicateValue
            },
			'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=btnRefreshAllItemId]': {
            	click: this.clickOnBtnRefreshAllItemId
            },
			'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=btnOnlyUnmatchedRecordsItemId]': {
            	click: this.clickOnBtnOnlyUnmatchedRecordsItemId
            },
			
	        'adminresetpasswordwindow[itemId=applicantlistadminresetpasswordwindow] button[itemId=submitBtn]':{
	        	click:function(obj){
	        		 this.changePasswordByExternalUser(obj);
	        	}
	        },
	        'adminresetpasswordwindow[itemId=applicantlistadminresetpasswordwindow] button[itemId=cancelBtn]':{
	        	click:function(obj){
	        		 obj.up('window').close();
	        	}
	        },
	        'applicationsendsurvey button#saveBtn': {
	        	click: function(obj) {
	        		this.sendSurveyDetails(obj);
	        	}
	        },
	        'applicationpopiaoption button#saveBtn': {
	        	click: function(obj) {
	        		this.sendPopiaOptionDetails(obj);
	        	}
	        },
	       
	        'reassignapplicationform button#ard_submitbuttonId': {
	        	click: function(obj) {
	        		this.reassignApplicationsSave(obj);
	        	}
	        },
	        'reassignapplicationform button#ard_cancelbuttonId': {
	        	click: function(obj) {
	        		 obj.up('window').close();
	        	}
	        },
	        'applicationandadmissioncommentform button#ard_submitbuttonId': {
	        	click: function(obj) {
	        		this.applicationAndAdmissionCommentsSave(obj);
	        	}
	        },
	        'applicationandadmissioncommentform button#ard_cancelbuttonId': {
	        	click: function(obj) {
	        		 obj.up('window').close();
	        	}
	        },
            'searchresultgrid[itemId=applicationsListGrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
	            click: function() {
	                this.exportApplicationList(SERVERURL.PDFEXPORT,'pdf',false);
	            }
	        },
	        'searchresultgrid[itemId=applicationsListGrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
	        	click: function() {
	        		this.exportApplicationList(SERVERURL.PDFEXPORT,'pdf',true);
	        	}
	        },
	        'searchresultgrid[itemId=applicationsListGrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
	            click: function() {
	                this.exportApplicationList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
	            }
	        },
	        'searchresultgrid[itemId=applicationsListGrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
	        	click: function() {
	        		this.exportApplicationList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
	        	}
	        },    
            'searchresultgrid[itemId=applicationsListGrid] combo[itemId=applicationListAction]': {
                select: function(combo,comboRecord){
                	var me=this;
                	var searchResultGrid=me.getSearchResultGrid();
                	var record = searchResultGrid.getSelectionModel().getSelection()[0];
                	if (!isEmpty(record)) {
                		var applicationProgramId=record.get('APPLICATION_PROGRAM_ID');
                		if(!isNullOrEmpty(applicationProgramId)){
                			var selectAction=comboRecord[0].get('name');
                			if(!isNullOrEmpty(selectAction)){
                				var recordsStatus = searchResultGrid.selModel.getSelection();
                				var myStatus=[];
                				for(var i in recordsStatus){
                					myStatus.push(recordsStatus[i].get('PROGRAM_STATUS'));
                				}
                				var arrrray = me.getUniqueStatus(myStatus);
                				if(arrrray!=true){

                					switch (selectAction) {

                					case 'ISSUE_OFFER_LETTER':                                	                                	
                						var url=SERVERURL.APPLICATIONS_ISSUE_OFFER_LETTER; //URL-: rest/applicationProgram/issueOfferLetter
                						if(!isNullOrEmpty(url)){
                							//url = url.concat("?applicationProgramID=" + applicationProgramId);

                							var records = searchResultGrid.getSelectionModel().getSelection();
                							var selectedRecords = new Array();
                							for (var count = 0; count < records.length; count++) {
                								var selectedRecord = records[count];
                								if (!isEmpty(selectedRecord.data)) {
                									var selectedApplicationProgram = new Object();
                									selectedApplicationProgram.id=selectedRecord.get('APPLICATION_PROGRAM_ID');
                									selectedRecords.push(selectedApplicationProgram);
                								}
                							}
                							if (selectedRecords.length > 0) {
                								var jsonFormatFormData = Ext.encode(selectedRecords);
                								if (!isNullOrEmpty(jsonFormatFormData)) {
                									if(arrrray=="PROVISIONAL_OFFER_DUE") {
                										showConfirmMessage(getAdmissionTranslation('PROVISIONAL_OFFER'),getAdmissionTranslation('CONFIRM_PROVISIONAL_OFFER'),
                    											function(btn,text) {
                    										if(btn == 'yes') {
                    											me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('ISSUE_PROVISIONAL_OFFER_MSG'),combo);
                    										}
                    									})
                									}
                									else {
                									showConfirmMessage(getCommonTranslation('OFFER_LETTER'),getCommonTranslation('CONFIRM_OFFER_LETTER'),
                											function(btn,text) {
                										if(btn == 'yes') {
                											me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('ISSUE_OFFER_LETTER_MSG'),combo);
                										}
                									})
                									}
                								}
                							}
                						}                                	                                                                    		
                						break;

                					case 'ACCEPT_OFFER_LETTER':
                						if(arrrray=="PROVISIONAL_OFFER_ISSUED" || arrrray=="PROVISIONAL_OFFER_EXPIRED") {
                							showConfirmMessage(getAdmissionTranslation('PROVISIONAL_OFFER'), getAdmissionTranslation('ARE_YOU_SURE_YOU_WANT_TO_ACCEPT_PROVISIONAL_OFFER'), function(btn, text) {
                    							if (btn == 'yes') {
                    								var url=SERVERURL.APPLICATIONS_ACCEPT_OFFER_LETTER; //URL-: rest/applicationProgram/acceptOfferLetter

                    								var records = searchResultGrid.getSelectionModel().getSelection();
                    								var selectedRecords = new Array();
                    								for (var count = 0; count < records.length; count++) {
                    									var selectedRecord = records[count];
                    									if (!isEmpty(selectedRecord.data)) {
                    										var selectedApplicationProgram = new Object();
                    										selectedApplicationProgram.id=selectedRecord.get('APPLICATION_PROGRAM_ID');
                    										selectedApplicationProgram.billedUserType='APPLICANT';
                    										selectedApplicationProgram.feePlanType='Program';
                    										selectedApplicationProgram.stageName='Admission commitment';
                    										selectedApplicationProgram.appliactionPrimaryId=record.get('APPLICATION_PRIMERY_ID');
                    										selectedApplicationProgram.programBatchSeatConfigId=record.get('PROG_BATCH_SEAT_CONFIG_ID');

                    										selectedRecords.push(selectedApplicationProgram);
                    									}
                    								}
                    								if (selectedRecords.length > 0) {
                    									var jsonFormatFormData = Ext.encode(selectedRecords);
                    									me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('PROVISIONAL_OFFER_ACCEPTED_SUCCESSFULLY'),combo);
                    								}
                    							}
                    						});
                						}
                						else {
                						showConfirmMessage(getCommonTranslation('ACCEPT_OFFER'), getCommonTranslation('ACCEPT_OFFER_CONFIRM_MESSAGE'), function(btn, text) {
                							if (btn == 'yes') {
                								var url=SERVERURL.APPLICATIONS_ACCEPT_OFFER_LETTER; //URL-: rest/applicationProgram/acceptOfferLetter

                								var records = searchResultGrid.getSelectionModel().getSelection();
                								var selectedRecords = new Array();
                								for (var count = 0; count < records.length; count++) {
                									var selectedRecord = records[count];
                									if (!isEmpty(selectedRecord.data)) {
                										var selectedApplicationProgram = new Object();
                										selectedApplicationProgram.id=selectedRecord.get('APPLICATION_PROGRAM_ID');
                										selectedApplicationProgram.billedUserType='APPLICANT';
                										selectedApplicationProgram.feePlanType='Program';
                										selectedApplicationProgram.stageName='Admission commitment';
                										selectedApplicationProgram.appliactionPrimaryId=record.get('APPLICATION_PRIMERY_ID');
                										selectedApplicationProgram.programBatchSeatConfigId=record.get('PROG_BATCH_SEAT_CONFIG_ID');

                										selectedRecords.push(selectedApplicationProgram);
                									}
                								}
                								if (selectedRecords.length > 0) {
                									var jsonFormatFormData = Ext.encode(selectedRecords);
                									me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('ACCEPT_OFFER_LETTER_MSG'),combo);
                								}
                							}
                						});
                						}

                						break;
                					case 'OFFER_LETTER_REJECTED':
                						if(arrrray=="PROVISIONAL_OFFER_ISSUED") {
                							showConfirmMessage(getAdmissionTranslation('PROVISIONAL_OFFER'), getAdmissionTranslation('DECLINE_PROVISIONAL_OFFER_CONFIRM_MESSAGE'), function(btn, text) {
                    							if (btn == 'yes') {
                    								var url=SERVERURL.APPLICATIONS_REJECT_OFFER_LETTER; //URL-: rest/applicationProgram/rejectOfferLetter
                    								var records = searchResultGrid.getSelectionModel().getSelection();
                    								var selectedRecords = new Array();
                    								for (var count = 0; count < records.length; count++) {
                    									var selectedRecord = records[count];
                    									if (!isEmpty(selectedRecord.data)) {
                    										var selectedApplicationProgram = new Object();
                    										selectedApplicationProgram.id=selectedRecord.get('APPLICATION_PROGRAM_ID');
                    										selectedRecords.push(selectedApplicationProgram);
                    									}
                    								}
                    								if(selectedRecords.length > 0){
                    									var jsonFormatFormData = Ext.encode(selectedRecords);
                    									me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('DECLINE_PROVISIONAL_OFFER_SUCCESS_MSG'),combo);
                    								}
                    					L		}
                    						});
                						}
                						else {
                						showConfirmMessage(getCommonTranslation('OFFER_LETTER'), getAdmissionTranslation('DECLINE_OFFER_CONFIRM_MESSAGE'), function(btn, text) {
                							if (btn == 'yes') {
                								var url=SERVERURL.APPLICATIONS_REJECT_OFFER_LETTER; //URL-: rest/applicationProgram/rejectOfferLetter
                								var records = searchResultGrid.getSelectionModel().getSelection();
                								var selectedRecords = new Array();
                								for (var count = 0; count < records.length; count++) {
                									var selectedRecord = records[count];
                									if (!isEmpty(selectedRecord.data)) {
                										var selectedApplicationProgram = new Object();
                										selectedApplicationProgram.id=selectedRecord.get('APPLICATION_PROGRAM_ID');
                										selectedRecords.push(selectedApplicationProgram);
                									}
                								}
                								if(selectedRecords.length > 0){
                									var jsonFormatFormData = Ext.encode(selectedRecords);
                									me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('DECLINE_OFFER_SUCCESS_MSG'),combo);
                								}
                							}
                						});
                						}
                						break;

                					case 'PRINT_OFFER_LETTER':

                						var user=me.getCurrentlyLoggedInUser();       
                						var progBatchSeatConfig=record.get('PROG_BATCH_SEAT_CONFIG_ID');

                						//Adding require parameters in object and pass this parameter to server side 
                						var parameterListObj =new Object();
                						
                						if(arrrray=="PROVISIONAL_OFFER_ISSUED" || arrrray=="PROVISIONAL_OFFER_DUE" || arrrray=="PROVISIONAL_OFFER_EXPIRED") {
                							parameterListObj.documentTypeCode="PROVISIONAL_OFFER_LETTER";
                						}
                						else {
                						parameterListObj.documentTypeCode="OFFER_LETTER";
                						}
                						parameterListObj.ownerType="PROGRAM_BATCH_SEAT_TYPE_LEVEL";

                						parameterListObj.userId=user.id; // logged in user ID
                						parameterListObj.userName=user.value; // logged in user Name

                						parameterListObj.ownerId=progBatchSeatConfig;                                 	                                    	
                						parameterListObj.templateReportParams={'PRM_APPLICATION_PROGRAM_ID':applicationProgramId.toString()}; //Application Program ID                                    	                                    	

                						me.sendPDFDynamicDocumentRequest(SERVERURL.GENERATE_DYNAMIC_DOCUMENT,parameterListObj);

                						break;
                					case 'APPROVE': 
                						var me = this;var records = searchResultGrid.getSelectionModel().getSelection();
                						showConfirmMessage(getCommonTranslation('APPROVE'), getCommonTranslation('APPROVE_CONFIRM_MESSAGE'), function(btn, text) {
                							if (btn == 'yes') {
                								var selectedRecords = new Array();
                								var applicationIDs;
                								var applicationProgramIds = new Array();
                								for (var i in records) {
                									selectedRecords.push(records[i].get('APPLICATION_PRIMERY_ID'));
                									applicationProgramIds.push(records[i].get('APPLICATION_PROGRAM_ID'));
                								}
                								applicationIDs = selectedRecords.join();
                								if(!isNullOrEmpty(applicationIDs)){
                									Ext.Ajax.request({
                										method: "GET",
                										type: 'rest',
                										url: SERVERURL.APPLICATIONS_APPROVE_PROGRAM_GRIDDATA, //rest/applicationProgram/applicationsToApprove
                										params:{
                											applicationIDs:applicationIDs
                										},
                										success: function(response, action) {
                											var record = Ext.decode(response.responseText);
                											var jsonArray=new Array();
                											for(var j in record){
                												jsonArray.push(record[j].id);
                											}
                											var myJson={
                													"currentStatus":"APPROVED",
                													"reasonId":1,
                													"remark":null,
                													"applicationProgramIds":applicationProgramIds,
                													"applicationIds":selectedRecords
                											};
                											var serverUrl='rest/applicationProgram/approveOrRejectOrWithdrawnApplication';
                											me.performSelectedAction(serverUrl,'POST',myJson,searchResultGrid,getAdmissionTranslation('APPLICATION_APPROVED_SUCCESSFULLY'),combo);
                										}
                									});
                								}
                							}
                						});
                						break;
                					case 'WITHDRAW': 
                						var URL;
                						if(recordsStatus[i].get('PROGRAM_STATUS')==="OFFER_LETTER_ISSUED"||recordsStatus[i].get('PROGRAM_STATUS')==="OFFER_LETTER_DUE"){
                							URL = SERVERURL.APPLICATIONS_WITHDRAW_PROGRAM_GRIDDATA;
                						}else{
                							URL = SERVERURL.APPLICATIONS_APPROVE_PROGRAM_GRIDDATA;
                						}
                						var me = this;
                						var records = searchResultGrid.getSelectionModel().getSelection();
                						showConfirmMessage(getCommonTranslation('WITHDRAW'), getCommonTranslation('WITHDRAW_CONFIRM_MESSAGE'), function(btn, text) {
                							if (btn == 'yes') {
                								var selectedRecords = new Array();
                								var applicationIDs;
                								for (var i in records) {
                									selectedRecords.push(records[i].get('APPLICATION_PRIMERY_ID'));
                								}
                								applicationIDs = selectedRecords.join();
                								if(!isNullOrEmpty(applicationIDs)){
                									Ext.Ajax.request({
                										method: "GET",
                										type: 'rest',
                										url: URL, //rest/applicationProgram/applicationsToApprove
                										params:{
                											applicationIDs:applicationIDs
                										},
                										success: function(response, action) {
                											var record = Ext.decode(response.responseText);
                											var jsonArray=new Array();
                											for(var j in record){
                												jsonArray.push(record[j].id);
                											}
                											var myJson={
                													"currentStatus":"WITHDRAWN",
                													"reasonId":1,
                													"remark":null,
                													"applicationProgramIds":jsonArray,
                													"applicationIds":selectedRecords
                											};
                											var serverUrl= SERVERURL.APPLICATIONS_APPROVE_REJECT_WITHDRAW_APPLICATION_PROGRAM//'rest/applicationProgram/approveOrRejectOrWithdrawnApplication';
                            								me.performSelectedAction(serverUrl,'POST',myJson,searchResultGrid,getAdmissionTranslation('APPLICATION_WITHDRAW_SUCCESSFULLY'),combo);
                										}
                									});
                								}
                							}
                					});
                						break;
                					case 'REJECT': 
                						var URL;
                						if(recordsStatus[i].get('PROGRAM_STATUS')==="OFFER_LETTER_ISSUED"||recordsStatus[i].get('PROGRAM_STATUS')==="OFFER_LETTER_DUE"){
                							URL = SERVERURL.APPLICATIONS_REJECT_PROGRAM_GRIDDATA;
                						}else{
                							URL = SERVERURL.APPLICATIONS_APPROVE_PROGRAM_GRIDDATA;
                						}
                						var me = this;
                						var records = searchResultGrid.getSelectionModel().getSelection();
                						if (records.length > 0) {
            		            			var window = me.getBulkapplicationrejection();
            		            			if(!window){
            		            				window = Ext.widget('bulkapplicationrejection');
            		            			}
            		            			window.show();
            		            			var totalRecordsField = window.down('#totalRecordsId');
            		            			var value = getCommonTranslation('TOTAL_RECORDS');
            		            			value = value + ":" +records.length;
            		            			totalRecordsField.setValue('<b class="menu-title">'+value+'</b>');
            		            		} else {
            		            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
            		            		}
                						break;
                					case 'RESEND_OFFER_LETTER': 
                						var url=SERVERURL.APPLICATIONS_ISSUE_OFFER_LETTER; //URL-: rest/applicationProgram/issueOfferLetter
                						if(!isNullOrEmpty(url)){
                							//url = url.concat("?applicationProgramID=" + applicationProgramId);

                							var records = searchResultGrid.getSelectionModel().getSelection();
                							var selectedRecords = new Array();
                							for (var count = 0; count < records.length; count++) {
                								var selectedRecord = records[count];
                								if (!isEmpty(selectedRecord.data)) {
                									var selectedApplicationProgram = new Object();
                									selectedApplicationProgram.id=selectedRecord.get('APPLICATION_PROGRAM_ID');
                									selectedRecords.push(selectedApplicationProgram);
                								}
                							}
                							if (selectedRecords.length > 0) {
                								var jsonFormatFormData = Ext.encode(selectedRecords);
                								if (!isNullOrEmpty(jsonFormatFormData)) {
                									if(arrrray=="PROVISIONAL_OFFER_ISSUED" || arrrray=="PROVISIONAL_OFFER_EXPIRED") {
                										showConfirmMessage(getAdmissionTranslation('PROVISIONAL_OFFER'),getAdmissionTranslation('CONFIRM_RESEND_PROVISIONAL_OFFER'),
                    											function(btn,text) {
                    										if(btn == 'yes') {
                    											me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('RESEND_PROVISIONAL_OFFER_MSG'),combo);
                    					}
                    									})
                									}
                									else {
                									showConfirmMessage(getCommonTranslation('OFFER_LETTER'),getCommonTranslation('CONFIRM_RESEND_OFFER_LETTER'),
                											function(btn,text) {
                										if(btn == 'yes') {
                											me.performSelectedAction(url,'POST',jsonFormatFormData,searchResultGrid,getAdmissionTranslation('RESEND_OFFER_LETTER_MSG'),combo);
                					}
                									})
                								}
                								}
                							}
                						}                                	                                                                    		
                						break;
                					}
                				}else{
                					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PROGRAM_STATUS_SHOULD_BE_SAME')); //Please select a record.
                					combo.reset();
                				}                			
                			}
                		}
                	}else{
                		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                		combo.reset();
                	}               	                	                	
                },
                expand: function(combo, eOpts){
                	var me=this;
                	var searchResultGrid=me.getSearchResultGrid();
                	var record = searchResultGrid.getSelectionModel().getSelection()[0];

                	if (!isEmpty(record)) {
                		var programStatus=record.get('PROGRAM_STATUS');
                		var applicationStatus=record.get('APPLICATION_STATUS');
                		if(!isNullOrEmpty(programStatus) && (programStatus==='OFFER_LETTER_ACCEPTED' || programStatus==='OFFER_LETTER_ISSUED'
                			|| programStatus==='OFFER_LETTER_DUE' || programStatus==='OFFER_LETTER_REJECTED' || programStatus==='PROVISIONAL_OFFER_ISSUED'
                    			|| programStatus==='PROVISIONAL_OFFER_DUE' || programStatus==='PROVISIONAL_OFFER_REJECTED' || programStatus==='OFFER_EXPIRED'
                    				|| programStatus==='PROVISIONAL_OFFER_EXPIRED' || programStatus == 'ESCALATED_OFFER_REVIEWED_AFTER_ACCEPTANCE'
                    					|| programStatus == 'ESCALATION_AFTER_ACCEPTANCE')){

                			if(programStatus ==='OFFER_LETTER_ISSUED' || programStatus ==='PROVISIONAL_OFFER_ISSUED' || programStatus==='OFFER_EXPIRED'
                				|| programStatus==='PROVISIONAL_OFFER_EXPIRED'){
                				this.removeStatusInDropDown(combo,'ISSUE_OFFER_LETTER');
                				this.addStatusInDropDown(combo,'ACCEPT_OFFER_LETTER','ACCEPT_OFFER_LETTER');
                				this.addStatusInDropDown(combo,'OFFER_LETTER_REJECTED','DECLINE_OFFER_LETTER');
                				this.addStatusInDropDown(combo,'RESEND_OFFER_LETTER','RESEND_OFFER_LETTER');
                				this.isVisibleOfferLetterAcceptAndDeclineOption(combo,this.getAPPLICANT_PERMISSIONS());	
                				// first remove and then again add status bcz of we have to maintain sequence 
                				if(programStatus==='OFFER_EXPIRED' || programStatus==='PROVISIONAL_OFFER_EXPIRED'){
                					this.removeStatusInDropDown(combo,'OFFER_LETTER_REJECTED');
                				}
                				this.removeStatusInDropDown(combo,'PRINT_OFFER_LETTER');
                				this.addStatusInDropDown(combo,'PRINT_OFFER_LETTER','PRINT_OFFER_LETTER');
                				this.addStatusInDropDown(combo,'RESEND_OFFER_LETTER','RESEND_OFFER_LETTER');
                			}else{
                				this.removeStatusInDropDown(combo,'OFFER_LETTER_REJECTED');
                				this.removeStatusInDropDown(combo,'RESEND_OFFER_LETTER');
                			}
                			if (programStatus === 'OFFER_LETTER_REJECTED' || programStatus === 'PROVISIONAL_OFFER_REJECTED') {
                				this.removeStatusInDropDown(combo,'ISSUE_OFFER_LETTER');
                				this.removeStatusInDropDown(combo,'REJECT_OFFER_LETTER');
                			}
                			this.addStatusInDropDown(combo,'PRINT_OFFER_LETTER','PRINT_OFFER_LETTER');
                		}else{
                			this.removeStatusInDropDown(combo,'PRINT_OFFER_LETTER');
                			this.removeStatusInDropDown(combo,'OFFER_LETTER_REJECTED');
                		}
                		if(!isNullOrEmpty(programStatus) && (programStatus==='ACTIVE')){
                			this.removeStatusInDropDown(combo,'ACCEPT_OFFER_LETTER');
                			this.addStatusInDropDown(combo,'APPROVE','APPLICATION_APPROVE');
                		}
                		// Start offer letter issue after declined by applicant 
                		if (programStatus === 'OFFER_LETTER_REJECTED' || programStatus === 'PROVISIONAL_OFFER_REJECTED') {
                			this.isVisibleIssueOfferLetter(combo,this.getAPPLICANT_PERMISSIONS());
                			this.removeStatusInDropDown(combo,'PRINT_OFFER_LETTER');
                			this.removeStatusInDropDown(combo,'ACCEPT_OFFER_LETTER');
                			this.removeStatusInDropDown(combo,'OFFER_LETTER_REJECTED');
                			
                			var recResend = combo.getStore().findRecord('name', 'RESEND_OFFER_LETTER');
                			if(recResend){
                				combo.getStore().remove(recResend);
                			}
                			combo.getStore().commitChanges();
                		}
            			}
                		if(programStatus==='OFFER_LETTER_DUE' || programStatus==='PROVISIONAL_OFFER_DUE'){
                		  this.isVisibleIssueOfferLetter(combo,this.getAPPLICANT_PERMISSIONS());	
                   		}
                		if(!isNullOrEmpty(programStatus)){
                			if(programStatus==='OFFER_LETTER_ACCEPTED' || programStatus==='ADMITTED' || programStatus==='OFFER_LETTER_DUE' || programStatus==='ACTIVE' || programStatus==='WITHDRAWN' || programStatus==='APPROVED' 
                				|| programStatus==='PROVISIONAL_OFFER_DUE' ||  programStatus==='ESCALATED' ||  programStatus==='ESCALATED_OFFER_REVIEWED' ||  programStatus==='WAITING_LIST' || programStatus==='WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'){
                				var recResend = combo.getStore().findRecord('name', 'RESEND_OFFER_LETTER');
                				if(recResend){
                					combo.getStore().remove(recResend);
                				}
                				combo.getStore().commitChanges();
                			}
                		}
                		// End 
                		var WITHDRAW = combo.getStore().findRecord('name', 'WITHDRAW');
                		var REJECT = combo.getStore().findRecord('name', 'REJECT');
                		var APPROVED = combo.getStore().findRecord('name', 'APPROVE');
                		if(applicationStatus!='DIRECT_ADMISSION'){
                			this.removeStatusInDropDown(combo,'REJECT');	
                			this.removeStatusInDropDown(combo,'WITHDRAW');	

                			if(programStatus!='REJECTED' && programStatus!='WITHDRAWN' && programStatus!='CLOSED' && programStatus!='ADMITTED' && programStatus!='WAITING_LIST'
                				&&  programStatus!='ESCALATED' &&  programStatus!='ESCALATED_OFFER_REVIEWED' && programStatus!='WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'){

                				if(programStatus==='OFFER_LETTER_ISSUED' || programStatus==='OFFER_LETTER_DUE' 
                					|| programStatus==='OFFER_LETTER_REJECTED' || programStatus==='PROVISIONAL_OFFER_ISSUED' || programStatus==='PROVISIONAL_OFFER_DUE' 
                    					|| programStatus==='PROVISIONAL_OFFER_REJECTED' || programStatus==='OFFER_EXPIRED' || programStatus==='PROVISIONAL_OFFER_EXPIRED'){
                					this.removeStatusInDropDown(combo,'WITHDRAW');
                					this.removeStatusInDropDown(combo,'REJECT');
                					this.removeStatusInDropDown(combo,'APPROVE');
                					this.addStatusInDropDown(combo,'REJECT','APPLICATION_REJECT');
                					
                					if (programStatus != 'OFFER_LETTER_REJECTED' || programStatus != 'PROVISIONAL_OFFER_REJECTED') {
                						this.addStatusInDropDown(combo,'WITHDRAW','APPLICATION_WITHDRAW');
                					}
                				}
                				if(programStatus==='OFFER_LETTER_ACCEPTED') {
                					this.removeStatusInDropDown(combo,'APPROVE');
                					this.removeStatusInDropDown(combo,'ACCEPT_OFFER_LETTER');
                				}
                				if(applicationStatus==='APPROVED' && programStatus==='APPROVED'){
                					this.removeStatusInDropDown(combo,'REJECT');
                					this.removeStatusInDropDown(combo,'APPROVE');
                				}
                				// for reject 
                				if(applicationStatus!='APPROVED'){
                					this.addStatusInDropDown(combo,'REJECT','APPLICATION_REJECT');
                				if(programStatus==='OFFER_LETTER_ACCEPTED'){
                					this.removeStatusInDropDown(combo,'WITHDRAW');
                					this.removeStatusInDropDown(combo,'REJECT');
                					this.removeStatusInDropDown(combo,'APPROVE');
                				}
                			}else{
                				this.removeStatusInDropDown(combo,'REJECT');
                				this.removeStatusInDropDown(combo,'WITHDRAW');
                			}
                		}else{
                			this.removeStatusInDropDown(combo,'REJECT');
                			this.removeStatusInDropDown(combo,'WITHDRAW');
                		}
                		if(applicationStatus == 'DIRECT_ADMISSION' || applicationStatus == 'ADMISSION_GRANTED' || programStatus == 'WAITING_LIST' || programStatus == 'ESCALATED' 
                			||  programStatus == 'ESCALATED_OFFER_REVIEWED' || applicationStatus == 'REJECTED' || applicationStatus == 'WITHDRAWN' || programStatus == 'REJECTED'
                			|| programStatus == 'WITHDRAWN' || programStatus == 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'){
                			this.removeStatusInDropDown(combo,'APPROVE');
                		}
                	} else {
                		this.removeStatusInDropDown(combo,'APPROVE');
                		this.removeStatusInDropDown(combo,'REJECT');
            			this.removeStatusInDropDown(combo,'WITHDRAW');
                	}
                	if(applicationStatus == 'SOLD' || applicationStatus == 'DIRECT_SUBMISSION_TOKEN_GENERATED' 
                		|| applicationStatus == 'FORM_SALE_TOKEN_GENERATED' || applicationStatus == 'INCOMPLETE'){
                		this.removeStatusInDropDown(combo,'APPROVE');
                		this.removeStatusInDropDown(combo,'REJECT');	
            			this.removeStatusInDropDown(combo,'WITHDRAW');
            			this.removeStatusInDropDown(combo,'PRINT_OFFER_LETTER');
            			this.removeStatusInDropDown(combo,'ACCEPT_OFFER_LETTER');
            			this.removeStatusInDropDown(combo,'OFFER_LETTER_REJECTED');
        				this.removeStatusInDropDown(combo,'RESEND_OFFER_LETTER');
                	}
                	if (isEmpty(record)) {
                		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                	}
                }
            },
            'basicsearch[itemId=basicSearchPanel]  button[itemId=ClearSearchBtn]':{
           	 	click: this.clearSearchForm
            },
            'applicantsendmessage[itemId=applicationSendMessageWindow] radiogroup[itemId=messageType]':{
  	        	change : function(val,nV,oV){
  	        		this.selectSectionMessageType(val,nV,oV);
  	        	}
  	        },
  	        'applicantsendmessage[itemId=applicationSendMessageWindow] customcombobox[itemId=msgTempletId]':{
  	        	select : function(obj,rec){
  	        		this.selectApplicantMessageTemp(obj,rec);
  	        	}
  	        },
  	        'applicantsendmessage[itemId=applicationSendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
  	        	click: function(obj) {
  	        		var isForAll = false;
  	        		var grid = this.getSearchResultGrid();
    				var applicantsendmessage = this.getApplicantsendmessage();
    				var quickSearchForm = this.getApplicationsListBasicSearchForm();
    				 var jsonFormatFormData = this.createJsonFormat(quickSearchForm.getValues());
    				//applicantsendmessage.down('#adhocMsgSubmitBtn').setDisabled(true);
    				var sendMessageLable = applicantsendmessage.down("#sendMsgCountItemId");
	    	       	if (sendMessageLable.isVisible()) {
	    	       		isForAll = true;
					}
    				var formPnl = obj.up('form');
    				var isMySelfChecked = false;
    				var fldValues = formPnl.getForm().getFieldValues();
    				isMySelfChecked = fldValues.recieverType;
    				if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
  	        	    	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
  	        	    	obj.setDisabled(false);
  	        	    	return;
  	        	    }
    				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
    				//var grid = this.getSearchResultGrid();
    				//var studentsendmessage = this.getStudentsendmessages();
    				var wsMsgEventRecipientConfigsUpdated = [];
    				/*var wsMsgEventRecipientConfigsUpdated = [{ 
								                           	 	msgRecipientTypeId: 500,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            },{ 
								                           	 	msgRecipientTypeId: 600,
								                           	 	msgTemplateConfigId: 0,	//formData.id, 
								                           	 	selectiveRecipientIds: [] 
								                            }];*/
    				
    				var formData = obj.up('form').getValues();
    				
    				var sendMessageToOptions = formData.recieverType;
    				var isApplicantChecked = false;
    				var isParentChecked = false;
    				var isFeePayerChecked = false;
    				
    				if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
    					if(sendMessageToOptions.constructor === Array){
    						if(sendMessageToOptions.length > 0){
    							sendMessageToOptions.forEach(function(current_value, index, initial_array) {
            						if(current_value == 1 || current_value == '1'){
            							isApplicantChecked = true;
            						}
									if(current_value == 2 || current_value == '2'){
										isParentChecked = true;
									}
									if(current_value == 3 || current_value == '3'){
										isFeePayerChecked = true;
									}
            					});
    						}
    					}else{
    						if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
    							isApplicantChecked = true;
    						}
							if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
								isParentChecked = true;
							}
							if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
								isFeePayerChecked = true;
							}
    					}
    				}
    				
    				//var abc = xyz.c;
    				
    				if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
    					//wsMsgEventRecipientConfigsUpdated = [];
    					applicantsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isApplicantChecked,isMySelfChecked,currentlyLoggedInUserId, null, isForAll, jsonFormatFormData);
    				}else{
    					var recipientIds;
    					if(grid != undefined){
    						recipientIds = this.getEnquiryReceipientIdsForSendingMessages(grid);
    						recipientIds = Ext.encode(recipientIds);
    						//typeId = 2;
    						//recipientId = 2;
    					}
    						
    					var RecipientTypeCodes = ["Applicant Person Adhoc","Fee Payer Adhoc"];
    					
    					if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
    						console.log("Both checkboxes checked -------- YES");
    						
    						Ext.Ajax.request({
        						type: 'rest',
        						url: SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
        						jsonData: RecipientTypeCodes,
        						method: 'POST',
        						success: function(response) {
        							var RecipientTypeCodesData = Ext.decode(response.responseText);
        							// Ajax Call to get Parent Ids by Application Ids
                					Ext.Ajax.request({
                						type: 'rest',
                						url: SERVERURL.FIND_ALL_PARENT_BY_APPLICATION_IDS,
                						jsonData: recipientIds,
                						method: 'POST',
                						success: function(response) {
                							// update wsMsgEventRecipientConfigsUpdated with parent ids
                							var wsMsgEventRecipientConfigsParents = {
        							            									msgRecipientTypeId: 68,
        											                           	 	msgTemplateConfigId: 0,	//formData.id, 
        											                           	 	selectiveRecipientIds: []
        								            							};
                							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Applicant_Person_Adhoc != null){
	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Applicant_Person_Adhoc;
	            							}
                							wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
                							wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
                							
                							// Ajax Call to get Fee Payer Ids by Application Ids
                							Ext.Ajax.request({
        	            						type: 'rest',
        	            						url: SERVERURL.FIND_ALL_FEE_PAYER_BY_APPLICATION_IDS,
        	            						jsonData: recipientIds,
        	            						method: 'POST',
        	            						success: function(response) {
        	            							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
        	            							var wsMsgEventRecipientConfigsFeePayer = {
        	            									msgRecipientTypeId: 67,
        					                           	 	msgTemplateConfigId: 0,	//formData.id, 
        					                           	 	selectiveRecipientIds: []
        		            							};
        	            							if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
	    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
	    	            							}
        	            							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
        											wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
        											applicantsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isApplicantChecked,isMySelfChecked,currentlyLoggedInUserId, null, isForAll, jsonFormatFormData);
        	            						}
        	            					});
                						}
                					});
        						}
    						});
    						
    					}else{ // Only one checkbox is selected
    						var urlNew = '';
    						if(isParentChecked) { // If Parent checkbox is selected
    							// url for getting parent ids
    							urlNew = SERVERURL.FIND_ALL_PARENT_BY_APPLICATION_IDS;
    						}
    						if(isFeePayerChecked) { // If Fee Payer checkbox is selected
    							// url for getting fee payer ids
    							urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_APPLICATION_IDS;
    						}
    						
    						Ext.Ajax.request({
        						type: 'rest',
        						url: SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
        						jsonData: RecipientTypeCodes,
        						method: 'POST',
        						success: function(response) {
        							var RecipientTypeCodesData = Ext.decode(response.responseText);
        							Ext.Ajax.request({
                						type: 'rest',
                						url: urlNew,
                						jsonData: recipientIds,
                						method: 'POST',
                						success: function(response) {
                							if(isParentChecked) { // If Parent checkbox is selected
                								// update wsMsgEventRecipientConfigsUpdated with parent ids
                								var wsMsgEventRecipientConfigsParents = {
                    									msgRecipientTypeId: 68,
        				                           	 	msgTemplateConfigId: 0,	//formData.id, 
        				                           	 	selectiveRecipientIds: []
        	            							};
                								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Applicant_Person_Adhoc != null){
    	            								wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Applicant_Person_Adhoc;
    	            							}
        										wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
        										wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
                    						}
                							if(isFeePayerChecked) { // If Fee Payer checkbox is selected
                    							// update wsMsgEventRecipientConfigsUpdated with fee payer ids
                								var wsMsgEventRecipientConfigsFeePayer = {
                    									msgRecipientTypeId: 67,
        				                           	 	msgTemplateConfigId: 0,	//formData.id, 
        				                           	 	selectiveRecipientIds: []
        	            							};
                								if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
    	            								wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
    	            							}
                    							wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
        										wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
                    						}
                							applicantsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isApplicantChecked,isMySelfChecked,currentlyLoggedInUserId, null, isForAll, jsonFormatFormData);
                						}
                					});
        						}
    						});
    					}
    					//studentsendmessage.sendMessage(obj,grid);
    				}
    				
  	        	}
  	        },'applicantsendmessage[itemId=applicationSendMessageWindow]  filefield[itemId=staticUploadFileField]': {
  	        	change: function(fileField, value, eOpts){
  	        		var this$ = this;
  	        		this$.uploadApplicantStaticDocumentFileMessage(fileField, value, eOpts);
  	        	}
  	        },
  	        'applicantstaticdocumentattachmentgrid actioncolumn': {
  	        	click : function(view, rowIndex, colIndex, item, e, record, row){
  	        		this.deleteApplicantStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
  	        	}
  	        },'applicantsendmessage[itemId=applicationSendMessageWindow]': {
  	        	render: function(grid){
  	        		var this$ = this;
  	        		var docGrid = grid.down('#applicantStaticDocumentAttachmentGridMessage');
  	        		docGrid.getStore().removeAll();
  	        		docGrid.getStore().sync();
  	        	}
  	        }, 'applicantsendmessage[itemId=applicationSendMessageWindow] radiogroup#sendingPriority': {
  	        	change: function( radio, newValue, oldValue, eOpts) {
  	        		this.loadApplicantScheduleField(radio, newValue, oldValue);
  	        	}
  	        },
  	        /*V2D-13247*/
  	        'applicantsendmessage[itemId=applicationSendMessageWindow] textarea[itemId=smsDiscription]':{
  	        	change : function(val,nV,oV){
  	        		var maxLength = localStorage.getItem('maxLength');
  	        		var applicantSendmessageForm = this.getApplicantsendmessage();
  	        		var smsTextField = applicantSendmessageForm.down('#smsDiscription');
  	        		var smsTextFieldDiscription = applicantSendmessageForm.down('#smsDiscriptionNotice');            				
  	        		var newValue = maxLength - smsTextField.getValue().length;
  	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
  	        	}
  	        },
            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=sendMessageBtn]': {
	           /* click: function(obj) {
                	var grid = this.getSearchResultGrid();
	            	if (grid.getSelectionModel().getCount() > 0) {
	            		var this$ = this;
	                	var window = this$.getSendMessageWindow();
	                	if(!window){
	                		window = Ext.widget('sendmessagewindow',{
	                			itemId:'applicationSendMessageWindow'
	                		});
	                		window.down('#msgRecipientTypeItemId').setValue(RECIPIENT_TYPES_COSTANTS.APPLICANT);
	                	}
	                	window.show();
	            	} else {
	            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            	}  
	            }*/
            	click: this.openApplicantSendMessage
	        },
	        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=applicantSendMSGToAllBtn]': {
            	click: this.openApplicantSendMessageToAll
            },
	        
	       /* 'sendmessagewindow[itemId=applicationSendMessageWindow] button#adhocMsgSubmitBtn': {
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		button.up('window').sendMessage(button,grid);
    			}
	        },*/
	       /* 'sendmessagewindow[itemId=applicationSendMessageWindow] combo#selectTemplate': {
	        	render: function(combo) {
	        		var store = combo.getStore();
	        		var msgRecipientTypeId = combo.up('window').down('#msgRecipientTypeItemId').getValue();
	        		 store.on('beforeload', function(store, operation) {
	                     store.proxy.extraParams = {
	                    		 msgRecipientTypeId :msgRecipientTypeId
	                     };
	                 });
    			},
    			select :function(combo,records){
    				var msgCategoryId = combo.up('window').down('#msgCategoryId');
    				var msgSubCategoryId = combo.up('window').down('#msgSubCategoryId');
    				msgCategoryId.setValue(records[0].data.msgCategoryId);
    				msgSubCategoryId.setValue(records[0].data.msgSubCategoryId);
    			}
	        },*/
            'addadmissionwindow[itemId=addAdmissionWindow] combo[itemId=cmbApplicationType]': {
                change: function(combo, newValue, oldValue, eOpts) {
                    var me = this;
                    var applicantSearchForm = me.getApplicantSearchForm();
                    var selectedApplicationType = newValue;
                    if (!isNullOrEmpty(selectedApplicationType)) {
                        me.showHideSearchCriteriaFields(selectedApplicationType, applicantSearchForm);
                    }
                    if(selectedApplicationType == 'ENQUIRED_EARLIER'){
                    	var enquiryIdStore=applicantSearchForm.down('#enqId').getStore();
                    	var enquiryNameStore=applicantSearchForm.down('#enqName').getStore();
                    	enquiryIdStore.getProxy().extraParams ={
                    		onlyOpenEnquiry:true
                    	};
                    	enquiryNameStore.getProxy().extraParams ={
                    		onlyOpenEnquiry:true
                    	};
                    	
                    }
                }
            },
            'addadmissionwindow[itemId=addAdmissionWindow] radio': {
                focus: function(cmp, e, eOpts) {
                    this.hideShowPanel(cmp, e, eOpts);
                }
            },
            'addadmissionwindow[itemId=addAdmissionWindow] form[itemId=applicantSearchComponent] button[itemId=searchBtn]': {
                click: function() {
                    var addAdmissionWindow = this.getAddAdmissionWindow();
                    var applicantSearchForm = this.getApplicantSearchForm();
                    this.onSearchButtonClick(this, addAdmissionWindow, applicantSearchForm, 'addAdmissionWindow');
                }
            },
            'addadmissionwindow[itemId=addAdmissionWindow]  combo[itemId=cmbApplicationType]': {
                select: function(cmbApplicationTypeCombo,record) {
                	this.hideShowSearchGrid();
                	var addAdmissionWindow=this.getAddAdmissionWindow();    
                	var proceedBtn = addAdmissionWindow.down('#proceedBtn');
                	if(cmbApplicationTypeCombo.getValue()=='FRESH_APPLICANT'){
                		proceedBtn.setDisabled(false);
                	}else{
                		proceedBtn.setDisabled(true);
                	}                	                	
                }
            },
            'addadmissionwindow[itemId=addAdmissionWindow] grid[itemId=searchGrid]':{
            	select: function(grid, record, index, eOpts){
            		var searchWindow = this.getSearchWindow();
            		var addAdmissionWindow=this.getAddAdmissionWindow();
            		var proceedBtn = addAdmissionWindow.down('#proceedBtn');
            		var searchGridWindow = searchWindow.down('#searchGrid');
                    if(searchGridWindow.getSelectionModel().getCount() > 0){
                    	var record = searchGridWindow.getSelectionModel().getSelection()[0];
                    	if(!isNullOrEmpty(record)){
                        	if(proceedBtn){
                        		proceedBtn.setDisabled(false);
                        	} 
                    	}else{
                    		if(proceedBtn){
                        		proceedBtn.setDisabled(true);
                        	} 
                    	}
                    }
            	}
            },
            
            'addadmissionwindow[itemId=addAdmissionWindow]  button[itemId=proceedBtn]': {
                click: function() {                	
                	var me=this;
                	var proceedFlag=true;
                	var searchResultDataObject=new Object();                	
                	var searchResultGrid=me.getAddAdmissionWindow().down('#searchGrid');
                	
                	var addAdmissionWindow=me.getAddAdmissionWindow();                    	                    	                        	
                	var admissionTypeForm=addAdmissionWindow.down('#admissionTypeForm');
                	var admissionTypeFormData=admissionTypeForm.getForm().getValues();
                	var admissionType=admissionTypeFormData.admissionType;
                	
                	if(searchResultGrid && searchResultGrid.isVisible()){
                		if(searchResultGrid.getSelectionModel().getCount() > 0){
                			var record = searchResultGrid.getSelectionModel().getSelection()[0];
                			if(!isEmpty(record.data)){
                				if(!isNullOrEmpty(record.data.birthDate))
                					record.data.birthDate = new Date(record.data.birthDate);
                					searchResultDataObject=record.data;
                			}
                			proceedFlag=true;
                		}else{
                			proceedFlag=false;
                			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                		}                		             		
                	}else{
                		
                		/* For Form Sold Application Case */
                		if(admissionType===this.FORM_SOLD_APPLICATION){
                			if(searchResultGrid && searchResultGrid.getSelectionModel().getCount() > 0){                    			
                    			proceedFlag=true;
                    		}else{
                    			proceedFlag=false;
                    			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                    		}
                		}
                	}
                	
                	if(proceedFlag){
                		var applicantProfile=me.getTabReferenceByTabTitle(getAdmissionTranslation('APPLICANT_PROFILE'));
                		if(applicantProfile){
                			applicantProfile.close();
                		}
                			me.addContentPanelTab(getAdmissionTranslation('APPLICANT_PROFILE'), 'applicantprofile', null, null, null, null);
                            var applicantProfile=me.getTabReferenceByTabTitle(getAdmissionTranslation('APPLICANT_PROFILE'));
                            if (applicantProfile) {                            	                            	                            	                     		
                            		if(!isEmpty(admissionTypeFormData)){
                            			if(!isNullOrEmpty(searchResultDataObject.saleRefPrimaryId)){
                                            applicantProfile.getApplicationDataObject()['enquiryStudentDetailId']=searchResultDataObject.saleRefPrimaryId;
                            			}                            			

                            			/* Form Sold Case */
                            			if(admissionType===this.FORM_SOLD_APPLICATION){
                            				
                            				applicantProfile.setApplicationId(searchResultDataObject.id);                            				
                            				me.setParameterForApplicantProfile(applicantProfile,null,admissionType,null);
                            				applicantProfile.getApplicationInfo()['applicationStatus']=searchResultDataObject.currentStatus;
                                			me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
                                			me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    
                                			//me.getApplicantProfileInformation(applicantProfile);
                                			me.gettingDataInSummaryGrid(applicantProfile);      
                            			}else{
                            				/* Setting search data in to the object for continue application flow */
                            				if(!isEmpty(searchResultDataObject)){                            				
                                        		searchResultDataObject.code="";
                                        		delete searchResultDataObject.id;
                                        		delete searchResultDataObject.version;
                                        		if(!isEmpty(searchResultDataObject.bankDetail)){
                                                    if(!isNullOrEmpty(searchResultDataObject.bankDetail.id)){
                                                        delete searchResultDataObject.bankDetail.id;
                                                    }
                                                    if(!isNullOrEmpty(searchResultDataObject.bankDetail.version)){
                                                        delete searchResultDataObject.bankDetail.version;        
                                                    }
                                                }
                                        		if (Ext.app.checkVelocity || Ext.app.checkVelocity == "true") {
                                        		    if (!isEmpty(searchResultDataObject.enquirerMobileCountryCode)) {
                                        		        searchResultDataObject.mobileCountryCode = searchResultDataObject.enquirerMobileCountryCode;
                                        		    }
                                        		    if (!isEmpty(searchResultDataObject.enquirerMobileNo)) {
                                        		        searchResultDataObject.mobileNumber = searchResultDataObject.enquirerMobileNo;
                                        		    }
                                        		    if (!isEmpty(searchResultDataObject.enquirerEmailId)) {
                                        		        searchResultDataObject.emailId = searchResultDataObject.enquirerEmailId;
                                        		    }
                                        		}
                                        		applicantProfile.setApplicationDataObject(searchResultDataObject);
                            				}	                                        	
                                        	me.setParameterForApplicantProfile(applicantProfile,null,admissionType,null);
                                    		me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,false);
                                    		me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,false);                                    		
                            			}                            				                             			                            			                            			
                            			var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
                            			if(!isEmpty(applicantLinkPanelObject)){
                            				var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];                            				
                            				me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);
                            				setTimeout(function(){
                            					applicantProfile.down('#applicantPersonRadioBtnPopiaAct').setVisible(false);
                                    		},200);

                            			} 
                            			
                            			Ext.app.TEMP_ADMISSIONTYPE=admissionType;
                                    	addAdmissionWindow.close();
                            		}                    		
                            	                   	
                            }
                		                		                		
                	}                	    
                }
            },
            'addadmissionwindow[itemId=addAdmissionWindow]  button[itemId=cancelBtn]': {
                click: function() {
                	this.getAddAdmissionWindow().close();
                }
            },            
         'basicsearch[itemId=basicSearchPanel]  combo[itemId=academy]': {
                render:function(academyCombo){
//                	this.loadComboWithAllValue(academyCombo);
                	this.loadDefaultAcadLocation(academyCombo.up('#basicSearchPanel'))
                },
               /* select: function(academyCombo) {                	
                	var me=this;
                	var basicSearchForm=this.getApplicationsListBasicSearchForm();
                	if(!isNullOrEmpty(academyCombo.getValue())){
                		var param=new Object();
                		param.academyId=academyCombo.getValue();
                		me.enableDisableCombo(academyCombo,basicSearchForm,'#location',param);
                	}                	                	
                }*/
                change: function(combo, records, eOpts) {
                    var locationComboField = combo.up('form').down('#location');
                    var comboValue = combo.getValue();
	                this.loadDependentCombo( locationComboField, comboValue, 'academyId');
                }
            },
            /*'basicsearch[itemId=basicSearchPanel]  combo[itemId=academyLocationCombo]': {
                render:function(academyLocationCombo){
                	var me = this;
                	var store = academyLocationCombo.getStore();
                	store.load({
            			callback:function(records,response,success){
            				academyLocationCombo.setValue(me.getCurrentAcademyLocation())
            				}
            			});
                	
//                	this.loadComboWithAllValue(academyCombo);
                	//var academyLocationId = this.getCurrentAcademyLocation();
                	//var academyLocationId=Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0];
                	//console.log('academyLocationId...',academyLocationId);
                	//academyLocationCombo.setValue(academyLocationId.rawValue);
                	//this.loadDefaultAcadLocation(academyCombo.up('#basicSearchPanel'))
                },

                change: function(combo, records, eOpts) {
                	var programComboField = combo.up('form').down('#program');
                	var academyLocationCombo = combo.getValue();
                	this.loadDependentCombo(programComboField, academyLocationCombo, 'academyLocationIds');
                }
            },*/
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=location]': {
                /*select: function(locationCombo) {
                	var me=this;
                	var basicSearchForm=this.getApplicationsListBasicSearchForm();
                	if(!isNullOrEmpty(locationCombo.getValue())){                
                		var academyCombo=basicSearchForm.down("#academy");
                		var param=new Object();
                		param.locationId=locationCombo.getValue();//locationId
                		param.academyId=academyCombo.getValue();//academyId
                			me.enableDisableCombo(locationCombo,basicSearchForm,'#program',param);
                	}
                	
                }*/
            	change: function(combo, records, eOpts) {
	                var programComboField = combo.up('form').down('#program');
	                var academyCombo = combo.up('form').down('#academy');
                    var academyValue = academyCombo.getValue(); 
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( programComboField, comboValue, 'locationId','academyId',academyValue);
	            }
            },
            'basicsearch[itemId=basicSearchPanel] multiselectcombofield[itemId=programDepartmentItemId]': {
                render: function(combo) {
                	var me = this;
                	var currentAcademyLocation = me.getCurrentAcademyLocation();
                    var store = combo.getStore();
                    store.getProxy().extraParams = {
                    	academyLocationsIds: currentAcademyLocation
            		};
                	store.load();
                },
                change: function(combo, records, eOpts) {
            		var appForm = combo.up('form');
            		
            		var departmentValues = combo.getValue();
            		
            		var academyLocationCombo = appForm.down('#academyLocationCombo');
            		var programGroupCombo = appForm.down('#programGroup');
                	var programCombo = appForm.down('#program');
                	var batch = appForm.down('#batch');
                	var seatType = appForm.down('#seatType');
                	
                	var programGroupValue = programGroupCombo.getValue();
                	var alValue = academyLocationCombo.getValue();
            		
                	programCombo.setDisabled(false);
                	programCombo.reset();
                	batch.reset();
                	seatType.reset();
                	batch.setDisabled(true);
                	seatType.setDisabled(true);
                	
                }
            },
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=programGroup]': {
            	render: function(programGroupCombo) { 
                	this.loadComboWithAllValue(programGroupCombo);
            	},
            	select: function(programGroupCombo) {   
                	
                	var programComboField = programGroupCombo.up('form').down('#program');
                	var academyLocationField = programGroupCombo.up('form').down('#academyLocationCombo');
                	
                	var programGroupValue = programGroupCombo.getValue();
                	var alValue = academyLocationField.getValue();
                	
                	programComboField.setDisabled(false);
                	programComboField.getStore().getProxy().extraParams = {
                		programGroupId:programGroupValue,
                		academyLocationId:alValue
                	}
                	programComboField.getStore().load();
                	//this.loadDependentCombo(programComboField, value, 'programGroupId');
                	
                }
            },
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=program]': {
                /*select: function(programCombo) {                	
                	var me=this;
                	var basicSearchForm=this.getApplicationsListBasicSearchForm();
                	if(!isNullOrEmpty(programCombo.getValue())){
                	var param= new Object();
                	param.id = programCombo.getValue();
                	me.enableDisableCombo(programCombo,basicSearchForm,'#batch',param);
                	}
                }*/
            	select: function(combo, records, eOpts) {
	                var batchComboField = combo.up('form').down('#batch');
	                this.resetSelectionStageSloteDropdown(combo.up('form').down('#selectionStageCombo'));
	                var comboValue = combo.getValue();
	                this.loadDependentCombo( batchComboField, comboValue, 'id');
	            }
            },
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=batch]': {
            	select:function(combo, records, eOpts) {
	                var seatComboField = combo.up('form').down('#seatType');
	                this.resetSelectionStageSloteDropdown(combo.up('form').down('#selectionStageCombo'));
	                var comboValue = combo.getValue();
	                this.loadDependentCombo( seatComboField, comboValue, 'batchId');
	            }
            },
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=seatType]': {
            	select: function(combo, records, eOpts) {
            		var basicSearchForm = combo.up('form');
            		basicSearchForm.down('#selectionStageCombo').reset();
            		var selectionStageCombo = basicSearchForm.down('#selectionStageCombo');
            		selectionStageCombo.setDisabled(false);
            		this.resetSelectionStageSloteDropdown(selectionStageCombo);
            		var items = combo.getStore().data.items;
            		var PBSTId = null;
            		Ext.each(items, function(item){
						  	if (item.data.seatTypeId == combo.getValue()) {
						  		PBSTId = item.data.id;
							}						  
					   });
            		selectionStageCombo.getStore().getProxy().extraParams={
            			programBatchSeatConfigId:PBSTId
		    			};
            		selectionStageCombo.getStore().load();
	            }
            },
            
            'basicsearch[itemId=basicSearchPanel]' :{
            	afterrender: function(form){
            	var selectStage	= form.down('#selectionStageCombo');
            		 this.loadDFRForSelectionStage(selectStage);

            	}
            },
			
             'basicsearch[itemId=basicSearchPanel]  combo[itemId=intakeYear]': {
            	select: function(combo, records, eOpts) {
	                var spBtnFetchNscDataItemId = this.getSearchResultGrid().down('#spBtnFetchNscDataItemId');
					spBtnFetchNscDataItemId.setDisabled(false);
	            }
            },
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=applicationStatus]': {
            	change: function(combo, records, eOpts) {
	                var comboValue = combo.getValue();

	                var container = combo.up('form');
	                selectionProcess = container.down('combo[itemId=selectionProcess]');
	                stageStatus = container.down('combo[itemId=stageStatus]');
	                if(comboValue=='DIRECT_ADMISSION'){
	                	selectionProcess.setDisabled(true);
	                	selectionProcess.reset();
	                	stageStatus.setDisabled(true);
	                	stageStatus.reset();
	                }else{
	                	selectionProcess.setDisabled(false);
	                	stageStatus.setDisabled(false);
	                }
	            }
            },
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=stageStatus]': {
            	render: function(combo, records, eOpts) {
            		combo.getStore().load();
//            		console.log('stage status load'+combo);
	            }
            },
            
            'basicsearch[itemId=basicSearchPanel]  combo[itemId=selectionProcess]': {
            	render: function(selectionProcessCombo) {   
                	this.loadComboWithAllValue(selectionProcessCombo);
                },
            	change : function(selectionProcessCombo) {  
                	var me= this;
                	var basicSearchForm=this.getApplicationsListBasicSearchForm();
                	if(selectionProcessCombo.getValue()){
                		var param = new Object();
                		param.selectionProcessId=selectionProcessCombo.getValue();
                		me.enableDisableCombo(selectionProcessCombo,basicSearchForm,'#selectionProcessStage',param);
                	}
                	else{
                		me.enableDisableCombo(selectionProcessCombo,basicSearchForm,'#selectionProcessStage',null,true);
                	}
                }
            }, 
            
            'programsearch[itemId=programSearchPanel]  combo[itemId=academy]': {            	 
              /*  render: function(academyCombo) {   
                   	this.loadComboWithAllValue(academyCombo);
                },  */               
                select: function(academyCombo) {  
                	var me=this;
                	var programSearchForm=this.getApplicationsListProgramSearchForm();
                	if(!isNullOrEmpty(academyCombo.getValue())){
                		var param= new Object();
                		param.academyId = academyCombo.getValue();
                		me.enableDisableCombo(academyCombo,programSearchForm,'#location',param);
                	}
                }
            },
            'programsearch[itemId=programSearchPanel]  combo[itemId=location]': {
                select: function(locationCombo) {   
                	var me =this;
                	var programSearchForm=this.getApplicationsListProgramSearchForm();
                	if(!isNullOrEmpty(locationCombo.getValue())){
                		var param= new Object();
                		param.academyLocationId = locationCombo.getValue();
                	me.enableDisableCombo(locationCombo,programSearchForm,'#program',param);
                	}
                }
            },            
            'programsearch[itemId=programSearchPanel]  combo[itemId=program]': {
                select: function(programCombo) {    
                	var me= this;
                	var programSearchForm=this.getApplicationsListProgramSearchForm();
                	if(!isNullOrEmpty(programCombo.getValue())){
                		var param = new Object();
                		param.id =programCombo.getValue();
                		me.enableDisableCombo(programCombo,programSearchForm,'#batch',param);
                	}
                }
            },
            'programsearch[itemId=programSearchPanel]  combo[itemId=batch]': {
                select: function(batchCombo) { 
                	var me= this;
                	var programSearchForm=this.getApplicationsListProgramSearchForm();
                	if(!isNullOrEmpty(batchCombo.getValue())){
                		var param = new Object();
                		param.batchId = batchCombo.getValue();
                	me.enableDisableCombo(batchCombo,programSearchForm,'#seatType',param);
                	}
                }
            },
            'programsearch[itemId=programSearchPanel]  combo[itemId=selectionProcessStage]': {
                render: function(selectionProcessStageCombo) {   
                	this.loadComboWithAllValue(selectionProcessStageCombo);
                }
            },
            
            'applicationuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	   			   change: this.downloadUploadFormChange
	   		},
	   		
	   	    'bulkofferstatusupdatestructure radiogroup[itemId=importDownloadgroupId]':{
  			   change: this.downloadUploadFormChangeBulkOfferStatus
  		    },
  		    
  			'applicationsuploaddownloadstructure radiogroup[itemId=importDownloadreadiogroupId]':{
	   			   change: this.downloadUploadApplicationFormChange
	   		},
	   		
	   		'applicationsnewuploaddownloadstructure radiogroup[itemId=importDownloadreadiogroupId]':{
	   			   change: this.downloadUploadApplicationNewFormChange
	   		},
	   	   'importapplicantrelationshipstructure radiogroup[itemId=importApplicantRelationshipRadioGroupItemId]':{
   			   change: this.downloadUploadFormChangeApplicantRelationship
	   	   },
	   	 'importbulkadmissionapprovaluploaddownloadstructure radiogroup[itemId=importBulkAdmissionApprovalDownloadradiogroupId]':{
			   change: this.downloadUploadBulkAdmissionApprovalFormChange
		   },
		   'bulkupdateapplicationstatusuploaddownloadstructure radiogroup[itemId=bulkUpdateApplicationStatusDownloadRadioGroupId]':{
			   change: this.downloadUploadUpdateApplicationStatusFormChange
		   },
	   	'importtabstructure radiogroup[itemId=importDownloadradiogroupId]':{
			   change: function( radioGroup, newValue, oldValue, eOpts) {
   				 var field=this.getImporttabstructure().down('#templateTypeLoderItemId');
  				 var templateName = field.getValue();
  				 var structure=this.getImporttabstructure();
 					this.hideAllForm(structure);
   				 switch (templateName){
 				 case 'IMPORT_BULK_APPLICATION_NEW':
 					this.downloadUploadApplicationNewFormChange(structure, newValue, oldValue);
 					 break;
 				case 'IMPORT_BULK_ADMISSION':
 	   			    this.downloadUploadFormChange(structure, newValue, oldValue);
 					 break;
 				case 'IMPORT_BULK_APPLICATION':
 					this.downloadUploadApplicationFormChange(structure, newValue, oldValue);
 					break;
 				case 'IMPORT_APPLICANT_PAST_HISTORY':
 					this.applicantPastHistoryLoaderRadioBtn(structure, newValue, oldValue);
 					break;
 				case 'IMPORT_APPLICANT_RELATIONSHIP':
 					   this.downloadUploadFormChangeApplicantRelationship(structure, newValue, oldValue);
 					 break;
 				case 'IMPORT_BULK_ADMISSION_APPROVAL':
					   this.downloadUploadBulkAdmissionApprovalFormChange(structure, newValue, oldValue);
					 break;
				case 'BULK_UPDATE_APPLICATION_STATUS':
						this.downloadUploadUpdateApplicationStatusFormChange(structure, newValue, oldValue);
					  break;
 				default : null;
 				 }
 				
			   }
	   	   },
	   	   
	   		'applicationsuploadform button[itemId=resetBtn]':{
	   			click: function() {
	   				var applicationuploadForm = this.getApplicationsuploadform().getForm();
	   				applicationuploadForm.findField('file').reset();
	   				var uploadoptionradiogroupform  = this.getApplicationsUploaduploadoptionradiogroup();
	   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	   					isUploadAll: false
	   				});
	   			}
	   		},
	   		
	   		'basicsearch customcombobox[itemId=dliAdmAssignToItemId]': {
	   			focus : function(combo){
	   				var form = this.getBasicsearch().getForm();
	   				var academyLocationId = combo.up('form').down('#academyLocationCombo').getValue();
	   				var alIds = [];
	   				var academyLocationIds;
	   				if (academyLocationId != undefined) {
	   					alIds.push(academyLocationId);
	   					academyLocationIds = alIds.join();
	   				} else {
	   					alIds.push(this.getCurrentAcademyLocation());
	   					academyLocationIds = alIds.join();
	   				}

	   				var applicationOwnerId = combo.up('form').down('#dliAdmAssignToItemId');
	   				applicationOwnerId.reset();
	   				var applicationOwnerStore = applicationOwnerId.getStore();
	   				applicationOwnerStore.getProxy().extraParams = {
	   					academyLocationIds: academyLocationIds
	   				};
	   				applicationOwnerStore.load();
	   			}
	   		},



	   		'importapplicationsnewuploadform button[itemId=resetBtn]':{
	   			click: function() {
	   				var newApplicationUploadForm = this.getImportapplicationsnewuploadform().getForm();
	   				newApplicationUploadForm.findField('file').reset();
	   				var uploadoptionradiogroupform  = this.getImportapplicationsnewUploaduploadoptionradiogroup();
	   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	   					isUploadAll: false
	   				});
	   			}
	   		},
	   		
	   		
	   		'importapplicationsnewuploadform button[itemId=uploadId]':{
	   			click:function(obj){
	   				var $this=this;
	   				var importWin=$this.getImportapplicationsnewuploadform()
	   				var grdStore;
	   				var form=$this.getImportapplicationsnewuploadform();
	   				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    	        	$this.getHashOfFile(form);
		        	setTimeout(function() {
		   				form.getForm().submit({
		   					method : 'POST',
		   					url : submitUrl,
		   					success : function(form, action){
		   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		   					},
		   					failure: function(form, action) {
   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		   					}
		   				});
		        	},1000);
	   				Ext.defer(function() {
	   					var grid = $this.getImportlistnewapplicant();
	   					var form =this.getImportapplicationsnewUploaduploadoptionradiogroup();
	   					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_NEW_BULK_APPLICATION');
	   				}, 2000, this);
	   			}  
	   		},
	   		'importapplicationsnewuploadform uploadoptionradiogroup[itemId=importapplicationsnewUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	   			change: function( radioGroup, newValue, oldValue, eOpts){
	   				var grid =this.getImportlistnewapplicant();
	   				var form =this.getImportapplicationsnewUploaduploadoptionradiogroup();
	   				var isUploadAll = newValue.isUploadAll;
	   				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_NEW_BULK_APPLICATION');
	   			}   
	   		},
	   		
		 'importapplicationsnewuploadform':{
			 show:function(obj){
				 var $this=this;
				 var structure=$this.getImporttabstructure();
 	        	var importWin=structure.down('#importapplicationsnewuploadformId');
				 var moduleName = importWin.down('#moduleName');
				 moduleName.getStore().load({
					 callback: function(records, operation, success) {
						 for(var i in records){
							 if(records[i].data.value=="Bulk Application New"){
								 moduleName.setValue(records[i].data.id);
								 moduleName.setReadOnly(true)
							 }
						 }
					 }	
				 });
			 }  
		 },
	   		
		 'importapplicationsnewdownloadform button[itemId=resetBtn]':{
			 click: function() {
				 var newApplicationDownloadForm = this.getImportapplicationsnewdownloadform().getForm();
				 newApplicationDownloadForm.reset();
			 }
		 },
	   		
	   		'importapplicationsnewdownloadform button[itemId=downoladBtnId]':{
	   			click: function() {
	   				var form = this.getImportapplicationsnewdownloadform();
	   				var alId= form.down('#academyLocationCombo').getValue();
	   				var csvForm = Ext.create('Ext.form.Panel',{

	   				});
	   				csvForm.getForm().submit({
	   					target: '_blank',
	   					method:'POST',
	   					params :{access_token : Ext.Ajax.defaultHeaders.access_token, 'academyLocationId' : alId},
	   					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	   					url: SERVERURL.PATH_DOWN_LOAD_APPLICATION_TEMPLATE,
	   					standardSubmit :true,
	   					success : function(form, action){
	   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	   					},
	   					failure: function(form, action) {
	   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	   					}
	   				});
	   			}
	   		},
	   		
	   		'importlistnewapplicant':{
	   			render:function(obj){
	   				var $this = this;
	   				var grid = $this.getImportlistnewapplicant();
	   				var form =this.getImportapplicationsnewUploaduploadoptionradiogroup();
   					var isUploadAll = form.items.items[0].getValue().isUploadAll;
   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_NEW_BULK_APPLICATION');
	   			},
	   			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   				if (e.target.tagName == 'A') {
	   					var fileType=null;
	   					if(cellIndex==1){
	   						fileType='successFile';
	   					}else if(cellIndex==6){
	   						fileType='errorFile';
	   					}else if(cellIndex==7){
	   						fileType='logFile';
	   					}
	   					var documentId = record.get("id");
	   					if (!isNullOrEmpty(documentId)) {
	   						this.getDownloadFile(documentId,fileType);
	   					}
	   				}
	   			}
	   		},
	   		'importlistapplicanthistoryloader':{
	   			show:function(obj){
	   				var $this = this;
	   				var structure=$this.getImporttabstructure();
	   				var grid = structure.down('#importlistapplicanthistoryloaderId');
	   				var form  = $this.getApplicantpasthistoryuploadoptionradiogroup();
	   				var isUploadAll = form.items.items[0].getValue().isUploadAll;
		          	var applicantHistoryUploadForm=structure.down('#applicantcompetitivepasthistoryloaderuploadformId');
		          	var templateName = applicantHistoryUploadForm.getValues().uploadType;
		          	var moduleName = null;
		          	switch (templateName){
		          		case 'CompetitiveExam':
		          			moduleName = 'APPLICANT_BULK_COMPETITIVE_EXAM';
		          			break;
		          		case 'EducationHistory':
		          			moduleName = 'APPLICANT_BULK_EDUCATION_HISTORY';
		          			break;
		          	  	default : null;
		          	}
	   				$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	   			},
	   			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	   				if (e.target.tagName == 'A') {
	   					var fileType=null;
	   					if(cellIndex==1){
	   						fileType='successFile';
	   					}else if(cellIndex==6){
	   						fileType='errorFile';
	   					}else if(cellIndex==7){
	   						fileType='logFile';
	   					}
	   					var documentId = record.get("id");
	   					if (!isNullOrEmpty(documentId)) {
	   						this.getDownloadFile(documentId,fileType);
	   					}
	   				}
	   			}
	   		},
	   		'importlistnewapplicant button[itemId=btnForce]':{
	   			click: function(obj) {
	   				var grid = this.getImportlistnewapplicant();
	   				if (grid.getSelectionModel().getCount() > 0) {
	   					if(grid.getSelectionModel().getCount() > 1){
	   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
	   					}else{
	   						var this$ = this;
	   						var id = grid.getSelectionModel().selectionStart.data.id;
	   						console.log(id);
	   						var urlAppend="?jobName="+id;
	   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	   						Ext.Ajax.request({
	   							url: submitURL,
	   							method: 'GET',
	   							success: function(response) {
	   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	   									//console.log("Manual trigger hit");
	   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	   								}else if(response.responseText==="SUCCESS"){
	   									//console.log("Manual trigger hit");
	   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	   								}
	   							}
	   						});
	   					}
	   				} else {
	   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	   				}  
	   			}
	   		},

	   		
	   		'applicationsuploadform button[itemId=uploadId]':{
	        		click:function(obj){
	        			var $this=this;
	    	        	var importWin=$this.getApplicationsuploadform()
	    	        	var grdStore;
	    	        	var form=$this.getApplicationsuploadform();
	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
	    	        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			        	setTimeout(function() {
		    	        	form.getForm().submit({
		    	        		method : 'POST',
		    	        		url : submitUrl,
		    	        		success : function(form, action){
		    	        			Ext.getBody().unmask();
		    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		    	    	        },
		    	        		failure: function(form, action) {
		    	        			Ext.getBody().unmask();
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		    	    	        }
		    	        	});
			        	},1000);

	        			 Ext.defer(function() {
	        				 var grid = $this.getImportlistapplicant();
	        				 var form = $this.getApplicationsUploaduploadoptionradiogroup();
	        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ADMISSION');
	         	        }, 2000, this);
	        		}  
    		 },
    		 'applicationsuploadform uploadoptionradiogroup[itemId=applicationsUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
    			 change: function( radioGroup, newValue, oldValue, eOpts){
    				 var grid =this.getImportlistapplicant();
    				 var form =this.getApplicationsUploaduploadoptionradiogroup();
    				 var isUploadAll = newValue.isUploadAll;
    				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ADMISSION');
    			 }   
    		 },
    		 
    		 'applicationsuploadform':{
	        		show:function(obj){
	        			var $this=this;
	        			var structure=$this.getImporttabstructure();
	    	        	var importWin=structure.down('#applicationsuploadformId');
	    	        	var moduleName = importWin.down('#moduleName');
	    	        	moduleName.getStore().load({
	    	        		callback: function(records, operation, success) {
	    	        			for(var i in records){
		    	        			if(records[i].data.value=="Bulk Admissions"){
		    	        				moduleName.setValue(records[i].data.id);
		    	        				moduleName.setReadOnly(true)
		    	        			}
	    	        			}
 	            		   }	
	    	        	});
	        		}  
    		 },
    		 
    		 
    		 
    		 'importapplicationsuploadform button[itemId=resetBtn]':{
 	   			click: function() {
 	   				var applicationuploadForm = this.getImportapplicationsuploadform().getForm();
 	   				applicationuploadForm.findField('file').reset();
 	   				var uploadoptionradiogroupform  = this.getImportapplicationsUploaduploadoptionradiogroup();
 	   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
 	   					isUploadAll: false
 	   				});
 	   			}
 	   		 },
    		 'importapplicationsuploadform uploadoptionradiogroup[itemId=importapplicationsUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
    			 change: function( radioGroup, newValue, oldValue, eOpts){
    				 var grid =this.getImportlistapplications();
    				 var form =this.getImportapplicationsUploaduploadoptionradiogroup();
    				/* 
    				 var templateName = form.getValues().uploadType;
     				 var moduleName = null;
     				 var loaderName = null;
     				 switch (templateName){
     				 case 'CompetitiveExam':
     					 moduleName = 'APPLICANT_BULK_COMPETITIVE_EXAM';
     					 break;
     				 case 'EducationHistory':
     					 moduleName = 'APPLICANT_BULK_EDUCATION_HISTORY';
     					 break;
     				 default : null;
     				 }
     				*/ 
    				 var isUploadAll = newValue.isUploadAll;
    				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid,'IMPORT_BULK_APPLICANT');
       			 }   
    		 },
 	   		
    		 'importapplicationsuploadform button[itemId=uploadId]':{
	        		click:function(btn){
	        			if(!preventMultipleCalls(btn)){
	                		return false;
	                	}
	        			var $this=this;
	    	        	var importWin=$this.getImportapplicationsuploadform()
	    	        	var grdStore;
	    	        	var form=$this.getImportapplicationsuploadform();
	    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
	    	        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			        	setTimeout(function() {
		    	        	form.getForm().submit({
		    	        		method : 'POST',
		    	        		url : submitUrl,
		    	        		success : function(form, action){
		    	        			Ext.getBody().unmask();
		    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		    	    	        },
		    	        		failure: function(form, action) {
		    	        			Ext.getBody().unmask();
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		    	    	        }
		    	        	});
			        	},1000);

	    	        	Ext.defer(function() {
	    	        		var grid = $this.getImportlistapplications();
	    	        		var form = $this.getImportapplicationsUploaduploadoptionradiogroup();
	    	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	    	        		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_APPLICANT');
	    	   			}, 2000, this);
	        		}  
    		 },
    		 
    		 'importapplicationsuploadform':{
	        		show:function(obj){
	        			var $this=this;
	    	        	var structure=$this.getImporttabstructure();
	    	        	var importWin=structure.down('#importapplicationsuploadformId');
	        			var moduleName = importWin.down('#moduleName');
	    	        	moduleName.getStore().load({
	    	        		callback: function(records, operation, success) {
	    	        			for(var i in records){
		    	        			if(records[i].data.value=="Bulk Applications"){
		    	        				moduleName.setValue(records[i].data.id);
		    	        				moduleName.setReadOnly(true)
		    	        			}
	    	        			}
	            		   }	
	    	        	});
	        		}  
    		 },
	   		
	   		'applicationsdownloadform button[itemId=resetBtn]':{
	   			click: function() {
	   				var applicationdownloadForm = this.getApplicationsdownloadform().getForm();
	   				applicationdownloadForm.reset();
	   			}
	   		},
	   		
	   		'applicationsdownloadform button[itemId=downoladBtnId]':{
	   			click: function() {
	   					
	   					var form = this.getApplicationsdownloadform();
	   		   			var alId= form.down('#academyLocationCombo').getValue();
	   					var csvForm = Ext.create('Ext.form.Panel',{
	   		   			
	   		   			});
	   					
	   		   			csvForm.getForm().submit({
	  	        		  target: '_blank',
	  	        		  method:'POST',
	  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token, 'academyLocationId' : alId},
	  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	  	        		  url: SERVERURL.DOWNLOAD_TEMPLATE_STUDENT_PROFILE_CREATE,
	  	        		  standardSubmit :true,
	  	        		  success : function(form, action){
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	          },
	        		  failure: function(form, action) {
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	          }
	  	        	  });
	   			}
	   		},
	   		
	   	    'importapplicationsdownloadform button[itemId=resetBtn]':{
	   			click: function() {
	   				var applicationdownloadForm = this.getImportapplicationsdownloadform().getForm();
	   				applicationdownloadForm.reset();
	   			}
	   		},
	   		
	   		'importapplicationsdownloadform button[itemId=downoladBtnId]':{
	   			click: function() {
	   					
	   					var form = this.getImportapplicationsdownloadform();
	   		   			var alId= form.down('#academyLocationCombo').getValue();
	   		   			var applicationType = form.down('#applicationTypeId').getValue();
	   					var csvForm = Ext.create('Ext.form.Panel',{
	   		   			
	   		   			});
	   					
	   		   			//csvForm.down('#exportListDTO').setValue(Ext.encode(jsonData));
	   		   			csvForm.getForm().submit({
	  	        		  target: '_blank',
	  	        		  method:'POST',
	  	        		  params :{access_token : Ext.Ajax.defaultHeaders.access_token, 'academyLocationId' : alId,'applicationType':applicationType},
	  	        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	  	        		  url: SERVERURL.DOWNLOAD_TEMPLATE_FOR_APPLICANT_CREATION,
	  	        		  standardSubmit :true,
	  	        		  success : function(form, action){
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	          },
	        		  failure: function(form, action) {
	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	    	          }
	  	        	  });
	   			}
	   		},
	   		
	   		'importlistapplicant':{
	   			render:function(obj){
	   				var $this = this;
 		    		var grid = $this.getImportlistapplicant();
 		    		var form = $this.getApplicationsUploaduploadoptionradiogroup();
 		    		var isUploadAll = form.items.items[0].getValue().isUploadAll;
 		    		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_ADMISSION');
	   			},
 		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				if (e.target.tagName == 'A') {
    					var fileType=null;
    					if(cellIndex==1){
    						fileType='successFile';
    					}else if(cellIndex==6){
    						fileType='errorFile';
    					}else if(cellIndex==7){
    						fileType='logFile';
    					}
    					var documentId = record.get("id");
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId,fileType);
    					}
    				}
    			}
	   		},
	   		
	   		'importlistapplications':{
	   			render:function(obj){
	   				var $this = this;
 		    		var grid = $this.getImportlistapplications();
 		    		var form = $this.getImportapplicationsUploaduploadoptionradiogroup();
	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
	        		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_APPLICANT');
	   			},
 		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
    				if (e.target.tagName == 'A') {
    					var fileType=null;
    					if(cellIndex==1){
    						fileType='successFile';
    					}else if(cellIndex==6){
    						fileType='errorFile';
    					}else if(cellIndex==7){
    						fileType='logFile';
    					}
    					var documentId = record.get("id");
    					if (!isNullOrEmpty(documentId)) {
    						this.getDownloadFile(documentId,fileType);
    					}
    				}
    			}
	   		},
	   		
	   	  'importlistapplicant button[itemId=btnForce]':{
	   			click: function(obj) {
		            	var grid = this.getImportlistapplicant();
		            	if (grid.getSelectionModel().getCount() > 0) {
		            		if(grid.getSelectionModel().getCount() > 1){
			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			        		}else{
			        			var this$ = this;
	   	                	//var id = grid.getSelectionModel().selectionStart.data.id;
	   	                	var id = grid.getSelectionModel().getSelection()[0].data.id;
	   	                	console.log(id);
	   	                	var urlAppend="?jobName="+id;
	   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
	   	    	        	Ext.Ajax.request({
	   	    	        		url: submitURL,
	   	    	        		method: 'GET',
	   	    	        		success: function(response) {
	   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
	   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
	   	    	        			}else if(response.responseText==="SUCCESS"){
	       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	   	    	        			}
	   	    	        		}
	   	    	        	});
			        		}
		            	} else {
		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            	}  
		            }
	 		   },
	 		 
	 		   
	 		  'importlistapplications button[itemId=btnForce]':{
		   			click: function(obj) {
			            	var grid = this.getImportlistapplications();
			            	if (grid.getSelectionModel().getCount() > 0) {
			            		if(grid.getSelectionModel().getCount() > 1){
				        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				        		}else{
				        			var this$ = this;
		   	                	var id = grid.getSelectionModel().selectionStart.data.id;
		   	                	console.log(id);
		   	                	var urlAppend="?jobName="+id;
		   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		   	    	        	Ext.Ajax.request({
		   	    	        		url: submitURL,
		   	    	        		method: 'GET',
		   	    	        		success: function(response) {
		   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		   	    	        			}else if(response.responseText==="SUCCESS"){
		       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		   	    	        			}
		   	    	        		}
		   	    	        	});
				        		}
			            	} else {
			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			            	}  
			            }
		 		   },
        		
		 		   'applications':{
		 			   render:function(structure){
		 				   this.disableImportApplicationsBulkAdmission(structure, this.getAPPLICANT_PERMISSIONS());
		 			   },
		 			   afterrender : function(structure){
		 				   var $this = this;
		 				   structure.body.on('scroll', function(e, target) {
		 					   var applicationGrid = $this.getSearchResultGrid();
		 					  if(structure.items.items[0].activeTab.title=="Bulk Document Download Status")
		 						  {
		 						 grid=structure.down('applicationbulkdownloadstatusgrid');
		 						if(structure.body.isScrollable() == false){
		 							$this.getGridHeaderFreeze(grid,structure,true);			
	 		        				}
		             			//$this.getGridHeaderFreeze(grid,structure,true);
		 						  }else
		 							  {
		 							 grid = $this.getSearchResultGrid();
		 							
		 								$this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,false); 			
		 		        				
		 							  }

		 					  
		 					   
		 				   });
		 				   
		 				  var tabpanel = structure.down('tabpanel');
			 				 var advancedsearchquerybuilder = structure.down('tabpanel').down('advancedsearchquerybuilder');
			 				var associatedAcadLocationIds = new Array();
		        			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		        			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICANT_PERMISSIONS());
			 			   if(permissionList.indexOf('ADVANCESEARCH') == -1){
			 				  tabpanel.remove(advancedsearchquerybuilder);
			 			   }
		 			   }
		 		   },
	 		   
	 		  /*ACD-12541*/
	 		   'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=bulkDownloadDocId]': {
	 			   click: function() {
	 				   var grid = this.getSearchResultGrid();
	 				   if (grid.getSelectionModel().getCount() > 0) {
	 					   var bulkDocDownloadItemId ="applicantbulkdownloaddocumentwin";
	 					   var bulkDocDownloadWin = Ext.widget('bulkdownloaddocumentwin', {
	 						   itemId: bulkDocDownloadItemId
	 					   });

	 					   var formWindowTab = this.getBulkdownloaddocumentwin();
	 					   
	 					   var applicationDocumentsId = formWindowTab.down("#applicationDocumentsId");
	 					   var applicationDocumentsIdStore = applicationDocumentsId.getStore();
	 					   
	 					   applicationDocumentsIdStore.getProxy().extraParams = {
	 						   personType:'APPLICANT',
	 						   isApplicableForStudent: true
	 					   };
	 					   
	 					   var userName = formWindowTab.down("#user_name");
	 					   var userNameStore = userName.getStore();
	 					   var userId = this.getCurrentlyLoggedInUser().id;
	 					   userNameStore.load({
	 						   callback: function(records, operation, success) {
	 							   if (success) {
	 								  /* if(records.length == 1){
	 									   facultyCombo.setValue(records[0].data.id);
	 									   $this.topicsAvailabiltiy(records[0].data.id);
	 								   }*/
	 								 /* records.forEach(function(obj){
	 					    	        	//var rec = records.findRecord('id',records.id);
	 					    	        	if(obj.data.id == userId){
	 					    	        		userName.setValue(obj.data.id);
	 					    	        	}
	 					    	        });*/
	 								  for(var i in records) {
		 								   	if(records[i].data.id == userId){
		 								   	userName.setValue(records[i].data.id);
		 								   	}
	 								   }
	 							   }
	 						   }	   
	 					   });
	 					  bulkDocDownloadWin.show();
	 					  
	 				   } else {
	 					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	 				   } 
	 			   }
	 		   },
	 		   /*Reset Bulk document win*/
	 		   'bulkdownloaddocumentwin[itemId=applicantbulkdownloaddocumentwin] button[itemId=bulkDocCancel]': {	 			  
	 			   /*click: function() {
	 				   var bulkDocWin = this.getBulkdownloaddocumentwin();
	 				   var bulkDocForm = bulkDocWin.down('form');
	 				   bulkDocForm.getForm().reset();
	 			   }*/	 		   
	 			   click:function(obj){
	 				   obj.up('window').close();
	 			   }
	 		   },
	 		   
	 		  /*Reset Bulk document win*/
	 		   'bulkdownloaddocumentwin[itemId=applicantbulkdownloaddocumentwin] button[itemId=submitBtn]': {	 			  
	 			   click: function(obj) {
	 				  this.sendBulkDocumentGenerateDetail(obj);
	 			   }	 			  
	 		   },
	 		   'selectionsnapshotgrid': {
	 			   select: function(me, record, index, eOpts) {
//	 				   console.log("row click");
	 				   var portalId = this.getCurrentLoggedPortalId();
	 				   if (portalId == 6) {
	 					   //var grid = this.getSelectionSnapShotGrid();
	 					   var grid = Ext.ComponentQuery.query('#newApplicantPortalWindow')[0].down('grid');
	 					   var btnAcceptOfferItemId = grid.down("#btnAcceptOfferItemId");
	 					   var btnDeclineOfferItemId = grid.down("#btnDeclineOfferItemId");
	 					   if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) &&
	 							   (record.data.currentStatus == 'OFFER_LETTER_ISSUED' || record.data.currentStatus == 'PROVISIONAL_OFFER_ISSUED')) {
	 						   btnAcceptOfferItemId.setDisabled(false);
	 						   btnDeclineOfferItemId.setDisabled(false);
	 					   } else {
	 						   btnAcceptOfferItemId.setDisabled(true);
	 						   btnDeclineOfferItemId.setDisabled(true);
	 					   }
	 				   }
	 			   },
	 			  beforerender: function(grid) {
	 				  if(portalId==6){
	 					 this.offerAcceptAndRejectLettreButtonPivileges(grid, this.getAPPLICANT_OFFER_LETTER_PERMISSIONS());
	 				  }
	 			   },
	 			   afterrender: function(grid, eOpts){
	 				   var me = this;
	 				   //-- Seat Type field on the Selection Snapshot grid must be hidden for schools (V2D-16943)
	 				   if(!isNullOrEmpty(localStorage.getItem('wheatherSchool')))
	 				   {
	 					   if(localStorage.getItem('wheatherSchool')==true || localStorage.getItem('wheatherSchool')=="true")
	 					   {
	 						   Ext.each(grid.columns, function(currentColumn){
	 							   if(currentColumn.dataIndex=="seatType.value")
	 							   {
	 								   currentColumn.destroy();	
	 							   } 							  
	 						   });
	 					   }
	 				   }
	 				   if(portalId!=6) {
	 				   me.addDataGridConfigButton(grid,me.getAPPLICANT_SELECTION_SNAPSHOT_PERMISSIONS());
	 				   } else {
	 					   Ext.each(grid.columns, function(currentColumn){
	 						   if(currentColumn.dataIndex=="applicationCode") {
	 							   currentColumn.destroy();	
	 						   } 							  
	 					   });
	 				   }
	 				   var gridStore = grid.getStore();
	 				   gridStore.on('load', function(){
	 					   setTimeout(function(){
	 						   if(grid.getStore().data.length>0){
	 							   grid.getSelectionModel().select(0);
	 						   }
	 					   },1000);
	 				   },grid);
	 				   
	 				  if(portalId==6){
	 					 //grid.columns[5].hide(false);
	 					 var columnModel = [{
	 				        header: getAdmissionTranslation('ACADEMY'), //Academy
	 				        dataIndex: 'academy.value',
	 				        sortable: true,
	 				        flex: .2
	 				    }, {
	 				        header: getAdmissionTranslation('LOCATION'), //Location
	 				        dataIndex: 'location.value',
	 				        sortable: true,
	 				        flex: .2
	 				    }, {
	 				        header: getAdmissionTranslation('PROGRAM'), //Program
	 				        dataIndex: 'program.value',
	 				        sortable: true,
	 				        flex: .2
	 				    }, {
	 				        header: getAdmissionTranslation('BATCH'), //Batch
	 				        dataIndex: 'batch.value',
	 				        sortable: true,
	 				        flex: .2
	 				    }, {
	 				        header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
	 				        dataIndex: 'seatType.value',
	 				        sortable: true,
	 				        flex: .2
	 				    }, {
	 				        header: getAdmissionTranslation('SELECTION_PROCESS'), //Seat Type
	 				        dataIndex: 'selectionProcess.value',
	 				        //sortable: true,
	 				        flex: .3,
	 				        hidden: false
	 				    },  {
	 				        header: getCommonTranslation('OFFER_STATUS'), //Program Status
	 				        dataIndex: 'currentStatus',
	 				        sortable: true,
	 				        flex: .3,
	 				        renderer: function(obj) {
	 							return getAdmissionTranslation(obj);
	 						}	 						
	 				    }, {
	 				        header: getAdmissionTranslation('PROVISIONAL_OFFER'),
	 				        dataIndex: 'provisionalOfferLetterIssuedFileName',
	 				        flex: .3,
	 				        renderer:function(value,rec){
	 							if(value!="" && value!=undefined && value != null){
	 								return '<a href="#">'+value+'</a>';
	 							}else{
	 								return "";
	 							}
	 						},
	 						hidden: false
	 				    }, {
	 				        header: getCommonTranslation('OFFER_LETTER'), //Seat Type
	 				        dataIndex: 'offerLetterIssuedFileName',
	 				        //sortable: true,
	 				        flex: .3,
	 				        renderer:function(value,rec){
	 							//var id=rec.record.data.id;
	 							if(value!="" && value!=undefined && value != null){
	 								return '<a href="#">'+value+'</a>';
	 							}else{
	 								return "";
	 							}
	 						},
	 						hidden: false
	 				    }];
	 					 
	 					//grid.reconfigure(null,columnModel);
	 					
	 					if(environment=="Production"){
							 var newJSArray = [
								 'resources/js/ckeditor/ckeditor.js',
								 'resources/jsPDF/jspdf.min.js',
								 'resources/jsPDF/jspdf.plugin.table.js',
								 'resources/jsSvgToPng/canvg.js',
								 'resources/js/html2canvas.min.js',
							     'https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js',
							     'https://cdnjs.cloudflare.com/ajax/libs/moment-timezone/0.5.45/moment-timezone.min.js',
								 'constants.js',
								 'webcam/webcam.js'
								 ];
							 loadAsync(newJSArray,0);
						 }  
	 				  }
	 				 if(portalId==6){
	 					 me.addDataGridConfigButton(grid,me.getAPPLICANT_OFFER_LETTER_PERMISSIONS());
	 				  }
	 			   },
	 			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	   				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	   				   if(columnName == "offerLetterIssuedFileName"){
	            			   if(e.target.tagName=='A'){
	            				 // if(record.data.fileName.length == 1){
	      						   var csvForm = Ext.create('Ext.form.Panel'); 
								   csvForm.getForm().submit({
									   target: '_blank',
									   method:'GET',
									   params :{
										   access_token : Ext.Ajax.defaultHeaders.access_token
									   },
									   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
									   url: SERVERURL.PATH_DOWNLOAD_OFFER_LETTER_ISSUED +'/'+record.data.applicationProgramDetailId,
									   standardSubmit :true
								   });
	            				 // }
	            			   }
	   				   }
	   				   if(columnName == "provisionalOfferLetterIssuedFileName"){
	   					   if(e.target.tagName=='A'){
     						   var csvForm = Ext.create('Ext.form.Panel'); 
							   csvForm.getForm().submit({
								   target: '_blank',
								   method:'GET',
								   params :{
									   access_token : Ext.Ajax.defaultHeaders.access_token
								   },
								   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
								   url: SERVERURL.PATH_DOWNLOAD_OFFER_LETTER_ISSUED +'/'+record.data.applicationProgramDetailIdForProvisional,
								   standardSubmit :true
							   });
           			   }
	   				   }
	   				   if(columnName == "applicationCode"){
	   					   if(e.target.tagName=='A'){
	   						   if( !isNullOrEmpty(record.data.isCurrentApplication) && record.data.isCurrentApplication == false ){
	   							  //alert('Open application in new tab');
	   							  
	   							  var grid = grid.ownerCt;
	   							  var $this = this;
	   							  
	   							  var applicantId = record.data.applicationId;
	                  			  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	                  			  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	                  			  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
	                  			  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
	                  			  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
	                  			  Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
	                  			  Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
	                  			  Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
	                  			  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
	                  			  Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');

	                  			  $this.openApplicantProfileFromFeeReportFromLink(applicantId, true,grid,record);
	   							   
	   						   }
	   					   }
	   				   }
	   			   }
	 		   },
	 		   'selectionsnapshotgrid button[itemId=btnAcceptOfferItemId]': {
	 			   click: function() {
	 				   var $this = this;
	 				   var personObj = $this.getPersonObj();
	 				   var personId = personObj.id;
	 				   var url = SERVERURL.APPLICATIONS_ACCEPT_OFFER_LETTER; //URL-: rest/applicationProgram/acceptOfferLetter
	 				   var grid = this.getSelectionSnapShotGrid();
	 				   if(portalId==6)
					   {
	 					  var grid = Ext.ComponentQuery.query('#newApplicantPortalWindow')[0].down('grid');
					   }
	 				   var records = grid.getSelectionModel().getSelection();
	 				   var selectedRecord = records[0];
	 				   if(selectedRecord.data.currentStatus == "PROVISIONAL_OFFER_ISSUED") {
	 					   showConfirmMessage(getAdmissionTranslation('PROVISIONAL_OFFER'),getAdmissionTranslation('ARE_YOU_SURE_YOU_WANT_TO_ACCEPT_PROVISIONAL_OFFER'),
	 			    				function(btn, text) {
	 						   if (btn == 'yes'){
			 					   var selectedRecords = new Array();
				 				   if (!isNullOrEmpty(selectedRecord) && !isNullOrEmpty(selectedRecord.data) &&
				 						   !isNullOrEmpty(selectedRecord.data.id)) {
				 					   var selectedApplicationProgram = new Object();
				 					   selectedApplicationProgram.id = selectedRecord.data.id;
				 					   selectedApplicationProgram.applicantPersonId = personId;
				 					   selectedRecords.push(selectedApplicationProgram);
				 				   }
				 				   if (selectedRecords.length > 0) {
				 					   var jsonFormatFormData = Ext.encode(selectedRecords);
				 					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				 					   Ext.Ajax.request({
				 						   type: 'rest',
				 						   method: 'POST',
				 						   url: url,
				 						   jsonData: jsonFormatFormData,
				 						   success: function(form, action) {
				 							  Ext.getBody().unmask();
				 							  grid.getStore().reload();
				 							  $this.refreshSelectionSnapShotGridWin(grid);
				 							  
				 							  // check for offer letter based document validation
				 							  var resp = Ext.JSON.decode(form.responseText);
				 							  if( resp.code == 'SUCCESS' ){
				 								 showSuccessMessage(getAdmissionTranslation('PROVISIONAL_OFFER'), getAdmissionTranslation('PROVISIONAL_OFFER_ACCEPTED_SUCCESSFULLY'));
				 							  } else {
				 								  if( resp.code == 'OFFER_BASED_PENDING_ERROR_ALL' ){
				 									  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('OFFER_BASED_PENDING_ERROR_ALL'));
				 								  }
				 								  if( resp.code == 'OFFER_BASED_PENDING_ERROR_PARTIAL' ){
				 									 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('OFFER_BASED_PENDING_ERROR_PARTIAL'));
				 								  }
				 							  }
				 						   },
				 						   failure: function(form, action) {
				 							   Ext.getBody().unmask();
				 							   var data = Ext.decode(form.responseText);
				 							   if(data[0].key == 'SEAT_CAPACITY_FULL')
				 							   {
				 								   showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('SEAT_CAPACITY_FULL')); 
				 							   }else if(data[0].key == 'ADMISSION_OFFER_PROCESS_NOT_OPENED' || data[0].key == 'cant_send_offer_letter_document_not_mapped')
				 							   {
				 								   showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('ADMISSION_OFFER_PROCESS_NOT_OPENED')); 
				 							   }
				 						   }
				 					   });
				 				   }
	 						   }
	 					   });
	 				   }
	 				   else {
	 					   var contentpanel = $this.getContentPanel();
	 					   var coursetabstructure = Ext.widget('applicantpaymentdetailsstructure');
	 					   var tabName = getMegaMenuTranslation('STEP20_PAYMENTS');
	 					   var getcontroller=$this.getController('menu.CoreERPNavigationController');
	 					   var getTab=getcontroller.getTab(tabName);
	 					   if(getTab!=null){
	 						   contentpanel.remove(getTab, true);
	 					   }
	 					   if(!isNullOrEmpty(coursetabstructure)){
	 						   openTab(contentpanel, tabName, coursetabstructure,CONSTANTS.MENU_COLOR_FIVE);
	 					   }
	 					   setTimeout(function() {
	 						   var getTabRemove = $this.getController('menu.CoreERPNavigationController').getTab(tabName);
	 						   contentpanel.remove(getTabRemove, true);
	 					   },10);
	 					   var formWindow = $this.getAcceptofferletterwin();
	 					   if (!formWindow) {
	 						   Ext.widget('acceptofferletterwin');
	 						   formWindow = $this.getAcceptofferletterwin();
	 					   }
	 					   formWindow.show();
	 					   var form = formWindow.down('#acceptOfferLetterFormItemId');
	 					   var acceptAcceptOfferLetterButton = form.down("#acceptAcceptOfferLetterWinItemId");
	 					   acceptAcceptOfferLetterButton.setDisabled(true);
	 					   var status = $this.checkOfferLetterDfr(form,true);
	 					   setTimeout(function() {
	 						   form.down('#isRegistrationContract2FieldContainer').doLayout();
	 						   form.down('#isRegistrationContractFieldContainer').doLayout();
	 					   },10);
	 				   }
	 			   }
	 		   },
	 		 'acceptofferletterwin checkboxfield#isRegistrationContractItemId': {
	 			   change: function(obj, newValue, oldValue, eOpts) {
	 				   var $this = this;
	 				   var formWindow = $this.getAcceptofferletterwin();
	 				   var form = formWindow.down('#acceptOfferLetterFormItemId');
	 				   var status = $this.checkOfferLetterDfr(form,false);
	 				   if(!status) {
	 					  var acceptAcceptOfferLetterButton = form.down("#acceptAcceptOfferLetterWinItemId");   
		 				  acceptAcceptOfferLetterButton.setDisabled(true);
	 				   }
	 			   }
	 		   },
	 	 
	 		  'acceptofferletterwin checkboxfield#isRegistrationContract2ItemId': {
	 			   change: function(obj, newValue, oldValue, eOpts) {
	 				   var $this = this;
	 				   var formWindow = $this.getAcceptofferletterwin();
	 				   var form = formWindow.down('#acceptOfferLetterFormItemId');
	 				   var status = $this.checkOfferLetterDfr(form,false);
	 			   }	
	 		   },
	 		   
	 		  'acceptofferletterwin customcombobox[itemId=offerLetterAcceptedBy]': {
	 			 render: function(obj){
	 				var $this = this;
	 				var formWindow = $this.getAcceptofferletterwin();
	 				var field = formWindow.down('#offerLetterAcceptedBy');
	 				var grid = $this.getSelectionSnapShotGrid();
	 				var records = grid.getSelectionModel().getSelection();
	 				var selectedRecord = records[0];
					var applicationId = selectedRecord.data.applicationId;
	    		    var fieldStore = field.getStore();
	    		    fieldStore.getProxy().extraParams = {
	    		    	applicationId: applicationId
    				};
	    		    fieldStore.load();   
	 			  },
	 			  select: function(obj){
	 				 var $this = this;
	 				 var formWindow = $this.getAcceptofferletterwin();
	 				 var form = formWindow.down('#acceptOfferLetterFormItemId');
	 				 $this.checkOfferLetterDfr(form,false);
	 			 }
	 		   },
	 		   'acceptofferletterwin button[itemId=acceptAcceptOfferLetterWinItemId]': {
	 			   click: function() {
	 				   var $this = this;

	 				   var formWindow = $this.getAcceptofferletterwin();
	 				   var form = formWindow.down('#acceptOfferLetterFormItemId');
	 				   var isRegistrationContractItemId = form.down('#isRegistrationContractItemId');
	 				   var isRegistrationContract = isRegistrationContractItemId.getValue();
	 				   var isRegistrationContract2ItemId = form.down('#isRegistrationContract2ItemId');
	 				   var isRegistrationContractCondition = isRegistrationContract2ItemId.getValue();
	 				   var offerLetterAcceptedBy = form.down('#offerLetterAcceptedBy').getValue();
	 				   var personObj = $this.getPersonObj();
	 				   var personId = personObj.id;

	 				   var url = SERVERURL.APPLICATIONS_ACCEPT_OFFER_LETTER; //URL-: rest/applicationProgram/acceptOfferLetter
	 				   var grid = $this.getSelectionSnapShotGrid();
	 				   if(portalId==6)
 					   {
	 					  var grid = Ext.ComponentQuery.query('#newApplicantPortalWindow')[0].down('grid');
 					   }
	 				   var records = grid.getSelectionModel().getSelection();
	 				   var selectedRecord = records[0];

	 				   var selectedRecords = new Array();
	 				   if (!isNullOrEmpty(selectedRecord) && !isNullOrEmpty(selectedRecord.data) &&
	 						   !isNullOrEmpty(selectedRecord.data.id)) {
	 					   var selectedApplicationProgram = new Object();
	 					   selectedApplicationProgram.id = selectedRecord.data.id;
	 					   selectedApplicationProgram.applicantPersonId = personId;
	 					   selectedApplicationProgram.isRegistrationContract = isRegistrationContract;
	 					   selectedApplicationProgram.isRegistrationContractCondition = isRegistrationContractCondition;
	 					   selectedApplicationProgram.acceptedByApplicantPersonId = offerLetterAcceptedBy;
	 					   selectedRecords.push(selectedApplicationProgram);
	 				   }
	 				   if (selectedRecords.length > 0) {
	 					   var jsonFormatFormData = Ext.encode(selectedRecords);
	 					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 					   Ext.defer(function() {
	 					   Ext.Ajax.request({
	 						   type: 'rest',
	 						   method: 'POST',
	 						   url: url,
	 						   jsonData: jsonFormatFormData,
	 						   success: function(form, action) {
	 							   $this.closeAcceptOfferLetterWin();
	 							   Ext.getBody().unmask();
	 							   $this.refreshSelectionSnapShotGridWin(grid);
	 							   
	 							   // check for offer letter based document validation
	 							   var resp = Ext.JSON.decode(form.responseText);
	 							   if( resp.code == 'SUCCESS' ){
	 								   //showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
	 								   
	 								   //comment code due to V2D-19290
		 							   var formWindow = $this.getOfferacceptancewin();
		 							   if (!formWindow) {
		 								   Ext.widget('offeracceptancewin');
		 								   formWindow = $this.getOfferacceptancewin();
		 							   }
		 							   formWindow.show();
	 							   } else {
	 								   if( resp.code == 'OFFER_BASED_PENDING_ERROR_ALL' ){
	 									   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('OFFER_BASED_PENDING_ERROR_ALL'));
	 								   }
	 								   if( resp.code == 'OFFER_BASED_PENDING_ERROR_PARTIAL' ){
	 									   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('OFFER_BASED_PENDING_ERROR_PARTIAL'));
	 								   }
	 							   }
	 						   }
	 					   });
	 					  }, 100);
	 				   }
	 			   }
	 		   },
	 		   'acceptofferletterwin button[itemId=cancelAcceptOfferLetterWinItemId]': {
	 			   click: function() {
	 				   this.closeAcceptOfferLetterWin();
	 			   }
	 		   },
	 		   'offeracceptancewin button[itemId=payNowAcceptOfferLetterWinItemId]': {
	 			   click: function(obj) {/*
	 				   var $this = this;

	 				   var applicantPortalController = $this.getController('Academia.controller.portal.ApplicantPortalController');
	 				   var applicationBaseController = $this.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController')
	 				   var applicantLinkPanelObject = applicationBaseController.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();

	 				   var contentPanel = this.getContentPanel().getActiveTab();
	 				   var applicantProfile = $this.getTabReferenceByTabTitle(contentPanel.getApplicationDataObject().code);

	 				   if (!isEmpty(applicantLinkPanelObject)) {

	 					   var onlinePaymentObject = applicantLinkPanelObject.FINANCIAL[3];
	 					   applicationBaseController.addPersonTabPanel('APPLICANT', onlinePaymentObject.tabPanelItemId, onlinePaymentObject.tabPanelTitle, onlinePaymentObject.tabPanelItemXtype, onlinePaymentObject.xtypeItemId, onlinePaymentObject.defaultPanel);

	 					   var personInfoPanel = applicantProfile.down("#personInfoPanel");
	 					   if (personInfoPanel) {
	 						   var onlinepaymentapplicantstructureid = personInfoPanel.down("#onlinepaymentapplicantstructureid");
	 						   if (onlinepaymentapplicantstructureid) {
	 							   personInfoPanel.setActiveTab(onlinepaymentapplicantstructureid);
	 						   }
	 					   }
	 				   }
	 				   $this.closeOfferAcceptanceWin();
	 			    */
	 				  if(portalId==6){
	 					 var $this = this;
		 				  var contentPanel = $this.getContentPanel().getActiveTab();
		 				   var applicantProfile = $this.getTabReferenceByTabTitle(contentPanel.getApplicationDataObject().code);
		 				   if(applicantProfile){
		 					 
			 				   var XMLHttpRequestObject = false;  
			 				   if (window.XMLHttpRequest) {  
			 					   XMLHttpRequestObject = new XMLHttpRequest();  
			 					   XMLHttpRequestObject.overrideMimeType("text/xml");  
			 				   }  
			 				   else if (window.ActiveXObject) {  
			 					   XMLHttpRequestObject = new  
			 					   ActiveXObject("Microsoft.XMLHTTP");  
			 				   } 
			 				   
			 				   if(XMLHttpRequestObject) {  
			 					   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
			 					   XMLHttpRequestObject.onreadystatechange = function() {       
			 						   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
			 							   var xmlDocument = XMLHttpRequestObject.responseXML;  
			 							   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
			 							   gatewayPostUrl = buildInfo.getElementsByTagName("applicantEnrolmentPaymentUrl") [0].childNodes[0].nodeValue;
			 							   var w ='900',h ='500';
			 							   // Fixes dual-screen position                         Most browsers      Firefox
			 							   var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
			 							   var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

			 							   var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
			 							   var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

			 							   var left = ((width / 2) - (w / 2)) + dualScreenLeft;
			 							   var top = ((height / 2) - (h / 2)) + dualScreenTop;
			 							   if(!isNullOrEmpty(applicantProfile)){
			 								   var url = gatewayPostUrl+"?applicationId="+applicantProfile.applicationId+"&academyLocationIds="+$this.getCurrentAcademyLocation(); 
			 								   var newWindow = window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);
			 								   if(contentpanel.getActiveTab())
			 								   {
			 									   contentpanel.getActiveTab().close();
			 								   }
			 								   // Puts focus on the newWindow
			 								   if (window.focus) {
			 									   newWindow.focus();
			 								   }
			 							   }
			 						   }  
			 					   }  
			 					   XMLHttpRequestObject.send(null);  
			 				   }  
		 				   } 
		 				  $this.closeOfferAcceptanceWin();
	 				  }
	 				 
	 			   }
	 		   },
	 		   'offeracceptancewin button[itemId=payLaterAcceptOfferLetterWinItemId]': {
	 			   click: function() {
	 				   this.closeOfferAcceptanceWin();
	 			   }
	 		   },
	 		   'selectionsnapshotgrid button[itemId=btnDeclineOfferItemId]': {
	 			   click: function() {
	 				   var $this = this;
	 				   var formWindow = $this.getDeclineofferletterwin();
	 				   if (!formWindow) {
	 					   Ext.widget('declineofferletterwin');
	 					   formWindow = $this.getDeclineofferletterwin();
	 				   }
	 				   formWindow.show();
	 			   }
	 		   },
	 		   'declineofferletterwin button[itemId=declineDeclineOfferLetterItemId]': {
	 			   click: function() {
	 				   var $this = this;
	 				   $this.closeDeclineOfferLetterWin();

	 				   var url = SERVERURL.APPLICATIONS_REJECT_OFFER_LETTER; //URL-: rest/applicationProgram/rejectOfferLetter
	 				   var grid = this.getSelectionSnapShotGrid();
	 				   if(portalId==6)
	 				   {
	 					   var grid = Ext.ComponentQuery.query('#newApplicantPortalWindow')[0].down('grid');
	 				   }
	 				   var records = grid.getSelectionModel().getSelection();
	 				   var selectedRecords = new Array();
	 				   for (var count = 0; count < records.length; count++) {
	 					   var selectedRecord = records[count];
	 					   if (!isEmpty(selectedRecord.data)) {
	 						   var selectedApplicationProgram = new Object();
	 						   selectedApplicationProgram.id=selectedRecord.get('id');
	 						   selectedRecords.push(selectedApplicationProgram);
	 					   }
	 				   }	 				   
	 				   if (selectedRecords.length > 0) {
	 					   var jsonFormatFormData = Ext.encode(selectedRecords);
	 					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 					   Ext.Ajax.request({
	 						   type: 'rest',
	 						   method: 'POST',
	 						   url: url,
	 						   jsonData: jsonFormatFormData,
	 						   success: function(form, action) {
	 							   Ext.getBody().unmask();
	 							   $this.refreshSelectionSnapShotGridWin(grid);
	 							   if(selectedRecord[0].data.currentStatus == "PROVISIONAL_OFFER_ISSUED"){
		 							   showSuccessMessage(getAdmissionTranslation('PROVISIONAL_OFFER'), getAdmissionTranslation('DECLINE_PROVISIONAL_OFFER_SUCCESS_MSG'));
	 							   }
	 							   else{
	 							   showSuccessMessage(getAdmissionTranslation('APOL_OFFER_REJECTION'), getAdmissionTranslation('APOL_DECLINE_OFFER_REJECTION_MESSAGE'));
	 							   }
	 						   }
	 					   });
	 				   }

	 			   }
	 		   },
	 		   'declineofferletterwin button[itemId=cancelDeclineOfferLetterItemId]': {
	 			   click: function() {
	 				   this.closeDeclineOfferLetterWin();
	 			   }
	 		   },
	            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=printProfileBtn]': {
	            	click: function(obj) {
	            		var  $this = this;
	            		var $this = this;
	                	var formWindow = $this.getApplicationformprintwindow();
	                	if (!formWindow) {
	                		Ext.widget('applicationformprintwindow');
	                		formWindow = $this.getApplicationformprintwindow();
	                	}
	            		var grid = $this.getSearchResultGrid();
	            		var record = grid.getSelectionModel().getSelection();
	            		if (grid.getSelectionModel().getCount() > 0) {
	            			
	            			var form = $this.getApplicationformprintwindow();
	            			var  templateNameField = form.down("#applicationFormPrint");
	            			
	            			var store = templateNameField.getStore();
	            			
	            			var academyLocationId=$this.getCurrentAcademyLocation();
	            			store.getProxy().extraParams={
	            		    	academyLocationId:academyLocationId,
	            		    	templateName:'APPLICATION_FORM_PRINT_SIS',
	            		    	reportType:'Basic Reports',
	            		    	whetherApplicationForm:true
	            			};
	            			store.load({
	            				callback: function(records, options, success) {
	            		        if(records.length>0){
	            		        	formWindow.show();
	            		        	records.forEach(function(current_value, index, initial_array){
	            		        		if(current_value.data.id=='0'){
	            		        			templateNameField.setValue(current_value);	
	            			}
	            			});	
	            		} else {
	            					$this.printProfileApplicant(obj);
	            				} 
	            				}
	            		    });
	            			
	            			
	            		} else {
	            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	            		}  
	            	}
	 	        },
	 	       'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=documentRequest]': {
   	            click: function(obj) {
   	            	var grid = this.getSearchResultGrid();
   	            	this.showApplicantRequestDocumentWin();
   	            	
   	            }
   	        },
   	     'facultyrequestdocumentwidow[itemId=applicantRequestdocumentId] button#btnrequest':{
	        	click: function(button) {
	        		var grid = this.getSearchResultGrid();
	        		this.documentRequestApplicant(button);
 			}
	        },
	 	        'applicationformprintwindow button#btnPrint': {
	 	        	click: function(button) {
	 	        		var grid = this.getSearchResultGrid();
	 	        		this.exportApplicationFormPrintJRXML('pdf',grid);
	 	        	}
	 	        },
	            'searchresultgrid[itemId=applicationsListGrid] button[itemId=searchResultGridBtnDelete]': {
	                click: function(){
	                	this.deleteSelectedApplication(true);
	                }
	            },
	            'offerletterdetailswindow[itemId=applicantofferletterdetailswindow] grid[itemId=offerLetterDetailsGrid]':{   
	    			   cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	    				   var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	    				   if(columnName == "fileName"){
	             			   if(e.target.tagName=='A'){
	             				 // if(record.data.fileName.length == 1){
	       						   var csvForm = Ext.create('Ext.form.Panel'); 
								   csvForm.getForm().submit({
									   target: '_blank',
									   method:'GET',
									   params :{
										   access_token : Ext.Ajax.defaultHeaders.access_token
									   },
									   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
									   url: SERVERURL.PATH_DOWNLOAD_OFFER_LETTER_ISSUED +'/'+record.data.id,
									   standardSubmit :true
								   });
	             				 // }
	             			   }
	    				   }
	    			   }
	    		   },
	               'basicsearch customcombobox[itemId=countryCombo]': {
		               	render: function(combo){
		               		var store = combo.getStore();
		               		store.load();
		               	}
	               },
	           	'applicationlistexportreporwidow[itemId=applicationlistexportreporwidow] button[itemId=btnAppListExport]':{
	           		click: function(obj) {
	           			var getWindow = obj.up('applicationlistexportreporwidow');
	           			var  value = getWindow.down('#applicationListExport').getValue();
	           			var  exportType = getWindow.down('#radioGroupApplicationList');
	           			if(exportType.getChecked()[0].getGroupValue() =='pdf'){
	           				this.exportApplicationList(SERVERURL.PDFEXPORT,exportType,false,value,'5000');
	           			}else{
	           				this.exportApplicationList(SERVERURL.EXCELEXPORT,exportType,false,value,'5000');
	           			}
	           			getWindow.close();
	           		}
	        	},
	          	'applicationlistexportalwindow[itemId=applicationlistexportalwindow] button[itemId=btnAppListExportAl]':{
	           		click: function(obj) {
	           			var getWindow = obj.up('applicationlistexportalwindow');
	           			var  value = getWindow.down('#applicationListExport').getValue();
	           			var  exportType = getWindow.down('#radioGroupApplicationList');
	           			if(exportType.getChecked()[0].getGroupValue() =='pdf'){
	           				this.exportApplicationList(SERVERURL.PDFEXPORT,exportType,false,value,'5000');
	           			}else{
	           				this.exportApplicationList(SERVERURL.EXCELEXPORTBYAL,exportType,false,value,'5000');
	           			}
	           			getWindow.close();
	           		}
	        	},
	        	'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=reviewApplicationItemId]': {
	        		click: function(obj) {
	        			var grid = this.getSearchResultGrid();
	        			if (grid.getSelectionModel().getCount() > 0) {
	        				var this$ = this;
	        				var window = this$.getApplicationreviewwindow();
	        				if(!window){
	        					window = Ext.widget('applicationreviewwindow');
	        				}
	        				window.show();
	        			} else {
	        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	        			}  
	        		}
	        	},
	        	'applicationreviewwindow button#ard_submitbuttonId': {
	        		click: function(obj) {
	        			this.saveReviewersForApplications(obj);
	        		}
	        	},
	        	'applicationreviewwindow button#ard_cancelbuttonId': {
	        		click: function(obj) {
	        			obj.up('window').close();
	            	}
	            },
	            'basicsearch[itemId=basicSearchPanel]  customcombobox[itemId=applicationOwner]': {
	            	render : function(selectionProcessCombo) {
	            		var basicSearchForm = selectionProcessCombo.up('basicsearch');
	            		var academyLocationCombo = basicSearchForm.down('#academyLocationCombo');
	            		if(academyLocationCombo.getValue()){
	            			var academyLocations = academyLocationCombo.getValue();
	            		}
	            		else{
	            			var academyLocations = this.getUserAccessibleAL().join()
	            		}
	            		var applicationOwner = this.getApplicationsListBasicSearchForm().down('#applicationOwner').getStore();
	            		applicationOwner.getProxy().extraParams = {
	            			academyLocationIds: academyLocations
	            		};
	            	},
	            	change : function(selectionProcessCombo) {
	            		var basicSearchForm = selectionProcessCombo.up('basicsearch');
	            		var academyLocationCombo = basicSearchForm.down('#academyLocationCombo');
	            		if(academyLocationCombo.getValue()){
	            			var academyLocations = academyLocationCombo.getValue();
	            		}
	            		else{
	            			var academyLocations = this.getUserAccessibleAL().join()
	            		}
	            		var applicationOwner = this.getApplicationsListBasicSearchForm().down('#applicationOwner').getStore();
	            		applicationOwner.getProxy().extraParams = {
	            			academyLocationIds: academyLocations
	            		};
	            	}
	            },
	            'basicsearch[itemId=basicSearchPanel]  combo[itemId=programStatus]': {
	                change: function(combo, records, eOpts) {
	                	var comboValue = combo.getValue();
	                	var form = combo.up('form');
	                    var expiryStartDate = form.down('#offerExpiryStartDate');
	                    var expiryEndDate = form.down('#offerExpiryEndDate');
	                    if(comboValue=='OFFER_LETTER_ISSUED' || comboValue=='OFFER_LETTER_REJECTED' || comboValue=='OFFER_EXPIRED') {
	                    	expiryStartDate.setDisabled(false);
	                    	expiryEndDate.setDisabled(false);
	                    } else {
	                    	expiryStartDate.reset();
	                    	expiryEndDate.reset();
	                    	expiryStartDate.setMinValue(null);
	                    	expiryStartDate.setMaxValue(null);
	                    	expiryStartDate.setDisabled(true);
	                    	expiryEndDate.setMinValue(null);
	                    	expiryEndDate.setMaxValue(null);
	                    	expiryEndDate.setDisabled(true);
	                    }
	                    form.getForm().checkValidity();
	                }
	            },
	            'searchresultgrid[itemId=duplicateapplicationdetailsgrid]' :{
		        	render: function(grid){
		        		grid.addExportButtonToolbar();
	        		        var buttonsToolBar = grid.query('toolbar')[0];
	        		        buttonsToolBar.query('#exportToPdfBtn')[0].setDisabled(true);
	        		        buttonsToolBar.query('#exportToPdfBtn')[0].setDisabled(true);
		        		this.genericCBGridAccessControlValidation(grid, this.getAPPLICANT_DUPLICATE_GRID_PERMISSIONS());
		        	},
		        	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts) {
		        		this.showEnquiryFormFromLink(grid,td, cellIndex, record, tr, rowIndex, e, eOpts);               	
		        	}
		        },
		        'searchresultgrid[itemId=duplicateapplicationdetailsgrid] button[itemId=exportToPdfBtn] #exportCurrentPagePdf': {
		        	click: function() {
		        			 this.exportApplicationListForDuplicateDetail(SERVERURL.PDFEXPORT,'pdf',false);
		          	}
		        	       },
		        'searchresultgrid[itemId=duplicateapplicationdetailsgrid] button[itemId=exportToPdfBtn] #exportPdfAll': {
		        	click: function() {
		        		      this.exportApplicationListForDuplicateDetail(SERVERURL.PDFEXPORT,'pdf',true);
		        		       }
		        	 },
		        'searchresultgrid[itemId=duplicateapplicationdetailsgrid] button[itemId=exportToPdfBtn] #exportCurrentExcelPage': {
		        		click: function() {
		        		        this.exportApplicationListForDuplicateDetail(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
		        	            }
		        	        },
		        'searchresultgrid[itemId=duplicateapplicationdetailsgrid] button[itemId=exportToPdfBtn] #exportExcelAll': {
		        	click: function() {         	            	
		                  this.exportApplicationListForDuplicateDetail(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
		        		  }
		        	 },
    	        'scrollablealertwindow button[itemId=feePlanAlertBtn]':{
 	 			   click : function(btn) {
 	 				   var alertWin = this.getScrollablealertwindow();
 	 				   alertWin.close();
 	 			   }
		        } ,
		        'applicantpasthistoryuploaddownloadstructure radiogroup[itemId=importDownloadradiogroupId]':{
		        	change: this.applicantPastHistoryLoaderRadioBtn
		        },
		        'applicantcompetitivepasthistoryloaderdownloadform':{
		        	show: function(obj){
		        		var structure=this.getImporttabstructure();
		        		this.resetFormAndSetValue(structure);
		        	}
		        },
		        'applicantcompetitivepasthistoryloaderdownloadform combo[itemId=templateTypeItemId]': {
	     			change : function(val,nV,oV){
	     				var structure=this.getImporttabstructure();
	     				 var form = structure.down('#applicantcompetitivepasthistoryloaderdownloadformId');
	     				 var examPassedField = form.down('#examPassed');
	     				 var examBoardField = form.down('#examBoard');
	    				 if(nV == 'CompetitiveExam'){
	    					 examPassedField.setVisible(false);
	    					 examBoardField.setVisible(false);
	    				 }
	    				 else{
	    					 examPassedField.setVisible(true);
	    					 examBoardField.setVisible(true);
	    				 }
	    			}
	     		 },
		        'applicantcompetitivepasthistoryloaderdownloadform button[itemId=resetBtn]':{
		        	click: function(obj){
		        		var structure=this.getImporttabstructure();
		        		this.resetFormAndSetValue(structure);
		        	}
		        },
		        'applicantcompetitivepasthistoryloaderdownloadform button[itemId=programBatchDownolad]':{
		        	click:function(obj){
		        		this.downloadTemplateForApplicantPastHistory();
		        	}  
		        },
		        'applicantcompetitivepasthistoryloaderuploadform uploadoptionradiogroup[itemId=applicantPastHistoryUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
		        	change: function(radioGroup, newValue, oldValue, eOpts){
		        		this.changeInnerUploadsRadioBtn(radioGroup, newValue, oldValue, eOpts);
		        	}
		        },
		        'applicantcompetitivepasthistoryloaderuploadform button[itemId=resetBtn]':{
		        	click:function(obj){
		        		var $this=this;
		        		var form = $this.getApplicantcompetitivepasthistoryloaderuploadform().getForm();
		        		form.reset();
		        		form.findField('file').reset();
		        		var uploadoptionradiogroupform  = $this.getApplicantpasthistoryuploadoptionradiogroup();
		        		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
		        			isUploadAll: false
		        		});
		        		form.isValid();
		        	}
		        },
		        'applicantcompetitivepasthistoryloaderuploadform customcombobox[itemId=uploadTypeItemId]': {
	     			 select: function(obj, record) {
	     				 var $this = this;
	     				 var structure=$this.getImporttabstructure();
	     				 var form = structure.down('#applicantcompetitivepasthistoryloaderuploadformId');
	     				 var templateName = form.getValues().uploadType;
	     				 var moduleName = null;
	     				 switch (templateName){
	     				 case 'CompetitiveExam':
	     					 moduleName = 'APPLICANT_BULK_COMPETITIVE_EXAM';
	     					 moduleNameUi = 'Bulk Applicant Competitive Exam';
	     					 break;
	     				case 'EducationHistory':
	     					 moduleName = 'APPLICANT_BULK_EDUCATION_HISTORY';
	     					moduleNameUi = 'Bulk Applicant Education History';
	     					 break;
	     				 default : null;
	     				 }
	     				 var combo = form.down('#moduleName');
	     				 combo.getStore().load({
	     					 callback: function(records, operation, success) {
	     						 for(var i in records){
	     							 if(records[i].data.value == moduleNameUi){
	     								 combo.setValue(records[i].data.id);
	     								 combo.setReadOnly(true);
	     							 }
	     						 }
	     					 }	   
	     				 });
	     				 var grid = structure.down('#importlistapplicanthistoryloaderId');
	     				 var form = $this.getApplicantpasthistoryuploadoptionradiogroup();
	     				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
	     				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
	     			 }
		        },
		        'applicantcompetitivepasthistoryloaderuploadform button[itemId=programBatchUpload]':{
		        	click:function(obj){
		        		var $this=this;
		        		var importWin=$this.getApplicantcompetitivepasthistoryloaderuploadform();
		        		importWin.down('#programBatchUpload').setDisabled(true);
		        		var templateName = importWin.getValues().uploadType;
		        		var moduleName = null;
		        		var grdStore;
		        		var form=$this.getApplicantcompetitivepasthistoryloaderuploadform();
		        		switch (templateName){
	     				 case 'CompetitiveExam':
	     					 moduleName = 'APPLICANT_BULK_COMPETITIVE_EXAM';
	     					 break;
	     				 case 'EducationHistory':
	     					 moduleName = 'APPLICANT_BULK_EDUCATION_HISTORY';
	     					 break;
	     				 default : null;
	     				 }
		        		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
		        		$this.getHashOfFile(form);
		        		setTimeout(function() {
		        			form.getForm().submit({
		        				method : 'POST',
		        				url : submitUrl,
		        				success : function(form, action){
		        					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		        				},
		        				failure: function(form, action) {
		        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
		        				}
		        			});
		        		},1000);

		        		Ext.defer(function() {
		        			var grid = $this.getImportlistapplicanthistoryloader();
		        			var form = $this.getApplicantpasthistoryuploadoptionradiogroup();
		        			var isUploadAll = form.items.items[0].getValue().isUploadAll;
		        			$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,moduleName);
		        		}, 2000, this);
 	 		   }
		        },
		        'importlistapplicanthistoryloader button[itemId=btnForce]':{
		        	click: function(obj) {
		        		var grid = this.getImportlistapplicanthistoryloader();
		        		if (grid.getSelectionModel().getCount() > 0) {
		        			if(grid.getSelectionModel().getCount() > 1){
		        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		        			}else{
		        				var this$ = this;
		        				var id = grid.getSelectionModel().selectionStart.data.id;
		        				console.log(id);
		        				var urlAppend="?jobName="+id;
		        				var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		        				Ext.Ajax.request({
		        					url: submitURL,
		        					method: 'GET',
		        					success: function(response) {
		        						if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		        							showWarningMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		        						}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		        							showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		        						}else if(response.responseText==="SUCCESS"){
		        							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
		        						}
		        					}
        });
		        			}
		        		} else {
		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		        		}  
		        	}
		 		   },
		 		  'bulkapplicationrejection button[itemId=saveBtn]': {
		            	click: function(obj) {
		            		var this$ = this;
		            		var searchResultGrid = this$.getSearchResultGrid();
		            		var records = searchResultGrid.getSelectionModel().getSelection();
		            		var combo = searchResultGrid.down('#applicationListAction');
		            		var selectedRecords = new Array();
		            		var form = obj.up('form');
		            		var rejectWindow = obj.up('window');
		            		var formValues = form.getValues();
							var applicationIDs;
							for (var i in records) {
								selectedRecords.push(records[i].get('APPLICATION_PRIMERY_ID'));
							}
							applicationIDs = selectedRecords.join();
							var jsonArray=new Array();
							for (var i in records) {
								jsonArray.push(records[i].get('APPLICATION_PROGRAM_ID'));
							}
							var myJson={
									"currentStatus":"REJECTED",
									"reasonId":formValues.reasonId,
									"remark":formValues.remark,
									"applicationProgramIds":jsonArray,
									"applicationIds":selectedRecords
							};
							var serverUrl= SERVERURL.APPLICATIONS_APPROVE_REJECT_WITHDRAW_APPLICATION_PROGRAM;
							this$.performSelectedAction(serverUrl,'POST',myJson,searchResultGrid,getAdmissionTranslation('APPLICATION_REJECT_SUCCESSFULLY'),combo,rejectWindow);
		            	}
		            },
		            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=reassignescalationitemid]': {
		            	click: function(obj) {
		            		var grid = this.getSearchResultGrid();
		            		if (grid.getSelectionModel().getCount() > 0) {
		            			var this$ = this;
		            			var window = this$.getReassignescalationform();
		            			if(!window){
		            				window = Ext.widget('reassignescalationform');
		            			}
		            			window.show();
		            		} else {
		            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            		}  
		            	}
		            },
		            'reassignescalationform button#reassignEscalationSubmitButtonId': {
			        	click: function(obj) {
			        		this.reassignEscalationSave(obj);
			        	}
			        },
			        'reassignescalationform button#reassignEscalationCancelButtonId': {
			        	click: function(obj) {
			        		 obj.up('window').close();
			        	}
			        },
		            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=reassignescalationitemid]': {
		            	click: function(obj) {
		            		var grid = this.getSearchResultGrid();
		            		if (grid.getSelectionModel().getCount() > 0) {
		            			var this$ = this;
		            			var window = this$.getReassignescalationform();
		            			if(!window){
		            				window = Ext.widget('reassignescalationform');
		            			}
		            			window.show();
		            		} else {
		            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            		}  
		            	}
		            },
		            'reassignescalationform button#reassignEscalationSubmitButtonId': {
			        	click: function(obj) {
			        		this.reassignEscalationSave(obj);
			        	}
			        },
			        'reassignescalationform button#reassignEscalationCancelButtonId': {
			        	click: function(obj) {
			        		 obj.up('window').close();
			        	}
			        },
		            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=reassignescalationitemid]': {
		            	click: function(obj) {
		            		var grid = this.getSearchResultGrid();
		            		if (grid.getSelectionModel().getCount() > 0) {
		            			var this$ = this;
		            			var window = this$.getReassignescalationform();
		            			if(!window){
		            				window = Ext.widget('reassignescalationform');
		            			}
		            			window.show();
		            		} else {
		            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		            		}  
		            	}
		            },
		            'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=raiseScholarshipApplicantRequestId]': {
		            	click: function(obj) {
		            	//	this.openScholarshipRaiseRequestTabForApplicant();
		            		var $this =this;

        	        		var grid =  this.getSearchResultGrid();
        	        		var records = grid.getSelectionModel().getSelection();
        	        		var pbscId = records[0].data.PROG_BATCH_SEAT_CONFIG_ID;
        	        		Ext.Ajax.request({
        	        			               method : "GET",
        	        			               type : 'rest',
        	        			              url : SERVERURL.PATH_FIND_SCHOLARSHIPRAISE_PBSCID+"?pbscId="+pbscId,
        	        			                 headers : {
        	        				                    'Content-Type' : 'application/json'
        	        					               },
        	        						             success : function(form,action) {
        	        							         var data = form.responseText;
        	        							if(data =="true"){
        	        								
        	        								$this.openScholarshipRaiseRequestTabForApplicant();
        	        							} else {
        	        	                     	showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('NO_SCHOLARSHIP_IS_LINKED_WITH_THE_PROGRAM_ASSOCIATED_WITH_THE_SELECTED_APPLICANT'));  
        	        							}
        	        							                                
        	        							                             

        	        							                            }
        	        						                        });
		            	}
		            },
		            'reassignescalationform button#reassignEscalationSubmitButtonId': {
			        	click: function(obj) {
			        		this.reassignEscalationSave(obj);
			        	}
			        },
			        'reassignescalationform button#reassignEscalationCancelButtonId': {
			        	click: function(obj) {
			        		 obj.up('window').close();
			        	}
			        },
		            
		            /****************bulk offer status update download loder*****/
		            
		             'bulkofferstatusupdatedownloadform multiselectcombofield#academyLocationId':{
		            	render: function(obj) {
		            		var form = this.getBulkofferstatusupdatedownloadform().getForm();
		            		var userId = this.getCurrentlyLoggedInUser().id;
		            		var academyLocationfield = form.findField('multiselectAcademyLocation');
		            		var currentAcademyLocation=this.getCurrentAcademyLocation();
		            		var store = obj.getStore();

		            		store.getProxy().extraParams = {
		            			id: userId
		            		};
		            		store.load({
		            			callback: function(record){
		            				academyLocationfield.setValue(currentAcademyLocation);
		            			}
		            		});
		            	},
		            	change: function(ob, rec) {
		            		var form = this.getBulkofferstatusupdatedownloadform().getForm();
		            		var academyLocationId = ob.up('form').down('#academyLocationId').getValue();
		            		var alIds = [];
		            		var academyLocationIds;
		            		if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
		            			for (var i in academyLocationId) {
		            				if (Ext.isObject(academyLocationId[0])) {
		            					alIds.push(academyLocationId[i].get("id"));
		            				} else {
		            					alIds.push(academyLocationId[i]);
		            				}
		            			}
		            			academyLocationIds = alIds.join();
		            		} else {
		            			alIds.push(this.getCurrentAcademyLocation());
		            			academyLocationIds = alIds.join();
		            		}
		            		
		            		var programId = ob.up('form').down('#program');
		            		programId.reset();
		            		
		                    var programStore = programId.getStore();
		            		programStore.getProxy().extraParams = {
		            			academyLocationIds: academyLocationIds
		            		};
		            		programStore.load();
		            	},
		            	
		             },
		             'bulkofferstatusupdatedownloadform combo[itemId=program]': {
						    change : function(obj){
							   var form = obj.up('form');
							   var values = form.getForm().getValues();
							   var programId = values.programId;
							   var batch = form.down('#batch');
							   batch.reset();
						    	var store = batch.getStore();
                                 store.removeAll();
							   var programids=[];
							   var programs; 
							   if(programId !=undefined && programId.length > 0){
						    		for(var i in programId){
						    			if(Ext.isObject(programId[0])){
						    				programids.push(programId[i].get("id"));
						    			}else{
						    				programids.push(programId[i]);
						    			}
						    		}
						    	programs = programids.join();
	 	                       	store.proxy.extraParams = {
	 	      					program : programs
	 	      					};
	 	                       	store.load();
						    	}
						   }
					   },
					  'bulkofferstatusupdatedownloadform combo[itemId=batch]': {
						    change : function(obj){
							   var form = obj.up('form');
							   var values = form.getForm().getValues();
							   var batchId = values.batch;
							   var seatType = form.down('#seatType');
							   seatType.reset();
							   var store = seatType.getStore();
                               store.removeAll();
							   var batchids=[];
							   var batchs; 
							   if(batchId !=undefined && batchId.length > 0){
						    		for(var i in batchId){
						    			if(Ext.isObject(batchId[0])){
						    				batchids.push(batchId[i].get("id"));
						    			}else{
						    				batchids.push(batchId[i]);
						    			}
						    		}
						    		batchs = batchids.join();
							 	    var store = seatType.getStore();
							 	    store.getProxy().extraParams = {
							 	    	batch : batchs
									};
								   store.load();
							   }
						   }
					   },
					   
			            'bulkofferstatusupdatedownloadform button[itemId=resetBtn]':{
				        	click: function(obj){
				        		  var downloadTemplateForm = this.getBulkofferstatusupdatedownloadform();
					        	  downloadTemplateForm.down('#academyLocationId').reset();
					        	  downloadTemplateForm.down('#program').reset();
					        	  downloadTemplateForm.down('#batch').reset();
					        	  downloadTemplateForm.down('#seatType').reset();
					        	  downloadTemplateForm.down('#offerstatus').reset();
					        	  downloadTemplateForm.down('#START_DATE').reset();
					        	  downloadTemplateForm.down('#END_DATE').reset();
					        	
				        	}
				        },
				        
				        'bulkofferstatusupdatedownloadform button[itemId=downoladBtnId]':{
				        	click:function(obj){
				        		var $this = this;
					        	  var form = $this.getBulkofferstatusupdatedownloadform();
					        	  var formValues = form.getValues();
					        	  var academyId= formValues.multiselectAcademyLocation;
					        	  var programId= formValues.programId;
					        	  var batchId= formValues.batch;
					        	  var seatTypeId= formValues.SEAT_TYPE;
					        	  var academyLocationArray = [];
			        	            if(!isNullOrEmpty(academyId)){
			        	        		if(typeof academyId == "object"){
			        	            		Ext.each(academyId, function(academyId){
			        	                        if(!isNullOrEmpty(academyId)){
			        	                        	academyLocationArray.push(academyId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			academyLocationArray.push(academyId);
			        	        		}
			        	        	}
			        	        	
			        	        	 var programArray = [];
			        	            if(!isNullOrEmpty(programId)){
			        	        		if(typeof programId == "object"){
			        	            		Ext.each(programId, function(programId){
			        	                        if(!isNullOrEmpty(programId)){
			        	                        	programArray.push(programId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			programArray.push(programId);
			        	        		}
			        	        	}
			        	            
			        	            var batchArray = [];
			        	            if(!isNullOrEmpty(batchId)){
			        	        		if(typeof batchId == "object"){
			        	            		Ext.each(batchId, function(batchId){
			        	                        if(!isNullOrEmpty(batchId)){
			        	                        	batchArray.push(batchId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			batchArray.push(batchId);
			        	        		}
			        	        	}
			        	            
			        	            var seatTypeArray = [];
			        	            if(!isNullOrEmpty(seatTypeId)){
			        	        		if(typeof seatTypeId == "object"){
			        	            		Ext.each(seatTypeId, function(seatTypeId){
			        	                        if(!isNullOrEmpty(seatTypeId)){
			        	                        	seatTypeArray.push(seatTypeId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			seatTypeArray.push(seatTypeId);
			        	        		}
			        	        	}
			        	            
			        	    	  var csvForm = Ext.create('Ext.form.Panel',{

					        	  });
					        	  csvForm.getForm().submit({
					        		  target: '_blank',
					        		  method:'POST',
					        		  params :{
					        			  access_token : Ext.Ajax.defaultHeaders.access_token, 
					        			  'academyLocationIds': academyLocationArray.join(),
					        			  'programIds' : programArray.join(),
					        			  'batchIds' : batchArray.join(),
					        			  'seatTypeIds' : seatTypeArray.join(),
					        			  'currentStatus' : formValues.offerstatus,
					        			  'startDate' : formValues.START_DATE,
					        			  'endDate' : formValues.END_DATE,	  
					        			  },
					        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					        		  url: SERVERURL.DOWNLOAD_TEMPLATE_OFFER_STATUS_UPDATE,
					        		  standardSubmit :true,
					        		  success : function(form, action){
					        			  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
					        		  },
					        		  failure: function(form, action) {
					        			  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
					        		  }
					        	  });
					          	
				        	}  
				        },
				    /****     bulk status update upload loder    **/
				        
				        'bulkofferstatusupdateuploadform button[itemId=resetBtn]':{
				   			click: function() {
				   				var applicationuploadForm = this.getBulkofferstatusupdateuploadform().getForm();
				   				applicationuploadForm.findField('file').reset();
				   				var uploadoptionradiogroupform  = this.getApplicationsUploaduploadoptionradiogroup();
				   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
				   					isUploadAll: false
				   				});
				   			}
				   		},
				   		
				        'bulkofferstatusupdateuploadform':{
			        		render:function(obj){
			        			var $this=this;
			    	        	var importWin=$this.getBulkofferstatusupdateuploadform()
			    	        	var moduleName = importWin.down('#moduleName');
			    	        	moduleName.getStore().load({
			    	        		callback: function(records, operation, success) {
			    	        			for(var i in records){
				    	        			if(records[i].data.value=="Bulk Offer Status Update"){
				    	        				moduleName.setValue(records[i].data.id);
				    	        				moduleName.setReadOnly(true)
				    	        			}
			    	        			}
		 	            		   }	
			    	        	});
			        		}  
		    		 },
		    		 'bulkofferstatusupdateuploadform button[itemId=uploadId]':{
			        		click:function(obj){
			        			var $this=this;
			    	        	var importWin=$this.getBulkofferstatusupdateuploadform()
			    	        	var grdStore;
			    	        	var form=$this.getBulkofferstatusupdateuploadform();
			    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
			    	        	$this.getHashOfFile(form);
					        	setTimeout(function() {
				    	        	form.getForm().submit({
				    	        		method : 'POST',
				    	        		url : submitUrl,
				    	        		success : function(form, action){
				    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
				    	    	        },
				    	        		failure: function(form, action) {
			   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
				    	    	        }
				    	        	});
					        	},1000);

			        			 Ext.defer(function() {
			        				 var grid = $this.getImportlistbulkofferstatusupdate();
			        				 var form = $this.getApplicationsUploaduploadoptionradiogroup();
			        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
			        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_OFFER_STATUS_UPDATE');
			         	        }, 2000, this);
			        		}  
		    		 },
		    		 
		    		 'bulkofferstatusupdateuploadform uploadoptionradiogroup[itemId=applicationsUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
		    			 change: function( radioGroup, newValue, oldValue, eOpts){
		    				 var grid =this.getImportlistbulkofferstatusupdate();
		    				 var form =this.getApplicationsUploaduploadoptionradiogroup();
		    				 var isUploadAll = newValue.isUploadAll;
		    				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_OFFER_STATUS_UPDATE');
		    			 }   
		    		 },
		    		 
		    		 /***import list bulk offer status ***/
		    		 
		    		 'importlistbulkofferstatusupdate':{
		 	   			render:function(obj){
		 	   				var $this = this;
		  		    		var grid = $this.getImportlistbulkofferstatusupdate();
		  		    		var form = $this.getApplicationsUploaduploadoptionradiogroup();
		  		    		var isUploadAll = form.items.items[0].getValue().isUploadAll;
		  		    		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_OFFER_STATUS_UPDATE');
		 	   			},
		  		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		     				if (e.target.tagName == 'A') {
		     					var fileType=null;
		     					if(cellIndex==1){
		     						fileType='successFile';
		     					}else if(cellIndex==6){
		     						fileType='errorFile';
		     					}else if(cellIndex==7){
		     						fileType='logFile';
		     					}
		     					var documentId = record.get("id");
		     					if (!isNullOrEmpty(documentId)) {
		     						this.getDownloadFile(documentId,fileType);
		     					}
		     				}
		     			}
		 	   		},
		 	   		
		 	   		'importlistbulkofferstatusupdate':{
		 	   			render:function(obj){
		 	   				var $this = this;
		  		    		var grid = $this.getImportlistbulkofferstatusupdate();
		  		    		var form = $this.getImportapplicationsUploaduploadoptionradiogroup();
		 	        		var isUploadAll = form.items.items[0].getValue().isUploadAll;
		 	        		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_OFFER_STATUS_UPDATE');
		 	   			},
		  		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		     				if (e.target.tagName == 'A') {
		     					var fileType=null;
		     					if(cellIndex==1){
		     						fileType='successFile';
		     					}else if(cellIndex==6){
		     						fileType='errorFile';
		     					}else if(cellIndex==7){
		     						fileType='logFile';
		     					}
		     					var documentId = record.get("id");
		     					if (!isNullOrEmpty(documentId)) {
		     						this.getDownloadFile(documentId,fileType);
		     					}
		     				}
		     			}
		 	   		},
		 	   		
		 	   	  'importlistbulkofferstatusupdate button[itemId=btnForce]':{
		 	   			click: function(obj) {
		 		            	var grid = this.getImportlistapplicant();
		 		            	if (grid.getSelectionModel().getCount() > 0) {
		 		            		if(grid.getSelectionModel().getCount() > 1){
		 			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		 			        		}else{
		 			        			var this$ = this;
		 	   	                	//var id = grid.getSelectionModel().selectionStart.data.id;
		 	   	                	var id = grid.getSelectionModel().getSelection()[0].data.id;
		 	   	                	console.log(id);
		 	   	                	var urlAppend="?jobName="+id;
		 	   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		 	   	    	        	Ext.Ajax.request({
		 	   	    	        		url: submitURL,
		 	   	    	        		method: 'GET',
		 	   	    	        		success: function(response) {
		 	   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		 	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		 	   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		 	   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		 	   	    	        			}else if(response.responseText==="SUCCESS"){
		 	       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 	   	    	        			}
		 	   	    	        		}
		 	   	    	        	});
		 			        		}
		 		            	} else {
		 		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 		            	}  
		 		            }
		 	 		   },
		 	 		   
		 	 		  'importlistbulkofferstatusupdate button[itemId=btnForce]':{
		 		   			click: function(obj) {
		 			            	var grid = this.getImportlistbulkofferstatusupdate();
		 			            	if (grid.getSelectionModel().getCount() > 0) {
		 			            		if(grid.getSelectionModel().getCount() > 1){
		 				        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		 				        		}else{
		 				        			var this$ = this;
		 		   	                	var id = grid.getSelectionModel().selectionStart.data.id;
		 		   	                	console.log(id);
		 		   	                	var urlAppend="?jobName="+id;
		 		   	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		 		   	    	        	Ext.Ajax.request({
		 		   	    	        		url: submitURL,
		 		   	    	        		method: 'GET',
		 		   	    	        		success: function(response) {
		 		   	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		 		   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		 		   	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		 		   	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		 		   	    	        			}else if(response.responseText==="SUCCESS"){
		 		       	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		 		   	    	        			}
		 		   	    	        		}
		 		   	    	        	});
		 				        		}
		 			            	} else {
		 			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		 			            	}  
		 			            }
		 		 		   },

		    		/* ************  bulk offer status update loder code end  ***********/
		 		 		   
		 		 		 /** import applicant relationship download form loder */

		 		 		 'importapplicantrelationshipdownloadform[itemId=importapplicantrelationshipdownloadformItemId] multiselectcombofield[itemId=program]': {
		 	                	render : function(combo){
		 	                		var $this = this;
		 	                		var academyLocationId = $this.getCurrentAcademyLocation();
		 	                		var store = combo.getStore();
		 	                       	store.proxy.extraParams = {
		 	      					academyLocationId : academyLocationId
		 	      					};
		 	                       	store.load();
		 	                  	},
		 	                  	change : function(obj){
							   var form = obj.up('form');
							   var values = form.getForm().getValues();
							   var programId = values.PROGRAM_NAME;
							   var batch = form.down('#batch');
							   batch.reset();
							   var programids=[];
							   var programs; 
							   if(programId !=undefined && programId.length > 0){
								   batch.setDisabled(false);
						    		for(var i in programId){
						    			if(Ext.isObject(programId[0])){
						    				programids.push(programId[i].get("id"));
						    			}else{
						    				programids.push(programId[i]);
						    			}
						    		}
						    	programs = programids.join();
						    	var store = batch.getStore();
	 	                       	store.proxy.extraParams = {
	 	      					program : programs
	 	      					};
	 	                       	store.load();
						    	}else{
						    		batch.setDisabled(true);
						    	}
						   }
					   },
					  'importapplicantrelationshipdownloadform[itemId=importapplicantrelationshipdownloadformItemId] multiselectcombofield[itemId=batch]': {
						    change : function(obj){
							    var form = this.getImportapplicantrelationshipdownloadform().getForm();
			            		var batchId = obj.up('form').down('#batch').getValue();
			            		
								   var batchids=[];
								   var batchs; 
								   var seatType = obj.up('form').down('#seatType');
								   seatType.reset();
								   if(batchId !=undefined && batchId.length > 0){
									   seatType.setDisabled(false);
							    		for(var i in batchId){
							    			if(Ext.isObject(batchId[0])){
							    				batchids.push(batchId[i].get("id"));
							    			}else{
							    				batchids.push(batchId[i]);
							    			}
							    		}
							    		batchs = batchids.join();
							    		var store = seatType.getStore();
										   store.getProxy().extraParams = {
											   batch : batchs
												};
										   store.load();
							    	}else{
							    		seatType.setDisabled(true);
							    		seatType.getStore().removeAll();
							    	}
						   }
					   },
		 	    	  /** Added multiple program and batch wise template will download. */
		 		 		 'importapplicantrelationshipdownloadform[itemId=importapplicantrelationshipdownloadformItemId] button[itemId=resetBtn]':{
		 	        		 click: function(obj){
		 	        			 var form = this.getImportapplicantrelationshipdownloadform();
		 	        			 var pbpsContiner = form.down('#programBatchContainerId');
		 	        			 var newcont=pbpsContiner.items.items.length;
		 	        			 for(var i=newcont-1;i>0;i--){
		 	        				 pbpsContiner.remove(pbpsContiner.items.items[i]);
		 	        			 }
		 	        			 form.doLayout();
		 	        			 form.getForm().reset();
		 	        			 form.down('#batch').reset();
		 	        			 form.down('#seatType').reset();
		 	        			 form.down('#applicationstatus').reset();
		 	        			
		 	        		 }
		 	        	 },
		 	        	'importapplicantrelationshipdownloadform button[itemId=downoladBtnId]':{
				        	click:function(obj){
				        		var $this = this;
					        	  var form = $this.getImportapplicantrelationshipdownloadform();
					        	  var formValues = form.getValues();
					        	 
					        	  var programId= formValues.PROGRAM_NAME;
                                  var batchId= formValues.BATCH_NAME;
							  var seatTypeId= formValues.SEAT_TYPE;

			        	        	 var programArray = [];
			        	            if(!isNullOrEmpty(programId)){
			        	        		if(typeof programId == "object"){
			        	            		Ext.each(programId, function(programId){
			        	                        if(!isNullOrEmpty(programId)){
			        	                        	programArray.push(programId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			programArray.push(programId);
			        	        		}
			        	        	}
                                
 							var batchArray = [];
			        	            if(!isNullOrEmpty(batchId)){
			        	        		if(typeof batchId == "object"){
			        	            		Ext.each(batchId, function(batchId){
			        	                        if(!isNullOrEmpty(batchId)){
			        	                        	batchArray.push(batchId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			batchArray.push(batchId);
			        	        		}
			        	        	}

							var seatTypeArray = [];
			        	            if(!isNullOrEmpty(seatTypeId)){
			        	        		if(typeof seatTypeId == "object"){
			        	            		Ext.each(seatTypeId, function(seatTypeId){
			        	                        if(!isNullOrEmpty(seatTypeId)){
			        	                        	seatTypeArray.push(seatTypeId.data.id);
			        	                        }
			        	                    });
			        	        		} else{
			        	        			seatTypeArray.push(seatTypeId);
			        	        		}
			        	        	}
			        	        	

			        	    	  var csvForm = Ext.create('Ext.form.Panel',{

					        	  });
					        	  csvForm.getForm().submit({
					        		  target: '_blank',
					        		  method:'POST',
					        		  params :{
					        			  access_token : Ext.Ajax.defaultHeaders.access_token, 
					        			  
					        			  'program' : programArray.join(),
					        			  'batch' : batchArray.join(),
					        			  'seatType' : seatTypeArray.join(),
					        			  'applicationstatus' : formValues.applicationstatus,	  
					        			  },
					        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
					        		  url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_APPLICANT_RELATIONSHIP,
					        		  standardSubmit :true,
					        		  success : function(form, action){
					        			  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
					        		  },
					        		  failure: function(form, action) {
					        			  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
					        		  }
					        	  });
					          	
				        	}  
				        },
						        
						        /** import applicant relationship grid */
						        'importapplicantrelationshipgrid':{
						        	   			render:function(obj){
						        	   				var $this = this;
						         		    		var grid = $this.getImportapplicantrelationshipgrid();
						         		    		var form = $this.getApplicationsUploaduploadoptionradiogroup();
						         		    		var isUploadAll = form.items.items[0].getValue().isUploadAll;
						         		    		$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_APPLICANT_RELATIONSHIP');
						        	   			},
						         		    	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						            				if (e.target.tagName == 'A') {
						            					var fileType=null;
						            					if(cellIndex==1){
						            						fileType='successFile';
						            					}else if(cellIndex==6){
						            						fileType='errorFile';
						            					}else if(cellIndex==7){
						            						fileType='logFile';
						            					}
						            					var documentId = record.get("id");
						            					if (!isNullOrEmpty(documentId)) {
						            						this.getDownloadFile(documentId,fileType);
						            					}
						            				}
						            			}
						        	   		},
						        'importapplicantrelationshipgrid button[itemId=btnForce]':{
						        		click: function(obj) {
						        		var grid = this.getImportapplicantrelationshipgrid();
						        			if (grid.getSelectionModel().getCount() > 0) {
						        			    if(grid.getSelectionModel().getCount() > 1){
						        				  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						        				}else{
						        				    var this$ = this;
						        		   	        var id = grid.getSelectionModel().getSelection()[0].data.id;
						        		   	        console.log(id);
						        		   	        var urlAppend="?jobName="+id;
						        		   	        var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						        		   	    	Ext.Ajax.request({
						        		   	    	url: submitURL,
						        		   	    	method: 'GET',
						        		   	    	success: function(response) {
						        		   	    	    if(response.responseText==="JOB_STATUS_NOT_PENDING"){
						        		   	    	      showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
						        		   	    	     }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
						        		   	    	        showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
						        		   	    	     }else if(response.responseText==="SUCCESS"){
						        		       	    	     showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						        		   	    	     }
						        		   	    	 }
						        		   	    	 });
						        				  }
						        			    } else {
						        			       showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						        			    }  
						        	 }
						        },

						        /** import applicant relationship upload form loader */
						        	'importapplicantrelationshipuploadform button[itemId=resetBtn]':{
						        		   	click: function() {
						        		   		var importapplicantrelationshipuploadform = this.getImportapplicantrelationshipuploadform().getForm();
						        		   		importapplicantrelationshipuploadform.findField('file').reset();
						        		   		var uploadoptionradiogroupform  = this.getApplicationsUploaduploadoptionradiogroup();
						        		   		uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						        		   		isUploadAll: false
						        		   		});
						        		   	}
						        	},
						        	'importapplicantrelationshipuploadform button[itemId=uploadId]':{
						        			        		click:function(obj){
						        			        			var $this=this;
						        			    	        	var importWin=$this.getImportapplicantrelationshipuploadform()
						        			    	        	var grdStore;
						        			    	        	var form=$this.getImportapplicantrelationshipuploadform();
						        			    	        	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
						        			    	        	$this.getHashOfFile(form);
						        					        	setTimeout(function() {
						        				    	        	form.getForm().submit({
						        				    	        		method : 'POST',
						        				    	        		url : submitUrl,
						        				    	        		success : function(form, action){
						        				    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						        				    	    	        },
						        				    	        		failure: function(form, action) {
						        			   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
						        				    	    	        }
						        				    	        	});
						        					        	},1000);

						        			        			 Ext.defer(function() {
						        			        				 var grid = $this.getImportapplicantrelationshipgrid();
						        			        				 var form = $this.getApplicationsUploaduploadoptionradiogroup();
						        			        				 var isUploadAll = form.items.items[0].getValue().isUploadAll;
						        			        				 $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_APPLICANT_RELATIONSHIP');
						        			         	        }, 2000, this);
						        			        		}  
						        	 },
						        	 'importapplicantrelationshipuploadform uploadoptionradiogroup[itemId=applicationsUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
						        		 			 change: function( radioGroup, newValue, oldValue, eOpts){
						        		 				 var grid =this.getImportapplicantrelationshipgrid();
						        		 				 var form =this.getApplicationsUploaduploadoptionradiogroup();
						        		 				 var isUploadAll = newValue.isUploadAll;
						        		 				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_APPLICANT_RELATIONSHIP');
						        		 			 }   
						        	 },
						        	'importapplicantrelationshipuploadform':{
						        			 show:function(obj){
						        			       var $this=this;
						        			       var structure=$this.getImporttabstructure();
						        			       var importWin=structure.down('#importapplicantrelationshipuploadformItemId');
						        			       var moduleName = importWin.down('#moduleName');
						        			       moduleName.getStore().load({
						        			       callback: function(records, operation, success) {
						        			       for(var i in records){
						        				    if(records[i].data.value=="Bulk Import Applicant Relationship"){
						        				    	moduleName.setValue(records[i].data.id);
						        				    	moduleName.setReadOnly(true)
						        				    }
						        			       }
						        			       }	
						        			       });
						        			 }  
						        	},
							        'searchresultgrid[itemId=applicationsListGrid] menuitem[itemId=pandaDocItemId]': {
							        	click: this.openPandaDocPopup
							        },

			/** bulk update application status upload form loader */
			'bulkupdateapplicationstatusuploadform button[itemId=resetBtn]': {
				click: function() {
					var bulkupdateapplicationstatusuploadform = this.getBulkupdateapplicationstatusuploadform().getForm();
					bulkupdateapplicationstatusuploadform.findField('file').reset();
					var uploadoptionradiogroupform = this.getApplicationsUploaduploadoptionradiogroup();
					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
						isUploadAll: false
					});
				}
			},
			'bulkupdateapplicationstatusuploadform button[itemId=uploadId]': {
				click: function(obj) {
					var $this = this;
					var form = $this.getBulkupdateapplicationstatusuploadform();
					submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
					$this.getHashOfFile(form);
					setTimeout(function() {
						form.getForm().submit({
							method: 'POST',
							url: submitUrl,
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
							},
							failure: function(form, action) {
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_CONTENT_MISMATCH'));
							}
						});
					}, 1000);
					Ext.defer(function() {
						var grid = $this.getBulkupdateapplicationstatusgrid();
						var form = $this.getApplicationsUploaduploadoptionradiogroup();
						var isUploadAll = form.items.items[0].getValue().isUploadAll;
						$this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'BULK_UPDATE_APPLICATION_STATUS');
					}, 2000, this);
				}
			},
			'bulkupdateapplicationstatusuploadform uploadoptionradiogroup[itemId=applicationsUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]': {
				change: function(radioGroup, newValue, oldValue, eOpts) {
					var grid = this.getBulkupdateapplicationstatusgrid();
					var isUploadAll = newValue.isUploadAll;
					this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'BULK_UPDATE_APPLICATION_STATUS');
				}
			},
			'bulkupdateapplicationstatusuploadform': {
				show: function(obj) {
					var $this = this;
					var structure = $this.getImporttabstructure();
					var importWin = structure.down('#bulkupdateapplicationstatusuploadformItemId');
					var moduleName = importWin.down('#moduleName');
					moduleName.getStore().load({
						callback: function(records, operation, success) {
							for (var i in records) {
								if (records[i].data.value == "Bulk Update Application Status") {
									moduleName.setValue(records[i].data.id);
									moduleName.setReadOnly(true)
								}
							}
						}
					});
				}
			},
			/** bulk update application status grid */
			'bulkupdateapplicationstatusgrid': {
				render: function(obj) {
					var $this = this;
					var grid = $this.getBulkupdateapplicationstatusgrid();
					var form = $this.getApplicationsUploaduploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid, 'BULK_UPDATE_APPLICATION_STATUS');
				},
				cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					if (e.target.tagName == 'A') {
						var fileType = null;
						if (cellIndex == 1) {
							fileType = 'successFile';
						} else if (cellIndex == 6) {
							fileType = 'errorFile';
						} else if (cellIndex == 7) {
							fileType = 'logFile';
						}
						var documentId = record.get("id");
						if (!isNullOrEmpty(documentId)) {
							this.getDownloadFile(documentId, fileType);
						}
					}
				}
			},
			'bulkupdateapplicationstatusgrid button[itemId=btnForce]': {
				click: function(obj) {
					var grid = this.getBulkupdateapplicationstatusgrid();
					if (grid.getSelectionModel().getCount() > 0) {
						if (grid.getSelectionModel().getCount() > 1) {
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
						} else {
							var id = grid.getSelectionModel().getSelection()[0].data.id;
							console.log(id);
							var urlAppend = "?jobName=" + id;
							var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER + urlAppend;
							Ext.Ajax.request({
								url: submitURL,
								method: 'GET',
								success: function(response) {
									if (response.responseText === "JOB_STATUS_NOT_PENDING") {
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
									} else if (response.responseText === "SIMILAR_NATURE_JOB_ALREADY_RUNNING") {
										showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
									} else if (response.responseText === "SUCCESS") {
										showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
									}
								}
							});
						}
					} else {
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			/** Bulk update application status download form **/
			'bulkupdateapplicationstatusdownloadform[itemId=bulkupdateapplicationstatusdownloadformItemId] button#downoladBtnId': {
				click: function() {
					var form = this.getBulkupdateapplicationstatusdownloadform().getForm();
					var formValues = form.getValues();

					var academyLocationId = formValues.ACAD_LOC_ID;
					var intakeYearId = formValues.intakeYear;
					var programGroupIds = [];
					var programIds = [];
					var batchIds = [];
					var seatTypeIds = [];
					var applicationStatus = formValues.applicationstatus;
					
					if (isNullOrEmpty(formValues.PROGRAM_GROUP) || (formValues.PROGRAM_GROUP && formValues.PROGRAM_GROUP.length == 1 && formValues.PROGRAM_GROUP[0] == '')) {
						programGroupIds = '';
					} else {
						for (var i = 0; i < formValues.PROGRAM_GROUP.length; ++i) {
							programGroupIds.push(formValues.PROGRAM_GROUP[i].data.id);
						}
						programGroupIds = programGroupIds.join(',')
					}
            		
					if (isNullOrEmpty(formValues.PROGRAM_NAME) || (formValues.PROGRAM_NAME && formValues.PROGRAM_NAME.length == 1 && formValues.PROGRAM_NAME[0] == '')) {
						programIds = '';
					} else {
						for (var i = 0; i < formValues.PROGRAM_NAME.length; ++i) {
							programIds.push(formValues.PROGRAM_NAME[i].data.id);
						}
						programIds = programIds.join(',')
					}
            		
					if (isNullOrEmpty(formValues.BATCH_NAME) || (formValues.BATCH_NAME && formValues.BATCH_NAME.length == 1 && formValues.BATCH_NAME[0] == '')) {
						batchIds = '';
					} else {
						for (var i = 0; i < formValues.BATCH_NAME.length; ++i) {
							batchIds.push(formValues.BATCH_NAME[i].data.id);
						}
						batchIds = batchIds.join(',')
					}
            		
					if (isNullOrEmpty(formValues.SEAT_TYPE) || (formValues.SEAT_TYPE && formValues.SEAT_TYPE.length == 1 && formValues.SEAT_TYPE[0] == '')) {
						seatTypeIds = '';
					} else {
						for (var i = 0; i < formValues.SEAT_TYPE.length; ++i) {
							seatTypeIds.push(formValues.SEAT_TYPE[i].data.sequence);
						}
						seatTypeIds = seatTypeIds.join(',')
					}
					
					var csvForm = Ext.create('Ext.form.Panel', {

					});
					csvForm.getForm().submit({
						target: '_blank',
						method: 'POST',
						params :{
            				access_token : Ext.Ajax.defaultHeaders.access_token,
            				academyLocationId:academyLocationId,
            				intakeYearId:intakeYearId,
            				programGroupIds:programGroupIds,
            				programIds:programIds,
            				batchIds:batchIds,
            				seatTypeIds:seatTypeIds,
            				applicationStatus: applicationStatus
            			},
						headers: { 'Authorization': Ext.Ajax.defaultHeaders.Authorization },
						url: SERVERURL.PATH_DOWNLOAD_BULK_UPDATE_APPLICATION_STATUS,
						standardSubmit: true,
						success: function(form, action) {
							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
						},
						failure: function(form, action) {
							showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
						}
					});
				}
        	},
			'bulkupdateapplicationstatusdownloadform[itemId=bulkupdateapplicationstatusdownloadformItemId] button[itemId=resetBtn]': {
				click: function(obj) {
					var applicationdownloadForm = this.getBulkupdateapplicationstatusdownloadform().getForm();
					applicationdownloadForm.reset();
				}
			},
			'bulkupdateapplicationstatusdownloadform customcombobox[itemId=academyLocationCombo]': {
				afterrender: function(combo) {
					var me = this;
					this.loadAcadLocCombo(combo);
					var store = combo.getStore();
					store.load({
						callback: function(records, response, success) {
							combo.setValue(me.getCurrentAcademyLocation())
						}
					});
				},
				change: function(obj) {
					var form = obj.up('form');
					var academyLocation = form.down('#academyLocationCombo').getValue();
					var intakeYearField = form.down('#intakeYear');
					var intakeYear = intakeYearField.getValue();
					var programGroup = form.down('#programGroup');
					var program = form.down('#program');
					var batch = form.down('#batch');
					var seatType = form.down('#seatType');

					// Reset chain
					intakeYearField.reset(); programGroup.reset(); program.reset(); batch.reset(); seatType.reset();
					//program.setDisabled(true);
					 batch.setDisabled(true); seatType.setDisabled(true);

					if (academyLocation && intakeYear) {
						var store = programGroup.getStore();
						store.proxy.extraParams = {
							academyLocationId: academyLocation,
							intakeYearId: intakeYear
						};
						store.load();
					}
				}
			},
			'bulkupdateapplicationstatusdownloadform customcombobox[itemId=intakeYear]': {
				change: function(obj, record) {
					var form = obj.up('form');
					var academyLocationField = form.down('#academyLocationCombo');
					var intakeYearField = form.down('#intakeYear');
					var programGroupField = form.down('#programGroup');
					var programField = form.down('#program');
					var batchField = form.down('#batch');
					var seatTypeField = form.down('#seatType');

					var academyLocationValue = academyLocationField.getValue();
					var intakeYearValue = intakeYearField.getValue();

					programGroupField.reset();
					programField.reset();
					batchField.reset();
					seatTypeField.reset();

					//programField.setDisabled(true);
					batchField.setDisabled(true);
					seatTypeField.setDisabled(true);
					if (!isNullOrEmpty(academyLocationValue && intakeYearValue)) {
						var programGroupStore = programGroupField.getStore();
						programGroupStore.proxy.extraParams = {
							academyLocationIds: academyLocationValue,
							intakeYear: intakeYearValue
						};
						programGroupStore.load();
						
						programField.getStore().getProxy().extraParams = {
												academyLocationId: academyLocationValue,
												intakeYearId: intakeYearValue,
											};
											programField.getStore().load();
					}
				}
			},
			'bulkupdateapplicationstatusdownloadform multiselectcombofield[itemId=programGroup]': {
				change: function(combo, newValue, oldValue) {
					var $this = this;
        	        var form = $this.getBulkupdateapplicationstatusdownloadform();
					var academyLocationField = form.down('#academyLocationCombo');
					var intakeYearField = form.down('#intakeYear');
					var programField = form.down('#program');
					var batchField = form.down('#batch');
					var seatTypeField = form.down('#seatType');

					var academyLocationValue = academyLocationField.getValue();
					var intakeYearValue = intakeYearField.getValue();

					programField.reset();
					batchField.reset();
					seatTypeField.reset();

					if (Ext.isArray(newValue) && newValue.length > 0) {
						var programGroups = newValue.join(',');

						//programField.setDisabled(false);
						programField.getStore().getProxy().extraParams = {
							academyLocationId: academyLocationValue,
							intakeYearId: intakeYearValue,
							programGroupIds: programGroups
						};
						programField.getStore().load();
						programField.setValue(null);
					} else {
						batchField.setDisabled(true);
						seatTypeField.setDisabled(true);
						//programField.setDisabled(true);
						programField.setValue(null);
						programField.getStore().removeAll();
					}
				}
			},
			'bulkupdateapplicationstatusdownloadform multiselectcombofield[itemId=program]': {
			     change: function(combo, newValue, oldValue) {
        	        var $this = this;
        	        var form = $this.getBulkupdateapplicationstatusdownloadform();
					var academyLocationField = form.down('#academyLocationCombo');
					var intakeYearField = form.down('#intakeYear');
					var batchField = form.down('#batch');
					var seatTypeField = form.down('#seatType');

                    var academyLocationValue = academyLocationField.getValue();
					var intakeYearValue = intakeYearField.getValue();

					batchField.reset();
					seatTypeField.reset();
					
					if (Ext.isArray(newValue) && newValue.length > 0) {
        	            var programs = newValue.join(',');

        	            batchField.setDisabled(false);
        	            batchField.getStore().getProxy().extraParams = {
        	                programIds: programs,
        	                isActive: true,
        	                intakeYearId: intakeYearValue,
        	                academyLocationId: academyLocationValue
        	            };
        	            batchField.getStore().load();
        	            batchField.setValue(null);
        	        } else {
        	            batchField.setDisabled(true);
        	            seatTypeField.setDisabled(true);
        	            batchField.setValue(null);
        	            batchField.getStore().removeAll();
        	        }
				}
			},
			'bulkupdateapplicationstatusdownloadform multiselectcombofield[itemId=batch]': {
				 change: function(combo, newValue, oldValue) {
        	        var $this = this;
        	        var form = $this.getBulkupdateapplicationstatusdownloadform();
					var seatTypeField = form.down('#seatType');

					seatTypeField.reset();

					if (Ext.isArray(newValue) && newValue.length > 0) {
        	            var batchs = newValue.join(',');

        	            seatTypeField.setDisabled(false);
        	            seatTypeField.getStore().getProxy().extraParams = {
        	            	batchIds: batchs
        	            };
        	            seatTypeField.getStore().load();
        	            seatTypeField.setValue(null);
        	        } else {
        	            seatTypeField.setDisabled(true);
        	            seatTypeField.setValue(null);
        	            seatTypeField.getStore().removeAll();
        	        }
				}
			},

							        /** Import bulk admission approval loader **/
							        
							        'importbulkadmissionapprovaluploadform button[itemId=resetBtn]':{
					        		   	click: function() {
					        		   		var importbulkadmissionapprovaluploadform = this.getImportbulkadmissionapprovaluploadform().getForm();
					        		   		importbulkadmissionapprovaluploadform.findField('file').reset();
					        		   	}
							        },
							        'importbulkadmissionapprovaluploadform':{
					        			 show:function(obj){
					        			       var $this=this;
					        			       var structure=$this.getImporttabstructure();
					        			       var importWin=structure.down('#importbulkadmissionapprovaluploadformItemId');
					        			       var moduleName = importWin.down('#moduleName');
					        			       moduleName.getStore().load({
					        			       callback: function(records, operation, success) {
					        			       for(var i in records){
					        				    if(records[i].data.value=="Import Bulk Admission Approval"){
					        				    	moduleName.setValue(records[i].data.id);
					        				    	moduleName.setReadOnly(true)
					        				    }
					        			       }
					        			       }	
					        			       });
					        			 }  
							        },
							        'importbulkadmissionapprovaluploadform button[itemId=uploadId]':{
							   			click:function(obj){
							   				var $this=this;
							   				var importWin=$this.getImportbulkadmissionapprovaluploadform();
							   				var grdStore;
							   				var form=$this.getImportbulkadmissionapprovaluploadform();
							   				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
						    	        	$this.getHashOfFile(form);
								        	setTimeout(function() {
								   				form.getForm().submit({
								   					method : 'POST',
								   					url : submitUrl,
								   					success : function(form, action){
								   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
								   					},
								   					failure: function(form, action) {
						   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
								   					}
								   				});
								        	},1000);
							   				Ext.defer(function() {
							   					var grid = $this.getImportlistadmissionapproval();
							   					var form =this.getImportbulkadmissionuploadoptionradiogroup();
							   					var isUploadAll = form.items.items[0].getValue().isUploadAll;
							   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ADMISSION_APPROVAL');
							   				}, 2000, this);
							   			}  
							   		},
							   		'importbulkadmissionapprovaluploadform uploadoptionradiogroup[itemId=importBulkAdmissionUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
							   			change: function( radioGroup, newValue, oldValue, eOpts){
							   				var grid =this.getImportlistadmissionapproval();
							   				var isUploadAll = newValue.isUploadAll;
							   				this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ADMISSION_APPROVAL');
							   			}   
							   		},
							   		'importlistadmissionapproval':{
							   			render:function(obj){
							   				var $this = this;
							   				var grid = $this.getImportlistadmissionapproval();
							   				var form =this.getImportbulkadmissionuploadoptionradiogroup();
						   					var isUploadAll = form.items.items[0].getValue().isUploadAll;
						   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_ADMISSION_APPROVAL');
							   			},
							   			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
							   				if (e.target.tagName == 'A') {
							   					var fileType=null;
							   					if(cellIndex==1){
							   						fileType='successFile';
							   					}else if(cellIndex==6){
							   						fileType='errorFile';
							   					}else if(cellIndex==7){
							   						fileType='logFile';
							   					}
							   					var documentId = record.get("id");
							   					if (!isNullOrEmpty(documentId)) {
							   						this.getDownloadFile(documentId,fileType);
							   					}
							   				}
							   			}
							   		},
							   		'importlistadmissionapproval button[itemId=btnForce]':{
							   			click: function(obj) {
							   				var grid = this.getImportlistadmissionapproval();
							   				if (grid.getSelectionModel().getCount() > 0) {
							   					if(grid.getSelectionModel().getCount() > 1){
							   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
							   					}else{
							   						var this$ = this;
							   						var id = grid.getSelectionModel().selectionStart.data.id;
							   						console.log(id);
							   						var urlAppend="?jobName="+id;
							   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
							   						Ext.Ajax.request({
							   							url: submitURL,
							   							method: 'GET',
							   							success: function(response) {
							   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
							   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
							   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
							   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
							   								}else if(response.responseText==="SUCCESS"){
							   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
							   								}
							   							}
							   						});
							   					}
							   				} else {
							   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
							   				}  
							   			}
							   		},
							        'importbulkadmissionapprovaldownloadform[itemId=importbulkadmissionapprovaldownloadformItemId] customcombobox[itemId=academyLocationCombo]': {
							        	 afterrender: function(combo) {
							        		var me = this;
							                this.loadAcadLocCombo(combo);
							        		var store = combo.getStore();
							                store.load({
							                    callback:function(records,response,success){
							        		 		combo.setValue(me.getCurrentAcademyLocation())
							        		 		}
							        		 	});
							        	 }
			     	          	},
				 		 		 'importbulkadmissionapprovaldownloadform[itemId=importbulkadmissionapprovaldownloadformItemId] button[itemId=resetBtn]':{
				 		 			click: function(obj) {
				 		   				var applicationdownloadForm = this.getImportbulkadmissionapprovaldownloadform().getForm();
				 		   				applicationdownloadForm.reset();
				 		   				var academyLocationIds = obj.up('form').down('#academyLocationCombo');
				 		   				var academyLocationId= this.getCurrentAcademyLocation();
				 		   				var academyLocationIdStore = academyLocationIds.getStore();
				 		   				            				 
				 		   				var academyLocationId = this.getCurrentAcademyLocation();
				 		   				academyLocationIds.getStore().load({
				 		   				                                	
				 		   					callback: function(record){		                                		
				 		   						academyLocationIds.select(academyLocationId);		                                	
				 		   					}		                                
				 		   				});
				 		 				}				 	        	 
				 		   			},
				 		   		'importbulkadmissionapprovaldownloadform[itemId=importbulkadmissionapprovaldownloadformItemId] button[itemId=downoladBtnId]':{
				 		   			click: function() {
				 		   				var form = this.getImportbulkadmissionapprovaldownloadform();
				 		   				var alId= form.down('#academyLocationCombo').getValue();
				 		   				var csvForm = Ext.create('Ext.form.Panel',{
				 		   					
				 		   				});
				 		   				csvForm.getForm().submit({
				 		   					target: '_blank',
				 		   					method:'POST',
				 		   					params :{access_token : Ext.Ajax.defaultHeaders.access_token, 'academyLocationId' : alId},
				 		   					headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				 		   					url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_ADMISSION_APPROVAL,
				 		   					standardSubmit :true,
				 		   					success : function(form, action){
				 		   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
				 		   					},
				 		   					failure: function(form, action) {
				 		   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'),getCommonTranslation('SUCCESS'));
				 		   					}
				 		   				});
				 		   			}
				 		   		},

						        	/*-- import loder code start*/
							        'importtabstructure [itemId=templateTypeLoderItemId]':{
							        	afterrender: function(combo){
							        		   var associatedAcadLocationIds = new Array();
                                               associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                                               var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICANT_PERMISSIONS());
                                                combo.getStore().on('load', function(record){
                                                    var firstArray = ['IMPORT_BULK_ADMISSION', 'IMPORT_BULK_APPLICATION', 'IMPORT_BULK_APPLICATION_NEW', 'IMPORT_APPLICANT_RELATIONSHIP', 'IMPORT_BULK_ADMISSION_APPROVAL', 'BULK_UPDATE_APPLICATION_STATUS'];
                                                    var secondArray = permissionList;
                                                    var thirdArray= [];
                                                    Ext.each(firstArray, function(currentItem){
                                                        if(secondArray.indexOf(currentItem) == -1){
                                                            thirdArray.push(currentItem);
                                                        }
                                                    });
                                                   
                                                    Ext.each(thirdArray, function(privilege) {
                                                        if (privilege == 'IMPORT_BULK_ADMISSION' || privilege == 'IMPORT_BULK_APPLICATION' || privilege == 'IMPORT_BULK_APPLICATION_NEW' || privilege == 'IMPORT_APPLICANT_RELATIONSHIP' || privilege == 'IMPORT_BULK_ADMISSION_APPROVAL' || privilege == 'BULK_UPDATE_APPLICATION_STATUS') {
                                                            var index = record.findExact('name',privilege)
                                                            record.removeAt(index);
                                                        }
                                                    });
                                                });
							            	}
							           },
							        	
							        	
						        	'importtabstructure customcombobox[itemId=templateTypeLoderItemId]': {
						     			 select: function(obj, record) {
						     				 var $this = this;
						     				 var field = obj.up('importtabstructure').down('#templateTypeLoderItemId');
						     				 var templateName = field.getValue();
						     				 var structure=obj.up('importtabstructure');
						     				 var radioFiled=structure.down('#importDownloadradiogroupId');
						     				 radioFiled.items.items[0].setValue(true);
						     				 radioFiled.items.items[1].setValue(false);
						     				 var newValue=radioFiled.getValue();
						     				 this.hideAllForm(structure);
						     				 switch (templateName){
						     				 case 'IMPORT_BULK_APPLICATION_NEW':
						     					this.downloadUploadApplicationNewFormChange(structure, newValue, null);
						     					 break;
						     				case 'IMPORT_BULK_ADMISSION':
						     	   			    this.downloadUploadFormChange(structure, newValue, null);
						     					 break;
						     				case 'IMPORT_BULK_APPLICATION':
						     					this.downloadUploadApplicationFormChange(structure, newValue, null);
						     					break;
						     				case 'IMPORT_APPLICANT_PAST_HISTORY':
						     					this.applicantPastHistoryLoaderRadioBtn(structure, newValue, null);
						     					break;
						     				case 'IMPORT_APPLICANT_RELATIONSHIP':
						     					   this.downloadUploadFormChangeApplicantRelationship(structure, newValue, null);
						     					 break;
						     				case 'IMPORT_BULK_ADMISSION_APPROVAL':
							 					   this.downloadUploadBulkAdmissionApprovalFormChange(structure, newValue, null);
							 					 break;
											case 'BULK_UPDATE_APPLICATION_STATUS':
												   this.downloadUploadUpdateApplicationStatusFormChange(structure, newValue, null);
											break;		 
						     				 default : null;
						     				 }
						     			 }
							        },
							        
							    'applicantprofile profiletemplate[itemId=applicantProfileTemplate]': {
					     				 render: this.addStudentLinkClickHandler 
					     	      },
					     	      'applicantprofile fieldset[itemId=applicantExpandContainerItemId]': {
					     	    	  expand: function(cmp) {
					     	    		  var store = cmp.down('selectionsnapshotgrid').getStore();
					     	    		  var applicantprofile = cmp.up('applicantprofile');
					     	    		  if(!store.isLoaded) {
					     	    			  store.isLoaded = true;
					     	    			  this.gettingDataInSummaryGridExpand(applicantprofile);
					     	    		  }
					     	    	  },
					     	    	  afterrender: function(cmp){
					     	    		  var store = cmp.down('selectionsnapshotgrid').getStore();
					     	    		  store.isLoaded = false;
					     	    	  }
					     	      }
				           });				
    },
    
	addStudentLinkClickHandler: function(view) {
	        var me = this;
	        var portalId = me.getCurrentLoggedPortalId();

	        if (portalId == 1) {
	            var el = view.getEl();

	            if (el) {
	                var grid = view.up('contentpanel').down('searchresultgrid');
	                var records = grid.getSelectionModel().getSelection();

	                if (records.length > 0) {
	                    var recordData = records[0].data;

	                    el.on('click', function(event, target) {
	                        event = event || window.event;
	                        target = target || event.target;

	                        if (event.stopPropagation) {
	                            event.stopPropagation();
	                        } else {
	                            event.cancelBubble = true;
	                        }

	                        var targetEl = Ext.fly(target);

	                        if (targetEl && (targetEl.hasCls('student-code-link') || targetEl.hasCls('linked-student-id-link'))) {
	                            var admissionId = target.getAttribute('data-admissionId') || '';
	                            var personId = target.getAttribute('data-studentPersonId') || '';
	                            var studentCode = target.getAttribute('data-studentCode') || '';
	                            var userId = target.getAttribute('data-studentId') || '';
	                            var programBatchSeatConfigId = recordData.PROG_BATCH_SEAT_CONFIG_ID;

	                            if (targetEl.hasCls('student-code-link')) {
	                                me.handleStudentLinkClick(admissionId, personId, studentCode, programBatchSeatConfigId, userId);
	                            } else if (targetEl.hasCls('linked-student-id-link')) {
	                                me.handleLinkedStudentLinkClick(admissionId, personId, studentCode, programBatchSeatConfigId, userId);
	                            }
	                        }
	                    }, me, { delegate: 'a' });
					} else {            
						el.on('click', function(event, target) {
							if (target.getAttribute('data-programBatchSeatConfigId')){
							event = event || window.event;
							target = target || event.target;

							if (event.stopPropagation) {
								event.stopPropagation();
							} else {
								event.cancelBubble = true;
							}

							var targetEl = Ext.fly(target);

							if (targetEl && (targetEl.hasCls('student-code-link') || targetEl.hasCls('linked-student-id-link'))) {
								var admissionId = target.getAttribute('data-admissionId') || '';
								var personId = target.getAttribute('data-studentPersonId') || '';
								var studentCode = target.getAttribute('data-studentCode') || '';
								var userId = target.getAttribute('data-studentId') || '';
								var programBatchSeatConfigId = target.getAttribute('data-programBatchSeatConfigId') || '';

								if (targetEl.hasCls('student-code-link')) {
									me.handleStudentLinkClick(admissionId, personId, studentCode, programBatchSeatConfigId, userId);
								} else if (targetEl.hasCls('linked-student-id-link')) {
									me.handleLinkedStudentLinkClick(admissionId, personId, studentCode, programBatchSeatConfigId, userId);
								}
							}
						   }	
						}, me, { delegate: 'a' });
					}
	            }
	        }
	    },
    
    handleLinkedStudentLinkClick: function(admissionId, personId, studentCode, programBatchSeatConfigId,userId) {
        if(!isNullOrEmpty(userId)) {
                var tabTitle = studentCode;
                var personId = personId;
                var admissionId=admissionId;	                			                     
                var programBatchSeatTypeConfigId = programBatchSeatConfigId;
                Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
                var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
                var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
                personController.isProfilePicSaved = false;
                personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
            }
   
       },
    
    handleStudentLinkClick: function(admissionId, personId, studentCode, programBatchSeatConfigId,userId) {
	             if(!isNullOrEmpty(userId)) {
	                     var tabTitle = studentCode;
	                     var personId = personId;
	                     var admissionId=admissionId;	                			                     
	                     var programBatchSeatTypeConfigId = programBatchSeatConfigId;
	                     Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
	                     var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	                     var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
	                     personController.isProfilePicSaved = false;
	                     personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
	                 }
	        
	},
	
    hideAllForm:function(structure){
    	    structure.down('#importapplicationsnewdownloadformId').hide();
			structure.down('#applicationsdownloadformId').hide();
			structure.down('#importapplicationsdownloadformId').hide();
			structure.down('#applicantcompetitivepasthistoryloaderdownloadformId').hide(); 
			structure.down('#importapplicantrelationshipdownloadformItemId').hide();
         
			structure.down('#importapplicantrelationshipuploadformItemId').hide();
			structure.down('#applicantcompetitivepasthistoryloaderuploadformId').hide();
			structure.down('#importapplicationsnewuploadformId').hide();
			structure.down('#importapplicationsuploadformId').hide(); 
			structure.down('#applicationsuploadformId').hide();
        
			structure.down('#importapplicantrelationshipgridItemId').hide();
			structure.down('#importlistapplicanthistoryloaderId').hide();
			structure.down('#importlistnewapplicantId').hide();
			structure.down('#importlistapplicationsId').hide(); 
			structure.down('#importListApplicant').hide();
			
			structure.down('#importbulkadmissionapprovaldownloadformItemId').hide();
			structure.down('#importbulkadmissionapprovaluploadformItemId').hide();
			structure.down('#importlistadmissionapprovalId').hide(); 
        	
			structure.down('#bulkupdateapplicationstatusuploadformItemId').hide();
			structure.down('#bulkupdateapplicationstatusdownloadformItemId').hide();
			structure.down('#bulkupdateapplicationstatusgridId').hide();
        	
    },
    closeOfferAcceptanceWin: function() {
    	var $this = this;
    	var formWindow = $this.getOfferacceptancewin();
    	formWindow.close();
    },
    exportApplicationFormPrintJRXML: function(fileType,grid) {
    	var $this=this;
		var form = $this.getApplicationformprintwindow();
		var  templateNameField = form.down("#applicationFormPrint");
		if(templateNameField.getValue()=='APPLICANT_PRINT_PROFILE'){
			$this.printProfileApplicant();
		}else{
			var record = grid.getSelectionModel().getSelection();
			var applicanttemp=[];
			for(var i in record){
				applicanttemp.push(record[i].get("ID"));
			}
			applicantId=applicanttemp.join();
			var profilePrintURL = SERVERURL.PATH_FIND_BULK_APPLICATION_FORM_PRINTING;
			var csvForm = Ext.create('Ext.form.Panel'); 
			csvForm.getForm().submit({
				target: '_blank',
				method:'POST',
				params :{
					access_token : Ext.Ajax.defaultHeaders.access_token,
					applicantIdsCommaSeperated : applicantId
				},
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				url: profilePrintURL,
				standardSubmit :true
			});
		}
    },
    printProfileApplicant:function(obj){
    	    var contentPanel = this.getContentPanel().getActiveTab();
    	    var grid = contentPanel.down('grid');
			var record = grid.getSelectionModel().getSelection();
			var applicanttemp=[];
			for(var i in record){
				applicanttemp.push(record[i].get("ID"));
			}
			applicantId=applicanttemp.join();
			var profilePrintURL = SERVERURL.PATH_FIND_BULK_APPLICANTPROFILE_PRINTING;
			var csvForm = Ext.create('Ext.form.Panel'); 
			csvForm.getForm().submit({
				target: '_blank',
				method:'POST',
				params :{
					access_token : Ext.Ajax.defaultHeaders.access_token,
					applicantIdsCommaSeperated : applicantId
				},
				headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				url: profilePrintURL,
				standardSubmit :true
			});
    },
    refreshSelectionSnapShotGridWin: function(grid) {
    	var $this = this;
    	var contentPanel = this.getContentPanel().getActiveTab();
    	if (!isNullOrEmpty(contentPanel) && !isNullOrEmpty(contentPanel.getApplicationDataObject()) &&
    			!isNullOrEmpty(contentPanel.getApplicationDataObject().code)) {
    		var applicantProfile = $this.getTabReferenceByTabTitle(contentPanel.getApplicationDataObject().code);
    		$this.gettingDataInSummaryGrid(applicantProfile);
    	}
    	var btnAcceptOfferItemId = grid.down("#btnAcceptOfferItemId");
    	var btnDeclineOfferItemId = grid.down("#btnDeclineOfferItemId");
    	btnAcceptOfferItemId.setDisabled(true);
    	btnDeclineOfferItemId.setDisabled(true);
    },
    closeAcceptOfferLetterWin: function() {
    	var $this = this;
    	var formWindow = $this.getAcceptofferletterwin();
    	formWindow.close();
    },
    closeDeclineOfferLetterWin: function() {
    	var $this = this;
    	var formWindow = $this.getDeclineofferletterwin();
    	formWindow.close();
    },
    loadComboWithAllValue:function(combo){
    	combo.getStore().load({
			callback: function(records, operation, success) {                            
				var model = new Academia.model.common.IdValueDataModel();
                model.set('id','');
                model.set('value', 'All');
                combo.getStore().insert(0,model);
            }
		});
    },
    loadAcadLocCombo: function(combo) {
        var store = combo.getStore();
        store.getProxy().extraParams = {
    		id: this.getCurrentlyLoggedInUser().id
    	};
        
    },
    loadDefaultAcadLocation:function(formPanel){

    	var this$= this,locCombo =formPanel.down('#location');
    	var acadCombo =formPanel.down('#academy'), programComboField =formPanel.down('#program');
    	
    	var c= Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0];
      	var data =c.findRecordByValue(c.getValue()).raw
    	
        acadCombo.setValue(data.academy.id);
  	  acadCombo.getStore().load({
    		  callback : function(){
    			  acadCombo.setValue(data.academy.id);
    			  this$.loadDependentCombo( locCombo, data.academy.id, 'academyId');
    		  }
    	  });
  	locCombo.setValue(data.location.id);
    	  locCombo.getStore().load({
    		  callback : function(records){
    			  Ext.each(records,function(items){
  		  			if(items.data.id === data.location.id){
  		  				locCombo.setValue(data.location.id);
  		  			}
  		  		});
    			this$.loadDependentCombo( programComboField, data.location.id, 'locationId','academyId',data.academy.id);
    		  }
    	  });
    },
    
    /*
     * This function is used for to perform selected action from acation combo on search result grid
     * 
     */
    performSelectedAction:function(url,method,jsonFormatData,searchResultGrid,successMsg,combo,rejectWindow){
    	var me = this;
    	//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');	
    	if(url=='rest/applicationProgram/approveOrRejectOrWithdrawnApplication'){
    		Ext.Ajax.timeout = 360000;	
        	showWarningMessage(getCommonTranslation('IN_PROGRESS'), getCommonTranslation("TRANSACTION_IN_PROGRESS_MESSAGE"));
    	}else{
    	  	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    	}
    	Ext.Ajax.request({
            type: 'rest',                                
            method: method,
            url: url,
            jsonData: (method === 'POST') ? jsonFormatData : "",            
            success: function(form, action) {   
            	try{
                	if(!isNullOrEmpty(rejectWindow)) {
                		rejectWindow.close();
                	}
                	if(searchResultGrid){
                    	searchResultGrid.getStore().reload();   
                	}
                	if(combo){
                    	combo.reset();
                	}
                	var searchPanel=me.getSearchPanel();
                	if(searchPanel){
                		var searchForm=searchPanel.getActiveTab().down('form');
                		if(searchForm){
                			me.loadGridAndSearchUsers(searchForm);
                		}
                	}
                	if( url == SERVERURL.APPLICATIONS_ACCEPT_OFFER_LETTER ){
                		// check for offer letter based document validation
                		var resp = Ext.JSON.decode(form.responseText);
                		if( resp.code == 'SUCCESS' ){
                			showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
                		} else {
                			if( resp.code == 'OFFER_BASED_PENDING_ERROR_ALL' ){
                				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('OFFER_BASED_PENDING_ERROR_ALL'));
                			}
                			if( resp.code == 'OFFER_BASED_PENDING_ERROR_PARTIAL' ){
                				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('OFFER_BASED_PENDING_ERROR_PARTIAL'));
                			}
                		}
                	} else {
                		showSuccessMessage(getCommonTranslation('SUCCESS'), successMsg);
                	}
            	}
            	catch(e){
            		//--
            	}
            },
            failure: function(form, action) {
            	var data = Ext.decode(form.responseText);
            	if(data[0].key == 'document_not_submitted')
            	{
            		/*showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_SUBMITTED'));*/ 
            	}else if(data[0].key == 'SEAT_CAPACITY_FULL')
            	{
            		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('SEAT_CAPACITY_FULL')); 
            	}else if(data[0].key == 'ADMISSION_OFFER_PROCESS_NOT_OPENED')
            	{
            		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('ADMISSION_OFFER_PROCESS_NOT_OPENED')); 
            	}else if(data[0].key == 'PROVISIONAL_OFFER_PROCESS_NOT_OPENED')
            	{
            		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PROVISIONAL_OFFER_PROCESS_NOT_OPENED')); 
            	}else if(data[0].key == 'cant_send_offer_letter_document_not_mapped')
            	{
            	//	showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('cant_send_offer_letter_document_not_mapped')); 
            	}else if(data[0].key == 'CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED')
            	{
            		showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('CANT_SEND_PROVISIONAL_OFFER_LETTER_DOCUMENT_NOT_MAPPED')); 
            	}else if(data[0].key == 'submit_characteristics_document'){
            		//showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('submit_characteristics_document')); 
            	}
            }
        });
    },
    
    /*
     * This function is used for to enable or disable combo
     * 
     */
    enableDisableCombo: function(selectedCombo,searchForm,itemId,params,whetherDisable) {
    	if(searchForm){
    		var combo=searchForm.down(itemId);
    		if(combo){
    			if(whetherDisable === undefined)
    				whetherDisable = false;
    			combo.setDisabled(whetherDisable);
    			combo.reset();
    			if(!isEmpty(params)){
    				combo.getStore().removeAll();
    				combo.getStore().load({
    					params:params,
    					callback: function(records, operation, success) {                            
    						var model = new Academia.model.common.IdValueDataModel();
    		                model.set('id','');
    		                model.set('value', 'All');
    		                combo.getStore().insert(0,model);
    		            }
    				});
    			}
    		}
    	}
    },
    
    /**
     * This function is to load the dependent combo
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
            dependentCombo.setDisabled(false);
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }else{
            dependentCombo.setDisabled(true);
        }
    },
    
    /**
     * This function is to reset other combo
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'academy':
            this.clearCombo(combo);
            locationCombo = container.down('combo[itemId=location]');
            this.clearCombo(locationCombo);
            programCombo = container.down('combo[itemId=program]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[itemId=batch]');
            this.clearCombo(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatType]');
            this.clearCombo(seatTypeCombo);
            break;
        case 'location':
            this.clearCombo(combo);
            programCombo = container.down('combo[itemId=program]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[itemId=batch]');
            this.clearCombo(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatType]');
            this.clearCombo(seatTypeCombo);
            break;
        case 'program':
            this.clearCombo(combo);
            batchCombo = container.down('combo[itemId=batch]');
            this.clearCombo(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatType]');
            this.clearCombo(seatTypeCombo);
            break;
        case 'batch':
        	this.clearCombo(combo);
        	seatTypeCombo = container.down('combo[itemId=seatType]');
        	this.clearCombo(seatTypeCombo);
        	break;
        case 'seatType':
        	this.clearCombo(combo);
        	
        }
    },
    
    /**
     * This function is to clear the combo value
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    
    /*
     * This function is used for to enable or disable combo
     * 
     */
    hideShowSearchGrid: function() {
    	var addAdmissionWindow=this.getAddAdmissionWindow();    	
    	var searchResultGrid = addAdmissionWindow.down('#searchGrid');    	
		if(searchResultGrid && searchResultGrid.isVisible()){
			searchResultGrid.setVisible(false);
		}
		
    },
    
    

    /*
     * This function is used for to show/hide Panel after clicking on radio
     */
    hideShowPanel: function(cmp, e, eOpts) {
        var me = this;
        var addAdmissionWindow = this.getAddAdmissionWindow();
        var applicantSearchForm = this.getApplicantSearchForm();
        var formSoldRadioField = addAdmissionWindow.down('#formSoldRadioField');
        var proceedBtn = addAdmissionWindow.down('#proceedBtn');    	     
        me.hideShowSearchGrid();
        if (applicantSearchForm) {
            var cmbApplicationType = applicantSearchForm.down('#cmbApplicationType');

            if (cmp.itemId === 'formSoldRadioField') {
                cmbApplicationType.setValue('APPLIED_EARLIER');
                cmbApplicationType.setVisible(false);
                me.showHideSearchCriteriaFields('APPLIED_EARLIER', applicantSearchForm);
            	proceedBtn.setDisabled(true);            	
            } else {
                cmbApplicationType.setVisible(true);
                cmbApplicationType.setValue('FRESH_APPLICANT');
                me.showHideSearchCriteriaFields('FRESH_APPLICANT', applicantSearchForm);
                proceedBtn.setDisabled(false);
            }
        }
    },
   exportApplicationListForDuplicateDetail : function(exportUrl,filetype,whetherAll,pageNo,limit) {
    	var $this = this;
    	var duplicateApplicationDetailsGrid = this.getDuplicateapplicationdetails();
    	var quickSearchForm = this.getBasicsearch();
    	var pagingtoolbaroptions = duplicateApplicationDetailsGrid.down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm, false);
    	var searchResultGrid = this.getSearchResultGrid();
    	
    	//Code for story
    	var searchForm = quickSearchForm;
    	
    		var emailArray = new Array();
    		var nationalArray = new Array();
    		var jsonFormatFormData = new Object();
    		jsonFormatFormData.configCode = "APPLICATION_LIST";
    		jsonFormatFormData.searchCriterias = new Array();
    		
        	var visibleColumns=this.getVisibleColumns(duplicateApplicationDetailsGrid);
        	var reportTitle=getCommonTranslation("APPLICATION_LIST");
        	var duplicateApplicationDetailsGridStore  =  duplicateApplicationDetailsGrid.getStore();
        	var mainGridSeletedRecord = searchResultGrid.getSelectionModel().getSelection();
        	var basicSearchForm = $this.getApplicationsListBasicSearchForm();
    		var alId = basicSearchForm.down('#academyLocationCombo').getValue();
    		if (mainGridSeletedRecord.length > 0) {
    			if(duplicateApplicationDetailsGridStore.data.length > 0) {
    				if(duplicateApplicationDetailsGrid.title === getAdmissionTranslation('DUPLICATE_APPLICATION_EMAIL_DETAILS') ){
    					Ext.each(mainGridSeletedRecord ,function(emailRecord){
    						if (!isNullOrEmpty(emailRecord.get('EMAIL'))) {
    							emailArray.push(emailRecord.get('EMAIL'));
    						}
    					});
    					var paramCodes = "EMAIL_ID";
    					var reportTitle = getAdmissionTranslation('DUPLICATE_APPLICATION_EMAIL_DETAILS');
    					if (emailArray.length > 0) {
    						jsonFormatFormData.searchCriterias.push({paramCode:paramCodes, paramValues:emailArray});
    					}

    				}
    				if(duplicateApplicationDetailsGrid.title === getAdmissionTranslation('DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS') ){
    					Ext.each(mainGridSeletedRecord ,function(nationalRecord){
    						if (!isNullOrEmpty(nationalRecord.get('NATIONAL_ID'))) {
    							nationalArray.push(nationalRecord.get('NATIONAL_ID'));
    						}
    					});
    					var paramCodes = "NATIONAL_ID";
    					var reportTitle = getAdmissionTranslation('DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS');
    					if (nationalArray.length > 0) {
    						jsonFormatFormData.searchCriterias.push({paramCode:paramCodes, paramValues:nationalArray}); 
    					}
    				}
    			}
    		}else{
				var paramCodes = "EMAIL_ID";
        	    var reportTitle = getAdmissionTranslation('DUPLICATE_APPLICATION_EMAIL_DETAILS');
        		if(duplicateApplicationDetailsGrid.title === getAdmissionTranslation('DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS') ){
        			var paramCodes = "NATIONAL_ID";
            		var reportTitle = getAdmissionTranslation('DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS');
        		}
        		var dataArray = $this.findDuplicateApplicationByEmailOrNationalId(paramCodes, basicSearchForm);
        		jsonFormatFormData.searchCriterias.push({paramCode:paramCodes, paramValues:dataArray});
			}
        	
    		/*if(!isEmpty(duplicateApplicationDetailsGrid.store.getCurrentSortCriteria()) &&duplicateApplicationDetailsGrid.store.getCurrentSortCriteria()!=undefined && duplicateApplicationDetailsGrid.store.getCurrentSortCriteria()!=null)
    			//jsonFormatFormData.sortCriterias=duplicateApplicationDetailsGrid.store.getCurrentSortCriteria();
    		*/	
        	/*if (alId != null) {
        		jsonFormatFormData.searchCriterias.push({paramCode:'ACAD_LOC_ID', paramValues:[alId]});	
			}*/
        	var basicFormVal = searchForm.getValues();
        	var admissionStatus = searchForm.down('#admissionStatus').getRawValue();
        	var stageStatus = basicFormVal.STAGE_STATUS;
        	if (!isNullOrEmpty(basicFormVal.STAGE_STATUS) && basicFormVal.STAGE_STATUS == 'INPROGRESS') {
        		stageStatus = searchForm.down('#stageStatus').getRawValue();
			}
        	
        	if(!isNullOrEmpty(basicFormVal.ACAD_LOC_ID)){
        		jsonFormatFormData.searchCriterias.push({paramCode:'ACAD_LOC_ID', paramValues:[basicFormVal.ACAD_LOC_ID]});
         	}
         	if(!isNullOrEmpty(basicFormVal.ADMISSION_STATUS)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'ADMISSION_STATUS', paramValues:[admissionStatus]});
         	}
         	if(!isNullOrEmpty(basicFormVal.ALTERNATE_EMAIL_ID)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'ALTERNATE_EMAIL_ID', paramValues:[basicFormVal.ALTERNATE_EMAIL_ID]});
         	}
         	if(!isNullOrEmpty(basicFormVal.APPICANT_PRINT_NAME)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'APPICANT_PRINT_NAME', paramValues:[basicFormVal.APPICANT_PRINT_NAME]});
         	}
         	if(!isNullOrEmpty(basicFormVal.APPLICATION_ID)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'APPLICATION_ID', paramValues:[basicFormVal.APPLICATION_ID]});
         	}
         	if(!isNullOrEmpty(basicFormVal.APPLICATION_STATUS)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'APPLICATION_STATUS', paramValues:[basicFormVal.APPLICATION_STATUS]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.BATCH)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'BATCH', paramValues:[basicFormVal.BATCH]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.COUNTRY_ID)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'COUNTRY_ID', paramValues:[basicFormVal.COUNTRY_ID]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.EMAIL_ID)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'EMAIL_ID', paramValues:[basicFormVal.EMAIL_ID]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.END_DATE)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'END_DATE', paramValues:[basicFormVal.END_DATE]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.ENQUIRY_NO)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'ENQUIRY_NO', paramValues:[basicFormVal.ENQUIRY_NO]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.MOBILE_NO)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'MOBILE_NO', paramValues:[basicFormVal.MOBILE_NO]});
         	} 
         	
         	if(!isNullOrEmpty(basicFormVal.PROGRAM)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'PROGRAM', paramValues:[basicFormVal.PROGRAM]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.PROGRAM_GROUP)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'PROGRAM_GROUP', paramValues:[basicFormVal.PROGRAM_GROUP]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.PROGRAM_STATUS)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'PROGRAM_STATUS', paramValues:[basicFormVal.PROGRAM_STATUS]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.REGISTRATION_TYPE)){
         		var registrationType = true;
         		if (basicFormVal.REGISTRATION_TYPE == 'FULL_TIME') {
         			registrationType = false;
    			}
         		jsonFormatFormData.searchCriterias.push({paramCode:'REGISTRATION_TYPE', paramValues:[registrationType]});
         	}
         	if(!isNullOrEmpty(basicFormVal.SELECTION_PROCESS)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'SELECTION_PROCESS', paramValues:[basicFormVal.SELECTION_PROCESS]});
         	}
         	if(!isNullOrEmpty(basicFormVal.STAGE_FEE_APPLICABLE)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'STAGE_FEE_APPLICABLE', paramValues:[basicFormVal.STAGE_FEE_APPLICABLE]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.STAGE_FEE_STATUS)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'STAGE_FEE_STATUS', paramValues:[basicFormVal.STAGE_FEE_STATUS]});
         	}
         	if(!isNullOrEmpty(basicFormVal.STAGE_STATUS)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'STAGE_STATUS', paramValues:[stageStatus]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.START_DATE)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'START_DATE', paramValues:[basicFormVal.START_DATE]});
         	}
         	if(!isNullOrEmpty(basicFormVal.applicantModeOfEnquiry)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'APPLICATION_PRIMERY_ID', paramValues:[basicFormVal.applicantModeOfEnquiry]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.applicationOwner)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'APPLICATION_OWNER_ID', paramValues:[basicFormVal.applicationOwner]});
         	} 
         	if(!isNullOrEmpty(basicFormVal.intakeYear)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'intakeYear', paramValues:[basicFormVal.intakeYear]});
         	} 
         	/*if(!isNullOrEmpty(basicFormVal.showApplications)){
         		jsonFormatFormData.searchCriterias.push({paramCode:'showApplications', paramValues:[basicFormVal.showApplications]});
         	}*/
    		duplicateApplicationDetailsGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit);
	},
    exportApplicationList : function(exportUrl,filetype,whetherAll,pageNo,limit) {
    	var $this = this;
    	var searchResultGrid = this.getSearchResultGrid();
    	var quickSearchForm = this.getApplicationsListBasicSearchForm();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm, true);
    	
    	//Code for story
    	var searchForm = quickSearchForm;
    	var enquiryModeIdsArray = searchForm.down('#applicantModeOfEnquiryItemId').getValue();
    	//V2D-103414-----------Start
    	var isMyApplications = searchForm.down('#myApplicationItemId').getValue();
    	if(enquiryModeIdsArray!=undefined){
    		if(enquiryModeIdsArray[0]==""){
    			enquiryModeIdsArray=null;
    		}
    	}
    	if(enquiryModeIdsArray==undefined){
    		enquiryModeIdsArray=null;
    	}
    	if(isMyApplications && isNullOrEmpty(enquiryModeIdsArray)){
    		var jsonObj = {
    				"userId":this.getCurrentlyLoggedInUser().id
    		}
    		submitUrl = SERVERURL.PATH_FIND_MY_APPLICATIONS_ID;
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : jsonObj,
    			method : 'POST',
    			async: false,
    			success : function(res, action) {
     				var data = Ext.decode(res.responseText);
     				if(whetherAll == true){
     					var jsonFormatFormData = $this.createJsonFormatForMyApplications(searchForm.getValues(),data);
     				}
     				else{
     					var jsonFormatFormData = $this.createJsonFormatForMyApplications(searchForm.getValues(),data);
     				}
     	        	var visibleColumns=$this.getVisibleColumns(searchResultGrid);
     	        	var reportTitle=getCommonTranslation("APPLICATION_LIST");
     	    		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
     	    			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
     	    		//searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit);
     	    		$this.exportApplicationGridWithFilters(searchResultGrid, exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit,searchForm);
     			}
    		});	
    	}else if(!isNullOrEmpty(enquiryModeIdsArray) && enquiryModeIdsArray.length > 0 && !isNullOrEmpty(enquiryModeIdsArray[0]) && isMyApplications){
    		var jsonFormatFormData;
    		
        	if(!isNullOrEmpty(enquiryModeIdsArray)){
        	    if(typeof enquiryModeIdsArray[0]!="object"){
        	        var enquiryModeIds = enquiryModeIdsArray;
        	        }else {
        	        var enquiryModeIdsTempArray = [];
        	        Ext.each(enquiryModeIdsArray,function(currentIds){
        	        	if(!isNullOrEmpty(currentIds)){
        	        		enquiryModeIdsTempArray.push(currentIds.data.id);
        	        	}
        	        });
        	        }
        	    }
        	
        	var applicationCode1 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPLICATION_ID)){
        		applicationCode1 = searchForm.down('#applicationID').getValue();
        	}
        	
        	var applicationCode2 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPICANT_PRINT_NAME)){
        		applicationCode2 = searchForm.down('#applicantName').getValue();
            }
    		
    		var applicationCode = "";
    		
    		if( applicationCode1 != null && applicationCode2 != null ){
    			if( applicationCode1 != applicationCode2 ){
        			applicationCode = -1;
        		}else {
        			applicationCode = applicationCode1;
        		}
    		} else {
    			if( applicationCode1 != null ){
    				applicationCode = applicationCode1;
    			}
    			if( applicationCode2 != null ){
    				applicationCode = applicationCode2;
    			}
    		}
     		var jsonAppDetail = [];
        	var jsonObj = {
    				"enquiryModeIds":enquiryModeIdsTempArray,
    				"applicationCode":applicationCode
    		}
        	if( applicationCode1 == null && applicationCode2 == null ){
        		delete jsonObj.applicationCode;
        	}
        	submitUrl = SERVERURL.PATH_APPLICATIONIDS_BYENQMODEIDS;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonObj,
     			method : 'POST',
     			success : function(res, action,applicationsIdFromMyApplications) {
     				var data = Ext.decode(res.responseText);
     				if(whetherAll == true){
     					var jsonFormatFormData = $this.createJsonForMyAppWithModeOfEnq(searchForm.getValues(),data);
     				}
     				else{
     					var jsonFormatFormData = $this.createJsonForMyAppWithModeOfEnq(searchForm.getValues(),data);
     				}
     	        	var visibleColumns=$this.getVisibleColumns(searchResultGrid);
     	        	var reportTitle=getCommonTranslation("APPLICATION_LIST");
     	    		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
     	    			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
     	    		//searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit);
     	    		$this.exportApplicationGridWithFilters(searchResultGrid, exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit,searchForm);
     			}
     		});	
     		//V2D-103414-----------enc
    	}else if (!isNullOrEmpty(enquiryModeIdsArray) && enquiryModeIdsArray.length > 0 && !isNullOrEmpty(enquiryModeIdsArray[0])){
        	if(!isNullOrEmpty(enquiryModeIdsArray)){
        	    if(typeof enquiryModeIdsArray[0]!="object"){
        	        var enquiryModeIds = enquiryModeIdsArray;
        	        }else {
        	        var enquiryModeIdsTempArray = [];
        	        Ext.each(enquiryModeIdsArray,function(currentIds){
        	        	enquiryModeIdsTempArray.push(currentIds.data.id);
        	        });
        	        }
        	    }
        	
        	var applicationCode1 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPLICATION_ID)){
        		applicationCode1 = searchForm.down('#applicationID').getValue();
        	}
        	
        	var applicationCode2 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPICANT_PRINT_NAME)){
        		applicationCode2 = searchForm.down('#applicantName').getValue();
            }
    		
    		var applicationCode = "";
    		
    		if( applicationCode1 != null && applicationCode2 != null ){
    			if( applicationCode1 != applicationCode2 ){
        			applicationCode = -1;
        		}else {
        			applicationCode = applicationCode1;
        		}
    		} else {
    			if( applicationCode1 != null ){
    				applicationCode = applicationCode1;
    			}
    			if( applicationCode2 != null ){
    				applicationCode = applicationCode2;
    			}
    		}
        	
        	var jsonAppDetail = [];
        	var jsonObj = {
    				"enquiryModeIds":enquiryModeIdsTempArray,
    				"applicationCode":applicationCode
    		}
        	
        	if( applicationCode1 == null && applicationCode2 == null ){
        		delete jsonObj.applicationCode;
        	}
        	
    		//jsonAppDetail.push(jsonObj);
        	submitUrl = SERVERURL.PATH_APPLICATIONIDS_BYENQMODEIDS;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonObj,
     			method : 'POST',
     			success : function(res, action) {
     				var data = Ext.decode(res.responseText);
     				if(whetherAll == true){
     	    			var jsonFormatFormData = $this.createJsonFormatWithEnqMode(searchForm.getValues(),data);
     	    		}
     	    		else{
     	    			var jsonFormatFormData = $this.createJsonFormatWithEnqMode(searchForm.getValues(),data);
     	    		}
     				//var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
     	        	var visibleColumns=$this.getVisibleColumns(searchResultGrid);
     	        	var reportTitle=getCommonTranslation("APPLICATION_LIST");
     	    		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
     	    			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
     	    		//searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit);
     	    		$this.exportApplicationGridWithFilters(searchResultGrid, exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit,searchForm);
     			}
     		});	
    	} else {
    		if(whetherAll == true){
    			var jsonFormatFormData=this.createJsonFormat(quickSearchForm.getValues());
    			var aloc = this.getUserAccessibleAL();
    			var accessibleAcademyLocations = new Array();
    	        if(jsonFormatFormData.ACAD_LOC_ID == "" || jsonFormatFormData.ACAD_LOC_ID == null){
    	        Ext.each(aloc, function(academyLocation){
    	        	accessibleAcademyLocations.push(academyLocation);
    	          });
    	       // jsonFormatFormData.searchCriterias.push({paramCode:'ACAD_LOC_ID', paramValues:accessibleAcademyLocations});
    	        }
    	        
    		}
    		else{
    			var jsonFormatFormData=this.createJsonFormat(quickSearchForm.getValues());
    		}
        	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        	var reportTitle=getCommonTranslation("APPLICATION_LIST");
    		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
    			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
    		$this.exportApplicationGridWithFilters(searchResultGrid, exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit,quickSearchForm);    		
    	}
	},
	convertKeyToValues:function(searchForm){
		 var formValues = new Array();
		 var stageStatusArray = ['INPROGRESS','NOT_APPLICABLE','NOTSTARTED','ENTRY_CRITERIA_PASSED','ENTRY_CRITERIA_FAILD','NEXT_STAGE_ENTRY_CRITERIA_PASSED','NEXT_STAGE_ENTRY_CRITERIA_FAILD',
			 'EXIT_CRITERIA_PASSED','EXIT_CRITERIA_FAILD','READY_TO_CLOSE','READY_TO_PROMOTED'];
		var admissionStatusArray = ['ADMISSION_IN_PROGRESS','ADMISSION_CONFIRMED','ADMITTED_ON_TRIAL_BASIS','ADMISSION_REJECTED','ADMITTED_PROVISIONALLY','WITHDRAW_AFTER_CONFIRMED','WITHDRAW_AFTER_ADMISSION',
			'WITHDRAW_AFTER_TRIAL','WITHDRAW_AFTER_PROVISION','PROVISIONAL_ADMISSION_REJECTED'];
	     var programStatusArray = ['OFFER_LETTER_ACCEPTED','OFFER_LETTER_ISSUED','OFFER_LETTER_REJECTED','OFFER_LETTER_DUE','PROVISIONAL_OFFER_REJECTED','PROVISIONAL_OFFER_ISSUED','PROVISIONAL_OFFER_DUE',
	    	 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER','PROVISIONAL_OFFER_EXPIRED','OFFER_EXPIRED','ESCALATED_OFFER_REVIEWED','WAITING_LIST','ADMITTED_ON_TRIAL','ADMITTED_ON_PROVISIONAL'];
		 formValues = searchForm.getValues();   
	     for (var key in formValues) {
	    	 var value = formValues[key];
	    	 if(!isNullOrEmpty(value) && key == "STAGE_STATUS" && stageStatusArray.indexOf(value) >= 0){
	    		 formValues[key] = searchForm.getForm().findField(key).getRawValue();
	    	 }
	    	 
	    	 if(!isNullOrEmpty(value) && key == "ADMISSION_STATUS" && admissionStatusArray.indexOf(value) >= 0){
	    		 formValues[key] = searchForm.getForm().findField(key).getRawValue();
	    	 }
	    	 
	    	 if(!isNullOrEmpty(value) && key == "PROGRAM_STATUS" && programStatusArray.indexOf(value) >= 0){
	 	    	formValues[key] = searchForm.getForm().findField(key).getRawValue();
	 	    }
	     }
	     return formValues;
	},
	createSearchCriteriaString: function(searchForm, isCommonExport) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        if(!isNullOrEmpty(isCommonExport) && isCommonExport==true) {
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' && key !== 'applicantModeOfEnquiry' && key !== 'showApplications'){
                var keyValueJsonObject = me.getJsonObject( key , value);
                if(keyValueJsonObject != undefined && searchForm.getForm().findField(key) != null){
                	searchCriteriaString=searchCriteriaString+getAdmissionTranslation(keyValueJsonObject.paramCode)+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
                }
                }
        }
        } else {
        	for (var key in formValues) {
            	var value = formValues[key];            
                if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' && key !== 'applicantModeOfEnquiry' && key !== 'showApplications' && key !== 'OFFER_EXPIRY_START_DATE' && key !== 'OFFER_EXPIRY_END_DATE'){
                    var keyValueJsonObject = me.getJsonObject( key , value);
                    if(keyValueJsonObject != undefined && searchForm.getForm().findField(key) != null){
                    	searchCriteriaString=searchCriteriaString+getAdmissionTranslation(keyValueJsonObject.paramCode)+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
                    }
                    }
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    
	 /*
     * This function is used for to load data in application list grid
     */
    loadGridAndSearchUsers: function(searchForm) {
    	var $this = this;
    	var ResultGrid = $this.getSearchResultGrid();
    	var documentReqBtn = ResultGrid.down('#documentRequest');
    	documentReqBtn.setDisabled(true);
    	//---------------------------------
    	var enquiryModeIdsArray = searchForm.down('#applicantModeOfEnquiryItemId').getValue();
    	var isMyApplications = searchForm.down('#myApplicationItemId').getValue();
    	
//Check Whether only my applications should be in the grid.
    	if(enquiryModeIdsArray!=undefined){
    		if(enquiryModeIdsArray[0]==""){
    			enquiryModeIdsArray=null;
    		}
    	}
    	if(enquiryModeIdsArray==undefined){
    		enquiryModeIdsArray=null;
    	}
    	searchForm.down('#applicationsListBasicSearchBtn').setDisabled(true);
    	//Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	if(isMyApplications && isNullOrEmpty(enquiryModeIdsArray)){
    		var jsonObj = {
    				"userId":this.getCurrentlyLoggedInUser().id
    		}
    		submitUrl = SERVERURL.PATH_FIND_MY_APPLICATIONS_ID;
    		Ext.Ajax.request({
    			type : 'rest',
    			url : submitUrl,
    			jsonData : jsonObj,
    			method : 'POST',
    			async: false,
    			success : function(res, action) {
    				var data = Ext.decode(res.responseText);
    				var jsonFormatFormData = $this.createJsonFormatForMyApplications(searchForm.getValues(),data);
    				var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    				var ResultGrid = $this.getSearchResultGrid();
    				resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.APPLICATION_LIST_VIEWCODE);
    				$this.loadApplicationGridWithFilters(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData);
    			}
    		});	
    	}else if(!isNullOrEmpty(enquiryModeIdsArray) && enquiryModeIdsArray.length > 0 && !isNullOrEmpty(enquiryModeIdsArray[0]) && isMyApplications){
    		
//check whether only my applications should be in the grid with the mode of enquiry
    		var jsonFormatFormData;
    		
        	if(!isNullOrEmpty(enquiryModeIdsArray)){
        	    if(typeof enquiryModeIdsArray[0]!="object"){
        	        var enquiryModeIds = enquiryModeIdsArray;
        	        }else {
        	        var enquiryModeIdsTempArray = [];
        	        Ext.each(enquiryModeIdsArray,function(currentIds){
        	        	if(!isNullOrEmpty(currentIds)){
        	        		enquiryModeIdsTempArray.push(currentIds.data.id);
        	        	}
        	        });
        	        }
        	    }
        	
        	var applicationCode1 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPLICATION_ID)){
        		applicationCode1 = searchForm.down('#applicationID').getValue();
        	}
        	
        	var applicationCode2 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPICANT_PRINT_NAME)){
        		applicationCode2 = searchForm.down('#applicantName').getValue();
            }
    		
    		var applicationCode = "";
    		
    		if( applicationCode1 != null && applicationCode2 != null ){
    			if( applicationCode1 != applicationCode2 ){
        			applicationCode = -1;
        		}else {
        			applicationCode = applicationCode1;
        		}
    		} else {
    			if( applicationCode1 != null ){
    				applicationCode = applicationCode1;
    			}
    			if( applicationCode2 != null ){
    				applicationCode = applicationCode2;
    			}
    		}
     		var jsonAppDetail = [];
        	var jsonObj = {
    				"enquiryModeIds":enquiryModeIdsTempArray,
    				"applicationCode":applicationCode
    		}
        	if( applicationCode1 == null && applicationCode2 == null ){
        		delete jsonObj.applicationCode;
        	}
        	submitUrl = SERVERURL.PATH_APPLICATIONIDS_BYENQMODEIDS;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonObj,
     			method : 'POST',
     			success : function(res, action,applicationsIdFromMyApplications) {
     				var data = Ext.decode(res.responseText);
     				jsonFormatFormData = $this.createJsonForMyAppWithModeOfEnq(searchForm.getValues(),data);
     		        var ResultGrid = $this.getSearchResultGrid();
     		        buttonsToolBar = ResultGrid.query('toolbar')[0];
     		    	var buttons = buttonsToolBar.query('button');
     		    	Ext.each(buttons, function(button) {
     		    		button.setDisabled(false);
     		    	});
     		    	documentReqBtn.setDisabled(true);
     		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
     		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.APPLICATION_LIST_VIEWCODE);
     		        $this.loadApplicationGridWithFilters(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData);
     			}
     		});	
    	}else if (!isNullOrEmpty(enquiryModeIdsArray) && enquiryModeIdsArray.length > 0 && !isNullOrEmpty(enquiryModeIdsArray[0])){
        	if(!isNullOrEmpty(enquiryModeIdsArray)){
        	    if(typeof enquiryModeIdsArray[0]!="object"){
        	        var enquiryModeIds = enquiryModeIdsArray;
        	        }else {
        	        var enquiryModeIdsTempArray = [];
        	        Ext.each(enquiryModeIdsArray,function(currentIds){
        	        	if(!isNullOrEmpty(currentIds)){
        	        		enquiryModeIdsTempArray.push(currentIds.data.id);
        	        	}
        	        });
        	        }
        	    }
        	
        	var applicationCode1 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPLICATION_ID)){
        		applicationCode1 = searchForm.down('#applicationID').getValue();
        	}
        	
        	var applicationCode2 = null;
        	if(!isNullOrEmpty(searchForm.getValues().APPICANT_PRINT_NAME)){
        		applicationCode2 = searchForm.down('#applicantName').getValue();
            }
    		
    		var applicationCode = "";
    		
    		if( applicationCode1 != null && applicationCode2 != null ){
    			if( applicationCode1 != applicationCode2 ){
        			applicationCode = -1;
        		}else {
        			applicationCode = applicationCode1;
        		}
    		} else {
    			if( applicationCode1 != null ){
    				applicationCode = applicationCode1;
    			}
    			if( applicationCode2 != null ){
    				applicationCode = applicationCode2;
    			}
    		}
        	
        	var jsonAppDetail = [];
        	var jsonObj = {
    				"enquiryModeIds":enquiryModeIdsTempArray,
    				"applicationCode":applicationCode
    		}
        	
        	if( applicationCode1 == jsonObj && applicationCode2 == null ){
        		delete jsonObj.applicationCode;
        	}
        	
    		//jsonAppDetail.push(jsonObj);
        	submitUrl = SERVERURL.PATH_APPLICATIONIDS_BYENQMODEIDS;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonObj,
     			method : 'POST',
     			success : function(res, action) {
     				var data = Ext.decode(res.responseText);
     				var jsonFormatFormData = $this.createJsonFormatWithEnqMode(searchForm.getValues(),data);
     		        var ResultGrid = $this.getSearchResultGrid();
     		        buttonsToolBar = ResultGrid.query('toolbar')[0];
     		    	var buttons = buttonsToolBar.query('button');
     		    	Ext.each(buttons, function(button) {
     		    		button.setDisabled(false);
     		    	});
     		    	documentReqBtn.setDisabled(true);
     		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
     		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.APPLICATION_LIST_VIEWCODE);
     		        $this.loadApplicationGridWithFilters(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData);
     			}
     		});
    	}else{
    		var jsonFormatFormData = $this.createJsonFormat(searchForm.getValues());
		        var ResultGrid = $this.getSearchResultGrid();
		        buttonsToolBar = ResultGrid.query('toolbar')[0];
		    	var buttons = buttonsToolBar.query('button');
		    	Ext.each(buttons, function(button) {
		    		button.setDisabled(false);
		    	});
		    	documentReqBtn.setDisabled(true);
		        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
		        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.APPLICATION_LIST_VIEWCODE);
		        $this.loadApplicationGridWithFilters(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData);
    	}
		if (!isNullOrEmpty(searchForm.down('#intakeYear').getValue())) {
			$this.getSearchResultGrid().down('#spBtnFetchNscDataItemId').setDisabled(false);
		} else {
			$this.getSearchResultGrid().down('#spBtnFetchNscDataItemId').setDisabled(true);
		}
		
    },
    
    createJsonFormatForPaymentPending: function(formValues, searchcriteria) {
    	var paymentPendingCheckBoxChecked = false;
    	var me=this;
    	
    	if( !isNullOrEmpty(formValues.applicationPaymentPending) && formValues.applicationPaymentPending ){
    		paymentPendingCheckBoxChecked = true;
    	}
    	
    	if( paymentPendingCheckBoxChecked ){
    		var paymentPendingStatusArr = ['SOLD','DIRECT_SUBMISSION_TOKEN_GENERATED','FORM_SALE_TOKEN_GENERATED'];
    		searchcriteria.push({paramCode:"PAYMENT_PENDING_ELIGIBILITY", paramValues:paymentPendingStatusArr});
    		delete formValues.APPLICATION_STATUS;
    	} else {
    		var paymentPendingStatusArr = ['SOLD','DIRECT_SUBMISSION_TOKEN_GENERATED','FORM_SALE_TOKEN_GENERATED'];
    		searchcriteria.push({paramCode:"PAYMENT_PENDING_ELIGIBILITY_NOT_IN", paramValues:paymentPendingStatusArr});
    	}
    	
    	delete formValues.applicationPaymentPending;
    },
    
    /*
     * This function is used for to create json for loading data in application list grid
     */
    createJsonFormat: function(formValues) {
    	var me=this;
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.APPLICATION_LIST_BASIC_CONFIGCODE;
        delete formValues.showApplications;
        delete formValues.OFFER_EXPIRY_START_DATE;
        delete formValues.OFFER_EXPIRY_END_DATE;
        
        if(!isNullOrEmpty(formValues.APPICANT_PRINT_NAME)){
        	var printName = formValues.APPICANT_PRINT_NAME;
        	formValues.APPICANT_PRINT_NAME=printName
        }
        if(!isNullOrEmpty(formValues.APPLICATION_ID)){
        	var id = formValues.APPLICATION_ID;
        	formValues.APPLICATION_ID=id
        }
        
        if(!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0]) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data) &&
        		!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data.id)) {
        	var departmentArray= [];
        	for(var i=0;i<formValues.PROGRAM_DEPARTMENT_ID.length;i++) {
        		departmentArray.push(formValues.PROGRAM_DEPARTMENT_ID[i].data.id);
        	}
        	var programDepartmentIds=departmentArray.join();
        	var keyValueJsonObject = me.getJsonObject( 'PROGRAM_DEPARTMENT_ID' , programDepartmentIds);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        } else{
        	delete formValues.PROGRAM_DEPARTMENT_ID;
        }
        
        me.createJsonFormatForPaymentPending(formValues,searchcriteria);
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key!='START_DATE' && key!='END_DATE' && key!='REGISTRATION_TYPE' && key != 'PROGRAM_DEPARTMENT_ID'&& key!='POPIA_STATUS'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        
        if(formValues.START_DATE){
             var keyValueJsonObject = me.getJsonObject( 'START_DATE' , formValues.START_DATE);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
    	 }
        
        if(formValues.END_DATE){
        	var keyValueJsonObject = me.getJsonObject( 'END_DATE' ,formValues.END_DATE);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(formValues.STAGE_FEE_STATUS != "" && formValues.STAGE_FEE_STATUS != null){
        	if(formValues.STAGE_FEE_STATUS=="SETTLED"){
        		searchcriteria.push({paramCode:'STAGE_FEE_STATUS_SETTLED', paramValues:["SETTLED"]});
        	}else{
        		if(formValues.STAGE_FEE_STATUS=="NOT_SETTLED"){
        			searchcriteria.push({paramCode:'STAGE_FEE_STATUS_NOT_SETTLED', paramValues:["SETTLED"]});
            	}
        	}
        	delete searchcriteria["STAGE_FEE_STATUS"];
    	}
        delete searchcriteria["REGISTRATION_TYPE"];	
        if(formValues.REGISTRATION_TYPE!= "" && formValues.REGISTRATION_TYPE != null){
        	var REGISTRATION_TYPE = null;
        	if(formValues.REGISTRATION_TYPE=="FULL_TIME"){
        		REGISTRATION_TYPE = false;
        		searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]}); 
        		
        	}
        	else
        	if(formValues.REGISTRATION_TYPE=="PART_TIME"){
        		REGISTRATION_TYPE = true;
        	searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]});     
        	}
        	
        }
        if(formValues.POPIA_STATUS != "" && formValues.POPIA_STATUS != null){
    		var popia=formValues.POPIA_STATUS=="Opt-In"?true:false;
    		searchcriteria.push({paramCode:"POPIA_STATUS", paramValues:[popia]});
    	}
    	
        if(!isNullOrEmpty(formValues.applicationOwner)){
        	var keyValueJsonObject = me.getJsonObject( 'APPLICATION_OWNER_ID' ,formValues.applicationOwner);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        
        var academyLocationIds =me.getUserAccessibleALForSendMessageAll();
        var ACCESSIBLE_AL_ID = me.getJsonObject( 'ACCESSIBLE_AL_ID' , academyLocationIds);
        me.pushJsonObjectInArray(ACCESSIBLE_AL_ID,searchcriteria);
        
        values.searchCriterias = searchcriteria;
        return values;
    },
    
    
    getUserAccessibleALForSendMessageAll:function(){
 	   var academyLocationId = [];
 	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
 	   for(var i=0; i<academyLocationList.length; i++){
 		   academyLocationId.push(academyLocationList[i].id);
 	   }
 	   return academyLocationId.join(',');
 },
    
    /*
     * This function is used for to create json for loading data in application list grid With enquiryMode
     */
    createJsonFormatWithEnqMode: function(formValues,data) {
    	var me=this;
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.APPLICATION_LIST_BASIC_CONFIGCODE;

        if(!isNullOrEmpty(formValues.APPICANT_PRINT_NAME)){
        	var printName = formValues.APPICANT_PRINT_NAME;
        	formValues.APPICANT_PRINT_NAME=printName
        }
        
        delete formValues.applicantModeOfEnquiry;
        delete formValues.showApplications;
        delete formValues.OFFER_EXPIRY_START_DATE;
        delete formValues.OFFER_EXPIRY_END_DATE;
        
        if(!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0]) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data) &&
        		!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data.id)) {
        	var departmentArray= [];
        	for(var i=0;i<formValues.PROGRAM_DEPARTMENT_ID.length;i++) {
        		departmentArray.push(formValues.PROGRAM_DEPARTMENT_ID[i].data.id);
        	}
        	var programDepartmentIds=departmentArray.join();
        	var keyValueJsonObject = me.getJsonObject( 'PROGRAM_DEPARTMENT_ID' , programDepartmentIds);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        } else{
        	delete formValues.PROGRAM_DEPARTMENT_ID;
        }
        
        me.createJsonFormatForPaymentPending(formValues,searchcriteria);
        
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value != 'APPLICATION_ID' && value !=='All' && key!='START_DATE' && key!='END_DATE'&& key!='REGISTRATION_TYPE' && key != 'PROGRAM_DEPARTMENT_ID'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        if(formValues.START_DATE){
             var keyValueJsonObject = me.getJsonObject( 'START_DATE' , formValues.START_DATE);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
    	 }
        
        if(formValues.END_DATE){
        	var keyValueJsonObject = me.getJsonObject( 'END_DATE' ,formValues.END_DATE);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(formValues.STAGE_FEE_STATUS != "" && formValues.STAGE_FEE_STATUS != null){
        	if(formValues.STAGE_FEE_STATUS=="SETTLED"){
        		searchcriteria.push({paramCode:'STAGE_FEE_STATUS_SETTLED', paramValues:["SETTLED"]});
        	}else{
        		if(formValues.STAGE_FEE_STATUS=="NOT_SETTLED"){
        			searchcriteria.push({paramCode:'STAGE_FEE_STATUS_NOT_SETTLED', paramValues:["SETTLED"]});
            	}
        	}
        	delete searchcriteria["STAGE_FEE_STATUS"];
    	}
        
        if(!isNullOrEmpty(formValues.applicationOwner)){
        	var keyValueJsonObject = me.getJsonObject( 'APPLICATION_OWNER_ID' ,formValues.applicationOwner);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        
        var applicationObj = {};
        applicationObj.paramCode = "APPLICATION_PRIMERY_ID";
        if( isNullOrEmpty(data) || data.length == 0 ){
        	data = [-1];
        }
        applicationObj.paramValues = data;
        
        searchcriteria.push(applicationObj);
        if(formValues.REGISTRATION_TYPE!= "" && formValues.REGISTRATION_TYPE != null){
        	var REGISTRATION_TYPE = null;
        	if(formValues.REGISTRATION_TYPE=="FULL_TIME"){
        		REGISTRATION_TYPE = false;
        		searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]}); 
        		
        	}
        	else
        	if(formValues.REGISTRATION_TYPE=="PART_TIME"){
        		REGISTRATION_TYPE = true;
        	searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]});     
        	}
        }
                
        values.searchCriterias = searchcriteria;
        return values;
    },
    /*
     * Create json for myApplicaitons only.
     * 
     */  
    createJsonFormatForMyApplications: function(formValues,data) {
    	var me=this;
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.APPLICATION_LIST_BASIC_CONFIGCODE;

        if(!isNullOrEmpty(formValues.APPICANT_PRINT_NAME)){
        	var printName = formValues.APPICANT_PRINT_NAME;
        	formValues.APPICANT_PRINT_NAME=printName
        }
        delete formValues.applicantModeOfEnquiry;
        delete formValues.showApplications;
        delete formValues.OFFER_EXPIRY_START_DATE;
        delete formValues.OFFER_EXPIRY_END_DATE;
        
        if(!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0]) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data) &&
        		!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data.id)) {
        	var departmentArray= [];
        	for(var i=0;i<formValues.PROGRAM_DEPARTMENT_ID.length;i++) {
        		departmentArray.push(formValues.PROGRAM_DEPARTMENT_ID[i].data.id);
        	}
        	var programDepartmentIds=departmentArray.join();
        	var keyValueJsonObject = me.getJsonObject( 'PROGRAM_DEPARTMENT_ID' , programDepartmentIds);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        } else{
        	delete formValues.PROGRAM_DEPARTMENT_ID;
        }
        
        me.createJsonFormatForPaymentPending(formValues,searchcriteria);
        
        if(isNullOrEmpty(formValues.applicationOwner)){
        	delete formValues.applicationOwner;
        }
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value != 'APPLICATION_ID' && value !=='All' && key!='START_DATE' && key!='END_DATE' && key!='REGISTRATION_TYPE' && key != 'PROGRAM_DEPARTMENT_ID'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        
        if(formValues.START_DATE){
             var keyValueJsonObject = me.getJsonObject( 'START_DATE' , formValues.START_DATE);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
    	 }
        
        if(formValues.END_DATE){
        	var keyValueJsonObject = me.getJsonObject( 'END_DATE' ,formValues.END_DATE);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(formValues.STAGE_FEE_STATUS != "" && formValues.STAGE_FEE_STATUS != null){
        	if(formValues.STAGE_FEE_STATUS=="SETTLED"){
        		searchcriteria.push({paramCode:'STAGE_FEE_STATUS_SETTLED', paramValues:["SETTLED"]});
        	}else{
        		if(formValues.STAGE_FEE_STATUS=="NOT_SETTLED"){
        			searchcriteria.push({paramCode:'STAGE_FEE_STATUS_NOT_SETTLED', paramValues:["SETTLED"]});
            	}
        	}
        	delete searchcriteria["STAGE_FEE_STATUS"];
    	}
        if(!isNullOrEmpty(formValues.applicationOwner)){
        	var keyValueJsonObject = me.getJsonObject( 'APPLICATION_OWNER_ID' ,formValues.applicationOwner);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(formValues.REGISTRATION_TYPE!= "" && formValues.REGISTRATION_TYPE != null){
        	var REGISTRATION_TYPE = null;
        	if(formValues.REGISTRATION_TYPE=="FULL_TIME"){
        		REGISTRATION_TYPE = false;
        		searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]}); 
        		
        	}
        	else
        	if(formValues.REGISTRATION_TYPE=="PART_TIME"){
        		REGISTRATION_TYPE = true;
        	searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]});     
        	}
        }
  
        delete formValues.applicantModeOfEnquiry;
        delete formValues.showApplications; 
        delete formValues.OFFER_EXPIRY_START_DATE;
        delete formValues.OFFER_EXPIRY_END_DATE;
        delete formValues.applicationOwner;
        var applicationObj = {};
        applicationObj.paramCode = "APPLICATION_PRIMERY_ID";
        if( isNullOrEmpty(data) || data.length == 0 ){
        	data = [-1];
        }
        applicationObj.paramValues = data;
        
        searchcriteria.push(applicationObj);
        values.searchCriterias = searchcriteria;
        return values;
    },
    /*
     * Create json for myApplicaitons with mode of enquiry.
     * 
     */  createJsonForMyAppWithModeOfEnq: function(formValues,data) {
    	var me=this;
        var values = new Object();
        var searchcriteria = new Array();
        var applicationsIdFromMyApplications = [];
    	applicationsIdFromMyApplications = this.getApplicationsIdFromMyApplications(data);
        values.configCode = CONSTANTS.CB.APPLICATION_LIST_BASIC_CONFIGCODE;

        if(!isNullOrEmpty(formValues.APPICANT_PRINT_NAME)){
        	var printName = formValues.APPICANT_PRINT_NAME;
        	formValues.APPICANT_PRINT_NAME=printName
        }
        delete formValues.showApplications;
        delete formValues.OFFER_EXPIRT_START_DATE;
        delete formValues.OFFER_EXPIRT_END_DATE;
        delete formValues.applicantModeOfEnquiry;
        
        if(!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0]) && !isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data) &&
        		!isNullOrEmpty(formValues.PROGRAM_DEPARTMENT_ID[0].data.id)) {
        	var departmentArray= [];
        	for(var i=0;i<formValues.PROGRAM_DEPARTMENT_ID.length;i++) {
        		departmentArray.push(formValues.PROGRAM_DEPARTMENT_ID[i].data.id);
        	}
        	var programDepartmentIds=departmentArray.join();
        	var keyValueJsonObject = me.getJsonObject( 'PROGRAM_DEPARTMENT_ID' , programDepartmentIds);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        } else{
        	delete formValues.PROGRAM_DEPARTMENT_ID;
        }
        
        me.createJsonFormatForPaymentPending(formValues,searchcriteria);
        
        if(isNullOrEmpty(formValues.applicationOwner)){
        	delete formValues.applicationOwner;
        }
        for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value != 'APPLICATION_ID' && value !=='All' && key!='START_DATE' && key!='END_DATE'&&  key!='REGISTRATION_TYPE' && key != 'PROGRAM_DEPARTMENT_ID'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }
        
        if(formValues.START_DATE){
             var keyValueJsonObject = me.getJsonObject( 'START_DATE' , formValues.START_DATE);
 	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
    	 }
        
        if(formValues.END_DATE){
        	var keyValueJsonObject = me.getJsonObject( 'END_DATE' ,formValues.END_DATE);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        if(formValues.STAGE_FEE_STATUS != "" && formValues.STAGE_FEE_STATUS != null){
        	if(formValues.STAGE_FEE_STATUS=="SETTLED"){
        		searchcriteria.push({paramCode:'STAGE_FEE_STATUS_SETTLED', paramValues:["SETTLED"]});
        	}else{
        		if(formValues.STAGE_FEE_STATUS=="NOT_SETTLED"){
        			searchcriteria.push({paramCode:'STAGE_FEE_STATUS_NOT_SETTLED', paramValues:["SETTLED"]});
            	}
        	}
        	delete searchcriteria["STAGE_FEE_STATUS"];
    	}
        if(!isNullOrEmpty(formValues.applicationOwner)){
        	var keyValueJsonObject = me.getJsonObject( 'APPLICATION_OWNER_ID' ,formValues.applicationOwner);
        	me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
        }
        
        var applicationObj = {};
        applicationObj.paramCode = "APPLICATION_PRIMERY_ID";
        if( isNullOrEmpty(applicationsIdFromMyApplications) || applicationsIdFromMyApplications.length == 0 ){
        	applicationsIdFromMyApplications = [-1];
        }
        applicationObj.paramValues = applicationsIdFromMyApplications;
        if(formValues.REGISTRATION_TYPE!= "" && formValues.REGISTRATION_TYPE != null){
        	var REGISTRATION_TYPE = null;
        	if(formValues.REGISTRATION_TYPE=="FULL_TIME"){
        		REGISTRATION_TYPE = false;
        		searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]}); 
        		
        	}
        	else
        	if(formValues.REGISTRATION_TYPE=="PART_TIME"){
        		REGISTRATION_TYPE = true;
        	searchcriteria.push({paramCode:"REGISTRATION_TYPE", paramValues:[REGISTRATION_TYPE]});     
        	}
        }
        
        searchcriteria.push(applicationObj);
        values.searchCriterias = searchcriteria;
        return values;
    },
    /*
     * This function is used for to create json object
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    /*
     * This function is used for to create json object in array
     */
    pushJsonObjectInArray: function(object, array) {
    	if(object!=null && object!="" && object.paramCode!='applicationOwner'){
    		if (object) {
    			array.push(object);
    		}
    	}
    },


	/*
     * This function is used for to adding toolbar and buttons on grid
     */
    gridRenderFunction: function(grid) {    	
        grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: ['->',{
                xtype: 'button',
                itemId: 'searchResultGridBtnAdd',
                tooltip: getCommonTranslation('ADD'),
                iconCls:'icon-addbutton',
				 cls:'addbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnEdit',
                tooltip: getCommonTranslation('EDIT'),
                iconCls:'icon-editbutton',
				cls:'editbutton'
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnView',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'icon-View',
				cls:'iconView'	
            }, {
                xtype: 'button',
                itemId: 'searchResultGridBtnDelete',
                cls: 'CustomToolbarBtnReject',
                //hidden:true,
                tooltip: getCommonTranslation('DELETE'),
                iconCls: 'icon-Delete',
				cls:'iconDelete'
            }, {
                xtype: 'customcombobox',
                //fieldLabel: getAdmissionTranslation('SELECT_ACTION'), //Select Action
                emptyText: 'Select',
                name: 'applicationListAction',
                itemId: 'applicationListAction',
                editable: false,
                disabled: true,
                width:250,
                 //Select Action
                store: 'admission.applications.applicationBase.ApplicationListActionComboStore',
                valueField: 'name',
                displayField: 'value',
                //value : 'All',
                queryMode: 'local'
            },/* {
                xtype: 'button',
                itemId: 'sendMessageBtn',
               // cls: 'CustomToolbarBtnReject',
                text:getCommonTranslation('SEND_MESSAGE'),
            	tooltip :getCommonTranslation('SEND_MESSAGE')
            }, {
                xtype: 'button',
                itemId: 'printProfileBtn',
                text:getCommonTranslation('PRINT_PROFILE'),
            	tooltip :getCommonTranslation('PRINT_PROFILE')
            },*/{
                xtype: 'button',
                itemId: 'makeAlumniBtn',
                text:getCommonTranslation('MAKE_ALUMNI'),
            	tooltip :getCommonTranslation('MAKE_ALUMNI')
            },{
			 	xtype : 'splitbutton',
		        itemId:'spBtnMoreActions',
		        text : getCommonTranslation('MOREACTIONS'),
		        menu:
		        	/*Start 24-4-25: Code for spread menu into two column: V2D:496504 */
		        	Ext.create('Ext.menu.Menu', { 
		        		layout: {
		        	        type: 'table',
		        	        columns: 2
		        	    },
		        	    defaults: {
		        	        xtype: 'menuitem'
		        	    },
		        	    items: [ 
		        	    	    {
		        	                itemId: 'sendMessageBtn',
		        	               // cls: 'CustomToolbarBtnReject',
		        	                text:getCommonTranslation('SEND_MESSAGE'),
		        	            	tooltip :getCommonTranslation('SEND_MESSAGE')
		        	            }, {
		        	                itemId: 'printProfileBtn',
		        	                text:getCommonTranslation('PRINT_PROFILE'),
		        	            	tooltip :getCommonTranslation('PRINT_PROFILE')
		        	            },{
		        	            	itemId: 'bulkDownloadDocId',
		        	            	// cls: 'CustomToolbarBtnReject',
		        	            	text:getCommonTranslation('BULK_DOWNLOAD_DOC'),
		        	            },
		        	    	{
		    	            	text : getCommonTranslation('SEND_SURVEY'),
		    	            	itemId:'sendSurveyBtn'
		    		        },{
		    	            	text : getTranslation('POPIA_OPTION'),
		    	            	 itemId:'popiaOptionBtn'
		    		        },{
		    					text:getCommonTranslation('RESET_PASSWORD'),
		    					itemId:'resetButtonItemId'
		    				},{
		    					text:getCommonTranslation('FROZEN'),
		    					itemId:'frozenItemId'
		    				},{
		    					text:getCommonTranslation('UN_FROZEN'),
		    					itemId:'unFrozenItemId'
		    				},{
		    					text:getCommonTranslation('PENDING_OFFER_FLAG'),
		    					itemId:'pendingOfferFlagItemId',
		    					disabled: true
		    				},{
		    					text:getAdmissionTranslation('PANDADOC'),
		    					itemId:'pandaDocItemId',
		    	    	        disabled: true
		    				},{
		    					text:getCommonTranslation('OFFER_LETTER_DETAILS'),
		    					itemId:'offerLetterDetailsItemId'
		    				},{
		    					text:getCommonTranslation('ADMISSION_APPROVAL_DETAILS'),
		    					itemId:'admissionApprovalDetailsItemId'
		    				},{
		    					text:getCommonTranslation('CALCULATE_EXAM_AGGREGATE'),
		    					itemId:'calculateExamAggregateItemId'
		    				},{
		    					text:getCommonTranslation('PRE_ELIGIBILITY_CHECK'),
		    					itemId:'preEligibilityItemId'
		    				},{
		    	            	text : getAdmissionTranslation('REASSIGN_APPLICATION'),
		    	            	itemId:'reassignApplicatioinItemId'
		    		        },{
		    		        	text : getCommonTranslation('MARK_APPLICATION_OFF_TRACK'),
		    	            	itemId:'markApplicationOffTrackItemId'
		    		        },{
		    	            	text : getAdmissionTranslation('REVIEW_APPLICATION'),
		    	            	itemId:'reviewApplicationItemId'
		    		        },{
		    		        	text : getAdmissionTranslation('CHECK_DUPLICATE_NATIONAL_ID'),
		    	            	itemId:'checkDuplicateNationalItemId'
		    		        },{
		    		        	text : getAdmissionTranslation('CHECK_DUPLICATE_EMAIL'),
		    	            	itemId:'checkDuplicateEmailItemId'
		    		        },{
		    		        	text : getCommonTranslation('RAISE_PRIORITY'),
		    	            	itemId:'raisePriorityItemId'
		    		        },{
		    		        	text : getCommonTranslation('REACTIVATE_APPLICATION'),
		    	            	itemId:'reactivateApplicationItemId'
		    		        },{
		    		        	text : getCommonTranslation('REQUEST_DOCUMENTS'),
		    	            	itemId:'documentRequest',
		    	            	tooltip :getCommonTranslation('REQUEST_DOCUMENTS'),
		    	    	        disabled: true
		    		        },{
		    		        	text:getCommonTranslation('SEND_MSG_TO_ALL'),
		    		        	itemId:'applicantSendMSGToAllBtn',
		    		        	tooltip :getCommonTranslation('SEND_MSG_TO_ALL')
		    		        },{
		    		        	text : getCommonTranslation('PRINT_OFFER_LETTER_WORDS'),
		    	            	itemId:'printOfferLetterWordsItemId'
		    		        },{
		    		        	text : getCommonTranslation('EXPIRE_OFFER_LETTER'),
		    	            	itemId:'expireOfferLetterItemId'
		    		        },{
		    		        	text : getCommonTranslation('APPLICATION_AND_ADMISSION_COMMENTS'),
		    	            	itemId:'applicationAndAdmissionCommentsItemId'
		    		        },{
		    		        	text : getCommonTranslation('REASSIGN_ESCALATION'),
		    	            	itemId:'reassignescalationitemid'
		    		        },
		    		        {
		    		    		text:getCommonTranslation('RAISE_SCHOLARSHIP_REQUEST'),
		    		    		itemId:'raiseScholarshipApplicantRequestId', 
		    		    		tooltip :getCommonTranslation('RAISE_SCHOLARSHIP_REQUEST'),
		    		    	}
		        	    ],
		        	}),		        	
		        	listeners: {click: function() {this.showMenu();}}
		        	/*End 24-4-25: Code for spread menu into two column: V2D:496504 */	
            }, {
			 	xtype : 'splitbutton',
		        itemId:'spBtnFetchNscDataItemId',
		        text : getCommonTranslation('ED_FETCH_NSC_DATA'),
				disabled: true,
		        menu:[{
	            	text : getCommonTranslation('ED_REFRESH_ALL'),
	            	itemId:'btnRefreshAllItemId'
		        },{
					text:getCommonTranslation('ED_ONLY_UNMATCHED_RECORDS'),
					itemId:'btnOnlyUnmatchedRecordsItemId'
				}],
		        listeners: {click: function() {this.showMenu();}}
            }, /*{
                xtype: 'button',
                itemId:'documentRequest',
    	        text : getCommonTranslation('REQUEST_DOCUMENTS'),
    	        tooltip :getCommonTranslation('REQUEST_DOCUMENTS'),
    	        disabled: true
            }*//*,{
            	xtype: 'button',
            	itemId: 'bulkDownloadDocId',
            	// cls: 'CustomToolbarBtnReject',
            	text:getCommonTranslation('BULK_DOWNLOAD_DOC'),
            }*/, {
		        xtype: 'button',
		        itemId: 'exportToPdfBtn',
		        text: getCommonTranslation('PRINT_EXPORT_BTN'),
		        //iconCls: 'export-combo-icon', // Optional icon
		        cls: 'print_export_btn_cls',
		        menu: [{
		            text: 'Export to PDF',
		            //itemId: 'btnExportToPDF',
		            menu: [{
						text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
						itemId: 'exportCurrentPagePdf'
					}, {
						text: getCommonTranslation('EXPORT_ALL_COMMON'), 
						itemId: 'exportPdfAll'
					}]
		        },{
		        	text: 'Export to Excel',
		            itemId: 'exportToPdfBtn',
		            menu: [{
						text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
						itemId: 'exportCurrentExcelPage'
					},{
						text: getCommonTranslation('EXPORT_ALL_COMMON'), 
						itemId: 'exportExcelAll'
					}]
		        }]
			}/*{
		        xtype: 'splitbutton',
		        itemId: 'exportToPdfBtn',
		        cls: 'CustomToolbarBtnExport export-cls',
		        iconCls:'export-pdf-icon',
		        //text: 'Export To Pdf',      
		        menu: [{
		            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
		            itemId: 'exportCurrentPagePdf'
		        }, {
		            text: getCommonTranslation('EXPORT_ALL_COMMON'),
		            itemId: 'exportPdfAll'
		        } ]
		    },{
		        xtype: 'splitbutton',
		        itemId: 'exportToPdfBtn',
		        cls: 'CustomToolbarBtnExport export-cls',
		        iconCls:'export-excel-icon',
		        //text: 'Export To Xcel',      
		        menu: [{
		            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'),
		            itemId: 'exportCurrentExcelPage'
		        }, {
		            text: getCommonTranslation('EXPORT_ALL_COMMON'),
		            itemId: 'exportExcelAll'
		        } ]
		    }*/]
        });
    },

	/*
     * This function is used for to display new admission window
     */
    showAddAdmissionWindow: function() {
        var window = this.getAddAdmissionWindow();
        if (!window) {
            window = Ext.widget('addadmissionwindow', {
                itemId: 'addAdmissionWindow'
            });
        }
        window.show();
        var applicantType = window.down('#cmbApplicationType');
        var applicantTypeStore=applicantType.getStore();
           	for(var i=0; i< applicantTypeStore.data.items.length;i++){
           		if(applicantTypeStore.data.items[i].data.name == 'EXISTING_STUDENT'){
           			applicantTypeStore.removeAt(i);
           		} 
           	}
    },

    /**
     * method to show and hide search fields on the basis of search criteria.				     
     *      
     */
    showHideSearchCriteriaFields: function(selectedApplicationType, applicantSearchForm) {
        if (applicantSearchForm) {
            var searchComponent = applicantSearchForm.down("#searchComponent");

            Ext.each(searchComponent.items.items, function(Component) {
                if (selectedApplicationType === 'FRESH_APPLICANT') {
                    searchComponent.down('#searchCriteriaPanel').setVisible(false);
                } else {
                    searchComponent.down('#searchCriteriaPanel').setVisible(true);
                    if (Component.itemId === 'searchCriteriaPanel') {
                        Ext.each(Component.items.items, function(childComponent) {
                            if (selectedApplicationType === 'ENQUIRED_EARLIER' && (childComponent.itemId === 'enqId' || childComponent.itemId === 'enqName' || childComponent.itemId === 'enqContactNo' || childComponent.itemId === 'enqEmailId')) {
                                childComponent.setVisible(true);
                            } else if (selectedApplicationType === 'APPLIED_EARLIER' && (childComponent.itemId === 'appId' || childComponent.itemId === 'appEmailId' ||
                            		childComponent.itemId === 'idTypeCombo' || childComponent.itemId === 'nationalId')) {
                                childComponent.setVisible(true);
                            } else if (selectedApplicationType === 'EXISTING_STUDENT' && childComponent.itemId === 'studentId') {
                                childComponent.setVisible(true);
                            } else {
                                if (childComponent.itemId !== 'searchBtn') {
                                    childComponent.setVisible(false);
                                }
                            }
                        });
                    }
                }
            });
        }
    },

    /**
     * This function is used for to search result after clicking on search button in Applicant Form.
     *    
     */
    onSearchButtonClick: function(me, searchWindow, applicantForm, itemIdValue) {
    	var addAdmissionWindow=this.getAddAdmissionWindow();
    	var searchResult = me.mixins.AdmissionFormCommonController.getSearchResult(me, applicantForm);
        //var searchResult = me.getSearchResult(me, applicantForm);
        if (isEmpty(searchResult)) {
            searchWindow.down('#searchGrid').setVisible(false);
            var proceedBtn = addAdmissionWindow.down('#proceedBtn');
        	if(proceedBtn){
        		proceedBtn.setDisabled(true);
        	}
        	showWarningMessage(getCommonTranslation('SUCCESS'), getAdmissionTranslation('SEARCH_RESULT_MSG')); //No search result found
        } else {
            searchWindow.down('#searchGrid').setVisible(true);
            me.mixins.AdmissionFormCommonController.loadDataInSearchWindow(me, searchResult, applicantForm, searchWindow);
        	/*var proceedBtn = addAdmissionWindow.down('#proceedBtn');
        	if(proceedBtn){
        		proceedBtn.setDisabled(false);
        	} */    
            //me.loadDataInSearchWindow(me, searchResult, applicantForm, searchWindow);
        }
    },
   
    
    /**
     * This function is used for to show applicant profile in edit or view mode 
     *     
     */
    editViewApplication: function(isView) {
    	var me = this;
    	var searchResultGrid = this.getSearchResultGrid();
        if (searchResultGrid.getSelectionModel().getCount() > 0) {            
            var record = searchResultGrid.getSelectionModel().getSelection()[0];
            var applicationId=record.get('APPLICATION_PRIMERY_ID');
            if(!isNullOrEmpty(applicationId)){
            	me.openApplicantProfile(applicationId, isView,searchResultGrid);
            }                                
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }     
    },
    
    
    /**
     * This function is used for to open applicant profile with parameters required for applicant profile 
     *   
     *     
     */
    openApplicantProfile:function(applicationId,isView,searchResultGrid,requestType,FromStaffTargetAppData){
    	var me=this;
    	//var searchResultGrid = this.getSearchResultGrid();   
    	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    	if(searchResultGrid){
    		var store=searchResultGrid.getStore();
    		var recordIndex = null;
    		if(requestType == null || requestType == '' || requestType == undefined){
    		 recordIndex=store.find('APPLICATION_PRIMERY_ID', applicationId);
    		}
    		if(requestType == 'REPLACE_TO_APPLICATION_ID'){
    			 recordIndex=store.find('replacedToBePrimaryId', applicationId);
    		}
    		if(requestType == 'REPLACE_BY_APPLICATION_ID'){
    			 recordIndex=store.find('replacedByPrimaryId', applicationId);
    		}
    		if(FromStaffTargetAppData){
    			recordIndex=0;	
    		}
    		var tabTitle = null;
    		var personId = null;
    		var applicationId = null;
    		var admissionId = null;
    		var applicantStagePersonId = null;
    		if(recordIndex!=-1){
    			if(FromStaffTargetAppData){
    				var record = FromStaffTargetAppData;	
    			}else{
    				var record = store.getAt(recordIndex);
    			}
    			//var record = store.getAt(recordIndex);
    			if(isNullOrEmpty(requestType)){
        			tabTitle = record.get('APPLICATION_ID');
        	        personId = record.get('PERSON_ID');
        	        applicationId = record.get('APPLICATION_PRIMERY_ID');
        	        admissionId = record.get('ADMISSION_PRIMERY_ID');
        	        applicantStagePersonId = record.get('APPLICATION_PERSON_ID');
    			}
    			if(requestType == 'REPLACE_TO_APPLICATION_ID'){
    				tabTitle = record.get('replacedToBeAppId');
        	        personId = record.get('replacedToBeAppPersonPrimaryId');
        	        applicationId = record.get('replacedToBePrimaryId');
    			}
    			if(requestType == 'REPLACE_BY_APPLICATION_ID'){
    				tabTitle = record.get('replacedByAppId');
        	        personId = record.get('replacedByAppPersonPrimaryId');
        	        applicationId = record.get('replacedByPrimaryId');
    			}
    	        var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
        		if(applicantProfile){
        			me.getContentPanel().setActiveTab(applicantProfile);   
        			var personalInfoSubmitBtn=applicantProfile.down('#personalInfoSaveButtonId');
					if(isView){
						personalInfoSubmitBtn.setVisible(false);
						//V2D-47886 below function is not defined.So comment out the code
						//me.actionButtonPanelHideShow(applicantProfile,false);
						var activePanel = me.getContentPanel().getActiveTab();
						var profile_image_icon_id = activePanel.down('#profile_image_icon_id')
                        profile_image_icon_id.setVisible(false);
						
					}else{
						personalInfoSubmitBtn.setVisible(true);
						var personInfoPanel=applicantProfile.down("#personInfoPanel");
						var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
						var countryCodeField = applicantPersonalDetails.down("#cellCountryCode");
        				var mobileField = applicantPersonalDetails.down("#mobileNumber");
        				this.setMaximumMinimumDigitsForMobileNoValidation(applicantPersonalDetails,countryCodeField,mobileField,null);
        				var countryCodeField = applicantPersonalDetails.down("#alternateCellCountryCode");
	                 	var mobileField = applicantPersonalDetails.down("#alternateMobileNumber");
	                 	this.setMaximumMinimumDigitsForMobileNoValidation(applicantPersonalDetails,countryCodeField,mobileField,null);
						//V2D-47886 below function is not defined.So comment out the code
						//me.actionButtonPanelHideShow(applicantProfile,true);
					}
					setTimeout(function(){
						Ext.getBody().unmask();
					   },1000);
        		}else{
        			me.addContentPanelTab(tabTitle, 'applicantprofile', null, personId,applicationId,admissionId);
        	        var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
        	        if (applicantProfile) {  
        	        	if(record.get('APPLICATION_STATUS') == 'SOLD' || record.get('APPLICATION_STATUS') == 'FORM_SALE_TOKEN_GENERATED' || record.get('APPLICATION_STATUS') == 'DIRECT_SUBMISSION_TOKEN_GENERATED'){
        	        		var applicantProfileItems = applicantProfile.down('actionbuttonpanel').items.items;
        	        		if(applicantProfileItems != undefined && applicantProfileItems.length > 0){
        	        			applicantProfileItems.forEach(function(buttons) {
        	        				if(buttons.itemId != 'printBtn' && buttons.itemId != 'withdrawApplicationBtn' ){
        	        					buttons.hide();
        	        				}
        	        				if(buttons.itemId != 'withdrawApplicationBtn'){
        	        					buttons.setDisabled(false);
        	        				}
        	        			});
        	        		}
        	        	}
        	        	me.setParameterForApplicantProfile(applicantProfile,record,'',isView);
        	        	me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
        				me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
        	        	var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
        	        	var applicantPortalController  = me.getController('Academia.controller.portal.ApplicantPortalController');
        	        	//commenting bacause permission code is already written in addContentPanelTab
        	        	//applicantPortalController.loadPanellinkForApplicant(applicantProfile, applicantLinkPanelObject);
        	        	me.gettingDataInSummaryGrid(applicantProfile);    
        	        	//me.getApplicantProfileInformation(applicantProfile);
        				if(!isEmpty(applicantLinkPanelObject)){
        					
        					var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
        					me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);
        					
        					var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
        					me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);
        					
        					var personInfoPanel=applicantProfile.down("#personInfoPanel");
        					if(personInfoPanel){
        						var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
        						if(personInfoPanel){
        							var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
        							if(applicantPersonalDetails){
        								personInfoPanel.setActiveTab(applicantPersonalDetails);
        								var personalInfoSubmitBtn=applicantPersonalDetails.down('#personalInfoSaveButtonId');        								

        								if(isView){
        									personalInfoSubmitBtn.setVisible(false);
        									//V2D-47886 below function is not defined.So comment out the code
        									//me.actionButtonPanelHideShow(applicantProfile,false);
        									var activePanel = me.getContentPanel().getActiveTab();
        									var profile_image_icon_id = activePanel.down('#profile_image_icon_id')
        									//var profile_image_icon_id = this.getApplicantprofile().down('#profile_image_icon_id')
        									profile_image_icon_id.setVisible(false);
        								}else{
        									personalInfoSubmitBtn.setVisible(true);
        									var countryCodeField = applicantPersonalDetails.down("#cellCountryCode");
        				                 	var mobileField = applicantPersonalDetails.down("#mobileNumber");
        				                 	this.setMaximumMinimumDigitsForMobileNoValidation(applicantPersonalDetails,countryCodeField,mobileField,null);
        				                 	var countryCodeField = applicantPersonalDetails.down("#alternateCellCountryCode");
        				                 	var mobileField = applicantPersonalDetails.down("#alternateMobileNumber");
        				                 	this.setMaximumMinimumDigitsForMobileNoValidation(applicantPersonalDetails,countryCodeField,mobileField,null);
        									//V2D-47886 below function is not defined.So comment out the code
        									//me.actionButtonPanelHideShow(applicantProfile,true);
        								}
        							}
        							setTimeout(function(){
    									var  otherDetailsSection= personInfoPanel.down("#otherDetailsApplicantFieldSet");
                						if(!isNullOrEmpty(otherDetailsSection)){
                							otherDetailsSection.expand();
                							otherDetailsSection.collapse();
                						}
    								  },400);
        						}        		
        					}
		
        				}
 
     }
        		}  
}
}                	
    }, 
    
    loadApplications: function(applicationId) {
    	var me=this;
    	var applicationsTab=me.getTabReferenceByTabTitle(getMegaMenuTranslation('ADM_SELECTIONPROCESS_APPLICATIONS'));
    	if(applicationsTab){
    		var basicSearchForm=applicationsTab.down('#basicSearchPanel');
    		var ResultGrid = applicationsTab.down('#applicationsListGrid');
    		if(basicSearchForm && ResultGrid){
    			//basicSearchForm.getForm().reset();    	
            	var jsonFormatFormData = me.createJsonFormat(basicSearchForm.getValues());                
                var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
                resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.APPLICATION_LIST_VIEWCODE);
                me.loadApplicationGridWithFilters(basicSearchForm, ResultGrid, resultViewUrl, jsonFormatFormData);
    		}        	
    	}    	        
    },
    
    
    /**
     * This function is used for to SET parameters required for applicant profile 
     *   
     *     
     */
    setParameterForApplicantProfile:function(applicantProfile,record,admissionType,isView){
    	var me=this;
    	var applicationInfoObject=me.getApplicationInfoObject(record,admissionType,isView,applicantProfile);
    	if(!isEmpty(applicationInfoObject)){
    		applicantProfile.setApplicationInfo(applicationInfoObject);            		
    	}
    },
    
    
    /**
     * This function is used for to GET applicant profile information
     * 
     *     
     */
    getApplicantProfileInformation: function(applicantProfile) {    	  
    	var me=this;
        var applicantProfileView = applicantProfile.down('#applicantProfileTemplate');
        //applicantProfileView.refresh();
        var applicationId = applicantProfile.getApplicationId();
        if (!isNullOrEmpty(applicationId)) {
            var url = SERVERURL.APPLICATIONS_GET_APPLICANT_SUMMARY;
            if(!isNullOrEmpty(url)){
            	url = url.concat("?id=" + applicationId);
                Ext.Ajax.request({
                    type: 'rest',
                    url: url,
                    method: 'GET',
                    success: function(res, action) {
                    	if(portalId==6)
                    	{
                    		if(Ext.ComponentQuery.query('dashboardhomepage').length!=0){
                    			var dashboard = Ext.ComponentQuery.query('dashboardhomepage')[0].close();
                    		}
                    		if(Ext.ComponentQuery.query('userinfo').length!=0){
                    			var dashBoardMenu = Ext.ComponentQuery.query('userinfo')[0];
                    			dashBoardMenu.down("#myDashboard").setVisible(false);
                    		}

                    	}
                        var data = Ext.decode(res.responseText);
                        if(!isNullOrEmpty(data) && !isNullOrEmpty(data.currentStatus)){
                        	data.currentStatus = getAdmissionTranslation(data.currentStatus);
                        }
                        var tpl = applicantProfileView.tpl;
                        if(Ext.isDefined(applicantProfileView.el)){
                        	tpl.overwrite(applicantProfileView.el.dom, data);
                        }
                        if(portalId==6)
                    	{
                        	if(!isNullOrEmpty(applicantProfileView.up().down('form'))){
                        		applicantProfileView.up().down('form').getForm().setValues(data);
                            	var formFields = applicantProfileView.up().down('form').getForm().getFields().items;
                            	Ext.each(formFields, function(currentField)
                        		{
                            		if(isNullOrEmpty(currentField.getValue()))
                        			{
                            			currentField.hide();
                        			}
                            		else
                        			{
                            			currentField.show();
                        			}
                        		});
                        	}
                    	}
                    }
                });
            }          	
         }                    
    },
    
    /**
     * This function is used for to GET Application Information Object
     *   
     *     
     */
    getApplicationInfoObject:function(record,admissionType,isViewMode,applicantProfile) {
    	var me=this;
    	var applicationObject=new Object();
    	
    	/*applicationObject.applicationID=(!isEmpty(record) && !isNullOrEmpty(record.get('APPLICATION_PRIMERY_ID')))?record.get('APPLICATION_PRIMERY_ID'):'';
    	applicationObject.admissionID=(!isEmpty(record) && !isNullOrEmpty(record.get('ADMISSION_PRIMERY_ID')))?record.get('ADMISSION_PRIMERY_ID'):'';
    	applicationObject.applicationStatus=(!isEmpty(record) && !isNullOrEmpty(record.get('APPLICATION_STATUS')))?record.get('APPLICATION_STATUS'):'';
    	applicationObject.admissionStatus=(!isEmpty(record) && !isNullOrEmpty(record.get('ADMISSION_STATUS')))?record.get('ADMISSION_STATUS'):'';
    	applicationObject.programStatus=(!isEmpty(record) && !isNullOrEmpty(record.get('PROGRAM_STATUS')))?record.get('PROGRAM_STATUS'):'';
    	applicationObject.stageStatus=(!isEmpty(record) && !isNullOrEmpty(record.get('CURRENT_STAGE')))?record.get('CURRENT_STAGE'):'';*/
		
		var data = (record && record.data) ? record.data : {};

		applicationObject.applicationID      = (!isNullOrEmpty(data.APPLICATION_PRIMERY_ID)) ? data.APPLICATION_PRIMERY_ID : '';
		applicationObject.admissionID        = (!isNullOrEmpty(data.ADMISSION_PRIMERY_ID)) ? data.ADMISSION_PRIMERY_ID : '';
		applicationObject.applicationStatus  = (!isNullOrEmpty(data.APPLICATION_STATUS)) ? data.APPLICATION_STATUS : '';
		applicationObject.admissionStatus    = (!isNullOrEmpty(data.ADMISSION_STATUS)) ? data.ADMISSION_STATUS : '';
		applicationObject.programStatus      = (!isNullOrEmpty(data.PROGRAM_STATUS)) ? data.PROGRAM_STATUS : '';
		applicationObject.stageStatus        = (!isNullOrEmpty(data.CURRENT_STAGE)) ? data.CURRENT_STAGE : '';

		
    	applicationObject=me.getAdmissionStatus(applicationObject, admissionType,applicantProfile); 
    	    	
    	if(isNullOrEmpty(isViewMode)){
    		applicationObject.isEditMode=false;
        	applicationObject.isViewMode=false;
    	}else{
    		if(isViewMode===true){
    			applicationObject.isEditMode=false;
            	applicationObject.isViewMode=true;
    		}else if(isViewMode===false){
    			applicationObject.isEditMode=true;
            	applicationObject.isViewMode=false;
    		}
    	}    	
        return applicationObject;
    },
    
    getAdmissionStatus:function(applicationObject,admissionType,applicantProfile){
    	if(isNullOrEmpty(admissionType)){
    		applicationObject.isDirectAdmission=false;
    		applicationObject.isMidTermAdmission=false;
    		applicationObject.isNewApplication=false;
    		applicationObject.isFormSoldApplication=false;    		
    	}else{
    		if(admissionType===this.DIRECT_ADMISSION){
    			applicationObject.applicationStatus='DIRECT_ADMISSION';
    			applicationObject.isDirectAdmission=true;
        		applicationObject.isMidTermAdmission=false;
        		applicationObject.isNewApplication=false;
        		applicationObject.isFormSoldApplication=false;
    		}else if(admissionType===this.MID_TERM_ADMISSION){
    			applicationObject.applicationStatus='MID_TERM_ADMISSION';    			
    			applicationObject.isDirectAdmission=false;
        		applicationObject.isMidTermAdmission=true;
        		applicationObject.isNewApplication=false;
        		applicationObject.isFormSoldApplication=false;
    		}else if(admissionType===this.NEW_APPLICATION){
    			applicationObject.applicationStatus='SUBMITTED';   
    			applicationObject.isDirectAdmission=false;
        		applicationObject.isMidTermAdmission=false;
        		applicationObject.isNewApplication=true;
        		applicationObject.isFormSoldApplication=false;
    		}else if(admissionType===this.FORM_SOLD_APPLICATION){
    			applicationObject.applicationStatus='SUBMITTED';   
    			applicationObject.isDirectAdmission=false;
        		applicationObject.isMidTermAdmission=false;
        		applicationObject.isNewApplication=false;
        		applicationObject.isFormSoldApplication=true;
    		}    		
    	}    
    	return applicationObject;
    },
    
    /**
     * This function is used for to GET Data In Summary Grid
     *   
     *     
     */
    gettingDataInSummaryGrid: function(applicantProfile) {
    	var me=this;
    	var portalId = this.getCurrentLoggedPortalId();
    	if(portalId==6){
    		applicantProfile = me.getContentPanel().items.items[0];
    		applicantProfile.down('#applicantExpandContainerItemId').setVisible(false);
    	}
    	if (applicantProfile) {
    		var grid=applicantProfile.down('#selectionSnapShotGrid');
    		if(portalId==6)
			{
    			var browser = me.getBrowsers();
    			if (browser.isChrome || browser.isFirefox ||browser.isSafari ){
    				var grid=Ext.ComponentQuery.query('selectionsnapshotgrid')[1];	
    			}
    			else{
    				setTimeout(function(){
    					var grid=Ext.ComponentQuery.query('selectionsnapshotgrid')[1];
    					if(grid){
    		    			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    		    				var associatedAcadLocationIds = new Array();
    		    				associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    		    				var applicantOfferLetterPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getAPPLICANT_OFFER_LETTER_PERMISSIONS());

    		    				var acceptOffer = false;
    		    				var declineOffer = false;

    		    				Ext.each(applicantOfferLetterPermissionList, function(privilege) {
    		    					if (privilege === 'ACCEPT_OFFER') {
    		    						acceptOffer = true;
    		    					}
    		    					if (privilege === 'DECLINE_OFFER') {
    		    						declineOffer = true;
    		    					}
    		    				});
    		    				
    		    				if (acceptOffer && declineOffer && portalId==6) {
    		    					grid.down("#btnAcceptOfferItemId").setVisible(false);
    		        				grid.down("#btnDeclineOfferItemId").setVisible(false);        				
    		    				}
    		    				
    		        			var paramObject = {
    		        				applicationID: applicantProfile.getApplicationId()
    		                    };
    		        			var storeConfig = grid.getStore();
    		        			storeConfig.config.paramObject = applicantProfile.getApplicationId();
								me.getApplicantProfileInformation(applicantProfile);

    		        			/*storeConfig.load({
    		                    	params:paramObject
    		                    	,callback: function(records, operation, success) {
    		                    		me.getApplicantProfileInformation(applicantProfile);
    		                    		
    		                    		if (acceptOffer && declineOffer) {
    		                    			var btnAcceptOfferItemId = grid.down("#btnAcceptOfferItemId");
    		                				var btnDeclineOfferItemId = grid.down("#btnDeclineOfferItemId");
    		                				
    		                    			if (portalId == 6) {
    		                    				var flag = false;
    		                    				var acceptButton = false;
    		                    				var provisionalColumn = false;
    		                    				for (i in records) {
    		                    					var record = records[i];
    		                    					if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) &&
    		                    							(record.data.currentStatus == 'OFFER_LETTER_ISSUED' || record.data.currentStatus == 'PROVISIONAL_OFFER_ISSUED')) {
    		                    						flag = true;
    		                    						if(record.data.provisionalOfferLetter==true) {
    		                    							provisionalColumn = true;
    		                    						}
    		                    						if(i==0) {
    		                    							provisionalColumn = true;
    		                    						}
    		                    						//break;
    		                    					}
    		                    					else if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) && (record.data.provisionalOfferLetter==true))  {
    		                    						provisionalColumn = true;
    		                    					}
    		                    				}
    		                    				if (flag) {
    		                    					btnAcceptOfferItemId.setVisible(true);
    		                    					btnDeclineOfferItemId.setVisible(true);
    		                    				} else {
    		                    					btnAcceptOfferItemId.setVisible(false);
    		                    					btnDeclineOfferItemId.setVisible(false);
    		                    				}
    		                    				if (acceptButton) {
        		                    				btnAcceptOfferItemId.setDisabled(false);
        		                    				btnDeclineOfferItemId.setDisabled(false);
        		                    			} else {
        		                    				btnAcceptOfferItemId.setDisabled(true);
        		                    				btnDeclineOfferItemId.setDisabled(true);
        		                    			} 
    		                    				if(grid.getStore().data.length>0){
	    		                    				grid.getSelectionModel().deselectAll();
	  		                    		          	grid.getSelectionModel().select(0);
    		                    				}
    		                    				var gridColumns = grid.columnManager.getColumns();
    		                    		        Ext.each(gridColumns, function(column) {
    		                    		            if (column.dataIndex == 'provisionalOfferLetterIssuedFileName') {
    		                    		            	column.setVisible(provisionalColumn);
    		                 		                }
    		                  		            });
    		                    			} else {
    		                					btnAcceptOfferItemId.setVisible(false);
    		                					btnDeclineOfferItemId.setVisible(false);
    		                				}
    		                    		}
    		                        }
    		                    });*/               		                             
    		    			}
    		    		}
    				},1000);
    			}
			}
    		if(grid){
    			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    				var associatedAcadLocationIds = new Array();
    				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    				var applicantOfferLetterPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICANT_OFFER_LETTER_PERMISSIONS());

    				var acceptOffer = false;
    				var declineOffer = false;

    				Ext.each(applicantOfferLetterPermissionList, function(privilege) {
    					if (privilege === 'ACCEPT_OFFER') {
    						acceptOffer = true;
    					}
    					if (privilege === 'DECLINE_OFFER') {
    						declineOffer = true;
    					}
    				});
    				
    				if (acceptOffer && declineOffer && portalId==6) {
    					grid.down("#btnAcceptOfferItemId").setVisible(false);
        				grid.down("#btnDeclineOfferItemId").setVisible(false);        				
    				}
    				
        			var paramObject = {
        				applicationID: applicantProfile.getApplicationId()
                    };
        			var storeConfig = grid.getStore();
        			storeConfig.config.paramObject = applicantProfile.getApplicationId();
					me.getApplicantProfileInformation(applicantProfile);

        			/*storeConfig.load({
                    	params:paramObject
                    	,callback: function(records, operation, success) {
                    		me.getApplicantProfileInformation(applicantProfile);
                    		
                    		if (acceptOffer && declineOffer) {
                    			var btnAcceptOfferItemId = grid.down("#btnAcceptOfferItemId");
                				var btnDeclineOfferItemId = grid.down("#btnDeclineOfferItemId");
                				
                    			if (portalId == 6) {
                    				var flag = false;
                    				var acceptButton = false;
                    				var provisionalColumn = false;
                    				for (i in records) {
                    					var record = records[i];
                    					if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) &&
                    							(record.data.currentStatus == 'OFFER_LETTER_ISSUED' || record.data.currentStatus == 'PROVISIONAL_OFFER_ISSUED')) {
                    						flag = true;
                    						if(record.data.provisionalOfferLetter==true) {
                    							provisionalColumn = true;
                    						}
                    						if(i==0) {
                    							acceptButton = true;
                    						}
                    						//break;
                    					}
                    					else if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) && (record.data.provisionalOfferLetter==true))  {
                    						provisionalColumn = true;
                    					}
                    				}
                    				if (flag) {
                    					btnAcceptOfferItemId.setVisible(true);
                    					btnDeclineOfferItemId.setVisible(true);
                    				} else {
                    					btnAcceptOfferItemId.setVisible(false);
                    					btnDeclineOfferItemId.setVisible(false);
                    				}
                    				if (acceptButton) {
	                    				btnAcceptOfferItemId.setDisabled(false);
	                    				btnDeclineOfferItemId.setDisabled(false);
	                    			} else {
	                    				btnAcceptOfferItemId.setDisabled(true);
	                    				btnDeclineOfferItemId.setDisabled(true);
	                    			} 
                    				if(grid.getStore().data.length>0){
	                    				grid.getSelectionModel().deselectAll();
	                    		        grid.getSelectionModel().select(0);
                    				}
                    				var gridColumns = grid.columnManager.getColumns();
                    		        Ext.each(gridColumns, function(column) {
                    		            if (column.dataIndex == 'provisionalOfferLetterIssuedFileName') {
                    		            	column.setVisible(provisionalColumn);
                 		                }
                  		            });
                    			} else {
                					btnAcceptOfferItemId.setVisible(false);
                					btnDeclineOfferItemId.setVisible(false);
                				}
                    		}
                        }
                    });*/               		                             
    			}
    		}        	
        }
    },
    gettingDataInSummaryGridExpand: function(applicantProfile) {
    	var me=this;
    	var portalId = this.getCurrentLoggedPortalId();
    	if(portalId==6){
    		applicantProfile = me.getContentPanel().items.items[0];
    		applicantProfile.down('#applicantExpandContainerItemId').setVisible(false);
    	}
    	if (applicantProfile) {
    		var grid=applicantProfile.down('#selectionSnapShotGrid');
    		if(portalId==6)
			{
    			var browser = me.getBrowsers();
    			if (browser.isChrome || browser.isFirefox ||browser.isSafari ){
    				var grid=Ext.ComponentQuery.query('selectionsnapshotgrid')[1];	
    			}
    			else{
    				setTimeout(function(){
    					var grid=Ext.ComponentQuery.query('selectionsnapshotgrid')[1];
    					if(grid){
    		    			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    		    				var associatedAcadLocationIds = new Array();
    		    				associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    		    				var applicantOfferLetterPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getAPPLICANT_OFFER_LETTER_PERMISSIONS());

    		    				var acceptOffer = false;
    		    				var declineOffer = false;

    		    				Ext.each(applicantOfferLetterPermissionList, function(privilege) {
    		    					if (privilege === 'ACCEPT_OFFER') {
    		    						acceptOffer = true;
    		    					}
    		    					if (privilege === 'DECLINE_OFFER') {
    		    						declineOffer = true;
    		    					}
    		    				});
    		    				
    		    				if (acceptOffer && declineOffer && portalId==6) {
    		    					grid.down("#btnAcceptOfferItemId").setVisible(false);
    		        				grid.down("#btnDeclineOfferItemId").setVisible(false);        				
    		    				}
    		    				
    		        			var paramObject = {
    		        				applicationID: applicantProfile.getApplicationId()
    		                    };
    		        			var storeConfig = grid.getStore();
    		        			storeConfig.config.paramObject = applicantProfile.getApplicationId();
    		        			storeConfig.load({
    		                    	params:paramObject
    		                    	,callback: function(records, operation, success) {
    		                    		me.getApplicantProfileInformation(applicantProfile);
    		                    		
    		                    		if (acceptOffer && declineOffer) {
    		                    			var btnAcceptOfferItemId = grid.down("#btnAcceptOfferItemId");
    		                				var btnDeclineOfferItemId = grid.down("#btnDeclineOfferItemId");
    		                				
    		                    			if (portalId == 6) {
    		                    				var flag = false;
    		                    				var acceptButton = false;
    		                    				var provisionalColumn = false;
    		                    				for (i in records) {
    		                    					var record = records[i];
    		                    					if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) &&
    		                    							(record.data.currentStatus == 'OFFER_LETTER_ISSUED' || record.data.currentStatus == 'PROVISIONAL_OFFER_ISSUED')) {
    		                    						flag = true;
    		                    						if(record.data.provisionalOfferLetter==true) {
    		                    							provisionalColumn = true;
    		                    						}
    		                    						if(i==0) {
    		                    							provisionalColumn = true;
    		                    						}
    		                    						//break;
    		                    					}
    		                    					else if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) && (record.data.provisionalOfferLetter==true))  {
    		                    						provisionalColumn = true;
    		                    					}
    		                    				}
    		                    				if (flag) {
    		                    					btnAcceptOfferItemId.setVisible(true);
    		                    					btnDeclineOfferItemId.setVisible(true);
    		                    				} else {
    		                    					btnAcceptOfferItemId.setVisible(false);
    		                    					btnDeclineOfferItemId.setVisible(false);
    		                    				}
    		                    				if (acceptButton) {
        		                    				btnAcceptOfferItemId.setDisabled(false);
        		                    				btnDeclineOfferItemId.setDisabled(false);
        		                    			} else {
        		                    				btnAcceptOfferItemId.setDisabled(true);
        		                    				btnDeclineOfferItemId.setDisabled(true);
        		                    			} 
    		                    				if(grid.getStore().data.length>0){
	    		                    				grid.getSelectionModel().deselectAll();
	  		                    		          	grid.getSelectionModel().select(0);
    		                    				}
    		                    				var gridColumns = grid.columnManager.getColumns();
    		                    		        Ext.each(gridColumns, function(column) {
    		                    		            if (column.dataIndex == 'provisionalOfferLetterIssuedFileName') {
    		                    		            	column.setVisible(provisionalColumn);
    		                 		                }
    		                  		            });
    		                    			} else {
    		                					btnAcceptOfferItemId.setVisible(false);
    		                					btnDeclineOfferItemId.setVisible(false);
    		                				}
    		                    		}
    		                        }
    		                    });               		                             
    		    			}
    		    		}
    				},1000);
    			}
			}
    		if(grid){
    			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    				var applicantStagePersonId=null;
    				if(!isNullOrEmpty(applicantProfile.applicationDataObject) && !isNullOrEmpty(applicantProfile.applicationDataObject.person)){
    					applicantStagePersonId=applicantProfile.applicationDataObject.person.id;
    				}
    				var associatedAcadLocationIds = new Array();
    				associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    				var applicantOfferLetterPermissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getAPPLICANT_OFFER_LETTER_PERMISSIONS());

    				var acceptOffer = false;
    				var declineOffer = false;

    				Ext.each(applicantOfferLetterPermissionList, function(privilege) {
    					if (privilege === 'ACCEPT_OFFER') {
    						acceptOffer = true;
    					}
    					if (privilege === 'DECLINE_OFFER') {
    						declineOffer = true;
    					}
    				});
    				
    				if (acceptOffer && declineOffer && portalId==6) {
    					grid.down("#btnAcceptOfferItemId").setVisible(false);
        				grid.down("#btnDeclineOfferItemId").setVisible(false);        				
    				}
    				if(!isNullOrEmpty(applicantStagePersonId)){
    					var paramObject = {
    	        				applicationID: applicantProfile.getApplicationId(),
    	        				applicantStagePersonID:applicantStagePersonId
    	                    };
    				}else{
        			var paramObject = {
        				applicationID: applicantProfile.getApplicationId()
                    };
    				}
        			var storeConfig = grid.getStore();
        			storeConfig.config.paramObject = applicantProfile.getApplicationId();
        			storeConfig.load({
                    	params:paramObject
                    	,callback: function(records, operation, success) {
                    		me.getApplicantProfileInformation(applicantProfile);
                    		
                    		if (acceptOffer && declineOffer) {
                    			var btnAcceptOfferItemId = grid.down("#btnAcceptOfferItemId");
                				var btnDeclineOfferItemId = grid.down("#btnDeclineOfferItemId");
                				
                    			if (portalId == 6) {
                    				var flag = false;
                    				var acceptButton = false;
                    				var provisionalColumn = false;
                    				for (i in records) {
                    					var record = records[i];
                    					if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) &&
                    							(record.data.currentStatus == 'OFFER_LETTER_ISSUED' || record.data.currentStatus == 'PROVISIONAL_OFFER_ISSUED')) {
                    						flag = true;
                    						if(record.data.provisionalOfferLetter==true) {
                    							provisionalColumn = true;
                    						}
                    						if(i==0) {
                    							acceptButton = true;
                    						}
                    						//break;
                    					}
                    					else if (!isNullOrEmpty(record.data) && !isNullOrEmpty(record.data.currentStatus) && (record.data.provisionalOfferLetter==true))  {
                    						provisionalColumn = true;
                    					}
                    				}
                    				if (flag) {
                    					btnAcceptOfferItemId.setVisible(true);
                    					btnDeclineOfferItemId.setVisible(true);
                    				} else {
                    					btnAcceptOfferItemId.setVisible(false);
                    					btnDeclineOfferItemId.setVisible(false);
                    				}
                    				if (acceptButton) {
	                    				btnAcceptOfferItemId.setDisabled(false);
	                    				btnDeclineOfferItemId.setDisabled(false);
	                    			} else {
	                    				btnAcceptOfferItemId.setDisabled(true);
	                    				btnDeclineOfferItemId.setDisabled(true);
	                    			} 
                    				if(grid.getStore().data.length>0){
	                    				grid.getSelectionModel().deselectAll();
	                    		        grid.getSelectionModel().select(0);
                    				}
                    				var gridColumns = grid.columnManager.getColumns();
                    		        Ext.each(gridColumns, function(column) {
                    		            if (column.dataIndex == 'provisionalOfferLetterIssuedFileName') {
                    		            	column.setVisible(provisionalColumn);
                 		                }
                  		            });
                    			} else {
                					btnAcceptOfferItemId.setVisible(false);
                					btnDeclineOfferItemId.setVisible(false);
                				}
                    		}
                        }
                    });              		                             
    			}
    		}        	
        }
    },
    
    /**
     * This function is used for to GET Person Information Object
     *   
     *     
     */
    getPersonInfoObject: function(record) {
        var personObject=new Object();
        /*if(!isEmpty(record) && !isNullOrEmpty(record.get('APPLICATION_PRIMERY_ID'))){
        	personObject.id=record.get('APPLICATION_PRIMERY_ID');
        	//personObject.personType ='APPLICANT';
        }else{*/
        	personObject.id='';
        	//personObject.personType ='APPLICANT';
        //}
        return personObject;
    },
    
    
    /**
     * This function is used for to operate container in view mode
     *    
     */
    setContainerInViewMode:function(container,componentQueryPath,applicantProfile){
    	
    	//Form Container Case
    	if(container.isXType('form')){
    		basicForm = container.getForm();
            toggleReadOnlyFormItems(basicForm,true);
            this.setDisableFormForViewMode(container,componentQueryPath,applicantProfile);
    	}
    	
    	//Grid Container Case
    	if(container.isXType('grid')){    		
            this.setDisableGridForViewMode(container,applicantProfile);
    	}
    	
    	//Window Container Case
    	if(container.isXType('window')){    		
            this.setDisableWindowForViewMode(container,componentQueryPath,applicantProfile);
    	}
    },

    /**
     * This function is used for to hide buttons on form which has flag is set
     *    
     */
    setDisableFormForViewMode:function(container,componentQueryPath,applicantProfile){
    	var containerButtons=applicantProfile.query(componentQueryPath);
    	if(container && containerButtons.length>0){               
           for(var count=0;count<containerButtons.length;count++){
            		var item=containerButtons[count];
                    if(item.isXType('button') && item.hasDisableForProfileViewMode==true){    			
//                        item.setVisible(false);    					
                    }		           	 
    		}   
    	}    	    	    	
    },
    
    /**
     * This function is used for to hide buttons on grid which has flag is set
     *    
     */
    setDisableGridForViewMode:function(container,applicantProfile){    	
    	if(container){
            var toolbars=container.getDockedItems('toolbar[dock="top"]');
            for(var count=0;count<toolbars.length;count++){
                Ext.each(toolbars[count].items.items, function(item) {
                    if(item.isXType('button') && item.hasDisableForProfileViewMode==true){    			
//                        item.setVisible(false);    					
                    }		           	 
    		    });   
            }    		
    	}     	
    },
    
    /**
     * This function is used for to hide buttons on window which has flag is set
     *    
     */
    setDisableWindowForViewMode:function(container,componentQueryPath,applicantProfile){
    	var containerButtons=applicantProfile.query(componentQueryPath);
    	if(container && containerButtons.length>0){               
           for(var count=0;count<containerButtons.length;count++){
            		var item=containerButtons[count];
                    if(item.isXType('button') && item.hasDisableForProfileViewMode==true){    			
//                        item.setVisible(false);    					
                    }		           	 
    		}   
    	}        
    },
    /**
     * This method is used to clear fields on basic search Form
     * @param button which is reference of buttton
     */
    clearSearchForm : function(button){
		//var appCombostore = this.getApplicationsListBasicSearchForm().down('#applicationID').getStore();
		 var acadLocId = this.getUserAccessibleAL();
		/*appCombostore.getProxy().extraParams=({
			isApplicationGrid:true
		});*/
		var currentAL = this.getCurrentAcademyLocation();
		var form = button.up('form').getForm();
		var searchBtn = button.up('form').down('#applicationsListBasicSearchBtn')
        form.findField('START_DATE').setMaxValue(null);
        form.findField('START_DATE').setMinValue(null);
        form.findField('END_DATE').setMaxValue(null);
        form.findField('END_DATE').setMinValue(null);
        form.findField('OFFER_EXPIRY_START_DATE').setMaxValue(null);
        form.findField('OFFER_EXPIRY_START_DATE').setMinValue(null);
        form.findField('OFFER_EXPIRY_START_DATE').setDisabled(true);
        form.findField('OFFER_EXPIRY_END_DATE').setMaxValue(null);
        form.findField('OFFER_EXPIRY_END_DATE').setMinValue(null);
        form.findField('OFFER_EXPIRY_END_DATE').setDisabled(true);
        form.findField('SUBMISSION_START_DATE').setMaxValue(null);
        form.findField('SUBMISSION_START_DATE').setMinValue(null);
        form.findField('SUBMISSION_START_DATE').setDisabled(false);
        form.findField('SUBMISSION_END_DATE').setMaxValue(null);
        form.findField('SUBMISSION_END_DATE').setMinValue(null);
        form.findField('SUBMISSION_END_DATE').setDisabled(false);
        form.findField('PROGRAM').setDisabled(true);
        form.findField('PROGRAM_SELECTION_PROCESS_STAGE_ID').setDisabled(true);
        var allApp = this.getApplicationsListBasicSearchForm().down('#allApplicationItemId');
        var combo = this.getApplicationsListBasicSearchForm().down('#showApplicationsMainItemId').isVisible();
        //searchBtn.setDisabled(true);
       
        var allAppValue =  allApp.getValue();

        form.getFields().each(function(field) {
        	field.reset();	
        });
       if(combo){
        	this.getApplicationsListBasicSearchForm().down('#allApplicationItemId').setValue(true);
        }else{
        	if(allAppValue){
            	this.getApplicationsListBasicSearchForm().down('#allApplicationItemId').setValue(true)
            }else{
            	this.getApplicationsListBasicSearchForm().down('#myApplicationItemId').setValue(true);
            }
        }
 	   this.getApplicationsListBasicSearchForm().down('#batch').setDisabled(true);
 	   var enquiryNo=this.getApplicationsListBasicSearchForm().down('#enquiryNo');
 	   enquiryNo.getStore().getProxy.extraParams={
 		  academyLocationId: acadLocId.join()
 	   };
 	   var department = this.getApplicationsListBasicSearchForm().down('#programDepartmentItemId');
 	   var departmentStore = department.getStore();
 	   departmentStore.getProxy().extraParams = {
 		  academyLocationsIds: acadLocId.join()
       };
 	   departmentStore.load();
		var spBtnFetchNscDataItemId = this.getSearchResultGrid().down('#spBtnFetchNscDataItemId');
		spBtnFetchNscDataItemId.setDisabled(true);
		
			
			var academyLocationfield = form.findField('ACAD_LOC_ID');
			var alStore = academyLocationfield.getStore();
			
			/*alStore.load({
					callback:function(records,response,success){
						academyLocationfield.setValue(currentAL)
						searchBtn.setDisabled(false);
					}
				});*/
			
			
    },
    /**
     * This is used to disable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	var moreActionButton = gridReference.down('#spBtnMoreActions');
        	moreActionButton.setVisible(false);
        	var sendMessageBtn = gridReference.down('#sendMessageBtn');
        	sendMessageBtn.setVisible(false);
        	var sendSurveyBtn = gridReference.down('#sendSurveyBtn');
        	sendSurveyBtn.setVisible(false);
        	var resetButtonItemId = gridReference.down('#resetButtonItemId');
        	resetButtonItemId.setVisible(false);
        	var frozenBtn = gridReference.down('#frozenItemId');
        	frozenBtn.setVisible(false);
        	var unFrozenBtn = gridReference.down('#unFrozenItemId');
        	var bulkDocDownloadBtn = gridReference.down('#bulkDownloadDocId');
        	unFrozenBtn.setVisible(false);
        	bulkDocDownloadBtn.setVisible(false);
        	var printProfileBtn = gridReference.down('#printProfileBtn');
        	printProfileBtn.setVisible(false);
        	var offerLetterDetailsBtn = gridReference.down('#offerLetterDetailsItemId');
        	offerLetterDetailsBtn.setVisible(false);
        	var admissionApprovalDetailsBtn = gridReference.down('#admissionApprovalDetailsItemId');
        	admissionApprovalDetailsBtn.setVisible(false);
        	var preEligibilityBtn = gridReference.down('#preEligibilityItemId');
        	preEligibilityBtn.setVisible(false);
        	var calculateExamAggregateBtn = gridReference.down('#calculateExamAggregateItemId');
        	calculateExamAggregateBtn.setVisible(false);
        	var documentRequest = gridReference.down('#documentRequest');
        	documentRequest.setVisible(false);
        	
        	var applicantSendMSGToAllBtn = gridReference.down('#applicantSendMSGToAllBtn');
        	applicantSendMSGToAllBtn.setVisible(false);
        	
        	var radioGroup = this.getApplicationsListBasicSearchForm().down('#showApplicationsMainItemId');
        	radioGroup.setVisible(false);
        	var allApplication=radioGroup.down('#allApplicationItemId');
        	var myApplication=radioGroup.down('#myApplicationItemId');
        	var allApplicationStatus=false;
        	var myApplicationStatus=false;
        	var reassignApplication = gridReference.down('#reassignApplicatioinItemId');
        	reassignApplication.setVisible(false);        	
        	var reviewApplication = gridReference.down('#reviewApplicationItemId');
        	reviewApplication.setVisible(false);
        	var duplicateEmailBtn = gridReference.down('#checkDuplicateEmailItemId');
        	duplicateEmailBtn.setVisible(false);
        	var duplicateNationalIdBtn = gridReference.down('#checkDuplicateNationalItemId');
        	duplicateNationalIdBtn.setVisible(false);
        	var spBtnFetchNscDataItemId = gridReference.down('#spBtnFetchNscDataItemId');
        	spBtnFetchNscDataItemId.setVisible(false);
        	var btnRefreshAllItemId = gridReference.down('#btnRefreshAllItemId');
        	btnRefreshAllItemId.setVisible(false);
        	var btnOnlyUnmatchedRecordsItemId = gridReference.down('#btnOnlyUnmatchedRecordsItemId');
        	btnOnlyUnmatchedRecordsItemId.setVisible(false);
        	var reactivateApplicationBtn = gridReference.down('#reactivateApplicationItemId');
        	reactivateApplicationBtn.setDisabled(true);
        	reactivateApplicationBtn.setVisible(false);
        	var printOfferLetterWordsBtn = gridReference.down('#printOfferLetterWordsItemId');
        	printOfferLetterWordsBtn.setDisabled(true);
        	printOfferLetterWordsBtn.setVisible(false);
        	var expireOfferLetterBtn = gridReference.down('#expireOfferLetterItemId');
        	expireOfferLetterBtn.setVisible(false);
        	expireOfferLetterBtn.setDisabled(true);
        	
        	var applicationAndAdmissionCommentsBtn = gridReference.down('#applicationAndAdmissionCommentsItemId');
        	applicationAndAdmissionCommentsBtn.setVisible(false);
        	var reassignEscalationBtn = gridReference.down('#reassignescalationitemid');
        	reassignEscalationBtn.setVisible(false);
        	var PopiaOptionButton = gridReference.down('#popiaOptionBtn');
        	PopiaOptionButton.setVisible(false);
        	var scholarshipRaiseRequest = gridReference.down('#raiseScholarshipApplicantRequestId');
        	scholarshipRaiseRequest.setVisible(false);
        	
        	var pandaDocBtn = gridReference.down('#pandaDocItemId');
        	pandaDocBtn.setVisible(false);
        	var raisePriorityBtn = gridReference.down('#raisePriorityItemId');
        	raisePriorityBtn.setVisible(false);
        	var markApplicationOffTrackBtn = gridReference.down('#markApplicationOffTrackItemId');
        	markApplicationOffTrackBtn.setVisible(false);
        	var pendingOfferFlagItemId = gridReference.down('#pendingOfferFlagItemId');
        	pendingOfferFlagItemId.setVisible(false);
        	
        	
        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'MOREACTIONS') {
            		if(!isNullOrEmpty(moreActionButton)){
            			moreActionButton.setVisible(true);
            		}        		
            	}
        		if (privilege === 'SENDSURVEY') {
            		if(!isNullOrEmpty(sendSurveyBtn)){
            			sendSurveyBtn.setVisible(true);
            		}        		
            	}
        		if (privilege === 'RESETPASSWORD') {
            		if(!isNullOrEmpty(resetButtonItemId)) {
            			resetButtonItemId.setVisible(true);
            		}
            	}
        		if (privilege === 'FROZEN') {
            		if(!isNullOrEmpty(frozenBtn)) {
            			frozenBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'UNFROZEN') {
            		if(!isNullOrEmpty(unFrozenBtn)) {
            			unFrozenBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'PENDING_OFFER_FLAG') {
            		if(!isNullOrEmpty(pendingOfferFlagItemId)) {
            			pendingOfferFlagItemId.setVisible(true);
            		}
            	}
        		if (privilege === 'SENDMESSAGE') {
            		if(!isNullOrEmpty(sendMessageBtn)){
            			sendMessageBtn.setVisible(true);
            		}        		
            	}
        		if (privilege === 'PRINT_PROFILE') {
            		if(!isNullOrEmpty(printProfileBtn)){
            			printProfileBtn.setVisible(true);
            		}        		
            	}
        		if (privilege === 'BULK_DOCUMENT_DOWNLOAD') {
            		if(!isNullOrEmpty(bulkDocDownloadBtn)) {
            			bulkDocDownloadBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'OFFER_LETTER_DETAILS') {
            		if(!isNullOrEmpty(offerLetterDetailsBtn)) {
            			offerLetterDetailsBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'ADMISSION_APPROVAL_DETAILS') {
            		if(!isNullOrEmpty(admissionApprovalDetailsBtn)) {
            			admissionApprovalDetailsBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'PRE_ELIGIBILITY_CHECK') {
            		if(!isNullOrEmpty(preEligibilityBtn)) {
            			preEligibilityBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'CALCULATE_EXAM_AGGREGATE') {
            		if(!isNullOrEmpty(calculateExamAggregateBtn)) {
            			calculateExamAggregateBtn.setVisible(true);
            		}
            	}
        		if (privilege === 'ALL_APPLICATIONS') {
            		if(!isNullOrEmpty(allApplication)) {
            			allApplicationStatus=true;
            		}
            	}
        		if (privilege === 'MY_APPLICATIONS') {
            		if(!isNullOrEmpty(myApplication)) {
                    	myApplicationStatus=true;
            		}
            	}
        		if (privilege === 'REASSIGN_APPLICATION') {
            		if(!isNullOrEmpty(reassignApplication)) {
            			reassignApplication.setVisible(true);
            		}
            	}
        		if (privilege === 'REVIEW_APPLICATION') {
            		if(!isNullOrEmpty(reviewApplication)) {
            			reviewApplication.setVisible(true);
            		}
            	}if(privilege ==='CHECK_DUPLICATE_EMAI'){
        			if(!isNullOrEmpty(duplicateEmailBtn)) {
        				duplicateEmailBtn.setVisible(true);
            	}
        			
        		}
        		if(privilege ==='CHECK_DUPLICATE_NATIONAL_ID'){
        			if(!isNullOrEmpty(duplicateNationalIdBtn)) {
        				duplicateNationalIdBtn.setVisible(true);
            		}
        			
        		}if (privilege === 'DOCUMENT_REQUEST') {
            		if(!isNullOrEmpty(documentRequest)){
            			documentRequest.setVisible(true);
            		}        		
            	}
				
				if (privilege === 'FETCH_NSC_DATA') {
            		if(!isNullOrEmpty(spBtnFetchNscDataItemId)){
            			spBtnFetchNscDataItemId.setVisible(true);
            		}        		
            	}
				if (privilege === 'REFRESH_ALL') {
            		if(!isNullOrEmpty(btnRefreshAllItemId)){
            			btnRefreshAllItemId.setVisible(true);
            		}        		
            	}
				if (privilege === 'ONLY_UNMATCHED_RECORDS') {
            		if(!isNullOrEmpty(btnOnlyUnmatchedRecordsItemId)){
            			btnOnlyUnmatchedRecordsItemId.setVisible(true);
            		}        		
            	}
				if (privilege === 'REACTIVATE_APPLICATION') {
            		if(!isNullOrEmpty(reactivateApplicationBtn)){
            			reactivateApplicationBtn.setVisible(true);
            		}        		
            	}
				
				if (privilege === 'PRINT_OFFER_LETTER_WORDS') {
            		if(!isNullOrEmpty(printOfferLetterWordsBtn)){
            			printOfferLetterWordsBtn.setVisible(true);
            		}        		
            	}
				if (privilege === 'SEND_MESSAGE_TO_ALL') {
            		if(!isNullOrEmpty(applicantSendMSGToAllBtn)){
            			applicantSendMSGToAllBtn.setVisible(true);
            			}
            		}
            		
				if (privilege === 'REASSIGN_ESCALATION') {
            		if(!isNullOrEmpty(reassignEscalationBtn)){
            			reassignEscalationBtn.setVisible(true);
            			reassignEscalationBtn.setDisabled(true);
            		}        		
            	}
            	
            	if (privilege === 'APPLICATION_AND_ADMISSION_COMMENTS') {
            		if(!isNullOrEmpty(applicationAndAdmissionCommentsBtn)){
            			applicationAndAdmissionCommentsBtn.setVisible(true);
            		}        		
            	}
            	if (privilege === 'EXPIRE_OFFER_LETTER') {
            		if(!isNullOrEmpty(expireOfferLetterBtn)){
            			expireOfferLetterBtn.setVisible(true);
            		}        		
            	}
            	if (privilege === 'POPIA_OPTION') {
            		if(!isNullOrEmpty(PopiaOptionButton)){
            			PopiaOptionButton.setVisible(true);
            		}        		
            	}
            	if (privilege === 'PANDADOC_BTN') {
            		if(!isNullOrEmpty(pandaDocBtn)){
            			pandaDocBtn.setVisible(true);
            		}        		
            	}
            	
            	if (privilege === 'RAISE_SCHOLARSHIP_REQUEST') {
            		if(!isNullOrEmpty(scholarshipRaiseRequest)){
            			scholarshipRaiseRequest.setVisible(true);
            		}        		
            	}
            	if(privilege ==='RAISE_PRIORITY'){
            		if(!isNullOrEmpty(raisePriorityBtn)) {
        				raisePriorityBtn.setVisible(true);
            		}
            	}
            	if(privilege ==='MARK_APPLICATION_OFF_TRACK'){
            		if(!isNullOrEmpty(markApplicationOffTrackBtn)) {
            			markApplicationOffTrackBtn.setVisible(true);
            		}
            	}
        	});
        	if(allApplicationStatus && myApplicationStatus) {
        		radioGroup.setVisible(true);
        		allApplication.setValue(true);
        	}else if((!allApplicationStatus && !myApplicationStatus) || (!allApplicationStatus && myApplicationStatus) ){
        		radioGroup.setVisible(false);
        		myApplication.setValue(true);
        	}else{
        		radioGroup.setVisible(false);
        		allApplication.setValue(true);
        	}
        },
        saveMarkApplicationOffTrack:function(form){
  			var $this = this;
  			var grid = this.getSearchResultGrid();
  			var values = form.getValues();

			var jsonData = new Object(); 
			var tempArray = []; 
        	var selected = grid.selModel.getSelection();
        	if( selected.length > 0){
        		
        		for( var i = 0; i < selected.length; i++) {
        			if(!isNullOrEmpty(selected[i].data.APPLICATION_PROGRAM_ID)){
       					tempArray.push(selected[i].data.APPLICATION_PROGRAM_ID);
       				}
        		}
        		jsonData.applicationProgramId = tempArray;
        		jsonData.markApplicationOffTrack = values.markApplicationOffTrack;
        		if(!isNullOrEmpty(values.markApplicationOffTrackReason)){
        			jsonData.markApplicationOffTrackReason = {
       	                 id: values.markApplicationOffTrackReason
       		        };
        		}
       			
        	submitUrl = SERVERURL.PATH_APPLICATION_OFF_TRACK;
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: jsonData,
				method: 'POST',
				success: function(form, action) {
					$this.hideWindowMask();
					showSuccessMessage( getCommonTranslation('MARK_APPLICATION_OFF_TRACK'),getCommonTranslation('SUCCESS'));
					Ext.ComponentQuery.query('markapplicationofftrackwindow')[0].close();
					grid.getStore().reload();
				}
			});
        	}
		 },
		 showAndHideTrackOffStatus : function(window){
			 var grid = this.getSearchResultGrid();
			 setTimeout(function(){
				 	var radioGroup =  window.down('form').getForm().findField('markApplicationOffTrack');
		         	var lost = radioGroup.items.items[0].getValue();
		         	var reapplied = radioGroup.items.items[1].getValue();

		         	 if(!isNullOrEmpty(grid.getSelectionModel().selected.items[0].data.OFF_TRACK_APPLICATION_STATUS) && !isNullOrEmpty(grid.getSelectionModel().selected.items[0].data.OFF_TRACK_APPLICATION_STATUS_REASON)){
		         		reapplied =true;
		         		radioGroup.items.items[1].setDisabled(false);
		         		radioGroup.items.items[1].setValue(true);
		         		radioGroup.items.items[0].setDisabled(true);
		         		radioGroup.items.items[0].setValue(false);
					  }else{
						reapplied =  false;
						radioGroup.items.items[0].setDisabled(false);
						radioGroup.items.items[0].setValue(true);
						radioGroup.items.items[1].setDisabled(true)
						radioGroup.items.items[1].setValue(false);
		         	}

		         	if(reapplied){
		         		window.down('#markApplicationOffTrackReason').reset();
		         		window.down('#markApplicationOffTrackReason').allowBlank=true;
		         		window.down('#markApplicationOffTrackReason').setVisible(false);
		         	}else{
		         		window.down('#markApplicationOffTrackReason').reset();
		         		window.down('#markApplicationOffTrackReason').allowBlank=false;
		         		window.down('#markApplicationOffTrackReason').setVisible(true);
		         	}
				},100);
         	
         },
        saveRaisePriority:function(form){
  			var $this = this;
  			var grid = this.getSearchResultGrid();
  			var values = form.getValues();

			var jsonData = new Object(); 
			var tempArray = []; 
        	var selected = grid.selModel.getSelection();
        	if( selected.length > 0){
        		
        		for( var i = 0; i < selected.length; i++) {
        			if(!isNullOrEmpty(selected[i].data.APPLICATION_PROGRAM_ID)){
       					tempArray.push(selected[i].data.APPLICATION_PROGRAM_ID);
       				}
        		}
        		jsonData.applicationProgramId = tempArray;
       			jsonData.priorityFlagIdName = {
	                 id: values.flagIdName
		        };
        	submitUrl = SERVERURL.PATH_APPLICANT_RAISE_PRIORITY;
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: jsonData,
				method: 'POST',
				success: function(form, action) {
					$this.hideWindowMask();
					showSuccessMessage( getCommonTranslation('RAISE_PRIORITY'),getCommonTranslation('SUCCESS'));
					Ext.ComponentQuery.query('raiseprioritywindow')[0].close();
					grid.getStore().reload();
				}
			});
        	}
		 },
		savePendingOfferFlagWindow:function(form){
  			var $this = this;
  			var grid = this.getSearchResultGrid();
  			var values = form.getValues();

			var jsonData = new Object(); 
			var tempArray = []; 
        	var selected = grid.selModel.getSelection();
        	if( selected.length > 0){
        		
        		for( var i = 0; i < selected.length; i++) {
        			if(!isNullOrEmpty(selected[i].data.APPLICATION_PROGRAM_ID)){
       					tempArray.push(selected[i].data.APPLICATION_PROGRAM_ID);
       				}
        		}
        		jsonData.applicationProgramId = tempArray;
       			jsonData.pendingOfferLetterCSM = {
	                 id: values.pendingOfferflag
		        };
        	submitUrl = SERVERURL.PATH_APPLICANT_PENDING_OFFER_SAVE;
			Ext.Ajax.request({
				type: 'rest',
				url: submitUrl,
				jsonData: jsonData,
				method: 'POST',
				success: function(form, action) {
					$this.hideWindowMask();
					showSuccessMessage( getCommonTranslation('PENDING_OFFER_FLAG'),getCommonTranslation('SUCCESS'));
					Ext.ComponentQuery.query('pendingofferflagwindow')[0].close();
					grid.getStore().reload();
				}
			});
        	}
		 },
        sendSurveyDetails:function(obj){
        	var $this = this;
        	var grid = $this.getSearchResultGrid();
        	
        	var form = $this.getApplicationSendsurvey().getForm();
        	var surveyId = form.findField('survey').getValue();
        	var surveyUrl = form.findField('survey').getRawValue();

        	var jsonData = [];
        	var selected = grid.selModel.getSelection();
        	if( selected.length > 0){
        		
        		for( var i = 0; i < selected.length; i++) {
        			jsonData.push({
        				"id":selected[i].data.ID,
        				"surveyMaster" : $this.getIdValueJson(surveyId),
//      				"userId":selected[i].data.ID,
        				"surveyUrl" : surveyUrl, //+ '&userId=' + selected[i].data.ID,
        				"applicant": $this.getIdValueJson(selected[i].data.ID),
        				"student": null,
        				"enquiry": null,
        				"user" : null,
        				"userType":"APPLICANT"

        			});
        		}
        	}
        	submitUrl = SERVERURL.SEND_SURVEY;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonData,
     			method : 'POST',
     			success : function(form, action) {
     				showSuccessMessage(getCommonTranslation('SEND_SURVEY'),getCommonTranslation('SUCCESS'));
     				grid.getStore().reload();
     				obj.up('window').close();
     			}
     		});
        },
        sendPopiaOptionDetails:function(obj){
        	var $this = this;

        	var form = $this.getApplicationpopiaoption();
        	form.down('#saveBtn').setDisabled(true);
       		var popiastatus =form.down('#popiastatusId').value; 
       		var popiastatusValue=null;
       		if(!isNullOrEmpty(popiastatus))
       			{
       			if(popiastatus=="Opt-In"){
       				popiastatusValue=true;
       				}else{
       				popiastatusValue=false;
       				      }
       			
        	var jsonData = []; 
        	var selected = grid.selModel.getSelection();
        	if( selected.length > 0){
        		
        		for( var i = 0; i < selected.length; i++) {
        			jsonData.push({
        				"id":selected[i].data.ID,
        				"popiaStatus":popiastatusValue,
        			});
        		}
        	}
        	submitUrl = SERVERURL.PATH_SEND_APPLICANT_POPIA_STATUS;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonData,
     			method : 'POST',
     			success : function(form, action) {
     				showSuccessMessage(getCommonTranslation('POPIA_STATUS'),getCommonTranslation('SUCCESS'));
     				grid.getStore().reload();
     				if(!isNullOrEmpty(Ext.ComponentQuery.query('applicationpopiaoption')[0])){
    	 				Ext.ComponentQuery.query('applicationpopiaoption')[0].close();
    	 		   }
     			}
     		});
       			}
       		else
       			{
       			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_DROPDOWN_VALUE'));
       			form.down('#saveBtn').setDisabled(false);
       			}
       		
        },
        reassignApplicationsSave:function(obj){
        	var $this = this;
        	var grid = $this.getSearchResultGrid();
       
        	var form = $this.getReassignapplicationform().down('idgeneratorformwin').getForm();
        	var formField = $this.getReassignapplicationform().down('idgeneratorformwin');
        	var sendReassignNotificationField	= formField.down('#sendReassignNotificationField').getValue();
        	var applicationOwner = form.findField('applicationOwner').getValue();
        	var apOwReassigndate = form.findField('reassignOwnerdate').getValue();
        	var apOwReassignRemark = form.findField('reassignOwnerRemark').getValue();

        	var jsonData = [];
        	var selected = grid.selModel.getSelection();
        	var temp ; 
        	if( selected.length > 0){
        		Ext.getBody().mask(getCommonTranslation('Please Wait'), 'x-mask-loading');
        		for( var i = 0; i < selected.length; i++) {
        			temp = null ;
        			 if( i == 0 ){
        				 temp =sendReassignNotificationField;
        	  		   }
        			jsonData.push({
        				"applicationOwner" : $this.getIdValueJson(applicationOwner),
        				"applicationAssignDate" : Ext.Date.format(new Date(apOwReassigndate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
        				"applicationAssignRemark" :apOwReassignRemark,
        				"id":selected[i].data.ID,
        				'sendReassignNotification': temp
        			});
        		}
        	}
        	submitUrl = SERVERURL.PATH_REASSIGN_APPLICANT_OWNER;
        	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonData,
     			method : 'POST',
     			success : function(form, action) {
     				showSuccessMessage(getAdmissionTranslation('REASSIGN_APPLICATION'),getAdmissionTranslation('APPLICATION_RE_ASSIGNED_SUCCESSFULLY'));
     				grid.getStore().reload();
     				obj.up('window').close();
     				Ext.getBody().unmask();
     			}
     		});
        },
        /*application and admission comment code*/ 
        applicationAndAdmissionCommentsSave:function(obj){
        	var $this = this;
        	var grid = $this.getSearchResultGrid();
       
        	var form = $this.getApplicationandadmissioncommentform().down('idgeneratorformwin').getForm();
        	var formField = $this.getApplicationandadmissioncommentform().down('idgeneratorformwin');
        	var applicationOwner = form.findField('applicationOwner').getValue();
        	var apOwReassigndate = form.findField('reassignOwnerdate').getValue();
        	var apOwReassignRemark = form.findField('reassignOwnerRemark').getValue();
        	var user = this$.getCurrentlyLoggedInUser();
        	var jsonData = [];
        	var selected = grid.selModel.getSelection();
        	var temp ; 
        	if( selected.length > 0){
        		Ext.getBody().mask(getCommonTranslation('Please Wait'), 'x-mask-loading');
        		for( var i = 0; i < selected.length; i++) {
        			temp = null ;
        			jsonData.push({
        				"reassignUserId" : applicationOwner,
        				"reassignDate" : Ext.Date.format(new Date(apOwReassigndate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT),
        				"commentText" :apOwReassignRemark,
        				"applicationId":selected[i].data.ID,
        				"assignbyUserId": user.id,
        			});
        		}
        	}
        	submitUrl = SERVERURL.PATH_APPLICANT_ADMISSION_COMMENTS;
        	Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
     		Ext.Ajax.request({
     			type : 'rest',
     			url : submitUrl,
     			jsonData : jsonData,
     			method : 'POST',
     			success : function(form, action) {
     				showSuccessMessage(getCommonTranslation('APPLICATION_AND_ADMISSION_COMMENTS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
     				grid.getStore().reload();
     				obj.up('window').close();
     				Ext.getBody().unmask();
     			}
     		});
        },

        getIdValueJson: function(id, value,code) {
        	if (id) return {
        		id: id,
        		value: value,
        		code: code
        	};
        },
        
        /* bulk offer status update*/
        downloadUploadFormChangeBulkOfferStatus : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = this.getBulkofferstatusupdatedownloadform();
    		var uploadTemplateForm = this.getBulkofferstatusupdateuploadform();
    		
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			$this.getImportlistbulkofferstatusupdate().setVisible(false);
    			if(downloadTemplateForm.getForm().isValid()) {
    				downloadTemplateForm.down('#downoladBtnId').setDisabled(false);
    			} else {
    				downloadTemplateForm.down('#downoladBtnId').setDisabled(true);
    			}
    		}else{
    			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getApplicationsUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			$this.getImportlistbulkofferstatusupdate().setVisible(true);
    		}
    	},
    	
        
        
        /** Download upload form change **/

    	downloadUploadFormChange : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = cb.down('#applicationsdownloadformId');
    		var uploadTemplateForm = cb.down('#applicationsuploadformId');
    		var importListNewApplicant = cb.down('#importListApplicant');
    		
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			importListNewApplicant.hide();
    			if(downloadTemplateForm.getForm().isValid()) {
    				downloadTemplateForm.down('#downoladBtnId').setDisabled(false);
    			} else {
    				downloadTemplateForm.down('#downoladBtnId').setDisabled(true);
    			}
    		}else{
    			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getApplicationsUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			importListNewApplicant.show();
    		}
    	},
    	
    	/** Download upload form change for applicant relationship loader **/

    	downloadUploadFormChangeApplicantRelationship : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = cb.down('#importapplicantrelationshipdownloadformItemId');
    		var uploadTemplateForm = cb.down('#importapplicantrelationshipuploadformItemId');
    		var importListNewApplicant = cb.down('#importapplicantrelationshipgridItemId');
    		
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			importListNewApplicant.hide();
    		}else{
    			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getApplicationsUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
            	downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			importListNewApplicant.show();
    		}
    	},
    	
    	downloadUploadApplicationFormChange : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = cb.down('#importapplicationsdownloadformId');
    		var uploadTemplateForm = cb.down('#importapplicationsuploadformId');
    		var importListNewApplicant = cb.down('#importlistapplicationsId');
    		
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			importListNewApplicant.hide();
    		}else{
    			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getImportapplicationsUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			importListNewApplicant.show();
    		}
    	},
    	
    	downloadUploadBulkAdmissionApprovalFormChange : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = cb.down('#importbulkadmissionapprovaldownloadformItemId');
    		var uploadTemplateForm = cb.down('#importbulkadmissionapprovaluploadformItemId');
    		var importlistadmissionapproval = cb.down('#importlistadmissionapprovalId');
    		
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			importlistadmissionapproval.hide();
    		}else{
            	var uploadoptionradiogroupform  = $this.getImportapplicationsUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			importlistadmissionapproval.show();
    		}
    	},
    	
    	downloadUploadUpdateApplicationStatusFormChange : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = cb.down('#bulkupdateapplicationstatusdownloadformItemId');
    		var uploadTemplateForm = cb.down('#bulkupdateapplicationstatusuploadformItemId');
    		var bulkupdateapplicationstatus = cb.down('#bulkupdateapplicationstatusgridId');
    		
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			bulkupdateapplicationstatus.hide();
    		}else{
            	var uploadoptionradiogroupform  = $this.getImportapplicationsUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			bulkupdateapplicationstatus.show();
    		}
    	},
    	
    	downloadUploadApplicationNewFormChange : function(cb, nv, ov){
    		var $this = this;
    		var downloadTemplateForm = cb.down('#importapplicationsnewdownloadformId');
    		var uploadTemplateForm = cb.down('#importapplicationsnewuploadformId');
    		var importListNewApplicant = cb.down('#importlistnewapplicantId');
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			importListNewApplicant.hide();
    		}else{
    			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
            	var uploadoptionradiogroupform  = $this.getImportapplicationsnewUploaduploadoptionradiogroup();
            	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
            		isUploadAll: false
            	});
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			importListNewApplicant.show();
    		}
    	},
    	
    	/**
         * 
         *Check and Change password by admin. 
         */
        changePasswordByExternalUser:function(button){
        	var grid = this.getSearchResultGrid();
        	var gridRec=grid.getSelectionModel().getSelection()[0];
        	var window=button.up('window');
        	var form=button.up('form').getForm();
        	window.down('#submitBtn').setDisabled(true);
    		var formValues=form.getValues();
    		var recordsTemp=grid.getSelectionModel().getSelection();
    		var externalApplicantIds=[];
    		recordsTemp.forEach(function(obj){
				   externalApplicantIds.push(obj.get('EXTERNAL_USER_ID'));
			   });
    		var data={
    				  "id":gridRec.data.EXTERNAL_USER_ID,
    				  "newPassword":this.encryptPassword(formValues.confirmedPassword),
    				  "ids":externalApplicantIds
    				};
    		/***
    		 * It's inital been commented further it get implemented. 
    		 * Check whether user is locked or not
    		 */
    		/*var url = SERVERURL.CHECK_PASSWORD_VALIDITY;
    		Ext.Ajax.request({
                method: "GET",
                type: 'rest',
                url:url+'?password='+formValues.newPassword,
                success: function(response) {
                	
                	var mssg = response.responseText;
    				if (mssg == "false") {
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
    				}else if(mssg == "true"){*/
    					/**
    					 * Change password
    					 */
    		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
    				function(btn, text) {
    			if (btn == 'yes'){
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var pswrdurl = SERVERURL.RESET_PASSWORD_EXTERNAL_USER;
    				Ext.Ajax.request({
    					method: "POST",
    					type: 'rest',
    					url:pswrdurl,
    					jsonData:data,
    					success: function(response) {
    						var mssg = response.responseText;
    						Ext.getBody().unmask();
    						if (mssg == 'true') {
    							window.close();
    							showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('ADMIN_PASSWORD_CHANGE_MSG'));
    						}
    					},
    					failure:function(response) {
    						Ext.getBody().unmask();
    						var mssg = response.responseText;
    						if (mssg.includes("PASSWORD_IN_USE")) {
    							showWarningMessage(getCommonTranslation('Alert'),getCommonTranslation('PASSWORD_IN_USE'));
    						}
    					}
    				});
    			}else{
    				window.down('#submitBtn').setDisabled(false);
    			}
    		});
    					
    					
    				/*}
                }
    		 });*/
        },
        
        getDownloadFile : function(documentId,fileType){

        	if(!isNullOrEmpty(documentId)){
        		var csvForm = Ext.create('Ext.form.Panel'); 
        		csvForm.getForm().submit({
        			target: '_blank',
        			method:'POST',
        			params :{
        				access_token : Ext.Ajax.defaultHeaders.access_token
        			},
        			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
        			standardSubmit :true
        		});
        	}
        },
        
        getUniqueStatus : function(list) {
       	 var newArr = [];
       	 var found;
       	 var status=false;
       	 for (var i = 0; i < list.length;i++) {
       		 found = undefined;
       		 for (var j=0; j<newArr.length;j++) {
       			 if (list[i] == newArr[j]) {
       				 found = true;
       				 break;
       			 }else{
       				 status=true;
       				 return status;
       			 }
       		 }
       		 if (!found) {
       			 newArr.push(list[i]);
       		 }
       	 }
       	 return newArr;
        },
        
    	disableImportApplicationsBulkAdmission: function(structure, permissionsMap) {
            var associatedAcadLocationIds = new Array();
            associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
           var applicationsApplicationBulkDocumentDownloadTab= false;
           var applicationsBulkOfferStatusUpdateTab= false;
            
            for (var i = 0; i < permissionList.length; i++) {
                if (permissionList[i] === "BULK_APPLICATION_DOCUMENT_DOWNLOAD") {
                	applicationsApplicationBulkDocumentDownloadTab = true;
                }
                if (permissionList[i] === "BULK_OFFER_STATUS_UPDATE") {
                	applicationsBulkOfferStatusUpdateTab = true;
                }
            }

            this.showApplicationTab(applicationsApplicationBulkDocumentDownloadTab, applicationsBulkOfferStatusUpdateTab,structure);
        },

        showApplicationTab: function(applicationsApplicationBulkDocumentDownloadTab,applicationsBulkOfferStatusUpdateTab,structure) {
            var panelItem = new Array();
            var $this = this;
            var newcont = structure.items.items.length;
            var insertPosition = newcont + 1;
            /*if (applicationsAdmissionBulkImportTab && applicationsApplicationBulkImportTab && newApplicationBulkImportTab) {
                panelItem.push({
                    xtype: 'tabpanel',
                    itemId: 'allVisibleTP',
                    plain: true,
                    style: {
                        overflow: 'hidden !important',
                        margin: '0!important'
                    },
                    frame: false,
                    border: false,
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'quicksearchpanel',
                        itemId: 'quickSearchPanel',
                        title: getAdmissionTranslation('QUICK_SEARCH'), //Quick Search
                    }, {
                        xtype: 'advancedsearchquerybuilder',
                        itemId: 'advancedSearchPanel',
                        searchConfigCode: CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE,
                        searchResultViewCode: CONSTANTS.CB.APPLICATION_LIST_VIEWCODE,
                        permissionMapKey: 'APPLICATION_PRIVILEGES',
                        gridTitle: getCommonTranslation("APPLICATION_LIST"),
                        moduleName: 'ADMISSION',
                        FPCONSTANTS: 'APPLICATION_PRIVILEGES'
                    }, {
                        xtype: 'applicationuploaddownloadstructure',
                        itemId: 'applicationuploaddownloadstructureId',
                        title: getTranslation('IMPORT_BULK_ADMISION')
                    }, {
                        xtype: 'applicationsuploaddownloadstructure',
                        itemId: 'applicationsuploaddownloadstructureId',
                        title: getTranslation('IMPORT_BULK_APPLICATION')
                    }, {
                        xtype: 'applicationsnewuploaddownloadstructure',
                        itemId: 'applicationsnewuploaddownloadstructureId',
                        title: getTranslation('IMPORT_BULK_APPLICATION_NEW')
                    }]
                });

            } else if (applicationsAdmissionBulkImportTab) {
                panelItem.push({
                    xtype: 'tabpanel',
                    itemId: 'allVisibleTP',
                    plain: true,
                    style: {
                        overflow: 'hidden !important',
                        margin: '0!important'
                    },
                    frame: false,
                    border: false,
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'quicksearchpanel',
                        itemId: 'quickSearchPanel',
                        title: getAdmissionTranslation('QUICK_SEARCH'), //Quick Search
                    }, {
                        xtype: 'advancedsearchquerybuilder',
                        itemId: 'advancedSearchPanel',
                        searchConfigCode: CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE,
                        searchResultViewCode: CONSTANTS.CB.APPLICATION_LIST_VIEWCODE,
                        permissionMapKey: 'APPLICATION_PRIVILEGES',
                        gridTitle: getCommonTranslation("APPLICATION_LIST"),
                        moduleName: 'ADMISSION',
                        FPCONSTANTS: 'APPLICATION_PRIVILEGES'
                    }, {
                        xtype: 'applicationuploaddownloadstructure',
                        itemId: 'applicationuploaddownloadstructureId',
                        title: getTranslation('IMPORT_BULK_ADMISION')
                    }, ]
                });

            } else if (applicationsApplicationBulkImportTab) {
                panelItem.push({
                    xtype: 'tabpanel',
                    itemId: 'allVisibleTP',
                    plain: true,
                    style: {
                        overflow: 'hidden !important',
                        margin: '0!important'
                    },
                    frame: false,
                    border: false,
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'quicksearchpanel',
                        itemId: 'quickSearchPanel',
                        title: getAdmissionTranslation('QUICK_SEARCH'), //Quick Search
                    }, {
                        xtype: 'advancedsearchquerybuilder',
                        itemId: 'advancedSearchPanel',
                        searchConfigCode: CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE,
                        searchResultViewCode: CONSTANTS.CB.APPLICATION_LIST_VIEWCODE,
                        permissionMapKey: 'APPLICATION_PRIVILEGES',
                        gridTitle: getCommonTranslation("APPLICATION_LIST"),
                        moduleName: 'ADMISSION',
                        FPCONSTANTS: 'APPLICATION_PRIVILEGES'
                    }, {
                        xtype: 'applicationsuploaddownloadstructure',
                        itemId: 'applicationsuploaddownloadstructureId',
                        title: getTranslation('IMPORT_BULK_APPLICATION')
                    },]
                });

            } else if (newApplicationBulkImportTab) {
                panelItem.push({
                    xtype: 'tabpanel',
                    itemId: 'allVisibleTP',
                    plain: true,
                    style: {
                        overflow: 'hidden !important',
                        margin: '0!important'
                    },
                    frame: false,
                    border: false,
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'quicksearchpanel',
                        itemId: 'quickSearchPanel',
                        title: getAdmissionTranslation('QUICK_SEARCH'), //Quick Search
                    }, {
                        xtype: 'advancedsearchquerybuilder',
                        itemId: 'advancedSearchPanel',
                        searchConfigCode: CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE,
                        searchResultViewCode: CONSTANTS.CB.APPLICATION_LIST_VIEWCODE,
                        permissionMapKey: 'APPLICATION_PRIVILEGES',
                        gridTitle: getCommonTranslation("APPLICATION_LIST"),
                        moduleName: 'ADMISSION',
                        FPCONSTANTS: 'APPLICATION_PRIVILEGES'
                    }, {
                        xtype: 'applicationsnewuploaddownloadstructure',
                        itemId: 'applicationsnewuploaddownloadstructureId',
                        title: getTranslation('IMPORT_BULK_APPLICATION_NEW')
                    },]
                });

            } else {
                panelItem.push({
                    xtype: 'tabpanel',
                    itemId: 'allVisibleTP',
                    plain: true,
                    style: {
                        overflow: 'hidden !important',
                        margin: '0!important'
                    },
                    frame: false,
                    border: false,
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [{
                        xtype: 'quicksearchpanel',
                        itemId: 'quickSearchPanel',
                        title: getAdmissionTranslation('QUICK_SEARCH'), //Quick Search
                    }, {
                        xtype: 'advancedsearchquerybuilder',
                        itemId: 'advancedSearchPanel',
                        searchConfigCode: CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE,
                        searchResultViewCode: CONSTANTS.CB.APPLICATION_LIST_VIEWCODE,
                        permissionMapKey: 'APPLICATION_PRIVILEGES',
                        gridTitle: getCommonTranslation("APPLICATION_LIST"),
                        moduleName: 'ADMISSION',
                        FPCONSTANTS: 'APPLICATION_PRIVILEGES'
                    }]
                });

            }*/
            
            var panelItem = new Array();
            var $this = this;
            var newcont = structure.items.items.length;
            var insertPosition = newcont;
            panelItem.push({
                xtype: 'tabpanel',
                itemId: 'allVisibleTP',
                plain: true,
                style: {
                    overflow: 'hidden !important'
                },
                frame: false,
                border: false,
                flex: 1,
                items: [{
                    xtype: 'quicksearchpanel',
                    itemId: 'quickSearchPanel',
                    title: getAdmissionTranslation('QUICK_SEARCH'), //Quick Search
                    listeners: {
                    	activate: function(me, eOpts){
                    		setTimeout(function(){
                    			var  contentPanelMain = $this.getContentPanel().getActiveTab();
                        		if(!isNullOrEmpty(contentPanelMain)){
                        			contentPanelMain.scrollBy(0,2);
                        			contentPanelMain.scrollBy(0,-2);
                        		}
    						  },1);
                    	}
                    }
                },
               {
                    xtype: 'advancedsearchquerybuilder',
                    itemId: 'advancedSearchPanel',
                    searchConfigCode: CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE,
                    searchResultViewCode: CONSTANTS.CB.APPLICATION_LIST_VIEWCODE,
                    permissionMapKey: 'APPLICATION_PRIVILEGES',
                    gridTitle: getCommonTranslation("APPLICATION_LIST"),
                    moduleName: 'ADMISSION',
                    FPCONSTANTS: 'APPLICATION_PRIVILEGES'
                }]
            });

            var insertAt = panelItem["0"].items.length;
            if (applicationsBulkOfferStatusUpdateTab) {
                panelItem["0"].items[insertAt] = {
                    xtype: 'bulkofferstatusupdatestructure',
                    itemId: 'bulkofferstatusupdatestructureId',
                    title: getTranslation('BULK_OFFER_STATUS_UPDATE')

                };
                insertAt = insertAt + 1;
            }

            if (applicationsApplicationBulkDocumentDownloadTab){
            panelItem["0"].items[insertAt] = {
                    xtype: 'applicationbulkdownloadstatusstructure',
                    itemId: 'applicationbulkdownloadstatusstructureId',
                    title: getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_STATUS'),
                    listeners: {
                    	activate: function(me, eOpts){
                    		var  contentPanelMain = $this.getContentPanel().getActiveTab();
                    		if(!isNullOrEmpty(contentPanelMain)){
                    			contentPanelMain.scrollBy(0,1);
                    			contentPanelMain.scrollBy(0,-1);
                    		}
                    	}
                    }
                };
            insertAt = insertAt + 1;
            }

                panelItem["0"].items[insertAt] = {
                    xtype: 'importtabstructure',
                    itemId: 'importtabstructure',
                    title: getCommonTranslation('IMPORT')

                };
                insertAt = insertAt + 1;
           
            structure.insert(insertPosition, panelItem);
        },
        
        selectSectionMessageType : function(val,nV,oV){

        	 var $this =  this;
        	 var formWin = $this.getApplicantsendmessage();

        	 //var value = nV.1;
        	 formWin.down('#recieverTypeIncludeMySelf').setValue(false);
        	 if(nV.messageType==2){
        		 formWin.down("#messageId").hide();
        		 formWin.down("#selectTemplate").allowBlank=true;
        		 formWin.down("#selectTemplate").setVisible(false);     		 
        		 formWin.down("#messageName").allowBlank=true;   
        		 formWin.down("#messageName").setVisible(false);
        		 formWin.down("#msgTempletId").setVisible(true);
        		 formWin.down("#msgTempletId").allowBlank=false;
        		 formWin.down("#msgTempletId").reset();
        		 formWin.down("#subject").setVisible(true);
        		 formWin.down("#subject").allowBlank=false;
        		 formWin.down("#subject").reset();
        		 formWin.down("#discriptionId").setVisible(true);
        		 formWin.down("#discriptionId").reset();
        		 formWin.down('#smsDiscription').reset();
        		 formWin.down('#smsDiscription').hide();
        		 formWin.down('#smsDiscriptionNotice').hide();
        		 formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
        	 }else{
        		 formWin.down("#msgTempletId").allowBlank=true;
        		 formWin.down("#msgTempletId").setVisible(false);     		
        		 formWin.down("#messageId").setVisible(true);
        		 formWin.down("#selectTemplate").setVisible(true);     		
        		 formWin.down("#messageName").setVisible(true);
        		 formWin.down("#messageName").reset();
        		 formWin.down("#subject").allowBlank=true;
        		 formWin.down("#subject").setVisible(false);
        		 formWin.down("#discriptionId").setVisible(false);
        		 formWin.down("#messageName").allowBlank=false;  
        		 formWin.down("#selectTemplate").allowBlank=false;
        		 formWin.down("#selectTemplate").reset();
        		 formWin.down("#applicantDocumentMessageAttachmentGrid").setVisible(false);
        		 formWin.down("#staticUploadFileField").setVisible(false);
        		 formWin.down('#smsDiscription').reset();
        		 formWin.down('#smsDiscription').hide();
        		 formWin.down('#smsDiscriptionNotice').hide();
        		 formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
        		 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
        		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
        		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
        	 }
         },
         selectApplicantMessageTemp: function(obj,rec){
   	       	var $this =  this;
   	       	 var formWin = $this.getApplicantsendmessage();
   	       	 if(rec[0].data.value == "SMS")
   	       	 {
   	       	formWin.down("#templateId").setVisible(false);
       		formWin.down("#templateId").allowBlank=true;
   	       	Ext.Ajax.request({
    	   		type: 'rest',
    	   		async: false,
    	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
    	   		params: {
    	   			screenName: 'applicantsendmessage',
    	   			academyLocationId: this.getCurrentAcademyLocation(),
    	   			languageCode:'en'
    	   		},
    	   		method: 'GET',
    	   		success: function(res, action) {
    	   			var response = Ext.decode(res.responseText);
    	   			if( Object.keys(response).length > 0 ){
    	   				var records=response.applicantsendmessage;
    	   				for(i in records){
    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isVisible==true && records[i].isMandatory){
    	   						formWin.down("#templateId").setVisible(true);
    	   					}
    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true){
    	   						formWin.down("#templateId").allowBlank=false;
    	   					}
    	   					if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='templateId' && records[i].isMandatory==true && records[i].isVisible==false){
    	   						formWin.down("#templateId").allowBlank=true;
    	   					}
    	   					
    	   				}
    	   			}else{
    	   				formWin.down("#templateId").setVisible(true);
    	   				formWin.down("#templateId").allowBlank=false;
    	   			}
    	   		}
    	   		
    	   	});
   	       		 formWin.down("#subject").allowBlank=true;
   	       		 formWin.down("#subject").hide();
   	       		 formWin.down("#staticUploadFileField").hide();
   	       		 formWin.down("#applicantDocumentMessageAttachmentGrid").hide();
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#discriptionId').hide();	       		 
   	       		 formWin.down('#subject').reset();
   	       		 formWin.down('#smsDiscription').show();
   	       		 formWin.down('#smsDiscriptionNotice').show();
   	       	 }else
   	       	 {	formWin.down("#templateId").hide();
	       		formWin.down("#templateId").allowBlank=true;
   	       		 formWin.down('#discriptionId').reset();
   	       		 formWin.down('#smsDiscription').reset();
   	       		 formWin.down('#smsDiscription').hide();
   	       		 formWin.down('#smsDiscriptionNotice').hide();
   	       		 formWin.down("#staticUploadFileField").show();
   	       		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
   	       		 formWin.down("#applicantDocumentMessageAttachmentGrid").show();
   	       		 formWin.down('#subject').reset();
   	       		 formWin.down("#subject").show();
   	       		 formWin.down("#subject").allowBlank=false;
   	       		 formWin.down('#discriptionId').show();    		
   	       	 }
   	       },
   	       /**
   	        * upload static document file for Student
   	        */
   	       uploadApplicantStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
   	    	   var this$ = this;
   	    	   var setupForm = fileField.up('applicantsendmessage');
   	    	   var grid = setupForm.down('#applicantStaticDocumentAttachmentGridMessage');
   	    	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
   	    	   fileField.setRawValue(fileUploadPath);
   	    	   var file = fileField.fileInputEl.dom.files[0];
   	    	   var fileSizeLimit = '5';
	    	   var url = SERVERURL.FILE_PRIORITY;
	    	   Ext.Ajax.request({
					type: 'rest',
					url: url+'?type=emailFileSize',
					method: 'GET',
					success : function(response, action){
						var responseData = Ext.JSON.decode(response.responseText);
						if(responseData.length>0 && responseData[0].value!=undefined && !isNullOrEmpty(responseData[0].value))
						{
							fileSizeLimit=responseData[0].value;
						}
	    	   if((file.size / 1048576) <=  fileSizeLimit ){
   	    		   if(!isNullOrEmpty(fileUploadPath)){
   	    			   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
   	    			   if (extension == "gif" || extension == "png" || extension == "bmp"
   	    				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
   	    					   || extension == "doc" || extension == "docx" || extension == "txt"
   	    						   || extension == "xls" || extension == "csv" || extension == "xml" || extension == "zip" || extension == "xlsx") {
   	    				   var entityId = 'student';
   	    				   var module = 'messaging';
   	    				   var entityType = 'template';
   	    				   var documentType = 'DOCUMENT';
   	    				   var isTransient = true;
   	    				   this$.saveApplicantStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
   	    					   if(success){
   	    						   var path = Ext.JSON.decode(action.response.responseText).path;
   	    						   var user = this$.getCurrentlyLoggedInUser();
   	    						   var store = grid.getStore();
   	    						   var documentStatus = "SUBMITTED";
   	    						   var documentType = null;
   	    						   if(!isNullOrEmpty(path)){
   	    							   store.add({
   	    								   id: '',
   	    								   name: fileUploadPath,
   	    								   path: path ,
   	    								   createdBy : {
   	    									   id :user.id,
   	    									   value : user.value,
   	    									   code : user.code
   	    								   },
   	    								   status : documentStatus,
   	    								   documentType : documentType,
   	    								   templateConfigDocId: '',
   	    								   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

   	    							   });
   	    							   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
   	    							   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
   	    						   }

   	    						   fileField.reset();
   	    					   }

   	    				   }, isTransient);
   	    			   }else{
   	    				   fileField.reset();
   	    				   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
   	    			   }
   	    		   }
   	    	   }else{
   	    		   fileField.reset();
   	    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
   	    	   }
		   	   }
			   });
   	       },
   	       /**
   	        * Remove entry from grid
   	        */
   	       	deleteApplicantStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
   	    	   var grid = view.up('#applicantStaticDocumentAttachmentGridMessage');
   	    	   var panel = this.getContentPanel().getActiveTab();
   	    	   var tabTitle = panel.title;
   	    	   var store = grid.getStore();
   	    	   var templateConfigDocId = record.get('templateConfigDocId');
   	    	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
   	    	   if(!(tabTitle == viewTitle)){
   	    		   if(!isNullOrEmpty(templateConfigDocId)){
   	    			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
   	    				   if (btn == 'yes') {
   	    					   Ext.Ajax.request({
   	    						   type: 'rest',
   	    						   url: SERVERURL.STATIC_DOC_DELETE,
   	    						   method: 'DELETE',
   	    						   params: {
   	    							   templateConfigDocId : templateConfigDocId
   	    						   },
   	    						   headers: {
   	    							   'Content-Type': 'application/json'
   	    						   },
   	    						   success: function(form, action) {
   	    							   store.remove(record);
   	    							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
   	    						   }
   	    					   });
   	    				   }
   	    			   });

   	    		   }else{
   	    			   store.remove(record);
   	    			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
   	    		   }
   	    	   }else{
   	    		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
   	    	   }

   	       },
   	       /**
   	        * This method is to enable schedule field
   	        */
   	       loadApplicantScheduleField : function(radio,newValue, oldValue){
   	       	var adhocMessageForm = radio.up('form');
   	       	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
   	       	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
   	       	var radioValue = radio.getValue().sendingPriority;
   	       	
   	       	if(radioValue=='IMMEDIATE'){
   	       		scheduleDateField.setVisible(false);
   	       		scheduleDateField.setDisabled(true);
   	       		scheduleTimeField.setVisible(false);
   	       		scheduleTimeField.setDisabled(true);    		
   	       	}
   	       	else if(radioValue=='SCHEDULE'){
   	       		scheduleDateField.setVisible(true);
   	       		scheduleDateField.setDisabled(false);
   	       		scheduleTimeField.setVisible(true);
   	       		scheduleTimeField.setDisabled(false);
   	       	}
   	       },
   	       openApplicantSendMessage:function(obj){
   		    	//var grid = this.getSearchresultgrid();
   		    	var grid = obj.up('grid');
   		    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
   		    	if(grid.getSelectionModel().getCount()>0) {
   		    		
   		    			var $this=this;
   		    			var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
   		    	       	   var structure = Ext.widget('applicantsendmessage',{
   	               			itemId:'applicationSendMessageWindow',
   	               			//customGridId: grid.itemId
   	               		});
   		    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
   		    	       	   /**
   		    	       	    * This is to remove tab from content panel and open same tab again
   		    	       	    */
   		    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
   		    	       	   var getTab=getcontroller.getTab(tabName);
   		    	       	   if(getTab!=null){
   		    	       		   contentPanel.remove(getTab, true);
   		    	       	   }
   		    	       	var formWindowTab = $this.getApplicantsendmessage();
   		    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
   		    	       	formWindowTab.down("#selectTemplate").setVisible(false);
   		    	       	formWindowTab.down("#messageName").allowBlank=true;   
   		    	       	formWindowTab.down("#messageName").setVisible(false);
   		    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
   		    			templateStore.getProxy().extraParams={
   		    				msgRecipientTypeId:10
   		    			};
   		    			templateStore.load();
   		    			
   		    			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
   		    			   Ext.Ajax.request({
   		    				   method : "GET",
   		    				   type : 'rest',
   		    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=EnquirerTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
   		    				   headers : {
   		    					   'Content-Type' : 'application/json'
   		    				   },
   		    				   success : function(form,action) {
   		    					   var data = Ext.JSON.decode(form.responseText);
   		    					   formWindowTab.down("#id").setValue(data.id);
   		    					   formWindowTab.down("#code").setValue(data.code);
   		    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
   		    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
   		    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
   		    					   Ext.getBody().unmask();
   		    					   
   		    					   //grid.getStore().reload();
   		    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
   		    				   }

   		    			   });
   		    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
   		    	       	setTimeout(function(){
		    	       		formWindowTab.down("#templateId").setVisible(false);
						  },100);
   		    			/*if (!formWindow) {
   		    				Ext.widget('applicantsendmessage');
   		    				formWindow = $this.getApplicantsendmessage();
   		    			}
   		    			formWindow.show(;*/
   		    		
   		    	} else {
   		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
   		    	}
   		    },
   		    /**
   		        * save document file. It's external call method
   		        * @param entityId : person id, It's mandatory. 
   		        * @param module : module name, for student module 'student', It's mandatory.
   		        * @param entityType : entity type, It's mandatory.
   		        * @param documentType : document type, It's mandatory.
   		        * @param isTransient : true or false (send json back to module controller or not)
   		        * @param callBackFunction : callback function return in module controller. It's mandatory.
   		        */
   		    	saveApplicantStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
   		       	var submitUrl = '';
   		       	var templateTab = this.getContentPanel();
   		       	var formWin =  this.getApplicantsendmessage();
   		       	var form = formWin.down('#msgDetailsForm');
   		       	var id = form.down('#document_hidden_field');
   		           if (isNullOrEmpty(id.getSubmitValue())) {
   		               submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
   		           }
   		           var data = new Object();
   		           if(!isNullOrEmpty(entityId)){
   		           	data.entityId = entityId;
   		           }else{
   		           	data.entityId = null;
   		           }
   		           if(!isNullOrEmpty(module)){
   		           	data.module = module;
   		           }else{
   		           	data.module = null;
   		           }
   		           if(!isNullOrEmpty(entityType)){
   		           	data.entityType = entityType;
   		           }else{
   		           	data.entityType = null;
   		           }
   		           form.getForm().setValues(data);
   		           form.getForm().submit({
   		           	method : 'POST',
   		           	url : submitUrl,
   		           	success : function(form, action){
   		           		callBackFunction(true, action, isTransient);
   		           		
   		           	}
   		           });
   		       },
   		       /**
   		        * Add value to grid
   		        */
   		       loadGridWithFileNameMessage:function(grid,value,store){
   		    	   grid.bindStore(store);
   		       },
   		       isFrozenApplicant:function(isFrozen){
   		    	   var grid = this.getSearchResultGrid();
   		    	   if (grid.getSelectionModel().getCount() > 0) {
   		    		   var externalApplicant=[];
   		    		   var selectedRec = grid.getSelectionModel().getSelection();
   		    		   if(isFrozen){
   		    			   selectedRec.forEach(function(obj){
   		    				   externalApplicant.push({externalApplicantId:obj.get('EXTERNAL_USER_ID'), isFrozen: true});
   		    			   });
   		    		   }else{
   		    			   selectedRec.forEach(function(obj){
   		    				   externalApplicant.push({externalApplicantId:obj.get('EXTERNAL_USER_ID'), isFrozen: false});
   		    			   });
   		    		   }
   		    		   Ext.Ajax.request({
   		    			   method: "POST",
   		    			   type: 'rest',
   		    			   url: SERVERURL.PATH_FROZEN_APPLICANT,
   		    			   jsonData: Ext.encode(externalApplicant),
   		    			   success: function(response, action) {
   		    				   if(isFrozen){
   	   		    				   showSuccessMessage(getCommonTranslation('UPDATE_APPLICANT'), getCommonTranslation('APPLICANT_FROZEN_SUCCESS'));
   		    				   }else{
   	   		    				   showSuccessMessage(getCommonTranslation('UPDATE_APPLICANT'), getCommonTranslation('APPLICANT_UN_FROZEN_SUCCESS'));
   		    				   }
   		    			   }
   		    		   });
   		    	   } else {
   		    		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
   		    	   } 
   		       },
   		    
   		    /*Save Request Document Generate*/
   	        sendBulkDocumentGenerateDetail:function(obj){
   	        	var $this = this;
   	        	var grid = $this.getSearchResultGrid();
   	        	var bulkWin = $this.getBulkdownloaddocumentwin();
   	        	var bulkWinForm = bulkWin.down('form');
   	        	
   	        	var userId = bulkWin.down('#user_name').getValue();
   	        	//var applicationDocId = bulkWin.down('#applicationDocumentsId');
   	        	var fileNameFormat = bulkWin.down('#fileNameFormat').getValue().fileNameFormat;
   	        	var folderStructure = bulkWin.down('#folderStructure').getValue().folderStructure;
   	       
   	        	var selected = grid.selModel.getSelection();
   	        	var applicationIdArray = []; 
   	        	var applicationCodeArray = [];
   	        	var documentIdCodeArray = [];
   	        	if( selected.length > 0){
   	        		for( var i = 0; i < selected.length; i++) {
   	        			var applicant = new Object();
   	        			applicant.code = selected[i].data.APPLICATION_ID;
   	        			applicant.value = selected[i].data.APPLICATION_PERSON_PRINTNAME.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
   	        			applicant.id = selected[i].data.APPLICATION_PERSON_ID;
	        			
   	        			applicationIdArray.push(applicant);
   	        			//applicationCodeArray.push(selected[i].data.APPLICATION_ID);
   	        		}
   	        	var documentIds = bulkWin.down('#applicationDocumentsId').getValue();

   	        	if(documentIds.length > 0) {
   	        		for( var i = 0; i < documentIds.length; i++) {
   	        			var document = new Object();
	        			document.code = documentIds[i].data.documentName;
	        			document.value = documentIds[i].data.documentType;
	        			document.id = documentIds[i].data.id;
	        			documentIdCodeArray.push(document);	
   	        		}	
   	        	}		
   	        		var formData = {
   	        			"applicationIds":applicationIdArray,
        			    "documentIds":documentIdCodeArray,
   	        			"fileNameFormate":fileNameFormat,
   	        			"folderStructureBy":folderStructure,
   	        			"userId":userId,
   	        			"requestFor":"APPLICANT",
        		     	//"applicationCodes":applicationCodeArray
   	        		};  	        		
   	        		
   	        	}
   	        	//var formData = Ext.encode(bulkDocModel.data);
   	        	submitUrl = SERVERURL.PATH_SAVE_BULK_DOCUMENT_DOWNLOAD;
   	     		Ext.Ajax.request({
   	     			type : 'rest',
   	     			url : submitUrl,
   	     			jsonData : formData,
   	     			method : 'POST',
   	     			success : function(form, action) {
   	     				var res = form.responseText.split("@");
   	     				if( res.length > 1 && !isNullOrEmpty(res[1]) ){
   	     					var resultMsg = getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_MISSING')+":";
   	     					var prevMsg = getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST');
   	     					//showWarningMessage(getCommonTranslation('ALERT'),prevMsg + "<br/>" + resultMsg + res[1]);
   	     					
   	     					var alertWin = $this.getScrollablealertwindow();
   	     					if(!alertWin){
   	     						alertWin = Ext.widget('scrollablealertwindow');
   	     					}
   	     					alertWin.down('#feePlanAlert').setValue(prevMsg + "<br/><br/>" + resultMsg + "<br/>" + res[1] + "<br/>");
   	     					alertWin.show();
   	     					
   	     				} else {
   	     					showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'),getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST'));
   	     				}
   	     			}
   	     		});
   	     	obj.up('window').close();
   	     	//showSuccessMessage(getCommonTranslation('ENQUIRY_SUCCESS'),getCommonTranslation('BULK_DOCUMENT_DOWNLOAD_REQUEST'));
   	      },
   	      
   	  offerAcceptAndRejectLettreButtonPivileges: function(gridReference,permissionsMap) {
       	
   		  var associatedAcadLocationIds = new Array();
   		  associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
   		  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

   		  var acceptLetterButton = gridReference.down('#btnAcceptOfferItemId');
   		  acceptLetterButton.setVisible(false);

   		  var rejectLetterBtn = gridReference.down('#btnDeclineOfferItemId');
   		  rejectLetterBtn.setVisible(false);

   		  Ext.each(permissionList, function(privilege) {
   			  if (privilege === 'ACCEPT_OFFER') {
   				  if(!isNullOrEmpty(acceptLetterButton)){
   					  acceptLetterButton.setVisible(true);
   				  }        		
   			  }
   			  if (privilege === 'DECLINE_OFFER') {
   				  if(!isNullOrEmpty(rejectLetterBtn)){
   					  rejectLetterBtn.setVisible(true);
   				  }        		
   			  }
       	});
       },
       isVisibleOfferLetterAcceptAndDeclineOption:function(combo,permissionsMap){
    	   var associatedAcadLocationIds = new Array();
    	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	   var this$=this;
    	   this.removeStatusInDropDown(combo,'ACCEPT_OFFER_LETTER');
    	   this.removeStatusInDropDown(combo,'OFFER_LETTER_REJECTED');

    	   Ext.each(permissionList, function(privilege) {
    		   if (privilege === 'ACCEPT_OFFER_LETTER') {
    			   this$.addStatusInDropDown(combo,'ACCEPT_OFFER_LETTER','ACCEPT_OFFER_LETTER');
    		   }
    		   if (privilege === 'DECLINE_OFFER_LETTER') {
    			   this$.addStatusInDropDown(combo,'OFFER_LETTER_REJECTED','DECLINE_OFFER_LETTER');
    		   }
    	   });
       },
       /*issue offer letter*/
       isVisibleIssueOfferLetter:function(combo,permissionsMap){
    	   var associatedAcadLocationIds = new Array();
    	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	   var this$=this;
    	   this.removeStatusInDropDown(combo,'ISSUE_OFFER_LETTER');
    	   Ext.each(permissionList, function(privilege) {
    		   if (privilege === 'ISSUE_OFFER_LETTER') {
    			   this$.addStatusInDropDown(combo,'ISSUE_OFFER_LETTER','ISSUE_OFFER_LETTER');
    		   }
    	   });
       },

      addStatusInDropDown:function(combo,statusKey,statusValue){
    	   var statusTemp = combo.getStore().findRecord('name', statusKey);
			if(isEmpty(statusTemp)){
				combo.getStore().add({
					name: statusKey,
					value: getAdmissionTranslation(statusValue)
				});
				combo.getStore().commitChanges();	
			}
       },
       removeStatusInDropDown:function(combo,statusKey){
    	   var statusTemp = combo.getStore().findRecord('name', statusKey);
			if(statusTemp){
				combo.getStore().remove(statusTemp);
				combo.getStore().commitChanges();
			} 
       },
       /**
   	 * This method is used to get Ids for Student
   	 */
   	getEnquiryReceipientIdsForSendingMessages : function(grid){
   		
   		if (grid.getSelectionModel().getCount() > 0) {
   			var records = grid.getSelectionModel().getSelection();
   			var ids=[];
   			
   			for(var i in records) {
				if(!isNullOrEmpty(records[i].data.POPIA_STATUS)&&records[i].data.POPIA_STATUS=='Opt-In')
				{
   				ids.push(records[i].data.ID);
				}
   			}
   			/*Ext.Array.each(records,function(value){
   				for(var i in records) {
   					ids.push(records[i].data.ADMISSION_ID);
   				}
   				//ids.push(value.data.id);
   			});*/
   			/*if(grid.itemId == 'trackenquirygrid'){
   				for(var i in records) {
   					ids.push(records[i].data.ID);
   				}
   			}*//*else if(grid.itemId == 'facultySearchResultGrid'){
   				for(var i in records) {
   					ids.push(records[i].raw.ID);
   				}
   			}*/
   			
   		}
   		/*var records = grid.getSelectionModel().getSelection();
   		var ids = new Array();
   		for(var i in records.data.committeeParticipants) {
   			ids.push(records.data.committeeParticipants[i].id);
   		}
   */
   		/*if(grid.itemId === 'StudentSearchResultGrid'){
   				for(var i = 0 ; i<records.length;i++){
   					ids.push(records[i].raw.ADMISSION_ID);
   				}
   			}else if(grid.itemId === 'facultySearchResultGrid' ||grid.itemId === 'applicationsListGrid',grid.itemId ==='trackenquirygrid'){
   				for(var i = 0 ; i<records.length;i++){
   					ids.push(records[i].raw.ID);
   				}
   			}else if(grid.itemId === 'userSearchresultgrid'){
   				for(var i = 0 ; i<records.length;i++){
   					ids.push(records[i].raw.USER_ID);
   				}
   			}else{
   				for(var i = 0 ; i<records.length;i++){
   					ids.push(records[i].raw.ID);
   				}
   			}*/
   		return ids;
   	},
   	disableApplicationGridExtraButton:function(column,selected) {
    	var grid = this.getSearchResultGrid();
    	var addButtonItemId = grid.down('#searchResultGridBtnAdd');
    	var editButtonItemId = grid.down('#searchResultGridBtnEdit');
    	var viewButtonItemId = grid.down('#searchResultGridBtnView');
    	var deleteButtonItemId = grid.down('#searchResultGridBtnDelete');
    	var admissionApprovalDetailsItemId = grid.down('#admissionApprovalDetailsItemId');
    	var appDocumentRequest = grid.down('#documentRequest');
    	var applicationListAction = grid.down('#applicationListAction');
    	deleteButtonItemId.setDisabled(false);
    	grid.down('#reactivateApplicationItemId').setDisabled(true);
    	applicationListAction.setDisabled(false);
    	
    	grid.down('#printOfferLetterWordsItemId').setDisabled(true);
    	var counter = 0;
    	var paymentPendingCounter = 0;
    	var acdLocArr = [];
    	var isNullAL = false;
    	selected.forEach(function(obj){
    		var admissionstatus=obj.getData().APPLICATION_STATUS;
    		if(!isNullOrEmpty(admissionstatus)){
    			if(admissionstatus == 'ADMISSION_GRANTED'){
    				counter = counter+1;
    			}
    			if(admissionstatus == 'SOLD' || admissionstatus == 'DIRECT_SUBMISSION_TOKEN_GENERATED' 
            		|| admissionstatus == 'FORM_SALE_TOKEN_GENERATED' ){
    				paymentPendingCounter = paymentPendingCounter+1;
    			}
    		}
    		if(counter>0){
    			deleteButtonItemId.setDisabled(true);
    		}else{
    			deleteButtonItemId.setDisabled(false);
    		}
    		var alId=obj.getData().ACADEMY_LOCATION_ID;
    		if(!isNullOrEmpty(alId)){
    			if(acdLocArr.length==0) {
    				acdLocArr.push(alId);
    			}
    			if(!Ext.Array.contains(acdLocArr,alId)) {
    				acdLocArr.push(alId);
    			}
    		} else {
    			isNullAL = true;
    		}
    	});
    	
    	 var flag = false;
	     var flag1 = true;
	     var count=selected.length;
	    	if(count == 0){
	    		grid.down('#reassignescalationitemid').setDisabled(true);	
	    	//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
	    	}else{
	    	//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
    	selected.forEach(function(obj){
    		var offerStatus=obj.getData().PROGRAM_STATUS;
    		if(!isNullOrEmpty(offerStatus)){
    			if(offerStatus=='ESCALATED'||offerStatus=='Escalated' || offerStatus=='ESCALATION_AFTER_ACCEPTANCE'||offerStatus=='Escalation After Acceptance'){
					 flag = true;
					}
				else{
					flag1 = false;
     			}
				if(flag == true && flag1 == true){
				grid.down('#reassignescalationitemid').setDisabled(false);
				//grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
				}
				else{
				grid.down('#reassignescalationitemid').setDisabled(true);
			//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
				}
			
    		}
    			});
	    	}
    	         var flag = false;
    		     var flag1 = true;
    		     var count=selected.length;
    		    	if(count == 0){
    		    		grid.down('#expireOfferLetterItemId').setDisabled(true);
    		    	//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
    		    		
    		    	}else{
    	    	selected.forEach(function(obj){
    	    		var offerStatus=obj.getData().PROGRAM_STATUS;
    	    		var feeStatus=obj.getData().ADMISSION_COMMITMENT_FEE_STATUS;
    	    		var feeApplicable=obj.getData().ADMISSION_COMMITMENT_FEE_APPLICABLE;
    	    		if(!isNullOrEmpty(offerStatus && feeStatus && feeApplicable)){
    	    			if(offerStatus=='OFFER_LETTER_ACCEPTED' && feeStatus=='FULLY_PENDING' && feeApplicable=='Yes'){
    						 flag = true;
    						}
    					else{
    						flag1 = false;
    	     			}
    					if(flag == true && flag1 == true){
    					grid.down('#expireOfferLetterItemId').setDisabled(false);
    				//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
    					}
    					else{
    					grid.down('#expireOfferLetterItemId').setDisabled(true);
    				//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
    					}
    				
    	    		}
    	    			});
    		    	}     
    		    	                 
   	if(isNullAL==false && acdLocArr.length==1) {
    		appDocumentRequest.setDisabled(false);
    	} else {
    		appDocumentRequest.setDisabled(true);
    	}
    	var count=selected.length;
    	if(count> 1){ // enable
    		addButtonItemId.setDisabled(true);
    		editButtonItemId.setDisabled(true);
    		viewButtonItemId.setDisabled(true);
    		applicationListAction.setDisabled(false);
    		admissionApprovalDetailsItemId.setDisabled(true);
    		grid.down('#resetButtonItemId').setDisabled(true);
    		grid.down('#offerLetterDetailsItemId').setDisabled(true);
    		//grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
    		
    	}else{  // disable
    		addButtonItemId.setDisabled(false);
    		applicationListAction.setDisabled(true);
    		applicationListAction.reset();
    		editButtonItemId.setDisabled(false);
    		viewButtonItemId.setDisabled(true);
    		admissionApprovalDetailsItemId.setDisabled(false);
    	//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
    	}
    	grid.down('#reactivateApplicationItemId').setDisabled(true);
    	grid.down('#printOfferLetterWordsItemId').setDisabled(true);
    	if(count== 1){ // enable
    		addButtonItemId.setDisabled(true);
    		editButtonItemId.setDisabled(false);
    		viewButtonItemId.setDisabled(false);
    		applicationListAction.setDisabled(false);
    		grid.down('#offerLetterDetailsItemId').setDisabled(true);
    		grid.down('#admissionApprovalDetailsItemId').setDisabled(true);
    	//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
    		
    		
    		var externalUserId = selected[0].data.EXTERNAL_USER_ID;
			if (!isNullOrEmpty(externalUserId)) {
				grid.down('#resetButtonItemId').setDisabled(false);
			} else {
				grid.down('#resetButtonItemId').setDisabled(true);
			}
			
			if( selected[0].data.PROGRAM_STATUS == "OFFER_LETTER_ISSUED" || selected[0].data.PROGRAM_STATUS == "OFFER_LETTER_ACCEPTED" || selected[0].data.PROGRAM_STATUS == "PROVISIONAL_OFFER_ISSUED" ){
				if( selected[0].data.IS_OFFER_LETTER_APPLICABLE == 'Applicable' ){
					grid.down('#offerLetterDetailsItemId').setDisabled(false);
				}
			}
			
			if( selected[0].data.PROGRAM_STATUS == "OFFER_LETTER_DUE"){
		    		grid.down('#printOfferLetterWordsItemId').setDisabled(false);
			}
			
			if( selected[0].data.PROGRAM_STATUS == "OFFER_LETTER_ISSUED"){
	    		grid.down('#printOfferLetterWordsItemId').setDisabled(false);
			}
			
			if( selected[0].data.PROGRAM_STATUS == "OFFER_LETTER_ACCEPTED"){
	    		grid.down('#printOfferLetterWordsItemId').setDisabled(false);
			}
			
			if( selected[0].data.PROGRAM_STATUS == "ADMITTED"){
				if( selected[0].data.APPLICATION_CREATION_SOURCE == "Direct Admission" || selected[0].data.APPLICATION_CREATION_SOURCE == "" || selected[0].data.APPLICATION_CREATION_SOURCE == "Mid term admission" ){
					grid.down('#offerLetterDetailsItemId').setDisabled(true);
				} else {
					if( selected[0].data.IS_OFFER_LETTER_APPLICABLE == 'Applicable' ){
						grid.down('#offerLetterDetailsItemId').setDisabled(false);
					}
				}
			}
			
			if(selected[0].data.APPLICATION_STATUS == 'REJECTED' || selected[0].data.APPLICATION_STATUS == 'WITHDRAWN') {
				grid.down('#reactivateApplicationItemId').setDisabled(false);
			}
			
			if(selected[0].data.APPLICATION_STATUS == 'SUBMITED' || selected[0].data.PROGRAM_STATUS == "REJECTED"){
				grid.down('#reactivateApplicationItemId').setDisabled(false);
			}
			
			if((selected[0].data.ADMISSION_STATUS == 'ADMISSION_CONFIRMED' || selected[0].data.ADMISSION_STATUS == 'WITHDRAWN'
				|| selected[0].data.ADMISSION_STATUS == 'ADMITTED_PROVISIONALLY' || selected[0].data.ADMISSION_STATUS == 'ADMITTED_ON_TRIAL_BASIS'
				|| selected[0].data.ADMISSION_STATUS == 'WITHDRAW_AFTER_CONFIRMED' || selected[0].data.ADMISSION_STATUS == 'WITHDRAW_AFTER_ADMISSION'
				|| selected[0].data.ADMISSION_STATUS == 'WITHDRAW_AFTER_TRIAL' || selected[0].data.ADMISSION_STATUS == 'WITHDRAW_AFTER_PROVISION'
				|| selected[0].data.ADMISSION_STATUS == 'PROVISIONAL_ADMISSION_REJECTED' || selected[0].data.ADMISSION_STATUS == 'REJECTED'
				|| selected[0].data.ADMISSION_STATUS == 'ADMISSION_REJECTED' || selected[0].data.PROGRAM_STATUS == 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER' )
				||((selected[0].data.ADMISSION_VIEW_STATUS == 'Admission Declined' || selected[0].data.ADMISSION_VIEW_STATUS == 'Admission Rejected') 
						&& selected[0].data.PROGRAM_STATUS == 'REJECTED')) {
				grid.down('#admissionApprovalDetailsItemId').setDisabled(false);
			}
			grid.down('#pandaDocItemId').setDisabled(false);
    	}
    	else {
    		grid.down('#pandaDocItemId').setDisabled(true);
    	}
           var popiaflag = false;
           var popiaflag1 = true;         	                    
           var popiaStatusStore=Ext.getStore('common.PopiaStatusDropdownValue');
           var popiaValue;
           var popiaCode;
           if (popiaStatusStore.data.items[0] != null){
        	   		 popiaValue=popiaStatusStore.data.items[0].data.value;
        	   		 popiaCode=popiaStatusStore.data.items[0].data.code;
        	   }
			if(popiaValue!=null&&popiaValue=='Yes'&&popiaCode!=null&&popiaCode=='Application')
				{
				selected.forEach(function(obj){
		    		var PopiaStatus=obj.getData().POPIA_STATUS;
		    		var admissionStatus=obj.getData().ADMISSION_STATUS;
		    		if(!isNullOrEmpty(PopiaStatus)){
		    			if(PopiaStatus=='Opt-Out'){
		    				popiaflag=true;
		    			}
						else if(PopiaStatus=='Opt-In'){
							popiaflag1=false;    		        						
							}
		    	         	}
		    		if(popiaflag == true && popiaflag1 == true ){
		        		deleteButtonItemId.setDisabled(true);
		        		editButtonItemId.setDisabled(true);
    					}
    					else{
    						if(selected.length==1){
   		        	      	addButtonItemId.setDisabled(true);
   		        	     	editButtonItemId.setDisabled(false);
   		        		    viewButtonItemId.setDisabled(false);
   		        		    
						  } else if(selected.length>1)
							      { 
			     					if(popiaflag == true && popiaflag1 == false ){
			     		        		deleteButtonItemId.setDisabled(true);
			         					}
							        addButtonItemId.setDisabled(true);
				    		        editButtonItemId.setDisabled(true);
				    		        viewButtonItemId.setDisabled(true);
							       }else
							    	   {
						    		addButtonItemId.setDisabled(false);
						    		editButtonItemId.setDisabled(false);
						    		viewButtonItemId.setDisabled(true);
							    	   }
           					}
		    			});
				}
    	if(count>=1){
    		grid.down('#reviewApplicationItemId').setDisabled(false);
    		grid.down('#calculateExamAggregateItemId').setDisabled(false);
    		//grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
    	}else{
    		grid.down('#reviewApplicationItemId').setDisabled(true);
    		grid.down('#calculateExamAggregateItemId').setDisabled(true);
    	//	grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
    	}
       if(count>1){
    	   grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
       }
    	
       else{
    	   grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
       }
       if(count==1){
    	   grid.down('#raiseScholarshipApplicantRequestId').setDisabled(false);
       }
    	
       else{
    	   grid.down('#raiseScholarshipApplicantRequestId').setDisabled(true);
       }
    	if( paymentPendingCounter >= 1 && counter == 0 ){
    		this.toggleMoreActionButtonForApplicationPendingPayment(grid,false,false);
    		grid.down('#calculateExamAggregateItemId').setDisabled(true);
    	} 
    	if( paymentPendingCounter <= 0 && counter == 0 ){
    		this.toggleMoreActionButtonForApplicationPendingPayment(grid,false,true);
    	}
    	
    	var statusflag = false;
    	var programStatusflag = false;
    	var offerStatusflag = true;
    	if (selected.length === 0) {
    	    grid.down('#pendingOfferFlagItemId').setDisabled(true);
    	    return; // Exit function as no further checks are needed
    	}
    	selected.forEach(function(obj){
    		var admissionstatus=obj.getData().ADMISSION_STATUS;
    		var program=obj.getData().PROGRAM_NAME;
    		var offerStatus=obj.getData().OFFER_STATUS;
    		if(!isNullOrEmpty(program)){
    			programStatusflag = true;
    		}else{
    			grid.down('#markApplicationOffTrackItemId').setDisabled(true);
    		}
    		if(!isNullOrEmpty(admissionstatus)){
    			if(admissionstatus=='ADMISSION_CONFIRMED'){
    				statusflag = true;
				}
    		}else{
    			grid.down('#raisePriorityItemId').setDisabled(false);
    		}
    		if (!isNullOrEmpty(offerStatus)) {
    	        if (offerStatus !== 'Active' && offerStatus !== 'Offer Letter Due') {
    	            offerStatusflag = false; // If any record has a different status, set flag to false
    	        }
    	    } else {
    	        offerStatusflag = false;
    	    }
    	});
    	if(statusflag == true){
			grid.down('#raisePriorityItemId').setDisabled(true);
		}else{
			grid.down('#raisePriorityItemId').setDisabled(false);
		}
    	
    	if(programStatusflag == true){
			grid.down('#markApplicationOffTrackItemId').setDisabled(false);
		}else{
			grid.down('#markApplicationOffTrackItemId').setDisabled(true);
		}
    	
    	if (offerStatusflag) {
    	    grid.down('#pendingOfferFlagItemId').setDisabled(false); // Enable if all records match conditions
    	} else {
    	    grid.down('#pendingOfferFlagItemId').setDisabled(true);  // Disable otherwise
    	}
    },
    toggleMoreActionButtonForApplicationPendingPayment:function(grid, action, enableAll) {
    	
    	var sendSurveyBtn = grid.down('#sendSurveyBtn');
    	sendSurveyBtn.setDisabled(action);
    	
    	var reassignApplicatioinItemId = grid.down('#reassignApplicatioinItemId');
    	reassignApplicatioinItemId.setDisabled(action);
    	
    	var checkDuplicateNationalItemId = grid.down('#checkDuplicateNationalItemId');
    	checkDuplicateNationalItemId.setDisabled(action);
    	
    	var checkDuplicateEmailItemId = grid.down('#checkDuplicateEmailItemId');
    	checkDuplicateEmailItemId.setDisabled(action);
    	
    	var newAction = !action;
    	if( enableAll == true ){
    		var newAction = action;
    	}
    	
    	var resetButtonItemId = grid.down('#resetButtonItemId');
    	resetButtonItemId.setDisabled(newAction);
    	
    	var frozenItemId = grid.down('#frozenItemId');
    	frozenItemId.setDisabled(newAction);
    	
    	var unFrozenItemId = grid.down('#unFrozenItemId');
    	unFrozenItemId.setDisabled(newAction);
    	
    	var offerLetterDetailsItemId = grid.down('#offerLetterDetailsItemId');
    	offerLetterDetailsItemId.setDisabled(newAction);
    	
    	var preEligibilityItemId = grid.down('#preEligibilityItemId');
    	preEligibilityItemId.setDisabled(newAction);
    },
    deleteSelectedApplication:function(){
    	var $this=this;
    	var grid=$this.getSearchResultGrid();
    	
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var IdsArr = [];
    	selectionModel.forEach(function(obj){
    		IdsArr.push(obj.get('ID'));
    	});
    	if (IdsArr.length > 0) {
    		showConfirmMessage(getCommonTranslation('APPLICANTS_HEADER_MESSAGE'),getCommonTranslation('APPLICATION_DELETE_ALERT'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_APPLICATIONS_DELETE+'?applicationIds='+ IdsArr.join(),
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(response,action) {
    						Ext.getBody().unmask();
    						var record = Ext.decode(response.responseText);
    						if(record==true){
    							grid.getStore().reload();
    							showSuccessMessage(getCommonTranslation('APPLICANTS_HEADER_MESSAGE'),getCommonTranslation('PATH_APPLICATION_DELETE_SUCCESS_MSG'));	
    						}else{
    							showSuccessMessage(getCommonTranslation('APPLICANTS_HEADER_MESSAGE'),getCommonTranslation('PATH_APPLICATION_NOT_DELETE_MESSAGE'));
    						}


    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
   expireOfferLetter:function(){
    	var $this=this;
    	var grid=$this.getSearchResultGrid();
    	
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var IdsArr = [];
    	selectionModel.forEach(function(obj){
    		IdsArr.push(obj.get('APPLICATION_PROGRAM_ID'));
    	});
    	if (IdsArr.length > 0) {
    		showConfirmMessage(getCommonTranslation('EXPIRE_OFFER_LETTER'),getCommonTranslation('EXPIRE_OFFER_LETTER_ALERT_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    				Ext.Ajax.request({
    					method : "POST",
    					type : 'rest',
    					url : SERVERURL.PATH_OFFER_LETTER_EXPIRE_ON_FEE_CONDITION,
    					jsonData : IdsArr,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(response,action) {
    						Ext.getBody().unmask();
    						var record = Ext.decode(response.responseText);
    						if(record==true){
    							grid.getStore().reload();
    							showSuccessMessage(getCommonTranslation('EXPIRE_OFFER_LETTER'),getCommonTranslation('EXPIRE_OFFER_LETTER_SUCCESS_MSG'));	
    						}else{
    							showSuccessMessage(getCommonTranslation('EXPIRE_OFFER_LETTER'),getCommonTranslation('EXPIRE_OFFER_LETTER_UNSUCCESS_MSG'));
    						}


    					}
    				});
    			}
  		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    openApplicantOfferLetterDetailsPopup:function(btn){
    	var grid = this.getSearchResultGrid();
    	   if (grid.getSelectionModel().getCount() > 0) {
    		   
    		   var resetPswrdWindowItemId ="applicantofferletterdetailswindow";
               var resetPswrdFormWindow = Ext.widget('offerletterdetailswindow', {
                    itemId: resetPswrdWindowItemId
                });
               resetPswrdFormWindow.show();
               
                var me=this;
	           	var searchResultGrid=me.getSearchResultGrid();
	           	var record = searchResultGrid.getSelectionModel().getSelection()[0];
	           	if (!isEmpty(record)) {
	           		var applicationProgramId=record.get('APPLICATION_PROGRAM_ID');
	           		var offerLetterDetailsGrid = resetPswrdFormWindow.down('#offerLetterDetailsGrid');
	           		offerLetterDetailsGrid.getStore().removeAll();
		           	offerLetterDetailsGrid.getStore().getProxy().extraParams = {
	        			applicationProgramId: applicationProgramId
	        		};
		           	offerLetterDetailsGrid.getStore().load();
	           	}
               
    	   } else {
    		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	   }
    },
    openDocumentStatusPopup:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts,enquiryId){
    	//var grid = this.getSearchResultGrid();
    	var documentStatusPopupWindowItemId ="applicantdocumentstatuspopupwindow";
    	var documentStatusPopupWindow = Ext.widget('documentstatuswindow', {
    		itemId: documentStatusPopupWindowItemId
    	});
    	documentStatusPopupWindow.show();
    	
    	var documentStatusPopupWindowGrid = documentStatusPopupWindow.down('#documentStatusPopupGrid');
    	
    	documentStatusPopupWindowGrid.getStore().getProxy().extraParams={
			applicationId:record.get('ID')
		};
    	documentStatusPopupWindowGrid.getStore().load();

    	/*var me=this;
    	var searchResultGrid=me.getSearchResultGrid();
    	//var record = searchResultGrid.getSelectionModel().getSelection()[0];
    	if (!isEmpty(record)) {
    		var applicationProgramId=record.get('APPLICATION_PROGRAM_ID');
    		var offerLetterDetailsGrid = resetPswrdFormWindow.down('#offerLetterDetailsGrid');
    		offerLetterDetailsGrid.getStore().removeAll();
    		offerLetterDetailsGrid.getStore().getProxy().extraParams = {
    			applicationProgramId: applicationProgramId
    		};
    		offerLetterDetailsGrid.getStore().load();
    	}*/
    },
    openEligibilityPointerPopup:function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts,enquiryId){
    	var $this = this;
    	var formWindow = $this.getEligibilitypointerwindow();
    	
    	if (!formWindow) {
			formWindow = Ext.widget('eligibilitypointerwindow', {
		            itemId: 'applicanteligibilitypointerpopupwindow'
		        });
		}
		formWindow.show();
    	var documentStatusPopupWindowGrid = formWindow.down('#eligibilityPointerPopupGridItemId');
    	documentStatusPopupWindowGrid.getStore().getProxy().extraParams={
			applicationId:record.get('ID')
		};
    	documentStatusPopupWindowGrid.getStore().load();
	    $this.addDataGridConfigButton(documentStatusPopupWindowGrid, $this.getAPPLICATION_ELIGIBILITY_CALCULATION_DETAILS_PERMISSIONS());
    	
    },
    openApplicationListExportSelectWin: function() {
    	var $this = this;
    	var formWindow = $this.getApplicationlistexportreporwidow();
		if (!formWindow) {
			formWindow = Ext.widget('applicationlistexportreporwidow', {
		            itemId: 'applicationlistexportreporwidow'
		        });
		}
		formWindow.show();
    },
    openApplicationListExportAlSelectWin: function() {
    	var $this = this;
    	var formWindow = $this.getApplicationlistexportalwindow();
		if (!formWindow) {
			formWindow = Ext.widget('applicationlistexportalwindow', {
		            itemId: 'applicationlistexportalwindow'
		        });
		}
		formWindow.show();
    },
    getUserAccessibleAL:function(){
    	   var academyLocationId = [];
    	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
    	   for(var i=0; i<academyLocationList.length; i++){
    		   academyLocationId.push(academyLocationList[i].id);
    	   }
    	   return academyLocationId;
    },
    saveReviewersForApplications:function(obj){
    	var $this = this;
    	var grid = $this.getSearchResultGrid();

    	var form = $this.getApplicationreviewwindow().down('customform').getForm();
    	var reviewApplicationUsers = form.findField("reviewApplication").getValue();
    	$this.getApplicationreviewwindow().down('#ard_submitbuttonId').setDisabled(true);
    	var jsonData = [];
    	var selected = grid.selModel.getSelection();
    	if( selected.length > 0){
    		for( var i = 0; i < selected.length; i++) {
    			for(var j=0; j<reviewApplicationUsers.length; j++){
    				if(selected[i]!="" && reviewApplicationUsers[j]!=""){
    					jsonData.push({
    						"application":this.getIdValueJson(selected[i].data.ID),                 //application Id
    						"users" : this.getIdValueJson(reviewApplicationUsers[j].data.id)	
    						//User Id
    					});
    				}
    			}
    		}
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	submitUrl = SERVERURL.PATH_SAVE_ASSIGN_APPLICATION_REVIEWERS;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : jsonData,
    		method : 'POST',
    		success : function(form, action) {
    			Ext.getBody().unmask();
    			showSuccessMessage(getAdmissionTranslation('APPLICATION_REVIEW'),getAdmissionTranslation('APPLICATION_REVIEWER_ASSIGNED_SUCCESSFULLY'));
    			grid.getStore().reload();
    			obj.up('window').close();
    		}
    	});
    },
    getApplicationsIdFromMyApplications:function(data){
    	var myApplicationsId = [];
    	var applicationsIdFromEnquiry =[]
    	for(var i=0; i<data.length; i++){
    		applicationsIdFromEnquiry.push(data[i]);
    	}
    	var jsonObj = {
    			"userId":this.getCurrentlyLoggedInUser().id,
    			"applicationsId":applicationsIdFromEnquiry
    	}
    	submitUrl = SERVERURL.PATH_FIND_MY_APPLICATIONS_ID;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : jsonObj,
    		method : 'POST',
    		async: false,
    		success : function(res, action) {
    			var data = Ext.decode(res.responseText);
    			myApplicationsId=data;
    			return myApplicationsId;
    		}
    	});	
    	return myApplicationsId;
    },
    checkOfferLetterDfr: function(form,render){
	  	var $this = this;
	  	var status = false;
	  	var acceptAcceptOfferLetterButton = form.down("#acceptAcceptOfferLetterWinItemId");
	  	var isRegistrationContractCheckBox1 = form.down("#isRegistrationContractItemId");
		var isRegistrationContractCheckBox2 = form.down("#isRegistrationContract2ItemId");
		var offerLetterAcceptedBy = form.down("#offerLetterAcceptedBy");
		var offerLetterDisclaimer = form.down("#offerLetterDisclaimer");
		var offerLetterMessage2 = form.down("#offerLetterMessage2");
		var checkBoxValue1 = isRegistrationContractCheckBox1.getValue();
		var checkBoxValue2 = isRegistrationContractCheckBox2.getValue();
		if(render) {
			var checkBoxDefaultValue1 = null;
			var checkBoxDefaultValue2 = null;
			var isRegistrationContractFieldContainer = form.down("#isRegistrationContractFieldContainer");
			var isRegistrationContract2FieldContainer = form.down("#isRegistrationContract2FieldContainer");
			isRegistrationContract2FieldContainer.setVisible(false);
		}
		var checkBoxDfr1 = false;
		var checkBoxDfr2 = false;
		Ext.Ajax.request({
			type: 'rest',
			async: false,
			url: SERVERURL.COMMON_FORM_FIELD_INFO,
			params: {
				screenName: 'offerLetterAcceptanceForm',
				academyLocationId: this.getCurrentAcademyLocation(),
				languageCode:'en'
			},
			method: 'GET',
			success: function(res, action) {
				var response = Ext.decode(res.responseText);
				if( Object.keys(response).length > 0 ){
					var records=response.offerLetterAcceptanceForm;
					status = true;
					for(i in records){
						if(records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='isRegistrationContractItemId' && records[i].isVisible==true && records[i].isMandatory){
							checkBoxDfr1 = true;
							if(render) {
								isRegistrationContractFieldContainer.setVisible(true);
								checkBoxDefaultValue1 = records[i].defaultValue;
								
							}
						} else if(records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='isRegistrationContractItemId' && records[i].isVisible==false){
							if(render) {
								isRegistrationContractFieldContainer.setVisible(false);
								checkBoxDefaultValue1 = records[i].defaultValue;
							}
						} else if(records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='isRegistrationContract2ItemId' && records[i].isVisible==true){
							checkBoxDfr2 = true;
							if(render) {
								isRegistrationContract2FieldContainer.setVisible(true);
								checkBoxDefaultValue2 = records[i].defaultValue;
							}
						} else if(records[i].formFieldInputType=='checkboxfield' && records[i].formFieldId=='isRegistrationContract2ItemId' && records[i].isVisible==false){
							if(render) {
								isRegistrationContract2FieldContainer.setVisible(false);
								checkBoxDefaultValue2 = records[i].defaultValue;
							}
						}else if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='offerLetterAcceptedBy'){
							if (records[i].isMandatory) {
								offerLetterAcceptedBy.allowBlank = false;
								offerLetterAcceptedBy.setFieldLabel('');
								offerLetterAcceptedBy.labelSeparator = '';
								offerLetterAcceptedBy.setFieldLabel(getAdmissionTranslation('OFFER_LETTER_ACCEPTED_BY') + '<span class="required" style="color:red"> *</span>');
                            }else{
                            	offerLetterAcceptedBy.allowBlank = true;
                            }
                            if (records[i].isVisible) {
                            	offerLetterAcceptedBy.setVisible(true);
                            }else{
                            	offerLetterAcceptedBy.setVisible(false);
                            }	
						}else if(records[i].formFieldInputType=='displayfield' && records[i].formFieldId=='offerLetterDisclaimer'){
							 if (records[i].isVisible) {
								  offerLetterDisclaimer.setVisible(true);
	                         }else{
	                              offerLetterDisclaimer.setVisible(false);
	                         }
						}else if(records[i].formFieldInputType=='displayfield' && records[i].formFieldId=='offerLetterMessage2'){
							 if (records[i].isVisible) {
								   offerLetterMessage2.setVisible(true);
	                         }else{
	                               offerLetterMessage2.setVisible(false);
	                         }
						}
					}
					if(render) {
						if(checkBoxDefaultValue1!= null && checkBoxDefaultValue1!="") {
							var checkBoxDefaultValue1ToSmall = checkBoxDefaultValue1.toLocaleLowerCase();
							if(checkBoxDefaultValue1ToSmall=="true") {
								isRegistrationContractCheckBox1.setValue(true);
							}
							if(checkBoxDefaultValue1ToSmall=="false") {
								isRegistrationContractCheckBox1.setValue(false);
							}
						}
						if(checkBoxDefaultValue2!= null && checkBoxDefaultValue2!="") {
							var checkBoxDefaultValue2ToSmall = checkBoxDefaultValue2.toLocaleLowerCase();
							if(checkBoxDefaultValue2ToSmall=="true") {
								isRegistrationContractCheckBox2.setValue(true);
							}
							if(checkBoxDefaultValue2ToSmall=="false") {
								isRegistrationContractCheckBox2.setValue(false);
							}
						}
					}
					setTimeout(function() {
					if(checkBoxDfr1 && checkBoxDfr2) {
						if(checkBoxValue1 && checkBoxValue2) {
							if(form.isValid()){
								acceptAcceptOfferLetterButton.setDisabled(false);
							}
						}
						else {
							acceptAcceptOfferLetterButton.setDisabled(true);
						}
					} else if(checkBoxDfr1 && !checkBoxDfr2) {
						if(checkBoxValue1) {
							if(form.isValid()){
								acceptAcceptOfferLetterButton.setDisabled(false);
							}
						}
						else {
							acceptAcceptOfferLetterButton.setDisabled(true);
						}
					} else if(!checkBoxDfr1 && checkBoxDfr2) {
						if(checkBoxValue2) {
							if(form.isValid()){
								acceptAcceptOfferLetterButton.setDisabled(false);
							}
						}
						else {
							acceptAcceptOfferLetterButton.setDisabled(true);
						}
					} else {
						if(form.isValid()){
							acceptAcceptOfferLetterButton.setDisabled(false);
						}
					}
					},30); 
				}else if(checkBoxValue1) {
						status = true;
						if(form.isValid()){
							acceptAcceptOfferLetterButton.setDisabled(false);
						}
				  }	
			}
		});
		return status;
	 },
	//******************For Open Applicant Profile********************************************************
     openApplicantProfileFromFeeReportFromLink:function(applicationId,isView,searchResultGrid,record){
   	  if(searchResultGrid){
   		  var store=searchResultGrid.getStore();
   		  var tabTitle = null;
   		  var personId = null;
   		  var applicationId = null;
   		  var admissionId = null;
   		  var record = record;
   		  /*tabTitle = record.get('APPLICATION_ID');
   		  personId = record.get('APPL_PERSON_ID');
   		  applicationId = record.get('APPL_ID');
   		  admissionId = record.get('APPLICATION_ID');*/
   		  
   		  tabTitle = record.data.applicationCode;
		  personId = record.data.applicantPersonId;
		  applicationId = record.data.applicationId;
		  admissionId = record.data.applicationCode;

   		  var applicationBaseController =Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
   		  var me=applicationBaseController;
   		  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
   		  if(applicantProfile){
   			  me.getContentPanel().setActiveTab(applicantProfile);        			
   		  }else{
   			  me.addContentPanelTab(tabTitle, 'applicantprofile', null, personId,applicationId,admissionId);
   			  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
   			  if (applicantProfile) {            	
   				  me.setParameterForApplicantProfile(applicantProfile,record,'',isView);
   				  me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
   				  me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
   				  var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
   				  me.gettingDataInSummaryGrid(applicantProfile);    
   				  //me.getApplicantProfileInformation(applicantProfile);
   				  if(!isEmpty(applicantLinkPanelObject)){

   					  var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
   					  me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);

   					  var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
   					  me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);

   					  var personInfoPanel=applicantProfile.down("#personInfoPanel");
   					  if(personInfoPanel){
   						  var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
   						  if(applicantPersonalDetails){
   							  personInfoPanel.setActiveTab(applicantPersonalDetails);
   						  }        						
   					  }

   				  }

   			  }
   		  }    	        
   	  }                	
     },
     admCheckCommonDuplicateValue: function(obj){
			var $this=this;
        	var grid = null;
        	var viewCode = null;
        	var configCode = null;
        	var duplicateGrid = null;
        	var admissionGrid=obj.up('grid');
        	var duplicateEmailArray = new Array();
        	var duplicateNationaIdArray =  new Array();
        	
        	if(!admissionGrid.isHidden()){
        		grid=admissionGrid;
        		viewCode=CONSTANTS.CB.APPLICATION_LIST_VIEWCODE;
        		configCode=CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE;
        	}
        	var basicSearchForm = $this.getApplicationsListBasicSearchForm();
        	//var alId = basicSearchForm.down('#academyLocationCombo').getValue();
			var contentPanel = $this.getContentPanel(); // get hold of the  content panel where we are adding all the tabs
	       	   var structure = Ext.widget('duplicateapplicationdetails',{
       		});
	       	   var tabName = getAdmissionTranslation('DUPLICATE_APPLICATION_DETAILS');
	       	   
	       	  //Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'),'x-mask-loading');
			
	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
    	var duplicateAdmissionGrid=$this.getDuplicateapplicationdetails();
    	
    	duplicateAdmissionGrid.setVisible(false);
    	
    	if(!admissionGrid.isHidden()){
    		duplicateGrid=duplicateAdmissionGrid;
    	}
    	duplicateGrid.setVisible(true);
    	var searchResultGrid = duplicateGrid;
        
        	if(grid.getSelectionModel().getCount()>0) {
	    	
        	
        	var records=grid.getSelectionModel().getSelection();	
               if(records.length > 0) {
            	  Ext.each(records, function(recordData){
            		  if (!isNullOrEmpty(recordData.get("EMAIL"))) {
            			  duplicateEmailArray.push(recordData.get("EMAIL"));
					}
            		  if (!isNullOrEmpty(recordData.get("NATIONAL_ID"))) {
            			  duplicateNationaIdArray.push(recordData.get("NATIONAL_ID"));
					}
            	  })
               }
        	
        	
        	if(obj.itemId=="checkDuplicateEmailItemId"){
        		searchResultGrid.setTitle(getAdmissionTranslation('DUPLICATE_APPLICATION_EMAIL_DETAILS'));
        		var paramCodes = "EMAIL_ID";  
        		if ( duplicateEmailArray.length > 0) {
        			this.loadDataForDuplicateValue(paramCodes,duplicateEmailArray,viewCode,configCode,searchResultGrid);
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILL_EMAIL_ID'));
					return;
				}
        	}
        	if(obj.itemId=="checkDuplicateNationalItemId"){
        		searchResultGrid.setTitle(getAdmissionTranslation('DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS'));
        		var paramCodes = "NATIONAL_ID";  
        		if (duplicateNationaIdArray.length > 0) {
        			this.loadDataForDuplicateValue(paramCodes,duplicateNationaIdArray,viewCode,configCode,searchResultGrid);
				}else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILL_NATIONAL_ID'));
					return;
				} 
        	}
          }else{
        		//showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));// Please select a record
        		var code = 'EMAIL_ID';
        		searchResultGrid.setTitle(getAdmissionTranslation('DUPLICATE_APPLICATION_EMAIL_DETAILS'));
        		if(obj.itemId=="checkDuplicateNationalItemId"){
        			searchResultGrid.setTitle(getAdmissionTranslation('DUPLICATE_APPLICATION_NATIONAL_ID_DETAILS'));
        			code = 'NATIONAL_ID';
        		}
        		
        		var dataArray = $this.findDuplicateApplicationByEmailOrNationalId(code, basicSearchForm);
        		this.loadDataForDuplicateValue(code,dataArray,viewCode,configCode,searchResultGrid);
        	}
	 },
	 preEligibilityCheck:function(obj){
			var $this=this;
        	var grid = null;
        	var viewCode = null;
        	var configCode = null;
        	var duplicateGrid = null;
        	var admissionGrid=obj.up('grid');
        	var duplicateEmailArray = new Array();
        	var eligibility =  new Array();
        	 
        	if(!admissionGrid.isHidden()){
        		grid=admissionGrid;
        		viewCode=CONSTANTS.CB.APPLICATION_LIST_VIEWCODE;
        		configCode=CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE;
        	}
        	if(grid.getSelectionModel().getCount()>0) {
        		var records=grid.getSelectionModel().getSelection();	
                if(records.length > 0) {
             	  Ext.each(records, function(recordData){
             		  if (recordData.get("APPLICATION_PRIMERY_ID") != null && recordData.get("BATCH_ID") != null && recordData.get("APPLICATION_PERSON_ID") != null) {
             			 eligibility.push({id:recordData.get("APPLICATION_PRIMERY_ID"), batchId:recordData.get("BATCH_ID"),applicantPersonId:recordData.get("APPLICATION_PERSON_ID")});
 					}
             	  });
             	 Ext.Ajax.request({
	                  type: 'rest',
	                  url: SERVERURL.PATH_APPLICATION_ELIGIBILITY,
	                  jsonData: eligibility,
	                  async: false,
	                  method: 'POST',
	                  success: function(frm, action) {
	   						Ext.getBody().unmask();
	   		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	   		    			grid.getStore().reload();
	                  },
	                  failure: function(form, action) {
	                	  Ext.getBody().unmask();
	   					}
	              });
                }
        	}else{
        		Ext.getBody().unmask();
        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));// Please select a record
        	}
	 },
	 calculateExamAggregate:function(obj){
		 
		var $this=this;
     	var grid = null;
     	var viewCode = null;
     	var configCode = null;
     	var duplicateGrid = null;
     	var admissionGrid=obj.up('grid');
     	var applicationModel =  new Array();
     	var batchIds=new Array();
     	var applicationIds=new Array();
     	var applicantPersonIds=new Array();

     	 
     	if(!admissionGrid.isHidden()){
     		grid=admissionGrid;
     		viewCode=CONSTANTS.CB.APPLICATION_LIST_VIEWCODE;
     		configCode=CONSTANTS.CB.APPLICATION_LIST_CONFIGCODE;
     	}
     
     	if(grid.getSelectionModel().getCount()>0) {
     		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     		var records=grid.getSelectionModel().getSelection();	
             if(records.length > 0) {
          	  Ext.each(records, function(recordData){
          		  if (recordData.get("APPLICATION_PRIMERY_ID") != null && recordData.get("BATCH_ID") != null) {
          			applicationModel.push({id:recordData.get("APPLICATION_PRIMERY_ID"), batchId:recordData.get("BATCH_ID"),applicantPersonId:recordData.get("APPLICATION_PERSON_ID")});
          			batchIds.push(recordData.get("BATCH_ID"));
          			applicationIds.push(recordData.get("APPLICATION_PRIMERY_ID"));
          			applicantPersonIds.push(recordData.get("APPLICATION_PERSON_ID"));
					}
          });


          	 Ext.Ajax.request({
	                  type: 'rest',
	                  url: SERVERURL.PATH_APPLICATION_CALCULATE_AGGREGATE,
	                  jsonData:{"applicationModel":applicationModel,"batchIds":batchIds,"applicationIds":applicationIds,"applicantPersonIds":applicantPersonIds },
	                  async: false,
	                  method: 'POST',
	                  success: function(frm, action) {
	   						Ext.getBody().unmask();
	   		    			showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SUCCESS'));
	   		    			grid.getStore().reload();
	   		    			obj.up('window').close();
	                  },
	                  failure: function(form, action) {
	                	  Ext.getBody().unmask();
	   					}
	              });
             }
     	}else{
     		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));// Please select a record
     	}
	 },
	 
	 loadDataForDuplicateValue : function(paramCodes,searchData,viewCode,configCode,duplicategrid) {
	
     	var jsonFormatFormData = this.createJsonFormatForDuplicateValue(paramCodes,searchData,configCode);
     	var searchResultGrid = duplicategrid;
     	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
     	resultViewUrl = resultViewUrl.concat(viewCode);
     	searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
     },
     createJsonFormatForDuplicateValue:function(paramCodes,searchData,configCode){			
     	var basicForm = this.getBasicsearch();
     	var basicFormVal = basicForm.getValues();
     	var values = new Object();
     	values.configCode = configCode;
     	var searchcriteria = new Array();

     	if(searchData != "" && searchData != null){
     		//'se@gmail.com', 'sharma@f.com'
         		searchcriteria.push({paramCode:paramCodes, paramValues:searchData});
         	}
     	
     	if(!isNullOrEmpty(basicFormVal.ACAD_LOC_ID)){
     		searchcriteria.push({paramCode:'ACAD_LOC_ID', paramValues:[basicFormVal.ACAD_LOC_ID]});
     	}
     	if(!isNullOrEmpty(basicFormVal.ADMISSION_STATUS)){
     		searchcriteria.push({paramCode:'ADMISSION_STATUS', paramValues:[basicFormVal.ADMISSION_STATUS]});
     	}
     	if(!isNullOrEmpty(basicFormVal.ALTERNATE_EMAIL_ID)){
     		searchcriteria.push({paramCode:'ALTERNATE_EMAIL_ID', paramValues:[basicFormVal.ALTERNATE_EMAIL_ID]});
     	}
     	if(!isNullOrEmpty(basicFormVal.APPICANT_PRINT_NAME)){
     		searchcriteria.push({paramCode:'APPICANT_PRINT_NAME', paramValues:[basicFormVal.APPICANT_PRINT_NAME]});
     	}
     	if(!isNullOrEmpty(basicFormVal.APPLICATION_ID)){
     		searchcriteria.push({paramCode:'APPLICATION_ID', paramValues:[basicFormVal.APPLICATION_ID]});
     	}
     	if(!isNullOrEmpty(basicFormVal.APPLICATION_STATUS)){
     		searchcriteria.push({paramCode:'APPLICATION_STATUS', paramValues:[basicFormVal.APPLICATION_STATUS]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.BATCH)){
     		searchcriteria.push({paramCode:'BATCH', paramValues:[basicFormVal.BATCH]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.COUNTRY_ID)){
     		searchcriteria.push({paramCode:'COUNTRY_ID', paramValues:[basicFormVal.COUNTRY_ID]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.EMAIL_ID)){
     		searchcriteria.push({paramCode:'EMAIL_ID', paramValues:[basicFormVal.EMAIL_ID]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.END_DATE)){
     		searchcriteria.push({paramCode:'END_DATE', paramValues:[basicFormVal.END_DATE]});
     	}
     	if(!isNullOrEmpty(basicFormVal.ENQUIRY_NO)){
     		searchcriteria.push({paramCode:'ENQUIRY_NO', paramValues:[basicFormVal.ENQUIRY_NO]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.MOBILE_NO)){
     		searchcriteria.push({paramCode:'MOBILE_NO', paramValues:[basicFormVal.MOBILE_NO]});
     	} 
     	
     	if(!isNullOrEmpty(basicFormVal.PROGRAM)){
     		searchcriteria.push({paramCode:'PROGRAM', paramValues:[basicFormVal.PROGRAM]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.PROGRAM_GROUP)){
     		searchcriteria.push({paramCode:'PROGRAM_GROUP', paramValues:[basicFormVal.PROGRAM_GROUP]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.PROGRAM_STATUS)){
     		searchcriteria.push({paramCode:'PROGRAM_STATUS', paramValues:[basicFormVal.PROGRAM_STATUS]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.REGISTRATION_TYPE)){
     		var registrationType = true;
     		if (basicFormVal.REGISTRATION_TYPE == 'FULL_TIME') {
     			registrationType = false;
			}
     		searchcriteria.push({paramCode:'REGISTRATION_TYPE', paramValues:[registrationType]});
     	}
     	if(!isNullOrEmpty(basicFormVal.SELECTION_PROCESS)){
     		searchcriteria.push({paramCode:'SELECTION_PROCESS', paramValues:[basicFormVal.SELECTION_PROCESS]});
     	}
     	if(!isNullOrEmpty(basicFormVal.SELECTION_PROCESS_STAGE)){
     		searchcriteria.push({paramCode:'SELECTION_PROCESS_STAGE', paramValues:[basicFormVal.SELECTION_PROCESS_STAGE]});
     	}
     	if(!isNullOrEmpty(basicFormVal.STAGE_FEE_APPLICABLE)){
     		searchcriteria.push({paramCode:'STAGE_FEE_APPLICABLE', paramValues:[basicFormVal.STAGE_FEE_APPLICABLE]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.STAGE_FEE_STATUS)){
     		searchcriteria.push({paramCode:'STAGE_FEE_STATUS', paramValues:[basicFormVal.STAGE_FEE_STATUS]});
     	}
     	if(!isNullOrEmpty(basicFormVal.STAGE_STATUS)){
     		searchcriteria.push({paramCode:'STAGE_STATUS', paramValues:[basicFormVal.STAGE_STATUS]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.START_DATE)){
     		searchcriteria.push({paramCode:'START_DATE', paramValues:[basicFormVal.START_DATE]});
     	}
     	if(!isNullOrEmpty(basicFormVal.applicantModeOfEnquiry)){
     		jsonFormatFormData.searchCriterias.push({paramCode:'APPLICATION_PRIMERY_ID', paramValues:[basicFormVal.applicantModeOfEnquiry]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.applicationOwner)){
     		jsonFormatFormData.searchCriterias.push({paramCode:'APPLICATION_OWNER_ID', paramValues:[basicFormVal.applicationOwner]});
     	} 
     	if(!isNullOrEmpty(basicFormVal.intakeYear)){
     		searchcriteria.push({paramCode:'intakeYear', paramValues:[basicFormVal.intakeYear]});
     	} 
     	/*if(!isNullOrEmpty(basicFormVal.showApplications)){
     		searchcriteria.push({paramCode:'showApplications', paramValues:[basicFormVal.showApplications]});
     	}*/

         	values.searchCriterias=searchcriteria;
         	return values;
         },
         showEnquiryFormFromLink: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
     	  var grid = grid.ownerCt;
     	  var $this = this;
     	  var enquiryId;
     	  var columnName=grid.columnManager.columns[cellIndex].dataIndex;
     	  if(e.target.tagName=="A"){     		 
     		  if(columnName=='ENQUIRY_ID' ){
     				var enquiryCode='';
    	  			enquiryCode = record.data.ENQUIRY_ID;
    	  			 Ext.Ajax.request({
   	                  type: 'rest',
   	                  async: false,
   	                  url: SERVERURL.FIND_DETAILS_BY_ENQUIRYCODE+"?code="+enquiryCode,
   	                  method: 'GET',
   	                  success: function(frm, action) {
   	                      var response = Ext.JSON.decode(frm.responseText);
   	                      enquiryId = response;
   	                  }
   	              });
     			$this.showEnquiryFromActualEnquiryTarget(grid,td, cellIndex, record, tr, rowIndex, e, eOpts,enquiryId);
     		  }
     		  if(columnName=='APPLICANT_DOCUMENT_STATUS' ){
     			 $this.openDocumentStatusPopup(grid,td, cellIndex, record, tr, rowIndex, e, eOpts,enquiryId);
     		  }
     		 if(columnName=='ELIGIBILITY_POINTER' ){
     			 $this.openEligibilityPointerPopup(grid,td, cellIndex, record, tr, rowIndex, e, eOpts,enquiryId);
     		  }
     	  }     	 
       },
       showEnquiryFromActualEnquiryTarget: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts,enquiryId) {
    	    var getController = Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
    	  	Academia.app.getController('Academia.controller.enquiry.EnquiryRevampController');
    		Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController');
    		Academia.app.getController('Academia.controller.enquiry.student.StudentDetailRevampController');
    	         	  			
    	  			var MyJson ={"configCode":"TRACK_ENQUIRY_ADMISSION",
    						  "searchCriterias":[{
    							  "paramCode":"ENQUIRY_NO",
    							  "paramValues":[enquiryId]},
    							  {"paramCode":"WHETHER_DELETED","paramValues":[false]}
    						  ]}
    	  			  Ext.Ajax.request({
    	                  type: 'rest',
    	                  url: SERVERURL.EXECUTEBASICSEARCH+"?page=1&start=0&limit=25",
    	                  jsonData: MyJson,
    	                  async: false,
    	                  method: 'POST',
    	                  success: function(frm, action) {
    	                      var data = Ext.JSON.decode(frm.responseText);
    	                      getController.linkClicked(0,0,grid,'Edit',true,data);
    	                  }
    	              });
    	  			
    	    },
       linkClicked : function(view,rowIndex,grid,buttonId,enquiryCode){
          
    	    var code = '';
    	    code = enquiryCode;
       		Academia.app.getController('Academia.controller.enquiry.EnquiryController');
          	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
          	Academia.app.getController('Academia.controller.enquiry.student.StudentDetailController');
          	Academia.app.getController('Academia.controller.enquiry.exam.ExamDetailController');
          	Academia.app.getController('Academia.controller.enquiry.admission.AdmissionReqmntDetailController');
          	Academia.app.getController('Academia.controller.enquiry.followup.FollowUpDetailController');
          	Academia.app.getController('Academia.controller.enquiry.closure.ClosureDetailController');
          	Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailRevampController');
          	
          	var $this = this;
          	var tabName = getEnquiryTranslation('ENQUIRY_DETAILS');
          	var getcontroller = $this.getController('menu.CoreERPNavigationController');
          	var contentpanel = $this.getContentPanel();
          	var getTab = getcontroller.getTab(tabName);
          	/*if (getTab != null) {
          		contentpanel.remove(getTab, true);
          	}*/
          	var val = '';
          	if(grid.getSelectionModel().getCount()>0){
             
          		var tabStructure1 = Ext.ComponentQuery.query("enquirytabstructure")[0];
          		if (!tabStructure1) {
          			tabStructure1 = Ext.widget('enquirytabstructure');
          		}
          		var tabStructure = tabStructure1.getForm();
          		var status = val.TRACK_ENQUIRY_STATUS;
          		
          		if(val.TRACK_ENQUIRY_STATUS!="Open"){
          			if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
          				tabStructure.findField("enquiryId").setVisible(true);
          				tabStructure.findField("enquiryId").reset();
          				
          				if(val.TRACK_ENQUIRY_NO!=null && val.TRACK_ENQUIRY_NO!=undefined){
          				  tabStructure.findField("enquiryId").setValue(val.TRACK_ENQUIRY_NO);
          				}else{
          					 tabStructure.findField("enquiryId").setValue(val.id);
          				}
          			}
          			if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
          				tabStructure.findField("enquiryTxtId").reset();
          				tabStructure.findField("enquiryTxtId").setVisible(false);
          			}
          		}else{
          			if(!isNullOrEmpty(tabStructure.findField("enquiryTxtId"))){
          				tabStructure.findField("enquiryTxtId").setVisible(true);
          				tabStructure.findField("enquiryTxtId").reset();
          				tabStructure.findField("enquiryTxtId").setValue(val.TRACK_ENQUIRY_NO);
          			}
          			if(!isNullOrEmpty(tabStructure.findField("enquiryId"))){
          				tabStructure.findField("enquiryId").reset();
          				tabStructure.findField("enquiryId").setVisible(false);
          			}
          		}
          		
          		if(val.ID!=null && val.ID!=undefined ){
          		  tabStructure.findField("enqId").setValue(val.ID);
          		}else{
          			tabStructure.findField("enqId").setValue(val.id);
          		}
          		if(val.ENQUIRY_TYPE!=undefined){
          			if(val.ENQUIRY_TYPE_NAME!=null && val.ENQUIRY_TYPE_NAME!=""){
          				tabStructure.findField("enqTypes").setValue(val.ENQUIRY_TYPE_NAME);
          			}
          		}else{
          			tabStructure.findField("enqTypes").setValue(val.enqTypes);
          		}
          		tabStructure.findField("buttonType").setValue(buttonId);
          		var enquiryAdmissioUrl=null;
          		if(val.STUDENT_DETAIL_ID>0){
          			tabStructure.findField("studentDetailId").setValue(val.STUDENT_DETAIL_ID);
          		}
          		var coursetabstructure = Ext.widget('enquirytabstructure');
          		
          		if(val.ENQUIRY_TYPE != getEnquiryTranslation('CNTRL_ADMISSION')){
          			
          			/**
          			 * Hide closure follow up grid in follow up detail tab.
          			 */
          			/*var closureFollowupgrid=$this.getClosurefollowupgrid();
          			if(closureFollowupgrid != undefined && closureFollowupgrid != null){
          				closureFollowupgrid.setVisible(false);
          			}*/
          		}
          		openTab(contentpanel,tabName, coursetabstructure,CONSTANTS.MENU_COLOR_FOUR);
          	
              			Ext.Ajax.request({
                              type : 'rest',
                              url : SERVERURL.FIND_DETAILS_BY_ENQUIRYCODE+'?code='+code,
                              method : 'GET',
                              success : function(form, action) {
                              var data = Ext.JSON.decode(form.responseText);
                              	if(!isNullOrEmpty(data)){
                              		
                              		var assignToId = Ext.ComponentQuery.query('displayfield[itemId=assignToId]')[0];
                              		if(!isNullOrEmpty(data.user)){
                              			assignToId.setVisible(true);
                              			assignToId.reset();
                              			assignToId.setValue(data.user.value);
                              		} else {
                              			assignToId.setVisible(true);
                              			assignToId.reset();
                              			assignToId.setValue("<span style=\'color:red\'>Unassigned<span/>");
                              		}
                              	
                              		
                              		var intermediateStage = Ext.ComponentQuery.query('displayfield[itemId=enqtab_intermediateStage]')[0];
                              		if(!isNullOrEmpty(data.enqIntermediateType)){ 
                              			intermediateStage.setValue(data.enqIntermediateType.value); 
                              		} 

                              		var intermediateStageId = Ext.ComponentQuery.query('hidden[itemId=enqtab_intermediateStageId]')[0];
                              		intermediateStageId.setValue(data.enqIntermediateType.id);

                              		var myTextField = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryStatus]')[0];
                              		if(data.status=='O'){
                              		   myTextField.setValue("Open");
                              		   var myText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
                 	            		if(!isNullOrEmpty(myText)){
                 	            			myText.setVisible(true);
                 	            			myText.reset();
                 	            			myText.setValue(val.code);
                 	            		}
                 	            		var myedtText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
                 	            		if(!isNullOrEmpty(myedtText)){
                 	            			myedtText.reset();
                 	            			myedtText.setVisible(false);
                 	            		}
                              		}else{
                              			myTextField.setValue("Closed");
                              			var myText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
                  	            		if(!isNullOrEmpty(myText)){
                  	            			myText.setVisible(true);
                  	            			myText.reset();
                  	            			myText.setValue(val.code);
                  	            		}
                  	            		var myedtText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
                  	            		if(!isNullOrEmpty(myedtText)){
                  	            			myedtText.reset();
                  	            			myedtText.setVisible(false);
                  	            		}
                              			
                              		}
                              		if(!isNullOrEmpty(data.enquiryPriority)){
                              		  var priorityField = Ext.ComponentQuery.query('displayfield[itemId=dispalyPriority]')[0];
                              		  priorityField.setValue(data.enquiryPriority.value);
                              		

                              		var priorityIdField = Ext.ComponentQuery.query('hidden[itemId=dispalyPriorityId]')[0];
                              		priorityIdField.setValue(data.enquiryPriority.id);
                              		}

                              		var studentName = Ext.ComponentQuery.query('displayfield[itemId=displayStudentName]')[0];
                              		if(data.enquiryStudentDetails.length!=0){ 
                              			studentName.setValue(data.enquiryStudentDetails[0].studentFirstName+" "+data.enquiryStudentDetails[0].studentLastName); 
                              		} 
                              		var parentName=Ext.ComponentQuery.query('displayfield[itemId=displayParentName]')[0];
                              		if(!isNullOrEmpty(data.firstName)){ 
                              			parentName.setValue(data.firstName+" "+data.lastName); 
                              		} 
                              		if(!isNullOrEmpty(data.enquiryType)) {
                              	       tabStructure.findField("enqTypes").setValue(data.enquiryType.code);
                              		}
                              		if(data.enquiryStudentDetails.length!=0){
                              		   tabStructure.findField("studentDetailId").setValue(data.enquiryStudentDetails[0].id);
                              		   val.STUDENT_DETAIL_ID=data.enquiryStudentDetails[0].id;
                              		}else{
                              			val.STUDENT_DETAIL_ID=0;
                              		}
                              		
                              		Ext.Ajax.request({
                                          type : 'rest',
                                          url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+val.STUDENT_DETAIL_ID,
                                          method : 'GET',
                                          success : function(form, action) {
                                          var data = Ext.JSON.decode(form.responseText);
                                          	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
                                          	if(!isNullOrEmpty(data[0])){
                                          		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
                                          			programIntake.setValue(data[0].programIntakeCombo); 
                                          		}
                                          	}
                                          }
                                      });
                              		
                              	}
                              }
                          });
              			
          		if(val.TRACK_ENQUIRY_STATUS!="Open"){
              		var myText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
              		if(!isNullOrEmpty(myText)){
              			myText.setVisible(true);
              			myText.reset();
              			myText.setValue(val.TRACK_ENQUIRY_NO);
              		}
              		var myedtText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
              		if(!isNullOrEmpty(myedtText)){
              			myedtText.reset();
              			myedtText.setVisible(false);
              		}
          		}else{
          			var myText = Ext.ComponentQuery.query('textfield[itemId=enquiryTxtId]')[0];
              		if(!isNullOrEmpty(myText)){
              			myText.setVisible(true);
              			myText.reset();
              			myText.setValue(val.TRACK_ENQUIRY_NO);
              		}
              		var myedtText = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryId]')[0];
              		if(!isNullOrEmpty(myedtText)){
              			myedtText.reset();
              			myedtText.setVisible(false);
              		}
          		}
          	/*	var form = Ext.getCmp('followUpDetailFormId');
          		if(val.TRACK_ENQUIRY_STATUS!="Open"){
          			form.down('#followdetail_submitbuttonId').setVisible(false);
          		}*/
          	
          		var assignToId = Ext.ComponentQuery.query('displayfield[itemId=assignToId]')[0];
          		if(!isNullOrEmpty(val.ASSIGN_TO_ID)){
          			assignToId.setVisible(true);
          			assignToId.reset();
          			assignToId.setValue(val.ENQUIRY_OWNER);
          		} else if(!isNullOrEmpty(val.ASSIN_TO)){
          			assignToId.setVisible(true);
          			assignToId.reset();
          			assignToId.setValue(val.ASSIN_TO);
          		} else {
          			assignToId.setVisible(true);
          			assignToId.reset();
          			assignToId.setValue("<span style=\'color:red\'>Unassigned<span/>");
          		}
          		var studentName = Ext.ComponentQuery.query('displayfield[itemId=displayStudentName]')[0];
          		if(!isNullOrEmpty(val.PROSPECTIVE_STUDENT_NAME)){ 
          			studentName.setValue(val.PROSPECTIVE_STUDENT_NAME); 
          		} else if(!isNullOrEmpty(val.STUDENT_FULL_NAME)){
          			studentName.setValue(val.STUDENT_FULL_NAME);
          		}

          		var parentName=Ext.ComponentQuery.query('displayfield[itemId=displayParentName]')[0];
          		if(!isNullOrEmpty(val.ENQUIRER_FIRST_NAME)){ 
          			parentName.setValue(val.ENQUIRER_FIRST_NAME); 
          		} else if(!isNullOrEmpty(val.ENQUIRER_NAME)){
          			parentName.setValue(val.ENQUIRER_NAME);
          		} 
          		
          		if(isNullOrEmpty(val.STUDENT_DETAIL_ID)){
          			val.STUDENT_DETAIL_ID = 0;
          		}
          		Ext.Ajax.request({
                      type : 'rest',
                      url : SERVERURL.ENQUIRY_ADMISSION_FIND_BY_ID+'?id='+val.STUDENT_DETAIL_ID,
                      method : 'GET',
                      success : function(form, action) {
                      var data = Ext.JSON.decode(form.responseText);
                      	var programIntake=Ext.ComponentQuery.query('displayfield[itemId=displayGradeIntakeYear]')[0];
                      	if(!isNullOrEmpty(data[0])){
                      		if(!isNullOrEmpty(data[0].programIntakeCombo)){ 
                      			programIntake.setValue(data[0].programIntakeCombo); 
                      		}
                      	}
                      }
                  });

          		
          		var intermediateStage = Ext.ComponentQuery.query('displayfield[itemId=enqtab_intermediateStage]')[0];
          		if(!isNullOrEmpty(val.ENQ_STAGE)){ 
          			intermediateStage.setValue(val.ENQ_STAGE); 
          		} else{
          			if(!isNullOrEmpty(val.ENQ_INTERMEDIATE_STAGE)){ 
          				intermediateStage.setValue(val.ENQ_INTERMEDIATE_STAGE); 
          			} }

          		var intermediateStageId = Ext.ComponentQuery.query('hidden[itemId=enqtab_intermediateStageId]')[0];
          		intermediateStageId.setValue(val.ENQ_INTERMEDIATE_ID);

          		var myTextField = Ext.ComponentQuery.query('displayfield[itemId=dispalyEnquiryStatus]')[0];
          		myTextField.setValue(status);

          		var priorityField = Ext.ComponentQuery.query('displayfield[itemId=dispalyPriority]')[0];
          		priorityField.setValue(val.ENQUIRY_PRIORITY);

          		var priorityIdField = Ext.ComponentQuery.query('hidden[itemId=dispalyPriorityId]')[0];
          		priorityIdField.setValue(val.ENQUIRY_PRIORITY_ID);
          	}else{
          		showWarningMessage(getCommonTranslation('ENQUIRY_TITLE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
          	}
          	if(buttonId === "Edit" && grid.getSelectionModel().getCount()>0){
          		coursetabstructure.down('button[itemId=enquirydetail_EditButtonId]').setVisible(false);
          		coursetabstructure.down('button[itemId=studentdetail_cancelbuttonId]').setVisible(false);
          	}
          },
          openTab: function(tabTitle, contentXType, menuColorcls,contentPanel) {
        	var baseController =  Academia.app.getController('Academia.controller.base.BaseController');
        	baseController.openTab(tabTitle, contentXType, menuColorcls,contentPanel);
          },
       getTrackEnquiryController:function(){
     	  return this.getController('enquiry.TrackEnquiryController');
       },
       findDuplicateApplicationByEmailOrNationalId:function(code, basicSearchForm){
    	   var values = basicSearchForm.getValues();
    	   var selectionProcessStage = values.SELECTION_PROCESS_STAGE;
    	   var applicationStatusVal = values.APPLICATION_STATUS;
    	  if(!isNullOrEmpty(values.BATCH)){
    		 var  batchVal = values.BATCH;
    	  }else{
    		 var batchVal = '';  
    	  }
    	  if(!isNullOrEmpty(values.SEAT_TYPE)){
    		 var seatTypeVal = values.SEAT_TYPE;
    	  }else{
    		 var seatTypeVal = '';  
    	  }
    	  if(isNullOrEmpty(selectionProcessStage)){
    		  selectionProcessStage = '';
     	  }
    	  if(values.APPLICATION_ID == undefined){
     		  values.APPLICATION_ID = '';
     	  }
     	  if(isNullOrEmpty(applicationStatusVal)){
     		 applicationStatusVal = '';  
     	  }
    	   var duplicateArray =  new Array(); 
    		 var submitURL = SERVERURL.PATH_FIND_DUPLICATE_APPLICATION+'?code='+code+'&academyLocationId='+values.ACAD_LOC_ID+'&applicationId='+values.APPLICATION_ID+'&applicantName='+values.APPICANT_PRINT_NAME+'&applicantOwner='+values.applicationOwner+'&applicationStauts='+applicationStatusVal+
    		  '&stageStatus='+values.STAGE_STATUS+'&admissionStatus='+values.ADMISSION_STATUS+'&programGroup='+values.PROGRAM_GROUP+'&programStatus='+values.PROGRAM_STATUS+
    		  '&selectionProcess='+values.SELECTION_PROCESS+'&programId='+values.PROGRAM+'&batchId='+batchVal+'&SeatTypeId='+seatTypeVal+
    		  '&countryId='+values.COUNTRY_ID+'&intakeYearId='+values.intakeYear+'&stageFeeStatus='+values.STAGE_FEE_STATUS+'&stageFeeApplicable='+values.STAGE_FEE_APPLICABLE+
    		  '&modeOfDeliveryId='+values.MODE_OF_DELIVERY_ID+'&stageFeeStatusNoSettled='+values.STAGE_FEE_STATUS+'&ragistrationType='+values.REGISTRATION_TYPE+'&emailId='+values.EMAIL_ID+
    		  '&mobileNumber='+values.MOBILE_NO+'&startDate='+values.START_DATE+'&endDate='+values.END_DATE+'&enqueryNumber='+values.ENQUIRY_NO+'&selectionProcessStage='+selectionProcessStage;
    	   Ext.Ajax.request({
               type : 'rest',
               url : submitURL,
               method : 'GET',
               async: false,
               success : function(form, action) {
            	   var data = Ext.JSON.decode(form.responseText);
            	   if (!isNullOrEmpty(data)) {
            		   data.forEach(function(obj){
            			   duplicateArray.push(obj);
            		   });
            	   }

               }
           }); 
    	   return duplicateArray;
       },
         applicantPastHistoryLoaderRadioBtn : function(cb, nv, ov){
        	  var $this = this;
        	  var downloadTemplateForm = cb.down('#applicantcompetitivepasthistoryloaderdownloadformId');
      		var uploadTemplateForm = cb.down('#applicantcompetitivepasthistoryloaderuploadformId');
      		var importListNewApplicant = cb.down('#importlistapplicanthistoryloaderId');
      		
        	  if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
        		  uploadTemplateForm.hide();
        		  downloadTemplateForm.show();
        		  importListNewApplicant.hide();
        	  }else{
        		  $this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
        		  var uploadoptionradiogroupform  = $this.getApplicationsUploaduploadoptionradiogroup();
        		  uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
        			  isUploadAll: false
        		  });
        		  downloadTemplateForm.hide();
        		  uploadTemplateForm.show();
        		  importListNewApplicant.show();
        	  }
          },
          resetFormAndSetValue: function(searchForm) {
        	  var downloadTemplateForm = searchForm.down('#applicantcompetitivepasthistoryloaderdownloadformId');
        	  downloadTemplateForm.down('#templateTypeItemId').setValue('CompetitiveExam');
        	  downloadTemplateForm.down('#program').reset();
        	  downloadTemplateForm.down('#batch').reset();
        	  downloadTemplateForm.down('#batch').setDisabled(true);
        	  downloadTemplateForm.down('#seatType').reset();
        	  downloadTemplateForm.down('#seatType').setDisabled(true);
        	  downloadTemplateForm.down('#examPassed').reset();
        	  downloadTemplateForm.down('#examBoard').reset();
        	  downloadTemplateForm.down('#examPassed').setVisible(false);
        	  downloadTemplateForm.down('#examBoard').setVisible(false)
          },
          downloadTemplateForApplicantPastHistory : function(){

        	  var form = this.getApplicantcompetitivepasthistoryloaderdownloadform();
        	  var programId= form.down('#program').getValue();
        	  var batdhId= form.down('#batch').getValue();        	  
        	  var seatTypeId= form.down('#seatType').getValue();
        	  var examPassed = form.down('#examPassed');
        	  var examBoard = form.down('#examBoard');
        	  var templateType = form.down('#templateTypeItemId');
        	  
        	  var csvForm = Ext.create('Ext.form.Panel',{

        	  });
        	  csvForm.getForm().submit({
        		  target: '_blank',
        		  method:'POST',
        		  params :{
        			  access_token : Ext.Ajax.defaultHeaders.access_token, 
        			  'programId' : batdhId,
        			  'programId':programId,
        			  'seatTypeId':seatTypeId,
        			  "examPassedId":examPassed.getValue(),
  					  "examBoardId":examBoard.getValue(),
  					  "templateType":templateType.getValue()
        			  },
        		  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
        		  url: SERVERURL.PATH_DOWNLOAD_TEMPLATE_FOR_APPLICANT_COMPETITIVE_EXAM,
        		  standardSubmit :true,
        		  success : function(form, action){
        			  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
        		  },
        		 failure: function(form, action) {
        			  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
        		  }
    	  });
          },

  		showApplicantRequestDocumentWin:function(){
  	    	var $this = this;
  	    	var formWindow = $this.getFacultyrequestdocumentwidow();
  	    	if (!formWindow) {
  	    		formWindow = Ext.widget('facultyrequestdocumentwidow',{
  	    			itemId:'applicantRequestdocumentId'
  	    		});
  	    		Ext.widget('facultyrequestdocumentwidow');
  	    		formWindow = $this.getFacultyrequestdocumentwidow();
  	    	}
  	    	formWindow.show();
  	    	
  	    	var form = formWindow.down('form');
  			var  templateNameField = form.down("#DocummentGroupFaculty");
  			
  			var store = templateNameField.getStore();
  			var basicSearchForm = $this.getApplicationsListBasicSearchForm();
    		var academyLocationId = basicSearchForm.down('#academyLocationCombo').getValue();
    		
    		var grid = $this.getSearchResultGrid();
  	    	var records=grid.getSelectionModel().getSelection();

	    	if(!isNullOrEmpty(records) && !isNullOrEmpty(records[0]) && !isNullOrEmpty(records[0].data)) {
	    		academyLocationId=records[0].data.ACADEMY_LOCATION_ID;
	    	}
  			
  			store.getProxy().extraParams={
  		    	academyLocationId:academyLocationId,
  		    	applicableTo: 'APPLICANT'
  			};
  		store.load();
      },
      documentRequestApplicant: function(button) {
    	  var grid = this.getSearchResultGrid();
    	  var records=grid.getSelectionModel().getSelection();
    	  var studentId=0;
    	  var admissionId=0;
    	  var	formWindow = Ext.widget('facultyrequestdocumentwidow',{
    		  itemId:'applicantRequestdocumentId'
    	  });
    	  var academyLocationId=this.getCurrentAcademyLocation();

    	  if(!isNullOrEmpty(records) && !isNullOrEmpty(records[0]) && !isNullOrEmpty(records[0].data)) {
    		  academyLocationId=records[0].data.ACADEMY_LOCATION_ID;
    	  }
    	  
    	  var appListArrays = [];
    	  for(var i in records) {
    		  appListArrays.push(records[i].data.APPLICATION_PERSON_ID);
    	  }
    	  var personIds = appListArrays.join(',');

    	  var documentGroupMasterId = this.getFacultyrequestdocumentwidow().down('#DocummentGroupFaculty').getValue();

    	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	  Ext.Ajax.request({
    		  type : 'rest',
    		  url : SERVERURL.PATH_PRDGM_MAKE_REQUEST_FOR_DOCUMENT,
    		  method : 'POST',
    		  //async: false,
    		  params: {
    			  documentGroupMasterId: documentGroupMasterId,
    			  academyLocationId: academyLocationId,
    			  personIds:personIds
    		  },
    		  headers: {
    			  'Content-Type': 'application/json'
    		  },
    		  success : function(form, action) {
    			  Ext.getBody().unmask();
    			  showSuccessMessage(getCommonTranslation('REQUEST_DOCUMENTS'),getExaminationTranslation('SUCCESS'));

    		  }
    	  });
    	  this.getFacultyrequestdocumentwidow().close();
      },
          changeInnerUploadsRadioBtn : function(radioGroup, newValue, oldValue, eOpts){
        	  var grid =this.getImportlistapplicanthistoryloader();
        	  var applicantHistoryUploadForm=this.getApplicantcompetitivepasthistoryloaderuploadform();
        	  var templateName = applicantHistoryUploadForm.getValues().uploadType;
        	  var moduleName = null;
        	  submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
        	  switch (templateName){
        	  	case 'CompetitiveExam':
        	  			moduleName = 'APPLICANT_BULK_COMPETITIVE_EXAM';
        	  			break;
        	  	case 'EducationHistory':
        	  			moduleName = 'APPLICANT_BULK_EDUCATION_HISTORY';
        	  			break;
        	  	default : null;
        	  }
        	  
        	  var form =this.getApplicantpasthistoryuploadoptionradiogroup();
        	  var isUploadAll = newValue.isUploadAll;
        	  this.onChangeUploadOptionRadioGroup(isUploadAll,grid, moduleName);
          },
       loadApplicationGridWithFilters : function(searchForm, ResultGrid, resultViewUrl,jsonFormatFormData){
    	   
    	   var me = this;
    	   var formValues = searchForm.getValues();
    	   var applicantDocumentStatusArray = searchForm.down('#applicantDocumentStatusItemId').getValue();
    	   var isMyApplications = searchForm.down('#myApplicationItemId').getValue();
    	   var expiryStartDate = searchForm.down('#offerExpiryStartDate').getValue();
    	   var expiryEndDate = searchForm.down('#offerExpiryEndDate').getValue();
    	   
    	   //Check Whether only my applications should be in the grid.
    	   if(applicantDocumentStatusArray!=undefined){
    		   if(applicantDocumentStatusArray[0]==""){
    			   applicantDocumentStatusArray=null;
    		   }
    	   }
    	   if(applicantDocumentStatusArray==undefined){
    		   applicantDocumentStatusArray=null;
    	   }
    	   
    	   var enquiryModeIdsTempArray = [];
    	   if(!isNullOrEmpty(applicantDocumentStatusArray)){
    		   if(typeof applicantDocumentStatusArray[0]!="object"){
    			   var enquiryModeIds = enquiryModeIdsArray;
    		   }else {
    			   Ext.each(applicantDocumentStatusArray,function(currentIds){
    				   if(!isNullOrEmpty(currentIds)){
    					   enquiryModeIdsTempArray.push(currentIds.data.id);
    				   }
    			   });
    		   }
    	   }
    	   
    	   var prevApplicationIds = [];
    	   var i = jsonFormatFormData.searchCriterias.length;
    	   while (i--) {
    	       if (jsonFormatFormData.searchCriterias[i].paramCode == "applicantDocumentStatus") { 
    	    	   jsonFormatFormData.searchCriterias.splice(i, 1);
    	       }
    	   }
    	   
    	   var k = jsonFormatFormData.searchCriterias.length;
    	   while (k--) {
    	       if (jsonFormatFormData.searchCriterias[k].paramCode == "APPLICATION_PRIMERY_ID") { 
    	    	   prevApplicationIds = jsonFormatFormData.searchCriterias[k].paramValues;  	    	   
    	       }
    	   }
    	   
    	   if( enquiryModeIdsTempArray.length != 0 ){

    		   var submitUrl = SERVERURL.PATH_FIND_APPLICANTION_BY_DOCUMENT_STATUS_CSM+"?documentStatusCSMIds="+enquiryModeIdsTempArray;
    		   Ext.Ajax.request({
    			   type : 'rest',
    			   url : submitUrl,
    			   //jsonData : jsonObj,
    			   method : 'GET',
    			   success : function(res, action) {
    				   var data = Ext.decode(res.responseText);
    				   console.log(data);
    				   
    				   if( isNullOrEmpty(data) || data.length == 0 ){
    					   data = [-1];
    				   }
    				   
    				   if( prevApplicationIds.length != 0 ){
    					   var intersection = data.filter(function(n) {
    						   return prevApplicationIds.indexOf(n) !== -1;
    					   });
    					   if( intersection.length == 0 ){
    						   intersection = [-1];
    					   }
    					   var j = jsonFormatFormData.searchCriterias.length;
    			    	   while (j--) {
    			    	       if (jsonFormatFormData.searchCriterias[j].paramCode == "APPLICATION_PRIMERY_ID") { 
    			    	    	   jsonFormatFormData.searchCriterias[j].paramValues = intersection; 	    	   
    			    	       }
    			    	   }
    				   } else {
    					   var applicationObj = {};
        				   applicationObj.paramCode = "APPLICATION_PRIMERY_ID";
    					   applicationObj.paramValues = data;
    					   jsonFormatFormData.searchCriterias.push(applicationObj);
    				   }
    				   if(!isNullOrEmpty(expiryStartDate) || !isNullOrEmpty(expiryEndDate)) {
    					   me.callSearchBasedOnExpiryDate(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData, expiryStartDate, expiryEndDate, null, null, null, null, null, null, null, null, null, null);
    				   } else {
    					   ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,searchForm.down('#applicationsListBasicSearchBtn'));
    				   }
    			   }
    		   });

    	   } else if(!isNullOrEmpty(expiryStartDate) || !isNullOrEmpty(expiryEndDate)) {
    		   me.callSearchBasedOnExpiryDate(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData, expiryStartDate, expiryEndDate, null, null, null, null, null, null, null, null, null, null);
    	   } else {
    		   ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,searchForm.down('#applicationsListBasicSearchBtn'));
    	   }
       },
       exportApplicationGridWithFilters : function(searchResultGrid, exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,advancedSearchRequest,pageNo,limit,searchForm){
    	    
    	   var me=this;
    	   var formValues = searchForm.getValues();
    	   var applicantDocumentStatusArray = searchForm.down('#applicantDocumentStatusItemId').getValue();
    	   var isMyApplications = searchForm.down('#myApplicationItemId').getValue();
    	   var expiryStartDate = searchForm.down('#offerExpiryStartDate').getValue();
    	   var expiryEndDate = searchForm.down('#offerExpiryEndDate').getValue();

    	   //Check Whether only my applications should be in the grid.
    	   if(applicantDocumentStatusArray!=undefined){
    		   if(applicantDocumentStatusArray[0]==""){
    			   applicantDocumentStatusArray=null;
    		   }
    	   }
    	   if(applicantDocumentStatusArray==undefined){
    		   applicantDocumentStatusArray=null;
    	   }
    	   
    	   var enquiryModeIdsTempArray = [];
    	   if(!isNullOrEmpty(applicantDocumentStatusArray)){
    		   if(typeof applicantDocumentStatusArray[0]!="object"){
    			   var enquiryModeIds = enquiryModeIdsArray;
    		   }else {
    			   Ext.each(applicantDocumentStatusArray,function(currentIds){
    				   if(!isNullOrEmpty(currentIds)){
    					   enquiryModeIdsTempArray.push(currentIds.data.id);
    				   }
    			   });
    		   }
    	   }
    	   
    	   var prevApplicationIds = [];
    	   var i = jsonFormatFormData.searchCriterias.length;
    	   while (i--) {
    	       if (jsonFormatFormData.searchCriterias[i].paramCode == "applicantDocumentStatus") { 
    	    	   jsonFormatFormData.searchCriterias.splice(i, 1);
    	       }
    	   }
    	   
    	   var k = jsonFormatFormData.searchCriterias.length;
    	   while (k--) {
    	       if (jsonFormatFormData.searchCriterias[k].paramCode == "APPLICATION_PRIMERY_ID") { 
    	    	   prevApplicationIds = jsonFormatFormData.searchCriterias[k].paramValues;  	    	   
    	       }
    	   }
    	   
    	   if( enquiryModeIdsTempArray.length != 0 ){

    		   var submitUrl = SERVERURL.PATH_FIND_APPLICANTION_BY_DOCUMENT_STATUS_CSM+"?documentStatusCSMIds="+enquiryModeIdsTempArray;
    		   Ext.Ajax.request({
    			   type : 'rest',
    			   url : submitUrl,
    			   //jsonData : jsonObj,
    			   method : 'GET',
    			   success : function(res, action) {
    				   var data = Ext.decode(res.responseText);
    				   console.log(data);
    				   
    				   if( isNullOrEmpty(data) || data.length == 0 ){
    					   data = [-1];
    				   }
    				   
    				   if( prevApplicationIds.length != 0 ){
    					   var intersection = data.filter(function(n) {
    						   return prevApplicationIds.indexOf(n) !== -1;
    					   });
    					   if( intersection.length == 0 ){
    						   intersection = [-1];
    					   }
    					   var j = jsonFormatFormData.searchCriterias.length;
    			    	   while (j--) {
    			    	       if (jsonFormatFormData.searchCriterias[j].paramCode == "APPLICATION_PRIMERY_ID") { 
    			    	    	   jsonFormatFormData.searchCriterias[j].paramValues = intersection; 	    	   
    			    	       }
    			    	   }
    				   } else {
    					   var applicationObj = {};
        				   applicationObj.paramCode = "APPLICATION_PRIMERY_ID";
    					   applicationObj.paramValues = data;
    					   jsonFormatFormData.searchCriterias.push(applicationObj);
    				   }
    				   if(!isNullOrEmpty(expiryStartDate) || !isNullOrEmpty(expiryEndDate)) {
    					   me.callSearchBasedOnExpiryDate(searchForm, null, null, jsonFormatFormData, expiryStartDate, expiryEndDate, exportUrl, filetype, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle, pageNo, limit, searchResultGrid);
    				   } else {
    					   searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit);
    				   }
    			   }
    		   });

    	   } else if(!isNullOrEmpty(expiryStartDate) || !isNullOrEmpty(expiryEndDate)) {
    		   me.callSearchBasedOnExpiryDate(searchForm, null, null, jsonFormatFormData, expiryStartDate, expiryEndDate, exportUrl, filetype, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle, pageNo, limit, searchResultGrid);
    	   } else {
    		   searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle,null,pageNo,limit);
    	   }
       },
       clickOnBtnRefreshAllItemId: function(obj) {
        var $this = this;
        var grid = this.getSearchResultGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records.length > 0) {
				var personIdArr = [];
                Ext.each(records, function(recordData) {
                    if (recordData.get("APPLICATION_PERSON_ID") != null) {
                        personIdArr.push(recordData.get("APPLICATION_PERSON_ID"));
                    }
                });
				var applicationPersonIds  = personIdArr.join(',');
				
				Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.ED_UPDATE_APPLICANT_FOR_NSC_UPDATE,
                        jsonData: {
                            applicationPersonIds: applicationPersonIds
                        },
                        method: 'POST',
                        success: function(frm, action) {
                            showSuccessMessage(getCommonTranslation('ELIGIBILITY_DETAILS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                        }
               });
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    clickOnBtnOnlyUnmatchedRecordsItemId: function(obj) {
        var grid = this.getSearchResultGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records.length > 0) {
				var personIdArr = [];
                Ext.each(records, function(recordData) {
                    if (recordData.get("REQUIRED_NSC_DATA") == null || recordData.get("REQUIRED_NSC_DATA") == 1) {
                        personIdArr.push(recordData.get("APPLICATION_PERSON_ID"));
                    }
                });
				var applicationPersonIds = personIdArr.join(',');
				if (personIdArr.length >= 0) {
					Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.ED_UPDATE_APPLICANT_FOR_NSC_UPDATE,
                        jsonData: {
                            applicationPersonIds: applicationPersonIds
                        },
                        method: 'POST',
                        success: function(frm, action) {
                            showSuccessMessage(getCommonTranslation('ELIGIBILITY_DETAILS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                        }
					});
				}
				
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    resetSelectionStageSloteDropdown : function(stageCombo) {
    	stageCombo.reset();
    	stageCombo.getStore().removeAll();
	},
	loadDFRForSelectionStage: function(selectionStage){
	   	var $this = this;
	   	Ext.Ajax.request({
	   		type: 'rest',
	   		async: false,
	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	   		params: {
	   			screenName: 'basicsearch',
	   			academyLocationId: this.getCurrentAcademyLocation(),
	   			languageCode:'en'
	   		},
	   		method: 'GET',
	   		success: function(res, action) {
	   			var response = Ext.decode(res.responseText);
	   			if( Object.keys(response).length > 0 ){
	   				var records=response.basicsearch;
	   				for(i in records){
	   					if(records[i].formFieldInputType=='customcombobox' && records[i].formFieldId=='seatType' && records[i].isVisible==false){
	   						selectionStage.setVisible(false);
	   						selectionStage.allowBlank = true;
	   					}
	   					
	   				}
	   			}
	   		}
	   		
	   	});
	   	
	 },
	 applicationReactivationProcess: function(grid){
		 var $this = this;
		 var grid = $this.getSearchResultGrid();
		 var records = grid.getSelectionModel().getSelection();
		 var applicationProgramIds = new Array();
		 if (records.length>0) {
			 for (var i in records) {
					applicationProgramIds.push(records[i].get('APPLICATION_PROGRAM_ID'));
			}
			 var applicationId = records[0].get('APPLICATION_PRIMERY_ID');
			 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');	
			 if(!isNullOrEmpty(applicationId) && applicationProgramIds.length>0){
				Ext.Ajax.request({
					method: "GET",
					type: 'rest',
					url: SERVERURL.PATH_TO_APPLICATION_REACTIVATION, 
					params:{
						applicationId:applicationId,
						applicationProgramIds:applicationProgramIds
					},
					success: function(response, action) {
						var searchResultGrid=$this.getSearchResultGrid();
						searchResultGrid.getStore().reload(); 
						var searchPanel=$this.getSearchPanel();
			         	if(searchPanel){
			         		var searchForm=searchPanel.getActiveTab().down('form');
			         		if(searchForm){
			         			$this.loadGridAndSearchUsers(searchForm);
			         		}
			         	}
			            showSuccessMessage(getCommonTranslation('REACTIVATE_APPLICATION'), getCommonTranslation('APPLICATION_REACTIVATED_SUCCESSFULLY'));
			            Ext.getBody().unmask();
					}
				});
			} 
		 } else {
			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		 }
	 },
	 
	 applicationPrintOfferLetterInWords: function(grid){
		 var $this = this;
		 var grid = $this.getSearchResultGrid();
		 var record = grid.getSelectionModel().getSelection()[0];
		 if (!isEmpty(record)) {
		    var applicationProgramId=record.get('APPLICATION_PROGRAM_ID');
			var user=$this.getCurrentlyLoggedInUser();       
			var progBatchSeatConfig=record.get('PROG_BATCH_SEAT_CONFIG_ID');
			var parameterListObj =new Object();
			parameterListObj.documentTypeCode="OFFER_LETTER";
			parameterListObj.ownerType="PROGRAM_BATCH_SEAT_TYPE_LEVEL";
			parameterListObj.userId=user.id; 
			parameterListObj.userName=user.value; 
			parameterListObj.isPrintOfferLetterInWord=true;

			parameterListObj.ownerId=progBatchSeatConfig;                                 	                                    	
			parameterListObj.templateReportParams={'PRM_APPLICATION_PROGRAM_ID':applicationProgramId.toString()};   	                                    	
			$this.sendPDFDynamicDocumentRequest(SERVERURL.GENERATE_DYNAMIC_DOCUMENT,parameterListObj);
		 }
	 },
	 openAdmAdmissionApprovalDetailsPopup:function(btn){
	    	var grid = this.getSearchResultGrid();
	    	   if (grid.getSelectionModel().getCount() > 0) {
	    		   
	    		   var admAdmissionAppDetailsWindowItemId ="admadmissionapprovaldetailswindow";
	               var admAdmissionAppDetailsWindow = Ext.widget('admissionapprovaldetailsadmwindow', {
	                    itemId: admAdmissionAppDetailsWindowItemId
	                });
	               admAdmissionAppDetailsWindow.show();
	                var me=this;
		           	var searchResultGrid=me.getSearchResultGrid();
		           	var record = searchResultGrid.getSelectionModel().getSelection()[0];
		           	if (!isEmpty(record)) {
		           		var applicationProgramId=record.get('APPLICATION_PROGRAM_ID');
		           		var admissionApprovalDetailsGrid = admAdmissionAppDetailsWindow.down('#admissionApprovalDetailsGrid');
		           		admissionApprovalDetailsGrid.getStore().removeAll();
		           		admissionApprovalDetailsGrid.getStore().getProxy().extraParams = {
		        			applicationProgramId: applicationProgramId
		        		};
		           		admissionApprovalDetailsGrid.getStore().load();
		           	}
	               
	    	   } else {
	    		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	    	   }

		 var formWindowTab = $this.getApplicantsendmessage();
		 var sendMessageLable = formWindowTab.down("#sendMsgCountItemId");
		 sendMessageLable.setVisible(true);
		 var totalRecord = grid.getStore().totalCount;
		 if (totalRecord > 1) {
			 sendMessageLable.setText(totalRecord+' '+getCommonTranslation('APPLICANTS_SEND_MESSAGE_COUNT'));	
		 }else{
			 sendMessageLable.setText(totalRecord+' '+getCommonTranslation('APPLICANT_SEND_MESSAGE_COUNT'));
		 }

		 formWindowTab.down("#selectTemplate").allowBlank=true;
		 formWindowTab.down("#selectTemplate").setVisible(false);
		 formWindowTab.down("#messageName").allowBlank=true;   
		 formWindowTab.down("#messageName").setVisible(false);
		 var templateStore = formWindowTab.down('#selectTemplate').getStore();
		 templateStore.getProxy().extraParams={
			 msgRecipientTypeId:10
		 };
		 templateStore.load();

		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 Ext.Ajax.request({
			 method : "GET",
			 type : 'rest',
			 url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=EnquirerTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
			 headers : {
				 'Content-Type' : 'application/json'
			 },
			 success : function(form,action) {
				 var data = Ext.JSON.decode(form.responseText);
				 formWindowTab.down("#id").setValue(data.id);
				 formWindowTab.down("#code").setValue(data.code);
				 formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
				 formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
				 formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
				 Ext.getBody().unmask();
			 }

		 });
		 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	 },
	 
	  openApplicantSendMessageToAll:function(obj){
		 var grid = obj.up('grid');
		 var $this=this;
		 var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		 var structure = Ext.widget('applicantsendmessage',{
			 itemId:'applicationSendMessageWindow',
			 //customGridId: grid.itemId
		 });
		 var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
		 /**
		  * This is to remove tab from content panel and open same tab again
		  */
		 var getcontroller=this.getController('menu.CoreERPNavigationController');
		 var getTab=getcontroller.getTab(tabName);
		 if(getTab!=null){
			 contentPanel.remove(getTab, true);
		 }

		 var formWindowTab = $this.getApplicantsendmessage();
		 var sendMessageLable = formWindowTab.down("#sendMsgCountItemId");
		 sendMessageLable.setVisible(true);
		 var totalRecord = grid.getStore().totalCount;
		 if (totalRecord > 1) {
			 sendMessageLable.setText(totalRecord+' '+getCommonTranslation('APPLICANTS_SEND_MESSAGE_COUNT'));	
		 }else{
			 sendMessageLable.setText(totalRecord+' '+getCommonTranslation('APPLICANT_SEND_MESSAGE_COUNT'));
		 }

		 formWindowTab.down("#selectTemplate").allowBlank=true;
		 formWindowTab.down("#selectTemplate").setVisible(false);
		 formWindowTab.down("#messageName").allowBlank=true;   
		 formWindowTab.down("#messageName").setVisible(false);
		 var templateStore = formWindowTab.down('#selectTemplate').getStore();
		 templateStore.getProxy().extraParams={
			 msgRecipientTypeId:10
		 };
		 templateStore.load();

		 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		 Ext.Ajax.request({
			 method : "GET",
			 type : 'rest',
			 url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=EnquirerTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
			 headers : {
				 'Content-Type' : 'application/json'
			 },
			 success : function(form,action) {
				 var data = Ext.JSON.decode(form.responseText);
				 formWindowTab.down("#id").setValue(data.id);
				 formWindowTab.down("#code").setValue(data.code);
				 formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
				 formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
				 formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
				 Ext.getBody().unmask();
			 }

		 });
		 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
	 },
	 callSearchBasedOnExpiryDate : function(searchForm, ResultGrid, resultViewUrl, jsonFormatFormData, expiryStartDate, expiryEndDate, exportUrl, filetype, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle, pageNo, limit, searchResultGrid){
    	   var urlParameters;
    	   var offerStatus = searchForm.down('#programStatus').getValue();
    	   var academyLocation = searchForm.down('#academyLocationCombo').getValue();
    	   var applicantCode = searchForm.down('#applicantName').getValue();
    	   var formValues = searchForm.getValues();
    	   
    	   urlParameters="?offerStatus=" + offerStatus;
    	   if(!isNullOrEmpty(expiryStartDate)) {
    		   urlParameters=urlParameters.concat("&expiryStartDate=" + formValues.OFFER_EXPIRY_START_DATE);
    	   }
    	   if(!isNullOrEmpty(expiryEndDate)) {
    		   urlParameters=urlParameters.concat("&expiryEndDate=" + formValues.OFFER_EXPIRY_END_DATE);
    	   }
    	   if(!isNullOrEmpty(academyLocation)) {
    		   urlParameters=urlParameters.concat("&academyLocationId=" + academyLocation);
    	   }
    	   if(!isNullOrEmpty(applicantCode)) {
    		   urlParameters=urlParameters.concat("&applicantCode=" + applicantCode);
    	   }
    	   
    	   var submitUrl = SERVERURL.PATH_TO_FIND_APP_PROGRAMS_BY_EXPIRY_DATE+urlParameters;
		   Ext.Ajax.request({
			   type : 'rest',
			   url : submitUrl,
			   method : 'GET',
			   success : function(res, action) {
				   var data = Ext.decode(res.responseText);
				   console.log(data);
				   
				   if( isNullOrEmpty(data) || data.length == 0 ){
					   data = [-1];
				   }
				   var applicationObj = {};
				   applicationObj.paramCode = "APPLICATION_PROGRAM_PRIMERY_ID";
				   applicationObj.paramValues = data;
				   jsonFormatFormData.searchCriterias.push(applicationObj);
				   
				   if(!isNullOrEmpty(exportUrl)) {
					   searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions, whetherAll, searchCriteriaString, visibleColumns, reportTitle, null, pageNo, limit);
				   } else {
					   ResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData,searchForm.down('#applicationsListBasicSearchBtn'));
				   }
			   }
		   });
       },
       reassignEscalationSave:function(obj){
    	   var $this = this;
    	   var grid = $this.getSearchResultGrid();
	      
    	   var form = $this.getReassignescalationform().down('idgeneratorformwin');
    	   var reassignOwner = form.down('#assignedToItemId').getValue();
    	   var reassigndate = form.down('#reassignOwnerdateItemId').getValue();
    	   var reassignRemark = form.down('#reassignOwnerRemarkItemId').getValue();
    	   
    	   var jsonData = new Object();
    	   var selected = grid.selModel.getSelection();
    	   var tempArray = []; 
    	   if( selected.length > 0){
       			Ext.getBody().mask(getCommonTranslation('Please Wait'), 'x-mask-loading');
       			for( var i = 0; i < selected.length; i++) {
       				if(!isNullOrEmpty(selected[i].data.APPLICATION_PROGRAM_ID)){
       					tempArray.push(selected[i].data.APPLICATION_PROGRAM_ID);
       				}
       			}
       			jsonData.applicationProgramIds = tempArray;
       			jsonData.reassignUser = $this.getIdValueJson(reassignOwner);
       			jsonData.escalationAssignDate = Ext.Date.format(new Date(reassigndate),CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
       			jsonData.escalationAssignRemark = reassignRemark;
       			submitUrl = SERVERURL.PATH_ESCALATION_USER_REASSIGNMENT;
       			Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
       			Ext.Ajax.request({
       				type : 'rest',
       				url : submitUrl,
       				jsonData : jsonData,
       				method : 'POST',
       				success : function(form, action) {
       					showSuccessMessage(getCommonTranslation('REASSIGN_ESCALATION'),getCommonTranslation('ESCALATION_RE_ASSIGNED_SUCCESSFULLY'));
       					grid.getStore().reload();
       					obj.up('window').close();
       					Ext.getBody().unmask();
       				}
       			});
       		}
       },
       
       openPandaDocPopup: function(btn) {
    	   var window = this.getPandadocpopup();
    	   if(!window){
    		   window = Ext.widget('pandadocpopup');
    	   }
    	   window.show();
       },
       openScholarshipRaiseRequestTabForApplicant:function(){
    	   requestIsFor='Applicant';
    	   var grid = this.getSearchResultGrid();
    	   if(grid.getSelectionModel().getCount() == 1){	
    		   var record = grid.getSelectionModel().getSelection()[0];
    		   var scholarshipMasterController = Academia.app.getController('Academia.controller.scholarship.ScholarshipMasterController');
    		   scholarshipMasterController.getScholarshipRequestPanel(requestIsFor,record);
    	   } else {
    		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	   }
       }
}); 
