/*
 * @author prathamesh.sheth
 * 
 * This controller is used for Direct Submission Form details.
 *    
 */
Ext.define('Academia.controller.admission.directSubmission.DirectSubmissionController', {
	
    extend: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
    
    alias: "widget.directsubmissioncontroller",
    
    mixins: { 		
    	PersonInfoController:'Academia.controller.personinfo.common.PersonInfoController'
    },

    models: ['admission.applicationFormSale.PersonEnityModel',
             		'admission.applicationFormSale.ApplicationFormEntityDataModel'],

    stores: ['admission.applicationFormSale.ApplicantTypeStore',
             'admission.applicationFormSale.ActiveProgramGroupComboStore',
             	  'admission.applicationFormSale.ProgramGroupComboStore',
             	  'admission.applicationFormSale.AddProgramGridStore',
             	  'admission.applicationFormSale.ApplicantGridStore', 
             	  'admission.applicationFormSale.SearchResultGridStore',
             	  'admission.applicationFormSale.CollectedByComboStore', 
             	  'admission.applicationFormSale.SaleRefTypeComboStore', 
             	  'admission.applicationFormSale.SaleRefComboStore', 
             	  'admission.applicationFormSale.ProgramTabGridStore',
             	  'Academia.store.personinfo.common.personalinfo.ParentGuardianStore',
              	  'Academia.store.common.CountryStore'
            ],

    views: ['admission.directSubmission.DirectSubmission',
            	 'admission.applicationFormSale.ApplicationFormSale',
            	 'admission.applicationFormSale.ApplicationFormSaleLayout', 
            	 'admission.applicationFormSale.ApplicantFormDetails',
            	 'admission.applicationFormSale.ApplicantGrid', 
            	 'admission.applicationFormSale.CollectionFormDetails',
            	 'admission.applicationFormSale.ApplicantDetailsLayout',
            	 'admission.applicationFormSale.ApplicantRelatives', 
            	 'admission.applicationFormSale.AddProgramTabGrid', 
            	 'admission.applicationFormSale.AddProgramWindowGrid', 
            	 'admission.applicationFormSale.AddProgramWindow', 
            	 'admission.applicationFormSale.SearchApplicantWindow', 
            	 'admission.applicationFormSale.ApplicationFormButtonPanel',
            	 'personinfo.common.PersonCommonWindow',
            	 'personinfo.common.personalinfo.ParentGuardianGrid', 
            	 'personinfo.common.personalinfo.ParentGuardianForm',
                 'personinfo.common.personalinfo.SiblingDetailsGrid', 
                 'personinfo.common.personalinfo.SiblingForm'],

    refs: [{
        ref: 'directSubmission',
        selector: 'directSubmission'
    }, {
        ref: 'searchWindow',
        selector: 'searchapplicantwindow[itemId=searchDirectSubmissionApplicantWindow]'
    }, {
        ref: 'applicantForm',
        selector: 'directSubmission form[itemId=directSubmissionFormApplicantDetails]'
    }, {
        ref: 'addProgramTabGrid',
        selector: 'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] grid[itemId=addprogramtabgrid]'
    }, {
        ref: 'applicantRelatives',
        selector: 'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives]'
    }, {
        ref: 'addProgramWindow',
        selector: 'addprogramwindow[itemId=addProgramDirectSubmissionWindow]'
    }, {
        ref: 'addProgramWindowGrid',
        selector: 'addprogramwindow[itemId=addProgramDirectSubmissionWindow] grid[itemId=addProgramWindowGrid]'
    }, {
        ref: 'applicationFormButtonPanel',
        selector: 'applicationformbuttonpanel[itemId=directSubmissionFormButtonPanel]'
    }, {
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personParentGuardianForm',
        selector: 'parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm]'
    }, {
    	ref: 'applicantionParentGuardianGrid',
        selector: 'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid]'
    }, {
        ref: 'personSiblingForm',
        selector: 'siblingform[itemId=applicantDirectSubmissionSiblingForm]'
    }, {
    	ref: 'applicantionSiblingDetailsGrid',
        selector: 'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid]'
    }],
    config: {
    	//DIRECT_SUBMISSION_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DIRECT_SUBMISSION_PROGRAM_PRIVILEGES'),
    	//DIRECT_SUBMISSION_PARENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DIRECT_SUBMISSION_PARENT_PRIVILEGES'),
    	//DIRECT_SUBMISSION_SIBLING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('DIRECT_SUBMISSION_SIBLING_PRIVILEGES')
    },

    init: function(application) {
        this.control({
            'directSubmission': {
                beforerender: function(directSubmissionFormPanel) {
                	var me=this;
                    var emptyObject = new Object();
                    emptyObject.id = null;
                    var directSubmissionFormJsonData = Ext.encode(emptyObject);
                    if (!isNullOrEmpty(directSubmissionFormJsonData)) {
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.APPLICATION_FORM_SALE_CREATE, //URL-:rest/applicationForm/create
                            jsonData: directSubmissionFormJsonData,
                            method: 'POST',
                            success: function(response, form) {
                                directSubmissionFormPanel.setDirectSubmissionFormId(response.responseText);
                                me.getApplicationFormButtonPanel().setVisible(false);
                            },
                            failure: function() {
                                return false;
                            }
                        });
                    }
                }
            },

            'directSubmission applicantformdetails[itemId=directSubmissionFormApplicantDetails] button[itemId=searchButton]': {            
                click: function() {
                    var searchWindow = this.getSearchWindow();
                    var applicantForm = this.getApplicantForm();
                    this.onSearchButtonClick(this, searchWindow, applicantForm, 'searchDirectSubmissionApplicantWindow');
                }
            },

            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] combo[itemId=cmbApplicationType]': {
                select: function(combo, record) {
                    var me = this;
                    var applicantForm = me.getApplicantForm();
                    var selectedApplicationType = record[0].get('name');
                    if (!isNullOrEmpty(selectedApplicationType)) {
                        me.showHideSearchCriteriaFields(selectedApplicationType, applicantForm);
                        me.displayTypeId(applicantForm,selectedApplicationType);                        
                    }
                }
            },
                        

            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] combo': {
                render: function(combo) {
                    combo.getStore().load();
                }
            },
            
            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] textfield[name=firstName]': {
            	change: function(firstNameField){
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] textfield[name=middleName]': {
            	change: function(firstNameField){
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] textfield[name=lastName]': {
            	change: function(firstNameField){
            		this.setPrintNameValue(firstNameField);
            	}
            },

            'applicantformdetails[itemId=directSubmissionFormApplicantDetails]': {
                render: function(applicantForm) {
                    var submissionDate = applicantForm.down('#submissionDate');
                    if (submissionDate) {
                        submissionDate.setVisible(true);
                        submissionDate.setDisabled(false);
                    }
                }
            },

            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] button[itemId=saveApplicantFormDetails]': {
                click: function() {
                    var directSubmission = this.getDirectSubmission();
                    var applicantForm = this.getApplicantForm();
                    var programTabGrid = this.getAddProgramTabGrid();
                    var applicantRelatives = this.getApplicantRelatives();
                    var directSubmissionId = this.getDirectSubmission().getDirectSubmissionFormId();
                    var buttonPanel=this.getApplicationFormButtonPanel();
                    this.saveApplicationForm(this, applicantForm, programTabGrid, applicantRelatives, directSubmission, directSubmissionId,undefined,buttonPanel);
                }
            },

            'applicantformdetails[itemId=directSubmissionFormApplicantDetails] button[itemId=cancelApplicationFormDetails]': {
                click: function() {
                    var applicantForm = this.getApplicantForm();
                    applicantForm.getForm().reset();
                    var applicantRelatives = this.getApplicantRelatives();
                    applicantRelatives.setActiveTab(0);
                    Ext.each(applicantRelatives.items.items, function(tab) {
                    	tab.setDisabled(true);                            
                    });
                }
            },

            'searchapplicantwindow[itemId=searchDirectSubmissionApplicantWindow] button[itemId=cancelBtn]': {
                click: function() {
                    this.getSearchWindow().close();
                }
            },
            'searchapplicantwindow[itemId=searchDirectSubmissionApplicantWindow] button[itemId=importBtn]': {
                click: function() {
                    var searchWindow = this.getSearchWindow();
                    var applicantForm = this.getApplicantForm();
                    this.resetNameFields(applicantForm);
                    this.onSearchImportButtonClick(this, searchWindow, applicantForm);
                }
            },

            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] grid[itemId=addprogramtabgrid]': {
                render: function(grid) {
                    var applicantRelatives = this.getApplicantRelatives();
                    grid.getStore().load({
                        params: {
                            applicationID: applicantRelatives.getApplicationId()
                        }
                    });
                    
                    grid.getStore().on('beforeload', function(store, operation) {
                        var application = applicantRelatives.getApplicationId();
                        store.proxy.extraParams = {
                        		applicationID: application
                        };
                    });
                    this.doAccessControlValidation(grid, this.getDIRECT_SUBMISSION_PROGRAM_PERMISSIONS());
                    this.disableMoreActionPivileges(grid,this.getDIRECT_SUBMISSION_PROGRAM_PERMISSIONS());
                }
            },

            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] grid[itemId=addprogramtabgrid] button[itemId=btnAdd]': {
                click: function() {
                    var window = this.getAddProgramWindow();
                    if (!window) {
                        window = Ext.widget('addprogramwindow', {
                            itemId: 'addProgramDirectSubmissionWindow'
                        });
                    }
                    window.show();
                }
            },

            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] grid[itemId=addprogramtabgrid]  button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var grid = me.getAddProgramTabGrid();
                    var url = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_DELETE; //URL-:rest/applicationProgram/delete
                    if (grid) {
                        me.checkGridRecordSelection(me, grid, 'id', getAdmissionTranslation('DELETE_PROGRAM'), url, getAdmissionTranslation('DELETE_PROGRAM_MSG'));
                    }
                }
            },

            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] grid[itemId=addprogramtabgrid] button[itemId=savePriority]': {
                click: function() {
                    var grid = this.getAddProgramTabGrid();
                    this.savePriority(this, grid);
                }
            },

            'addprogramwindow[itemId=addProgramDirectSubmissionWindow] combo[itemId=cmbPgmGroup]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
          	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=false&activeFormSubmission=true';
                  store.load(
      		    	{
                      scope:this,
                         callback: function(records,option,success){
                             store.commitChanges();
                             combo.bindStore(store);
                        
                              if(store.getAt(0))
	                    			combo.select(store.getAt(0));
                      }
                   });
          	},
                change: function(combo, value) {
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    this.loadAddProgramGrid(addProgramWindowGrid, value,false,true,true);
                }
            },
            'addprogramwindow[itemId=addProgramDirectSubmissionWindow] button[itemId=addProgramBtn]': {
                click: function() {
                    var programTabGrid = this.getAddProgramTabGrid();
                    var programWindow = this.getAddProgramWindow();
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var applicantionId = this.getApplicantRelatives().getApplicationId();
                    this.addProgramToApplication(this, programTabGrid, programWindow, addProgramWindowGrid, applicantionId);
                }
            },
            'addprogramwindow[itemId=addProgramDirectSubmissionWindow] button[itemId=cancelProgramBtn]': {
                click: function() {
                    this.getAddProgramWindow().close();
                }
            },

            'addprogramwindow[itemId=addProgramDirectSubmissionWindow] grid[itemId=addProgramWindowGrid]': {
              /*  render: function(addProgramWindowGrid) {
                    var addProgramTabGrid = this.getAddProgramTabGrid();
                    var programGroup = addProgramWindowGrid.down('#cmbPgmGroup');
                    this.loadProgramGroupWithGridData(this, programGroup, addProgramWindowGrid, addProgramTabGrid);
                },*/
                beforeselect: function(sm, record) {
                    if (record.get('disabled')) {
                        return false;
                    }
                }
            },

            'applicationformbuttonpanel[itemId=directSubmissionFormButtonPanel] button[itemId=submitApplicationFormDetails]': {
                click: function() {
                    var DIRECT_SUBMISSION_FORM_SALE_STATUS = 'DIRECT_SUBMISSION_TOKEN_GENERATED';
                    var me = this;
                    var directSubmissionPanel = me.getDirectSubmission();
                    var applicationformbuttonpanel = me.getApplicationFormButtonPanel();
                    var directSubmissionFormId = directSubmissionPanel.getDirectSubmissionFormId();
                    var applicantForm = this.getApplicantForm();                    
                    var applicantRelatives = this.getApplicantRelatives();
                    me.submitApplicationForm(me, null, directSubmissionPanel, applicationformbuttonpanel, null, directSubmissionFormId, null, DIRECT_SUBMISSION_FORM_SALE_STATUS,applicantRelatives,applicantForm);
                }
            },
            
            'applicationformbuttonpanel[itemId=directSubmissionFormButtonPanel] button[itemId=makePaymentButton]': {
                click: function() {
                	var me = this;
                	var directSubmissionPanel = me.getDirectSubmission();
                    if(directSubmissionPanel){
                    	me.openSubmissionFeeTab(directSubmissionPanel, 'submissionfee');
                    }                                                     	                    
                }
            },
                        

            'applicationformbuttonpanel[itemId=directSubmissionFormButtonPanel] button[itemId=assignAppIdButton]': {
                click: function() {
                	var me = this;
                	var directSubmissionPanel = me.getDirectSubmission();
                    if(directSubmissionPanel){
                   	 	me.openAssignApplicationTab(directSubmissionPanel,'Application submission');
                    }                                                                                 	                   
                }
            },

            'applicationformbuttonpanel[itemId=directSubmissionFormButtonPanel] button[itemId=cancelApplicationFormButton]': {
                click: function() {
                    var me = this;
                    var directSubmission = this.getDirectSubmission();
                    if (directSubmission) {
                        var url = SERVERURL.APPLICATION_FORM_SALE_DELETE; //URL-:rest/applicationForm/delete					    	
                        var directSubmissionFormId = directSubmission.getDirectSubmissionFormId();
                        me.deleteFunction(me, directSubmissionFormId, getAdmissionTranslation('DELETE_APPLICANT_FORM'), url, getAdmissionTranslation('DELETE_APPLICANT_FORM_MSG'), null, directSubmission);
                    }
                }
            },
            
            /**
             * Parent Guardian Details
             * 
             */

            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid]': {
            	render: function() {
            		var grid = this.getApplicantionParentGuardianGrid();
            		var applicantRelatives = this.getApplicantRelatives();
                    this.loadGridStore(grid, applicantRelatives, SERVERURL.APPLICANT_PARENT_AND_GUARDIAN_DETAILS);
                    this.doAccessControlValidation(grid, this.getDIRECT_SUBMISSION_PARENT_PERMISSIONS());
                }
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantDirectSubmissionParentGuardianForm');
                }
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnEdit]': {
                click: this.editApplicantParentGuardianFormWindow
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnView]': {
                click: this.viewApplicantParentGuardianFormWindow
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] parentguardiangrid[itemId=applicantionParentGuardianGrid] button[itemId=btnDelete]': {
                click: this.deleteApplicantParentGuardianRecord
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm] button[itemId=submitButtonId]': {
                click: this.saveApplicantParentGuardian
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm] textfield[itemId=employeeIdField]': {
                change: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onChangeDisabledInnerParentGuardianForm(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm] button[itemId=searchButtonId]': {
            	click: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.validateEmployeeOrgId(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm] checkboxfield[itemId=isEmployeeOrganisation]': {
                change: function(employeeOrg, checkValue, oldValue, eOpts) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                    this.onChangeEmployeeOrgField(parentGuardianForm, checkValue);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm]': {
            	render: function() {
            		var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onRenderHideInnerParentGuardianFormField(parentGuardianForm);
                	this.getPersonCommonWindow().doLayout();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=applicantDirectSubmissionParentGuardianForm] combo[itemId=relationShipField]': {
                afterrender: function(combo, eOpts) {
                    this.onRenderParentGuardianRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onSelectRelationshipComboValue(combo, '#applicantionParentGuardianGrid', parentGuardianForm);
                }
            },
            
            /**
             *  Sibling form details
             */
            
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid]': {
            	render: function() {
            		var grid = this.getApplicantionSiblingDetailsGrid();
            		var applicantRelatives = this.getApplicantRelatives();
                    this.loadGridStore(grid, applicantRelatives, SERVERURL.APPLICANT_SIBLING_DETAILS);
                    this.doAccessControlValidation(grid, this.getDIRECT_SUBMISSION_SIBLING_PERMISSIONS());
                }
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
                    this.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantDirectSubmissionSiblingForm');
                }
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnEdit]': {
                click: this.editApplicantSiblingFormWindow
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnView]': {
                click: this.viewApplicantSiblingFormWindow
            },
            'directSubmission tabpanel[itemId=directSubmissionFormApplicantRelatives] siblingdetailsgrid[itemId=applicantionSiblingDetailsGrid] button[itemId=btnDelete]': {
                click: this.deleteApplicantSiblingRecord
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantDirectSubmissionSiblingForm]': {
                render: function(siblingForm) {
                	this.onRenderHideInnerSiblingFormField(siblingForm);
                	this.getPersonCommonWindow().doLayout();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantDirectSubmissionSiblingForm] combo[itemId=relationShipField]': {
                render: function(combo, eOpts) {
                    this.onRenderSiblingRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var siblingForm = this.getPersonSiblingForm();
                	this.onSelectSiblingRelationshipComboValue(combo, '#applicantDirectSubmissionSiblingForm', siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantDirectSubmissionSiblingForm] textfield[itemId=siblingStudentId]': {
            	change: function(field, newValue, oldValue, eOpts){
                	var siblingForm = this.getPersonSiblingForm();
                	this.onChangeResetInnerSiblingForm(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantDirectSubmissionSiblingForm] button[itemId=searchButtonId]': {
                click: function(){
                	var siblingForm = this.getPersonSiblingForm();
                	this.validateSiblingStudentId(siblingForm);
                }
            },
            
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantDirectSubmissionSiblingForm] button[itemId=submitButtonId]': {
            	click: this.saveApplicantSibling
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=applicantDirectSubmissionSiblingForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            }

        });
    },
    
    /**
     * View applicant parent guardian history form window
     */

    viewApplicantParentGuardianFormWindow: function() {
    	var this$ = this;
    	var grid = this$.getApplicantionParentGuardianGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantDirectSubmissionParentGuardianForm');
        	var parentGuardianForm = this.getPersonParentGuardianForm();
        	this$.mixins.PersonInfoController.viewParentGuardianFormWindow(grid, parentGuardianForm, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_FORM_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * edit applicant parent guardian history form window
     */
    editApplicantParentGuardianFormWindow: function() {

    	var this$ = this;
    	var grid = this$.getApplicantionParentGuardianGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'applicantDirectSubmissionParentGuardianForm');
        	var parentGuardianForm = this.getPersonParentGuardianForm();
        	this$.mixins.PersonInfoController.editParentGuardianFormWindow(grid, parentGuardianForm, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_FORM_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     * delete applicant parent guardian history form window
     */
    deleteApplicantParentGuardianRecord: function() {
    	var this$ = this;
    	var grid = this$.getApplicantionParentGuardianGrid();
        this$.mixins.PersonInfoController.deleteParentGuardianRecord(grid, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_DELETE);
    },
    /**
     * save applicant parent guardian history form window
     */
    saveApplicantParentGuardian: function() {
    	
    	var this$ = this;
    	var applicantRelatives = this.getApplicantRelatives();
		var personId = applicantRelatives.getPersonId();
    	var grid = this$.getApplicantionParentGuardianGrid();
        var personObj = {
        		id : personId
        };//this$.getPersonObj();
        var parentGuardianForm = this.getPersonParentGuardianForm();
        var personCommonWindow = this$.getPersonCommonWindow();
        this$.mixins.PersonInfoController.saveParentGuardian('APPLICANT', grid, personCommonWindow, parentGuardianForm, personObj, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_ADD, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_UPDATE);

    },
    
    /**
     * View applicant sibling history form window
     */

    viewApplicantSiblingFormWindow: function() {
        var this$ = this;
        var grid = this$.getApplicantionSiblingDetailsGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantDirectSubmissionSiblingForm');
        	var form = this$.getPersonSiblingForm();
        	this$.mixins.PersonInfoController.viewSiblingFormWindow(grid, form, SERVERURL.APPLICANT_EDIT_SIBLING_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
        
    },
    /**
     * edit applicant sibling history form window
     */
    editApplicantSiblingFormWindow: function() {

    	var this$ = this;
    	var grid = this$.getApplicantionSiblingDetailsGrid();
        if (grid.getSelectionModel().getCount() > 0) {
        	var formWindow = this$.getPersonCommonWindow();
        	this$.mixins.PersonInfoController.showPersonCommonWindow(formWindow, 'SIBLING', 'applicantDirectSubmissionSiblingForm');
        	var form = this$.getPersonSiblingForm();
        	this$.mixins.PersonInfoController.editSiblingFormWindow(grid, form, SERVERURL.APPLICANT_EDIT_SIBLING_DETAILS);
        } else {
            showWarningMessage(getPersonModuleTranslation('SIBLING_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
       
    },
    /**
     * delete applicant sibling history form window
     */
    deleteApplicantSiblingRecord: function() {

    	var this$ = this;
    	var grid = this$.getApplicantionSiblingDetailsGrid();
        this$.mixins.PersonInfoController.deleteSiblingRecord(grid, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_DELETE);
    },
    /**
     * save applicant sibling history form window
     */
    saveApplicantSibling: function() {

    	var this$ = this;
    	var applicantRelatives = this.getApplicantRelatives();
		var personId = applicantRelatives.getPersonId();
    	var grid = this$.getApplicantionSiblingDetailsGrid();
        var personObj = {
        		id : personId
        };
        var siblingForm = this$.getPersonSiblingForm();
        var personCommonWindow = this$.getPersonCommonWindow();
        this$.mixins.PersonInfoController.saveSibling('APPLICANT', grid, personCommonWindow, siblingForm, personObj, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_ADD, SERVERURL.APPLICANT_PERSON_RELATIONSHIP_UPDATE);
    },
    /**
     * @author Pravin.Surve
     * This function is to enable update priority button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getAddProgramTabGrid();
   		var updateButton = grid.down("#savePriority");//itemId of update button
       	
   		updateButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'UPDATEPRIORITY') {
           		if(!isNullOrEmpty(updateButton)){
           			updateButton.setVisible(true);//enable more action button
           		}        		
           	}
       	});
       },
       /**
    	 * SET the print name value when user entered first, middle and lastname.
    	 */
        setPrintNameValue:function(textfield){
        	var form = textfield.up('form');
        	var getForm=form.getForm();
        	var firstName = getForm.findField('firstName').getValue();
        	var middleName = getForm.findField('middleName').getValue();
        	var lastName = getForm.findField('lastName').getValue();
        	
        	var printName=null;
        	if(isNullOrEmpty(middleName)){
        		printName =firstName+" "+lastName;
        	}else{
        		printName =firstName+" "+middleName+" "+lastName ;
        	}
        	printName=printName.trim();
        	
        	var task = new Ext.util.DelayedTask(function(){
        		getForm.findField('printName').setValue(printName.replace(/ +/g, " "));
        		getForm.findField('shortName').setValue(printName.replace(/ +/g, " "));
        	});
        	task.delay(50);

        }
    
});
