/*
 * @author Rajkumar.Patidar
 * 
 * This controller is used for manage form details.
 *    
 */
Ext.define('Academia.controller.admission.manageForm.ManageFormController', {
//	extend: 'Academia.controller.base.BaseController',
	extend :'Academia.controller.admission.applicantFormSaleDirectSubmission.ApplicationFormCommonController',
	alias: "widget.manageformcontroller",
	stores: ['feeandpayment.managebill.Applicant','feeandpayment.managebill.Applicant',
	         'user.UserAcademyLocationStore','common.ProgramsByAcademyLocationsIds','feeandpayment.reports.Program',
	         'common.BatchesByProgramId','common.SeatTypesByBatchId', 'admission.manageForm.FeeAdmissionList',
	         'feeandpayment.managebill.BillType','feeandpayment.managebill.BillFor','feeandpayment.ALUnit','feeandpayment.FeeCurrencyStore',
	         'feeandpayment.receipts.Bank','feeandpayment.receipts.FeeLedgerName','feeandpayment.FeePaymentMode','feeandpayment.receipts.DrawnOnBank',
	         'admission.manageForm.StudentWithOutAL','admission.manageForm.AddProgramTempStore','common.CreateApplicationRelationshipStore',
	         'Academia.store.common.GenderTypeStore','feeandpayment.BillCurrencyStore','Academia.store.common.ApplicationTypeStore',
	         'enquiry.EnquiryModeStore','feeandpayment.receipts.CostCentreReceipt'],
	views: ['admission.manageForm.ManageFormTabStructure','admission.manageForm.ManageFormStructure',
	         'admission.manageForm.ManageFormQuickSeachForm','admission.manageForm.ManageFormList',
	         'feeandpayment.receipts.MakePaymentWin','admission.applicantFormSaleDirectSubmission.AddAdmissionDetailWindow',
	         'common.PersonHostelRequirementForm'],
     config:{
    	 APPLICATION_MANAGE_FORMS_PRIVILEGES : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_MANAGE_FORMS_PRIVILEGES'),
    	 APPLICATION_PROGRAM_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_PROGRAM_DETAILS_PRIVILEGES'),
    	 CREATE_APPLICATION_ADD_PROGRAM_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CREATE_APPLICATION_ADD_PROGRAM_PRIVILEGES'),
    	 SCHOOL_ATTENDANCE_START_DATE_PRIVILEGES : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOOL_ATTENDANCE_START_DATE_PRIVILEGES'),
     }, 
     refs: [{
    	 ref : 'contentPanel',
    	 selector : 'contentpanel'
     },{
    	 ref : 'applicantCommonForm',
    	 selector : 'applicantcommonform'
     },{
    	 ref: 'manageFormQuickSeachForm',
    	 selector: 'manageformquickseachform'
     },{
    	 ref:'manageFormList',
    	 selector:'manageformlist'
     },{
    	 ref: 'manageFormMakePaymentWindow',
    	 selector: 'makepaymentwindow[itemId=manageFormMakePaymentWindow]'
     },{
    	 ref: 'searchWindow',
    	 selector: 'searchapplicantwindow[itemId=searchApplicationWindowCommon]'
     }, {
    	 ref: 'addProgramWindow',
    	 selector: 'addprogramwindow[itemId=addProgramApplicationCommonFormWindow]'
     }, {
    	 ref: 'addProgramGrid',
    	 selector: 'addprogramgrid'
     },{
    	 ref: 'addProgramWindowGrid',
    	 selector: 'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] grid[itemId=addProgramWindowGrid]'
     },{
     	ref : 'addAdmissionDetailWindow',
     	selector : 'addadmissiondetailwindow[itemId=addAdmissionDetailWindowItem]'
     },{
    	 ref : 'makePaymentWin',
    	 selector : 'makepaymentwin'
     }],
    init: function(application) {
    	this.control({
    		'manageformstructure':{
    			afterrender : function(structure){
    				var grid = structure.down('manageformlist');
    				this.getGridHeaderFreeze(grid,structure);
    			}
    		},
    		'applicantcommonform combo[itemId=cmbApplicationType]': {
    			afterrender: function(combo){
    		        var applicantTypeStore=combo.getStore();
    		           	for(var i=0; i< applicantTypeStore.data.items.length;i++){
    		           		if(applicantTypeStore.data.items[i].data.name == 'APPLIED_EARLIER'){
    		           			applicantTypeStore.removeAt(i);
    		           		} 
    		           	}
    			},
                change: function(combo, record) {
                    var me = this;
                    var applicantForm = combo.up('applicantcommonform');
                    var selectedApplicationType = combo.getValue(); // record[0].get('name');
                    applicantForm.down('#linkStudentCode').setVisible(false);
                    if(selectedApplicationType==='Fresh Applicant' || selectedApplicationType==='FRESH_APPLICANT'){
                    	selectedApplicationType = 'FRESH_APPLICANT';
                    	applicantForm.down('#dispalyCode').setVisible(false);
                    	me.resetApplicationDetailForm();
                    }
                    if (!isNullOrEmpty(selectedApplicationType)) {
                        me.showHideAdmissionDetailWindow(selectedApplicationType, applicantForm);
                        
                        /*V2D-12722*/
                        if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                        var relationShipCombo = applicantForm.down('#relationShipField');
                        var relationShipStore = relationShipCombo.getStore();
                        relationShipCombo.getStore().load({
                        	callback:function(record) {
                        		for(var i in record) {
                        			if(record[i].data.name == relationShipStore.data.items[2].data.name) {
                        				relationShipCombo.setValue(record[i].data.name);
                        				relationShipCombo.setRawValue(record[i].data.displayValue);
                        			}
                        		}
                        	}
                        });
                        }
                    }
                    me.hideInvalidIconFromField(applicantForm);
                }
            },
            'addadmissiondetailwindow form button[itemId=searchButton]': {
            	click: function(button) {
            		var searchWindow = this.getAddAdmissionDetailWindow();
            		var applicantForm = this.getApplicantCommonForm();
            		this.onSearchClick(this, searchWindow, applicantForm);
            	}
            },
            'addadmissiondetailwindow' :{
            	render: function() {
            		var searchWindow = this.getAddAdmissionDetailWindow();
            		searchWindow.down('#enqId').reset();
            		searchWindow.down('#enqName').reset();
            		var storeEnq=searchWindow.down('#enqId');
            		var academyLocationId=this.getCurrentAcademyLocation();
            		storeEnq.getStore().getProxy().extraParams ={
            			academyLocationIds:academyLocationId,
            			onlyOpenEnquiry:true
            		};
            		var storeEnqName=searchWindow.down('#enqName');
            		storeEnqName.getStore().getProxy().extraParams ={
            			onlyOpenEnquiry:true
            		};
            	}
            },
            'addadmissiondetailwindow  combo[itemId=enqId]': {
            	select: function(obj){
            		var searchWindow = this.getAddAdmissionDetailWindow();
            		endId=searchWindow.down('#enqName');
            		studentName=searchWindow.down('#enqName');
            		studentName.reset();
            		var enqId=studentName.getValue();
            		var store = studentName.getStore();
            		store.getProxy().extraParams = {
            			enqId:obj.getValue()
            		};
            		store.load();
            	}
            },
            'applicantcommonform textfield[name=firstName]': {
            	change: this.setPrintAndShortName
            },
            'applicantcommonform textfield[name=middleName]': {
            	change: this.setPrintAndShortName
            },
            'applicantcommonform textfield[name=lastName]': {
            	change: this.setPrintAndShortName
            },
            'applicantcommonform textfield[name=firstNameOtherLanguage]': {
            	change: this.setPrintAndShortOtherLanguageName
            },
            'applicantcommonform textfield[name=middleNameOtherLanguage]': {
            	change: this.setPrintAndShortOtherLanguageName
            },
            'applicantcommonform textfield[name=lastNameOtherLanguage]': {
            	change: this.setPrintAndShortOtherLanguageName
            },
            
            'applicantcommonform radiogroup[name=applicantDetailsId]': {
            	change: function(){
            		var applicantForm = this.getApplicantCommonForm();
            		var selectedApplicationType = applicantForm.down("#cmbApplicationType").getValue();
            		if(selectedApplicationType!=='ENQUIRED_EARLIER'){
            			var grid = this.getAddProgramGrid();
                		grid.getStore().removeAll();                   	
            		}
            		
            	}
            },
            'addadmissiondetailwindow[itemId=addAdmissionDetailWindowItem] button[itemId=importBtn]': {
            	click: function() {
            		var searchWindow = this.getAddAdmissionDetailWindow();
            		var applicantForm = this.getApplicantCommonForm();
            		var selectedApplicationType = applicantForm.down("#cmbApplicationType").getValue();
            		var formNo=applicantForm.getForm().getValues().isFormNoManually;
                   	var token=applicantForm.getForm().getValues().token;
            		this.getDetailsApplicationReset();
            		
            		if(selectedApplicationType==='ENQUIRED_EARLIER'){
            			this.AddDefaultProgram(this,searchWindow,applicantForm);   
            			this.loadDFRForCreateApplicationEnquireEarlier();
            		}
            		if(applicantForm.down('#relationShipField'))
            			applicantForm.down('#relationShipField').getStore().load();
            		//this.onSearchImportButtonClick(this, searchWindow, applicantForm);
            		this.onSearchImportButtonForApplicantFormClick(this, searchWindow, applicantForm);
            		this.setDisplayField(applicantForm,selectedApplicationType);
            		if(!isNullOrEmpty(formNo) && formNo)
                   	{
                   	applicantForm.getForm().findField('isFormNoManually').setValue(true);
                   	applicantForm.down('#formNoId').setVisible(true);
                   	applicantForm.down('#formNoId').setValue(token);
                   	if(isNullOrEmpty(token)){
                   //	applicantForm.down('#formNoId').setEmptyText('');	
                   	}
                   	}
            	}
            },
            'addadmissiondetailwindow[itemId=addAdmissionDetailWindowItem] button[itemId=cancelBtn]': {
                click: function() {
                    this.getAddAdmissionDetailWindow().close();
                }
            },
            'applicantcommonform addprogramgrid': {
            	afterrender:function(grid){
					var me = this;
					me.addDataGridConfigButton(grid,me.getAPPLICATION_PROGRAM_DETAILS_PERMISSIONS());
      	      	}
            },
            'applicantcommonform addprogramgrid button[itemId=btnAdd]': {
                click: function() {
                    var window = this.getAddProgramWindow();
                    if (!window) {
                        window = Ext.widget('addprogramwindow', {
                            itemId: 'addProgramApplicationCommonFormWindow'
                        });
                    }
                    window.show();
                }
            },
            'applicantcommonform addprogramgrid button[itemId=btnDelete]': {
                click: function() {
                    var grid = this.getAddProgramGrid();
                    if (grid) {
                    	this.deleteProgram(this, grid, getAdmissionTranslation('DELETE_PROGRAM'), getAdmissionTranslation('DELETE_PROGRAM_MSG'));
                    }
                }
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] grid[itemId=addProgramWindowGrid]':{
            	afterrender: function(grid) {
           		 var me = this;
           		 me.addDataGridConfigButton(grid,me.getCREATE_APPLICATION_ADD_PROGRAM_PERMISSIONS());
           	 	}
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] button[itemId=resetBtn]':{
            	click:function(){
            		var addProgramWindowGrid = this.getAddProgramWindowGrid();
            		
            		var a = addProgramWindowGrid.down("#cmbAcademyLocations");
            		if( a != undefined ){
            			a.reset();
            			var storeAcademyLocation = a.getStore();
            			if(storeAcademyLocation != undefined){
            				//b.select(storeProgramGroup.getAt(0));
            				storeAcademyLocation.clearFilter();
            				storeAcademyLocation.removeAll();
            				storeAcademyLocation.load();
            			}
            		}
            		
            		var b = addProgramWindowGrid.down("#cmbPgmGroup");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		if( b != undefined ){
            			b.reset();
            			var storeProgramGroup = b.getStore();
            			if(storeProgramGroup != undefined){
            				//b.select(storeProgramGroup.getAt(0));
            				storeProgramGroup.removeAll();
            				storeProgramGroup.getProxy().extraParams = {};
            				var params = storeProgramGroup.getProxy().extraParams;
            				storeProgramGroup.load({
                                scope:this,
                                callback: function(records,option,success){
                                	storeProgramGroup.commitChanges();
                                	c.reset();
                                    b.bindStore(storeProgramGroup);
                                    if(storeProgramGroup.getAt(0)){
                                    	b.select(storeProgramGroup.getAt(0));
                                    	this.addProgramWindowQuickSearch();
                                    }
                                }
            				});
            			}
            		}
            		
            		
            		if( c != undefined ){
            			c.reset();
            			/*var storeProgram = c.getStore();
            			if(storeProgram != undefined){
            				//b.select(storeProgramGroup.getAt(0));
            				storeProgram.removeAll();
            			}*/
            		}
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");
					if (d != undefined) {
						d.reset();
					}
					if (e != undefined) {
						e.reset();
					}
                    var programGroupIds = [];
      	            var selectedProgramId = 0;	
      	            var selectedAcademyLocationId = 0;
      	            var selectedProgramGroup = 0;
                    var isformSaleSelection=true, isformSubmissionSelection=false,whetherAdmissionOpen =true;
              		//this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, programGroupIds, selectedAcademyLocationId, selectedProgramId);
            	}
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] button[itemId=quickSearchId]':{
            	click:function(){
            		this.addProgramWindowQuickSearch();
            	}
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] combo[itemId=cmbAcademyLocations]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                      store.load({
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                                  if(store.getAt(0)){
                                	  //combo.select(store.getAt(0));
                                  }
                          }
                       });
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var programGroupIds = [];
      	            var selectedProgramId = 0;	
      	            var selectedAcademyLocationId = 0;
      	            var selectedProgramGroup = 0;
                    var isformSaleSelection=true, isformSubmissionSelection=false,whetherAdmissionOpen =true;
              		//this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, programGroupIds, selectedAcademyLocationId, selectedProgramId);
              	},
                //change: function(combo, selectedAcademyLocation) {
              	select: function( combo, selectedAcademyLocation, eOpts ) {
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var a = combo;
            		var b = addProgramWindowGrid.down("#cmbPgmGroup");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");
            		var storeProgram = c.getStore();
            		var storeProgramGroup = b.getStore();
            		storeProgram.getProxy().extraParams={
            			academyLocationId:selectedAcademyLocation[0].data.id,
    				};
            		
            		if(selectedAcademyLocation[0].data.id != null){
            			storeProgramGroup.getProxy().extraParams={
            				academyLocationId:selectedAcademyLocation[0].data.id,
        				};
            			storeProgramGroup.load({
                            scope:this,
                            callback: function(records,option,success){
                            	storeProgramGroup.commitChanges();
                                b.bindStore(storeProgramGroup);
                                if(records != null && records != undefined && records != "" && records.length > 0){
                                	if(storeProgramGroup.getAt(0)){
                                    	b.select(storeProgramGroup.getAt(0));
                                    }
                                }
                            }
            			});
            		}
            		
            		if(b != undefined && b.getValue() != null ){
            			storeProgram.getProxy().extraParams.programGroupId = b.getValue();
    	            }
            		if(d != undefined && d.getValue() != null ){
            			storeProgram.getProxy().extraParams.modeDeliveryId = d.getValue();
    	            }
            		var regTypeEnum = null;
					if (e != undefined && e.getValue() != null) {
						if(e.getValue()=="FULL_TIME"){
							regTypeEnum = false;
						}else if(e.getValue()=="PART_TIME"){
							regTypeEnum = true;
						}
					}
					if (regTypeEnum!=null) {	
						storeProgram.getProxy().extraParams.registrationTypeEnum = regTypeEnum;
					}
					var applicantCommonForm=this.getApplicantCommonForm();
            		var applicationType=applicantCommonForm.down('#applicantDetailsId').getValue();
            		if(applicationType.whehterDirectSubmission){
            			isformSubmissionSelection=true;
            			isformSaleSelection=false;
            			whetherAdmissionOpen=false;
            		}else{
            			isformSaleSelection=true;
            			isformSubmissionSelection=false;
            			whetherAdmissionOpen=false;
            		}
            		storeProgram.getProxy().extraParams={
            			isformSaleSelection:isformSaleSelection,
            			isformSubmissionSelection:isformSubmissionSelection,
            			whetherAdmissionOpen:whetherAdmissionOpen
            			//programGroupId:selectedProgramGroup[0].data.id,
    				};
            		storeProgram.load();
            		/*storePrograms.load({
                        scope:this,
                        callback: function(records,option,success){
                        	storePrograms.commitChanges();
                            combo.bindStore(storePrograms);
                             if(storePrograms.getAt(0)){
                           	  //combo.select(store.getAt(0));
                             }
                        }
                    });*/
                },
                keyup: function( me, e, eOpts ){
                	if(e.keyCode == 38 || e.keyCode == 40){
                		return false; 
                	}
                	else
                	{
                		var store = me.getStore();
                		store.clearFilter();
                		if(me.getValue()!=null)
                		{
                			store.filter({
                				property: 'value',
                				value: me.getValue(),
                				anyMatch: true,
                				caseSensitive: false
                			});
                		}
                	}

                }
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] combo[itemId=cmbPrograms]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            		var applicantCommonForm=this.getApplicantCommonForm();
            		var applicationType=applicantCommonForm.down('#applicantDetailsId').getValue();
            		if(applicationType.whehterDirectSubmission){
            			isformSubmissionSelection=true;
            			isformSaleSelection=false;
            			whetherAdmissionOpen=false;
            		}else{
            			isformSaleSelection=true;
            			isformSubmissionSelection=false;
            			whetherAdmissionOpen=false;
            		}
            		
            		store.getProxy().extraParams={
            			isformSaleSelection:isformSaleSelection,
            			isformSubmissionSelection:isformSubmissionSelection,
            			whetherAdmissionOpen:whetherAdmissionOpen
            			//programGroupId:selectedProgramGroup[0].data.id,
    				};
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                      store.load({
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                                  if(store.getAt(0)){
                                	  //combo.select(store.getAt(0));
                                  }
                          }
                       });
              	}
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] combo[itemId=cmbPgmGroup]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                      store.load({
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                                  if(store.getAt(0)){
                                	  combo.select(store.getAt(0));
                                	  this.addProgramWindowQuickSearch();
                                  }
                          }
                       });
                      
                      this.setAllowBlank(combo,false);
                      //this.addProgramWindowQuickSearch();
              	},
                change: function(combo, selectedProgramGroup) {
              	//select: function( combo, selectedProgramGroup, eOpts ) {
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var a = addProgramWindowGrid.down("#cmbAcademyLocations");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");
            		var storeProgram = c.getStore();
            		var applicantCommonForm=this.getApplicantCommonForm();
            		var applicationType=applicantCommonForm.down('#applicantDetailsId').getValue();
            		if(applicationType.whehterDirectSubmission){
            			isformSubmissionSelection=true;
            			isformSaleSelection=false;
            			whetherAdmissionOpen=false;
            		}else{
            			isformSaleSelection=true;
            			isformSubmissionSelection=false;
            			whetherAdmissionOpen=false;
            		}
            		
            		storeProgram.getProxy().extraParams={
            			programGroupId:selectedProgramGroup,
            			isformSaleSelection:isformSaleSelection,
            			isformSubmissionSelection:isformSubmissionSelection,
            			whetherAdmissionOpen:whetherAdmissionOpen
            			//programGroupId:selectedProgramGroup[0].data.id,
    				};
            		
            		if(a != undefined && a.getValue() != null ){
            			storeProgram.getProxy().extraParams.academyLocationId = a.getValue();
    	            }
            		if(d != undefined && d.getValue() != null ){
            			storeProgram.getProxy().extraParams.modeDeliveryId = d.getValue();
    	            }
            		var regTypeEnum = null;
					if (e != undefined && e.getValue() != null) {
						if(e.getValue()=='FULL_TIME'){
							regTypeEnum = false;
						}else if(e.getValue()=='PART_TIME'){
							regTypeEnum = true;
						}
					}
					if (regTypeEnum!=null) {	
						storeProgram.getProxy().extraParams.registrationTypeEnum = regTypeEnum;
					}
            		
            		storeProgram.load();
            		/*storePrograms.load({
                        scope:this,
                        callback: function(records,option,success){
                        	storePrograms.commitChanges();
                            combo.bindStore(storePrograms);
                             if(storePrograms.getAt(0)){
                           	  //combo.select(store.getAt(0));
                             }
                        }
                    });*/
            		//this.addProgramWindowQuickSearch();
                }
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] combo[itemId=modeDeliveryId]' : {
				afterrender : function(combo) {
					var store = combo.getStore();
					var me=this;
					store.getProxy().api.read = this.getUrlOfStore(store);
					store.load({
								scope : this,
								callback : function(records, option, success) {
									store.commitChanges();
									combo.bindStore(store);
									if (store.getAt(0)) {
										// combo.select(store.getAt(0));
										
									}
								}
							});

					this.setAllowBlank(combo, true);
				},
				change : function(combo,
						selectedModeOfDelivery) {
					var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var a = addProgramWindowGrid.down("#cmbAcademyLocations");
                    var b = addProgramWindowGrid.down("#cmbPgmGroup");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");

					var storeProgram = c.getStore();
					
					var applicantCommonForm=this.getApplicantCommonForm();
            		var applicationType=applicantCommonForm.down('#applicantDetailsId').getValue();
            		if(applicationType.whehterDirectSubmission){
            			isformSubmissionSelection=true;
            			isformSaleSelection=false;
            			whetherAdmissionOpen=false;
            		}else{
            			isformSaleSelection=true;
            			isformSubmissionSelection=false;
            			whetherAdmissionOpen=false;
            		}
					
					storeProgram.getProxy().extraParams = {
						modeDeliveryId : selectedModeOfDelivery,
						isformSaleSelection:isformSaleSelection,
            			isformSubmissionSelection:isformSubmissionSelection,
            			whetherAdmissionOpen:whetherAdmissionOpen
					};

					if (a != undefined
							&& a.getValue() != null) {
						storeProgram.getProxy().extraParams.academyLocationId = a
								.getValue();
					}

					if (b != undefined
							&& b.getValue() != null) {
						storeProgram.getProxy().extraParams.programGroupId = b
								.getValue();
					}
					if (d != undefined
							&& d.getValue() != null) {
						storeProgram.getProxy().extraParams.modeDeliveryId = d
								.getValue();
					}
					var regTypeEnum = null;
					if (e != undefined && e.getValue() != null) {
						if(e.getValue()=='FULL_TIME'){
							regTypeEnum = false;
						}else if(e.getValue()=='PART_TIME'){
							regTypeEnum = true;
						}
					}
					if (regTypeEnum!=null) {	
						storeProgram.getProxy().extraParams.registrationTypeEnum = regTypeEnum;
					}

					storeProgram.load();
					
				}
			},
			'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] combo[itemId=registrationTypeId]' : {
				afterrender : function(combo) {
					var store = combo.getStore();
					store.getProxy().api.read = this.getUrlOfStore(store);
						store.load({
								scope : this,
								callback : function(records, option, success) {
									store.commitChanges();
									combo.bindStore(store);
									if (store.getAt(0)) {
									}
								}
							});

					this.setAllowBlank(combo, true);
					// this.addProgramWindowQuickSearch();
				},
				change : function(combo,
						selectedRegistrationType) {
					var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var a = addProgramWindowGrid.down("#cmbAcademyLocations");
                    var b = addProgramWindowGrid.down("#cmbPgmGroup");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
					var regTypeEnum=null;
					
					if(selectedRegistrationType!=null){
						if(selectedRegistrationType=='FULL_TIME'){
							regTypeEnum=false;
						}else if(selectedRegistrationType=='PART_TIME'){
							regTypeEnum=true;
						}
					}

					var storeProgram = c.getStore();
					var applicantCommonForm=this.getApplicantCommonForm();
            		var applicationType=applicantCommonForm.down('#applicantDetailsId').getValue();
            		if(applicationType.whehterDirectSubmission){
            			isformSubmissionSelection=true;
            			isformSaleSelection=false;
            			whetherAdmissionOpen=false;
            		}else{
            			isformSaleSelection=true;
            			isformSubmissionSelection=false;
            			whetherAdmissionOpen=false;
            		}
					
					if(regTypeEnum!=null){
						storeProgram.getProxy().extraParams = {
							registrationTypeEnum : regTypeEnum,
							isformSaleSelection:isformSaleSelection,
	            			isformSubmissionSelection:isformSubmissionSelection,
	            			whetherAdmissionOpen:whetherAdmissionOpen
						};
					}
					
					if (a != undefined
							&& a.getValue() != null) {
						storeProgram.getProxy().extraParams.academyLocationId = a
								.getValue();
					}

					if (b != undefined
							&& b.getValue() != null) {
						storeProgram.getProxy().extraParams.programGroupId = b
								.getValue();
					}
					if (d != undefined
							&& d.getValue() != null) {
						storeProgram.getProxy().extraParams.modeDeliveryId = d
								.getValue();
					}

					storeProgram.load();
				}
			},
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] button[itemId=addProgramBtn]': {
                click: function() {
                    var programTabGrid = this.getAddProgramGrid();
                    var programWindow = this.getAddProgramWindow();
                    var addProgramWindowGrid = this.getAddProgramWindowGrid();
                    var b = addProgramWindowGrid.down("#cmbPgmGroup");
                    if(b != undefined){
                    	if( !(b.getValue() == null || b.getValue() == undefined || b.getValue()=="") ){
                    		if(this.validateMaxProgramsAllowed(programTabGrid,programWindow,addProgramWindowGrid)){
                            	this.addProgram(this, programTabGrid, programWindow, addProgramWindowGrid);
                            }
                    	}else{
                    		showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('SELECT_PROGRAM_GROUP_ERR_MSG'));
                    	}
                    }
                }
            },
            'addprogramwindow[itemId=addProgramApplicationCommonFormWindow] button[itemId=cancelProgramBtn]': {
                click: function() {
                    this.getAddProgramWindow().close();
                }
            },
            'applicantcommonform button[itemId=btnAddRelationshipDetails]': {
                 click : this.addRelationshipDetailContainer
            },
            'applicantcommonform button[itemId=addRelationBtn]': {
                click : this.addRelationshipDetailContainer
           },
            'applicantcommonform button[itemId=SubmitAndGenerateFormNoBtn]': {
            	click : this.saveApplicationDetailsForm
            },
            'applicantcommonform button[itemId=resetBtn]': {
            	click : this.resetApplicationDetailForm
            },
            'applicantcommonform checkboxfield[itemId=relationshipCheckbox]': {
            	change : function($this,data){
            		var form = $this.up('applicantcommonform');
            		this.ShowHideOrganizationDetails(form,$this.getValue());
            	}
            },
            'applicantcommonform combo[itemId=relationshipStudent]':{
       			select:this.setStudentRelatedDetails
            },
            'applicantcommonform combo[itemId=relationshipUser]':{
       			select:this.setEmployeeRelatedDetails
            },
            'applicantcommonform combo[itemId=relationShipField]':{
       			change:function(combo,data){
    				  this.setRelationShipDetails(combo,data);
    			  },
    			  render:function(combo,record){
    				  if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
              			var relationship=combo.getStore();
              			relationship.on('load', function(){
              				for(var i=0; i< relationship.data.items.length;i++){
              					if(relationship.data.items[i].data.name == 'LOCAL_GUARDIAN'){
              						relationship.removeAt(i);
              					} 
              				}
              			});
              		}
    			  }
            },
            'applicantcommonform checkboxfield[itemId=whetherHostelApplicable]': {
         	   change: function(obj,newValue,oldValue) {
         		   var form = obj.up('form');
         		   var hostelFieldsContainer1 = form.down('#hostelFieldsContainer1');
         		   var hostelFieldsContainer2 = form.down('#hostelFieldsContainer2');
         		   
         		   if( newValue ){
         			   hostelFieldsContainer1.setVisible(true);
         			   hostelFieldsContainer2.setVisible(true);
         		   } else{
         			   hostelFieldsContainer1.setVisible(false);
         			   hostelFieldsContainer2.setVisible(false);
         		   }
                }
            },
            'applicantcommonform': {
            	afterrender:function(form) {
            		
            		var $this = this
            		form.body.on('click', function() {
            			$this.hideInvalidIconFromField(form);
            		});
            		var hostelFieldsContainer1 = form.down('#hostelFieldsContainer1');
            		var hostelFieldsContainer2 = form.down('#hostelFieldsContainer2');
            		/* V2D-504705 */
            		if(form.xtype == 'applicantcommonform' && form.title == 'Create Application') {
            			if(form.down('#relationshipUser')) {
            				form.down('#relationshipUser').allowBlank = true;
            				form.down('#relationshipUser').validate();
            			}
            			if(form.down('#relationshipStudent')) {
            				form.down('#relationshipStudent').allowBlank = true;
            				form.down('#relationshipStudent').validate();
            			}
            		}
            		/* V2D-504705 */
            		/*if( newValue ){
          			   hostelFieldsContainer1.setVisible(true);
          			   hostelFieldsContainer2.setVisible(true);
          		   } else{*/
            		hostelFieldsContainer1.setVisible(false);
            		hostelFieldsContainer2.setVisible(false);
            		///}
            		var formNoId = form.down("#formNoId");
            		var isFormNoManually=form.getForm().getValues().isFormNoManually;
            		formNoId.reset();
            		if(isFormNoManually){
            			formNoId.setVisible(true);
            			formNoId.setReadOnly(false);
            			formNoId.emptyText=' ';
            			formNoId.applyEmptyText();
            			formNoId.allowBlank=false;
            			formNoId.labelSeparator = '';
            			formNoId.setFieldLabel(getAdmissionTranslation('FORM_NO')+'<span class="required" style="color:red"> *</span>');
            		}else{
            			formNoId.setVisible(false);
            			formNoId.setReadOnly(true);
            			formNoId.emptyText=getCommonTranslation('ID_AUTOGENERATE');
            			formNoId.applyEmptyText();
            			formNoId.allowBlank=true;
            		}
    		        if(isNullOrEmpty(form.down('#relationShipField').getValue())){
    		        	form.down('#relationshipStudent').setVisible(false);
    		        	form.down('#relationshipUser').setVisible(false);
    		        }
            		if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){

            			var allowblankFalse = '<span class="required" style="color:red"> *</span>';
            			
            			var relationShipCombo = form.down('#relationShipField');
            			relationShipCombo.allowBlank = false;
            			relationShipCombo.labelSeparator = '';
            			relationShipCombo.setFieldLabel(getPersonModuleTranslation('RELATIONSHIP')+allowblankFalse);
            			
            			var relationshipName = form.down('#relationshipName');
            			relationshipName.allowBlank = false;
            			relationshipName.labelSeparator = '';
            			relationshipName.setFieldLabel(getAdmissionTranslation('NAME')+allowblankFalse);
            			
            			var mobileCodeContainer = form.down('#relationshipMobileCountryFieldContainerId');
            			mobileCodeContainer.setFieldLabel(getAdmissionTranslation('MOBILE_NO')+allowblankFalse);
            			
            			var relationshipMobileCountryCode = form.down('#relationshipMobileCountryCodeItemId');
            			relationshipMobileCountryCode.allowBlank = false;
            			
            			var relationshipMobileNo = form.down('#relationshipMobileNo');
            			relationshipMobileNo.allowBlank = false;
            			
            			var relationshipEmail = form.down('#relationshipEmail');
            			relationshipEmail.allowBlank = false;
            			relationshipEmail.labelSeparator = '';
            			relationshipEmail.setFieldLabel(getAdmissionTranslation('EMAIL_ID')+allowblankFalse);
            			
            			var applicantType = form.down('#cmbApplicationType');
            			var relationShipStore = relationShipCombo.getStore();
            			if(applicantType.getValue() == 'FRESH_APPLICANT'){            				
            				//relationShipCombo.setValue(relationShipStore.data.items[2]);
            			  	relationShipCombo.getStore().load({
            		           	callback:function(record) {
            		           	for(var i in record) {
            		           	if(record[i].data.name == relationShipStore.data.items[2].data.name) {
            		           	/*relationShipCombo.setValue(relationShipStore.data.items[2].data.name);
            		           	relationShipCombo.setRawValue(relationShipStore.data.items[2].data.displayValue);*/
            		           	relationShipCombo.setValue(record[i].data.name);
            		           	           relationShipCombo.setRawValue(record[i].data.displayValue);
            		           	}
            		           	}
            		           	}
            		           	});
            			}
            		} else {
            			if( form != null ){
                    		var countryCodeFieldItemIDArray = ["#phoneCountryCode","#cellCountryCode","#relationshipMobileCountryCodeItemId"];
                		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                		    var countryCodeField = form.down("#cellCountryCode");
                         	var mobileField = form.down("#mobileNumber");
                         	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                		}
            		}
            		if( form != null ){
                		var countryCodeFieldItemIDArray = ["#phoneCountryCode","#cellCountryCode","#relationshipMobileCountryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#cellCountryCode");
                     	var mobileField = form.down("#mobileNumber");
                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		}
            		/* hide hostel details input if current logged in AL is not configured for
            		whether boarding required */
            		var academyLocationId=this.getCurrentAcademyLocation();
            		var params = {
            				academyLocationId : academyLocationId
                   	};
                   	var submitUrl = SERVERURL.PATH_FIND_ALL_PROGRAM_GROUP_BY_ACADEMY_LOCATION;
                   	var boardingPresent = false;
                   	
                   	this$.sendGetAjaxRequest(submitUrl, 'GET', params, function(option, success, response) {
                       	if(success){
                       		if(!isNullOrEmpty(response.responseText)){
                       			var data = Ext.decode(response.responseText);
                       			if(!isNullOrEmpty(data)){
                       				for(var index in data){
                       					var obj = data[index];
                       					if( obj.isBoardingSchool == true ){
                       						boardingPresent = true;
                       						break;
                       					}
                       				}
                       			}
                       		}
                       		if(!boardingPresent){
                       			form.down('#hostelRequiredDetailsItemId').setVisible(false);
                       		}
                       	} 
                     });
            	}
            },
            
            'applicantcommonform nestedJsonCombo[itemId=salutation]':{
            	afterrender:function(combo,data){
            		var form = combo.up('applicantcommonform');
            		combo.getStore().load();
            		var formNoId = form.down("#formNoId");
            		var isReadOnly = formNoId.readOnly; 
            		if(!isReadOnly){
            			form.down("#formNoManuallyId").setVisible(false);
            		}
            	}
            },
            'applicantcommonform radiogroup[itemId=formNoManuallyId]':{
            	change:function(obj,data){
            		var form = obj.up('applicantcommonform');
            		var formNoId = form.down("#formNoId");
            		var value = obj.getValue();
            		var isFormNoManually = value.isFormNoManually;
            		formNoId.reset();
            		if(isFormNoManually){
            			formNoId.setVisible(true);
            			formNoId.setReadOnly(false);
            			formNoId.emptyText=' ';
            			formNoId.applyEmptyText();
            			formNoId.allowBlank=false;
            			formNoId.labelSeparator = '';
            			formNoId.setFieldLabel(getAdmissionTranslation('FORM_NO')+'<span class="required" style="color:red"> *</span>');
            		}else{
            			formNoId.setVisible(false);
            			formNoId.setReadOnly(true);
            			formNoId.emptyText=getCommonTranslation('ID_AUTOGENERATE');
            			formNoId.applyEmptyText();
            			formNoId.allowBlank=true;
            		}
            		formNoId.validate();
            		Ext.resumeLayouts();
            	}
            },
    		'manageformquickseachform button[itemId=manageFormSearchBtn]': {
    			click: this.getSearchManageForm
    		},
    		'manageformquickseachform button[itemId=manageFormResetBtn]': {
    			click: this.getResetManageForm
    		},
    		'manageformquickseachform [itemId=academyLocationCombo]':{
    			render : this.loadALComboForSearch,
    			
    			select: function(combo, record) {
            		var appForm = combo.up('form');
            		var acadLocId = record[0].get('id');
					var programGroupCombo = combo.up('form').down('#programGroupCombo');
					programGroupCombo.reset();
            		var programComboField = combo.up('form').down('#programId');
                	var academyLocationCombo = combo.getValue();
                	this.loadDependentManageFormCombo(programComboField, academyLocationCombo, 'academyLocationIds');
                	
                },
    			/*change: function(combo, records, eOpts) {
	                var programComboField = combo.up('form').down('#programId');
                    var comboValue = combo.getValue();
                    this.loadDependentManageFormCombo(programComboField, comboValue, 'academyLocationIds');
	            }*/
    		},
    		'manageformquickseachform [itemId=programGroupCombo]':{
    			render : function(combo, record) {
    				this.loadWithAllValue(combo);
    			},
    			select: function(combo, record) {
    				var $this = this;
    				var form = $this.getManageFormQuickSeachForm().getForm();
    				var programCombo = form.findField('program');
    				var alId = form.findField('academyLocation').getValue();
					/*
    				programCombo.getStore().getProxy().extraParams={
    					academyLocationIds:alId,
    					programGroupId:record[0].data.id
    				};
    				programCombo.getStore().load();*/
					this.loadDependentManageFormCombo(programCombo, alId, 'academyLocationIds','programGroupId',record[0].data.id);
                },
    		},
    		'manageformquickseachform [itemId=programId]':{
    			/*change: function(combo, records, eOpts) {
	                var batchComboField = combo.up('form').down('#batchId');
	                var comboValue = combo.getValue();
	                this.loadDependentManageFormCombo( batchComboField, comboValue, 'id');
	            },*/
	            select: function(combo, record) {
            		
            		var batchComboField = combo.up('form').down('#batchId');
 	                var comboValue = combo.getValue();
 	                this.loadDependentManageFormCombo(batchComboField, comboValue, 'id');                	
                },
    		},
    		'manageformquickseachform [itemId=batchId]':{
    			change: function(combo, records, eOpts) {
	                var batchComboField = combo.up('form').down('#seatTypeId');
	                var comboValue = combo.getValue();
	                this.loadDependentManageFormCombo( batchComboField, comboValue, 'batchId');
	            }
    		},
    		'manageformlist':{
    			cellclick : this.getCheckButtonStaus,
    			render : function(grid){
    				this.doAccessControlValidation(grid, this.getAPPLICATION_MANAGE_FORMS_PRIVILEGES());
    				this.disableMoreButtonPivileges(grid,this.getAPPLICATION_MANAGE_FORMS_PRIVILEGES());
    				var buttonsToolBar = grid.query('toolbar')[0];
    		    	var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
    		    	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    		    	pdftoolbar.setDisabled(true);
    		    	exceltoolbar.setDisabled(true);
    			},
    			selectionchange: function(column, selected,eOpts ){
    				var me = this;
    				setTimeout(function (){
    					me.disableManageFormGridExtraButton(column,selected);
    				}, 300);
    			},
    			afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getAPPLICATION_MANAGE_FORMS_PRIVILEGES());
                 }
    		},
    		'manageformlist button[itemId=btnEdit]':{
    			click : this.getEditApplicationDeatils
    		},
    		'manageformlist button[itemId=btnDelete]':{
    			click: function(){
                	this.deleteSelectedApplication(true);
                }
    		},
    		'manageformlist menuitem[itemId=assignApplicationID]': {
    			click: function(item, e, eOpts) {
    				var assignApplicationIdGrid = this.getManageFormList();
    				this.assignApplicationIdForManageForm(this, assignApplicationIdGrid);
    			}
    		},
    		'manageformlist button[itemId=collectPayment]': {
                click: function(button, e, eOpts) {
                	 var grid = this.getManageFormList();
                     var window = this.getManageFormMakePaymentWindow();
                     this.showMakePaymentWindowForManageForm(grid, window, 'manageFormMakePaymentWindow');
                }
            },
            'makepaymentwin[itemId=manageFormMakePaymentWindow] button[itemId=SubmitBtn]': {
            	click: function(button) {
            		var print = false;
            		this.createBillForManageForm(button,print);
            	}
            },
            'makepaymentwin[itemId=manageFormMakePaymentWindow] button[itemId=SubmitAndPrintMakePaymentBtn]': {
            	click: function(button) {
            		var print = true;
            		this.createBillForManageForm(button,print);
            	}
            },
            'manageformlist button[itemId=submitForm]': {
                click: this.getSubmitApplicationForm
            },
            'makepaymentwin[itemId=manageFormMakePaymentWindow] button[itemId=collectPaymentResetBtn]': {
            	click: function(button) {
            		this.createBillForManageFormReset(button);
            	}
            },
            'applicantcommonform customcombobox[itemId=applicationOwner]' :{
            	render: function(combo) {
            		var locations = [];
            		var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
            		for(var i=0; i<academyLocationList.length; i++){
            			locations.push(academyLocationList[i].id);
            		}
            		enquryOenerStore = combo.getStore();
            		enquryOenerStore.getProxy().extraParams = {
            			academyLocationIds: locations.join()
            		};
            		var user=this.getCurrentlyLoggedInUser();
            		var userId = user.id;
            		enquryOenerStore.load({
            			callback: function(record, operation, success) {
            				if (success) {
            					combo.setValue(userId);
            				}
            			}
            		});
            		//followUpUserStore.load();
            	}
            },
            
            
            'makepaymentwin[itemId=manageFormMakePaymentWindow] combo[itemId=receivingCurrency]':{
            	
            	select: function(obj,rec) {
            		 var $this = this;
            		var academyLocationId = $this.getCurrentAcademyLocation();
            		var grid = $this.getManageFormList();
	            		var record = grid.getSelectionModel().getSelection()[0];
	            		var formWindow=$this.getMakePaymentWin();
	            		
	            		var fromCurrencyId = record.raw.currencyId;
	            		var fromCurrencyName = record.raw.currencyName;
	            		
	            		 var discountAmount=record.data.discountAmount;
	            		
	            		
	            		var date=formWindow.down('#transactionDate');
	            	//	var receiptDate=date.rawValue;
	            		var receiptDate = Ext.Date.format(new Date(date.getValue()),CONSTANTS.NEW_SUBMIT_DATE_FORMAT)
	            		var feeAmount = record.data.feeAmount;
	            		
	            		var currency = formWindow.down('#receivingCurrency');
	            		var toCurrencyId=null;
	            		var toCurrencyName=null;
	            		if(currency!=null){
  	            			toCurrencyId = currency.getValue();
  	            			toCurrencyName = currency.getRawValue();            			
  	            		}
            		
            		Ext.Ajax.request({
  		    		  method: "GET",
  		    		  type: 'rest',
  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
  		    		  params:{
  		    			  academyLocationId:academyLocationId
  		    		  },
  		    		  success: function(response) {
  		    			  if(response){
  		    				  result=response.responseText;
  		    				  if(result === "true")
  		    				  {

  		    					  Ext.Ajax.request({
  		    						  type: 'rest',
  		    						  url: SERVERURL.PATH_CONVERTED_AMOUNT_BILLING_CURRENCY, 												 
  		    						  method: 'GET',
  		    						  headers: {
  		    							  'Content-Type': 'application/json'
  		    						  },
  		    						  params: {
  		    							  fromCurrencyId:fromCurrencyId,
  		    							  toCurrencyId:toCurrencyId,
  		    							  receiptDate : receiptDate,
  		    							  feeAmount : feeAmount,
  		    							  discountAmount  : discountAmount

  		    						  },
  		    						  success:function(form,action) {
  		    							  var data = Ext.JSON.decode(form.responseText);
  		    							  var amountField = formWindow.down('numberfield#amount').setValue(data[0]);
  		    							  var discountAmount = formWindow.down('#discountAmount').setValue(data[1]);
  		    							  var instrumentAmountField = formWindow.down('numberfield#instrumentAmount').setValue(data[0]);

  		    						  },
  		    						  failure: function(form, action) {
  		    							  var currencyField = formWindow.down('nestedJsonCombo#receivingCurrency');
  		    							  currencyField.setValue(record.raw.currencyName);
  		    							  var amountField = formWindow.down('numberfield#amount');
  		    							  amountField.setValue(record.get('feeAmount'));
  		    							  var discountAmount = formWindow.down('#discountAmount');
  		    							  discountAmount.setValue(record.get('discountAmount'));
  		    							  var instrumentAmountField = formWindow.down('numberfield#instrumentAmount');
  		    							  instrumentAmountField.setValue(record.get('feeAmount'));

  		    						  }

  		    					  });
  		    				  }

  		    			  }
  		    			
  	            		
  	            	
  		    	    		
  		    		  }
  		    	  });
            		
            		
            		
            	
            	
            	}
            },
            'manageformlist menuitem[itemId=sendReminder]': {
                click: this.sendReminder
            },
            
            'applicantcommonform customcombobox[itemId=cellCountryCode]' :{
            	select:function(rowModel,record) {
            		var form = this.getApplicantCommonForm();
            		var countryCodeField = form.down("#cellCountryCode");
                 	var mobileField = form.down("#mobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
            	}
            },
            'applicantcommonform numberfield[itemId=mobileNumber]' :{
            	change:function(record) {
            		var form = this.getApplicantCommonForm();
                 	var mobileField = form.down("#mobileNumber");
                 	mobileField.isValid();
        			form.getForm().checkValidity();
            	}
            },
            'makepaymentwin':{
            	render:function(win){
    				var $this = this
    				win.body.on('click', function() {
    					var form = win.down('idgeneratorcustomform');
    					$this.hideInvalidIconFromField(form);
    			       });
    			},
    			 afterrender:function(form) {
   				  form.down("#costCentre").setFieldLabel(getFeeAndPaymentCommonTranslation('COST_CENTER'));
   			  }
            }
    	});
    },
    /**
     * load Al by user Id
     */
    loadALComboForSearch: function(combo) {
    	var me = this;
    	var store = combo.getStore();
    	store.getProxy().extraParams = {
    		id: this.getCurrentlyLoggedInUser().id
    	};
    	store.load({
    		callback:function(records,response,success){
    			combo.setValue(me.getCurrentAcademyLocation())
    		}
    	});
    },
	
	 /**
     * load all combo 
     */
	loadWithAllValue:function(combo){
		var $this = this;
		var form = $this.getManageFormQuickSeachForm().getForm();
		var programCombo = form.findField('program');
			var alId=$this.getCurrentAcademyLocation()
			this.loadDependentManageFormCombo(programCombo, alId, 'academyLocationIds');
		/*	programCombo.getStore().getProxy().extraParams={
				academyLocationIds:
			};
			programCombo.getStore().load();*/	
	    	combo.getStore().load({
			callback: function(records, operation, success) {                            
				var model = new Academia.model.common.IdValueDataModel();
                model.set('id','');
                model.set('value', 'All');
                combo.getStore().insert(0,model);
            }
		});
    },
    
    /**
     * This function is to load the dependent combo
     */
    loadDependentManageFormCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdownField(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
            dependentCombo.setDisabled(false);
			delete store.getProxy().extraParams;
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }else{
            dependentCombo.setDisabled(true);
        }
    },
    resetOtherDropdownField: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'programId':
            this.clearCombos(combo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombos(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombos(seatTypeCombo);
            break;
        case 'batchId':
        	this.clearCombos(combo);
        	seatTypeCombo = container.down('combo[itemId=seatTypeId]');
        	this.clearCombos(seatTypeCombo);
        	break;
        case 'seatTypeId':
        	this.clearCombos(combo);
        }
    },
    /**
     * This function is to clear the combo value
     */
    clearCombos: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    /**
     * search grid data
     */
    getSearchManageForm : function(){
    	 var $this=this;
    	 var form = this.getManageFormQuickSeachForm();
    	 var formValue = form.getValues();
    	 var flag=1;
    	 var applicationIdValue = formValue.applicationType ;
    	 form.down('#manageFormSearchBtn').setDisabled(true);
    	 if(!isNullOrEmpty(applicationIdValue))
    		 {
    	 if(applicationIdValue == 'WithApplicationId')
		 {
    	 forAllApplicationType = false ;
		 applicationIdNull = false;
		 }else if(applicationIdValue == 'AllApplications'){
			 forAllApplicationType = true ;
			 applicationIdNull = null ; 
		 }
		 else {
			 applicationIdNull = true;
			 forAllApplicationType = false ;
			 }
    		 }
    	 var academyLocationId = formValue.academyLocation;
    	 
    	 if(isNullOrEmpty(applicationIdNull) || applicationIdNull==false){
    		 flag = 2;
    	 }
    	 if(isNullOrEmpty(formValue.academyLocation)){
    		 var baseController = Academia.app.getController('Academia.controller.base.BaseController');
    		 var academyLocationId = baseController.getCurrentAcademyLocation();
    	 }
    	 
    	 var grid = this.getManageFormList();
    	 var buttonsToolBar = grid.query('toolbar')[0];
	     var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	     var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	 var store = grid.getStore();
    	 store.getProxy().extraParams = {
    		 feePlanType : flag,
    		 token : formValue.FormNo,
    		 applicationId:formValue.applicationId,
    		 applicantName : formValue.applicantName,
    		 code:formValue.code,
    		 applicationIdNull :applicationIdNull,
    		 forAllApplicationType : forAllApplicationType,
    		 academyLocationId : academyLocationId,
    		 ProgramGroupId : formValue.programGroup,
    		 programId : formValue.program,
    		 batchId : formValue.batch,
    		 seatTypeId : formValue.seatType,
    		 fromDate : formValue.fromDate,
    		 toDate : formValue.toDate,
    		 emailId : formValue.email,
    		 receiptNo : formValue.receiptNo,
		 };
    	 $this.resetPageSetting(store);
    	 store.load({
		    	  callback: function(records, operation, success) {
		    		  form.down('#manageFormSearchBtn').setDisabled(false);
						if(records.length>0){
					    	pdftoolbar.setDisabled(false);
					    	exceltoolbar.setDisabled(false);
						}
					  }
  				});
    	 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
     	
     	grid.config.searchFilterForm = $this.getManageFormQuickSeachForm();
     	
        /***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    getResetManageForm : function(){
    	var form = this.getManageFormQuickSeachForm();
    	var BaseController = Academia.app.getController('Academia.controller.base.BaseController');
    	form.getForm().getFields().each(function(field) {
    		if(field.itemId !='academyLocationCombo'){
    			field.reset();
    		}else{
    			field.setValue(BaseController.getCurrentAcademyLocation());
    		}
    		if(field.itemId =='batchId'){
    			field.setDisabled(true);
    		}
    	});
    },
    /**
     * This function is used for to assign Application Id to application after clicking on 'Assign Application Id' button.   
     */
    assignApplicationIdForManageForm: function(me, grid) {
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            var url = SERVERURL.GENERATE_APPLICATION_ID;
            url = url.concat('?applicationId='+record.get('applicationId'));
           
            if (!isNullOrEmpty(record.get("applicationId"))) {
	                Ext.Ajax.request({
	                    type: 'rest',
	                    url: url, 												 
	                    method: 'POST',
	                    headers: {
	                        'Content-Type': 'application/json'
	                    },
	                   /* params: {
	                        applicationId: record.get("applicationId")
	                    },*/
	                    success: function(form, action) {
	                        grid.getStore().reload();
	                        Ext.getBody().unmask();
	                        grid.getSelectionModel().deselectAll();
	                        showSuccessMessage(getAdmissionTranslation('ASSIGN_APPLICATION_ID'), getAdmissionTranslation('ASSIGN_APPLICATION_ID_MSG')); //Application Id assigned successfully.
	                    }
	                });
	        } else {
	        	showWarningMessage(getAdmissionTranslation('ASSIGN_APPLICATION_ID'), getAdmissionTranslation('ASSIGNED_APPLICATION_ID')); //Application Id already assigned
	            Ext.getBody().unmask();
	        }   
        } else {
        	showWarningMessage(getAdmissionTranslation('ASSIGN_APPLICATION_ID'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        	Ext.getBody().unmask();
        }
    },
    /**
     * This function is used for to show make payment form after clicking on 'Make Payment' button.
     * first Calls the server and checks if payment is done or no
     * if payment is not done, Then opens the payment window.
     * feeStageName hardcoded as per the inputs from Serosoft team
     * @author Rajkumar.patidar
     */
    showMakePaymentWindowForManageForm: function(grid, window, itemIdValue) {
    	var me = this;
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection()[0];
            if(!isNullOrEmpty(record.get('feePlanName'))) {
	            var url = SERVERURL.CHECK_FOR_PAYMENT;
	            url = url.concat('?applicationId='+record.get('applicationId'));
	            var feeStageName = record.get("feeStage");
	           /* if(itemIdValue === 'assignApplicationMakePayment'|| itemIdValue === 'applicationFeeMakePayment') {
	            	feeStageName = 'Application form sale';
	              } else if (itemIdValue === 'submissionFeeMakePayment') {
	            	feeStageName = 'Application submission';
	              } else if (itemIdValue === 'applicationFeeMakePayment') {
	            	feeStageName ='Selection process';
	              }*/
	            
	            url = url.concat('&feeStageName='+feeStageName);
	            Ext.Ajax.request({
	                type: 'rest',
	                url: url,											 
	                method: 'GET',
	                async: true,
	                params: null,
	                //jsonData: Ext.encode(formValues),
	                headers: {
	                    'Content-Type': 'application/json'
	                },
	                success: function(response, action) {
	                	var responseObj = Ext.decode(response.responseText);
			  			if(!responseObj) {
		  		            if (!isEmpty(record)) {
		  		                if (!window) {
		  		                    window = Ext.widget('makepaymentwin', { // Equivalent to Ext.create('widget.panel')
		  		                        itemId: itemIdValue
		  		                    });
		  		                }
		  		                window.show();
		  		                var form = window.down('form');
		  		                
		  		                
		  		                var currency = form.getForm().findField('currency')
		  		                var academyLocationId= record.data.academyLocationId;
		  		                var feeId=record.data.feeId;
		  		                currency.getStore().getProxy().extraParams = {
		  		                	academyLocationId : academyLocationId,
		  		                	feeId : feeId,
		  						};
		  		                currency.getStore().load();
		  		             
		  		             
		  		                
		  		                
		  		              //V2D-68085 Set ReceiptId PlaceHolder According to DataSetting 
               				 setTimeout(function(){
               				 var receiptNoField = form.getForm().findField('receiptNo')
               				 if(receiptNoField.readOnly == false){
               					receiptNoField.emptyText = [ '' ];
               					receiptNoField.applyEmptyText();
               					receiptNoField.reset();
               					me.setAllowBlank(receiptNoField, false);	
               				 }else{
               					me.setAllowBlank(receiptNoField, true);	 
               				 }
               				 },10);
		  		                form.loadRecord(record);
		  		                form.down('#discountAmount').setVisible(true);
		  		                if(!isNullOrEmpty(record.get('discountType'))){
		  		                	/*if(record.get('discountType')!='ADHOC'){
			  		                	form.down('#discountAmount').setReadOnly(true);
			  		                }else{
			  		                	form.down('#discountAmount').setReadOnly(false);
			  		                	form.down('#discountAmount').setMaxValue(record.get('totalFee'));
			  		                }*/	
		  		                	form.down('#discountAmount').setReadOnly(true);
		  		                	//form.down('#discountAmount').setMaxValue(record.get('totalFee'));
		  		                	
		  		                }else{
		  		                	form.down('#discountAmount').setDisabled(true);	
		  		                }
		  		                form.down('hidden[name=id]').setValue(record.get('applicationId'));
		  		                form.down('hidden[name=academyLocationId]').setValue(record.get('academyLocationId'));
		  		                var stageNameField = form.down('hidden[name=stageName]');
		  		                var feePlanTypeField = form.down('hidden[name=feePlanType]');
		  		                if(itemIdValue === 'assignApplicationMakePayment'|| itemIdValue === 'applicationFeeMakePayment') {
		  		                	//stageNameField.setValue('Application form sale');
		  		                	feePlanTypeField.setValue('Application');
		  		                } else if (itemIdValue === 'submissionFeeMakePayment') {
		  		                	//stageNameField.setValue('Application submission');
		  		                	feePlanTypeField.setValue('Application');
		  		                } else if (itemIdValue === 'applicationFeeMakePayment') {
		  		                	//stageNameField.setValue('Selection process');
		  		                	feePlanTypeField.setValue('Program');
		  		                }
		  		                stageNameField.setValue(feeStageName);
		  		                var billTypeCombo = form.down('combo#billType');
		  		                billTypeCombo.setValue('P_AND_C_FEE');
		  		                billTypeCombo.setEditable(false);
		  		                billTypeCombo.setReadOnly(true);
		  		                
		  		                var recieptFormCombo = form.down('nestedJsonCombo#receiptForm');
		  		              recieptFormCombo.getStore().load(function(){
		  		                recieptFormCombo.setValue('APPLICANT');
		  		            });
		  		                recieptFormCombo.setEditable(false);
		  		                recieptFormCombo.setReadOnly(true);
		  		                
		  		                var amountField = form.down('numberfield#amount');
		  		                var instrumentAmountField = form.down('numberfield#instrumentAmount');
		  		                amountField.setValue(record.get('feeAmount'));
		  		                instrumentAmountField.setValue(record.get('feeAmount'));
		  		                amountField.setEditable(false);
		  		                instrumentAmountField.setEditable(false);
		  		                
		  		                var studentField = form.down('textfield#student');
		  		                studentField.setValue(record.get('applicantName'));
		  		                studentField.setReadOnly(true);

		  		                var currencyField = form.down('nestedJsonCombo#receivingCurrency');
		  		                //  currencyField.setValue(record.raw.currencyName);
		  		                var crStore = currencyField.getStore();
		  		                setTimeout(function(){
		  		                	crStore.load({
		  		                		callback: function(records, operation, success) {
		  		                			for(var i in records){
		  		                				if (record.raw.currencyId == records[i].data.id) {
		  		                					currencyField.setValue(records[i].data.id);
		  		                				}
		  		                			}
		  		                		}
		  		                	});
		  		                },100);

		  		                
		  		                
		  		              if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
		  		                	var receiptType = form.down('#receiptType');	                           		
		  		                	receiptType.setVisible(false);		                           			
		  		                } 
		  		            }
			  			}
	                }
	            });
	       
            } else {
            	//TODO: Call to be integrated
            	this.saveMakePaymentForManageForm(record);
            	showWarningMessage(getAdmissionTranslation('COLLECT_PAYMENT'), getAdmissionTranslation('CANNOT_MAKE_PAYMENT'));
            }
        } else {
        	showWarningMessage(getAdmissionTranslation('COLLECT_PAYMENT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    saveMakePaymentForManageForm : function(record){
    	 var serverUrl = SERVERURL.ASSIGN_APPLICATION_ID_MAKE_PAYMENT;
 		serverUrl = serverUrl.concat('?applicationId='+record.get('applicationId'));
 		this.sendSaveAjaxRequest(serverUrl, 'POST', null, function(opt,success,response){
 		});
    },
    getOpenApplicationForm : function(){
    	var me=this;
    	var contentpanel = this.getContentPanel();
//    	var structure = Ext.widget('applicantcommonstructure');
    	var structure = Ext.widget('applicantcommonform');
    	
    	var csvForm = Ext.create('Ext.form.Panel',{
    		style:{marginLeft:'6px !important',marginTop:'5px !important'}, 
     		items:[{
     			xtype : structure
     		}]
     	});
    	
    	var tabName = getAdmissionTranslation('CREATE_APPLICATION');
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentpanel.remove(getTab, true);
    	}
    	openTab(contentpanel, tabName, csvForm,CONSTANTS.MENU_COLOR_TWO);
    },
    getEditApplicationDeatils:function(){
    	var me=this;
    	var grid = this.getManageFormList();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		var receiptNo=record.get('receiptNo');
    		if(isNullOrEmpty(receiptNo)){
    		var applicationId = record.get("applicationId");
    		if(!isNullOrEmpty(applicationId)){
    			me.getOpenApplicationForm();
    			var form = me.getApplicantCommonForm();
    			applicant_Personal_Information_Url = SERVERURL.APPLICANT_PERSONAL_INFORMATION_BY_ID;  //URL-:rest/applicantPerson/findApplicationWithPersonDetail        	           	
    			applicant_Personal_Information_Url=applicant_Personal_Information_Url.concat("?id="+applicationId);           	
    			me.sendGetAjaxRequest(applicant_Personal_Information_Url, 'GET', null, function(option, success, response) {
    				if(success){	
    					var data = Ext.decode(response.responseText);
    					if(!isEmpty(data)){ 
    						form.down("#resetBtn").setVisible(false);
    						form.down("#SubmitAndGenerateFormNoBtn").setText('Save');
//    						form.down("#SubmitAndGenerateFormNoBtn").setVisible(false);
    						var personDetail = data.person;
    						var programDetails = data.applicationPrograms;
    						var personRelationships = personDetail.personRelationships;
    						var getform = form.getForm(); 
    						getform.findField('applicationId').setValue(data.id);
    						getform.findField('version').setValue(data.version);
    						getform.findField('applicationFormId').setValue(data.applicationFormId);
    						getform.findField('applicationCode').setValue(data.code);
    						getform.findField('personId').setValue(data.person.id);
    						getform.findField('personVersion').setValue(data.person.version);
    						//form.getForm().findField('applicationDate').setValue(dateRender(data.submissionDate));
    						form.down("#fieldcontainerformNoManuallyId").setVisible(false);
    						
    						getform.findField('token').setValue(record.get('token'));
    						getform.findField('token').setVisible(true);
    						
    						getform.findField('personVersion').setValue(data.person.version);
    						
    						var currentStatus = data.currentStatus;
    						var whehterDirectSubmission = form.down("#applicantDetailsId");
    						if(currentStatus=='FORM_SALE_TOKEN_GENERATED'){
    							whehterDirectSubmission.items.items[0].setValue(true);	
    						}else{
    							whehterDirectSubmission.items.items[1].setValue(true);
    						}
    						
    						form.down("#resetBtn").setVisible(false);
    						form.down("#searchComponent").setVisible(false);
    						
    						
    						if(!isNullOrEmpty(personDetail.salutation))
    						   me.setJsonData(form,'salutation',personDetail.salutation.id);
    						me.setJsonData(form,'firstName',personDetail.firstName);
    						me.setJsonData(form,'middleName',personDetail.middleName);
    						me.setJsonData(form,'lastName',personDetail.lastName);
    						me.setJsonData(form,'shortName',personDetail.shortName);
    						me.setJsonData(form,'printName',personDetail.printName);
    						if(!isNullOrEmpty(personDetail.birthDate))
    							me.setJsonData(form,'birthDate',new Date(personDetail.birthDate));
    						me.setJsonData(form,'gender',personDetail.gender);
    						me.setJsonData(form,'phoneCountryCode',personDetail.phoneCountryCode);
    						me.setJsonData(form,'phoneAreaCode',personDetail.phoneAreaCode);
    						me.setJsonData(form,'phoneNo',personDetail.phoneNo);
    						me.setJsonData(form,'cellCountryCode',personDetail.mobileCountryCode);
    						me.setJsonData(form,'mobileNumber',personDetail.mobileNumber);
    						me.setJsonData(form,'emailId',personDetail.emailId);
    						me.setJsonData(form,'applicationDate',personDetail.applicationDate);
    						me.setJsonData(form,'firstNameOtherLanguageId',personDetail.firstNameOtherLanguage);
    						me.setJsonData(form,'firstNameOtherLanguageId',personDetail.firstNameOtherLanguage);
    						me.setJsonData(form,'middleNameOtherLanguageId',personDetail.middleNameOtherLanguage);
    						me.setJsonData(form,'lastNameOtherLanguageId',personDetail.lastNameOtherLanguage);
    						me.setJsonData(form,'shortNameOtherLanguageId',personDetail.shortNameOtherLanguageId);
    						if (!isNullOrEmpty(personDetail.genderCSM) && !isNullOrEmpty(personDetail.genderCSM.id)) {
    							 me.setJsonData(form,'gender',personDetail.genderCSM.id);
    		                 }
    						if(!isNullOrEmpty(data.submissionDate))
    					   	   	me.setJsonData(form,'applicationDate',new Date(data.submissionDate));
    					   	
    						// Set Hostel Details
    						var this$ = me;
    	                	var params = {
    	                			applicantPersonId: data.person.id
    	                	};
    	                	var submitUrl = SERVERURL.PATH_GET_APPLICANT_HOSTEL_PERSONAL_INFO_BY_APPLICANT_PERSON_ID;
    	                	this$.sendGetAjaxRequest(submitUrl, 'GET', params, function(option, success, response) {
    	                    	if(success){
    	                    		if(!isNullOrEmpty(response.responseText)){
    	                    			var hostelData = Ext.decode(response.responseText);
    	                    			
    	                    			if(!isNullOrEmpty(hostelData.whetherHostelApplicable)){
    	        					   		me.setJsonData(form,'whetherHostelApplicable',hostelData.whetherHostelApplicable);
    	        					   	}
    	        						if(!isNullOrEmpty(hostelData.dietaryRequirements)){
    	        					   		me.setJsonData(form,'dietaryRequirementsItemId',hostelData.dietaryRequirements);
    	        					   	}
    	        					   	if(!isNullOrEmpty(hostelData.foodAllergies)){
    	        					   		me.setJsonData(form,'foodAllergiesItemId',hostelData.foodAllergies);
    	        					   	}
    	        					   	if(!isNullOrEmpty(hostelData.sleepingDisorder)){
    	        					   		me.setJsonData(form,'sleepingDisorderItemId',hostelData.sleepingDisorder);
    	        					   	}
    	        					   	if(!isNullOrEmpty(hostelData.anyMedicalNeedsOrSomething)){
    	        					   		me.setJsonData(form,'anyMedicalNeedsOrSomethingItemId',hostelData.anyMedicalNeedsOrSomething);
    	        					   	}
    	        					   	
    	        						// Show Hide Hostel Fields
    	        		               	var hostelFieldsContainer1 = form.down('#hostelFieldsContainer1');
    	        		         		var hostelFieldsContainer2 = form.down('#hostelFieldsContainer2');
    	        					   	
    	   	                			if( !isNullOrEmpty(hostelData.whetherHostelApplicable) ){
    		   	              		   		hostelFieldsContainer1.setVisible(hostelData.whetherHostelApplicable);
    		   	              		   		hostelFieldsContainer2.setVisible(hostelData.whetherHostelApplicable);
    		   	              		   	} else{
    		   	              		   		hostelFieldsContainer1.setVisible(false);
    		   	              		   		hostelFieldsContainer2.setVisible(false);
    		   	              		   	}
    	        					   	
    	                    		}
    	                    	}
    	                    });
    						
    						me.setProgramDetails(form,programDetails);
    						me.setRelationDetails(form,personRelationships);
    						
    						var applicantModeOfEnquiryField = form.getForm().findField("applicantModeOfEnquiry");
            				if(data.applicationEnquiryMultipleMode.length>0){
            					applicantModeOfEnquiryField.getStore().load({
                    				callback: function(records, operation, success) {
                    					if (success) {
                    						var applicantModeOfEnquiryArray= [];
                    						if(records.length > 0){
                    							data.applicationEnquiryMultipleMode.forEach(function(modeOfObj){
                    								var result = records.filter(function (obj) {
                    									  return obj.data.id === modeOfObj.enquiryMode.id;
                    									})[0];
                    								applicantModeOfEnquiryArray.push(result);
                    							});
                    							applicantModeOfEnquiryField.setValue(applicantModeOfEnquiryArray);
                    						}
                    					}
                    				}
                    	        });
            				}
    						
    					}
    				}        		
    			});
    		}
    		}else{
        		showWarningMessage(getAdmissionTranslation('MANAGE_FORMS'), getAdmissionTranslation('PAYMENT_ALREADY_MADE')); 
    		}
    		}else{
    		showWarningMessage(getAdmissionTranslation('MANAGE_FORMS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    	}
    },
    setJsonData : function(from,itemId,value){
    	from.down("#"+itemId).setValue(value);
    },
    setProgramDetails : function(form,records){
    	var programGrid = form.down('addprogramgrid');
    	var myJson = [];
    	for(var i in records){
    		myJson.push({
    			 'programBatchSeatConfigurationId':records[i].progBatchSeatConfigId,
    			 'academy': this.geValueJson(records[i].academyName),
    			 'location': this.geValueJson(records[i].locationName),
    			 'academy.value':records[i].academyName, 
    			 'location.value':records[i].locationName, 
    			 'id':records[i].id,
    			 'version':records[i].version,
    			 'program':records[i].program, 
    			 'program.value':records[i].program.value, 
    			 'batch':records[i].batch,  
    			 'batch.value':records[i].batch.value, 
    			 'seatType':records[i].seatType, 
    			 'seatType.value':records[i].seatType.value, 
    			 'programGroupId':records[i].programGroupId, 
    			 'academyLocationId':records[i].academyLocationId, 
    			 'currentStatus':records[i].currentStatus,
    			 'distancetoTravel':records[i].distancetoTravel,
    			 'version':records[i].version, 
    			 'whetherHostelApplicable':records[i].whetherHostelApplicable,
    			 'whetherTransportApplicable':records[i].whetherTransportApplicable,
    			 'whetherOfferLetterAccepted':records[i].whetherOfferLetterAccepted
    			 
    		});
    		}
    	programGrid.getStore().loadData(myJson);
    },
    setRelationDetails : function(form,personRelationships){
    	var $this = this;
    	var relationDataLength = personRelationships.length;
    	if(relationDataLength>0){
    		var fieldPanel=form.down('#relationshipDetailsId');
 			Ext.Array.each(personRelationships,function(value,index){
 				if(index>0){
 					$this.addRelationshipDetailContainer();    			
 	    		}
 				var filedContainer = fieldPanel.items.items[index];
 				var containerPanel1 = filedContainer.items.items[0];
				var containerPanel2 = filedContainer.items.items[1];
				containerPanel1.items.items[0].setValue(value.relationship);
				containerPanel1.items.items[2].setValue(value.relatedPerson.isEmployeeOfOrganization);
				containerPanel1.items.items[4].setValue(value.id);
				//containerPanel1.items.items[1].setValue(value.relatedPerson.employeeId);
				containerPanel1.items.items[6].setValue(value.version);
				
				containerPanel2.items.items[0].setValue(value.relatedPerson.printName);
				
				//containerPanel2.items.items[1].setValue(value.relatedPerson.mobileNumber);
				
				var mobileContainerPanel = containerPanel2.items.items[1];
				mobileContainerPanel.items.items[0].setValue(value.relatedPerson.mobileCountryCode);
				mobileContainerPanel.items.items[1].setValue(value.relatedPerson.mobileNumber);
				
				containerPanel2.items.items[2].setValue(value.relatedPerson.emailId);
				containerPanel2.items.items[3].setValue(value.relatedPerson.id);
				containerPanel2.items.items[4].setValue(value.relatedPerson.version);
				
				if(value.relationship == 'BROTHER' || value.relationship=='SISTER'){
					var student = containerPanel1.items.items[3];
					var studentStore = student.getStore();
					studentStore.load({
						 callback: function(rec, operation, success) {
							 if (success) {
								 student.setValue(value.relatedPerson.employeeId);
							 }
						 }
					 });
				}else{
					var user = containerPanel1.items.items[4];
					var userStore = user.getStore();
					userStore.load({
						 callback: function(rec, operation, success) {
							 if (success) {
								 user.setValue(value.relatedPerson.employeeId);
							 }
						 }
					 });
				}
 			});
    	}
    },
    getCheckButtonStaus : function(this$, td, cellIndex, record, tr, rowIndex, e, eOpts){
    	var grid = this$.ownerCt
    	var buttonsToolBar = grid.query('toolbar')[0];
    	var assignApplicationButton = buttonsToolBar.query('#assignApplicationID')[0];
    	var collectPaymentButton = buttonsToolBar.query('#collectPayment')[0];
    	var submitFormButton = buttonsToolBar.query('#submitForm')[0]; 
    	var editButton = buttonsToolBar.query('#btnEdit')[0];

    	assignApplicationButton.setDisabled(false);
    	collectPaymentButton.setDisabled(true);
    	submitFormButton.setDisabled(true);

    	var applicationCode = record.get('applicationCode');
    	var receiptNo = record.get('receiptNo');
    	var totalFee = record.get('totalFee');
    	var feePlanName = record.get('feePlanName');
    	var isSubmissionBillGenerated = record.get('isSubmissionBillGenerated')

    	if(isNullOrEmpty(receiptNo) && !isNullOrEmpty(feePlanName)){
    		collectPaymentButton.setDisabled(false);
    	}
    	if(!isNullOrEmpty(applicationCode)){
    		assignApplicationButton.setDisabled(true);
    		if(isNullOrEmpty(feePlanName) && isNullOrEmpty(receiptNo)){
    			submitFormButton.setDisabled(false);
    		}
    		if(!isNullOrEmpty(feePlanName) && !isNullOrEmpty(receiptNo)){
    			submitFormButton.setDisabled(false);
    		}
    	}
    	if(isSubmissionBillGenerated == true){
    		collectPaymentButton.setDisabled(true);
    		if(isNullOrEmpty(applicationCode)){
    			assignApplicationButton.setDisabled(false);
    			submitFormButton.setDisabled(true);
    		}
    		if(!isNullOrEmpty(applicationCode)){
    			assignApplicationButton.setDisabled(true);
    			submitFormButton.setDisabled(false);
    		}

    	}
    	var getController = Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
    	var columnName=grid.columnManager.columns[cellIndex].dataIndex;
    	if(e.target.tagName=="A"){
    		  if(columnName=='applicationCode' ){
    			  var applicantId = record.get('applicationId'); 
					this.openApplicantProfileFromManageFormAdm(applicantId, false,grid,record);
    		  }
    	  }
    	
    },
    
    createBillForManageForm: function(button,print) {
    	this$= this;
    	var grid = this$.getManageFormList();
    	var manageFormListStore = grid.getStore();
    	var form = button.up('form');
    	var window = button.up('window');
    	var formValues = form.getValues();
    	var applicantObject = new Object();
    	applicantObject.id = formValues.id;
    	formValues.raiseBillType =  'P_AND_C_FEE';
    	formValues.applicant = applicantObject;
    	
    	var recieptForObj = new Object();
    	recieptForObj.id = 2;
    	recieptForObj.value = "APPLICANT";
    	formValues.receiptFor = recieptForObj;
    	
    	var paymentMode = new Object();
    	paymentMode.id = formValues.paymentMode;
    	
    	var instrumentBank = new Object();
    	if(isNullOrEmpty(formValues.instrumentBank)) {
    	    instrumentBank.id= null;
    	} else {
    	    instrumentBank.id = formValues.instrumentBank;
    	}
    	var costCentreId;
    	if(isNullOrEmpty(formValues.costCentre))
    	{
    		delete formValues.costCentre;
    	}
    	 	                	   
    	if(formValues.voucherMode === 'BANK') {
	      	var receiptPaymentInstrumentsArray = new Array();
	      	var receiptPaymentInstruments = new Object();
	    	receiptPaymentInstruments.paymentMode = paymentMode;
	    	receiptPaymentInstruments.instrumentBank = instrumentBank;
	    	receiptPaymentInstruments.instrumentNo = formValues.instrumentNo;
	        receiptPaymentInstruments.instrumentDate = formValues.instrumentDate;
	    	receiptPaymentInstruments.amount = formValues.amount;
	    	
	    	delete formValues.instrumentDate;
	    	delete formValues.amount;
	    	
	    	receiptPaymentInstrumentsArray.push(receiptPaymentInstruments);
	    	formValues.receiptPaymentInstruments = receiptPaymentInstrumentsArray;
    	}
    	
    	if(isNullOrEmpty(formValues.depositedBank)) {
    		formValues.depositedBank = null;
    	};
    	
    	if(isNullOrEmpty(formValues.depositedCash)) {
    		formValues.depositedCash = null;
    	};
    	delete formValues.instrumentNo;
    	delete formValues.depositedLedger;
    	delete formValues.id;
    	delete formValues.paymentMode;
    	delete formValues.instrumentBank;
    	delete formValues.instrumentAmount;
    	delete formValues.customData;
    	var submitData = Ext.encode(formValues); 
    	
    	this$.applyWindowMask();
    	window.down('#SubmitBtn').setDisabled(true);
    	window.down('#SubmitAndPrintMakePaymentBtn').setDisabled(true);
    	this.sendSaveAjaxRequest(SERVERURL.RECEIPT_HEADER_SAVEANDCREATEBILL, 'POST', submitData, function(opt,success,response){
		  	if(success){
		  		this$.hideWindowMask();
		  		manageFormListStore.reload();
		  		grid.getSelectionModel().deselectAll();
		  		//Call for makePayment as per nita.
		  		/** https://serosoft.atlassian.net/browse/V2D-120605
		  		Application is directly goes to submitted state which goes wrong for many clients.
		  		As discussed with senior commenting this code.
		  		**/
		  		/*var serverUrl = SERVERURL.ASSIGN_APPLICATION_ID_MAKE_PAYMENT;
		  		serverUrl = serverUrl.concat('?applicationId='+formValues.applicant.id);
		  		this$.sendSaveAjaxRequest(serverUrl, 'POST', null, function(opt,success,response){});*/
		  		window.close();
		  		showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS')); //No search result found
		  		if(print==true){
		  			this$.getPrintGenerateMakePayment(response.responseText);
		  		}
		  	}else{
		  		this$.hideWindowMask();
		  		window.down('#SubmitBtn').setDisabled(false);
		  		window.down('#SubmitAndPrintMakePaymentBtn').setDisabled(false);
		  		manageFormListStore.reload();
		  		grid.getSelectionModel().deselectAll();		  		
		  	}
		  	
	  	});
    },
    getPrintGenerateMakePayment : function(id){
   	 var fileType = 'pdf';
   	 var $this = this;
    	var user=$this.getCurrentlyLoggedInUser();
    	var code ="MANAGE_RECEIPT_SETTLEMENT_CODE";
    	var reportParams =new Object();
    	reportParams.userId=user.code;
    	reportParams.ids=String(id); // convert int into string
    	var reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
    	var exportUrl = SERVERURL.MANAGE_RECEIPT_SETTLEMENT_PDF;

    	if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true") {
    		code="MANAGE_RECEIPT_CODE";
    		reportTitle=getFeeAndPaymentCommonTranslation('MANAGE_RECEIPT_JASPER_TITLE');
    		exportUrl=SERVERURL.MANAGE_RECEIPT_PDF
    	}

    	  var store=$this.getStore('examinationcenters.IsTemplateMappedStore');
    	    store.getProxy().extraParams={
    	    	code:code
    	    };
    	    store.load({
    	    	callback:function(rec,obj,success){
    	    		if(obj.response.responseText=="true"){
    	    			$this.exportJRXMLReport(code,reportParams,reportTitle,fileType,exportUrl); 
    	    		}else{
    	    			showWarningMessage(getCommonTranslation('ALERT'),getTranslation('TEMPLATE_MAPPING_ERROR'));
    	    		}
    			}
    	   });
    },
    getSubmitApplicationForm : function(){
    	var me = this;
    	var grid = this.getManageFormList();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			type: 'rest',
    			url: SERVERURL.APPLICATION_SUBMITFORM, 												 
    			method: 'POST',
    			headers: {
    				'Content-Type': 'application/json'
    			},
    			params: {
    				applicationId: record.get("applicationId")
    			},
    			success: function(form, action) {
    				grid.getStore().reload();
    				Ext.getBody().unmask();
    				grid.getSelectionModel().deselectAll();
    				showSuccessMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('SUBMIT_FORM_MSG')); //Application Id assigned successfully.
    			}
    		});
    	}else{
    		showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
    	}
    },
    addProgramWindowQuickSearch : function(){
    	var addProgramWindowGrid = this.getAddProgramWindowGrid();
		var a = addProgramWindowGrid.down("#cmbAcademyLocations");
		var b = addProgramWindowGrid.down("#cmbPgmGroup");
		var c = addProgramWindowGrid.down("#cmbPrograms");
		var d = addProgramWindowGrid.down("#modeDeliveryId");
 		var e = addProgramWindowGrid.down("#registrationTypeId");
		
		if(b != undefined){
        	if( b.getValue() == null || b.getValue() == undefined || b.getValue() == ""){
        		showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('SELECT_PROGRAM_GROUP_ERR_MSG'));
        	}else{
        		var programGroupIds = [];
                var selectedProgramId = 0;
                var selectedAcademyLocationId = 0;
                var selectedProgramGroup = programGroupIds;
                var modeDeliveryId = 0;
				var regTypeEnum = null;
                
                if(a != undefined && a.getValue() != null ){
                	selectedAcademyLocationId = a.getValue();
                }
                
                if(c != undefined && c.getValue() != null ){
                	selectedProgramId = c.getValue();
                }
                if (d != undefined && d.getValue() != null) {
					modeDeliveryId = d.getValue();
				}
                if (e != undefined && e.getValue() != null) {
					if(e.getValue()=='FULL_TIME'){
						regTypeEnum = false;
					}else if(e.getValue()=='PART_TIME'){
						regTypeEnum = true;
					}
				}
                
                if(b != undefined){
                	
                	if( b.getValue() == null ){    	            	
                    	var items = b.store.data.items;
                    	if(items.length > 0){
                    		var arrayLength = items.length;
                    		for (var i = 0; i < arrayLength; i++) {
                    			programGroupIds.push(items[i].raw.id);            			
                    		}
                    		//params.programGroupIds = programGroupIds.join();
                    	}
                    	selectedProgramGroup = 0;
                	}else{    	            		
                		selectedProgramGroup = b.getValue();
                	}
                }
                
        		var isformSaleSelection=true, isformSubmissionSelection=false,whetherAdmissionOpen =true;
        		
        		var applicantCommonForm=this.getApplicantCommonForm();
        		var applicationType=applicantCommonForm.down('#applicantDetailsId').getValue();
        		if(applicationType.whehterDirectSubmission){
        			isformSubmissionSelection=true;
        			isformSaleSelection=false;
        			whetherAdmissionOpen=false;
        		}else{
        			isformSaleSelection=true;
        			isformSubmissionSelection=false;
        			whetherAdmissionOpen=false;
        		}
        		
        		this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, programGroupIds, selectedAcademyLocationId, selectedProgramId,modeDeliveryId,regTypeEnum);
        	}
        }
    },
    getMaxProgramsAllowedForSelectedProgramGroup : function(storeProgramGroupDropdown, programGroupId){
    	if(storeProgramGroupDropdown != null && storeProgramGroupDropdown != undefined){
    		var maxProgramsAllowed = -1;
    		var items = storeProgramGroupDropdown.data.items;
    		if(items != undefined && items.length == 0){
    			return maxProgramsAllowed;
    		}
    		if(items != undefined && items.length > 0){
    			items.forEach(function(entry) {
    			    if(programGroupId == entry.raw.id){
    			    	maxProgramsAllowed = entry.raw.maxProgramsAllowed;
    			    }
    			});
    		}
    		return maxProgramsAllowed;
    	}
    },
    getAppliedProgramsByProgramGroupId : function(storeAppliedPrograms, selectedProgramGroupId){
    	if(storeAppliedPrograms != null && storeAppliedPrograms != undefined){
    		var appliedProgramsCountByProgramGroupId = 0;
    		var items = storeAppliedPrograms.data.items;
    		if(items != undefined && items.length == 0){
    			return appliedProgramsCountByProgramGroupId;
    		}
    		if(items != undefined && items.length > 0){
    			items.forEach(function(entry) {
    			    if(selectedProgramGroupId == entry.data.programGroupId){
    			    	appliedProgramsCountByProgramGroupId++;
    			    }
    			});
    		}
    		return appliedProgramsCountByProgramGroupId;
    	}
    },
    validateMaxProgramsAllowed : function(programTabGrid,programWindow,addProgramWindowGrid){
    	
    	var selectedApplicationProgramGrid = programTabGrid
        var programWindow = programWindow
        var addProgramWindowGrid = addProgramWindowGrid
        
        var b = addProgramWindowGrid.down("#cmbPgmGroup");
        var selectedProgramGroupId = b.getValue();
        var storeProgramGroup = b.getStore();
        var storeProgramGroupItems = storeProgramGroup.data.items;
        
        var maxProgramsAllowed = this.getMaxProgramsAllowedForSelectedProgramGroup(storeProgramGroup, selectedProgramGroupId);
        
        if(maxProgramsAllowed != null && parseInt(maxProgramsAllowed) != -1 && parseInt(maxProgramsAllowed) != 0 ){
            var programsAppliedByProgramGroup = this.getAppliedProgramsByProgramGroupId(selectedApplicationProgramGrid.getStore(),selectedProgramGroupId);
            var selectedPrograms = addProgramWindowGrid.getSelectionModel().selected;
            if(selectedPrograms != undefined){
            	var selectedProgramsCount = selectedPrograms.items.length;
            	if( parseInt(selectedProgramsCount) + parseInt(programsAppliedByProgramGroup) > parseInt(maxProgramsAllowed) ){
            		if(parseInt(maxProgramsAllowed) == 1){
            			showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('MAX_PROGRAMS_ERR_MSG_START') + maxProgramsAllowed + getAdmissionTranslation('MAX_PROGRAMS_SINGLE_ERR_MSG_END'));
            		}else{
            			showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('MAX_PROGRAMS_ERR_MSG_START') + maxProgramsAllowed + getAdmissionTranslation('MAX_PROGRAMS_MULTIPLE_ERR_MSG_END'));
            		}
            		return false;
            	}else{
            		return true;
            	}
            }
        }else{
        	return true;
        }
    },
    disableSchoolAttendanceStartDatePivileges : function(formWindow,permissionsMap){
	    	
	    	var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	
   		    var schoolAttendanceStartDate = formWindow.down('#schoolAttendanceStartDate');
				schoolAttendanceStartDate.setVisible(false);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'SCHOOL_ATTENDANCE_START_DATE') {
	    			if(!isNullOrEmpty(schoolAttendanceStartDate)){
	    				schoolAttendanceStartDate.setVisible(true);
	    			}        		
	    		}
	    	});
	    },
	disableMoreButtonPivileges : function(gridReference,permissionsMap){
	    	
	    	var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    	buttonsToolBar = gridReference.query('toolbar')[0];
	    	var buttons = buttonsToolBar.query('button');
	    	
	    	
	    	/*Ext.each(buttons, function(button) {
	    		console.log(button);
	    		button.setVisible(false);
	    	});*/
	    	
	    	
	    	buttonsToolBar.query('#assignApplicationID')[0].setVisible(false);
	    	buttonsToolBar.query('#collectPayment')[0].setVisible(false);
	    	buttonsToolBar.query('#submitForm')[0].setVisible(false);
	    	buttonsToolBar.query('#sendReminder')[0].setVisible(false);

	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'COLLECTPAYMENT') {
	    			var button = buttonsToolBar.query('#collectPayment')[0];
	    			if(!isNullOrEmpty(button)){
	    				button.setVisible(true);
	    			}        		
	    		}
	    		if (privilege === 'ASSINGNAPPLICATIONID') {
	    			var button = buttonsToolBar.query('#assignApplicationID')[0];
	    			if(!isNullOrEmpty(button)){
	    				button.setVisible(true);
	    			}        		
	    		}
	    		if (privilege === 'SUBMITFORM') {
	    			var button = buttonsToolBar.query('#submitForm')[0];
	    			if(!isNullOrEmpty(button)){
	    				button.setVisible(true);
	    			}        		
	    		}
	    		if (privilege === 'SENDREMINDER') {
	    			var button = buttonsToolBar.query('#sendReminder')[0];
	    			if(!isNullOrEmpty(button)){
	    				button.setVisible(true);
	    			}        		
	    		}
	    	});
	    	var keysToCheck = ["ASSINGNAPPLICATIONID", "SENDREMINDER"];
			var hasAny = false;
			for (var i = 0; i < permissionList.length; i++) {
				if (permissionList.indexOf(keysToCheck[i]) !== -1) {
					hasAny = true;
					break;
				}
			}
			if(hasAny) {
				gridReference.down('#manageFormMoreActions').show();
			}
	    },
	    createBillForManageFormReset:function(button){
	    	var grid = this.getManageFormList();
    		var record = grid.getSelectionModel().getSelection()[0];
    		var formWindow=this.getMakePaymentWin();
    		
	    	var form = button.up('#makePaymentReceiptform');
	    	form.down('#depositedBank').reset();
	    	form.down('#paymentMode').reset();
	    	form.down('#instrumentNo').reset();
	    	form.down('#instrumentBank').reset();
	    	form.down('#narration').reset();
	    	form.down('#depositedCash').reset();
	    	form.down('#receivingIAU').reset();
	    	form.down('#receivingCurrency').setValue(record.raw.currencyId);
	    	form.down('#amount').setValue(record.get('feeAmount'));
	    	form.down('#discountAmount').setValue(record.get('discountAmount'));
	    	
	    	
             
	    	
	    },
	    openApplicantProfileFromManageFormAdm:function(applicationId,isView,searchResultGrid,record){
	  	  Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		  Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
		  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyListController');
		  Academia.app.getController('Academia.controller.personinfo.faculty.FacultyPersonalController');
		  Academia.app.getController('Academia.controller.admission.admissionCommon.AdmissionFormCommonController');
		  Academia.app.getController('Academia.controller.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionPaymentsRefundsAndFeePlansController');
		  Academia.app.getController('Academia.controller.admission.directSubmission.DirectSubmissionController');
		  Academia.app.getController('Academia.controller.admission.preAdmissionFeesAndRefund.PreAdmissionFeesAndRefundController');
		  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration');
		  Academia.app.getController('Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration');
		  Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantProfileBase.ApplicantProfileBaseController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController');
		  Academia.app.getController('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantService.ApplicantServiceController');
		  Academia.app.getController('Academia.controller.admission.applications.applicantDocuments.ApplicantDocumentController');
		  Academia.app.getController('Academia.controller.admission.applications.admissionAndMidTermAdmission.AdmissionAndMidTermAdmissionController');
		  if(searchResultGrid){
			  var store=searchResultGrid.getStore();
			  var tabTitle = null;
			  var personId = null;
			  var applicationId = null;
			  var admissionId = null;
			  var record = record;
			  tabTitle = record.get('applicationCode');
			  applicationId = record.get('applicationId');
			  admissionId = record.get('applicationCode');
			  var applicationBaseController =Academia.app.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
			  var me=applicationBaseController;
			  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
			  if(applicantProfile){
				  me.getContentPanel().setActiveTab(applicantProfile); 
				  Ext.getBody().unmask();
			  }else{
				  me.addContentPanelTab(tabTitle, 'applicantprofile', null, null,applicationId,admissionId);
				  var applicantProfile=me.getTabReferenceByTabTitle(tabTitle);
				  if (applicantProfile) {            	
					  me.setParameterForApplicantProfile(applicantProfile,record,'',isView);
					  me.mixins.ButtonPanelConfiguration.enableDisableButtonPanel(applicantProfile,true);
					  me.mixins.LinkPanelConfiguration.enableDisableAccorianLinkPanel(applicantProfile,true);    			
					  var applicantLinkPanelObject=me.mixins.PersonDetailsLinkPanel.getApplicantProfileLink();
					  var applicantPortalController  = me.getController('Academia.controller.portal.ApplicantPortalController');
					  //commenting bacause permission code is already written in addContentPanelTab
      	        	  //applicantPortalController.loadPanellinkForApplicant(applicantProfile, applicantLinkPanelObject);
					  me.gettingDataInSummaryGrid(applicantProfile);    
					  //me.getApplicantProfileInformation(applicantProfile);
					  if(!isEmpty(applicantLinkPanelObject)){

						  var personalDetailObject=applicantLinkPanelObject.PERSONAL_INFORMATION[0];    				
						  me.addPersonTabPanel('APPLICANT', personalDetailObject.tabPanelItemId, personalDetailObject.tabPanelTitle, personalDetailObject.tabPanelItemXtype, personalDetailObject.xtypeItemId,personalDetailObject.defaultPanel);

						  var admissionDetailObject=applicantLinkPanelObject.APPLICATION_AND_ADMISSION[2];    				
						  me.addPersonTabPanel('APPLICANT', admissionDetailObject.tabPanelItemId, admissionDetailObject.tabPanelTitle, admissionDetailObject.tabPanelItemXtype, admissionDetailObject.xtypeItemId,admissionDetailObject.defaultPanel);

						  var personInfoPanel=applicantProfile.down("#personInfoPanel");
						  if(personInfoPanel){
							  var applicantPersonalDetails=personInfoPanel.down("#applicantPersonalDetails");
							  if(applicantPersonalDetails){
								  var applicantProfileItems = applicantProfile.down('actionbuttonpanel').items.items;
								  if(applicantProfileItems != undefined && applicantProfileItems.length > 0){
									  applicantProfileItems.forEach(function(buttons) {
						    			    if(buttons.itemId != 'printBtn' && buttons.itemId != 'withdrawApplicationBtn' ){
						    			    	buttons.hide();
						    			    }
						    			    if(buttons.itemId == 'withdrawApplicationBtn'){
						    			    	buttons.setDisabled(false);
						    			    }
						    			});
						    		}
								  personInfoPanel.setActiveTab(applicantPersonalDetails);
							  }        						
						  }

					  }

				  }
			  }    	        
		  }                	
	},
	disableManageFormGridExtraButton:function(column,selected) {
    	var $this = this;
    	var grid = $this.getManageFormList();
    	var btnEdit = grid.down('#btnEdit');
    	var collectPayment = grid.down('#collectPayment');
    	var assignApplicationID = grid.down('#assignApplicationID');
    	var submitForm = grid.down('#submitForm');
    	var selectionLength = selected.length;
    	if (selectionLength > 1) {
    		btnEdit.setDisabled(true);
    		collectPayment.setDisabled(true);
    		assignApplicationID.setDisabled(true);
    		submitForm.setDisabled(true);
		}else if(selectionLength == 0){
			btnEdit.setDisabled(false);
    		collectPayment.setDisabled(false);
    		assignApplicationID.setDisabled(false);
    		submitForm.setDisabled(false);	
		}else if (selectionLength == 1) {
			assignApplicationID.setDisabled(false);
			collectPayment.setDisabled(true);
	    	submitForm.setDisabled(true);
			var record = grid.getSelectionModel().getSelection()[0];
			var applicationCode = record.get('applicationCode');
	    	var receiptNo = record.get('receiptNo');
	    	var feePlanName = record.get('feePlanName');
	    	var isSubmissionBillGenerated = record.get('isSubmissionBillGenerated')

	    	if(isNullOrEmpty(receiptNo) && !isNullOrEmpty(feePlanName)){
	    		collectPayment.setDisabled(false);
	    	}
	    	if(!isNullOrEmpty(applicationCode)){
	    		assignApplicationID.setDisabled(true);
	    		if(isNullOrEmpty(feePlanName) && isNullOrEmpty(receiptNo)){
	    			submitForm.setDisabled(false);
	    		}
	    		if(!isNullOrEmpty(feePlanName) && !isNullOrEmpty(receiptNo)){
	    			submitForm.setDisabled(false);
	    		}
	    	}
	    	if(isSubmissionBillGenerated == true){
	    		collectPayment.setDisabled(true);
	    		if(isNullOrEmpty(applicationCode)){
	    			assignApplicationID.setDisabled(false);
	    			submitForm.setDisabled(true);
	    		}
	    		if(!isNullOrEmpty(applicationCode)){
	    			assignApplicationID.setDisabled(true);
	    			submitForm.setDisabled(false);
	    		}

	    	}
		}
    },
    sendReminder: function(obj){
    	var grid = obj.up('grid');
    	var records = grid.getSelectionModel().getSelection();
    	if(grid.getSelectionModel().getCount()>0) {
    		if(records != undefined && records.length > 0){
    			var applicationIds = [];
    			records.forEach(function(record) {
    				var receiptNo = record.get('receiptNo');
    		    	var feePlanName = record.get('feePlanName');
    		    	if(isNullOrEmpty(receiptNo) && !isNullOrEmpty(feePlanName)){
    					applicationIds.push(record.get('applicationId'));
    				}
    			});
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.PATH_SEND_REMINDER_TO_PAY_THE_APPLICATION_FEES, 												 
    						method: 'GET',
    						async: false,
    						headers: {
    							'Content-Type': 'application/json'
    						},
    						params: {
    							applicationIds: applicationIds.join()
    						},
    						success: function(form, action) {
    							showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REMINDER_SENT_SUCCESS'));
    						}
    					});		
    		}
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    deleteSelectedApplication:function(){
    	var $this=this;
    	var grid = $this.getManageFormList();
    	
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var IdsArr = [];
    	selectionModel.forEach(function(obj){
    			IdsArr.push(obj.get('applicationId'));
    	});
    	if (IdsArr.length > 0) {
    		showConfirmMessage(getCommonTranslation('APPLICANTS_HEADER_MESSAGE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.timeout = CONSTANTS.AJAX_TIMEOUT;
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.PATH_APPLICATIONS_DELETE+'?applicationIds='+ IdsArr.join(),
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(response,action) {
    						Ext.getBody().unmask();
    						var record = Ext.decode(response.responseText);
    						if(record==true){
    							/*var msg = '<span style="font-weight: 600;font-size: 16px;letter-spacing: 0.5px;color: black;">'+getMessagingModuleTranslation('SUCCESS')+'</span><br><span style="font-size: 12px;text-align: left;color: black;top: -3px;position: relative;">'+getCommonTranslation('PATH_APPLICATION_DELETE_SUCCESS_MSG')+'</span>';
    	    					var box2 =Ext.Msg.show({
									//title: getMessagingModuleTranslation('SUCCESS'),
									msg: msg,
									buttons: Ext.Msg.OK,
									icon: Ext.Msg.INFO,
									cls: 'successMessageBox commonMsgBoxCls newClsMessageSuccessBox',
									fn: function(btn){
										if(btn == 'ok'){
											grid.getStore().reload();
										}
									}
								});
    	    					box2.removeCls('newClsMessageConfirmBox');
    	    					box2.dockedItems.items[1].layout.pack = "end";
    	    					box2.doLayout();
    	    					box2.dockedItems.items[1].items.items[0].setUI('CustomBtnSubmit');*/
    							showSessionTimeOutMessage(
									getMessagingModuleTranslation('SUCCESS'),
									getCommonTranslation('PATH_APPLICATION_DELETE_SUCCESS_MSG'),
									function(btn){
										if(btn == 'ok'){
											grid.getStore().reload();
										}
									}
		    					);
    						}else{
    							showSuccessMessage(getCommonTranslation('APPLICANTS_HEADER_MESSAGE'),getCommonTranslation('PATH_APPLICATION_NOT_DELETE_MESSAGE'));
    						}


    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    }
});
