/**
 * This controller is used for Selection process from the admissions module.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.controller.admission.selectionProcess.SelectionProcessController', {
    extend: 'Academia.controller.base.BaseController',
    
    models: ['Academia.model.common.IdValueDataModel'],
    stores: ['admission.admissionCycle.SelectionProcessTypeStore','admission.quotas.QuotaLists','admission.selectionProcess.Processes', 'admission.selectionProcess.QuotaTypes',
             'Academia.store.course.CourseStageStore', 'Academia.store.admission.selectionProcess.SelectionProcessStages',
             'Academia.store.common.BasisOfEvaluations', 
             'Academia.store.admission.selectionProcess.EvaluationParameters', 'Academia.store.admission.selectionProcess.ResourceRequirements',
             'Academia.store.admission.selectionProcess.ConditionalMarks', 'Academia.store.admission.selectionProcess.Documents',
             'Academia.store.admission.selectionProcess.Applicabilities', 'admission.selectionProcess.DocumentGridRecords','gradeMaster.GradeTypeMappingStore'],
    views: [
            'Academia.view.admission.selectionProcess.SelectionProcessStructure',
            //GRIDS
            'Academia.view.admission.selectionProcess.SelectionProcessGrid', 
            'Academia.view.admission.selectionProcess.SelectionProcessStagesGrid',
            'Academia.view.admission.selectionProcess.EvaluationParametersGrid',
            'Academia.view.admission.selectionProcess.ConditionalMarksGrid',
            'Academia.view.admission.selectionProcess.DocumentsGrid',
            'Academia.view.admission.selectionProcess.ResourceRequirementGrid',
            
            //Selection Process Stages
            'Academia.view.admission.selectionProcess.SelectionProcessStageWindow',
            'Academia.view.admission.selectionProcess.SelectionProcessForm',
            'Academia.view.admission.selectionProcess.SelectionProcessAddEditStructure',
            
            //Stage Configuration
            'Academia.view.admission.selectionProcess.StageConfigurationStructure', 'Academia.view.admission.selectionProcess.StageConfigurationPanel',
            //Tabs
            'Academia.view.admission.selectionProcess.BasicSettingsStructure', 'Academia.view.admission.selectionProcess.BasicSettingsForm', 
            'Academia.view.admission.selectionProcess.EvaluationParametersWindow', 'Academia.view.admission.selectionProcess.ConditionalMarksWindow',
            'Academia.view.admission.selectionProcess.DocumentsWindow', 'Academia.view.admission.selectionProcess.ResourceRequirementWindow',
            'common.NestedJsonCombo','baselayout.contentarea.ContentPanel'
            ],

    refs: [{
   	  ref: 'contentpanel',
	  selector: 'contentpanel'
  },{
    	ref: 'selectionProcessStructure',
    	selector: 'selectionprocessstructure'
    },{
        ref: 'selectionProcessGrid',
        selector: 'selectionprocessgrid'
    }, {
    	ref: 'sPStageWindow',
    	selector: 'spstagewindow'
    }, {
    	ref: 'selectionProcessForm',
    	selector: 'selectionprocessform'
    }, {
    	ref: 'selectionProcessStagesGrid',
    	selector: 'selectionprocessstagesgrid'
    }, {
    	ref: 'evaluationParametersGrid',
    	selector: 'evaluationparametersgrid'
    }, {
    	ref: 'evaluationParametersWindow',
    	selector: 'evaluationparameterswindow'
    }, {
    	ref: 'conditionalMarksGrid',
    	selector: 'conditionalmarksgrid'
    }, {
    	ref: 'basicSettingsForm',
    	selector: 'basicsettingsform'
    }, {
    	ref: 'resourceRequirementGrid',
    	selector: 'resourcerequirementgrid'
    }, {
    	ref: 'documentsGrid',
    	selector: 'documentsgrid'
    },{
    	ref:'spaddeditpanel',
    	selector:'spaddeditpanel'
    }],
    
    config: {
    	componentCreated : false,
    	SELECTION_PROCESS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SELECTION_PROCESS_PRIVILEGES')
    },
    
    init: function(application) {
    	this.selectedStageRecord= null;
        this.control({
        				//QuotaType Grid listeners
        	'selectionprocessgrid': {
        		render: function(grid) {
        			 grid.getStore().load();
        			 this.doAccessControlValidation(grid, this.getSELECTION_PROCESS_PERMISSIONS());
        		}
        	},
        	
        	//listeners of the selection process grid
        	'selectionprocessgrid button': {
        		click: function(button) {
        			if(button.itemId === 'btnAdd') {
        				this.onAddSelectionProcess(button);
        			}else if(button.itemId === 'btnEdit') {
        				this.onEditSelectionProcess(button);
        			}else if(button.itemId === 'btnView') {
        				this.onViewSelectionProcess(button);
        			}else if(button.itemId === 'btnDelete') {
        				this.onDeleteSelectionProcess(button);
        			}
        		}
        	},
            'selectionprocessform button[itemId=btnSaveSelectionProcess]': {
            	click: function(button) {
                	this.onSelectionProcessSave(button);
                }
            },
   		  'selectionprocessform customcombobox[itemId=selectionProcessType]':{
			  select:function(obj,rec){
				var selectionProcesValue = this.getSelectionProcessForm().down('#selectionProcessType').value;
				var quotaTypeSelector = this.getSelectionProcessForm().down('#quotaTypeSelector');
				var remark = this.getSelectionProcessForm().down('#remark');
				var quotaTypeRemark = this.getSelectionProcessForm().down('#quotaTypeRemark');
				if(selectionProcesValue ==='PLACEMENT')
				{
					quotaTypeSelector.setDisabled(true);
					remark.setDisabled(true);
					quotaTypeRemark.setDisabled(true);
				}else{
					quotaTypeSelector.setDisabled(false);
					remark.setDisabled(false);
					quotaTypeRemark.setDisabled(false);
					
				}
			}
		  },
            'selectionprocessform itemselector[itemId=quotaTypeSelector]': {
            	render: function(this$, eOpts) {
        			this$.getStore().load();
        		}
            }, 
            
          //listeners of the selection process STAGES grid
            'selectionprocessstagesgrid button': {
        		click: function(button) {
        			if(button.itemId === 'btnAdd') {
        				this.onAddSelectionProcessStages(button);
        			}else if(button.itemId === 'btnEdit') {
        				this.onEditSelectionProcessStages(button);
        			}else if(button.itemId === 'btnView') {
        				this.onViewSelectionProcessStages(button);
        			}else if(button.itemId === 'btnDelete') {
        				this.onDeleteSelectionProcessStages(button);
        			
        		}/*else if(button.itemId === 'saveReordering') {
    				this.onReorderSave(button);
    			 }else if(button.itemId === 'configureStage') {
    				this.configureStage(button);
    			}*/
        		}
        	},
        	
        	 'selectionprocessstagesgrid menuitem[itemId=configureStage]': {
 	            click: function(button) {            	
 	            	this.configureStage(button);
 	            }
 	        },
 	       'selectionprocessstagesgrid menuitem[itemId=saveReordering]': {
	            click: function(button) {
	            	this.onReorderSave(button);
	            }
	        },
        	
        	
//            'selectionprocessstagesgrid splitbutton[itemId=btnMoreOperations] menuitem[itemId=saveReordering]': {
//            	click: function(button) {
//            		this.onReorderSave(button);
//            	}
//            },
//            'selectionprocessstagesgrid splitbutton[itemId=btnMoreOperations] menuitem[itemId=configureStage]': {
//            	click: function(button) {
//            		this.configureStage(button);
//            	}
//            },
            'basicsettingsform combo[itemId=evaluationCombo]': {
            	change: function(combo, newValue, oldValue) {
            		this.evaluationComboSelect(combo, newValue, oldValue);
            	}
            },
            'basicsettingsform checkbox[itemId=previousStagesCheck]': {
            	change: function(checkBox, newValue, oldValue, eOpts ) {
            		this.togglePreviousStages(checkBox, newValue);
            	}
            },
            'basicsettingsform button[itemId=saveBasicSettings]': {
            	click: function(button) {
            		this.saveBasicSettings(button);
            	}
            },
            'spstagewindow button[itemId=btnSaveStageDetails]': {
            	click: function(button) {
            		this.onSaveStageDetails(button);
            	}
            },
            'spstagewindow button[itemId=btnCancelStageDetails]': {
            	click: function(button) {
            		button.up('window').close();
            	}
            },
            'spstagewindow combo#stageCombo':{
            	render: function(combo) {
            		combo.getStore().load();
            	}
            	
            },
            
            // listeners for parameters grid
            'evaluationparametersgrid button': {
            	click: function(button) {
            		var form =  this.getBasicSettingsForm();
            		var evalType = form.down("#gradeTypeName").value;
            		if(button.itemId == 'btnAdd') {
            			this.onAddEvaluationParameter(button,evalType);
            		} else if(button.itemId == 'btnEdit') {
            			this.onEditEvaluationParameter(button,false,evalType);
            		} else if(button.itemId == 'btnView') {
            			this.onViewEvaluationParameter(button,evalType);
            		} else if(button.itemId == 'btnDelete') {
            			this.onDeleteEvaluationParameter(button);
            		}
            	}
            },
            'evaluationparameterswindow button[itemId=btnSaveEvaluationParameters]': {
            	click: function(button) {
            		this.saveEvaluationParameters(button);
            	}
            },
            
            // listeners for conditionalmarks grid
            'conditionalmarksgrid button': {
            	click: function(button) {
            		if(button.itemId == 'btnAdd') {
            			this.onAddConditionalMarks(button);
            		} else if(button.itemId == 'btnEdit') {
            			this.onEditConditionalMarks(button);
            		} else if(button.itemId == 'btnView') {
            			this.onViewConditionalMarks(button);
            		} else if(button.itemId == 'btnDelete') {
            			this.onDeleteConditionalMarks(button);
            		}
            	}
            },
            'conditionalmarkswindow button[itemId=btnSaveConditionalMarks]': {
            	click: function(button) {
            		this.saveConditionalMarks(button);
            	}
            },
            
            // listeners for resource requirement grid
            'resourcerequirementgrid button': {
            	click: function(button) {
            		if(button.itemId == 'btnAdd') {
            			this.onResourceRequirementAdd(button);
            		}else if(button.itemId == 'btnEdit') {
            			this.onResourceRequirementEdit(button);
            		} else if(button.itemId == 'btnView') {
            			this.onResourceRequirementView(button);
            		} else if(button.itemId === 'btnDelete') {
            			this.onResourceRequirementDelete(button);
            		}
            	}
            },
            
            // listeners for documents grid
            'stageconfigurationstructure documentsgrid button': {
            	click: function(button) {
            		if(button.itemId == 'btnAdd') {
            			this.onDocumentAdd(button);
            		}else if(button.itemId == 'btnEdit') {
            			this.onDocumentEdit(button);
            		} else if(button.itemId == 'btnView') {
            			this.onDocumentView(button);
            		} else if(button.itemId === 'btnDelete') {
            			this.onDocumentDelete(button);
            		}
            	}
            },
            'documentswindow button[itemId=btnSaveDocuments]': {
            	click: function(button) {
            		button.setDisabled(true);
            		this.saveDocument(button);
            	}
            },
            'resourcerequirementwindow button[itemId=btnSaveResourseRequirements]': {
            	click: function(button) {
            		this.saveResourceRequirement(button);
            	}
            },
            'resourcerequirementwindow radiogroup[itemId=resourceGroupId]': {
            	change: function(radio,newValue, oldValue) {
            		this.changeResourceTypeCombo(radio,newValue, oldValue);
            	}
            },
            'resourcerequirementwindow nestedJsonCombo[itemId=resourceTypeCombo]': {
            	render: function(combo) {
            		combo.getStore().load({
                          callback: function(records, operation, success) {
                         		combo.getStore().remove(this.data.items[0]);
                          }
                      });
            	}
            },
            'selectionprocessstructure':{
            	render:function(selectionprocessstructure)
            	{
            		this.enableselectionprocesspanel(selectionprocessstructure);
            	},
            	afterrender:function(structure)
            	{
            		
            		var grid=structure.down('selectionprocessgrid');
            		this.getGridHeaderFreeze(grid,structure,true);
            	}
            },
            'spaddeditpanel':{
            	afterrender:function(structure){
    				var $this = this
    				structure.body.on('click', function() {
    					var form = structure.down('#selectionProcessFormId');
    					$this.hideInvalidIconFromField(form);
    			       });
    			}
            },
            'documentsgrid':{
            	afterrender:function(grid){
            		grid.getStore().load();
            	}
            },
            'resourcerequirementgrid':{
            	afterrender:function(grid){
            		grid.getStore().load();
            	}
            }

        });
    },

    
    changeResourceTypeCombo : function(radio,newValue, oldValue){
    	var visible=true;
    	var resourceRequirementForm = radio.up('form');
    	var resourceTypeCombo = resourceRequirementForm.down('#resourceTypeCombo');
    	var resourceCategory= resourceRequirementForm.down('#resourceCategoryId');
    	var radioValue = radio.getValue().resourceGroup;
    	
    	if(radioValue=='FACILITY' || radioValue=='EQUIPMENT'  ){
    		this.loadComponentStore(resourceTypeCombo,'resourceGroup',radioValue);
    		visible=true;
    	}
    	else if(radioValue=='STAFF'||radioValue=='FACULTY') {
    		visible=false;
    	}
    	
    	
    	resourceTypeCombo.allowBlank = !visible;
		resourceTypeCombo.setVisible(visible);
		resourceTypeCombo.setDisabled(!visible);
		resourceTypeCombo.validate();
		
		resourceCategory.setVisible(visible);
		resourceCategory.allowBlank = !visible;
		resourceCategory.setDisabled(!visible);
		resourceCategory.validate();
    },
    
    /*
     * 	********************** Selection Process Methods ********************* 
     */
    
    /**
     * method to save the reordered structure.
     * method common for both, Quota and quota type.
     * @param {Object} button reference of the clicked button.
     */
    onReorderSave : function(button) {
    	var grid = button.up('grid');
    	var store = grid.getStore();
    	var updatedRecords =  store.getUpdatedRecords();
    	var modifiedRecords = new Ext.util.HashMap();
    	
    	var formMethod = 'PUT';
    	Ext.each(updatedRecords, function(rec) {
    		modifiedRecords.add(rec.get('id'), rec.get('stageOrder'));  
    	});
    	var formValues =  Ext.encode(modifiedRecords.map);
    	if(formValues != '{}') {
    		var url = SERVERURL.SP_STAGE_UPDATE_STAGE_ORDER; 
        	Ext.Ajax.request({
                type: 'rest',
                url: url,
                jsonData: formValues,
                method: formMethod,
                success: function(response, action) {
                 var result = response.responseText;
               	 grid.getStore().load();
               	 grid.getSelectionModel().deselectAll(true);
               	 
               	 if(result=="fail"){
               		showErrorMessage(getAdmissionTranslation('SAVE_REORDERING'), getAdmissionTranslation('REORDER_RECORD_FAIL'));
               	 }
               	 else if(result=="success"){
               		showSuccessMessage(getAdmissionTranslation('SAVE_REORDERING'), getCommonTranslation('SUCCESS'));
               	 }
                    
                }
            });	
    	} else {
    		showErrorMessage(getAdmissionTranslation('SAVE_REORDERING'), getAdmissionTranslation('REORDER_RECORD'));
    	}
    	
    }, 
    
    /**
     * method to Add Selection Process.
     * @param {Object} button: reference of the clicked button.
     */
    onAddSelectionProcess: function(button) {
    	var tabReference = this.openTab('SUB', getAdmissionTranslation('SELECTION_PROCESS_ADD'), 'spaddeditpanel');
    	tabReference.query('grid[xtype=selectionprocessstagesgrid]')[0].hide();
    },
    
    /**
     * method to save the newly added Selection Process.
     * @param {Object} button: reference of the clicked button.
     */
    onSelectionProcessSave: function(button) {
    	var this$ = this;
    	var form = button.up('form');
    	var activeTab = form.up('spaddeditpanel');
    	var formMethod = null;
    	var formValues = button.up('form').getValues();
    	var successMessage;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    		successMessage=getCommonTranslation('RECORD_UPDATE_SUCCESS');
    	} else {
    		formMethod = 'POST';
			successMessage=getCommonTranslation('RECORD_ADD_SUCCESS');
    	}
    	
    	var grid = this$.getSelectionProcessStagesGrid();
    	this.selectedStageRecord = grid.getSelectionModel().getSelection()[0]; 
    	 
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.SELECTION_PROCESS_ADD_UPDATE_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 
            	 var selectionProcessGrid = this$.getSelectionProcessGrid();
            	 selectionProcessGrid.getStore().load();
            	 selectionProcessGrid.getSelectionModel().deselectAll(true);
            	 Ext.getBody().unmask();
            	 this$.closeTab(activeTab);
            	 showSuccessMessage(getAdmissionTranslation('SELECTION_PROCESS'),successMessage);
            	 var  contentPanelMain = this$.getContentpanel().getActiveTab();
            	 contentPanelMain.scrollBy(0,1);
				 contentPanelMain.scrollBy(0,-1);
             },
             failure: function(){
            	 this$.closeTab(activeTab);
             }
         });
    },
    
    /**
     * method to Edit Selection Process.
     * @param {Object} button: reference of the clicked button.
     * @param {Boolean} viewOnly: flag to decide if the tab should be opened in view/Edit mode
     */
    onEditSelectionProcess: function(button, viewOnly) {
    	var this$ = this;
    	var selectionProcessGrid = button.up('grid');
    	 var record = selectionProcessGrid.getSelectionModel().getSelection()[0];
    	if(selectionProcessGrid.getSelectionModel().getCount()>0) {
    		//TODO: remove all the other previously opened tabs. 
    		var tabName = "";
        	if (record != "" && record != null && record != undefined) {
        		var name = record.get('name');
        		tabName= name + " - " + getAdmissionTranslation('SELECTION_PROCESS_EDIT');
        	}
    		
        	var formWindow = null;
        	if(viewOnly) {
        		formWindow = this.openTab('SUB', getAdmissionTranslation('SELECTION_PROCESS_VIEW'), 'spaddeditpanel');
        	} else {
        		formWindow = this.openTab('SUB', tabName, 'spaddeditpanel');	
        	}
        	var resetButton =formWindow.down('button#gradeMasterResetButtonId');
   		 	resetButton.setVisible(false);
       		var formRef = formWindow.down('form');
        		formRef.loadRecord(record);
        		var selectionProcessStageGrid = this.getSelectionProcessStagesGrid();
        		var selectionProcessStore = this.getSelectionProcessForm().down('#selectionProcessType').getStore();
        		selectionProcessStore.load({
        			callback: function(records, operation, success) {
						   if (success) {
							   this$.getSelectionProcessForm().down('#selectionProcessType').setValue(record.data.selectionProcessType);
						   }
        			}
        		});
        		var selectionProcesValue = this.getSelectionProcessForm().down('#selectionProcessType').value;
				var quotaTypeSelector = this.getSelectionProcessForm().down('#quotaTypeSelector');
				var remark = this.getSelectionProcessForm().down('#remark');
				var quotaTypeRemark = this.getSelectionProcessForm().down('#quotaTypeRemark');
				if(selectionProcesValue ==='PLACEMENT')
				{
					quotaTypeSelector.setDisabled(true);
					remark.setDisabled(true);
					quotaTypeRemark.setDisabled(true);
				}else{
					quotaTypeSelector.setDisabled(false);
					remark.setDisabled(false);
					quotaTypeRemark.setDisabled(false);
					
				}
				
        		/*
        		 * Code to change all the fields to a viewonly/noneditable mode. 
        		 * and hide the toolbar of the grid.
        		 */
        		if(viewOnly) {
        			this.toggleReadOnlyFormItems(formRef.getForm(), true);
        			formRef.down('button[itemId=btnSaveSelectionProcess]').setVisible(false);
        			var buttonsBar = selectionProcessStageGrid.query('toolbar');
            		buttonsBar[0].setVisible(false);
//        		} else {
//        			var buttonsBar = selectionProcessStageGrid.query('toolbar');
//        			var splitButton = buttonsBar[0].down('splitbutton#btnMoreOperations');
//        			splitButton.setDisabled(false);
        		}
        		
        		/*
        		 *  loading the grid according to the selection of the SP
        		 */
        		var selectionProcessId = record.get('id');
        		var store = selectionProcessStageGrid.getStore(); 
            	var url = store.getProxy().proxyConfig.api.read;
            	url = url.concat('?processId='+selectionProcessId); 
            	store.getProxy().api.read = url;
            	store.load();
            	
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_PROCESS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * method to view the selected Selection Process.
     * @param {Object} button: reference of the clicked button.
     */
    onViewSelectionProcess: function(button) {
    	//Calling the edit method and passing the readonly flag to true.
    	this.onEditSelectionProcess(button, true);
    },
    
    
    /**
     * method to Delete Selection Process.
     * @param {Object} button: reference of the clicked button.
     */
    onDeleteSelectionProcess: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.SELECTION_PROCESS_ADD_UPDATE_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('SELECTION_PROCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_PROCESS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /*
     * 	********************** Selection Process Stages Methods ********************* 
     */  
    /**
     * method to display the selection process Stage window on click of the add new button.
     * @param {Object} button: reference of the clicked button.
     */
    onAddSelectionProcessStages: function(button) {
    	this.showWindow('spstagewindow');
    },
    
    /**
     * method to Edit the selection process Stage on click of the Edit button.
     * @param {Object} button: reference of the clicked button.
     */
    onEditSelectionProcessStages: function(button) {
    	var stageGrid = button.up('grid');
    	if(stageGrid.getSelectionModel().getCount()>0){
    			var stageWindow = this.showWindow('spstagewindow');
                var stageRecord = stageGrid.getSelectionModel().getSelection()[0];
                /*
                 * populate data into the window
                 */
                form = stageWindow.down('form').form;
                form.loadRecord(stageRecord);
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_PROCESS_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method will be used to view the selection process stages.
     * FIXME: [AKR] use the edit method for displaying and making the form readonly.
     */
    onViewSelectionProcessStages: function(button) {
    	var stageGrid = button.up('grid');
    	if(stageGrid.getSelectionModel().getCount()>0){
    		var stageWindow = this.showWindow('spstagewindow');
    		var formRef = stageWindow.down('form');
    		var stageRecord = stageGrid.getSelectionModel().getSelection()[0];
    		formRef.down('button').setVisible(false);
    		formRef.loadRecord(stageRecord);
    		this.toggleReadOnlyFormItems(formRef.getForm(), true);
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_PROCESS_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method to Delete Selection Process Stages.
     * @param {Object} button: reference of the clicked button.
     */
    onDeleteSelectionProcessStages: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.SP_STAGE_ADD_UPDATE_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('SELECTION_PROCESS_STAGE'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_PROCESS_STAGE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method to save the stage details on click of the save stage button
     * Handles both the add and edit functionality.
     * @param {Object} button: reference of the clicked button.
     */
    onSaveStageDetails: function(button) {
    	if(!preventMultipleCalls(button)){
    		return false;
    	}
    	var me = this;
    	var windowRef = button.up('window');
    	var formValues = button.up('form').getValues();
    	var grid = this.getSelectionProcessStagesGrid();
    	var formMethod = null;
    	var url = SERVERURL.SP_STAGE_ADD_UPDATE_DELETE;
    	var selectionProcessId = this.getSelectionProcessForm().down('hidden[name=id]').value;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	formValues.selectionProcessId = selectionProcessId;
    	if(! formValues.hasOwnProperty('committeeApprovalRequired')) {
    		formValues.committeeApprovalRequired = false;
    	}
   	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
            type: 'rest',
            url: url,
            jsonData: formValues,
            method: formMethod,
            success: function() {
            	me.closeFormWindow(windowRef);
            	grid.getStore().load();
            	 Ext.getBody().unmask();
            	grid.getSelectionModel().deselectAll(true);
            	 if(formMethod === 'POST'){
           		  showSuccessMessage(getAdmissionTranslation('ADD_STAGE'),getCommonTranslation('RECORD_ADD_SUCCESS'));
            	 }else{
           		  showSuccessMessage(getAdmissionTranslation('EDIT_STAGE'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
            	 }
            },
            failure: function(){
            	me.closeFormWindow(windowRef);
            }
        });
    },
    
    /**
     * method to open the configure stage tab. used for configuring an individual stage.
     * @param {Object} button: reference of the clicked button.
     */
    configureStage: function(button) {
    	var stageGrid = button.up('grid');
    	var this$ = this;
    	if(stageGrid.getSelectionModel().getCount()>0){
    		var stageRecord = stageGrid.getSelectionModel().getSelection()[0];
    		var stageId = stageRecord.get('id'); 
    		var stageorder=stageRecord.get('stageOrder');
    		//Code to open the tab.
    		var tabReference = this.openTab('SUB', getAdmissionTranslation('STAGE_CONFIGURATION'), 'stageconfigurationpanel');
    		var formRef = tabReference.down('form#basicSettingsForm');
    		var form = formRef.getForm();
    		var evalParamGrid = this.getEvaluationParametersGrid();
        	var condMarksGrid = this.getConditionalMarksGrid();
        	
    		if(stageorder > 1)
    			{
    		this$.initializePreviousStageComponent(formRef, stageId);
    			
    			}
    		else
    			{
    			formRef.down('#previousStagesCheck').hide();
    			}
    		tabReference.down('hidden#selectionProcessStageIdField').setValue(stageId);

    		// do a server call n bring the presaved data 
    		// set it in the above form
    		var url= SERVERURL.SP_STAGE_EVALPARAM_GET;
    		url = url.concat('?selectionProcessStageId='+stageId);
    		Ext.Ajax.request({
    			type: 'rest',
    			url: url,
    			method: 'GET',
    			success: function(response, action) {
    				var responseObj = Ext.decode(response.responseText);
    				form.setValues(responseObj);
    				var gradeType = formRef.down('#gradeTypeId');
    				var gradeTypeStore = gradeType.getStore();
    				gradeTypeStore.load({
    				    	callback: function(records, operation, success) {
    			    			   for(var i=0; i< gradeTypeStore.data.items.length;i++){
    			    				   if(gradeTypeStore.data.items[i].data.id == responseObj.gradeTypeId){
    			    					   gradeType.setValue(gradeTypeStore.data.items[i].data.id);
    			    					   break;
    			    				   } 
    			    			   }
    							}
    			        });
    				   
    				/*Code to set the selection mode radio values.*/
    				var radioComponent = formRef.query('radiogroup')[0];
    				radioComponent.setValue({'whetherAutomatic' :responseObj.whetherAutomatic});
    				
    				formRef.down('#gradeTypeName').setValue(responseObj.evaluationType);
    				
    				 if(responseObj.evaluationType == "GRADE"){
    		            	Ext.each(evalParamGrid.columns, function(currentColumn){
    		            		if(currentColumn.dataIndex=="maxMarks"  ||  currentColumn.dataIndex=="minMarks")
    		    			   {
    		    				   currentColumn.setVisible(false);
    		    			   }
    		    		   }); 
    		            	condMarksGrid.setVisible(false);
    		              }
    				 
    				/*code to set the previous stages values*/
    				var previousStages = responseObj.selectionStagePreviousWeightages;
    				this$.setPreviousStageValues(formRef, previousStages);
    			}
    		});
    		
    		//code to Load dependent grids (eval param and conditionalMarksGrid)if they have data.
    		//add stageEvalParamId in the request.
    		this.loadDependentGrids(stageId);
    		
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_STAGES'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * method to set the values in the previous stage combos.
     * called internally from configureStage method.
     */
    setPreviousStageValues: function(formRef, previousStageValues) {
    	var previousStagesItems = formRef.query('fieldcontainer#previousStageWeightageComponent')[0];
		for(var i=0; i< previousStageValues.length; i++) {
			var j = i+i;
			var valueField = previousStagesItems.items.getAt(j+1);
			var stage = previousStageValues[i];
			valueField.setValue(stage.weightage);
		}
    },
    
    /**
     * Private method to load the dependent grids based on the stageId
     */
     
    loadDependentGrids: function(stageId) {
    	//Loading Evaluation Parameter Grid
    	var store = this.getEvaluationParametersGrid().getStore();
    	var evalParamGridUrl = store.getProxy().proxyConfig.api.read;
		evalParamGridUrl = evalParamGridUrl.concat('?selectionProcessStageId='+stageId);
		store.getProxy().api.read = evalParamGridUrl; 
		store.load();
		
    	//Loading Conditional Marks Grid
		var store = this.getConditionalMarksGrid().getStore();
    	var conditionalMarksGridUrl = store.getProxy().proxyConfig.api.read;
    	conditionalMarksGridUrl = conditionalMarksGridUrl.concat('?selectionProcessStageId='+stageId);
		store.getProxy().api.read = conditionalMarksGridUrl; 
		store.load();
		
		//Loading Resource Plan Grid
		var resourcePlanGridStore = this.getResourceRequirementGrid().getStore();
		var resourcePlanGridUrl = resourcePlanGridStore.getProxy().proxyConfig.api.read;
		resourcePlanGridUrl = resourcePlanGridUrl.concat('?selectionProcessStageId='+stageId);
		resourcePlanGridStore.getProxy().api.read = resourcePlanGridUrl; 
		resourcePlanGridStore.load();
		
		//Loading Documents Grid
		var store = this.getDocumentsGrid().getStore();
    	var documentsGridUrl = store.getProxy().proxyConfig.api.read;
    	documentsGridUrl = documentsGridUrl.concat('?selectionProcessStageId='+stageId);
		store.getProxy().api.read = documentsGridUrl; 
		store.load();
    },
    
    //*************** Basic Settings Methods ************** //
    /**
     * method for hiding/showing the radio component and droolsTextBox on selection of the
     * Basis of Evaluation combo.
     * Logic: 1. show selection Mode Combo in all cases
     * 2. Do not show droolsTextBox If Marks selected:
     * 3. Do not show previous stages if "No Evaluation Selected" 
     *  		
     * @param {Object} combo The reference of the comboBox.
     * @param {Array} records The array of the selected record in the comboBox.
     */
    evaluationComboSelect: function(combo, newValue, oldValue) {
    	var this$=this;    	
    	var droolsComponent = combo.up().down('textfield[itemId=droolsRulesComponent]');
    	var gradeTypeCombo = combo.up().down('#gradeTypeId');
    	var radioComponent = gradeTypeCombo.nextSibling(); 
    	var evalParamGrid = this$.getEvaluationParametersGrid();
		var condMarksGrid = this$.getConditionalMarksGrid();
    	var previousStagesComponent = combo.up().nextSibling();
    	var form = this$.getBasicSettingsForm();
    	if(newValue === 'MARK') {
    		radioComponent.setVisible(true);
    		droolsComponent.setVisible(false);
    		this.setAllowBlank(gradeTypeCombo, true);
    		gradeTypeCombo.setVisible(false);
    		previousStagesComponent.setVisible(true);
    		evalParamGrid.setVisible(true);
    		radioComponent.items.items[0].disabled=false;
    		form.isValid();
   	
    	}else if(newValue === 'GRADE') {
    		radioComponent.setVisible(true);
    		droolsComponent.setVisible(false);
    		this.setAllowBlank(gradeTypeCombo, false);
    		gradeTypeCombo.setVisible(true);    		
    		previousStagesComponent.setVisible(false);
    		evalParamGrid.setVisible(true);
    		radioComponent.setValue({'whetherAutomatic' :false});
    		radioComponent.items.items[0].disabled=true;
    		form.isValid();
    	   	
    	}else if(newValue === 'NO_EVALUATION') {
    		radioComponent.setVisible(true);
    		droolsComponent.setVisible(false);    		
    		this.setAllowBlank(gradeTypeCombo, true);
    		gradeTypeCombo.setVisible(false);
    		previousStagesComponent.setVisible(false);
    		evalParamGrid.setVisible(false);
    		condMarksGrid.setVisible(false);
    		radioComponent.items.items[0].disabled=false;
    		form.isValid();
    		 		
    	} 
    },
    
    /**
     * method to initialize the dropdowns.
     * private method.
     */
    initializePreviousStageComponent: function(formRef, stageId) {
    	/*
    	 * call the api and get the previous stages data and 
    	 * iterate on the data and create the number fields
    	 */
    	var this$ = this;
    	var url= SERVERURL.SP_STAGE_LOAD_PREVIOUS_STAGE;
		url = url.concat('?selectionProcessStageId='+stageId);
		Ext.Ajax.request({
			type: 'rest',
			url: url,
			method: 'GET',
			async: false,
			success: function(response, action) {
				var responseObj = Ext.decode(response.responseText);
				var targetContainer = formRef.query('fieldcontainer#previousStageWeightageComponent')[0];
				targetContainer.removeAll(true);
				var previousStagesCheck = formRef.down("#previousStagesCheck");
				var isEvaluationTypeGrade = false;
				for(var i=0; i< responseObj.length; i++) {
					var stageName = responseObj[i].stageName;
            		var stageId = responseObj[i].id;
            		if(responseObj[i].evaluationType == "GRADE"){
            			isEvaluationTypeGrade = true;
            		} 
					
            		targetContainer.add(Ext.create('Ext.form.field.Hidden', {
            			name: 'previousSelectionStageId',
            			value: stageId
            		}));
            			targetContainer.add(Ext.create('Ext.form.field.Number', {
                			labelAlign: 'left',
                			fieldLabel: stageName+" (%)",
                			name: 'weightage',
                			minValue: 0,
                			labelWidth: 150,
                			maxValue: 100
                		}));
            			this$.setComponentCreated(true); 
				}
				if(isEvaluationTypeGrade){
					previousStagesCheck.setVisible(false);
					targetContainer.removeAll(true);
				}
			}
		});
    },
    
    
    /**
     * method used to toggle the visibility of the previous stages.
     * used in the basic setting tab of the selection process.
     * @param checkBox {Object} the reference of the checkbox.
     * @param {Boolean} newValue The boolean value of the checkbox.
     * True if checked,
     * False if unchecked
     */
    togglePreviousStages: function(checkBox, newValue) {
    	var targetContainer = checkBox.up('panel').down('fieldcontainer#previousStageWeightageComponent');
    	if(newValue) {
    		targetContainer.setVisible(true);
    	}else {
    		targetContainer.setVisible(false);
    	}
    },
    
    /**
     * method to save the basic settings in the stageConfiguration tab.
     * @param {Object} button The reference of the button.
     */
    saveBasicSettings: function(button) {
    	
    	var selectionStagePreviousWeightages = new Array();
    	var form = button.up('form');
    	formValues = form.getValues();
    	var evalParamGrid = this.getEvaluationParametersGrid();
    	var condMarksGrid = this.getConditionalMarksGrid();
    	
    	/*
    	 * include the values only if the check box is checked.
    	 */
    	if(formValues.includePrevsStagePerformance && formValues.previousSelectionStageId) {

    		if(formValues.previousSelectionStageId.constructor === Array){
	    		for(var i=0; i < formValues.previousSelectionStageId.length; i++) {
	        		var stageWeightage = new Object();
	        		stageWeightage.previousSelectionStageId = formValues.previousSelectionStageId[i];
	        		stageWeightage.weightage = formValues.weightage[i];
	        		selectionStagePreviousWeightages.push(stageWeightage);
	        	};	
    		}else{
    			var stageWeightage = new Object();
    			stageWeightage.previousSelectionStageId = formValues.previousSelectionStageId;
        		stageWeightage.weightage = formValues.weightage;
        		selectionStagePreviousWeightages.push(stageWeightage);
    		}
        	formValues.selectionStagePreviousWeightages = selectionStagePreviousWeightages;
    	} else {
    		formValues.includePrevsStagePerformance = false;
    	}
    	
    	delete formValues.previousSelectionStageId;
    	delete formValues.weightage;
    	delete formValues.previousStageText;
    	delete formValues.gradeTypeName;

    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 
    	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.SP_STAGE_EVALPARAM_ADD_EDIT_DELETE,
            jsonData: formValues,
            method: 'PUT',
            success: function(responce) {
           	 Ext.getBody().unmask();
                showSuccessMessage(getAdmissionTranslation('BASIC_SETTINGS'), getAdmissionTranslation('BASIC_SETTINGS_UPDATED'));
                evalParamGrid.getStore().load();
                evalParamGrid.getSelectionModel().deselectAll(true);
                var formValues = form.getValues();
                form.down('#gradeTypeName').setValue(formValues.evaluationType);
                if(formValues.evaluationType == "GRADE"){
            	Ext.each(evalParamGrid.columns, function(currentColumn){
            		if(currentColumn.dataIndex=="maxMarks" || currentColumn.dataIndex=="minMarks")
    			   {
    				   currentColumn.setVisible(false);
    			   }
    		   }); 
            	condMarksGrid.setVisible(false);
              }
                else if(formValues.evaluationType == "MARK"){
                	Ext.each(evalParamGrid.columns, function(currentColumn){
                		if(currentColumn.dataIndex=="maxMarks" || currentColumn.dataIndex=="minMarks")
        			   {
        				   currentColumn.setVisible(true);
        			   }
        		   }); 
                	condMarksGrid.setVisible(true);
                	 form.down('#gradeTypeId').setValue('');
                  }
            }
        });
    },
    
    /* ********************************* evaluation parameters Grid methods *******************************/
    /**
     * method to add a new parameter in the Evaluation parameter tab.
     * @param {Object} button The reference of the button.
     */
    onAddEvaluationParameter: function(button,evalType) {
    	var evaluationParametersWindow = this.showWindow('evaluationparameterswindow');
    	var formWindow = evaluationParametersWindow.down('form');
    	if(evalType == "GRADE"){
    		formWindow.down("#maxMarks").allowBlank = true;
    		formWindow.down("#maxMarks").setVisible(false);
    		formWindow.down("#minMarks").setVisible(false);
    		formWindow.down("#weightage").setValue(100);
    		formWindow.down("#weightage").setReadOnly(true);
    	}
    },
    
    /**
     * this method is used to save the Editing the evaluation parameter.
     */
    onEditEvaluationParameter: function(button, viewOnly, evalType) {
    	var evalParamGrid = button.up('grid');
    	var form = null;
    	if(evalParamGrid.getSelectionModel().getCount()>0){
    			var evaluationParametersWindow = this.showWindow('evaluationparameterswindow');
    			var evalParamRecord = evalParamGrid.getSelectionModel().getSelection()[0];
    			
    	    	var formWindow = evaluationParametersWindow.down('form');
    	    	if(evalType == "GRADE" && !viewOnly){
    	    		formWindow.down("#maxMarks").allowBlank = true;
    	    		formWindow.down("#maxMarks").setVisible(false);
    	    		formWindow.down("#minMarks").setVisible(false);
    	    		formWindow.down("#weightage").setValue(100);
    	    		evalParamRecord.data.weightage=100;
    	    		formWindow.down("#weightage").setReadOnly(true);
    	    	}
               
                /*
                 * populate data into the window
                 */
                //formRef = evaluationParametersWindow.down('form');
                form = evaluationParametersWindow.down('form').form;
                form.loadRecord(evalParamRecord);
                if(viewOnly) {
                	this.toggleReadOnlyFormItems(form, true);                	
                	formWindow.down('button[itemId=btnSaveEvaluationParameters]').setVisible(false);
                	if(evalType == "GRADE"){
                		formWindow.down("#maxMarks").setVisible(false);
                		formWindow.down("#minMarks").setVisible(false);
                	}
                }
    	} else {
    		showWarningMessage(getAdmissionTranslation('EVALUATION_PARAMETERS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * this method is used to save the Editing the evaluation parameter.
     */
    onViewEvaluationParameter: function(button,evalType) {
    	this.onEditEvaluationParameter(button, true, evalType);
    },
    
    /**
     * this method is used to delete the evaluation parameter from the grid. 
     */
    onDeleteEvaluationParameter: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.SP_STAGE_EVALPARAM_GRID_ADD_EDIT_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('SELECTION_PROCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('SELECTION_PROCESS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * this method is used to save the evaluation parameter.
     */
    saveEvaluationParameters: function(button) {
    	if(!preventMultipleCalls(button)){
    		return false;
    	}
    	var this$ = this;
    	var formWindow = button.up('window');
    	var formValues = button.up('form').getValues();
    	var formMethod = null;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	var BSformValues = this$.getBasicSettingsForm().getForm().getValues();
    	
    	var selectionProcessStageEvalParamID = BSformValues.id; 
    	formValues.selectionProcessStageEvalParamID = selectionProcessStageEvalParamID;
    	if(BSformValues.gradeTypeName == "GRADE"){
    		formValues.maxMarks = 100;
    		formValues.weightage = 100;
    	}
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.SP_STAGE_EVALPARAM_GRID_ADD_EDIT_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 var evalParamGrid = this$.getEvaluationParametersGrid();
            	 evalParamGrid.getStore().load();
            	 evalParamGrid.getSelectionModel().deselectAll(true);
            	 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
            	 if(formMethod === 'POST'){
            		  showSuccessMessage(getAdmissionTranslation('EVALUATION_PARAMETERS'),getCommonTranslation('RECORD_ADD_SUCCESS'));
            	 }else{
            		  showSuccessMessage(getAdmissionTranslation('EVALUATION_PARAMETERS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
            	 }
               
             },
             failure: function(response, form, action) {
            	 this$.closeFormWindow(formWindow);
             }
         });
    },
    
    /* ********************************* conditional Marks Grid methods *******************************/
    
    /**
     * method to add a conditional Marks in the conditional Marks grid.
     * @param {Object} button The reference of the button.
     *
     */
    onAddConditionalMarks: function(button) {
    	this.showWindow('conditionalmarkswindow');
    },
    
    /**
     * this method is used to save the Conditional Marks.
     * @param {Object} button The reference of the button.
     */
    saveConditionalMarks: function(button) {
    	var this$ = this;
    	var formWindow = button.up('window');
    	var formValues = button.up('form').getValues();
    	var formMethod = null;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	
    	var BSformValues = this$.getBasicSettingsForm().getForm().getValues();
    	var selectionProcessStageEvalParamId = BSformValues.id; 
    	formValues.selectionProcessStageEvaluationParamID = selectionProcessStageEvalParamId;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.SP_STAGE_CONDMARKS_GRID_ADD_EDIT_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 var condMarksGrid = this$.getConditionalMarksGrid();
            	 condMarksGrid.getStore().load();
            	 condMarksGrid.getSelectionModel().deselectAll(true);
            	 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
            	 if(formMethod === 'POST'){
           		  showSuccessMessage(getAdmissionTranslation('CONDITIONAL_MARKS'),getCommonTranslation('RECORD_ADD_SUCCESS'));
            	 }else{
           		  showSuccessMessage(getAdmissionTranslation('CONDITIONAL_MARKS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
            	 }
             },
             failure: function(){
            	 this$.closeFormWindow(formWindow);
             }
         });
    },
    
    /**
     * this method is used to save the Editing the Conditional Marks.
     * @param {Object} button The reference of the button.
     * @param {Boolean} viewOnly weather the screen should be opened in viewOnly/editable mode.
     */
    onEditConditionalMarks: function(button, viewOnly) {
    	var condMarksGrid = button.up('grid');
    	var form = null;
    	if(condMarksGrid.getSelectionModel().getCount()>0){
    			var conditionalmarkswindow = this.showWindow('conditionalmarkswindow');
                var condMarksRecord = condMarksGrid.getSelectionModel().getSelection()[0];
                /*
                 * populate data into the window
                 */
                formRef = conditionalmarkswindow.down('form');
                form = conditionalmarkswindow.down('form').form;
                form.loadRecord(condMarksRecord);
                if(viewOnly) {
                	this.toggleReadOnlyFormItems(form, true);
                	formRef.down('button[itemId=btnSaveConditionalMarks]').setVisible(false);
                }
    	} else {
    		showWarningMessage(getAdmissionTranslation('CONDITIONAL_MARKS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * this method is used to view the Conditional Marks record.
     * @param {Object} button The reference of the button.
     */
    onViewConditionalMarks: function(button) {
    	this.onEditConditionalMarks(button, true);
    },
    
    /**
     * this method is used to delete the Conditional Marks record.
     * @param {Object} button The reference of the button.
     */
    onDeleteConditionalMarks: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.SP_STAGE_CONDMARKS_GRID_ADD_EDIT_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('CONDITIONAL_MARKS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('CONDITIONAL_MARKS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /*
     *********************** Methods for Resource Requirement grid**********************
     */
    /**
     * method to add ResourceRequirement in the Resource Requirement grid.
     * @param {Object} button The reference of the button.
     */
    onResourceRequirementAdd: function(button) {
    	this.showWindow('resourcerequirementwindow');
    },
    
    /**
     * this method is used to Edit the Resource Requirement form from resource Plan tab.
     * @param {Object} button The reference of the button.
     * @param {Boolean} viewOnly weather the screen should be opened in viewOnly/editable mode.
     */
    onResourceRequirementEdit: function(button, viewOnly) {
    	var resourcePlanGrid = button.up('grid');
    	if(resourcePlanGrid.getSelectionModel().getCount()>0){
    		var resReqRecord = resourcePlanGrid.getSelectionModel().getSelection()[0];
			var resourceRequirementWindow = this.showWindow('resourcerequirementwindow');
            /*
             * populate data into the window
             */
            formRef = resourceRequirementWindow.down('form');
            form = resourceRequirementWindow.down('form').form;
            form.loadRecord(resReqRecord);
            if(viewOnly) {
            	this.toggleReadOnlyFormItems(form, true);
            	formRef.down('button[itemId=btnSaveResourseRequirements]').setVisible(false);
            }
	} else {
		showWarningMessage(getAdmissionTranslation('RESOURCE_PLAN'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
    },
    
    /**
     * this method is used to view the Resource Requirement record.
     */
    onResourceRequirementView: function(button) {
    	this.onResourceRequirementEdit(button, true);
    },
    
    /**
     * this method is used to delete the Resource Requirement record.
     */
    onResourceRequirementDelete: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.SP_STAGE_RESOURCEPLAN_ADD_EDIT_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('RESOURCE_PLAN'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('RESOURCE_PLAN'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /**
     * this method is used to save the Resource Requirement form from resource Plan.
     */
    saveResourceRequirement: function(button) {
    	if(!preventMultipleCalls(button)){
    		return false;
    	}
    	var this$ = this;
    	var formWindow = button.up('window');
    	var formValues = button.up('form').getValues();
    	var formMethod = null;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	var grid = this.getSelectionProcessStagesGrid();
    	var stageRecord = grid.getSelectionModel().getSelection()[0];
    	var selectionProcessStageId = stageRecord.get('id'); 
    	formValues.selectionProcessStageId = selectionProcessStageId;
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.SP_STAGE_RESOURCEPLAN_ADD_EDIT_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 var resReqGrid = this$.getResourceRequirementGrid();
            	 resReqGrid.getStore().load();
            	 resReqGrid.getSelectionModel().deselectAll(true);
            	 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
            	 
            	 if(formMethod === 'POST'){
              		  showSuccessMessage(getAdmissionTranslation('EVALUATION_PARAMETERS'),getCommonTranslation('RECORD_ADD_SUCCESS'));
               	 }else{
              		  showSuccessMessage(getAdmissionTranslation('EVALUATION_PARAMETERS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
               	 }
             },
             failure: function(){
            	 this$.closeFormWindow(formWindow);
             }
         });
    },
    
    /*
     *********************** Methods for Documents grid**********************
     */
    
    /**
     * method to add Document in the Document grid.
     * @param {Object} button The reference of the button.
     */
    onDocumentAdd: function(button) {
    	this.showWindow('documentswindow');
    },
    
    /**
     * this method is used to save the Document record from document tab.
     */
    saveDocument: function(button) {
    	var this$ = this;
    	var formWindow = button.up('window');
    	var formValues = button.up('form').getValues();
    	var formMethod = null;
    	if(formValues.id !== "" && formValues.id !== null && formValues.id !== undefined) {
    		formMethod = 'PUT';
    	} else {
    		formMethod = 'POST';
    	}
    	var selectionProcessStageId;
    	var grid = this.getSelectionProcessStagesGrid();
    	if (grid) {
    		var stageRecord = grid.getSelectionModel().getSelection()[0];
    		var selectionProcessStageId = stageRecord.get('id'); 
    	}
    	if (!selectionProcessStageId && this.selectedStageRecord) {
    	    selectionProcessStageId = this.selectedStageRecord.get('id');
    	}
    	
    	formValues.selectionProcessStageId = selectionProcessStageId;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 Ext.Ajax.request({
             type: 'rest',
             url: SERVERURL.SP_DOCUMENTS_ADD_EDIT_DELETE,
             jsonData: formValues,
             method: formMethod,
             success: function() {
            	 var documentGrid = this$.getDocumentsGrid();
            	 documentGrid.getStore().load();
            	 documentGrid.getSelectionModel().deselectAll(true);
            	 Ext.getBody().unmask();
            	 this$.closeFormWindow(formWindow);
            	 if(formMethod === 'POST'){
             		  showSuccessMessage(getAdmissionTranslation('STAGE_DOCUMENTS'),getCommonTranslation('RECORD_ADD_SUCCESS'));
              	 }else{
             		  showSuccessMessage(getAdmissionTranslation('STAGE_DOCUMENTS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
              	 }
             },
             failure: function(){
            	 this$.closeFormWindow(formWindow);
             }
         });
    },
    
    /**
     * this method is used to Edit the Document in the Document grid.
     * @param {Object} button The reference of the button.
     * @param {Boolean} viewOnly weather the screen should be opened in viewOnly/editable mode.
     */
    onDocumentEdit: function(button, viewOnly) {
    	var documentGrid = button.up('grid');
    	if(documentGrid.getSelectionModel().getCount()>0){
    		var documentRecord = documentGrid.getSelectionModel().getSelection()[0];
			var documentWindow = this.showWindow('documentswindow');
            /*
             * populate data into the window
             */
            formRef = documentWindow.down('form');
            form = documentWindow.down('form').form;
            form.loadRecord(documentRecord);
            if(viewOnly) {
            	this.toggleReadOnlyFormItems(form, true);
            	formRef.down('button[itemId=btnSaveDocuments]').setVisible(false);
            }
	} else {
		showWarningMessage(getAdmissionTranslation('STAGE_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	}
    },
    
    
    /**
     * this method is used to view the Document in the Document grid.
     */
    onDocumentView: function(button) {
    	this.onDocumentEdit(button, true);
    },
    
    
    /**
     * this method is used to delete the Document in the Document grid.
     */
    onDocumentDelete: function(button) {
    	var grid = button.up('grid');
    	var url = SERVERURL.SP_DOCUMENTS_ADD_EDIT_DELETE;
    	if(grid.getSelectionModel().getCount()>0){
    		showConfirmMessage(getCommonTranslation('DELETE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var record = grid.getSelectionModel().getSelection()[0];
                    var id = record.get("id");
                    url = url.concat('/'+id);
                    Ext.Ajax.request({
                        method: "DELETE",
                        type: 'DELETE',
                        url: url,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(form, action) {
                        	grid.getStore().load();
                        	grid.getSelectionModel().deselectAll(true);
                            showSuccessMessage(getAdmissionTranslation('STAGE_DOCUMENTS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
                        }
                    });
                }
            });
    	} else {
    		showWarningMessage(getAdmissionTranslation('STAGE_DOCUMENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    
    /*
     * 	********************** Common Methods ********************* 
     */  
   
    /**
     * method to open a new tab with passed form within it
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    openTab: function(location, tabTitle, contentXType) {
    	if(location === 'main') {
	    	var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
	    	coreErpNavigationController.addTab(tabTitle, contentXType);
    	} else {
    		return this.addTab(tabTitle, contentXType);
    	}
    }, 
    
    /**
     * private method for adding a tab in the inner tab structure (SelectionProcessStructure). 
     * @param {Object} tabTitle the title of the tab which has to be added, it should be the translated value.
     * @param {Object} contentXType The xtype of the item that has to be inserted.
     */
    addTab: function(tabTitle, contentXType) {
    	var contentPanelMain = this.getContentpanel().getActiveTab();
		var spTabPanel = contentPanelMain.down('tabpanel');
       // var spTabPanel = this.getSelectionProcessStructure();
        var innerPanel = spTabPanel.items.findBy(function(tab) {
            return tab.title === tabTitle;
        });
        if (!innerPanel) {
            innerPanel = spTabPanel.add({
                xtype: contentXType,
                title: tabTitle,
                closable: true
            });
        }
        spTabPanel.setActiveTab(innerPanel);
        return innerPanel;
    },
    
    /**
     * method to close the passed Tab
     * Any one reference can be passed.
     * @param {Object} windowAlias: alias of the Tab that has to be closed.
     * @param {Object} windowReference: reference of the Tab that has to be closed.
     */
    closeTab: function(tabReference) {
    	tabReference.close();
    },
    
    /**
     * method to open the passed form
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    showWindow: function(windowReference) {
    	var formWindow = null;
    	switch(windowReference) {
    	case 'spstagewindow':
    			formWindow = this.getSPStageWindow();
    		break;
    	}
    	
        if (!formWindow) {
        	formWindow = Ext.widget(windowReference.toLowerCase());
        }
        formWindow.show();
        
        return formWindow;
    },
    
    /**
     * method to close the passed formWindow
     * @param {Object} windowAlias: alias of the window that has to be closed.
     * @param {Object} windowReference: reference of the form that has to be closed.
     */
    closeFormWindow: function(windowReference) {
    	if(windowReference != null || windowReference != undefined) {
        	windowReference.close();
        } 
    },
     
    /**
    This function is used to set all items of form to read only mode.
    @param {view} form: is the form that has to be changed to a readOnly mode,
    @param {boolean} readOnly: is the boolean value, true to make readOnly,
     false for setting the readOnly property to false.
    */
    toggleReadOnlyFormItems: function (form, readOnly) {
        Ext.suspendLayouts();
        form.getFields().each(function(field) {
        	if(field.xtype !== 'itemselector' && field.xtype != 'multiselectfield') {
        		field.setReadOnly(readOnly);	
        	} else {
        		field.setDisabled(true);
        	}
        });
        Ext.resumeLayouts();
    } ,
    enableselectionprocesspanel:function(selectionprocessstructure)
    {
    	this.showTabforselectionProcessPanel(selectionprocessstructure);
    },

    showTabforselectionProcessPanel : function(selectionprocessstructure) {
    	var panelItem = new Array();
    	var $this = this;
    	var newcont=selectionprocessstructure.items.items.length;
    	var insertPosition=newcont+1;
    	panelItem.push({
    		xtype:'tabpanel',
    		itemId:'allVisibleTP',
    		plain: true,
    		style:{overflow:'hidden !important',margin:'0!important'},
    		
    		frame: false,
    		border:false,
    		defaults: {
    			labelAlign: 'top'
    		},

    		items:[{
    			title: getAdmissionTranslation('SELECTION_PROCESS'),
    			autoScroll: true,
    			cls:'horizontalScrollingFixed',
    			xtype:'panel',
    			layout: 'vbox',
    		    defaults:{
    		        width:'100%'
    		    },
    			items:[{
    				xtype:'panel',
    				items:[{
        				xtype:'selectionprocessgrid'
        			}]
    			}],
    			listeners: {
  					activate: function(me, eOpts){
  						var  contentPanelMain = $this.getContentpanel().getActiveTab();
  						 if (!isNullOrEmpty(contentPanelMain)) {
  							contentPanelMain.scrollBy(0,1);
  	  						contentPanelMain.scrollBy(0,-1);
                         }  		
  					}
  				}
    		}]
    	});

    	selectionprocessstructure.insert(insertPosition,panelItem);
    },

});
