/**
 * @author Amit G */
Ext.define('Academia.controller.admission.selectionStageReport.SelectionStageReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['user.UserAcademyLocationStore','program.ProgramByGroupIdStore','common.BatchesByProgramId','common.SeatTypesByBatchId',
	         'admission.selectionStageReport.SelectionStageReportGridStore'],
	         views: ['admission.selectionStageReport.SelectionStageReportTabStructure',
	                 'admission.selectionStageReport.SelectionStageReportStructure','admission.selectionStageReport.SelectionStageReportGrid',
	                 'admission.selectionStageReport.SelectionStageReportFilter'],
	                 config : {
	                	 STUDENT_SELECTIONSTAGE_REPORT_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager
	                	 .getFeaturePrivilegesMap('STUDENT_SELECTIONSTAGE_REPORT_PRIVILEDGE')
	                 },
	                 refs: [{
	                	 ref: 'selectionstagereportfilter',
	                	 selector: 'selectionstagereportfilter'
	                 },{
	                	 ref: 'selectionstagereportgrid',
	                	 selector: 'selectionstagereportgrid'
	                 }],
	            	
	                 init: function(application) {
	                	 this.control({
	                 		'selectionstagereportfilter customcombobox[itemId=academyLocationCombo]': {
	                             render: function(combo) {
	                             	var me = this;
	                             	var store = combo.getStore();
	                                 store.getProxy().extraParams = {
	                             		id: this.getCurrentlyLoggedInUser().id
	                             	};
	                                 store.load();
	                             },
	                             select: function(combo, record) {
	                             	var acadLocId = record[0].get('id');
	                             	var form = this.getSelectionstagereportfilter();
	                             	var programField=form.down('#programId');
	                             	var batchField=form.down('#batchId');
	                             	var seatTypeField=form.down('#seatTypeId');
	                             	programField.setDisabled(false);
	                             	var programStore = programField.getStore();
	                             	programField.reset();
	                             	batchField.reset();
	                             	
	                             	seatTypeField.reset();
	                             	batchField.setDisabled(true);
	                             	seatTypeField.setDisabled(true);
	                             	 var exportReport = buttonsToolBar.query('#exportReportsId')[0];
	    		                	 exportReport.setDisabled(true);
	                             	programStore.proxy.extraParams = {
	                             			academyLocationIds : acadLocId,
	         	    	        	};
	                             	programStore.load();
	                             }
	                 		},
	                		 'selectionstagereportfilter combo#programId': {
	                			 select: function(obj, record){
	                				 this.selectionStageReportProgSelect(obj, record)
	                			 },
	                			 render : function(obj) {
	                				 var store = obj.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 store.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };
	                				 store.load();
	                			 }
	                		 },
	                		 'selectionstagereportfilter combo#batchId':{
	                			 select: function(obj, record){
	                				 this.selectionStageReportBatchSelect(obj, record)
	                			 }
	                		 },
	                		 'selectionstagereportfilter combo#seatTypeId':{
	                			 select: function(obj, record){
	                				 var exportReport = buttonsToolBar.query('#exportReportsId')[0];
	    		                	 exportReport.setDisabled(false);
	                			 }
	                		 },
	                		 'selectionstagereportfilter button[itemId=searchFilterBtn]' : {
	                			 click : function(form) {
	                				 var grid = this.getSelectionstagereportgrid();
	                				 var buttonsToolBar = grid.query('toolbar')[0];
	                				 var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	                				 var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
	                				 var store = grid.getStore();
	                				 var form = this.getSelectionstagereportfilter().getForm();
	                				 var values = form.getValues();
	                				 store.getProxy().extraParams = {
	                					 progBatchSeatConfId : values.progBatchSeatConfId,
	                				 }
	                				 this.resetPageSetting(store);
	                				 store.load({
	                							  callback: function(records, operation, success) {
	                						 				if(records.length>0){
	                						 				    	pdftoolbar.setDisabled(false);
	                											    	exceltoolbar.setDisabled(false);
	                						 					}
	                									 }
	                						 });
	                				 
	                				 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
	                				     	
	                				      	grid.config.searchFilterForm = this.getSelectionstagereportfilter();
	                				     	
	                				         /***************End Code added for show filter data on PDF/Excel Export Report **************/
	                				 
	                			              }
	                		 },
	                		 'selectionstagereportfilter button[itemId=resetBtn]' : {
	                			 click : function(obj) {
	                				 var form = obj.up('form');
	                				 form.getForm().reset();
	                				 var program = form.down('#programId');
	                				 var batch = form.down('#batchId');
	                				 var seatType = form.down('#seatTypeId');
	                				 var exportReport = buttonsToolBar.query('#exportReportsId')[0];

	                				 program.setDisabled(true);
	                				 batch.setDisabled(true);
	                				 seatType.setDisabled(true);
	                				 exportReport.setDisabled(true);

	                				/* var programStore = program.getStore();
	                				 var academyLocationId=this.getCurrentAcademyLocation();
	                				 programStore.getProxy().extraParams = {
	                					 academyLocationIds: academyLocationId
	                				 };
	                				 programStore.load();*/
	                			 }
	                		 },
	                		 'selectionstagereportgrid button[itemId=exportReportsId]': {
	                			 click: function(btn) {
	                				this.exportXlsSelectionStageReport();
	                			 }
	                		 },
	                		 'selectionstagereportgrid': {
	                        	 render : function(grid) {
		             					this.doAccessControlValidation(grid, this.getSTUDENT_SELECTIONSTAGE_REPORT_PERMISSIONS());
		             					this.disableSelectionStageReportPivileges(grid, this.getSTUDENT_SELECTIONSTAGE_REPORT_PERMISSIONS());
		             					var buttonsToolBar = grid.query('toolbar')[0];
		                       		    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
		                            	var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
		                            	pdftoolbar.setDisabled(true);
		                            	exceltoolbar.setDisabled(true);
		             				}
	                		 }
	                	 });
	                 },

	                 selectionStageReportProgSelect : function(obj, record) {
	                	 var programId = record[0].get("id");
	                	 var form = obj.up('form');
	                	 var batch = form.down('#batchId');
	                	 var seatType = form.down('#seatTypeId');
	                	 batch.reset();
	                	 batch.setDisabled(false);
	                	 seatType.reset();
	                	 seatType.setDisabled(true);
	                	 var exportReport = buttonsToolBar.query('#exportReportsId')[0];
	                	 exportReport.setDisabled(true);
	                	 if(programId > 0){
	                		 var store = batch.getStore();
	                		 store.getProxy().extraParams = {
	                			 id: programId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 selectionStageReportBatchSelect : function(obj, record){
	                	 var form = obj.up('form');
	                	 var seatType = form.down('#seatTypeId');
	                	 seatType.reset();
	                	 seatType.setDisabled(false);
	                	 var exportReport = buttonsToolBar.query('#exportReportsId')[0];
	                	 exportReport.setDisabled(true);
	                	 var batchId = record[0].get("id");
	                	 if(batchId > 0){	    	        					  
	                		 var store = seatType.getStore();
	                		 store.getProxy().extraParams = {
	                			 batchId: batchId
	                		 };
	                		 store.load();
	                	 }
	                 },
	                 disableSelectionStageReportPivileges : function(gridReference, permissionsMap) {

	                	 var associatedAcadLocationIds = new Array();
	                	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                	 var permissionList = Academia.utilities.accessControl.AccessControlManager
	                	 .checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                	 buttonsToolBar = gridReference.query('toolbar')[0];
	                	 buttonsToolBar.setVisible(false);
	                	 var exportReport = buttonsToolBar.query('#exportReportsId')[0];
	                	 Ext.each(permissionList, function(privilege) {
	                		 if (privilege === 'EXPORTREPORTS') {
	                			 if(!isNullOrEmpty(exportReport)){
	                				 exportReport.setVisible(true);
	                			 }        		
	                		 }
	                	 });
	                	 buttonsToolBar.setVisible(true);
	                 },
	                 exportXlsSelectionStageReport : function() {
	            		var $this = this;
	            		var form = $this.getSelectionstagereportfilter().getForm();
	            		var values = form.getValues();
	            		var reportParams = new Object();
	            		var academyLocationId = this.getCurrentAcademyLocation();
	            		var reportTitle = "Selection Stage Report";
	            		var code;
	            		var alinfomodel = Academia.model.authentication.ALInfoModel;
	            		var wheatherSchool = alinfomodel.get('wheatherSchool');
	            		
	            		code = 'SELECTION_STAGE_REPORT';
	            		reportParams.headerName = 'Selection Stage Report';
	            		reportParams.progBatchSeatConfId = values.progBatchSeatConfId;
	            		$this.exportJRXMLReport(code, reportParams, reportTitle, '.vnd.ms-excel', SERVERURL.PATH_SELECTION_STAGE_EXPORT_REPORT);
	            	}
});
