/**
 *  @author Harshit Satya
 */
Ext.define('Academia.controller.alumniManagementSystem.AlumniNewsAndFeedsController', {
    extend: 'Academia.controller.base.BaseController',
    models: [
    	'alumni.alumniNewsAndFeeds.AlumniNewsAndFeedsFilterGridModel'
    ],
    stores: [
    	'alumni.alumniNewsAndFeeds.AlumniNewsIdStore',
    	'alumni.alumniNewsAndFeeds.AlumniNewsTitleStore',
    	'alumni.alumniNewsAndFeeds.AlumniNewsAndFeedsFilterStore',
    	'alumni.alumniNewsAndFeeds.AlumniPassOutYearStore',
    	'alumni.alumniNewsAndFeeds.AlumniNewsPublishAndDraftStore'
    ],
    views: [
    	'alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsStructure',
    	'alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsFilter',
    	'alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsGrid',
    	'alumniSystem.alumniNewsAndFeeds.AlumniAddNewsAndFeeds',
    	'alumniSystem.alumniNewsAndFeeds.AlumniPhotoUploadForm'
    ],
    config: {
        TNS_MANAGE_CEREMONY_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_CEREMONY_PRIVILEGES'),
        ALUMNI_NEWS_AND_FEED_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ALUMNI_NEWS_AND_FEED_PRIVILEGES')
    },
    refs: [{
        ref: 'alumninewsandfeedsfilter',
        selector: 'alumninewsandfeedsfilter'
    },{
        ref: 'alumninewsandfeedsgrid',
        selector: 'alumninewsandfeedsgrid'
    },{
    	ref: 'alumniaddnewsandfeeds',
    	selector: 'alumniaddnewsandfeeds'
    },{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }],
    init: function(application) {
        this.control({
            'alumninewsandfeedsfilter button[name=resetBtn]': {
            	click: function(cmp){
                    var me = this;
                    form = me.getAlumninewsandfeedsfilter();
                    grid = me.getAlumninewsandfeedsgrid();
                    form.getForm().reset();                  
                }
            },
            'alumninewsandfeedsfilter button[name=submitBtn]': {
            	click: this.showNewsAndFeedsData
            },
            'alumninewsandfeedsgrid button[itemId=btnAdd]': {
                click: this.onAddNewsAndFeeds
            },
            'alumninewsandfeedsgrid button[itemId=btnEdit]': {
                click: this.onEditNewsAndFeeds
            },
            'alumninewsandfeedsgrid button[itemId=btnView]': {
                click: this.onViewNewsAndFeeds
            },
            'alumninewsandfeedsgrid': {
            	render: function(grid){
					this.doAccessControlValidation(grid, this.getALUMNI_NEWS_AND_FEED_PRIVILEGES());
					this.getGridButtonsPivileges(grid, this.getALUMNI_NEWS_AND_FEED_PRIVILEGES());
				},
            	selectionchange: function(column, selected, eOpts ){  
        	        var $this = this                
        	        var grid = $this.getAlumninewsandfeedsgrid();
        	        var gridSeletion = grid.getSelectionModel().getCount();
        	        var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	        if(grid.getSelectionModel().getCount()==1) { 
        	        	grid.down('#btnView').setDisabled(false); 
        	            if (selectedRecord.get('status') === 'UNPUBLISHED') {
        	                grid.down('#btnEdit').setDisabled(false);
        	            } 
        	            if(selectedRecord.get('status') === 'PUBLISHED') {
        	                grid.down('#btnEdit').setDisabled(true);
        	            }  
	        	    } else{
	        	        grid.down('#btnEdit').setDisabled(true)
	        	        grid.down('#btnView').setDisabled(true)  
	        	    }if(grid.getSelectionModel().getCount()==0) {
	        	    	grid.down('#btnDelete').setDisabled(true)
	        	    	grid.down('#publishBtnitemId').setDisabled(true)
	        	        grid.down('#unPublishBtnitemId').setDisabled(true)
	        	    } else {
	        	    	grid.down('#btnDelete').setDisabled(false)
	        	    	grid.down('#publishBtnitemId').setDisabled(false)
	        	        grid.down('#unPublishBtnitemId').setDisabled(false)
	        	    }
        	        
        	 },
        	 afterrender: function(grid){
             	var me=this;

                 me.addDataGridConfigButton(grid,me.getALUMNI_NEWS_AND_FEED_PRIVILEGES());
             }
            },
            'alumniaddnewsandfeeds alumniphotouploadform[itemId=alumniNewsAndFeedsUploadImageItemId] filefield[itemId=alumniPhotoFileImage]' : {
                change: this.handleUploadImage
            }, 
            'alumniaddnewsandfeeds button[itemId=btnSaveItemId]': {
            	click: this.createAlumniNewsAndFeeds
            },
            'alumninewsandfeedsgrid button[itemId=btnDelete]':{
            	click: this.deleteNewsAndFeeds
            },
            'alumninewsandfeedsgrid button[itemId=publishBtnitemId]':{
            	click: this.publishNewsAndFeeds
            },
            'alumninewsandfeedsgrid button[itemId=unPublishBtnitemId]':{
            	click: this.unPublishNewsAndFeeds
            },
            'alumniaddnewsandfeeds multiselectcombofield[name=academyLocations]':{
            	change: this.handleProgramFromAcademyLocation
            },
            'alumniaddnewsandfeeds customcombobox[name=alumniProgram]':{
            	change: this.handleBatchFromProgram
            },
            'alumniaddnewsandfeeds button[name=btnReset]': {
            	click: function(cmp){
                    var me = this;
                    form = me.getAlumniaddnewsandfeeds();	
                    form.getForm().reset();                  
                }
            },
        });
    },
    
    showNewsAndFeedsData: function() {
        var me = this,
            form = me.getAlumninewsandfeedsfilter(), 
            grid = me.getAlumninewsandfeedsgrid(),   
            formVal = form.getForm().getValues();    

        grid.getStore().getProxy().extraParams = {
        	newsCode: formVal.newsCode,                   
        	newsTitle: formVal.newsTitle,                     
        	status: formVal.status,    
            startDate: formVal.startDate,             
            endDate: formVal.endDate,                         
        };

        grid.down('pagingtoolbar').moveFirst();
        grid.config.searchFilterForm = me.getAlumninewsandfeedsfilter();
    },
    
    onAddNewsAndFeeds: function() {
        this.openAddNewsAndFeedsPage('add');
    },
    
    onEditNewsAndFeeds: function(grid, rowIndex) {
    	var me = this;
    	var newRecord = {}
    	var grid = me.getAlumninewsandfeedsgrid();
    	var form = me.getAlumniaddnewsandfeeds();
    	
    	
    	if(grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		
    		Ext.Ajax.request({
        		url: SERVERURL.PATH_ALUMNI_NEWS_AND_FEEDS_FETCH_NEWSID,
        		type: 'rest',
                method: 'GET',
                params: { 
                	newsId: record.data.id
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(response){
                	var data = Ext.decode(response.responseText);
                	newRecord = data;
                	me.openAddNewsAndFeedsPage('edit', newRecord);
                }
        	})
    	} 
    },
    
    onViewNewsAndFeeds: function(grid, rowIndex){
    	var me = this;
    	var newRecord = {}
    	var grid = me.getAlumninewsandfeedsgrid();
    	var addNewsAndFeedsTab = Ext.widget('alumniaddnewsandfeeds');
    	
    	if(grid.getSelectionModel().getCount() > 0) {
    		var record = grid.getSelectionModel().getSelection()[0];
    		
    		Ext.Ajax.request({
        		url: SERVERURL.PATH_ALUMNI_NEWS_AND_FEEDS_FETCH_NEWSID,
        		type: 'rest',
                method: 'GET',
                params: { 
                	newsId: record.data.id
                },
                headers: {
                    'Content-Type': 'application/json'
                },
                success: function(response){
                	var data = Ext.decode(response.responseText);
                	newRecord = data;
                	me.openAddNewsAndFeedsPage('view', newRecord);                 	
                }
        	})
    	}
    },
    
    openAddNewsAndFeedsPage: function(mode, record) {
    	var $this = this;
        var contentpanel = $this.getContentPanel();
        var tabName;
        if(mode === 'add') {
        	tabName = getAlumni('ADD_NEWS_AND_FEEDS');
        }
        if(mode === 'edit') {
        	tabName = getAlumni('EDIT_NEWS_AND_FEEDS');
        }
        if(mode === 'view') {
        	tabName = getAlumni('VIEW_NEWS_AND_FEEDS');
        }
           
        var navigationController = $this.getController('menu.CoreERPNavigationController');
        
        var existingTab = navigationController.getTab(tabName);
        if (existingTab) {
            contentpanel.remove(existingTab);
        }
        
        var addNewsAndFeedsTab = Ext.widget('alumniaddnewsandfeeds');
        
        var oppositeTabNames = [];
        if (mode === 'add') {
            oppositeTabNames = [getAlumni('EDIT_NEWS_AND_FEEDS'), getAlumni('VIEW_NEWS_AND_FEEDS')];
        } else if (mode === 'edit') {
            oppositeTabNames = [getAlumni('ADD_NEWS_AND_FEEDS'), getAlumni('VIEW_NEWS_AND_FEEDS')];
        } else if (mode === 'view') {
            oppositeTabNames = [getAlumni('ADD_NEWS_AND_FEEDS'), getAlumni('EDIT_NEWS_AND_FEEDS')];
        }
        
        contentpanel.items.each(function(tab) {
            if (oppositeTabNames.includes(tab.title)) {
                contentpanel.remove(tab);
            }
        });
        
        
   	 	openTab(contentpanel, tabName, addNewsAndFeedsTab, CONSTANTS.MENU_COLOR_ONE);
        
        addNewsAndFeedsTab.setMode(mode);
        
        if (mode === 'edit' || mode === 'view') { 	
        	var form = addNewsAndFeedsTab.getForm();
         	form.findField('recordId').setValue(record.id);
             form.findField('newsId').setValue(record.code);
             form.findField('newsTitle').setValue(record.title);
             form.findField('description').setValue(record.description);
             
             if(record.startDate) {	
             	form.findField('startDate').setValue(record.alumniStartDate);
             } else {
             	form.findField('startDate').setValue(null);
             }
             if(record.endDate) {	
             	form.findField('endDate').setValue(record.alumniEndDate);
             } else {
             	form.findField('endDate').setValue(null);
             }
             
             
             
             if(record.startTime) {
             	form.findField('startTime').setValue(record.alumniStartTime);
             } else {
             	form.findField('startTime').setValue(null);
             }
             if(record.endTime) {
             	form.findField('endTime').setValue(record.alumniEndTime);
             } else {
             	form.findField('endTime').setValue(null);
             }
             
             var startDateField = addNewsAndFeedsTab.down('#startDateItemId');
             var endDateField = addNewsAndFeedsTab.down('#endDateItemId');
		     var currentDate = new Date();
				
			 if (startDateField) {
			    // Set initial minValue for startDateField
			    var validFromDate = record.startDate ? new Date(record.startDate) : null;
			    if(validFromDate) {
			    	startDateField.setMinValue(validFromDate > currentDate ? currentDate : validFromDate);
			    } else {
			    	startDateField.setMinValue(currentDate);
			    }
			    startDateField.validate();
			
			    // Add change listener to dynamically update endDateField minValue
			    startDateField.on('change', function(field, newValue) {
			        if (endDateField) {
			            var selectedStartDate = new Date(newValue);
			
			            // Set the endDateField minValue
			            if (selectedStartDate < currentDate) {
			                endDateField.setMinValue(currentDate);
			            } else {
			                endDateField.setMinValue(selectedStartDate);
			            }
			
			            // Validate the endDateField to enforce the updated minValue
			            endDateField.validate();
			        }
			    });
			 }
			
			 if (endDateField) {
			    // Set initial minValue for endDateField
			    var startDate = record.startDate ? new Date(record.startDate) : null;
			    if (startDate && !record.endDate) {
			        endDateField.setMinValue(startDate > currentDate ? startDate : currentDate);
			    } else {
			        endDateField.setMinValue(currentDate);
			    }
			    endDateField.validate();
			 }

             
             var alumniNewsAndFeedsuploadImage = addNewsAndFeedsTab.down('#alumniNewsAndFeedsUploadImageItemId');
             var imageFileName = record.imageUrl;
             var imagePathArray = imageFileName.split('/');
             var imageName = imagePathArray[imagePathArray.length-1]
             alumniNewsAndFeedsuploadImage.down('#hiddenFileName').setValue(imageFileName);
             alumniNewsAndFeedsuploadImage.down('#alumniPhotoFileImage').setRawValue(imageName)
             
             var academyLocations = [];
             Ext.each(record.alumniNewsAndFeedsMapping, function(item) {
                 academyLocations.push(item.academyLocation.id);
             });
             
             
             // Load academyLocations first
             form.findField('academyLocations').getStore().load({
            	    callback: function () {
            	        form.findField('academyLocations').setValue(academyLocations);

            	        // Proceed to load alumniProgram and alumniBatch only after academyLocations is set
            	        if (academyLocations.length === 1) {
            	            var mapping = record.alumniNewsAndFeedsMapping[0];

            	            // Load and set alumniProgram field
            	            if (mapping.program) {
            	                var programCombo = form.findField('alumniProgram');
            	                programCombo.getStore().load({
            	                    callback: function (programRecords) {
            	                        if (programRecords.length > 0) {
            	                            programCombo.setValue(mapping.program.id); 
            	                            if (mapping.batch) {
            	                                var batchCombo = form.findField('alumniBatch');
            	                                batchCombo.getStore().load({
            	                                    callback: function (batchRecords) {
            	                                        if (batchRecords.length > 0) {
            	                                            batchCombo.setValue(mapping.batch.id); 
            	                                        }
            	                                    }
            	                                });
            	                            }
            	                        }
            	                    }
            	                });
            	            }
            	        }
            	    }
            	});

             
             if(record.alumniNewsAndFeedsMapping[0].passoutYear) {
             	var passoutYearCombo = form.findField('passoutYear');
             	passoutYearCombo.setValue(record.alumniNewsAndFeedsMapping[0].passoutYear)
             }
             
             
             if (mode === 'view') {
                 // Disable all fields in view mode
                 addNewsAndFeedsTab.getForm().getFields().each(function(field) {
                     field.setReadOnly(true);
                 });
                 form.findField('imagePathDisplay').setValue(imageName)
             } 
         }
        
    },
    
    handleUploadImage: function(photoFileImage, value, eOpts) {
        value = value.replace('C:\\fakepath\\', '');
        var newValue = value.replace(/ +/g, " ").split(' ').join('_');
        photoFileImage.setRawValue(newValue);
        
        var extension = value.substring(value.lastIndexOf('.') + 1).toLowerCase();
        
        if (!isNullOrEmpty(value)) {
            // Check for valid file extension
            if (extension == "png" || extension == "jpeg" || extension == "jpg") {
                // Check for file size
                var file = photoFileImage.fileInputEl.dom.files[0];
                if (file && file.size > 5 * 1024 * 1024) { // 5 MB limit
                    photoFileImage.reset();
                    showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_FILE_SIZE_EXCEEDED'));
                }
            } else {
                photoFileImage.reset();
                showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
            }
        }
    },
    
    createAlumniNewsAndFeeds: function(button) {
        var me = this;
        var formPanel = me.getAlumniaddnewsandfeeds();
        var formValues = formPanel.getValues();
        
        // Check if there's an image to upload
        var imageField = formPanel.down('#alumniNewsAndFeedsUploadImageItemId');
        var imageVal = imageField.down('#alumniPhotoFileImage');
        
        if (imageVal.getValue()) {
        	imageField.getForm().submit({
                method: 'POST',
                url: SERVERURL.PATH_ALUMNI_NEWS_FILE_UPLOAD,
                success: function(form, action) {
                    var responseData = Ext.decode(action.response.responseText);
                    var path = responseData.path;
                    if(path.split('.')[1] == '') {
                    	var existingImageUrl = formPanel.down('#hiddenFileName').getValue();
                        me.saveAluminiNewsAndFeedsData(existingImageUrl);
                    } else {
                    	me.saveAluminiNewsAndFeedsData(path);
                    }
                     
                }
            })
        } else {
            // Use existing image URL if no new file is selected
            var existingImageUrl = formPanel.down('#hiddenFileName').getValue();
            me.saveAluminiNewsAndFeedsData(existingImageUrl);
        }
        
         
    },
    
    saveAluminiNewsAndFeedsData: function(imageUrl) {
    	var me = this;
        var formPanel = me.getAlumniaddnewsandfeeds();
        var formValues = formPanel.getValues();

        // Collect academy locations
        var alumniNewsAndFeedsAcademyLocation = [];
        Ext.each(formValues.academyLocations, function(location) {
            var mapping = {
                "academyLocation": { "id": location.data ? location.data.id : location }
            };

            if (formValues.alumniProgram) {
                mapping.program = { "id": formValues.alumniProgram };
            }

            if (formValues.alumniBatch) {
                mapping.batch = { "id": formValues.alumniBatch };
            }

            if (formValues.passoutYear) {
                mapping.passoutYear = formValues.passoutYear;
            }

            alumniNewsAndFeedsAcademyLocation.push(mapping);
        });
        
        var status = "UNPUBLISHED";
        if (formValues.recordId && formValues.status) {
            status = formValues.status;
        }

        var dataPayload = {
            title: formValues.newsTitle,
            imageUrl: imageUrl,
            status: status,
            alumniNewsAndFeedsMapping: alumniNewsAndFeedsAcademyLocation
        };
        
        if (formValues.startDate) {
            dataPayload.startDate = formValues.startDate;
        }
        if (formValues.endDate) {
            dataPayload.endDate = formValues.endDate;
        }
        if (formValues.startTime) {
            dataPayload.startTime = formValues.startTime;
        }
        if (formValues.endTime) {
            dataPayload.endTime = formValues.endTime;
        }
        if (formValues.description) {
            dataPayload.description = formValues.description;
        }
        
        if (formValues.recordId) {
            dataPayload.id = formValues.recordId;
            dataPayload.code = formValues.newsId;
        }
        
        var submitUrl = SERVERURL.PATH_ALUMNI_ADD_NEWS_AND_FEEDS;
                
        var tabName;
        
        if (formValues.recordId != '' || formValues.newsId != '') {
        	tabName = getAlumni('EDIT_NEWS_AND_FEEDS');
        } else {
        	tabName = getAlumni('ADD_NEWS_AND_FEEDS');
        }
        
        var navigationController = this.getController('menu.CoreERPNavigationController');
        
        var currentTab = navigationController.getTab(tabName);
        
        if(currentTab.title == getAlumni('EDIT_NEWS_AND_FEEDS')) {
        	 showConfirmMessage(getAlumni('NEWS_AND_FEEDS'), 'You are about to perform an action that will reset all records and settings. Please review everything carefully before proceeding. Do you want to continue?', function (btn, text) {
        		 if(btn == "yes") {
        			 var data = Ext.encode(dataPayload);
        		        Ext.Ajax.request({
        		            url: submitUrl,
        		            method: "POST",
        		            jsonData: data,
        		            success: function(response) {
        		                Ext.getBody().unmask();

        		                // Parse response
        		                var responseData = Ext.decode(response.responseText);
        		                
        		                // Check if response is 0 (or whatever condition you need)
        		                if (!formValues.recordId && responseData === 0) {
        		                    // Handle duplicate data case
        		                    showErrorMessage(getCommonTranslation('ERROR'), getAlumni('DUPLICATE_DATA'));
        		                } else {
        		                    // Handle successful response
        		                    var grid = me.getAlumninewsandfeedsgrid();
        		                    grid.getStore().load();

        		                    var currentTab = me.getController('menu.CoreERPNavigationController').getTab(
        		                            formValues.recordId ? getAlumni('EDIT_NEWS_AND_FEEDS') : getAlumni('ADD_NEWS_AND_FEEDS')
        		                    );
        		                    
        		                    showSuccessMessage(getAlumni('NEWS_AND_FEEDS'), getAlumni('NEWS_AND_FEEDS_SAVE'));
        		                    
        		                    if (currentTab) {
        		                        me.getContentPanel().remove(currentTab, true);
        		                    }
        		                }
        		            },
        		            failure: function(response) {
        		                Ext.getBody().unmask();
//        		                showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('SERVER_ERROR'));
        		            }
        		        });
        		 } else {
        			 me.getContentPanel().remove(currentTab, true);
        		 }
        	 })
        } else {

			 var data = Ext.encode(dataPayload);
		        Ext.Ajax.request({
		            url: submitUrl,
		            method: "POST",
		            jsonData: data,
		            success: function(response) {
		                Ext.getBody().unmask();

		                // Parse response
		                var responseData = Ext.decode(response.responseText);
		                
		                var saveButton = formPanel.down('#btnSaveItemId');
		                
		                // Check if response is 0 (or whatever condition you need)
		                if (!formValues.recordId && responseData === 0) {
		                    // Handle duplicate data case
		                	saveButton.setDisabled(true);
		                    showErrorMessage(getCommonTranslation('ERROR'), getAlumni('DUPLICATE_DATA'));
		                } else {
		                    // Handle successful response
		                    var grid = me.getAlumninewsandfeedsgrid();
		                    grid.getStore().load();

		                    var currentTab = me.getController('menu.CoreERPNavigationController').getTab(
		                            formValues.recordId ? getAlumni('EDIT_NEWS_AND_FEEDS') : getAlumni('ADD_NEWS_AND_FEEDS')
		                    );
		                    
		                    showSuccessMessage(getAlumni('NEWS_AND_FEEDS'), getAlumni('NEWS_AND_FEEDS_SAVE'));
		                    
		                    if (currentTab) {
		                        me.getContentPanel().remove(currentTab, true);
		                    }
		                }
		            },
		            failure: function(response) {
		                Ext.getBody().unmask();
//		                showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('SERVER_ERROR'));
		            }
		        });
		 
        }
        
        
        
    },
    
    deleteNewsAndFeeds: function(obj){
    	var this$ = this;
        var grid = this.getAlumninewsandfeedsgrid(); 
        if (grid.getSelectionModel().getCount() > 0) {
            var selectionModel = grid.getSelectionModel().getSelection();
            var idsArr = [];

            selectionModel.forEach(function (record) {
                idsArr.push(record.get('id')); 
            });

            var ids = idsArr.join();

           
            showConfirmMessage(getAlumni('NEWS_AND_FEEDS_LIST'), getAlumni('DO_YOU_WANT_TO_DELETE'), function (btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');

                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_ALUMNI_NEWS_AND_FEEDS_DELETE,
                        params: {
                        	newsIds: ids, 
                        },
                        method: 'POST',
                        success: function (form, action) {
                   
                            Ext.getBody().unmask();
                          
                            showSuccessMessage(getAlumni('NEWS_AND_FEEDS'), getAlumni('DELETE_SUCCESS'));
                           
                            grid.getStore().load();
                            
                            grid.getSelectionModel().deselectAll();
                        },
                        failure: function () {
                            Ext.getBody().unmask();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }	
    },
    
    publishNewsAndFeeds: function(obj){
    	var this$ = this;
        var grid = this.getAlumninewsandfeedsgrid(); 
        if (grid.getSelectionModel().getCount() > 0) {
            var selectionModel = grid.getSelectionModel().getSelection();
            var idsArr = [];

            selectionModel.forEach(function (record) {
                idsArr.push(record.get('id')); 
            });

            var ids = idsArr.join();

           
            showConfirmMessage(getAlumni('NEWS_AND_FEEDS_LIST'), getAlumni('DO_YOU_WANT_TO_PUBLISH'), function (btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');

                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_ALUMNI_NEWS_AND_FEEDS_PUBLISH,
                        params: {
                        	newsAndFeedsIds: ids, 
                        },
                        method: 'POST',
                        success: function (form, action) {
                   
                            Ext.getBody().unmask();
                          
                            showSuccessMessage(getAlumni('NEWS_AND_FEEDS'), getAlumni('PUBLISH_SUCCESS'));
                           
                            grid.getStore().load();
                            
                            grid.getSelectionModel().deselectAll();
                        },
                        failure: function () {
                            Ext.getBody().unmask();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }	
    },
    
    unPublishNewsAndFeeds: function(obj){
    	var this$ = this;
        var grid = this.getAlumninewsandfeedsgrid(); 
        if (grid.getSelectionModel().getCount() > 0) {
            var selectionModel = grid.getSelectionModel().getSelection();
            var idsArr = [];

            selectionModel.forEach(function (record) {
                idsArr.push(record.get('id')); 
            });

            var ids = idsArr.join();

           
            showConfirmMessage(getAlumni('NEWS_AND_FEEDS_LIST'), getAlumni('DO_YOU_WANT_TO_UNPUBLISH'), function (btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');

                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_ALUMNI_NEWS_AND_FEEDS_UNPUBLISH,
                        params: {
                        	unpublishNewsAndFeedsIds: ids, 
                        },
                        method: 'POST',
                        success: function (form, action) {
                   
                            Ext.getBody().unmask();
                          
                            showSuccessMessage(getAlumni('NEWS_AND_FEEDS'), getAlumni('UNPUBLISH_SUCCESS'));
                           
                            grid.getStore().load();
                            
                            grid.getSelectionModel().deselectAll();
                        },
                        failure: function () {
                            Ext.getBody().unmask();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }	
    },
    
    getGridButtonsPivileges:function(grid,permissionMap){

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
    	
		var publishBtnitemId = grid.down('#publishBtnitemId');
		publishBtnitemId.setVisible(false);
		
		var unPublishBtnitemId = grid.down('#unPublishBtnitemId');
		unPublishBtnitemId.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		
    		if (privilege === 'PUBLISH') {
        		if(!isNullOrEmpty(publishBtnitemId)){
        			publishBtnitemId.setVisible(true);
        		}        		
        	}
    		
    		if (privilege === 'UNPUBLISH') {
        		if(!isNullOrEmpty(unPublishBtnitemId)){
        			unPublishBtnitemId.setVisible(true);
        		}        		
        	}
    	});
    },
    
    handleProgramFromAcademyLocation:function(obj, rec) {
		var $this = this;
		var form = $this.getAlumniaddnewsandfeeds();
		var program = form.down('#alumniProgramItemId');
		var batch = form.down('#alumniBatchItemId');
		program.reset();
		batch.reset();
		if(rec.length==1){
			if(!isNullOrEmpty(rec) && typeof rec[0] !='object') {
				var academyLocations=[];
				if(rec.length > 0){
					academyLocations.push(rec);
				}
				program.setDisabled(false);
				program.getStore().getProxy().extraParams = {
					academyLocationIds:academyLocations.join()
				};
				program.getStore().load();
				program.setValue(null); 
				batch.setDisabled(true); 
				batch.setValue(null); 
				batch.getStore().removeAll(); 
			}
		} else {
			program.setDisabled(true);
			program.setValue(null);
			program.getStore().removeAll();

			batch.setDisabled(true);
			batch.setValue(null);
			batch.getStore().removeAll();
		}
	},
	
	handleBatchFromProgram:function(obj, rec) {
		var $this = this;
		var form = $this.getAlumniaddnewsandfeeds();
		var batch = form.down('#alumniBatchItemId');
		batch.reset();
        if (rec) {
        	batch.setDisabled(false);
        	batch.getStore().getProxy().extraParams = {
        		programIds: rec
			};
        	batch.getStore().load();
        	batch.setValue(null);
        } else {
        	batch.setDisabled(true);
        	batch.setValue(null);
        	batch.getStore().removeAll();
        }
	},

  
});
