/**
 * @author Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.controller.attendance.AttendanceMasterController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['attendance.CourseLevelFacultyBlankModel','attendance.attendancereport.AttendanceReportGrid',
	          'attendance.UpdateAttendanceModel'],
	stores : ['common.ProgramByAcademyLocationStore','attendance.StudentCourses','attendance.CourseLevelFacultyBlank',
	          'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch', 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameAdmissionCodeBySmartSearch','attendance.FacultyNameSmartSearch',
	          'course.coursecomponent.CourseComponentCouseWise','attendance.StudentSearch','enquiry.AcademicBatchStore',
	          'attendance.SectionByCourseNComponent','attendance.AllProgramMappedByCourse','common.BatchesByProgramId','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'attendance.SectionAndFacultyByPeriodID','attendance.StudentAttendanceStatus','attendance.TimeSlotList',
	          'attendance.FacultyGridCompleteNMultipleSession','attendance.UserNameSmartSearchByUserGroup',
	          'attendance.attendancereport.AttendanceForCompleteDayList','attendance.attendancereport.AttendanceForCourseLevelList',
	          'attendance.FacultyAttendanceStatus','attendance.AssignedCoursesFacultyStore','common.AssignedProgramStore','attendance.AttendanceReportTreeStore',
	          'coursetransaction.studentenrollment.studentenrollmentdetail.AdmissionCodeBySmartSearch','attendance.attendancereport.AttendanceReportGrid',
	          'coursetransaction.studentenrollment.studentenrollmentdetail.AdmissionCodeBySmartSearch','attendance.attendancereport.AcadmyByAdmission',
	          'course.coursevariants.CourseVariantStore','program.programDetails.programBatches.PrimaryAcademicStore','organization.academylocations.AcademicTenureStore',
	          'attendance.AttendanceFacultyList','personinfo.faculty.FacultySurveyStr','attendance.attendancereport.AttendanceReportSummary','attendance.ConsolidateAttendanceGridStore',
	          'attendance.AssignedSectionByCourseNComponent','common.ClassTeacherProgramStore','attendance.StudentAttendanceStatusStore','attendance.AttendanceMarkingTypeStore',
	          'personinfo.common.personalinfo.StudentAttendanceGroupStore','attendance.MultipleSessionValueStore','admission.applicationFormSale.ProgramGroupComboStore',
	          'personinfo.common.personalinfo.AttendanceReportProgramGroupStore','attendance.FacultyAttendanceReportTreeStore'
	          ],
	          views : ['attendance.AttendanceMasterStrucure','attendance.AttendanceSearchStrucure','attendance.StudentSearch',
	                   'attendance.AttendanceStructure','attendance.EditAttendance','attendance.AddEditTopics','attendance.AttendanceTabMasterStructure',
	                   'attendance.MarkAttendanceMasterStructure','attendance.StudentAttendanceUploaddownloadStructure','attendance.FacultyGridCompleteNMultipleSession',
	                   'attendance.AttendanceForComplateDayList','attendance.AttendanceForCourseLevelList','attendance.AttendanceMainStructure',
	                   'attendance.attendancereport.AttendanceReprotStructure','attendance.pendingattendance.PendingAttendanceStructure','attendance.attendancereport.AttendanceReportSearch',
	                   'attendance.attendancereport.AttendanceReportGrid','attendance.attendancereport.AttendanceDataStatus',
	                   'attendance.attendancereport.AttendanceDataStatusGrid','Academia.view.attendance.attendancereport.AttendanceSendSurvey',
	                   'attendance.pendingattendance.PendingSearchAttendance','attendance.pendingattendance.PendingAttendanceStructure',
	                   'attendance.pendingattendance.PendingAttendanceGrid','attendance.pendingattendance.PendingDetailsWindow','attendance.OpenAttendanceStatusWindow',
	                   'attendance.pendingattendance.MarkedAttendanceDetailsWindow','attendance.ConsolidateSearchAttendance','attendance.ConsolidateAttendanceStructure','attendance.ConsolidateAttendanceGrid'
	                   ],

	                   config: {

	                	   /* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.

	                	    *//**
	                	    * @cfg {Array} ATTENDANCE_PERMISSIONS array (required)
	                	    * The array of permissions to use for Access control wise enabling and disabling buttons.
	                	    * @accessor 
	                	    */
	                	   ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES'),
	                	   ATTENDANCE_SUMMARY_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_SUMMARY_REPORT_PRIVILEGES'),
	                	   STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_WISE_ATTENDANCE_REPORT_PRIVILEGES'),
	                	   FACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PRIVILEGES')
	                   },

	                   refs : [{
	                	   ref: 'attendancetabmasterstructure',
	                	   selector: 'attendancetabmasterstructure'
	                   },{
	                	   ref: 'attendancestudentsearch',
	                	   selector: 'attendancestudentsearch'
	                   },{
	                	   ref: 'attendancesearchstrucure',
	                	   selector: 'attendancesearchstrucure'
	                   },{
	                	   ref: 'attendancestructure',
	                	   selector: 'attendancestructure'
	                   },{
	                	   ref: 'attendancemasterstrucure',
	                	   selector: 'attendancemasterstrucure'
	                   },{
	                	   ref: 'contentPanel',
	                	   selector: 'contentPanel'
	                   },{
	                	   ref: 'editattendance',
	                	   selector: 'editattendance'
	                   },{
	                	   ref : 'editattenDance',
	                	   selector : 'editattendance form'
	                   },{
	                	   ref: 'addedittopics',
	                	   selector: 'addedittopics'
	                   },{
	                	   ref : 'addeditTopics',
	                	   selector : 'addedittopics form'
	                   },{
	                	   ref : 'attendanceforcomplatedaylist',
	                	   selector : 'attendanceforcomplatedaylist'
	                   },{
	                	   ref : 'attendanceforcourselevellist',
	                	   selector : 'attendanceforcourselevellist'
	                   },{
	                	   ref : 'attendancemainstructure',
	                	   selector : 'attendancemainstructure'
	                   },{
	                	   ref : 'attendancedatastatus',
	                	   selector : 'attendancedatastatus'
	                   },{
	                	   ref : 'attendanceDatastatus',
	                	   selector : 'attendancedatastatus grid'
	                   },{
	                	   ref : 'attendancedatastatusgrid',
	                	   selector : 'attendancedatastatusgrid'
	                   },{
	                	   ref :'attendancesendsurvey',
	                	   selector : 'attendancesendsurvey'
	                   },{
	                	   ref :'attendanceSendSurvey',
	                	   selector : 'attendancesendsurvey form'
	                   },{
	                	   ref : 'attendancereportsearch',
	                	   selector : 'attendancereportsearch'
	                   },{
	                	   ref : 'attendancereprotstructure',
	                	   selector : 'attendancereprotstructure'
	                   },{
	                	   ref : 'attendancereportgrid',
	                	   selector : 'attendancereportgrid[itemId=attendancereportgridItemId]'
	                   },{
	                	   ref: 'openattendancestatuswindow',
	                	   selector: 'openattendancestatuswindow'
	                   }],
	                   init : function() {
	                	   this.control({
	                		   'attendancestudentsearch':{
	                			   render : function(form){
	                				   this$=this;
	                				   var forms = form.getForm();
	                				   var academyLocationId = this$.getCurrentAcademyLocation();
	                				   var programGroupStore = this.getStore('personinfo.common.personalinfo.AttendanceReportProgramGroupStore');
	                				   programGroupStore.getProxy().extraParams = {
	                					   academyLocationId: academyLocationId
	                				   };
	                				   programGroupStore.load();
	                				   
	                				   var studentAttendanceGroupStore = forms.findField("studentAttendanceGroup").getStore();
	                				   studentAttendanceGroupStore.getProxy().extraParams = {
	                					   type:'studentGroup'
	                				   };
	                				   studentAttendanceGroupStore.load();
	                			   },
	                			   afterlayout:function(form, isValid, eOpts){
									   this.checkFormValidity(form);
								   }
	                		   },
	                		   'attendancestudentsearch button[itemId=searchBtn]': {
	                			   click: function(){
	                				   var $this = this;
	                				   var  contentPanelMain = this.getContentPanel().getActiveTab();
	                				   contentPanelMain.scrollBy(0,1);
	                				   contentPanelMain.scrollBy(0,-1);
	                				   var attendancestructure = $this.getAttendancesearchstrucure();
	                				   this.attendanceTypeFilter(); 
	                			   }
	                		   },
	                		   'attendancestudentsearch button[itemId=resetBtn]': {
	                			   click: function(){
	                				   this.resetSearchFilter();
	                			   }
	                		   },
	                		   'attendancestudentsearch customcombobox[itemId=attendanceAcademicTerm]': {
	                			   change: function(obj, record){
	                				   var this$ = this;
	                				   var academicTermId = obj.value;
	                				   var form = this.getAttendancestudentsearch();
	                				   var academyLocationId = this$.getCurrentAcademyLocation();
	                				   var attendanceType = form.down('#attendanceTypeRadio').getValue().attendanceTypeWise;
	                				   var facultyField = form.down('#facultyName_Id');
                					   var studentField = form.down('#studentName_Id');
	                				   if(attendanceType == 'COURSE_LEVEL') {
	                					   var courseField = form.down('#courseId');
	                					   var courseVariantField = form.down('#courseVariantId');
	                					   courseField.reset();
	                					   courseVariantField.reset();
	                					   facultyField.reset();
	                					   studentField.reset();
	                					   courseVariantField.setDisabled(true);
	                					   var courseStore = courseField.getStore();
	                					   
	                					   var studentCoursesStore = courseField.getStore();
	        	                		   studentCoursesStore.getProxy().extraParams = {
	        	                			   academyLocationIds:academyLocationId,
	        	                			   academicTermId:academicTermId
	        	                		   };
	        	                		   studentCoursesStore.load();
	        	                		   
	        	                		   var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
	        	                		   var studentStore = studentField.getStore();
	        	                		   studentStore.getProxy().api.read=submitURL;
	        	                		   studentStore.getProxy().extraParams = {
	        	                			   academyLocationIds : academyLocationId,
	        	                			   academicTermId:academicTermId
	        	                		   };
	        	                		   studentStore.load();
	        	                		   
	        	                		   var submitURL=SERVERURL.PATH_GET_PARAMETERIZED_FACULTIES;
	        	                		   var facultyStore = facultyField.getStore();
	                					   facultyStore.getProxy().api.read=submitURL;
	                					   facultyStore.getProxy().extraParams = {
	        	                			   academyLocationIds : academyLocationId,
	        	                			   academicTermId:academicTermId
	        	                		   };
	                					   facultyStore.load();
	                					   
	                				   } else {
	                					   var programField = form.down('#programBatch_programId');
	                					   var batchField = form.down('#programBatch_batchId');
	                					   var periodField = form.down('#periodIdItemId');
	                					   var sectionField = form.down('#programCoursection_ID');
	                					   var programGroupField = form.down('#ProgramGroupItemId');
	                					   
	                					   programField.reset();
	                					   batchField.reset();
	                					   periodField.reset();
	                					   sectionField.reset();
	                					   studentField.reset();
	                					   facultyField.reset();
	                					   
	                					   batchField.setDisabled(true);
	                					   periodField.setDisabled(true);
	                					   sectionField.setDisabled(true);
	                					   
	                					   var programStore = programField.getStore();
	                					   var studentStore = studentField.getStore();
	                					   var facultyStore = facultyField.getStore();
	                					   
	                					   
	                					   programStore.getProxy().extraParams = {
	                						   academyLocationIds : academyLocationId,
	                						   academicTermId : academicTermId,
	                						   programGroupId : programGroupField.getValue()
	                					   }
	                					   programStore.load();
	                					   
	                					   var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
	                					   studentStore.getProxy().api.read=submitURL;
	                					   studentStore.getProxy().extraParams = {
	                						   academyLocationIds : academyLocationId,
	                						   academicTermId : academicTermId,
	                						   programGroupId : programGroupField.getValue()
	                					   }
	                					   studentStore.load();
	                					   
	                					   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
	                					   facultyStore.getProxy().api.read=submitURL;
	                					   facultyStore.getProxy().extraParams = {
	                						   academyLocationIds : academyLocationId,
	                						   academicTermId : academicTermId,
	                						   programGroupId : programGroupField.getValue()
	                					   }
	                					   facultyStore.load();
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch customcombobox[itemId=studentName_Id]': {
	                			   select: function(obj, record){
	                				   var this$ = this;
	                				   var form = this.getAttendancestudentsearch();
	                				   var attendanceType = form.down('#attendanceTypeRadio').getValue().attendanceTypeWise;
	                				   form.down('#studentStatusId').setValue(record[0].data.activeStatus);
	                				   var facultyField = form.down('#facultyName_Id');
	                				   if(attendanceType == 'COURSE_LEVEL') {
	                					   var courseField = form.down('#courseId');
	                					   var courseVariantField = form.down('#courseVariantId');
	                					   var academicTermField = form.down('#attendanceAcademicTerm');
	                					   facultyField.reset();
	                					   courseField.reset();
	                					   courseVariantField.reset();
	                					   courseVariantField.setDisabled(true);
	                					   var courseStore = courseField.getStore();
	                					   courseStore.getProxy().extraParams = {
	                						   academyLocationIds: this$.getCurrentAcademyLocation(),
	                						   isCurrentPeriod:false,
	                						   studentId:record[0].data.id,
	                						   academicTermId:academicTermField.getValue()
	                					   }
	                					   courseStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length==1){
	                									   courseField.setValue(records[0].data.courseId);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var submitURL=SERVERURL.PATH_GET_PARAMETERIZED_FACULTIES;
	        	                		   var facultyStore = facultyField.getStore();
	                					   facultyStore.getProxy().api.read=submitURL;
	                					   facultyStore.getProxy().extraParams = {
	        	                			   academyLocationIds : this$.getCurrentAcademyLocation(),
	        	                			   academicTermId:academicTermField.getValue()
	        	                		   };
	                					   facultyStore.load();
	                				   } else {
	                					   var programField = form.down('#programBatch_programId');
	                					   var batchField = form.down('#programBatch_batchId');
	                					   var periodField = form.down('#periodIdItemId');
	                					   var sectionField = form.down('#programCoursection_ID');
	                					   var academicTermField = form.down('#attendanceAcademicTerm');
	                					   var programGroupField = form.down('#ProgramGroupItemId');
	                					   programField.reset();
	                					   batchField.reset();
	                					   batchField.setDisabled(true);
	                					   periodField.reset();
	                					   periodField.setDisabled(true);
	                					   sectionField.reset();
	                					   sectionField.setDisabled(true);
	                					   facultyField.reset();
	                					   var programStore = programField.getStore();
	                					   programStore.getProxy().extraParams = {
	                						   academyLocationIds: this$.getCurrentAcademyLocation(),
	                						   studentId:record[0].data.id,
	                						   onlyCurrentRecords:false,
	                						   academicTermId:academicTermField.getValue(),
	                						   programGroupId:programGroupField.getValue()
	                					   }
	                					   programStore.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length==1){
	                									   programField.setValue(records[0].data.id);
	                								   }
	                							   }
	                						   }
	                					   });
	                					   var facultyStore = facultyField.getStore();
	                					   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
	                					   facultyStore.getProxy().api.read=submitURL;
	                					   facultyStore.getProxy().extraParams = {
	                						   academyLocationIds : this$.getCurrentAcademyLocation(),
	                						   academicTermId : academicTermField.getValue(),
	                						   programGroupId : programGroupField.getValue()
	                					   }
	                					   facultyStore.load();
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch combo#ProgramGroupItemId': {
	                			   select: function(obj, record) {
	                				   var this$ = this;
	                				   var programGroupId = obj.value;
	                				   var academyLocationId = this$.getCurrentAcademyLocation();
	                				   var form=this$.getAttendancestudentsearch();
	                				   var programField = form.down('#programBatch_programId');
                					   var batchField = form.down('#programBatch_batchId');
                					   var periodField = form.down('#periodIdItemId');
                					   var sectionField = form.down('#programCoursection_ID');
                					   var academicTermField = form.down('#attendanceAcademicTerm');
                					   var studentField = form.down('#studentName_Id');
                					   var facultyField = form.down('#facultyName_Id');
                					   
                					   programField.reset();
                					   batchField.reset();
                					   periodField.reset();
                					   sectionField.reset();
                					   facultyField.reset();
                					   
                					   batchField.setDisabled(true);
                					   periodField.setDisabled(true);
                					   sectionField.setDisabled(true);
                					   
                					   var programStore = programField.getStore();
                					   var facultyStore = facultyField.getStore();
                					   
                					   programStore.getProxy().extraParams = {
                						   academyLocationIds : academyLocationId,
                						   academicTermId : academicTermField.getValue(),
                						   programGroupId : programGroupId,
                						   studentId:studentField.getValue()
                					   }
                					   programStore.load({
                						   callback: function(records, operation, success) {
                							   if (success) {
                								   if(records.length==1){
                									   programField.setValue(records[0].data.id);
                								   }
                							   }
                						   }
                					   });
                					   
                					   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
                					   facultyStore.getProxy().api.read=submitURL;
                					   facultyStore.getProxy().extraParams = {
                						   academyLocationIds : academyLocationId,
                						   academicTermId : academicTermField.getValue(),
                						   programGroupId : programGroupId
                					   }
                					   facultyStore.load();
                					   
                					   this$.checkFormValidity(form);
	                			   }
	                			   
	                		   },
	                		   'attendancestudentsearch combo#programBatch_programId': {
	                			   change: function(obj, record) {
	                				   var this$ = this;
	                				   var programId = obj.value;
	                				   var acadmeyLocationId = this$.getCurrentAcademyLocation();
	                				   var form=this$.getAttendancestudentsearch();
                					   var batchField = form.down('#programBatch_batchId');
                					   var periodField = form.down('#periodIdItemId');
                					   var sectionField = form.down('#programCoursection_ID');
                					   var academicTermField = form.down('#attendanceAcademicTerm');
                					   var programGroupField = form.down('#ProgramGroupItemId');
                					   var studentField = form.down('#studentName_Id');
                					   var facultyField = form.down('#facultyName_Id');
                					   
                					   batchField.reset();
                					   periodField.reset();
                					   sectionField.reset();
                					   facultyField.reset();
                					   
                					   batchField.setDisabled(true);
                					   periodField.setDisabled(true);
                					   sectionField.setDisabled(true);
	                				   if(programId > 0){
	                					   var studentId = studentField.getValue();
	                					   batchField.setDisabled(false);
	                					   var store = batchField.getStore();
	                					   store.getProxy().extraParams = {
	                						   programId: programId,
	                						   onlyCurrentRecords:false,
	                						   studentId:studentId,
	                						   academicTermId:academicTermField.getValue(),
	                					   };
	                					   store.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length==1){
	                									   batchField.setValue(records[0].get('id'));
	                								   } else {
	                                					   var facultyStore = facultyField.getStore();
	                                					   
	                									   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
	            	                					   facultyStore.getProxy().api.read=submitURL;
	                                					   facultyStore.getProxy().extraParams = {
	                                						   academyLocationIds : academyLocationId,
	                                						   academicTermId : academicTermField.getValue(),
	                                						   programGroupId : programGroupField.getValue(),
	                                						   programId : programId
	                                					   }
	                                					   facultyStore.load();
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch combo#programBatch_batchId': {
	                			   change: function(obj, record) {
	                				   var this$ = this;
	                				   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                				   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                				   
	                				   var batchId = obj.value;
	                				   var acadmeyLocationId = this$.getCurrentAcademyLocation();
	                				   
	                				   var form=this$.getAttendancestudentsearch();
                					   var batchField = form.down('#programBatch_batchId');
                					   var periodField = form.down('#periodIdItemId');
                					   var sectionField = form.down('#programCoursection_ID');
                					   var academicTermField = form.down('#attendanceAcademicTerm');
                					   var programGroupField = form.down('#ProgramGroupItemId');
                					   var studentField = form.down('#studentName_Id');
                					   var facultyField = form.down('#facultyName_Id');
                					   
                					   periodField.reset();
                					   sectionField.reset();
                					   facultyField.reset();
                					   
                					   periodField.setDisabled(true);
                					   sectionField.setDisabled(true);
                					   
	                				   if(batchId > 0){
	                					   var studentId = studentField.getValue();
	                					   periodField.setDisabled(false);
	                					   var store = periodField.getStore();
	                					   store.getProxy().extraParams = {
	                						   batchId: batchId,
	                						   studentId:studentId,
	                						   onlyCurrentRecords:false,
	                						   academicTermId:academicTermField.getValue(),
	                					   };
	                					   store.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length==0){
	                									   if(wheatherSchool) {
	                										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	                									   } 
	                								   }
	                								   if(records.length==1){
	                									   periodField.setValue(records[0].get('id'))
	                								   } else {
	                									   var facultyStore = facultyField.getStore();
	                									   
	                									   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
	            	                					   facultyStore.getProxy().api.read=submitURL;
	                									   facultyStore.getProxy().extraParams = {
	                										   academyLocationIds : academyLocationId,
	                										   academicTermId : academicTermField.getValue(),
	                										   programGroupId : programGroupField.getValue(),
	                										   batchId : batchId
	                									   }
	                									   facultyStore.load();
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                			   
	                		   },
	                		   'attendancestudentsearch combo#periodIdItemId': {
	                			   change: function(obj, record) {
	                				   var this$ = this;
	                				   var periodId = obj.value;
	                				   var form=this$.getAttendancestudentsearch();
                					   var sectionField = form.down('#programCoursection_ID');
                					   var academicTermField = form.down('#attendanceAcademicTerm');
                					   var programGroupField = form.down('#ProgramGroupItemId');
                					   var studentField = form.down('#studentName_Id');
                					   var facultyField = form.down('#facultyName_Id');
                					   
                					   sectionField.reset();
                					   facultyField.reset();
                					   
                					   sectionField.setDisabled(true);
	                				   if(periodId > 0){
	                					   var studentId = studentField.getValue();
	                					   sectionField.setDisabled(false);
	                					   var store = sectionField.getStore();
	                					   store.getProxy().extraParams = {
	                						   periodId: periodId,
	                						   studentId:studentId,
	                						   onlyCurrentRecords:false
	                					   };
	                					   store.load({
	                						   callback: function(records, operation, success) {
	                							   if (success) {
	                								   if(records.length==1){
	                									   sectionField.setValue(records[0].data.id);
	                								   } else {
	                									   var facultyStore = facultyField.getStore();

	                									   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
	            	                					   facultyStore.getProxy().api.read=submitURL;
	                									   facultyStore.getProxy().extraParams = {
	                										   academyLocationIds : academyLocationId,
	                										   academicTermId : academicTermField.getValue(),
	                										   programGroupId : programGroupField.getValue(),
	                										   periodId : periodId
	                									   }
	                									   facultyStore.load();
	                								   }
	                							   }
	                						   }
	                					   });
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch combo#programCoursection_ID': {
	                			   change: function(obj, record) {
	                				   var this$ = this;
	                				   var sectionId = obj.value;
	                				   var form=this$.getAttendancestudentsearch();
                					   var academicTermField = form.down('#attendanceAcademicTerm');
                					   var programGroupField = form.down('#ProgramGroupItemId');
                					   var facultyField = form.down('#facultyName_Id');
                					   var facultyStore = facultyField.getStore();
                					   facultyField.reset();
	                				   if(sectionId > 0){
	                					   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
	                					   facultyStore.getProxy().api.read=submitURL;
    									   facultyStore.getProxy().extraParams = {
    										   academyLocationIds : academyLocationId,
    										   academicTermId : academicTermField.getValue(),
    										   programGroupId : programGroupField.getValue(),
    										   sectionId : sectionId
    									   }
    									   facultyStore.load();
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch combo#courseId': {
	                			   change: function(obj, record) {
	                				   var me = this;
			        				   var form = obj.up('form');
			        				   var courseId = obj.value;
	                				   if(courseId > 0) {
	                					   this.courseNprogramSection(courseId);
	                				   } else {
	                					   var courseSectionId = form.down('#courseVariantId');
	            	                	   courseSectionId.setDisabled(true);
	            	                	   courseSectionId.clearValue();
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch combo#courseVariantId': {
	                			   change: function(obj, record) {
	                				   var me = this;
			        				   var form = obj.up('form');
			        				   var facultyField = form.down('#facultyName_Id');
			        				   var academicTermField = form.down('#attendanceAcademicTerm')
			        				   var courseVariantId = obj.value;
	                				   if(courseVariantId > 0) {
	                					   var submitURL=SERVERURL.PATH_GET_PARAMETERIZED_FACULTIES;
	        	                		   var facultyStore = facultyField.getStore();
	                					   facultyStore.getProxy().api.read=submitURL;
	                					   facultyStore.getProxy().extraParams = {
	        	                			   academyLocationIds : me.getCurrentAcademyLocation(),
	        	                			   academicTermId:academicTermField.getValue(),
	        	                			   courseVariantId:courseVariantId
	        	                		   };
	                					   facultyStore.load();
	                				   }
	                				   this$.checkFormValidity(form);
	                			   }
	                		   },
	                		   'attendancestudentsearch radiogroup[itemId=attendanceTypeRadio]':{
	                			   change : function(obj,record){
	                				   this.attendanceTypeDropdown(); 
	                			   }
	                		   },
	                		   'attendancesearchstrucure':{
	                			   render:function(structure){
	                				   var portalId = this.getCurrentLoggedPortalId();
	                				   var permissionsMap = new Ext.util.HashMap();
	                				   if(portalId == 2) {
	                					   radioStruct.setVisible(false);
	                					   permissionsMap = this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION();
	                				   }else{
	                					   permissionsMap = this.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION();
	                				   }
	                				   var associatedAcadLocationIds = new Array();
	                				   associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                				   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                				   this.getSessionValues(permissionList);
	                			   }
	                		   },
	                		   'addedittopics button[itemId=cancelBtn]':{
	                			   click:function(){
	                				   this.getAddedittopics().close();  
	                			   }
	                		   } ,
	                		   'addedittopics button[itemId=submitBtn]':{
	                			   click:this.updateTopics
	                		   },
	                		   'attendancemainstructure treepanel[itemId=attendanceReportTreePanelItemId]':{
	                			   itemclick : this.getOpenAttendanceReportStructure
	                		   },
	                		   'attendanceforcomplatedaylist':{
	                			   afterrender : function(){
	                				   var grid = this.getAttendanceforcomplatedaylist();
	                				   this.doAccessControlValidation(grid, this.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
	                				   this.disableMoreActionAttendancePivileges(grid, this.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
									   var me = this;
										setTimeout(function(){
	    									me.addDataGridConfigButton(grid,me.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
										}, 1500);
	                			   }
	                		   },
	                		   'attendanceforcourselevellist':{
	                			   afterrender : function(){
	                				   var grid = this.getAttendanceforcourselevellist();
	                				   this.doAccessControlValidation(grid, this.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
	                				   this.disableMoreActionCourseAttendancePivileges(grid, this.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
									   var me = this;
										setTimeout(function(){
	    									me.addDataGridConfigButton(grid,me.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION());
										}, 1500);
	                			   }
	                		   },
	                		   'attendanceforcomplatedaylist button[itemId=btnDeleteAttendance]':{
	                			   click: this.deleteAttendanceRecord
	                		   },
	                		   'attendanceforcomplatedaylist button[itemId=btnEditAttendance]':{
	                			   click: this.openEditAttendanceWindow
	                		   },
	                		   'attendanceforcourselevellist button[itemId=deleteCourseAttendance]':{
	                			   click: this.deleteAttendanceRecord
	                		   },
	                		   'attendanceforcourselevellist button[itemId=editCourseAttendance]':{
	                			   click: this.openEditAttendanceWindow
	                		   },
	                		   'openattendancestatuswindow button[itemId=submitBtn]':{
	                			   click: this.bulkUpdateStudentAttendance
	                		   },
	                		   'openattendancestatuswindow button[itemId=cancelBtn]':{
	                			   click : function(){
	                				   this.getOpenattendancestatuswindow().close();
	                			   }
	                		   },
	                		   'tabpanel[itemId=tabpanelIds] tab':{
	                			   activate: function(){
	                				   var  contentPanelMain = this.getContentPanel().getActiveTab();
	                				   contentPanelMain.scrollBy(0,1);
	                				   contentPanelMain.scrollBy(0,-1);
	                			   }
	                		   }
	                	   });
	                   },
	                   attendanceTypeFilter:function(){
	                	   var $this = this;
	                	   var form = $this.getAttendancestudentsearch().getForm();
	                	   var attendancesearchstrucure =  $this.getAttendancesearchstrucure().getForm();
	                	   var attendancesearchstrucure =  this.getAttendancesearchstrucure().getForm();
	                	   var attendanceType = $this.getAttendancestudentsearch().down('#attendanceTypeRadio').getValue().attendanceTypeWise;
	                	   var attendanceMaster = $this.getAttendancemasterstrucure();
	                	   var newStructure =$this.getAttendancemainstructure();
	                	   if(attendanceType == 'COMPLETE_DAY' || attendanceType == 'Complete Day'){
	                		   var RESULT_GRID = $this.getAttendanceforcomplatedaylist();
	                		   var quickSearchForm = this.getAttendancesearchstrucure().down('attendancestudentsearch');
	                		   this.createJsonFormatForStudent(quickSearchForm,RESULT_GRID,RESULT_GRID.getStore());
	                		   //this.getGridHeaderFreeze(RESULT_GRID,newStructure,false);
	                		   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                		   if(wheatherSchool){
	                			   RESULT_GRID.columns[9].setVisible(false);
	                		   }	
	                		   RESULT_GRID.columns[8].setVisible(true);
	                		   attendanceMaster.down('#studentAttendanceGridId').setVisible(true);
	                		   attendanceMaster.down('#studentCourseLevelGridId').setVisible(false);
	                		   RESULT_GRID.columns[12].setVisible(true);
	                	   }else if(attendanceType == 'MULTIPLE_SESSION' || attendanceType == 'Multiple Session'){
	                		   var RESULT_GRID = $this.getAttendanceforcomplatedaylist();
	                		  //this.getGridHeaderFreeze(RESULT_GRID,newStructure,false);
	                		   var quickSearchForm = this.getAttendancesearchstrucure().down('attendancestudentsearch');
	                		   this.createJsonFormatForStudent(quickSearchForm,RESULT_GRID,RESULT_GRID.getStore());
	                		   attendanceMaster.down('#studentAttendanceGridId').setVisible(true);
	                		   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                		   if(wheatherSchool){
	                			   RESULT_GRID.columns[9].setVisible(false);
	                		   }	
	                		   RESULT_GRID.columns[8].setVisible(true);
	                		   RESULT_GRID.columns[12].setVisible(true);
	                		   attendanceMaster.down('#studentAttendanceGridId').setVisible(true);
	                		   attendanceMaster.down('#studentCourseLevelGridId').setVisible(false);
	                	   }else if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level'){
	                		   var RESULT_GRID = $this.getAttendanceforcourselevellist();
	                		   //this.getGridHeaderFreeze(RESULT_GRID,newStructure,false);
	                		   var quickSearchForm = this.getAttendancesearchstrucure().down('attendancestudentsearch');
	                		   this.createJsonFormatForStudent(quickSearchForm,RESULT_GRID,RESULT_GRID.getStore());
	                		   attendanceMaster.down('#studentAttendanceGridId').setVisible(false);
	                		   attendanceMaster.down('#studentCourseLevelGridId').setVisible(true);
	                	   }
	                   },
	                   attendanceTypeDropdown:function(){
	                	   var this$ =  this;
	                	   var form = this.getAttendancestudentsearch();
	                	   form.down('#studentStatusId').setValue(true);
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var  contentPanelMain = this.getContentPanel().getActiveTab();
	                	   contentPanelMain.scrollBy(0,1);
	                	   contentPanelMain.scrollBy(0,-1);
	                	   this$.getAttendanceforcomplatedaylist().getStore().removeAll();
	                	   this$.getAttendanceforcomplatedaylist().down('#custompagingtoolbar').setVisible(false);
 						   this$.getAttendanceforcourselevellist().getStore().removeAll();
						   this$.getAttendanceforcourselevellist().down('#custompagingtoolbar').setVisible(false);
	                	   var attendancesearchstrucure =  this.getAttendancesearchstrucure().getForm();
	                	   var attendanceTypeRadio=form.down('#attendanceTypeRadio').getValue();
	                	   var attendanceType = attendanceTypeRadio.attendanceTypeWise;
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var facultyId = this.getCurrentlyLoggedInUser();
	                	   var sessionNumber = "";
	                	   Ext.Ajax.request({
	                		   type : 'rest',
	                		   async: false,
	                		   url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
	                		   params : {
	                			   academyLocatonId : academyLocationId,
	                			   attendanceType:attendanceType
	                		   },
	                		   method : 'GET',
	                		   success : function(f, action) {
	                			   if(isNullOrEmpty(f.responseText))
	                			   {
	                				   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
	                			   }else{
	                				   var res = Ext.JSON.decode(f.responseText);
	                				   var data=res[0];
	                				   attendanceType = data.studentAttendanceType;
	                				   facultyAttendanceType = data.facultyAttendanceType;
	                				   sessionNumber = data.sessionNo;
	                				   attendancesearchstrucure.findField('attendanceType').setValue(data.studentAttendanceType);
	                				   attendancesearchstrucure.findField('noOfBackDays').setValue(data.backDateAllowed);
	                				   attendancesearchstrucure.findField('sessionPlanningFlag').setValue(data.timeTablePlanningFlag);
	                				   attendancesearchstrucure.findField('startDate').setValue(data.startDate);
	                				   attendancesearchstrucure.findField('endDate').setValue(data.endDate);

	                			   }
	                		   }
	                	   });
	                	   form.down('#attendanceAcademicTerm').reset();
	                	   if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
	                		   form.down('#ProgramGroupItemId').setVisible(false);
	                		   form.down('#ProgramGroupItemId').reset();
	                		   form.down("#programBatch_programId").setVisible(false);
	                		   form.down("#programBatch_programId").reset();
	                		   //this$.setAllowBlank(form.down("#programBatch_programId"), true);
	                		   form.down("#programBatch_batchId").setVisible(false);
	                		   form.down("#programBatch_batchId").reset();
	                		   //this$.setAllowBlank(form.down("#programBatch_batchId"), true);
	                		   form.down("#periodIdItemId").reset();
	                		   form.down("#programCoursection_ID").reset();
	                		   form.down("#programCoursection_ID").setVisible(false);
	                		   form.down("#studentName_Id").reset();
	                		   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                		   if(wheatherSchool){
	                			   form.down("#periodIdItemId").hide();
	                			   this$.setAllowBlank(form.down("#periodIdItemId"), true);
	                		   }else{
	                			   form.down("#periodIdItemId").setVisible(false);
	                			   //this$.setAllowBlank(form.down("#periodIdItemId"), false);
	                		   }
	                		   form.down('#moreDetailId').setVisible(true);
	                		   form.down('#sessionNumberItemId').setVisible(false);
	                		   form.down('#sessionNumberItemId1').setVisible(false);
	                		   form.down("#sessionNumberItemId1").reset();

	                		   var academicTermField = form.down("#attendanceAcademicTerm");
	                		   var academicTermStore = academicTermField.getStore();
	                		   var academicTermId = 0;
	                		   academicTermStore.getProxy().extraParams = {	
	                			   academyLocationIds:academyLocationId
	                		   };
	                		   academicTermStore.load({
	                			   callback: function(records, operation, success) {
		                			   if (success) {
		                				   for(var i in records) {
		                					   if(records[i].data.sequence == 1) {
		                						   academicTermId = records[i].data.id;
		                						   academicTermField.setValue(academicTermId);
		                					   }
		                				   }
		                				   if(academicTermId == 0) {
		                					   var studentCoursesStore = form.down("#courseId").getStore();
		        	                		   studentCoursesStore.getProxy().extraParams = {
		        	                			   academyLocationIds:academyLocationId				
		        	                		   };
		        	                		   studentCoursesStore.load();
		        	                		   
		        	                		   var submitURL=SERVERURL.GET_STUDENT_IN_FACULTY_PARAM_COURSES;
		        	                		   var studentStore = form.down("#studentName_Id").getStore();
		        	                		   studentStore.getProxy().api.read=submitURL;
		        	                		   studentStore.getProxy().extraParams = {
		        	                			   academyLocationIds : academyLocationId,
		        	                		   };
		        	                		   studentStore.load();
		        	                		   
		        	                		   var submitURL=SERVERURL.PATH_GET_PARAMETERIZED_FACULTIES;
		        	                		   var facultyStore = form.down("#facultyName_Id").getStore();
		                					   facultyStore.getProxy().api.read=submitURL;
		                					   facultyStore.getProxy().extraParams = {
		        	                			   academyLocationIds : academyLocationId,
		        	                		   };
		                					   facultyStore.load();
		                				   }
		                			   }
	                			   }
	                		   });

	                		   form.down("#courseId").setVisible(true);
	                		   form.down("#courseVariantId").setVisible(true);
	                		   form.down("#courseVariantId").setDisabled(true);
	                		   form.down("#timeContainer").setVisible(true);
	                		   form.down("#facultyAttendanceStatus").setVisible(false);
	                		   form.down("#attendanceStatus").setVisible(true);
	                		   form.down("#absentForLast").setFieldLabel(getProgramandcourseTranslation('ABSENT_FOR_SESSION'));
	                		   form.isValid();
	                	   }
	                	   else if(attendanceType == 'MULTIPLE_SESSION' || attendanceType == 'Multiple Session'){
	                		   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		   var wheatherSchool = alinfomodel.get('wheatherSchool');

	                		   form.down('#ProgramGroupItemId').reset();
	                		   form.down('#ProgramGroupItemId').setVisible(true);
	                		   form.down("#programBatch_programId").reset();
	                		   //this$.setAllowBlank(form.down("#programBatch_programId"), false);
	                		   form.down("#programBatch_programId").setVisible(true);
	                		   form.down("#programBatch_batchId").reset();
	                		   //this$.setAllowBlank(form.down("#programBatch_batchId"), false);
	                		   form.down("#programBatch_batchId").setDisabled(true);
	                		   form.down("#programBatch_batchId").setVisible(true);
	                		   form.down("#programCoursection_ID").reset();
	                		   form.down("#programCoursection_ID").setDisabled(true);
	                		   form.down("#programCoursection_ID").setVisible(true);
	                		   form.down("#studentName_Id").reset();

	                		   if(wheatherSchool){
	                			   form.down("#periodIdItemId").hide();
	                			   this$.setAllowBlank(form.down("#periodIdItemId"), true);
	                			   form.down('#sessionNumberItemId').setVisible(true); 
	                			   form.down('#sessionNumberItemId1').setVisible(false);
	                		   }else{
	                			   form.down("#periodIdItemId").setVisible(true);
	                			   //this$.setAllowBlank(form.down("#periodIdItemId"), false);
	                			   form.down('#sessionNumberItemId1').setVisible(true);
	                			   form.down('#sessionNumberItemId').setVisible(false); 
	                		   }

	                		   form.down('#moreDetailId').setVisible(true);

	                		   form.down("#courseId").setVisible(false);
	                		   form.down("#courseId").reset();
	                		   form.down("#courseVariantId").setVisible(false);
	                		   form.down("#courseVariantId").reset();
	                		   form.down("#timeContainer").setVisible(false);
	                		   form.down("#attendanceStatus").setVisible(true);
	                		   form.down("#facultyAttendanceStatus").setVisible(false);
	                		   var storeArray = [];

	                		   var multipleSessionStore = this.getStore('attendance.MultipleSessionValueStore');
	                		   multipleSessionStore.getProxy().extraParams = {
	                			   type:"multipleSession"
	                		   };
	                		   multipleSessionStore.load({
	                			   callback: function(records, operation, success) {
	                				   if (success) {
	                					   for (s=1;s<=sessionNumber;s++) {
	                						   if(multipleSessionStore.find("code",s)>=0){
	                							   storeArray.push({
	                								   'val':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('value'),
	                								   'code':multipleSessionStore.getAt(multipleSessionStore.find("code",s)).get('code')
	                							   });
	                						   } else {
	                							   storeArray.push({'val':s,
	                								   'code': s});
	                						   }
	                					   }
	                				   }
	                				   var store1 = Ext.create('Ext.data.Store', {
	                					   fields: ['val','code'],
	                					   data : storeArray
	                				   });
	                				   if(wheatherSchool){
	                					   var l = Ext.ComponentQuery.query('[itemId=sessionNumberItemId]').length-1;
	                					   Ext.ComponentQuery.query('[itemId=sessionNumberItemId]')[l].bindStore(store1);
	                					   if(storeArray.length>0)
	                					   {
	                						   Ext.ComponentQuery.query('[itemId=sessionNumberItemId]')[l].setValue(1);
	                					   }
	                				   }else{
	                					   if(portalId == 2) {
	                						   var l = Ext.ComponentQuery.query('[itemId=sessionNumberItemId]').length-1;
	                						   Ext.ComponentQuery.query('[itemId=sessionNumberItemId]')[l].bindStore(store1);
	                						   if(storeArray.length>0)
	                						   {
	                							   Ext.ComponentQuery.query('[itemId=sessionNumberItemId]')[l].setValue(1);
	                						   }
	                					   }else{
	                						   var l = Ext.ComponentQuery.query('[itemId=sessionNumberItemId1]').length-1;
	                						   Ext.ComponentQuery.query('[itemId=sessionNumberItemId1]')[l].bindStore(store1);
	                						   if(storeArray.length>0)
	                						   {
	                							   Ext.ComponentQuery.query('[itemId=sessionNumberItemId1]')[l].setValue(1);
	                						   }
	                					   }
	                				   }	 
	                			   }
	                		   });
	                		   var academicTermField = form.down("#attendanceAcademicTerm");
	                		   var academicTermStore = academicTermField.getStore();
	                		   var academicTermId = 0;
	                		   form.isValid();
	                		   academicTermStore.getProxy().extraParams = {	
	                			   academyLocationIds:academyLocationId
	                		   };
	                		   academicTermStore.load({
	                			   callback: function(records, operation, success) {
		                			   if (success) {
		                				   for(var i in records) {
		                					   if(records[i].data.sequence == 1) {
		                						   academicTermId = records[i].data.id;
		                						   academicTermField.setValue(academicTermId);
		                					   }
		                				   }
		                				   if(academicTermId == 0) {
		                					   var programByAcademyLocationStore = form.down("#programBatch_programId").getStore();
		        	                		   programByAcademyLocationStore.getProxy().extraParams = {	
		        	                			   academyLocationIds:academyLocationId
		        	                		   };
		        	                		   programByAcademyLocationStore.load();
		        	                		   
		        	                		   var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
		        	                		   var studentStore = form.down("#studentName_Id").getStore();
		        	                		   studentStore.getProxy().api.read=submitURL;
		        	                		   studentStore.getProxy().extraParams = {
		        	                			   academyLocationIds : academyLocationId,
		        	                		   };
		        	                		   studentStore.load();
		        	                		   
		        	                		   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
		        	                		   var facultyStore = form.down("#facultyName_Id").getStore();
		                					   facultyStore.getProxy().api.read=submitURL;
		                					   facultyStore.getProxy().extraParams = {
		        	                			   academyLocationIds : academyLocationId,
		        	                		   };
		                					   facultyStore.load();
		                				   }
		                			   }
	                			   }
	                		   });

	                	   } else {
	                		   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                		   var wheatherSchool = alinfomodel.get('wheatherSchool');

	                		   form.down('#ProgramGroupItemId').reset();
	                		   form.down('#ProgramGroupItemId').setVisible(true);
	                		   form.down("#programBatch_programId").reset();
	                		   form.down("#programBatch_programId").setVisible(true);
	                		   form.down("#programBatch_batchId").reset();
	                		   //this$.setAllowBlank(form.down("#programBatch_programId"), false);
	                		   form.down("#programBatch_batchId").setDisabled(true);
	                		   form.down("#programBatch_batchId").setVisible(true);
	                		   //this$.setAllowBlank(form.down("#programBatch_batchId"), false);
	                		   form.down("#programCoursection_ID").reset();
	                		   form.down("#programCoursection_ID").setDisabled(true);
	                		   form.down("#programCoursection_ID").setVisible(true);
	                		   form.down("#studentName_Id").reset();

	                		   form.down('#sessionNumberItemId').setVisible(false);
	                		   form.down('#sessionNumberItemId').reset();
	                		   form.down('#sessionNumberItemId1').setVisible(false);
	                		   form.down('#sessionNumberItemId1').reset();
	                		   if(wheatherSchool){
	                			   form.down("#periodIdItemId").hide();
	                			   this$.setAllowBlank(form.down("#periodIdItemId"), true);
	                		   }else{
	                			   form.down("#periodIdItemId").setVisible(true);
	                			   //this$.setAllowBlank(form.down("#periodIdItemId"), false);
	                		   }
	                		   form.down("#periodIdItemId").setDisabled(true);

	                		   form.down('#moreDetailId').setVisible(true);
	                		   form.down("#courseId").setVisible(false);
	                		   form.down("#courseId").reset();
	                		   form.down("#courseVariantId").setVisible(false);
	                		   form.down("#courseVariantId").reset();
	                		   form.down("#timeContainer").setVisible(false);
	                		   form.down("#attendanceStatus").setVisible(true);
	                		   form.down("#facultyAttendanceStatus").setVisible(false);
	                		   
	                		   var academicTermField = form.down("#attendanceAcademicTerm");
	                		   var academicTermStore = academicTermField.getStore();
	                		   var academicTermId = 0;
	                		   form.isValid();
	                		   academicTermStore.getProxy().extraParams = {	
	                			   academyLocationIds:academyLocationId
	                		   };
	                		   academicTermStore.load({
	                			   callback: function(records, operation, success) {
		                			   if (success) {
		                				   for(var i in records) {
		                					   if(records[i].data.sequence == 1) {
		                						   academicTermId = records[i].data.id;
		                						   academicTermField.setValue(academicTermId);
		                					   }
		                				   }
		                				   if(academicTermId == 0) {
		                					   var programByAcademyLocationStore = form.down("#programBatch_programId").getStore();
		        	                		   programByAcademyLocationStore.getProxy().extraParams = {	
		        	                			   academyLocationIds:academyLocationId
		        	                		   };
		        	                		   programByAcademyLocationStore.load();
		        	                		   
		        	                		   var submitURL=SERVERURL.PATH_FIND_ACTIVE_STUDENTS_IN_FACULTY_PROGRAMS;
		        	                		   var studentStore = form.down("#studentName_Id").getStore();
		        	                		   studentStore.getProxy().api.read=submitURL;
		        	                		   studentStore.getProxy().extraParams = {
		        	                			   academyLocationIds : academyLocationId,
		        	                		   };
		        	                		   studentStore.load();
		        	                		   
		        	                		   var submitURL=SERVERURL.PATH_GET_PBS_SECTION_CLASS_TEACHER;
		        	                		   var facultyStore = form.down("#facultyName_Id").getStore();
		                					   facultyStore.getProxy().api.read=submitURL;
		                					   facultyStore.getProxy().extraParams = {
		        	                			   academyLocationIds : academyLocationId,
		        	                		   };
		                					   facultyStore.load();
		                				   }
		                			   }
	                			   }
	                		   });
	                	   }
	                	   this.checkFormValidity(form);
	                   },
	                   courseNprogramSection:function(record){
	                	   var form = this.getAttendancestudentsearch();
	                	   var academyLocationId = this.getCurrentAcademyLocation();
	                	   var this$ = this;
	                	   var courseId = record;
	                	   var courseSectionId = form.down('#courseVariantId');
	                	   var studentId = form.down('#studentName_Id').getValue();
	                	   var facultyField = form.down('#facultyName_Id');
	                	   var academicTermField = form.down('#attendanceAcademicTerm');
	                	   courseSectionId.setVisible(true);
	                	   courseSectionId.setDisabled(false);
	                	   courseSectionId.clearValue();

	                	   var store = courseSectionId.getStore();
	                	   store.getProxy().extraParams = {
	                		   courseId: courseId,
	                		   studentId:studentId,
	                		   academyLocationIds:academyLocationId,
	                		   academicTermId:academicTermField.getValue(),
	                	   };
	                	   store.load({
	                		   callback: function(records, operation, success) {
	                			   if (success) {
	                				   if(records.length==1){
	                					   courseSectionId.setValue(records[0].get('id'));
	                				   } else {
	                					   var submitURL=SERVERURL.PATH_GET_PARAMETERIZED_FACULTIES;
	        	                		   var facultyStore = facultyField.getStore();
	                					   facultyStore.getProxy().api.read=submitURL;
	                					   facultyStore.getProxy().extraParams = {
	        	                			   academyLocationIds : academyLocationId,
	        	                			   academicTermId:academicTermField.getValue(),
	        	                			   courseId:courseId
	        	                		   };
	                					   facultyStore.load();
	                				   }
	                			   }
	                		   }	   
	                	   });
	                   },
	                   getJsonObject: function(key, value, additionalValue) {
	                	   if (value != '' && value != null && additionalValue == undefined) {
	                		   return {
	                			   "paramCode": key,
	                			   "paramValues": [value]
	                		   };
	                	   } else if (value != '' && additionalValue != undefined) {
	                		   return {
	                			   "paramCode": key,
	                			   "paramValues": [value, additionalValue]
	                		   };
	                	   }
	                   },
	                   pushJsonObjectInArray: function(object, array) {
	                	   if (object) {
	                		   array.push(object);
	                	   }
	                   },
	                   resetSearchFilter:function(){
	                	   
	                		   var form=this.getAttendancestudentsearch();
	                		   var startDateField = form.down('#startDate');
	                		   var endDateField = form.down('#endDate');
	                		   form.down('#attendanceAcademicTerm').reset();
	                		   form.down('#attendanceAcademicTerm').reset();
	                		   form.down('#studentName_Id').reset();
	                		   form.down('#studentStatusId').reset();
	                		   //form.down('#programBatch_Id').reset();
	                		   form.down('#ProgramGroupItemId').reset();
	                		   form.down('#programBatch_programId').reset();
	                		   form.down('#programBatch_batchId').reset();
	                		   form.down('#courseId').reset();
	                		   form.down('#courseVariantId').reset();
	                		   form.down('#periodIdItemId').reset();
	                		   form.down('#programCoursection_ID').reset();
	                		   form.down('#facultyName_Id').reset();
	                		   form.down('#fromTime').reset();
	                		   
	                		   form.down('#toTime').reset();
	                		   form.down('#sessionNumberItemId').reset();
	                		   form.down('#sessionNumberItemId1').reset();
	                		   form.down('#facultyAttendanceStatus').reset();
	                		   
	                		   form.down('#timeSlotListId').reset();
	                		   form.down('#startDate').reset();
	                		   form.down('#endDate').reset();
	                		   form.down('#studentAttendanceGroup').reset();
	                		   form.down('#attendanceStatus').reset();
	                		   form.down('#absentForLast').reset();
	                		   
	                		   startDateField.setMinValue(false);
	                		   startDateField.setMaxValue(new Date());
	                		   endDateField.setMinValue(false);
	                		   endDateField.setMaxValue(new Date());
	                		   var courseSectionId=form.down('#courseVariantId');
	                		   courseSectionId.setDisabled(true);
	                		  
	                		 /* Ext.ComponentQuery.query('attendancesearchstrucure')[0].destroy();
	                		   if(Ext.isDefined(Ext.ComponentQuery.query('attendancemasterstrucure')[0])){
	                			   Ext.ComponentQuery.query('attendancemasterstrucure')[0].insert(0,{xtype : 'attendancesearchstrucure'});
	                		   }*/
	                	   
	                   },
	                   getSessionValues:function(permissionList){
	                	   var $this = this;
	                	   var academyLocationId = this.getCurrentAcademyLocation();
//	                	   var form = this.getStudentattendance().getForm();
//	                	   var form = this.getAttendancestudentsearch().getForm();
	                	   var form = this.getAttendancesearchstrucure().getForm();
	                	   var studentForm=this.getAttendancestudentsearch();
	                	   var attendanceTypeRadio=studentForm.down('#attendanceTypeRadio');
	                	   var attendanceType=[];
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   Ext.Ajax.request({
	                		   type : 'rest',
	                		   url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
	                		   params : {
	                			   academyLocatonId : academyLocationId,
	                			   portalId : portalId
	                		   },
	                		   method : 'GET',
	                		   success : function(f, action) {
	                			   if(isNullOrEmpty(f.responseText))
	                			   {
	                				   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));
	                				   $this.getAttendancestudentsearch().down("#searchBtn").setDisabled(true);
	                				   var attendanceMaster = $this.getAttendancemasterstrucure();

	                				   attendanceMaster.down('#studentAttendanceGridId').down("#searchResultGridBtnAdd").setDisabled(true);
	                				   attendanceMaster.down('#studentMultiSessionGridId').down("#searchResultGridBtnAdd").setDisabled(true);
	                				   attendanceMaster.down('#facultyDayWiseGridId').down("#searchResultGridBtnAdd").setDisabled(true);
	                				   attendanceMaster.down('#facultyMultiSessionGridId').down("#searchResultGridBtnAdd").setDisabled(true);
	                				   attendanceMaster.down('#facultyCourseLevelGridId').down("#searchResultGridBtnAdd").setDisabled(true);
	                				   attendanceMaster.down('#studentCourseLevelGridId').down("#searchResultGridBtnAdd").setDisabled(true);
	                			   }else{
	                				   var res = Ext.JSON.decode(f.responseText);
	                				   Ext.each(res, function(data) {
	                					   attendanceType.push(data.studentAttendanceType);
	                				   });

	                				   //--setting initial values to false
	                				   var tab2=false, tab3=false,tab4=false;

	                				   //--initially setting all radio fields to true
	                				   var completeDayRadio = studentForm.down('[inputValue=COMPLETE_DAY]');
	                				   var courseLevelRadio = studentForm.down('[inputValue=COURSE_LEVEL]');
	                				   var multipleSessionRadio = studentForm.down('[inputValue=MULTIPLE_SESSION]');
	                				   attendanceTypeRadio.items.items[0].setVisible(true);
	                				   attendanceTypeRadio.items.items[1].setVisible(true);
	                				   attendanceTypeRadio.items.items[2].setVisible(true);

	                				   //--checking for the visible tabs
	                				   if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
	                					   tab2=true;
	                				   }
	                				   if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
	                					   tab3=true;
	                				   }
	                				   if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
	                					   tab4=true;
	                				   }

	                				   if(!tab2 && !tab3 && !tab4){
	                					   tab2=true;
	                				   }

	                				   if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
	                					   attendanceTypeRadio.setVisible(false);
	                				   }
	                				   else {
	                					   attendanceTypeRadio.setVisible(true);
	                				   }

	                				   //-- setting values to true/false on the basis of visible tabs
	                				   if(!tab2){
	                					   attendanceTypeRadio.items.items[0].setVisible(false);
	                				   }
	                				   if(!tab3){
	                					   attendanceTypeRadio.items.items[1].setVisible(false);
	                				   }
	                				   if(!tab4){
	                					   attendanceTypeRadio.items.items[2].setVisible(false);
	                				   }

	                				   //-- setting radioGroup value on the basis of visible tabs
	                				   setTimeout(function(){
	                					   if(tab2){
	                						   completeDayRadio.setValue(true);
	                					   }
	                					   else if(tab3){
	                						   courseLevelRadio.setValue(true);
	                					   }
	                					   else if(tab4){
	                						   multipleSessionRadio.setValue(true);
	                					   }
	                				   },1000);


	                			   }
	                		   }
	                	   });
	                   },
	                   createJsonFormatForStudent : function(quickSearchForm,grid,store){
	                	   var $this = this;
	                	   quickSearchForm.down('#searchBtn').setDisabled(true);
	                	   var form =  quickSearchForm.getForm();
	                	   var values = form.getValues();
	                	   grid.getSelectionModel().deselectAll(true);
	                	   var sectionId = values.sectionId;
	                	   var portalId = this.getCurrentLoggedPortalId();
	                	   var facultyId = values.facultyName;
	                	   var section;
	                	   if(sectionId != null && sectionId != ''){
	                		   section = sectionId;
	                	   }
	                	   var alinfomodel = Academia.model.authentication.ALInfoModel;
	                	   var wheatherSchool = alinfomodel.get('wheatherSchool');
	                	   if(wheatherSchool){
	                		   var sessionNo=values.sessionNumber 
	                	   }	else{
	                		   if(portalId == 2) {
	                			   var sessionNo=values.sessionNumber 
	                		   }else{
	                			   var sessionNo=values.sessionNumber1 
	                		   }
	                	   }
	                	   if(portalId == 2) {
	                		   facultyId=this.getCurrentlyLoggedInUser().id;
	                		   if(grid.itemId == "studentAttendanceGridId"){
	                			   grid.columns[8].setVisible(false);
	                		   }
	                		   if(grid.itemId == "studentCourseLevelGridId"){
	                			   grid.columns[12].setVisible(false);
	                		   }
	                	   }
	                	   var attendanceGroupId = values.studentAttendanceGroup;
	                	   store.getProxy().extraParams={
	                		   programId : values.programId,
	                		   batchId : values.batchId,
	                		   periodId : values.periodId,
	                		   sectionId : section,
	                		   startDate : values.startDate,
	                		   endDate : values.endDate,
	                		   attendanceStatus : values.attendanceStatus,
	                		   courseId : values.courseId,
	                		   courseVariantId : values.courseVariant,
	                		   startTime : values.fromTime,
	                		   endTime : values.toTime,
	                		   absentForLast : values.absentForLast,
	                		   facultyId:facultyId,
	                		   sessionNo : sessionNo,
	                		   studentID : values.studentName,
	                		   studentId : values.studentName,
	                		   attendanceType:values.attendanceTypeWise,
	                		   attendanceGroupId : attendanceGroupId,
	                		   programGroupId: values.programGroup,
	                		   activeStatus: values.studentStatus,
	                		   academicTermId:values.attendanceAcademicTerm
	                	   }

	                	   var param = store.getProxy().extraParams;

	                	   if(!isNullOrEmpty(values.absentForLast)){
	                		   param.attendanceStatus='2'
	                	   }
	                	   this.resetPageSetting(store);
	                	   store.load({
    						   callback: function(records, operation, success) {
    							   if (success) {
    								   quickSearchForm.down('#searchBtn').setDisabled(false);  
    							   }
    						   }
    					   });
	                	   grid.config.searchFilterForm =  quickSearchForm;
	                   },
	                   getOpenAttendanceReportStructure : function(treePanel, record, item,index, e, eOpts){
	                	   var $this = this;
	                	   var containpanel = $this.getAttendancemainstructure();
	                	   var treePanel = containpanel.down('#attendanceReportTreePanelItemId');
	                	   var tabDetail = record.data;
	                	   var structure = Ext.widget(tabDetail.reportXtype);
	                	   var tabstructure = containpanel.down('#tabpanelIds');

	                	   if (!isNullOrEmpty(tabDetail.text)
	                			   && !isNullOrEmpty(tabDetail.reportXtype)
	                			   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
	                		   treePanel.toggleCollapse();
	                		   openTab(tabstructure, tabDetail.text,structure);
	                		   treePanel.getSelectionModel().deselectAll();
	                	   }
	                   },
	                   openEditAttendanceWindow : function(windowName){
	                	   var this$ = this;
	                	   var attendancesearchstrucure =  this$.getAttendancesearchstrucure().getForm();
	                	   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	                	   var attendanceGrid =  this$.getAttendanceforcomplatedaylist();
	                	   if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level') {
	                		   attendanceGrid = this$.getAttendanceforcourselevellist();
	                	   }
	                	   if(attendanceGrid.getSelectionModel().getCount()>0){
	                		   var studentCount = attendanceGrid.getSelectionModel().getCount();
	                		   var frmWin = this.getOpenattendancestatuswindow();
	                		   if (!frmWin) {
	                			   Ext.widget('openattendancestatuswindow');
	                			   frmWin = this.getOpenattendancestatuswindow();
	                		   }
	                		   frmWin.show();
	                		   frmWin.down('form').getForm().findField('StudentCount').setValue(studentCount);
	                		   var permissionMap = '';
	                		   if (this$.getCurrentLoggedPortalId() == 2) {
	                			   permissionMap = this.getFACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PERMISSION();
	                		   } else {
	                			   permissionMap = this.getSTUDENT_WISE_ATTENDANCE_REPORT_PERMISSION()
	                		   }
	                		   var associatedAcadLocationIds = new Array();
	                		   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	                		   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
	                		   var attendanceStatus = frmWin.down('#attendanceStatus');
	                		   var attendanceStatusStore = attendanceStatus.getStore().load({
	                			   callback : function(records, operation, success) {
	                				   if (success) {
	                					   if(records.length > 0){
	                						   attendanceStatus.setValue(records[0].data.id);
	                						   var presentPermission = true;
	                						   var absentPermission = true;
	                						   var leavePermission = true;
	                						   Ext.each(permissionList, function(privilege) {
	                							   if (privilege === 'PRESENT') {
	                								   presentPermission = false;		
	                							   }
	                							   if(privilege === 'ABSENT') {
	                								   absentPermission = false;
	                							   }
	                							   if(privilege === 'LEAVE') {
	                								   leavePermission = false;
	                							   }
	                						   });
	                						   if(presentPermission) {
	                							   attendanceStatusStore.removeAt(attendanceStatusStore.find('id', '1'));
	                						   }
	                						   if(absentPermission) {
	                							   attendanceStatusStore.removeAt(attendanceStatusStore.find('id', '2'));
	                						   }
	                						   if(leavePermission) {
	                							   attendanceStatusStore.removeAt(attendanceStatusStore.find('id', '3'));
	                						   }
	                						   attendanceStatus.bindStore(attendanceStatusStore);
	                					   }
	                				   }
	                			   }
	                		   });
	                	   } else {
	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
	                	   }
	                   },
	                   bulkUpdateStudentAttendance : function(){
	                	   var this$ = this;
	                	   var attendancesearchstrucure =  this$.getAttendancesearchstrucure().getForm();
	                	   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	                	   var startDate = attendancesearchstrucure.findField('startDate').getValue();
	                	   var endDate = attendancesearchstrucure.findField('endDate').getValue();
	                	   var noOfBackDays =  attendancesearchstrucure.findField('noOfBackDays').getValue();
	                	   var frmWin = this$.getOpenattendancestatuswindow();
	                	   var grid = this$.getAttendanceforcomplatedaylist();
	                	   if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level') {
	                		   grid = this$.getAttendanceforcourselevellist();
	                	   }
	                	   var gridRecord = grid.getSelectionModel().getSelection();
	                	   var values =  frmWin.down('form').getValues();
	                	   var status = frmWin.down('form').down('#attendanceStatus').getRawValue();
	                	   var ids=[];
	                	   var notValid = true;
	                	   var studentAttendance =new Academia.model.attendance.UpdateAttendanceModel();
	                	   studentAttendance.set("attendanceMarkingTypeId",values.attendanceStatus);
	                	   studentAttendance.set("attendanceType",attendanceType);
	                	   Ext.Array.each(gridRecord, function(record, index) {
	                		   if(record.data.dateOfAttendance>=startDate && record.data.dateOfAttendance <= endDate) { 
	                			   ids.push(record.data.id);
	                		   } else {
	                			   notValid = false;
	                		   }
	                	   });
	                	   studentAttendance.set("attendanceids",ids);
	                	   studentAttendance.set("comment",values.commentArea);
	                	   studentAttendance.set("portalId",this$.getCurrentLoggedPortalId());
	                	   delete studentAttendance.data.attendanceStatus;
	                	   var formData = Ext.encode(studentAttendance.data);
	                	   if(!notValid) {
	                		   showConfirmMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getProgramandcourseTranslation('BACK_DATE_ALLOWED_MSG')+noOfBackDays+getProgramandcourseTranslation('DAYS'), function(btn, text) {
                      			 if (btn == 'yes') {
                      				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                      				Ext.Ajax.request({
     		                		   type: 'rest',
     		                		   url: SERVERURL.UPDATE_ATTENDANCE_STATUS,
     		                		   jsonData : formData,
     		                		   method : 'POST',
     		                		   timeout:300000,
     		                		   success: function(f, action) {
     		                			   Ext.getBody().unmask();
     		                			   var data = f.responseText;
     		                			   if(data == "SUCCESS")
     		                				   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
     		                			   grid.getStore().reload();
     		                			   grid.getSelectionModel().deselectAll();
     		                			   frmWin.close();
     		                		   },
     		                		   failure: function(result, request) {
     		                			   showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG'));
     		                			   return false;
     		                		   }
     		                	   });
                      			 }
                      			 });
	                	   } else {
	                		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                		   Ext.Ajax.request({
		                		   type: 'rest',
		                		   url: SERVERURL.UPDATE_ATTENDANCE_STATUS,
		                		   jsonData : formData,
		                		   method : 'POST',
		                		   timeout:300000,
		                		   success: function(f, action) {
		                			   Ext.getBody().unmask();
		                			   var data = f.responseText;
		                			   if(data == "SUCCESS")
		                				   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
		                			   grid.getStore().reload();
		                			   grid.getSelectionModel().deselectAll();
		                			   frmWin.close();
		                		   },
		                		   failure: function(result, request) {
		                			   showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
		                			   return false;
		                		   }
		                	   });
	                	   }
	                   },
	                   deleteAttendanceRecord : function() {
	                	   var this$ = this;
	                	   var attendancesearchstrucure =  this$.getAttendancesearchstrucure().getForm();
	                	   var attendanceType = attendancesearchstrucure.findField('attendanceType').getValue();
	                	   var frmWin = this$.getOpenattendancestatuswindow();
	                	   var grid = this$.getAttendanceforcomplatedaylist();
	                	   var submitUrl = SERVERURL.DELETE_STUDENT_ATTENDANCE_DETAILS;
	                	   if(attendanceType == 'COURSE_LEVEL' || attendanceType == 'Course Level') {
	                		   grid = this$.getAttendanceforcourselevellist();
		                	   submitUrl = SERVERURL.DELETE_STUDENT_COURSE_ATTENDANCE_DETAILS;
	                	   }
	                	   if(grid.getSelectionModel().getCount()>0) {
	                		   showConfirmMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                      			 if (btn == 'yes') {
	                		   var gridRecord = grid.getSelectionModel().getSelection();
		                	   var ids=[];
		                	   Ext.Array.each(gridRecord, function(record, index) {
		                		   ids.push(record.data.id);
		                	   });
		                	   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		                	   Ext.Ajax.request({
		                		   method : "DELETE",
		                		   type : 'rest',
		                		   timeout:300000,
		                		   url : submitUrl+ '?ids='+ ids,
		                		   headers : {
		                			   'Content-Type' : 'application/json'
		                		   },
		                		   success : function(res,form,action) {
		                			   Ext.getBody().unmask();
		                			   if(res.responseText="success"){
		                				   showSuccessMessage(getProgramandcourseTranslation('STUDENT_ATTENDANCE'),getCommonTranslation('SUCCESS'));
		                				   grid.getStore().reload();
		                			   }
		                		   }
		                	   });
	                	   }
	                   });
	                	   } else {
	                		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
	                	   }
	                   },
	                   disableMoreActionAttendancePivileges: function(gridReference,permissionsMap) {
                      	 var associatedAcadLocationIds = new Array();
                      	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
                      	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                      	 var deleteAttendanceBtn = gridReference.down('#btnDeleteAttendance');
                      	 var editAttendanceBtn = gridReference.down('#btnEditAttendance');
						 editAttendanceBtn.setVisible(false);
                      	 deleteAttendanceBtn.setVisible(false);
						 Ext.each(permissionList, function(privilege) {
                      		 if (privilege === 'UPDATE') {
                      			 if(!isNullOrEmpty(editAttendanceBtn)){
                      				editAttendanceBtn.setVisible(true);
                      			 }        		
                      		 }
                      		 if (privilege === 'DELETE') {
                				   if(!isNullOrEmpty(deleteAttendanceBtn)){
                					   deleteAttendanceBtn.setVisible(true);
                				   }        	
                			   }
                      	 });
                       },
                       disableMoreActionCourseAttendancePivileges: function(gridReference,permissionsMap) {
                    	   var associatedAcadLocationIds = new Array();
                    	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
                    	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                    	   var deleteCourseAttendance = gridReference.down('#deleteCourseAttendance');
                    	   var editCourseAttendance = gridReference.down('#editCourseAttendance');
                    	   editCourseAttendance.setVisible(false);
                    	   deleteCourseAttendance.setVisible(false);
                    	   Ext.each(permissionList, function(privilege) {
                    		   if (privilege === 'UPDATE') {
                    			   if(!isNullOrEmpty(editCourseAttendance)){
                    				   editCourseAttendance.setVisible(true);
                    			   }        		
                    		   }
                    		   if (privilege === 'DELETE') {
                    			   if(!isNullOrEmpty(deleteCourseAttendance)){
                    				   deleteCourseAttendance.setVisible(true);
                    			   }        	
                    		   }

                    	   });
                       },
                       
                       
     checkFormValidity: function(vForm) {
		     var form=this.getAttendancestudentsearch()
			 isValid = vForm.isValid(),
			 searchButton = form.down('#searchBtn');

		// If form is valid or hidden mandatory fields are ignored
		if (isValid || this.areHiddenFieldsValid(vForm)) {
			searchButton ? searchButton.enable() : Ext.emptyFn();
		} else {
			searchButton ? searchButton.disable() : Ext.emptyFn();
		}
	},

	areHiddenFieldsValid: function(vForm) {
		    var form = vForm.getForm(); 
			fields = form.getFields().items;
            var flag = false;
		// Check if hidden mandatory fields are valid
		for (var i = 0; i < fields.length; i++) {
			if (!fields[i].isVisible() && !fields[i].allowBlank && !fields[i].isValid()) {
				flag = true;
			}
		}
		for (var i = 0; i < fields.length; i++) {
			if (fields[i].isVisible() && !fields[i].allowBlank && !fields[i].isValid()) {
				flag = false;
			}
		}
		return flag;
	}
 });