Ext.define('Academia.controller.attendance.PendingAttendanceController', {
	extend: 'Academia.controller.attendance.AttendanceMasterController',
	stores: ['attendance.PendingAttendanceGridStore','coursetransaction.studentenrollment.studentenrollmentdetail.AdmissionCodeBySmartSearch',
		'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','attendance.FacultyCodeSmartSearch','program.ProgramCodeOrNameSmartSearch','program.programDetails.programBatches.programCourse.ProgramCourseCodeStore'
		,'coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo','program.ProgramGroupStore','feeandpayment.reports.Program',
		'attendance.PendingAttendanceDatesGridStore','common.ProgramByAcademyLocationStore','common.AssignedProgramStore',
		'attendance.AssignedSectionByCourseNComponent','attendance.EditStudentAttendanceListStore','attendance.AttendanceCountStore',
		'messaging.MessagingTemplatesStore','committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore',
		'attendance.AttendanceMarkingTypeStore','attendance.MultipleSessionValueStore','admission.applicationFormSale.ProgramGroupComboStore',
		'personinfo.common.personalinfo.AttendanceReportProgramGroupStore','attendance.PendingAttendanceStatusStore','attendance.facultyportal.AttendanceCourses',
		'attendance.PendingAttendanceCourseWiseStore','common.AcademicTermStoreForIntakeYearId','attendance.facultyportal.AttendanceCourseVariantStore','common.BatchIntakeYearStore',
		'coursetransaction.facultytopicassignment.ParameterizedFaculties','program.ProgramCategoryByAlStore'],
		model: ['attendance.PendingAttendanceGridModel','attendance.AttendanceCountModel','common.ClassTeacherProgramStore',
			'attendance.PendingAttendanceCourseWiseModel'],
			views: ['attendance.pendingattendance.PendingSearchAttendance','attendance.AttendanceTabMasterStructure',
				'attendance.pendingattendance.PendingAttendanceStructure','attendance.pendingattendance.PendingAttendanceGrid',
				'attendance.pendingattendance.PendingDetailsWindow','attendance.pendingattendance.MarkedAttendanceDetailsWindow',
				'attendance.pendingattendance.PendingAttendanceDatesGrid','attendance.pendingattendance.MarkedAttendanceDetailGrid',
				'course.StudentSendMessageWindowDashlet','course.StudentDashletStaticDocumentAttachmentGrid','attendance.pendingattendance.PendingAttendanceCourseWiseStructure',
				'attendance.pendingattendance.PendingAttendanceCourseWiseGrid','attendance.pendingattendance.PendingAttendanceCourseWiseReportGrid',
				'attendance.pendingattendance.PendingCourseWiseSearchAttendance'],
				config: {
					CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES'),
					FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES'),
					PENDING_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PENDING_ATTENDANCE_REPORT_PRIVILEGES'),
					FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES'),
					ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_PRIVILEGES'),
					ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES'),
					EMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('EMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES'),
					PENDING_ATTENDANCE_DATES_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PENDING_ATTENDANCE_DATES_PRIVILEGES'),
					FACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES')
				},
				refs: [{
					ref: 'attendancestudentsearch',
					selector: 'attendancestudentsearch'
				},{
					ref: 'pendingsearchattendance',
					selector: 'pendingsearchattendance'
				},{
					ref: 'attendancetabmasterstructure',
					selector: 'attendancetabmasterstructure'
				},{
					ref: 'pendingattendancestructure',
					selector: 'pendingattendancestructure'
				},{
					ref: 'attendancesearchstrucure',
					selector: 'attendancesearchstrucure'
				},{
					ref: 'pendingattendancegrid',
					selector: 'pendingattendancegrid'
				},{
					ref: 'pendingdetailswindow',
					selector: 'pendingdetailswindow'
				},{
					ref: 'markedattendancedetailswindow',
					selector: 'markedattendancedetailswindow'
				},{
					ref: 'markedAttendanceDetailsWindow',
					selector: 'markedattendancedetailswindow form'
				},{
					ref: 'pendingattendancedatesgrid',
					selector: 'pendingattendancedatesgrid'
				},{
					ref: 'markedattendancedetailgrid',
					selector: 'markedattendancedetailgrid'
				},{
					ref: 'contentPanel',
					selector: 'contentPanel'
				},{
					ref :'studentsendmessagewindowdashlet',
					selector : 'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow]'
				},{
					ref :'studentdashletstaticdocumentattachmentgrid',
					selector : 'studentdashletstaticdocumentattachmentgrid'
				},{
					ref :'pendingattendancecourseWisestructure',
					selector : 'pendingattendancecourseWisestructure'
				},{
					ref :'pendingattendancecoursewisegrid',
					selector : 'pendingattendancecoursewisegrid'
				},{
					ref :'pendingattendancecoursewisereportgrid',
					selector : 'pendingattendancecoursewisereportgrid'
				},{
					ref :'pendingcoursewisesearchattendance',
					selector : 'pendingcoursewisesearchattendance'
				}],
				init: function(application) {
					this.control({
						'pendingattendancegrid' : {
							beforerender:function(){
								this.getStore('attendance.PendingAttendanceGridStore').removeAll();
							},
							render : function(grid){
								var portalId = this.getCurrentLoggedPortalId();
								if (portalId == 2) {
									this.doAccessControlValidation(grid, this.getFACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES());
								}else{
									this.doAccessControlValidation(grid, this.getPENDING_ATTENDANCE_REPORT_PRIVILEGES());
								}
							},
							cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
								var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if (e.target.tagName == 'A') {
									this.openDetailsWindow(columnName, record, false);
								}
							},
							afterrender:function(grid){
								var me = this;
								setTimeout(function(){
									me.addDataGridConfigButton(grid,me.getPENDING_ATTENDANCE_REPORT_PRIVILEGES());
								},1500);
							},
						},
						'pendingcoursewisesearchattendance': {
							afterrender:function(cmp){
								var me = this;
								var programField = cmp.down('#courseWiseProgramId');
								var academyLocationId = me.getCurrentAcademyLocation();
								var programStore = programField.getStore();
								programStore.getProxy().extraParams = {
									academyLocationIds : academyLocationId,
									isCurrentPeriod : true
								};
							}
						},
						'pendingsearchattendance': {
							afterrender:function(cmp){
								var me = this;
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								var programField = cmp.down("#programBatch_programId");
								var batchField = cmp.down("#programBatch_batchId");
								var periodField = cmp.down("#periodIdItemId");
								
								programField.reset();
								batchField.reset();
								periodField.reset();
								if(wheatherSchool){
									me.setAllowBlank(programField, true);
									me.setAllowBlank(batchField, true);
									me.setAllowBlank(periodField, true);
								}
							}
						},
						'pendingsearchattendance combo#ProgramGroupItemId' : {
							select : function(obj, record) {
								var this$ = this;
								var facultyId = null;
								if(this$.getCurrentLoggedPortalId()==2){
									facultyId = this$.getCurrentlyLoggedInUser().id;
								} 
								var form=this$.getPendingsearchattendance();
								form.down("#programBatch_programId").reset();
								form.down("#programBatch_batchId").reset();
								form.down("#periodIdItemId").reset();
								form.down("#programCoursection_ID").reset();
								form.down("#facultyName_Id").reset();
								form.down("#programBatch_batchId").setDisabled(true);
								form.down("#periodIdItemId").setDisabled(true);
								form.down("#programCoursection_ID").setDisabled(true);
								var programGroupId = record[0].get("id");
								var programStore = this$.getStore('common.ClassTeacherProgramStore');
								var academyLocationIds = this$.getCurrentAcademyLocation();

								programStore.getProxy().extraParams = {
									programGroupId: programGroupId,
									academyLocationIds :academyLocationIds,
									facultyId :facultyId
								};
								programStore.load();
							}
						},

						'pendingsearchattendance radiogroup[itemId=attendanceSearchId]':{
							change: function(obj,record) {
								var $this = this;
								this.changeAttendanceType(obj,record);
								var markStruct = $this.getMarkedattendancedetailswindow();
								var pendingSturct = this.getPendingdetailswindow();
								var markGrid = $this.getMarkedattendancedetailgrid();
								var pendingGrid = $this.getPendingattendancedatesgrid();
								pendingGrid.setVisible(false);
								pendingSturct.setVisible(false);
								markGrid.setVisible(false);
								markStruct.setVisible(false);
							},
							afterrender:function(){
								var form = this.getPendingsearchattendance();
								var radioButtons = form.down('#attendanceSearchId');
								var portalId = this.getCurrentLoggedPortalId();
								if(portalId == 2) {
									radioButtons.setVisible(false);
								}
							}
						},
						'pendingsearchattendance button[itemId=resetBtn]':{
							click: function(obj,record) {
								var this$ = this;
								var attendanceType = "";
								var facultyAttendanceType = "";
								var form = this.getPendingsearchattendance();
								var structureForm = this.getPendingattendancestructure();
								var pendingStructureForm = structureForm.getForm();
								var pendingSearchAttendanceForm=form.getForm();
								pendingStructureForm.getFields().each(function(field) {
									if(field.name == 'attendanceTypeRadio' || field.name == 'attendanceTypeWise') {

									}else{
										field.reset();	
									}
								});
								var portalId = this.getCurrentLoggedPortalId();
								var facultyId = null;
								if(portalId==2){
									facultyId = this.getCurrentlyLoggedInUser().id;
								}
								attendanceType=structureForm.down("#attendanceTypeRadio").getValue().attendanceTypeWise;
								form.down("#programBatch_batchId").setDisabled(true);
								form.down("#periodIdItemId").setDisabled(true);
								form.down("#programCoursection_ID").setDisabled(true);
								form.down("#startDate").setMinValue(false);
								form.down("#startDate").setMaxValue(new Date());
								form.down("#endDate").setMinValue(false);
								form.down("#endDate").setMaxValue(new Date());
								{
									if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
										form.down('#courseVariantId').setVisible(true);
										form.down('#courseVariantId').setDisabled(true);
										form.down("#programCoursection_ID").setVisible(false);
										form.down("#pendingAttendanceStatusId").setValue('PENDING');
									}else{
										var programByAcademyLocationStore = this.getStore('common.ClassTeacherProgramStore');
										programByAcademyLocationStore.getProxy().extraParams = {	
											facultyId : facultyId,
											academyLocationIds:this.getCurrentAcademyLocation()
										};
										programByAcademyLocationStore.load();
									}

								}
							}
						},
						'pendingsearchattendance button[itemId=searchBtn]':{
							click: function() {
								var $this = this;
								var  contentPanelMain = this.getContentPanel().getActiveTab();
								contentPanelMain.scrollBy(0,1);
								contentPanelMain.scrollBy(0,-1);
								var attendancestructure = $this.getPendingsearchattendance();
								var selectedAttendance = attendancestructure.down('#attendanceSearchId').getValue();
								var markStruct = $this.getMarkedattendancedetailswindow();
								var pendingSturct = this.getPendingdetailswindow();
								var markGrid = $this.getMarkedattendancedetailgrid();
								var pendingGrid = $this.getPendingattendancedatesgrid();
								var val = selectedAttendance['attendanceDetials'];
								this.loadPendingAttendanceGrid();
							}
						},

						'pendingsearchattendance customcombobox[itemId=programBatch_programId]': {
							select: function(obj, record) {
								var this$ = this;
								var programId = record[0].get("id");
								var portalId = this.getCurrentLoggedPortalId();
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								var facultyId = null;
								var form = this.getPendingsearchattendance();
								form.down("#programBatch_batchId").reset();
								form.down("#periodIdItemId").reset();
								form.down("#programCoursection_ID").reset();
								if(portalId==2){
									facultyId = this.getCurrentlyLoggedInUser().id;
								}
								if(programId > 0){
									form.down("#programBatch_batchId").setDisabled(false);
									var store = this$.getStore('enquiry.AcademicBatchStore');
									store.getProxy().extraParams = {
										id: programId,
										isActive:true,
										pastBatch:true
									};
									store.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length==0){
													form.down("#programCoursection_ID").setDisabled(true);
													form.down("#programCoursection_ID").clearValue();
												}
												if(records.length==1){
													form.down("#programBatch_batchId").setValue(records[0].get('id'));
													form.down("#periodIdItemId").setDisabled(false);
													var store = form.down("#periodIdItemId").getStore();
													store.getProxy().extraParams = {
														id: records[0].get('id'),
														isCurrentPeriod:true
													};
													store.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length==0){
																	form.down("#programCoursection_ID").setDisabled(true);
																	if(wheatherSchool) {
																		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
																	} 
																}
																if(records.length==1){
																	form.down("#periodIdItemId").setValue(records[0].get('id'))
																	form.down("#programCoursection_ID").setDisabled(false);
																	var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
																	store.getProxy().extraParams = {
																		periodId: records[0].get('id'),
																		facultyId : facultyId
																	};
																	store.load({
																		callback: function(records, operation, success) {
																			if (success) {
																				if(records.length==1){
																					form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
																				}
																			}
																		}
																	});

																}
															}
														}
													});
												}
											}
										}
									});
								}else{
									var form = this.getPendingsearchattendance();
									var academyLocationIds = this.getCurrentAcademyLocation();
									var store = form.down("#programBatch_programId").getStore();
									store.getProxy().extraParams = {	
										facultyId : facultyId,
										academyLocationIds:this.getCurrentAcademyLocation()
									};
									store.load();

								}
							},
							change:function(obj,record){
								this.validateSearchButton()	
							}
							
						},

						'pendingsearchattendance combo#programBatch_batchId': {
							select: function(obj, record) {
								var this$ = this;
								var portalId = this.getCurrentLoggedPortalId();
								var alinfomodel = Academia.model.authentication.ALInfoModel;
								var wheatherSchool = alinfomodel.get('wheatherSchool');
								var facultyId = null;
								if(portalId==2){
									facultyId = this.getCurrentlyLoggedInUser().id;
								}
								var batchId = record[0].get("id");
								if(batchId > 0){
									var form = this.getPendingsearchattendance();
									form.down("#periodIdItemId").setDisabled(false);
									var store = form.down("#periodIdItemId").getStore();
									store.getProxy().extraParams = {
										id: batchId,
										isCurrentPeriod:true
									};
									store.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length==0){
													form.down("#programCoursection_ID").setDisabled(true);
													if(wheatherSchool) {
														showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

													} 
												}
												if(records.length==1){
													form.down("#periodIdItemId").setValue(records[0].get('id'))
													form.down("#programCoursection_ID").setDisabled(false);
													var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
													store.getProxy().extraParams = {
														periodId: records[0].get('id'),
														facultyId : facultyId
													};
													store.load({
														callback: function(records, operation, success) {
															if (success) {
																if(records.length==1){
																	form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
																	this$.loadPendingAttendanceGrid();
																}
															}
														}
													});

												}
											}
										}
									});
								}
							}
						},
						change:function(obj,record){
							this.validateSearchButton()	
						}
						,

						'pendingsearchattendance combo#periodIdItemId': {
							select: function(obj, record) {
								var this$ = this;
								var portalId = this.getCurrentLoggedPortalId();
								var facultyId = null;
								if(portalId==2){
									facultyId = this.getCurrentlyLoggedInUser().id;
								}
								var periodId = record[0].get("id");
								if(periodId > 0){
									var form = this.getPendingsearchattendance();
									form.down("#programCoursection_ID").setDisabled(false);
									var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
									store.getProxy().extraParams = {
										periodId: periodId,
										facultyId :facultyId
									};
									store.load({
										callback: function(records, operation, success) {
											if (success) {
												if(records.length==1){
													form.down("#programCoursection_ID").setValue(records[0].data.sectionId);
													this$.loadPendingAttendanceGrid();
												}
											}
										}
									});

								}
							},
							change:function(obj,record){
								this.validateSearchButton()	
							}

						},

						'pendingsearchattendance combo#courseId': {
							select: function(obj, record) {
								var form = this.getPendingsearchattendance();
								this.courseSectionAndProgramSection(obj, record, form);
							}
						},

						'pendingattendancestructure':{
							render:function(){
								var $this = this;
								var form = this.getPendingsearchattendance();
								var portalId = this.getCurrentLoggedPortalId();
								var permissionsMap = new Ext.util.HashMap();
								if (portalId == 2) {
									permissionsMap= this.getFACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES();
								}else{
									permissionsMap=this.getPENDING_ATTENDANCE_REPORT_PRIVILEGES();
								}
								var academyLocationId = this$.getCurrentAcademyLocation();
								var programGroupStore = this$.getStore('personinfo.common.personalinfo.AttendanceReportProgramGroupStore');
								programGroupStore.getProxy().extraParams = {
									academyLocationId: academyLocationId
								};
								programGroupStore.load();

								var associatedAcadLocationIds = new Array();
								associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
								this.pendingStudentAttendanceTypeRadio(form,permissionList);

								var markStruct = $this.getMarkedattendancedetailswindow();
								var pendingSturct = this.getPendingdetailswindow();
								var markGrid = $this.getMarkedattendancedetailgrid();
								var pendingGrid = $this.getPendingattendancedatesgrid();

							},
							afterrender : function(structure){
								var grid = structure.down('pendingattendancegrid');
								var  contentPanelMain = this.getContentPanel().getActiveTab();
								contentPanelMain.scrollBy(0,1);
								contentPanelMain.scrollBy(0,-1);
								if(this.getCurrentLoggedPortalId()==2){
									var newStructure = structure.up('personinfofacultyportal');
									// this.getGridHeaderFreeze(grid,newStructure,false);
								}
							}
						},
						'pendingattendancestructure radiogroup[itemId=attendanceTypeRadio]':{
							change : function(obj,record){
								var form = this.getPendingsearchattendance();
								this.pendingAttendanceTypeDropdown(form,record); 
							}
						},
						'pendingsearchattendance datefield[itemId=startDate]':{
							change : function(obj,record){
								var attendanceType = this.getPendingattendancestructure().down('#attendanceTypeRadio').getValue();
								if(attendanceType.attendanceTypeWise == 'COURSE_LEVEL') {
									var store = this.getStore('attendance.PendingAttendanceGridStore');
									store.removeAll();
								}
							}
						},
						'pendingsearchattendance datefield[itemId=endDate]':{
							change : function(obj,record){
								var attendanceType = this.getPendingattendancestructure().down('#attendanceTypeRadio').getValue();
								if(attendanceType.attendanceTypeWise == 'COURSE_LEVEL') {
									var store = this.getStore('attendance.PendingAttendanceGridStore');
									store.removeAll();
								}
							}
						},
						'pendingDetailsWindow' : {
							beforerender:function(){
								this.getStore('attendance.PendingAttendanceDatesGridStore').removeAll();
							}
						},
						'pendingsearchattendance combo#Program_Group':{
							select: function(obj, record) {
								var programGroupId = record[0].get("id");
								var academyLocationIds = this.getCurrentAcademyLocation();
								var portalId = this.getCurrentLoggedPortalId();
								var facultyId = null;
								if(portalId==2){
									facultyId = this.getCurrentlyLoggedInUser().id;
								}
								if(programGroupId>0){
									var form = this.getPendingsearchattendance();

									var store = form.down("#programBatch_programId").getStore();
									store.getProxy().extraParams = {
										programGroupId: programGroupId,
										facultyId : facultyId,
										academyLocationIds:academyLocationIds
									};
									store.load();
								}else{
									var form = this.getPendingsearchattendance();
									var academyLocationIds = this.getCurrentAcademyLocation();
									var store = form.down("#programBatch_programId").getStore();
									store.getProxy().extraParams = {
										facultyId : facultyId,
										academyLocationIds:academyLocationIds
									};
									store.load();

								}
							}
						},
						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow] radiogroup#sendingPriority': {
							change: function( radio, newValue, oldValue, eOpts) {
								this.loadDashletStudentScheduleField(radio, newValue, oldValue);
							}
						},		   
						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow] radiogroup[itemId=messageType]':{
							change : function(val,nV,oV){
								this.selectSectionMessageType(val,nV,oV);
							}
						},
						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow]':{
							render : function(grid){
								var this$ = this;
								var portalId = this.getCurrentLoggedPortalId();
								if(portalId == 2) {
									var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
									this$.disableRadioGroupAndOtherPivileges(grid, this$.getEMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES(), itemIdPrivilegeNameArray);
								}
							}
						},
						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow] customcombobox[itemId=msgTempletId]':{
							select : function(obj,rec){
								this.selectDashletStudentMessageTemp(obj,rec);
							}
						},
						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow] button[itemId=adhocMsgSubmitBtn]':{
							click: function(button) {
								var window  = this.getStudentsendmessagewindowdashlet();
								this.sendDashletStudentMessageDashlet(button,button.up('studentsendmessagewindowdashlet').griddslt,window,button.up('studentsendmessagewindowdashlet').sectionId);   				
							}
						},'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow]  filefield[itemId=staticUploadFileField]': {
							change: function(fileField, value, eOpts){
								var this$ = this;
								this$.uploadDashletStudentStaticDocumentFileMessage(fileField, value, eOpts);
							}
						},
						/*V2D-13247*/
						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow] textarea[itemId=smsDiscription]':{
							change : function(val,nV,oV){
								var studentSendMessageWindowDashlet = this.getStudentsendmessagewindowdashlet();
								var smsTextField = studentSendMessageWindowDashlet.down('#smsDiscription');
								var smsTextFieldDiscription = studentSendMessageWindowDashlet.down('#smsDiscriptionNotice');
								var maxLength = localStorage.getItem('maxLength');
								var newValue = maxLength - smsTextField.getValue().length;
								smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
							}
						},

						'studentsendmessagewindowdashlet[itemId=studentDashletSendMessageWindow] textarea[itemId=pushNotificationDiscription]':{
							change : function(val,nV,oV){
								var studentSendMessageWindowDashlet = this.getStudentsendmessagewindowdashlet();
								var pushTextField = studentSendMessageWindowDashlet.down('#pushNotificationDiscription');
								var pushTextFieldDiscription = studentSendMessageWindowDashlet.down('#pushNotificationDiscriptionNotice');
								var maxLength = 1000;
								var newValue = maxLength - pushTextField.getValue().length;
								pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
							}
						},

						'studentdashletstaticdocumentattachmentgrid actioncolumn': {
							click : function(view, rowIndex, colIndex, item, e, record, row){
								this.deleteDashletStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
							}
						},
						'pendingattendancedatesgrid' : {
							beforerender : function(grid){
								var permissionMap = this.getATTENDANCE_ENTRY_PERMISSIONS();
								var portalId = this.getCurrentLoggedPortalId();
								if(portalId == 2) {
									permissionMap = this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES();
								}
								Ext.apply(grid,{
									code:null,
									setCode : function(code){
										grid.code = code;
									},
									getCode:function(){
										return grid.code;
									}
								});

								var associatedAcadLocationIds = new Array();
								associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
								for (var i = 0; i < permissionList.length; i++) {
									if (permissionList[i] === "VIEW") {
										grid.setCode(true);
										return;
									}else{
										grid.setCode(false);
									}
								}
							},
							cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
								var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if (e.target.tagName == 'A') {
									this.openMarkedAttendanceStructure(record);
								}
							},
							render : function(grid){
								var portalId = this.getCurrentLoggedPortalId();
								if (portalId == 2) {
									this.doAccessControlValidation(grid, this.getFACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES());
								}else{
									this.doAccessControlValidation(grid, this.getPENDING_ATTENDANCE_DATES_PRIVILEGES());
								}
							}
						},
						'tabpanel[itemId=tabpanelIds] tab':{
							activate: function(){
								var  contentPanelMain = this.getContentPanel().getActiveTab();
								contentPanelMain.scrollBy(0,1);
								contentPanelMain.scrollBy(0,-1);
							}
						},
						'pendingcoursewisesearchattendance customcombobox[itemId=courseWiseAcademicTermId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var academicTermId = obj.getValue();
								if(academicTermId > 0) {
									this.academicTermSelection(form, academicTermId);
								}
							}
						},
						'pendingcoursewisesearchattendance customcombobox[itemId=courseWiseIntakeYearId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var intakeYearId = obj.getValue();
								if(intakeYearId > 0) {
									this.intakeYearSelection(form, intakeYearId);
								}
							}
						},
						'pendingcoursewisesearchattendance customcombobox[itemId=courseWiseCourseId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var courseId = obj.getValue();
								if(courseId > 0) {
									this.courseSelection(form, courseId);
								}
							}
						},
						'pendingcoursewisesearchattendance customcombobox[itemId=courseWiseCourseVariantId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var courseVariantId = obj.getValue();
								if(courseVariantId > 0) {
									this.courseVariantSelection(form, courseVariantId);
								}
							}
						},
						'pendingcoursewisesearchattendance customcombobox[itemId=courseWiseProgramId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var programId = obj.getValue();
								if(programId > 0) {
									this.courseWiseProgramSelection(form, programId);
								}
							}
						},
						'pendingcoursewisesearchattendance customcombobox[itemId=couseWiseBatchId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var batchId = obj.getValue();
								if(batchId > 0) {
									this.courseWiseBatchSelection(form, batchId);
								}
							}
						},
						'pendingcoursewisesearchattendance button[itemId=courseWiseresetBtnId]': {
							click: function(obj, record){
								var form = this.getPendingcoursewisesearchattendance();
								this.courseWiseFormReset(form);
							}
						},
						'pendingcoursewisesearchattendance button[itemId=courseWisesearchBtnId]': {
							click: function(obj, record){
								var form = this.getPendingcoursewisesearchattendance();
								this.courseWiseRecordSearch(form);
							}
						},
						'pendingattendancecoursewisegrid' : {
							beforerender : function(grid){
								var permissionMap = this.getATTENDANCE_ENTRY_PERMISSIONS();
								var portalId = this.getCurrentLoggedPortalId();
								if(portalId == 2) {
									permissionMap = this.getATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES();
								}
								Ext.apply(grid,{
									code:null,
									setCode : function(code){
										grid.code = code;
									},
									getCode:function(){
										return grid.code;
									}
								});

								var associatedAcadLocationIds = new Array();
								associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
								var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
								for (var i = 0; i < permissionList.length; i++) {
									if (permissionList[i] === "VIEW") {
										grid.setCode(true);
										return;
									}else{
										grid.setCode(false);
									}
								}
							},
							cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
								var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if (e.target.tagName == 'A') {
									this.openCourseWiseMarkedAttendanceStructure(record);
								}
							},
							render : function(grid){
								var portalId = this.getCurrentLoggedPortalId();
								if (portalId == 2) {
									this.doAccessControlValidation(grid, this.getFACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES());
								}else{
									this.doAccessControlValidation(grid, this.getPENDING_ATTENDANCE_REPORT_PRIVILEGES());
								}
							},

							afterrender:function(grid){
								var me = this;
								setTimeout(function(){
									me.addDataGridConfigButton(grid,me.getPENDING_ATTENDANCE_REPORT_PRIVILEGES());
								},1500);
							},

						},
						'pendingcoursewisesearchattendance customcombobox[itemId=courseWiseProgramCategoryId]': {
							change: function(obj, record){
								var me = this;
								var form = obj.up('form');
								var programCategoryId = obj.getValue();
								if(programCategoryId > 0) {
									this.programCategorySelection(form, programCategoryId);
								}
							}
						},
						'pendingattendancecoursewisereportgrid' : {
							beforerender:function(){
								this.getStore('attendance.PendingAttendanceGridStore').removeAll();
							},
							render : function(grid){
								var portalId = this.getCurrentLoggedPortalId();
								if (portalId == 2) {
									this.doAccessControlValidation(grid, this.getFACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES());
								}else{
									this.doAccessControlValidation(grid, this.getPENDING_ATTENDANCE_REPORT_PRIVILEGES());
								}
							},
							cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
								var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
								if (e.target.tagName == 'A') {
									this.openDetailsWindow(columnName, record,true);
								}
							},

							afterrender:function(grid){
								var me = this;
								setTimeout(function(){
									me.addDataGridConfigButton(grid,me.getPENDING_ATTENDANCE_REPORT_PRIVILEGES());
								},1500);


							},
						}
					});
				},
				courseSectionAndProgramSection:function(obj, record, form){
					var this$ = this;
					var courseId = record[0].data.courseId;
					var courseData = record[0].data;
					var hasComponent=record[0].data.sectionAtComponentLevel;
					var facultyId = null;
					var academyLocationIds = this.getCurrentAcademyLocation();
					if(this$.getCurrentLoggedPortalId()==2){
						facultyId = this$.getCurrentlyLoggedInUser().id
					}
					var sectionId=this$.getPendingsearchattendance().down('#courseVariantId');
					sectionId.reset();
					sectionId.setDisabled(false);
					var store = sectionId.getStore();
					store.getProxy().extraParams = {
						courseId: courseId,
						facultyId : facultyId,
						academyLocationIds:academyLocationIds,
						isCurrentPeriod:true
					};
					store.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length==1){
									this$.getPendingsearchattendance().down('#courseVariantId').setValue(records[0].get('id'));
								}
							}
						}	   
					});
				},
				changeAttendanceType:function(obj,record){
					var $this = this;
					var form =$this.getPendingsearchattendance();
					var grid =$this.getPendingattendancegrid();
					var structureForm = $this.getPendingattendancestructure();
					grid.setVisible(false);

					if(record.attendanceDetials == 'faculty' || record.attendanceDetials == 'student') {
						var type=structureForm.down('#attendanceTypeRadio').getValue();
						this.pendingAttendanceTypeDropdown(form,type); 
					} else {
						this.pendingAttendanceTypeFilterForAdminAndOtherEmp();
					}

					$this.clearFormValue();
					var store = this.getStore('attendance.PendingAttendanceGridStore');
					if(record.attendanceDetials == 'faculty'){
						store.removeAll();
						form.down('#facultyName_Id').setVisible(true);
						form.down('#userName_Id').setVisible(false);

					}else if(record.attendanceDetials == 'student'){
						store.removeAll();

					} else if(record.attendanceDetials == 'admin') {

						form.down('#facultyName_Id').setVisible(false);
						var userName = form.down('#userName_Id');

						userName.setVisible(true);

						var userNamestore = userName.getStore();
						userNamestore.getProxy().extraParams = {
							userGroupName:'Admin'
						};
						userNamestore.load();

					} else if(record.attendanceDetials == 'otherEmployee') {
						form.down('#facultyName_Id').setVisible(false);

						var userName = form.down('#userName_Id');
						userName.setVisible(true);
						var userNamestore = userName.getStore();
						userNamestore.getProxy().extraParams = {
							userGroupName:'Other Employee'
						};
						userNamestore.load();
					}
					form.isValid();
				},

				validateSearchButton: function(btn){
					var $this = this;
					var form = $this.getPendingsearchattendance();
					var searchButton=form.down('#searchBtn');

					var isValid=true;
					var fieldsArray=[
						form.down('#programBatch_programId'),
						form.down('#programBatch_batchId'),
						form.down('#periodIdItemId')
						];

					Ext.each(fieldsArray,function(field){
						if(field.isVisible() && isNullOrEmpty(field.getValue()) && !field.allowBlank){
							isValid=false;
						}
					});

					if(isValid){
						searchButton.setDisabled(false);	
					}else{
						searchButton.setDisabled(true);
					}

				},

				clearFormValue:function(){
					var $this = this;
					var form =$this.getPendingsearchattendance().getForm();

					form.findField('facultyName').clearValue();
					form.findField('programId').clearValue();
					form.findField('batchId').clearValue();
					form.findField('courseId').clearValue();
					form.findField('componentId').clearValue();
					form.findField('courseVariant').clearValue();
					form.findField('periodId').clearValue();
					form.findField('sectionId').clearValue();
					var startDate = form.findField('startDate');
					var endDate = form.findField('endDate');
					if(startDate.getValue()!=null){
						startDate.reset();
					}
					if(endDate.getValue()!=null){
						endDate.reset();
					}
				},
				pendingStudentAttendanceTypeRadio:function(form,permissionList){
					var this$ = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var pendingAttendanceStructure = this.getPendingattendancestructure();
					var studentAttendanceType = [];
					var attendanceType=[];
					var attendanceTypeRadio=pendingAttendanceStructure.down('#attendanceTypeRadio');
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
						params : {
							academyLocatonId : academyLocationId
						},
						method : 'GET',
						success : function(f, action) {
							if(isNullOrEmpty(f.responseText))
							{
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
							}else{
								var res = Ext.JSON.decode(f.responseText);
								Ext.each(res, function(data) {
									attendanceType.push(data.studentAttendanceType);
								});
							}
						}
					});
					//--setting initial values to false
					var tab2=false, tab3=false,tab4=false;

					//--initially setting all radio fields to true
					var completeDayRadio = pendingAttendanceStructure.down('[inputValue=COMPLETE_DAY]');
					var courseLevelRadio = pendingAttendanceStructure.down('[inputValue=COURSE_LEVEL]');
					var multipleSessionRadio = pendingAttendanceStructure.down('[inputValue=MULTIPLE_SESSION]');
					attendanceTypeRadio.items.items[0].setVisible(true);
					attendanceTypeRadio.items.items[1].setVisible(true);
					attendanceTypeRadio.items.items[2].setVisible(true);

					//--checking for the visible tabs
					if((Ext.Array.contains(permissionList, 'PROGRAM_WISE'))&&(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day'))){
						tab2=true;
					}
					if((Ext.Array.contains(permissionList, 'COURSE_WISE'))&&(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level'))){
						tab3=true;
					}
					if((Ext.Array.contains(permissionList, 'SESSION_WISE'))&&(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session'))){
						tab4=true;
					}

					if(!tab2 && !tab3 && !tab4){
						tab2=true;
					}

					if((!tab2 && !tab3) || (!tab3 && !tab4) || (!tab4 && !tab2)){
						attendanceTypeRadio.setVisible(false);
					}
					else {
						attendanceTypeRadio.setVisible(true);
					}

					//-- setting values to true/false on the basis of visible tabs
					if(!tab2){
						attendanceTypeRadio.items.items[0].setVisible(false);
					}
					if(!tab3){
						attendanceTypeRadio.items.items[1].setVisible(false);
					}
					if(!tab4){
						attendanceTypeRadio.items.items[2].setVisible(false);
					}

					//-- setting radioGroup value on the basis of visible tabs
					setTimeout(function(){
						if(tab2){
							completeDayRadio.setValue(true);
						}
						else if(tab3){
							courseLevelRadio.setValue(true);
						}
						else if(tab4){
							multipleSessionRadio.setValue(true);
						}
					},300);
				},
				pendingAttendanceTypeDropdown:function(form,record){
					var this$ = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var attendanceType = "";
					var facultyAttendanceType = "";
					var sessionNumber = "";
					var attendanceType = record.attendanceTypeWise;
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
						params : {
							academyLocatonId : academyLocationId,
							attendanceType :attendanceType,
						},
						method : 'GET',
						success : function(f, action) {
							if(isNullOrEmpty(f.responseText))
							{
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
							}else{
								var res = Ext.JSON.decode(f.responseText);
								var data=res[0];
								attendanceType = data.studentAttendanceType;
								facultyAttendanceType = data.facultyAttendanceType;
								sessionNumber = data.sessionNo;
								this$.getPendingattendancestructure().down('#sessionNoId').setValue(sessionNumber);
							}
						}
					});

					var portalId = this.getCurrentLoggedPortalId();
					var facultyId = this.getCurrentlyLoggedInUser();
					var structure = this.getPendingattendancestructure();
					//var courseWiseSturcture =  structure.down('#pendingattendancecourseWisestructureId');
					var courseWiseForm = structure.down('#pendingcoursewisesearchattendanceId');
					var courseWiseGrid = structure.down('#pendingattendancereportpanelId');
					var programSessionWiseGrid = structure.down('#pendingattendancegridId');
					if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
						courseWiseForm.show();
						form.hide();
						programSessionWiseGrid.setVisible(false);
						courseWiseGrid.setVisible(true);
						var academicTermField = courseWiseForm.down('#courseWiseAcademicTermId');
						var courseField = courseWiseForm.down('#courseWiseCourseId');
						var facultyeField = courseWiseForm.down('#courseWiseFacultyId');
						var programCategoryField = courseWiseForm.down('#courseWiseProgramCategoryId');

						courseWiseForm.down("#courseWiseAttendanceStatusId").setValue('PENDING');
						academicTermField.reset();
						courseField.reset();
						facultyeField.reset();

						var academicTermStore = academicTermField.getStore();
						academicTermStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							onlyCurrentRecord:true
						};
						academicTermStore.load({
							callback: function(record, operation, success) {
								if (success) {
									if(record.length>0){
										var tabAcademicTerm = null;
										Ext.each(record, function(value) {
											if(value.get('sequence') == '1'){
												academicTermField.setValue(value.get('id'));
											}
										});
									}
								}
							}
						});

						var courseStore = courseField.getStore();
						courseStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId,
							isCurrentPeriod : true
						};
						courseStore.load();

						var facultyStore = facultyeField.getStore();
						facultyStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId,
							isCurrentPeriod : true
						};
						facultyStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length==1){
										facultyeField.setValue(records[0].get('id'));
									}
								}
							}
						});

						var programCategoryStore = programCategoryField.getStore();
						programCategoryStore.getProxy().extraParams = {
							academyLocationIds : academyLocationId
						};
						programCategoryStore.load({
							callback: function(records, operation, success) {
								if (success) {
									if(records.length==1){
										programCategoryField.setValue(records[0].get('id'));
									}
								}
							}
						});

						var reportGrid = this$.getPendingattendancecoursewisereportgrid();
						var attendancePendingGrid = this$.getPendingattendancecoursewisegrid();
						if(!isNullOrEmpty(reportGrid)){
							//reportGrid.getStore().removeAll();
							try {
								//this$.getPendingattendancecoursewisereportgrid().down('custompagingtoolbar').hide();
							}
							catch(e){
							}
						}

						if(!isNullOrEmpty(attendancePendingGrid)){
							//attendancePendingGrid.getStore().removeAll();
							try {
								//this$.getPendingattendancecoursewisegrid().down('custompagingtoolbar').hide();
							}
							catch(e){
							}
						}

					} else {
						courseWiseForm.hide();
						form.show();
						programSessionWiseGrid.setVisible(true);
						courseWiseGrid.setVisible(false);
						form.down('#ProgramGroupItemId').setVisible(true);
						if(!isNullOrEmpty(this$.getPendingattendancegrid())){
							//this$.getPendingattendancegrid().getStore().removeAll(); 
							try {
								//this$.getPendingattendancegrid().down('custompagingtoolbar').hide();
							}
							catch(e){
							}
						}

						var facultyId = null;
						if(portalId==2){
							facultyId = this.getCurrentlyLoggedInUser().id;
						}
						var programByAcademyLocationStore = form.down("#programBatch_programId").getStore();
						programByAcademyLocationStore.getProxy().extraParams = {	
							facultyId : facultyId,
							academyLocationIds:academyLocationId
						};
						programByAcademyLocationStore.load();

						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							form.down("#periodIdItemId").hide();
							form.down("#periodIdItemId").allowBlank=true;
						}else{
							form.down("#periodIdItemId").setVisible(true);
						}
						form.down("#periodIdItemId").reset();
						form.down("#ProgramGroupItemId").reset();
						form.down("#periodIdItemId").setDisabled(true);
						form.down("#programBatch_programId").clearValue();
						form.down("#programBatch_programId").setVisible(true);
						// form.down("#programBatch_programId").allowBlank=true;

						form.down("#programBatch_batchId").setVisible(true);
						form.down("#programBatch_batchId").reset();
						// form.down("#programBatch_batchId").allowBlank=true;
						form.down("#programBatch_batchId").setDisabled(true);
						form.down("#programCoursection_ID").setVisible(true);
						form.down("#programCoursection_ID").setDisabled(true);
						form.down("#programCoursection_ID").reset();
						form.down("#courseId").setVisible(false);
						form.down("#courseId").allowBlank=true;
						form.down("#courseId").reset();
						form.down("#sessionItemId").setVisible(false);
						form.down("#sessionItemId").allowBlank=true;
						form.down("#courseVariantId").setVisible(false);
						form.down("#courseVariantId").reset();
						form.down('#ProgramGroupItemId').setVisible(true);
						form.down("#startDate").allowBlank=true;
						form.down("#startDate").reset();
						form.down("#endDate").allowBlank=true;
						form.down("#endDate").reset();
						form.down("#startDate").setMinValue(false);
						form.down("#startDate").setMaxValue(new Date());
						form.down("#endDate").setMinValue(false);
						form.down("#endDate").setMaxValue(new Date());
						form.down('#dateContainer').setVisible(true);
						form.down("#pendingAttendanceStatusId").reset();
						form.down("#pendingAttendanceStatusId").setVisible(false);
						form.down("#facultyName_Id").reset();
						form.down("#facultyName_Id").setVisible(false);
					}
				},
				loadPendingAttendanceGrid:function(){
					var me = this;
					var grid = this.getPendingattendancegrid();
	                var formFilter = this.getPendingsearchattendance();
	                formFilter.down('#searchBtn').setDisabled(true);
	                var form = formFilter.getForm();
					var structureForm = this.getPendingattendancestructure().getForm();
					var values = form.getValues();
					grid.setVisible(true);
					grid.focus();
					var store = grid.getStore();
					var programId = values.programId;
					var batchId = values.batchId;
					var periodId = values.periodId;
					var sectionId = values.sectionId;
					var startDate = values.startDate;
					var endDate = values.endDate;
					var courseId = values.courseId;
					var facultyName = values.facultyName;
					var programGroupId = values.programGroup;
					var academyLocationId = this.getCurrentAcademyLocation();
					var sessionNo = values.sessionNo;
					var courseVariantId = values.courseVariant;
					var attendanceStatus = values.pendingAttendanceStatus;
					var pendingStructure = this.getPendingattendancestructure();
					var attendanceType = pendingStructure.down("#attendanceTypeRadio").getValue().attendanceTypeWise;;
					var facultyAttendanceType = "";
					var program;
					if(!isNullOrEmpty(programId)){
						program = programId;
					}else{
						program = '';
					}
					var batch;
					if(!isNullOrEmpty(batchId)){
						batch = batchId;
					}else{
						batch = '';
					}
					var period;
					if(!isNullOrEmpty(periodId)){
						period = periodId;
					}else{
						period = '';
					}
					var section;
					if(!isNullOrEmpty(sectionId)){
						section = sectionId;
					}else{
						section = '';
					}

					var course;
					if(!isNullOrEmpty(courseId)){
						course = courseId;
					}else{
						course = '';
					}
					var courseVariant;
					if(!isNullOrEmpty(courseVariantId)){
						courseVariant = courseVariantId;
					}else{
						courseVariant = '';
					}

					var fromDate;
					if(!isNullOrEmpty(startDate)){
						fromDate = startDate;
					}else{
						fromDate = '';
					}

					var toDate;
					if(!isNullOrEmpty(endDate)){
						toDate = endDate;
					}else{
						toDate = '';
					}


					var faculty;
					if(!isNullOrEmpty(facultyName)){
						faculty = facultyName;
					}else{
						faculty = '';
					}

					var programGroup;
					if(!isNullOrEmpty(programGroupId)){
						programGroup = programGroupId;
					}else{
						programGroup = '';
					}
					if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
						var  contentPanelMain = this.getContentPanel().getActiveTab();
						contentPanelMain.scrollBy(0,1);
						contentPanelMain.scrollBy(0,-1);
						var facultyId = null
						if(portalId == 2) {
							facultyId=this.getCurrentlyLoggedInUser().id;
							grid.columns[8].setVisible(false);
						} else {
							facultyId = facultyName;
						}
						(Ext.isDefined(grid.columns[0])) ? grid.columns[0].setVisible(false) : '';
						(Ext.isDefined(grid.columns[1])) ? grid.columns[1].setVisible(false) : '';
						(Ext.isDefined(grid.columns[2])) ? grid.columns[2].setVisible(false) : '';
						(Ext.isDefined(grid.columns[3])) ? grid.columns[3].setVisible(false) : '';
						(Ext.isDefined(grid.columns[4])) ? grid.columns[4].setVisible(false) : '';
						(Ext.isDefined(grid.columns[5])) ? grid.columns[5].setVisible(false) : '';
						(Ext.isDefined(grid.columns[6])) ? grid.columns[6].setVisible(true) : '';
						(Ext.isDefined(grid.columns[7])) ? grid.columns[7].setVisible(true) : '';
						(Ext.isDefined(grid.columns[9])) ? grid.columns[9].setVisible(true) : '';
						(Ext.isDefined(grid.columns[10])) ? grid.columns[10].setVisible(true) : '';
						(Ext.isDefined(grid.columns[11])) ? grid.columns[11].setVisible(true) : '';
						(Ext.isDefined(grid.columns[12])) ? grid.columns[12].setVisible(true) : '';

						var submitURL=SERVERURL.STUDENT_PENDING_ATTENDANCE_COURSE_LEVEL;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							courseId:course,
							academyLocationId:academyLocationId,
							facultyId:facultyId,
							courseVariantId:courseVariant,
							attendanceStatus:attendanceStatus,
							startDate:fromDate,
							endDate:toDate
						};
						this.resetPageSetting(store);
						grid.hide();
						store.load({
							callback: function(records){
				   formFilter.down('#searchBtn').setDisabled(false);
								grid.show();
								var  contentPanelMain = me.getContentPanel().getActiveTab();
								contentPanelMain.scrollBy(0,1);
								contentPanelMain.scrollBy(0,-1);
							}
						});
					}
					else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
						var facultyId = null
						if(portalId == 2) {
							facultyId=this.getCurrentlyLoggedInUser().id;
							grid.columns[8].setVisible(false);
						}
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							grid.columns[3].setVisible(false);
						}else{
							grid.columns[3].setVisible(true);
						}	
						grid.columns[0].setVisible(false);
						grid.columns[1].setVisible(true);
						grid.columns[2].setVisible(true);
						grid.columns[4].setVisible(true);
						grid.columns[5].setVisible(false);
						grid.columns[6].setVisible(false);
						grid.columns[7].setVisible(false);
						grid.columns[9].setVisible(true);
						grid.columns[10].setVisible(true);
						grid.columns[11].setVisible(true);


						var submitURL=SERVERURL.STUDENT_MULTIPLE_SESSION_PENDING_ATTENDANCE;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							programId:program,
							batchId:batch,
							periodId:period,
							sectionId:section,
							programGroupId:programGroup,
							academyLocationId:academyLocationId,
							startDate:fromDate,
							endDate:toDate,
							facultyId:facultyId,
							sessionNo:sessionNo,
							attendanceType:attendanceType
						};
						this.resetPageSetting(store);
		   store.load({
			   callback: function(records){
				   formFilter.down('#searchBtn').setDisabled(false);
				  
			   }
		   });
						grid.config.searchFilterForm =  this.getPendingsearchattendance();
					}
					else{
						var facultyId = null
						if(portalId == 2) {
							facultyId=this.getCurrentlyLoggedInUser().id;
							grid.columns[7].setVisible(false);
						}
						var alinfomodel = Academia.model.authentication.ALInfoModel;
						var wheatherSchool = alinfomodel.get('wheatherSchool');
						if(wheatherSchool){
							grid.columns[3].setVisible(false);
						}else{
							grid.columns[3].setVisible(true);
						}	
						grid.columns[0].setVisible(false);
						grid.columns[1].setVisible(true);
						grid.columns[2].setVisible(true);
						grid.columns[4].setVisible(true);
						grid.columns[5].setVisible(false);
						grid.columns[6].setVisible(false);
						grid.columns[7].setVisible(false);
						grid.columns[9].setVisible(true);
						grid.columns[10].setVisible(true);
						grid.columns[11].setVisible(true);

						var submitURL=SERVERURL.STUDENT_PENDING_ATTENDANCE;
						store.getProxy().api.read=submitURL;
						store.getProxy().extraParams = {
							programId:program,
							batchId:batch,
							periodId:period,
							sectionId:section,
							programGroupId:programGroup,
							academyLocationId:academyLocationId,
							startDate:fromDate,
							endDate:toDate,
							facultyId:facultyId,
							//sessionNo:sessionNo,
							attendanceType:attendanceType
						};
						this.resetPageSetting(store);
		   store.load({
			   callback: function(records){
				   formFilter.down('#searchBtn').setDisabled(false);
				  
			   }
		   });
						grid.config.searchFilterForm =  this.getPendingsearchattendance();
					}
				},
				openDetailsWindow:function(title, record, isCourseWiseAttendance){
					var $this = this;
					var tabName = '';
					var structure ='';
					var pendingAttendanceDatesGrid = this.getPendingattendancedatesgrid();
					var pendingStructure = this.getPendingattendancestructure();


					if(title=='totalPendings'){
						tabName = getCommonTranslation('ATTENDANCE_PENDING');
						structure = Ext.widget('pendingdetailswindow');
					}else{
						tabName = getCommonTranslation('ATTENDANCE_MARKED');
						structure = Ext.widget('markedattendancedetailswindow');
					}

					var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					/**
					 * This is to remove tab from content panel and open same tab again
					 */
					var getcontroller=$this.getController('menu.CoreERPNavigationController');
					var getTab = null;
					for(var i =0 ;i<contentPanel.items.length;i++){
						if(contentPanel.items.items[i].title == tabName){
							getTab= contentPanel.items.items[i];
						}
					}
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					openTab(contentPanel, tabName, structure);

					var $this = this;
					var form;
					var programId;
					var batchId;
					var periodId;
					var sectionId;
					var startDate;
					var endDate;
					var programGroupId;
					var courseId;
					var courseSectionId;
					var academyLocationId = this.getCurrentAcademyLocation();
					var facultyName;
					var attendancType = "";
					var facultyAttendanceType = "";
					var attendanceType;
					if(isCourseWiseAttendance){
						form = this.getPendingcoursewisesearchattendance().getForm();
						var values = form.getValues();
						programId = values.courseWiseProgram;
						batchId = values.couseWiseBatch;
						periodId = values.courseWisePeriod;
						startDate = values.startDate;
						endDate = values.endDate;
						courseId = values.courseWiseCourseName;
						facultyName = values.courseWiseFaculty;
						attendanceType='COURSE_LEVEL';
					}else{
						form = this.getPendingsearchattendance().getForm();
						var values = form.getValues();
						programId = values.programId;
						batchId = values.batchId;
						periodId = values.periodId;
						sectionId = values.sectionId;
						startDate = values.startDate;
						endDate = values.endDate;
						programGroupId = values.programGroup;
						courseId = values.courseId;
						courseSectionId = values.courseSectionId;
						facultyName = values.facultyName;
						attendanceType = pendingStructure.down("#attendanceTypeRadio").getValue().attendanceTypeWise;
					}
					var program;
					if(!isNullOrEmpty(programId)){
						program = programId;
					}else{
						program = '';
					}

					var batch;
					if(!isNullOrEmpty(batchId)){
						batch = batchId;
					}
					else{
						batch = '';
					}


					var period;
					if(!isNullOrEmpty(periodId)){
						period = periodId;
					}else{
						period = '';
					}

					var section;
					if(!isNullOrEmpty(sectionId)){
						section = sectionId;
					}else if(!isNullOrEmpty(courseSectionId)){
						section = courseSectionId;
					}else{
						section = '';
					}

					var course;
					if(!isNullOrEmpty(courseId)){
						course = courseId;
					}else{
						course = '';
					}
					var programGroup;
					if(!isNullOrEmpty(programGroupId)){
						programGroup = programGroupId;
					}else{
						programGroup = '';
					}

					var fromDate;
					if(!isNullOrEmpty(startDate)){
						fromDate = startDate;
					}

					var toDate;
					if(!isNullOrEmpty(endDate)){
						toDate = endDate;
					}


					var faculty;
					if(!isNullOrEmpty(facultyName)){
						faculty = facultyName;
					}
					if(attendanceType == 'Course Level' || attendanceType == 'COURSE_LEVEL'){
						if(title=="totalPendings"){
							var markStruct = $this.getMarkedattendancedetailswindow();
							var pendingSturct = this.getPendingdetailswindow();
							pendingSturct.down('#attendanceTypeId').setValue('COURSE_LEVEL');
							pendingSturct.down('#courseVariantId').setValue(record.data.courseVariantId);
							var markGrid = $this.getMarkedattendancedetailgrid();
							var pendingGrid = $this.getPendingattendancedatesgrid();
							//pendingGrid.columns[1].setVisible(true);
							//pendingGrid.columns[2].setVisible(true);
							var facultyId = null;
							if(portalId == 2) {
								pendingGrid.columns[3].setVisible(false);
								facultyId=this.getCurrentlyLoggedInUser().id;
							} else {
								pendingGrid.columns[3].setVisible(true);
								facultyId = faculty;
							}
							var form = this.getPendingsearchattendance().getForm();
							var values = form.getValues();
							var courseId= record.data.courseId;
							var courseVariantId = record.data.courseVariantId;
							var sectionId = record.data.sectionId;
							pendingSturct.down('#programName').setValue(record.data.programName);
							pendingSturct.down('#batchName').setValue(record.data.batchName);
							pendingSturct.down('#periodName').setValue(record.data.periodName);
							pendingSturct.down('#sectionName').setValue(record.data.sectionCode);
							pendingSturct.down('#courseName').setValue(record.data.courseName);
							pendingSturct.down('#courseVariantName').setValue(record.data.courseVaraintName);
							pendingSturct.down('#programName').setVisible(false);
							pendingSturct.down('#batchName').setVisible(false);
							pendingSturct.down('#periodName').setVisible(false);
							pendingSturct.down('#sectionName').setVisible(false);
							pendingSturct.down('#courseName').setVisible(true);
							pendingSturct.down('#courseVariantName').setVisible(true);
							pendingSturct.down('#FacultyName').setVisible(false);
							var startDate = values.startDate;
							var endDate = values.endDate;
							var academyLocationId = $this.getCurrentAcademyLocation();
							var store = pendingGrid.getStore();
							var submitURL=SERVERURL.COURSE_LEVEL_STUDENT_PENDING_DATES;
							store.getProxy().api.read=submitURL;
							store.getProxy().extraParams = {
								courseId: courseId,
								courseVariantId:courseVariantId,
								sectionId:sectionId,
								facultyId:facultyId,
								academyLocationId:academyLocationId,
								startDate:fromDate,
								endDate:toDate
							};
							this.resetPageSetting(store);
							store.load();
						}
						if(title=="totalMarkedAttendance"){
							var markStruct = $this.getMarkedattendancedetailswindow();
							var pendingSturct = this.getPendingdetailswindow();
							var markGrid = $this.getMarkedattendancedetailgrid();
							var pendingGrid = $this.getPendingattendancedatesgrid();
							var form = this.getPendingsearchattendance().getForm();
							var values = form.getValues();
							var courseId= record.data.courseId;
							var courseVariantId = record.data.courseVariantId;
							var store = markGrid.getStore();
							var facultyId = null;
							if(portalId == 2) {
								facultyId=this.getCurrentlyLoggedInUser().id;
							} else {
								facultyId = faculty;
							}
							markStruct.down('#courseName').setValue(record.data.courseName);
							markStruct.down('#courseVariantName').setValue(record.data.courseVaraintName);
							markStruct.down('#programName').setVisible(false);
							markStruct.down('#batchName').setVisible(false);
							markStruct.down('#periodName').setVisible(false);
							markStruct.down('#sectionName').setVisible(false);
							markStruct.down('#courseName').setVisible(true);
							markStruct.down('#courseVariantName').setVisible(true);
							markStruct.down('#FacultyName').setVisible(false);

							markGrid.columns[0].setVisible(true);
							markGrid.columns[1].setVisible(true);
							markGrid.columns[2].setVisible(true);
							markGrid.columns[4].setVisible(true);
							markGrid.columns[5].setVisible(true);
							markGrid.columns[6].setVisible(true);
							if(portalId == 2) {
								markGrid.columns[3].setVisible(false);
							} else {
								markGrid.columns[3].setVisible(true);
							}

							var submitURL=SERVERURL.COURSE_LEVEL_STUDENT_MARKED_ATTENDANCE;
							store.getProxy().api.read=submitURL;
							store.getProxy().extraParams = {
								courseId: courseId,
								courseVariantId:courseVariantId,
								facultyId:facultyId,
								startDate:fromDate,
								endDate:toDate

							};
							this.resetPageSetting(store);
							store.load();
						}
					}
					else if(attendanceType=='Multiple Session' || attendanceType=='MULTIPLE_SESSION'){
						if(title=="totalPendings"){
							var markStruct = this.getMarkedattendancedetailswindow();
							var pendingSturct = this.getPendingdetailswindow();
							pendingSturct.down('#attendanceTypeId').setValue('MULTIPLE_SESSION');
							pendingSturct.down('#sectionId').setValue(record.data.sectionId);
							var markGrid = $this.getMarkedattendancedetailgrid();
							var pendingGrid = $this.getPendingattendancedatesgrid();
							var facultyId = null
							if(portalId == 2) {
								facultyId=this.getCurrentlyLoggedInUser().id;
							}
							var form = this.getPendingsearchattendance().getForm();
							var values = form.getValues();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								pendingSturct.down('#periodName').setVisible(false);
							}else{
								pendingSturct.down('#periodName').setVisible(true);
							}	 
							pendingSturct.down('#programName').setValue(record.data.programName);
							pendingSturct.down('#batchName').setValue(record.data.batchName);
							pendingSturct.down('#periodName').setValue(record.data.periodName);
							pendingSturct.down('#sectionName').setValue(record.data.sectionCode);
							pendingSturct.down('#programName').setVisible(true);
							pendingSturct.down('#batchName').setVisible(true);
							pendingSturct.down('#sectionName').setVisible(true);
							pendingSturct.down('#courseName').setVisible(false);
							pendingSturct.down('#courseVariantName').setVisible(false);
							pendingSturct.down('#FacultyName').setVisible(false);

							var programId = record.data.programId;
							var batchId = record.data.batchId;
							var periodId =  record.data.periodId;
							var sectionId = record.data.sectionId;
							var startDate = values.startDate;
							var endDate = values.endDate;
							var sessionNo=1;
							pendingGrid.columns[1].setVisible(false);
							pendingGrid.columns[2].setVisible(false);
							pendingGrid.columns[3].setVisible(false);
							var store = pendingGrid.getStore();

							var submitURL=SERVERURL.PENDING_ATTENDANCE_DATES;
							store.getProxy().api.read=submitURL;
							store.getProxy().extraParams = {
								programId: programId,
								batchId:batchId,
								periodId:periodId,
								sectionId:sectionId,
								startDate:startDate,
								endDate:endDate,
								facultyId:facultyId,
								sessionNo:sessionNo,
								attendanceType:attendanceType
							};
							this.resetPageSetting(store);
							store.load();
						}
						if(title=="totalMarkedAttendance"){
							var markStruct = $this.getMarkedattendancedetailswindow();
							var pendingSturct = this.getPendingdetailswindow();
							var markGrid = $this.getMarkedattendancedetailgrid();
							var pendingGrid = $this.getPendingattendancedatesgrid();
							var form = this.getPendingsearchattendance().getForm();
							var values = form.getValues();
							var programId = record.data.programId;
							var batchId = record.data.batchId;
							var periodId =  record.data.periodId;
							var sectionId = record.data.sectionId;
							var startDate = values.startDate;
							var endDate = values.endDate;
							var store = markGrid.getStore();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								markStruct.down('#periodName').setVisible(false);
							}else{
								markStruct.down('#periodName').setVisible(true);
							}	 
							markStruct.down('#programName').setValue(record.data.programName);
							markStruct.down('#batchName').setValue(record.data.batchName);
							markStruct.down('#periodName').setValue(record.data.periodName);
							markStruct.down('#sectionName').setValue(record.data.sectionCode);
							markStruct.down('#programName').setVisible(true);
							markStruct.down('#batchName').setVisible(true);
							markStruct.down('#sectionName').setVisible(true);
							markStruct.down('#courseName').setVisible(false);
							markStruct.down('#courseVariantName').setVisible(false);
							markStruct.down('#FacultyName').setVisible(false);

							markGrid.columns[0].setVisible(true);
							markGrid.columns[1].setVisible(false);
							markGrid.columns[2].setVisible(false);
							markGrid.columns[3].setVisible(false);
							markGrid.columns[4].setVisible(true);
							markGrid.columns[5].setVisible(true);
							markGrid.columns[6].setVisible(true);

							var submitURL=SERVERURL.MULTIPLE_SESSION_MARKED_ATTENDANCE;
							store.getProxy().api.read=submitURL;
							store.getProxy().extraParams = {
								programId: programId,
								batchId:batchId,
								periodId:periodId,
								sectionId:sectionId,
								startDate:startDate,
								endDate:endDate,
								attendanceType:attendanceType
							};
							this.resetPageSetting(store);
							store.load();
						}
					}
					else{
						if(title=="totalPendings"){
							var markStruct = $this.getMarkedattendancedetailswindow();
							var pendingattendancestructure = $this.getPendingattendancestructure();
							var selectedAttendanceType = pendingattendancestructure.down('#attendanceTypeRadio').getValue().attendanceTypeWise;
							var pendingSturct = this.getPendingdetailswindow();
							pendingSturct.down('#attendanceTypeId').setValue(selectedAttendanceType);
							pendingSturct.down('#sectionId').setValue(record.data.sectionId);
							var markGrid = $this.getMarkedattendancedetailgrid();
							var pendingGrid = $this.getPendingattendancedatesgrid();
							var facultyId = null
							if(portalId == 2) {
								facultyId=this.getCurrentlyLoggedInUser().id;
							}
							var form = this.getPendingsearchattendance().getForm();
							var values = form.getValues();
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								pendingSturct.down('#periodName').setVisible(false);
							}else{
								pendingSturct.down('#periodName').setVisible(true);
							}	 
							pendingSturct.down('#programName').setValue(record.data.programName);
							pendingSturct.down('#batchName').setValue(record.data.batchName);
							pendingSturct.down('#periodName').setValue(record.data.periodName);
							pendingSturct.down('#sectionName').setValue(record.data.sectionCode);
							pendingSturct.down('#programName').setVisible(true);
							pendingSturct.down('#batchName').setVisible(true);
							pendingSturct.down('#sectionName').setVisible(true);
							pendingSturct.down('#courseName').setVisible(false);
							pendingSturct.down('#courseVariantName').setVisible(false);
							pendingSturct.down('#FacultyName').setVisible(false);

							var programId = record.data.programId;
							var batchId = record.data.batchId;
							var periodId =  record.data.periodId;
							var sectionId = record.data.sectionId;
							var startDate = values.startDate;
							var endDate = values.endDate;
							pendingGrid.columns[1].setVisible(false);
							pendingGrid.columns[2].setVisible(false);
							pendingGrid.columns[3].setVisible(false);
							var store = pendingGrid.getStore();

							var submitURL=SERVERURL.PENDING_ATTENDANCE_DATES;
							store.getProxy().api.read=submitURL;
							store.getProxy().extraParams = {
								programId: programId,
								batchId:batchId,
								periodId:periodId,
								sectionId:sectionId,
								startDate:startDate,
								endDate:endDate,
								facultyId:facultyId,
								attendanceType:attendanceType

							};
							this.resetPageSetting(store);
							store.load();
						}
						if(title=="totalMarkedAttendance"){
							var markStruct = $this.getMarkedattendancedetailswindow();
							var pendingSturct = this.getPendingdetailswindow();
							var markGrid = $this.getMarkedattendancedetailgrid();
							var pendingGrid = $this.getPendingattendancedatesgrid();
							var form = this.getPendingsearchattendance().getForm();
							var values = form.getValues();
							var programId = record.data.programId;
							var batchId = record.data.batchId;
							var periodId =  record.data.periodId;
							var sectionId = record.data.sectionId;
							var startDate = values.startDate;
							var endDate = values.endDate;
							var store = markGrid.getStore();

							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							if(wheatherSchool){
								markStruct.down('#periodName').setVisible(false);
							}else{
								markStruct.down('#periodName').setVisible(true);
							}	 
							markStruct.down('#programName').setValue(record.data.programName);
							markStruct.down('#batchName').setValue(record.data.batchName);
							markStruct.down('#periodName').setValue(record.data.periodName);
							markStruct.down('#sectionName').setValue(record.data.sectionCode);
							markStruct.down('#programName').setVisible(true);
							markStruct.down('#batchName').setVisible(true);
							markStruct.down('#sectionName').setVisible(true);
							markStruct.down('#courseName').setVisible(false);
							markStruct.down('#courseVariantName').setVisible(false);
							markStruct.down('#FacultyName').setVisible(false);

							markGrid.columns[0].setVisible(true);
							markGrid.columns[1].setVisible(false);
							markGrid.columns[2].setVisible(false);
							markGrid.columns[3].setVisible(false);
							markGrid.columns[4].setVisible(true);
							markGrid.columns[5].setVisible(true);
							markGrid.columns[6].setVisible(true);

							var submitURL=SERVERURL.MARKED_ATTENDANCE;
							store.getProxy().api.read=submitURL;
							store.getProxy().extraParams = {
								programId: programId,
								batchId:batchId,
								periodId:periodId,
								sectionId:sectionId,
								startDate:startDate,
								endDate:endDate,
								attendanceType:attendanceType
							};
							this.resetPageSetting(store);
							store.load();
						}
					}
				},
				pendingAttendanceTypeFilterForAdminAndOtherEmp :function() {

					var $this = this;

					var form = $this.getPendingsearchattendance();


					form.down("#programBatch_programId").allowBlank=true;
					form.down("#programBatch_programId").setVisible(false);
					form.down("#programBatch_programId").reset();

					form.down("#programBatch_batchId").setVisible(false);
					form.down("#programBatch_batchId").reset();

					form.down("#periodIdItemId").setVisible(false);
					form.down("#periodIdItemId").reset();

					form.down("#programCoursection_ID").setVisible(false);
					form.down("#programCoursection_ID").reset();

					form.down("#courseId").allowBlank=true;
					form.down("#courseId").setVisible(false);
					form.down("#courseId").reset();

					form.down("#courseVariantId").setVisible(false);
					form.down("#courseVariantId").reset();

					form.down('#dateContainer').setVisible(true);

					form.down("#startDate").setVisible(true);
					form.down("#startDate").reset();
					form.down("#startDate").allowBlank=false;

					form.down("#endDate").setVisible(true);
					form.down("#endDate").reset();
					form.down("#endDate").allowBlank=false;

					form.down("#startDate").setFieldLabel(getCommonTranslation('START_DATE')+'<span class="required" style="color:red"> *</span>');
					form.down("#endDate").setFieldLabel(getCommonTranslation('END_DATE')+'<span class="required" style="color:red"> *</span>');		
				},
				openSendMessageDashletWindow : function(selectedRecord, studentCountGrid,sectionId){

					var $this=this;
					var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					if(!isNullOrEmpty(sectionId)) {
						var structure = Ext.widget('studentsendmessagewindowdashlet',{
							itemId:'studentDashletSendMessageWindow',
							sectionId: sectionId
						});
					} else {
						var structure = Ext.widget('studentsendmessagewindowdashlet',{
							itemId:'studentDashletSendMessageWindow',
							griddslt: studentCountGrid
						});
					}
					var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
					/**
					 * This is to remove tab from content panel and open same tab again
					 */
					var getcontroller=this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
					//	openTab(contentPanel, tabName, structure);
					var formWindowTab = $this.getStudentsendmessagewindowdashlet();
					formWindowTab.down("#selectTemplate").allowBlank=true;
					formWindowTab.down("#selectTemplate").setVisible(false);
					formWindowTab.down("#messageName").allowBlank=true;   
					formWindowTab.down("#messageName").setVisible(false);
					var templateStore = formWindowTab.down('#selectTemplate').getStore();
					templateStore.getProxy().extraParams={
						msgRecipientTypeId:2
					};
					templateStore.load();

					var customUrl=SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=CourseDashletTemplatebe539740-692d-4ae1-bc17-338c4002874d';
					if(isNullOrEmpty(studentCountGrid)){	// added for Attendance dashlet
						customUrl=SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=attendanceTemplatebe539740-692d-4ae1-bc17-338c4002874d';
					}
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						method : "GET",
						type : 'rest',
						url : customUrl,
						headers : {
							'Content-Type' : 'application/json'
						},
						success : function(form,action) {
							var data = Ext.JSON.decode(form.responseText);
							formWindowTab.down("#id").setValue(data.id);
							formWindowTab.down("#code").setValue(data.code);
							formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
							formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
							formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
							Ext.getBody().unmask();

							//grid.getStore().reload();
							//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
						}

					});
					openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);	     
				},

				sendDashletStudentMessageDashlet : function(button,grid,window,sectionId){

					baseController = Academia.app.getController('Academia.controller.base.BaseController');
					var formData = button.up('form').getValues();
					var recipientIds = null;
					typeId = 2;
					recipientId = 2;
					if(!isNullOrEmpty(grid)){
						var recipientIds = this.getReceipientIds(grid);
					}else{
						var admissionIds = new Array();
						var sectionId =  sectionId;
						var facultyId = this.getCurrentlyLoggedInUser().id;
						var studentListParam = {
								"userId" : facultyId,
								// "periodId" : periodId,
								"sectionId" : sectionId,
								"page" : 1,
								"limit":-1
						};
						Ext.Ajax.request({
							type : 'rest',
							async: false,
							url : SERVERURL.GET_STUDENT_COMPLETE_DAY_ATTENDANCE_DASHLET,
							jsonData : studentListParam,
							method : 'POST',
							success : function(f, action) {
								if(f.responseText == 'ENTRY_NOT_FOUND')
								{
									showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
								}else{
									var data = Ext.JSON.decode(f.responseText);
									for(var i = 0;i<data.rows.length;i++){
										admissionIds.push(data.rows[i].studentId);
										recipientIds =  admissionIds;
									}
								}
							}
						});
					}

					//var basicSetUpForm=button.up('form');

					/*Added for SENT TO functionality*/
					var wsMsgEventRecipientConfigsUpdated = [];
					var sendMessageToOptions = formData.recieverType;
					var isStudentChecked = false;
					var isParentChecked = false;
					var isMySelfChecked = false;
					var isLoggedInUserId=this.getCurrentlyLoggedInUser().id;				
					if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
						if(sendMessageToOptions.constructor === Array){
							if(sendMessageToOptions.length > 0){
								sendMessageToOptions.forEach(function(current_value, index, initial_array) {
									if(current_value == 1 || current_value == '1'){
										isStudentChecked = true;
									}
									if(current_value == 2 || current_value == '2'){
										isParentChecked = true;
									}
									if(current_value == 4 || current_value == '4'){
										isMySelfChecked = true;
									}
								});
							}
						}else{
							if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
								isStudentChecked = true;
							}
							if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
								isParentChecked = true;
							}
							if(sendMessageToOptions == 4 || sendMessageToOptions == '4'){
								isMySelfChecked = true;
							}
						}
					}
					if(!isStudentChecked && !isParentChecked){
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SELECT_INCLUDE_MYSELF_WITH_OTHER_ONE')); 
						return false;
					}

					if( !isParentChecked){ // No checkbox is checked
					}else{

						var RecipientTypeCodes = ["Parent Adhoc"];

						var urlNew = '';
						urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;

						Ext.Ajax.request({
							type: 'rest',
							url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
							jsonData: RecipientTypeCodes,
							method: 'POST',
							async: false,
							success: function(response) {
								var RecipientTypeCodesData = Ext.decode(response.responseText);

								Ext.Ajax.request({
									type: 'rest',
									url: urlNew,
									jsonData: recipientIds,
									method: 'POST',
									async: false,
									success: function(response) {
										if(isParentChecked) { // If Parent checkbox is selected
											// update wsMsgEventRecipientConfigsUpdated with parent ids
											var wsMsgEventRecipientConfigsParents = {
													msgRecipientTypeId: 66,
													msgTemplateConfigId: 0,	//formData.id, 
													selectiveRecipientIds: []
											};
											if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
												wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
											}
											wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
											wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
										}
									}
								});
							}
						});

					}
					if(isMySelfChecked){
						var wsMsgEventRecipientConfigsMySelf = {
								msgRecipientTypeId: 166,
								msgTemplateConfigId: 0,	//formData.id, 
								selectiveRecipientIds: [isLoggedInUserId]
						};
						wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsMySelf);

					}
					/*END*/

					var staticDocumentGrid = this.getStudentdashletstaticdocumentattachmentgrid();
					var staticDocumentStore = staticDocumentGrid.getStore();
					//staticDocumentStore.removeAll();
					var staticDocuments = new Array();
					staticDocumentStore.each(function(values){

						var staticDocumentObject = new Object();

						staticDocumentObject.id = values.get('id');
						staticDocumentObject.templateConfigDocId = values.get('templateConfigDocId');
						staticDocumentObject.name = values.get('name');
						var date = values.get('submissionDate');
						if(isNullOrEmpty(date)){
							date = Ext.Date.format(new Date(), 'd-m-Y');
						}

						staticDocumentObject.submissionDate = date;
						staticDocumentObject.path = values.get('path');
						staticDocumentObject.createdBy = {
								id : values.get('createdBy').id,
								value : values.get('createdBy').value,
								code : values.get('createdBy').code
						},
						staticDocumentObject.status = values.get('status');
						staticDocumentObject.documentType = values.get('documentType');
						staticDocuments.push(staticDocumentObject);
					});

					staticDocumentStore.removeAll();


					if(formData.messageType=="2")
					{

						var json = new Object();
						//json.id = formData.id;
						//json.code = formData.code;
						//json.templateConfigName = formData.templateConfigName;
						json.msgSubCategoryId = formData.msgSubCategoryId;
						json.templateDataProviderId = null;
						json.whetherStaticMsg = false;
						json.recipientTypeId = typeId;
						json.msgMessageTypeId = 4;
						json.approvalRequired = false;
						json.approverId = null;
						json.academyLocationId = 3;
						json.authorId = 1;
						json.authorName = "System Admin System Admin";
						json.availableForAdhocMsg = true;
						json.status = "APPROVED";
						json.staticDocuments = staticDocuments;
						var jsonData=[];
						if(formData.msgTempletId =="EMAIL_SYSTEM_NOTIFICATION")
						{
							var obj1 = new Object();

							var arr1 = new Object();
							arr1.id = 1;
							arr1.code = 'Email';
							arr1.whetherMsgSubjAvail = true;
							arr1.whetherAttachmentSupported = true;


							obj1.subjectLine = formData.subjectDisplayCode;
							obj1.msgContent = formData.discriptionId;
							obj1.msgDeliveryMode = arr1;

							var tempArr = new Array();
							var tempObj = new Object();

							tempArr.push(obj1);
							var jsonData={"messageTemplates": [{
								"subjectLine": formData.subjectDisplayCode,
								"msgContent": formData.discriptionId,
								"msgDeliveryMode": {
									"id": 1,
									"code": "Email",
									"whetherMsgSubjAvail": true,
									"whetherAttachmentSupported": true
								}
							}]};
							json.messageTemplates = tempArr
						}else if(formData.msgTempletId =="EMAIL_ONLY")
						{
							var obj1 = new Object();

							var arr1 = new Object();
							arr1.id = 1;
							arr1.code = 'EMAIL_ONLY';
							arr1.whetherMsgSubjAvail = true;
							arr1.whetherAttachmentSupported = true;


							obj1.subjectLine = formData.subjectDisplayCode;
							obj1.msgContent = formData.discriptionId;
							obj1.msgDeliveryMode = arr1;

							var tempArr = new Array();
							var tempObj = new Object();

							tempArr.push(obj1);
							json.messageTemplates = tempArr
						}else if(formData.msgTempletId =="SYSTEM_NOTIFICATION")
						{
							var obj1 = new Object();

							var arr1 = new Object();
							arr1.id = 4;
							arr1.code = 'SYSTEM_NOTIFICATION';
							arr1.whetherMsgSubjAvail = true;
							arr1.whetherAttachmentSupported = true;


							obj1.subjectLine = formData.subjectDisplayCode;
							obj1.msgContent = formData.discriptionId;
							obj1.msgDeliveryMode = arr1;

							var tempArr = new Array();
							var tempObj = new Object();

							tempArr.push(obj1);
							json.messageTemplates = tempArr
						}
						else if(formData.msgTempletId =="PUSH_NOTIFICATION")
						{
							var obj1 = new Object();
							var arr1 = new Object();
							arr1.id = 6;
							arr1.code = 'PUSH_NOTIFICATION';
							arr1.whetherMsgSubjAvail = true;
							arr1.whetherAttachmentSupported = false;

							//objArr.push(arr1);

							obj1.subjectLine = formData.subjectDisplayCode;
							obj1.msgContent = formData.discriptionId;
							obj1.msgDeliveryMode = arr1;

							var tempArr = new Array();
							var tempObj = new Object();

							tempArr.push(obj1);
							json.messageTemplates = tempArr
							//json.push(tempObj);
						}else if(formData.msgTempletId =="PUSH_NOTIFICATION_ONLY")
						{
							var obj1 = new Object();
							var arr1 = new Object();
							arr1.id = 6;
							arr1.code = 'PUSH_NOTIFICATION_ONLY';
							arr1.whetherMsgSubjAvail = true;
							arr1.whetherAttachmentSupported = false;

							//objArr.push(arr1);

							obj1.subjectLine = formData.subjectDisplayCode;
							//obj1.msgContent = formData.pushNotificationDiscription;
							obj1.msgContent = formData.discriptionId;
							obj1.msgDeliveryMode = arr1;

							var tempArr = new Array();
							var tempObj = new Object();

							tempArr.push(obj1);
							json.messageTemplates = tempArr
							//json.push(tempObj);
						}else
						{
							var obj1 = new Object();

							var arr1 = new Object();
							arr1.id = 2;
							arr1.code = 'SMS';
							arr1.whetherMsgSubjAvail = false;
							arr1.whetherAttachmentSupported = false;

							obj1.subjectLine = formData.subjectDisplayCode;
							obj1.msgContent = formData.smsDiscription;
							obj1.msgDeliveryMode = arr1;

							var tempArr = new Array();
							var tempObj = new Object();

							tempArr.push(obj1);
							json.messageTemplates = tempArr

						}
						jsonDataEncode = Ext.encode(json);
						Ext.Ajax.request({
							type: 'rest',
							//url: SERVERURL.ADHOC_MESSAGE_UPDATE_COMMITTEE,
							url: SERVERURL.ADHOC_MESSAGE_UPDATE_TEMPLATE_CONFIG,
							jsonData: jsonDataEncode,
							method: 'POST',
							success: function(form, action) {
								Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
								var templateConfigId = Ext.decode(form.responseText);
								submitUrl = SERVERURL.ADOC_MESSAGEING_CREATE; 
								var submitUrl; 
								var json = {
										id: null, 
										status: null, 
										//msgTemplateConfigId: formData.id, 
										sendingPriority: formData.sendingPriority, 
										msgCategoryId:formData.msgCategoryId, 
										msgSubCategoryId: formData.msgSubCategoryId, 
										messageId: formData.messageId, 
										displayCode: formData.subjectDisplayCode, 
										wsMsgEventRecipientConfigs: [ 
											/*{ 
							                            	// msgRecipientTypeId: 44, 
							                            	 msgRecipientTypeId: recipientId,
							                            	 msgTemplateConfigId:templateConfigId,	//formData.id, 
							                            	 selectiveRecipientIds:recipientIds 
							                             } */
											], 
											wsAdhocRecipients: null, 
											approverId: null, 
											approvalRequired: false, 
											reviewStatusCode: "APPROVED" 
								};

								/*added for SENT TO option*/
								if(isStudentChecked){
									json.wsMsgEventRecipientConfigs.push({ 
										msgRecipientTypeId: recipientId,
										msgTemplateConfigId:templateConfigId,	//formData.id, 
										selectiveRecipientIds:recipientIds 
									});
								}

								if(wsMsgEventRecipientConfigsUpdated.length > 0){
									wsMsgEventRecipientConfigsUpdated.forEach(function(current_value, index, initial_array) {
										//current_value.msgRecipientTypeId = recipientId;
										current_value.msgTemplateConfigId = templateConfigId;
										json.wsMsgEventRecipientConfigs.push(current_value);
									});
								}
								/*END for SENT TO option*/


								if(formData.sendingPriority==="SCHEDULE"){
									if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
										var dateString="";
										dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
										json.msgDueDate=dateString;
									}else{
										json.msgDueDate= null;
									}
								}else if(formData.sendingPriority==="IMMEDIATE"){
									var now = new Date();
									var dateString = Ext.Date.format(now,'Y-m-d h:i A');
									json.msgDueDate=null;
								}else{
									json.msgDueDate= null;
								}

								var academyLocation=baseController.getCurrentAcademyLocation();
								if(!isNullOrEmpty(academyLocation)){
									json.academyLocationId=academyLocation;
								}

								var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
								if(!isEmpty(currentlyLoggedInUser)){
									json.authorId=currentlyLoggedInUser.id;
									json.authorName=currentlyLoggedInUser.value;
								}
								jsonDataEncode = Ext.encode(json);
								var $this = this;
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl,
									jsonData : jsonDataEncode,
									method : 'POST',
									success : function(frm, action) {
										Ext.getBody().unmask();
										if(!isNullOrEmpty(grid)){
											grid.getStore().reload();
											grid.getSelectionModel().deselectAll(true);
										}
										//staticDocumentGrid.getStore().reload();
										//staticDocumentGrid.getSelectionModel().deselectAll(true);
										//button.up('window').close();
										var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
										var getcontroller=Academia.app.getController('menu.CoreERPNavigationController');
										var getTab=getcontroller.getTab(tabName);
										if(getTab!=null){
											contentPanel.remove(getTab, true);
										}
										showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
									}
								});

							}

						});


					}else
					{	
						baseController = Academia.app.getController('Academia.controller.base.BaseController');
						//var recipientIds = null;
						/*typeId = 2;
			recipientId = 2;*/
						var msgRecipientType = 2;
						var typeId=2;
						if(isNullOrEmpty(grid)){
							var admissionIds = new Array();
							//var sectionId = null;
							var facultyId = this.getCurrentlyLoggedInUser().id;
						}else{
							recipientIds = this.getReceipientIds(grid);
						}

						var json = {
								id: null, 
								status: null, 
								msgTemplateConfigId: null, 
								sendingPriority: formData.sendingPriority, 
								msgCategoryId:formData.msgCategoryId, 
								msgSubCategoryId: formData.msgSubCategoryId, 
								messageId: formData.messageId,
								displayCode: formData.displayCode, 
								wsMsgEventRecipientConfigs: [ 
									/*{ 
					                            	 msgRecipientTypeId: msgRecipientType,
					                            	 msgTemplateConfigId:formData.msgTemplateConfigId, 
					                            	 selectiveRecipientIds:recipientIds 
					                             } */
									], 
									wsAdhocRecipients: null, 
									approverId: null, 
									approvalRequired: false, 
									reviewStatusCode: "APPROVED" 

						};

						/*added for SENT TO option*/
						if(isStudentChecked){
							json.wsMsgEventRecipientConfigs.push({ 
								msgRecipientTypeId: recipientId,
								msgTemplateConfigId:templateConfigId,	//formData.id, 
								selectiveRecipientIds:recipientIds 
							});
						}

						if(wsMsgEventRecipientConfigsUpdated.length > 0){
							wsMsgEventRecipientConfigsUpdated.forEach(function(current_value, index, initial_array) {
								//current_value.msgRecipientTypeId = recipientId;
								current_value.msgTemplateConfigId = templateConfigId;
								json.wsMsgEventRecipientConfigs.push(current_value);
							});
						}
						/*END for SENT TO option*/

						if(formData.sendingPriority==="SCHEDULE"){
							if(!isNullOrEmpty(formData.msgDueDate) && !isNullOrEmpty(formData.msgDueDateTime)){
								var dateString="";
								dateString=formData.msgDueDate+" "+formData.msgDueDateTime;
								json.msgDueDate=dateString;
							}else{
								json.msgDueDate= null;
							}
						}else if(formData.sendingPriority==="IMMEDIATE"){
							var now = new Date();
							var dateString = Ext.Date.format(now,'Y-m-d h:i A');
							json.msgDueDate=null;
						}else{
							json.msgDueDate= null;
						}

						var academyLocation=baseController.getCurrentAcademyLocation();
						if(!isNullOrEmpty(academyLocation)){
							json.academyLocationId=academyLocation;
						}

						var currentlyLoggedInUser=baseController.getCurrentlyLoggedInUser();
						if(!isEmpty(currentlyLoggedInUser)){
							json.authorId=currentlyLoggedInUser.id;
							json.authorName=currentlyLoggedInUser.value;
						}
						jsonDataEncode = Ext.encode(json);
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.ADOC_MESSAGEING_CREATE,
							jsonData: jsonDataEncode,
							method: 'POST',
							success: function(form, action) {
								showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('MESSAGE_SEND_MSG'));
								if(Ext.isDefined(grid)){
									grid.getStore().reload();
									grid.getSelectionModel().deselectAll(true);
								}					
								var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
								var getcontroller=Academia.app.getController('menu.CoreERPNavigationController');
								var getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentPanel.remove(getTab, true);
								}
								//button.up('window').close();
							}

						});
					}	
				},

				/**
				 * This method is used to get Ids 
				 */
				getReceipientIds : function(grid){
					var records = grid.getSelectionModel().getSelection();
					var ids = new Array();

					if(grid.itemId === 'StudentSearchResultGrid'){
						for(var i = 0 ; i<records.length;i++){
							ids.push(records[i].raw.ADMISSION_ID);
						}
					}else if(grid.itemId === 'userSearchresultgrid'){
						for(var i = 0 ; i<records.length;i++){
							ids.push(records[i].raw.USER_ID);
						}
					}else if(grid.url === 'rest/course/getCourseDashlet'){
						for(var i = 0 ; i<records[0].data.studentIds.length;i++){
							ids.push(records[0].data.studentIds[i]);
						}
					}else{
						for(var i = 0 ; i<records.length;i++){
							ids.push(records[i].raw.ID);
						}
					}
					return ids;
				},
				loadDashletStudentScheduleField : function(radio,newValue, oldValue){
					var adhocMessageForm = radio.up('form');
					var scheduleDateField = adhocMessageForm.down('#scheduleDate');
					var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
					var radioValue = radio.getValue().sendingPriority;

					if(radioValue=='IMMEDIATE'){
						scheduleDateField.setVisible(false);valueCode
						scheduleDateField.setDisabled(true);
						scheduleTimeField.setVisible(false);
						scheduleTimeField.setDisabled(true);    		valueCode
					}
					else if(radioValue=='SCHEDULE'){
						scheduleDateField.setVisible(true);
						scheduleDateField.setDisabled(false);
						scheduleTimeField.setVisible(true);
						scheduleTimeField.setDisabled(false);
					}
				},

				/*Start messaging functions*/

				selectSectionMessageType : function(val,nV,oV){

					var $this =  this;
					var formWin = $this.getStudentsendmessagewindowdashlet();

					//var value = nV.1;
					if(nV.messageType==2){
						formWin.down("#messageId").hide();
						formWin.down("#selectTemplate").allowBlank=true;
						formWin.down("#selectTemplate").setVisible(false);     		 
						formWin.down("#messageName").allowBlank=true;   
						formWin.down("#messageName").setVisible(false);
						formWin.down("#msgTempletId").setVisible(true);
						formWin.down("#msgTempletId").allowBlank=false;
						formWin.down("#msgTempletId").reset();
						formWin.down("#subject").setVisible(true);
						formWin.down("#subject").allowBlank=false;
						formWin.down("#subject").reset();
						formWin.down("#discriptionId").setVisible(true);
						formWin.down("#discriptionId").reset();
						formWin.down('#smsDiscription').reset();
						formWin.down('#smsDiscription').hide();
						formWin.down('#smsDiscriptionNotice').hide();
						formWin.down('#pushNotificationDiscription').hide();
						formWin.down('#pushNotificationDiscriptionNotice').hide();
					}else{
						formWin.down("#msgTempletId").allowBlank=true;
						formWin.down("#msgTempletId").setVisible(false);     		
						formWin.down("#messageId").setVisible(true);
						formWin.down("#selectTemplate").setVisible(true);     		
						formWin.down("#messageName").setVisible(true);
						formWin.down("#messageName").reset();
						formWin.down("#subject").allowBlank=true;
						formWin.down("#subject").setVisible(false);
						formWin.down("#discriptionId").setVisible(false);
						formWin.down("#messageName").allowBlank=false;  
						formWin.down("#selectTemplate").allowBlank=false;
						formWin.down("#selectTemplate").reset();
						formWin.down("#studentdashletDocumentMessageAttachmentGrid").setVisible(false);
						formWin.down("#staticUploadFileField").setVisible(false);
						formWin.down('#smsDiscription').reset();
						formWin.down('#smsDiscription').hide();
						formWin.down('#smsDiscriptionNotice').hide();
						formWin.down('#pushNotificationDiscription').hide();
						formWin.down('#pushNotificationDiscriptionNotice').hide();
						var allowblankFalse = '<span class="required" style="color:red"> *</span>';
						formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
						formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
					}
					formWin.getForm().checkValidity();
				},
				selectDashletStudentMessageTemp: function(obj,rec){
					var $this =  this;
					var formWin = $this.getStudentsendmessagewindowdashlet();
					var subject = formWin.down('#subject');
					var smsDiscription = formWin.down('#smsDiscription');
					var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
					var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
					var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
					if(rec[0].data.value == "SMS")
					{
						formWin.down("#subject").allowBlank=true;
						formWin.down("#subject").hide();
						formWin.down("#staticUploadFileField").hide();
						formWin.down("#studentdashletDocumentMessageAttachmentGrid").hide();
						formWin.down('#discriptionId').reset();
						formWin.down('#discriptionId').hide();	       		 
						subject.reset();
						smsDiscription.show();
						smsDiscriptionNotice.show();
						pushNotificationDiscription.hide();
						pushNotificationDiscriptionNotice.hide();
						pushNotificationDiscription.reset();
					}
					//V2D-72177
					/*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
	       		 subject.show();
	       		 formWin.down("#staticUploadFileField").hide();
	       		 this.setAllowBlank (subject,false);
	       		 formWin.down("#studentdashletDocumentMessageAttachmentGrid").hide();
	       		 formWin.down('#discriptionId').reset();
	       		 formWin.down('#discriptionId').hide();
	       		 subject.reset();
	       		 smsDiscription.reset();
	       		 smsDiscription.hide();
	       		 smsDiscriptionNotice.hide();
	       		 pushNotificationDiscription.reset();
	       		 pushNotificationDiscription.show();
	       		 pushNotificationDiscriptionNotice.show();
	       		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
	       		 //formWin.down('#smsDiscription')
	       	 }*/
					else{
						formWin.down('#discriptionId').reset();
						formWin.down('#smsDiscription').reset();
						formWin.down('#smsDiscription').hide();
						formWin.down('#smsDiscriptionNotice').hide();
						formWin.down("#staticUploadFileField").show();
						// formWin.down("#staticDocumentMessageAttachmentGrid").show();
						formWin.down("#studentdashletDocumentMessageAttachmentGrid").show()
						subject.reset();
						subject.show();
						this.setAllowBlank (subject,false);
						//formWin.down("#subject").allowBlank=false;
						formWin.down('#discriptionId').show();
						pushNotificationDiscription.hide();
						pushNotificationDiscriptionNotice.hide();
						pushNotificationDiscription.reset();
					}
					formWin.getForm().checkValidity();
				},
				/**
				 * upload static document file for Student
				 */
				uploadDashletStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
					var this$ = this;
					var setupForm = fileField.up('studentsendmessagewindowdashlet');
					var grid = setupForm.down('#studentdashletStaticDocumentAttachmentGridMessage');
					fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
					fileField.setRawValue(fileUploadPath);
					var file = fileField.fileInputEl.dom.files[0];
					if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
						if(!isNullOrEmpty(fileUploadPath)){
							var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
							if (this$.isValidFileExtensionForMessaging(extension)) {
								var entityId = 'student';
								var module = 'messaging';
								var entityType = 'template';
								var documentType = 'DOCUMENT';
								var isTransient = true;
								var this$ = this;
								this$.saveApplicantStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
									if(success){
										var path = Ext.JSON.decode(action.response.responseText).path;
										var user = this$.getCurrentlyLoggedInUser();
										var store = grid.getStore();
										var documentStatus = "SUBMITTED";
										var documentType = null;
										if(!isNullOrEmpty(path)){
											store.add({
												id: '',
												name: fileUploadPath,
												path: path ,
												createdBy : {
													id :user.id,
													value : user.value,
													code : user.code
												},
												status : documentStatus,
												documentType : documentType,
												templateConfigDocId: '',
												submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

											});
											this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
											showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
										}

										fileField.reset();
									}

								}, isTransient);
							}else{
								fileField.reset();
								showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
							}
						}
					}else{
						fileField.reset();
						showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					}
				},
				/**
				 * Remove entry from grid
				 */
				deleteDashletStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
					var grid = view.up('#studentdashletStaticDocumentAttachmentGridMessage');
					var panel = this.getContentPanel().getActiveTab();
					var tabTitle = panel.title;
					var store = grid.getStore();
					var templateConfigDocId = record.get('templateConfigDocId');
					var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
					if(!(tabTitle == viewTitle)){
						if(!isNullOrEmpty(templateConfigDocId)){
							showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
								if (btn == 'yes') {
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.STATIC_DOC_DELETE,
										method: 'DELETE',
										params: {
											templateConfigDocId : templateConfigDocId
										},
										headers: {
											'Content-Type': 'application/json'
										},
										success: function(form, action) {
											store.remove(record);
											showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
										}
									});
								}
							});

						}else{
							store.remove(record);
							showSuccessMessage(getPersonModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
						}
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
					}

				},
				/**
				 * This method is to enable schedule field
				 */
				loadApplicantScheduleField : function(radio,newValue, oldValue){
					var adhocMessageForm = radio.up('form');
					var scheduleDateField = adhocMessageForm.down('#scheduleDate');
					var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
					var radioValue = radio.getValue().sendingPriority;

					if(radioValue=='IMMEDIATE'){
						scheduleDateField.setVisible(false);
						scheduleDateField.setDisabled(true);
						scheduleTimeField.setVisible(false);
						scheduleTimeField.setDisabled(true);    		
					}
					else if(radioValue=='SCHEDULE'){
						scheduleDateField.setVisible(true);
						scheduleDateField.setDisabled(false);
						scheduleTimeField.setVisible(true);
						scheduleTimeField.setDisabled(false);
					}
				},
				/*openApplicantSendMessage:function(obj){
		    	//var grid = this.getSearchresultgrid();
		    	var grid = obj.up('grid');
		    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
		    	if(grid.getSelectionModel().getCount()>0) {

		    			var $this=this;
		    			var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		    	       	   var structure = Ext.widget('applicantsendmessage',{
	               			itemId:'applicationSendMessageWindow',
	               			//customGridId: grid.itemId
	               		});
		    	       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
				 *//**
				 * This is to remove tab from content panel and open same tab again
				 *//*
		    	       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
		    	       	   var getTab=getcontroller.getTab(tabName);
		    	       	   if(getTab!=null){
		    	       		   contentPanel.remove(getTab, true);
		    	       	   }
		    	       	var formWindowTab = $this.getStudentsendmessagewindowdashlet();
		    	       	formWindowTab.down("#selectTemplate").allowBlank=true;
		    	       	formWindowTab.down("#selectTemplate").setVisible(false);
		    	       	formWindowTab.down("#messageName").allowBlank=true;   
		    	       	formWindowTab.down("#messageName").setVisible(false);
		    			var templateStore = formWindowTab.down('#selectTemplate').getStore();
		    			templateStore.getProxy().extraParams={
		    				msgRecipientTypeId:10
		    			};
		    			templateStore.load();

		    			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		    			   Ext.Ajax.request({
		    				   method : "GET",
		    				   type : 'rest',
		    				   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=EnquirerTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
		    				   headers : {
		    					   'Content-Type' : 'application/json'
		    				   },
		    				   success : function(form,action) {
		    					   var data = Ext.JSON.decode(form.responseText);
		    					   formWindowTab.down("#id").setValue(data.id);
		    					   formWindowTab.down("#code").setValue(data.code);
		    					   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
		    					   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
		    					   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
		    					   Ext.getBody().unmask();

		    					   //grid.getStore().reload();
		    					   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
		    				   }

		    			   });
		    	       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_ONE);
		    			if (!formWindow) {
		    				Ext.widget('applicantsendmessage');
		    				formWindow = $this.getStudentsendmessagewindowdashlet();
		    			}
		    			formWindow.show(;

		    	} else {
		    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		    	}
		    },*/
				/**
				 * save document file. It's external call method
				 * @param entityId : person id, It's mandatory. 
				 * @param module : module name, for student module 'student', It's mandatory.
				 * @param entityType : entity type, It's mandatory.
				 * @param documentType : document type, It's mandatory.
				 * @param isTransient : true or false (send json back to module controller or not)
				 * @param callBackFunction : callback function return in module controller. It's mandatory.
				 */
				saveApplicantStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
					var submitUrl = '';
					var templateTab = this.getContentPanel();
					var formWin =  this.getStudentsendmessagewindowdashlet();
					var form = formWin.down('#msgDetailsForm');
					var id = form.down('#document_hidden_field');
					if (isNullOrEmpty(id.getSubmitValue())) {
						submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
					}
					var data = new Object();
					if(!isNullOrEmpty(entityId)){
						data.entityId = entityId;
					}else{
						data.entityId = null;
					}
					if(!isNullOrEmpty(module)){
						data.module = module;
					}else{
						data.module = null;
					}
					if(!isNullOrEmpty(entityType)){
						data.entityType = entityType;
					}else{
						data.entityType = null;
					}
					form.getForm().setValues(data);
					form.getForm().submit({
						method : 'POST',
						url : submitUrl,
						success : function(form, action){
							callBackFunction(true, action, isTransient);

						}
					});
				},
				/**
				 * Add value to grid
				 */
				loadGridWithFileNameMessage:function(grid,value,store){
					grid.bindStore(store);
				},
				openMarkedAttendanceStructure : function(rec) {
					this$=this;
					var contentPanel = this.getContentPanel();
					var attendancestructure = this.getPendingsearchattendance();
					var pendingStructure = this.getPendingdetailswindow();
					var academyLocationId = this.getCurrentAcademyLocation();
					var selectedAttendance = attendancestructure.down('#attendanceSearchId').getValue();
					var val = selectedAttendance['attendanceDetials'];
					var attendanceDate="";
					var backDate="";
					var portalId = this.getCurrentLoggedPortalId();
					var attendanceType=pendingStructure.down('#attendanceTypeId').getValue();
					var facultyDateGrid = this.getPendingattendancedatesgrid();
					var selectedRecord = facultyDateGrid.getSelectionModel().getSelection()[0];
					attendanceDate=rec.data.date;
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						url : SERVERURL.CHECK_ALLOWED_BACK_DATE,
						params : {
							academyLocationId : academyLocationId,
							portalId : portalId,
							attendanceDate : Ext.Date.format(new Date(attendanceDate), 'Y-m-d'),
							attendanceType : attendanceType
						},
						method : 'GET',
						success : function(f, action) {
							var data = Ext.JSON.decode(f.responseText);
							if(data.id == null)
							{
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('BACK_DATE_ATTENDANCE_CAPTURE')+data.backDateAllowed+getProgramandcourseTranslation('CALENDAR_DAYS'));
							}else{
								var structure = Ext.widget('markattendancemasterstructure');
								var tabName = getMegaMenuTranslation('PC_PERIOD_EXECUTION_ATTENDENCE');
								var getcontroller= Academia.app.getController('menu.CoreERPNavigationController');
								var getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentPanel.remove(getTab, true);
								}
								openTab(contentPanel, tabName, structure);

								Ext.defer(function() {
									var attendanceController = Academia.app.getController('Academia.controller.attendance.AttendanceController')
									if(attendanceType == 'COURSE_LEVEL'){
										this$.fillCourseWiseSearchFormValues(attendanceController,attendanceType,true);
									}else{
										this$.fillSearchFormValues(attendanceController,attendanceType);
									}
								},2000);
							}
						}});
				},
				OnfacultyPortalfillSearchFormValues : function(attendanceController,attendanceType){
					var $this =  this;
					var this$ = attendanceController;
					var academyLocationId = this.getCurrentAcademyLocation();
					var pendingStructure = this.getPendingdetailswindow();
					var dateGrid = this.getPendingattendancedatesgrid();
					var dateRecords = dateGrid.getSelectionModel().getSelection();
					var portalId = this.getCurrentLoggedPortalId();
					var facultyId = this.getCurrentlyLoggedInUser().id;
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					if(attendanceType=="COMPLETE_DAY"){
						var sectionId = pendingStructure.down('#sectionId').getValue();
						var programWiseSearch = this$.getProgramwisecaptureattendancesearch();
						var programByAcademyLocationStore = programWiseSearch.down('#facultyAttendanceProgramId').getStore();
						programByAcademyLocationStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							facultyId:facultyId,
							onlyCurrentRecords:true,
							wheatherSchool:wheatherSchool
						};
						programByAcademyLocationStore.load({
							callback: function(records, operation, success) {
								if (success) {
									Ext.defer(function(){
										var record = programByAcademyLocationStore.findRecord('sectionId', sectionId).data;
										programWiseSearch.down('#facultyAttendanceProgramId').setValue(record.sectionId);
										var dateField = programWiseSearch.down('#completeDayDate_Id');
										dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
										this$.loadCaptureAttendanceStudentGrid();
									}, 500, this);
								}
							}
						});
					}  else if(attendanceType=='MULTIPLE_SESSION'){
						var sectionId = pendingStructure.down('#sectionId').getValue();
						var sessionWiseSearch = this$.getMultiplesessionwisecaptureattendancesearch();
						var programByAcademyLocationStore = sessionWiseSearch.down('#session_programBatch_programId').getStore();
						programByAcademyLocationStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							facultyId:facultyId,
							onlyCurrentRecords:true
						};
						programByAcademyLocationStore.load({
							callback: function(records, operation, success) {
								if (success) {
									Ext.defer(function(){
										var record = programByAcademyLocationStore.findRecord('sectionId', sectionId).data;
										sessionWiseSearch.down('#session_programBatch_programId').setValue(record.sectionId);
										var dateField = sessionWiseSearch.down('#session_dateOfAttendance_Id');
										dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
										this$.loadCaptureAttendanceStudentGrid();
									}, 500, this);
								}
							}
						});
					} else if(attendanceType=='COURSE_LEVEL') {
						Ext.defer(function(){
							var attendanceTypess = Academia.model.authentication.AttendanceSettingModel;
							var backDaysAllowed = attendanceTypess.data.COURSE_LEVEL.backDateAllowedForFaculty;
							var courseVariantId = pendingStructure.down('#courseVariantId').getValue();
							var courseWiseSearch = this$.getCoursewisecaptureattendancesearch();
							var courseVariantStore = courseWiseSearch.down('#courseVariantId').getStore();
							var academicTermId = courseWiseSearch.down('#academicTerm').getValue();
							if(isNullOrEmpty(academicTermId)){
								academicTermId = courseVariantStore.getProxy().extraParams;
							}
							courseVariantStore.getProxy().extraParams = {
								academicTermId: academicTermId,
								academyLocationIds:academyLocationId,
								facultyId:facultyId,
								isCurrentPeriod:true
							};
							courseVariantStore.load({
								callback: function(records, operation, success) {
									if (success && records.length) {
										Ext.defer(function(){
											var record = courseVariantStore.findRecord('id', courseVariantId).data;
											courseWiseSearch.down('#courseVariantId').setValue(record.id);
											var dateField = courseWiseSearch.down('#dateOfAttendance_Id');
											var timeSlotField = courseWiseSearch.down('#timetableSlotListId');
											dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
											timeSlotFieldStore = timeSlotField.getStore();
											timeSlotFieldStore.getProxy().extraParams = {
												courseVariantId:courseVariantId,
												facultyId:facultyId,
												backDaysAllowed:backDaysAllowed
											};
											timeSlotFieldStore.load({
												callback: function(records, operation, success) {
													if (success) {
														timeSlotField.setDisabled(false);
														setTimeout(function(){
															var tsRecord = timeSlotFieldStore.findRecord('id',dateRecords[0].data.programId);
															var tsId = [tsRecord];
															timeSlotField.setValue(tsId);
															timeSlotField.setValue(tsId);

															//----------
															var facultyCaptureAttendanceController = this$.getController('facultyportal.attendance.FacultyCaptureAttendanceController');
															var form=facultyCaptureAttendanceController.getCoursewisecaptureattendancesearch();
															form.down('#fromTime').clearValue();
															form.down('#toTime').clearValue();
															form.down('#dateOfAttendance_Id').setDisabled(true);
															form.down('#fromTime').setDisabled(true);
															form.down('#toTime').setDisabled(true);
															form.down('#fromTime').allowBlank=true;
															form.down('#toTime').allowBlank=true;
															form.down('#dateOfAttendance_Id').allowBlank=true;
															form.down('#timeBtnAdd').setDisabled(true);

															//----------
															this$.loadCaptureAttendanceStudentGrid();
														},1000);
													}
												}
											});
										}, 500, this);
									}
								}
							});
						},500, this);
					}
				},
				fillSearchFormValues : function(attendanceController,attendanceType){
					var $this =  this;
					var this$ = attendanceController;
					var academyLocationId = this.getCurrentAcademyLocation();
					var grid = this.getPendingattendancegrid();
					var dateGrid = this.getPendingattendancedatesgrid();
					var records = grid.getSelectionModel().getSelection();
					var dateRecords = dateGrid.getSelectionModel().getSelection();
					var portalId = this.getCurrentLoggedPortalId();
					var facultyId = null;
					if(portalId == 2){
						facultyId = this.getCurrentlyLoggedInUser().id;
					}
					var attendanceTypeRadio=this$.getStudentpncattendancestructure().down('#attendanceTypeRadio');
					if(attendanceType=="COMPLETE_DAY"){
						attendanceTypeRadio.items.items[0].setValue(true);
						attendanceTypeRadio.items.items[1].setValue(false);
						attendanceTypeRadio.items.items[2].setValue(false);
					} else if(attendanceType=="MULTIPLE_SESSION"){
						attendanceTypeRadio.items.items[0].setValue(false);
						attendanceTypeRadio.items.items[1].setValue(false);
						attendanceTypeRadio.items.items[2].setValue(true);
					} else if(attendanceType=="COURSE_LEVEL"){
						attendanceTypeRadio.items.items[0].setValue(false);
						attendanceTypeRadio.items.items[1].setValue(true);
						attendanceTypeRadio.items.items[2].setValue(false);

					}
					if(!isNullOrEmpty(records[0].data.programId) && records[0].data.programId>0){
						var programId = records[0].data.programId;
						var batchId = records[0].data.batchId;
						var periodId = records[0].data.periodId;
						var sectionId = records[0].data.sectionId;
						var form = this$.getStudentattendance().getForm();
						var programField =  form.findField('programId');
						var batchField =  form.findField('batchId');
						var periodField =  form.findField('periodId');
						var sectionField =  form.findField('sectionId');
						var dateField = form.findField('dateOfAttendance');
						var sessionField = form.findField('sessionNo');
						dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
						var multipleSessionStore = $this.getStore('attendance.MultipleSessionValueStore');
						multipleSessionStore.getProxy().extraParams = {
							type:"multipleSession"
						};
						multipleSessionStore.load({
							callback: function(rec, operation, success) {
								if (rec.length > 0) {
									for (s=0;s<rec.length;s++) {
										if(dateRecords[0].data.sessionNo == rec[s].data.code) {
											sessionField.setValue(rec[s].data.code);
										} else {
											sessionField.setValue(dateRecords[0].data.sessionNo);
										}
									}
								} else {
									sessionField.setValue(1);
								}
							}
						});
						var facultyField = form.findField('facutly');

						var programStore =  programField.getStore();
						var batchStore =  batchField.getStore();
						var periodStore =  periodField.getStore();
						var sectionStore = sectionField.getStore();
						programField.setDisabled(false);
						batchField.setDisabled(false);
						periodField.setDisabled(false);
						sectionField.setDisabled(false);
						programStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							facultyId:facultyId
						};
						programStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for(var i = 0 ;i<=records.length-1;i++){
										if(programId == records[i].data.id){
											programField.setValue(programId);
											batchStore.getProxy().extraParams = {
												id: records[i].get('id'),
												isActive:true
											};
											batchStore.load({
												callback: function(records, operation, success) {
													if (success) {
														for(var i = 0 ;i<=records.length-1;i++){
															if(batchId == records[i].data.id){
																batchField.setValue(batchId);
																periodStore.getProxy().extraParams = {
																	id: records[i].get('id'),
																	isCurrentPeriod:true
																};
																periodStore.load({
																	callback: function(records, operation, success) {
																		if (success) {
																			for(var i = 0 ;i<=records.length-1;i++){
																				if(periodId == records[i].data.id){
																					periodField.setValue(periodId);
																					sectionStore.getProxy().extraParams = {
																						periodId: records[i].get('id'),
																						facultyId:facultyId
																					};
																					sectionStore.load({
																						callback: function(records, operation, success) {
																							if (success) {
																								for(var i = 0 ;i<=records.length-1;i++){
																									if(sectionId == records[i].data.sectionId){
																										sectionField.setValue(sectionId);
																										facultyField.setValue(records[i].data.facultyId);
																										form.findField('facutlyList').setDisabled(false);
																										this$.facultyList();
																										if(form.isValid()){
																											setTimeout(function(){
																												this$.getStudentattendance().down('#searchBtn').setDisabled(false);
																											},300);
																											this$.searchStudentsGrid();
																										}
																									}
																								}
																							}
																						}
																					});
																				}
																			}
																		}
																	}
																});
															}
														}
													}
												}
											});
										}
									}
								}
							}
						});
					} else if (!isNullOrEmpty(records[0].data.courseId) && records[0].data.courseId>0){
						var timeSlots = timeRender(dateRecords[0].data.fromDateTime)+" - "+timeRender(dateRecords[0].data.toDateTime);
						var timeSlotId = dateRecords[0].data.courseCoveragePlanId;
						var attendanceMarkedBy = null;
						if(dateRecords[0].data.facultyId > 0){
							attendanceMarkedBy = dateRecords[0].data.facultyId;
						}
						var courseId = records[0].data.courseId;
						var courseVariantId = records[0].data.courseVariantId;
						var componentId = records[0].data.componentId;
						var form = this$.getStudentattendance().getForm();
						var courseField = form.findField('courseId');
						var dateField = form.findField('dateOfAttendance');
						dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
						var courseVariantField = this$.getStudentattendance().down('#courseVariantId');
						var courseStore = courseField.getStore();
						courseStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							isCurrentPeriod:true
						};
						courseStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for(var i = 0 ;i<=records.length-1;i++){
										if(records[i].data.courseId==courseId){
											courseField.setValue(courseId);
											this$.courseNprogramSection(null,courseId, timeSlotId, attendanceMarkedBy, courseVariantId, componentId);
											this$.loadCourseTopics(courseId);
										}
									}
								}
							}
						});
					}
				},
				academicTermSelection : function(form, academicTermId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var intakeYearField = form.down('#courseWiseIntakeYearId');
					var courseField = form.down('#courseWiseCourseId');
					var courseVariantField = form.down('#courseWiseCourseVariantId');
					var facultyeField = form.down('#courseWiseFacultyId');
					var attendanceField = form.down('#courseWiseAttendanceStatusId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#endDate');
					var programCategoryField = form.down('#courseWiseProgramCategoryId');
					var programField = form.down('#courseWiseProgramId');
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');

					intakeYearField.reset();
					courseField.reset();
					courseVariantField.reset();
					facultyeField.reset();
					startDateField.reset();
					endDateField.reset();
					programCategoryField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();

					courseVariantField.setDisabled(true);
					batchField.setDisabled(true);
					periodField.setDisabled(true);

					var intakeYearStore = intakeYearField.getStore();
					intakeYearStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId
					};
					intakeYearStore.load();

					var programCategoryStore = programCategoryField.getStore();
					programCategoryStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId
					};
					programCategoryStore.load();

					var programStore = programField.getStore();
					programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						isCurrentPeriod : true
					};
					programStore.load();

					var facultyStore = facultyeField.getStore();
					facultyStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						isCurrentPeriod : true
					};
					facultyStore.load();

					var courseStore = courseField.getStore();
					courseStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						isCurrentPeriod : true
					};
					courseStore.load();
				},
				intakeYearSelection : function(form, intakeYearId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermId = form.down('#courseWiseAcademicTermId').getValue();
					var courseField = form.down('#courseWiseCourseId');
					var courseVariantField = form.down('#courseWiseCourseVariantId');
					var facultyeField = form.down('#courseWiseFacultyId');
					var attendanceField = form.down('#courseWiseAttendanceStatusId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#endDate');
					var programCategoryField = form.down('#courseWiseProgramCategoryId');
					var programField = form.down('#courseWiseProgramId');
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');

					courseField.reset();
					courseVariantField.reset();
					facultyeField.reset();
					startDateField.reset();
					endDateField.reset();
					programCategoryField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();

					courseVariantField.setDisabled(true);
					batchField.setDisabled(true);
					periodField.setDisabled(true);
					var courseStore = courseField.getStore();
					courseStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						isCurrentPeriod : true
					};
					courseStore.load();

					var programCategoryStore = programCategoryField.getStore();
					programCategoryStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId
					};
					programCategoryStore.load();

					var facultyStore = facultyeField.getStore();
					facultyStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						isCurrentPeriod : true
					};
					facultyStore.load();

					var programStore = programField.getStore();
					programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						intakeYearId : intakeYearId,
						academicTermId : academicTermId,
						isCurrentPeriod : true
					};
					programStore.load();
				},
				courseSelection : function(form, courseId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermId = form.down('#courseWiseAcademicTermId').getValue();
					var intakeYearId = form.down('#courseWiseIntakeYearId').getValue();
					var courseField = form.down('#courseWiseCourseId');
					var courseVariantField = form.down('#courseWiseCourseVariantId');
					var facultyeField = form.down('#courseWiseFacultyId');
					var attendanceField = form.down('#courseWiseAttendanceStatusId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#endDate');
					var programCategoryField = form.down('#courseWiseProgramCategoryId');
					var programField = form.down('#courseWiseProgramId');
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');

					courseVariantField.reset();
					facultyeField.reset();
					startDateField.reset();
					endDateField.reset();
					programCategoryField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();

					courseVariantField.setDisabled(false);
					batchField.setDisabled(true);
					periodField.setDisabled(true);

					var courseVariantStore = courseVariantField.getStore();
					courseVariantStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						courseId : courseId,
						isCurrentPeriod : true
					};
					courseVariantStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length==1){
									courseVariantField.setValue(records[0].get('id'));
								} else {
									var programStore = programField.getStore();
									programStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										academicTermId : academicTermId,
										intakeYearId : intakeYearId,
										courseId : courseId,
										isCurrentPeriod : true
									};
									programStore.load();

									var facultyStore = facultyeField.getStore();
									facultyStore.getProxy().extraParams = {
										academyLocationIds : academyLocationId,
										academicTermId : academicTermId,
										intakeYearId : intakeYearId,
										courseId : courseId,
										isCurrentPeriod : true
									};
									facultyStore.load();
								}
							}
						}
					});
				},
				courseVariantSelection : function(form, courseVariantId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermId = form.down('#courseWiseAcademicTermId').getValue();
					var intakeYearId = form.down('#courseWiseIntakeYearId').getValue();
					var courseId = form.down('#courseWiseCourseId').getValue();
					var courseVariantField = form.down('#courseWiseCourseVariantId');
					var facultyeField = form.down('#courseWiseFacultyId');
					var attendanceField = form.down('#courseWiseAttendanceStatusId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#endDate');
					var programCategoryField = form.down('#courseWiseProgramCategoryId');
					var programField = form.down('#courseWiseProgramId');
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');

					facultyeField.reset();
					startDateField.reset();
					endDateField.reset();
					programCategoryField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();

					batchField.setDisabled(true);
					periodField.setDisabled(true);

					var facultyStore = facultyeField.getStore();
					facultyStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						courseId : courseId,
						courseVariantId : courseVariantId,
						isCurrentPeriod : true
					};
					facultyStore.load();

					var programStore = programField.getStore();
					programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						courseId : courseId,
						courseVariantId : courseVariantId,
						isCurrentPeriod : true
					};
					programStore.load();

				},
				courseWiseProgramSelection : function(form, programId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermId = form.down('#courseWiseAcademicTermId').getValue();
					var intakeYearId = form.down('#courseWiseIntakeYearId').getValue();
					var courseId = form.down('#courseWiseCourseId').getValue();
					var courseVariantId = form.down('#courseWiseCourseVariantId').getValue();
					var facultyeId = form.down('#courseWiseFacultyId').getValue();
					var attendanceId = form.down('#courseWiseAttendanceStatusId').getValue();
					var startDateId = form.down('#startDate').getValue();
					var endDateId = form.down('#endDate').getValue();
					var programCategoryId = form.down('#courseWiseProgramCategoryId').getValue();
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');

					batchField.reset();
					periodField.reset();

					batchField.setDisabled(false);
					periodField.setDisabled(true);

					var batchStore = batchField.getStore();
					batchStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						courseId : courseId,
						programId : programId,
						isCurrentPeriod : true
					};
					batchStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length==1){
									batchField.setValue(records[0].get('id'));
								}
							}
						}
					});
				},
				courseWiseBatchSelection : function(form, batchId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermId = form.down('#courseWiseAcademicTermId').getValue();
					var intakeYearId = form.down('#courseWiseIntakeYearId').getValue();
					var courseId = form.down('#courseWiseCourseId').getValue();
					var courseVariantId = form.down('#courseWiseCourseVariantId').getValue();
					var facultyeId = form.down('#courseWiseFacultyId').getValue();
					var attendanceId = form.down('#courseWiseAttendanceStatusId').getValue();
					var startDateId = form.down('#startDate').getValue();
					var endDateId = form.down('#endDate').getValue();
					var programCategoryId = form.down('#courseWiseProgramCategoryId').getValue();
					var programId = form.down('#courseWiseProgramId').getValue();
					var periodField = form.down('#courseWisePeriodId');

					periodField.reset();
					periodField.setDisabled(false);

					var periodStore = periodField.getStore();
					periodStore.getProxy().extraParams = {
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						programId : programId,
						batchId : batchId,
						isCurrentPeriod : true
					};
					periodStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length==1){
									periodField.setValue(records[0].get('id'));
								}
							}
						}
					});
				},

				programCategorySelection : function(form, programCategoryId){
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermId = form.down('#courseWiseAcademicTermId').getValue();
					var intakeYearId = form.down('#courseWiseIntakeYearId').getValue();
					var courseId = form.down('#courseWiseCourseId').getValue();
					var courseVariantId = form.down('#courseWiseCourseVariantId').getValue();
					var facultyeId = form.down('#courseWiseFacultyId').getValue();
					var attendanceId = form.down('#courseWiseAttendanceStatusId').getValue();
					var startDateId = form.down('#startDate').getValue();
					var endDateId = form.down('#endDate').getValue();
					var programField = form.down('#courseWiseProgramId');
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');

					programField.reset();
					batchField.reset();
					periodField.reset();

					batchField.setDisabled(true);
					periodField.setDisabled(true);

					var programStore = programField.getStore();
					programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						academicTermId : academicTermId,
						intakeYearId : intakeYearId,
						courseId : courseId,
						courseVariantId : courseVariantId,
						programCategoryId : programCategoryId,
						isCurrentPeriod : true
					};
					programStore.load();
				},

				courseWiseFormReset : function(form){
					var $this = this;
					var academyLocationId = this.getCurrentAcademyLocation();
					var academicTermField = form.down('#courseWiseAcademicTermId');
					var intakeYearField = form.down('#courseWiseIntakeYearId');
					var courseField = form.down('#courseWiseCourseId');
					var courseVariantField = form.down('#courseWiseCourseVariantId');
					var facultyeField = form.down('#courseWiseFacultyId');
					var attendanceField = form.down('#courseWiseAttendanceStatusId');
					var startDateField = form.down('#startDate');
					var endDateField = form.down('#endDate');
					var programCategoryField = form.down('#courseWiseProgramCategoryId');
					var programField = form.down('#courseWiseProgramId');
					var batchField = form.down('#couseWiseBatchId');
					var periodField = form.down('#courseWisePeriodId');
					var moreField = form.down('#moreDetailId');

					academicTermField.reset();
					intakeYearField.reset();
					courseField.reset();
					courseVariantField.reset();
					facultyeField.reset();
					attendanceField.reset();
					startDateField.reset();
					endDateField.reset();
					programCategoryField.reset();
					programField.reset();
					batchField.reset();
					periodField.reset();

					moreField.collapse(true);
					courseVariantField.setDisabled(true);
					batchField.setDisabled(true);
					periodField.setDisabled(true);

					form.down("#courseWiseAttendanceStatusId").setValue('PENDING');
					var academicTermStore = academicTermField.getStore();
					academicTermStore.getProxy().extraParams = {
						academyLocationIds:academyLocationId,
						onlyCurrentRecord:true
					};
					academicTermStore.load({
						callback: function(record, operation, success) {
							if (success) {
								if(record.length>0){
									var tabAcademicTerm = null;
									Ext.each(record, function(value) {
										if(value.get('sequence') == '1'){
											academicTermField.setValue(value.get('id'));
										}
									});
								}
							}
						}
					});

					var courseStore = courseField.getStore();
					courseStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						isCurrentPeriod : true
					};
					courseStore.load();

					var facultyStore = facultyeField.getStore();
					facultyStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						isCurrentPeriod : true
					};
					facultyStore.load();

					var programCategoryStore = programCategoryField.getStore();
					programCategoryStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId
					};
					programCategoryStore.load();

					var programStore = programField.getStore();
					programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId,
						isCurrentPeriod : true
					};
					programStore.load();
				},

				courseWiseRecordSearch : function(form){
					var $this = this;
					var academyLocationId = this.getCurrentAcademyLocation();
		       		form.down('#courseWisesearchBtnId').setDisabled(true);
					var courseWiseSearchForm = form.getForm();
					var attendanceReportGrid = $this.getPendingattendancecoursewisereportgrid();
					var attendancePendingGrid = $this.getPendingattendancecoursewisegrid();
					var reportGridStore = attendanceReportGrid.getStore();
					var attendancePendingGridStore = attendancePendingGrid.getStore();
					var values = courseWiseSearchForm.getValues();

					if(values.courseWiseAttendanceStatus == 'PENDING'){
						attendancePendingGridStore.removeAll();
						attendancePendingGridStore.getProxy().extraParams = {
							academyLocationId : academyLocationId,
							academicTermId : values.courseWiseAcademicTerm,
							intakeYearId : values.courseWiseIntakeYear,
							courseId : values.courseWiseCourseName,
							courseVariantId : values.courseWiseCourseVariant,
							facultyId : values.courseWiseFaculty,
							attendanceStatus : values.courseWiseAttendanceStatus,
							programCategoryId : values.courseWiseProgramCategory,
							programId : values.courseWiseProgram,
							batchId : values.couseWiseBatch,
							periodId : values.courseWisePeriod,
							fromDate : values.startDate,
							toDate : values.endDate,
							attendanceMarked : false
						};

						attendancePendingGridStore.load({
							callback: function(record, operation, success) {
								if (success) {
			       					form.down('#courseWisesearchBtnId').setDisabled(false);
									if(record.length == 0){
										if(!isNullOrEmpty(attendancePendingGrid)){
											//attendancePendingGridStore.removeAll();
											try {
												// attendancePendingGrid.down('custompagingtoolbar').hide();
											}
											catch(e){
											}
										}
									}
								}
							}
						});
						attendancePendingGrid.config.searchFilterForm = form;
					}else{
						if(!isNullOrEmpty(attendancePendingGrid)){
							//attendancePendingGridStore.removeAll();
							try {
								//attendancePendingGrid.down('custompagingtoolbar').hide();
							}
							catch(e){
							}
						}
					}

					reportGridStore.removeAll();
					reportGridStore.getProxy().api.read=SERVERURL.STUDENT_PENDING_ATTENDANCE_COURSE_LEVEL;
					reportGridStore.getProxy().extraParams = {
						academyLocationId : academyLocationId,
						academicTermId : values.courseWiseAcademicTerm,
						intakeYearId : values.courseWiseIntakeYear,
						courseId : values.courseWiseCourseName,
						courseVariantId : values.courseWiseCourseVariant,
						facultyId : values.courseWiseFaculty,
						attendanceStatus : values.courseWiseAttendanceStatus,
						programCategoryId : values.courseWiseProgramCategory,
						programId : values.courseWiseProgram,
						batchId : values.couseWiseBatch,
						periodId : values.courseWisePeriod,
						startDate : values.startDate,
						endDate : values.endDate
					};
					reportGridStore.load({
						callback: function(record, operation, success) {
							if (success) {
		       					form.down('#courseWisesearchBtnId').setDisabled(false);
								if(record.length == 0){
									if(!isNullOrEmpty(attendanceReportGrid)){
										//reportGridStore.removeAll();
										try {
											// attendanceReportGrid.down('custompagingtoolbar').hide();
										}
										catch(e){
										}
									}
								}
							}
						}
					});
					attendanceReportGrid.config.searchFilterForm = form;
				},
				openCourseWiseMarkedAttendanceStructure : function(rec) {
					this$=this;
					var contentPanel = this.getContentPanel();
					var attendancestructure = this.getPendingcoursewisesearchattendance();
					var pendingStructure = this.getPendingattendancestructure();
					var academyLocationId = this.getCurrentAcademyLocation();
					var selectedAttendance = attendancestructure.down('#attendanceSearchId').getValue();
					var val = selectedAttendance['attendanceDetials'];
					var attendanceDate="";
					var backDate="";
					var portalId = this.getCurrentLoggedPortalId();
					var attendanceType=pendingStructure.down("#attendanceTypeRadio").getValue().attendanceTypeWise;
					var facultyDateGrid = this.getPendingattendancecoursewisegrid();
					var selectedRecord = facultyDateGrid.getSelectionModel().getSelection()[0];
					attendanceDate=rec.data.planDate;
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						url : SERVERURL.CHECK_ALLOWED_BACK_DATE,
						params : {
							academyLocationId : academyLocationId,
							portalId : portalId,
							attendanceDate : Ext.Date.format(new Date(attendanceDate), 'Y-m-d'),
							attendanceType : attendanceType
						},
						method : 'GET',
						success : function(f, action) {
							var data = Ext.JSON.decode(f.responseText);
							if(data.id == null)
							{
								showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('BACK_DATE_ATTENDANCE_CAPTURE')+data.backDateAllowed+getProgramandcourseTranslation('CALENDAR_DAYS'));
							}else{
								var structure = Ext.widget('markattendancemasterstructure');
								var tabName = getMegaMenuTranslation('PC_PERIOD_EXECUTION_ATTENDENCE');
								var getcontroller= Academia.app.getController('menu.CoreERPNavigationController');
								var getTab=getcontroller.getTab(tabName);
								if(getTab!=null){
									contentPanel.remove(getTab, true);
								}
								openTab(contentPanel, tabName, structure);

								Ext.defer(function() {
									var attendanceController = Academia.app.getController('Academia.controller.attendance.AttendanceController')
									this$.fillCourseWiseSearchFormValues(attendanceController,attendanceType,false);
								},2000);
							}
						}});
				},

				fillCourseWiseSearchFormValues : function(attendanceController,attendanceType, isAttendanceReportGrid){
					var $this =  this;
					var this$ = attendanceController;
					var academyLocationId = this.getCurrentAcademyLocation();
					var grid;
					var dateGrid;
					if(isAttendanceReportGrid){
						dateGrid = this.getPendingattendancedatesgrid();
					}else{
						grid = this.getPendingattendancecoursewisegrid();
						dateGrid = this.getPendingattendancecoursewisegrid();
					}
					//var records = grid.getSelectionModel().getSelection();
					var dateRecords = dateGrid.getSelectionModel().getSelection();
					var portalId = this.getCurrentLoggedPortalId();
					var facultyId = null;
					if(portalId == 2){
						facultyId = this.getCurrentlyLoggedInUser().id;
					}
					var attendanceTypeRadio=this$.getStudentpncattendancestructure().down('#attendanceTypeRadio');
					if(attendanceType=="COMPLETE_DAY"){
						attendanceTypeRadio.items.items[0].setValue(true);
						attendanceTypeRadio.items.items[1].setValue(false);
						attendanceTypeRadio.items.items[2].setValue(false);
					} else if(attendanceType=="MULTIPLE_SESSION"){
						attendanceTypeRadio.items.items[0].setValue(false);
						attendanceTypeRadio.items.items[1].setValue(false);
						attendanceTypeRadio.items.items[2].setValue(true);
					} else if(attendanceType=="COURSE_LEVEL"){
						attendanceTypeRadio.items.items[0].setValue(false);
						attendanceTypeRadio.items.items[1].setValue(true);
						attendanceTypeRadio.items.items[2].setValue(false);

					}
					if (!isNullOrEmpty(dateRecords[0].data.courseId) && dateRecords[0].data.courseId>0){
						var timeSlots;
						var timeSlotId;
						var courseId = dateRecords[0].data.courseId;
						var courseVariantId = dateRecords[0].data.courseVariantId;
						var componentId = dateRecords[0].data.componentId;
						var form = this$.getStudentattendance().getForm();
						var courseField = form.findField('courseId');
						var dateField = form.findField('dateOfAttendance');
						if(isAttendanceReportGrid){
							timeSlots = timeRender(dateRecords[0].data.fromTime)+" - "+timeRender(dateRecords[0].data.toTime);
							dateField.setValue(dateFormatRender(dateRecords[0].data.dateValue));
							timeSlotId = dateRecords[0].data.courseCoveragePlanId;
						}else{
							timeSlots = dateRecords[0].data.fromTime+" - "+dateRecords[0].data.toTime;
							dateField.setValue(dateFormatRender(dateRecords[0].data.sessionDate));
							timeSlotId = dateRecords[0].data.courseCoveragePlanId;
						}
						var attendanceMarkedBy = null;
						if(dateRecords[0].data.facultyId > 0){
							attendanceMarkedBy = dateRecords[0].data.facultyId;
						}
						var courseVariantField = this$.getStudentattendance().down('#courseVariantId');
						var academicTermField = this$.getStudentattendance().down('#academicTerm');

						courseVariantField.reset();
						var courseStore = courseField.getStore();
						courseStore.getProxy().extraParams = {
							academyLocationIds:academyLocationId,
							isCurrentPeriod:true
						};
						courseStore.load({
							callback: function(records, operation, success) {
								if (success) {
									for(var i = 0 ;i<=records.length-1;i++){
										if(records[i].data.courseId==courseId){
											courseField.setValue(courseId);
											this$.courseNprogramSection(null,courseId, timeSlotId, attendanceMarkedBy, courseVariantId, componentId);
											this$.loadCourseTopics(courseId);
										}
									}
								}
							}
						});
					}
				},


});
