/**

 * This BaseController has most of the methods which will be used across the application,
 * you are free to override any of its method if required.
 * 
 * [NOTE: DO NOT ADD/EDIT ANY METHODS WITHOUT DISCUSSION WITH E-ZEST DEVELOPMENT TEAM]
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.controller.base.BaseController', {
    extend: 'Ext.app.Controller',
    init: function() {
        this.control({
        	'idgeneratorcustomform' :{
        		afterrender : this.formFieldItems
        	},
        	'dynamicfieldform' :{
        		afterrender : this.formFieldItems
        	},
        	'idgeneratorform':{
        		afterrender : this.formFieldItems
        	},
        	'opensectionsearch':{
        		afterrender : this.formFieldItems
        	},
        	'idgeneratorcustomform button[itemId=resetBtn]' :{
        		click : this.resetCustomForm
        	},
        	'dynamicfieldform button[itemId=resetBtn]' :{
        		click : this.resetCustomForm
        	},
        	'idgeneratorform button[itemId=resetBtn]' :{
        		click : this.resetCustomForm
        	},
        	'dynamicfieldformwin' :{
        		afterrender : this.formFieldWindowItems
        	},
        	'idgeneratorcustomformwin' :{
        		afterrender : this.formFieldWindowItems
        	},
        	'idgeneratorformwin' :{
        		afterrender : this.formFieldWindowItems
        	},
        	'idgeneratorcustomformwin button[itemId=resetBtn]' :{
        		click : this.resetCustomFormWindow
        	},
        	'dynamicfieldformwin button[itemId=resetBtn]' :{
        		click : this.resetCustomFormWindow
        	},
        	'idgeneratorformwin button[itemId=resetBtn]' :{
        		click : this.resetCustomFormWindow
        	},
        	'sendmessagewindow radiogroup#sendingPriority': {
        		change: function( radio, newValue, oldValue, eOpts) {
        			this.loadScheduleField(radio, newValue, oldValue);
        		}
        	},
        	'gridpanel' :{
        		beforerender: function(grid){
        			if(!isNullOrEmpty(grid.refreshStoreData)){
        				if(grid.getStore().getRange().length>0){
        					if(grid.refreshStoreData)
        						grid.getStore().removeAll();
        				}
        			}
        		}
        	},
        	 'searchresultgrid displayfield[itemId=totalCountDisplayField]':{
				 afterrender:function(totalCountDisplayField){
					 var resultUrl,$this = this,
					 grid = totalCountDisplayField.up('grid');
					 if(grid.up().xtype=='advancedsearchquerybuilder'){
						 resultUrl=SERVERURL.EXECUTEADVANCESEARCHCOUNT;
					 }else{
						 resultUrl = SERVERURL.EXECUTEBASICSEARCHCOUNT;
					 }
					 Ext.defer(function () {
						 if(totalCountDisplayField){
							 var el = totalCountDisplayField.getEl();
							 if (el) {
								 el.removeAllListeners();
								 el.on('click', function (event, target) {
									 if (target.tagName.toLowerCase() === 'a') {
										 event.stopEvent();
										 if(grid && grid.store && grid.store.proxy){
											 $this.getTotalRecordCountForCBGrid(grid,totalCountDisplayField,resultUrl,grid.store.proxy.jsonData);
										 }
									 }
								 },totalCountDisplayField,{ delegate: 'a' }); 
							 }
						 }
					 },100);
				 }
			 }
        });
        this.callParent(arguments);
    },

	getNestedObject:function(value){
		   if (value){
			    var object = new Object();
			    object.id = value;
			    return object;
		   }
	},
    /**
     * method to open a new tab with passed form within it
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    openTab: function(tabTitle, contentXType, menuColorcls,contentPanel, moduleName, isNavMenuClicked) {
    	var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
    	return coreErpNavigationController.addTab(tabTitle, contentXType, menuColorcls,contentPanel, null, null, moduleName, isNavMenuClicked);
    },
    
    /**
     * method to load controllers for xtype a new tab with passed form within it
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    loadContollers: function(panelXtype) {
		var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
		coreErpNavigationController.loadContollers(panelXtype);
    },
    /**
     * method to close the passed Tab
     * Any one reference can be passed.
     * @param {Object} windowAlias: alias of the Tab that has to be closed.
     * @param {Object} windowReference: reference of the Tab that has to be closed.
     */
    closeTab: function(tabReference) {
    	tabReference.close();
    },
    
    /**
     * This method is use to get the tab reference 
     * @param tabTitle title of the tab 
     */
    getTabReferenceByTabTitle:function(tabTitle) {
    	var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
    	return coreErpNavigationController.getTab(tabTitle);
    },
    
    getTabReferenceByTabXtype: function(tabXType) {
    	var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
    	return coreErpNavigationController.getTabByXtype(tabXType);
    },
    
    /**
     * method to get the content panels active tab reference.
     * @author akshay.kalbhor
     */
    getActiveTabfromContentPanel: function() {
    	var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
    	return coreErpNavigationController.getActiveTabfromContentPanel();
    },
    /**
     * method to open the passed form
     * @param {Object} windowReference: reference of the form that has to be opened.
     */
    showWindow: function(windowReference) {
    	if(Ext.isDefined(Ext.ComponentQuery.query(windowReference.toLowerCase())[0])){
    		this.closeFormWindow(Ext.ComponentQuery.query(windowReference.toLowerCase())[0]);
    	}
    	var formWindow = Ext.widget(windowReference.toLowerCase());
        formWindow.show();
        Ext.defer(function(){
        	formWindow.center();
        },50);
        
        var $this = this
        var form = formWindow.down('form');
        formWindow.body.on('click', function() {
        $this.hideInvalidIconFromField(form);
              });
        return formWindow;
    },
    
    /**
     * method to close the passed formWindow
     * @param {Object} windowAlias: alias of the window that has to be closed.
     * @param {Object} windowReference: reference of the form that has to be closed.
     */
    closeFormWindow: function(windowReference) {
    	if(windowReference != null || windowReference != undefined) {
        	windowReference.close();
        } 
    },
     
    /**
     * This function is used to set all items of form to read only mode.
     * @param {view} form: is the form that has to be changed to a readOnly mode,
     * @param {boolean} readOnly: is the boolean value, true to make readOnly,
     * false for setting the readOnly property to false.
     */
    toggleReadOnlyFormItems: function (form, readOnly) {
        Ext.suspendLayouts();
        
        try{
            // Apply or remove the read-only class to the form
            var formPanel = form.owner; // Assuming 'form' is form.getForm()
            if (readOnly) {
            	formPanel.addCls('readonly-form');  // Add the read-only class
            } else {
            	formPanel.removeCls('readonly-form');  // Remove the read-only class
            }
        }
        catch(e){
        	//---
        }
        
        
        form.getFields().each(function(field) {
        	if(field.xtype !== 'itemselector' && field.xtype != 'multiselectfield') {
        		field.setReadOnly(readOnly);	
        	} else {
        		field.setDisabled(true);
        	}
        });
        Ext.resumeLayouts();
    },
	  deleteEmptyFields:function(object){
		  for (var property in object) {
			  if(isNullOrEmpty(object[property])){
				  delete object[property];
			  }
			}
	  },
    /**
     * This method is checks or field and reset function in field.
     * if filed and reset function is present reset the field.
     * @author Rupesh.Agrawal
     * @param {Object} : field to be reset
     */
    checkkAndResetField:function(field){
    	if(field){
        	if(typeof field.reset != "undefined") {
        		field.reset();
        	}
    	}
    },
    
    removeField:function(field,remove){
    	field.setDisabled(remove);
    	field.setVisible(!remove);
    },
    
    /**
     * method to do the validation if the user has access to the records add/view/edit/delete functionality,
     * calls AccessControlManager's checkFeaturePrivelages() which returns a list of permissions.
     * @param {Object} the reference of the grid.
     */
    doAccessControlValidationWithCB: function(associatedAcadLocations, permissionsMap) {
		searchResultGrid = this.getSearchResultGrid();
		var associatedAcadLocationIds = new Array();

		Ext.each(associatedAcadLocations, function(acadLocation) {
			associatedAcadLocationIds.push(acadLocation.ACADEMY_LOCATION_ID);
		});
	
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		searchResultGrid.disableButtonsByPivileges(permissionList);
	},
	
	/**
     * method to do the validation if the user has access to the records add/view/edit/delete functionality,
     * calls AccessControlManager's checkFeaturePrivelages() which returns a list of permissions.
     * @param {Object} the reference of the grid.
     */
    genericCBGridAccessControlValidation: function(grid, permissionsMap) {
    	var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		grid.disableButtonsByPivileges(permissionList);
	},
    
    /**
     * method to do the validation if the user has access to the records add/view/edit/delete functionality,
     * calls AccessControlManager's checkFeaturePrivelages() which returns a list of permissions.
     * @param {Object} the reference of the grid.
     */
    doAccessControlValidation: function(grid, permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		this.disableButtonsByPivileges(permissionList, grid);
	},
	
	doAccessControlValidationForLoader: function(form, permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		this.disableLoaderButtonsByPivileges(permissionList, form);
	},
	
	onChangeUploadOptionRadioGroup : function(isUploadAll, grid, moduleName){
		var $this = this;
		var uploadedBy = null;
		if(!isUploadAll){
			uploadedBy = $this.getCurrentlyLoggedInUser().id;
		}
		grid.getStore().getProxy().extraParams = {
			moduleName: moduleName,
			uploadedBy:uploadedBy
		};
		$this.resetPageSetting(grid.getStore());
		grid.getStore().load();
	},
    
    /**
     * method to get the currently selected/default academy location.
     * @returns the value of the current academy location.
     */
	getCurrentAcademyLocation:function(){
		return Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue();
	},
	
	/**
     * method to get the currently accessible/default academy location.
     * @returns the value of the current academy location.
     */
	isAccessibleAcademyLocation:function(value){
		var isAccessible = false;
		if(!isNullOrEmpty(value)){
			var store = Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getStore();
			var index = store.find( 'id', value, 0, false, true, true);
			if(index != -1){
				isAccessible = true;
			}
		}
		return isAccessible;
		
	},
	
	 /**
	  * private method called internally from the doAccessControlValidation() method.
     * method to disable/hide the buttons in the toolbar according to the passed privilege level 
     * @param {Array} the max privilege level for the particular row, the values can be ADD, UPDATE, VIEW, DELETE or EXPORT  
     * @param {Object} the reference of the grid.
     */
    disableButtonsByPivileges: function(privilegeList, gridReference) {
    	buttonsToolBar = gridReference.query('toolbar')[0];
    	/*
    	 * querying the buttons and unhiding them if any.
    	 */
    	var buttons = buttonsToolBar.query('button');
    	Ext.each(buttons, function(button) {
    		button.setVisible(false);
    	});
    	Ext.each(privilegeList, function(privilege) {
    		if (privilege === 'CREATE') {
        		var button = buttonsToolBar.query('#btnAdd')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		} else{
					var examCenterAddBtn = buttonsToolBar.query('#examCenterAddBtn')[0];
					if(!isNullOrEmpty(examCenterAddBtn)){
        				examCenterAddBtn.setVisible(true);
        			}
				}       		
    		} else if (privilege === 'UPDATE') {
        		var button = buttonsToolBar.query('#btnEdit')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		} else{
					var examCenterEditdBtn = buttonsToolBar.query('#examCenterEditdBtn')[0];
					if(!isNullOrEmpty(examCenterEditdBtn)){
        				examCenterEditdBtn.setVisible(true);
        			}
				} 
        	} else if (privilege === 'VIEW') {
        		var button = buttonsToolBar.query('#btnView')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		} else{
					var examCenterViewBtn = buttonsToolBar.query('#examCenterViewBtn')[0];
					if(!isNullOrEmpty(examCenterViewBtn)){
        				examCenterViewBtn.setVisible(true);
        			}
				} 
        	} else if (privilege === 'DELETE') {
        		var button = buttonsToolBar.query('#btnDelete')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	} else if (privilege === 'EXPORT') {
        		var buttonsArray = new Array();
        		buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
        		buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
        		buttonsArray.push(buttonsToolBar.query('#btnExportToCSV')[0]);
        		Ext.each(buttonsArray, function(button) {
        			if(!isNullOrEmpty(button)){
            			button.setVisible(true);
            			if(gridReference.xtype == 'bulkExamResultPublishGrid') {
            				gridReference.removeCls('bulk-exam-result-publish-grid');
            			}
            		}  
        		});
        	}else if (privilege === 'EDIT' || privilege ==='ENTER_REMARK') {
        		var button = buttonsToolBar.query('#btnEdit')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'PRINT') {
        		var button = buttonsToolBar.query('#btnPrint')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'SAVE') {
        		var button = buttonsToolBar.query('#btnSaveItemId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'EXPORTREPORTS') {
        		var button = buttonsToolBar.query('#exportReportItemId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'UpdateAttendance') {
        		var button = buttonsToolBar.query('#updateAttendanceItemId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'VIEW_DETAILS') {
        		var button = buttonsToolBar.query('#btnView')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === 'MAPPROGRAMDETAILS') {
        		var button = buttonsToolBar.query('#mapProgramBtn')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === 'COPY_BATCH') {
        		var button = buttonsToolBar.query('#btnCopyBatch')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === 'COPY_SETUP') {
        		var button = buttonsToolBar.query('#btnCopySetup')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === 'REQUESTEXAMCANCELLATIONBUTTON') {
        		var button = buttonsToolBar.query('#requestExamCancellationButtonId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === 'ENTER_EXTERNAL_COURSE_INSTITUTE') {
        		var button = buttonsToolBar.query('#addExternalCourseInstitute')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'EXPORTREPORTS') {
        		var button = buttonsToolBar.query('#exportReportsId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'RESET_GRADE_STATUS') {
        		var button = buttonsToolBar.query('#resetGradeStatusBtn')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === 'EXPORT_BARCODE_REPORT') {
        		var button = buttonsToolBar.query('#btnExportBarcodeReport')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
             else if (privilege === 'PRINT_EXCEL_TRANSCRIPT') {
        		var button = buttonsToolBar.query('#btnPrintTranscriptInExcelItemId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	} else if (privilege === 'REMOVE_FLAG') {
        		var button = buttonsToolBar.query('#btnRemoveFlag')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "UNLOCK_USER_ROLE") {
        		var button = gridReference.down('#UnlockUserRole');
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "LOCK_USER_ROLE") {
        		var button = gridReference.down('#lockUserRole');
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "APPROVE") {
        		var button = buttonsToolBar.query('#btnApprove')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        			if(!isNullOrEmpty(gridReference.down('#spBtnMoreActions'))){        				
        				gridReference.down('#spBtnMoreActions').setVisible(true);
        			}
        		}  
        	}else if (privilege === "APPLY_TO") {
        		var button = buttonsToolBar.query('#btnApplyTo')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        			if(gridReference.down('#spBtnMoreActions')){
        				gridReference.down('#spBtnMoreActions').setVisible(true);
        			}
        		}  
        	}else if (privilege === "APPLY_FOR_HOSTEL") {
        		var button = buttonsToolBar.query('#applyForHostel')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "APPLY_FOR_WAITING_LIST") {
        		var button = buttonsToolBar.query('#applyWaitingList')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "REVOKE_APPLICATION") {
        		var button = buttonsToolBar.query('#revokeApplication')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "ACTIVE_SCHOLARSHIP") {
        		var button = buttonsToolBar.query('#activateScholarshipStudent')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}else if (privilege === "TRANSFER_SCHOLARSHIP") {
        		var button = buttonsToolBar.query('#transferScholarshipApplicant')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if(privilege == "UNPUBLISH_MARKS_GRADE") {
        		var button = buttonsToolBar.query('#btnUnpublishMarksGrade')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
    		
        	else if(privilege == "SEND_DOCUMENT") {
        		var button = buttonsToolBar.query('#sendDocument')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
    		
        	else if(privilege == "REMOVE_WITHDRAWN_STATUS") {
        		var button = buttonsToolBar.query('#removeWithDrawnStatusId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if(privilege == "PERIOD_DE_ENROLL") {
        		var button = buttonsToolBar.query('#periodDeEnroll')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if(privilege == "QUICKCOMMENT") {
        		var button = buttonsToolBar.query('#quickCommentToFacultyRequestId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}else if(privilege == "RESET_PASSWORD") {
        		var button = buttonsToolBar.query('#resetPasswordId')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if(privilege == "MANAGE_REQUEST") {
        		var button = buttonsToolBar.query('#btnManageRequest')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if(privilege == "AUTO_APPROVE") {
        		var button = buttonsToolBar.query('#btnAutoApprove')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if(privilege == "CANCEL") {
        		var button = buttonsToolBar.query('#btnCancel')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if(privilege == "CHECK_HISTORY") {
        		var button = buttonsToolBar.query('#checkHistoryBtn')[0];
        		if(portalId == '2') {
        			button = buttonsToolBar.query('#checkHistoryBtnFP')[0];
        		}
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}
        	}
        	else if (privilege === "REJECT") {
        		var button = buttonsToolBar.query('#btnReject')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        	else if (privilege === "RESUBMIT") {
        		var button = buttonsToolBar.query('#btnResubmit')[0];
        		if(!isNullOrEmpty(button)){
        			button.setVisible(true);
        		}  
        	}
        });
    },
    disableLoaderButtonsByPivileges: function(privilegeList, form) {
    	var buttons = form.query('uploadoptionradiogroup')[0]
    	//buttonsToolBar = form.query('button')[0];
    	//var buttons = form.down("#userListUploadOptionRadioGroupItemId");
    	Ext.each(buttons, function(button) {
    		button.setVisible(false);
    	});
    	Ext.each(privilegeList, function(privilege) {
    		  if (privilege === 'VIEW') {
        		if(!isNullOrEmpty(buttons)){
        			buttons.setVisible(true);
        		}  
        	} 
    	});
    },

    /**
     * method to load the dependent grid on click of a record of a grid.
     * @param {Object} The reference of the dependentGrid to be loaded.
     * @param {String} The string value ie. the parameter that should be appended in the url for loading the grid.
     * @param {String} the url of the grid, Optional parameter that can be sent, if present then 
     * this url will be attached with the 'parameter' and the 'id' will be sent as its value.
     * 
     *  [NOTE:] this method removes all records from the store before reloading it.
     * 
     * ## Use of Parameter and Id
     * 		@example  
     * 		url = "rest/programSelectionProcess/findByCriteria",
     * 
     * 		we need url = "rest/programSelectionProcess/findByCriteria?programGroupId=1"
     * 		url = "rest/programSelectionProcess/findByCriteria?parameter=id"
     * Here parameter is "programGroupId" and id is "1"
     * 
     */
    loadComponentStore: function(component, parameter, id, url) {
    	var store = component.getStore();
    	if(isNullOrEmpty(url)) {
    		url = this.getUrlOfStore(store);
    	}
    	url = url.concat('?'+parameter+'='+id); 
    	store.getProxy().api.read = url;
    	store.reload();
    },
    /**
     * This method is used to get url from store.
     */
    getUrlOfStore:function(store){
    	var url = store.getProxy().url;
		if(isNullOrEmpty(url)) {
    		url = store.getProxy().proxyConfig.api.read;
    	}
		return url;
    },
    /**
	 * This method is use to send the request to server to save the form data.
	 * 
	 * @param url The url to save the data
	 * @param requestMethod Rest method type of the request
	 * @param submitData form data to be saved
	 * @param callbackFunction callback function  
	 * 
	 * example code to call this method from your controller:
	 *  this.sendSaveAjaxRequest(SERVERURL.SAVE_CERTIFICATE_REQUEST, 'POST', submitData, function(opt,success,response){
		  	if(success){
				Further code after success i.e to reload grid etc.
		  	}
	  		});
	 */
	sendSaveAjaxRequest:function(url,requestMethod,submitData,callback){
		Ext.Ajax.request({
			type:'rest',
			method:requestMethod,
			url:url,
			jsonData:submitData,
			callback:callback
		});
	},
	
	/**
     * This method is use to send the ajax request for GET methods to get the data from server.
     * 
   *  @param url The url to get the data
   * @param requestMethod Rest method type of the request
   * @param params parameters to find the data
   * @param callbackFunction callback function  
   * eg.  var param ={
	 			  requestId :requestId	
	           };
     */
     sendGetAjaxRequest:function(url,requestMethod,params,callback){      		
   	  Ext.Ajax.request({
 			type:'rest',
 			method:requestMethod,
 			url:url,
 			params:params,
 			callback:callback
 		});
 	},
 	
 /**
   * This method is used to send PDF request for dynamic PDF document download.  
   * 
   * @param url The url is pdf request url
   * @param params is parameters list object to send with this request       
 */
 	sendPDFDynamicDocumentRequest:function(url,params){      		
   	  
 		var csvForm = Ext.create('Ext.form.Panel',{
    		items:[{
    			xtype : 'textfield',
    			maxLength : 20480,
    			itemId : 'dynamicDocumentRequestContent',
    			name : 'dynamicDocumentRequestContent'
    		}]
    	});
    	                                    	
    	csvForm.down('#dynamicDocumentRequestContent').setValue(Ext.encode(params));
    	
    	csvForm.getForm().submit({
			target: 'download_frame',
		    method:'POST',
		    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		    headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                		  
		    url : url,
		    standardSubmit :true,
			failure: function(form, action) {
				var data = Ext.decode(form.responseText);
				if(data[0].key == 'PROVISIONAL_OFFER_PROCESS_NOT_OPENED') {
					showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('PROVISIONAL_OFFER_PROCESS_NOT_OPENED')); 
				}else if(data[0].key == 'cant_send_offer_letter_document_not_mapped') {
					   showWarningMessage(getCommonTranslation('ALERT'), getErrorTranslation('cant_send_offer_letter_document_not_mapped')); 
				}
			}
    	});      
 	},
 	
 	/**
 	   * This method is use to get the visible columns in any CB grid
 	   */
 	getVisibleColumns:function(grid){
		var visibleColumns=new Array();
		var columns=new Array();
		columns=grid.columnManager.columns;
		Ext.each(columns,function (column){
			if(column.data!=undefined && column.whetherExtra != true /*&& column.data.resultKey!='PERSON_IMAGE'*/){
			var visibleColumn=new Object();
			visibleColumn.resultKey=column.data.resultKey;
			visibleColumn.displayCode=column.text;
			visibleColumn.displayOrder=column.data.displayOrder;
			visibleColumns.push(visibleColumn);
			}
		});
		
		return visibleColumns;
	},
 	
  /**
   * This method is use to get the logged in user.
   */
 	getCurrentlyLoggedInUser:function() {
 		var userInfo = Academia.model.authentication.UserInfoModel;
 		var user = { 
 				id: userInfo.get('userId'),
 				value:userInfo.get('userName'),
 				code:userInfo.get('code')
 				//TODO:Please confirm with other while changing generic methods other functionality might break due to this.
 				//portalId:userInfo.get('portalId')
 				//personId: userInfo.get('personId')
 		};
 		return user;
 	},
 	/**
 	 * this method only for student portal login.
 	 */
 	getCurrentlyLoggedInUserInfoForPortal:function(){
 		var portalInfo =Academia.model.authentication.PortalInfoModel;
 		var userPortalInfo= { 
 				admissionDetails: portalInfo.get('admissionDetails'),
 				student:portalInfo.get('student'),
 				userAacademyLocations:portalInfo.get('userAacademyLocations'),
 				programBatchDetails:portalInfo.get('programBatchDetails'),
 				pastProgramBatchDetails:portalInfo.get('pastProgramBatchDetails')
 		};
 		return userPortalInfo;
 	},
 	/**
 	 * this method only for student portal login.
 	 */
 	getStudentDetailForErpPortal:function(){
 		var portalInfo =Academia.model.authentication.StudentERPInfoModel;
 		var userPortalInfo= { 
 				admissionDetails: portalInfo.get('admissionDetails'),
 				student:portalInfo.get('student'),
 				userAacademyLocations:portalInfo.get('userAacademyLocations'),
 				programBatchDetails:portalInfo.get('programBatchDetails'),
 				pastProgramBatchDetails:portalInfo.get('pastProgramBatchDetails')
 		};
 		return userPortalInfo;
 	},
 	
   /**
   * This method is use to get the logged in user.
   */
 	getCurrentlyLoggedInUserWithPersonId:function() {
 		var userInfo = Academia.model.authentication.UserInfoModel;
 		var user = { 
 				id: userInfo.get('userId'),
 				value:userInfo.get('userName'),
 				code:userInfo.get('code'),
 				personId: userInfo.get('personId')
 		};
 		return user;
 	},
 	
 	 /**
	   * This method is use to get the current loggedIn portal Id.
	   */
	 	getCurrentLoggedPortalId:function() {
	 		var userInfo = Academia.model.authentication.UserInfoModel;
	 		var portal =  userInfo.get('portalId');
	 		return portal;
	 	},
	 	
	 	
	 	/**
	     * This method is to enable schedule field
	     */
	    loadScheduleField : function(radio,newValue, oldValue){
	    	var adhocMessageForm = radio.up('form');
	    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	    	var radioValue = radio.getValue().sendingPriority;
	    	
	    	if(radioValue=='IMMEDIATE'){
	    		scheduleDateField.setVisible(false);
	    		scheduleDateField.setDisabled(true);
	    		scheduleTimeField.setVisible(false);
	    		scheduleTimeField.setDisabled(true);    		
	    	}
	    	else if(radioValue=='SCHEDULE'){
	    		scheduleDateField.setVisible(true);
	    		scheduleDateField.setDisabled(false);
	    		scheduleTimeField.setVisible(true);
	    		scheduleTimeField.setDisabled(false);
	    	}
	    },
 	
 	 /**
 	   * This method is use to download the reports based on jrxmls
 	   */
 	 /*exportJRXMLReport:function(code,reportParams,reportTitle,filetype){
     	
 		if(filetype=="pdf"){
 		exportUrl=SERVERURL.EXPORT_PDF_REPORT;//"/ReportDocumentResource/exportPdfReport";
 		}else{
 		exportUrl=SERVERURL.EXPORT_XCEL_REPORT;//"/ReportDocumentResource/exportXcelReport";
 		}
 		filetype="application/"+filetype;
 		
     	
     	  // This code is for GET request that open new tab to download file
     	 
     	//baseController = Academia.app.getController('Academia.controller.base.BaseController');
     	user=this.getCurrentlyLoggedInUser();
     	
     	var exportDocumentData =new Object();
     	exportDocumentData.code=code;
     	exportDocumentData.userId=user.code;
 		exportDocumentData.reportParams=reportParams;
     	exportDocumentData.academyLocationId=this.getCurrentAcademyLocation();
     	exportDocumentData.reportTitle=reportTitle;
     	
     	var csvForm = Ext.create('Ext.form.Panel',{
     		items:[{
     			xtype : 'textfield',
     			itemId : 'exportDocumentData',
     			name : 'exportDocumentData'
     		}]
     	}); 
     	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));
     	csvForm.getForm().submit({
 			target: '_blank',
 		    method:'POST',
 		    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
 		    headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 		    url : exportUrl,
 		    standardSubmit :true
     	});
 	}*/
 	
 	
exportJRXMLReport:function(code,reportParams,reportTitle,filetype,exportUrl){
     	
 		filetype="application/"+filetype;
     	  // This code is for GET request that open new tab to download file
     	 
     	//baseController = Academia.app.getController('Academia.controller.base.BaseController');
     	user=this.getCurrentlyLoggedInUser();
     	
     	var exportDocumentData =new Object();
     	exportDocumentData.code=code;
     	exportDocumentData.userId=user.code;
 		exportDocumentData.reportParams=reportParams;
     	exportDocumentData.academyLocationId=this.getCurrentAcademyLocation();
     	exportDocumentData.reportTitle=reportTitle;
     	if(!isNullOrEmpty(reportParams)){
	     	if(!isNullOrEmpty(reportParams.evaluationGroupId)){
	         	exportDocumentData.evaluationGroupId=reportParams.evaluationGroupId;
	     	}
	     	if(!isNullOrEmpty(reportParams.admissionId)){
	         	exportDocumentData.admissionId = reportParams.admissionId;
	     	}
	     	if(!isNullOrEmpty(reportParams.reportEnum)){
	         	exportDocumentData.reportEnum = reportParams.reportEnum;
	     	}
     	}
     	
     	
     	var csvForm = Ext.create('Ext.form.Panel',{
     		items:[{
     			xtype : 'textfield',
     			maxLength:1000000,
     			itemId : 'exportDocumentData',
     			name : 'exportDocumentData'
     		}]
     	}); 
     	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));
     	csvForm.getForm().submit({
 			target: '_blank',
 		    method:'POST',
 		    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
 		    headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
 		    url : exportUrl,
 		    standardSubmit :true
     	});
 	},
 	
	/**** its for all window *****/
 	formFieldWindowItems : function(form){
	 	   var formAlias = form.ownerCt.alias[0].split(".")[1];
	 	   if(formAlias == 'form') {
	 		  formAlias = form.ownerCt.ownerCt.alias[0].split(".")[1];
	 	   }
	 	   this.toggleFormFieldsItems(form,formAlias);
	},
	
	/**** its for all form *****/
 	formFieldItems : function(form){
 		var $this = this;
 		var formAlias = form.alias[0].split(".")[1];
 		if(!form.iRendered){
 			form.iRendered = true;
 	 		if(!form.isApplicantDFR){
 	 	 	    $this.toggleFormFieldsItems(form,formAlias);
 	 		}
 		}

 		
 	},
 	/**** its for Applicant Profile PersonalInfoForm form Only *****/
 	formApplicantPersonalInfoFieldItems : function(form){
 		var $this = this;
 		var formAlias = form.alias[0].split(".")[1];
 		form.isApplicantDFR = true;
 	    $this.toggleApplicantPersonalInfoFormFieldsItems(form,formAlias);
 	   
 	},
 	/************ When single AL than set default value *********
 	 * pass field name 
 	 * **************/
 	setDefaultAcademyLocation : function(field){

 	},

 	
 	 /*****  
 	  * @author Rajkumar.Patidar
 	  * its common render function for form.
 	  * in this function user can change field property or add new field on form
 	  *****/ 
 	toggleFormFieldsItems: function (form,formAlias) {
 		
 		if(formAlias == "lessonplanningaddexamwin" || formAlias == "lessonplanningresitwin"){
 			return false;
 		}
 		
 		var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
 		var formFieldsInfo = fieldInfo.get("formFieldsInfo");
 		var formfields = formFieldsInfo[formAlias];
 		if(formfields != undefined){
 			for(var i in formfields){
 				if(formfields[i].formAliasName == formAlias){
 					var formFieldName = formfields[i].formFieldName;
 					var formItemId = formfields[i].formFieldId;
 					if(formItemId==""){
 						formItemId=null;
 					}
 					var isMandatory = formfields[i].isMandatory;
 					
 					var formFieldDefaultHelpText = formfields[i].formFieldDefaultHelpText;
 					var formFieldHelpText = formfields[i].formFieldHelpText;
 					
 					//var isLocked = formfields[i].isLocked;
 					var defaultValue = formfields[i].defaultValue;
 					var isVisible = formfields[i].isVisible;
 					var formFieldLabel = formfields[i].formFieldLabel;
 					//var formFieldInputType = formfields[i].formFieldInputType;
 					Ext.suspendLayouts();
 					
 					
 					var field = form.getForm().findField(formFieldName);
 					if(!field){
 						  field = form.down('#'+formItemId);
 					}
 					
 					// As discussed with team Code Commented by Amit G, 
 					// because due to this code, 
 					// In manage enquiry student detail UI DFR not working.
 					
 					/*if(field !=null)
 					{
 						if(field.itemId == undefined) {
 							field = form.down('#'+formItemId);
 						}
 					}*/
 					
 					if(field != null){
 						
 						field.isHelpText = false;
 						field.helpTextToShow = '';
 	 					if(!isNullOrEmpty(formFieldDefaultHelpText) || !isNullOrEmpty(formFieldHelpText)){
 	 						field.isHelpText = true;
 	 						field.helpTextToShow = !isNullOrEmpty(formFieldHelpText) ? formFieldHelpText : formFieldDefaultHelpText;
 	 					}
 						
	 					var buttons = form.query('button');
	 					Ext.Array.each(buttons, function(button) {
	 						if(button.itemId == formItemId){
	 							button.setText(formFieldLabel);
	 							if(isVisible == false){
	 								button.setVisible(isVisible);
	 							}else if(isVisible == true){
	 								button.setVisible(isVisible);
	 								if(form.xtype == 'personalinformationform' && button.itemId == 'photoFileImage' && portalId != '3') {
	 									button.hide();
	 								}
	 								button.setText(formFieldLabel);
	 							}
	 						}
	 					});
	 					
	 					//form.getForm().getFields().each(function(field) {
 						if(field.xtype=='textfield' || field.xtype=='textarea' || field.xtype=='displayfield' ||  
 								field.xtype=='datefield' || field.xtype=='numberfield' || field.xtype=='textareafield'||field.xtype=='timefield'){
 							if(field.name == formFieldName){
 								field.setFieldLabel(formFieldLabel);
 								if(field.xtype!='datefield'){
 									if(!isNullOrEmpty(defaultValue)){
 										field.setValue(defaultValue);
 									}
 								}
 								if(isVisible == false){
 									field.setVisible(isVisible);
 									if(isMandatory == true){
 										field.allowBlank=true;
 									}
 								}
 								else if(isVisible == true){
 									field.setVisible(isVisible);
 									field.setFieldLabel(formFieldLabel);
 									if(field.xtype!='datefield'){
 										if(!isNullOrEmpty(defaultValue)){
 											field.setValue(defaultValue);
 										}
 									}
 									if(formAlias == "applicationreferenceform" && field.itemId == 'contactNo'){
 										if(isMandatory == true){
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 	 										field.labelSeparator = '';
 	 										field.setFieldLabel('');
 									}
 									if(formAlias == "applicationreferenceform" && field.itemId == 'mobileCountryCode'){
 										if(isMandatory == true){
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 										field.labelSeparator = '';
 										field.setFieldLabel('');
 									}
 									else if(formAlias == "idgeneratorform" && field.itemId == 'batchNameItemId' && form.formCode =='batchForm' && isMandatory == true ){
 										field.labelSeparator = '';
 										//field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
 										field.allowBlank=false;
 									}
 									else if(isMandatory == true){
 										field.labelSeparator = '';
 										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
 										field.allowBlank=false;
 									} else {
 										field.allowBlank = true;
 									}
 								}
 							}
 						}
 						if(field.xtype=='radiogroup' || field.xtype=='radiofield' ){
 							if(field.itemId == formItemId){
 								var radioField = field.items.items;
 								field.setFieldLabel(formFieldLabel);
 								for(var i in radioField){
 									var value = defaultValue;
 									if(defaultValue=='true'){ value=true;}
 									if(defaultValue=='false'){value=false;}

 									if(radioField[i].inputValue==value){
 										radioField[i].setValue(true);
 									}
 								}
 								if(isVisible == false){
 									field.setVisible(isVisible);
 									field.setValue(defaultValue);
 									if(isMandatory == true){
 										field.allowBlank=true;
 									}
 								}
 								else if(isVisible == true){
 									field.setVisible(isVisible);
 									field.setFieldLabel(formFieldLabel);
 									field.setValue(defaultValue);
 									if(isMandatory == true){
 										field.labelSeparator = '';
 										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
 										field.allowBlank=false;
 									}
 								}
 								field.setValue(value);

 			 					
 			 					if(formAlias == "programbatchesform" && (field.xtype=='radiogroup' || field.xtype=='radiofield') && field.itemId == 'additionlReq_Id' ){
 			 						form.down('#additionalRequirement_Id').parentVisible = isVisible;
 			 						
 			 						if(field.getValue().hasAdditionalRequirement)
 			 						{
 			 							form.down('#additionalRequirement_Id').setVisible(isVisible);
 			 						}
 			 					}
 			 					
 			 					if(formAlias == 'programperiodformwindow' && (field.xtype=='radiogroup' || field.xtype=='radiofield') && field.itemId == 'whetherPlacementPeriod_ID' 
 			 						&& field.isVisible()==false)
 			 					{
 			 						var placementTypeField=form.down('#placementType');
 						        	var equivalentPeriodField=form.down('#equivalentPeriod');
 						        	//var autoPromField=form.down('#programPeriodAutoPromotionId');
 						        	var extPromField=form.down('#programPeriodExternalPromotionId');
 						        	var rankBasisField=form.down('#programPeriodRankBasis');
 						        	var isLastPeriodField=form.down('#isLastPeriodOfProgramRadioGroup');
 						        	var kysStartDateField=form.down('#kysStartDate');
 						        	var kysEndDateField=form.down('#kysEndDate');
 						        	var studentSDateField=form.down('#studentCourseSelectionStartDate');
 						        	var studentEDateField=form.down('#studentCourseSelectionEndDate');
 						        	var requestStartTime = form.down('#studentCourseSelectionStartTime');
 						        	var requestEndTime = form.down('#studentCourseSelectionEndTime');
 		  					placementTypeField.setDisabled(true);
 			        		equivalentPeriodField.setDisabled(true);

 			        		
 			        		//autoPromField.setDisabled(true);
 			        		extPromField.setDisabled(true);
 			        		rankBasisField.setDisabled(false);
 			        		//isLastPeriodField.setDisabled(false);
 			        		kysStartDateField.setDisabled(true);
 			        		kysEndDateField.setDisabled(true);
 			        		studentSDateField.setDisabled(true);
 			        		studentEDateField.setDisabled(true);
 			        		requestStartTime.setDisabled(true);
 			        		requestEndTime.setDisabled(true);
 		  					 
 			 						
 			 					
 			 						field.dfr=field.getValue().whetherPlacementPeriod;
 			 					}
 			 					else
 			 					{
 			 						field.dfr=field.getValue().whetherPlacementPeriod;
 			 					}
 			 						
 							}
 						}
 						if(field.xtype=='checkbox' || field.xtype=='checkboxfield'){
 							if(field.name == formFieldName){
 								var value = null;
 								if(defaultValue=='true'){ 
 									value=true;
 									//field.checked = value;
 								} else if(defaultValue=='false'){
 									value=false;
 								}
 								
 								if(isMandatory){
									 formFieldLabel = '<span class="required" style="color:red"> *</span>'+formFieldLabel;
									 field.isMandatory = "true";
								 }
								 else{
									 field.isMandatory = "false";
								 }
 								
 								//field.setFieldLabel(formFieldLabel);
								field.setBoxLabel(formFieldLabel);
								field.setVisible(isVisible);
 								field.setValue(value);
 								
 							}
 							if(formAlias == 'programperiodformwindow' && (field.xtype=='checkbox' || field.xtype=='checkboxfield') && field.itemId == 'enrolledDirectly')
		 					{
 								if(field.isVisible()==false){
		 						var enrolledDirectly=form.down('#enrolledDirectly');
					        	
		 						field.dfr='not_visible'
		 						field.enrolledValue=field.getValue();
 								}
 								else{
 	 								field.enrolledValue=field.getValue();
 	 							}
		 					}
 							
 						}
 						if(field.xtype=='customcombobox' || field.xtype=='nestedJsonCombo' || field.xtype=='combo'
 							|| field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='livesearchcombo' || field.xtype=='statusCombo' || field.xtype=='groupingcombobox'){
 							if(field.name == formFieldName){
 								if(!isNullOrEmpty(defaultValue)  && (field.itemId != 'weightageComboId')){
 									var newVariable = 0;
 									newVariable = defaultValue;
 									tempField = field;
 									if(tempField.getStore().getProxy().api != undefined && tempField.getStore().getProxy().api  !=null){
 										tempField.getStore().load({
 											callback : function(records, operation, success) {
 												if (success) {
 													//field.setValue(records[newVariable].data.id);
 													var indx= this.find('id',newVariable);
 													if(indx != -1){
	 													var id = this.getAt(indx).get('id');
	 													tempField.setValue(id);
 													}
 												}
 											}

 										});
 									}else{
 										field.setValue(defaultValue);
 										if(field.itemId == 'calculationPriority' && field.up('form') && field.up('form').xtype == 'calculateresultfilter') {
 											var fieldVals = ['High', 'Medium', 'Low'];
 											if(fieldVals.indexOf(defaultValue) != -1) {
 												field.setValue(defaultValue);
 											}
 											else {
 												field.setValue('Medium');
 											}
 										}
 									}
 								}
 								field.setFieldLabel(formFieldLabel);
 								if(isVisible == true){
 									field.setVisible(isVisible);
 									if(formAlias == 'bulkUploadDocAndNotesForm' && field.itemId == 'batchComboBulkUpload') {
 										field.setVisible(false);
 									}
 									//field.setFieldLabel(formFieldLabel);
 									field.setValue(defaultValue);
 									if(field.itemId == 'calculationPriority' && field.up('form') && field.up('form').xtype == 'calculateresultfilter') {
 										var fieldVals = ['High', 'Medium', 'Low'];
 										if(fieldVals.indexOf(defaultValue) != -1) {
 											field.setValue(defaultValue);
 										}
 										else {
 											field.setValue('Medium');
 										}
 									}
 									if(isMandatory == true){
 										field.labelSeparator = '';
 										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
 										field.allowBlank=false;
 									} else {
 										field.allowBlank = true;
 									}
 								}
 								if(isVisible == false){
 									field.setVisible(isVisible);
 									field.setValue(defaultValue);
 									if(isMandatory == true){
 										field.labelSeparator = '';
 										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
 										field.allowBlank=true;
 									} else {
 										field.allowBlank = true;
 									}
 								}
 								if(formAlias == 'attendancereportsearch' && (field.xtype=='customcombobox') && field.itemId == 'sessionItemId1')
 			 					{
 			 						field.dfr=field.isVisible();
 			 					}
 							}
 						}
 						if(field.xtype=='fieldcontainer'){
 							if(field.itemId == formItemId){
 								if(formAlias == "applicationreferenceform" && field.itemId == 'mobileNoFldItemId'){
 									if(field.down('#contactNo').allowBlank){
 										isMandatory = false;
 									}
 									else{
 										isMandatory = true;
 									}
 									this.clearFL(field);
 								}
 								if(isMandatory == true){
 									if(formFieldLabel.indexOf('required') == -1){
 	 									var allowblankFalse = '<span class="required" style="color:red"> *</span>';
 									}
 									else{
 										var allowblankFalse = '';
 									}
 									field.labelSeparator = '';
 									field.setFieldLabel(formFieldLabel+allowblankFalse);
								} else {
									field.setFieldLabel(formFieldLabel);
								} 								
 								field.setVisible(isVisible);
 							}
 						}
 						if(field.xtype=='fieldset' || field.xtype=='filefield'){
 							if(field.itemId == formItemId){
 								field.setVisible(isVisible);
 								//field.setFieldLabel(formFieldLabel);
 								if(field.xtype=='filefield' ){
 									field.setFieldLabel(formFieldLabel);
 									if( isMandatory == true ){
 										this.setAllowBlank(field, false);
 									}
								}
 	 							
 	 							if(field.xtype=='fieldset'){
 	 								field.setTitle(formFieldLabel);
 	 							}
 							}
 						}
 						if(field.xtype=='label'){
 							if(field.itemId == formItemId){
 								field.setVisible(isVisible);
 								field.setText(formFieldLabel);
 							}
 						}
 						

	 					
	 					if(formAlias == "programbatchesform"  && field.itemId == 'additionalRequirement_Id' && !isEmpty(form.down('#additionlReq_Id').getValue())){
	 						if(form.down('#additionlReq_Id').getValue().hasAdditionalRequirement==true){
	 						form.down('#additionalRequirement_Id').setVisible(true);
	 						}
	 						else{
	 							form.down('#additionalRequirement_Id').setVisible(false);
	 						}
	 					}
	 					if(formAlias == "programbatchesform" && form.down('#additionlReq_Id').isVisible()==false )
	 					{
	 						form.down('#additionalRequirement_Id').setVisible(false);
	 					}
 						
 	 				}
 					Ext.resumeLayouts();
 			  }			
 			}
 		}
 	},
 	 /*****  
	  * @author Amit G
	  * its  render function for Applicant PersonalInfo form.
	  * in this function user can change field property or add new field on form
	  *****/ 
	toggleApplicantPersonalInfoFormFieldsItems: function (form,formAlias) {
		
		var fieldInfo = Academia.model.authentication.FormPersonalInfoFieldInfoModel;
		var formFieldsInfo = fieldInfo.get("formPersonalInfoFieldsInfo");
		if(formAlias == 'addressfieldsform'){
			formAlias = 'addressformwindow';
		}
		var formfields = formFieldsInfo[formAlias];
		if(formfields != undefined){
			for(var i in formfields){
				if(formfields[i].formAliasName == formAlias){
					var formFieldName = formfields[i].formFieldName;
					var formItemId = formfields[i].formFieldItemId;
					var isMandatory = formfields[i].isMandatory;
					//var isLocked = formfields[i].isLocked;
					var defaultValue = formfields[i].defaultValue;
					var isVisible = formfields[i].isVisible;
					var formFieldLabel = formfields[i].formFieldLabel;
					//var formFieldInputType = formfields[i].formFieldInputType;
					Ext.suspendLayouts();
					if (formItemId === 'identityExpiryDateItemId' && formAlias === 'personalinformationform') {
						localStorage.setItem('identityExpiryDateIsVisible',isVisible);
						localStorage.setItem('identityExpiryDateIsMendatory',isMandatory);
					}					
					
					var field = form.getForm().findField(formFieldName);
					if(!field){
						  field = form.down('#'+formItemId);
					}
					
					// As discussed with team Code Commented by Amit G, 
					// because due to this code, 
					// In manage enquiry student detail UI DFR not working.
					
					/*if(field !=null)
					{
						if(field.itemId == undefined) {
							field = form.down('#'+formItemId);
						}
					}*/
					
					if(field != null){
	 					var buttons = form.query('button');
	 					Ext.Array.each(buttons, function(button) {
	 						if(button.itemId == formItemId){
	 							button.setText(formFieldLabel);
	 							if(isVisible == false){
	 								button.setVisible(isVisible);
	 							}else if(isVisible == true){
	 								button.setVisible(isVisible);
	 								button.setText(formFieldLabel);
	 							}
	 						}
	 					});
	 					
	 					//form.getForm().getFields().each(function(field) {
						if(field.xtype=='textfield' || field.xtype=='textarea' || field.xtype=='displayfield' ||  
								field.xtype=='datefield' || field.xtype=='numberfield' || field.xtype=='textareafield'||field.xtype=='timefield'){
							if(field.name == formFieldName){
								field.setFieldLabel(formFieldLabel);
								field.setValue(defaultValue);
								if(isVisible == false){
									field.setVisible(isVisible);
									if(isMandatory == true){
										field.allowBlank=true;
									}
								}
								else if(isVisible == true){
									field.setVisible(isVisible);
									field.setFieldLabel(formFieldLabel);
									field.setValue(defaultValue);
									if(formAlias == "applicationreferenceform" && field.itemId == 'contactNo'){
 										if(isMandatory == true){
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 	 									field.labelSeparator = '';
 	 									field.setFieldLabel('');
 									}
 									if(formAlias == "applicationreferenceform" && field.itemId == 'mobileCountryCode'){
 										if(isMandatory == true){
 	 										field.allowBlank=false;
 	 									} else {
 	 										field.allowBlank = true;
 	 									}
 										field.labelSeparator = '';
 										field.setFieldLabel('');
 									}
									if(isMandatory == true){
										field.labelSeparator = '';
										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
										field.allowBlank=false;
									} else {
										field.allowBlank = true;
									}
								}
							}
						}
						if(field.xtype=='radiogroup' || field.xtype=='radiofield' ){
							if(field.itemId == formItemId){
								var radioField = field.items.items;
								field.setFieldLabel(formFieldLabel);
								for(var i in radioField){
									var value = defaultValue;
									if(defaultValue=='true'){ value=true;}
									if(defaultValue=='false'){value=false;}

									if(radioField[i].inputValue==value){
										radioField[i].setValue(true);
									}
								}
								if(isVisible == false){
									field.setVisible(isVisible);
									field.setValue(defaultValue);
									if(isMandatory == true){
										field.allowBlank=true;
									}
								}
								else if(isVisible == true){
									field.setVisible(isVisible);
									field.setFieldLabel(formFieldLabel);
									field.setValue(defaultValue);
									if(isMandatory == true){
										field.labelSeparator = '';
										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
										field.allowBlank=false;
									}
								}
								field.setValue(value);
							}
						}
						if(field.xtype=='checkbox' || field.xtype=='checkboxfield'){
							if(field.name == formFieldName){
								var value = null;
								if(defaultValue=='true'){ 
									value=true;
									//field.checked = value;
								} else if(defaultValue=='false'){
									value=false;
								}
								//field.setFieldLabel(formFieldLabel);
								field.setBoxLabel(formFieldLabel);
								field.setVisible(isVisible);
								field.setValue(value);
								
							}
						}
						if(field.xtype=='customcombobox' || field.xtype=='nestedJsonCombo' || field.xtype=='combo'
							|| field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2'){
							if(field.name == formFieldName){
								if(!isNullOrEmpty(defaultValue)){
									var newVariable = 0;
									newVariable = defaultValue;
									tempField = field;
									if(tempField.getStore().getProxy().api != undefined && tempField.getStore().getProxy().api  !=null){
										tempField.getStore().load({
											callback : function(records, operation, success) {
												if (success) {
													//field.setValue(records[newVariable].data.id);
													var indx= this.find('id',newVariable);
													if(indx != -1){
	 													var id = this.getAt(indx).get('id');
	 													tempField.setValue(id);
													}
												}
											}

										});
									}else{
										field.setValue(defaultValue);
									}
								}
								field.setFieldLabel(formFieldLabel);
								if(isVisible == true){
									field.setVisible(isVisible);
									//field.setFieldLabel(formFieldLabel);
									field.setValue(defaultValue);
									if(isMandatory == true){
										field.labelSeparator = '';
										field.setFieldLabel(formFieldLabel+'<span class="required" style="color:red"> *</span>');
										field.allowBlank=false;
									} else {
											field.allowBlank = true;
										}
								}
								if(isVisible == false){
									field.setVisible(isVisible);
									field.setValue(defaultValue);
									if(isMandatory == true){
										field.allowBlank=true;
									}
								}
							}
						}
						if(field.xtype=='fieldcontainer'){
							if(field.itemId == formItemId){
								if(formAlias == "applicationreferenceform" && field.itemId == 'mobileNoFldItemId'){
 									if(field.down('#contactNo').allowBlank){
 										isMandatory = false;
 									}
 									else{
 										isMandatory = true;
 									}
 									this.clearFL(field);
 								}
								if(isMandatory == true){
									if(formFieldLabel.indexOf('required') == -1){
 	 									var allowblankFalse = '<span class="required" style="color:red"> *</span>';
 									}
 									else{
 										var allowblankFalse = '';
 									}
 									field.labelSeparator = '';
									field.setFieldLabel(formFieldLabel+allowblankFalse);
								} else {
									field.setFieldLabel(formFieldLabel);
								} 								
								field.setVisible(isVisible);
							}
						}
						if(field.xtype=='fieldset' || field.xtype=='filefield'){
							if(field.itemId == formItemId){
								field.setVisible(isVisible);
								//field.setFieldLabel(formFieldLabel);
								if(field.xtype=='filefield' ){
									field.setFieldLabel(formFieldLabel);
									if( isMandatory == true ){
										this.setAllowBlank(field, false);
									}
								}
							}
						}
						if(field.xtype=='label'){
							if(field.itemId == formItemId){
								field.setVisible(isVisible);
								field.setText(formFieldLabel);
							}
						}
						
	 				}
					Ext.resumeLayouts();
			  }			
			}
		}
	},
	clearFL: function(field){
			var fl = field;
			setTimeout(function(){
				fl.down('#contactNo').setFieldLabel('');
				fl.down('#mobileCountryCode').setFieldLabel('');
				
				var iM = !fl.down('#contactNo').allowBlank;
				
				if(iM){
					if(fl.getFieldLabel().indexOf('required') == -1){
						var allowblankFalse = '<span class="required" style="color:red"> *</span>';
					}
					else{
						var allowblankFalse = '';
					}
					fl.labelSeparator = '';
					fl.setFieldLabel(fl.getFieldLabel()+allowblankFalse);
				}
			},200);
	},
 	resetGridSetting:function(grid){
 		if(grid){
 			var store= grid.getStore();
 			if(store){
 	 		   store.currentPage = 1;
 	 		   store.getProxy().setExtraParam('sort', null);
 			}
		}
 	},
 	
 	/**
 	 * resetPageSetting used for reseting 
 	 *  page and start params for pagination
 	 */
 	resetPageSetting:function(store, grid){
 		if(store){
 			store.currentPage = 1;
 			try {
 				store.getProxy().setExtraParam('sort', null);
 			}
 			catch(err) {
 				console.log(err);
 			}
 		}
 		if(grid && grid.down('custompagingtoolbar')) {
 			try {
 				store.pageSize = store.initialPageSize;
 				grid.down('custompagingtoolbar').plugins[0].setPageSize(store.initialPageSize);
 			}
 			catch(err) {
 				console.log(err);
 			}
 		}
 	},
 	
 	/**
 	 * @author Abhishek.Bais
 	 * resetCustomForm are using for reset 
 	 *  dynamic form rendering forms
 	 */
 	resetCustomForm:function(obj){
 		var form = obj.up('form');
 		if(form.xtype !== "attendancestudentsearch" && form.xtype !== "managefinanceholdaddform" && form.xtype !== "committeeform"){
	 		form.getForm().reset();
	 		var $this = this;
	 		var formAlias = form.alias[0].split(".")[1];
	 		$this.toggleFormFieldsItems(form,formAlias);
	 		form.isValid(true);
	 		try{
	 			form.getForm().clearInvalid();
	 		}
	 		catch(e){}
		}
 	},
 	/**
 	 * @author Abhishek.Bais
 	 * resetCustomFormWindow are using for reset 
 	 *  dynamic form rendering forms on Window
 	 */
 	resetCustomFormWindow:function(obj){
 		var form = obj.up('form');
 		form.getForm().reset();
 		var formAlias = form.ownerCt.alias[0].split(".")[1];
	 	   if(formAlias == 'form') {
	 		  formAlias = form.ownerCt.ownerCt.alias[0].split(".")[1];
	 	   }
 		this.toggleFormFieldsItems(form,formAlias);
 		form.isValid(true);
 	},
 	
 	/** 
 	 * Code to show mask in window
 	 */
 	applyWindowMask:function(message){
 		if(!message){
 			message= getCommonTranslation('SUBMITTING_FORM');
 		}
 		
 		var window=   Ext.WindowMgr.getActive( ).getMaskTarget(); 
 		window.mask.apply(window,[message]);
 	},
 	/** 
 	 * Code to hide mask in window
 	 */
 	hideWindowMask:function(){
 		var window=Ext.WindowMgr.getActive( );
 		if(window) {
 			window.unmask();
 		}
 	},
 	
 	/**
 	 * method to get the academy locations display name which will be displayed in the header.
 	 * @author akshay.kalbhor
 	 */
 	getAcademyLocationDisplayName: function(academyLocationId) {
 		var allAcademyLocations = Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations;
 		var name = null;
 		try{
 			Ext.each(allAcademyLocations, function(currentAcademyLocation){
 				if(currentAcademyLocation.id==academyLocationId){
 					name = currentAcademyLocation.displayName;
 				}
 			});
 		}
 		catch(e){
 			name = null;
 		}
 		
 		if(academyLocationId > 0 && name == null) {
 	 		var url = SERVERURL.ACADEMY_LOCATION_DISPLAY_NAME;
 			Ext.Ajax.request({
 	 			type:'rest',
 	 			method: 'GET',
 	 			async: false,
 	 			url:url,
 	 			params: {
 	 				'id': academyLocationId
 	 			},
 	 			success : function(response){
 	            	if(response){
 	            		name = response.responseText;
 	            	}
 	           }
 	 		});
 		} else if(name == null) {
 			name = getCommonTranslation('ACADEMIA_ERP_DEFAULT_TEXT');
 		}
 		return name;
 	},
 	
 	/**
 	 * getRandomColor function are using for set dynamically color in dashlet  
 	 */
 	getRandomColor:function(index){
 	var color = ["#669900","#3366CC", "#AC3030","#FFAD33","#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB",
 	            "#CD853F","#DDA0DD","#FA8072","#F4A460","#2E8B57","#87CEEB","#00FF7F","#D8BFD8","#FF6347","#40E0D0","#EE82EE","#9ACD32","#7FFFD4",
 	            "#FFEBCD","#8A2BE2","#F0FFFF","#6495ED","#DEB887","#B8860B","#BDB76B","#00CED1","#DAA520","#F0E68C","#ADD8E6","#90EE90","#FFB6C1",
 	            "#20B2AA","#BA55D3","#48D1CC","#FFE4B5","#98FB98","#AFEEEE","#DB7093"][index];
 		
 		return color;
 	},
 	
 	
 	/**
	 * toggle grid summary row
	 * @param: pass grid & boolean
 	 * @author Rajkumar.Patidar
	 */
	toggleGridSummaryRow : function(grid,isVisible){
		var view = grid.getView();
		view.getFeature(0).toggleSummaryRow(isVisible);
		view.refresh();
	},
	
 	/**
 	 * grid header will fix when scroll down .
 	 * @param:  grid name ,structure :- single grid on structure
 	 * @author Rajkumar.Patidar
 	 */
	getGridHeaderFreezeForCalculatAvrg : function(grid,structure,withouTab){},
	getGridHeaderFreezeForCompletion : function(grid,structure,withouTab){},
     getGridHeaderFreeze : function(grid,structure,withouTab){},
     getGridHeaderFreezeVoucherCls : function(grid,structure,withouTab){},
     getGridHeaderFreezeForEmpLeaveGrids : function(grid,structure,withouTab){},
     getGridHeaderFreezeLoginFreq : function(grid,structure,withouTab){},
     getGridHeaderFreezeOnlineUserReport : function(grid,structure,withouTab){},
     getGridHeaderFreezeForQuartz : function(grid,structure,withouTab){},
     getGridHeaderFreezeForInactiveUser : function(grid,structure,withouTab){},
     getGridHeaderFreezeStudentProfile : function(grid,structure,withouTab){},
     getAdhocDocGridHeaderFreeze : function(grid,structure){},
     getGridHeaderFreezeForExaminationResults : function(grid,structure,withouTab){},
     getGridHeaderFreezeManageAssessmentEvents : function(grid,structure,withouTab){},
     getGridHeaderFreezeHallTicket : function(grid,structure,withouTab){},
     getGridHeaderFreezeRequest : function(grid,structure,withouTab){},
     getGridHeaderFreezeAssignId : function(grid,structure,withouTab){},
     getGridHeaderFreezeNoPage : function(grid,structure,withouTab){},
     getGridHeaderFreezeSalesAndAdm : function(grid,structure,withouTab){},
     getGridHeaderFreezeWithDisplayGrandTotal: function(grid,structure,withouTab){},
     getGridHeaderFreezeWithoutPagination: function(grid, structure, withouTab) {}, 
     getManageTargetGridHeaderFreezeWithoutPagination: function(grid, structure, withouTab) {},
     getGridHeaderFreezeWithoutPaginationCustomized	: function(grid, structure, withouTab) {},
     getGridHeaderFreezeWithoutPaginationTwoItemsCustomized	: function(grid, structure, withouTab) {},
     getMultipleGridHeaderFreezeWithoutPaggination: function(grid,structure,withouTab){},
	getMultipleGridHeaderFreeze : function(grid,structure,withouTab){},
	getMultipleGridHeaderForMarkAttendanceFreeze : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFreezeForPaginationFix : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFreezeForPaginationFix : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFreeze : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFreezeMultipleStructure : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFeeAndPaymentApplyToStructure : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFreezeMultipleStructureWithOutTab : function(grid,structure,withouTab){},
	getCBGridHeaderFreeze : function(grid,structure,withouTab){},
	getCBGridHeaderFreezeSEDetailTab : function(grid,structure,withouTab){},
	getCBGridHeaderFreezeForPBSCouseEnrolledStudents : function(grid,structure,withouTab){},
	getMultipleCBGridHeaderFreezeCourseReport : function(grid,structure,withouTab){},
	getMultipleGridHeaderFreezeForFeeReport : function(grid,structure){},
	getGridHeaderFreezeForOBE : function(grid,structure,withouTab){},
	addGeridFreezOnlyHeaderCSS : function(gridHeader){},
	addGeridFreezCSSForWithOutTabForOnlyHeader : function(gridHeader){},
	removeGridHeaderFreezCSSForOnlyHeader : function(gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabOnlyHeader : function(gridHeader){},
	getGridHeaderFreezeForQuestionPaperMapping : function(grid,structure,withouTab){},
	addGeridFreezOnlyTitleAndHeaderCSS : function(gridTitle,gridHeader){},
	addGeridFreezCSSForWithOutTabForOnlyTitleAndHeader : function(gridTitle,gridHeader){},
	removeGridHeaderFreezCSSForOnlyTitleAndHeader : function(gridTitle,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabOnlyTitleAndHeader : function(gridTitle,gridHeader){},
	addGeridFreezCSSQuartz : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSQuartz : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSInactiveUser : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSInactiveUser : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForEventLevelRemarkGrid: function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSS : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezSalesCSS : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForExaminationResults : function(gridTitle,gridBttns,gridHeader,tabBar){},
	addGridFreezCSSForExaminationResultsCourseWise: function(gridTitle,gridBttns,gridHeader,tabBar){},
	removeGridFreezCSSForExaminationResultsCourseWise: function(gridTitle,gridBttns,gridHeader,tabBar){},
	addGeridFreezCSSManageAssessmentEvents: function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSTwoItems : function(gridTitle,gridHeader){},
	addGeridFreezCSSRequest : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSTwoItems : function(gridTitle,gridHeader){},
	addGeridFreezForMarkAttendanceCSS : function(gridTitle,gridHeader){},
	addGeridFreezCSSForFeeAndPaymentAppyToStru : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForFeeAndPaymentAppyToStru : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabForMultipleStru : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabForMultipleStru : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForEventLevelRemarkGrid: function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSS : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezSalesCSS : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForExaminationResults : function(gridTitle,gridBttns,gridHeader,tabBar){},
	removeGridHeaderFreezCSSManageAssessmentEvents: function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSRequest : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSTwoItems: function(gridTitle,gridHeader){},
	removeGridHeaderFreezForMarkAttendanceCSS : function(gridTitle,gridHeader){},
	addGeridFreezCSSForWithOutTab : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabLoginFreq : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabOnlineUserReport : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabHallTicket : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabAssignId : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabFour : function(gridTitle,gridBttns,gridHeader, gridBody){},
	addGeridFreezCSSForWithOutTabCheckPermission : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabStudentProfile : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabStudentProfile : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTab : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabLoginFreq : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabOnlineUserReport : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabHallTicket : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabAssignId : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabFour : function(gridTitle,gridBttns,gridHeader,gridBody){},
	removeGridHeaderFreezCSSForWithOutTabCheckPermission : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabRoles : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezCSSForWithOutTabRoles : function(gridTitle,gridBttns,gridHeader){},
	addGeridFreezCSSForWithOutTabPagination: function(gridTitle, gridBttns, gridHeader) {},
    addManageTargetFreezCSSForWithOutTabPagination: function(gridTitle, gridBttns, gridHeader) {},
    removeGridHeaderFreezCSSForWithOutTabPagination: function(gridTitle, gridBttns, gridHeader) {}, 
    removeManageTargetHeaderFreezCSSForWithOutTabPagination: function(gridTitle, gridBttns, gridHeader) {},
    removeGridHeaderFreezCSSForWithOutTabPaginationCustomized: function(gridTitle, gridBttns, gridHeader) {},
    removeGridHeaderFreezCSSForWithOutTabPaginationCustomizedTwoItems: function(gridTitle, gridHeader) {},
    addGeridFreezCSSForWithOutTabPaginationCustomized: function(gridTitle, gridBttns, gridHeader) {},
    addGeridFreezCSSForWithOutTabPaginationCustomizedTwoItems: function(gridTitle, gridHeader) {},
	addGridFreezeCSSForCourseReportStructure : function(gridTitle,gridBttns,gridHeader){},
	removeGridHeaderFreezeCSSForCourseReportStructure : function(gridTitle,gridBttns,gridHeader){},
	addAdhocDocGridFreezCSS : function(gridTitle,gridBttns,gridHeader){},
	removeAdhocDocGridFreezCSS : function(gridTitle,gridBttns,gridHeader){},
	addEmpLeaveGridFreezCSS : function(gridTitle,gridBttns,gridHeader){},
	removeEmpLeaveGridFreezCSS : function(gridTitle,gridBttns,gridHeader){},
	addExportToPngForDashboard:function(panel,chart){
		var $this = this;
		if(!isNullOrEmpty(Ext.ComponentQuery.query('#exportToPng'))){
			if(Ext.ComponentQuery.query('#exportToPng').length){
				if(!isNullOrEmpty(panel.down('#exportToPng'))){
					panel.remove(panel.down('#exportToPng'));
				}
			}
		}
		if(!isNullOrEmpty(Ext.ComponentQuery.query('#exportToJPG'))){
			if(Ext.ComponentQuery.query('#exportToJPG').length){
				if(!isNullOrEmpty(panel.down('#exportToJPG'))){
					panel.remove(panel.down('#exportToJPG'));
				}
			}
		}
    	var exportToPNG={
    			 text: 'Export To PNG',
		         itemId :'exportToPng',
		         handler: function(btn, target, header, tool){
		        	 var customWidth = 30;
		        	 if(chart.itemId == 'admissionStatisticsByProgramBarChart'){
		        		 customWidth = 200;
		        	 } else if(chart.itemId == 'selectionProcessOverviewColumnChart') {
		        		 customWidth = 100;
		        	 }
		        	 var title = btn.up('button').previousSibling().text;
		        	 var surface = chart.surface;
		        	 var svg = Ext.draw.engine.SvgExporter.generate(surface);
		        	 var canvas = document.createElement('canvas');
		        	 var context = canvas.getContext("2d");
		        	 canvas.height = surface.height + 100;
      				 canvas.width = surface.width+100;
      				 var x = canvas.width / 2;
      				 
      				 //add code for Graphical Reports : Task Report Date Range is not displaying full 
      				 if(chart.itemId == 'tmGraphicalReportsPieChartItemId') {		        		 
      					x = x/6;				 
		        	 }
      				 else if(chart.itemId == 'tmGraphicalReportsBarChartItemId'){
      					x = x/2;
      				 }
      				 ///End of code
      				 
		        	 context.font = "18px Georgia";
		        	 context.textAlign = 'bottom';
		             context.fillText(title, x, 20);
                     context.fillStyle = "#FFFFFF";
                     context.fillRect(0,30,surface.width+100,surface.height + 100);
		             context.drawSvg(svg,customWidth,30);
		        	 var dataURL = canvas.toDataURL('image/png',1.0);
		        	 downloadImage(dataURL,'chart.png');
		         }
	     };
    	var exportToJPEG={
   			 text: 'Export To JPEG',
		         itemId :'exportToJPG',
		         handler: function(btn, target, header, tool){
		        	 var title = btn.up('button').previousSibling().text;
		        	 var surface = chart.surface;
		        	 var svg = Ext.draw.engine.SvgExporter.generate(chart.surface);
		        	 var canvas = document.createElement('canvas');
		        	 var context = canvas.getContext("2d");
		        	 canvas.height = surface.height;
		        	 canvas.width = surface.width;
		        	 var x = canvas.width / 2;
		        	 context.font = "18px Georgia";
		        	 context.textAlign = 'center';
		        	 context.fillText(title, x, 20);
		        	 context.drawSvg(svg,0,30);
		        	 var dataURL = canvas.toDataURL('image/jpeg',1.0);
		        	 downloadImage(dataURL,'chart.jpeg');
		         }
	     };
    	panel.add(exportToPNG);
    	//panel.add(exportToJPEG);
	}, 
	/**
	 * @author Ravi Choudhary
	 * used to get weekday from a date
	 * @param date in string 
	 * @param format is date format
	 * date formats must be in(m-d-Y i.e. "03-01-2017", or y-m-d i.e. "2017-03-02" or d-m-Y i.e. "02-03-2017") 
	 * or all above in slash format
	 */
	getWeekDayFromDate : function(date, format) {
		var newDate = this.getDateFromDMYdate(date, format);
		if (!isNullOrEmpty(newDate)) {
			var weekday = new Array(7);
			weekday[0] = "SUNDAY";
			weekday[1] = "MONDAY";
			weekday[2] = "TUESDAY";
			weekday[3] = "WEDNESDAY";
			weekday[4] = "THURSDAY";
			weekday[5] = "FRIDAY";
			weekday[6] = "SATURDAY";
			weekday[7] = "SUNDAY";
			return (weekday[newDate.getDay()]);
		} else {
			return null;
		}
	},
	
	/**
	 * @author Ravi Choudhary
	 * used to get date in MM/DD/YYYY format from a date in DD/MM/YYYY
	 * used to get date in MM-DD-YYYY format from a date in DD-MM-YYYY
	 * @param date in string 
	 * @param format is date format (no need to provide)
	 */
	getDateFromDMYdate : function(date, format) {
		var orgModel = Academia.model.common.OrgSettingDateTimeModel;
    	var format = orgModel.get('dateFormat');
		if (date !== null && date !== '' && date instanceof Date) {
        	return date;
        } else if (date !== null && date !== '' && typeof(date) == "number") {
        	return new Date(date);
        } else if (!isNullOrEmpty(format) && format === "DMY_DESH") {
			var arr = date.split("-");
//			if(Ext.isSafari) {
//				var arr = val.split("-");
//				if (arr.length > 2) {
//					val = arr[0] + "/" + arr[1] + "/" + arr[2];
//				}
//			}
			newDate = arr[2] + "/" + arr[1] + "/" + arr[0];
			return new Date(newDate);
		} else if (!isNullOrEmpty(format) && format === "DMY_SLASH") {
			var arr = date.split("/");
			newDate = arr[2] + "/" + arr[1] + "/" + arr[0];
			return new Date(newDate);
		} else if (!isNullOrEmpty(format) && format === "DMY_DESH_MONTH") {
			var arr = date.split("-");
			newDate = arr[0] + "/" + arr[1] + "/" + arr[2];
			return new Date(newDate);
		} else if (!isNullOrEmpty(date)) {
			return new Date(date);
		}
		else {
			return date;
		}
	},
	isValidFileExtensionSponsorInvoice: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "pdf" || extension == "doc" || extension == "docx" || extension == "jpg" || extension == "jpeg" || extension == "png") {
				return true;
			}
		}
		return false;
	},
	isValidFileExtensionPDFWord: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "pdf" || extension == "doc" || extension == "docx") {
				return true;
			}
		}
		return false;
	},
	isValidFileExtension: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" || extension == "xlsx" ||
					extension == "jpg" || extension == "jpeg" || extension == "png" || extension == "gif" || extension == "zip") {
				return true;
			}
		}
		return false;
	},
	isValidImageExtension: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "jpg" || extension == "jpeg" || extension == "png" || extension == "gif") {
				return true;
			}
		}
		return false;
	},
	isValidExtensionForUploadedFile :function(extension){
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" || extension == "xlsx" ||
					extension == "jpg" || extension == "jpeg" || extension == "png" || extension == "gif" || extension == "zip" || extension == "csv") {
				return true;
			}
		}
		return false;
	},
	isValidFileExtensionForLoader: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "csv") {
				return true;
			}
		}
		return false;
	},
	isValidFileExtensionForMessaging: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "gif" || extension == "png" || extension == "bmp"
   				   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
   					   || extension == "doc" || extension == "docx" || extension == "txt"
   						   || extension == "xls" || extension == "xlsx" || extension == "csv"  
   							   || extension == "xml" || extension == "zip" || extension == "ppt" || extension == "pptx") {
				return true;
			}
		}
		return false;
	},
	isValidProfileImageExtension: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "jpg" || extension == "jpeg" || extension == "png") {
				return true;
			}
		}
		return false;
	},
	isValidProfileImageExtensionReAddmission: function(extension) {
		if (!isNullOrEmpty(extension)) {
			extension = extension.toLowerCase();
			if (extension == "jpg" || extension == "jpeg" || extension == "png"|| extension == "doc" || extension == "pdf") {
				return true;
			}
		}
		return false;
	},
	setAllowBlank: function(field, value){
		var currentFieldLabel = field.getFieldLabel();
		if(value==true){
			field.labelSeparator = ': ';
			field.allowBlank = true;
		}
		else {
			// applied check if already red start added in field label V2D-60534
			if(currentFieldLabel.includes('*') || (field.afterLabelTextTpl && field.afterLabelTextTpl.includes('*'))){
				//field.labelSeparator = ':';
				field.labelSeparator = '';
			}else{
				field.labelSeparator = '<span class="required" style="color:red"> *</span>';
				//field.labelSeparator = ':';
			}
			field.allowBlank = false;
		}
		field.setFieldLabel(currentFieldLabel);
	},
	//==============To Set Default Country Code=================//
	setDefaultCountryCode : function(form , coutryFieldArray,removeMasking) {
		var combo = [];
		if(!isNullOrEmpty(removeMasking)){
			for(index1 in coutryFieldArray) {
				combo.push(form.down(coutryFieldArray[index1]));
				if(!isNullOrEmpty(Ext.app.defaultCountryCode)){
					if(combo[index1].getStore().getCount()){
						for(index2 in combo) {
							if(isNullOrEmpty(combo[index2].getValue())){
								combo[index2].setValue(Ext.app.defaultCountryCode);
							}
						}
						// Masking UnMask When Application Edit
						removeMasking.unmask();	
					}
					else{
						combo[index1].getStore().load({
							callback : function(rec,operation,success) {
								for(index2 in combo) {
									if(isNullOrEmpty(combo[index2].getValue())){
										combo[index2].setValue(Ext.app.defaultCountryCode);
									}
								}
								// Masking UnMask When Application Edit
								removeMasking.unmask();	
							}
						});
					}
				}else{
					// Masking UnMask When Application Edit
					removeMasking.unmask();	
				}
			}
		}else{
			for(index1 in coutryFieldArray) {
				combo.push(form.down(coutryFieldArray[index1]));
				if(!isNullOrEmpty(Ext.app.defaultCountryCode)){
					if(combo[index1].getStore().getCount()){
						for(index2 in combo) {
							if(isNullOrEmpty(combo[index2].getValue())){
								combo[index2].setValue(Ext.app.defaultCountryCode);
							}
						}
					}
					else{
						combo[index1].getStore().load({
							callback : function(rec,operation,success) {
								for(index2 in combo) {
									if(isNullOrEmpty(combo[index2].getValue())){
										combo[index2].setValue(Ext.app.defaultCountryCode);
									}
								}
							}
						});
					}
				}
			}
		}
	},
	//==============To Set Default Country Code=================//
	
	//==============Set Min/Max Length for Mobile No from CSM Length Value=================//
	
	setMinMaxLengthOnMobile: function(MobileNofield, minValue, maxValue){
		MobileNofield.minLength = minValue;
		MobileNofield.maxLength = maxValue;
	},
	
   //=============== To Apply Permission On Radio Group And Others ======================//
	/*1.>
	 *To Apply Permission On Radio Group Format of --itemIdPrivilegeNameArray-- is
	 * 
	 *ex.> var itemIdPrivilegeNameArray = [{"#Item Id of any one radio button of radio group" : "Privilege of respective radio button" , "#Item Id of another radio button of radio group" : "Privilege of respective radio button", "radioGroupItemId" : "", "defaultButtonItemId" : "" }];
	 * 
	 * one JsonObject ---{}--- of an array contain information of one radio group.
	 * 
	 * radioGroupItemId :- predefined constant key. whose value will be itemId of radioGroup.(Mandatory to take key of same name)
	 * defaultButtonItemId :- predefined constant key, whose value will be itemId of default radio button.(Mandatory to take key of same name)
	 * 
	 * for reference code can be seen in Contoller (User.js,CommitteeController.js).
	 *
	 *2.>
	 *To Apply Permission On buttons Format of --itemIdPrivilegeNameArray-- is
	 *
	 *ex.> var itemIdPrivilegeNameArray = [{"#Item Id of first button" : "Privilege of respective radio button" , "#Item Id of second button" : "Privilege of respective radio button"......................... }];
	 * */ 
	 disableRadioGroupAndOtherPivileges: function(form, permissionsMap, itemIdPrivilegeNameArray) {
			var academyLocationId = this.getCurrentAcademyLocation();
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(academyLocationId);
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			for(index in itemIdPrivilegeNameArray) {
				var radioGroupItemId = itemIdPrivilegeNameArray[index].radioGroupItemId;
				if(!isNullOrEmpty(radioGroupItemId)) {
					var isRadioGroupHidden = false;
					var isDefaultPrivilege = false;
					form.down(radioGroupItemId).setVisible(false);
					for(itemId in itemIdPrivilegeNameArray[index]) {
						if(itemId != 'defaultButtonItemId' && itemId != 'radioGroupItemId') {
							if((Ext.Array.contains(permissionList, itemIdPrivilegeNameArray[index][itemId]))){
								if(itemIdPrivilegeNameArray[index].defaultButtonItemId == itemId) {
									form.down(itemId).setValue(true);
									isDefaultPrivilege = true;
								} else if(isDefaultPrivilege == false) {
									form.down(itemId).setValue(true);
								}
							} else {
								isRadioGroupHidden = true;
							}
						}
					}
					if(isRadioGroupHidden == false){
					   form.down(radioGroupItemId).setVisible(true);	
					}	
				} else {
					for(itemId in itemIdPrivilegeNameArray[index]) {
						form.down(itemId).setVisible(false);
						if((Ext.Array.contains(permissionList, itemIdPrivilegeNameArray[index][itemId]))){
							form.down(itemId).setVisible(true);
						}
					}
				}
				
			}
		},
		/*Set PlaceHolder in form Field */
		setFieldPlaceHolder: function(field,text){
			field.inputEl.dom.placeholder=text;
		},
	//=============== To Apply Permission On Radio  Group And Others ======================//
	
    //=============== To Apply Permission On Tree Panel ======================//
		 checkPermissionAndRemoveFromTreePnl: function(treePnlRootNode, permissionMap, permissionKey){
        	 var associatedAcadLocationIds = new Array();
             associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	
        	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
        	 var constView = 'VIEW';
        	 if(!isNullOrEmpty(permissionList)){
        		 if(!Ext.Array.contains(permissionList, constView)) {							
    				 var vacantNode = treePnlRootNode.findChild("permissionKey",permissionKey,true);
                	 if(!isNullOrEmpty(vacantNode)){
                		 vacantNode.remove(); 
                	 }
    			 } 
        	 }
         },
		
   //=============== To Apply Permission On Tree Panel ======================//
         
     	isValidXMLFileExtensionForLoader: function(extension) {
     		if (!isNullOrEmpty(extension)) {
     			extension = extension.toLowerCase();
     			if (extension == "xml") {
     				return true;
     			}
     		}
     		return false;
     	},
     	getXMLUploadedFile : function(grid){
    		var $this = this;
    		var uploadedBy = null;academyLocationId:this.getCurrentAcademyLocation(),
    		grid.getStore().getProxy().extraParams = {
    			academyLocationId:$this.getCurrentAcademyLocation()
    		};
    		$this.resetPageSetting(grid.getStore());
    		grid.getStore().load();
    	},
    	 //============================ For Get Browsers ======================//
    	
    	getBrowsers:function () {// Opera 8.0+
        	var isOpera = (!!window.opr && !!opr.addons) || !!window.opera || navigator.userAgent.indexOf(' OPR/') >= 0;

        	// Firefox 1.0+
        	var isFirefox = typeof InstallTrigger !== 'undefined';

        	// Safari 3.0+ "[object HTMLElementConstructor]" 
        	var isSafari = /constructor/i.test(window.HTMLElement) || (function (p) { return p.toString() === "[object SafariRemoteNotification]"; })(!window['safari'] || (typeof safari !== 'undefined' && safari.pushNotification));

        	// Internet Explorer 6-11
        	var isIE = /*@cc_on!@*/false || !!document.documentMode;

        	// Edge 20+
        	var isEdge = !isIE && !!window.StyleMedia;

        	// Chrome 1 - 71
        	var isChrome = !!window.chrome && (!!window.chrome.webstore || !!window.chrome.runtime);

        	// Blink engine detection
        	var isBlink = (isChrome || isOpera) && !!window.CSS;

        	var output=null;
        	var output={
    				"isFirefox":isFirefox,
    				"isChrome":isChrome,
    				"isSafari":isSafari,
    				"isIE":isIE,
    				"isEdge":isEdge,
    				"isBlink":isBlink
    		};
        	return output;
        },
      setTabPbsCbsPermission: function(screen){
    		var me = this;
    		
    		try{
        		var contentPanelManageTimeTableTab = me.getContentPanel().getActiveTab();
    		}
    		catch(e){
    			var contentPanelManageTimeTableTab = me.getContentpanel().getActiveTab();
    		}
    		var associatedAcadLocationIds = new Array();
    		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    		try{
    			
        		var permissionsMap = this.getMASTER_TIME_TABLE_PRIVILEGES();
        		
    		}
    		catch(e){
    			var permissionsMap = this.getFACULTY_COURSE_EXECUTION_REPORT_PERMISSIONS();
    		}
    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

    		var isCourseSection = Ext.Array.contains(permissionList, "COURSE_SECTION");
    		var isProgramSection = Ext.Array.contains(permissionList, "PROGRAM_BATCH_SECTION");

    		if(screen=="createMasterTimeTable"){
    			var form = contentPanelManageTimeTableTab.down('mastersearchfilter');
    			var radioBtnField = form.down('#sectionTypeId');

    			if((isCourseSection && !isProgramSection) || (!isCourseSection && !isProgramSection)){	// case 1 && case 4
    				var hideRadios = true;
    				var defaultSelection = "cbs";
    			}
    			else if(!isCourseSection && isProgramSection){ // case 2
    				var hideRadios = true;
    				var defaultSelection = "pbs";
    			}
    			else if(isCourseSection && isProgramSection){ // case 3
    				var hideRadios = false;
    				var defaultSelection = "pbs";
    			}

    			if(hideRadios==true){
    				radioBtnField.setVisible(false);
    			}
    			else{
    				radioBtnField.setVisible(true);
    			}

    			if(defaultSelection=="cbs"){
    				radioBtnField.setValue({sectionType: "COURSE_SECTION"});
    			}
    			else{
    				radioBtnField.setValue({sectionType: "PROGRAM_BATCH_SECTION"}); 
    			}
    		}
    		else if(screen=="extendTimeTable"){
    			var form = contentPanelManageTimeTableTab.down('extendmastertimetableform');
    			
    			var permissionListArray = form.permissionListArray;
    			isCourseSection = (Ext.Array.indexOf(permissionListArray,"COURSE_SECTION") != -1);
    			isProgramSection = (Ext.Array.indexOf(permissionListArray,"PROGRAM_BATCH_SECTION") != -1);
    			var isAcademicTerm = (Ext.Array.indexOf(permissionListArray,"ACADEMIC_TERM") != -1);
    			
    			var sectionType = form.down('#sectionType');
    			var sectionTypeStore = sectionType.getStore();

    			if(isCourseSection && isProgramSection && isAcademicTerm){
    				sectionTypeStore.on('load', function(){
                      if(!isNullOrEmpty(sectionType.el)){
                       try{
    							sectionType.setValue('PROGRAM_BATCH_SECTION');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('PROGRAM_BATCH_SECTION');
        						},1000);
    						}
                       }
    				});
    			}
    			else if(isProgramSection && isCourseSection && !isAcademicTerm){
    				sectionTypeStore.on('load', function(){
    					var record = sectionTypeStore.findRecord('id','ACADEMIC_TERM');
    					if(!isNullOrEmpty(record) && !isNullOrEmpty(sectionType.el)){
	    					sectionTypeStore.remove(record);
                            try{
    							sectionType.setValue('PROGRAM_BATCH_SECTION');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('PROGRAM_BATCH_SECTION');
        						},1000);
    						}
    					}
    				});
    			}
    			else if(isProgramSection && !isCourseSection && isAcademicTerm){
    				sectionTypeStore.on('load', function(){
    					var record = sectionTypeStore.findRecord('id','COURSE_SECTION');
    					if(!isNullOrEmpty(record) && !isNullOrEmpty(sectionType.el)){
	    					sectionTypeStore.remove(record);
                            try{
    							sectionType.setValue('PROGRAM_BATCH_SECTION');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('PROGRAM_BATCH_SECTION');
        						},1000);
    						}
    					}
    				});
    			}
    			else if(!isProgramSection && isCourseSection && isAcademicTerm){
    				sectionTypeStore.on('load', function(){
    					var record = sectionTypeStore.findRecord('id','PROGRAM_BATCH_SECTION');
    					if(!isNullOrEmpty(record) && !isNullOrEmpty(sectionType.el)){
	    					sectionTypeStore.remove(record);
                            try{
    							sectionType.setValue('COURSE_SECTION');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('COURSE_SECTION');
        						},1000);
    						}
    					}
    				});
    			}
    			else if(isProgramSection && !isCourseSection && !isAcademicTerm){
    				sectionTypeStore.on('load', function(){
    					var record = sectionTypeStore.findRecord('id','COURSE_SECTION');
    					var record1 = sectionTypeStore.findRecord('id','ACADEMIC_TERM');
    					if(!isNullOrEmpty(record) && !isNullOrEmpty(record1) && !isNullOrEmpty(sectionType.el)){
	    					sectionTypeStore.remove(record);
	    					sectionTypeStore.remove(record1);
                            try{
    							sectionType.setValue('PROGRAM_BATCH_SECTION');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('PROGRAM_BATCH_SECTION');
        						},1000);
    						}
    					}
    				});
    			}
    			else if(!isProgramSection && isCourseSection && !isAcademicTerm){
    				sectionTypeStore.on('load', function(){
    					var record = sectionTypeStore.findRecord('id','PROGRAM_BATCH_SECTION');
    					var record1 = sectionTypeStore.findRecord('id','ACADEMIC_TERM');
    					if(!isNullOrEmpty(record) && !isNullOrEmpty(record1) && !isNullOrEmpty(sectionType.el)){
	    					sectionTypeStore.remove(record);
	    					sectionTypeStore.remove(record1);
                            try{
    							sectionType.setValue('COURSE_SECTION');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('COURSE_SECTION');
        						},1000);
    						}
    					}
    				});
    			}
    			else if(!isProgramSection && !isCourseSection && isAcademicTerm){
    				sectionTypeStore.on('load', function(){
    					var record = sectionTypeStore.findRecord('id','PROGRAM_BATCH_SECTION');
    					var record1 = sectionTypeStore.findRecord('id','COURSE_SECTION');
    					if(!isNullOrEmpty(record) && !isNullOrEmpty(record1) && !isNullOrEmpty(sectionType.el)){
	    					sectionTypeStore.remove(record);
	    					sectionTypeStore.remove(record1);
                            try{
    							sectionType.setValue('ACADEMIC_TERM');
    						}
    						catch(e){
        						setTimeout(function(){
                					sectionType.setValue('ACADEMIC_TERM');
        						},1000);
    						}
    					}
    				});
    			}
    		}
    		else if(screen=="viewMasterTimeTable"){
    			var permissionMap1=this.getSECTION_COURSE_VIEW_TIMETABLE_PRIVILEGES();
    			var permissionList1 = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap1);

        		 isCourseSection = Ext.Array.contains(permissionList1, "COURSE_SECTION");
        		 isProgramSection = Ext.Array.contains(permissionList1, "PROGRAM_BATCH_SECTION");
    			var form = contentPanelManageTimeTableTab.down('programcoursefilters');
    			var radioBtnField = form.down('#courseSectionTypeRadio');

    			setTimeout(function(){
    				me.changePBSSectionType();
    			},500);

    			if((isCourseSection && !isProgramSection) || (!isCourseSection && !isProgramSection)){	// case 1 && case 4
    				var hideRadios = true;
    				var defaultSelection = "cbs";
    			}
    			else if(!isCourseSection && isProgramSection){ // case 2
    				var hideRadios = true;
    				var defaultSelection = "pbs";
    			}
    			else if(isCourseSection && isProgramSection){ // case 3
    				var hideRadios = false;
    				var defaultSelection = "pbs";
    			}

    			if(hideRadios==true){
    				radioBtnField.setVisible(false);
    			}
    			else{
    				radioBtnField.setVisible(true);
    			}

    			if(defaultSelection=="cbs"){
    				radioBtnField.setValue({sectionType: "CBS"});
    			}
    			else{
    				radioBtnField.setValue({sectionType: "PBS"}); 
    			}
    		}
    		else if(screen=="extendedTimeTable"){
    			var permissionMap2=this.getCOURSE_COVERAGE_PLAN_PERMISSIONS();
    			var permissionList2 = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap2);

        		 isCourseSection = Ext.Array.contains(permissionList2, "COURSE_SECTION");
        		 isProgramSection = Ext.Array.contains(permissionList2, "PROGRAM_BATCH_SECTION");
    			var form = contentPanelManageTimeTableTab.down('coursecoverageplanbasicsearchfilter');
    			var radioBtnField = form.down('#courseSectionTypeRadio');

    			if((isCourseSection && !isProgramSection) || (!isCourseSection && !isProgramSection)){	// case 1 && case 4
    				var hideRadios = true;
    				var defaultSelection = "cbs";
    			}
    			else if(!isCourseSection && isProgramSection){ // case 2
    				var hideRadios = true;
    				var defaultSelection = "pbs";
    			}
    			else if(isCourseSection && isProgramSection){ // case 3
    				var hideRadios = false;
    				var defaultSelection = "pbs";
    			}

    			if(hideRadios==true){
    				radioBtnField.setVisible(false);
    			}
    			else{
    				radioBtnField.setVisible(true);
    			}

    			if(defaultSelection=="cbs"){
    				radioBtnField.setValue({sectionType: "CBS"});
    			}
    			else{
    				radioBtnField.setValue({sectionType: "PBS"}); 
    			}
    		}
    		else if(screen=="importMasterTimeTable"){// || screen=="importMasterTimeTableUpload"){
    			var form = contentPanelManageTimeTableTab.down('uploadtemplate');
    			isCourseSection = (Ext.Array.indexOf(form.permissionListArray,"COURSE_SECTION") != -1);
    			isProgramSection = (Ext.Array.indexOf(form.permissionListArray,"PROGRAM_BATCH_SECTION") != -1);
    			if(screen=="importMasterTimeTable"){
    				var sectionType1 = form.down('#downloadType');
    				var sectionType2 = form.down('#uploadType');
    			}
    			var sectionTypeStore1 = sectionType1.getStore();
    			var sectionTypeStore2 = sectionType2.getStore();

    			if((isCourseSection && isProgramSection)){
    				sectionTypeStore1.load({
    					callback:function(record){
    						if(record.length>0){
    							sectionType1.setValue('PROGRAM_BATCH_SECTION');
    						}
    					}
    				});
    				sectionTypeStore2.load({
    					callback:function(record){
    						if(record.length>0){
    							sectionType2.setValue('PROGRAM_BATCH_SECTION');
    						}
    					}
    				});
    				/*sectionTypeStore1.on('load', function(){
						sectionType1.setValue('PROGRAM_BATCH_SECTION');
					});*/
    				/*sectionTypeStore2.on('load', function(){
    					sectionType2.setValue('PROGRAM_BATCH_SECTION');
    				});*/
    			}
    			else if((!isProgramSection && isCourseSection) || (!isProgramSection && !isCourseSection)){
    				sectionTypeStore1.on('load', function(){
    					var record = sectionTypeStore1.findRecord('id','PROGRAM_BATCH_SECTION');
    					if(!isNullOrEmpty(record)){
	    					sectionTypeStore1.remove(record);
	    					sectionType1.setValue('COURSE_SECTION');
    					}
    				});
    				sectionTypeStore2.on('load', function(){
    					var record = sectionTypeStore2.findRecord('id','PROGRAM_BATCH_SECTION');
    					if(!isNullOrEmpty(record)){
	    					sectionTypeStore2.remove(record);
	    					sectionType2.setValue('COURSE_SECTION');
    					}
    				});
    			}
    			else if((isProgramSection && !isCourseSection)){
    				sectionTypeStore1.on('load', function(){
    					var record = sectionTypeStore1.findRecord('id','COURSE_SECTION');
    					if(!isNullOrEmpty(record)){
        					sectionTypeStore1.remove(record);
        					sectionType1.setValue('PROGRAM_BATCH_SECTION');
    					}
    				});
    				sectionTypeStore2.on('load', function(){
    					var record = sectionTypeStore2.findRecord('id','COURSE_SECTION');
    					if(!isNullOrEmpty(record)){
	    					sectionTypeStore2.remove(record);
	    					sectionType2.setValue('PROGRAM_BATCH_SECTION');
    					}
    				});
    			}
    		}
    		else if(screen=="pendingSessionReport"){
    			var form = contentPanelManageTimeTableTab;//.down('pendingsessionreportstructure');
    			var radioBtnField = form.down('#sectionTypeId');

    			if((isCourseSection && !isProgramSection) || (!isCourseSection && !isProgramSection)){	// case 1 && case 4
    				var hideRadios = true;
    				var defaultSelection = "cbs";
    			}
    			else if(!isCourseSection && isProgramSection){ // case 2
    				var hideRadios = true;
    				var defaultSelection = "pbs";
    			}
    			else if(isCourseSection && isProgramSection){ // case 3
    				var hideRadios = false;
    				var defaultSelection = "pbs";
    			}

    			if(hideRadios==true){
    				radioBtnField.setVisible(false);
    			}
    			else{
    				radioBtnField.setVisible(true);
    			}

    			if(defaultSelection=="cbs"){
    				radioBtnField.setValue({whetherPBSorCBS: false});
    			}
    			else{
    				radioBtnField.setValue({whetherPBSorCBS: true}); 
    			}
    		}
    		else if(screen=="courseExecutionReport"){
    			var form = contentPanelManageTimeTableTab.down('delayedcoursesearch');
    			var radioBtnField = form.down('#selectionTypeId');

    			if((isCourseSection && !isProgramSection) || (!isCourseSection && !isProgramSection)){	// case 1 && case 4
    				var hideRadios = true;
    				var defaultSelection = "cbs";
    			}
    			else if(!isCourseSection && isProgramSection){ // case 2
    				var hideRadios = true;
    				var defaultSelection = "pbs";
    			}
    			else if(isCourseSection && isProgramSection){ // case 3
    				var hideRadios = false;
    				var defaultSelection = "pbs";
    			}

    			if(hideRadios==true){
    				radioBtnField.setVisible(false);
    			}
    			else{
    				radioBtnField.setVisible(true);
    			}

    			if(defaultSelection=="cbs"){
    				radioBtnField.setValue({selectionType: "COURSE_SECTION"});
    			}
    			else{
    				radioBtnField.setValue({selectionType: "PROGRAM_BATCH_SECTION"}); 
    			}
    		}
    		else if(screen=="courseExecutionReportFaculty"){
    			var form = contentPanelManageTimeTableTab;
    			var radioBtnField = form.down('#selectionTypeId');

    			if((isCourseSection && !isProgramSection) || (!isCourseSection && !isProgramSection)){	// case 1 && case 4
    				var hideRadios = true;
    				var defaultSelection = "cbs";
    			}
    			else if(!isCourseSection && isProgramSection){ // case 2
    				var hideRadios = true;
    				var defaultSelection = "pbs";
    			}
    			else if(isCourseSection && isProgramSection){ // case 3
    				var hideRadios = false;
    				var defaultSelection = "pbs";
    			}

    			if(hideRadios==true){
    				radioBtnField.setVisible(false);
    			}
    			else{
    				radioBtnField.setVisible(true);
    			}

    			if(defaultSelection=="cbs"){
    				radioBtnField.setValue({selectionType: "COURSE_SECTION"});
    			}
    			else{
    				radioBtnField.setValue({selectionType: "PROGRAM_BATCH_SECTION"}); 
    			}
    		}
    	},
    	
    	// Method to Encrypt Password 
    	// parameter Plain password
    	// return encrypted password
    	encryptPassword:function (passwordText) {
    		var encrypt = new JSEncrypt();
    		encrypt.setPublicKey(CONST.PUBLIC_KEY_FOR_AUTENTICATION);
            var encrypted = encrypt.encrypt(passwordText);
            return encrypted;
    	},
    	
    	// Method to generate hash of uploaded file 
    	// parameter form
    	// return set generated
        getHashOfFile : function(form) {
        	var file = form.getEl().down('input[type=file]').dom.files[0];
        	var hash;
			var reader = new FileReader();
	        
        	reader.onload = function(event){
        		hash = event.target.result;
	        	var items = new Array();
		        var newcont=form.items.items.length;
				var insertPosition=newcont+1;
				if(form && form.xtype == 'importexternalmarkresultfilter' || form.itemId == 'importutilityformwin') {
					var prevHeight = form.getHeight();
				}
		        items.push({
					xtype : 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype: 'hidden',
		                name: 'md5Hash',
		                itemId: 'md5HashId'
					},{
						xtype: 'hidden',
		                name: 'encodedFileName',
		                itemId: 'encodedFileNamedId'
					}]
				});
		     	form.insert(insertPosition,items);
		     	if(prevHeight) {
		     		form.setHeight(prevHeight);
		     	}
	        	var md5HashData = CryptoJS.MD5(hash).toString();
		        var md5HashField = form.getForm().findField('md5Hash');
		        var encodedFileNameField = form.getForm().findField('encodedFileName');
		        encodedFileNameField.setValue(window.btoa(file.name));
	        	md5HashField.setValue(md5HashData);
			};
			reader.readAsText(file);
        },
         addDataGridConfigButton:function(grid,permissionObject){
        	var gridClassPermission = grid.$className;
        	var isVisible=false;
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionObject);
        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'GRID_CONFIGURATION') {
        			isVisible=true;
        		}
        	});
        	var me=this;
        	var btn=null;
        	if(grid && grid.id){
        		var gridWithOutHeader= grid.down('grid');
        		btn=Ext.getCmp(grid.id+'Button');
        	}
        	if(gridClassPermission.indexOf("SearchResultGrid")!=-1){
        		if(grid.config.isGridColumnBtn){
        			me.addButtonDataGrid(grid,isVisible,btn);	
        		}
        	}else{
        		if(isNullOrEmpty(btn)){
        			setTimeout(function(){
        				me.addDataGridConfigButton(grid,permissionObject);
        			},1500);
        		}else{
        			if(grid.config.isGridColumnBtn){
        			me.addButtonDataGrid(grid,isVisible,btn);
        			}
        		}

        	}
        	
        },
        addButtonDataGrid:function(grid,isVisible,btn){
        	if(!isNullOrEmpty(btn)){
        		if(isVisible){
        			btn.setVisible(true);
        		}
        		else{
        			btn.setVisible(false);
        		}
        	}
        },
        setMaximumMinimumDigitsForMobileNoValidation:function(form, countryCodeField, mobileField, record){
        	var countryInfo = null;
        	if(!isNullOrEmpty(record)) {
        		countryInfo=record[0].data;
        		mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
        		mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
        		if(!isNullOrEmpty(mobileField.getValue())) {
        			mobileField.isValid();
        			try{
        				form.getForm().checkValidity();
        	 		}
        	 		catch(e){}
        		}
        	}
        	else if(countryCodeField){
        		countryCodeField.getStore().load({
        			callback: function(records, operation, success) {
        				if (success) {
        					setTimeout(function(){
        						var countryCode=countryCodeField.getValue();
            					for(var i in records){
            						if(records[i].data.isdCode == countryCode){
        								countryInfo = records[i].data;
        								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : mobileField.maxLength;
        								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : mobileField.minLength;
        								if(!isNullOrEmpty(mobileField.getValue())) {
        									mobileField.isValid();
        									try{
        				        				form.getForm().checkValidity();
        				        	 		}
        				        	 		catch(e){}
        								}
        								break;
        							}
            					}
    		            	},1000);
        				}
        			}
        		});
        	}
        },
        setMaximumMinimumDigitsForPhoneNoValidation:function(form, countryCodeField, phoneNoField, record){
        	var countryInfo = null;
        	if(!isNullOrEmpty(record)) {
        		countryInfo=record[0].data;
        		phoneNoField.maxLength = (!isNullOrEmpty(countryInfo.phMaxDigit)) ? parseInt(countryInfo.phMaxDigit) : phoneNoField.maxLength;
        		phoneNoField.minLength = (!isNullOrEmpty(countryInfo.phMinDigit)) ? parseInt(countryInfo.phMinDigit) : phoneNoField.minLength;
        		if(!isNullOrEmpty(phoneNoField.getValue())) {
        			phoneNoField.isValid();
        			try{
        				form.getForm().checkValidity();
        	 		}
        	 		catch(e){}
        		}
        	}
        	else if(countryCodeField){
        		countryCodeField.getStore().load({
        			callback: function(records, operation, success) {
        				if (success) {
        					setTimeout(function(){
        						var countryCode=countryCodeField.getValue();
            					for(var i in records){
            						if(records[i].data.isdCode == countryCode){
        								countryInfo = records[i].data;
        								phoneNoField.maxLength = (!isNullOrEmpty(countryInfo.phMaxDigit)) ? parseInt(countryInfo.phMaxDigit) : phoneNoField.maxLength;
        								phoneNoField.minLength = (!isNullOrEmpty(countryInfo.phMinDigit)) ? parseInt(countryInfo.phMinDigit) : phoneNoField.minLength;
        								if(!isNullOrEmpty(phoneNoField.getValue())) {
        									phoneNoField.isValid();
        									try{
        				        				form.getForm().checkValidity();
        				        	 		}
        				        	 		catch(e){}
        								}
        								break;
        							}
            					}
    		            	},1000);
        				}
        			}
        		});
        	}
        },
        hideInvalidIconFromField:function(searchFilterForm){
        	/* V2D-519897 - commenting code to show error message on field
        	var iconCls = Ext.baseCSSPrefix + 'form-invalid-icon';
        	try{
            	var form = searchFilterForm.getForm();
        	}
        	catch(e){
        		var form = null;
        	}
        	if(!isNullOrEmpty(form)){
        		form.getFields().each(function(field) {
        			if(field.xtype=='multiselectcombofield' || field.xtype=='textfield' || field.xtype=='textarea' || field.xtype=='datefield'||
        					field.xtype=='datefield' || field.xtype=='numberfield' || field.xtype=='textareafield'||field.xtype=='timefield'
        						|| field.xtype=='customcombobox' || field.xtype=='nestedJsonCombo' || field.xtype=='combo'
        							|| field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='multiselectfield' || field.xtype=='filefield'){
        				
        				
        				
        				field.bodyEl.on('keypress' ,function(me,value){
        					if(field.isValid() == false && !isNullOrEmpty(field.getValue())){
        						field.errorEl.setVisible(true);
        						field.errorEl.parent().setWidth(21);
        					}else if(isNullOrEmpty(field.getValue())){
        						field.removeCls('x-form-invalid ');
                				field.inputEl.removeCls('x-form-invalid-field');
        						field.errorEl.setVisible(false);
        						field.errorEl.parent().setWidth(0);
        					}
        				});
        				
        				if(isNullOrEmpty(field.getValue())) {
        					field.removeCls('x-form-invalid ');
            				field.inputEl.removeCls('x-form-invalid-field');
            				field.errorEl.setVisible(false);
            				field.errorEl.parent().setWidth(0);
        				}
        				else  {
        					if(!isNullOrEmpty(field.errorEl)){
        						field.errorEl.addCls(iconCls);
        						field.errorEl.setVisible(true);
        						field.errorEl.parent().setWidth(21);
        					}
    					
        				}
        			}
        			
        		});
        	}
        	*/
        },
        showInvalidIconOnField :function(searchFilterForm) {
        	try{
            	var form = searchFilterForm.getForm();
        	}
        	catch(e){
            	var form = null;
        	}
        	if(!isNullOrEmpty(form)){
        		if(!form.isValid()){
        		form.getFields().each(function(field) {
        			if((field.xtype=='multiselectcombofield' || field.xtype=='textfield' || field.xtype=='textarea' || field.xtype=='datefield' ||  
        					field.xtype=='datefield' || field.xtype=='numberfield' || field.xtype=='textareafield'||field.xtype=='timefield'
        						|| field.xtype=='customcombobox' || field.xtype=='nestedJsonCombo' || field.xtype=='combo'
        							|| field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='multiselectfield') && (field.allowBlank == false) && (field.isValid() ) ){
        				field.addCls('x-form-invalid ');
        				field.inputEl.addCls('x-form-invalid-field');
        				field.errorEl.setVisible(true);
        			}
        		});
        	  }
        	}
        },
        
        setMaxFileSizeForSendMessageScreen: function(){
        	Ext.Ajax.request({
 	 			type:'rest',
 	 			method: 'GET',
 	 			async: false,
 	 			url:SERVERURL.FILE_PRIORITY,
 	 			params: {
 	 				'type': "emailFileSize"
 	 			},
 	 			success : function(response){
 	            	if(response && !isNullOrEmpty(response.responseText)){
 	            		var responseText = Ext.decode(response.responseText);
 	            		if(responseText.length > 0){
 	            			var maxIdRecord = responseText.reduce(function(prev, current) {
 	            			    return (prev.id > current.id) ? prev : current
 	            			});
 	            			Academia.config.Runtime.setSendMsgMaxFileSize(maxIdRecord.value);
 	            		}
 	            		else if(Academia.config.Runtime.getSendMsgMaxFileSize() == 0){
 	        				Academia.config.Runtime.setSendMsgMaxFileSize(5);
 	        			}else {
 	 	            		Academia.config.Runtime.setSendMsgMaxFileSize(5);
 	 	            	}
 	            	}
 	            	else {
 	            		Academia.config.Runtime.setSendMsgMaxFileSize(5);
 	            	}
 	           }
 	 		});
        },
        disableInactiveStudentPivileges: function(form,permissionMap,field){
         	var this$ = this;
		    	var associatedAcadLocationIds = new Array();
		    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
					field.setVisible(false);
         	Ext.each(permissionList, function(privilege) {
         		if (privilege === 'INACTIVE_STUDENT') {
         			if(!isNullOrEmpty(field)){
         				field.setVisible(true);
         			}        		
         		}
         	
         	});

		    },
		   /* Author-  @deepika Parmar----V2D-283113
		    * @Param :scrollerPanel - panel where we have set autoScroll as true to show scroller on screen
		    * @Param: grid- where column menu is visible
		    * */
		    
		    hideGridColumnMenuOnScroll :function(scrollerPanel,grid){
		    	scrollerPanel.body.on('scroll', function(e, target) {
					if(grid.headerCt.menu){
						grid.headerCt.menu.hide();
					}
					
				});
		    },

		    enableDefaultSorting :function(state,grid,field){
		    	var ds = grid.store;
		    	if(ds.sorters.length){
		    		var oldIndex;
		    		var dataIndex = ds.sorters.keys[0];
		    		var gridColumns = grid.columns;
		    		for (oldIndex = 0; oldIndex < gridColumns.length; ++oldIndex) {
		    			if (gridColumns[oldIndex].dataIndex == dataIndex) { break; }
		    		}
		    		grid.store.applyState({root: "data", property: "", direction: ""});
		    		if(!isNullOrEmpty(grid.columns[oldIndex])) {
		    			grid.columns[oldIndex].setSortState(null);
		    		}
		    		grid.store.sorters.clear();
		    		grid.view.refresh();
		    	}
		    	if(Ext.isDefined(grid.getStore()) && Ext.isDefined(grid.getStore().getProxy()) && Ext.isDefined(grid.getStore().getProxy().api) && Object.keys(grid.getStore().getProxy().api).length>0  && grid.getStore().count()>0){
		    		grid.getStore().load({
		    			callback: function(){
		    				ds.sort({
		    					property : field,
		    					direction : state,
		    					sorterFn : function(v1, v2) {
		    						var reA = /[^a-zA-Z]/g;
		    						var reN = /[^0-9]/g;
		    						if (!isNullOrEmpty(v1.get(field))
		    								&& !isNullOrEmpty(v2.get(field))) {
		    							if (typeof (v1.get(field)) == "string" && typeof (v2.get(field)) == "string") {
		    								v1 = v1.get(field);
		    								v2 = v2.get(field);
		    								var aA = v1.replace(reA, "");
		    								var bA = v2.replace(reA, "");
		    								if(aA.toLowerCase() === bA.toLowerCase()) {
		    									var aN = parseInt(v1.replace(reN, ""), 10);
		    									var bN = parseInt(v2.replace(reN, ""), 10);
		    									return aN === bN ? 0 : aN > bN ? 1 : -1;
		    								} else {
		    									return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
		    								}
		    							}else if (typeof (v1.get(field)) == "object" && typeof (v2.get(field)) == "object") {
		    								v1 = v1.get(field).value;
		    								v2 = v2.get(field).value;
		    								if (!isNullOrEmpty(v1)
		    										&& !isNullOrEmpty(v2)) {
		    									var aA = v1.replace(reA, "");
		    									var bA = v2.replace(reA, "");
		    									if(aA.toLowerCase() === bA.toLowerCase()) {
		    										var aN = parseInt(v1.replace(reN, ""), 10);
		    										var bN = parseInt(v2.replace(reN, ""), 10);
		    										return aN === bN ? 0 : aN > bN ? 1 : -1;
		    									} else {
		    										return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
		    									}
		    								}
		    							} else {
		    								v1 = v1.get(field);
		    								v2 = v2.get(field);
		    								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
		    							}
		    						} else {
		    							if (isNullOrEmpty(v1.get(field))) {
		    								v1.set(field, '');
		    							}
		    							if (isNullOrEmpty(v2.get(field))) {
		    								v2.set(field, '');
		    							}
		    							v1 = v1.get(field);
		    							v2 = v2.get(field);
		    							return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
		    						}
		    					}
		    				});
		    			}
		    		});
		    	}
		    	else{
		    		ds.sort({
		    			property : field,
		    			direction : state
		    		});
		    	}

		    },setMaximumMinimumDigitsForPhoneNoValidation:function(form, countryCodeField, phoneNoField, record){
	            var countryInfo = null;
	            if(!isNullOrEmpty(record)) {
	                countryInfo=record[0].data;
	                phoneNoField.maxLength = (!isNullOrEmpty(countryInfo.phMaxDigit)) ? parseInt(countryInfo.phMaxDigit) : phoneNoField.maxLength;
	                phoneNoField.minLength = (!isNullOrEmpty(countryInfo.phMinDigit)) ? parseInt(countryInfo.phMinDigit) : phoneNoField.minLength;
	                if(!isNullOrEmpty(phoneNoField.getValue())) {
	                    phoneNoField.isValid();
	                    try{
	                        form.getForm().checkValidity();
	                     }
	                     catch(e){}
	                }
	            }
	            else {
	                countryCodeField.getStore().load({
	                    callback: function(records, operation, success) {
	                        if (success) {
	                            setTimeout(function(){
	                                var countryCode=countryCodeField.getValue();
	                                for(var i in records){
	                                    if(records[i].data.isdCode == countryCode){
	                                        countryInfo = records[i].data;
	                                        phoneNoField.maxLength = (!isNullOrEmpty(countryInfo.phMaxDigit)) ? parseInt(countryInfo.phMaxDigit) : phoneNoField.maxLength;
	                                        phoneNoField.minLength = (!isNullOrEmpty(countryInfo.phMinDigit)) ? parseInt(countryInfo.phMinDigit) : phoneNoField.minLength;
	                                        if(!isNullOrEmpty(phoneNoField.getValue())) {
	                                            phoneNoField.isValid();
	                                            try{
	                                                form.getForm().checkValidity();
	                                             }
	                                             catch(e){}
	                                        }
	                                        break;
	                                    }
	                                }
	                            },1000);
	                        }
	                    }
	                });
	            }
	        },
	        
	        getGridHeaderFreezeForEventLevelRemarkGrid: function(grid, structure, withouTab){},
	        getGridHeaderFreezeForAssessmentScheme: function(grid, structure, withouTab) {},
	        addGeridFreezCSSForAssessmentScheme: function(gridTitle, gridBttns, gridHeader) {},
	        removeGeridFreezCSSForAssessmentScheme: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForLearningTarget: function(grid, structure, withouTab) {},
	        addGeridFreezCSSForLearningTarget: function(gridTitle, gridBttns, gridHeader) {},
	        removeGeridFreezCSSForLearningTarget: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForExamResultFP: function(grid, structure, withouTab) {},
	        addGeridFreezCSSForExamResultFP: function(gridTitle, gridBttns, gridHeader) {},
	        removeGeridFreezCSSForExamResultFP: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForGradeMaster: function(grid, structure, withouTab) {},
	        addGridFreezCSSForGradeMaster: function(gridTitle, gridBttns, gridHeader) {},
	        removeGridFreezCSSForGradeMaster: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForPendingMarkEntry: function(grid, structure, withouTab) {},
	        addGridFreezCSSForPendingMarkEntry: function(gridTitle, gridBttns, gridHeader) {},
	        removeGridFreezCSSForPendingMarkEntry: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForEventMappedStudentsGrid: function(grid, structure, withouTab) {},
	        addGridFreezCSSForEventMappedStudentsGrid: function(gridTitle, gridBttns, gridHeader) {},
	        removeGridFreezCSSForEventMappedStudentsGrid: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForImportAssessmentEvents : function(grid,structure){},
	        addGridFreezCSSForImportAssessmentEvents: function(gridTitle,gridBttns,gridHeader){},
	        removeGridHeaderFreezCSSForImportAssessmentEvents: function(gridTitle,gridBttns,gridHeader){},
	        addGridFreezCSSForAssessmentGroups: function(gridTitle,gridBttns,gridHeader){},
	        removeGridFreezCSSForAssessmentGroups: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForAssessmentSchemeMapUnmap: function(grid, structure, withouTab) {},
	        addGeridFreezCSSForAssessmentSchemeMapUnmap: function(gridTitle, gridBttns, gridHeader) {},
	        removeGeridFreezCSSForAssessmentSchemeMapUnmap: function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForAssessmentSchemeMapUnmap: function(grid, structure, withouTab) {},
	        addGeridFreezCSSForAssessmentSchemeMapUnmap: function(gridTitle, gridBttns, gridHeader) {},
	        removeGeridFreezCSSForAssessmentSchemeMapUnmap: function(gridTitle,gridBttns,gridHeader){},
	        getMultipleGridHeaderFreezeCss: function (grid, structure, withouTab) {},
	        addCssGridFreezForWithOutTab : function(gridTitle,gridBttns,gridHeader){},
	    	removeCssGridHeaderFreezForWithOutTab : function(gridTitle,gridBttns,gridHeader){},
	        getGridHeaderFreezeForManageAssessmentStatus: function (grid, structure, withouTab) {},
	        addCssGridFreezForManageAssessmentStatus: function(gridTitle, gridBttns, gridHeader){},
	    	removeCssGridHeaderFreezForManageAssessmentStatus: function(gridTitle, gridBttns, gridHeader){},
	        gridHeaderFreezeForBusinessRuleMapping: function (grid, structure, withouTab) {},
	        addCssGridFreezForBusinessRuleMapping: function(gridTitle, gridBttns, gridHeader){},
	    	removeCssGridHeaderFreezForBusinessRuleMapping: function(gridTitle, gridBttns, gridHeader){},
	        getGridHeaderFreezeForImportMarksRemarks: function(grid, structure, withouTab) {},
	        addCssGridFreezForImportMarkRemark: function(gridTitle, gridBttns, gridHeader){},
	        removeCssGridHeaderFreezForImportMarkRemark: function(gridTitle, gridBttns, gridHeader){},
	        getGridHeaderFreezeForMarkEntry: function(grid, structure, withouTab) {},
	        addCssGridFreezForMarkEntry: function(gridTitle, gridBttns, gridHeader){},
	        doAccessControlValidationForFlyOut:function(flyOut,permissionsMap){
                var $this = this;
				var totalBalance=flyOut.down("#totalBalance");
				if(!isNullOrEmpty(totalBalance)){
					totalBalance.setVisible(false);
				}
				var associatedAcadLocationIds = new Array();
				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
				
				Ext.each(permissionList, function(privilege) {	
					if (privilege === 'TOTAL_BALANCE') {
						if(!isNullOrEmpty(totalBalance)){
							totalBalance.setVisible(true);
						}        		
					}
				});
	        },
	        removeCssGridHeaderFreezForMarkEntry: function(gridTitle, gridBttns, gridHeader){},
	        getGridHeaderFreezeForProgLvlModeration: function (grid, structure, withouTab) {},
	        addGeridFreezCSSForProgLvlModeration: function (gridTitle, gridBttns, gridHeader) {},
	        removeGridHeaderFreezCSSForProgLvlModeration: function (gridTitle, gridBttns, gridHeader) {},
	        getGridHeaderFreezeForExamCancellationAddMapping: function (grid, structure) {},
	        addGridFreezCSSForExamCancellationAddMapping: function (gridTitle, gridBttns, gridHeader) {},
	        removeGridHeaderFreezCSSForExamCancellationAddMapping: function (gridTitle, gridBttns, gridHeader) {},
	        getGridHeaderFreezeForExamConcessionAddMapping: function (grid, structure) {},
	        addGridFreezCSSForExamConcessionAddMapping: function (gridTitle, gridBttns, gridHeader) {},
	        removeGridHeaderFreezCSSForExamConcessionAddMapping: function (gridTitle, gridBttns, gridHeader) {},
	        getGridHeaderFreezeForConcessionNonConcession: function (grid, structure) {},
	        addGridFreezCSSForConcessionNonConcession: function (gridTitle, gridBttns, gridHeader) {},
	        removeGridHeaderFreezCSSForConcessionNonConcession: function (gridTitle, gridBttns, gridHeader) {},
	        getTotalRecordCountForGrid:function(totalCountDisplayField,url,params){
	        	var me = this,grid,pageSizeCombo;
	        	if(totalCountDisplayField){
	        		grid = totalCountDisplayField.up('grid');
	        		totalCountDisplayField.setValue('Loading....');
	        	}
	        	if(grid){
	        		pageSizeCombo = grid.down('#pageSizeCombo');
	        	}
	        	Ext.Ajax.request({
	        		method : "GET",
	        		type : 'rest',
	        		url : url,
	        		headers : {
	        			'Content-Type' : 'application/json'
	        		},
	        		params: params,
	        		success : function(response,action) {
	        			var data = response.responseText;
	        			if(totalCountDisplayField && data){
	        				totalCountDisplayField.setValue(data.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
	        			}
	        			grid.store.totalCount = data; 
	        			grid.config.totalCount = data;
	        			grid.down('#nextButtonPaging') && grid.down('#nextButtonPaging').setDisabled(false);
	        			grid.down('#lastButton') && grid.down('#lastButton').setDisabled(false);
	        		},
	        		failure:function(){
	        			if(totalCountDisplayField && pageSizeCombo){
	        			  totalCountDisplayField.setValue('<a href="" target="_blank" style="text-decoration: none;">'+pageSizeCombo.getValue()+'+</a>)');
	        			}
	        		}
	        	});
	        },
	        getTotalRecordCountForCBGrid:function(grid,totalCountDisplayField,resultUrl,params){
	        	var me = this,pageSizeCombo,jsonData,
	        	pageSizeCombo = grid.down('#pageSizeCombo'),
	        	gridParams=Ext.decode(params),
	        	json = new Object();
	        	if(totalCountDisplayField){
	        		totalCountDisplayField.setValue('Loading....');
	        	}
	        	if(resultUrl=='rest/cb/executeBasicSearchCount'){
	        		json.configCode = gridParams.configCode;
		        	json.searchCriterias = gridParams.searchCriterias;
	        	}else{
	        		json.configCode = gridParams.configCode;
		        	json.searchResultViewColumns = gridParams.searchResultViewColumns;
		        	json.cbSearchCriteria = gridParams.cbSearchCriteria;
		        	json.searchSQLGroups = gridParams.searchSQLGroups;
	        	}
	        	jsonData = Ext.encode(json);
	        	Ext.Ajax.request({
	        		method : "POST",
	        		type : 'rest',
	        		url : resultUrl,
	        		headers : {
	        			'Content-Type' : 'application/json'
	        		},
	        		jsonData: jsonData,
	        		success : function(response,action) {
	        			var data = response.responseText;
	        			if(totalCountDisplayField && data){
	        				totalCountDisplayField.setValue(data.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")+')');
	        			}
	        			grid.store.totalCount = data; 
	        			//grid.config.totalCount = data;
	        			grid.down('#totalRecordCount') && grid.down('#totalRecordCount').setValue(data); 
	        			grid.down('#nextButtonPaging') && grid.down('#nextButtonPaging').setDisabled(false);
	        			grid.down('#lastButton') && grid.down('#lastButton').setDisabled(false);
	        			grid.down('#next').setDisabled(false);
	        			grid.down('#last').setDisabled(false);
	        			//grid.down('#pageSizeCombo') && grid.down('#pageSizeCombo').setDisabled(false);
	        		},
	        		failure:function(){
	        			showWarningMessage(getCommonTranslation('ALERT'),'Something Went wrong , please try again later');
	        			if(totalCountDisplayField && pageSizeCombo){
	        				totalCountDisplayField.setValue('<a href="" target="_blank" style="text-decoration: none;font-weight:600">Many</a>)');
	        			}
	        		}
	        	});
	        }
});

/**
 * This Event is used for restricting the page to refresh while we press backspace button
 */

Ext.EventManager.on(window, 'keydown', function(e, t) {
	var rx = /INPUT|SELECT|TEXTAREA/i;

	if (e.getKey() == e.BACKSPACE && (!(/^input$/i.test(t.tagName)||rx.test(e.target.tagName)  )|| t.disabled || t.readOnly)) {
		e.preventDefault();
	}

});





