/*
 * This controller is used for Calendar
 */
Ext.define('Academia.controller.calendar.CalendarController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['common.StatusComboStore','calendar.CalendarStore', 'calendar.WorkTimingConfigurationGridStore',
             'calendar.HolidayListGridStore', 'calendar.SpecialDaysGridStore', 'calendar.SpecialDayBreaksGridStore', 
             'common.WeekDaysComboStore', 'calendar.entitylist.FacultyStore', 'calendar.entitylist.UserStore', 
             'calendar.entitylist.CourseVariantsStore', 'calendar.entitylist.CalendarAcademyLocationStore', 
             'calendar.entitylist.FacilityStore', 'calendar.entitylist.EquipmentStore', 'calendar.entitylist.filters.LocationFilterStore', 
             'calendar.entitylist.filters.ResourceTypeFilterStore', 
             'calendar.entitylist.filters.SubDepartmentFilterStore', 'calendar.WorkTimeSlotStore', 'calendar.SlotNameStore',
             'calendar.CalAcademyLocationStore','calendar.CalendarTypeStore','calendar.HourDurationStore',
             'calendar.HolidayListDefaultStore','department.ParentDepartmentByAccesibleStore','common.DayWiseWeekComboStore','calendar.CalendarSearchStore'],

    views: ['common.StatusCombo','calendar.Calendar', 'calendar.CalendarGrid', 'calendar.CalendarStructure', 'calendar.AddCalendarForm', 
            'calendar.worktimingconfiguration.WorkTimingConfigurationGrid', 'calendar.worktimingconfiguration.WorkTimingConfigurationFormWindow', 
            'calendar.holidaysandspecialdaystabs.HolidaysAndSpecialDaysTabStructure', 'calendar.holidaysandspecialdaystabs.HolidayListGrid', 
            'calendar.holidaysandspecialdaystabs.HolidayListFormWindow', 
            'calendar.holidaysandspecialdaystabs.SpecialDaysStructure', 'calendar.holidaysandspecialdaystabs.SpecialDaysGrid', 
            'calendar.holidaysandspecialdaystabs.SpecialDaysFormWindow', 'calendar.holidaysandspecialdaystabs.SpecialDayBreaksGrid', 
            'calendar.holidaysandspecialdaystabs.SpecialDayBreaksFormWindow', 'calendar.ViewCalendarForm', 'calendar.entitylist.EntityList', 
            'calendar.entitylist.FacultyGrid', 'calendar.entitylist.UserGrid', 'calendar.entitylist.CourseVariantsGrid', 
            'calendar.entitylist.CalendarAcademyLocationGrid', 'calendar.entitylist.FacilityGrid', 'calendar.entitylist.EquipmentGrid', 
            'calendar.worktimingconfiguration.WorkTimeSlotEditorGrid', 'calendar.worktimingconfiguration.WorkTimeSlotFormWindow', 
            'calendar.worktimingconfiguration.CopyWorkTimeConfigWindow','calendar.CalAcademyLocationWin','calendar.CalAcademyLocationGrid',
            'calendar.worktimingconfiguration.WorkTimingDetailsWindow','calendar.HolidayDetailsCalendarForm','calendar.HolidayDetailsCalendarGrid','calendar.CalendarStructurePanel'],

    alias: "widget.calendarcontroller",
    refs: [{
        ref: 'contentPanel',
        selector: 'contentPanel'
    }, {
        ref: 'calendarSearchForm',
        selector: 'calendarsearchform[itemId=calendarSearchForm]'
    }, {
        ref: 'calendarGrid',
        selector: 'searchresultgrid[itemId=calenderSearchResultGrid]'
    }, {
        ref: 'frnViewCalendar',
        selector: 'viewcalendarform'
    }, {
        ref: 'workTimingConfigurationFormWindow',
        selector: 'worktimingconfigurationformwindow'
    }, {
        ref: 'frnWorkTimingConfiguration',
        selector: 'worktimingconfigurationformwindow form[itemId=workTimingConfigurationForm]'
    }, {
        ref: 'copyWorkTimeConfigWindow',
        selector: 'copyworktimeconfigwindow'
    }, {
        ref: 'copyWorkTimeForm',
        selector: 'copyworktimeconfigwindow form[itemId=copyWorkTimeForm]'
    }, {
        ref: 'workTimeSlotFormWindow',
        selector: 'worktimeslotformwindow'
    }, {
        ref: 'workTimeSlotForm',
        selector: 'worktimeslotformwindow form[itemId=workTimeSlotForm]'
    }, {
        ref: 'holidayListGrid',
        selector: 'holidaylistgrid'
    }, {
        ref: 'winHolidayListForm',
        selector: 'holidayListFormWindow'
    }, {
        ref: 'frnHolidayList',
        selector: 'holidayListFormWindow form[itemId=holidayListForm]'
    }, {
        ref: 'specialDaysGrid',
        selector: 'specialdaysgrid'
    }, {
        ref: 'winSpecialDaysForm',
        selector: 'specialDaysFormWindow'
    }, {
        ref: 'frnSpecialDays',
        selector: 'specialDaysFormWindow form[itemId=specialDaysForm]'
    }, {
        ref: 'specialDayBreaksGrid',
        selector: 'specialdaybreaksgrid'
    }, {
        ref: 'winSpecialDayBreaksForm',
        selector: 'specialDayBreaksFormWindow'
    }, {
        ref: 'frnSpecialDayBreaks',
        selector: 'specialDayBreaksFormWindow form[itemId=specialDayBreaksForm]'
    }, // Grid split button functionality
    {
        ref: 'grdFacility',
        selector: 'facilitygrid'
    }, {
        ref: 'grdEquipment',
        selector: 'equipmentsgrid'
    }, {
        ref: 'grdFaculty',
        selector: 'facultygrid'
    }, {
        ref: 'grdUser',
        selector: 'calenderusergrid'
    }, {
        ref: 'grdCourseVariant',
        selector: 'coursevariantsgrid'
    }, {
        ref: 'grdCalendarAcademyLocation',
        selector: 'calendaracademylocationgrid'
    }, {
        ref: 'entityList',
        selector: 'entitylist'
    },{
        ref: 'calacademyLocationwin',
        selector: 'calacademyLocationwin'
    },{
        ref: 'calacademylocationgrid',
        selector: 'calacademylocationgrid'
    },{
        ref: 'worktimingdetailswindow',
        selector: 'worktimingdetailswindow'
    },{
        ref: 'empWorkTimingConfiguration',
        selector: 'worktimingdetailswindow form[itemId=employeeWorkTimingForms]'
    },{
        ref: 'holidaydetailscalendarform',
        selector: 'holidaydetailscalendarform'
    },{
        ref: 'holidaydetailscalendargrid',
        selector: 'holidaydetailscalendargrid'
    },{
        ref: 'holidaysandspecialdaystabstructure',
        selector: 'holidaysandspecialdaystabstructure'
    },{
        ref: 'calendarstructure',
        selector: 'calendarstructure'
    },{
        ref: 'addcalendarform',
        selector: 'addcalendarform'
    },{
    	ref:'calendarStructurePanel',
    	selector:'calendarStructurePanel'
    }],
    config:{
    	CALENDAR_MASTER_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('CALENDAR_MASTER_PRIVILEGES'),
},

    init: function(application) {
        this.control({
            'viewcalendarform #viewDatePicker': {
                'select': {
                    fn: function(dp, dt) {
                        var viewCalendarForm = this.getFormComponent();
                        viewCalendarForm.down('#viewCalendarId').setStartDate(dt);
                        viewCalendarForm.down('#viewCalendarButton').toggle(false, false);
                        viewCalendarForm.down('#viewCalendarButton').hideMenu();
                    },
                    scope: this
                }
            },
            'viewcalendarform #viewCalendarButton': {
                click: function(cmp, e, eOpts) {
                    var viewCalendarForm = this.getFormComponent();
                    cmp.showMenu();
                    viewCalendarForm.down('#viewDatePicker').setVisible(true);
                }
            },
            /*'viewcalendarform #app-center': {
                afterrender: function(cmp) {
                    this.getFrnViewCalendar().down('#app-center').header.addCls('app-center-header');
                }
            },*/
            'viewcalendarform ': {
                afterrender: function(cmp) {
                    var width = cmp.getWidth();
                    var height = cmp.getHeight();
                    cmp.down('#viewCalendarId').setWidth(width);
                    cmp.down('#viewCalendarId').setHeight(height - 40);
                }
            },
            /*'viewcalendarform #viewCalendarId': {
                'viewchange': this.updateViewCalendarTitle
            },*/
            'searchresultgrid[itemId=calenderSearchResultGrid] button[itemId=btnAddCalendar]': {
                click: this.addCalendar
            },
            'searchresultgrid[itemId=calenderSearchResultGrid] button[itemId=btnViewCalendar]': {
                click: this.viewCalendarForm
            },
            'searchresultgrid[itemId=calenderSearchResultGrid] button[itemId=btnEditCalendar]': {
                click: this.editCalendar
            },
            'searchresultgrid[itemId=calenderSearchResultGrid] button[itemId=btnDeleteCalendar]': {
                click: this.deleteCalendar
            },
            'addcalendarform button[itemId=btnSaveAddCalendar]': {
                click: this.beforeAddEditCalendar
            },
            'addcalendarform checkboxgroup[itemId=weeklyOff]': {
            	change: this.weeklyOffValidation
            },
            /*
             * Work timing configuration grid and window functionality
             */'worktimingconfigurationgrid button[itemId=btnAddWorkTimingConfiguration]': {
                click: this.addWorkTimingConfiguration
            },
            'worktimingconfigurationgrid button[itemId=btnViewWorkTimingConfiguration]': {
                click: Ext.bind(this.editWorkTimingConfiguration, this, [true])
            },
            'worktimingconfigurationgrid button[itemId=btnEditWorkTimingConfiguration]': {
                click: Ext.bind(this.editWorkTimingConfiguration, this, [false])
            },
            'worktimingconfigurationgrid button[itemId=btnDeleteWorkTimingConfiguration]': {
                click: this.deleteWorkTimingConfiguration
            },
            'worktimingconfigurationgrid': {
            	selectionchange: function(column, selected,eOpts ) {
                    this.getTimeSlots(column, selected, eOpts);
                }
            },
            'worktimingconfigurationformwindow combo[itemId=day]': {
                afterrender: function(component, The, eOpts) {
                    var store = component.getStore();
                    store.loadData(weekDaysData);
                }
            },
            'worktimingconfigurationformwindow button[itemId=btnSaveWorkTimingConfigurationForm]': {
                click: this.saveWorkTimingConfiguration
            },
            'worktimingconfigurationformwindow button[itemId=btnCancelWorkTimingConfigurationForm]': {
                click: this.cancelWorkTimingConfiguration
            },
            /* 
             * Copy functionality
             */
            'worktimingconfigurationgrid button[itemId=btnCopyWorkTimingConfiguration]': {
            	 click: function(btn) {
                     var weekDayGrid = btn.up('#calendarWorkingWeekDaysGrid');
                     if (weekDayGrid.getSelectionModel().getCount() > 0) {
                     this.openCopyWorkTimeWindow();
                     } else {
                         showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
                     }
                    
                }
            },
            'copyworktimeconfigwindow form[itemId=copyWorkTimeForm]':{
            	render: function(form){
            		this.filterCopyWeekDayCombo(form);
            	}
            },
            'copyworktimeconfigwindow form[itemId=copyWorkTimeForm] button[itemId=btnCopySelectedDayConfig]':{
            	click: function(btn){
            		this.copyWorkTimingConfiguration(btn);
            	}
            },
            'copyworktimeconfigwindow form[itemId=copyWorkTimeForm] button[itemId=btnCancelCopySelectedDayConfig]':{
            	click: function(){
            		this.getCopyWorkTimeConfigWindow().close();
            	}
            },
            /*
             * Work slot grid and window functionality
             */

            'worktimesloteditorgrid button[itemId=btnAddSlotOnSelectedDay]': {
                click: this.addSlotOnSelectedDay
            },
            'worktimesloteditorgrid button[itemId=btnViewSlotOnSelectedDay]': {
                click: Ext.bind(this.editSlotOnSelectedDay, this, [true])
            },
            'worktimesloteditorgrid button[itemId=btnEditSlotOnSelectedDay]': {
                click: Ext.bind(this.editSlotOnSelectedDay, this, [false])
            },
            'worktimesloteditorgrid button[itemId=btnDeleteSlotOnSelectedDay]': {
                click: this.deleteSlotOnSelectedDay
            },
            'worktimeslotformwindow button[itemId=btnSaveSlotOnSelectedDayForm]': {
                click: function(btn) {
                    this.saveSlotOnSelectedDay(btn);
                }
            },
            'worktimeslotformwindow button[itemId=btnCancelSlotOnSelectedDayForm]': {
                click: this.cancelSlotOnSelectedDay
            },

            'holidaylistgrid button[itemId=btnAddHolidayList]': {
                click: this.addHolidayListRecord
            },
            'holidaylistgrid button[itemId=btnEditHolidayList]': {
                click: Ext.bind(this.editHolidayListRecord, this, [false])
            },
            'holidaylistgrid button[itemId=btnViewHolidayList]': {
                click: Ext.bind(this.editHolidayListRecord, this, [true])
            },
            'holidaylistgrid button[itemId=btnDeleteHolidayList]': {
                click: this.deleteHolidayListRecord
            },
            'holidayListFormWindow button[itemId=btnSaveHolidayListForm]': {
                click: this.saveHolidayListForm
            },
            'holidayListFormWindow button[itemId=btnCancelHolidayListForm]': {
                click: this.cancelHolidayListForm
            },
            'specialdaysgrid button[itemId=btnAddSpecialDay]': {
                click: this.addSpecialDayRecord
            },
            'specialdaysgrid button[itemId=btnEditSpecialDay]': {
                click: Ext.bind(this.editSpecialDayRecord, this, [false])
            },
            'specialdaysgrid button[itemId=btnViewSpecialDay]': {
                click: Ext.bind(this.editSpecialDayRecord, this, [true])
            },
            'specialdaysgrid button[itemId=btnDeleteSpecialDay]': {
                click: this.deleteSpecialDayRecord
            },
            'specialDaysFormWindow button[itemId=btnSaveSpecialDaysForm]': {
                click: this.saveSpecialDaysForm
            },
            'specialDaysFormWindow button[itemId=btnCancelSpecialDaysForm]': {
                click: this.cancelSpecialDaysForm
            },
            'specialdaybreaksgrid button[itemId=btnAddSpecialDayBreaks]': {
                click: this.addSpecialDayBreaksRecord
            },
            'specialdaybreaksgrid button[itemId=btnEditSpecialDayBreaks]': {
                click: Ext.bind(this.editSpecialDayBreaksRecord, this, [false])
            },
            'specialdaybreaksgrid button[itemId=btnViewSpecialDayBreaks]': {
                click: Ext.bind(this.editSpecialDayBreaksRecord, this, [true])
            },
            'specialdaybreaksgrid button[itemId=btnDeleteSpecialDayBreaks]': {
                click: this.deleteSpecialDayBreaksRecord
            },
            'specialDayBreaksFormWindow button[itemId=btnSaveSpecialDayBreaksForm]': {
                click: this.saveSpecialDayBreaksForm
            },
            'specialDayBreaksFormWindow button[itemId=btnCancelSpecialDayBreaksForm]': {
                click: this.cancelSpecialDayBreaksForm
            },
            'specialdaysgrid': {
                select: this.reloadSpecialDayBreaks
            },
            'calendarsearchform[itemId=calendarSearchForm] button[itemId=calendarSearchBtn]': {
                click: function() {
                    this.loadCalendarSearchResultGrid();
                }
            }, 
            'calendarsearchform[itemId=calendarSearchForm] button[itemId=cancelButtonId]': {
                click: function(me) {
                    this.resetFields(me);
                }
            },
            /*'calendarsearchform[itemId=calendarSearchForm] combo[itemId=academyComboField]': {
                render: function(combo, records, eOpts) {
                    var store = combo.getStore();
                    store.getProxy().api.read = SERVERURL.CALENDAR_ACADEMY_STORE;
                    store.load();
                },
                select: function(combo, records, eOpts) {
                    var form = combo.up('form');
                    var locationCombo = form.down('#locationComboField');
                    locationCombo.setDisabled(false);
                    locationCombo.reset();
                    var locationStore = locationCombo.getStore();
                    locationStore.getProxy().api.read = SERVERURL.CALENDAR_LOCATION_STORE;
                    locationStore.load({
                        params: {
                            academyId: combo.getValue()
                        }
                    });
                }
            }*/
            'searchresultgrid[itemId=calenderSearchResultGrid]': {
                render: function(grid, options) {
                	//this.genericCBGridAccessControlValidation(grid, this.getCALENDAR_MASTER_PERMISSION());
                	this.addToolbarButtonOnSearchResultGrid(grid);
                	this.doAccessControlValidation(grid, this.getCALENDAR_MASTER_PERMISSION());
    				var itemIdPrivilegeNameArray = [{"#btnAddCalendar" : "CREATE" }, {"#btnEditCalendar" : "UPDATE"} ,{ "#btnViewCalendar" : "VIEW_CALENDAR"},{ "#btnDeleteCalendar" : "DELETE"},{ "#spBtnMoreActions" : "MOREACTIONS"},{ "#entityListMenu" : "ENTITY_LIST"},{ "#mapAcademyLocationsLink" : "MAP_ACADEMY_LOCATIONS"}];
  	        		this.disableRadioGroupAndOtherPivileges(grid, this.getCALENDAR_MASTER_PERMISSION(), itemIdPrivilegeNameArray);
                	
                    

					/*this.genericCBGridAccessControlValidation(grid, this.getUSER_MANAGEMENT_PERMISSIONS());
					this.disableMoreActionPivileges(grid,this.getUSER_MANAGEMENT_PERMISSIONS());*/
                },
                afterlayout:function(grid){
                	grid.up().up().scrollBy(0,-1);
                	grid.up().up().scrollBy(0,1);
                }
            },
            'searchresultgrid[itemId=calenderSearchResultGrid] #spBtnMoreActions menuitem[itemId=entityListMenu]': {
                click: this.entityListMenuClicked
            },
            'searchresultgrid[itemId=calenderSearchResultGrid] #spBtnMoreActions menuitem[itemId=mapAcademyLocationsLink]': {
                click: this.openMappingALWindow
            },
            'calacademylocationgrid button[itemId=btnAdd]': {
                click: this.mapAcademyLocations
            },
            'searchresultgrid[itemId=calenderSearchResultGrid] button[itemId=btnDeleteCalendar]': {
                click: this.deleteCalendar

            },
            'facilitygrid #comboLocation': {
                select: function(combo, records, eOpts) {
                    var facilityStore = this.getGrdFacility().getStore();
                    var calendarId = this.getCalendarId();
                    var id = records[0].get('id');
                    facilityStore.getProxy().extraParams = {
                        locationId: id,
                        calendarId: calendarId
                    };
                    facilityStore.load();
                }
            },
            'facilitygrid #comboResourceType': {
                select: function(combo, records, eOpts) {
                    var facilityStore = this.getGrdFacility().getStore();
                    var id = records[0].get('id');
                    var calendarId = this.getCalendarId();
                    facilityStore.getProxy().extraParams = {
                        resourceTypeId: id,
                        calendarId: calendarId
                    };
                    facilityStore.load();

                }
            },
            'equipmentsgrid #comboResourceType': {
                select: function(combo, records, eOpts) {
                    var store = this.getGrdEquipment().getStore();
                    var calendarId = this.getCalendarId();
                    var id = records[0].get('id');
                    store.getProxy().extraParams = {
                        resourceTypeId: id,
                        calendarId: calendarId
                    };
                    store.load();
                }
            },
            'coursevariantsgrid #courseVariantId': {
                change: function($this, newValue, oldValue, eOpts) {
                    var store = this.getGrdCourseVariant().getStore();
                    var calendarId = this.getCalendarId();
                    store.getProxy().extraParams = {
                        searchText: newValue,
                        calendarId: calendarId
                    };
                    store.load();
                }
            },
            'calenderusergrid #userNameId': {
                change: function($this, newValue, oldValue, eOpts) {
                    var store = this.getGrdUser().getStore();
                    var calendarId = this.getCalendarId();
                    store.getProxy().extraParams = {
                        searchText: newValue,
                        calendarId: calendarId
                    };
                    store.load();
                }
            },
            'calenderusergrid #comboDepartment': {
                select: function(combo, records, eOpts) {
                    var subdepartmentStore = this.getStore('calendar.entitylist.filters.SubDepartmentFilterStore');
                    var id = records[0].get('id');
                    var subdepartmentCombo = Ext.ComponentQuery.query('calenderusergrid #comboSubDepartment')[0];
                    subdepartmentCombo.reset();
                    subdepartmentStore.getProxy().extraParams = {
                        parentId: id
                    };
                    subdepartmentStore.load();
                    subdepartmentCombo.setDisabled(false);

                }
            },
            'calenderusergrid #comboSubDepartment': {
                select: function(combo, records, eOpts) {
                    var departmentCombo = Ext.ComponentQuery.query('calenderusergrid #comboDepartment')[0];
                    var departmentId = departmentCombo.getValue();
                    var calendarId = this.getCalendarId();
                    var store = this.getGrdUser().getStore();
                    var id = records[0].get('id');
                    store.getProxy().extraParams = {
                        subDepartmentId: id,
                        departmentId: departmentId,
                        calendarId: calendarId
                    };
                    store.load();
                }
            },
            'facultygrid #facultyNameId': {
                change: function($this, newValue, oldValue, eOpts) {
                    var store = this.getGrdFaculty().getStore();
                    var calendarId = this.getCalendarId();
                    store.getProxy().extraParams = {
                        searchText: newValue,
                        calendarId: calendarId
                    };
                    store.load();
                }
            },
            'facultygrid #comboDepartment': {
                select: function(combo, records, eOpts) {
                    var subdepartmentStore = this.getStore('calendar.entitylist.filters.SubDepartmentFilterStore');
                    var id = records[0].get('id');
                    var subdepartmentCombo = Ext.ComponentQuery.query('facultygrid #comboSubDepartment')[0];
                    subdepartmentCombo.reset();
                    subdepartmentStore.getProxy().extraParams = {
                        parentId: id
                    };
                    subdepartmentStore.load();
                    subdepartmentCombo.setDisabled(false);

                }
            },
            'facultygrid #comboSubDepartment': {
                select: function(combo, records, eOpts) {
                    var departmentCombo = Ext.ComponentQuery.query('facultygrid #comboDepartment')[0];
                    var departmentId = departmentCombo.getValue();
                    var calendarId = this.getCalendarId();
                    var store = this.getGrdFaculty().getStore();
                    var id = records[0].get('id');
                    store.getProxy().extraParams = {
                        subDepartmentId: id,
                        departmentId: departmentId,
                        calendarId: calendarId
                    };
                    store.load();
                }
            },
            'addcalendarform combo[itemId=calendarType]': {
            	select: function(combo, records, eOpts) {
            		this.loadCalendarType(combo, records);
            	}
            },
            'addcalendarform checkbox[itemId=isSessionBreakdown]': {
            	change: function(me, newValue, oldValue, eOpts) {
            		//var calendarForm = this.getFormComponent().down('addcalendarform');
            		var calendarForm = this.getActiveTabfromContentPanel().down('addcalendarform');
            		var worktimingConfigurationGrid = calendarForm.down('worktimingconfigurationgrid');
            		var isSessionBreakdown = calendarForm.down('#isSessionBreakdown');
            		//	worktimingConfigurationGrid.getSelectionModel().getCount() > 0
            		if (newValue) {
            			isSessionBreakdown.setValue(true);
            		} else  {
            			isSessionBreakdown.setValue(false);
            		} 
            		this.loadSessionBreakdown (me, newValue, oldValue, eOpts);
            	}
            },
            'addcalendarform': {
            	render: function(form){
            		var calendarType=form.down('#calendarType');
            		this.removePlaceHolderForManualIdSetting(form);
            		//calendarType.setValue("ACADEMIC");
            		calendarType.getStore().load({
            			callback: function(records, operation, success) {
            				calendarType.setValue(records[0].data.id);
            			}
            		});
            	}
            },
            'worktimingdetailswindow button[itemId=btnCancel]': {
            	click: this.cancelWorkTimingDetailsWindow
            },
            'worktimingdetailswindow combo[itemId=startTime]': {
            	change: function( combo, newValue, oldValue, eOpts ) {
            		this.totalHoursCalculation(combo);
            	}
            },
            'worktimingdetailswindow combo[itemId=endTime]': {
            	change: function( combo, newValue, oldValue, eOpts ) {
            		this.totalHoursCalculation(combo);
            	}
            },
            'worktimingdetailswindow combo[itemId=lateComingAllowedTill]': {
            },
            'worktimingdetailswindow combo[itemId=earlyGoingAllowedAfter]': {
            },
            'worktimingdetailswindow button[itemId=btnSaveEmployeeWorkTiming]': {
                click: this.saveEmployeeWorkTimingConfiguration
            },
           /* 'holidaydetailscalendargrid': {
            	render: function(form){
            		var calendarType=form.down('#calendarType');
            		//calendarType.setValue("ACADEMIC");
            		calendarType.getStore().load({
            			callback: function(records, operation, success) {
            				calendarType.setValue(records[0].data.id);
            			}
            		});
            	}
            },*/
            'holidaydetailscalendargrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var grid = $this.getHolidaydetailscalendargrid();
                    var columnName = grid.columnManager.columns[cellIndex].dataIndex;

                    if (e.target.tagName == 'DIV') {
                        if (columnName == "addButton") {
                            if (e.target.className == "addButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)) {
                                    var serialNo;
                                    if (grid.getStore() != null)
                                        serialNo = grid.getStore().getCount();
                                        this.addNewRowInHolidayGrid();
                                }
                            }
                        } else if (columnName == "deleteButton") {
                            if (e.target.className == "deleteButtonClsForGridActionCls") {
                                if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow || !isNullOrEmpty(record.data.id)) {
                                    if (grid.getStore().getRange().length > 0) {
                                        grid.getStore().removeAt(rowIndex);
                                        grid.getView().refresh();
                                                                                
                                    }
                                }
                            }
                        }
                    }
                },
                //V2D-301917
                sortchange:function(){
                	var $this = this;
                	var calendarForm = $this.getActiveTabfromContentPanel().down('addcalendarform');
            		var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
            		var taskGrid = $this.getHolidaydetailscalendargrid();
            		if(!isNullOrEmpty(calendarId)){
                    	var holidayGridStore = taskGrid.getStore();
                		holidayGridStore.getProxy().extraParams = {
                            calendarId: calendarId
                        };
                		holidayGridStore.reload();
            		}
                }
            },
            'holidaydetailscalendarform button[itemId=importHolidayItemId]': {
                click: this.importHolidayList
            },
            'holidaydetailscalendarform textarea[itemId=holidayJsonTextItemId]': {
                change: function(textarea){
                	var form = this.getHolidaydetailscalendarform();
                	var importButton = form.down('#importHolidayItemId');
                	if(form.isValid()){
                		importButton.setDisabled(false);
                	}else{
                		importButton.setDisabled(true);
                	}
                }
            },
            'holidaysandspecialdaystabstructure button[itemId=saveHolidaysandspecialdaystabstructureItemId]': {
                click: this.saveHolidayList,
                render: function(form){
            		var $this=this;
            		var holidaydetailsCalendarGrid=form.down('#holidaydetailscalendargrid');
            		//var calendarForm = this.getFormComponent().down('addcalendarform');
            		 var calendarForm = this.getActiveTabfromContentPanel().down('addcalendarform');
            		var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
            		if(!isNullOrEmpty(calendarId)) {
            			var taskGrid = $this.getHolidaydetailscalendargrid();
            	        taskGrid.getStore().removeAll();
            	        taskGrid.getStore().loadRawData([]);
                		var holidayGridStore = this.getStore('Academia.store.calendar.HolidayListGridStore');
                		
                		holidayGridStore.getProxy().extraParams = {
                            calendarId: calendarId
                        };
                        holidayGridStore.load({
  	                            callback: function(records, operation, success) {
  	                            	var emmTaskModel=null;
  	                            	currentGridTaskList=[];
  	                             	for (i in records) {
  	                                     var holiday = records[i].data;
  	                                     
  	                                     emmTaskModel = new Academia.model.calendar.HolidayListDefaultModel();
  	                                     emmTaskModel.set("id", holiday.id);
  	                                     emmTaskModel.set("fromDate", holiday.fromDate);
  	                                     emmTaskModel.set("holidayReason", holiday.holidayReason);
  	                                     emmTaskModel.set("isAddDeleteRow", true);
  	                                     currentGridTaskList.push(emmTaskModel);
  	                                 }
  	                             	taskGrid.getStore().loadRawData(currentGridTaskList, true);
  	                            }
  	                        }
                        		);
                       
            		}
            		
            		
            	}
            },
            'contentpanel':{
                tabchange:function(tabPanel, newCard, oldCard, eOpts){
                    if(newCard.xtype=='calendarstructure'){
                        var $this=this;
                        var calendarForm = this.getActiveTabfromContentPanel().down('addcalendarform');
                        var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
                        if(!isNullOrEmpty(calendarId)) {
                            var taskGrid = $this.getActiveTabfromContentPanel().down('holidaydetailscalendargrid');
                            taskGrid.getStore().removeAll();
                            taskGrid.getStore().loadRawData([]);
                            var holidayGridStore = this.getStore('Academia.store.calendar.HolidayListGridStore');
                            holidayGridStore.getProxy().extraParams = {
                                calendarId: calendarId
                            };
                            holidayGridStore.load({
                                callback: function(records, operation, success) {
                                    var emmTaskModel=null;
                                    currentGridTaskList=[];
                                    for (i in records) {
                                        var holiday = records[i].data;

                                        emmTaskModel = new Academia.model.calendar.HolidayListDefaultModel();
                                        emmTaskModel.set("id", holiday.id);
                                        emmTaskModel.set("fromDate", holiday.fromDate);
                                        emmTaskModel.set("holidayReason", holiday.holidayReason);
                                        emmTaskModel.set("isAddDeleteRow", true);
                                        currentGridTaskList.push(emmTaskModel);
                                    }
                                    taskGrid.getStore().loadRawData(currentGridTaskList, true);
                                }
                            });
                        }
                    }
                }
            },
            'addcalendarform radiogroup[itemId=dayWiseScheduleId]':{
            	change: function(obj,record) {
            		var form = this.getAddcalendarform();
            		var val = record.dayWiseSchedule;
       			 if (val) {
       				this.setAllowBlank(form.down('#dayPerCycleId'), false);
   					form.down('#dayPerCycleId').setVisible(true);
   					form.down('#dayPerCycleId').reset();
   				 } else {
   					this.setAllowBlank(form.down('#dayPerCycleId'), true);
   					form.down('#dayPerCycleId').setVisible(false);
   					form.down('#dayPerCycleId').reset();
   				 }
       			form.getForm().checkValidity();
       			//form.getForm().isValid();
               }
            },
            'holidaysandspecialdaystabstructure button[itemId=holidayDetailSearchBtn]': {
                click: function(){
                	var $this = this;
                    var grid = $this.getCalendarGrid();
                    var calRecord = grid.getSelectionModel().getSelection();
                    var str = $this.getHolidaysandspecialdaystabstructure();
                    //var record = grid.getSelectionModel().getSelection();
                    var formValues = str.getForm().getValues();
                    var fromDate = str.down('#startDateId').getValue();
                    var  toDate = str.down('#endDateId').getValue();
                    var holidaySearchGrid = $this.getHolidaydetailscalendargrid();
                    var holidaySearchStore = holidaySearchGrid.getStore();
                    holidaySearchStore.getProxy().extraParams = {
                    	fromDate: formValues.startDate,
                    	toDate:formValues.endDate,
                    	calendarId:calRecord[0].data['ID'],
                    };
                   
                    holidaySearchStore.load();                    
                     
                }
            },
            'holidaydetailscalendargrid button[itemId=btnAddHoliday]': {
                click:  this.addNewRowInHolidayGrid
            },
        });
    },

    addToolbarButtonOnSearchResultGrid: function(grid) {
        grid.addDocked({
            xtype: 'toolbar',
            itemId: 'functionButtonsToolbar',
            dock: 'top',
            items: [{
                xtype: 'button',
                itemId: 'btnAddCalendar',
                tooltip: getCommonTranslation('ADD'),
                iconCls:'icon-addbutton',
				 cls:'addbutton'
            }, {
                xtype: 'button',
                itemId: 'btnEditCalendar',
                tooltip: getCommonTranslation('EDIT'),
                iconCls:'icon-editbutton',
				cls:'editbutton'
            }, {
                xtype: 'button',
                itemId: 'btnViewCalendar',
                tooltip: getCommonTranslation('VIEW'),
                iconCls: 'icon-View',
				cls:'iconView'	
            }, {
                xtype: 'button',
                itemId: 'btnDeleteCalendar',
                cls: 'CustomToolbarBtnReject',
                tooltip: 'Delete department',
                iconCls: 'icon-Delete',
				cls:'iconDelete'
            }, {
                xtype: 'splitbutton',
                itemId: 'spBtnMoreActions',
                text: getCommonTranslation('MOREACTIONS'),
                menu: [{
                    text: getCommonTranslation('ENTITY_LIST'),
                    itemId: 'entityListMenu'
                },{
					text:getCommonTranslation('MAP_ACADEMY_LOCATIONS'),
					itemId:'mapAcademyLocationsLink'
				}],
                listeners: {
                    click: function() {
                        this.showMenu();
                    }
                }
            }]
        });
    },
    resetFields: function(me){
    	var form = me.up("#calendarSearchForm");
    	/*var locationCombo = form.down('#locationComboField');
    	locationCombo.setDisabled(true);*/
    	form.getForm().reset();
    },
    /**
     * On search button click load calendar data
     */
    loadCalendarSearchResultGrid: function() {
        var searchForm = this.getCalendarSearchForm();
        var jsonFormatFormData = this.createSearchResultJsonFormat(searchForm);
        var resultGrid = this.getCalendarGrid();
        var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
        resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.CALENDAR_LIST_BASIC_CONFIGCODE);
        resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);

    },
    /**
     * create json for calendar data
     */
    createSearchResultJsonFormat: function(searchForm) {
        var me = this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.CALENDAR_LIST_BASIC_CONFIGCODE;

        formValues = searchForm.getValues();

     /*   var calenderId = formValues["calenderId"];
        if (!isNullOrEmpty(calenderId)) {
            var keyValueJsonObject = me.getJsonObject('CALENDAR_ID', calenderId);
            me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
        }
        var calenderName = formValues["calenderName"];
        if (!isNullOrEmpty(calenderName)) {
            var keyValueJsonObject = me.getJsonObject('CALENDAR_NAME', calenderName);
            me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
        }*/
     // var  calendarNameOrCode= formValues["calenderNameOrCode"];
        var  calendarNameOrCode= formValues.calenderNameOrCode;
      if (!isNullOrEmpty(calendarNameOrCode)) {
          var keyValueJsonObject = me.getJsonObject('CALENDAR_ID', calendarNameOrCode);
          me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
      }
        
       // var calendarType = formValues["calendarType"];
        var calendarType =  formValues.calendarType;
        if (!isNullOrEmpty(calendarType)) {
            var keyValueJsonObject = me.getJsonObject('CALENDAR_TYPE',calendarType);
            me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
        }
        
        
      //  var academyId = formValues["academyId"];
        var academyId = formValues.academyId;
        if (!isNullOrEmpty(academyId)) {
            var keyValueJsonObject = me.getJsonObject('ACADEMY_ID', academyId);
            me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
        }else{
        	var loggedInUser=this.getCurrentlyLoggedInUser();
        	var loggedInUserId = loggedInUser.id;
        	if(loggedInUserId != 1){
        		var loggedAcademyLocationId = this.getCurrentAcademyLocation();
        		if (!isNullOrEmpty(loggedAcademyLocationId)) {
        			var keyValueJsonObject = me.getJsonObject('ACADEMY_ID', loggedAcademyLocationId);
        			me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
	        		}
        	}
        }
        /*
        var locationId = formValues["locationId"];
        if (!isNullOrEmpty(locationId)) {
            var keyValueJsonObject = me.getJsonObject('LOCATION_ID', locationId);
            me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
        }*/
       

      //  var status = formValues["status"];
        var status =  formValues.status;
        if (!isNullOrEmpty(status)) {
            var keyValueJsonObject = me.getJsonObject('STATUS', (status == true) ? 'ACTIVE' : 'INACTIVE');
            me.pushJsonObjectInArray(keyValueJsonObject, searchcriteria);
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    /**
     * get json for calendar data
     */
    getJsonObject: function(key, value, additionalValue) {
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    /**
     * push json object in array
     */
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    /*
     * For weeklyOff validation purpose.
     */
    weeklyOffValidation: function(component, newValue, oldValue, eOpts) {
    	
    	var isWeekDayPresent = false;
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var workingWeekDaysGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
        var weeklyOffGroup = newValue.weeklyOffGroup;
        if(!isEmpty(weeklyOffGroup)){
        weekDayGridStore = workingWeekDaysGrid.getStore();
        var weeklyOffs = new Array();
        var newValues = new String(newValue.weeklyOffGroup);
        weeklyOffs = newValues.split(",");
        if(!isEmpty(weeklyOffGroup)){
        	if(!isArray(weeklyOffGroup)){
        		var weeklyOffGroup = new Array(weeklyOffGroup);
        	}
        	if(isArray(weeklyOffGroup)){
        		for(var i=0; i < weeklyOffGroup.length; i++){
                	var record = weekDayGridStore.findRecord('weekday',weeklyOffGroup[i], 0, false, true, true);
                	if(!isEmpty(record)){
                		isWeekDayPresent = true;
                		break;
                	}
                }
        	}/*else{
        		var record = weekDayGridStore.findRecord('weekday',weeklyOffGroup, 0, false, true, true);
            	if(!isEmpty(record)){
            		isWeekDayPresent = true;
            		//break;            		
            	}
        	}*/
        }
        }
        
        if(isWeekDayPresent){
        	if(oldValue.weeklyOffGroup !=undefined){
        		var selectedDay = 'checkbox[itemId=' + weeklyOffs[weeklyOffs.length - 1] + ']';

        		calendarForm.down(selectedDay).setValue(oldValue.weeklyOffGroup);

        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('WEEKDAY_ENTRY_PRESENT_FOR_SELECTED_WEEK_OFF'));
        		for(var i=0; i < component.items.items.length; i++){
        			//Ext.each(component.items.items, function(i) {
        			if(component.items.items[i].itemId == weeklyOffs[weeklyOffs.length - 1])
        			{
        				component.items.items[i].setValue(true);
        			}else
        			{
        				component.items.items[i].setValue(false);
        			}

        		};
        	}else{
        		for(var i=0; i < component.items.items.length; i++){
        		component.items.items[i].setValue(false);
        		}
        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('WEEKDAY_ENTRY_PRESENT_FOR_SELECTED_WEEK_OFF'));
        		
        	}
        }else if(Ext.isDefined(weeklyOffs)) {
        	if( weeklyOffs.length === 7){
        		var selectedDay = 'checkbox[itemId=' + weeklyOffs[weeklyOffs.length - 1] + ']';
        		calendarForm.down(selectedDay).setValue(oldValue.weeklyOffGroup);
        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_WEEKLYOFF_MSG'));
        	}
        }
    
    },
    /*
     * For Reloading the special day breaks grid on Edit mode of calendar.
     */
    reloadSpecialDayBreaks: function(component, record, index, eOpts) {
        var wsCalendarWeekDayId = record.data.id;
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var specialDayBreaksGridStore = calendarForm.down('#specialDayBreaksGrid').getStore();
        specialDayBreaksGridStore.getProxy().extraParams = {
            weekDayId: wsCalendarWeekDayId
        };
        specialDayBreaksGridStore.reload();
    },

    /*
     * For Reloading the breaks on selected day details on Edit mode of calendar.
     */
    filterSlotSelectedDayDetails: function(component, record, index, eOpts) {
        //var workDayId = record.data.id;
        var weekday = record.data.weekday;
        var calendarForm = this.getActiveTabfromContentPanel().down('addcalendarform');
        var workTimeSlotEditorGridStore = calendarForm.down('#workTimeSlotEditorGrid').getStore();

        workTimeSlotEditorGridStore.clearFilter();
        this.applyFilterOnWorlSlotGrid(workTimeSlotEditorGridStore, weekday);

    },
    
    getTimeSlots: function(component, record, index, eOpts) {
        //var workDayId = record.data.id;
    	if(record.length > 0){
            var weekday = record[0].data.weekday;
        var calendarWeekdayId = record[0].data.id;
        var calendarForm = this.getActiveTabfromContentPanel().down('addcalendarform');
        var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
        var timeSlotGrid = calendarForm.down('#workTimeSlotEditorGrid');
        timeSlotGrid.expand();
        var workTimeSlotEditorGridStore = timeSlotGrid.getStore();
        workTimeSlotEditorGridStore.getProxy().extraParams = {
        	calendarWeekdayId: calendarWeekdayId,
        	calendarId:calendarId,
        	weekday:weekday
        };
        workTimeSlotEditorGridStore.removeAll();
        workTimeSlotEditorGridStore.loadPage(1);
        }
    },

    /*
     * This function is used for Adding calendar from calendar Grid.   
     */
    addCalendar: function() {
        var me = this;
        var tabName = getCommonTranslation('ADD_CALENDER');
        var menuController = me.getMenuController();
        menuController.addTab(tabName, 'calendarstructure', CONSTANTS.MENU_COLOR_THIRTEEN);
        var calendarForm = this.getFormComponent(tabName).down('addcalendarform');
        calendarForm.down('#calendarWorkingWeekDaysGrid').setVisible(false);
        calendarForm.down('#workTimeSlotEditorGrid').setVisible(false);
        this.getCalendarstructure().down('#holidaysandspecialdaystabstructure').setDisabled(true);
        me.addNewRowInHolidayGrid();
        Ext.app.weekDayArray = [{
			name : "SUNDAY",
				value : getCommonTranslation('SUNDAY')
			}, {
				name : "MONDAY",
				value : getCommonTranslation('MONDAY')
			}, {
				name : "TUESDAY",
				value : getCommonTranslation('TUESDAY')
			}, {
				name : "WEDNESDAY",
				value : getCommonTranslation('WEDNESDAY')
			}, {
				name : "THURSDAY",
				value : getCommonTranslation('THURSDAY')
			}, {
				name : "FRIDAY",
				value : getCommonTranslation('FRIDAY')
			}, {
				name : "SATURDAY",
				value : getCommonTranslation('SATURDAY')
			}];
        var taskGrid = me.getHolidaydetailscalendargrid();
        taskGrid.getStore().removeAll();
        taskGrid.getStore().loadRawData([]);
    },
    
    updateViewCalendarTitle: function(p, vw, dateInfo) {
        var startDt = new Date(),
            endDt = new Date();
        if (dateInfo) {
            // will be null when switching to the event edit form so ignore
            // Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
            //this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
            startDt = dateInfo.viewStart;
            endDt = dateInfo.viewEnd;
        }
        var p = this.getFrnViewCalendar().down('#app-center'), //Ext.getCmp('app-center'),
            fmt = Ext.Date.format;

        if (Ext.Date.clearTime(startDt).getTime() == Ext.Date.clearTime(endDt).getTime()) {
            p.setTitle(fmt(startDt, 'F j, Y'));
        } else if (startDt.getFullYear() == endDt.getFullYear()) {
            if (startDt.getMonth() == endDt.getMonth()) {
                p.setTitle(fmt(startDt, 'F j') + ' - ' + fmt(endDt, 'j, Y'));
            } else {
                p.setTitle(fmt(startDt, 'F j') + ' - ' + fmt(endDt, 'F j, Y'));
            }
        } else {
            p.setTitle(fmt(startDt, 'F j, Y') + ' - ' + fmt(endDt, 'F j, Y'));
        }
    },
    /*
     * This function is used for View calendar from calendar Grid.
     */
    viewCalendarForm: function() {
        var me = this;
        var grid = this.getCalendarGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection();
            if (record != "" && record != null && record != undefined) {
                var id = record[0].data['ID'];
                var tabTitle = getCommonTranslation('VIEW')+" "+ record[0].data['CALENDAR_NAME'];
                var menuController = me.getMenuController();
                menuController.addTab(tabTitle, 'viewcalendarform', CONSTANTS.MENU_COLOR_THIRTEEN);
                var viewCalendarForm = me.getFormComponent(tabTitle);
                if (!isEmpty(record)) {
                    viewCalendarForm.eventStore.getProxy().url = SERVERURL.CALENDAR_VIEW;
                    viewCalendarForm.eventStore.getProxy().extraParams = {
                    	id: id
                    };
                    viewCalendarForm.eventStore.load();
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    /*
     * For Editing the calendar from calendar grid 
     */
    editCalendar: function() {
        var me = this;
        var grid = this.getCalendarGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection();
            if (!isEmpty(record)) {
            	Ext.app.weekDayArray = [{
        			name : "SUNDAY",
        				value : getCommonTranslation('SUNDAY')
        			}, {
        				name : "MONDAY",
        				value : getCommonTranslation('MONDAY')
        			}, {
        				name : "TUESDAY",
        				value : getCommonTranslation('TUESDAY')
        			}, {
        				name : "WEDNESDAY",
        				value : getCommonTranslation('WEDNESDAY')
        			}, {
        				name : "THURSDAY",
        				value : getCommonTranslation('THURSDAY')
        			}, {
        				name : "FRIDAY",
        				value : getCommonTranslation('FRIDAY')
        			}, {
        				name : "SATURDAY",
        				value : getCommonTranslation('SATURDAY')
        			}];
                var tabTitle = getCommonTranslation('EDIT')+" "+ record[0].data['CALENDAR_NAME'];
                var menuController = me.getMenuController();
                menuController.addTab(tabTitle, 'calendarstructure', CONSTANTS.MENU_COLOR_THIRTEEN);
                var calendarForm = me.getFormComponent(tabTitle).down('addcalendarform');
                calendarForm.down('#calendarWorkingWeekDaysGrid').setVisible(true);
                calendarForm.down('#workTimeSlotEditorGrid').setVisible(true);
                calendarForm.down('#resetButtonId').setVisible(false);
                var params = {
                    id: record[0].data['ID']
                };
                this.setDataToCalendarForm(calendarForm, params);
                calendarForm.down('#calendarType').setReadOnly(true);
                calendarForm.down('#isSessionBreakdown').setReadOnly(true);
                var taskGrid = me.getHolidaydetailscalendargrid();
    	        taskGrid.getStore().removeAll();
    	        taskGrid.getStore().loadRawData([]);
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    /**
     * Set data to calendar form in add/edit case
     */
    setDataToCalendarForm: function(calendarForm, params) {
        var this$ = this;
        this$.sendGetAjaxRequest(SERVERURL.GET_CALENDAR_DETAILS, 'GET', params, function(option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                calendarForm.down('#hiddenCalendarId').setValue(data.id);
                calendarForm.down('#version').setValue(data.version);
                var isSessionBreakdown =calendarForm.down('#isSessionBreakdown');
                var dayWiseSchedule =calendarForm.down('#dayWiseScheduleId');
                calendarForm.getForm().findField('dayPerCycle').setValue(data.dayPerCycle);
                dayWiseSchedule.setValue({dayWiseSchedule:data.dayWiseSchedule});
                dayWiseSchedule.setReadOnly(true);
                calendarForm.getForm().findField('dayPerCycle').setReadOnly(true);
                calendarForm.down('#weekStart').setValue({
                    rb: data.weekStart
                });
                var weekdays = data.weeklyOffs;
                var days = new Array();
                for (var i = 0; i < weekdays.length; i++) {
                    days.push(weekdays[i].weekday);
                }
                calendarForm.down('#weeklyOff').setValue({
                    weeklyOffGroup: days
                });
                if(data.status == 'ACTIVE'){
                	data.status = true;
                }else{
                	data.status = false;
                }
                calendarForm.down('#calendarType').reset(); //V2D-368656
                calendarForm.getForm().setValues(data);
                if(doReadOnlyCalIdField){
                	calendarForm.down('#calendarCode').setReadOnly(true);
                }
                var calendarWorkingWeekDays = data.calendarWorkingWeekDays;
                var workingWeekDaysGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
                var worktimingConfigurationGrid = calendarForm.down('worktimingconfigurationgrid');
                var workingWeekDaysStore = workingWeekDaysGrid.getStore();
                var workTimeSlotEditorGridStore = calendarForm.down('#workTimeSlotEditorGrid').getStore();
                workingWeekDaysStore.removeAll();
                workTimeSlotEditorGridStore.removeAll();
                var calendarSlots = data.calendarSlots;
                var count = 0;
                workingWeekDaysStore.getProxy().extraParams = {
                	calendarId : data.id
                };
                workingWeekDaysStore.load();
                isSessionBreakdown.setValue(data.isSessionBreakdown);
                
                var worktimesloteditorgrid=calendarForm.down('worktimesloteditorgrid');
               
                if(data.calendarType == 'EMPLOYEE') {
                	isSessionBreakdown.setVisible(false);
                	isSessionBreakdown.setValue(false);
                	if(data.isSessionBreakdown) {
                		worktimesloteditorgrid.setVisible(true);
                    	worktimingConfigurationGrid.columns[3].setVisible(true);
                    } else {
                		worktimesloteditorgrid.setVisible(false);
                    	worktimingConfigurationGrid.columns[3].setVisible(false);
                    }
                }
                setTimeout(function (){
                	calendarForm.down('#calendarType').setValue(data.calendarType);  //V2D-368656
                },800); 
                var holidaysAndSpecialDaysTabs = calendarForm.down('#holidaysAndSpecialDaysTabStructure');
            }
        });
    },
    /*
     * This function is used for to return Calendar Form component
     */
    getFormComponent: function(tabTitle) {
        if (isNullOrEmpty(tabTitle)) {
            return this.getContentPanel().getActiveTab(); //.down('form');
        } else {
            var menuController = this.getMenuController();
            var tab = menuController.getTab(tabTitle);
            return tab;
        }
    },
    /*
     *  For Delete the calendar from calendar grid 
     */
    deleteCalendar: function() {
        var me = this;
        var grid = this.getCalendarGrid();
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
        	
        	showConfirmMessage(getCommonTranslation('DELETE_CALENDAR'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    var records = grid.getSelectionModel().getSelection()[0];
                    var editTabTitle = getCommonTranslation('EDIT')+" "+ records.get('CALENDAR_NAME');
                    var viewTabTitle = getCommonTranslation('VIEW')+" "+ records.get('CALENDAR_NAME');
                    var editCalendarForm = me.getFormComponent(editTabTitle);
                    var viewCalendarForm = me.getFormComponent(viewTabTitle);
                    if (null != editCalendarForm) {
                        editCalendarForm.close();
                    }
                    if (null != viewCalendarForm) {
                        viewCalendarForm.close();
                    }
                    var id = "";
                    id = records.get("ID");
                    Ext.Ajax.request({
                        type: 'rest',
                        method: 'DELETE',
                        url: SERVERURL.CALENDAR_DELETE + id,
                        async: false,
                        success: function(form, action) {
                            grdStore.reload();
                            showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_CALENDAR_MSG')); //"Calendar  deleted successfully"
                        }
                    });
                
                }
        	});    
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },

    /*
     * For checking condtion before update 
     */
    beforeAddEditCalendar: function() {
        var $this = this;
        var calendarForm = $this.getFormComponent().down('addcalendarform');
        var hiddenCalendarIdField = calendarForm.down('#hiddenCalendarId');
        if (hiddenCalendarIdField.getSubmitValue() == null || hiddenCalendarIdField.getSubmitValue() == "" || hiddenCalendarIdField.getSubmitValue() === undefined) {
            $this.saveAddCalendarForm();
        } else {
        	var calendarId = null;
            var grid = $this.getCalendarGrid();
            var record = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(record)) {
                calendarId = record.get('ID');
                
            }else if(!isNullOrEmpty(hiddenCalendarIdField.getSubmitValue())){
            	calendarId = hiddenCalendarIdField.getSubmitValue();
            }
            if(!isNullOrEmpty(calendarId)){
            	Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.CHECK_MASTER_TIMETABLE,
                    params: {
                        calendarId: calendarId
                    },
                    method: 'GET',
                    success: function(response) {
                        var data = Ext.decode(response.responseText);
                        if (data) {
                        	showConfirmMessage(getCommonTranslation('CALENDAR'), getCommonTranslation('CALENDAR_CONFIRM_MESSAGE'), function(btn, text) {
                                if (btn == 'yes') {
                                	$this.saveAddCalendarForm();
                                }
                        	});    
                        } else {
                            $this.saveAddCalendarForm();
                        }
                    }
                });
            }
        }
    },

    /*
     * Save Add/Edit for Calendar object
     */
    saveAddCalendarForm: function() {
        var this$ = this;
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var submitUrl, isUpdate = false;
        var hiddenCalendarIdField = calendarForm.down('#hiddenCalendarId');
        var holidaysAndSpecialDaysTabs =  this.getCalendarstructure().down('#holidaysandspecialdaystabstructure');
        if (hiddenCalendarIdField.getSubmitValue() == null || hiddenCalendarIdField.getSubmitValue() == "" || hiddenCalendarIdField.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.CALENDAR_CREATE;
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CALENDAR_UPDATE;
            isUpdate = true;
        }
        var grid = this$.getCalendarGrid();
        var jsonFormatFormData = this$.createJsonFormat(calendarForm, hiddenCalendarIdField.getValue());

        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');

        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(response, action) {
                Ext.getBody().unmask();
                holidaysAndSpecialDaysTabs.setDisabled(false);
                var calId = response.responseText;
                if (isUpdate) {
                    if (grid) {
                        grid.getSelectionModel().deselectAll();
                    }
                    var calendarWeekdayGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
                    calendarWeekdayGrid.getSelectionModel().deselectAll(true);
                    if(calendarForm.down('#calendarType').getValue() == 'ACADEMIC'){
                    	calendarForm.down('#workTimeSlotEditorGrid').getStore().removeAll();
                    	calendarForm.down('#workTimeSlotEditorGrid').collapse();
                    }
                    showSuccessMessage(getCommonTranslation('EDIT_CALENDAR'), getCommonTranslation('EDIT_CALENDAR_MSG')); //Calendar updated successfully
                } else {
                    hiddenCalendarIdField.setValue(calId);
                    calendarForm.down('#calendarWorkingWeekDaysGrid').setVisible(true);
                    calendarForm.down('#workTimeSlotEditorGrid').setVisible(true);
                    calendarForm.down('#calendarType').setReadOnly(true);
                    calendarForm.down('#isSessionBreakdown').setReadOnly(true);
                    calendarForm.down('#resetButtonId').setVisible(false);
                    showSuccessMessage(getCommonTranslation('ADD_CALENDAR'), getCommonTranslation('ADD_CALENDAR_MSG'));
                }
                var params = {
                    id: calId
                };
                this$.setDataToCalendarForm(calendarForm, params);
                if (grid) {
                    grid.getStore().reload();
                }
            }
        });
    },
    /*
     * creating the json data for Add/Edit calendar for save 
     */
    createJsonFormat: function(calendarForm, hiddenCalendarId) {
        var workTimingGridStore = calendarForm.down('#calendarWorkingWeekDaysGrid').getStore();
        var workTimeSlotEditorGridStore = calendarForm.down('#workTimeSlotEditorGrid').getStore();
        var calendarWorkingWeekDaysArray = new Array();
        var calendarFormValuesObj = new Object();
        var calendarCode = calendarForm.down('#calendarCode').getValue();
        var version = calendarForm.down('#version').getValue();
        var calendarName = calendarForm.down('#calendarName').getValue();
        var calendarDescription = calendarForm.down('#calendarDescription').getValue();
        var weekStart = calendarForm.down('radiogroup[itemId=weekStart]').getValue();
        var weeklyOffValues = calendarForm.down('checkboxgroup[itemId=weeklyOff]').getChecked();
        var status = calendarForm.down("combo[itemId=calendarStatus]").getValue();
        var calendarType = calendarForm.down("combo[itemId=calendarType]").getValue();
        var isSessionBreakdown = calendarForm.down("checkbox[itemId=isSessionBreakdown]").getValue();
        var dayWiseSchedule = calendarForm.getForm().findField('dayWiseSchedule').getValue();
        var dayPerCycle = calendarForm.down('#dayPerCycleId').getValue();
        
        calendarFormValuesObj.id = hiddenCalendarId;
        calendarFormValuesObj.version = version;
        calendarFormValuesObj.code = calendarCode; //": "xyz",
        calendarFormValuesObj.name = calendarName; //"test",
        calendarFormValuesObj.description = calendarDescription; // "test 1",
        if (status) {
            calendarFormValuesObj.status = "ACTIVE"; //": "ACTIVE"
        } else {
            calendarFormValuesObj.status = "INACTIVE"; //": "INACTIVE"
        }
        calendarFormValuesObj.calendarType=calendarType;
        calendarFormValuesObj.isSessionBreakdown=isSessionBreakdown;
        calendarFormValuesObj.weekStart = weekStart.rb; //": "MONDAY",
        calendarFormValuesObj.calendarInitSetupComplete = true;
        calendarFormValuesObj.dayWiseSchedule = dayWiseSchedule;
        calendarFormValuesObj.dayPerCycle = dayPerCycle;
        var weeklyOffs = new Array();
        Ext.each(weeklyOffValues, function(obj, index) {
            weeklyOffsObj = new Object();
            weeklyOffsObj.weekday = obj.getSubmitValue();
            weeklyOffs.push(weeklyOffsObj);
        });
        calendarFormValuesObj.weeklyOffs = weeklyOffs; //": 
        // Logic for creating object WorkTiming grid and Breaks grid 
        return Ext.encode(calendarFormValuesObj);
    },
    /*
     * This function is used for Adding Work Timing window on Grid.
     */
    addWorkTimingConfiguration: function() {
    	var this$ = this;
    	var calendarForm = this$.getFormComponent().down('addcalendarform');
    	var calendarType = calendarForm.down('#calendarType');
    	var dayPerCycle =  calendarForm.down('#dayPerCycleId').getValue();
    	var values =  calendarForm.down('#dayWiseScheduleId').getValue();
    	if (calendarType.getValue() == "EMPLOYEE") {
    		var window = Ext.widget('worktimingdetailswindow');
    		// V2D-302249 start
    		var weekDayStore =  window.down('#weekday').getStore();
    		weekDayStore.removeAll();
    		weekDayStore.add(Ext.app.weekDayArray);
    		// V2D-302249 end
    		window.show();
    	} else {
    		var window = Ext.widget('worktimingconfigurationformwindow');
    		var weekDayStore =  window.down('#weekday').getStore();
    		weekDayStore.removeAll();
    		weekDayStore.add(Ext.app.weekDayArray);
    		if(values.dayWiseSchedule || values.dayWiseSchedule == 'true') {
    		for(var i=1;i<=dayPerCycle;i++) {
    			weekDayStore.add({
    				'name' : "DAY" + i,
    				'value' : "Day " + i
    			});
    		}
    	}
    		window.show();
    	}
    	this$.updateWeekDaysStoreValues();
    	this$.loadTimeSlot();
    },
    updateWeekDaysStoreValues: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var calendarType = calendarForm.down('#calendarType');
        var weekDaysStore=null;
        if (calendarType.getValue()=="EMPLOYEE") {
        	weekDaysStore=this.getWorktimingdetailswindow().down("combo[itemId=weekday]").getStore();
        } else {
        	weekDaysStore = this.getFrnWorkTimingConfiguration().down("combo[itemId=weekday]").getStore();
        }
        
        var weeklyOffValues = calendarForm.down('checkboxgroup[itemId=weeklyOff]').getChecked();
        Ext.each(weeklyOffValues, function(obj, index) {
            var record = weekDaysStore.findRecord("name", obj.getSubmitValue());
            if (!isEmpty(record)) {
                weekDaysStore.remove(record);
            }
        });
    },
    cancelWorkTimingConfiguration: function() {
        this.getWorkTimingConfigurationFormWindow().close();
    },
    /**
     * Duplicate entry check for 
     */
    duplicateEntryCheckForWorkTiming: function(gridStore, model) {
        var status = false;
        gridStore.each(function(record) {
            if (model.get('id') != record.get('id') && model.get('weekday') == record.get('weekday')) {
                showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DUPLICATE_CHECK'));
                status = true;
            }
        });
        return status;
    },
    saveWorkTimingConfiguration: function() {
    	var this$= this;
        var workTimingConfigurationForm = this.getFrnWorkTimingConfiguration().getForm();
        var window = this.getWorkTimingConfigurationFormWindow();

        var model = new Academia.model.calendar.WorkTimingConfigurationGridModel();
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var weekDayGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
        var timeSlotGrid = calendarForm.down('#workTimeSlotEditorGrid');
        var weekDayGridStore = weekDayGrid.getStore();
        workTimingConfigurationForm.updateRecord(model);
        delete model.data.dbId;
        delete model.data.breaks;
        var weekDayCombo = this.getFrnWorkTimingConfiguration().down('#weekday');
        var formValue = window.down('form').getForm().getValues()
        var startTimeVal = window.down('#startTime').getValue();
        var endTimeVal = window.down('#endTime').getValue();
      
        startTimeVal.setFullYear(1970);
        endTimeVal.setFullYear(1970);
        model.set('calendar', this$.getIdValueJson(calendarForm.down('#hiddenCalendarId').getValue()));
        if(endTimeVal > startTimeVal){
        	if (!isNullOrEmpty(model.get('id'))) {
                var record = weekDayGrid.getSelectionModel().getSelection();
                if (record != "" && record != null && record != undefined) {
                    var duplicateStatus = this.duplicateEntryCheckForWorkTiming(weekDayGridStore, model);
                    if (duplicateStatus == false) {
                        model.set('startTime', formValue.startTime);
                        model.set('endTime',formValue.endTime);
                        var formData = Ext.encode(model.data);
                        Ext.Ajax.request({
                            type: 'rest',
                            url: SERVERURL.SAVE_CALENDAR_WORKING_WEEKDAY,
                            jsonData: formData,
                            method: 'POST',
                            success: function(response, action) {
                            	weekDayGrid.getSelectionModel().deselectAll(true);
                            	timeSlotGrid.getStore().removeAll();
                            	timeSlotGrid.collapse();
                            	weekDayGridStore.getProxy().extraParams = {
                                    calendarId: calendarForm.down('#hiddenCalendarId').getValue()
                                };
                            	weekDayGridStore.load();
                            }
                        });
                    }
                }
            } else {
                var count = weekDayGridStore.getCount();
                model.set('startTime', formValue.startTime);
                model.set('endTime', formValue.endTime);
                var duplicateStatus = this.duplicateEntryCheckForWorkTiming(weekDayGridStore, model);
                if (duplicateStatus == false) {
                	var formData = Ext.encode(model.data);
                	Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.SAVE_CALENDAR_WORKING_WEEKDAY,
                        jsonData: formData,
                        method: 'POST',
                        success: function(response, action) {
                        	weekDayGrid.getSelectionModel().deselectAll(true);
                        	timeSlotGrid.getStore().removeAll();
                        	timeSlotGrid.collapse();
                        	weekDayGridStore.getProxy().extraParams = {
                                calendarId: calendarForm.down('#hiddenCalendarId').getValue()
                            };
                        	weekDayGridStore.load();
                        }
                    });

                }

            }
            window.close();
        }
        else{
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('WORK_TIMING_START_END_TIME_MSG'));
        }
    },
    editWorkTimingConfiguration: function(isView) {
    	var this$ = this; 
        var calendarForm = this$.getFormComponent().down('addcalendarform');
        var weekDaysGrid = calendarForm.down('#calendarWorkingWeekDaysGrid'); //.getStore();
        var calendarType = calendarForm.down('#calendarType');
        //	var grid = this.getWorkTimingConfigurationGrid();
        if (weekDaysGrid.getSelectionModel().getCount() > 0) {
        	
        	if (calendarType.getValue()=="EMPLOYEE") {
        		var window = Ext.widget('worktimingdetailswindow');
        		window.show();
        		this$.updateWeekDaysStoreValues();
        		var worktimingdetailswindow=this$.getWorktimingdetailswindow();
        		
            	var slotField = worktimingdetailswindow.down('#slot');
            	var isSessionBreakdown = calendarForm.down('#isSessionBreakdown');
            	if(isSessionBreakdown.getValue()) {
            		slotField.setVisible(true);
            		slotField.allowBlank = false;
            	} else {
            		slotField.setVisible(false);
            		slotField.allowBlank = true;
            	}
        		
        		var record = weekDaysGrid.getSelectionModel().getSelection()[0];
        		var empWorkTimingConfiguration = this$.getEmpWorkTimingConfiguration();
        		if (!isEmpty(record)) {
        			/*if(!isNullOrEmpty(record.data.startTime))
        				record.data.startTime = new Date(record.data.startTime);
        			if(!isNullOrEmpty(record.data.endTime))
        				record.data.endTime = new Date(record.data.endTime);
        			if(!isNullOrEmpty(record.data.lateComingAllowedTill))
        				record.data.lateComingAllowedTill = new Date(record.data.lateComingAllowedTill);
        			if(!isNullOrEmpty(record.data.earlyGoingAllowedAfter))
        				record.data.earlyGoingAllowedAfter = new Date(record.data.earlyGoingAllowedAfter);

        			*/
        			if(!isNullOrEmpty(record.data.minHoursOfFullDay)) {
        				var dateF = new Date("01/01/2000 "+record.data.minHoursOfFullDay);
        				record.data.minHoursOfFullDay = Ext.Date.format(dateF, 'H:i');
        			}
        			if (!isNullOrEmpty(record.data.minHoursOfHalfDay)) {
        				var dateH = new Date("01/01/2000 "+record.data.minHoursOfHalfDay);
        				record.data.minHoursOfHalfDay = Ext.Date.format(dateH, 'H:i');
        			}
        			if (!isNullOrEmpty(record.data.totalHours)) {
        				var dateTot = new Date("01/01/2000 "+record.data.totalHours);
        				record.data.totalHours = Ext.Date.format(dateTot, 'H:i');
        			}
        			empWorkTimingConfiguration.loadRecord(record);

        			if (isView) {
        				empWorkTimingConfiguration.down('#btnSaveEmployeeWorkTiming').setVisible(false);
        				empWorkTimingConfiguration.loadRecord(record);
        				toggleReadOnlyFormItems(empWorkTimingConfiguration.getForm(), true);
        			}
        		}
        	} else {
        		var winWorkTimingConfigurationForm = Ext.widget('worktimingconfigurationformwindow');
        		winWorkTimingConfigurationForm.show();

        		this$.updateWeekDaysStoreValues();
        		var record = weekDaysGrid.getSelectionModel().getSelection()[0];
        		var winWinWorkTimingConfigurationForm = this$.getFrnWorkTimingConfiguration();
        		if (!isEmpty(record)) {
        			if(!isNullOrEmpty(record.data.startTime)) {
        				winWorkTimingConfigurationForm.down('#startTime').setValue(record.data.startTime);
        			}
        			if(!isNullOrEmpty(record.data.endTime)) {
        				winWorkTimingConfigurationForm.down('#endTime').setValue(record.data.endTime);
        			}
        			winWinWorkTimingConfigurationForm.loadRecord(record);
        			if (isView) {
        				winWinWorkTimingConfigurationForm.down('#btnSaveWorkTimingConfigurationForm').setVisible(false);
        				winWinWorkTimingConfigurationForm.loadRecord(record);
        				toggleReadOnlyFormItems(winWinWorkTimingConfigurationForm.getForm(), true);
        			}
        		}
        	}
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    deleteWorkTimingConfiguration: function() {
    	var this$ = this;
    	var calendarForm = this.getFormComponent().down('addcalendarform');
    	var weekDaysGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
    	var workTimeSlotEditorGrid = calendarForm.down('#workTimeSlotEditorGrid');
    	var weekDaysGridStore = weekDaysGrid.getStore();
    	var workTimeSlotStore = workTimeSlotEditorGrid.getStore();
    	if (weekDaysGrid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				var record = weekDaysGrid.getSelectionModel().getSelection()[0];
    				if (!isEmpty(record)) {
    					if(!isNullOrEmpty(record.get('id'))){
    						var count = workTimeSlotStore.getCount();
    						var calendarSlots = [];
    						for (var i = 0; i < count; i++) {
    							var slotRecord = workTimeSlotStore.getAt(i);
    							if(!isNullOrEmpty(slotRecord.get('id')) && slotRecord.get('slotPurpose') == 'SLOT_SESSION'){
    								calendarSlots.push(slotRecord.get('id'));
    							}
    						}
    						if(calendarSlots.length > 0) {
    							Ext.Ajax.request({
    								type: 'rest',
    								url: SERVERURL.CHECK_MASTER_TIMETABLE,
    								params: {
    									calendarSlots: calendarSlots
    								},
    								method: 'GET',
    								success: function(response) {
    									var data = Ext.decode(response.responseText);
    									if (!data) {
    										this$.removeWorkTimeConfigFromStore(weekDaysGridStore, workTimeSlotStore, calendarSlots, record.get('id'));
    									} else {
    										showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SLOT_ENTRY_PRESENT_FOR_MASTER_TIME_TABLE'));
    									}
    								}
    							});
    						} else {
    							this$.removeWorkTimeConfigFromStore(weekDaysGridStore, workTimeSlotStore, calendarSlots, record.get('id'));
    						}
    					}
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    
    removeWorkTimeConfigFromStore: function(weekDaysGridStore, workTimeSlotStore, calendarSlots, id){
    	var submitURL = '';
    	if(calendarSlots.length > 0) {
    		submitURL = SERVERURL.DELETE_CALENDAR_SLOTS+ '?ids='+calendarSlots.join();
    		Ext.Ajax.request({
    			method : "DELETE",
    			type : 'rest',
    			url :  submitURL,
    			headers : {
    				'Content-Type' : 'application/json'
    			},
    			success : function(form,action) {
    				workTimeSlotStore.reload();
    			}
    		});
    	}
    	submitURL = SERVERURL.DELETE_CALENDAR_WEEKDAYS+ '?id='+id;
		Ext.Ajax.request({
			method : "DELETE",
			type : 'rest',
			url :  submitURL,
			headers : {
				'Content-Type' : 'application/json'
			},
			success : function(form,action) {
				weekDaysGridStore.reload();
			}
		});
    },
    /*
     * Copy the work configuration 
     */
    openCopyWorkTimeWindow: function(){
    	var this$ = this;
    	var copyWorkTimeConfigWindow = this$.getCopyWorkTimeConfigWindow();
    	if(!copyWorkTimeConfigWindow){
    		copyWorkTimeConfigWindow = Ext.widget('copyworktimeconfigwindow');
    	}
    	copyWorkTimeConfigWindow.show();
    },
    filterCopyWeekDayCombo: function(form){
    	var this$ = this;
    	var calendarForm = this$.getFormComponent().down('addcalendarform');
    	var weekDayGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
    	var dayPerCycle = calendarForm.down('#dayPerCycleId').getValue();
    	var values = calendarForm.down('#dayWiseScheduleId').getValue();
        var weekDayGridStore = weekDayGrid.getStore();
    	var weekDayComboStore = form.down('#weekday').getStore();
    	weekDayComboStore.removeAll();
    	weekDayComboStore.add(Ext.app.weekDayArray);
    	if(values.dayWiseSchedule || values.dayWiseSchedule == 'true') {
    		for(var i=1;i<=dayPerCycle;i++) {
    			weekDayComboStore.add({
    				'name' : "DAY" + i,
    				'value' : "Day " + i
    			});
    		}
    	}
    	var weeklyOffValues = calendarForm.down('checkboxgroup[itemId=weeklyOff]').getChecked();
        Ext.each(weeklyOffValues, function(weekOff, index) {
            var record = weekDayComboStore.findRecord("name", weekOff.getSubmitValue());
            if (!isEmpty(record)) {
            	weekDayComboStore.remove(record);
            }
        });
        weekDayGridStore.each(function(storeRecord) {
            var record = weekDayComboStore.findRecord("name", storeRecord.get('weekday'));
            if (!isEmpty(record)) {
            	weekDayComboStore.remove(record);
            }
        });
        
        
    },
    copyWorkTimingConfiguration: function(btn) {
    	var this$ = this;
        var calendarForm = this$.getFormComponent().down('addcalendarform');
        var weekDayGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
        var workTimeSlotEditorGrid = calendarForm.down('#workTimeSlotEditorGrid');
        var weekDayCombo = btn.up('form').down('#weekday');
        if (weekDayGrid.getSelectionModel().getCount() > 0) {
        	var weekDayGridStore = weekDayGrid.getStore();
        	var workTimeSlotStore = workTimeSlotEditorGrid.getStore();
        	var count = weekDayGridStore.getCount();
            var weekDayGridRecord = weekDayGrid.getSelectionModel().getSelection()[0];
            if(!isEmpty(weekDayGridRecord)){
            	var workTimeConfigModel = new Academia.model.calendar.WorkTimingConfigurationGridModel();
            	var weekBreaks =[]; 
            	delete workTimeConfigModel.data.dbId;
            	workTimeConfigModel.set('calendar', this$.getIdValueJson(calendarForm.down('#hiddenCalendarId').getValue()));
            	workTimeConfigModel.set('startTime', weekDayGridRecord.get('startTime'));
            	workTimeConfigModel.set('endTime', weekDayGridRecord.get('endTime'));
            	workTimeConfigModel.set('slot', weekDayGridRecord.get('slot'));
            	workTimeConfigModel.set('weekday', weekDayCombo.getValue());
            	workTimeConfigModel.set('lateComingAllowedTill', weekDayGridRecord.get('lateComingAllowedTill'));
            	workTimeConfigModel.set('earlyGoingAllowedAfter',weekDayGridRecord.get('earlyGoingAllowedAfter'));
            	workTimeConfigModel.set('isNightShift', weekDayGridRecord.get('isNightShift'));
            	workTimeConfigModel.set('totalHours', weekDayGridRecord.get('totalHours'));
            	workTimeConfigModel.set('minHoursOfFullDay',weekDayGridRecord.get('minHoursOfFullDay'));
            	workTimeConfigModel.set('minHoursOfHalfDay',weekDayGridRecord.get('minHoursOfHalfDay'));
            	workTimeConfigModel.set('weekday', weekDayCombo.getValue());
            	
                var workSlotArray = [];
                
                workTimeSlotStore.each(function(record){
                	var workSlotModel = new Academia.model.calendar.WorkTimeSlotModel();
                	delete workSlotModel.data.dbId;
                	delete workSlotModel.data.slotPurpose;
                	delete workSlotModel.data.parentId;
                	delete workSlotModel.data.wsCalendarId;
                	delete workSlotModel.data.sortStartTime;
                	delete workSlotModel.data.sortEndTime;
                	if(record.get('slotPurpose') == 'SLOT_SESSION') {
                		delete workSlotModel.data.wsCalendarWeekDayId;
                		delete workSlotModel.data.breakName;
                    	workSlotModel.set('startTime', record.get('startTime'));
                    	workSlotModel.set('endTime', record.get('endTime'));
                    	workSlotModel.set('period', record.get('period'));
                    	workSlotModel.set('weekday', weekDayCombo.getValue());
                    	workSlotModel.set('calendar', this$.getIdValueJson(calendarForm.down('#hiddenCalendarId').getValue()))
                    	workSlotArray.push(workSlotModel.data);
                	} else {
                		delete workSlotModel.data.calendar;
                		delete workSlotModel.data.weekday;
                		delete workSlotModel.data.period;
                		weekBreaks.push({
	        				  "startTime":record.get('startTime'),
	        				  "endTime": record.get('endTime'),
	        				  "breakName" : 'Break'
	        			  });
                	}
                });
                workTimeConfigModel.set('breaks', weekBreaks);
                var weekFormData = Ext.encode(workTimeConfigModel.data);
                var calendarSlotFormData = Ext.encode(workSlotArray);
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.SAVE_CALENDAR_WORKING_WEEKDAY,
                    jsonData: weekFormData,
                    method: 'POST',
                    success: function(response, action) {
                    	weekDayGrid.getSelectionModel().deselectAll(true);
                    	workTimeSlotStore.removeAll();
                    	workTimeSlotEditorGrid.collapse();
                    	weekDayGridStore.getProxy().extraParams = {
                            calendarId: calendarForm.down('#hiddenCalendarId').getValue()
                        };
                    	weekDayGridStore.load();
                    	if(workSlotArray.length >0){
                    		Ext.Ajax.request({
                				type: 'rest',
                				url: SERVERURL.SAVE_MULTIPLE_CALENDAR_SLOTS,
                				jsonData: calendarSlotFormData,
                				method: 'POST',
                				success: function(response, action) {
                					
                				}
                			});
                    	}
                    }
                });
            }
            this.getCopyWorkTimeConfigWindow().close();
            
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }

    },


    /*
     * This function is used for Adding Breaks window on Grid.
     */
    addSlotOnSelectedDay: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var grid = calendarForm.down('#calendarWorkingWeekDaysGrid');
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection();
            var workTimeSlotFormWindow = Ext.widget('worktimeslotformwindow');
            workTimeSlotFormWindow.show();
            workTimeSlotFormWindow.down('#startTime').setMinValue(record[0].data.startTime);
            workTimeSlotFormWindow.down('#startTime').setMaxValue(record[0].data.endTime);
            workTimeSlotFormWindow.down('#endTime').setMaxValue(record[0].data.endTime);

        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_SELECTION')); //"Please select Record from Work selection grid"
        }
    },
    cancelSlotOnSelectedDay: function() {
        this.getWorkTimeSlotFormWindow().close();
    },
    saveSlotOnSelectedDay: function(btn) {
    	var this$ = this;
    	var period = 1;
    	var addSlotForm = this$.getWorkTimeSlotForm();
    	var addSlotFormWindow = this$.getWorkTimeSlotFormWindow();
    	var addCalendarform = this.getActiveTabfromContentPanel();
    	var workTimeSlotEditorGrid = addCalendarform.down('#workTimeSlotEditorGrid');
    	var workTimeConfigGrid = addCalendarform.down('panel[xtype=worktimingconfigurationgrid]');
    	var workTimeSlotStore = workTimeSlotEditorGrid.getStore();
    	var model = new Academia.model.calendar.WorkTimeSlotModel();
    	var record = workTimeConfigGrid.getSelectionModel().getSelection()[0];
    	var wsCalendarWeekDayId = record.get('id');
    	var weekday = record.get('weekday');
    	addSlotForm.updateRecord(model);
    	var formValue = addSlotForm.getForm().getValues();
    	var startTimeVal = addSlotForm.down('#startTime').getValue();
    	var endTimeVal = addSlotForm.down('#endTime').getValue();
    	var submitUrl = '';
    	if(model.data.slotPurpose == 'SLOT_SESSION') {
    		submitUrl = SERVERURL.SAVE_CALENDAR_SLOTS
    		model.set('calendar', this$.getIdValueJson(addCalendarform.down('#hiddenCalendarId').getValue()));
    		model.set('weekday', weekday);
    		delete model.data.wsCalendarWeekDayId;
    		delete model.data.breakName;
    	} else {
    		submitUrl = SERVERURL.CALENDAR_SPECIAL_DAY_BREAKS_CREATE
    		/*if(!isNullOrEmpty(model.data.id)) {
    			submitUrl = SERVERURL.CALENDAR_SPECIAL_DAY_BREAKS_UPDATE
    		}*/
    		model.set('wsCalendarWeekDayId', wsCalendarWeekDayId);
    		model.set('breakName', 'Break');
    		delete model.data.calendar;
    		delete model.data.weekday;
    		delete model.data.period;
    	}
    	model.set('startTime', formValue.startTime);
    	model.set('endTime', formValue.endTime);
    	delete model.data.dbId;
    	delete model.data.slotPurpose;
    	delete model.data.parentId;
    	delete model.data.wsCalendarId;
    	delete model.data.sortStartTime;
    	delete model.data.sortEndTime;
    	if(endTimeVal > startTimeVal){
    		var count = workTimeSlotStore.count();
    		workTimeSlotStore.clearFilter();
    		var slotRecord = workTimeSlotStore.findRecord('id', model.get('id'), 0, false, true, true);
    		if (!isNullOrEmpty(slotRecord)) {
    			var formData = Ext.encode(model.data);
    			Ext.Ajax.request({
    				type: 'rest',
    				url: submitUrl,
    				jsonData: formData,
    				method: 'POST',
    				success: function(response, action) {
    					workTimeSlotStore.getProxy().extraParams = {
    						calendarId: addCalendarform.down('#hiddenCalendarId').getValue(),
    						weekday:weekday,
    						calendarWeekdayId:wsCalendarWeekDayId
    					};
    					workTimeSlotStore.load();
    					workTimeSlotEditorGrid.getSelectionModel().deselectAll();
    				}
    			});
    		} else {
    			if (count < record.get('slot')) {
    				var formData = Ext.encode(model.data);
    				Ext.Ajax.request({
    					type: 'rest',
    					url: submitUrl,
    					jsonData: formData,
    					method: 'POST',
    					success: function(response, action) {
    						workTimeSlotStore.getProxy().extraParams = {
    							calendarId: addCalendarform.down('#hiddenCalendarId').getValue(),
    							weekday:weekday,
    							calendarWeekdayId:wsCalendarWeekDayId
    						};
    						workTimeSlotStore.load();
    						workTimeSlotEditorGrid.getSelectionModel().deselectAll();
    					}
    				});
    			} else {
    				showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TIME_SLOT_PERIOD_EXCEEDS'));
    			}

    		}
    		addSlotFormWindow.close();
    	}
    	else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('WORK_TIMING_START_END_TIME_MSG'));
    	}
    },
    checkTimeOverlappingInTimeSlot: function(workTimeSlotStore, model) {
        var this$ = this;
        var isOverlap = false;
        if (workTimeSlotStore) {
            for (var i = 0; i < workTimeSlotStore.getCount(); i++) {
                var slot = workTimeSlotStore.getAt(i);
                if (!isEmpty(slot) && slot.get("id") != model.get("id")) {
                    var startTime = this$.getDateWithDefaultFullYear(slot.get("startTime"));
                    var endTime = this$.getDateWithDefaultFullYear(slot.get("endTime"));
                    var checkStartTime = this$.getDateWithDefaultFullYear(model.get("startTime"));
                    var checkEndTime = this$.getDateWithDefaultFullYear(model.get("endTime"));
                    if ((checkStartTime < endTime && checkStartTime > startTime) || (checkEndTime < endTime && checkEndTime > startTime) || (checkStartTime <= startTime && checkEndTime >= endTime)) {
                        isOverlap = true;
                    }
                    if (isOverlap) {
                        break;
                    }
                }
            }

        }

        return isOverlap;
    },

    getDateWithDefaultFullYear: function(date) {
        if (date) {
        	date = new Date(date);
            date.setFullYear(1970);
        }
        return date;
    },
    applyFilterOnWorlSlotGrid: function(store, weekday) {
        store.filter({
            filterFn: function(record) {
                var flag = true;
                if (record.get('weekday') == weekday) {
                    flag = true;
                } else {
                    flag = false;
                }
                return flag;
            }
        }, this);
    },

    editSlotOnSelectedDay: function(isView) {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var workTimeSlotEditorGrid = calendarForm.down('#workTimeSlotEditorGrid');
        var workTimeGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
        var workTimeGridStore = workTimeGrid.getStore();
        
        if (workTimeSlotEditorGrid.getSelectionModel().getCount() > 0) {
            var workTimeSlotFormWindow = Ext.widget('worktimeslotformwindow');
            workTimeSlotFormWindow.show();
            var workRecord = workTimeGrid.getSelectionModel().getSelection()[0];
            var record = workTimeSlotEditorGrid.getSelectionModel().getSelection()[0];
            var workTimeSlotForm = this.getWorkTimeSlotForm();
            if (!isEmpty(record)) {
                	var workStartTime = workRecord.get("startTime");
                    var workEndTime = workRecord.get("endTime");
                    
                    workTimeSlotForm.down('#startTime').setMinValue(workStartTime);
                    workTimeSlotForm.down('#endTime').setMaxValue(workEndTime);
                    
                    /*workTimeSlotForm.down('#startTime').setMinValue(workStartTime);
                    workTimeSlotForm.down('#startTime').setMaxValue(workEndTime);
                    workTimeSlotForm.down('#endTime').setMinValue(workStartTime);
                    workTimeSlotForm.down('#endTime').setMaxValue(workEndTime);*/
                    
                    workTimeSlotForm.down('#startTime').setValue(record.data.startTime);
                    workTimeSlotForm.down('#endTime').setValue(record.data.endTime);
                    
                    /*if(!isNullOrEmpty(record.data.startTime) && typeof record.data.startTime != "object")
                		record.data.startTime = new Date("01/01/1970 "+record.data.startTime);
                	if(!isNullOrEmpty(record.data.endTime) && typeof record.data.endTime != "object")
                		record.data.endTime = new Date("01/01/1970 "+record.data.endTime);*/
                	
                    workTimeSlotForm.loadRecord(record);
                //}
                
                if (isView) {
                    workTimeSlotForm.down('#btnSaveSlotOnSelectedDayForm').setVisible(false);
                    workTimeSlotForm.loadRecord(record);
                    toggleReadOnlyFormItems(workTimeSlotForm.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    deleteSlotOnSelectedDay: function() {
    	var this$ = this;
    	var calendarForm = this.getFormComponent().down('addcalendarform');
    	var workTimeSlotEditorGrid = calendarForm.down('#workTimeSlotEditorGrid');
    	var workTimeSlotStore = workTimeSlotEditorGrid.getStore();
    	if (workTimeSlotEditorGrid.getSelectionModel().getCount() > 0) {
    		var slotRecord = workTimeSlotEditorGrid.getSelectionModel().getSelection()[0];
    		showConfirmMessage(getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    			if (btn == 'yes') {
    				if (!isEmpty(slotRecord)) {
    					if(!isNullOrEmpty(slotRecord.get('id'))){
    						if(slotRecord.get('slotPurpose') == 'SLOT_SESSION'){
    							var calendarSlots = [];
    							calendarSlots.push(slotRecord.get('id'));
    							Ext.Ajax.request({
    								type: 'rest',
    								url: SERVERURL.CHECK_MASTER_TIMETABLE,
    								params: {
    									calendarSlots: calendarSlots
    								},
    								method: 'GET',
    								success: function(response) {
    									var data = Ext.decode(response.responseText);
    									if (!data) {
    										var submitURL = '';
    										var id = slotRecord.get('id');
    										var ids = [];
    										ids.push(id);
    										submitURL = SERVERURL.DELETE_CALENDAR_SLOTS+ '?ids='+ids.join();
    										Ext.Ajax.request({
    											method : "DELETE",
    											type : 'rest',
    											url :  submitURL,
    											headers : {
    												'Content-Type' : 'application/json'
    											},
    											success : function(form,action) {
    												workTimeSlotStore.reload();
    											}
    										});
    									} else {
    										showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SLOT_ENTRY_PRESENT_FOR_MASTER_TIME_TABLE'));
    									}
    								}
    							});
    						} else {
    							var id = slotRecord.get('id');
    							submitURL = SERVERURL.CALENDAR_SPECIAL_DAY_BREAKS_DELETE+id;
    							Ext.Ajax.request({
    								method : "DELETE",
    								type : 'rest',
    								url :  submitURL,
    								headers : {
    									'Content-Type' : 'application/json'
    								},
    								success : function(form,action) {
    									workTimeSlotStore.reload();
    								}
    							});
    						}
    					}
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    /*
     * This function is used for Adding Holdiays on Grid.
     */
    addHolidayListRecord: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var grid = calendarForm.down('#holidayListGrid');
        grid.showHolidayListForm();
    },
    /*
     * For Edit and View of Holiday Grid records.
     */
    editHolidayListRecord: function(isView) {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var grid = calendarForm.down('#holidayListGrid');
        if (grid.getSelectionModel().getCount() > 0) {
            grid.showHolidayListForm();
            var record = grid.getSelectionModel().getSelection();
            var holidayListForm = this.getFrnHolidayList();
            if (record != "" && record != null && record != undefined) {
            	if(!isNullOrEmpty(record[0].data.fromDate))
             		record[0].data.fromDate = new Date(record[0].data.fromDate);
             	if(!isNullOrEmpty(record[0].data.toDate))
             		record[0].data.toDate = new Date(record[0].data.toDate);
                holidayListForm.loadRecord(record[0]);
                if (isView) {
                    holidayListForm.down('#btnSaveHolidayListForm').setVisible(false);
                    holidayListForm.loadRecord(record[0]);
                    toggleReadOnlyFormItems(holidayListForm.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    cancelHolidayListForm: function() {
        this.getWinHolidayListForm().close();
    },
    /*
     * To Add and Edit Save for Holidays Grid according to grid.
     */
    saveHolidayListForm: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var holidayListForm = this.getFrnHolidayList(); //.getForm();
        var window = this.getWinHolidayListForm();
        var model = new Academia.model.calendar.HolidayListGridModel();
        holidayListForm.updateRecord(model);
        var submitUrl, isUpdate = false;
        var hiddenHolidayId = holidayListForm.down('#hidden_id_field');
        if (hiddenHolidayId.getSubmitValue() == null || hiddenHolidayId.getSubmitValue() == "" || hiddenHolidayId.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.CALENDAR_HOLIDAY_CREATE;
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CALENDAR_HOLIDAY_UPDATE;
            isUpdate = true;
        }
        var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
        var jsonFormatFormData = this.createJsonFormatForHolidays(holidayListForm, calendarForm);
        var holidayGridStore = calendarForm.down('#holidayListGrid').getStore();
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(response) {
                holidayGridStore.getProxy().extraParams = {
                    calendarId: calendarId
                };
                holidayGridStore.reload();

                var calId = response.responseText;
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('CALENDAR_HOLIDAY'), getCommonTranslation('CALENDAR_HOLIDAY_EDIT_MSG')); //Holiday updated Successfully
                } else {
                    showSuccessMessage(getCommonTranslation('CALENDAR_HOLIDAY'), getCommonTranslation('CALENDAR_HOLIDAY_ADD_MSG')); //Holiday updated successfully
                }
            },
            failure: function(form, action) {
                window.close();
            }
        });
        window.close();
    },
    createJsonFormatForHolidays: function(holidayListForm, calendarForm) {
        var calendarHolidayses = new Object();
        calendarHolidayses.fromDate = holidayListForm.down("#fromDate").getSubmitValue();
        calendarHolidayses.toDate = holidayListForm.down("#toDate").getSubmitValue();
        calendarHolidayses.holidayReason = holidayListForm.down("#holidayReason").getValue();
        calendarHolidayses.id = holidayListForm.down('#hidden_id_field').getValue();
        calendarHolidayses.calendarId = calendarForm.down('#hiddenCalendarId').getValue();
        calendarHolidayses.version = holidayListForm.down('#version').getValue();
        return Ext.encode(calendarHolidayses);
    },
    /*
     * For Delete the record of Holiday Grid.
     */
    deleteHolidayListRecord: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var holidayGrid = calendarForm.down('#holidayListGrid');
        var holidayGridStore = holidayGrid.getStore();
        if (holidayGrid.getSelectionModel().getCount() > 0) {
        	showConfirmMessage(getCommonTranslation('CALENDAR_HOLIDAY'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (holidayGrid.getSelectionModel().getCount() > 0) {
                        var records = holidayGrid.getSelectionModel().getSelection();
                        var id = "";
                        id = records[0].get("id");
                        Ext.Ajax.request({
                            type: 'rest',
                            method: 'DELETE',
                            url: SERVERURL.CALENDAR_HOLIDAY_DELETE + id,
                            async: false,
                            success: function(form, action) {
                                holidayGridStore.reload();
                                showSuccessMessage(getCommonTranslation('CALENDAR_HOLIDAY'), getCommonTranslation('CALENDAR_HOLIDAY_DELETE_MSG')); //Holiday updated successfully
                            }
                        });
                    }
                }
        	}); 
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    /*
     * For Adding special Days on Grid for calendar. 
     */
    addSpecialDayRecord: function() {
        //var calendarForm= this.getFormComponent();
        //var grid = calendarForm.down('#specialDaysGrid');
        this.showSpecialDaysForm();
    },
    showSpecialDaysForm: function() {
        var winSpecialDaysForm = Ext.widget('specialDaysFormWindow');
        winSpecialDaysForm.show();
    },
    /*
     * For Edit Special Days record on Grid.
     */
    editSpecialDayRecord: function(isView) {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var grid = calendarForm.down('#specialDaysGrid');
        if (grid.getSelectionModel().getCount() > 0) {
            this.showSpecialDaysForm();
            var record = grid.getSelectionModel().getSelection();
            var specialDaysForm = this.getFrnSpecialDays();
            if (record != "" && record != null && record != undefined) {
                specialDaysForm.loadRecord(record[0]);
                if (isView) {
                    specialDaysForm.down('#btnSaveSpecialDaysForm').setVisible(false);
                    //specialDaysForm.down('#btnCancelSpecialDaysForm').setVisible(false);
                    specialDaysForm.loadRecord(record[0]);
                    toggleReadOnlyFormItems(specialDaysForm.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    /*
     * For Delete the Special Days from Grid.
     */
    deleteSpecialDayRecord: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var specialDaysGrid = calendarForm.down('#specialDaysGrid');
        var specialDaysGridStore = specialDaysGrid.getStore();
        if (specialDaysGrid.getSelectionModel().getCount() > 0) {
            Ext.MessageBox.show({
                title: getCommonTranslation('CALENDAR_SPECIAL_DAYS'),
                msg: getCommonTranslation('DELETE_CONFIRM_MESSAGE'), //Are you sure you want to delete the selected record?			
                buttons: Ext.MessageBox.OKCANCEL,
                icon: Ext.MessageBox.QUESTION,
                fn: function(btn, text) {
                    if (btn == 'ok') {
                        if (specialDaysGrid.getSelectionModel().getCount() > 0) {
                            var records = specialDaysGrid.getSelectionModel().getSelection();
                            var id = "";
                            id = records[0].get("id");
                            Ext.Ajax.request({
                                type: 'rest',
                                method: 'DELETE',
                                url: SERVERURL.CALENDAR_SPECIAL_DAYS_DELETE + id, //'rest/calendarSpecialDay/delete?id='+id,					
                                async: false,
                                success: function(form, action) {
                                    specialDaysGridStore.reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('CALENDAR_SPECIAL_DAY_DELETE_MSG')); //Special Days record deleted successfully
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    cancelSpecialDaysForm: function() {
        this.getWinSpecialDaysForm().close();
    },
    /*
     * For save Add/Edit Special Days form window.
     */
    saveSpecialDaysForm: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var specialDaysForm = this.getFrnSpecialDays(); //.getForm();
        var window = this.getWinSpecialDaysForm();
        var model = new Academia.model.calendar.SpecialDaysGridModel();
        specialDaysForm.updateRecord(model);
        var submitUrl, isUpdate = false;
        var hiddenSpecialDayId = specialDaysForm.down('#hidden_id_field');
        if (hiddenSpecialDayId.getSubmitValue() == null || hiddenSpecialDayId.getSubmitValue() == "" || hiddenSpecialDayId.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.CALENDAR_SPECIAL_DAYS_CREATE; //'rest/calendarSpecialDay/create';
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.CALENDAR_SPECIAL_DAYS_UPDATE; //'rest/calendarSpecialDay/update';
            isUpdate = true;
        }
        var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
        var jsonFormatFormData = this.createJsonFormatForSpecialDays(specialDaysForm, calendarForm);
        var specialDaysGrid = calendarForm.down('#specialDaysGrid');
        var specialDayBreaksGrid = calendarForm.down('#specialDayBreaksGrid');
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(response) {
                specialDaysGrid.getStore().getProxy().extraParams = {
                    calendarId: calendarId
                };
                specialDaysGrid.getStore().reload();
                specialDaysGrid.getSelectionModel().deselectAll();
                specialDayBreaksGrid.getStore().removeAll();
                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('CALENDAR_SPECIAL_DAYS'), getCommonTranslation('CALENDAR_SPECIAL_DAY_EDIT_MSG')); //Special day record updated Successfully
                } else {
                    showSuccessMessage(getCommonTranslation('CALENDAR_SPECIAL_DAYS'), getCommonTranslation('CALENDAR_SPECIAL_DAY_ADD_MSG')); //Special day record added Successfully
                }
            }
        });
        window.close();
    },
    createJsonFormatForSpecialDays: function(specialDaysForm, calendarForm) {
        //var calendarSpecialDays = new Object();
        var calendarSpecialDays = specialDaysForm.getValues();
        calendarSpecialDays.calendarId = calendarForm.down('#hiddenCalendarId').getValue();
        calendarSpecialDays.breaks = new Array();
        return Ext.encode(calendarSpecialDays);
    },
    /*
     * Adding the special day breaks grid record.
     */
    addSpecialDayBreaksRecord: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var grid = calendarForm.down('#specialDaysGrid');
        if (grid.getSelectionModel().getCount() > 0) {
            var record = grid.getSelectionModel().getSelection();
            var winSpecialDayBreaksForm = Ext.widget('specialDayBreaksFormWindow');
            winSpecialDayBreaksForm.down('#startTime').setMinValue(record[0].data.startTime);
            winSpecialDayBreaksForm.down('#startTime').setMaxValue(record[0].data.endTime);
            winSpecialDayBreaksForm.down('#endTime').setMinValue(record[0].data.startTime);
            winSpecialDayBreaksForm.down('#endTime').setMaxValue(record[0].data.endTime);
            winSpecialDayBreaksForm.show();
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_SPECIAL_DAYS_SELECTION')); //Please select a record
        }
    },
    /*
     * For Edit and View of Special days breaks Record on Grid. 
     */
    editSpecialDayBreaksRecord: function(isView) {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var grid = calendarForm.down('#specialDayBreaksGrid');
        if (grid.getSelectionModel().getCount() > 0) {
            grid.showSpecialDayBreaksForm();
            var record = grid.getSelectionModel().getSelection();
            var specialDayBreaksForm = this.getFrnSpecialDayBreaks();
            if (record != "" && record != null && record != undefined) {
                var specialDaysgrid = calendarForm.down('#specialDaysGrid');
                if (specialDaysgrid.getSelectionModel().getCount() > 0) {
                    var specialDayRecord = specialDaysgrid.getSelectionModel().getSelection();
                    if (specialDayRecord != "" && specialDayRecord != null && specialDayRecord != undefined) {
                        var startTime = specialDayRecord[0].data.startTime;
                        var endTime = specialDayRecord[0].data.endTime;
                        specialDayBreaksForm.down('#startTime').setMinValue(startTime);
                        specialDayBreaksForm.down('#startTime').setMaxValue(endTime);
                        specialDayBreaksForm.down('#endTime').setMinValue(startTime);
                        specialDayBreaksForm.down('#endTime').setMaxValue(endTime);
                    }
                }
                specialDayBreaksForm.loadRecord(record[0]);
                if (isView) {
                    specialDayBreaksForm.down('#btnSaveSpecialDayBreaksForm').setVisible(false);
                    specialDayBreaksForm.down('#btnCancelSpecialDayBreaksForm').setVisible(false);
                    specialDayBreaksForm.loadRecord(record[0]);
                    toggleReadOnlyFormItems(specialDayBreaksForm.getForm(), true);
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    cancelSpecialDayBreaksForm: function() {
        this.getWinSpecialDayBreaksForm().close();
    },
    /*
     * For save Add/Edit Special Day Breaks form window.
     */
    saveSpecialDayBreaksForm: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var specialDayBreaksForm = this.getFrnSpecialDayBreaks(); //.getForm();
        var window = this.getWinSpecialDayBreaksForm();
        var model = new Academia.model.calendar.SpecialDayBreaksGridModel();
        specialDayBreaksForm.updateRecord(model);
        var submitUrl, isUpdate = false,
            wsCalendarWeekDayId = "";
        var hiddenSpecialDayBreaksId = specialDayBreaksForm.down('#hidden_id_field');
        var specialDaysGrid = calendarForm.down('#specialDaysGrid');
        if (hiddenSpecialDayBreaksId.getSubmitValue() == null || hiddenSpecialDayBreaksId.getSubmitValue() == "" || hiddenSpecialDayBreaksId.getSubmitValue() === undefined) {
            submitUrl = SERVERURL.CALENDAR_SPECIAL_DAY_BREAKS_CREATE; //'rest/calendarBreak/create';
            isUpdate = false;
            if (specialDaysGrid.getSelectionModel().getCount() > 0) {
                var record = specialDaysGrid.getSelectionModel().getSelection();
                if (record != "" && record != null && record != undefined) {
                    wsCalendarWeekDayId = record[0].get("id");
                }
            }
        } else {
            submitUrl = SERVERURL.CALENDAR_SPECIAL_DAY_BREAKS_UPDATE;
            isUpdate = true;
            if (specialDaysGrid.getSelectionModel().getCount() > 0) {
                var record = specialDaysGrid.getSelectionModel().getSelection();
                if (record != "" && record != null && record != undefined) {
                    wsCalendarWeekDayId = record[0].get("id");
                }
            }
            //wsCalendarWeekDayId = specialDayBreaksForm.down('#wsCalendarWeekDayId').getValue();
        }
        var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
        var jsonFormatFormData = this.createJsonFormatForSpecialDayBreaks(specialDayBreaksForm, calendarForm, wsCalendarWeekDayId);
        var specialDayBreaksGrid = calendarForm.down('#specialDayBreaksGrid').getStore();
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: 'POST',
            success: function(response) {
                specialDayBreaksGrid.getProxy().extraParams = {
                    weekDayId: wsCalendarWeekDayId
                };
                specialDayBreaksGrid.reload();

                if (isUpdate) {
                    showSuccessMessage(getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS'), getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS_EDIT_MSG')); //Special day Break record updated Successfully
                } else {
                    showSuccessMessage(getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS'), getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS_ADD_MSG')); //"Special day Break added Successfully"
                }
            },
            failure: function(form, action) {
                window.close();
            }
        });
        window.close();
    },
    createJsonFormatForSpecialDayBreaks: function(specialDayBreaksForm, calendarForm, wsCalendarWeekDayId) {
        //var breaks = new Object();
        var breaks = specialDayBreaksForm.getValues();
        breaks.wsCalendarWeekDayId = wsCalendarWeekDayId;
        breaks.wsCalendarId = calendarForm.down('#hiddenCalendarId').getValue();
        //breaks.breaks = new Array();
        return Ext.encode(breaks);
    },
    /*
     * For Delete the Special Day Breaks from Grid.
     */
    deleteSpecialDayBreaksRecord: function() {
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var specialDayBreaksGrid = calendarForm.down('#specialDayBreaksGrid');
        var specialDayBreaksGridStore = specialDayBreaksGrid.getStore();
        if (specialDayBreaksGrid.getSelectionModel().getCount() > 0) {
            Ext.MessageBox.show({
                title: getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS'),
                msg: getCommonTranslation('DELETE_CONFIRM_MESSAGE'), //Are you sure you want to delete the selected record?			
                buttons: Ext.MessageBox.OKCANCEL,
                icon: Ext.MessageBox.QUESTION,
                fn: function(btn, text) {
                    if (btn == 'ok') {
                        if (specialDayBreaksGrid.getSelectionModel().getCount() > 0) {
                            var records = specialDayBreaksGrid.getSelectionModel().getSelection();
                            var id = "";
                            id = records[0].get("id");
                            Ext.Ajax.request({
                                type: 'rest',
                                method: 'DELETE',
                                url: SERVERURL.CALENDAR_SPECIAL_DAY_BREAKS_DELETE + id, //'rest/calendarBreak/delete?id='+id,/				
                                async: false,
                                success: function(form, action) {
                                    specialDayBreaksGridStore.reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS_DELETE_MSG')); //Special days break deleted successfully
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
        }
    },
    /**
     * This is the function to add Entity List Tab.
     * 
     */
    entityListMenuClicked: function() {
        var me = this;
        var grid = me.getCalendarGrid();
        if (grid.getSelectionModel().getCount() > 0) {
            var records = grid.getSelectionModel().getSelection();
            if (records != "" && records != null && records != undefined) {
                var rec = records[0];
                if (!isNullOrEmpty(rec.get('ID'))) {
                    var tabName = rec.get("CALENDAR_NAME") + " - " + getCommonTranslation('ENTITY_LIST');
                    var menuController = me.getMenuController();
                    menuController.addTab(tabName, 'entitylist', CONSTANTS.MENU_COLOR_THIRTEEN);
                    var entityList = this.getEntityList();
                    var entityForm = entityList.down('#entityform');
                    entityForm.down('#calendarId_hidden').setValue(rec.get("ID"));
                    var facultyStore = me.getGrdFaculty().getStore();
                    var userStore = me.getGrdUser().getStore();
                    var calendarAcademyLocationStore = me.getGrdCalendarAcademyLocation().getStore();
                    var facililtyStore = me.getGrdFacility().getStore();

                    var equipmentStore = me.getGrdEquipment().getStore();
                    
                    facultyStore.currentPage = 1;
                    /*facultyStore.load({
                        params: {
                            calendarId: rec.get("ID")
                        }
                    });
                    */
                    facultyStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    facultyStore.load();

                    var checkBoxCalendarAcademyloctaions = me.getGrdCalendarAcademyLocation().down('#chkOrg');

                    var isOrgLinked = this.checkLinkedOrganization(rec.get("ID"));
                    if (isOrgLinked) {
                        checkBoxCalendarAcademyloctaions.setValue(true);
                    } else {
                        checkBoxCalendarAcademyloctaions.setValue(false);
                    }
                    userStore.currentPage = 1;
                    userStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    userStore.load();
                    /*userStore.load({
                        params: {
                            calendarId: rec.get("ID")
                        }
                    });*/
                    calendarAcademyLocationStore.currentPage = 1;
                    calendarAcademyLocationStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    calendarAcademyLocationStore.load();
                    /*calendarAcademyLocationStore.load({
                        params: {
                            calendarId: rec.get("ID")
                        }
                    });*/
                    facililtyStore.currentPage = 1;
                    facililtyStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    facililtyStore.load();
                    /*facililtyStore.load({
                        params: {
                            calendarId: rec.get("ID"),
                        	limit:CONSTANTS.DEFAULT_PAGESIZE
                        }
                    });*/
                    
                    
                    
                    equipmentStore.currentPage = 1;
                    equipmentStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    equipmentStore.load();
                    /*equipmentStore.load({
                        params: {
                            calendarId: rec.get("ID")
                        }
                    });*/
                    calendarAcademyLocationStore.currentPage = 1;
                    calendarAcademyLocationStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    calendarAcademyLocationStore.load();
                    /*calendarAcademyLocationStore.load({
                        params: {
                            calendarId: rec.get("ID")
                        }
                    });*/

                    var courseVarStore = me.getGrdCourseVariant().getStore();
                    courseVarStore.currentPage = 1;
                    courseVarStore.getProxy().extraParams = {
                    	calendarId: rec.get("ID"),
                    	limit:CONSTANTS.DEFAULT_PAGESIZE
                    };
                    courseVarStore.load();
                    /*courseVarStore.load({
                        params: {
                            calendarId: rec.get("ID")
                        }
                    });*/
                }
            }
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    /**
     * This is the function to get the calendar id
     * 
     */
    getCalendarId: function() {
        var entityList = this.getEntityList();
        var entityForm = entityList.down('#entityform');
        var calendarId = entityForm.down('#calendarId_hidden').getValue();
        return calendarId;
    },
    /*
     * This function is used for to check whether the calendar is associated with the organization 
     */
    checkLinkedOrganization: function(calendarId) {
        var isLinked = false;
        Ext.Ajax.request({
            type: 'rest',
            async: false,
            method: 'GET',
            url: SERVERURL.CALENDAR_ENTITY_CHECK_ORG,
            params: {
                calendarId: calendarId
            },
            success: function(form, action) {
                isLinked = form.responseText;
            }
        });
        return isLinked;
    },
    getMenuController: function() {
        return Academia.app.getController('menu.CoreERPNavigationController');
    },
    
    openMappingALWindow: function() {
    	var me = this;
    	var grid = me.getCalendarGrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		if (records != "" && records != null && records != undefined) {
    			var rec = records[0];
    			var calId = rec.get('ID');
    			if (!isNullOrEmpty(calId)) {
    				var formWindow = me.getCalacademyLocationwin();
    				if (!formWindow) {
    					Ext.widget('calacademyLocationwin');
    					formWindow = me.getCalacademyLocationwin();
    				}
    				formWindow.show();
    				
    				var gridAcademic = me.getCalacademylocationgrid();
    				Ext.apply(gridAcademic,{
    					codeAL:null,
    					setCodeAL : function(codeAL){
    						gridAcademic.codeAL = codeAL;
    					},
    					getCodeAL:function(){
    						return gridAcademic.codeAL;
    					}
    				});
    				gridAcademic.getStore().getProxy().extraParams = {
    					calendarId:calId
    				};
    				var arrr = [];
    				gridAcademic.getStore().load({
    					callback: function(records, operation, success) {
    						if (success) {
    							if(records.length > 0){
    								if(gridAcademic.getSelectionModel().getCount()>0){
    									gridAcademic.getSelectionModel().deselectAll();
    								}
    								for(i in records){
    									if(records[i].data.whetherMapped){
    										gridAcademic.getSelectionModel().select(records[i],true);
    										arrr.push(records[i]);
    									}
    								}
    							}		 
    						}
    					}	   
    				});
    				gridAcademic.setCodeAL(arrr);
    			}
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },

    mapAcademyLocations: function(button) {
    	button.setDisabled(true);
    	var $this = this;

    	var grid = $this.getCalendarGrid();
    	var rec = grid.getSelectionModel().getSelection()[0];
    	var calId = rec.get('ID');

    	var acdemylocGrid = $this.getCalacademylocationgrid();
    	var calendarGrid = $this.getCalendarGrid();
    	var arr=[],datatosave= new Object(); 
    	if (acdemylocGrid.getSelectionModel().getCount() > 0) {
    		var records = acdemylocGrid.getSelectionModel().getSelection();
    		for(var i in records) {
    			var jsonObj={
					"id": records[i].data.id,
					"version":records[i].data.version,
					"academyLocationId":records[i].data.academyLocationId,
					"academyLocationName":records[i].data.academyLocationName
    			}
    			arr.push(jsonObj);
    		}

    	datatosave={
    		'calendarId':calId,
    		'academyLocations':arr
    	}

    	var submitUrl; 
    	var message;
    	submitUrl = SERVERURL.CALENDAR_MAP_AL; 
    	message = getCommonTranslation('CALENDAR_ACADEMY_LOCATIONS_MAP_SUCCESSFULLY');
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : datatosave,
    		method : 'POST',
    		success : function(frm, action) {
    			Ext.getBody().unmask();
    			grid.getStore().reload(); 
    			$this.getCalacademyLocationwin().close();  
    			showSuccessMessage(getCommonTranslation('CALENDAR_ACADEMY_LOCATION_MAPPING'), message);

    		}
    	});
    	}else{
    		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
    		 button.setDisabled(false);
    	}

    },
    
    loadCalendarType: function(combo, records) {
    	var $this = this;
    	var calendarForm = $this.getFormComponent().down('addcalendarform');
    	var calendarType = calendarForm.down('#calendarType');
    	var isSessionBreakdown = calendarForm.down('#isSessionBreakdown');
    	var worktimesloteditorgrid=calendarForm.down('worktimesloteditorgrid');
    	var worktimingConfigurationGrid = calendarForm.down('worktimingconfigurationgrid');
    	var dayWiseSchedule = calendarForm.down('#dayWiseScheduleId');
    	var dayPerCycle = calendarForm.down('#dayPerCycleId');
    	if (calendarType.getValue()=="EMPLOYEE") {
    		//isSessionBreakdown.setVisible(true);
    		isSessionBreakdown.setValue(false);
    		worktimesloteditorgrid.setVisible(false);
    		worktimingConfigurationGrid.columns[3].setVisible(false);
    		dayWiseSchedule.reset();
    		dayWiseSchedule.setVisible(false);
    		dayPerCycle.setVisible(false);
    		this.setAllowBlank(dayPerCycle,true);
    	} else {
    		isSessionBreakdown.setVisible(false);
    		worktimesloteditorgrid.setVisible(true);
    		worktimingConfigurationGrid.columns[3].setVisible(false);
    		dayWiseSchedule.setVisible(true);
    		dayPerCycle.setVisible(false);
    	}
    },
    
    loadSessionBreakdown: function(me, newValue, oldValue, eOpts){
     	var $this = this;
    	var calendarForm = $this.getFormComponent().down('addcalendarform');
    	var worktimingConfigurationGrid = calendarForm.down('worktimingconfigurationgrid');
    	var worktimesloteditorgrid=calendarForm.down('worktimesloteditorgrid');
    	//var workingdetailsWindow = $this.getWorktimingdetailswindow();
    	//var slotField = workingdetailsWindow.down('#slot');
    	var isSessionBreakdown = calendarForm.down('#isSessionBreakdown');
    	 var models = worktimingConfigurationGrid.getStore().getRange();
    	if(isSessionBreakdown.getValue()) {
    		//slotField.setVisible(true);
    		worktimesloteditorgrid.setVisible(true);
    		worktimingConfigurationGrid.columns[3].setVisible(true);
    		
    	} else {
    		//slotField.setVisible(false);
    		worktimesloteditorgrid.setVisible(false);
    		worktimingConfigurationGrid.columns[3].setVisible(false);
    		for (var i=0;i<models.length;i++) { 
    			models[i].set('slot',"");
    		}
    	}
    },
    cancelWorkTimingDetailsWindow: function() {
        this.getWorktimingdetailswindow().close();
    },
    totalHoursCalculation: function(combo, records) {
    	var $this = this;
    	var calendarForm = $this.getFormComponent().down('addcalendarform');
    	var workingdetailsWidow = $this.getWorktimingdetailswindow();
    	var totalHoursField = workingdetailsWidow.down('#totalHours');
    	var startTime = workingdetailsWidow.down('#startTime').getValue();
    	var endTime = workingdetailsWidow.down('#endTime').getValue();
    	var minHoursOfFullDayItemId = workingdetailsWidow.down('#minHoursOfFullDayItemId');
    	var minHoursOfHalfDayItemId = workingdetailsWidow.down('#minHoursOfHalfDayItemId');
    	if (!isNullOrEmpty(startTime) && !isNullOrEmpty(endTime)) {
    	    var inTimeDate = new Date(startTime);
    	    inTimeDate.setFullYear(1970);
    	    var inTimeInMiliSeconds = inTimeDate.getTime();
    	    var outTimeDate = new Date(endTime);
    	    outTimeDate.setFullYear(1970);
    	    var outTimeInMiliSeconds = outTimeDate.getTime();

    	    var timeDiff = outTimeInMiliSeconds - inTimeInMiliSeconds;

    	    if (timeDiff < 0)
    	        timeDiff = 86400000 + timeDiff;
    	    var totalTimeInMinutes = (timeDiff / 60000);
    	    var minutes = 0,
    	        hours = 0;
    	    var minutes = 0 + '' + (totalTimeInMinutes % 60);
    	    var hours = 0 + '' + (totalTimeInMinutes - minutes) / 60;
    	    var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
    	    totalHoursField.setValue(totalTime);

    	    var newDateForTime = new Date(timeDiff);
    	    var newDateForTime = new Date(newDateForTime.valueOf() + newDateForTime.getTimezoneOffset() * 60000);
    	    minHoursOfFullDayItemId.setMaxValue(newDateForTime);
    	    minHoursOfHalfDayItemId.setMaxValue(newDateForTime);
    	} else {
    	    totalHoursField.setValue('');
    	}
    	minHoursOfFullDayItemId.reset();
    	minHoursOfHalfDayItemId.reset();

    	//this.createTimeStore(workingdetailsWidow);
    	
    },
    createTimeStore: function(workingdetailsWidow) {
    	var interval = 15; // in minute
    	var orgFormat;
    	var timeValueCount = 1440 / interval;
    	
    	var lateComingAllowedTill = workingdetailsWidow.down('#lateComingAllowedTill');
    	var store = lateComingAllowedTill.getStore();
    	var startTime = workingdetailsWidow.down('#startTime');
    	var startTimeValue = startTime.getValue();
    	startTimeValue.setFullYear(1970);
    	
    	var objArr = new Array();
    	var obj;
    	for(i = 0; i < timeValueCount; i++) {
    		obj = new Object();
    		obj.date = startTimeValue;
    		obj.disp = Ext.Date.format(startTimeValue, CONSTANTS.DISPLAY_TIME_FORMAT);
    		objArr.push(obj);
    		startTimeValue = new Date(startTimeValue.getTime() + (interval * 60000));
    	}
    	lateComingAllowedTill.bindStore(null);
    	var newStore = Ext.create('Ext.data.Store',{
    		itemId: 'newStore',
    		data: objArr
    	});
    	lateComingAllowedTill.bindStore(newStore);
    	//store.loadData(objArr, false);
    	//store.refresh();
    	//store.load();
    },
    saveEmployeeWorkTimingConfiguration: function() {
    	var $this=this;
        var empWorkTimingConfiguration = $this.getEmpWorkTimingConfiguration().getForm();
        var window = $this.getWorktimingdetailswindow();

        var model = new Academia.model.calendar.WorkTimingConfigurationGridModel();
        var calendarForm = this.getFormComponent().down('addcalendarform');
        var weekDayGrid = calendarForm.down('#calendarWorkingWeekDaysGrid');
        var weekDayGridStore = weekDayGrid.getStore();
        empWorkTimingConfiguration.updateRecord(model);
        delete model.data.dbId;
        delete model.data.breaks;
        model.set('calendar', $this.getIdValueJson(calendarForm.down('#hiddenCalendarId').getValue()))
        var weekDayCombo = this.getEmpWorkTimingConfiguration().down('#weekday');
        var formValues = empWorkTimingConfiguration.getValues();
        var isProcess = true;
        if(formValues.isNightShift == false) {
        	if(window.down('#endTime').getValue() < window.down('#startTime').getValue()) {
        		showWarningMessage(getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'), getCommonTranslation('WORK_TIMING_START_END_TIME_MSG'));
        		isProcess = false;
        	}
        	if((window.down('#startTime').getValue() > window.down('#lateComingAllowedTill').getValue() || window.down('#endTime').getValue() < window.down('#lateComingAllowedTill').getValue()) && (isProcess == true)) {
        		showWarningMessage(getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'), getCommonTranslation('WORK_TIMING_LATE_COMING_MSG'));
        		isProcess = false;
        	}
        	if((window.down('#lateComingAllowedTill').getValue() > window.down('#earlyGoingAllowedAfter').getValue() || window.down('#endTime').getValue() < window.down('#earlyGoingAllowedAfter').getValue()) && (isProcess == true)) {
        		showWarningMessage(getCommonTranslation('CALENDAR_WORK_TIMING_CONFIGURATION_DETAILS'), getCommonTranslation('WORK_TIMING_EARLY_GOING_MSG'));
        		isProcess = false;
        	}
        }
        if(isProcess == true) {
        if(window.down('#minHoursOfFullDayItemId').getValue() > window.down('#minHoursOfHalfDayItemId').getValue())
        {
        if (!isNullOrEmpty(model.get('id'))) {
            var record = weekDayGrid.getSelectionModel().getSelection();
            if (record != "" && record != null && record != undefined) {
                var duplicateStatus = this.duplicateEntryCheckForWorkTiming(weekDayGridStore, model);
                if (duplicateStatus == false) {
                	weekDayGridStore.remove(weekDayGridStore.findRecord('id', record[0].data.id));
                    model.set('startTime', formValues.startTime);
                    model.set('endTime', formValues.endTime);
                    model.set('totalHours', formValues.totalHours);
                    model.set('lateComingAllowedTill', formValues.lateComingAllowedTill);
                    model.set('earlyGoingAllowedAfter', formValues.earlyGoingAllowedAfter);
                    model.set('minHoursOfHalfDay', formValues.minHoursOfHalfDay);
                    model.set('minHoursOfFullDay', formValues.minHoursOfFullDay);
                    var weekFormData = Ext.encode(model.data);
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.SAVE_CALENDAR_WORKING_WEEKDAY,
                        jsonData: weekFormData,
                        method: 'POST',
                        success: function(response, action) {
                        	weekDayGrid.getSelectionModel().deselectAll(true);
                        	weekDayGridStore.reload();
                        }
                    });
                }
            }
        } else {
            var count = weekDayGridStore.getCount();
            model.set('startTime', formValues.startTime);
            model.set('endTime', formValues.endTime);
            model.set('totalHours', formValues.totalHours);
            model.set('lateComingAllowedTill', formValues.lateComingAllowedTill);
            model.set('earlyGoingAllowedAfter', formValues.earlyGoingAllowedAfter);
            model.set('minHoursOfHalfDay', formValues.minHoursOfHalfDay);
            model.set('minHoursOfFullDay', formValues.minHoursOfFullDay);
            var duplicateStatus = this.duplicateEntryCheckForWorkTiming(weekDayGridStore, model);
            if (duplicateStatus == false) {
            	var weekFormData = Ext.encode(model.data);
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.SAVE_CALENDAR_WORKING_WEEKDAY,
                    jsonData: weekFormData,
                    method: 'POST',
                    success: function(response, action) {
                    	weekDayGrid.getSelectionModel().deselectAll(true);
                    	weekDayGridStore.reload();
                    }
                });
            }

        }
        }else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MIN_HOURS_MAX_HOURS_CHECK'));
        	return false;
        }
        window.close();
        }
    },
    
    loadTimeSlot: function(me, newValue, oldValue, eOpts){
    	var $this = this;
    	var calendarForm = $this.getFormComponent().down('addcalendarform');
    	var worktimingConfigurationGrid = calendarForm.down('worktimingconfigurationgrid');
    	var workingdetailsWindow = $this.getWorktimingdetailswindow();
    	if (!isNullOrEmpty(workingdetailsWindow)) {
    		var slotField = workingdetailsWindow.down('#slot');
    		var isSessionBreakdown = calendarForm.down('#isSessionBreakdown');
    		if(isSessionBreakdown.getValue()) {
    			slotField.setVisible(true);
    			slotField.allowBlank = false;
    		} else {
    			slotField.setVisible(false);
    			slotField.allowBlank = true;
    		}
    	} 
    },
    
    saveHolidayList: function() {
      	 var $this = this;
         var calendarForm = $this.getFormComponent().down('addcalendarform');
         var calendarId = calendarForm.down('#hiddenCalendarId').getValue();
      	 var taskGrid = $this.getHolidaydetailscalendargrid();
         var str=$this.getHolidaysandspecialdaystabstructure();
         var fromDatestr = str.down('#startDateId').getValue();
         var  toDate = str.down('#endDateId').getValue();
         var models = taskGrid.getStore().getRange();
         
         if(fromDatestr != null){
         	fromDatestr= new Date(fromDatestr);
         	fromDatestr = Ext.Date.format(fromDatestr, 'Y-m-d');
               }
         
         if(toDate != null){
         	toDate= new Date(toDate);
             toDate = Ext.Date.format(toDate, 'Y-m-d');
               }
            
            var myJson = new Array();
            var uniqueHoliday= new Array();
            for (var i = 0; i < models.length; i++) {
            	var date=new Date(models[i].get('fromDate')).getDate()+"/"+new Date(models[i].get('fromDate')).getMonth()+"/"+new Date(models[i].get('fromDate')).getFullYear();
                    var emmTaskModel = new Academia.model.calendar.HolidayListDefaultModel();
                    var holidayNew=date.trim()+models[i].get('holidayReason').trim().toLowerCase();
                    if(uniqueHoliday.length<=0){
      				  uniqueHoliday.push(holidayNew);
      			      }else{
      				     if(uniqueHoliday.indexOf(holidayNew)>-1){
      					  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DATE_OCCASION_COMBINATION_ALREADY_EXISTS'));
      					 return  ;
      				  }else{
      					 uniqueHoliday.push(holidayNew);
      				  }
      			      }
                    if (!isNullOrEmpty(models[i].get('id'))) {
                        emmTaskModel.set("id", models[i].get('id'));
                    }
                    if (!isNullOrEmpty(calendarId)) {
                        emmTaskModel.set("calendarId", calendarId);
                    }
                    if (!isNullOrEmpty(models[i].get('fromDate'))) {
                        var fromDate = new Date(models[i].get('fromDate'));
                        emmTaskModel.set("fromDate", Ext.Date.format(fromDate, CONSTANTS.SUBMIT_DATE_FORMAT));
                        emmTaskModel.set("toDate", Ext.Date.format(fromDate, CONSTANTS.SUBMIT_DATE_FORMAT));
                    } else {
                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_VALID_DATE'));
                    	return false;
                    }
                    if (!isNullOrEmpty(models[i].get('holidayReason'))) {
                        emmTaskModel.set("holidayReason", models[i].get('holidayReason'));
                    } else {
                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ENTER_VALID_DATE'));
                    	return false;
                    }
                    delete emmTaskModel.data.isAddDeleteRow;
                    delete emmTaskModel.data.assignPrefillFromDate;
                    
                    myJson.push(emmTaskModel.data);
            }
            
           
           var objJson = {
        		   calendarId : calendarId,
        		   wsCalendarHolidayList : myJson
           };
           var formData = Ext.encode(objJson);
     	   var message;
     	   Ext.Ajax.request({
     		   type : 'rest',
     		   url : SERVERURL.CREATE_HOLIDAY_LIST,
     		   jsonData : formData,
     		   method : 'POST',
     		  params: {
     			 fromDate: fromDatestr,
     			toDate:toDate
              },
				 success: function(frm, action) {
					 var response = frm.responseText;
					 Ext.getBody().unmask();

					 if (response.startsWith("A_HOLIDAY_ALREADY_EXIST_FOR_SELECTED_DATE")) {
						 var parts = response.split(":");
						 var messageCode = parts[0];
						 var date = parts.length > 1 ? parts[1].trim() : "";

						 showErrorMessage(
							 getCommonTranslation('ERROR'),
							 getCommonTranslation(messageCode) + (date ? " (" + date + ")" : "")
						 );
					 } else {
						 showSuccessMessage(
							 getCommonTranslation('SUCCESS'),
							 getCommonTranslation('CALENDAR_HOLIDAY_ADD_MSG')
						 );
					 }
					 taskGrid.getStore().getProxy().extraParams = {
							 calendarId: calendarId
						 };
					 taskGrid.getStore().reload();
                }
     	   });
      },
      importHolidayList: function() {
    	  var $this = this;
    	  var form = $this.getHolidaydetailscalendarform();
    	  var holidayJson = form.down('#holidayJsonTextItemId');
    	  var holidayJsonValue = holidayJson.getValue();
    	  if (!isNullOrEmpty(holidayJsonValue)) {
    		  var isHolidayValid=$this.validateHolidayList(holidayJsonValue);
    		  if(isHolidayValid){
    		  var taskGrid = $this.getHolidaydetailscalendargrid();
    		  var emmTaskModel = null;
    		  var currentGridTaskList = taskGrid.getStore().getRange();
    		  var holidayListArray = holidayJsonValue.split(',');
    		  holidayListArray = holidayListArray.filter(Boolean)
    		  var uniqueHoliday=new Array();
    		 
    		  for (i in holidayListArray) {
    			  var holiday = holidayListArray[i];
    			  var holidaySplitArr = holiday.split(':');
    			  var holidayNew=holidaySplitArr[0].trim()+holidaySplitArr[1].trim().toLowerCase();
                  if(uniqueHoliday.length<=0){
    				  uniqueHoliday.push(holidayNew);
    			  }else{
    				  if(uniqueHoliday.indexOf(holidayNew)>-1){
    					  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DATE_OCCASION_COMBINATION_ALREADY_EXISTS'));
    					 return  ;
    				  }
    				  
    			  }
    			  
    			  var holidayDate = holidaySplitArr[0].trim();
    			  var holidayOccasion = holidaySplitArr[1];

    			  var holidayDateSplitStrArr = holidayDate.split('-');

    			  emmTaskModel = new Academia.model.calendar.HolidayListDefaultModel();
    			  emmTaskModel.set("fromDate", new Date(holidayDateSplitStrArr[2], holidayDateSplitStrArr[1] - 1, holidayDateSplitStrArr[0]));
    			  emmTaskModel.set("holidayReason", holidayOccasion);
    			  emmTaskModel.set("isAddDeleteRow", true);
    			
    			  currentGridTaskList.push(emmTaskModel);
    		  }
    		  taskGrid.getStore().loadRawData(currentGridTaskList, true);
    		  var holidaytextField=form.down('#holidayJsonTextItemId');
    		  holidaytextField.setValue("");
    		  }
    	  } else {
    		  form.isValid();
    	  }
      },
      
      addNewRowInHolidayGrid: function() {
    	/*  var $this = this;
          var grid = $this.getHolidaydetailscalendargrid();
          var ObjModel = [];
          var holidayModel = new Academia.model.calendar.HolidayListDefaultModel();
          holidayModel.set("fromDate", '');
          holidayModel.set("holidayReason", '');
          holidayModel.set("isAddDeleteRow", true);
          ObjModel.push(model);
          grid.getStore().loadRawData(ObjModel, true); */
    	    var grid = this.getHolidaydetailscalendargrid();
            store = grid.getStore();
            grid.editingPlugin.cancelEdit();

             var r = Ext.create('Academia.model.calendar.HolidayListDefaultModel', {
            	 fromDate :'',
          	     holidayReason :'', 
          	     isAddDeleteRow : true
             });
                                            
             store.insert(store.count(), r);
             grid.getView().refresh();
             setTimeout(function(){
            	 grid.editingPlugin.startEdit(r, 0);  
             },500);             
      },
      
      validateHolidayList: function(holidayJsonValue) {
          var $this = this;
         
          var holidaySplit=holidayJsonValue.split(",");
          holidaySplit = holidaySplit.filter(Boolean)
          var settedvalue=false;
         
          if(!isNullOrEmpty(holidaySplit)) {
        	  for (var i=0;i<holidaySplit.length;i++) { 
        		  var splitHolidayAndDate=holidaySplit[i].split(":");
        		  var dateSplit=splitHolidayAndDate[0].split("-");
        		  if(dateSplit.length ==3 && !isNullOrEmpty(splitHolidayAndDate[1])) {
        			  if(isNullOrEmpty(splitHolidayAndDate[0]) && isNullOrEmpty(splitHolidayAndDate[1])) {
        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_VALIDATION'));
        				  return false;
        			  } else if(splitHolidayAndDate[0].split("-").length !=3 ) {
        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_VALIDATION'));
        				  return false;
        			  } else if (dateSplit[0].replace(/\n/ig, '').trim().length !=2 || dateSplit[0].replace(/\n/ig, '') > 31 ){
        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_DATE_VALIDATION'));
        				  return false;
        			  }else if (dateSplit[1].length !=2 || dateSplit[1] > 12){
        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_DATE_VALIDATION'));
        				  return false;
        			  }else if (dateSplit[2].trim().length !=4){
        				  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_DATE_VALIDATION'));
        				  return false;
        			  } else {
        				  settedvalue=true;
        			  } 
        		  } else {
        			  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CALENDAR_HOLIDAY_VALIDATION'));
        			  return false;
        		  }
        	  }
        	  return settedvalue;
          }
      },
      getIdValueJson: function(id, value,code) {
     	 if (id) return {
     		 id: id,
     		 value: value,
     		 code: code
     	 };
      },
      removePlaceHolderForManualIdSetting:function(form){
                Ext.Ajax.request({
                   type: 'rest',
                   url: SERVERURL.FIND_BY_ENTITY_ID,                             
                   method: 'GET',
                   params: {
                       entityId: 25
                   },
                   success: function(response) {
                       if(!isNullOrEmpty(response.responseText)){
                           var responseObject =  Ext.JSON.decode(response.responseText);                                  
                           if(!isEmpty(responseObject)){
                               var calendarCode = form.down("#calendarCode");
                               if(responseObject.whetherManualId){
                            	     calendarCode.setReadOnly(false);
                            	     doReadOnlyCalIdField=false;
                            	     calendarCode.emptyText=' ';
                            	     calendarCode.allowBlank=false;
                            	     calendarCode.labelSeparator +='<span class="required" style="color:red"> *</span>';
                            	     calendarCode.setFieldLabel(calendarCode.fieldLabel);
                            	     calendarCode.applyEmptyText();
                               }else{
                            	     calendarCode.setReadOnly(true);
                            	     doReadOnlyCalIdField=true;
                            	     calendarCode.allowBlank=true;
                            	     calendarCode.emptyText= getCommonTranslation('ID_AUTOGENERATE');
                            	     calendarCode.applyEmptyText();
                              }
                           }
                       }                                                     
                   }                
               });
      }
});
