/**
 * @author Vishal Joshi
 * @author Amit G
 */
Ext.define('Academia.controller.committee.committee.CommitteeController', {
	extend: 'Academia.controller.base.BaseController',
	// un-comment the model code if required.
	models : ['committee.committee.CommitteeMambershipModel','common.AcademyLocationProgramModel','common.ProgramAcademyLocationModel','committee.committee.CommitteeParticipantModel'],
	stores : ['committee.committee.CommitteeGridStore','committee.committee.CommitteeStore','hostel.roomallocation.UserSmartSearchByUserType', 'attendance.UserGroup','messaging.MessagingTemplatesStore',
	          'common.AcademyLocationNameSeparated','transport.serviceRoute.InternalUser','common.StatusComboStore','committee.committee.CommitteeParticipantGridStore',
	          'committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore','user.UserAcademyLocationStore',
	          'committee.committee.CommitteeApplyToGridStore','common.AcademyLocationByName','committee.committee.CommitteeALMappingStore',
	          'committee.committee.CommitteeALMappingComboStore',
	          'committee.committee.CommitteeProgramGroupMappingStore',
	          'committee.committee.CommitteeProgramGroupSmartComboStore',
	          'committee.committee.CommitteeParticipantUserComboStore',
	          'committee.committee.CommitteeCoordinator',
	          'committee.committee.CommitteeBatchSeatTypeStore',
	          'committee.committee.ParticipantMembershipTypeStore',
	          'committee.committee.CommitteeMambershipStore','committee.committee.CommitteeType','importutility.ModuleName','importutility.ImportPersonCoveredStore',
	          'committee.committee.MemebershipFeeRuleStore','committee.committee.MembershipTypeStore',
	          'committee.committee.MembershipApproverStore','committee.committee.CommitteProgramMappingStore','feeandpayment.ALProgramSearchCombo','feeandpayment.ALProgramBatchList',
	          'feeandpayment.ALProgramBatchSearchCombo','feeandpayment.ALProgramBatchSeatTypeList','feeandpayment.managebill.Student','committee.committee.CommitteeMemberShipTypeStudentsStore',
	          'committee.committee.CommitteeRequestReceivedGridStore','committee.committee.MembershipTypesStore','committee.committee.StudentApplyForCommitteeStore','committee.committee.CommitteeMemberShipTypeByCommitteeIdStore',
	          'committee.committee.CommitteeRequestReceivedGridStore','committee.committee.MembershipTypesStore','committee.committee.MembershipDetailStore','committee.committee.CommitteeATProgramMappingStore',
	          'committee.committee.CommitteeATProgramBatchMappingStore','committee.committee.CommitteeATProgramBatchPeriodStore','facilitiesresources.managegallery.MapFolderATCourseVariantStore',
	          'committee.committee.CommitteeATProgramComboStore','committee.committee.CommitteeATProgramBatchComboStore','committee.committee.CommitteeATProgramBatchPeriodComboStore',
	          'committee.committee.CommitteeATCourseComboStore','committee.committee.CommitteeATCourseVariantComboStore',
	          'committee.committee.AlumniCommitteeGridStore',
	          'committee.committee.AlumniCommitteeALMappingStore',
	          'committee.committee.AlumniCommitteProgramMappingStore',
	          'committee.committee.AlumniALProgramBatchListStore','committee.committee.AlumniCommitteeApplyToGridStore',
	          'committee.committee.AlumniCommitteeStore','importutility.BulkCommitteeParticipantStore','committee.committee.BulkCommitteeParticipantStore',
	          'importutility.BulkMembershipUploadStore'],
	views : ['committee.committee.CommitteeTabStructure','committee.committee.CommitteeStructure','committee.committee.CommitteeFilter','committee.committee.CommitteeALWindow',
	         'committee.committee.CommitteeGrid','committee.committee.CommitteeForm','committee.committee.CommitteeALGrid', 'committee.committee.ParticipantGrid',
	         'committee.committee.AddCommitteeParticipant','committee.committee.CommitteeSendMessage','messaging.StaticDocumentAttachmentGrid',
	         'facilitiesresources.resourcebooking.ResourceBookingFormLayout', 'facilitiesresources.resourcebooking.ResourceBookingFormAcademyLocationGrid',
	         'facilitiesresources.resourcebooking.ResourceBookingFormUserGrid',
	         'committee.committee.CommitteApplyToTabStructure',
	         'committee.committee.CommitteeApplyToStructure',
	         'committee.committee.CommitteApplyToGrid',
	         'committee.committee.CommitteeAddMappingTab','feeandpayment.adjustment.AdjustmentProgressTracker',
	         'committee.committee.CommitteeAddMappingStructure',
	         'committee.committee.CommitteeAddMappingALGrid',
	         'committee.committee.CommitteeApplyToViewWindow',
	         'committee.committee.CommitteeAddMappingProgramGrid',
	         'committee.committee.CommitteeMappingAlertWin',
	         'committee.committee.ManageCommitteeTabPanel',
			 'committee.committee.AddCommitteeMembership','Academia.view.baselayout.contentarea.ContentPanel',
	         'committee.committee.CommitteeMembershipGrid','committee.committee.CommitteeUpdateUploadDownloadStructure',
	         'committee.committee.CommitteeCoveredUpdateGrid','committee.committee.CommitteeUpdateDownloadForm',
	         'committee.committee.CommitteeUpdateUploadForm','UploadOptionRadioGroup','committee.committee.CommitteeUploadOptionRadioGroup',
	         'committee.committee.AddCommitteeMembershipWindow','committee.committee.CommitteeAddMappingProgramViewGrid','committee.committee.CommitteeAddMappingBatchGrid',
	         'committee.committee.CommitteeAddMappingBatchSeatTypeGrid','committee.committee.CommitteeRequestTabStructure','committee.committee.CommitteeRequestFilter',
	         'committee.committee.CommitteeRequestGrid','committee.committee.CommitteeRequestStructure','committee.committee.StudentCommitteeRequestTabStructure','committee.committee.StudentCommitteeRequestStructure','committee.committee.StudentCommitteeRequestPanel',
	         'committee.committee.StudentCommitteeRequesterDetailsPanel','committee.committee.StudentCommitteeRequestBasicDetails',
	         'committee.committee.MembershipDetailListGrid','committee.committee.MembershipDetailList','committee.committee.CommitteApplyToFilter','committee.committee.CommitteApplyToGridForProgramBatchPeriod',
	         'committee.committee.CommitteApplyToGridForCourseSection','committee.committee.CommitteeAddMappingTabForPBP','committee.committee.CommitteeAddMappingTabForCourseSection','committee.committee.CommitteeAddMappingStructurePBP',
	         'committee.committee.CommitteeAddMappingStructureCourseSection','committee.committee.CommitteeApplyToATGrid',
	         'committee.committee.CommitteeApplyToCourseVariantGrid','committee.committee.CommitteeAddMappingATProgramGrid',
	         'committee.committee.CommitteeAddMappingATProgramBatchGrid','committee.committee.CommitteeAddMappingATProgramBatchPeriodGrid','committee.committee.CommitteeApplyToCourseGrid',
	         'committee.committee.AlumniCommitteeGrid', 'committee.committee.AlumniInterestGroupForm',
	         'committee.committee.AlumniCommitteApplyToTabStructure','committee.committee.AlumniCommitteeApplyToStructure','committee.committee.AlumniCommitteApplyToGrid',
	         'committee.committee.AlumniCommitteeAddMappingStructure','committee.committee.AlumniCommitteeAddMappingTab','committee.committee.AlumniCommitteeAddMappingALGrid',
	         'committee.committee.AlumniCommitteeAddMappingProgramGrid','committee.committee.AlumniCommitteeAddMappingProgramViewGrid','committee.committee.AlumniCommitteeAddMappingBatchGrid',
	         'committee.committee.BulkCommitteeParticipantUploadStructure','committee.committee.BulkCommitteeParticipantUploadForm','committee.committee.BulkCommitteeParticipantDownloadForm',
	         'committee.committee.BulkCommitteeParticipantGrid','committee.committee.MembershipBulkUploadDownloadStructure',
	         'committee.committee.BulkMembershipDownloadForm','committee.committee.BulkMembershipUploadForm',
	         'committee.committee.BulkMembershipUpdateGrid','committee.committee.BulkMembershipUploadOptionRadioGroup'],
	   
	refs : [{
		ref:'committeeAddMappingBatchSeatTypeGrid',
		selector:'committeeAddMappingBatchSeatTypeGrid'
	},{
		ref:'committeeAddMappingBatchGrid',
		selector:'committeeAddMappingBatchGrid'
	},{
		ref:'committeeAddMappingProgramViewGrid',
		selector:'committeeAddMappingProgramViewGrid'
	},{
    	ref : 'committeestructure',
    	selector : 'committeestructure'
    },{
    	ref : 'committeefilter',
    	selector : 'committeefilter'
    },{
    	ref: 'committeegrid',
    	selector: 'committeegrid'
    },{
    	ref: 'contentPanel',
    	selector: 'contentPanel'
    },{
    	ref: 'committeeform',
    	selector: 'committeeform'
    },{
    	ref: 'committeealwindow',
    	selector: 'committeealwindow'
    },{
    	ref: 'addcommitteeparticipant',
    	selector: 'addcommitteeparticipant'
    },{
    	ref: 'participantgrid',
    	selector: 'participantgrid'
    },{
    	ref :'committeesendmessage',
    	selector : 'committeesendmessage'
    },{
    	ref :'staticDocumentAttachmentGrid',
    	selector : 'staticdocumentattachmentgrid[itemId =staticDocumentAttachmentGridMessage]'
    },{
    	ref :'resourcebookingformlayout',
    	selector : 'resourcebookingformlayout'
    },{
    	ref :'resourcebookingacadlocgrid',
    	selector : 'resourcebookingacadlocgrid'
    },{
    	ref :'resourcebookingusergrid',
    	selector : 'resourcebookingusergrid'
    },{
    	ref :'committeapplytotabstructure',
    	selector : 'committeapplytotabstructure'
    },{
    	ref :'committeeapplytostructure',
    	selector : 'committeeapplytostructure'
    },{
    	ref :'committeapplytogrid',
    	selector : 'committeapplytogrid'
    },{
    	ref :'committeeaddmappingtab',
    	selector : 'committeeaddmappingtab'
    },{
    	ref:'adjustmentprogresstracker',
    	selector:'adjustmentprogresstracker'
    },{
    	ref:'committeeaddmappingalgrid',
    	selector:'committeeaddmappingalgrid'
    },{
    	ref:'committeeaddmappingstructure',
    	selector:'committeeaddmappingstructure'
    },{
    	ref:'committeeapplytoviewwindow',
    	selector:'committeeapplytoviewwindow'
    },{
    	ref:'committeeaddmappingprogramgrid',
    	selector:'committeeaddmappingprogramgrid'
    },{
    	ref:'committeemappingalertwin',
    	selector:'committeemappingalertwin'
    },{
    	ref:'committeeMembershipGrid',
    	selector:'committeeMembershipGrid'
    },{
    	ref:'manageCommitteeTabPanel',
    	selector:'manageCommitteeTabPanel'
    },{
    	ref:'committeetabstructure',
    	selector:'committeetabstructure'
    },{
    	ref:'committeeupdatedownloadform',
    	selector:'committeeupdatedownloadform'
    },{
    	ref:'committeeupdateuploadform',
    	selector:'committeeupdateuploadform'
    },{
    	ref:'committeecoveredupdategrid',
    	selector:'committeecoveredupdategrid'
    },{
    	ref:'committeeuploadoptionradiogroup',
    	selector:'committeeuploadoptionradiogroup'
    },{
    	ref:'addCommitteeMembershipWindow',
    	selector:'addCommitteeMembershipWindow'
    },{
    	ref:'contentPanel',
    	selector:'contentPanel'
    },{
    	ref:'committeerequestfilter',
    	selector:'committeerequestfilter'
    },{
    	ref:'committeerequestgrid',
    	selector:'committeerequestgrid'
    },{
    	ref:'studentcommitteerequesttabstructure',
    	selector:'studentcommitteerequesttabstructure'
    },{
    	ref: 'studentcommitteerequesterdetailspanel',
    	selector: 'studentcommitteerequesterdetailspanel'
    },{
    	ref: 'studentcommitteerequestbasicdetails',
    	selector: 'studentcommitteerequestbasicdetails'
    },{
    	ref: 'studentcommitteerequestpanel',
    	selector: 'studentcommitteerequestpanel'
    	
    },{ 
    	ref: 'membershipdetaillist',
    	selector: 'membershipdetaillist' 
    },{
    	ref: 'membershipdetaillistgrid',
    	selector: 'membershipdetaillistgrid' 
    },{
    	ref:'committeapplytogridforprogrambatchperiod',
    	selector:'committeapplytogridforprogrambatchperiod'
    },{
    	ref:'committeapplytogridforcoursesection',
    	selector:'committeapplytogridforcoursesection'
    },{
    	ref:'committeeaddmappingtabforPBP',
    	selector:'committeeaddmappingtabforPBP'
    },{
    	ref:'committeeaddmappingtabforcoursesection',
    	selector:'committeeaddmappingtabforcoursesection'
    },{
    	ref:'committeeapplytoatgrid',
    	selector:'committeeapplytoatgrid'
    },{
    	ref:'committeeapplytocoursegrid',
    	selector:'committeeapplytocoursegrid'
    },{
    	ref:'committeeapplytocoursevariantgrid',
    	selector:'committeeapplytocoursevariantgrid'
    },{
    	ref:'committeeaddmappingatprogramgrid',
    	selector:'committeeaddmappingatprogramgrid'
    },{
    	ref:'committeeaddmappingatprogrambatchgrid',
    	selector:'committeeaddmappingatprogrambatchgrid'
    },{
    	ref:'committeeaddmappingatprogrambatchperiodgrid',
    	selector:'committeeaddmappingatprogrambatchperiodgrid'
    },{
    	ref:'committeeaddmappingstructurePBP',
    	selector:'committeeaddmappingstructurePBP'
    },{
    	ref:'committeapplytofilter',
    	selector:'committeapplytofilter'
    },{
    	ref:'committeeaddmappingstructurecoursesection',
    	selector:'committeeaddmappingstructurecoursesection'
    },{
    	ref: 'alumnicommitteegrid',
    	selector: 'alumnicommitteegrid' 
    }, {
    	ref: 'alumniinterestgroupform',
    	selector: 'alumniinterestgroupform'
    }, {
    	ref: 'alumnicommitteeapplytostructure',
    	selector: 'alumnicommitteeapplytostructure'
    }, {
    	ref: 'alumnicommitteapplytogrid',
    	selector: 'alumnicommitteapplytogrid'
    }, {
    	ref: 'alumnicommitteapplytotabstructure',
    	selector: 'alumnicommitteapplytotabstructure'
    },{
    	ref: 'alumnicommitteeaddmappingstructure', 
    	selector: 'alumnicommitteeaddmappingstructure'
    },{
    	ref: 'alumnicommitteeaddmappingalgrid', 
    	selector: 'alumnicommitteeaddmappingalgrid'
    },{
    	ref: 'alumnicommitteeaddmappingtab', 
    	selector: 'alumnicommitteeaddmappingtab'
    },{
    	ref: 'alumnicommitteeaddmappingprogramgrid', 
    	selector: 'alumnicommitteeaddmappingprogramgrid'
    },{
    	ref: 'alumnicommitteeaddmappingprogramviewgrid', 
    	selector: 'alumnicommitteeaddmappingprogramviewgrid'    	
    },{
    	ref: 'alumnicommitteeaddmappingbatchgrid', 
    	selector: 'alumnicommitteeaddmappingbatchgrid'  
    },{
    	ref:'bulkCommitteeParticipantUploadStructure',
    	selector: 'bulkCommitteeParticipantUploadStructure'
    },{
    	ref:'bulkCommitteeParticipantUploadForm',
    	selector:'bulkCommitteeParticipantUploadForm'
    },{
    	ref:'bulkCommitteeParticipantDownloadForm',
    	selector:'bulkCommitteeParticipantDownloadForm'
    },{
    	ref:'bulkCommitteeParticipantGrid',
    	selector:'bulkCommitteeParticipantGrid'
    },{
    	ref:'membershipbulkuploaddownloadstructure',
    	selector:'membershipbulkuploaddownloadstructure'
    },{
    	ref:'bulkmembershipuploadform',
    	selector:'bulkmembershipuploadform'
    },{
    	ref:'bulkmembershipdownloadform',
    	selector:'bulkmembershipdownloadform'
    },{
    	ref:'bulkmembershipupdategrid',
    	selector:'bulkmembershipupdategrid'
    }],
    config: {
    	TNS_MANAGE_COMMITTEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_COMMITTEE_PRIVILEGES'),
    	COMMITTEE_PARTICIPANT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMMITTEE_PARTICIPANT_PRIVILEGES'),
    	TNS_MANAGE_COMMITTEE_APPLY_TO_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_COMMITTEE_APPLY_TO_PRIVILEGES'),
    	TNS_MANAGE_COMMITTEE_MEMBERSHIP: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_COMMITTEE_MEMBERSHIP'),
    	MANAGE_COMMITTEE_REQUEST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_COMMITTEE_REQUEST_PRIVILEGES'),
    	TNS_MANAGE_ALUMNI_COMMITTEE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('TNS_MANAGE_ALUMNI_COMMITTEE_PRIVILEGES'),
    },
    
    isAlumni: false,
    
    init : function() {
    	this.committeeFormMode;
    	this.control({
    		'committeeAddMappingBatchGrid button#nextButton':{
	 			  click:function(btn){
	 				 this.batchNextEventCommittee(btn);
	 			  }
	 		  },
    		'committeeAddMappingProgramViewGrid button#nextButton':{
	 			  click:function(btn){
	 				 this.programNextEventCommittee(btn);
	 			  }
	 		  },
    		'committeeaddmappingprogramgrid button#nextButton':{
	 			  click:function(btn){
	 				 this.programGroupNextEventCommittee(btn);
	 			  }
	 		  },
	 		 'committeeAddMappingProgramViewGrid customcombobox#programsearchcombo' : {
	   			 select:function(obj, record){
	   				 var programGrid = this.getCommitteeAddMappingProgramViewGrid();
	   				programGrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					programGrid.getStore().filter({property: 'programId',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = programGrid.el ? programGrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ programGrid.getStore().getCount();
	   			 }
	   		 },
	   		'committeeAddMappingProgramViewGrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCommitteeAddMappingProgramViewGrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programsearchcombo')){
	 					 activeGrid.down('#programsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'committeeAddMappingBatchGrid customcombobox#programbatchsearchcombo' : {
	   			 select:function(obj, record){
	   				 var batchgrid = this.getCommitteeAddMappingBatchGrid();
	   				batchgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					batchgrid.getStore().filter({property: 'batchId',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = batchgrid.el ? batchgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ batchgrid.getStore().getCount();
	   			 }
	   		 },
	   		 'committeeAddMappingBatchSeatTypeGrid customcombobox#batchSeatType' : {
	   			 select:function(obj, record){
	   				 var batchgrid = this.getCommitteeAddMappingBatchSeatTypeGrid();
	   				batchgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					batchgrid.getStore().filter({property: 'programBatchSeatTypeId',
	   						 value: record[0].get('programBatchSeatTypeId'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = batchgrid.el ? batchgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ batchgrid.getStore().getCount();
	   			 }
	   		 },
	   		'committeeAddMappingBatchGrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCommitteeAddMappingBatchGrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programbatchsearchcombo')){
	 					 activeGrid.down('#programbatchsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'committeeAddMappingBatchGrid button#submitFeeMapping':{
	 			  click:function(btn){
	 				  this.submitCommitteMapping(btn,'batchType');
	 			  }
	 		  },
	 		 'committeeAddMappingBatchSeatTypeGrid button#submitFeeMapping':{
	 			click:function(btn){
	 				  this.submitCommitteMapping(btn,'seatType');
	 			  }
	 		  },
	 		 'committeeAddMappingBatchSeatTypeGrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCommitteeAddMappingBatchSeatTypeGrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				 if(activeGrid.down('#batchSeatType')){
	 					 activeGrid.down('#batchSeatType').reset();
	 				  }
	 			  }
	 		  },
    		'committeefilter button[itemId=searchBtn]': {
    			click: this.loadCommitteeGrid
    		},
    		'committeefilter button[itemId=resetBtn]': {
    			click: this.resetCommitteeFilter
    		},
    		'committeegrid button[itemId=btnDelete]':{
    			click: this.deleteCommitteeRecord
    		},
    		'committeegrid button[itemId=btnAdd]':{
    			click: function(button){
    				this.addCommitteeRecord('ADD');
    				this.committeeFormMode='ADD';
    			}
    		},
    		'committeegrid button[itemId=btnView]':{
    			click: this.viewCommitteeRecord
    		},
    		'committeegrid button[itemId=btnEdit]':{
    			click: this.editCommitteeRecord
    		},
    		'committeeform button[itemId=submitBtn]':{
    			click: this.saveCommitteeRecord
    		},
    		
    		'committeegrid menuitem[itemId=addMeetingBtn]':{
    			click: this.openAddMeetingTab
    		},
    		'committeegrid menuitem[itemId=btnApplyTo]':{
    			click: this.openApplyToTab
    		},
    		'committeegrid menuitem[itemId=sendMessageBtn]':{
    			click: this.openCommitteeSendMessage
    		},
    		'committeesendmessage radiogroup[itemId=messageType]':{
    			change : function(val,nV,oV){
    				this.selectSectionMessageType(val,nV,oV);
    			}
    		},
    		'committeesendmessage customcombobox[itemId=msgTempletId]':{
    			select : function(obj,rec){
    				this.selectMessageTemp(obj,rec);
    			}
    		},
    		/*V2D-13247*/
    		'committeesendmessage textarea[itemId=smsDiscription]':{
    			change : function(val,nV,oV){
    				var committeeSendMessage = this.getCommitteesendmessage();
    				var smsTextField = committeeSendMessage.down('#smsDiscription');
    				var smsTextFieldDiscription = committeeSendMessage.down('#smsDiscriptionNotice');
    				var maxLength = localStorage.getItem('maxLength');
    				var newValue = maxLength - smsTextField.getValue().length;
    				smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
    			}
    		},
    		'committeesendmessage textarea[itemId=pushNotificationDiscription]':{
    			change : function(val,nV,oV){
    				var committeeSendMessage = this.getCommitteesendmessage();
    				var pushTextField = committeeSendMessage.down('#pushNotificationDiscription');
    				var pushTextFieldDiscription = committeeSendMessage.down('#pushNotificationDiscriptionNotice');
    				var maxLength = 1000;
    				var newValue = maxLength - pushTextField.getValue().length;
    				pushTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+'/'+maxLength+'</span>');							
    			}
    		},
    		
    		// Bulk Membership loader
    		'membershipbulkuploaddownloadstructure radiogroup[itemId=bulkMembershipUploadDownloadId]':{
	   			 change:this.bulkMembershipParticipantChange
	   		 },
	   		 
	   		'bulkmembershipuploadform button[itemId=resetBtnBulkMem]':{
	   			 click:function(){
	   				var $this = this;
	   				var bulkUploadForm = $this.getBulkmembershipuploadform();
	   				bulkUploadForm.getForm().reset();
	   				bulkUploadForm.isValid();
	   				var uploadoptionradiogroupform  = bulkUploadForm.down('#membershipUploadOptionRadioGroupItemId');
	   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
	   					isUploadAll: false
	   				});
	 	        	var moduleName = bulkUploadForm.down('#moduleBulkMemName');
	 	        	moduleName.getStore().load({
	 	        		callback: function(records, operation, success) {
	 	        			for(var i in records){
		    	        			if(records[i].data.value=="Bulk Upload Membership"){
		    	        				moduleName.setValue(records[i].data.id);
		    	        				moduleName.setReadOnly(true)
		    	        			}
	 	        			}
	          		   }	
	 	        	});
	   			}
	   			 
	   		 },
    		
    		'committeefilter customcombobox[itemId=userType]':{
    			render:function(){
    				var $this = this;
    				var form = $this.getCommitteefilter().getForm();
    				var committeeStore = form.findField('committee').getStore();
    				var assignedUserStore = form.findField('assignedUser').getStore();
    				var alFilter = form.findField('ACADEMY_LOCATION_ID').getStore();
    				var committeeItemFld = $this.getCommitteefilter().down('#committeeItemId');
    				alFilter.getProxy().extraParams={
    					id:$this.getCurrentlyLoggedInUser().id
    				};
    				var alIds =[];
    				alFilter.load({
    					callback:function(record) {
    						for(var i in record){
    							alIds.push(record[i].data.id);
    						}
    						/*committeeStore.getProxy().extraParams = {
	        	        		academyLocationIds:alIds.join()
	        				};
	        				committeeStore.load();*/
    						assignedUserStore.getProxy().extraParams = {
    							academyLocationIds:alIds.join()
    						};
    						assignedUserStore.load();
    						committeeItemFld.getStore().getProxy().setExtraParam('participantId', null);
    						committeeItemFld.getStore().getProxy().setExtraParam('academyLocationIds', alIds.join());
    						committeeItemFld.lastQuery=null;
    					}
    				});
    			},
    			select:function(obj,rec){
    				var $this = this;
    				var form = $this.getCommitteefilter().getForm();
    				form.findField('assignedUser').setDisabled(false);
    				var selectedAl = form.findField('ACADEMY_LOCATION_ID').getValue();
    				var assignedUserStore = form.findField('assignedUser').getStore();
    				var store = $this.getStore('user.UserAcademyLocationStore');
    	        	var alids=[];
    	        	store.getProxy().extraparams={
    	        		id:$this.getCurrentlyLoggedInUser().id
    	        	}
    	        	store.load({
    	        		callback:function(record) {
    	        			for (var i in record) {
    	        				alids.push(record[i].data.id);
    	        			}
    	        			assignedUserStore.getProxy().extraParams = {
	        					userType:rec[0].data.id,
	        	        		academyLocationIds:selectedAl!=null?selectedAl :alids.join()
	        				};
	        				assignedUserStore.load();
    	        		}
    	        	});
    			}
    		},
    		
    		'committeeform':{
    			render:function(){
    				var $this = this;
    				var form = $this.getCommitteeform().getForm();
    				var associatedAcadLocationIds = new Array();
    				associatedAcadLocationIds.push($this.getCurrentAcademyLocation());
    				var tabPanelMain = $this.getManageCommitteeTabPanel();
    				var permission = $this.getTNS_MANAGE_COMMITTEE_MEMBERSHIP();
    				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, $this.getTNS_MANAGE_COMMITTEE_MEMBERSHIP());
    				if(permissionList.indexOf('MEMBERSHIP') === -1){
    				tabPanelMain.child('#membershipId').tab.hide();
    					//tabPanelMain.child('#membershipId').tab.hide();
    				}
    				//$this.doAccessControlValidation($this.getCommitteeMembershipGrid(), $this.getTNS_MANAGE_COMMITTEE_MEMBERSHIP());
    			}
    		},
    		
    		'committeeform customcombobox[itemId=userItemId]':{
    			render:function(combo){
    				var $this = this;
    				var store = combo.getStore();
    				store.getProxy().extraParams={
    					academyLocationIds: $this.getCurrentAcademyLocation()
    				};
    				
    			}
    		},
    		
    		/*'committeeform multiselectcombofield[itemId=multiselectAcademyLocationId]':{
    			change:function(obj,rec){
    				if(!isNullOrEmpty(rec)) {
    					var $this = this;
        				var form = $this.getCommitteeform().getForm();
        				var users = form.findField('user');
        				users.setDisabled(false);
        				var academyLocations=[];
        				if(rec.length > 0){
        					if(!isNaN(rec[0])){
        						academyLocations.push(rec);
        					}
        					else{
        						for(var i in rec){
        							academyLocations.push(rec[i].data.id);
        						}
        					}
        				}
        				users.getStore().getProxy().actionMethods.read= 'GET';
        				users.getStore().getProxy().extraParams = {
        					academyLocationIds:academyLocations.join()
        				};
        				users.getStore().load();
    				}
    			}
    		},*/
    		
    		'committeegrid':{
    			render: function(grid){
    				var $this = this;
    				this.doAccessControlValidation(grid, this.getTNS_MANAGE_COMMITTEE_PERMISSIONS());
    				this.disableManageCommOtherPivileges(grid,this.getTNS_MANAGE_COMMITTEE_PERMISSIONS());
    				this.disableMoreActionPivileges(grid,this.getTNS_MANAGE_COMMITTEE_PERMISSIONS());
    				grid.getStore().removeAll();
    				grid.getStore().loadData([]);
    			},
    			cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
					if (e.target.tagName == 'A') {
						var dataIndex = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
						var portalId = this.getCurrentLoggedPortalId();
						var academyLocationId = this.getCurrentAcademyLocation();
		 				var associatedAcadLocationIds = new Array();
		 				associatedAcadLocationIds.push(academyLocationId);
						var $this = this;
						var doOpenTab = false;
						if(dataIndex == 'totalParticipants'){
							if(portalId == 1){
				 				  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getTNS_MANAGE_COMMITTEE_PERMISSIONS());
				 				  Ext.each(permissionList, function(privilege) {
				 					  if (privilege === 'PARTICIPANT_HYPERLINK') {
				 						 doOpenTab = true;
				 					  } 
				 				  });
				 				  if(doOpenTab){
				 					 $this.openAddParticipantDetails(dataIndex, record);
				 				  }else{
				 						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PERMISSSION_HAS_NOT_BEEN_GRANTED'));  
				 				  }
							}
						} else {
							var formWindow = $this.getCommitteealwindow();
							if (!formWindow) {
								Ext.widget('committeealwindow');
								formWindow = $this.getCommitteealwindow();
								formWindow.setHeight(300);
								formWindow.setWidth(600);
							}
							$this.fillALRelatedGrid(formWindow, dataIndex, record);
						}
					}
    			},
    			selectionchange:function(column,selected,eOpts){
    				var grid = this.getCommitteegrid();
    				if(selected.length==0 || selected.length==1){
    					grid.down('#addMeetingBtn').setDisabled(false);
    					grid.down('#btnApplyTo').setDisabled(false);
    					grid.down('#btnEdit').setDisabled(false);
    					grid.down('#btnView').setDisabled(false);
    					grid.down('#btnDelete').setDisabled(false);

    					grid.down('#btnEdit').setDisabled(false);
    					grid.down('#btnView').setDisabled(false);
    					grid.down('#btnDelete').setDisabled(false);
    				}else{
    					grid.down('#addMeetingBtn').setDisabled(true);
    					grid.down('#btnApplyTo').setDisabled(true);
    					grid.down('#btnEdit').setDisabled(true);
    					grid.down('#btnView').setDisabled(true);
    					grid.down('#btnDelete').setDisabled(true);
    				}
    				
    			},
    			deselect:function(obj, record, rowIndex, e){
    				var $this = this;
    				var grid = $this.getCommitteegrid();
    				if(obj.selected.items.length==1){
    					grid.down('#addMeetingBtn').setDisabled(false);
    					grid.down('#btnApplyTo').setDisabled(false);
    					grid.down('#btnEdit').setDisabled(false);
    					grid.down('#btnView').setDisabled(false);
    					grid.down('#btnDelete').setDisabled(false);
    				} else {
    					grid.down('#addMeetingBtn').setDisabled(true);
    					grid.down('#btnApplyTo').setDisabled(true);
    					grid.down('#btnEdit').setDisabled(true);
    					grid.down('#btnView').setDisabled(true);
    					grid.down('#btnDelete').setDisabled(true);
    				}
    				if(obj.selected.items.length==0){
    					grid.down('#btnEdit').setDisabled(false);
    					grid.down('#btnView').setDisabled(false);
    					grid.down('#btnDelete').setDisabled(false);
    				}
    				
    			}
    		},
    		
    		'participantgrid button[itemId=btnSaveItemId]':{
    			click: this.updateCommitteeParticipantRecord
    		},
    		
    		'participantgrid button[itemId=btnAdd]':{
    			click: this.openCommitteeParticipant
    		},
    		'participantgrid button[itemId=btnEdit]':{
    			click: function(){
    				var grid = this.getParticipantgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					this.openCommitteeParticipant();
    					this.editCommitteeParticipant(grid);
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
    				}
    			}
    		},
    		'committeealwindow customcombobox[itemId=membershipTypeUser]':{
    			afterrender: function(){
    				var $this = this;
    				var form = $this.getCommitteealwindow();
    				var structure = $this.getAddcommitteeparticipant();
    	        	var committeeId = structure.down('#committeeItemId').getValue();
    				var membershipTypeUserStore = form.down('#membershipTypeUser').getStore();
    				membershipTypeUserStore.getProxy().extraParams = {
    					committeeId: committeeId,
    					isAdditionalMembership: false
    				};
    				membershipTypeUserStore.load();
    			},
    			select:function(obj,rec){
    				var form = this.getCommitteealwindow();
    				form.down('#fromDateItemId').setValue(new Date(rec[0].data.fromDate));
					form.down('#toDateItemId').setValue(new Date(rec[0].data.tillDate));
					form.down('#fromDateItemId').setReadOnly(true);
					form.down('#toDateItemId').setReadOnly(true)
    			}
    		},
    		'committeealwindow customcombobox[itemId=additionalMembershipType]':{
    			afterrender: function(){
    				var $this = this;
    				var form = $this.getCommitteealwindow();
    				var structure = $this.getAddcommitteeparticipant();
    	        	var committeeId = structure.down('#committeeItemId').getValue();
    				var additionalMembershipTypeStore = form.down('#additionalMembershipType').getStore();
    				additionalMembershipTypeStore.getProxy().extraParams = {
    					committeeId: committeeId,
    					isAdditionalMembership: true
    				};
    				additionalMembershipTypeStore.load();
    			},
    			select:function(obj,rec){
    				var form = this.getCommitteealwindow();
    				var additionalMembershipType = form.down('#additionalMembershipType').getValue();
    				var addBtn = form.down('#btnAdditionalMemebership');
    				if (!isNullOrEmpty(rec[0].data.code)){
    					addBtn.setDisabled(false);
    				}else{
    					addBtn.setDisabled(true);
    				}
    			}
    		},
    		
    		'committeealwindow button[itemId=btnAdditionalMemebership]': {
            	click: function(obj){
    				this.addMultipleAdditionalMembership(obj);
    			}          
            },
    		
    		'committeealwindow customcombobox[itemId=userType]':{
    			select:function(obj,rec){
    				var $this = this;
    				var form = $this.getCommitteealwindow();
    				form.down('#assignedUser').setDisabled(false);
    				var assignedUserStore = form.down('#assignedUser').getStore();
    				
    	        	var structure = $this.getAddcommitteeparticipant();
    	        	var committeeId = structure.down('#committeeItemId').getValue();
    	        	
    	        	assignedUserStore.getProxy().extraParams = {
    					userType: rec[0].data.id,
    					committeeId: committeeId
    				};
    				assignedUserStore.load();
    				if(rec[0].data.userGroupName == 'Student'){
    					form.down('#membershipTypeUser').setVisible(true);
    				}else{
    				form.down('#membershipTypeUser').setVisible(false);
    				}
    				if(rec[0].data.userGroupName == 'Student'){
    					form.down('#membershipContainer').setVisible(true);
    					
    					
    				}else{
    					form.down('#fromDateItemId').setReadOnly(false);
    					form.down('#toDateItemId').setReadOnly(false);
    					form.down('#membershipTypeUser').reset();
    					form.down('#additionalMembershipType').reset();
    					form.down('#membershipContainer').setVisible(false);
    				}
    				
    				/*var store = $this.getStore('user.UserAcademyLocationStore');
    	        	var alids=[];membershipTypeUser
    	        	store.getProxy().extraparams={
    	        		id:$this.getCurrentlyLoggedInUser().id
    	        	}
    	        	*/

    	        	/*store.load({
    	        		callback:function(record) {
    	        			for (var i in record) {
    	        				alids.push(record[i].data.id);
    	        			}
    	        			assignedUserStore.getProxy().extraParams = {
	        					userType:rec[0].data.id,
	        					academyLocationIds:alids.join()
	        				};
	        				assignedUserStore.load();
    	        		}
    	        	});*/
    			}
    		},
    		
    		'committeealwindow button[itemId=submitCommitteeParticipantBtn]':{
    			click:function(obj,rec){
    				var $this = this;
    				var form = $this.getCommitteealwindow();
    				$this.saveParticipantDetails(form);
    			}
    		},
    		
    		'participantgrid button[itemId=btnDelete]':{
    			click: this.deleteCommitteeParticipant
    		},
    		
    		'committeesendmessage button[itemId=adhocMsgSubmitBtn]':{
    			click: function(obj) {
    				var grid = this.getCommitteegrid();
    				var formPnl = obj.up('form');
    				var isMySelfChecked = false;
    				var committeesendmessage = this.getCommitteesendmessage();
    				var fldValues = formPnl.getForm().getFieldValues();
    				isMySelfChecked = fldValues.recieverType;
    				var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
    				committeesendmessage.sendMessage(obj,grid,isMySelfChecked,currentlyLoggedInUserId);
    			}
    		},
    		
    		'committeesendmessage customcombobox[itemId=selectTemplate]':{
    			select: function(obj, record) {
    				//var form = obj.up('window');
    				var form = this.getCommitteesendmessage();
    				form.down('#msgCategoryId').setValue(record[0].data.msgCategoryId);
    				form.down('#msgSubCategoryId').setValue(record[0].data.msgSubCategoryId);
    			}
    		},
    		'participantgrid':{
    			render: function(grid){
    				this.doAccessControlValidation(grid, this.getCOMMITTEE_PARTICIPANT_PERMISSIONS());
    				this.disableManageCommOtherPivileges(grid,this.getCOMMITTEE_PARTICIPANT_PERMISSIONS());
    				var editBtn = grid.down('#btnEdit');
    				editBtn.setVisible(true);
    			},
    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
    				var me = this;
 					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
 					if(columnName == "membershipType"){
 						if(e.target.tagName=='A'){
 							if(record.data.membershipTypeCount >= 1){
 									var docWindow = me.getMembershipdetaillist();
 									var ID = record.data.id;
 									if (!docWindow) {
 										docWindow = Ext.widget('membershipdetaillist',{
 											itemId:'membershipDetailList'
 										});
 									}
 									docWindow.show();
 									var membershipdetaillistgrid = docWindow.down('#membershipdetaillistgridItemId');
 									 var store = membershipdetaillistgrid.getStore();
 									  store.getProxy().extraParams = {
 	             						  ID: record.data.id
 	             					  };
 	             					  store.load();
 								}
 						}
 					}
 				},
    			selectionchange:function(){
    				var grid = this.getParticipantgrid();
    				var editBtn = grid.down('#btnEdit');
    				if(grid.getSelectionModel().getCount()>1){
    					editBtn.setDisabled(true);
    				}else{
    					editBtn.setDisabled(false);
    				}
    			}
    		},
    		'committeesendmessage  filefield[itemId=staticUploadFileField]': {
	            change: function(fileField, value, eOpts){
	            	var this$ = this;
	            	this$.uploadStaticDocumentFileMessage(fileField, value, eOpts);
	            }
            },
            'staticdocumentattachmentgrid[itemId=staticDocumentAttachmentGridMessage] actioncolumn': {
            	click : function(view, rowIndex, colIndex, item, e, record, row){
            		this.deleteStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
            	}
            },
    		'committeesendmessage': {
    			render: function(grid){
	            	var this$ = this;
	            	var docGrid = grid.down('#staticDocumentAttachmentGridMessage');
	            	docGrid.getStore().removeAll();
	            	docGrid.getStore().sync();
	            	var itemIdPrivilegeNameArray = [{"#adhocMessage" : "ADHOC_MESSAGE" , "#messageTemplate" : "MESSAGE_TEMPLATE", "radioGroupItemId" : "#messageType", "defaultButtonItemId" : "#adhocMessage" }];
  	        		this$.disableRadioGroupAndOtherPivileges(grid, this$.getTNS_MANAGE_COMMITTEE_PERMISSIONS(), itemIdPrivilegeNameArray);
	            }
            },
            'committeesendmessage radiogroup#sendingPriority': {
        		change: function( radio, newValue, oldValue, eOpts) {
        	      this.loadCommitteeScheduleField(radio, newValue, oldValue);
        		}
        	},
        	'committeeform textfield#committeeCodeItemId': {
                blur: function(obj, record) {
                    var data = obj.getValue();
                    if (data) {
                        var form = this.getCommitteeform();
                        var grid = this.getCommitteegrid();
                        var idItemId = form.down("#idItemId");
                        var submitUrl = SERVERURL.CM_COMMITTEE_UNIQUE_COMMITTEE_CODE + '?committeeCode=' + data;
                        
                        if (!isNullOrEmpty(idItemId.getValue())) {
                        	submitUrl = submitUrl +  '&id=' + idItemId.getValue();
                        }	
                        Ext.Ajax.request({
                            type: 'rest',
                            url: submitUrl,
                            method: 'GET',
                            success: function(response, action) {
                                var responseData = Ext.decode(response.responseText);
                                if (responseData.code == 'EXIST') {
                                	showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('CM_DUPLICATE_COMMITTEE_CODE'));
                                    form.down("#committeeCodeItemId").reset();
                                    /*if (grid.getSelectionModel().getCount() > 0) {
                                        if (grid.getSelectionModel().getSelection()[0].data.committeeCode != data) {
                                            showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('CM_DUPLICATE_COMMITTEE_CODE'));
                                            form.down("#committeeCodeItemId").setValue(grid.getSelectionModel().getSelection()[0].data.committeeCode);
                                        }
                                    } else {
                                        showWarningMessage(getCommonTranslation('ALERT'), getServiceRequestTranslation('CM_DUPLICATE_COMMITTEE_CODE'));
                                        form.down("#committeeCodeItemId").reset();
                                    }*/
                                }
                            }
                        });
                    }
                }
            },
            'committeeform button[itemId=resetBtnCommittee]': {
                click: this.resetCommitteeForm
            },
            'committeapplytogrid':{
    			render: function(grid){
    				var $this = this;
    				this.doAccessControlValidation(grid, this.getTNS_MANAGE_COMMITTEE_APPLY_TO_PERMISSIONS());
    			}
            },
            'committeapplytogrid button[itemId=btnAdd]':{
    			click:function(){
    				this.openAddCommitteeMappingTab(Ext.widget('committeeaddmappingtab'),this.getCommitteeaddmappingalgrid());
    			}
	   		 },
	   		 'committeapplytogridforprogrambatchperiod button[itemId=btnAdd]':{
	   			 click:function(){
	   				this.openAddCommitteeMappingTab(Ext.widget('committeeaddmappingtabforPBP'),this.getCommitteeapplytoatgrid());
	   			 }
	   		 },
	   		'committeapplytogridforcoursesection button[itemId=btnAdd]':{
	   			 click:function(){
	   				this.openAddCommitteeMappingTab(Ext.widget('committeeaddmappingtabforcoursesection'),this.getCommitteeapplytoatgrid());
	   			 }
	   		 },
	   		 'committeapplytogrid button[itemId=btnView]':{
	   			click:function(btn){
	   				this.openViewCommitteeMappingTab(this.getCommitteapplytogrid());
	 			 }
	   		 },
	   		'committeapplytogrid button[itemId=btnDelete]':{
	   			click:function(){
	   				this.deleteCommitteeMappingRecord(this.getCommitteapplytogrid());
	   			}
	   		 },
	   		'committeapplytogridforprogrambatchperiod button[itemId=btnDelete]':{
	   			click:function(){
	   				this.deleteCommitteeMappingRecord(this.getCommitteapplytogridforprogrambatchperiod());
	   			}
	   		 },
	   		'committeapplytogridforcoursesection button[itemId=btnDelete]':{
	   			click:function(){
	   				this.deleteCommitteeMappingRecord(this.getCommitteapplytogridforcoursesection());
	   			}
	   		 },
	   		 'committeeaddmappingalgrid customcombobox#academylocationsearchcombo' : {
	   			 select:function(obj, record){
	   				 var academylocationgrid = this.getCommitteeaddmappingalgrid();
	   				 academylocationgrid.getStore().clearFilter();
	   				 if(!isNullOrEmpty(record)){
	   					 academylocationgrid.getStore().filter({property: 'id',
	   						 value: record[0].get('id'),
	   						 exactMatch: true,
	   						 caseSensitive: true});
	   				 }
	   				var gridDom = academylocationgrid.el ? academylocationgrid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ academylocationgrid.getStore().getCount();
	   			 }
	   		 },
	 		 'committeeaddmappingalgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCommitteeaddmappingalgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#academylocationsearchcombo')){
	 					 activeGrid.down('#academylocationsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'committeeaddmappingalgrid button#nextButton':{
	 			  click:function(btn){
	 				 this.academyLocationNextEventCommittee(btn);
	 			  }
	 		  },
	 		 'committeeaddmappingprogramgrid customcombobox#programsearchcombo' : {
	 			 select:function(obj, record){
	 				 var grid = this.getCommitteeaddmappingprogramgrid();
	 				grid.getStore().clearFilter();
	 				 if(!isNullOrEmpty(record)){
	 					grid.getStore().filter({property: 'longValue',
	 						 value: record[0].get('id'),
	 						 exactMatch: true,
	 						 caseSensitive: true});
	 				 }
	 				var gridDom = grid.el ? grid.el.dom : null;
	 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
	 			 }
	 		 },
	 		 'committeeaddmappingprogramgrid button#resetBtn':{
	 			  click:function(btn){
	 				 var activeGrid = this.getCommitteeaddmappingprogramgrid();
	 				  activeGrid.getSelectionModel().deselectAll();
	 				  activeGrid.getStore().clearFilter();
	 				  if(activeGrid.down('#programsearchcombo')){
	 					 activeGrid.down('#programsearchcombo').reset();
	 				  }
	 			  }
	 		  },
	 		 'committeeaddmappingalgrid button#submitBtn':{
	 			  click:function(btn){
	 				 this.submitMappingWithAcademyLocation(btn);
	 			  }
	 		  },
	 		 'committeeaddmappingprogramgrid button#submitBtn':{
	 			  click:function(btn){
	 				 this.submitMappingWithProgramGroup(btn);
	 			  }
	 		  },
	 		  'committeefilter':{
	 			  render:function(){
	 				  var $this = this;
	 				  var form = $this.getCommitteefilter();
	 				  var userTypeFld = form.down('#userType');
	 				  var assignedUserFld = form.down('#assignedUser');
	 				  var userId= $this.getCurrentlyLoggedInUser().id;
	 				  var committeeRadioGrpFld = form.down('#committeeRadioGrp');
	 				  var committeeItemFld = form.down('#committeeItemId');
	 				  var isPermissionGiven = false;
	 				 committeeRadioGrpFld.setVisible(false);
	 				  var alumniCommitteeButton = form.down('#alumniCommitteeItemId');
	 				  alumniCommitteeButton.setVisible(false);
	 				  var academyLocationId = this.getCurrentAcademyLocation();
	 				  var associatedAcadLocationIds = new Array();
	 				  associatedAcadLocationIds.push(academyLocationId);
	 				  var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getTNS_MANAGE_COMMITTEE_PERMISSIONS());
	 				  Ext.each(permissionList, function(privilege) {
	 					  if (privilege === 'ALL_COMMITTEE') {
	 						  isPermissionGiven = true;
	 						  committeeRadioGrpFld.setVisible(true);
	 					  } 
	 					  
	 					  //Alumni
	 					 if (privilege === 'ALUMNI_RADIO_COMMITTEE') {
	 						  isPermissionGiven = true;
	 						 alumniCommitteeButton.setVisible(true);
	 					  }
	 				  });
	 				  form.config.isPermissionGiven = isPermissionGiven;
	 				  if(!isPermissionGiven){
	 					 var alComboFld = form.down('#academyLocationCombo');
	 					  userTypeFld.reset();
	 					  userTypeFld.setDisabled(true);
	 					  assignedUserFld.reset();
	 					  assignedUserFld.setDisabled(true);
	 					  Ext.Ajax.request({
	 						  method : "GET",
	 						  type : 'rest',
	 						  url : SERVERURL.PATH_FIND_USER_TYPE_ID_BY_USER_ID,
	 						  headers : {
	 							  'Content-Type' : 'application/json'
	 						  },
	 						  params : {
	 							  userId : userId
	 						  },
	 						  success : function(form,action) {
	 							  var data = Ext.JSON.decode(form.responseText);

	 							  userTypeFld.getStore().load({
	 								  callback:function(record) {
	 									  userTypeFld.setValue(data);
	 								  }
	 							  });
	 							  var selectedAl = alComboFld.getValue();
	 							  var assignedUserStore = assignedUserFld.getStore();
	 							  var store = $this.getStore('user.UserAcademyLocationStore');
	 							  var alids=[];
	 							  store.getProxy().extraparams={
	 								  id:userId
	 							  }
	 							  store.load({
	 								  callback:function(record) {
	 									  for (var i in record) {
	 										  alids.push(record[i].data.id);
	 									  }
	 									  assignedUserStore.getProxy().extraParams = {
	 										  userType:data,
	 										  academyLocationIds:selectedAl!=null?selectedAl :alids.join()
	 									  };
	 									  assignedUserStore.load({
	 										  callback:function(record) {
	 											  assignedUserFld.setValue(userId);
	 											  $this.loadCommitteeGrid();
	 										  }
	 									  });
	 									  committeeItemFld.getStore().getProxy().setExtraParam('participantId', userId);
	 									  committeeItemFld.getStore().getProxy().setExtraParam('academyLocationIds', alids.join());
	 									  committeeItemFld.lastQuery=null;
	 								  }
	 							  });
	 							 
	 						  }
	 					  });
	 				  }
//	 				  else{
//	 					 $this.loadCommitteeGrid();  // V2D-433830
//	 				  }
	 			  }
	 		  },
	 		  'committeefilter radiogroup[itemId=committeeRadioGrp]':{
	 			  change: function( radio, newValue, oldValue, eOpts) {
	 				  this.changeAllCommitteeRadioGroup(radio, newValue, oldValue);
	 			  }
	 		  },
	 		  'committeetabstructure': {
	 			  render:function(committeetabstructure){
	 				  this.disableCommitteeTabImportTab(committeetabstructure, this.getTNS_MANAGE_COMMITTEE_PERMISSIONS());
	 		  }
	 		  },
	 		  'committeeupdateuploaddownloadstructure radiogroup[itemId=importDownloadgroupId]':{
	 			  change: this.committeDownloadUploadFormChange
	 		  },
	 		  'committeeupdatedownloadform[itemId=committeeupdatedownloadformId] button[itemId=downoladBtnId]':{
	 			  click:function(obj){
	 				  var $this = this;
	 				  var form =$this.getCommitteeupdatedownloadform();
	 				  var csvForm = Ext.create('Ext.form.Panel',{

    	});
	 				  csvForm.getForm().submit({
	 					  target: '_blank',
	 					  method:'POST',
	 					  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
	 					  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	 					  url: SERVERURL.PATH_COMMITTEE_CREATION_TEMPLATE_DOWNLOAD,
	 					  standardSubmit :true,
	 					  success : function(form, action){
	 						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 					  },
	 					  failure: function(form, action) {
	 						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	 					  }
	 				  });
	 			  }  
	 		  },
		        'committeeupdateuploadform button[itemId=uploadId]':{
		   			click:function(obj){
		   				var $this=this;
		   				var form=$this.getCommitteeupdateuploadform();
		   				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
	    	        	$this.getHashOfFile(form);
			        	setTimeout(function() {
			   				form.getForm().submit({
			   					method : 'POST',
			   					url : submitUrl,
			   					success : function(form, action){
			   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    },
			   					failure: function(form, action) {
	   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
			   					}
			   				});
			        	},1000);
		   				Ext.defer(function() {
		   					var grid = $this.getCommitteecoveredupdategrid();
		   					var form =$this.getCommitteeuploadoptionradiogroup();
		   					var isUploadAll = form.items.items[0].getValue().isUploadAll;
		   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_COMMITTEE_CREATION');
		   				}, 2000, this);
		   			}  
		   		},
		   		'committeeupdateuploadform button[itemId=resetBtn]':{
		   			click: function() {
		   				var $this = this;
		   				var committeeMapUploadForm = $this.getCommitteeupdateuploadform().getForm();
		   				committeeMapUploadForm.findField('file').reset();
		   				committeeMapUploadForm.isValid();
		   				var uploadoptionradiogroupform  = $this.getCommitteeuploadoptionradiogroup();
		   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
		   					isUploadAll: false
		   				});
		   			}
		   		},
	   		 'committeeupdateuploadform':{
	     		render:function(obj){
	     			var $this=this;
	 	        	var importWin=$this.getCommitteeupdateuploadform()
	 	        	var moduleName = importWin.down('#moduleName');
	 	        	moduleName.getStore().load({
	 	        		callback: function(records, operation, success) {
	 	        			for(var i in records){
		    	        			if(records[i].data.value=="Bulk Committee Creation"){
		    	        				moduleName.setValue(records[i].data.id);
		    	        				moduleName.setReadOnly(true)
		    	        			}
	 	        			}
	          		   }	
	 	        	});
	     		}  
			 },
			 'committeecoveredupdategrid button[itemId=btnForce]':{
		   			click: function(obj) {
		   				var grid = this.getCommitteecoveredupdategrid();
		   				if (grid.getSelectionModel().getCount() > 0) {
		   					if(grid.getSelectionModel().getCount() > 1){
		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		   					}else{
		   						var this$ = this;
		   						var id = grid.getSelectionModel().selectionStart.data.id;
		   						console.log(id);
		   						var urlAppend="?jobName="+id;
		   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
		   						Ext.Ajax.request({
		   							url: submitURL,
		   							method: 'GET',
		   							success: function(response) {
		   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
		   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
		   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
		   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
		   								}else if(response.responseText==="SUCCESS"){
		   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
		   								}
		   							}
		   						});
		   					}
		   				} else {
		   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		   				}  
		   			}
		   		},
		   		'committeecoveredupdategrid':{
		   			render:function(obj){
		   				var $this = this;
		   				var grid = $this.getCommitteecoveredupdategrid();
		   				var form =this.getCommitteeuploadoptionradiogroup();
	   					var isUploadAll = form.items.items[0].getValue().isUploadAll;
	   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_COMMITTEE_CREATION');
		   			},
		   			cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		   				if (e.target.tagName == 'A') {
		   					var fileType=null;
		   					if(cellIndex==1){
		   						fileType='successFile';
		   					}else if(cellIndex==6){
		   						fileType='errorFile';
		   					}else if(cellIndex==7){
		   						fileType='logFile';
		   					}
		   					var documentId = record.get("id");
		   					if (!isNullOrEmpty(documentId)) {
		   						this.getMapCommitteeDownloadFile(documentId,fileType);
		   					}
		   				}
		   			}
		   		},
	   		 	'committeeupdateuploadform committeeuploadoptionradiogroup[itemId=committeeUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	      			 change: function( radioGroup, newValue, oldValue, eOpts){
	      				 var grid =this.getCommitteecoveredupdategrid();
	      				 var isUploadAll = newValue.isUploadAll;
	      				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_COMMITTEE_CREATION');
	      			 }   
	      		 },
	      		'bulkmembershipuploadform bulkmembershipuploadoptionradiogroup[itemId=membershipUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
	      			 change: function( radioGroup, newValue, oldValue, eOpts){
	      				 var grid =this.getBulkmembershipupdategrid();
	      				 var isUploadAll = newValue.isUploadAll;
	      				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_UPLOAD_MEMBERSHIP');
	      			 }   
	      		 },
	      		
	 		  'committeeMembershipGrid button[itemId=btnAdd]':{
	 			  click:this.openAddMembershipWindow
	 		  },
	 		 'addCommitteeMembershipWindow datefield[itemId=membershipEndDate]':{
	 			  change:this.membershipEndDateChange
	 		  },
	 		 'addCommitteeMembershipWindow datefield[itemId=membershipStartDate]':{
	 			change:this.membershipStartDateChange
	 		  },
	 		 'committeeMembershipGrid button[itemId=btnDelete]':{
	 			  click:this.onDeleteMembership
	 		  },
	 		 'committeeMembershipGrid button[itemId=btnEdit]':{
	 			  click:this.onEditMembership
	 		  },
	 		 'committeeMembershipGrid button[itemId=btnView]':{
	 			  click:this.onEditMembership
	 		  },
	 		 'addCommitteeMembershipWindow radiogroup#onlineApplicationRequired':{
	 			  change:this.onChangeOnlineApplicationRequired
	 		  } ,
	 		  'addCommitteeMembershipWindow radiogroup#feesApplicable':{
	 			  change:this.onChangeIsFeeApplicable
	 		  } ,
	 		  'addCommitteeMembershipWindow radiogroup#autoApprove':{
	 			  change:this.onChangeApprove
	 		  } ,
	 		  'addCommitteeMembershipWindow customcombobox[itemId=feePlan]':{
	 			  change:function(cmp,record){
	 				  var me = this,
	 				  formView = me.getAddCommitteeMembershipWindow();
	 				  feePlanCombo = formView.down('#feePlan');
	 				  feeRuleCombo = formView.down('#feeRule');
	 				  feeRuleCombo.reset();
	 				  if(!isNullOrEmpty(feePlanCombo.getRawValue())){
	 					 feeRuleCombo.setDisabled(false);
	 					 feeRuleCombo.getStore().getProxy().extraParams={
		 					 feePlanId:record
		 		    	    };
		 				 feeRuleCombo.getStore().load();
	 				  }else{
	 					 feeRuleCombo.setDisabled(true);
	 				  }
	 			  }
	 		  },
	 		 'addCommitteeMembershipWindow button[itemId=saveMemebershipBtn]':{
	 			  click:this.addMembershiponCommittee
	 		  },
		 	 'addCommitteeMembershipWindow button[itemId=cancelMemebershipBtn]':{
		 			  click:function(){
		 				 var formWindow = this.getAddCommitteeMembershipWindow();
		 					formWindow && formWindow.close();
		 			  }
		     },
		     'committeeMembershipGrid':{
		    	 render:function(cmp){
		    		 var committeeform = this.getCommitteeform().getForm();
		    		 var idField =  committeeform.findField('id');
		    		cmp.getStore().getProxy().extraParams={
		        		committeeID:idField.getValue()
		        	};
		    		 cmp.getStore().load();
		    		 if(this.committeeFormMode=='VIEW'){
		    			 cmp.down('#btnAdd').setDisabled(true);
		    			 cmp.down('#btnEdit').setDisabled(true);
		    		 }
		    	 },
		    	 selectionchange:function(grid,selected){
		    		 var gridView = this.getCommitteeMembershipGrid();
		    		 if(selected.length == 1){
		    			 gridView.down('#btnDelete').setDisabled(false);
		    			 gridView.down('#btnView').setDisabled(false);
		    			 gridView.down('#btnEdit').setDisabled(false);
		    			 if(this.committeeFormMode=='VIEW'){
		    				 gridView.down('#btnDelete').setDisabled(true);
		    				 gridView.down('#btnEdit').setDisabled(true);
		    			 }
		    		 }else{
		    			 gridView.down('#btnDelete').setDisabled(true);
		    			 gridView.down('#btnView').setDisabled(true);
		    			 gridView.down('#btnEdit').setDisabled(true);
		    		 }
		    	 }
		    	 
		     },
			   'contentPanel': {
				   tabchange: function( tabPanel, newCard, oldCard, eOpts ) {
					   if(newCard.xtype=='committeetabstructure'){
						   newCard.down('grid').getHeader().removeCls('gridFixHeader');
						   newCard.down('grid').dockedItems.items[3].removeCls('gridFixHeader');
						   newCard.down('grid').columnManager.headerCt.removeCls('gridFixHeader');
//						   var recordCount = newCard.down('grid').getStore().getCount();
//						   if(recordCount<2){   //V2D-363019
//							   newCard.down('grid').getStore().removeAll();
//						//	   this.loadCommitteeGrid();  // V2D-433830
//						   }
					   }
				   }
	 		   },
	 		  'committeerequestfilter':{
	 			  render:function(obj){
	 				  var $this = this;  
	 				  var membershipType = obj.down('#membershipType');
	 				  var user=$this.getCurrentlyLoggedInUser();
	 				 var associatedAcadLocationIds = new Array();
	 				associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	 				var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds,this.getMANAGE_COMMITTEE_REQUEST_PERMISSIONS());
	 				var myRequestButton=obj.down('#myRequestButton');
	 				var allRequestButton=obj.down('#allRequestButton');
	 				var requestId=obj.down('#requestId');
	 				var all=false;
	 				var my=false;
	 				allRequestButton.setVisible(false);
					myRequestButton.setVisible(false);
					if(user.code=="sysadmin"){
						requestId.items.items[0].setValue(true);
						requestId.items.items[1].setValue(false);	
					}else{
					requestId.items.items[0].setValue(false);
					requestId.items.items[1].setValue(true);
					}
	 				Ext.each(permissionList, function(privilege) {
	 					 if(privilege === 'ALL_REQUESTS'){
	 						allRequestButton.setVisible(true);
 							myRequestButton.setVisible(false);
 							requestId.items.items[0].setValue(true);
 							requestId.items.items[1].setValue(false);
                    		all=true;
	 					}
	 					if(privilege === 'MY_REQUEST') {
	 							myRequestButton.setVisible(true);
		 						allRequestButton.setVisible(false);
		 						requestId.items.items[0].setValue(false);
		 						requestId.items.items[1].setValue(true);
		 						my=true;
	 					}
	 				});
	 			    if(all == true && my == true){
	 			    	    allRequestButton.setVisible(true);
 							myRequestButton.setVisible(true);
 							requestId.items.items[0].setValue(true);
 							requestId.items.items[1].setValue(false);
     	 			    	}
	 				  if(allRequestButton.getValue()==true){
	 					  membershipType.getStore().getProxy().extraParams={
	 						  isAdmin:true,
	 						  approverId:user.id
	 					  };
	 				  }else{
	 					  membershipType.getStore().getProxy().extraParams={
	 						  isAdmin:false,
	 						  approverId:user.id
	 					  }; 
	 				  }
	 			  }
	 			  },
	 		   'committeerequestfilter button[itemId=searchBtn]': {
	    			click: this.loadCommitteeRequestGrid
	    		},
	    		'committeerequestfilter radiogroup[itemId=requestId]':{
	 			   change: this.requestChangeFunction
	 		   },
	    		'committeerequestgrid':{
			    	 render:function(grid){
			    		 this.doAccessControlValidation(grid, this.getMANAGE_COMMITTEE_REQUEST_PERMISSIONS());
		    			 this.disableManageCommitteeRequestOtherPivileges(grid,this.getMANAGE_COMMITTEE_REQUEST_PERMISSIONS());
			    		},
			    	 selectionchange:function(grid,selected){
			    		 var gridView = this.getCommitteerequestgrid();
			    		 var btnApproveGridItemId = gridView.down('#btnApproveGridItemId');
			    		 var btnRejectGridItemId = gridView.down('#btnRejectGridItemId');
			    		 
			    		 var counter = 0;
			    		 selected.forEach(function(obj){
			    	    		var approvalStatus=obj.data.approvalStatus;
			    	    		if(!isNullOrEmpty(approvalStatus)){
			    	    			if(approvalStatus == 'APPROVED' || approvalStatus == 'REJECTED' ||  approvalStatus == 'CANCELLED'){
			    	    				counter = counter+1;
			    	    			}
			    	    		}
			    	    		if(counter>0){
			    	    			btnApproveGridItemId.setDisabled(true);
			    	    			btnRejectGridItemId.setDisabled(true);
			    	    			
			    	    		}else{
			    	    			btnApproveGridItemId.setDisabled(false);
			    	    			btnRejectGridItemId.setDisabled(false);
			    	    		}
			    	    	});
			    		 if(selected.length == 1){
			    			 gridView.down('#btnView').setDisabled(false);
			    		 }else{
			    			 gridView.down('#btnView').setDisabled(true);
			    		 }
			    	 }
			    	 
			     },
		            'committeerequestfilter button[itemId=resetBtn]': {
		                click: this.resetCommitteeRequestForm
		         },
		         'committeerequestfilter customcombobox[itemId=membershipType]': {
		        	 select:function(obj,rec){
		    				var $this = this;
		    				var form = $this.getCommitteerequestfilter();
		    				form.down('#studentId').reset();
		    				form.down('#studentId').setDisabled(false);
		    				form.down('#studentId').getStore().getProxy().extraParams = {
		    					membershipTypeId: rec[0].data.id,
		    				};
		    				form.down('#studentId').getStore().load();
		    			}
		         },
		         'committeerequestgrid button[itemId=btnView]': {
		        	 click: function(obj) {
		        		 var $this = this;
		        		 var grid = $this.getCommitteerequestgrid();
		                    if (grid.getSelectionModel().getCount() > 0) {
		                    	 $this.viewCommitteeRequestForm();
		                    } else {
		                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
		                    }
		    			}
		         },
		         'committeerequestgrid button[itemId=btnApproveGridItemId]': {
			          	click: function(){
			          		this.approveCommitteeRequest('#committeerequestgridId', SERVERURL.PATH_APPROVE_REJECT_COMMITTEE_REQUEST);
			          	}
			          },
			     'committeerequestgrid button[itemId=btnRejectGridItemId]': {
				         click: function(){
				          	this.rejectCommitteeRequest('#committeerequestgridId', SERVERURL.PATH_APPROVE_REJECT_COMMITTEE_REQUEST);
				         }
				   },
		         'committeerequestfilter datefield[itemId=startDate]':{
						select: function(obj, record) {
							var form = this.getCommitteerequestfilter();
							form.down('#endDate').allowBlank=false;
							form.isValid();
						}
				    },
				    
				    'committeerequestfilter datefield[itemId=endDate]':{
						select: function(obj, record) {
							var form = this.getCommitteerequestfilter();
							form.down('#startDate').allowBlank=false;
							form.isValid();
						}
				    },
				    'committeapplytofilter':{
				    	afterrender:function(form){
				    		this.doaccessValidaitonForRadio(form);
				    	}
				    },
				     // Alumni Code: Start
				    'alumnicommitteapplytogrid button[itemId=btnAdd]':{
		    			click:this.openAddAlumniCommitteeMappingTab
			   		 },
			   		'alumnicommitteapplytogrid button[itemId=btnDelete]':{
		    			click:this.deleteAlumniCommitteeMappingTab
			   		 },
				    'alumnicommitteegrid': {
				    	render: function(grid){
				    		var $this = this;
				    		$this.doAccessControlValidation(grid, $this.getTNS_MANAGE_ALUMNI_COMMITTEE_PERMISSIONS());
						},
				    	selectionchange: function(column, selected, eOpts ){  
		                    var $this = this                
		                    var grid = $this.getAlumnicommitteegrid();
		                    var gridSeletion = grid.getSelectionModel().getCount();
		                    if(grid.getSelectionModel().getCount()==1) { 
		                        grid.down('#btnEdit').setDisabled(false)
		                        grid.down('#btnView').setDisabled(false)  
		                        grid.down('#btnDelete').setDisabled(false)
		                    }
		                    else{
		                        grid.down('#btnEdit').setDisabled(true)
		                        grid.down('#btnView').setDisabled(true) 
		                        grid.down('#btnDelete').setDisabled(true)
		                    }
		                },
		                afterrender: function(grid){
		                	var me=this;
		 
		                    me.addDataGridConfigButton(grid,me.getTNS_MANAGE_ALUMNI_COMMITTEE_PERMISSIONS());
		                }
				    },
				    'alumnicommitteeaddmappingalgrid': {
				    	selectionchange: function(column, selected, eOpts ){  
		                    var $this = this                
		                    var grid = $this.getAlumnicommitteeaddmappingalgrid();
		                    var gridSeletion = grid.getSelectionModel().getCount();
		                    if(grid.getSelectionModel().getCount()>0) { 
		                        grid.down('#submitAlumniMapping').setDisabled(false)
		                    }
		                    else{
		                        grid.down('#submitAlumniMapping').setDisabled(true)
		                    }
		                },
				    },
				    'alumnicommitteeaddmappingprogramviewgrid': {
				    	selectionchange: function(column, selected, eOpts ){  
		                    var $this = this                
		                    var grid = $this.getAlumnicommitteeaddmappingprogramviewgrid();
		                    var gridSeletion = grid.getSelectionModel().getCount();
		                    if(grid.getSelectionModel().getCount()>0) { 
		                        grid.down('#submitAlumniMapping').setDisabled(false)
		                    }
		                    else{
		                        grid.down('#submitAlumniMapping').setDisabled(true)
		                    }
		                },
				    },
				    'alumnicommitteeaddmappingbatchgrid': {
				    	selectionchange: function(column, selected, eOpts ){  
		                    var $this = this                
		                    var grid = $this.getAlumnicommitteeaddmappingbatchgrid();
		                    var gridSeletion = grid.getSelectionModel().getCount();
		                    if(grid.getSelectionModel().getCount()>0) { 
		                        grid.down('#submitAlumniMapping').setDisabled(false)
		                    }
		                    else{
		                        grid.down('#submitAlumniMapping').setDisabled(true)
		                    }
		                },
				    },				    
				    'alumnicommitteegrid button[itemId=btnAdd]': { 
				    	click: this.onAddAlumniInterestGroup
				    },
				    'alumnicommitteegrid button[itemId=btnEdit]': { 
				    	click: this.onEditAlumniInterestGroup
				    },
				    'alumnicommitteegrid button[itemId=btnView]': { 
				    	click: this.onViewAlumniInterestGroup
				    },
				    'alumniinterestgroupform button[itemId=submitBtnAl]': {
				    	click: this.createAlumniCommittee
				    },
				    'alumnicommitteegrid button[itemId=btnDelete]': {
				    	click: this.deleteAlumniCommittee
				    },
				    'alumnicommitteegrid menuitem[itemId=btnApplyTo]':{
		    			click: this.openApplyToTabToAlumni
		    		},
		    		'alumniinterestgroupform button[itemId=resetBtnAl]' : {
		    			click: function(cmp){
		                    var me = this;
		                    form = me.getAlumniinterestgroupform();
		                    form.getForm().reset();                  
		                }
		    		},
//		    		'alumnicommitteeaddmappingalgrid button#nextButton':{
//		    		    click:function(btn){
//		    		        this.academyLocationNextEventAlumniCommittee(btn);
//		    		    }
//		    		},
		    		'alumnicommitteeaddmappingalgrid button#nextButton':{
		    		    click:function(btn){
		    		        this.academyLocationNextEventAlumniCommittee(btn);
		    		    }
		    		},
		    		'alumnicommitteeaddmappingprogramviewgrid button#nextButton':{
			 			  click:function(btn){
			 				 this.programNextEventAlumniCommittee(btn);
			 			  }
			 		  },
			 		 'alumnicommitteeaddmappingprogramviewgrid button#nextButton':{
			 			  click:function(btn){
			 				 this.programNextEventAlumniCommittee(btn);
			 			  }
			 		  },
			 		 'alumnicommitteeaddmappingalgrid button#resetBtn':{
			 			  click:function(btn){
			 				 var activeGrid = this.getAlumnicommitteeaddmappingalgrid();
			 				  activeGrid.getSelectionModel().deselectAll();
			 				  activeGrid.getStore().clearFilter();
			 				  if(activeGrid.down('#academylocationsearchcombo')){
			 					 activeGrid.down('#academylocationsearchcombo').reset();
			 				  }
			 				 activeGrid.getStore().load()
			 			  }
			 		  },
			 		 'alumnicommitteeaddmappingprogramviewgrid button#resetBtn':{
			 			  click:function(btn){
			 				 var activeGrid = this.getAlumnicommitteeaddmappingprogramviewgrid();
			 				  activeGrid.getSelectionModel().deselectAll();
			 				  activeGrid.getStore().clearFilter();
			 				  if(activeGrid.down('#programsearchcombo')){
			 					 activeGrid.down('#programsearchcombo').reset();
			 				  }
			 				 activeGrid.getStore().load()
			 			  }
			 		  },
			 		 'alumnicommitteeaddmappingbatchgrid button#resetBtn':{
			 			  click:function(btn){
			 				 var activeGrid = this.getAlumnicommitteeaddmappingbatchgrid();
			 				  activeGrid.getSelectionModel().deselectAll();
			 				  activeGrid.getStore().clearFilter();
			 				  if(activeGrid.down('#programbatchsearchcombo')){
			 					 activeGrid.down('#programbatchsearchcombo').reset();
			 				  }
			 				 activeGrid.getStore().load()
			 			  }
			 		  },
			 		 'alumnicommitteeaddmappingalgrid customcombobox#academylocationsearchcombo' : {
			 			 select:function(obj, record){
			 				 var grid = this.getAlumnicommitteeaddmappingalgrid();
			 				grid.getStore().clearFilter();
			 				 if(!isNullOrEmpty(record)){
			 					grid.getStore().filter({property: 'id',
			 						 value: record[0].get('id'),
			 						 exactMatch: true,
			 						 caseSensitive: true});
			 				 }
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			 			 }
			 		 },
			 		'alumnicommitteeaddmappingprogramviewgrid customcombobox#programsearchcombo' : {
			 			 select:function(obj, record){
			 				 var grid = this.getAlumnicommitteeaddmappingprogramviewgrid();
			 				grid.getStore().clearFilter();
			 				 if(!isNullOrEmpty(record)){
			 					grid.getStore().filter({property: 'programId',
			 						 value: record[0].get('programId'),
			 						 exactMatch: true,
			 						 caseSensitive: true});
			 				 }
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			 			 }
			 		 },
			 		 'alumnicommitteeaddmappingbatchgrid customcombobox#programbatchsearchcombo' : {
			 			 select:function(obj, record){
			 				 var grid = this.getAlumnicommitteeaddmappingbatchgrid();
			 				grid.getStore().clearFilter();
			 				 if(!isNullOrEmpty(record)){
			 					grid.getStore().filter({property: 'batchId',
			 						 value: record[0].get('id'),
			 						 exactMatch: true,
			 						 caseSensitive: true});
			 				 }
			 				var gridDom = grid.el ? grid.el.dom : null;
			 				gridDom.nextElementSibling.children[0].innerText=getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount();
			 			 }
			 		 },
			 		'alumnicommitteeaddmappingalgrid button#submitAlumniMapping':{
			 			  click:function(btn){
			 				  this.submitAlumniCommitteMapping(btn,'academyLocationType');
			 			  }
			 		  },
			 		 'alumnicommitteeaddmappingprogramviewgrid button#submitAlumniMapping':{
			 			  click:function(btn){
			 				  this.submitAlumniCommitteMapping(btn,'programViewType');
			 			  }
			 		  },
			 		'alumnicommitteeaddmappingbatchgrid button#submitAlumniMapping':{
			 			  click:function(btn){
			 				  this.submitAlumniCommitteMapping(btn,'batchType');
			 			  }
			 		  },
			 		  'alumnicommitteeaddmappingstructure':{
			 			 afterrender: function(structure){
			 				 var me = this
			 				 var alumnicommitteegrid = me.getAlumnicommitteegrid()
			 				 var committeeAddMappingId = me.getAlumnicommitteeaddmappingalgrid()
			 				 var alumnicommitteeaddmappingtab = me.getAlumnicommitteeaddmappingtab();
			 				var alumnicommitteegridId = alumnicommitteegrid.getSelectionModel().getSelection()[0].data.id
			 				if(!isNullOrEmpty(alumnicommitteegridId)){
			 					alumnicommitteeaddmappingtab.down('#alumnicommitteeMappingId').setValue(alumnicommitteegridId);
			 				}
			 				var store = committeeAddMappingId.getStore()
			 				store.load({
			        			callback:function() {
			        				store.getProxy().extraParams= {
			        					alumniCommitteeId:alumnicommitteegridId,
			        				};
			        				store.load()
			        			}
			        		});
			 				
			 			 } 
			 		  },
			 		  'alumnicommitteapplytogrid':{
				 			 afterrender: function(structure){
				 				 var me = this;
				 				var alumnicommitteegrid = me.getAlumnicommitteegrid()
				 				var grid = me.getAlumnicommitteapplytogrid()
				 				
				 				//var alumnicommitteeGridId = alumnicommitteegrid.getStore().data.items[0].data.id
				 				var alumnicommitteeGridId = alumnicommitteegrid.getSelectionModel().getSelection()[0].data.id
				 				var store = grid.getStore();
				 				store.load({
				 					callback:function() {
				        				store.getProxy().extraParams= {
				        					committeeId:alumnicommitteeGridId,
				        				};
				        				store.load()
				        			}
				 				 })
				 			 }
			 		  
			 		  },
				    //Alumni Code: End 
				    'committeapplytofilter radiogroup[itemId=committeApplyToGroup]':{
				    	change:function(radioGroup, newValue, oldValue, eOpts){
				    		var applyToGrid, 
				    		grid = this.getCommitteegrid(),
				    	    gridData = grid.getSelectionModel().getSelection()[0],
				    		record = grid.getSelectionModel().getSelection(),
				    		structure = this.getCommitteeapplytostructure();
				    		structure.down('#committeapplytogrid').setVisible(false);
				    		structure.down('#committeapplytogridforPBP').setVisible(false);
				    		structure.down('#committeapplytogridforCS').setVisible(false);
				    		if(newValue.committeApplyToGroup=="programBatchSeatType"){
				    			applyToGrid=structure.down('#committeapplytogrid');
				    			applyToGrid.setVisible(true);
				    			applyToGrid.getStore().getProxy().extraParams={
										committeeId: record[0].get('id'),
										isCV:false,
										isPBP:false,
										isPBS:true,
									};
				    			applyToGrid.getStore().load();
				    		}else if(newValue.committeApplyToGroup=="programBatchPeriod"){
				    			applyToGrid=structure.down('#committeapplytogridforPBP');
				    			applyToGrid.setVisible(true);
				    			applyToGrid.getStore().getProxy().extraParams={
										committeeId: record[0].get('id'),
										isCV:false,
										isPBP:true,
										isPBS:false,
									};
				    			applyToGrid.getStore().load();
				    		}else if(newValue.committeApplyToGroup=="courseSection"){
				    			applyToGrid=structure.down('#committeapplytogridforCS');
				    			applyToGrid.setVisible(true);
				    			applyToGrid.getStore().getProxy().extraParams={
										committeeId: record[0].get('id'),
										isCV:true,
										isPBP:false,
										isPBS:false,
									};
				    			applyToGrid.getStore().load();
				    		}
				    	}
				    },
				    'committeeaddmappingstructurePBP committeeapplytoatgrid button[itemId=nextButton]':{
				    	click:function(){
				    		this.nextEventForAcademicTermCommittee(this.getCommitteeapplytoatgrid());
				    	}
				    },
				    'committeeaddmappingatprogramgrid button[itemId=nextButton]':{
				    	click:function(){
				    		this.nextEventForProgramCommittee(this.getCommitteeaddmappingatprogramgrid());
				    	}
				    },
				    'committeeaddmappingatprogrambatchgrid button[itemId=nextButton]':{
				    	click:function(){
				    		this.nextEventForProgramBatchCommittee(this.getCommitteeaddmappingatprogrambatchgrid());
				    	}
				    },
				    'committeeaddmappingatprogrambatchperiodgrid button[itemId=submitMapping]':{
				    	click:function(){
				    		this.submitMappingWithAcademicTermProgramBatchPeriod();
				    	}
				    },
				    'committeeaddmappingstructurecoursesection committeeapplytoatgrid button[itemId=nextButton]':{
				    	click:function(){
				    		this.nextEventForAcademicTermCSCommittee(this.getCommitteeapplytoatgrid());
				    	}
				    },
				    'committeeaddmappingstructurecoursesection committeeapplytocoursegrid button[itemId=nextButton]':{
				    	click:function(){
				    		this.nextEventForCourseCSCommittee(this.getCommitteeapplytocoursegrid());
				    	}
				    },
				    'committeeapplytocoursevariantgrid button[itemId=submitMapping]':{
				    	click:function(){
				    		this.submitMappingWithAcademicTermCourseCourseVariant();
				    	}
				    },
				    'committeeapplytoatgrid customcombobox#academyTermsearchcombo' : {
				    	select:function(obj, record){
				    		var academicTermgrid = this.getCommitteeapplytoatgrid();
				    		this.setTotalRecordData(academicTermgrid,'id',record[0].get('id'));
				    	}
			   		 },
			   		'committeeaddmappingatprogramgrid customcombobox#programSearchCombo' : {
			   			select:function(obj, record){
			   				var programgrid = this.getCommitteeaddmappingatprogramgrid();
			   				this.setTotalRecordData(programgrid,'programName',record[0].get('programName'));
			   			}
			   		 },
			   		'committeeaddmappingatprogrambatchgrid customcombobox#programBatchSearchCombo' : {
			   			select:function(obj, record){
			   				var programBatchgrid = this.getCommitteeaddmappingatprogrambatchgrid();
			   				this.setTotalRecordData(programBatchgrid,'batchName',record[0].get('batchName'));
			   			}
			   		 },
			   		'committeeaddmappingatprogrambatchperiodgrid customcombobox#prgramBPsearchcombo' : {
			   			select:function(obj, record){
			   				var programBPgrid = this.getCommitteeaddmappingatprogrambatchperiodgrid();
			   				this.setTotalRecordData(programBPgrid,'periodName',record[0].get('periodName'));
			   			}
			   		 },
			   		 'committeeapplytocoursegrid  customcombobox#coursesearchcombo':{
			   			 select:function(obj, record){
			   				var coursegrid = this.getCommitteeapplytocoursegrid();
			   				this.setTotalRecordData(coursegrid,'courseName',record[0].get('courseName'));
			   			 }
			   		 },
			   		'committeeapplytocoursevariantgrid customcombobox#coursevariantsearchcombo':{
			   			 select:function(obj, record){
			   				var courseVargrid = this.getCommitteeapplytocoursevariantgrid();
			   				this.setTotalRecordData(courseVargrid,'courseVariantCode',record[0].get('courseVariantCode'));
			   			 }
			   		 },
			   		 'committeeapplytoatgrid button#resetBtn':{
			   			 click:function(btn){
			   				 var grid = this.getCommitteeapplytoatgrid();
			   				 this.resetGridSelectionAndCombo(grid,grid.down('#academyTermsearchcombo'));
			   			 }
			 		  },
			 		 'committeeapplytocoursegrid button#resetBtn':{
			 			 click:function(btn){
			 				 var grid = this.getCommitteeapplytocoursegrid();
			 				 this.resetGridSelectionAndCombo(grid,grid.down('#coursesearchcombo'));
			 			 }
			 		  },
			 		 'committeeapplytocoursevariantgrid button#resetBtn':{
			 			 click:function(btn){
			 				 var grid = this.getCommitteeapplytocoursevariantgrid();
			 				 this.resetGridSelectionAndCombo(grid,grid.down('#coursevariantsearchcombo'));
			 			 }
			 		  },
			 		  'committeeaddmappingatprogramgrid button#resetBtn':{
			 			 click:function(btn){
			 				 var grid = this.getCommitteeaddmappingatprogramgrid();
			 				 this.resetGridSelectionAndCombo(grid,grid.down('#programSearchCombo'));
			 			 }
			 		  },
			 		 'committeeaddmappingatprogrambatchgrid button#resetBtn':{
			 			 click:function(btn){
			 				 var grid = this.getCommitteeaddmappingatprogrambatchgrid();
			 				 this.resetGridSelectionAndCombo(grid,grid.down('#programBatchSearchCombo'));
			 			 }
			 		  },
			 		 'committeeaddmappingatprogrambatchperiodgrid button#resetBtn':{
			 			 click:function(btn){
			 				 var grid = this.getCommitteeaddmappingatprogrambatchperiodgrid();
			 				 this.resetGridSelectionAndCombo(grid,grid.down('#prgramBPsearchcombo'));
			 			 }
			 		  },
			 		 'committeapplytogridforprogrambatchperiod button[itemId=btnView]':{
			   			click:function(btn){
			   				this.openViewCommitteeMappingTab(this.getCommitteapplytogridforprogrambatchperiod());
			 			 }
			   		 },
			   		 'committeapplytogridforcoursesection button[itemId=btnView]':{
			   			click:function(btn){
			   				this.openViewCommitteeMappingTab(this.getCommitteapplytogridforcoursesection());
			 			 }
			   		 },
			   		 'bulkCommitteeParticipantDownloadForm button[itemId=bulkCommitteeParticipantDownoladBtnId]':{
			   			 click:this.downloadbulkCommitteeParticipant
			   			 
			   		 },
			   		 'bulkCommitteeParticipantUploadStructure radiogroup[itemId=bulkCommitteeParticipantImportDownloadgroupId]':{
			   			 change:this.bulkCommitteeParticipantChange
			   		 },
			   		 'bulkCommitteeParticipantUploadForm button[itemId=bulkCommitteeParticipantBtn]':{
			   			 click:this.bulkCommitteeParticipantUpload
			   		 },
			   		 'bulkmembershipuploadform button[itemId=bulkMemUploadId]':{
			   			click:function(obj){
				    		this.bulkCommitteeMembersUpload(obj);
				    	}
			   		 },
			   		'bulkmembershipuploadform':{
			     		render:function(obj){
			     			var $this=this;
			 	        	var importWin=$this.getBulkmembershipuploadform()
			 	        	var moduleName = importWin.down('#moduleBulkMemName');
			 	        	moduleName.getStore().load({
			 	        		callback: function(records, operation, success) {
			 	        			for(var i in records){
				    	        			if(records[i].data.value=="Bulk Upload Membership"){
				    	        				moduleName.setValue(records[i].data.id);
				    	        				moduleName.setReadOnly(true)
				    	        			}
			 	        			}
			          		   }	
			 	        	});
			     		}  
					 },
			 		  'bulkmembershipdownloadform[itemId=bulkmembershipdownloadform] button[itemId=downoladBtnBulkMemId]':{
			 			  click:function(obj){
			 				  var $this = this;
			 				  var form =$this.getBulkmembershipdownloadform();
			 				  var csvForm = Ext.create('Ext.form.Panel',{
			 				  });
			 				  csvForm.getForm().submit({
			 					  target: '_blank',
			 					  method:'POST',
			 					  params :{access_token : Ext.Ajax.defaultHeaders.access_token},
			 					  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			 					  url: SERVERURL.PATH_DOWNLOAD_COMMITTEE_MEMBERSHIP_TEMPLATE,
			 					  standardSubmit :true,
			 					  success : function(form, action){
			 						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			 					  },
			 					  failure: function(form, action) {
			 						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
			 					  }
			 				  });
			 			  }  
			 		  },
			   		 'bulkmembershipupdategrid':{
			   			 afterrender:function(cmp){
			   				 cmp.getStore().getProxy().extraParams= {
			   					moduleName: 'BULK_UPLOAD_MEMBERSHIP',
			   					uploadedBy:1
			   		    	}
			   				cmp.getStore().load();
			   			 },cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   				if (e.target.tagName == 'A') {
				   					var fileType=null;
				   					if(cellIndex==1){
				   						fileType='successFile';
				   					}else if(cellIndex==6){
				   						fileType='errorFile';
				   					}else if(cellIndex==7){
				   						fileType='logFile';
				   					}
				   					var documentId = record.get("id");
				   					if (!isNullOrEmpty(documentId)) {
				   						this.getMapCommitteeDownloadFile(documentId,fileType);
				   					}
				   				}
				   			}
			   		 },
					 'bulkmembershipupdategrid button[itemId=btnForceBulkMem]':{
				   			click: function(obj) {
				   				var grid = this.getBulkmembershipupdategrid();
				   				if (grid.getSelectionModel().getCount() > 0) {
				   					if(grid.getSelectionModel().getCount() > 1){
				   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				   					}else{
				   						var this$ = this;
				   						var id = grid.getSelectionModel().selectionStart.data.id;
				   						var urlAppend="?jobName="+id;
				   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
				   						Ext.Ajax.request({
				   							url: submitURL,
				   							method: 'GET',
				   							success: function(response) {
				   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
				   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
				   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
				   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
				   								}else if(response.responseText==="SUCCESS"){
				   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
				   								}
				   							}
				   						});
				   					}
				   				} else {
				   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   				}  
				   			}
				   		},
			   		 'bulkCommitteeParticipantUploadForm button[itemId=resetBtn]':{
			   			 click:function(){
			   				var $this = this;
			   				var committeeMapUploadForm = $this.getBulkCommitteeParticipantUploadForm();
			   				committeeMapUploadForm.down('#uploadFileField').reset();
			   				committeeMapUploadForm.isValid();
			   				var uploadoptionradiogroupform  = committeeMapUploadForm.down('#bulkCommitteeParticipantRadioGroupItemId');
			   				uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
			   					isUploadAll: false
			   				});
			   			}
			   			 
			   		 },
			   		 'bulkCommitteeParticipantGrid':{
			   			 afterrender:function(cmp){
			   				 cmp.getStore().getProxy().extraParams= {
			   					moduleName: 'BULK_COMMITTEE_PARTICIPANT',
			   					uploadedBy:1
			   		    	}
			   				cmp.getStore().load();
			   			 },cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   				if (e.target.tagName == 'A') {
				   					var fileType=null;
				   					if(cellIndex==1){
				   						fileType='successFile';
				   					}else if(cellIndex==6){
				   						fileType='errorFile';
				   					}else if(cellIndex==7){
				   						fileType='logFile';
				   					}
				   					var documentId = record.get("id");
				   					if (!isNullOrEmpty(documentId)) {
				   						this.getMapCommitteeDownloadFile(documentId,fileType);
				   					}
				   				}
				   			}
			   		 },
					 'bulkCommitteeParticipantGrid button[itemId=btnForce]':{
				   			click: function(obj) {
				   				var grid = this.getBulkCommitteeParticipantGrid();
				   				if (grid.getSelectionModel().getCount() > 0) {
				   					if(grid.getSelectionModel().getCount() > 1){
				   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
				   					}else{
				   						var this$ = this;
				   						var id = grid.getSelectionModel().selectionStart.data.id;
				   						var urlAppend="?jobName="+id;
				   						var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
				   						Ext.Ajax.request({
				   							url: submitURL,
				   							method: 'GET',
				   							success: function(response) {
				   								if(response.responseText==="JOB_STATUS_NOT_PENDING"){
				   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
				   								}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
				   									showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
				   								}else if(response.responseText==="SUCCESS"){
				   									showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
				   								}
				   							}
				   						});
				   					}
				   				} else {
				   					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   				}  
				   			}
				   		},
				   		'bulkCommitteeParticipantUploadForm committeeuploadoptionradiogroup[itemId=bulkCommitteeParticipantRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
			      			 change: function( radioGroup, newValue, oldValue, eOpts){
			      				 var grid =this.getBulkCommitteeParticipantGrid();
			      				 var isUploadAll = newValue.isUploadAll;
			      				 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_COMMITTEE_PARTICIPANT');
			      			 }   
			      		 },
					        'bulkCommitteeParticipantUploadForm button[itemId=bulkCommitteeParticipantBtn]':{
					   			click:function(obj){
					   				obj.setDisabled(true);
					   				var $this=this;
					   				var form=$this.getBulkCommitteeParticipantUploadForm();
					   				submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
				    	        	$this.getHashOfFile(form);
						        	setTimeout(function() {
						   				form.getForm().submit({
						   					method : 'POST',
						   					url : submitUrl,
						   					success : function(form, action){
						   						showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
						   						},
						   					failure: function(form, action) {
				   		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
						   					}
						   				});
						        	},1000);
					   				Ext.defer(function() {
					   					var grid = $this.getBulkCommitteeParticipantGrid();
					   					var formnew =form.down('#bulkCommitteeParticipantRadioGroupItemId');;
					   					var isUploadAll = formnew.items.items[0].getValue().isUploadAll;
					   					this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_COMMITTEE_PARTICIPANT');
					   				}, 2000, this);
					   			}  
					   		},
					   		'bulkCommitteeParticipantUploadForm':{
					   			afterrender:function(cmp){
					   				var moduleName = cmp.down('#moduleName');
					   				moduleName.getStore().load({
					   					callback: function(records, operation, success) {
					 	        			for(var i in records){
						    	        			if(records[i].data.value=="Bulk Committee Participant"){
						    	        				moduleName.setValue(records[i].data.id);
						    	        				moduleName.setReadOnly(true)
						    	        			}
					 	        			}
					          		   }	
					   	    		})
					   			}
					   		}
    	});
    },
    /**
     * This method is to enable schedule field 
     */
    //Alumni Code: Start 
    //submitAlumniMapping
    deleteAlumniCommitteeMappingTab:function(obj) {
      	var this$ = this;
        var grid = this.getAlumnicommitteapplytogrid(); 
        if (grid.getSelectionModel().getCount() > 0) {
      	  var record = grid.getSelectionModel().getSelection()[0];
      	  var id = record.data.id;
            showConfirmMessage(getAlumni('RECORD'), getAlumni('DO_YOU_WANT_TO_DELETE'), function (btn, text) {
                if (btn == 'yes') {
                    Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
                    
                    var urlWithParam = SERVERURL.PATH_ALUMNI_COMMITTEE_MAPPING_DELETE + '?alumniCommitteeId=' + encodeURIComponent(id);

                    Ext.Ajax.request({
                        type: 'rest',
                        url: urlWithParam,
                        method: 'DELETE',
                        success: function (form, action) {
                   
                            Ext.getBody().unmask();
                          
                            showSuccessMessage(getAlumni('RECORD'), getAlumni('DELETE_SUCCESS'));
                           
                            grid.getStore().load();
                            
                            grid.getSelectionModel().deselectAll();
                        },
                        failure: function () {
                            Ext.getBody().unmask();
                        }
                    });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }	
    
    },
    submitAlumniCommitteMapping:function(btn, type){
    	var $this = this,params=[]
    	submitUrl =SERVERURL.PATH_RESOURCE_BOOKING_ALUMNI_COMMITTEE_ACADEMY_LOCATION_CREATE;
    	var alGrid = this.getAlumnicommitteeaddmappingalgrid();
    	var programViewGrid = this.getAlumnicommitteeaddmappingprogramviewgrid();
    	var batchGrid = this.getAlumnicommitteeaddmappingbatchgrid()
    	var selectedRecord = alGrid.getSelectionModel().getSelection(); 
    	
    	var addMappingTab = this.getAlumnicommitteeaddmappingtab();
    	var tabStructure = this.getAlumnicommitteeaddmappingstructure();
    	
    	var getcontroller= this.getController('menu.CoreERPNavigationController');
    	 var applyToGrid = $this.getAlumnicommitteapplytogrid()
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var alumnicommitteeMappingId = addMappingTab.down('#alumnicommitteeMappingId').getValue();
    	
    	var submitJsonArr;
    	var jsonsArr = [];
    	
    	if(type == "programViewType"){
			  selectedRecord = programViewGrid.getSelectionModel().getSelection();
		  }
    	if(type == "batchType"){
			  selectedRecord = batchGrid.getSelectionModel().getSelection();
		  }
		if(alumnicommitteeMappingId){
			  alumnicommitteeMappingId = parseInt(alumnicommitteeMappingId);
		}
		  
    	if(selectedRecord.length>0){    		
    		if(type == "academyLocationType"){
    			selectedRecord.forEach(function(rec){
    				  params.push({		          
  			          "alumniCommittee":{
  			              id:alumnicommitteeMappingId
  			          },
  			          "academyLocation" : {
  			              id:rec.get('id')
  			          },
  			          "program" : {
  			              id:rec.get('programId')
  			          },
  			          "batch":{
  			              id:rec.get('batchId')
  			          },
  			      })
  			  })
    		}
    		else if(type == "programViewType"){
    			selectedRecord.forEach(function(rec){
    				params.push({		          
  			          "alumniCommittee":{
  			              id:alumnicommitteeMappingId
  			          },
  			          "academyLocation" : {
  			              "id":rec.get('academyLocationId')
  			          },
  			          "program" : {
  			              "id":rec.get('programId')
  			          },
  			          "batch":{
  			              id:rec.get('batchId')
  			          },
  			      })
    			});
    		}
    		else{ 
    			selectedRecord.forEach(function(rec){
    				params.push({		          
    			          "alumniCommittee":{
    			              id:alumnicommitteeMappingId
    			          },
    			          "academyLocation" : {
    			              "id":rec.get('academyLocationId')
    			          },
    			          "program" : {
    			              "id":rec.get('programId')
    			          },
    			          "batch":{
    			              id:rec.get('batchId')
    			          },
    			      })
    			});
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: submitUrl,
    			jsonData:Ext.encode(params),
    			success : function(response, action) {
    				Ext.getBody().unmask();
    				var data = response.responseText;

    				if(response.responseText == "success"){
    					Ext.getBody().unmask();
    					var tabName = getAlumni('ADD_MAPPING');
    					var getTab=getcontroller.getTab(tabName);
	    				if(getTab!=null){
	    					contentPanel.remove(getTab, true);
	    				}
	    				var committeeApplyToGridStore = applyToGrid.getStore();	
			        	applyToGrid.getStore().load();
			        	showSuccessMessage(getAlumni('COMMITTEE'), getAlumni('ALUMNI_COMMITTEE_MAPPED_SUCCESSFULLY'));
    				}
    			}
    		});
    	}
    	else {
    		showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    academyLocationNextEventAlumniCommittee :function(btn){
		var academylocationgrid = this.getAlumnicommitteeaddmappingalgrid();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
    		btn.up('').setDisabled(false)
	    	var committeeaddmappingstructure = this.getAlumnicommitteeaddmappingstructure();
	    	var committeapplytotabstructure = this.getAlumnicommitteapplytotabstructure();
	    	var committeemappingtabstructure = this.getAlumnicommitteeaddmappingtab();
	    	var programcontainer = committeeaddmappingstructure.down('#programcontainer');
	    	programcontainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(programcontainer);
	    	var alProgramGrid = this.getAlumnicommitteeaddmappingprogramviewgrid();
	    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
	    	alProgramSearchCombo.reset();
	    	var alumnicommitteegrid = this.getAlumnicommitteegrid();
	    	var alumnicommitteegridId = alumnicommitteegrid.getStore().data.items[0].data.id
	    	
	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	alProgramGridStore.load({
    			callback:function() {
    				alProgramGridStore.getProxy().extraParams= {
    					alumniCommitteeId:alumnicommitteegridId,
    					academyLocationIds: academyLocationIdsArr.join()
    				};
    				alProgramGridStore.load()
    			}
    		});
	    	
//	    	alProgramGridStore.getProxy().extraParams= {
//	    		academyLocationIds: academyLocationIdsArr.join()
//	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	this.setProgressTrackerToAlumni(1);
    	} else {
    		showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
    	}
    },
    programNextEventAlumniCommittee:function(btn){
    	var me = this,alumnicommitteeaddmappingstructure,alumnicommitteapplytotabstructure,alumnicommitteemappingtabstructure,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'))
    	});
    	
    	if(selectionModel.length > 0){
    		 committeeaddmappingstructure = me.getAlumnicommitteeaddmappingstructure();
	    	 committeapplytotabstructure = me.getAlumnicommitteapplytotabstructure();
	    	 committeemappingtabstructure = me.getAlumnicommitteeaddmappingtab();
	    	 programcontainer = committeeaddmappingstructure.down('#programbatchcontainer');
	    	programcontainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(programcontainer);
	    	
	    	var alprogramgrid = this.getAlumnicommitteeaddmappingbatchgrid();
	    	
	    	var alprogramgridCombo = alprogramgrid.down('#programbatchsearchcombo');
	    	alprogramgridCombo.getStore().getProxy().extraParams= {
		    		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join()
	    		};
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION, update: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);

//			var alProgramGridStore = alProgramGrid.getStore();
//	    	alProgramGridStore.load({
//    			callback:function() {
//    				alProgramGridStore.getProxy().extraParams= {
//    					alumniCommitteeId:alumnicommitteegridId,
//    					academyLocationIds: academyLocationIdsArr.join()
//    				};
//    				alProgramGridStore.load()
//    			}
//    		});
	    	
			var alumnicommitteegrid = me.getAlumnicommitteegrid()
			var alumnicommitteegridId = alumnicommitteegrid.getStore().data.items[0].data.id
				
			proxy.extraParams= {
					academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
		    		alumniCommitteeId:alumnicommitteegridId,
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
	    	this.setProgressTrackerToAlumni(2);
    	} else {
    		showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
    	}
    },
    openAddAlumniCommitteeMappingTab: function(){

	var contentpanel = this.getContentPanel();
	var committeemappingtabstructure = Ext.widget('alumnicommitteeaddmappingtab');
	var tabName = getAlumni('ADD_MAPPING');

	//var committeeaddmappingstructure = committeemappingtabstructure.down('committeeaddmappingstructure');
	
	var getcontroller=this.getController('menu.CoreERPNavigationController');
	var getTab=getcontroller.getTab(tabName);
	if(getTab!=null){
		contentpanel.remove(getTab, true);
	}
	openTab(contentpanel, tabName, committeemappingtabstructure,CONSTANTS.MENU_COLOR_NINE);
	var committeeaddmappingstructure = this.getAlumnicommitteeaddmappingstructure();
	var committeapplytotabstructure = this.getAlumnicommitteapplytotabstructure();
	var academylocationgrid = this.getAlumnicommitteeaddmappingalgrid();
	academylocationgrid.getStore().clearFilter();
	academylocationgrid.getStore().load();
	this.getAdjustmentprogresstracker().setVisible(true);
	this.resetProgressTrackerToAlumni();
	var adjustmentprogresstracker = committeemappingtabstructure.down("#adjustmentprogresstracker");
	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
	progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
	progresstracker1.textEl.addCls("inProgressCss-progress-text");
	progresstracker1.updateText("Step 1 In Progress");
	var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
//	if(!isNullOrEmpty(recordsCommitteeGrid)){
//		committeeaddmappingstructure.down("#lblCommittee").setValue(recordsCommitteeGrid.get('committeeName'));
//		committeemappingtabstructure.down('#committeeMappingName').setValue(recordsCommitteeGrid.get('committeeName'));
//		committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
//	}

},
    openApplyToTabToAlumni: function(){
		var $this=this;
		var grid = $this.getAlumnicommitteegrid();
		var applyToGrid = $this.getAlumnicommitteapplytogrid();
		var gridData = grid.getSelectionModel().getSelection()[0];
		if (grid.getSelectionModel().getCount() > 0) {
			if(grid.getSelectionModel().getCount() == 1) {
				var record = grid.getSelectionModel().getSelection()[0];
				var tabName = getAlumni('APPLY_TO');
				var contentPanel = $this.getContentPanel();
				var structure = Ext.widget('alumnicommitteapplytotabstructure');
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				//committeeApplyToGridStore.load();
				
				openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);	
			} else {
				 showWarningMessage(getAlumni('APPLY_TO'), getAlumni('PLEASE_SELECT_SINGLE_RECORD'));
			 }
			
		}else {
			showWarningMessage(getAlumni('ALERT'),getAlumni('PLEASE_SELECT_RECORD'));
		}
	},
    // ALumni Code: End
    
    loadCommitteeScheduleField : function(radio,newValue, oldValue){
    	var adhocMessageForm = radio.up('form');
    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
    	var radioValue = radio.getValue().sendingPriority;
    	
    	if(radioValue=='IMMEDIATE'){
    		scheduleDateField.setVisible(false);
    		scheduleDateField.setDisabled(true);
    		scheduleTimeField.setVisible(false);
    		scheduleTimeField.setDisabled(true);    		
    	}
    	else if(radioValue=='SCHEDULE'){
    		scheduleDateField.setVisible(true);
    		scheduleDateField.setDisabled(false);
    		scheduleTimeField.setVisible(true);
    		scheduleTimeField.setDisabled(false);
    	}
    },
    addMultipleAdditionalMembership:function(obj){
    	var $this = this;
    	var formWindow = $this.getCommitteealwindow();
		   var panelItem = new Array();
		   
		   panelItem.push({
	   		   xtype:'fieldcontainer',
	   		   width: '100%',
	   		   layout : 'hbox',
	   		   defaults : {
	   			   width: 256,
	   			   labelAlign : 'top'
	   		   },
	   		   items : [{
					xtype: 'hidden',
					itemId:'langItemId',
					name: 'langId'
			},{
					xtype: 'customcombobox',
	            			name: 'additionalMembershipType',
	            			itemId: 'additionalMembershipType',
	            			fieldLabel: getCommonTranslation("ADDITIONAL_MEMBERSHIP"),
	            			store: Ext.create('Academia.store.committee.committee.MembershipTypesStore'),
	            			valueField: 'id',
	            			displayField: 'value',
	            			matchFieldWidth:true,
	            			editable: false,
	            			 style:{
	     						marginLeft:'236px'
	     					},
	            			listeners:{
	            			afterrender: function(obj){
	            				setTimeout(function() {
	            					var form = obj.up('committeealwindow');
		            				var gridStore = $this.getParticipantgrid().getStore();
		            				var committeeId = gridStore.data.items[0].data.committee.id;
		            				var additionalMembershipTypeStore = obj.getStore();
		            				additionalMembershipTypeStore.getProxy().extraParams = {
		            					committeeId: committeeId,
		            					isAdditionalMembership: true
		            				};
		            				additionalMembershipTypeStore.load();
	            				},100);
	            			}
	            			}/*,
	            			select:function(obj,rec){
	            				var form = this.getCommitteealwindow();
	            				var additionalMembershipType = form.down('#additionalMembershipType').getValue();
	            				var addBtn = form.down('#btnAdditionalMemebership');
	            				if (!isNullOrEmpty(rec[0].data.code)){
	            					addBtn.setDisabled(false);
	            				}else{
	            					addBtn.setDisabled(true);
	            				}
	            			}*/
				},{
     			   xtype: 'button',
    			   glyph: ICONGLYPH.DELETEGLYPH,
    			   cls: 'CustomBodyBtnReject',
    			   tooltip: getCommonTranslation('DELETETOOLTIP'),
    			   style:{
						marginTop:'30px'
					},
    			   listeners:{
    				   click:function(obj){
    					   var frm = obj.ownerCt.ownerCt.ownerCt;
    					   var membershipContainerPanel = frm.down('#membershipContainerPanelId');
    					   var container = obj.up('fieldcontainer');
    					   membershipContainerPanel.remove(container);
    					   frm.doLayout();
    				   }
    			   }
    		   }]
	   	   });
		   
		   var membershipContainer = formWindow.down('#membershipContainerPanelId');
		   if(membershipContainer.items.length<5){
			   membershipContainer.add(panelItem);
			   var panelItem = membershipContainer.items.items;
			   
		   }
		   formWindow.doLayout();
    },
    
    openCommitteeParticipant:function(obj){
    	var $this=this;
    	var grid = $this.getCommitteegrid();
    	var formWindow = $this.getCommitteealwindow();
		if (!formWindow) {
			Ext.widget('committeealwindow');
			formWindow = $this.getCommitteealwindow();
		}
		formWindow.show();
		var membershipTypeUser = formWindow.down('#membershipTypeUser');
		var additionalMembershipType = formWindow.down('#additionalMembershipType');
		var record = grid.getSelectionModel().getSelection()[0];
		var fromDate = formWindow.down('#fromDateItemId');
		var tillDate = formWindow.down('#toDateItemId');
		fromDate.setMinValue(dateRender(record.data.validFromDate));
		fromDate.setMaxValue(dateRender(record.data.validTillDate));
		tillDate.setMinValue(dateRender(record.data.validFromDate));
		tillDate.setMaxValue(dateRender(record.data.validTillDate));
		formWindow.setTitle(getCommonTranslation('COMMITTEE_PARTICIPANT_DETAIL'));
		formWindow.down('#mapCommitteeParticipantWindowId').show();
		membershipTypeUser.getStore().getProxy().extraParams={
			committeeId:record.data.id,
			isAdditionalMembership: false
    	};
		membershipTypeUser.getStore().load();
		
		additionalMembershipType.getStore().getProxy().extraParams={
			committeeId:record.data.id,
			isAdditionalMembership: true
    	};
		additionalMembershipType.getStore().load();
    },
    selectMessageTemp: function(obj,rec){
    	var $this =  this;
    	 var formWin = $this.getCommitteesendmessage();
    	 var subject = formWin.down('#subject');
       	 var smsDiscription = formWin.down('#smsDiscription');
  		 var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
  		 var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
  		 var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
    	 if(rec[0].data.value == "SMS")
    	 {
    		 formWin.down("#subject").allowBlank=true;
    		 formWin.down("#subject").hide();
    		 formWin.down("#staticUploadFileField").hide();
    		 formWin.down("#staticDocumentMessageAttachmentGrid").hide();
    		 formWin.down('#discriptionId').reset();
    		 formWin.down('#discriptionId').hide();	       		 
    		 subject.reset();
       		 smsDiscription.show();
       		 smsDiscriptionNotice.show();
       		 pushNotificationDiscription.hide();
       		 pushNotificationDiscriptionNotice.hide();
       		 pushNotificationDiscription.reset();
    	 }else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION_ONLY" || rec[0].data.value == "Push Notification Only")
    	 {
    		 formWin.down('#discriptionId').reset();
    		 formWin.down('#smsDiscription').reset();
    		 formWin.down('#smsDiscription').hide();
    		 formWin.down('#smsDiscriptionNotice').hide();
    		 formWin.down("#staticUploadFileField").hide();
    		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
    		 formWin.down("#staticDocumentMessageAttachmentGrid").hide()
    		 subject.show();
       		 this.setAllowBlank(subject,false);
       		 //formWin.down("#subject").allowBlank=false;
       		 formWin.down('#discriptionId').show();
       		 pushNotificationDiscription.hide();
       		 pushNotificationDiscriptionNotice.hide();
       		 pushNotificationDiscription.reset();    		
    	 }
    	 /*else if(rec[0].data.Dvalue == "PUSH_NOTIFICATION" || rec[0].data.value == "Push Notification"){
       		 subject.show();
       		 formWin.down("#staticUploadFileField").hide();
       		 this.setAllowBlank(subject,false);
       		 formWin.down("#staticDocumentMessageAttachmentGrid").hide();
       		 formWin.down('#discriptionId').reset();
       		 formWin.down('#discriptionId').hide();
       		 subject.reset();
       		 smsDiscription.reset();
       		 smsDiscription.hide();
       		 smsDiscriptionNotice.hide();
       		 pushNotificationDiscription.reset();
       		 pushNotificationDiscription.show();
       		 pushNotificationDiscriptionNotice.show();
       		 pushNotificationDiscriptionNotice.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+' 1000/1000</span>');
       		 //formWin.down('#smsDiscription')
       	 }*/
    	 else
    	 {
    		 formWin.down('#discriptionId').reset();
    		 formWin.down('#smsDiscription').reset();
    		 formWin.down('#smsDiscription').hide();
    		 formWin.down('#smsDiscriptionNotice').hide();
    		 formWin.down("#staticUploadFileField").show();
    		 // formWin.down("#staticDocumentMessageAttachmentGrid").show();
    		 formWin.down("#staticDocumentMessageAttachmentGrid").show()
    		 subject.show();
       		 this.setAllowBlank(subject,false);
       		 //formWin.down("#subject").allowBlank=false;
       		 formWin.down('#discriptionId').show();
       		 pushNotificationDiscription.hide();
       		 pushNotificationDiscriptionNotice.hide();
       		 pushNotificationDiscription.reset();    		
    	 }
    	 formWin.getForm().checkValidity();
    },
    selectSectionMessageType : function(val,nV,oV){

   	 var $this =  this;
   	 var formWin = $this.getCommitteesendmessage();

   	 //var value = nV.1;
   	 if(nV.messageType==2){
   		 formWin.down("#messageId").hide();
   		 formWin.down("#selectTemplate").allowBlank=true;
   		 formWin.down("#selectTemplate").setVisible(false);     		 
   		 formWin.down("#messageName").allowBlank=true;   
   		 formWin.down("#messageName").setVisible(false);
   		 formWin.down("#msgTempletId").setVisible(true);
   		 formWin.down("#msgTempletId").allowBlank=false;
   		 formWin.down("#msgTempletId").reset();
   		 formWin.down("#subject").setVisible(true);
   		 formWin.down("#subject").allowBlank=false;
   		 formWin.down("#subject").reset();
   		 formWin.down("#discriptionId").setVisible(true);
   		 formWin.down("#discriptionId").reset();
   		 formWin.down('#smsDiscription').reset();
   		 formWin.down('#smsDiscription').hide();
   		 formWin.down('#smsDiscriptionNotice').hide();
   		 formWin.down('#pushNotificationDiscription').hide();
 		 formWin.down('#pushNotificationDiscriptionNotice').hide();
 		 formWin.down('#fldSendToContainer').show();
   	 }else{
   		 formWin.down("#msgTempletId").allowBlank=true;
   		 formWin.down("#msgTempletId").setVisible(false);     		
   		 formWin.down("#messageId").setVisible(true);
   		 formWin.down("#selectTemplate").setVisible(true);     		
   		 formWin.down("#messageName").setVisible(true);
   		 formWin.down("#messageName").reset();
   		 formWin.down("#subject").allowBlank=true;
   		 formWin.down("#subject").setVisible(false);
   		 formWin.down("#discriptionId").setVisible(false);
   		 formWin.down("#messageName").allowBlank=false;  
   		 formWin.down("#selectTemplate").allowBlank=false;
   		 formWin.down("#selectTemplate").reset();
   		 formWin.down("#staticDocumentMessageAttachmentGrid").setVisible(false);
   		 formWin.down("#staticUploadFileField").setVisible(false);
   		 formWin.down('#smsDiscription').reset();
   		 formWin.down('#smsDiscription').hide();
   		 formWin.down('#smsDiscriptionNotice').hide();
   		 formWin.down('#pushNotificationDiscription').hide();
		 formWin.down('#pushNotificationDiscriptionNotice').hide();
   		 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
   		 formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
   		 formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
   		 formWin.down('#fldSendToContainer').hide();
   	 }
   	 formWin.getForm().checkValidity();


   	
   	/* form.down("#coursesectiongrid").hide();
   	 form.down("#coursesectionstudentstructure").hide();

   	 form.down("#programbatchsectionsearch").hide();
   	 form.down("#programbatchsectiongrid").hide();
   	 form.down("#programbatchsectionstudentstructure").hide();

   	 form.down("#coursesectiongroupstructure").hide();

   	 if(value==false){
   		 form.down("#coursesectionsearch").show();
   	 }else if(value==true){
   		 form.down("#programbatchsectionsearch").show();
   	 }else if(value==='section_group'){
   		 form.down("#coursesectiongroupstructure").show();
   	 }*/

    },
    deleteCommitteeParticipant:function(grid){
    	var $this=this;
    	var grid = grid.up().up();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
    				function(btn, text) {
    			if (btn == 'yes') {
    				var records = grid.getSelectionModel().getSelection();
    				var ids=[];
    				for(var i in records) {
    					ids.push(records[i].data.id);
    				}
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.COMMITTEE_PARTICIPANT_DELERE_ALL_DATA+ '?ids='+ ids,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					params : {
    						ids : ids
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('SUCCESS'));
    						grid.getStore().reload();
//    						$this.getCommitteegrid().getSelectionModel().deselectAll();
    						$this.getCommitteegrid().getStore().reload();
    					}
    				});
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    fillALRelatedGrid:function(formWindow, dataIndex, record){
    	var $this = this; 
		var form = $this.getCommitteealwindow();
		var alGrid = form.down('#academyLocationGridItemId');
		var gridStore = alGrid.getStore();
		gridStore.removeAll();
		var grid = $this.getCommitteegrid();
		var arr= [];
		for (var i =0; i<record.data.committeeAcademyLocations.length;i++) {
			arr.push({"value":record.data.committeeAcademyLocations[i].academyLocation.value});
		}
		gridStore.loadRawData(arr, true);
    	formWindow.down('#committeeNameAL').setValue(record.data.committeeCode);
    	formWindow.down('#committeeNameDesc').setValue(record.data.committeeCode);
    	formWindow.down('#description').setValue(record.data.description);
		if(dataIndex == 'committeeAcademyLocations'){
			formWindow.down('#descriptionForm').hide();
			formWindow.down('#academyLocationForm').show();
			formWindow.setTitle(getCommonTranslation('COMMITTEE_ACADEMY_LOCATION'));
		}
		if(dataIndex == 'description'){
			formWindow.setTitle(getExaminationTranslation('Description'));
			formWindow.down('#descriptionForm').show();
			$this.toggleReadOnlyFormItems(formWindow.down('#descriptionForm').getForm(),true);
			formWindow.down('#academyLocationForm').hide();
		}
		formWindow.show();
    },
    
    
    openAddParticipantDetails:function(dataIndex, record){
    	var $this = this; 
    	var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    	var structure = Ext.widget('addcommitteeparticipant');
    	var tabName = getCommonTranslation('COMMITTEE_PARTICIPANT_DETAIL');
    	var form = $this.getCommitteefilter().getForm();
    	/**
    	 * This is to remove tab from content panel and open same tab again
    	 */
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var getTab=getcontroller.getTab(tabName);
    	if(getTab!=null){
    		contentPanel.remove(getTab, true);
    	}
    	openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);

    	var grid = structure.down('#participantgridItemId');
    	structure.down('#committeeItemId').setValue(record.data.id)
    	structure.down('#committeeName').setValue(record.data.committeeName);
    	structure.down('#committeeType').setValue(record.data.committeeTypeValue);
    	structure.down('#committeeCode').setValue(record.data.committeeCode);
    	structure.down('#committeeFromDate').setValue(dateRender(record.data.validFromDate));
    	structure.down('#committeeToDate').setValue(dateRender(record.data.validTillDate));
    	grid.getStore().getProxy().extraParams={
    		committeeId:record.data.id,
    		userGroupId:form.findField('userType').getValue()
    	};
    	grid.getStore().load();
    },
    
    loadCommitteeGrid:function(){
    	var $this=this;
    	if($this.isAlumni) {
    		var me = this,
            form = me.getCommitteefilter(), 
            grid = me.getAlumnicommitteegrid(),   
            formVal = form.getForm().getValues();    
    		
    		var isActive = formVal.status === "ACTIVE" ? true : false;
	        grid.getStore().getProxy().extraParams = {
	        	committeeId: formVal.committeeAlumni,                   
	        	isActive: isActive,
	        	committeeTypeId: formVal.committeeType,
	            academyLocationId: formVal.ACADEMY_LOCATION_ID
	        };
	
	        grid.down('pagingtoolbar').moveFirst();
	        grid.config.searchFilterForm = me.getCommitteefilter();
    	}
    	else {
    	
    	
    	var form = $this.getCommitteefilter().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getCommitteegrid();
    	var isActive;
    	$this.getCommitteefilter().down('#searchBtn').setDisabled(true);
    	if(formValue.status!= "INACTIVE") {
    		isActive=true;
    	} else {
    		isActive=false;
    	}
    	var store = null;
    	if(formValue.ACADEMY_LOCATION_ID ==='')
    	{
    		store = $this.getStore('user.UserAcademyLocationStore');
    		var alids=[];
    		store.getProxy().extraParams={
    			id:$this.getCurrentlyLoggedInUser().id
    		}
    		var assignedUserVal = form.findField('assignedUser').getValue();
    		store.load({
    			callback:function(record) {
    				for (var i in record) {
    					alids.push(record[i].data.id);
    				}
    				grid.getStore().getProxy().extraParams= {
    					committeeId:formValue.committee,
    					academyLocationId:formValue.ACADEMY_LOCATION_ID,
    					participantId:assignedUserVal,
    					isActive:isActive,
    					userGroupId:form.findField('userType').getValue(),
    					academyLocationIds :alids.join(),
    					committeeTypeId:formValue.committeeType
    				};
    				grid.getSelectionModel().deselectAll();
    				$this.resetGridSetting(grid);
    				$this.resetPageSetting(grid.getStore());
    				grid.getStore().load({
    					callback:function(record) {
    					   $this.getCommitteefilter().down('#searchBtn').setDisabled(false);
    					}
    				});
    			}
    		});
    	}else{
    		grid.getStore().getProxy().extraParams= {
				committeeId:formValue.committee,
				academyLocationId:formValue.ACADEMY_LOCATION_ID,
				participantId:assignedUserVal,
				isActive:isActive,
				userGroupId:form.findField('userType').getValue(),
				academyLocationIds :'',
				committeeTypeId:formValue.committeeType
			};
    		grid.getSelectionModel().deselectAll();
    		$this.resetGridSetting(grid);
    		$this.resetPageSetting(grid.getStore());
    		grid.getStore().load({
    			callback:function(record) {
    			   $this.getCommitteefilter().down('#searchBtn').setDisabled(false);
    			}
    		});
    	}
    	
    	/***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	
    	grid.config.searchFilterForm = $this.getCommitteefilter();
    	/***************End Code added for show filter data on PDF/Excel Export Report **************/
    }
    }, 
    resetCommitteeFilter: function() {
        var $this = this;
        var form, grid;
        
        // Handle the 'isAlumni' case
        if ($this.isAlumni) {
            form = $this.getCommitteefilter();
            grid = $this.getAlumnicommitteegrid();
            form.getForm().reset();
            $this.isAlumni = true;

            // Reset committee combo box when alumni is selected
            var committeeCombo = $this.getCommitteefilter().down("#committeeItemId");
            if (committeeCombo) {
                committeeCombo.reset();
                // Optionally reset the store to ensure a fresh state
                committeeCombo.getStore().removeAll();
            }

        } else{
        
        var filter = $this.getCommitteefilter().getForm();
        var isPermissionGiven = $this.getCommitteefilter().config.isPermissionGiven;
        if(isPermissionGiven){
        	filter.reset();
            var assignedUser = $this.getCommitteefilter().down("#assignedUser");
            assignedUser.setDisabled(true);
            assignedUser.reset();
            $this.getCommitteefilter().down("#academyLocationCombo").setRawValue(null);
        }
        else{
        	$this.getCommitteefilter().down("#committeeItemId").reset();
        	$this.getCommitteefilter().down("#academyLocationCombo").reset();
        	$this.getCommitteefilter().down("#statusItemId").reset();
        }
        $this.loadCommitteeGrid();
    }
    
    // Ensure that the combo box store is properly reloaded if needed
        var committeeCombo = $this.getCommitteefilter().down("#committeeItemId");
        if (committeeCombo) {
            committeeCombo.getStore().load();  // Reload the store after resetting
        }
        },
    openAddMeetingTab:function(){
    	var $this=this;
    	var grid = $this.getCommitteegrid();
    	var gridData = grid.getSelectionModel().getSelection()[0];
    	if (grid.getSelectionModel().getCount() > 0) {
//    		Academia.app.getController('Academia.controller.enquiry.enquirydetail.EnquiryDetailController');
    		var contentpanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    		var tabName = getCommonTranslation('EVENT_DETAILS');
    		/**
    		 * This is to remove tab from content panel and open same tab again 
    		 */
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
    		$this.getController('Academia.controller.facilitiesresources.resourcebooking.ResourceBookingController').addResourceBooking(getCommonTranslation('EVENT_DETAILS'),false, false);
    		var form = 	contentpanel.getActiveTab().down('resourcebookingformlayout').getForm();
        	var bookingPurpose = form.findField('bookingPurpose');
        	var committee = form.findField('committee');
        	var bookedBy = form.findField('bookedBy');
        	var isMendatory = form.findField('isMendatory');
        	var purposeDesc = form.findField('purposeDesc');
        	var eventDesc = form.findField('eventDesc');
        	var noOfParticipants = form.findField('noOfParticipants');
        	$this.getResourcebookingformlayout().down('#gradeMasterResetButtonId').setVisible(false);
        	
        	bookingPurpose.getStore().load({
        		callback:function(record){
        			for ( var i in record) {
        				if(record[i].data.value==getCommonTranslation('MEETING')) {
        					var docGrid = contentpanel.getActiveTab().down('resourcebookingformlayout').down('#documentsGridResourceBooking');
                    		var meetingDocsId = contentpanel.getActiveTab().down('resourcebookingformlayout').down('#meetingDocsId');
                    		docGrid.setVisible(true);
                    		meetingDocsId.setVisible(true);
        					bookingPurpose.setValue(record[i].data.id);
        					bookingPurpose.setReadOnly(true);
        					$this.getController('Academia.controller.facilitiesresources.resourcebooking.ResourceBookingController').selectBookingPurpose(bookingPurpose, null, null);
        					committee.setVisible(true);
        					committee.setReadOnly(true);
        					bookedBy.setReadOnly(true);
        					noOfParticipants.setValue(gridData.data.noOfParticipants);
        					eventDesc.setFieldLabel(getCommonTranslation('MEETING_AGENDA'));
        					eventDesc.setWidth(256);
                    		eventDesc.clearInvalid();
                    		$this.setAllowBlank(eventDesc, false);
        					isMendatory.setVisible(false);
        					purposeDesc.setVisible(false);
        					var store = $this.getStore('user.UserAcademyLocationStore');
            	        	var alids=[];
            	        	store.getProxy().extraparams={
            	        		id:$this.getCurrentlyLoggedInUser().id
            	        	}
            	        	store.load({
            	        		callback:function(rec) {
            	        			for (var i in rec) {
            	        				alids.push(rec[i].data.id);
            	        			}
            	        			committee.getStore().getProxy().extraParams= {
                						academyLocationIds:alids.join()
                					},
                					committee.getStore().load({
                						callback:function(res) {
                							committee.setValue(gridData.data.id);
                							var gridStore = $this.getResourcebookingacadlocgrid().getStore();
                    	                	gridStore.getProxy().api.read = SERVERURL.ACADEMY_LOCATION_BY_COMMITTEE+"?committeeId="+gridData.data.id;
                    	                	gridStore.load();
                						}
                					});
            	        			var academyLocationId=$this.getCurrentAcademyLocation();
            	        			bookedBy.getStore().getProxy().extraParams={
            	        				id :academyLocationId
            	        			};
            	        			bookedBy.getStore().load({
            	                    	callback:function(res) {
            	                    		bookedBy.setValue(gridData.data.committeeCoordinatorId);
                						}
            	                    });
            	        		}
            	        	});
        					
        				}
					}
        		}
        	});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
   },
    
    deleteCommitteeRecord:function(){
    	var $this=this;
    	var grid = $this.getCommitteegrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('COMMITTEE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.COMMITTEE_DELETE+'?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						if(Ext.decode(form.responseText) == 0) {
    							showWarningMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('DEPENDENCY_EXIST_MSG'));
    						}else {
    							grid.getStore().reload();
    							showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_DELETED_SUCCESSFULLY'));
    						}
    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
   },
	addCommitteeRecord:function(isView){
		var $this = this;
		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			var structure = Ext.widget('manageCommitteeTabPanel');
			
	        var tabName = getCommonTranslation('ADD_COMMITTEE');
	       /**
	        * This is to remove tab from content panel and open same tab again
	        */
	        if (isView == 'ADD') {
	        	 tabName = getCommonTranslation('ADD_COMMITTEE')
	            
	        }
	        else if (isView == 'VIEW') {
	        	tabName = getCommonTranslation('VIEW_COMMITTEE')
	            
	        } else if (isView== 'EDIT') {
	        	tabName = getCommonTranslation('EDIT_COMMITTEE')
	        } 
	        
	       var getcontroller=this.getController('menu.CoreERPNavigationController');
	       var getAddTab = getcontroller.getTab(getCommonTranslation('ADD_COMMITTEE'));
	        var getEditTab = getcontroller.getTab(getCommonTranslation('EDIT_COMMITTEE'));
	        var getViewTab = getcontroller.getTab(getCommonTranslation('VIEW_COMMITTEE'));
	        if (getAddTab != null) {
	            contentPanel.remove(getAddTab, true);
	        }
	        if (getEditTab != null) {
	            contentPanel.remove(getEditTab, true);
	        }
	        if (getViewTab != null) {
	            contentPanel.remove(getViewTab, true);
	        }
	        
	       /*var getTab=getcontroller.getTab(tabName);
	       if(getTab!=null){
	       	contentPanel.remove(getTab, true);
	       }*/
	       openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_TWO);
	       var committeeform = $this.getCommitteeform();
	       Ext.apply(committeeform,{
	    	   code:null,
	    	   setCode : function(code){
	    		   committeeform.code = code;
	    	   },
	    	   getCode:function(){
	    		   return committeeform.code;
	    	   }
	       });
	       committeeform.setCode(true);
	       if (isView == 'ADD') {
	    	   structure.child('#membershipId').tab.setDisabled(true);
	       setTimeout(function() {
	    	   var form = $this.getCommitteeform();
		       var status = form.down('#statusItemId');
	    	   form.down('#fromDateItemId').setValue(new Date());
	    	   form.down('#toDateItemId').clearInvalid();
	    	   status.getStore().load({
					callback:function(record) {
						status.setValue(record[0].data.id);	
	    	   }
	       });
       		},300);
	       }
	},
	viewCommitteeRecord:function(){
		var $this = this;
		$this.committeeFormMode='VIEW';
		var grid = $this.getCommitteegrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addCommitteeRecord('VIEW');
			var committeeform = $this.getCommitteeform().getForm();
			$this.populateCommitteeRecord(grid, committeeform, false);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	editCommitteeRecord:function(){
		var $this = this;
		$this.committeeFormMode='EDIT';
		var grid = $this.getCommitteegrid();
		if(grid.getSelectionModel().getCount()>0) {
			$this.addCommitteeRecord('EDIT');
			var committeeform = $this.getCommitteeform();
			if(!committeeform.setCode){
				Ext.apply(committeeform,{
			    	   code:null,
			    	   setCode : function(code){
			    		   committeeform.code = false;
			    	   },
			    	   getCode:function(){
			    		   return committeeform.code;
			    	   }
			       });
			}
			committeeform.setCode(false);
			$this.populateCommitteeRecord(grid, committeeform.getForm(), true);
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	populateCommitteeRecord:function(grid, committeeform, isEditable){
		var $this = this;
		var record = grid.getSelectionModel().getSelection()[0];
		
		var submitUrl = SERVERURL.COMMITTEE_FIND_BY_ID;
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl+"?id="+record.data.id,
			method : 'GET',
			success : function(resp, action) {
				Ext.getBody().unmask();
				var data = Ext.decode(resp.responseText);
				var committeeCode = committeeform.findField('committeeCode');
				committeeCode.setValue(data.committeeCode);
				var committeeName = committeeform.findField('committeeName');
				committeeName.setValue(data.committeeName);
				//var multiselectAcademyLocation = committeeform.findField('multiselectAcademyLocation');
				/*var alArray= [];
				if(!isNullOrEmpty(data.committeeAcademyLocations)) {
					for(var i in data.committeeAcademyLocations){
						alArray.push(data.committeeAcademyLocations[i].academyLocation.id);
					}
				}*/
				/*multiselectAcademyLocation.getStore().getProxy().extraParams={
					id:$this.getCurrentlyLoggedInUser().id
				};*/
				/*multiselectAcademyLocation.getStore().load({
					callback:function(record) {
						multiselectAcademyLocation.setValue(alArray);
					}
				});*/
				var user = committeeform.findField('user');
				//user.setDisabled(false);
				var userStore = user.getStore();
				userStore.getProxy().actionMethods.read= 'GET';
				userStore.getProxy().extraParams={
					//academyLocationIds: $this.getCurrentAcademyLocation()
					committeeId: record.data.id
				};
				userStore.load({
					callback:function(record) {
						user.setValue(data.committeeCoordinatorId);
					}
				});
				var fromDate = committeeform.findField('fromDate');
				fromDate.setValue(dateRender(data.validFromDate));
				var toDate = committeeform.findField('toDate');
				toDate.setValue(dateRender(data.validTillDate));
				var panelStartDate = committeeform.findField('panelStartDate');
				panelStartDate.setValue(dateRender(data.progressionPanelStartDate));
				var status = committeeform.findField('status');
				status.getStore().load({
					callback:function(record) {
						if(data.status) {
							status.setValue(record[0].data.id);
						} else {
							status.setValue(record[1].data.id);
						}
					}
				});
				var committeeType = committeeform.findField('committeeType');
				if(!isNullOrEmpty(data.committeeTypeId) && !isNullOrEmpty(data.committeeTypeId)) {
					committeeType.getStore().load({
						callback:function(record) {
							committeeType.setValue(data.committeeTypeId);
						}
					});
				}
				var description = committeeform.findField('description');
				description.setValue(data.description);
				
				var id = committeeform.findField('id');
				id.setValue(data.id);
				
				if(!isEditable) {
					$this.getCommitteeform().down('#submitBtn').setVisible(false);
					$this.getCommitteeform().down('#resetBtnCommittee').setVisible(false);
					$this.toggleReadOnlyFormItems(committeeform, true);
				}
			}
		});
	},
	
	updateCommitteeParticipantRecord: function(){
		var $this = this;
		var contentPanel = $this.getContentPanel();
		var grid = $this.getParticipantgrid();
		var committeeGrid = $this.getCommitteegrid();
		
		if(grid.getSelectionModel().getCount()>0) {
			var json = $this.createParticipantJson(grid);
			var submitUrl= SERVERURL.COMMITTEE_PARTICIPANT_UPDATE_DATA;
			Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
			var formData = Ext.encode(json);
			Ext.Ajax.request({
				type : 'rest',
				url : submitUrl,
				jsonData : formData,
				method : 'POST',
				success : function(frm, action) {
					Ext.getBody().unmask();
					committeeGrid.getStore().reload();
	//				committeeGrid.getSelectionModel().deselectAll();
					showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_PARTICIPANTS_CREATED_SUCCESSFULLY'));
					var tabName = getCommonTranslation('COMMITTEE_PARTICIPANT_DETAIL');
					var getcontroller=$this.getController('menu.CoreERPNavigationController');
					var getTab=getcontroller.getTab(tabName);
					if(getTab!=null){
						contentPanel.remove(getTab, true);
					}
				}
			});
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
		
	},
	
	saveParticipantDetails: function(form){
		var $this = this;
		form.down('#submitCommitteeParticipantBtn').setDisabled(true);
		var id = form.down('#id').getValue();
		var participantgrid = $this.getParticipantgrid();
		var json = $this.createSaveParticipantJson(form);
		var membershipDesc = null;
		var membershipType = form.down('#membershipTypeUser');
		var store=membershipType.getStore();
		if( !isNullOrEmpty(membershipType.getStore())){
		if( !isNullOrEmpty(membershipType.getStore().data)){
		if( !isNullOrEmpty(membershipType.getStore().data.items)){
		var length = membershipType.getStore().data.items.length;	
		for(i=0; i < length; i++){	  
	    if(membershipType.getStore().data.items[i].data.id == membershipType.getValue()){
	    	 membershipDesc = membershipType.getStore().data.items[i].data.value;
	                  }
	              }   
			}
		}
		}    
		if(json.length == 0){
			form.down('#submitCommitteeParticipantBtn').setDisabled(false);
			return;
		}
		var submitUrl;
		if(id){
			submitUrl= SERVERURL.COMMITTEE_PARTICIPANT_UPDATE_DATA;
		}else{
			submitUrl= SERVERURL.COMMITTEE_PARTICIPANT_CREATE;
		}
		var formData = Ext.encode(json);
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : json,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask();
				participantgrid.getStore().reload();
				participantgrid.getSelectionModel().deselectAll();
				if(id){
					if(frm.responseText == 'FAILURE'){
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_STUDENT_ALREADY_PART_OF_MEMBERSHIP_TYPE')+ " ("+membershipDesc+")");
					}else{
						showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
					}
				}else{
					if(frm.responseText == '-3'){
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SELECTED_STUDENT_ALREADY_PART_OF_MEMBERSHIP_TYPE')+ " ("+membershipDesc+")");
					}else if(frm.responseText == '-4'){
						showWarningMessage(getCommonTranslation('ALERT'), "Can't add to the committe as Committee End Date has passed");
					}else{
						 showSuccessMessage(getCommonTranslation("COMMITTEE"), getCommonTranslation("COMMITTEE_PARTICIPANTS_CREATED_UPDATED_SUCCESSFULLY"))
					}
				}
	//			$this.getCommitteegrid().getSelectionModel().deselectAll();
				$this.getCommitteegrid().getStore().reload();
				form.close();
			}
		});
	},
	
	hasDuplicates:function(array){
		   var arr = [];
		   for (var i = 0; i < array.length; ++i) {
			   if(!isNullOrEmpty(array[i])){
				   var id = array[i].id;
			        if (id!=null && arr.indexOf(id) !== -1) {
			        	return true;
			        }
			        arr.push(id);
			   }else{
				   arr.push(null);
			   }
		    }
	   },
	
	createSaveParticipantJson: function(form){
		var $this = this;
		var formValues = form.down('#mapCommitteeParticipantWindowId').getForm().getValues();
		var committeeId = $this.getAddcommitteeparticipant().down('#committeeItemId').getValue();
		var arr=[];
		var additionalMembershipTypeArr = [];
		if(!isNullOrEmpty(formValues.additionalMembershipType)){
			 var isArr = isArray(formValues.additionalMembershipType);
			 if (isArr == true) {
				  for (var i = 0; i < formValues.additionalMembershipType.length; i++) {
					   var obj = new Object();
					   obj = $this.getIdValueJson(formValues.additionalMembershipType[i]);
					   additionalMembershipTypeArr.push(obj);
				   }
				  if($this.hasDuplicates(additionalMembershipTypeArr)){
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SAME_ADDITIONAL_MEMBERSHIP_TYPE_ALREAY_ADDED'));
					   return [];
				  }
			   }else{
				   var obj = new Object();
				   obj = $this.getIdValueJson(formValues.additionalMembershipType);
				   additionalMembershipTypeArr.push(obj);
			   }
		}
		var id = form.down('#id').getValue();
		if(id){
			if(!isNullOrEmpty(form.down('#membershipTypeUser').getRawValue())){
				var arryRecordToSave ={
						"participant":{
							"id":form.down('#assignedUserIdForEdit').getValue()
						},
						"committee":{
							"id":committeeId
						},
						"designation":form.down('#designationNameItemId').getValue(),
						"responsibility":form.down('#responsabilityItemId').getValue(),
						"fromDate":formValues.fromDate,
						"toDate" :formValues.toDate,
						"membershipType": {
					        "id" : formValues.membershipTypeUser
					    },
					    "additionalMembershipTypeList": additionalMembershipTypeArr,
					    "id":id
					};
			}else{
				var arryRecordToSave ={
						"participant":{
							"id":form.down('#assignedUserIdForEdit').getValue()
						},
						"committee":{
							"id":committeeId
						},
						"designation":form.down('#designationNameItemId').getValue(),
						"responsibility":form.down('#responsabilityItemId').getValue(),
						"fromDate":formValues.fromDate,
						"toDate" :formValues.toDate,
					    "id":id,
					    "additionalMembershipTypeList": additionalMembershipTypeArr,
					};
			}
		}else{
			if(!isNullOrEmpty(form.down('#membershipTypeUser').getRawValue())){
				var arryRecordToSave ={
						"participant":{
							"id":form.down('#assignedUser').getValue()
						},
						"committee":{
							"id":committeeId
						},
						"designation":form.down('#designationNameItemId').getValue(),
						"responsibility":form.down('#responsabilityItemId').getValue(),
						"fromDate":formValues.fromDate,
						"toDate" :formValues.toDate,
						"membershipType": {
					        "id" : formValues.membershipTypeUser
					    },
					    "additionalMembershipTypeList": additionalMembershipTypeArr,
					};
			}else{
				var arryRecordToSave ={
						"participant":{
							"id":form.down('#assignedUser').getValue()
						},
						"committee":{
							"id":committeeId
						},
						"designation":form.down('#designationNameItemId').getValue(),
						"responsibility":form.down('#responsabilityItemId').getValue(),
						"fromDate":formValues.fromDate,
						"toDate" :formValues.toDate,
						"additionalMembershipTypeList": additionalMembershipTypeArr,
					};
			}
		}
			arr.push(arryRecordToSave);
		return arr;
	},
	
	createParticipantJson: function(grid){
		var records = grid.getSelectionModel().getSelection();
		var arryRecordToSave=[];
		for(var i in records) {
			var fromDate = null ;
			var toDate = null;
			if(!isNullOrEmpty(records[i].data.fromDate))
			{	
				fromDate = Ext.Date.format(new Date(records[i].data.fromDate), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);//records[i].data.fromDate;
				if(fromDate==="NaN-NaN-0NaN"){
					fromDate= records[i].data.fromDate;
				}
			}
			if(!isNullOrEmpty(records[i].data.toDate))
			{
				toDate = Ext.Date.format(new Date(records[i].data.toDate), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);//records[i].data.toDate;
				if(toDate==="NaN-NaN-0NaN"){
					toDate= records[i].data.toDate;
				}
			}
			arryRecordToSave.push({
				"id":records[i].data.id,
				"participant":{
					"id":records[i].data.participant.id
				},
				"committee":{
					"id":records[i].data.committee.id
				},
				"designation":records[i].data.designation,
				"responsibility":records[i].data.responsibility,
				//"fromDate":!isNullOrEmpty(records[i].data.fromDate)?Ext.Date.format(new Date(records[i].data.fromDate), 'd-m-Y'):'null',
				//"toDate" :!isNullOrEmpty(records[i].data.fromDate)?Ext.Date.format(new Date(records[i].data.toDate), 'd-m-Y'):'null'
				"fromDate":fromDate,
				"toDate":toDate
			});
		}
		return arryRecordToSave;
	},
	
	saveCommitteeRecord: function(){
		var $this = this;
		var contentPanel = $this.getContentPanel();
		var grid = $this.getCommitteegrid();
		var json;
		var submitUrl;
		var isView = '';
		var isPermissionGiven = $this.getCommitteefilter().config.isPermissionGiven;
		if($this.getCommitteeform().getCode()) {
			json = $this.createSaveJson($this);
			submitUrl = SERVERURL.COMMITTEE_SAVE;
			isView = 'ADD';
		} else {
			json = $this.createUpdateJson($this, grid);
			submitUrl = SERVERURL.COMMITTEE_UPDATE;
			isView = 'EDIT';
		}
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		var formData = Ext.encode(json);
		if(isNullOrEmpty(formData.committeeType) || isNullOrEmpty(formData.committeeType.id)) {
			delete formData.committeeType;
		}
		
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : formData,
			method : 'POST',
			success : function(frm, action) {
				
				if (isView == 'ADD') {
		            tabName = getCommonTranslation('ADD_COMMITTEE');
		            showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_CREATED_SUCCESSFULLY'));
		            var getcontroller=$this.getController('menu.CoreERPNavigationController');
                    var getAddTab = getcontroller.getTab(getCommonTranslation('ADD_COMMITTEE'));
                    if (getAddTab != null) {
                        contentPanel.remove(getAddTab, true);
                    } 
				}
		        else if (isView== 'EDIT') {
		            tabName = getCommonTranslation('EDIT_COMMITTEE');
		            showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_UPDATED_SUCCESSFULLY'));
		            var getcontroller=$this.getController('menu.CoreERPNavigationController');
                    var getAddTab = getcontroller.getTab(getCommonTranslation('EDIT_COMMITTEE'));
                    if (getAddTab != null) {
                        contentPanel.remove(getAddTab, true);
                    } 
		        }
				$this.resetCommitteeFilter();
				var store = $this.getStore('user.UserAcademyLocationStore');
		    	var alids=[];
		    	store.getProxy().extraparams={
		    		id:$this.getCurrentlyLoggedInUser().id
		    	}
		    	store.load({
		    		callback:function(record) {
		    			for (var i in record) {
		    				alids.push(record[i].data.id);
		    			}
	                    $this.resetPageSetting(grid.getStore());
		    			grid.getStore().getProxy().extraParams= {
			        		academyLocationIds :alids.join()
			        	};
			        	grid.getSelectionModel().deselectAll();
			        	$this.resetGridSetting(grid);
			        	$this.resetPageSetting(grid.getStore());
			        	//grid.getStore().load();
		    		}
		    	});
		    	var getcontroller=$this.getController('menu.CoreERPNavigationController');
				grid.getSelectionModel().deselectAll();
				var structure = $this.getManageCommitteeTabPanel();
				/*var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}*/
				if (isView == 'ADD') {
				Ext.defer(function(){
					Ext.getBody().unmask();
					structure.child('#membershipId').tab.setDisabled(false);
					var rec = grid.getStore().findRecord('id',frm.responseText)
					if(rec){
						grid.getSelectionModel().select(rec);
						//$this.editCommitteeRecord();
					}
				},1500);
				}else{
					Ext.getBody().unmask();
				}
				
			}
		});
	},
	createSaveJson: function($this){
		var formValue = $this.getCommitteeform().getValues();
		var json= new Object;
		var coordinator={
			"id":	formValue.user
		};
		var committeeType=null;
		if(!isNullOrEmpty(formValue.committeeType)) {
			committeeType = {
				"id":	formValue.committeeType
			};
		}
		/*var ALIds=[];
		for (var i=0; i<formValue.multiselectAcademyLocation.length; i++) {
			var alids ={
					"id":(formValue.multiselectAcademyLocation[i].data!=undefined)?formValue.multiselectAcademyLocation[i].data.id:formValue.multiselectAcademyLocation
			}
			academyLocation={
					"academyLocation":alids
			}
			ALIds.push(academyLocation)
		}*/
		var isStatus;
		if(formValue.status == "ACTIVE") {
			isStatus=true;
		} else {
			isStatus=false;
		}
		json = {
				"committeeCode": formValue.committeeCode,
				"committeeName": formValue.committeeName,
				"committeeCoordinator":coordinator,
				"validFromDate":formValue.fromDate,
				"validTillDate":formValue.toDate,
				"status":isStatus,
				"description":formValue.description,
				"committeeType":committeeType,
				"progressionPanelStartDate":formValue.panelStartDate
		};
		return json;	
	},
	
	createUpdateJson: function($this, grid){
		var formValue = $this.getCommitteeform().getValues();
		var json= new Object;
		var coordinator={
			"id":	formValue.user
		};
		var committeeType=null;
		if(!isNullOrEmpty(formValue.committeeType)) {
			committeeType = {
				"id":	formValue.committeeType
			};
		}
		/*var ALIds=[];
		for (var i=0; i<formValue.multiselectAcademyLocation.length; i++) {
			academyLocation={
					"academyLocation":{
						"id":(formValue.multiselectAcademyLocation[i].data!=undefined)?formValue.multiselectAcademyLocation[i].data.id:formValue.multiselectAcademyLocation[i]
					}
			}	
			ALIds.push(academyLocation)
		}*/
		var isStatus;
		if(formValue.status == "ACTIVE") {
			isStatus=true;
		} else {
			isStatus=false;
		}
		json = {
				"id":formValue.id,
				"committeeCode": formValue.committeeCode,
				"committeeName": formValue.committeeName,
				"committeeCoordinator":coordinator,
				"validFromDate":formValue.fromDate,
				"validTillDate":formValue.toDate,
				"status":isStatus,
				"description":formValue.description,
				"committeeType":committeeType,
				"progressionPanelStartDate":formValue.panelStartDate
		};
		return json;	
	},
	
	openCommitteeSendMessage:function(obj){
	
		var grid = this.getCommitteegrid();
		//var gridMSG = this.getStaticDocumentAttachmentGrid();
		if(grid.getSelectionModel().getCount()>0) {
			if(grid.getSelectionModel().getSelection()[0].data.totalParticipants >0){
				var $this=this;
				var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		       	   var structure = Ext.widget('committeesendmessage');
		       	   var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
		       	   /**
		       	    * This is to remove tab from content panel and open same tab again
		       	    */
		       	   var getcontroller=this.getController('menu.CoreERPNavigationController');
		       	   var getTab=getcontroller.getTab(tabName);
		       	   if(getTab!=null){
		       		   contentPanel.remove(getTab, true);
		       	   }
		       	var formWindowTab = $this.getCommitteesendmessage();
		       	formWindowTab.down("#selectTemplate").allowBlank=true;
		       	formWindowTab.down("#selectTemplate").setVisible(false);
		       	formWindowTab.down("#messageName").allowBlank=true;   
		       	formWindowTab.down("#messageName").setVisible(false);
				var templateStore = formWindowTab.down('#selectTemplate').getStore();
				templateStore.getProxy().extraParams={
					msgRecipientTypeId:43
				};
				templateStore.load();
				
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				   Ext.Ajax.request({
					   method : "GET",
					   type : 'rest',
					   url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=Committeebe539740-692d-4ae1-bc17-338c4002874d',
					   headers : {
						   'Content-Type' : 'application/json'
					   },
					   success : function(form,action) {
						   var data = Ext.JSON.decode(form.responseText);
						   formWindowTab.down("#id").setValue(data.id);
						   formWindowTab.down("#code").setValue(data.code);
						   formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
						   formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
						   formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
						   Ext.getBody().unmask();
						   
						   //grid.getStore().reload();
						   //showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
					   }
	
				   });
		       	openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
				/*if (!formWindow) {
					Ext.widget('committeesendmessage');
					formWindow = $this.getCommitteesendmessage();
				}
				formWindow.show(;*/
			}
			else {
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COMMITTEE_PARTICIPANTS_NOT_FOUND'));
			}
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	/**
	 * save document file. It's external call method
	 * @param entityId : person id, It's mandatory. 
	 * @param module : module name, for student module 'student', It's mandatory.
	 * @param entityType : entity type, It's mandatory.
	 * @param documentType : document type, It's mandatory.
	 * @param isTransient : true or false (send json back to module controller or not)
	 * @param callBackFunction : callback function return in module controller. It's mandatory.
	 */
	saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
		var submitUrl = '';
		var templateTab = this.getContentPanel();
		var formWin =  this.getCommitteesendmessage();
		var form = formWin.down('#msgDetailsForm');
		var id = form.down('#document_hidden_field');
	    if (isNullOrEmpty(id.getSubmitValue())) {
	        submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
	    }
	    var data = new Object();
	    if(!isNullOrEmpty(entityId)){
	    	data.entityId = entityId;
	    }else{
	    	data.entityId = null;
	    }
	    if(!isNullOrEmpty(module)){
	    	data.module = module;
	    }else{
	    	data.module = null;
	    }
	    if(!isNullOrEmpty(entityType)){
	    	data.entityType = entityType;
	    }else{
	    	data.entityType = null;
	    }
	    form.getForm().setValues(data);
	    form.getForm().submit({
	    	method : 'POST',
	    	url : submitUrl,
	    	success : function(form, action){
	    		callBackFunction(true, action, isTransient);
	    		
	    	}
	    });
	},
	/**
	 * upload static document file
	 */
	uploadStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
		var this$ = this;
		var setupForm = fileField.up('committeesendmessage');
		var grid = setupForm.down('#staticDocumentAttachmentGridMessage');
		fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
		var file = fileField.fileInputEl.dom.files[0];
		fileField.setRawValue(fileUploadPath);
		var sub = setupForm.down('#subject');
		var isNullSubject = sub.getValue();
		if(isNullOrEmpty(isNullSubject)){
			sub.setValue(' ');
		}
		
		if((file.size / 1048576) <= CONSTANTS.EMAIL_UPLOAD_FILE_SIZE_LIMIT  ){
			if(!isNullOrEmpty(fileUploadPath)){
				var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
				if (this$.isValidFileExtensionForMessaging(extension)) {
					var entityId = 'COMMITTEE_ADHOC';
					var module = 'messaging';
					var entityType = 'template';
					var documentType = 'DOCUMENT';
					var isTransient = true;
					var this$ = this;
					this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
						if(success){
							var path = Ext.JSON.decode(action.response.responseText).path;
							var user = this$.getCurrentlyLoggedInUser();
							var store = grid.getStore();
							var documentStatus = "SUBMITTED";
							var documentType = null;
							if(!isNullOrEmpty(path)){
								store.add({
									id: '',
									name: fileUploadPath,
									path: path ,
									createdBy : {
										id :user.id,
										value : user.value,
										code : user.code
									},
									status : documentStatus,
									documentType : documentType,
									templateConfigDocId: '',
									submissionDate: Ext.Date.format(new Date(), CONSTANTS.NEW_SUBMIT_DATE_FORMAT)
	
								});
								this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
								showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
							}
	
							fileField.reset();
							if(isNullOrEmpty(isNullSubject)){
								sub.reset();
							}
							
						}
	
					}, isTransient);
				}else{
					fileField.reset();
					showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
				}
			}
		}else{
			fileField.reset();
			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
		}
	},
	/**
	 * Add value to grid
	 */
	loadGridWithFileNameMessage:function(grid,value,store){
		grid.bindStore(store);
	},
	/**
	 * Remove entry from grid
	 */
	deleteStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
		var grid = view.up('#staticDocumentAttachmentGridMessage');
		var panel = this.getContentPanel().getActiveTab();
		var tabTitle = panel.title;
		var store = grid.getStore();
		var templateConfigDocId = record.get('templateConfigDocId');
		var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
		if(!(tabTitle == viewTitle)){
			if(!isNullOrEmpty(templateConfigDocId)){
	            showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	                if (btn == 'yes') {
	                	Ext.Ajax.request({
	                        type: 'rest',
	                        url: SERVERURL.STATIC_DOC_DELETE,
	                        method: 'DELETE',
	                        params: {
	                        	templateConfigDocId : templateConfigDocId
	                        },
	                        headers: {
	                            'Content-Type': 'application/json'
	                        },
	                        success: function(form, action) {
	                        	store.remove(record);
	                            showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	                        }
	                    });
	                }
	            });
	        
	    	}else{
	    		store.remove(record);
	    		showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
	    	}
		}else{
			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
		}
		
	},
	//Disable other Privileges button 
	disableManageCommOtherPivileges: function(gridReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var buttonsToolBar = gridReference.query('toolbar')[0];
		buttonsToolBar.setVisible(false);
		var sendMessageBtn=buttonsToolBar.query('#sendMessageBtn')[0];
		var saveBtn = buttonsToolBar.query('#btnSaveItemId')[0];
		var addMeetingBtn = buttonsToolBar.query('#addMeetingBtn')[0];
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'SENDMESSAGE') {
				if(!isNullOrEmpty(sendMessageBtn)){
					sendMessageBtn.setVisible(true);
				}        		
			}
			if (privilege === 'SAVE') {
				if(!isNullOrEmpty(saveBtn)){
					saveBtn.setVisible(true);
				}        		
			}
			if (privilege === 'ADD_MEETING') {
				if(!isNullOrEmpty(addMeetingBtn)){
					addMeetingBtn.setVisible(true);
				}        		
			}
		});
		buttonsToolBar.setVisible(true);
	},
	resetCommitteeForm: function() {
	    var $this = this;
	    var form = $this.getCommitteeform().getForm();
	    var recId = $this.getCommitteeform().down("#idItemId").getValue();
	    form.reset();
	    var fromDateItemId = $this.getCommitteeform().down("#fromDateItemId");
	    fromDateItemId.setValue(new Date());
	    var userItemId = $this.getCommitteeform().down("#userItemId");
	    $this.getCommitteeform().down('#toDateItemId').clearInvalid();
		$this.getCommitteeform().down('#panelStartDateItemId').clearInvalid();
	//    userItemId.setDisabled(true);
	    userItemId.reset();
	    $this.getCommitteeform().down("#idItemId").setValue(recId);
	},
	disableMoreActionPivileges: function(gridReference,permissionsMap) {
	
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	
		var buttonsToolBar = gridReference.query('toolbar')[0];
	
		var splitbuttons = buttonsToolBar.query('splitbutton')[0];
		splitbuttons.setVisible(false);
	
		Ext.each(splitbuttons.menu.items.items, function(menuItems) {
			menuItems.setVisible(false);
		});
	
		var sendMessageBtn=buttonsToolBar.query('#sendMessageBtn')[0];
		var addMeetingBtn = buttonsToolBar.query('#addMeetingBtn')[0];
		var buttonMoreAction = buttonsToolBar.query('#spBtnMoreActions')[0];
		var btnApplyTo = buttonsToolBar.query('#btnApplyTo')[0];
		var isVisibleMore = false;
		
		Ext.each(permissionList, function(privilege) {
	
			if (privilege === 'SENDMESSAGE') {
				if(!isNullOrEmpty(sendMessageBtn)){
					sendMessageBtn.setVisible(true);
					isVisibleMore = true;
				}        		
			}
			if (privilege === 'ADD_MEETING') {
				if(!isNullOrEmpty(addMeetingBtn)){
					addMeetingBtn.setVisible(true);
					isVisibleMore = true;
				}        		
			}
			if (privilege === 'APPLY_TO') {
				if(!isNullOrEmpty(btnApplyTo)){
					btnApplyTo.setVisible(true);
					isVisibleMore = true;
				}        		
			}
			if(isVisibleMore){
				buttonMoreAction.setVisible(true);
			}
		});
	},
	openApplyToTab: function(){
		var $this=this;
		var grid = $this.getCommitteegrid();
		var gridData = grid.getSelectionModel().getSelection()[0];
		if (grid.getSelectionModel().getCount() > 0) {
			if(grid.getSelectionModel().getCount() == 1) {
				var record = grid.getSelectionModel().getSelection();
				var tabName = getExaminationTranslation('APPLY_TO');
				var contentPanel = $this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
				var structure = Ext.widget('committeapplytotabstructure');
				/**
				 * This is to remove tab from content panel and open same tab again
				 */
				var getcontroller=$this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentPanel.remove(getTab, true);
				}
				
				if(!isNullOrEmpty(record)){
					structure.config.committeGridRecord = record[0];
					Ext.Ajax.request({
			            type: 'rest',
			            url: SERVERURL.PATH_GET_TYPE_OF_MAPPING,
			            method: 'GET',
			            params : {
			            	committeeId : record[0].get('id')
						 },
			            success: function(response, action) {
			                var responseData = Ext.decode(response.responseText);
			                var isCV,isPBP,isPBS,applyToGrid,committeeApplyToGridStore;
			                if (responseData.mapped) {
			                	if(!isNullOrEmpty(responseData.courseVariantId)){
			                		isCV=true;
			                		isPBP=false;
			                		isPBS=false;
			                		applyToGrid = structure.query('committeapplytogridforcoursesection')[0];
			        				committeeApplyToGridStore = applyToGrid.getStore();
			                	}else if(!isNullOrEmpty(responseData.progBatchPeriodConfigId)){
			                		isCV=false;
			                		isPBP=true;
			                		isPBS=false;
			                		applyToGrid = structure.query('committeapplytogridforprogrambatchperiod')[0];
			        				committeeApplyToGridStore = applyToGrid.getStore();
			                	}else if(!isNullOrEmpty(responseData.seatConfigId)){
			                		isCV=false;
			                		isPBP=false;
			                		isPBS=true;
			                		applyToGrid = structure.query('committeapplytogrid')[0];
			        				committeeApplyToGridStore = applyToGrid.getStore();
			                	}
			                }else{
			                	isCV=false;
		                		isPBP=false;
		                		isPBS=true;
			                	applyToGrid = structure.query('committeapplytogrid')[0];
		        				committeeApplyToGridStore = applyToGrid.getStore();
			                }
			                committeeApplyToGridStore.getProxy().extraParams={
								committeeId: record[0].get('id'),
								isCV:isCV,
								isPBP:isPBP,
								isPBS:isPBS,
							};
			                committeeApplyToGridStore.sorters.clear();
							committeeApplyToGridStore.removeAll();
							committeeApplyToGridStore.load();
			            }
			        });
				}
				openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_NINE);
			} else {
				 showWarningMessage(getExaminationTranslation('APPLY_TO'), getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
			 }
			
		}else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	openAddCommitteeMappingTab: function(committeemappingtabstructure,grid){
		var contentpanel = this.getContentPanel();
		var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
	
		//var committeeaddmappingstructure = committeemappingtabstructure.down('committeeaddmappingstructure');
		
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentpanel.remove(getTab, true);
		}
		openTab(contentpanel, tabName, committeemappingtabstructure,CONSTANTS.MENU_COLOR_NINE);
		var committeeaddmappingstructure = this.getCommitteeaddmappingstructure();
		var committeapplytotabstructure = this.getCommitteapplytotabstructure();
		//var academylocationgrid = this.getCommitteeaddmappingalgrid();
		grid.getStore().clearFilter();
		grid.getStore().load();
		this.getAdjustmentprogresstracker().setVisible(true);
	
		this.resetProgressTracker(committeemappingtabstructure);
		var adjustmentprogresstracker = committeemappingtabstructure.down("#adjustmentprogresstracker");
		var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
		progresstracker1.textEl.removeCls("x-progress-text x-progress-text-back");
		progresstracker1.textEl.addCls("inProgressCss-progress-text");
		progresstracker1.updateText("Step 1 In Progress");
		var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
		if(!isNullOrEmpty(recordsCommitteeGrid)){
			committeemappingtabstructure.down("#lblCommittee").setValue(recordsCommitteeGrid.get('committeeName'));
			committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
		}
	},
	openViewCommitteeMappingTab: function(grid){
		var $this=this;
		//var grid = $this.getCommitteapplytogrid();
		var gridData = grid.getSelectionModel().getSelection()[0];
		if (grid.getSelectionModel().getCount() > 0) {
			var formWindow = $this.getCommitteeapplytoviewwindow();
			if (!formWindow) {
				Ext.widget('committeeapplytoviewwindow');
				formWindow = $this.getCommitteeapplytoviewwindow();
				if(grid.xtype=='committeapplytogrid'){
					formWindow.down('#academyLocationAL').setValue(gridData.get('academyLocationName'));
					formWindow.down('#programGroupAL').setValue(gridData.get('programGroupName'));
					formWindow.down('#seatTypeAL').setValue(gridData.get('seatTypeName'));
					formWindow.down('#programAL').setValue(gridData.get('programName'));
					formWindow.down('#batchAL').setValue(gridData.get('batchName'));
					formWindow.down('#committeeCodeAL').setValue(gridData.data.committee.code);
					formWindow.down('#committeeNameAL').setValue(gridData.data.committee.value);
					formWindow.down('#academyTerm').setVisible(false);
					formWindow.down('#periodAT').setVisible(false);
					formWindow.down('#courseAT').setVisible(false);
					formWindow.down('#courseVariantAT').setVisible(false);
				}else if(grid.xtype=='committeapplytogridforprogrambatchperiod'){
					formWindow.down('#academyTerm').setVisible(true);
					formWindow.down('#periodAT').setVisible(true);
					formWindow.down('#courseAT').setVisible(false);
					formWindow.down('#courseVariantAT').setVisible(false);
					formWindow.down('#academyLocationAL').setVisible(false);
					formWindow.down('#programGroupAL').setVisible(false);
					formWindow.down('#seatTypeAL').setVisible(false);
					formWindow.down('#academyTerm').setValue(gridData.get('academicTermName'));
					formWindow.down('#programAL').setValue(gridData.get('programName'));
					formWindow.down('#batchAL').setValue(gridData.get('batchName'));
					formWindow.down('#periodAT').setValue(gridData.get('periodName'));
					formWindow.down('#committeeCodeAL').setValue(gridData.raw.committeeCode);
					formWindow.down('#committeeNameAL').setValue(gridData.raw.committeeName);
				}else if(grid.xtype=='committeapplytogridforcoursesection'){
					formWindow.down('#academyTerm').setVisible(true);
					formWindow.down('#periodAT').setVisible(false);
					formWindow.down('#courseAT').setVisible(true);
					formWindow.down('#courseVariantAT').setVisible(true);
					formWindow.down('#academyLocationAL').setVisible(false);
					formWindow.down('#programGroupAL').setVisible(false);
					formWindow.down('#seatTypeAL').setVisible(false);
					formWindow.down('#programAL').setVisible(false);
					formWindow.down('#batchAL').setVisible(false);
					formWindow.down('#academyTerm').setValue(gridData.get('academicTerm').value);
					formWindow.down('#courseAT').setValue(gridData.get('courseCodeName'));
					formWindow.down('#courseVariantAT').setValue(gridData.get('courseVariantCode'));
					formWindow.down('#committeeCodeAL').setValue(gridData.raw.committeeCode);
					formWindow.down('#committeeNameAL').setValue(gridData.raw.committeeName);
				}
			}
			formWindow.show();
			
		}else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	
	academyLocationNextEventCommittee:function(btn){
		var academylocationgrid = this.getCommitteeaddmappingalgrid();
    	var selectionModel = academylocationgrid.getSelectionModel().getSelection();
    	var academyLocationIdsArr = [];
    	selectionModel.forEach(function(obj){
    		academyLocationIdsArr.push(obj.get('id'));
    	});
    	if(academyLocationIdsArr.length > 0){
	    	var committeeaddmappingstructure = this.getCommitteeaddmappingstructure();
	    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
	    	var committeemappingtabstructure = this.getCommitteeaddmappingtab();
	    	var programcontainer = committeeaddmappingstructure.down('#programcontainer');
	    	programcontainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(programcontainer);
	    	var alProgramGrid = this.getCommitteeaddmappingprogramgrid();
	    	var alProgramSearchCombo = alProgramGrid.down('#programsearchcombo');
	    	alProgramSearchCombo.reset();
	    	alProgramSearchCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	//alProgramSearchCombo.getStore().load();
	    	var alProgramGridStore = alProgramGrid.getStore();
	    	alProgramGridStore.getProxy().extraParams= {
	    		academyLocationIds: academyLocationIdsArr.join()
	    	};
	    	alProgramGridStore.clearFilter();
	    	alProgramGridStore.load();
	    	this.setProgressTracker(1, committeemappingtabstructure);
	    	var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				
				committeeaddmappingstructure.down("#lblCommitteeProgramTab").setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingName').setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    setProgressTrackerToAlumni : function(progresstracker){
    	var structure = this.getAlumnicommitteeaddmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");

    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker3.textEl.addCls("inProgressCss-progress-text");
    		progresstracker3.updateText("Step 3 In Progress");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    	}
    	if(progresstracker==3){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker3.updateProgress((i * 0.1), '');
    		}
    		progresstracker3.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker3.textEl.addCls("custom-progress-text");
    		progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker4.textEl.addCls("inProgressCss-progress-text");
    		progresstracker4.updateText("Step 4 In Progress");
    		progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
    	}
    },
    setProgressTracker : function(progresstracker,structure){
    	//var structure = this.getCommitteeaddmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");

    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	var progresstracker3 = adjustmentprogresstracker.down("#progresstracker3");
    	var progresstracker4 = adjustmentprogresstracker.down("#progresstracker4");
    	var progresstracker5 = adjustmentprogresstracker.down("#progresstracker5");

    	if(progresstracker==1){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker1.updateProgress((i * 0.1), '');
    		}
    		progresstracker1.textEl.addCls("custom-progress-text");
    		progresstracker1.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker2.textEl.addCls("inProgressCss-progress-text");
    		progresstracker2.updateText("Step 2 In Progress");
    		progresstracker1.updateText(getCommonTranslation('STEP_1_COMPLETE'));
    	}
    	if(progresstracker==2){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker2.updateProgress((i * 0.1), '');
    		}
    		progresstracker2.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker2.textEl.addCls("custom-progress-text");
    		progresstracker3.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker3.textEl.addCls("inProgressCss-progress-text");
    		progresstracker3.updateText("Step 3 In Progress");
    		progresstracker2.updateText(getCommonTranslation('STEP_2_COMPLETE'));
    	}
    	if(progresstracker==3){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker3.updateProgress((i * 0.1), '');
    		}
    		progresstracker3.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker3.textEl.addCls("custom-progress-text");
    		progresstracker4.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker4.textEl.addCls("inProgressCss-progress-text");
    		progresstracker4.updateText("Step 4 In Progress");
    		progresstracker3.updateText(getCommonTranslation('STEP_3_COMPLETE'));
    	}
    	if(progresstracker==4){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker4.updateProgress((i * 0.1), '');
    		}
    		progresstracker4.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker4.textEl.addCls("custom-progress-text");
    		progresstracker5.textEl.removeCls("x-progress-text x-progress-text-back");
    		progresstracker5.textEl.addCls("inProgressCss-progress-text");
    		progresstracker5.updateText("Step 5 In Progress");
    		progresstracker4.updateText(getCommonTranslation('STEP_4_COMPLETE'));
    	}
    	if(progresstracker==5){
    		for(var i = 0; i < 11; i ++ ){
    			progresstracker5.updateProgress((i * 0.1), '');
    		}
    		progresstracker5.textEl.removeCls("inProgressCss-progress-text");
    		progresstracker5.textEl.addCls("custom-progress-text");
    		progresstracker5.updateText(getCommonTranslation('STEP_5_COMPLETE'));
    	}
    },
    resetProgressTracker : function(structure){
    	//var structure = this.getCommitteeaddmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    },
    resetProgressTrackerToAlumni : function(){
    	var structure = this.getAlumnicommitteeaddmappingtab();
    	var adjustmentprogresstracker = structure.down("#adjustmentprogresstracker");
    	var progresstracker1 = adjustmentprogresstracker.down("#progresstracker1");
    	var progresstracker2 = adjustmentprogresstracker.down("#progresstracker2");
    	progresstracker1.reset();
    	progresstracker1.updateText('');
    	progresstracker2.reset();
    	progresstracker2.updateText('');
    },
    submitMappingWithAcademyLocation: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getCommitteeaddmappingstructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtab();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	
    	var committeeMappingId = committeemappingtabstructure.down('#committeeMappingId').getValue();
    	var applyToGrid = this.getCommitteapplytogrid();
    	
    	var submitJsonArr;
    	var jsonALArr = [];
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.COMMITTEE_ACADEMY_LOCATION_MAPPING_SAVE_DATA;
    		if(activeGrid.xtype == 'committeeaddmappingalgrid'){
    			selectedRecord.forEach(function(obj){
    				jsonALArr.push(obj.get('id'));
    			});
    			submitJsonArr={
    					committeeId: parseInt(committeeMappingId),
    					academyLocationIds: jsonALArr.join()
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: SERVERURL.COMMITTEE_ACADEMY_LOCATION_MAPPING_CHECK,
    			params: {
    				committeeId: parseInt(committeeMappingId),
					academyLocationIds: jsonALArr.join()
        		},
    			success : function(response, action) {
    				
    				var data = Ext.decode(response.responseText);
    				
    				if(data.committeeId == 0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
          				if(!alertWin){
          					alertWin = Ext.widget('committeemappingalertwin');
          				}
          				alertWin.down('#committeeAlert').setValue(getCommonTranslation('COMMITTEE_ALREDAY_MAPPED_AL_PROGRAM_GROUP_MSG'));
          				var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
          				var htmlData = '';
          				if(data.academyLocationPGList.length>0){
          					data.academyLocationPGList.forEach(function(obj){
          						htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj.secondValue + ' - ' + obj.value + '</div>';
          					});
          					
          					pnlListMappingFld.setValue(htmlData);
          				}
          				var btn = alertWin.down('#committeeAlertBtnOk');
          				btn.on('click', function() {
          					alertWin.close();
          					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
          					Ext.Ajax.request({
          						method: "POST",
          						type: 'rest',
          						url: submitUrl,
          						jsonData:submitJsonArr,
          						success : function(response, action) {
          							Ext.getBody().unmask();
          							var data = response.responseText;
          							var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
          							var getTab=getcontroller.getTab(tabName);
          							if(getTab!=null){
          								contentPanel.remove(getTab, true);
          							}

          							/*Start code for open Apply To tab again with updated records */
          							var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
          							var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
          							if(getTabApplyTo!=null){
          								contentPanel.remove(getTabApplyTo, true);
          							}
          							var committeeApplyToGridStore = applyToGrid.getStore();
          							if(!isNullOrEmpty(committeeMappingId)){
          								committeeApplyToGridStore.getProxy().extraParams={
          									committeeId: committeeMappingId
          								};
          							}
          							$this.resetGridSetting(applyToGrid);
            			        	$this.resetPageSetting(committeeApplyToGridStore);
            	    				committeeApplyToGridStore.load();
          							
          							var structure = Ext.widget('committeapplytotabstructure');

          							openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
          							/* End code for open Apply To tab again with updated records */
          							showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
          						}
          					});
          				});
          				alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
        					method: "POST",
        					type: 'rest',
        					url: submitUrl,
        					jsonData:submitJsonArr,
        					success : function(response, action) {
        						Ext.getBody().unmask();
        						var data = response.responseText;
        						var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
        						var getTab=getcontroller.getTab(tabName);
        						if(getTab!=null){
        							contentPanel.remove(getTab, true);
        						}

        						 /*Start code for open Apply To tab again with updated records */
        						var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
        						var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
        						if(getTabApplyTo!=null){
        							contentPanel.remove(getTabApplyTo, true);
        						}
        						var committeeApplyToGridStore = applyToGrid.getStore();
        						if(!isNullOrEmpty(committeeMappingId)){
        							committeeApplyToGridStore.getProxy().extraParams={
        								committeeId: committeeMappingId
        							};
        						}
        						$this.resetGridSetting(applyToGrid);
        			        	$this.resetPageSetting(committeeApplyToGridStore);
        	    				committeeApplyToGridStore.load();
        						var structure = Ext.widget('committeapplytotabstructure');

        						openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
        						/* End code for open Apply To tab again with updated records */
        						showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
        					}
        				});
    				}
    			}
    		});
    		
    		
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    deleteCommitteeMappingRecord: function(grid){
    	var $this=this;
    	//var grid = $this.getCommitteapplytogrid();
    	if (grid.getSelectionModel().getCount() > 0) {
    		showConfirmMessage(getCommonTranslation('COMMITTEE'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    			if (btn == 'yes') {
    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    				var records = grid.getSelectionModel().getSelection();
    				var id = records[0].get("id");
    				Ext.Ajax.request({
    					method : "DELETE",
    					type : 'rest',
    					url : SERVERURL.COMMITTEE_MAPPING_DELETE+'?id='+ id,
    					headers : {
    						'Content-Type' : 'application/json'
    					},
    					success : function(form,action) {
    						Ext.getBody().unmask();
    						if(Ext.decode(form.responseText) == 0) {
    							showWarningMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('DEPENDENCY_EXIST_MSG'));
    						}else {
    							$this.resetGridSetting(grid);
    				        	$this.resetPageSetting(grid.getStore());
    							grid.getStore().load();
    							showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPING_DELETED_SUCCESSFULLY'));
    						}
    					}
    				});
    			}
    		});
    	}else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitMappingWithProgramGroup: function(btn){
    	var $this = this;
    	var contentPanel = this.getContentPanel();
    	var tabStructure = this.getCommitteeaddmappingstructure();
    	var getcontroller=this.getController('menu.CoreERPNavigationController');
    	var activeGrid = tabStructure.getActiveTab().down('grid');
    	var selectedRecord = activeGrid.getSelectionModel().getSelection();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtab();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	
    	var committeeMappingId = committeemappingtabstructure.down('#committeeMappingId').getValue();
    	var applyToGrid = this.getCommitteapplytogrid();
    	
    	var submitJsonArr;
    	var academyLocationPGList;
    	var jsonALArr = [];
    	if(selectedRecord.length>0){
    		var submitUrl = SERVERURL.COMMITTEE_PROGRAM_GROUP_MAPPING_SAVE_DATA;
    		if(activeGrid.xtype == 'committeeaddmappingprogramgrid'){
    			selectedRecord.forEach(function(obj){
    				academyLocationPGList = {
    					id:obj.get('longValue'),
    					secondId: obj.get('secondId')
    				}
    				jsonALArr.push(academyLocationPGList);
    			});
    			submitJsonArr={
    					committeeId: parseInt(committeeMappingId),
    					academyLocationPGList: jsonALArr
    			}
    		}
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: SERVERURL.COMMITTEE_PROGRAM_GROUP_MAPPING_CHECK,
    			jsonData:submitJsonArr,
    			success : function(response, action) {
    				
    				var data = Ext.decode(response.responseText);
    				
    				if(data.committeeId == 0){
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
          				if(!alertWin){
          					alertWin = Ext.widget('committeemappingalertwin');
          				}
          				alertWin.down('#committeeAlert').setValue(getCommonTranslation('COMMITTEE_ALREDAY_MAPPED_AL_PROGRAM_GROUP_MSG'));
          				var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
          				var htmlData = '';
          				if(data.academyLocationPGList.length>0){
          					data.academyLocationPGList.forEach(function(obj){
          						htmlData = htmlData + '<div style="padding-bottom: 3px;">' + obj.secondValue + ' - ' + obj.value + '</div>';
          					});
          					
          					pnlListMappingFld.setValue(htmlData);
          				}
          				var btn = alertWin.down('#committeeAlertBtnOk');
          				btn.on('click', function() {
          					alertWin.close();
          					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
          					Ext.Ajax.request({
        		    			method: "POST",
        		    			type: 'rest',
        		    			url: submitUrl,
        		    			jsonData:submitJsonArr,
        		    			success : function(response, action) {
        		    				Ext.getBody().unmask();
        		    				var data = response.responseText;
        		    				var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
        		    				var getTab=getcontroller.getTab(tabName);
        		    				if(getTab!=null){
        		    					contentPanel.remove(getTab, true);
        		    				}

        		    				/* Start code for open Apply To tab again with updated records */
        		    				var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
        		    				var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
        		    				if(getTabApplyTo!=null){
        		    					contentPanel.remove(getTabApplyTo, true);
        		    				}
        		    				var committeeApplyToGridStore = applyToGrid.getStore();
        		    				if(!isNullOrEmpty(committeeMappingId)){
        		    					committeeApplyToGridStore.getProxy().extraParams={
        		    						committeeId: committeeMappingId
        		    					};
        		    				}
        		    				$this.resetGridSetting(applyToGrid);
        				        	$this.resetPageSetting(committeeApplyToGridStore);
        		    				committeeApplyToGridStore.load();
        		    				
        		    				
        		    				var structure = Ext.widget('committeapplytotabstructure');
        		    				
        		    				openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
        		    				/* End code for open Apply To tab again with updated records */
        		    				showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
        		    			}
        		    		});
          				});
          				alertWin.show();
    				}
    				else{
    					Ext.Ajax.request({
    		    			method: "POST",
    		    			type: 'rest',
    		    			url: submitUrl,
    		    			jsonData:submitJsonArr,
    		    			success : function(response, action) {
    		    				Ext.getBody().unmask();
    		    				var data = response.responseText;
    		    				var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    		    				var getTab=getcontroller.getTab(tabName);
    		    				if(getTab!=null){
    		    					contentPanel.remove(getTab, true);
    		    				}

    		    				/* Start code for open Apply To tab again with updated records */
    		    				var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    		    				var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    		    				if(getTabApplyTo!=null){
    		    					contentPanel.remove(getTabApplyTo, true);
    		    				}
    		    				var committeeApplyToGridStore = applyToGrid.getStore();
    		    				if(!isNullOrEmpty(committeeMappingId)){
    		    					committeeApplyToGridStore.getProxy().extraParams={
    		    						committeeId: committeeMappingId
    		    					};
    		    				}
    		    				$this.resetGridSetting(applyToGrid);
    				        	$this.resetPageSetting(committeeApplyToGridStore);
    		    				committeeApplyToGridStore.load();
    		    				
    		    				
    		    				var structure = Ext.widget('committeapplytotabstructure');
    		    				
    		    				openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
    		    				/* End code for open Apply To tab again with updated records */
    		    				showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
    		    			}
    		    		});
    				}
    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    changeAllCommitteeRadioGroup : function(radio,newValue, oldValue){
    	var $this = this;
    	var committeeFilterForm = radio.up('form');
    	var radioValue = radio.getValue().manageCommittee;
    	var userTypeFld = committeeFilterForm.down('#userType');
    	var assignedUserFld = committeeFilterForm.down('#assignedUser');
    	var committeeItemFld = committeeFilterForm.down('#committeeItemId');
    	var committeeAlumniFld = committeeFilterForm.down('#committeeItemIdAlumni');
    	var grid = $this.getCommitteegrid();
    	var userId= $this.getCurrentlyLoggedInUser().id;
    	
    	var gridAl;

        // Reset fields that are common across all conditions
        committeeFilterForm.down('#committeeItemId').reset();
        committeeFilterForm.down('#academyLocationCombo').reset();
        committeeFilterForm.down("#academyLocationCombo").setRawValue(null);
        committeeFilterForm.down('#statusItemId').reset();
        committeeAlumniFld.reset();
    	
    	if(radioValue=='ALL_COMMITTEE'){
    	    
    	    $this.isAlumni = false;
    		
    		committeeItemFld.show();
    		committeeAlumniFld.hide();
    		
    		// Show CommitteeGrid and hide AlumniCommitteeGrid
            grid = $this.getCommitteegrid();
            gridAl = $this.getAlumnicommitteegrid();
            grid.show();
            gridAl.hide();
    	
    		userTypeFld.reset();
    		assignedUserFld.reset();
    		userTypeFld.setVisible(true);
    		assignedUserFld.setVisible(true);
    		userTypeFld.setDisabled(false);
    		var store = $this.getStore('user.UserAcademyLocationStore');
			var alids=[];
			
			store.getProxy().extraparams={
				id:userId
			}
			store.load({
				callback:function(record) {
					for (var i in record) {
						alids.push(record[i].data.id);
					}
					committeeItemFld.getStore().getProxy().setExtraParam('academyLocationIds', alids.join());
					committeeItemFld.getStore().getProxy().setExtraParam('participantId', null);
		    		committeeItemFld.lastQuery=null;
		    		$this.loadCommitteeGrid();
				}
			});
    	}
    	else if(radioValue=='MY_COMMITTEE'){
    	   
    	   $this.isAlumni = false;
    		
    		committeeItemFld.show();
    		committeeAlumniFld.hide();
    		
    		// Show CommitteeGrid and hide AlumniCommitteeGrid
            grid = $this.getCommitteegrid();
            gridAl = $this.getAlumnicommitteegrid();
            grid.show();
            gridAl.hide();
    	
    		userTypeFld.reset();
    		userTypeFld.setVisible(true);
    		userTypeFld.setDisabled(true);
    		assignedUserFld.setVisible(true);
    		assignedUserFld.reset();
    		assignedUserFld.setDisabled(true);
    		
    		Ext.Ajax.request({
    			method : "GET",
    			type : 'rest',
    			url : SERVERURL.PATH_FIND_USER_TYPE_ID_BY_USER_ID,
    			headers : {
    				'Content-Type' : 'application/json'
    			},
    			params : {
    				userId : userId
    			},
    			success : function(form,action) {
    				var data = Ext.JSON.decode(form.responseText);

    				userTypeFld.getStore().load({
    					callback:function(record) {
    						userTypeFld.setValue(data);
    					}
    				});
    				var selectedAl = committeeFilterForm.down('#academyLocationCombo').getValue();
    				var assignedUserStore = assignedUserFld.getStore();
    				var store = $this.getStore('user.UserAcademyLocationStore');
    				var alids=[];
    				store.getProxy().extraparams={
    					id:userId
    				}
    				store.load({
    					callback:function(record) {
    						for (var i in record) {
    							alids.push(record[i].data.id);
    						}
    						assignedUserStore.getProxy().extraParams = {
    							userType:data,
    							academyLocationIds:selectedAl!=null?selectedAl :alids.join()
    						};
    						assignedUserStore.load({
    							callback:function(record) {
    								assignedUserFld.setValue(userId);
    								$this.loadCommitteeGrid();
    							}
    						});
    						committeeItemFld.getStore().getProxy().setExtraParam('academyLocationIds', alids.join());
    						committeeItemFld.getStore().getProxy().setExtraParam('participantId', userId);
    			    		committeeItemFld.lastQuery=null;
    					}
    				});
    			}
    		});
    	}else if(radioValue=='ALUMNI_COMMITTEE') { // Alumni Committee
    		$this.isAlumni = true;
    		
    		committeeItemFld.hide();
    		committeeAlumniFld.show();
    		
    		grid = $this.getCommitteegrid();
            gridAl = $this.getAlumnicommitteegrid();
            grid.hide();
            gridAl.show();
            
    		userTypeFld.reset();
    		userTypeFld.setVisible(false);
    		assignedUserFld.reset();
    		assignedUserFld.setDisabled(true);
    		assignedUserFld.setVisible(false);
    		
//    		Ext.Ajax.request({
//    			method : "GET",
//    			type : 'rest',
//    			url : SERVERURL.PATH_FIND_USER_TYPE_ID_BY_USER_ID,
//    			headers : {
//    				'Content-Type' : 'application/json'
//    			},
//    			params : {
//    				userId : userId
//    			},
//    			success : function(form,action) {
//    				var data = Ext.JSON.decode(form.responseText);
//
//    				userTypeFld.getStore().load({
//    					callback:function(record) {
//    						userTypeFld.setValue(data);
//    					}
//    				});
//    				var selectedAl = committeeFilterForm.down('#academyLocationCombo').getValue();
//    				var assignedUserStore = assignedUserFld.getStore();
//    				var store = $this.getStore('user.UserAcademyLocationStore');
//    				var alids=[];
//    				store.getProxy().extraparams={
//    					id:userId
//    				}
//    				store.load({
//    					callback:function(record) {
//    						for (var i in record) {
//    							alids.push(record[i].data.id);
//    						}
//    						assignedUserStore.getProxy().extraParams = {
//    							userType:data,
//    							academyLocationIds:selectedAl!=null?selectedAl :alids.join()
//    						};
//    						assignedUserStore.load({
//    							callback:function(record) {
//    								assignedUserFld.setValue(userId);
//    								$this.loadCommitteeGrid();
//    							}
//    						});
//    						committeeItemFld.getStore().getProxy().setExtraParam('academyLocationIds', alids.join());
//    						committeeItemFld.getStore().getProxy().setExtraParam('participantId', userId);
//    			    		committeeItemFld.lastQuery=null;
//    					}
//    				});
//    			}
//    		});
    	
    	}
    	committeeFilterForm.down('#committeeItemId').reset();
    	committeeFilterForm.down('#academyLocationCombo').reset();
    	committeeFilterForm.down("#academyLocationCombo").setRawValue(null);
    	committeeFilterForm.down('#statusItemId').reset();
  
    },
    /*****START:Applied Permisssion Management for ComitteeTAB Loader*******/ 
    disableCommitteeTabImportTab : function(committeetabstructure,permissionsMap){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var importCommitteeTabUpdatesTab=false;
    	var bulkCommitteeParticipantTab = false;
    	var bulkUploadMembershipTab = false;
    	Ext.each(permissionList, function(privilege) {
    		if(privilege === 'BULK_COMMITTEE_CREATION'){
    			importCommitteeTabUpdatesTab = true;
    		}
    		if(privilege === 'BULK_COMMITTEE_PARTICIPANT'){
    			bulkCommitteeParticipantTab = true;
    		}
    		if(privilege === 'BULK_MEMBERSHIP_CREATION'){
    			bulkUploadMembershipTab = true;
    		}
    	}
    	);
    	this.showCommitteeTabImportTab(committeetabstructure,importCommitteeTabUpdatesTab,bulkCommitteeParticipantTab,bulkUploadMembershipTab);
    },
    showCommitteeTabImportTab : function(committeetabstructure,importCommitteeTabUpdatesTab,bulkCommitteeParticipantTab,bulkUploadMembershipTab){
    	var panelItem = new Array();
    	var $this = this;
    	var newcont = committeetabstructure.items.items.length;
    	var insertPosition = newcont;
    	panelItem.push({
    	    			xtype:'tabpanel',
    	    			itemId:'allVisibleTP',
    	    			plain: true,
    	    			style:{overflow:'hidden !important',margin:'0!important'},
    	    			
    	    			frame: false,
    	    			border:false,
    	    			defaults: {
    	    				labelAlign: 'top'
    	    			},
    	    			items:[{
    	    				xtype:'panel',
    	    				height:'auto',
    	    				title: getCommonTranslation("SEARCH"),
    	    				items:[{
    	    					xtype : 'committeefilter'
    	    				},{
    	    					xtype : 'committeegrid'
    	    				},{
    	    					xtype: 'alumnicommitteegrid'
    	    				}]
    	    			}]
    	    		});
    				var insertAt = panelItem["0"].items.length;
    				if(importCommitteeTabUpdatesTab){
    					panelItem["0"].items[insertAt] = {
    							xtype : 'committeeupdateuploaddownloadstructure',
    							itemId:'committeeupdateuploaddownloadstructure',
    							title: getCommonTranslation('BULK_COMMITTEE_CREATION'),
    							tabCls: 'right-tab'	
    					};
    				}
    				var insertAt = panelItem["0"].items.length;
    				if(bulkCommitteeParticipantTab){
    					panelItem["0"].items[insertAt] = {
    							xtype : 'bulkCommitteeParticipantUploadStructure',
    							itemId:'bulkCommitteeParticipantUploadStructure',
    							title: getCommonTranslation('BULK_COMMITTEE_PARTICIPANT'),
    							tabCls: 'right-tab'	
    					};
    				}
    				// Bulk Membership Loader
    				var insertAt = panelItem["0"].items.length;
    				if(bulkUploadMembershipTab) {
    					panelItem["0"].items[insertAt] = {
    							xtype : 'membershipbulkuploaddownloadstructure',
    							itemId:'membershipbulkuploaddownloadstructure',
    							title: getCommonTranslation('BULK_MEMBERSHIP_CREATION'),
    							tabCls: 'right-tab'	
    					};
    				}
    				
    								
    		committeetabstructure.insert(insertPosition,panelItem);
    },
    committeDownloadUploadFormChange : function(cb, nv, ov){
   		var $this = this;
   		var downloadTemplateForm = this.getCommitteeupdatedownloadform();
   		var uploadTemplateForm = this.getCommitteeupdateuploadform();
   		var grid = this.getCommitteecoveredupdategrid();
   		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
   			uploadTemplateForm.hide();
   			downloadTemplateForm.show();
   			grid.setVisible(false);
   		}else{
   			downloadTemplateForm.hide();
   			uploadTemplateForm.show();
   			grid.setVisible(true);
   		}
   	},
	getMapCommitteeDownloadFile : function(documentId,fileType){
    	if(!isNullOrEmpty(documentId)){
    		var csvForm = Ext.create('Ext.form.Panel'); 
    		csvForm.getForm().submit({
    			target: '_blank',
    			method:'POST',
    			params :{
    				access_token : Ext.Ajax.defaultHeaders.access_token
    			},
    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
    			standardSubmit :true
    		});
    }
    },
    openAddMembershipWindow:function(btn){
    	var me = this,
    	committeeform = me.getCommitteeform(),
    	fromDate = committeeform.down('#fromDateItemId'),
    	toDate = committeeform.down('#toDateItemId');
    	var formWindow = me.getAddCommitteeMembershipWindow();
		if (!formWindow) {
			Ext.widget('addCommitteeMembershipWindow');
			formWindow = me.getAddCommitteeMembershipWindow();
		}
		var membershipStartDate =formWindow.down('#membershipStartDate'),
		membershipEndDate =formWindow.down('#membershipEndDate'),
		applicationStartDate =formWindow.down('#applicationStartDate'),
		applicationEndDate =formWindow.down('#applicationEndDate');
		membershipStartDate.setMinValue(new Date(fromDate.getValue()));
		membershipStartDate.setMaxValue(new Date(toDate.getValue()));
		membershipEndDate.setMinValue(new Date(fromDate.getValue()));
		membershipEndDate.setMaxValue(new Date(toDate.getValue()));
		applicationStartDate.setMinValue(new Date(fromDate.getValue()));
		applicationEndDate.setMinValue(new Date(fromDate.getValue()));
		formWindow.show();
    },
    onChangeApprove:function(cmp,val){
    	var addMemberView= this.getAddCommitteeMembershipWindow();
    	var saveMemebershipBtn = addMemberView.down('#saveMemebershipBtn');
    	val.whetherAutoApprove && addMemberView.down('#approverId').reset();
    	addMemberView.down('#approverId').setDisabled(val.whetherAutoApprove);    	
    	if(!val.whetherAutoApprove){
    		saveMemebershipBtn.setDisabled(true);
    	}else{
    		saveMemebershipBtn.setDisabled(false);
    	}
    	
    },
    addMembershiponCommittee:function(btn){
    	var me = this,
    	addMemberView= me.getAddCommitteeMembershipWindow(),
    	membersshipGrid = me.getCommitteeMembershipGrid(),
    	formView = addMemberView.down('form').getForm(),
    	formVal = formView.getValues(),
    	committeeForm = me.getCommitteeform(),
        idItemId = committeeForm.down("#idItemId");
    	
    	param={
    	    "committee" :{
    	        "id":idItemId.getValue()
    	    },
    	    "membershipType":{
    	        "id": formVal.membershipType
    	    },
    	    "memberShipStartDate": formVal.memberShipStartDate,
    	    "memberShipEndDate" : formVal.memberShipEndDate,
    	    "applicationStartDate" : formVal.applicationStartDate,
    	    "applicationEndDate" : formVal.applicationEndDate,
    	    "isOnlineApplication" :formVal.whetherOnlineApplicationRequired,
    	    "isFeeApplicable" : formVal.whetherFeesApplicable,
    	    "isAutoApprove" : formVal.whetherAutoApprove,
    	    "additionalMembership" :formVal.additionalMembership,
    	    "feePlan": {
    	        "id": formVal.feePlan
    	    },
    	    "feePlanRule" : {
    	        "id": formVal.feeRule
    	    },
    	    "user": {
    	        "id": formVal.approverId
    	    }
    	}
    	var serviceUrl=SERVERURL.PATH_CREATE_MEMBERSHIP_DEFINATION;
    	if(formVal.id){
    		serviceUrl=SERVERURL.PATH_UPDATE_MEMBERSHIP_DATA;
    		param.id=parseInt(formVal.id);
    	}
    	Ext.Ajax.request({
            type: 'rest',
            url: serviceUrl,
            method: 'POST',
            jsonData : Ext.encode(param),
            success: function(response, action) {
                addMemberView.close();
                if(formVal.id){
                	if(response.responseText == -1){
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MEMBERSHIPTYPE_ALREADY_MAPPED'));
                	}else if(response.responseText == -2){
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FEEPLAN_ALREADY_MAPPED'));
                	}else{
                		showSuccessMessage(getCommonTranslation('MEMBERSHIPS'), getCommonTranslation('UPDATE_MEMBERSHIP_SUCCESS_MESSAGES'));
                	}
                }else{
                	if(response.responseText == -1){
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MEMBERSHIPTYPE_ALREADY_MAPPED'));
                	}else if(response.responseText == -2){
                		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FEEPLAN_ALREADY_MAPPED'));
                	}else{
                		showSuccessMessage(getCommonTranslation('MEMBERSHIPS'), getCommonTranslation('ADD_MEMBERSHIP_SUCCESS_MESSAGES'));
                	}
                }
                membersshipGrid.getSelectionModel().deselectAll();
                membersshipGrid.getStore().load();
            }
        });
    	
    },
    onDeleteMembership:function(btn){
    	var me = this,
    	membersshipGrid = me.getCommitteeMembershipGrid(),
    	rec = membersshipGrid.getSelectionModel().getSelection();
    	showConfirmMessage(getCommonTranslation('MEMBERSHIPS'),getCommonTranslation('DELETE_MEMBERSHIP_MESSAGES'),function(btn,text){
			if (btn == 'yes') {
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				Ext.Ajax.request({
					method : "DELETE",
					type : 'rest',
					url : SERVERURL.PATH_DELETE_MEMBERSHIP_DATA+ '?id='+ rec[0].get('id'),
					headers : {
						'Content-Type' : 'application/json'
					},
					params : {
						id : rec[0].get('id')
					},
					success : function(form,action) {
						Ext.getBody().unmask();
						membersshipGrid.getSelectionModel().deselectAll();
						membersshipGrid.getStore().load();
						showSuccessMessage(getCommonTranslation('MEMBERSHIPS'), getCommonTranslation('DELETE_MEMBERSHIP_SUCCESS_MESSAGES'));
					}
				});
			}
		});
    },
    onEditMembership:function(btn){
    	var me = this,recData,
    	membersshipGrid = me.getCommitteeMembershipGrid(),
    	rec = membersshipGrid.getSelectionModel().getSelection(),
    	formWindow = me.getAddCommitteeMembershipWindow();
		if (!formWindow) {
			Ext.widget('addCommitteeMembershipWindow');
			formWindow = me.getAddCommitteeMembershipWindow();
		}
		var membershipForm =formWindow.down('form').getForm(),
		membershipType= membershipForm.findField('membershipType'),
		feePlan= membershipForm.findField('feePlan'),
		feeRule= membershipForm.findField('feeRule'),
		approverId= membershipForm.findField('approverId');
		formWindow.setTitle(getCommonTranslation('UPDATE_MEMBERSHIP'));
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_FINDBYID_MEMBERSHIP_DATA,
            method: 'GET',
            params:{
            	id:rec[0].get('id'),
            },
            success: function(response, action) {
            	Ext.getBody().unmask();
            	if(response.responseText){
            		
	            		recData = Ext.decode(response.responseText);
		            	formWindow.show();
		            	formWindow = me.getAddCommitteeMembershipWindow();
		            	var saveMemebershipBtn = formWindow.down('#saveMemebershipBtn');
		            	membershipForm.setValues(recData);
		            	membershipType.getStore().load(function(){
		            		membershipType.setValue(recData.membershipType);
		            	});
		            	feePlan.getStore().load(function(){
		            		feePlan.setValue(recData.feePlan);
		            		feeRule.getStore().getProxy().extraParams={
		            			feePlanId:recData.feePlan
							};
		            		feeRule.getStore().load(function(){
		            			feeRule.setValue(recData.feePlanRule);
		                	});
		            	});
		            	approverId.getStore().getProxy().extraParams={
							id:recData.user
						};
		            	approverId.getStore().load(function(){
		            		approverId.setValue(recData.user);
	            	});
		            	Ext.defer(function(){
		            		var autoApprove = membershipForm.findField('autoApprove'),
		            		feesApplicable = membershipForm.findField('feesApplicable'),
		            		onlineApplicationRequired = membershipForm.findField('onlineApplicationRequired');
		            		additionalMembership = membershipForm.findField('additionalMembership');
		            		if(recData.isOnlineApplication){
		            			onlineApplicationRequired.items.items[0].setValue(true);
		            		}else{
		            			onlineApplicationRequired.items.items[1].setValue(true);
		            		}
		            		if(recData.isFeeApplicable){
		            			feesApplicable.items.items[0].setValue(true);
		            		}else{
		            			feesApplicable.items.items[1].setValue(true);
		            		}
		            		if(recData.isAutoApprove){
		            			autoApprove.items.items[0].setValue(true);
		            		}else{
		            			autoApprove.items.items[1].setValue(true);
		            		}
		            		if(recData.additionalMembership){
		            			additionalMembership.setRawValue(true);
		            		}else{
		            			additionalMembership.setRawValue(false);
		            		}
		            		if(formWindow.down('form').getForm().isValid()){
		            			saveMemebershipBtn.setDisabled(false);
		            		}else{
		            			saveMemebershipBtn.setDisabled(true);
		            		}
		            	},1000);
		            	if(btn.itemId == 'btnView'){
		            		formWindow.setTitle(getCommonTranslation('MEMBERSHIP_DETAILS'));
		            		formWindow.down('#saveMemebershipBtn').setVisible(false);
		            		me.toggleReadOnlyFormItems(membershipForm,true);
		            	}
		            
            	}
            }
        });
    },

    onChangeOnlineApplicationRequired:function(cmp){
    	var addMemberView= this.getAddCommitteeMembershipWindow();
    	var onlineApplicationRequired = addMemberView.down('#onlineApplicationRequired');
    	var membershipStartDate = addMemberView.down('#membershipStartDate');
    	var membershipEndDate = addMemberView.down('#membershipEndDate');
    	var saveMemebershipBtn = addMemberView.down('#saveMemebershipBtn');
    	var applicationStartDate=addMemberView.down('#applicationStartDate');
    	var applicationEndDate=addMemberView.down('#applicationEndDate')
    	if(membershipStartDate.getValue() && membershipEndDate.getValue() && onlineApplicationRequired.getValue().whetherOnlineApplicationRequired==true){
    		applicationStartDate.setDisabled(false);
    		applicationEndDate.setDisabled(false);
    	}else{
    		addMemberView.down('#applicationStartDate').setDisabled(true);
    		addMemberView.down('#applicationEndDate').setDisabled(true);
    		addMemberView.down('#applicationStartDate').reset();
    		addMemberView.down('#applicationEndDate').reset();
    		saveMemebershipBtn.setDisabled(false);
    	}
    	if(addMemberView.down('form').getForm().isValid()){
			saveMemebershipBtn.setDisabled(false);
		}else{
			saveMemebershipBtn.setDisabled(true);
		}
    },
    onChangeIsFeeApplicable:function(cmp,val){
    	var addMemberView= this.getAddCommitteeMembershipWindow();
    	var feePlan=addMemberView.down('#feePlan');
    	var feeRule=addMemberView.down('#feeRule');
    	var saveMemebershipBtn = addMemberView.down('#saveMemebershipBtn');
    	if(!val.whetherFeesApplicable){
    		addMemberView.down('#feePlan').setDisabled(true); 
    		addMemberView.down('#feeRule').setDisabled(true); 
    		addMemberView.down('#feePlan').reset();
    		addMemberView.down('#feeRule').reset();
    	}else{
    		addMemberView.down('#feePlan').setDisabled(false);
    	}
    	if(addMemberView.down('form').getForm().isValid()){
			saveMemebershipBtn.setDisabled(false);
		}else{
			saveMemebershipBtn.setDisabled(true);
		}
    },
    programGroupNextEventCommittee:function(btn){
    	var me = this,committeeaddmappingstructure,committeapplytotabstructure,committeemappingtabstructure,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection()
    	 alprogramgridIdsArr = [],
    	 programIdsArr = [];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('secondId'));
    		programIdsArr.push(obj.get('longValue'));
    	});
    	
    	if(selectionModel.length > 0){
    		 committeeaddmappingstructure = me.getCommitteeaddmappingstructure();
	    	 committeapplytotabstructure = me.getCommitteapplytotabstructure();
	    	 committeemappingtabstructure = me.getCommitteeaddmappingtab();
	    	 programcontainer = committeeaddmappingstructure.down('#programcontainer2');
	    	programcontainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(programcontainer);
	    	
	    	var alprogramgrid = me.getCommitteeAddMappingProgramViewGrid();
	    	
	    	var alprogramgridCombo = alprogramgrid.down('#programsearchcombo');
	  	alprogramgridCombo.getStore().getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		//programGroupId:programIdsArr.join()
	    	};
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	alprogramgridStore.getProxy().extraParams= {
	    		academyLocationIds: alprogramgridIdsArr.join(),
	    		programGroupId:programIdsArr.join()
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				
				committeeaddmappingstructure.down("#lblCommitteeProgramView").setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingName').setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
	    	this.setProgressTracker(2,committeemappingtabstructure);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    
    },
    programNextEventCommittee:function(btn){
    	var me = this,committeeaddmappingstructure,committeapplytotabstructure,committeemappingtabstructure,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'))
    	});
    	
    	if(selectionModel.length > 0){
    		 committeeaddmappingstructure = me.getCommitteeaddmappingstructure();
	    	 committeapplytotabstructure = me.getCommitteapplytotabstructure();
	    	 committeemappingtabstructure = me.getCommitteeaddmappingtab();
	    	 programcontainer = committeeaddmappingstructure.down('#programbatchcontainer');
	    	programcontainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(programcontainer);
	    	
	    	var alprogramgrid = me.getCommitteeAddMappingBatchGrid();
	    	
	    	var alprogramgridCombo = alprogramgrid.down('#programbatchsearchcombo');
	    	alprogramgridCombo.getStore().getProxy().extraParams= {
		    		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join()
	    		};
	    	
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION, update: SERVERURL.FIND_PROGRAM_BATCH_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);
			proxy.extraParams= {
					academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				
				committeeaddmappingstructure.down("#committeProgramBatchTab").setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingName').setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
	    	this.setProgressTracker(3,committeemappingtabstructure);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    batchNextEventCommittee:function(btn){
    	var me = this,committeeaddmappingstructure,committeapplytotabstructure,committeemappingtabstructure,programcontainer,
    	alprogramgrid =btn.up('grid'),
    	 selectionModel = alprogramgrid.getSelectionModel().getSelection(),
    	 alprogramgridIdsArr = [],
    	 programId=[],
    	 batchId=[];
    	selectionModel.forEach(function(obj){
    		alprogramgridIdsArr.push(obj.get('academyLocationId'));
    		programId.push(obj.get('programId'));
    		batchId.push(obj.get('batchId'));
    	});
    	
    	if(selectionModel.length > 0){
    		 committeeaddmappingstructure = me.getCommitteeaddmappingstructure();
	    	 committeapplytotabstructure = me.getCommitteapplytotabstructure();
	    	 committeemappingtabstructure = me.getCommitteeaddmappingtab();
	    	 programcontainer = committeeaddmappingstructure.down('#programbatchseattypecontainer');
	    	programcontainer.setDisabled(false);
	    	committeeaddmappingstructure.setActiveTab(programcontainer);
	    	
	    	var alprogramgrid = me.getCommitteeAddMappingBatchSeatTypeGrid();
	    	var alprogramgridCombo = alprogramgrid.down('#batchSeatType');
		  	alprogramgridCombo.getStore().getProxy().extraParams= {
			  		academyLocationIds: alprogramgridIdsArr.join(),
		    		programIds:programId.join(),
		    		batchIds:batchId.join()
		    	};
	    	var alprogramgridStore = alprogramgrid.getStore();
	    	var  proxy = alprogramgridStore.getProxy();
			var  newApi =  {read: SERVERURL.FIND_BY_PROGRAM_BATCH_SEAT_TYPE_AND_ACADEMY_LOCATION, update: SERVERURL.FIND_BY_PROGRAM_BATCH_SEAT_TYPE_AND_ACADEMY_LOCATION };
			Ext.apply(proxy.api,newApi);
			proxy.extraParams= {
				academyLocationIds: alprogramgridIdsArr.join(),
	    		programIds:programId.join(),
	    		batchIds:batchId.join()
	    	};
			alprogramgridStore.clearFilter();
			alprogramgridStore.load();
			var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
			if(!isNullOrEmpty(recordsCommitteeGrid)){
				
				committeeaddmappingstructure.down("#committeeProgramBatchSeattypeTab").setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingName').setValue(recordsCommitteeGrid.get('committeeName'));
				committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
			}
	    	this.setProgressTracker(4,committeemappingtabstructure);
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitCommitteMapping:function(btn, type){
    		  var $this = this,params=[],
    		  submitUrl =SERVERURL.PATH_SAVE_COMMITTEE_BATCH_TYPE,
    	       batchGrid = $this.getCommitteeAddMappingBatchGrid(),
    	       seatTypeGrid = $this.getCommitteeAddMappingBatchSeatTypeGrid(),
    	       selectedRecord = batchGrid.getSelectionModel().getSelection(),
    	  	   committeemappingtabstructure = $this.getCommitteeaddmappingtab(),
    	  	   committeapplytotabstructure = $this.getCommitteapplytotabstructure(),
    	  	   contentPanel = $this.getContentPanel(),
    	       tabStructure = $this.getCommitteeaddmappingstructure(),
    	       getcontroller = $this.getController('menu.CoreERPNavigationController'),
    	       applyToGrid = $this.getCommitteapplytogrid(),
    	    committeeMappingId = committeemappingtabstructure.down('#committeeMappingId').getValue();
    		  if(type == "seatType"){
    			  selectedRecord = seatTypeGrid.getSelectionModel().getSelection();
    			  submitUrl = SERVERURL.PATH_SAVE_COMMITTEE_SEAT_TYPE
    		  }
    		  if(committeeMappingId){
    			  committeeMappingId = parseInt(committeeMappingId);
    		  }
    		  if(selectedRecord.length>0){
    			  if(type == "seatType"){
    				  selectedRecord.forEach(function(rec){
        				  params.push({
        					  programBatchSeatConfiguration:{
        			              id:rec.get('programBatchSeatTypeId')
        			          },
        			          "batch":{
        			              id:rec.get('batchId')
        			          },
        			          "committee":{
        			              id:committeeMappingId
        			          },
        			          "academyLocation" : {
        			              "id":rec.get('academyLocationId')
        			          },
        			          "programGroup" : {
        			              "id":rec.get('programGroupId')
        			          },
        			          "program" : {
        			              "id":rec.get('programId')
        			          }
        			      })
        			  })
    			  }else{
    				  selectedRecord.forEach(function(rec){
        				  params.push({
	        					  "batch":{
	        			              id:rec.get('batchId')
	        			          },
	        			          "committee":{
	        			              id:committeeMappingId
	        			          },
	        			          "academyLocation" : {
	        			              "id":rec.get('academyLocationId')
	        			          },
	        			          "programGroup" : {
	        			              "id":rec.get('programGroupId')
	        			          },
	        			          "program" : {
	        			              "id":rec.get('programId')
	        			          }
        			      });
        			  });
    			  }
    			 
    	    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	    		Ext.Ajax.request({
    	    			method: "POST",
    	    			type: 'rest',
    	    			url: submitUrl,
    	    			jsonData:Ext.encode(params),
    	    			success : function(response, action) {
    	    				if(response.responseText == "SUCCESS"){
    	    					Ext.getBody().unmask();
    	    					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    		    				var getTab=getcontroller.getTab(tabName);
    		    				if(getTab!=null){
    		    					contentPanel.remove(getTab, true);
    		    				}

    		    				var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    		    				var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    		    				if(getTabApplyTo!=null){
    		    					contentPanel.remove(getTabApplyTo, true);
    		    				}
    		    				var committeeApplyToGridStore = applyToGrid.getStore();
    		    				if(!isNullOrEmpty(committeeMappingId)){
    		    					committeeApplyToGridStore.getProxy().extraParams={
    		    						committeeId: committeeMappingId
    		    					};
    		    				}
    		    				$this.resetGridSetting(applyToGrid);
    				        	$this.resetPageSetting(committeeApplyToGridStore);
    		    				committeeApplyToGridStore.load();
    		    				
    		    				
    		    				var structure = Ext.widget('committeapplytotabstructure');
    		    				
    		    				openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
    	    					showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
    	    				}else{
    	    					Ext.getBody().unmask();
    	    					var alertWin = $this.getCommitteemappingalertwin();
    	          				if(!alertWin){
    	          					alertWin = Ext.widget('committeemappingalertwin');
    	          				}
    	          				alertWin.down('#committeeAlert').setValue(getCommonTranslation('COMMITTEE_ALREDAY_MAPPED_AL_PROGRAM_GROUP_MSG'));
    	          				var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    	          				var htmlData = '';
    	          						htmlData = htmlData + '<div style="padding-bottom: 3px;">' +response.responseText + '</div>';
    	          					
    	          					pnlListMappingFld.setValue(htmlData);
    	          				
    	          					var btn = alertWin.down('#committeeAlertBtnOk');
    	              				btn.on('click', function() {
    	              					alertWin.close();
    	              				})
    	          				alertWin.show();
    	    				}
    	    				
    	    				
    	    			}
    	    		});
    	    	} else {
    	    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	    	}
    },
    membershipEndDateChange:function(cmp){
    	var me = this,
    	formWindow = me.getAddCommitteeMembershipWindow();
    	membershipStartDate =formWindow.down('#membershipStartDate'),
    	membershipEndDate =formWindow.down('#membershipEndDate'),
		applicationStartDate =formWindow.down('#applicationStartDate'),
		applicationEndDate =formWindow.down('#applicationEndDate');
    	onlineApplicationRequired =formWindow.down('#onlineApplicationRequired');
    	onlineApplicationRequiredRadioGrp=formWindow.down('#onlineApplicationRequired');
    	if(onlineApplicationRequiredRadioGrp.getValue().whetherOnlineApplicationRequired && 
    			membershipStartDate.getValue() && membershipEndDate.getValue() && onlineApplicationRequired.getValue()==true){
    		applicationStartDate.setDisabled(false);
    		applicationEndDate.setDisabled(false);
    	}
    	onlineApplicationRequired.reset();
    	membershipEndDate.getValue() && applicationStartDate.setMaxValue(new Date(membershipEndDate.getValue()));
    	membershipEndDate.getValue() && applicationEndDate.setMaxValue(new Date(membershipEndDate.getValue()));
    },
    membershipStartDateChange:function(cmp){
    	var me = this,
    	formWindow = me.getAddCommitteeMembershipWindow();
    	membershipStartDate =formWindow.down('#membershipStartDate'),
    	membershipEndDate =formWindow.down('#membershipEndDate'),
		applicationStartDate =formWindow.down('#applicationStartDate'),
		applicationEndDate =formWindow.down('#applicationEndDate');
    	onlineApplicationRequiredRadioGrp=formWindow.down('#onlineApplicationRequired');
    	membershipEndDate.getValue() && applicationStartDate.setMaxValue(new Date(membershipEndDate.getValue()));
    	membershipEndDate.getValue() && applicationEndDate.setMaxValue(new Date(membershipEndDate.getValue()));
		if(onlineApplicationRequiredRadioGrp.getValue().whetherOnlineApplicationRequired &&
				membershipStartDate.getValue() && membershipEndDate.getValue()){
    		applicationStartDate.setDisabled(false);
    		applicationEndDate.setDisabled(false);
    	}
    },
    editCommitteeParticipant:function(grid){
    	var $this = this;
    	var gridRecords = grid.getSelectionModel().getSelection()[0];
		var window = this.getCommitteealwindow();
		window.setTitle(getCommonTranslation('EDIT_COMMITTEE_PARTICIPANT_DETAIL'));
		var assignedUser = window.down('#assignedUser');
		var assignedUserForEditCase = window.down('#assignedUserForEditCase');
		var userCombo = window.down('#userType');
		var structure = this.getAddcommitteeparticipant();
		var committeeId = structure.down('#committeeItemId').getValue();
		var saveBtn = window.down('#submitCommitteeParticipantBtn');
		var assignedUserIdForEdit = window.down('#assignedUserIdForEdit');
		
		window.down('#id').setValue(gridRecords.data.id);
		window.down('#designationNameItemId').setValue(gridRecords.data.designation);
		window.down('#responsabilityItemId').setValue(gridRecords.data.responsibility);
		window.down('#fromDateItemId').setValue(dateRender(gridRecords.data.fromDate));
		window.down('#toDateItemId').setValue(dateRender(gridRecords.data.toDate));
        if(!isNullOrEmpty(gridRecords.data.membershipType)){
        	window.down('#membershipTypeUser').setValue(gridRecords.data.membershipType.id);
        }

        window.down('#additionalMembershipType').getStore().load();
        if(!isNullOrEmpty(gridRecords.data.additionalMembershipTypeList) && gridRecords.data.additionalMembershipTypeList.length>0){
                	window.down('#btnAdditionalMemebership').setDisabled(false);
                	
                	for (var i = 0; i < gridRecords.data.additionalMembershipTypeList.length; i++) {
                		
                		var membershipContainerPanel = window.down('#membershipContainerPanelId');
        				var formContainer = membershipContainerPanel.getComponent(i);
        				formContainer.down('#additionalMembershipType').setValue(gridRecords.data.additionalMembershipTypeList[i].id);
        				if(!isNullOrEmpty(gridRecords.data.additionalMembershipTypeList[i])) {
        					formContainer.down('#additionalMembershipType').setValue(gridRecords.data.additionalMembershipTypeList[i].id);
        				}
        				if (i < (gridRecords.data.additionalMembershipTypeList.length - 1)) {
        					this.addMultipleAdditionalMembership(window);
        				}
                	}
         }else{
              window.down('#btnAdditionalMemebership').setDisabled(true);
         }
		
		if(gridRecords.data.membershipStatus){
			window.down('#fromDateItemId').setReadOnly(true);
			window.down('#toDateItemId').setReadOnly(true);
			window.down('#membershipTypeUser').setReadOnly(true);
		}
		if(gridRecords.data.membershipType !=null){
			window.down('#fromDateItemId').setReadOnly(true);
			window.down('#toDateItemId').setReadOnly(true);
		}
		
		assignedUser.setVisible(false);
		assignedUserForEditCase.setVisible(true);
		assignedUserForEditCase.allowBlank = true;
		var allowblankFalse = '<span class="required" style="color:red"> *</span>';
		assignedUserForEditCase.setFieldLabel(getFileManagementTranslation('USER')+allowblankFalse);
		
		userCombo.getStore().load({
			callback: function(record, opt, success){
				if (success) { 
					var data = userCombo.findRecord("userGroupName",gridRecords.data.userType);
					userCombo.setValue(data.data.id);  
					setTimeout(function() {
						saveBtn.setDisabled(false);
					},1000);
					userCombo.setReadOnly(true);
					if(data){
						userCombo.fireEvent('select',userCombo,[data]);
					}
				}
			}    
		});
		assignedUserForEditCase.setValue(gridRecords.data.participant.value);
		assignedUserIdForEdit.setValue(gridRecords.data.participant.id)
		assignedUserForEditCase.setReadOnly(true);
    },
    loadCommitteeRequestGrid:function(){
    	var $this=this;
    	var form = $this.getCommitteerequestfilter().getForm();
    	var formValue = form.getValues();
    	var grid = $this.getCommitteerequestgrid();
		  var user=$this.getCurrentlyLoggedInUser();
		  var isAdmins = null;
		  var approverIds = null;
	 	   if(formValue.allRequestButton == true){
					  isAdmins = true
					  approverIds = user.id
			  }
	 	   else{
					  isAdmins = false
					  approverIds = user.id
		 	   }
    
    	grid.getStore().getProxy().extraParams = {              
    		membershipTypeId: formValue.membershipType,
    		studentId : formValue.STUDENT_ID,
    		startDate: formValue.startDate,
    		endDate:formValue.endDate,
    		isAdmin:isAdmins,
    		approverId:approverIds
    			
 	   };
    	grid.getStore().load();
    	/***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	grid.config.searchFilterForm = $this.getCommitteerequestfilter();
    	/***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    requestChangeFunction:function(cb, nv, ov){
    	var $this = this;
 	   var committeeRequestFilter = $this.getCommitteerequestfilter();
		var membershipType = committeeRequestFilter.down('#membershipType');
		  var user=$this.getCurrentlyLoggedInUser();
 	   if(nv.allRequestButton == true){
 		  this.resetCommitteeRequestForm()
			  membershipType.getStore().getProxy().extraParams={
				  approverId:user.id,
				  isAdmin:true 	   
				  };
 		 membershipType.getStore().load();
		  }
 	   else{
 		  this.resetCommitteeRequestForm()
			  membershipType.getStore().getProxy().extraParams={
				  isAdmin:false,
				  approverId:user.id,
			  };
  		 membershipType.getStore().load();
 	   }

    },
    //Disable other Privileges button 
    disableManageCommitteeRequestOtherPivileges: function(gridReference,permissionsMap) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		var buttonsToolBar = gridReference.query('toolbar')[0];
		buttonsToolBar.setVisible(false);
		var btnApprove=buttonsToolBar.query('#btnApproveGridItemId')[0];
		var btnReject = buttonsToolBar.query('#btnRejectGridItemId')[0];
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'APPROVE') {
				if(!isNullOrEmpty(btnApprove)){
					btnApprove.setVisible(true);
				}        		
			}
			if (privilege === 'REJECT') {
				if(!isNullOrEmpty(btnReject)){
					btnReject.setVisible(true);
				}        		
			}
		});
		buttonsToolBar.setVisible(true);
	},
	resetCommitteeRequestForm: function() {
	    var $this = this;
	    var form = $this.getCommitteerequestfilter();
	    var stdId=form.down('#studentId');
	    var membershipId=form.down('#membershipType');
	    var fromDate =  form.down('#startDate');
 	    var toDate = form.down('#endDate');
 	    membershipId.reset();
 	    stdId.reset();
 	    stdId.setDisabled(true);
 	    fromDate.allowBlank=true;
 	    toDate.allowBlank=true;
 	    fromDate.setMaxValue(false);
 	    fromDate.setMinValue(false);
 	    toDate.setMaxValue(false);
 	    toDate.setMinValue(false);
 	    fromDate.reset();
	    toDate.reset();
 	    form.getForm().isValid();
	},
	approveCommitteeRequest:function(gridItemId, url){
		
        var grid = this.getCommitteerequestgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('APPROVE_REQUEST'), getCommonTranslation('APPROVE_REQUEST_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                        var records = grid.getSelectionModel().getSelection();
                        var status;
                        var ids=[];
        				for(var i in records) {
        					ids.push(records[i].data.id);
        					status = "APPROVED";
        				} 
        				url=url.concat("?requestIds="+ids+"&approvalStatus="+status); 
        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                        Ext.Ajax.request({
                            type: 'rest',
                            url: url,
                            method: 'PUT',
                            headers : {
        						'Content-Type' : 'application/json'
        					},
                            success: function(form, action) {
                            	Ext.getBody().unmask();
                            	grid.getStore().reload();
                            	grid.getSelectionModel().deselectAll(true);
                                showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('APPROVE_REQUEST_SUCCUSS_MESSAGE'));
                            }
                        });
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('APPROVE_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
	},
	rejectCommitteeRequest:function(gridItemId, url){
		
        var grid = this.getCommitteerequestgrid();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCommonTranslation('REJECT_REQUEST'), getCommonTranslation('REJECT_REQUEST_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                        var records = grid.getSelectionModel().getSelection();
                        var status;
                        var ids=[];
        				for(var i in records) {
        					ids.push(records[i].data.id);
        					status = "REJECTED";
        				} 
        				url=url.concat("?requestIds="+ids+"&approvalStatus="+status); 
        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                            Ext.Ajax.request({
                                type: 'rest',
                                url: url,
                                method: 'PUT',
                                headers : {
            						'Content-Type' : 'application/json'
            					},
                                success: function(form, action) {
                                	Ext.getBody().unmask();
                                	grid.getStore().reload();
                                	grid.getSelectionModel().deselectAll(true);
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('REJECT_REQUEST_SUCCUSS_MESSAGE'));
                                }
                            });
                        }
            });
        } else {
            showWarningMessage(getCommonTranslation('REJECT_REQUEST'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
	},
	viewCommitteeRequestForm:function(){
		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		var structure = Ext.widget('studentcommitteerequesttabstructure');
		var tabName = getCommonTranslation('VIEW_COMMITTEE_REQUEST');
		/**
		 * This is to remove tab from content panel and open same tab again
		 */
		var getcontroller=this.getController('menu.CoreERPNavigationController');
		var getTab=getcontroller.getTab(tabName);
		if(getTab!=null){
			contentPanel.remove(getTab, true);
		}
		openTab(contentPanel, tabName, structure, CONSTANTS.MENU_COLOR_NINE);
		Ext.apply(structure,{
			code:null,
			setCode : function(code){
				structure.code = code;
			},
			getCode:function(){
				return structure.code;
			}
		});
		structure.setCode(true);
		this.setCommitteRequesterErpDetails();
	},
	nextEventForAcademicTermCommittee:function(grid){
		var committeeaddmappingstructure = this.getCommitteeaddmappingstructurePBP();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtabforPBP();
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var selectedRecIdsArr = [];
    	selectionModel.forEach(function(obj){
			selectedRecIdsArr.push(obj.get('id'));
		});
    	if(selectedRecIdsArr.length > 0){
    		var programcontainer = committeeaddmappingstructure.down('#programcontainerPBP');
    		programcontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programcontainer);
    		var nextGrid= this.getCommitteeaddmappingatprogramgrid();
    		var nextSearchCombo= nextGrid.down('#programSearchCombo');
    		nextSearchCombo.reset();
    		nextSearchCombo.getStore().getProxy().extraParams= {
    			academicTermIds: selectedRecIdsArr.join()
    		};
    		var nextGridStore = nextGrid.getStore();
    		nextGridStore.getProxy().extraParams= {
    			academicTermIds: selectedRecIdsArr.join()
    		};
    		nextGrid.setLoading();
    		nextGridStore.clearFilter();
    		nextGridStore.load({
    			callback:function(){
    			   nextGrid.setLoading(false);
    			}
    		});
    		this.setProgressTracker(1,committeemappingtabstructure);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){
    			committeeaddmappingstructure.down("#lblCommitteeProgramTab").setValue(recordsCommitteeGrid.get('committeeName'));
    			committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    nextEventForProgramCommittee:function(grid){
		var committeeaddmappingstructure = this.getCommitteeaddmappingstructurePBP();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtabforPBP();
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var selectedRecIdsArr = [];
    	var selectedATRecIdsArr=[];
    	selectionModel.forEach(function(obj){
			selectedRecIdsArr.push(obj.get('programId'));
			selectedATRecIdsArr.push(obj.get('academicTermId'));
		});
    	if(selectedRecIdsArr.length > 0){
    		var programcontainer = committeeaddmappingstructure.down('#programBatchContainerPBP');
    		programcontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programcontainer);
    		var nextGrid= this.getCommitteeaddmappingatprogrambatchgrid();
    		var nextSearchCombo= nextGrid.down('#programBatchSearchCombo');
    		nextSearchCombo.reset();
    		nextSearchCombo.getStore().getProxy().extraParams= {
    			programIds: selectedRecIdsArr.join(),
    			academicTermIds:selectedATRecIdsArr.join()
    		};
    		var nextGridStore = nextGrid.getStore();
    		nextGridStore.getProxy().extraParams= {
    			programIds: selectedRecIdsArr.join(),
    			academicTermIds:selectedATRecIdsArr.join()
    		};
    		nextGrid.setLoading();
    		nextGridStore.clearFilter();
    		nextGridStore.load({
    			callback:function(){
     			   nextGrid.setLoading(false);
     			}
     		});
    		this.setProgressTracker(2,committeemappingtabstructure);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){
    			committeeaddmappingstructure.down("#lblCommitteeProgrambatchTab").setValue(recordsCommitteeGrid.get('committeeName'));
    			committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    nextEventForProgramBatchCommittee:function(grid){
		var committeeaddmappingstructure = this.getCommitteeaddmappingstructurePBP();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtabforPBP();
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var selectedRecIdsArr = [];
    	var selectedATRecIdsArr=[];
    	var selectedProgramRecIdsArr=[];
    	selectionModel.forEach(function(obj){
			selectedRecIdsArr.push(obj.get('batchId'));
			selectedATRecIdsArr.push(obj.get('academicTermId'));
			selectedProgramRecIdsArr.push(obj.get('programId'));
		});
    	if(selectedRecIdsArr.length > 0){
    		var programcontainer = committeeaddmappingstructure.down('#programBatchPeriodContainerPBP');
    		programcontainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(programcontainer);
    		var nextGrid= this.getCommitteeaddmappingatprogrambatchperiodgrid();
    		var nextSearchCombo= nextGrid.down('#prgramBPsearchcombo');
    		nextSearchCombo.reset();
    		nextSearchCombo.getStore().getProxy().extraParams= {
    			batchIds: selectedRecIdsArr.join(),
                academicTermIds: selectedATRecIdsArr.join(),
                programIds:selectedProgramRecIdsArr.join()
    		};
    		var nextGridStore = nextGrid.getStore();
    		nextGridStore.getProxy().extraParams= {
    			batchIds: selectedRecIdsArr.join(),
                academicTermIds: selectedATRecIdsArr.join(),
                programIds:selectedProgramRecIdsArr.join()
    		};
    		nextGrid.setLoading();
    		nextGridStore.clearFilter();
    		nextGridStore.load({
    			callback:function(){
     			   nextGrid.setLoading(false);
     			}
     		});
    		this.setProgressTracker(3,committeemappingtabstructure);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){
    			committeeaddmappingstructure.down("#committeProgramBatchPeriodTab").setValue(recordsCommitteeGrid.get('committeeName'));
    			committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    nextEventForAcademicTermCSCommittee:function(grid){
		var committeeaddmappingstructure = this.getCommitteeaddmappingstructurecoursesection();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtabforcoursesection();
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var selectedRecIdsArr = [];
    	selectionModel.forEach(function(obj){
			selectedRecIdsArr.push(obj.get('id'));
		});
    	if(selectedRecIdsArr.length > 0){
    		var courseCodeNameContainer = committeeaddmappingstructure.down('#courseCodeNameContainer');
    		courseCodeNameContainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(courseCodeNameContainer);
    		var nextGrid= this.getCommitteeapplytocoursegrid();
    		var nextSearchCombo= nextGrid.down('#coursesearchcombo');
    		nextSearchCombo.reset();
    		nextSearchCombo.getStore().getProxy().extraParams= {
    			academicTermIds: selectedRecIdsArr.join()
    		};
    		var nextGridStore = nextGrid.getStore();
    		nextGridStore.getProxy().extraParams= {
    			limit:-1,
    			academicTermIds: selectedRecIdsArr.join()
    		};
    		nextGrid.setLoading();
    		nextGridStore.clearFilter();
    		nextGridStore.load({
    			callback:function(){
     			   nextGrid.setLoading(false);
     			}
     		});
    		this.setProgressTracker(1,committeemappingtabstructure);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){
    			committeeaddmappingstructure.down("#lblCommitteeCourseTab").setValue(recordsCommitteeGrid.get('committeeName'));
    			committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    nextEventForCourseCSCommittee:function(grid){
		var committeeaddmappingstructure = this.getCommitteeaddmappingstructurecoursesection();
    	var committeapplytotabstructure = this.getCommitteapplytotabstructure();
    	var committeemappingtabstructure = this.getCommitteeaddmappingtabforcoursesection();
    	var selectionModel = grid.getSelectionModel().getSelection();
    	var selectedRecIdsArr = [];
    	var selectedATRecIdsArr=[];
    	selectionModel.forEach(function(obj){
			selectedRecIdsArr.push(obj.get('courseId'));
			selectedATRecIdsArr.push(obj.get('academicTermId'));
		});
    	if(selectedRecIdsArr.length > 0){
    		var courseVariantContainer = committeeaddmappingstructure.down('#courseVariantContainer');
    		courseVariantContainer.setDisabled(false);
    		committeeaddmappingstructure.setActiveTab(courseVariantContainer);
    		var nextGrid= this.getCommitteeapplytocoursevariantgrid();
    		var nextSearchCombo= nextGrid.down('#coursevariantsearchcombo');
    		nextSearchCombo.reset();
    		nextSearchCombo.getStore().getProxy().extraParams= {
    			courseIds: selectedRecIdsArr.join(),
    			academicTermIds: selectedATRecIdsArr.join()
    		};
    		var nextGridStore = nextGrid.getStore();
    		nextGridStore.getProxy().extraParams= {
    			limit:-1,
    			courseIds: selectedRecIdsArr.join(),
    			academicTermIds: selectedATRecIdsArr.join()
    		};
    		nextGrid.setLoading();
    		nextGridStore.clearFilter();
    		nextGridStore.load({
    			callback:function(){
     			   nextGrid.setLoading(false);
     			}
     		});
    		this.setProgressTracker(2,committeemappingtabstructure);
    		var recordsCommitteeGrid = committeapplytotabstructure.config.committeGridRecord;
    		if(!isNullOrEmpty(recordsCommitteeGrid)){
    			committeeaddmappingstructure.down("#lblCommitteeProgramView").setValue(recordsCommitteeGrid.get('committeeName'));
    			committeemappingtabstructure.down('#committeeMappingId').setValue(recordsCommitteeGrid.get('id'));
    		}
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    submitMappingWithAcademicTermProgramBatchPeriod:function(){
    	var $this = this,params=[],
    	submitUrl =SERVERURL.PATH_SAVE_COMMITTEE_PROGRAM_BATCH_PERIOD,
    	batchGrid = $this.getCommitteeaddmappingatprogrambatchgrid(),
    	periodGrid = $this.getCommitteeaddmappingatprogrambatchperiodgrid(),
    	selectedRecord = periodGrid.getSelectionModel().getSelection(),
    	committeemappingtabstructure = $this.getCommitteeaddmappingtabforPBP(),
    	committeapplytotabstructure = $this.getCommitteapplytotabstructure(),
    	contentPanel = $this.getContentPanel(),
    	tabStructure = $this.getCommitteeaddmappingstructurePBP(),
    	getcontroller = $this.getController('menu.CoreERPNavigationController'),
    	applyToGrid = $this.getCommitteapplytogrid(),
    	committeeMappingId = committeemappingtabstructure.down('#committeeMappingId').getValue();
    	
    	if(committeeMappingId){
    		committeeMappingId = parseInt(committeeMappingId);
    	}
    	if(selectedRecord.length>0){
    			selectedRecord.forEach(function(rec){
    				params.push({
    					"batch":{
    						id:rec.get('batchId')
    					},
    					"committee":{
    						id:committeeMappingId
    					},
    					"program" : {
    						id:rec.get('programId')
    					},
    					"programBatchPeriodConfiguration":{
    						id:rec.get('pbpId')
    					},
    					"academicTermId":rec.get('academicTermId'),
    					"committeeId":committeeMappingId
    				});
    			});
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: submitUrl,
    			jsonData:Ext.encode(params),
    			success : function(response, action) {
    				if(response.responseText == "SUCCESS"){
    					Ext.getBody().unmask();
    					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    					var getTab=getcontroller.getTab(tabName);
    					if(getTab!=null){
    						contentPanel.remove(getTab, true);
    					}

    					var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    					var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    					if(getTabApplyTo!=null){
    						contentPanel.remove(getTabApplyTo, true);
    					}
    					var committeeApplyToGridStore = applyToGrid.getStore();
    					if(!isNullOrEmpty(committeeMappingId)){
    						committeeApplyToGridStore.getProxy().extraParams={
    							committeeId: committeeMappingId
    						};
    					}
    					$this.resetGridSetting(applyToGrid);
    					$this.resetPageSetting(committeeApplyToGridStore);
    					committeeApplyToGridStore.load();


    					var structure = Ext.widget('committeapplytotabstructure');

    					openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
    					showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
    				}else{
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('COMMITTEE_IS_ALREADY_MAPPED'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					htmlData = htmlData + '<div style="padding-bottom: 3px;">' +response.responseText + '</div>';

    					pnlListMappingFld.setValue(htmlData);

    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    					})
    					alertWin.show();
    				}


    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}

    },
    submitMappingWithAcademicTermCourseCourseVariant:function(){
    	var $this = this,params=[],
    	submitUrl =SERVERURL.PATH_SAVE_COMMITTEE_COURSE_VARIANTS,
    	courseVariantGrid = $this.getCommitteeapplytocoursevariantgrid(),
    	selectedRecord = courseVariantGrid.getSelectionModel().getSelection(),
    	committeemappingtabstructure = $this.getCommitteeaddmappingtabforcoursesection(),
    	committeapplytotabstructure = $this.getCommitteapplytotabstructure(),
    	contentPanel = $this.getContentPanel(),
    	tabStructure = $this.getCommitteeaddmappingstructurecoursesection(),
    	getcontroller = $this.getController('menu.CoreERPNavigationController'),
    	applyToGrid = $this.getCommitteapplytogrid(),
    	committeeMappingId = committeemappingtabstructure.down('#committeeMappingId').getValue();

    	if(committeeMappingId){
    		committeeMappingId = parseInt(committeeMappingId);
    	}
    	if(selectedRecord.length>0){
    		selectedRecord.forEach(function(rec){
    			params.push({
    				"courseVariant":{
    					id:rec.get('id')
    				},
    				"committee":{
    					id:committeeMappingId
    				},
    				"academicTermId":rec.get('academicTermId'),
    				"committeeId":committeeMappingId
    			});
    		});
    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: submitUrl,
    			jsonData:Ext.encode(params),
    			success : function(response, action) {
    				if(response.responseText == "SUCCESS"){
    					Ext.getBody().unmask();
    					var tabName = getFeeAndPaymentCommonTranslation('ADD_MAPPING');
    					var getTab=getcontroller.getTab(tabName);
    					if(getTab!=null){
    						contentPanel.remove(getTab, true);
    					}

    					var tabNameApplyTo = getExaminationTranslation('APPLY_TO');
    					var getTabApplyTo=getcontroller.getTab(tabNameApplyTo);
    					if(getTabApplyTo!=null){
    						contentPanel.remove(getTabApplyTo, true);
    					}
    					var committeeApplyToGridStore = applyToGrid.getStore();
    					if(!isNullOrEmpty(committeeMappingId)){
    						committeeApplyToGridStore.getProxy().extraParams={
    							committeeId: committeeMappingId
    						};
    					}
    					$this.resetGridSetting(applyToGrid);
    					$this.resetPageSetting(committeeApplyToGridStore);
    					committeeApplyToGridStore.load();


    					var structure = Ext.widget('committeapplytotabstructure');

    					openTab(contentPanel, tabNameApplyTo, structure,CONSTANTS.MENU_COLOR_NINE);
    					showSuccessMessage(getCommonTranslation('COMMITTEE'), getCommonTranslation('COMMITTEE_MAPPED_SUCCESSFULLY'));
    				}else{
    					Ext.getBody().unmask();
    					var alertWin = $this.getCommitteemappingalertwin();
    					if(!alertWin){
    						alertWin = Ext.widget('committeemappingalertwin');
    					}
    					alertWin.down('#committeeAlert').setValue(getCommonTranslation('COMMITTEE_IS_ALREADY_MAPPED'));
    					var pnlListMappingFld = alertWin.down('#pnlListMappingItemId');
    					var htmlData = '';
    					htmlData = htmlData + '<div style="padding-bottom: 3px;">' +response.responseText + '</div>';

    					pnlListMappingFld.setValue(htmlData);

    					var btn = alertWin.down('#committeeAlertBtnOk');
    					btn.on('click', function() {
    						alertWin.close();
    					})
    					alertWin.show();
    				}


    			}
    		});
    	} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    doaccessValidaitonForRadio:function(form){
    	var committeeGrid = this.getCommitteegrid();
    	var record = committeeGrid.getSelectionModel().getSelection()[0];
    	var applyToRadio = form.down('#committeApplyToGroup');
		var committeApplyToGroup = applyToRadio.items.items;
		var academyLocationId = this.getCurrentAcademyLocation();
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(academyLocationId);
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, this.getTNS_MANAGE_COMMITTEE_APPLY_TO_PERMISSIONS());
		Ext.each(permissionList, function(privilege) {
			if (privilege === 'APPLYTO_COURSE_SECTION') {
				committeApplyToGroup[2].setVisible(true);
			} 
			if (privilege === 'APPLYTO_PROGRAM_BATCH_PERIOD') {
				committeApplyToGroup[1].setVisible(true);
			} 
		});
		Ext.Ajax.request({
            type: 'rest',
            url: SERVERURL.PATH_GET_TYPE_OF_MAPPING,
            method: 'GET',
            params : {
            	committeeId : record.data.id
			 },
            success: function(response, action) {
                var responseData = Ext.decode(response.responseText);
                if (responseData.mapped) {
                	if(!isNullOrEmpty(responseData.courseVariantId)){
                		applyToRadio.setValue({committeApplyToGroup:'courseSection'});
                		applyToRadio.items.items[1].setDisabled(true);
                		applyToRadio.items.items[0].setDisabled(true);
                	}else if(!isNullOrEmpty(responseData.progBatchPeriodConfigId)){
                		applyToRadio.setValue({committeApplyToGroup:'programBatchPeriod'});
                		applyToRadio.items.items[2].setDisabled(true);
                		applyToRadio.items.items[0].setDisabled(true);
                	}else if(!isNullOrEmpty(responseData.seatConfigId)){
                		applyToRadio.setValue({committeApplyToGroup:'programBatchSeatType'})
                		applyToRadio.items.items[2].setDisabled(true);
                		applyToRadio.items.items[1].setDisabled(true);
                	}
                }
            }
        });
    },
	setCommitteRequesterErpDetails:function(){
		var me = this;
		var gridView = me.getCommitteerequestgrid();
		var selectedRecord = gridView.getSelectionModel().getSelection()[0];
		 var studentCommittee = me.getStudentcommitteerequestpanel();
		var basicDetails = me.getStudentcommitteerequestbasicdetails();
		var requesterPanel = me.getStudentcommitteerequesterdetailspanel();
		me.toggleReadOnlyFormItems(basicDetails.getForm(), true);
		var submitPanel = studentCommittee.down('#submitBtn');
		submitPanel.destroy();
		requesterPanel.down('#name').setValue(selectedRecord.data.studentId.value);
		requesterPanel.down('#batch').setValue(selectedRecord.data.intakeList);
		requesterPanel.down('#program').setValue(selectedRecord.data.programList);
		requesterPanel.down('#seatType').setValue(selectedRecord.data.seatTypeList);
		requesterPanel.down('#email').setValue(selectedRecord.data.email);
		requesterPanel.down('#mobile').setValue(selectedRecord.data.mobileNo);
		basicDetails.down('#enteredBy').setValue(selectedRecord.data.studentId.value);
		if(!isNullOrEmpty(selectedRecord.data.requestAssignTo)){
		 basicDetails.down('#assignedTo').setValue(selectedRecord.data.requestAssignTo.value);
		}else{
		 basicDetails.down('#assignedTo').setValue("Auto");    
		}
		basicDetails.down('#requestDate').setValue(dateRender(selectedRecord.data.requestDate));
		basicDetails.down('#committeeNameItemId').setValue(selectedRecord.data.committeeId.value);
		basicDetails.down('#membershipTypeItemId').setDisabled(false);
		basicDetails.down('#membershipTypeItemId').setValue(selectedRecord.data.membershipTypeId.value);
		basicDetails.down('#membershipAmountItemId').setDisabled(false);
		basicDetails.down('#membershipAmountItemId').setValue(selectedRecord.data.membershipAmount);
		basicDetails.down('#requestReason').setValue(selectedRecord.data.description);
		
		
	},
	resetGridSelectionAndCombo:function(grid,combo){
		grid.getSelectionModel().deselectAll();
		grid.getStore().clearFilter();
		if(combo){
		  combo.reset();
		}
	},
	setTotalRecordData:function(grid,property,value){
		grid.getStore().clearFilter();
		grid.getStore().filter({property: property,
			value: value,
			exactMatch: true,
			caseSensitive: true});
		var totalRecord = grid.down('#totalRecordDisplayField');
		totalRecord.setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ grid.getStore().getCount());
	},
	
	  getIdValueJson: function(id, value) {
   	   if (id) return {
   		   id: id,
   		   value: value
   	   };
      },
      
      // Alumni Interest Group
      onAddAlumniInterestGroup: function() {
    	  this.openAlumniInterestGroup('add');
      },
      
      onEditAlumniInterestGroup: function() {
      	var me = this;
      	var newRecord = {}
      	var grid = me.getAlumnicommitteegrid();
      	var form = me.getAlumniinterestgroupform();
      	
      	if(grid.getSelectionModel().getCount() > 0) {
      		var record = grid.getSelectionModel().getSelection()[0];
      		
      		Ext.Ajax.request({
          		url: SERVERURL.PATH_ALUMNI_COMMITTEE_FIND_BY_ID,
          		type: 'rest',
                  method: 'GET',
                  params: { 
                	  alumniCommitteeId: record.data.id
                  },
                  headers: {
                      'Content-Type': 'application/json'
                  },
                  success: function(response){
                  	var data = Ext.decode(response.responseText);
                  	newRecord = data;
                  	me.openAlumniInterestGroup('edit', newRecord);
                  }
          	})
      	} 
      },
      
      onViewAlumniInterestGroup: function() {
        	var me = this;
          	var newRecord = {}
          	var grid = me.getAlumnicommitteegrid();
          	var form = me.getAlumniinterestgroupform();
          	
          	if(grid.getSelectionModel().getCount() > 0) {
          		var record = grid.getSelectionModel().getSelection()[0];
          		
          		Ext.Ajax.request({
              		url: SERVERURL.PATH_ALUMNI_COMMITTEE_FIND_BY_ID,
              		type: 'rest',
                      method: 'GET',
                      params: { 
                    	  alumniCommitteeId: record.data.id
                      },
                      headers: {
                          'Content-Type': 'application/json'
                      },
                      success: function(response){
                      	var data = Ext.decode(response.responseText);
                      	newRecord = data;
                      	me.openAlumniInterestGroup('view', newRecord);
                      }
              	})
          	} 
          },
      
          openAlumniInterestGroup: function(mode, record) {
        	  var $this = this;
        	  var contentpanel = $this.getContentPanel();
              var tabName;
              if(mode === 'add') {
              	tabName = getAlumni('ADD_ALUMNI_INTEREST_GROUP');
              }
              if(mode === 'edit') {
              	tabName = getAlumni('EDIT_ALUMNI_INTEREST_GROUP');
              }
              if(mode === 'view') {
              	tabName = getAlumni('VIEW_ALUMNI_INTEREST_GROUP');
              }
              var navigationController = $this.getController('menu.CoreERPNavigationController');
              
              var existingTab = navigationController.getTab(tabName);
              if (existingTab) {
                  contentpanel.remove(existingTab);
              }
              
              var alumniInterestGroupTab = Ext.widget('alumniinterestgroupform');
              
              var oppositeTabNames = [];
              if (mode === 'add') {
                  oppositeTabNames = [getAlumni('EDIT_ALUMNI_INTEREST_GROUP'), getAlumni('VIEW_ALUMNI_INTEREST_GROUP')];
              } else if (mode === 'edit') {
                  oppositeTabNames = [getAlumni('ADD_ALUMNI_INTEREST_GROUP'), getAlumni('VIEW_ALUMNI_INTEREST_GROUP')];
              } else if (mode === 'view') {
                  oppositeTabNames = [getAlumni('ADD_ALUMNI_INTEREST_GROUP'), getAlumni('EDIT_ALUMNI_INTEREST_GROUP')];
              }
              
              contentpanel.items.each(function(tab) {
                  if (oppositeTabNames.includes(tab.title)) {
                      contentpanel.remove(tab);
                  }
              });
              
              openTab(contentpanel, tabName, alumniInterestGroupTab, CONSTANTS.MENU_COLOR_ONE);
              
              if (mode === 'edit' || mode === 'view') {
            	  var form = alumniInterestGroupTab.getForm();
            	  form.findField('id').setValue(record.id);
            	  form.findField('committeeName').setValue(record.committeeName);
            	  form.findField('committeeCode').setValue(record.committeeCode);  
            	  form.findField('committeeType').setValue(record.committeeType.id);
            	  form.findField('description').setValue(record.description); 
            	  form.findField('startDate').setValue(new Date(record.validFromDate));
                  form.findField('endDate').setValue(new Date(record.validTillDate));
                  
                  var committeeCoordinatorID = record.committeeCoordinator.id;
            	  
            	  form.findField('user').getStore().load({
                      callback:function(records){
                      	form.findField('user').setValue(committeeCoordinatorID);    
                      }   
                  });
            	  
            	  var startDateField = alumniInterestGroupTab.down('#startDateItemId');
            	  var endDateField = alumniInterestGroupTab.down('#endDateItemId');
            	  var currentDate = new Date();
            	  
            	  if (startDateField) {
            		var validFromDate = new Date(record.validFromDate);
      	            startDateField.setMinValue(validFromDate > currentDate ? currentDate : validFromDate);
      	            startDateField.validate();
      	            
      	            startDateField.on('change', function(field, newValue) {
        				if (endDateField) {
        					var selectedStartDate = new Date(newValue);
        					if (selectedStartDate < currentDate) {
        						endDateField.setMinValue(currentDate);
        					} else {
        						endDateField.setMinValue(selectedStartDate);
        					}
        					endDateField.validate();
        				}
        			});
            	  }
            	 
            	  if(endDateField) {
            		  var validFromDate = new Date(record.validFromDate);
            		  endDateField.setMinValue(validFromDate > currentDate ? validFromDate : currentDate);
            		  endDateField.validate();
            	  }
            	  
                  var status = form.findField('status');
                  status.getStore().load({
    					callback:function(r) {
    						if(record.status) {
    							status.setValue(r[0].data.id);
    						} else {
    							status.setValue(r[1].data.id);
    						}
    					}
    				});
            	  
                  var resetButton = alumniInterestGroupTab.down('#resetBtnAl');
                  resetButton.hide();
                  
                  alumniInterestGroupTab.getForm().findField('committeeCode').setReadOnly(true);
            	  
            	  if (mode === 'view') {
                      // Disable all fields in view mode
            		  alumniInterestGroupTab.getForm().getFields().each(function(field) {
                          field.setReadOnly(true);
                          if (field.allowBlank !== undefined) {
      	                    field.allowBlank = true; 
      	                }    
                      });
            		  
            		  var saveButton = alumniInterestGroupTab.down('#submitBtnAl');
                      saveButton.hide();
                      
                  }
              }  
          },

      
      createAlumniCommittee: function(button) {
    	  var me = this;
    	  me.saveAlumniCommittee()
      },
      
      saveAlumniCommittee: function() {
    	  var me = this;
    	  var formPanel = me.getAlumniinterestgroupform();
          var formValues = formPanel.getValues();
          
          var status = formValues.status === "ACTIVE" ? true : false;
          
          var dataPayload = {
        		  committeeCode: formValues.committeeCode,
        		  committeeName: formValues.committeeName,
        		  committeeCoordinator: {"id": formValues.user},
        		  validFromDate: new Date(formValues.startDate),
        		  validTillDate: new Date(formValues.endDate),
        		  status: status,
        		  description: formValues.description,
        		  committeeType: {"id": formValues.committeeType},
          };
          
          var submitUrl
          
          if (formValues.id) {
              dataPayload.id = formValues.id;
              submitUrl = SERVERURL.PATH_ALUMNI_COMMITTEE_UPDATE_COMMITTEE
          } else {
        	  submitUrl = SERVERURL.PATH_ALUMNI_COMMITTEE_CREATE_COMMITTEE;
          }
             
          var data = Ext.encode(dataPayload)
          Ext.Ajax.request({
	            url: submitUrl,
	            method: "POST",
	            jsonData: data,
	            success: function(response) {
	                Ext.getBody().unmask();

	                // Parse response
	                var responseData = Ext.decode(response.responseText);
	                
	                // Check if response is 0 (or whatever condition you need)
	                if (!formValues.id && responseData === 0) {
	                    // Handle duplicate data case
	                    showErrorMessage(getCommonTranslation('ERROR'), getAlumni('DUPLICATE_DATA'));
	                } else {
	                    // Handle successful response
	                    var grid = me.getAlumnicommitteegrid();
	                    grid.getStore().load();

	                    var currentTab = me.getController('menu.CoreERPNavigationController').getTab(
	                            formValues.id ? getAlumni('EDIT_ALUMNI_INTEREST_GROUP') : getAlumni('ADD_ALUMNI_INTEREST_GROUP')
	                    );
	                    
	                    if (formValues.id){
	                    	showSuccessMessage(getAlumni('ALUMNI_INTEREST_GROUP'), getAlumni('ALUMNI_INTEREST_GROUP_UPDATE'));
	                    } else {
	                    	showSuccessMessage(getAlumni('ALUMNI_INTEREST_GROUP'), getAlumni('ALUMNI_INTEREST_GROUP_SAVE'));
	                    }
	                    
	                    
	                    
	                    if (currentTab) {
	                        me.getContentPanel().remove(currentTab, true);
	                    }
	                }
	            },
	            failure: function(response) {
	                Ext.getBody().unmask();
//	                showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('SERVER_ERROR'));
	            }
	        });
      },
      
      deleteAlumniCommittee: function(obj) {
      	var this$ = this;
          var grid = this.getAlumnicommitteegrid(); 
          if (grid.getSelectionModel().getCount() > 0) {
        	  var record = grid.getSelectionModel().getSelection()[0];
        	  var id = record.data.id;
              showConfirmMessage(getAlumni('INTEREST_GROUP_LIST'), getAlumni('DO_YOU_WANT_TO_DELETE'), function (btn, text) {
                  if (btn == 'yes') {
                      Ext.getBody().mask(getAlumni('SUBMITTING_FORM'), 'x-mask-loading');
                      
                      var urlWithParam = SERVERURL.PATH_ALUMNI_COMMITTEE_DELETE_COMMITTEE + '?alumniCommitteeId=' + encodeURIComponent(id);

                      Ext.Ajax.request({
                          type: 'rest',
                          url: urlWithParam,
                          method: 'DELETE',
                          success: function (form, action) {
                     
                              Ext.getBody().unmask();
                            
                              showSuccessMessage(getAlumni('ALUMNI_INTEREST_GROUP'), getAlumni('DELETE_SUCCESS'));
                             
                              grid.getStore().load();
                              
                              grid.getSelectionModel().deselectAll();
                          },
                          failure: function () {
                              Ext.getBody().unmask();
                          }
                      });
                  }
              });
          } else {
              showWarningMessage(getCommonTranslation('PLEASE_SELECT_RECORD'), getCommonTranslation('PLEASE_SELECT_RECORD'));
          }	
      
      },
      downloadbulkCommitteeParticipant:function(btn){
    	  var me = this,
    	  form= me.getBulkCommitteeParticipantDownloadForm(),
    	  formVal = form.getValues();
    	  try{
    		  committeeId = Ext.pluck(Ext.pluck(formVal.bulkCommitteeParticipant,'data'),'id').join();
    	  }catch(e){
    		  committeeId = formVal.bulkCommitteeParticipant.join();
    	  }
    	  
    	  var csvForm = Ext.create('Ext.form.Panel',{
    		  items:[{
  				xtype : 'textfield',
  				maxLength : 20480,
  				itemId : 'committeeIds',
  				name : 'committeeIds',
  				vtype : 'spaceAsInput'
  			},{
  				xtype : 'textfield',
  				maxLength : 20480,
  				itemId : 'userGrpId',
  				name : 'userGrpId',
  				vtype : 'spaceAsInput'
  			}]
      	});
    	  csvForm.down('#committeeIds').setValue(committeeId);
    	  csvForm.down('#userGrpId').setValue(formVal.userTypeId);
  	 				  csvForm.getForm().submit({
  	 					  target: '_blank',
  	 					  method:'POST',
  	 					  params :{
  	 						  access_token : Ext.Ajax.defaultHeaders.access_token
  	 						  },
  	 					  headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
  	 					  url: SERVERURL.DOWNLOAD_TEMPLATE_COMMITTEE_PARTICIPANT,
  	 					  standardSubmit :true,
  	 					  success : function(form, action){
  	 						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
  	 					  },
  	 					  failure: function(form, action) {
  	 						  showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
  	 					  }
  	 				  });
  	 			  
    	  
      },
      bulkCommitteeParticipantChange : function(cb, nv){
     		var me = this,
     		 downloadTemplateForm = me.getBulkCommitteeParticipantDownloadForm(),
     		 uploadTemplateForm = me.getBulkCommitteeParticipantUploadForm(),
     		 grid = me.getBulkCommitteeParticipantGrid();
     		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
     			uploadTemplateForm.hide();
     			downloadTemplateForm.show();
     			grid.setVisible(false);
     		}else{
     			downloadTemplateForm.hide();
     			uploadTemplateForm.show();
     			grid.setVisible(true);
     		}
     	},
     	
     	// Bulk Membership Loader
     	bulkMembershipParticipantChange: function(cb, nv){
     		var me = this,
    		 downloadTemplateForm = me.getBulkmembershipdownloadform(),
    		 uploadTemplateForm = me.getBulkmembershipuploadform(),
    		 grid = me.getBulkmembershipupdategrid();
    		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
    			uploadTemplateForm.hide();
    			downloadTemplateForm.show();
    			grid.setVisible(false);
    		}else{
    			downloadTemplateForm.hide();
    			uploadTemplateForm.show();
    			grid.setVisible(true);
    		}
    		var formnew =uploadTemplateForm.down('#membershipUploadOptionRadioGroupItemId');;
			var isUploadAll = formnew.items.items[0].getValue().isUploadAll;
    		me.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_UPLOAD_MEMBERSHIP');
    	},
    	bulkCommitteeMembersUpload:function(obj){
    		obj.setDisabled(true);
    		var $this=this;
    		var form=$this.getBulkmembershipuploadform();
    		submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
    		$this.getHashOfFile(form);
    		setTimeout(function() {
    			form.getForm().submit({
    				method : 'POST',
    				url : submitUrl,
    				success : function(form, action){
    					showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
	                var grid = $this.getBulkmembershipupdategrid();
					grid.getStore().reload();
    				},
    				failure: function(form, action) {
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
    				}
    			});
    		},1000);
    		Ext.defer(function() {
    			var grid = $this.getBulkmembershipupdategrid();;
    			var formnew =form.down('#bulkMembershipUploadDownloadId');;
    			var isUploadAll = formnew.items.items[0].getValue().isUploadAll;
    			this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'BULK_COMMITTEE_PARTICIPANT');
    		}, 2000, this);

    	},
     	bulkCommitteeParticipantUpload:function(){
     		
     	}
});
