/**
' * @author Pritam.Patil
 * This controller is use to handle functionality for Completion 
 */
Ext.define('Academia.controller.completion.CompletionFormController', {
    extend: 'Academia.controller.base.BaseController',
    init: function(config) {
        this.callParent(arguments);
    },
    views: ['completion.completionlistforms.common.CompletionPanel','completion.completionlist.TerminationQuickSearchForm',
            'completion.completionlist.PassingOutPanel','completion.completionlist.PassingOutView', 
            'completion.completionlist.TemporaryTerminationPanel','completion.completionlist.TemporaryTerminationView', 
            'completion.completionlist.TerminationPanel','completion.completionlist.TerminationView', 
            'completion.completionlist.TransferPanel','completion.completionlist.TransferView', 
            'completion.completionlist.WithdrawalFromProgramPanel','completion.completionlist.WithdrawalFromProgramView',
            'completion.completionlist.WithdrawProgramQuickSearchForm','completion.completionlistforms.PassingOutGeneralForm', 
            'completion.completionlistforms.common.PendingPaymentForm','completion.completionlistforms.common.PendingRefundsForm',
            'completion.completionlistforms.common.IssueCertificatesForm','completion.completionlistforms.common.DocumentForm',
            'completion.completionlistforms.common.CheckListForm','completion.completionlistforms.PassingOutTabPanel', 
            'completion.completionlistforms.common.IssueCertificatesGrid','completion.completionlistforms.common.CompletionDocumentGrid',
            'servicerequest.common.FeeDetailsGrid','completion.completionlistforms.common.CompletionRefundHistoryGrid', 
            'document.DocumentFormWindow',
            'completion.completionlistforms.TransferGeneralForm','completion.completionlistforms.TerminationTabPanel',
            'completion.completionlistforms.TerminationGeneralForm','completion.completionlistforms.TempTerminationTabPanel',
            'completion.completionlistforms.TransferTabPanel','completion.completionlistforms.WithdrawProgramTabPanel', 
            'completion.completionlistforms.WithdrawFromProgramGeneralForm','completion.completionlistforms.common.StudentBasicDetails',
            'completion.completionlistforms.common.PassingOutProfileView','document.ExtendedDocumentForm',
            
            'completion.completionlistforms.common.CompletionPendingBillGrid',
            'completion.completionlistforms.common.CompletionPendingPaymentGrid',
            'completion.completionlistforms.common.PendingRefundablesForm',
            'completion.completionlistforms.common.CompletionRefundHistoryGrid','completion.completionlistforms.TerminationStaticDocumentAttachmentGrid',
            'completion.completionlistforms.TerminationSendMessages','completion.completionlist.PassingOutGrid',
            'completion.setup.ShowFeesDuePopUp','completion.completionlist.CompletionDetailWindow',
            'completion.completionlist.CompletionDetailWindowForm', 'completion.completionlist.PrintCertificateWindow',
            'completion.completionlist.DebarmentReasonsWindow', 'completion.CompletionSendMessage', 'messaging.StudentStaticDocumentAttachmentGrid','completion.PassOutRejectButtonWindow','completion.PassOutRejectButtonForm'],

    stores: ['completion.completionform.PendingBillGrids','completion.completionform.PendingPayments', 
             'completion.completionform.IssueCertificatesGrids',
             'completion.completionform.CompletionDocuments','servicerequest.TransferReasons', 
             'completion.completionform.CompletionCheckLists','completion.completionform.CompletionStatus',
             'completion.completionform.TerminationStatus','completion.completionform.PassOutStatus', 
             'completion.completionform.WithdrawReasons','personinfo.common.paymentandrefund.RefundHistoryStore','messaging.MessagingTemplatesStore',
             'committee.committee.MessageTypeNotificationStore','messaging.StaticDocumentAttachmentGridStore','completion.completionform.PassingOutGridStore',
             'completion.completionform.CertificateNamesStore',
             'servicerequest.TerminationReasons', 'servicerequest.DebarmentReasons','servicerequest.studentservicerequest.ReasonForLeavingStore',
             'completion.completionform.DebarmentReasonsDataStore','completion.completionform.CompletionCertificateDataStore'],
    
    config: {
    	COMPLETION_PASSING_OUT_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_PASSING_OUT_PRIVILEGES'),
    	COMPLETION_WITHDRAW_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_WITHDRAW_FROM_PROGRAM_PRIVILEGES'),
    	COMPLETION_PASSING_OUT_ISSUE_CERTIFICATE_SEND_MESSAGE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_PASSING_OUT_ISSUE_CERTIFICATE_SEND_MESSAGE'),
    	COMPLETION_PASSINGOUT_PENDING_REFUNDING_SEND_MESSAGE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_PASSINGOUT_PENDING_REFUNDING_SEND_MESSAGE'),
    	COMPLETION_PASSINGOUT_PENDING_PAYMENT_SEND_MESSAGE_PERMISSION: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_PASSINGOUT_PENDING_PAYMENT_SEND_MESSAGE'),
    },
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },{
        ref: 'documentForm',
        selector: 'documentform[completion_document]'
    }, {
        ref: 'passingOutTabPanel',
        selector: 'passingouttabpanel'
    }, {
        ref: 'transferTabPanel',
        selector: 'transfertabpanel'
    }, {
        ref: 'terminationTabPanel',
        selector: 'terminationtabpanel'
    }, {
        ref: 'temporaryTerminationPanel',
        selector: 'temporaryterminationpanel'
    }, {
        ref: 'withdrawProgramTabPanel',
        selector: 'withdrawprogramtabpanel'
    }, {
        ref: 'completionPanel',
        selector: 'completionpanel'
    }, {
        ref: 'issuCertificatesGrid',
        selector: 'issuecertificatesgrid'
    }, {
        ref: 'passingoutgrid',
        selector: 'passingoutgrid'
    }, {
        ref: 'terminationSearchResultGrid',
        selector: 'searchresultgrid[itemId=terminationSearchResultGrid]'
    }, {
        ref: 'temporaryTerminationSearchResultGrid',
        selector: 'searchresultgrid[itemId=temporaryTerminationSearchResultGrid]'
    }, {
        ref: 'transferSearchResultGrid',
        selector: 'searchresultgrid[itemId=transferSearchResultGrid]'
    }, {
        ref: 'withdrawalProgramSearchResultGrid',
        selector: 'searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid]'
    },{
    	ref : 'completionDocumentGrid',
    	selector : 'completiondocumentgrid'
    },{
    	ref : 'passingOutProfileView',
    	selector :'passingoutprofileview'
    },{
    	ref :'terminationsendmessages',
    	selector : 'terminationsendmessages[itemId=terminationSendMsgID]'
    },{
    	ref :'terminationDocumentMessageAttachmentGrid',
    	selector : 'terminationstaticdocumentattachmentgrid[itemId=terminationStaticDocumentAttachmentGridMessage]'
    },{
    	ref :'completiondetailwindow',
    	selector : 'completiondetailwindow'
    },{
    	ref :'completiondetailwindowform',
    	selector : 'completiondetailwindowform'
    },{
    	ref :'withdrawProgramQuickSearchForm',
    	selector : 'withdrawprogramquicksearchform'
    }, {
    	ref: 'printcertificatewindow',
    	selector: 'printcertificatewindow'
    }, {
    	ref: 'debarmentreasonswindow',
    	selector: 'debarmentreasonswindow'
    }, {
    	ref: 'completionsendmessage',
    	selector: 'completionsendmessage'
    },{
        ref: 'passoutrejectbuttonwindow',
        selector: 'passoutrejectbuttonwindow'
    },
    {
        ref: 'passoutrejectbuttonform',
        selector: 'passoutrejectbuttonform'
    }],

    init: function() {
        this.control({
            'completiondetailwindowform': {
             afterrender:function(form){
            		var saveBtn = form.down('#completeCompletionSaveItemId');
            	    
            	 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
            	 var markCheckListComplete =form.down("#markCheckListComplete");
            	 var markCertificateComplete = form.down("#markCertificateComplete");
            	 var effectiveTrasferDate = form.down("#effectiveTrasferDate");
            	 var effectivePassoutCommunicationDate = form.down("#effectivePassoutCommunicationDate");
            	 var decisionNumber = form.down("#decisionNumber");
            	 
            	 if(!record.effectivePassoutCommunicationDate){
                 	var today = new Date();
                 	tomorrow = new Date();
                 	form.down('#effectivePassoutCommunicationDate').setMinValue(new Date(tomorrow.setDate(today.getDate() + 1)));
                 	
                 }
            	   Ext.Ajax.request({
   					type: 'rest',
   					async: false,
   					url: SERVERURL.COMMON_FORM_FIELD_INFO,
   					params: {
   						//screenName: 'Manage Receipt',
   						academyLocationId: this.getCurrentAcademyLocation(),
   						languageCode:'en'
   					},
   					method: 'GET',
   					success: function(res, action) {
   						var response = Ext.decode(res.responseText);
   					
   						if( Object.keys(response).length > 0 ){
   							var records=response.completiondetailwindowform;
   							if(records && records.length >0){
   								for(i in records){
   									if((records[i].isMandatory == true) &&  records[i].formFieldId =='markCheckListComplete'){
   									 form.down("#markCheckListComplete").setBoxLabel(getProgramandcourseTranslation('MARK_CHECKLIST_COMPLETE')+allowblankFalse);
   									 form.down("#markCheckListComplete").isMandatory =true;
   									}
   									if((records[i].isMandatory == true) &&  records[i].formFieldId =='markCertificateComplete'){
   									 form.down("#markCertificateComplete").setBoxLabel(getProgramandcourseTranslation('MARK_CERTIFICATE_COMPLETE')+allowblankFalse);
   					            	 form.down("#markCertificateComplete").isMandatory =true;
      							   }
   									if((records[i].isMandatory == true) &&  records[i].formFieldId =='effectiveTrasferDate'){
   									 form.down("#effectiveTrasferDate").isMandatory =true;
   									}
   									if((records[i].isMandatory == true) &&  records[i].formFieldId =='decisionNumber'){
      									 form.down("#decisionNumber").isMandatory =true;
      								}
   								}
   							}
   							if((!markCheckListComplete.isMandatory && markCheckListComplete.isVisible) && (!markCertificateComplete.isMandatory && markCertificateComplete.isVisible)
   									&& (!effectiveTrasferDate.isMandatory && effectiveTrasferDate.isVisible) && (!decisionNumber.isMandatory && decisionNumber.isVisible))
                              {
   								saveBtn.enable();   								
                              }
   							//effectiveTrasferDate.setVisible(false);
   						}
   					}
            	   });
		   		
               }           	
             },
            /* Open Form Functions */

            'passingoutgrid button[itemId=updateButtonId]': {
                click: function(){
                	this.openPassoutCompletionPanel(this.getPassingoutgrid());
                }
            },
            'passingoutgrid button[itemId=rejectBtnId]': {
                click: function(){
                	this.operationResetButton(this.getPassingoutgrid());
                }
            },
            'passoutrejectbuttonform button[itemId=cancelBtn]': {
            	click: function(btn) {
            		btn.up('window').close();
            	}
            },
            'passoutrejectbuttonform button[itemId=submitBtnWin]': {
            	click:function(btn){
            		var this$ = this;
            		btn.disable();
                    var window=this.getPassoutrejectbuttonform()//form window
                    var form = window.down("#passoutrejectform").getForm();
                    var formValues = form.getValues(); 
                    var grid=this.getPassingoutgrid();  
                    Ext.getBody().mask(getCommonTranslation('LOADING_MASK'));
                    
                    var saveModel = [];
                    
                    for(var i=0;i<grid.getSelectionModel().getSelection().length;i++){
						var selectedRecord = grid.getSelectionModel().getSelection()[i];
					 	var jsonData = {
                    		   id: selectedRecord.get("completionId"),
                    		   rejectedRemark :formValues.rejectRemark,
                    		   rejectedBy:{
                    			   id: this$.getCurrentlyLoggedInUser().id
                    		   }
                   		 };
                   		 saveModel.push(jsonData);
					}

                    var formData = Ext.encode(saveModel);
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PATH_REJECT_PASSOUT,                                                       
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        jsonData : formData, 
                        success: function(form, action) {  
                            grid.getStore().reload();
                            Ext.getBody().unmask();  
                            grid.getSelectionModel().deselectAll();
                            showSuccessMessage(getExaminationTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
                            window.close();
                        }
                    });

                    window.close();
            	},
            },
            'terminationpanel searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=searchResultGridBtnUpdate]': {
                click: this.openCompletionPanel
            },
            'temporaryterminationpanel searchresultgrid[itemId=temporaryTerminationSearchResultGrid] button[itemId=searchResultGridBtnUpdate]': {
                click: this.openCompletionPanel
            },
            'transferpanel searchresultgrid[itemId=transferSearchResultGrid] button[itemId=searchResultGridBtnUpdate]': {
                click: this.openCompletionPanel
            },
            'withdrawalfromprogrampanel searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=searchResultGridBtnUpdate]': {
                click: this.openCompletionPanel
            },
            'withdrawprogramquicksearchform combo[itemId=selectedNameField]': {
                select: this.changeNameFieldConfig
            },
            'terminationquicksearchform combo[itemId=selectedNameField]': {
                select: this.changeNameFieldConfig
            },

            /*  Cancel Functions */

            'passingoutgeneralform button[itemId=generalCancel]': {
                click: this.closeFormPanel
            },
            'terminationgeneralform button[itemId=generalCancel]': {
                click: this.closeFormPanel
            },
            'transfergeneralform button[itemId=generalCancel]': {
                click: this.closeFormPanel
            },
            'withdrawfromprogramgeneralform button[itemId=generalCancel]': {
                click: this.closeFormPanel
            },

            /* Save Functions */

            'passingoutgeneralform button[itemId=generalSave]': {
                click: this.saveGeneralForm
            },
            'passingoutgeneralform datefield[itemId=startDate]': {
            	change: function(field, newValue, oldValue) {
            		var passoutDateField = field.up('passingoutgeneralform').down('#effectivePassoutCommunicationDate');
            		var flage= this.isSameDate(newValue);
            		if(flage){
            			passoutDateField.setMinValue(newValue);
            			passoutDateField.reset();
            		}else{
            			var today = new Date();
                    	var tomorrow = new Date();
                    	passoutDateField.setMinValue(new Date(tomorrow.setDate(today.getDate() + 1)));
            		}
            		
                }
            },
            'passingoutgeneralform datefield[itemId=effectivePassoutCommunicationDate]': {
            	 change: function(field, newValue, oldValue) {
            		 var startDateField = field.up('passingoutgeneralform').down('#startDate');
            		 //startDateField.setMaxValue(newValue);
                 }
            },
            'completiondetailwindowform datefield[itemId=effectiveTrasferDate]': {
            	change: function(field, newValue, oldValue) {
            		var passoutDateField = field.up('completiondetailwindowform').down('#effectivePassoutCommunicationDate');
            		var flage= this.isSameDate(newValue);
            		if(flage){
            			passoutDateField.setMinValue(newValue);
            			passoutDateField.reset();
            		}else{
            			var today = new Date();
                    	var tomorrow = new Date();
                    	passoutDateField.setMinValue(new Date(tomorrow.setDate(today.getDate() + 1)));
            		}
            		
                }
            },
            'completiondetailwindowform datefield[itemId=effectivePassoutCommunicationDate]': {
            	 change: function(field, newValue, oldValue) {
                     
            		 var startDateField = field.up('completiondetailwindowform').down('#effectiveTrasferDate');
            		 //startDateField.setMaxValue(newValue);
                 }
            },
            'terminationgeneralform[itemId=terminationGeneralId] button[itemId=generalSubmitBtn]': {
                click: this.saveTerminationGeneralForm
            },
            'terminationgeneralform[itemId=tempTerminationGeneralId] button[itemId=generalSubmitBtn]': {
                click: this.saveTempTerminationGeneralForm
            },
            'transfergeneralform button[itemId=transferGeneralSubmitBtn]': {
                click: this.saveTransferGeneralForm
            },
            'withdrawfromprogramgeneralform button[itemId=withdrawGeneralSubmitBtn]': {
                click: this.saveWithdrawFromProgramGeneralForm
            },

            /* set data functions */

            'passingouttabpanel passingoutgeneralform[itemId=completionGeneralId]': {
                afterrender: this.setPassingOutGeneralForm
            },
            'terminationtabpanel terminationgeneralform[itemId=terminationGeneralId]': {
                afterrender: this.setTerminationGeneralData
            },
            'terminationtabpanel terminationgeneralform[itemId=terminationGeneralId] button[action=addTerminationReasonGeneral]':{
            	click: function(btn){
            		this.addTerminationReasonGeneral(btn);
            	}
            },
            'terminationtabpanel terminationgeneralform[itemId=terminationGeneralId] button[action=deleteTerminationReasonGeneral]':{
            	click: function(btn){
            		this.deleteTerminationReasonGeneral(btn);
            	}
            },
            'tempterminationtabpanel terminationgeneralform[itemId=tempTerminationGeneralId]': {
                render: this.setTempTerminationGeneralData
            },
            'withdrawfromprogramgeneralform': {
                render: this.setWithdrwalFromProgramGeneralData
            },
            'withdrawfromprogramgeneralform button[action=addWFPReasonGeneral]':{
            	click: function(btn){
            		this.addWFPReasonGeneral(btn);
            	}
            },
            'withdrawfromprogramgeneralform button[action=deleteWFPReasonGeneral]':{
            	click: function(btn){
            		this.deleteWFPReasonGeneral(btn);
            	}
            },
            'transfergeneralform': {
                render: this.setTransferGeneralData
            },

            /* hide show Functions */

            /*'passingouttabpanel issuecertificatesform[itemId=completion_issue_certificate]': {
                render: this.hideButton
            },
*/
            'passingoutpanel withdrawprogramquicksearchform[itemId=passing_quickSearch]': {
                render: this.hideCombo
            },
            'transferpanel terminationquicksearchform[itemId=transfer_quickSearch]': {
                beforerender: this.changeComboName
            },
            'temporaryterminationpanel terminationquicksearchform[itemId=tempTermination_quickSearch]': {
                render: this.hideCheckBoxFieldContainer
            },
            'temporaryterminationpanel terminationquicksearchform[itemId=tempTermination_quickSearch]': {
            	beforerender: this.changeTerminationComboName
            },

            /** Update Status buttons */
            
            'passingoutgrid button[itemId=updateStatus]': {
            	 click: this.updateSearchCheckboxStatus
            },            
            'terminationpanel searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=updateStatus]': {
                click: this.updateSearchCheckboxStatus
            },             
            'transferpanel searchresultgrid[itemId=transferSearchResultGrid] button[itemId=updateStatus]': {
            	 click: this.updateSearchCheckboxStatus
            },
            'withdrawalfromprogrampanel searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=updateStatus]': {
            	 click: this.updateSearchCheckboxStatus
            },
            'withdrawalfromprogrampanel grid[itemId=withdrawalFromProgramSearchResultGrid] button[itemId=emailCertificate]':{
 				click: function(btn){
					this.openPrintEmailDocWindow(btn, SERVERURL.PATH_EMAIL_CERTIFICATE_WITHDRAW_FROM_PROGRAM,"WITHDRAW_PROGRAM")
 					/*var grid = btn.up('grid');
 					if (grid.getSelectionModel().getCount() > 0) {
 						var record = grid.getSelectionModel().getSelection()[0];
 						var completionId = record.get('COMPLETION_ID');
 						var url = SERVERURL.PATH_EMAIL_CERTIFICATE_WITHDRAW_FROM_PROGRAM;
 						var params = {
 								completionId:completionId
 						};
 						this.sendGetAjaxRequest(url,'GET',params,function(option, success, response){
 							if(success){
 								showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
 							}
 						});
 					} else {
 						showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
 					}*/
 				}
            },
            
            'terminationpanel searchresultgrid[itemId=terminationSearchResultGrid] button[itemId=emailCertificate]': {
            	click: function(btn){
					this.openPrintEmailDocWindow(btn, SERVERURL.PATH_EMAIL_CERTIFICATE_FOR_TERMINATION,"TERMINATION")
 					/*var grid = btn.up('grid');
 					if (grid.getSelectionModel().getCount() > 0) {
 						var record = grid.getSelectionModel().getSelection()[0];
 						var completionId = record.get('COMPLETION_ID');
 						var url = SERVERURL.PATH_EMAIL_CERTIFICATE_FOR_TERMINATION;
 						var params = {
 								completionId:completionId
 						};
 						this.sendGetAjaxRequest(url,'GET',params,function(option, success, response){
 							if(success){
 								showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
 							}
 						});
 					} else {
 						showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
 					}*/
 				}}, 
 				
 				
 				'temporaryterminationpanel searchresultgrid[itemId=temporaryTerminationSearchResultGrid] button[itemId=emailCertificate]': {
 					click: function(btn){
	
						this.openPrintEmailDocWindow(btn, SERVERURL.PATH_EMAIL_CERTIFICATE_FOR_DEBARMENT,"TEMPORARY_TERMINATION")
 	 					/*var grid = btn.up('grid');
 	 					if (grid.getSelectionModel().getCount() > 0) {
 	 						var record = grid.getSelectionModel().getSelection()[0];
 	 						var completionId = record.get('COMPLETION_ID');
 	 						var url = SERVERURL.PATH_EMAIL_CERTIFICATE_FOR_DEBARMENT;
 	 						var params = {
 	 								completionId:completionId
 	 						};
 	 						this.sendGetAjaxRequest(url,'GET',params,function(option, success, response){
 	 							if(success){
 	 								showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
 	 							}
 	 						});
 	 					} else {
 	 						showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
 	 					}*/
 	 				}
 	            },
 				
            
            /* To Load passing Out tab Grid */
            
            
            
            'passingouttabpanel' : {
            	tabchange : function(tabPanel, newCard, oldCard, eOpts ){
        			var tab = tabPanel.activeTab.itemId ;
        			var admissionId = this.getContentPanel().getActiveTab().getAdmissionId();
        			switch(tab){
        			case 'completionGeneralId': {
        				var tabName = 'passingoutgeneralform';
        	    		var btnItemId = '#generalSave';
        				this.disableAllButtonLessEffectiveDate(tabPanel,tabName,btnItemId);
        				break;
        				
        			}
        			case 'completion_pending_payments' :{
        				
        				var grid = tabPanel.down('#completionpendingBillGrid');
        				this.loadCompletionPendingBillGridData(grid, admissionId);
        				break;
        			}
        			case 'completion_pending_refunds' :{
        				
        				var grid = tabPanel.down('#completionRefundHistoryGrid');
        				this.loadCompletionPendingRefundsGridData(grid, admissionId);
        				break;
        			}
        			case 'completion_pending_refundables' :{
        				
        				var grid = tabPanel.down('#completionPendingRefundablesBillGrid');
        				this.loadCompletionPendingRefundablesGridData(grid, admissionId);
            			break;
        			}
        			case 'completion_issue_certificate' :{
        				
        				var grid = tabPanel.down('#issueCertificatesGridId');
        				this.loadIssueGrid(grid);
            			break;
        			}
        			case 'completion_document':{
        				
        				var grid = tabPanel.down('#completionDocumentGridId');
        				this.loadStudentDocument(grid);
        				break;
        			}
        			/*case 'checkListCompletion':{
        				var itemSelector = tabPanel.down('#checkListSelector');
        				this.loadCheckListCombo(itemSelector);
        			}*/
        			}
        			
        		},
        		afterrender:function(structure){
        			this.disableWithDrawAndPassOutBypassButtonsPivileges(structure, this.getCOMPLETION_PASSING_OUT_PERMISSION());
        			var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
        			this.getPayementBypassStatus(structure,completionId);
        		}
        	},
        	
        	/* to load termination tab */
        	
        	'terminationtabpanel' : {
        		tabchange : function(tabPanel, newCard, oldCard, eOpts ){
        			var tab = tabPanel.activeTab.itemId ;
        			var admissionId = this.getContentPanel().getActiveTab().getAdmissionId();
        			switch(tab){
        			case 'terminationGeneralId': {
        				var tabName = 'terminationgeneralform';
        	    		var btnItemId = '#generalSubmitBtn';
        				this.disableAllButtonLessEffectiveDate(tabPanel,tabName,btnItemId);
        				break;
        			}
        			case 'termination_pending_payments' :{
        				
        				var grid = tabPanel.down('#completionpendingBillGrid');
        				this.loadCompletionPendingBillGridData(grid, admissionId);
        				break;
        			}
        			case 'termination_pending_refunds' :{
        				
        				var grid = tabPanel.down('#completionRefundHistoryGrid');
        				this.loadCompletionPendingRefundsGridData(grid, admissionId);
        				break;
        			}
        			case 'termination_pending_refundables' :{
        				
        				var grid = tabPanel.down('#completionPendingRefundablesBillGrid');
        				this.loadCompletionPendingRefundablesGridData(grid, admissionId);
            			break;
        			}
        			case 'termination_issue_certificate' :{
        				
        				var grid = tabPanel.down('#issueCertificatesGridId');
        				this.loadIssueGrid(grid);
            			break;
        			}
        			case 'termination_document':{
        				
        				var grid = tabPanel.down('#completionDocumentGridId');
        				this.loadStudentDocument(grid);
        				break;
        			}
        			/*case 'termination_checkList':{
	    				var itemSelector = tabPanel.down('#checkListSelector');
	    				this.loadCheckListCombo(itemSelector);
	    				break;
        			}*/
        		}
        		},
        		afterrender:function(structure){
        			structure.down('#byPassPendingCheck').setVisible(false);
        			structure.down('#byPassPendingBtn').setVisible(false);
        		}
        	},
        	
        	/* to load transfer tab panel*/ 
        	
        	'transfertabpanel' : {
        		tabchange : function(tabPanel, newCard, oldCard, eOpts ){
        			var tab = tabPanel.activeTab.itemId ;
        			var admissionId = this.getContentPanel().getActiveTab().getAdmissionId();
        			switch(tab){
        			case 'transferGeneralFormId': {
        				var tabName = 'transfergeneralform';
        	    		var btnItemId = '#transferGeneralSubmitBtn';
        				this.disableAllButtonLessEffectiveDate(tabPanel,tabName,btnItemId);
        				break;
         			
        			}
        			case 'transfer_pending_payments' :{
        				
        				var grid = tabPanel.down('#completionpendingBillGrid');
        				this.loadCompletionPendingBillGridData(grid, admissionId);
        				break;
        			}
        			case 'transfer_pending_refunds' :{
        				
        				var grid = tabPanel.down('#completionPendingPaymentgrid');
        				this.loadCompletionPendingRefundsGridData(grid, admissionId);
        				break;
        			}
        			case 'transfer_pending_refundables' :{
        				
        				var grid = tabPanel.down('#completionPendingRefundablesBillGrid');
        				this.loadCompletionPendingRefundablesGridData(grid, admissionId);
            			break;
        			}
        			case 'transfer_issue_certificate' :{
        				
        				var grid = tabPanel.down('#issueCertificatesGridId');
        				this.loadIssueGrid(grid);
            			break;
        			}
        			case 'transfer_document':{
        				
        				var grid = tabPanel.down('#completionDocumentGridId');
        				this.loadStudentDocument(grid);
        				break;
        				}
        			/*case 'transfer_checkList':{
	    				var itemSelector = tabPanel.down('#checkListSelector');
	    				this.loadCheckListCombo(itemSelector);
	    				break;
        			}*/
        			}
        		},
        		afterrender:function(structure){
        			var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
        			this.getPayementBypassStatus(structure,completionId);
        		}
        	},
        	
        	/* withdraw from Program tab */
        	
        	'withdrawprogramtabpanel' : {
        		tabchange : function(tabPanel, newCard, oldCard, eOpts ){
        			var tab = tabPanel.activeTab.itemId ;
        			var admissionId = this.getContentPanel().getActiveTab().getAdmissionId();
        			switch(tab){
        			case 'withPGeneralId': {
        				var tabName = 'withdrawfromprogramgeneralform';
        	    		var btnItemId = '#withdrawGeneralSubmitBtn';
        				this.disableAllButtonLessEffectiveDate(tabPanel,tabName,btnItemId);
        				break;
        			}
        			case 'withP_pending_payments' :{
        				
        				var grid = tabPanel.down('#completionpendingBillGrid');
        				this.loadCompletionPendingBillGridData(grid, admissionId);
        				break;
        			}
        			case 'withP_pending_refunds' :{
        				
        				var grid = tabPanel.down('#completionPendingPaymentgrid');
        				this.loadCompletionPendingRefundsGridData(grid, admissionId);
        				break;
        			}
        			case 'withP_pending_refundables' :{
        				
        				var grid = tabPanel.down('#completionPendingRefundablesBillGrid');
        				this.loadCompletionPendingRefundablesGridData(grid, admissionId);
            			break;
        			}
        			case 'withP_issue_certificate' :{
        				
        				var grid = tabPanel.down('#issueCertificatesGridId');
        				this.loadIssueGrid(grid);
            			break;
        			}
        			case 'withP_document':{
        				
        				var grid = tabPanel.down('#completionDocumentGridId');
        				this.loadStudentDocument(grid);
        				break;
        			}
        			/*case 'withP_checkList':{
	    				var itemSelector = tabPanel.down('#checkListSelector');
	    				this.loadCheckListCombo(itemSelector);
	    				break;
        			}*/
        			}
        			
        		},
        		afterrender:function(structure){
        			this.disableWithDrawAndPassOutBypassButtonsPivileges(structure, this.getCOMPLETION_WITHDRAW_PERMISSION());
        			var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
        			this.getPayementBypassStatus(structure,completionId);
        		}
        	},

            /* To change Status on click of Mark as Complete */
            'passingouttabpanel issuecertificatesform[itemId=completion_issue_certificate] button[itemId=markAsComplete]': {
                click: this.markAsComplete
            },
            'terminationtabpanel issuecertificatesform[itemId=termination_issue_certificate] button[itemId=markAsComplete]': {
                click: this.markAsComplete
            },
            'transfertabpanel issuecertificatesform[itemId=transfer_issue_certificate] button[itemId=markAsComplete]': {
                click: this.markAsComplete
            },
            'withdrawprogramtabpanel issuecertificatesform[itemId=withP_issue_certificate] button[itemId=markAsComplete]': {
                click: this.markAsComplete
            },
            
		 	/* Print Certificate functionality on click of send Message Button */
           'passingouttabpanel issuecertificatesform[itemId=completion_issue_certificate] button[itemId=printCertificateBtn]': {
                click:function(button){
                	this.printCertificate(button,null,null);
                }	
            },
            'terminationtabpanel issuecertificatesform[itemId=termination_issue_certificate] button[itemId=printCertificateBtn]': {
            	  click:function(button){
                  	this.printCertificate(button,null,null);
                  }	
            },
            'transfertabpanel issuecertificatesform[itemId=transfer_issue_certificate] button[itemId=printCertificateBtn]': {
            	  click:function(button){
                  	this.printCertificate(button,null,null);
                  }	
            },
            'withdrawprogramtabpanel issuecertificatesform[itemId=withP_issue_certificate] button[itemId=printCertificateBtn]': {
            	  click:function(button){
                  	this.printCertificate(button,null,null);
                  }	
            },
           
            
            /* Send message functionality on click of send Message Button */
            
            'passingouttabpanel issuecertificatesform[itemId=completion_issue_certificate] button[itemId=sendMessageBtn]': {
                click:function(button){
                	this.sendMessage(button,null,null);
                }	
            },
            'passingouttabpanel pendingpaymentform[itemId=completion_pending_payments] button[itemId=sendMessageBtn]': {
                click:function(button){
                	this.sendMessage(button,null,null);
                }	
            },
            'passingouttabpanel pendingrefundablesform[itemId=completion_pending_refundables] button[itemId=sendMessageBtn]': {
                click:function(button){
                	this.sendMessage(button,null,null);
                }	
            },
            'passingouttabpanel documentform[itemId=completion_document] button[itemId=sendMessageBtn]': {
                click:function(button){
                	this.sendMessage(button,null,null);
                }	
            },
            'passingouttabpanel documentform[itemId=completion_document] button[itemId=sendNotificationBtn]': {
                click:function(button){
                	this.sendNotification(button,null,null);
                }	
            },
            'terminationtabpanel issuecertificatesform[itemId=termination_issue_certificate] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
            		this.openTermisionSendMessage(button);
                }	
            },
            'terminationtabpanel pendingpaymentform[itemId=termination_pending_payments] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
            		this.openTermisionSendMessage(button);
                }	
            },
            'terminationtabpanel pendingrefundablesform[itemId=termination_pending_refundables] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
            		this.openTermisionSendMessage(button);
                }	
            },
            'terminationtabpanel documentform[itemId=termination_document] button[itemId=sendMessageBtn]': {
                click:function(button){
                	//this.sendMessage(button,null,null);
                	this.openTermisionSendMessage(button);
                }	
            },
            'terminationtabpanel documentform[itemId=termination_document] button[itemId=sendNotificationBtn]': {
                click:function(button){
                	this.sendNotification(button,null,null);
                }	
            },
            'transfertabpanel issuecertificatesform[itemId=transfer_issue_certificate] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
                	this.openTermisionSendMessage(button);
                }	
            },
            'transfertabpanel pendingpaymentform[itemId=transfer_pending_payments] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
                	this.openTermisionSendMessage(button);
                }	
            },
            'transfertabpanel pendingrefundablesform[itemId=transfer_pending_refundables] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
                	this.openTermisionSendMessage(button);
                }	
            },
            'transfertabpanel documentform[itemId=transfer_document] button[itemId=sendMessageBtn]': {
                click:function(button){
                	//this.sendMessage(button,null,null);
                	this.openTermisionSendMessage(button);
                }	
            },
            'transfertabpanel documentform[itemId=transfer_document] button[itemId=sendNotificationBtn]': {
                click:function(button){
                	this.sendNotification(button,null,null);
                }	
            },
            'withdrawprogramtabpanel issuecertificatesform[itemId=withP_issue_certificate] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
            		this.openTermisionSendMessage(button);
                }	
            },
            'withdrawprogramtabpanel pendingpaymentform[itemId=withP_pending_payments] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
            		this.openTermisionSendMessage(button);
                }	
            },
            'withdrawprogramtabpanel pendingrefundablesform[itemId=withP_pending_refundables] button[itemId=sendMessageBtn]': {
            	click:function(button){
                	//this.sendMessage(button,null,null);
            		this.openTermisionSendMessage(button);
                }	
            },
            'withdrawprogramtabpanel documentform[itemId=withP_document] button[itemId=sendMessageBtn]': {
                click:function(button){
                	//this.sendMessage(button,null,null);
                	this.openTermisionSendMessage(button);
                }	
            },
            'withdrawprogramtabpanel documentform[itemId=withP_document] button[itemId=sendNotificationBtn]': {
                click:function(button){
                	this.sendNotification(button,null,null);
                }	
            },
            
            /* Email Certificate functionality on click of send Message Button */
            // Removed buttons V2D-380420
            'passingouttabpanel issuecertificatesform[itemId=completion_issue_certificate] button[itemId=emailCertificateBtn]': {
                click:function(button){
                	this.emailCertificate(button,null,null);
                }	
            },
            'terminationtabpanel issuecertificatesform[itemId=termination_issue_certificate] button[itemId=emailCertificateBtn]': {
            	 click:function(button){
                 	this.emailCertificate(button,null,null);
                 }	
            },
            'transfertabpanel issuecertificatesform[itemId=transfer_issue_certificate] button[itemId=emailCertificateBtn]': {
            	 click:function(button){
                 	this.emailCertificate(button,null,null);
                 }	
            },
            'withdrawprogramtabpanel issuecertificatesform[itemId=withP_issue_certificate] button[itemId=emailCertificateBtn]': {
            	 click:function(button){
                 	this.emailCertificate(button,null,null);
                 }	
            },

            /* To load ChekList Item Selector & To Update Check List */

            'checklistform[itemId=checkListCompletion] itemselector[itemId=checkListSelector]': {
                render: this.loadCheckListCombo
            },
            'checklistform[itemId=termination_checkList] itemselector[itemId=checkListSelector]': {
                render: this.loadCheckListCombo
            },
            'checklistform[itemId=transfer_checkList] itemselector[itemId=checkListSelector]': {
                render: this.loadCheckListCombo
            },
            'checklistform[itemId=withP_checkList] itemselector[itemId=checkListSelector]': {
                render: this.loadCheckListCombo
            },
            
            'passingouttabpanel checklistform[itemId=checkListCompletion] button[itemId=completionCheckListUpdateBtn]': {
                click: this.updateCheckList
            },
            'terminationtabpanel checklistform[itemId=termination_checkList] button[itemId=completionCheckListUpdateBtn]': {
                click: this.updateCheckList
            },
            'transfertabpanel checklistform[itemId=transfer_checkList] button[itemId=completionCheckListUpdateBtn]': {
                click: this.updateCheckList
            },
            'withdrawprogramtabpanel checklistform[itemId=withP_checkList] button[itemId=completionCheckListUpdateBtn]': {
                click: this.updateCheckList
            },
            
          
            'checklistform': {
                render: this.loadSelectedChekList
            },
            
            /* Document tab function */
            'completiondocumentgrid #btnEditCompletionDoc' :{
            	click: function(){
            		var isView = false;
            		this.editCompletionDoc(isView);
            	}
            },
            'completiondocumentgrid #btnViewCompletionDoc' :{
            	click: function(){
            		var isView = true;
            		this.editCompletionDoc(isView);
            	}
            },
            'completiondocumentgrid #btnAddCompletionDoc' :{
            	click: function(){
            		this.showDocumentFormWindowPopUp();
            	}
            },
            'completiondocumentgrid #btnDeleteCompletionDoc': {
            	click: function(){
            		this.deleteDocumentRecord();
            	}
            },
            
            'documentformwindow[itemId=completionDocForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
            	click: function(){
            		this.closeDocumentWindow();
            	}
            },
            'documentformwindow[itemId=completionDocForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
            	click: function(){
            		this.saveCompletionDocumentForm();
            	}
            },
         /*   'completiondocumentgrid':{
            	render:this.loadStudentDocument
            },*/
            'passingoutprofileview' : {
            	afterrender: function(view){
            		this.setProfileView(view,null);
            	} 
            },
            
            /* Effective date functionality */
        		 'tempterminationtabpanel' : {
             		tabchange : function(tabPanel, newCard, oldCard, eOpts ){
             			var tab = tabPanel.activeTab.itemId ;
             			if(tab === 'tempTerminationGeneralId'){
             				var dateField = tabPanel.activeTab.down('#startDate');
             				var submitBtn = tabPanel.activeTab.down('#generalSubmitBtn');
             				this.enableSubmitBtn(dateField,submitBtn);
             				var tillDate = tabPanel.activeTab.down('#endDate');
             				tillDate.setDisabled(false);
             				}
             			},
             			render : function(tabPanel){
                			var dateField = tabPanel.activeTab.down('#startDate');
            				var submitBtn = tabPanel.activeTab.down('#generalSubmitBtn');
                			this.enableSubmitBtn(dateField,submitBtn);
                			var tillDate = tabPanel.activeTab.down('#endDate');
             				tillDate.setDisabled(false);
                		}
             	},
             
             		/* check List cell click */
             		
             		'passingoutgrid': {
                     	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
                     		var searchGrid = this.getPassingoutgrid();
                     		var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                     	    if (e.target.tagName == 'A' && columnName === "checkList") {
                            this.showPassoutCheckList(searchGrid);
                     	    } else if(e.target.tagName == 'A' && columnName === "feeDues") {
                     	    	this.showPassoutPendingFees(searchGrid);
                     	    }else if(e.target.tagName == 'A' && columnName === "certificate") {
                     	    	this.showPassoutCeritificate(searchGrid);
                     	    }
                     	},
                     	selectionchange: function(view,rec){
                     		var searchGrid = this.getPassingoutgrid();
                     		var publishCertificateBtn  = searchGrid.down('#publishGraduationCertificate');
                     		var enablePublishButton = false;
                     		var rejectBtn  = searchGrid.down('#rejectBtnId');
                     		
                     		var anyReject = false;
                     		var anyPending = false;
                     		var anyPassout = false;
                     		
                     		if(rec.length > 0){
                     			for(var i=0;i< rec.length;i++){
                     				if(rec[i].data.status == "REJECTED" ){
                     					anyReject = true;
                     					break;
                     				}
                     				
                     				if(rec[i].data.status == "PASSED_OUT" ){
                     					anyPassout = true;
                     				}
                     				
                     				if(rec[i].data.status == "PENDING" || rec[i].data.status == "IN_PROCESS")
                     				{
                     					anyPending = true;
                     				}
                     			}
                     			
                     			if(anyReject){
                     				searchGrid.down('#updateButtonId').disable();
                 					searchGrid.down('#spBtnMoreActions').disable();
                 					searchGrid.down('#certificateBtnId').disable();
                 					publishCertificateBtn.disable();
                 					rejectBtn.disable();
                     			}
                     			
                     			if(anyPassout){
                     				if(!anyReject){
                     					searchGrid.down('#updateButtonId').enable();
                     					searchGrid.down('#spBtnMoreActions').enable();
                     					searchGrid.down('#certificateBtnId').enable();
                     					publishCertificateBtn.enable();
                     					rejectBtn.disable();
                     				}
                     			}
                     			if(anyPending){
                     				if(!anyReject && !anyPassout){
                     					searchGrid.down('#updateButtonId').enable();
                     					searchGrid.down('#spBtnMoreActions').enable();
                     					searchGrid.down('#certificateBtnId').enable();
                     					publishCertificateBtn.disable();
                     					rejectBtn.enable();
                     				}
                     			}
                     		}else{
                     			searchGrid.down('#updateButtonId').enable();
             					searchGrid.down('#spBtnMoreActions').enable();
             					searchGrid.down('#certificateBtnId').enable();
             					publishCertificateBtn.enable();
             					rejectBtn.disable(); 
                     		}
                     		
                     	/*	if(rec.length > 0){
                     			for(var i=0;i< rec.length;i++){
                     				if(!isNullOrEmpty(rec[i].raw.passOutPath) && rec[i].data.status == "PASSED_OUT" ){
                     					enablePublishButton = true
                     				}else{
                     					var enablePublishButton = false;
                     					break;
                     				}
                     			}
                     			if(enablePublishButton){
                     				publishCertificateBtn.enable();
                     			}else{
                     				publishCertificateBtn.disable();
                     			}
                     		}else{
                     			publishCertificateBtn.disable();
                     		}

                 			
                     		if(rec.length > 0) {
                     			var disableRejectBtn = false;
                     			for(var i=0;i< rec.length;i++){
                     				if(rec[i].data.status == "PASSED_OUT" ){
                     					disableRejectBtn = true;
                     					break;
                     				}
                     			}
                     			rejectBtn.setDisabled(disableRejectBtn);
                     		}
                     		else {
                     			rejectBtn.disable();
                     		}
                     		
                     		if(rec.length > 0) {
                     			for(var i=0;i< rec.length;i++){
                     				if(rec[i].data.status == "REJECTED" ){
                     					searchGrid.down('#updateButtonId').disable();
                     					searchGrid.down('#spBtnMoreActions').disable();
                     					searchGrid.down('#certificateBtnId').disable();
                     					publishCertificateBtn.disable();
                     					rejectBtn.disable();
                     					break;
                     				}else{
                     					if(rec[i].data.status == "PASSED_OUT"){
                     					searchGrid.down('#updateButtonId').enable();
                     					searchGrid.down('#spBtnMoreActions').enable();
                     					searchGrid.down('#certificateBtnId').enable();
                     					publishCertificateBtn.enable();
                     					rejectBtn.disable();
                     					break;
                     					}else{
                     						searchGrid.down('#updateButtonId').enable();
                         					searchGrid.down('#spBtnMoreActions').enable();
                         					searchGrid.down('#certificateBtnId').enable();
                         					publishCertificateBtn.enable();
                         					rejectBtn.enable();
                     						
                     					}
                     				}
                     			}
                     		}else{
                     			searchGrid.down('#updateButtonId').enable();
             					searchGrid.down('#spBtnMoreActions').enable();
             					searchGrid.down('#certificateBtnId').enable();
             					publishCertificateBtn.enable();
             					rejectBtn.disable(); 
                     		}*/
                     	},
                     	afterrender:function(grid){
                     		this.hidePublishGraduationCertificateButton(grid,this.getCOMPLETION_PASSING_OUT_PERMISSION())
                     	}
                     },
                     'passingoutgrid menuitem[itemId=checkEligibilityButtonId]':{
            			 click:this.checkEligibility
            		 },
            		 'passingoutgrid menuitem[itemId=printCertificateButtonId]':{
            			 click:this.exportPrintCertificates
            		 },
            		 'passingoutgrid menuitem[itemId=emailCertificateButtonId]':{
            			 //click:this.emailCertificates
            			 click: function(btn){
								this.openPrintEmailDocWindow(btn);
							}
            		 },
            		 'passingoutgrid button[itemId=publishGraduationCertificate]':{
            			 click:this.publishGraduationCertificate
            		 },
            		 'passingoutgrid menuitem[itemId=markCompleteButtonId]':{
            			 click:this.markCompleteCompletion
            		 },
            		 'passingoutgrid button[itemId=certificateBtnId]': {
            			 //click:this.exportCompletionCertificate
            			 click: this.openPrintCertificateWindow
                	 },
                     'terminationpanel searchresultgrid[itemId=terminationSearchResultGrid]': {
                      	cellclick: function(grid, td, cellIndex, record){
                      		var searchGrid = this.getTerminationSearchResultGrid();
                      		var columnName = searchGrid.columnManager.columns[cellIndex].dataIndex;
                      	    if (columnName === "CHECKLIST") {
                             this.showPendingItems(searchGrid);
                      	    }
                      	}
                      },
                      'temporaryterminationpanel searchresultgrid[itemId=temporaryTerminationSearchResultGrid]': {
                       	cellclick: function(grid, td, cellIndex, record){
                       		var searchGrid = this.getTemporaryTerminationSearchResultGrid();
                       		var columnName = searchGrid.columnManager.columns[cellIndex].dataIndex;
                       	    if (columnName === "CHECKLIST") {
                              this.showPendingItems(searchGrid);
                       	    }
                       	    else if(columnName == "DEBARMENT_REASONS"){
                       	    	var selectedRecord = searchGrid.getSelectionModel().getSelection()[0];
                       	    	if(parseInt(selectedRecord.get('DEBARMENT_REASONS')) > 0){
                           	    	this.showDebarmentReasonsWindow(grid);
                       	    	}
                       	    }
                       	}
                       },
                       'debarmentreasonswindow':{
                    	   afterrender: function(win){
                    		   var winGrid = win.down('#debarmentReasonsListDetailGrid');
                    		   var winGridStore = winGrid.getStore();
                    		   winGridStore.removeAll();
                    		   
                    		   var searchGrid = this.getTemporaryTerminationSearchResultGrid();
                    		   var selectedRecord = searchGrid.getSelectionModel().getSelection()[0];
                    		   
                    		   var serviceRequestId = selectedRecord.get('SERVICE_REQUEST_ID');
                    		   
                    		   winGridStore.getProxy().extraParams = {
                    			   serviceRequestId: serviceRequestId
                    		   }
                    		   
                    		   winGridStore.load();
                    	   }
                       },
                       'transferpanel searchresultgrid[itemId=transferSearchResultGrid]': {
                        	cellclick: function(grid, td, cellIndex, record){
                        		var searchGrid = this.getTransferSearchResultGrid();
                        		var columnName = searchGrid.columnManager.columns[cellIndex].dataIndex;
                        	    if (columnName === "CHECKLIST") {
                               this.showPendingItems(searchGrid);
                        	    }
                        	}
                        },
                        'withdrawalfromprogrampanel searchresultgrid[itemId=withdrawalFromProgramSearchResultGrid]': {
                         	cellclick: function(grid, td, cellIndex, record){
                         		var searchGrid = this.getWithdrawalProgramSearchResultGrid();
                         		var columnName = searchGrid.columnManager.columns[cellIndex].dataIndex;
                         	    if (columnName === "CHECKLIST") {
                                this.showPendingItems(searchGrid);
                         	    }
                         	}
                         },
                        'completionpendingpaymentgrid[itemId=completionPendingPaymentgrid]': {
                             cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
                            	 var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
                            	 if(cellDataIndex == "voucherMode"){
                            		 var grid = view.up('grid');
                            		 this.viewRefundHistoryInstrumentDetails(grid, 'paymentheaderinstrumentadjustmentdetailsgridwindow', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
                                 }
                          		
                             }
                         },
                         'issuecertificatesgrid actioncolumn#actionItemId':{
                        	 click: function(grid,cell,row,col,e){
                        		 var rec = grid.getStore().getAt(row);
                        		 var m = e.getTarget().className;
                        		 if(m === 'x-action-col-icon x-action-col-0   export-pdf-icon'){
                        		 }else if(m === 'x-action-col-icon x-action-col-2   export-pdf-icon'){
                        			 this.printCertificate(null,grid,rec);
                        		 }
                        	 }
                         },
                         /*START :- added for adhoc messaging*/
                	        'terminationsendmessages[itemId=terminationSendMsgID] radiogroup[itemId=messageType]':{
                	        	change : function(val,nV,oV){
                	        		this.selectTermisionSectionMessageType(val,nV,oV);
                	        	}
                	        },
                	        'terminationsendmessages[itemId=terminationSendMsgID] customcombobox[itemId=msgTempletId]':{
                	        	select : function(obj,rec){
                	        		this.selectTermisionMessageTemp(obj,rec);
                	        	}
                	        },
                	        'terminationsendmessages[itemId=terminationSendMsgID] button[itemId=adhocMsgSubmitBtn]':{
                	        	click: function(obj) {
                	        		//var grid = this.getIssuecertificatesgrid();
                	        		var admissionId = this.getCompletionPanel().getAdmissionId();
                	        		var placementSendMessage = this.getTerminationsendmessages();
                	        		placementSendMessage.placementSendMessage(obj,admissionId);
                	        	}
                	        },
                	        'terminationsendmessages[itemId=terminationSendMsgID] filefield[itemId=staticUploadFileField]': {
                	        	change: function(fileField, value, eOpts){
                	        		var this$ = this;
                	        		this$.uploadTermisionStaticDocumentFileMessage(fileField, value, eOpts);
                	        	}
                	        },
                	        'terminationsendmessages[itemId=terminationSendMsgID]': {
                	        	render: function(grid){
                	        		var this$ = this;
                	        		var docGrid = grid.down('#terminationStaticDocumentAttachmentGridMessage');
                	        		docGrid.getStore().removeAll();
                	        		docGrid.getStore().sync();
                	        	}
                	        }, 
                	        'terminationsendmessages[itemId=terminationSendMsgID] radiogroup#sendingPriority': {
                	        	change: function( radio, newValue, oldValue, eOpts) {
                	        		this.loadTermisionScheduleField(radio, newValue, oldValue);
                	        	}
                	        },
                	        'terminationstaticdocumentattachmentgrid[itemId=terminationStaticDocumentAttachmentGridMessage] actioncolumn': {
                	        	click : function(view, rowIndex, colIndex, item, e, record, row){
                	        		this.deleteTermisionStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
                	        	}
                	        },
                	        /*V2D-13247*/
                	        'terminationsendmessages[itemId=terminationSendMsgID] textarea[itemId=smsDiscription]':{
                	        	change : function(val,nV,oV){
                	        		var terminationSendMessages = this.getTerminationsendmessages();
                	        		var smsTextField = terminationSendMessages.down('#smsDiscription');
                	        		var smsTextFieldDiscription = terminationSendMessages.down('#smsDiscriptionNotice');            				
                	        		var newValue = 160 - smsTextField.getValue().length;
                	        		smsTextFieldDiscription.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+newValue+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE_NUMBER')+'</span>');							
                	        	}
                	        },
                	        /*END :- added for adhoc messaging*/
                	        'completiondetailwindow checkboxfield[itemId=markCheckListComplete]': {
                                change: function(field,newVal){
                                	var form = this.getCompletiondetailwindow();
                                	/*	
                                	if(form.down('#markCheckListComplete').getValue() && form.down('#markCertificateComplete').getValue()) {
                                	    form.down('#effectiveTrasferDate').setVisible(true);
                                	    this.setAllowBlank(form.down('#effectiveTrasferDate'), false);
                                	    form.down('form').getForm().isValid();
                                	    form.down('form').getForm().clearInvalid();
                                	} else {
                                		form.down('#effectiveTrasferDate').setVisible(false);
                                		this.setAllowBlank(form.down('#effectiveTrasferDate'), true);
                                		form.down('form').getForm().isValid();
                                		form.down('#effectiveTrasferDate').reset();
                                		form.down('form').getForm().clearInvalid();
                                	}*/
                                	// this.getValidateFields(form,field,newVal);    // Commented for V2D-444958
                                	
                                }
                            },
                	        'completiondetailwindow checkboxfield[itemId=markCertificateComplete]': {
                                change: function(field,newVal){
                                	var form = this.getCompletiondetailwindow();
                                	
                                	/*if(form.down('#markCheckListComplete').getValue() && form.down('#markCertificateComplete').getValue()) {
                                	    form.down('#effectiveTrasferDate').setVisible(true);
                                	    this.setAllowBlank(form.down('#effectiveTrasferDate'), false);
                                	    form.down('form').getForm().isValid();
                                	    form.down('form').getForm().clearInvalid();
                                	} else {
                                		form.down('#effectiveTrasferDate').setVisible(false);
                                		this.setAllowBlank(form.down('#effectiveTrasferDate'), true);
                                		form.down('form').getForm().isValid();
                                		form.down('#effectiveTrasferDate').reset();
                                		form.down('form').getForm().clearInvalid();
                                	}*/
                                	// this.getValidateFields(form,field,newVal);     // Commented for V2D-444958
                                }
                            },
                            
                            'completiondetailwindow textfield[itemId=decisionNumber]': {
                                change: function(field,newVal){
                                	var form = this.getCompletiondetailwindow();
                                	
                                	// this.getValidateFields(form,field,newVal);   // Commented for V2D-444958
                                }
                            },
                            'completiondetailwindow datefield[itemId=effectiveTrasferDate]': {
                                change: function(field,newVal){
                                	var form = this.getCompletiondetailwindow();
                                	
                                	//this.getValidateFields(form,field,newVal);     // Commented for V2D-444958
                                }
                            },
                            
                            'completiondetailwindow button[itemId=completeCompletionSaveItemId]': {
                                click: this.completeCompletionProcess
                            },
                            'completiondetailwindow button[itemId=completeCompletionCancelItemId]': {
                            	click: function(){
                                	var form = this.getCompletiondetailwindow();
                                	form.close();
                                }
                            },
                            'transfertabpanel pendingpaymentform[itemId=transfer_pending_payments] checkbox[itemId=byPassPendingCheck]':{
                            	change:function(checkbox, newValue, oldValue, eOpts ){
                            		var byPassPendingPaymentBtn =checkbox.up().up().down('#byPassPendingBtn');
                            		var grid = checkbox.up().up().down('#completionpendingBillGrid');
                            		if(newValue == true && grid.getStore().data.items.length>0 && isPaymentByPassDone==false){
                            			byPassPendingPaymentBtn.setDisabled(false);
                            		}
                            		else{
                            			byPassPendingPaymentBtn.setDisabled(true);
                            		}
                            	}
                            },
                            'withdrawprogramtabpanel pendingrefundablesform[itemId=withP_pending_refundables] checkbox[itemId=byPassPendingRefCheck]':{
                            	change:function(checkbox, newValue, oldValue, eOpts ){
                            		var byPassPendingPaymentBtn =checkbox.up().up().down('#byPassPendingRefBtn');
                            		var grid = checkbox.up().up().down('#completionPendingRefundablesBillGrid');
                            		if(newValue == true && grid.getStore().data.items.length>0 && isRefundableByPassDone==false){
                            			byPassPendingPaymentBtn.setDisabled(false);
                            		}
                            		else{
                            			byPassPendingPaymentBtn.setDisabled(true);
                            		}
                            	}
                            },
                            'withdrawprogramtabpanel pendingrefundablesform[itemId=withP_pending_refundables] button[itemId=byPassPendingRefBtn]':{
                            	click:function(btn){
                            		var whetherByPassRefPayments = btn.up().up().down('#byPassPendingRefCheck').getValue();
                            		var byPassPendingRefBtn = btn.up().up().down('#byPassPendingRefBtn');
                            		var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
                            		showConfirmMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('ARE_YOU_SURE_YOU_WANT_TO_BYPASS_PENDING_REFUNDABLE_VALIDATION'),function(btn,text){
                    	    			if (btn == 'yes') {
                    	    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    	    				Ext.Ajax.request({
                    	    					method : "GET",
                    	    					type : 'rest',
                    	    					url : SERVERURL.UPDATE_BYPASS_PENDING_PAYMENTS_AND_REFUNDS,
                    	    					params: {
                    								id: completionId,
                    								whetherByPassPendingRefunds:whetherByPassRefPayments
                    							},
                    	    					success : function(form,action) {
                    	    						Ext.getBody().unmask();
                    	    							//grid.getStore().reload();
                    	    						isRefundableByPassDone=true;
                    	    						    byPassPendingRefBtn.setDisabled(true); 
                    	    							showSuccessMessage(getCompletionModuleTranslation('WITHDRAW_DETAILS'),getCompletionModuleTranslation('PENDING_REFUND_BYPASSED_SUCCESSFULLY'));
                    	    					}
                    	    				});
                    	    			}
                    	    		});
                            	},
                            },
                            'withdrawprogramtabpanel pendingpaymentform[itemId=withP_pending_payments] checkbox[itemId=byPassPendingCheck]':{
                            	change:function(checkbox, newValue, oldValue, eOpts ){
                            		var byPassPendingPaymentBtn =checkbox.up().up().down('#byPassPendingBtn');
                            		var grid = checkbox.up().up().down('#completionpendingBillGrid');
                            		if(newValue == true && grid.getStore().data.items.length>0 && isPaymentByPassDone==false){
                            			byPassPendingPaymentBtn.setDisabled(false);
                            		}
                            		else{
                            			byPassPendingPaymentBtn.setDisabled(true);
                            		}
                            	}
                            },
                            'withdrawprogramtabpanel pendingpaymentform[itemId=withP_pending_payments] button[itemId=byPassPendingBtn]':{
                            	click:function(btn){
                            		var whetherByPassPayments = btn.up().up().down('#byPassPendingCheck').getValue();
                            		var byPassPendingBtn = btn.up().up().down('#byPassPendingBtn');
                            		var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
                            		showConfirmMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('ARE_YOU_SURE_YOU_WANT_TO_BYPASS_PENDING_PAYMENT_VALIDATION'),function(btn,text){
                    	    			if (btn == 'yes') {
                    	    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    	    				Ext.Ajax.request({
                    	    					method : "GET",
                    	    					type : 'rest',
                    	    					url : SERVERURL.UPDATE_BYPASS_PENDING_PAYMENTS_AND_REFUNDS, 
                    	    					params: {
                    								id: completionId,
                    								whetherByPassPendingPayments:whetherByPassPayments
                    							},
                    	    					success : function(form,action) {
                    	    						Ext.getBody().unmask();
                    	    							//grid.getStore().reload();
                    	    						byPassPendingBtn.setDisabled(true);
                    	    						isPaymentByPassDone=true;
                    	    							showSuccessMessage(getCompletionModuleTranslation('WITHDRAW_DETAILS'),getCompletionModuleTranslation('PENDING_PAYMENTS_BYPASSED_SUCCESSFULLY'));
                    	    					}
                    	    				});
                    	    			}
                    	    		});
                            	},
                            	
                            },
                            
                            'passingouttabpanel pendingrefundablesform[itemId=completion_pending_refundables] checkbox[itemId=byPassPendingRefCheck]':{
                            	change:function(checkbox, newValue, oldValue, eOpts ){
                            	    var byPassPendingPaymentBtn =checkbox.up().up().down('#byPassPendingRefBtn');
                            		var grid = checkbox.up().up().down('#completionPendingRefundablesBillGrid');
                            		if(newValue == true && grid.getStore().data.items.length>0 && isRefundableByPassDone==false){
                            			byPassPendingPaymentBtn.setDisabled(false);
                            		}
                            		else{
                            			byPassPendingPaymentBtn.setDisabled(true);
                            		}
                            	}
                            },
                            'passingouttabpanel pendingrefundablesform[itemId=completion_pending_refundables] button[itemId=byPassPendingRefBtn]':{
                            	click:function(btn){
                            		var whetherByPassRefPayments = btn.up().up().down('#byPassPendingRefCheck').getValue();
                            		var byPassPendingRefBtn = btn.up().up().down('#byPassPendingRefBtn');
                            		var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
                            		showConfirmMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('ARE_YOU_SURE_YOU_WANT_TO_BYPASS_PENDING_REFUNDABLE_VALIDATION'),function(btn,text){
                    	    			if (btn == 'yes') {
                    	    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    	    				Ext.Ajax.request({
                    	    					method : "GET",
                    	    					type : 'rest',
                    	    					url : SERVERURL.UPDATE_BYPASS_PENDING_PAYMENTS_AND_REFUNDS,
                    	    					params: {
                    								id: completionId,
                    								whetherByPassPendingRefunds:whetherByPassRefPayments
                    							},
                    	    					success : function(form,action) {
                    	    						Ext.getBody().unmask();
                    	    							//grid.getStore().reload();
                    	    					     	byPassPendingRefBtn.setDisabled(true);
                    	    					     	isRefundableByPassDone=true;
                    	    							showSuccessMessage(getCompletionModuleTranslation('WITHDRAW_DETAILS'),getCompletionModuleTranslation('PENDING_REFUND_BYPASSED_SUCCESSFULLY'));
                    	    					}
                    	    				});
                    	    			}
                    	    		});
                            	},
                            },
                            'passingouttabpanel pendingpaymentform[itemId=completion_pending_payments] checkbox[itemId=byPassPendingCheck]':{
                            	change:function(checkbox, newValue, oldValue, eOpts ){
                            	var byPassPendingPaymentBtn =checkbox.up().up().down('#byPassPendingBtn');
                            		var grid = checkbox.up().up().down('#completionpendingBillGrid');
                            		if(newValue == true && grid.getStore().data.items.length>0 && isPaymentByPassDone==false){
                            			byPassPendingPaymentBtn.setDisabled(false);
                            		}
                            		else{
                            			byPassPendingPaymentBtn.setDisabled(true);
                            		}
                            	}
                            },
                            'passingouttabpanel pendingpaymentform[itemId=completion_pending_payments] button[itemId=byPassPendingBtn]':{
                            	click:function(btn){
                            		var whetherByPassPayments = btn.up().up().down('#byPassPendingCheck').getValue();
                            		var byPassPendingBtn = btn.up().up().down('#byPassPendingBtn');
                            		var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
                            		showConfirmMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('ARE_YOU_SURE_YOU_WANT_TO_BYPASS_PENDING_PAYMENT_VALIDATION'),function(btn,text){
                    	    			if (btn == 'yes') {
                    	    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    	    				Ext.Ajax.request({
                    	    					method : "GET",
                    	    					type : 'rest',
                    	    					url : SERVERURL.UPDATE_BYPASS_PENDING_PAYMENTS_AND_REFUNDS,
                    	    					params: {
                    								id: completionId,
                    								whetherByPassPendingPayments:whetherByPassPayments
                    							},
                    	    					success : function(form,action) {
                    	    						Ext.getBody().unmask();
                    	    							//grid.getStore().reload();
                    	    						    byPassPendingBtn.setDisabled(true);
                    	    						    isPaymentByPassDone=true;
                    	    							showSuccessMessage(getCompletionModuleTranslation('WITHDRAW_DETAILS'),getCompletionModuleTranslation('PENDING_PAYMENTS_BYPASSED_SUCCESSFULLY'));
                    	    					}
                    	    				});
                    	    			}
                    	    		});
                            	},
                            	
                            },
                            'transfertabpanel pendingpaymentform[itemId=transfer_pending_payments] button[itemId=byPassPendingBtn]':{
                            	click:function(btn){
                            		var whetherByPassPayments = btn.up().up().down('#byPassPendingCheck').getValue();
                            		var byPassPendingBtn = btn.up().up().down('#byPassPendingBtn');
                            		var  completionId = this.getContentPanel().getActiveTab().getCompletionId();
                            		showConfirmMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('ARE_YOU_SURE_YOU_WANT_TO_BYPASS_PENDING_PAYMENT_VALIDATION'),function(btn,text){
                    	    			if (btn == 'yes') {
                    	    				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                    	    				Ext.Ajax.request({
                    	    					method : "GET",
                    	    					type : 'rest',
                    	    					url : SERVERURL.UPDATE_BYPASS_PENDING_PAYMENTS_AND_REFUNDS,
                    	    					params: {
                    								id: completionId,
                    								whetherByPassPendingPayments:whetherByPassPayments
                    							},
                    	    					success : function(form,action) {
                    	    						Ext.getBody().unmask();
                    	    							//grid.getStore().reload();
                    	    						    byPassPendingBtn.setDisabled(true);
                    	    						    isPaymentByPassDone=true;
                    	    							showSuccessMessage(getCompletionModuleTranslation('WITHDRAW_DETAILS'),getCompletionModuleTranslation('PENDING_PAYMENTS_BYPASSED_SUCCESSFULLY'));
                    	    					}
                    	    				});
                    	    			}
                    	    		});
                            	},
                            	
                            },
                            'printcertificatewindow button[itemId=cancelBtn]': {
                            	click: function(btn) {
                            		btn.up('window').close();
                            	}
                            },
                            'printcertificatewindow button[itemId=submitBtnId]': {
                            	click: this.onPrintCertificateSubmit
                            },
                            'printcertificatewindow button[itemId=sendToStudentProfileBtn]': {
                            	click: this.onPrintCertificateSendTo
                            },
							'issuecertificatesform': {
								activate: function(issuePnl) {
									var associatedAcadLocationIds = new Array();
									associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
									var permissionsMap = this.getCOMPLETION_PASSING_OUT_ISSUE_CERTIFICATE_SEND_MESSAGE_PERMISSION();
									var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
									var sendMessageBtn = issuePnl.down('#sendMessageBtn');
									sendMessageBtn.setVisible(false);
									Ext.each(permissionList, function(privilege) {
										if (privilege == "SEND_MESSAGE") {
											if (!isNullOrEmpty(sendMessageBtn)) {
												sendMessageBtn.setVisible(true);
											}
										}
				
									});
								}
							},
							'pendingrefundablesform': {
								activate: function(refundPnl) {
									var associatedAcadLocationIds = new Array();
									associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
									var permissionsMap = this.getCOMPLETION_PASSINGOUT_PENDING_REFUNDING_SEND_MESSAGE_PERMISSION();
									var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
									var sendMessageBtn = refundPnl.down('#sendMessageBtn');
									sendMessageBtn.setVisible(false);
									Ext.each(permissionList, function(privilege) {
										if (privilege == "SEND_MESSAGE") {
											if (!isNullOrEmpty(sendMessageBtn)) {
												sendMessageBtn.setVisible(true);
											}
										}
				
									});
								}
							},
							'pendingpaymentform': {
								activate: function(paymentPnl) {
									var associatedAcadLocationIds = new Array();
									associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
									var permissionsMap = this.getCOMPLETION_PASSINGOUT_PENDING_PAYMENT_SEND_MESSAGE_PERMISSION();
									var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
									var sendMessageBtn = paymentPnl.down('#sendMessageBtn');
									sendMessageBtn.setVisible(false);
									Ext.each(permissionList, function(privilege) {
										if (privilege == "SEND_MESSAGE") {
											if (!isNullOrEmpty(sendMessageBtn)) {
												sendMessageBtn.setVisible(true);
											}
										}
				
									});
								}
							},
							'completionsendmessage[itemId=completionSendMessageWindows] radiogroup#sendingPriority': {
								change: function( radio, newValue, oldValue, eOpts) {
									this.loadStudentScheduleField(radio, newValue, oldValue);
								}
							},
							'completionsendmessage[itemId=completionSendMessageWindows] customcombobox[itemId=msgTempletId]':{
								select : function(obj,rec){
									this.selectMessageTemp(obj,rec);
								}
							},
							'completionsendmessage[itemId=completionSendMessageWindows] radiogroup[itemId=messageType]':{
								change: function(val,nV,oV) {
									this.selectSectionMessageType(val, nV, oV);
								}
							},
							'completionsendmessage[itemId=completionSendMessageWindows]  filefield[itemId=staticUploadFileField]': {
								change: function(fileField, value, eOpts) {
									var form = this.getCompletionsendmessage();
									var subject = form.down('#subject').getValue();
									if(isNullOrEmpty(subject)) {
										form.down('#subject').setValue(' ');
									}
									this.uploadStudentStaticDocumentFileMessage(fileField, value, eOpts);
								}
							},
							'studentstaticdocumentattachmentgrid[itemId=studentStaticDocumentAttachmentGridMessage] actioncolumn': {
								click: function(view, rowIndex, colIndex, item, e, record, row){
									this.deleteStudentStaticMessageDocument(view, rowIndex, colIndex, item, e, record, row);
								}
							},
							'completionsendmessage[itemId=completionSendMessageWindows] button[itemId=adhocMsgSubmitBtn]':{
			 	    			click: this.sendAdhocMsg
							},
							'completionsendmessage[itemId=completionSendMessageWindows]': {
								render: function(grid) {
									var docGrid = grid.down('#studentStaticDocumentAttachmentGridMessage');
									docGrid.getStore().removeAll();
									docGrid.getStore().sync();
								}
							},
							'printcertificatewindow': {
								afterrender: this.onPrintCertificateWinRender
							}
        });
    },

    loadCompletionPendingBillGridData: function(grid, admissionId){
    	var store = grid.getStore();
    	store.getProxy().api.read = SERVERURL.COMPLETION_PENDING_RFUNDABLE_GRID_DATA;
    	
    	store.getProxy().extraParams = {
    		admissionId: admissionId
        };
    	store.load();
    },
    loadCompletionPendingRefundsGridData: function(grid, admissionId){
    	var store = grid.getStore();
    	store.getProxy().api.read = SERVERURL.COMPLETION_PENDING_RFUNDS_GRID_DATA;
    	store.getProxy().extraParams = {
    		admissionId: admissionId
        };
    	store.load();
    },
    loadCompletionPendingRefundablesGridData: function(grid, admissionId){
    	var store = grid.getStore();
    	store.getProxy().api.read = SERVERURL.COMPLETION_PENDING_REFUNDS_GRID_DATA;
    	
    	store.getProxy().extraParams = {
    		admissionId: admissionId
        };
    	store.load();
    },
    
    /**
     * View refunds history
     *  @param grid
     *  @param windowXType
     *  @param url
     */
    viewRefundHistoryInstrumentDetails: function(grid, windowXType, url) {

        if (grid.getSelectionModel().getCount() > 0) {
        	var record = grid.getSelectionModel().getSelection()[0];
        	var formWindow = Ext.widget(windowXType);
        	formWindow.show();
        	var params = {
        			paymentHeaderId : record.get('id')
        	};
        	var gridWindow = formWindow.down('grid');
        	var store = gridWindow.getStore();
            store.getProxy().api.read = url;
            store.getProxy().extraParams = params;
            store.load();
            
        } else {
            showWarningMessage(getPersonModuleTranslation('REFUND_HISTORY'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * This method is used to apply record to TAB
     * @param newTab tab reference 
     */
    applyCompletionId: function(newTab) {
        Ext.apply(newTab, {
            completionId: null,
            studentId:null,
            requestId:null,
            personId: null,
            admissionId: null,
            effectiveDate:null,
            admissionCode:null,
            setCompletionId: function(completionId) {
                newTab.completionId = completionId;
            },
            getCompletionId: function() {
                return newTab.completionId;
            },
            setStudentId: function(studentId) {
                newTab.studentId = studentId;
            },
            getStudentId: function() {
                return newTab.studentId;
            },
            setRequestId: function(requestId) {
                newTab.requestId = requestId;
            },
            getRequestId: function() {
                return newTab.requestId;
            },
            setPersonId: function(personId) {
                newTab.personId = personId;
            },
            getPersonId: function() {
                return newTab.personId;
            },
            setAdmissionId: function(admissionId) {
                newTab.admissionId = admissionId;
            },
            getAdmissionId: function() {
                return newTab.admissionId;
            },
            setEffectiveDate: function(effectiveDate) {
                newTab.effectiveDate = effectiveDate;
            },
            getEffectiveDate: function() {
                return newTab.effectiveDate;
            },
            getAdmissionCode: function() {
                return newTab.admissionCode;
            },
            setAdmissionCode: function(admissionCode) {
                newTab.admissionCode = admissionCode;
            }
        });
    },

    /**
     * This method is use to set the configuration to the tab. 
     * @param newTab 
     * @param completionId of student 
     */
    setConfig: function(newTab, completionId,requestId,personId, admissionId,effectiveDate,admissionCode) {

        if (newTab) {
            newTab.setCompletionId(completionId);
            newTab.setRequestId(requestId);
            newTab.setPersonId(personId);
            newTab.setAdmissionId(admissionId);
            newTab.setEffectiveDate(effectiveDate);
            newTab.setAdmissionCode(admissionCode);
        };
    },

    /**
     * This method is used to open completion tab Panel
     * @param btnRef which is reference of button
     */
    openCompletionPanel: function(buttonRef) {
    	var grid = buttonRef.up('grid');
        if (grid.getSelectionModel().getCount() === 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            grid_itemId = grid.itemId;
            var completionId = record.get('COMPLETION_ID');
            var requestId = record.get('SERVICE_REQUEST_ID'); 
            var personId = record.get('PERSON_ID'); 
            var admissionId = null;
            var admissionCode = record.get('ADMISSION_ID');
            var effectiveDate = record.get('EFFECTIVE_FROM_DATE');
            this.openTabPanel(grid_itemId, completionId,requestId,personId, admissionId,effectiveDate,admissionCode);
        } else {
        	showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    openPassoutCompletionPanel: function(grid) {
        if (grid.getSelectionModel().getCount() === 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            grid_itemId = grid.itemId;
            var completionId = record.get('completionId');
            var requestId = record.get('SERVICE_REQUEST_ID'); 
            var personId = record.get('PERSON_ID'); 
            var admissionId = null;
            var admissionCode = record.get('admissionCode');
            var effectiveDate = record.get('effectionTransferDate');
            var effectivePassoutCommunicationDate = record.get('effectivePassoutCommunicationDate');
            this.openTabPanel(grid_itemId, completionId,requestId,personId, admissionId,effectiveDate,admissionCode,effectivePassoutCommunicationDate);
        } else if(grid.getSelectionModel().getCount() > 1){
        	showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD')); //Please select a record.
        } else {
        	showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    operationResetButton: function(grid) {
        if(grid.getSelectionModel().getCount() >= 1){
			 var record = grid.getSelectionModel().getSelection()[0];
            grid_itemId = grid.itemId;
     //       var window=this.showWindow('passoutrejectbuttonwindow');
            var window=this.showWindow('passoutrejectbuttonform');
            //this.openTabPanel(grid_itemId, completionId,requestId,personId, admissionId,effectiveDate,admissionCode);
        
        } else {
        	showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
        }
    },
   

    /**
     * This method is used to get Record of selected Student 
     * @param url
     * @param id
     * @param callback function
     * @returns student details record
     */
    getRecord: function(url, id, callback) {
        this.sendGetAjaxRequest(url,'GET',id, callback);
    },

    /**
     * This method is used to open Tab 
     * @param button_itemId which is itemId of Update button
     * @param completionId of student record
     */
    openTabPanel: function(grid_itemId, completionId,requestId,personId, admissionId,effectiveDate,admissionCode,effectivePassoutCommunicationDate) {
        var me = this;
        var panel = null;
        var tab = null;
        var requestPanel = null;
        var requestTitle = null;

        switch (grid_itemId) {
        case 'passingOutSearchResultGrid': 
            {
                requestTitle = getCompletionModuleTranslation('PASSING_OUT_DETAILS_COLON')+admissionCode ;
                tab = this.getTabReferenceByTabTitle(requestTitle);
                if (!tab) { 
                    tab = me.openTab(requestTitle, 'completionpanel',CONSTANTS.MENU_COLOR_SIX);
                    this.applyCompletionId(tab);
                    this.setConfig(tab, completionId,null,personId, admissionId,effectiveDate,admissionCode,effectivePassoutCommunicationDate);
                    requestPanel = Ext.widget('passingouttabpanel');
                    panel = tab.down('#centerCompletionPanel');
                    panel.add({
                        xtype: 'fieldset',
                        marginLeft: '2px',
                        frame: true,
                        border: true,
                        minWidth: 500,
                        style: {
                            marginTop: '0px !important'
                        },
                        width: '100%',
                        items: [{
        				    xtype: 'panel',
        				    layout: {
        				        type: 'hbox'
        				    },
        				    width: '100%',
        				    minWidth: 500,
        	                items: [{
        		                xtype: 'panel',
        		                style: {
        		                    marginTop: '0px !important'
        		                },
        		                width: '20%',
        		                items: [{
        			            	xtype:'image',
        			                itemId: 'student_profile_image',
        			                border: 1,
        			                style: {
        			                    borderColor: 'black',
        			                    borderStyle: 'solid'
        			                },
        			                width: 130,
        			                height: 150
        			            }]
        		            },{
        		                xtype: 'panel',
        		                cls: 'panelNoSpace',
        		                style: {
        		                	marginLeft: '-10px !important',
        		                    marginTop: '0px !important'
        		                },
        		                width: '60%',
        		                height: 300,
        		                items: [{
                            xtype: 'passingoutprofileview',
                            itemId : 'passingOutView',
                            height: 300
                        }]
        		            }]
        				}]
                    }, requestPanel);
                }else{
                	contentPanel.setActiveTab(tab);
                }
                break;
            }
        case 'terminationSearchResultGrid':
            {
        	 	requestTitle = getCompletionModuleTranslation('TERMINATION_DETAILS_COLON')+admissionCode ;
                tab = this.getTabReferenceByTabTitle(requestTitle);
                if (!tab) {
//                	for(var i=0;i<contentPanel.items.length ;i++){
//                	    if(contentPanel.items.items[i].title.split(':')[0] === getCompletionModuleTranslation('TERMINATION_DETAILS'))
//                        contentPanel.remove(contentPanel.items.items[i]);
//                	}	    
                    tab = me.openTab(requestTitle, 'completionpanel',CONSTANTS.MENU_COLOR_SIX);
                    this.applyCompletionId(tab);
                    this.setConfig(tab, completionId,requestId,personId, admissionId,effectiveDate,admissionCode);
                    requestPanel = Ext.widget('terminationtabpanel');
                    panel = tab.down('#centerCompletionPanel');
                    panel.add({
                        xtype: 'fieldset',
                        marginLeft: '2px',
                        frame: true,
                        border: true,
                        minWidth: 500,
                        style: {
                            marginTop: '0px !important'
                        },
                        width: '100%',
                        items: [{
        				    xtype: 'panel',
        				    layout: {
        				        type: 'hbox'
        				    },
        				    width: '100%',
        				    minWidth: 500,
        	                items: [ {
        		                xtype: 'panel',
        		                style: {
        		                    marginTop: '0px !important'
        		                },
        		                width: '30%',
                        items: [{
        			            	xtype:'image',
        			                itemId: 'student_profile_image',
        			                border: 1,
        			                style: {
        			                    borderColor: 'black',
        			                    borderStyle: 'solid'
        			                },
        			                width: 130,
        			                height: 150
        			            }]
        		            },{
        		                xtype: 'panel',
        		                cls: 'panelNoSpace',
        		                style: {
        		                	marginLeft: '-10px !important',
        		                    marginTop: '0px !important'
        		                },
        		                width: '60%',
        		                height: 300,
        		                items: [{
                            xtype: 'passingoutprofileview',
                            itemId : 'terminationView',
                            height: 300
                        }]
        		            }]
                        }]	    
                    }, requestPanel);
                }else{
                	contentPanel.setActiveTab(tab);
                }
             
                break;
            }
        case 'temporaryTerminationSearchResultGrid':
            {
                requestTitle = getCompletionModuleTranslation('TEMP_TERMINATION_DETAILS_COLON')+admissionCode ;
                tab = this.getTabReferenceByTabTitle(requestTitle);
                if (!tab) {
//                	for(var i=0;i<contentPanel.items.length ;i++){
//                	    if(contentPanel.items.items[i].title.split(':')[0] === getCompletionModuleTranslation('TEMP_TERMINATION_DETAILS'))
//                        contentPanel.remove(contentPanel.items.items[i]);
//                	}	 
                    tab = me.openTab(requestTitle, 'completionpanel',CONSTANTS.MENU_COLOR_SIX);
                    this.applyCompletionId(tab);
                    this.setConfig(tab, completionId,requestId,personId, admissionId,effectiveDate,admissionCode);
                    requestPanel = Ext.widget('tempterminationtabpanel');
                    
                    panel = tab.down('#centerCompletionPanel');
                    panel.add({
                        xtype: 'fieldset',
                        title: getCompletionModuleTranslation('STUDENT_BASIC_DETAILS'),
                        marginLeft: '2px',
                        frame: true,
                        border: true,
                        minWidth: 500,
                        style: {
                            marginTop: '0px !important'
                        },
                        width: '100%',
                        items: [{
            				    xtype: 'panel',
            				    layout: {
            				        type: 'hbox'
            				    },
            				    width: '100%',
            				    minWidth: 500,
                        items: [{
            		                xtype: 'panel',
            		                style: {
            		                    marginTop: '0px !important'
            		                },
            		                width: '30%',
            		                items: [{
            			            	xtype:'image',
            			                itemId: 'student_profile_image',
            			                border: 1,
            			                style: {
            			                    borderColor: 'black',
            			                    borderStyle: 'solid'
            			                },
            			                width: 130,
            			                height: 150
            			            }]
            		            },{
            		                xtype: 'panel',
            		                cls: 'panelNoSpace',
            		                style: {
            		                	marginLeft: '-10px !important',
            		                    marginTop: '0px !important'
            		                },
            		                width: '60%',
            		                height: 300,
            		                items: [{
                            xtype: 'passingoutprofileview',
                            itemId : 'tempTerminationView',
                            height: 300
                            
                        }]
            		            }]
                    }]
                    }, requestPanel);
                }else{
                	contentPanel.setActiveTab(tab);
                }
                break;
            }
        case 'transferSearchResultGrid':
            {
                requestTitle = getCompletionModuleTranslation('TRANSFER_DETAILS_COLON')+admissionCode ;
                tab = this.getTabReferenceByTabTitle(requestTitle);
                if (!tab) {
//                	for(var i=0;i<contentPanel.items.length ;i++){
//                	    if(contentPanel.items.items[i].title.split(':')[0] === getCompletionModuleTranslation('TRANSFER_DETAILS'))
//                        contentPanel.remove(contentPanel.items.items[i]);
//                	}	 
                    tab = me.openTab(requestTitle, 'completionpanel',CONSTANTS.MENU_COLOR_SIX);
                    this.applyCompletionId(tab);
                    this.setConfig(tab, completionId,requestId,personId, admissionId,effectiveDate,admissionCode);
                    requestPanel = Ext.widget('transfertabpanel');
                    panel = tab.down('#centerCompletionPanel');
                    panel.add({
                        xtype: 'fieldset',
                        title: getCompletionModuleTranslation('STUDENT_BASIC_DETAILS'),
                        marginLeft: '2px',
                        frame: true,
                        border: true,
                        minWidth: 500,
                        style: {
                            marginTop: '0px !important'
                        },
                        width: '100%',
                        items: [{
        				    xtype: 'panel',
        				    layout: {
        				        type: 'hbox'
        				    },
        				    width: '100%',
        				    minWidth: 500,
        	                items: [ {
        		                xtype: 'panel',
        		                style: {
        		                    marginTop: '0px !important'
        		                },
        		                width: '30%',
        		                items: [{
        			            	xtype:'image',
        			                itemId: 'student_profile_image',
        			                border: 1,
        			                style: {
        			                    borderColor: 'black',
        			                    borderStyle: 'solid'
        			                },
        			                width: 130,
        			                height: 150
        			            }]
        		            },{
        		                xtype: 'panel',
        		                cls: 'panelNoSpace',
        		                style: {
        		                	marginLeft: '-10px !important',
        		                    marginTop: '0px !important'
        		                },
        		                width: '60%',
        		                height: 300,
                        items: [{
        		                	xtype: 'passingoutprofileview',
                                    itemId : 'transferPanelView',
                                    height: 300
        		                }]
        		            }]
        				
                        }]
                    }, requestPanel);
                }else{
                	 contentPanel.setActiveTab(tab);
                }
               
                break;
            }
        case 'withdrawalFromProgramSearchResultGrid':
            {
                requestTitle = getCompletionModuleTranslation('WITHDRAW_DETAILS_COLON')+admissionCode ;
                tab = this.getTabReferenceByTabTitle(requestTitle);
                if (!tab) {
//                	for(var i=0;i<contentPanel.items.length ;i++){
//                	    if(contentPanel.items.items[i].title.split(':')[0] === getCompletionModuleTranslation('WITHDRAW_DETAILS'))
//                        contentPanel.remove(contentPanel.items.items[i]);
//                	}	
                    tab = me.openTab(requestTitle, 'completionpanel',CONSTANTS.MENU_COLOR_SIX);
                    this.applyCompletionId(tab);
                    this.setConfig(tab, completionId,requestId,personId, admissionId,effectiveDate,admissionCode);
                    requestPanel = Ext.widget('withdrawprogramtabpanel');
                    panel = tab.down('#centerCompletionPanel');
                    panel.add({
                        xtype: 'fieldset',
                        title: getCompletionModuleTranslation('STUDENT_BASIC_DETAILS'),
                        marginLeft: '2px',
                        frame: true,
                        border: true,
                        minWidth: 500,
                        style: {
                            marginTop: '0px !important'
                        },
                        width: '100%',
                        items: [{
        				    xtype: 'panel',
        				    layout: {
        				        type: 'hbox'
        				    },
        				    width: '100%',
        				    minWidth: 500,
        				    
        				    items: [ {
        		                xtype: 'panel',
        		                style: {
        		                    marginTop: '0px !important'
        		                },
        		                width: '30%',
        		                items: [{
        			            	xtype:'image',
        			                itemId: 'student_profile_image',
        			                border: 1,
        			                style: {
        			                    borderColor: 'black',
        			                    borderStyle: 'solid'
        			                },
        			                width: 130,
        			                height: 150
        			            }]
        		            },{
        		                xtype: 'panel',
        		                cls: 'panelNoSpace',
        		                style: {
        		                	marginLeft: '-10px !important',
        		                    marginTop: '0px !important'
        		                },
        		                width: '60%',
        		                height: 300,
                        items: [{
        		                	xtype: 'passingoutprofileview',
                                    itemId : 'withdrawProgramView',
                                    height: 300
        		                }]
        		            }]
                        }]		    
                    }, requestPanel);
                }else{
                contentPanel.setActiveTab(tab);
                }
                break;
            }
        default:
            {
                break;
            }
        }
    },

    /**
     * This method id used to close form
     * @param button ref
     */
    closeFormPanel: function(button) {
        var me = this;
            me.getCompletionPanel().close();
    },

    /**
     * this method is used to save General Form details
     * @param button ref
     */
    saveGeneralForm: function(button) {
        	var me = this;
        	var grid = me.getPassingoutgrid();
        	var completionId = this.getContentPanel().getActiveTab().getCompletionId();
            var form = button.up('form');
            var values = form.getValues();
            values.effectiveDate = values.effectiveDate;
            values.effectivePassoutCommunicationDate = values.effectivePassoutCommunicationDate;
            values.id =  completionId;
            values.effectiveDateChangedBy = {
            		id: me.getCurrentlyLoggedInUser().id
            }
            if (isNullOrEmpty(values.effectivePassoutCommunicationDate)){
            	 delete values.effectivePassoutCommunicationDate;
            }
            if (isNullOrEmpty(values.customData) || values.customData.length == 0){
           	 delete values.customData;
            }
            if(form.isValid()) {
            var submitData = Ext.encode(values);
            me.getAjaxCall(submitData, form, SERVERURL.PASSING_OUT_GENERAL_SAVE, 'PASSING_OUT',grid,completionId);
            }else {
            	showWarningMessage(getCompletionModuleTranslation('PASSING_OUT_DETAILS'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
            }
    },

    /**
     * This method is used to save withdrwal from Program's general tab form
     * @param button ref
     */
    saveWithdrawFromProgramGeneralForm: function(button) {
        var me = this;
        var data = null;
        var grid = me.getWithdrawalProgramSearchResultGrid();
        var id = this.getContentPanel().getActiveTab().getRequestId();
		var param = {
				   serviceRequestId : id
		};
       this.getRecord(SERVERURL.WITHDRAW_PROGRAM_FIND_BY_ID, param, function(option, success, response) {
            data = Ext.decode(response.responseText);
           var completionId = me.getContentPanel().getActiveTab().getCompletionId();
            var form = button.up('form');
            var values = form.getValues();

            data[0].effectiveDate = values.effectiveDate;
            data.tillDate = values.tillDate;
            data.id =  completionId;
            data.serviceRequest = {
            		id : id
            };
            if(form.isValid()) {
            	 var submitData = Ext.encode(data);
                me.getAjaxCall(submitData, form, SERVERURL.WITHDRAW_FROM_PROGRAM_GENERAL_SAVE_ALL, 'WITHDRAW_PROGRAM',grid);
                }else {
                	showWarningMessage(getCompletionModuleTranslation('WITHDRAW_DETAILS'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
            }
           

        });
    },

    /**
     * This method is used to save termination general form
     * @param button ref 
     */
    saveTerminationGeneralForm: function(button) {
        var me = this;
        var data = null;
        button.setDisabled(true);
        Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        var grid = me.getTerminationSearchResultGrid();
        var id = this.getContentPanel().getActiveTab().getRequestId();
		var param = {
				   serviceRequestId : id
		};
        this.getRecord(SERVERURL.TERMINATION_FIND_BY_ID, param, function(option, success, response) {
            data = Ext.decode(response.responseText);
            var completionId = me.getContentPanel().getActiveTab().getCompletionId();
            var form = button.up('form');
            var values = form.getValues();
            var newData = [];
            Ext.each(data, function(currentData){
            	currentData.effectiveDate = values.effectiveDate;
            	currentData.id =  completionId;
            	currentData.serviceRequest = {
                		id : id
                };
            	newData.push(currentData);
            });
            if(form.isValid()) {
            	var submitData = Ext.encode(newData);
            	 me.getAjaxCallWithMaskig(submitData, form, SERVERURL.UPDATE_MULTIPLE_TERMINATION_REASON, 'TERMINATION',grid, button);
               }else {
               	showWarningMessage(getCompletionModuleTranslation('TERMINATION_DETAILS'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
              }
          
           
        });
    },

    /**
     * This method is used to save temporary termination general form
     * @param button ref 
     */
    saveTempTerminationGeneralForm: function(button) {
        var me = this;
        var data = null;
        var grid = me.getTemporaryTerminationSearchResultGrid();
        var id = this.getContentPanel().getActiveTab().getRequestId();
		var param = {
				   serviceRequestId : id
		};
        this.getRecord(SERVERURL.TEMP_TERMINATION_FIND_BY_ID, param, function(option, success, response) {
            data = Ext.decode(response.responseText);
            var completionId = me.getContentPanel().getActiveTab().getCompletionId();
            var form = button.up('form');
            var values = form.getValues();
            
            var newData = [];
            Ext.each(data, function(currentData){
            	currentData.effectiveDate = values.effectiveDate;
	            currentData.tillDate = values.tillDate;
	            currentData.id =  completionId;
	            currentData.serviceRequest = {
	            		id : id
	            };
            	newData.push(currentData);
            });
            if(form.isValid()) {
	        	  var submitData = Ext.encode(newData);
	        	  me.getAjaxCall(submitData, form, SERVERURL.UPDATE_MULTIPLE_DEBARMENT_REASON, 'TEMP_TERMINATION_DETAILS',grid);
               }else {
               	showWarningMessage(getCompletionModuleTranslation('TEMP_TERMINATION_DETAILS'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
              }
          
           
        });
    },

    /**
     * This method is used to save transfer general form 
     * @param button ref
     */
    saveTransferGeneralForm: function(button) {
        var me = this;
        var data = null;
        var grid = me.getTransferSearchResultGrid();
        var id = this.getContentPanel().getActiveTab().getRequestId();
		var param = {
				   serviceRequestId : id
		};
      
        this.getRecord(SERVERURL.TRANSFER_FIND_BY_ID, param, function(option, success, response) {
            data = Ext.decode(response.responseText);
            var completionId = me.getContentPanel().getActiveTab().getCompletionId();
            var form = button.up('form');
            var values = form.getValues();
            data.effectiveDate = values.effectiveDate;
            data.tillDate = values.tillDate;
            data.id =  completionId;
            data.serviceRequest = {
            		id : id
            };
        
            if(form.isValid()) {
                var submitData = Ext.encode(data);
                me.getAjaxCall(submitData, form, SERVERURL.TRANSFER_GENERAL_SAVE, 'TRANSFER_DETAILS',grid);
             }else {
             	showWarningMessage(getCompletionModuleTranslation('TRANSFER_DETAILS'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
            }
           

        });

    },

    /**
     * This is used to send AJAX call for updating general form details
     * @param data
     * @param form ref
     * @param url 
     * @param title
     */
    getAjaxCall: function(data, form, url, title,grid) {
    	var me = this;
        this.sendSaveAjaxRequest(url, 'PUT', data, function(opt, success, response) {
            if (success) {
            	me.getCompletionPanel().close();
            	grid.getStore().reload();
                showSuccessMessage(getCompletionModuleTranslation(title), getCompletionModuleTranslation('SAVEDSUCCESSFULLY'));
            }
        });
    },
    getAjaxCallWithMaskig: function(data, form, url, title,grid, button) {
    	var me = this;
        this.sendSaveAjaxRequest(url, 'PUT', data, function(opt, success, response) {
            if (success) {
            	me.getCompletionPanel().close();
            	grid.getStore().reload();
                showSuccessMessage(getCompletionModuleTranslation(title), getCompletionModuleTranslation('SAVEDSUCCESSFULLY'));
                Ext.getBody().unmask();
                button.setDisabled(false);
            }
        });
    },

    /**
     * This method is used to get Completion status to enable submit button
     */
    enableSubmitBtn : function(date,button,status){
    	  var me = this;
    	  if(status==undefined)
    		  status = me.getCompletionStatus();
          if(status === true){
	        	  date.setDisabled(false);
	        	  button.setDisabled(false);
          }else{
        	  date.setDisabled(true);
        	  button.setDisabled(true);
          }
    },
    
    
    /*
     * This function is to disble buttons if the effective date is less the current date
     */
    disableAllButtonLessEffectiveDate : function(tabPanel,tabName,btnItemId){
    	var dateField = tabPanel.down(tabName).down('#startDate');
		var submitBtn = tabPanel.down(tabName).down(btnItemId);
		this.enableSubmitBtn(dateField,submitBtn,false);
		
		var displayFormatMap = Academia.utilities.DisplayFormatMap;
	    var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	    var currentDateFormat = orgModel.get('dateFormat');
		var format = displayFormatMap.getDisplayFormat(currentDateFormat);
		
		if(!isNullOrEmpty(this.getContentPanel().getActiveTab().effectiveDate)){
			
			var currentDate = Ext.Date.parse(Ext.Date.format(new Date(),CONSTANTS.DATE_FORMAT), CONSTANTS.DATE_FORMAT);
			var effectiveDate = Ext.Date.parse((this.getContentPanel().getActiveTab().effectiveDate), format);
    		if(currentDate < effectiveDate){
     			this.enableSubmitBtn(dateField,submitBtn);
     		}
    		else{
    			this.disableAllButtons(tabPanel,tabName);
    		}
		}else{
        	 	this.enableSubmitBtn(dateField,submitBtn);
        }
		var effectiveDate = this.getContentPanel().getActiveTab().getEffectiveDate();
		
		var displayFormatMap = Academia.utilities.DisplayFormatMap;
	    var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	    var currentDateFormat = orgModel.get('dateFormat');
		var format = displayFormatMap.getDisplayFormat(currentDateFormat);
		
		effectiveDate = Ext.Date.parse(effectiveDate, format);
		if(!isNullOrEmpty(effectiveDate)) {
			dateField.setValue(dateRender(effectiveDate));
		}
		
    },
    
    
    /**
     * This method is used to disable all the buttons on form of student is made inactive
     */
    disableAllButtons : function(tabPanel,tabName){
		var effectiveDateField = tabPanel.down(tabName) && tabPanel.down(tabName).down('#startDate');
    	var checklistSaveBtn = tabPanel.down('checklistform') && tabPanel.down('checklistform').down('#completionCheckListUpdateBtn');
		var pendingPaymentSendBtn = tabPanel.down('pendingpaymentform') && tabPanel.down('pendingpaymentform').down('#sendMessageBtn');
		var pendingRefundablesSendMsgBtn  = tabPanel.down('pendingrefundablesform') && tabPanel.down('pendingrefundablesform').down('#sendMessageBtn');
		var issueCertificatesMarkAsCompleteBtn = tabPanel.down('issuecertificatesform') && tabPanel.down('issuecertificatesform').down('#markAsComplete');
		var issueCertificatesSendMessageBtn = tabPanel.down('issuecertificatesform') && tabPanel.down('issuecertificatesform').down('#sendMessageBtn');
		// Removed buttons V2D-380420
		//var issueCertificatesPrintCertBtn = tabPanel.down('issuecertificatesform') && tabPanel.down('issuecertificatesform').down('#printCertificateBtn');
		var issueCertificatesEmailCertBtn = tabPanel.down('issuecertificatesform') && tabPanel.down('issuecertificatesform').down('#emailCertificateBtn');
		var docSendNotificationBtn = tabPanel.down('documentform') && tabPanel.down('documentform').down('#sendNotificationBtn');
		var docSendMsgBtn = tabPanel.down('documentform') && tabPanel.down('documentform').down('#sendMessageBtn');
		var documentGridAddBtn = tabPanel.down('completiondocumentgrid') && tabPanel.down('completiondocumentgrid').down('#btnAddCompletionDoc');
		var documentGridEditBtn = tabPanel.down('completiondocumentgrid') && tabPanel.down('completiondocumentgrid').down('#btnEditCompletionDoc');
		var documentGridDeleteBtn = tabPanel.down('completiondocumentgrid') && tabPanel.down('completiondocumentgrid').down('#btnDeleteCompletionDoc');
		
		effectiveDateField && effectiveDateField.setDisabled(true);
		checklistSaveBtn && checklistSaveBtn.setDisabled(true);
		issueCertificatesMarkAsCompleteBtn && issueCertificatesMarkAsCompleteBtn.setDisabled(true);
		if(!isNullOrEmpty(this.getContentPanel().getActiveTab().effectiveDate)){
			var displayFormatMap = Academia.utilities.DisplayFormatMap;
		    var orgModel = Academia.model.common.OrgSettingDateTimeModel;
		    var currentDateFormat = orgModel.get('dateFormat');
			var format = displayFormatMap.getDisplayFormat(currentDateFormat);
			
			var currentDate = Ext.Date.parse(Ext.Date.format(new Date(),CONSTANTS.DATE_FORMAT), CONSTANTS.DATE_FORMAT);
			var effectiveDate = Ext.Date.parse((this.getContentPanel().getActiveTab().effectiveDate), format);
			if(currentDate <= effectiveDate){
				issueCertificatesSendMessageBtn && issueCertificatesSendMessageBtn.setDisabled(false);
				pendingPaymentSendBtn && pendingPaymentSendBtn.setDisabled(false);
				pendingRefundablesSendMsgBtn && pendingRefundablesSendMsgBtn.setDisabled(false);
			}
			else{
				issueCertificatesSendMessageBtn && issueCertificatesSendMessageBtn.setDisabled(true);
				pendingPaymentSendBtn && pendingPaymentSendBtn.setDisabled(true);
				pendingRefundablesSendMsgBtn && pendingRefundablesSendMsgBtn.setDisabled(true);
			}
		}
		//issueCertificatesPrintCertBtn.setDisabled(true);
		//issueCertificatesEmailCertBtn && issueCertificatesEmailCertBtn.setDisabled(true);
		docSendNotificationBtn && docSendNotificationBtn.setDisabled(true);
		docSendMsgBtn && docSendMsgBtn.setDisabled(true);
		documentGridAddBtn && documentGridAddBtn.setDisabled(true);
		documentGridEditBtn && documentGridEditBtn.setDisabled(true);
		documentGridDeleteBtn && documentGridDeleteBtn.setDisabled(true);
    },
    
    /**
     * This is used to set Passing Out General form
     */
    setPassingOutGeneralForm : function(form){
    	var record = this.getCompletionData();
        form.down('#startDate').setValue(dateRender(record.effectiveDate));
        form.down('#effectivePassoutCommunicationDate').setValue(dateRender(record.effectivePassoutCommunicationDate));
        if(!record.effectivePassoutCommunicationDate){
        	var today = new Date();
        	tomorrow = new Date();
        	form.down('#effectivePassoutCommunicationDate').setMinValue(new Date(tomorrow.setDate(today.getDate() + 1)));
        	
        }
    },
    /**
     * THis is used to set data in Termination Form 
     * @param form ref
     */
    setTerminationGeneralData: function(form) {
        var data = null;
        var id = this.getContentPanel().getActiveTab().getRequestId();
        this.hideTillDateField(form);
        param = {
        		serviceRequestId : id
        };
        var me = this;
        
        this.addTerminationGeneralReasonFields(1, form, true);
        
        this.getRecord(SERVERURL.TERMINATION_FIND_BY_ID, param, function(option, success, response) {
        	if(!isNullOrEmpty(response.responseText)){
        		data = Ext.decode(response.responseText);
        		if(data.length){
            		form.down('#terminationRemark').setValue(data[0].remark);
            		form.down('#studentRemarkId').setValue(data[0].studentRemark);
            		if(data[0].approvedBy !== null){
            			form.down('#approvedById').setValue(data[0].approvedBy.value);
            		}
            		//form.down('#terminationGeneralReason').setValue(data.reasonId.value);
            		var record = me.getCompletionData();
            		form.down('#startDate').setValue(dateRender(record.effectiveDate));
            		
            		form.down('[name=terminationReasonId]').getStore().load({
        	    		callback: function(){
        	    			me.loadTerminationGeneralData(data, form);
        	    		}
            	    });
        		}
        	}
        });
    },
    
    loadTerminationGeneralData: function(data, form){
    	var me = this;
    	var terminationRequestMultipleReason = data;
    	var firstReasonId = data[0].reasonId.value;
    	var firstReasonRemark = data[0].reasonId.displayOtherLanguage;
    	
    	form.down('#terminationReason_1').setValue(firstReasonId);
    	form.down('#terminationRemarks_1').setValue(firstReasonRemark);
    	if(terminationRequestMultipleReason.length>1){
    		this.addTerminationGeneralReasonFields(2, form, true, terminationRequestMultipleReason)
    	}
    },
    
    addTerminationGeneralReasonFields: function(inc, form, isView, values){
    	var me = this;
    	var terminationReasonsFieldset = form.down('#terminationReasonsGeneralFieldset');
    	
    	if(!Ext.isDefined(isView)){
			isView = false;
		}
    	
    	if(inc == 1){
    		var hideDeleteBtn = true;
    		var btnMargin = 30;
    		var panelHeight= 90;
    		var fieldHeight= 78;
    		var terminationReasonLabel = getServiceRequestTranslation('TERMINATION_REASON');
    		var terminationRemarkLabel = getCommonTranslation('REASON_REMARKS');
    	}
    	else{
    		var hideDeleteBtn = false;
    		var btnMargin = 0;
    		var panelHeight= 60;
    		var fieldHeight= 60;
    		var terminationReasonLabel = false;
    		var terminationRemarkLabel = false;
    	}
    	
    	var reasonContainer = {
    			xtype: 'fieldcontainer',
    			defaults: {
    				width: 256,
    				labelAlign: 'top'
    			},
    			layout: 'hbox',
    			inc: inc,
    			isView: isView,
    			items: [{
    				xtype: 'customcombobox',
    				fieldLabel: terminationReasonLabel,
    				store: 'servicerequest.TerminationReasons',
    				name: 'terminationReasonId',
    				valueField: 'id',
    				itemId: 'terminationReason_'+inc,
    				displayField: 'value',
    				allowBlank: false,
    				editable: false,
    				readOnly: isView,
    				value: Ext.isDefined(values) ? values[inc-1].reasonId.value : null
    			},{
    				xtype: 'textarea',
    				fieldLabel: terminationRemarkLabel,
    				name: 'terminationRemarks',
    				itemId: 'terminationRemarks_'+inc,
    				rows:3,
    				readOnly: isView,
    				value: Ext.isDefined(values) ? values[inc-1].reasonId.displayOtherLanguage : ""
    			},{
    				xtype : 'button',
    				itemId: 'terminationReasonAddBtn_'+inc,
    				width: 'auto',
    				cls: 'CustomBodyBtnSettings',
    				action: 'addTerminationReasonGeneral',
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD'),
    				style:{
    					'margin-top':btnMargin+'px !important;'
    				},
    				hidden: isView
    			},{
    				xtype: 'button',
    				glyph: ICONGLYPH.DELETEGLYPH,
    				itemId: 'terminationReasonDeleteBtn_'+inc,
    				width: 'auto',
    				cls: 'CustomBodyBtnReject',
    				action: 'deleteTerminationReasonGeneral',
    				tooltip: getCommonTranslation('DELETETOOLTIP'),
    				hidden: hideDeleteBtn,
    				style:{
    					'margin-top':btnMargin+'px !important;'
    				},
    				hidden: isView
    			}],
    			afterender: function(btn){
    				me.validateTerminationFormGeneral(btn);
    			}
    	};
    	
    	var panelItem = new Array();
    	panelItem.push(reasonContainer);
    	terminationReasonsFieldset.add(panelItem);
    	
    	if(Ext.isDefined(values) && values.length){
        	setTimeout(function(){
        		if(values.length > inc){
        			var nInc = inc+1;
        			me.addTerminationGeneralReasonFields(nInc, form, isView, values)
        		}
        	},300);
    	}
    },
    addTerminationReasonGeneral: function(btn){
    	var me = this;
    	var fieldcontainer = btn.up('fieldcontainer');
    	var newInc = fieldcontainer.inc+1;
    	var isView = fieldcontainer.isView;
    	var terminationgeneralform = btn.up('terminationgeneralform');
    	
    	me.addTerminationGeneralReasonFields(newInc, terminationgeneralform, isView);
    },
    deleteTerminationReasonGeneral: function(btn){
    	var me = this;
    	
    	var fieldcontainer = btn.up('fieldcontainer');
    	var fieldset = fieldcontainer.up('fieldset');
    	var terminationgeneralform = btn.up('terminationgeneralform');
    	
    	fieldset.remove(fieldcontainer);
    	setTimeout(function(){
        	me.validateTerminationFormGeneral(null, terminationgeneralform);
    	},300);
    },
    validateTerminationFormGeneral: function(btn, form){
    	var me = this;
    	if(!isNullOrEmpty(btn)){
    		var terminationgeneralform = btn.up('terminationgeneralform');
    	}
    	else{
    		var terminationgeneralform = form;
    	}
    	terminationgeneralform.isValid();
    	terminationgeneralform.getForm().clearInvalid();
    },

    /**
     * THis is used to set data in temporary Termination Form 
     * @param form ref
     */
    setTempTerminationGeneralData: function(form) {    	
        var data = null;
        var id = this.getContentPanel().getActiveTab().getRequestId();
    	form.down('#endDate').setDisabled(false);
    	form.down('#startDate').setDisabled(false);
        param = {
        		serviceRequestId : id
        };
        var me = this;
        this.addTerminationGeneralReasonFieldsTemp(1, form, true);
        var view = this.getPassingOutProfileView();
        this.getRecord(SERVERURL.TEMP_TERMINATION_FIND_BY_ID, param, function(option, success, response) {
        	if(!isNullOrEmpty(response.responseText)){
        		data = Ext.decode(response.responseText);
    			if(data){
					 form.down('#terminationRemark').setValue(data.remark);
					 form.down('#endDate').setValue(dateRender(data.tillDate));
					 form.down('#startDate').setValue(dateRender(data.effectiveDate));
					 if(data.approvedBy !== null){
						 form.down('#approvedById').setValue(data.approvedBy.value);
					 }
					 //form.down('#terminationGeneralReason').setValue(data.reason.value);
					 completionId = me.getContentPanel().getActiveTab().getCompletionId();
					 var record = me.getCompletionData(completionId);
					 record.effectiveDate =data.effectiveDate ;
					 var templateDataArray=new Array();
					 templateDataArray.push(record);
					 view.getStore().loadData(templateDataArray);
					 form.down('#endDate').setMinValue(dateRender(data.effectiveDate));
					 
					form.down('[name=terminationReasonId]').getStore().load({
						callback: function(){
							me.loadTerminationGeneralDataTemp(data, form);
						}
					});
         	    }
				 form.down('#startDate').setReadOnly(true);
				 form.down('#studentRemarkId').setVisible(false);
				 form.down('#endDate').setEditable(true);
				 form.down('#endDate').setReadOnly(false);
				 form.down('#generalSubmitBtn').setDisabled(false);
        	}
        });
    },
    
    loadTerminationGeneralDataTemp: function(data, form){
    	var me = this;
    	var terminationRequestMultipleReason = data;
    	var firstReasonId = data.reasonLst[0].value;
    	var firstReasonRemark = data.reasonLst[0].displayOtherLanguage;
    	
    	form.down('#terminationReason_1').setValue(firstReasonId);
    	form.down('#terminationRemarks_1').setValue(firstReasonRemark);
    	var inc = terminationRequestMultipleReason.reasonLst.length;
    	if(inc=2){
    		this.addTerminationGeneralReasonFieldsTemp(inc, form, true, terminationRequestMultipleReason);
    	} else if(inc>2) {
			this.addTerminationGeneralReasonFieldsTemp((inc-1), form, true, terminationRequestMultipleReason);
		}
    },
    
    addTerminationGeneralReasonFieldsTemp: function(inc, form, isView, values){
    	var me = this;
    	var terminationReasonsFieldset = form.down('#terminationReasonsGeneralFieldset');
    	
    	if(!Ext.isDefined(isView)){
			isView = false;
		}
    	
    	if(inc == 1){
    		var hideDeleteBtn = true;
    		var btnMargin = 30;
    		var panelHeight= 90;
    		var fieldHeight= 78;
    		var terminationReasonLabel = getServiceRequestTranslation('DEBARMENT_REASON');
    		var terminationRemarkLabel = getCommonTranslation('REMARK');
    	}
    	else{
    		var hideDeleteBtn = false;
    		var btnMargin = 0;
    		var panelHeight= 60;
    		var fieldHeight= 60;
    		var terminationReasonLabel = false;
    		var terminationRemarkLabel = false;
    	}
    	
    	var reasonContainer = {
    			xtype: 'fieldcontainer',
    			defaults: {
    				width: 256,
    				labelAlign: 'top'
    			},
    			layout: 'hbox',
    			inc: inc,
    			isView: isView,
    			items: [{
    				xtype: 'customcombobox',
    				fieldLabel: terminationReasonLabel,
    				store: 'servicerequest.DebarmentReasons',
    				name: 'terminationReasonId',
    				valueField: 'id',
    				itemId: 'terminationReason_'+inc,
    				displayField: 'value',
    				allowBlank: true,
    				editable: false,
    				readOnly: isView,
    				value: Ext.isDefined(values) ? values.reasonLst[inc-1].value : null
    			},{
    				xtype: 'textarea',
    				fieldLabel: terminationRemarkLabel,
    				name: 'terminationRemarks',
    				itemId: 'terminationRemarks_'+inc,
    				rows:3,
    				readOnly: isView,
    				value: Ext.isDefined(values) ? values.reasonLst[inc-1].displayOtherLanguage : ""
    			},{
    				xtype : 'button',
    				itemId: 'terminationReasonAddBtn_'+inc,
    				width: 'auto',
    				cls: 'CustomBodyBtnSettings',
    				action: 'addTerminationReasonGeneralTemp',
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD'),
    				style:{
    					'margin-top':btnMargin+'px !important;'
    				},
    				hidden: isView
    			},{
    				xtype: 'button',
    				glyph: ICONGLYPH.DELETEGLYPH,
    				itemId: 'terminationReasonDeleteBtn_'+inc,
    				width: 'auto',
    				cls: 'CustomBodyBtnReject',
    				action: 'deleteTerminationReasonGeneralTemp',
    				tooltip: getCommonTranslation('DELETETOOLTIP'),
    				hidden: hideDeleteBtn,
    				style:{
    					'margin-top':btnMargin+'px !important;'
    				},
    				hidden: isView
    			}],
    			afterender: function(btn){
    				me.validateTerminationFormGeneralTemp(btn);
    			}
    	};
    	
    	var panelItem = new Array();
    	panelItem.push(reasonContainer);
    	terminationReasonsFieldset.add(panelItem);
    	
    	if(Ext.isDefined(values) && values.reasonLst.length){
        	setTimeout(function(){
        		if(values.reasonLst.length > inc){
        			var nInc = inc+1;
        			me.addTerminationGeneralReasonFieldsTemp(nInc, form, isView, values)
        		}
        	},300);
    	}
    },
    addTerminationReasonGeneralTemp: function(btn){
    	var me = this;
    	var fieldcontainer = btn.up('fieldcontainer');
    	var newInc = fieldcontainer.inc+1;
    	var isView = fieldcontainer.isView;
    	var terminationgeneralform = btn.up('terminationgeneralform');
    	
    	me.addTerminationGeneralReasonFieldsTemp(newInc, terminationgeneralform, isView);
    },
    deleteTerminationReasonGeneralTemp: function(btn){
    	var me = this;
    	
    	var fieldcontainer = btn.up('fieldcontainer');
    	var fieldset = fieldcontainer.up('fieldset');
    	var terminationgeneralform = btn.up('terminationgeneralform');
    	
    	fieldset.remove(fieldcontainer);
    	setTimeout(function(){
        	me.validateTerminationFormGeneralTemp(null, terminationgeneralform);
    	},300);
    },
    validateTerminationFormGeneralTemp: function(btn, form){
    	var me = this;
    	if(!isNullOrEmpty(btn)){
    		var terminationgeneralform = btn.up('terminationgeneralform');
    	}
    	else{
    		var terminationgeneralform = form;
    	}
    	terminationgeneralform.isValid();
    	terminationgeneralform.getForm().clearInvalid();
    },

    /**
     * THis is used to set data in Termination Form 
     * @param form ref
     */
    setWithdrwalFromProgramGeneralData: function(form) { //
        var data = null;
        var id = this.getContentPanel().getActiveTab().getRequestId();
        param = {
        		serviceRequestId : id
        };
        var me = this;
        
        this.addWFPGeneralReasonFields(1, form, true);
        
        this.getRecord(SERVERURL.WITHDRAW_PROGRAM_FIND_BY_ID,param, function(option, success, response) {
        	if(!isNullOrEmpty(response.responseText)){
        		data = Ext.decode(response.responseText);
                 if(data && Ext.isDefined(data.approvedBy) && data.approvedBy !== null){
        			 form.down('#approvedByWithdraw').setValue(data.approvedBy.value);
        		 }
                 var record = me.getCompletionData();
                 form.down('#startDate').setValue(dateRender(record.effectiveDate));
                 
                 form.down('[name=wfpReasonId]').getStore().load({
     	    		callback: function(){
     	    			me.loadWFPGeneralData(data, form);
     	    		}
         	    });
        	}
        });
    },
    
    loadWFPGeneralData: function(data, form){
    	var me = this;
    	var wfpRequestMultipleReason = data;
    	var firstReasonId = data[0].reasonId;
    	var firstReasonRemark = data[0].remark;
    	
    	form.down('#withdrawRemarks').setValue(data[0].withdrawalRemarks);
    	form.down('#wfpReason_1').setValue(firstReasonId);
    	form.down('#wfpRemarks_1').setValue(firstReasonRemark);
    	if(wfpRequestMultipleReason.length>1){
    		this.addWFPGeneralReasonFields(2, form, true, wfpRequestMultipleReason)
    	}
    },
    
    addWFPGeneralReasonFields: function(inc, form, isView, values){
    	var me = this;
    	var wfpReasonsFieldset = form.down('#withdrawFromProgramReasonsGeneralFieldset');
    	
    	if(!Ext.isDefined(isView)){
			isView = false;
		}
    	
    	if(inc == 1){
    		var hideDeleteBtn = true;
    		var btnMargin = 30;
    		var panelHeight= 90;
    		var fieldHeight= 78;
    		var wfpReasonLabel = getServiceRequestTranslation('WITHDRAWAL_REASON');
    		var wfpRemarkLabel = getCommonTranslation('REASON_REMARKS');
    	}
    	else{
    		var hideDeleteBtn = false;
    		var btnMargin = 0;
    		var panelHeight= 60;
    		var fieldHeight= 60;
    		var wfpReasonLabel = false;
    		var wfpRemarkLabel = false;
    	}
    	
    	var reasonContainer = {
    			xtype: 'fieldcontainer',
    			defaults: {
    				width: 256,
    				labelAlign: 'top'
    			},
    			layout: 'hbox',
    			inc: inc,
    			isView: isView,
    			items: [{
    				xtype: 'customcombobox',
    				fieldLabel: wfpReasonLabel,
    				store: 'servicerequest.studentservicerequest.ReasonForLeavingStore',
    				name: 'wfpReasonId',
    				valueField: 'id',
    				itemId: 'wfpReason_'+inc,
    				displayField: 'value',
    				allowBlank: false,
    				editable: false,
    				readOnly: isView,
    				value: Ext.isDefined(values) ? values[inc-1].reasonId : null
    			},{
    				xtype: 'textarea',
    				fieldLabel: wfpRemarkLabel,
    				name: 'wfpRemarks',
    				itemId: 'wfpRemarks_'+inc,
    				rows:3,
    				readOnly: isView,
    				value: Ext.isDefined(values) ? values[inc-1].remark : ""
    			},{
    				xtype : 'button',
    				itemId: 'wfpReasonAddBtn_'+inc,
    				width: 'auto',
    				cls: 'CustomBodyBtnSettings',
    				action: 'addWFPReasonGeneral',
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD'),
    				style:{
    					'margin-top':btnMargin+'px !important;'
    				},
    				hidden: isView
    			},{
    				xtype: 'button',
    				glyph: ICONGLYPH.DELETEGLYPH,
    				itemId: 'wfpReasonDeleteBtn_'+inc,
    				width: 'auto',
    				cls: 'CustomBodyBtnReject',
    				action: 'deleteWFPReasonGeneral',
    				tooltip: getCommonTranslation('DELETETOOLTIP'),
    				hidden: hideDeleteBtn,
    				style:{
    					'margin-top':btnMargin+'px !important;'
    				},
    				hidden: isView
    			}],
    			afterender: function(btn){
    				me.validateWFPFormGeneral(btn);
    			}
    	};
    	
    	var panelItem = new Array();
    	panelItem.push(reasonContainer);
    	wfpReasonsFieldset.add(panelItem);
    	
    	if(Ext.isDefined(values) && values.length){
        	setTimeout(function(){
        		if(values.length > inc){
        			var nInc = inc+1;
        			me.addWFPGeneralReasonFields(nInc, form, isView, values)
        		}
        	},300);
    	}
    },
    addWFPReasonGeneral: function(btn){
    	var me = this;
    	var fieldcontainer = btn.up('fieldcontainer');
    	var newInc = fieldcontainer.inc+1;
    	var isView = fieldcontainer.isView;
    	var withdrawfromprogramgeneralform = btn.up('withdrawfromprogramgeneralform');
    	
    	me.addWFPGeneralReasonFields(newInc, withdrawfromprogramgeneralform, isView);
    },
    deleteWFPReasonGeneral: function(btn){
    	var me = this;
    	
    	var fieldcontainer = btn.up('fieldcontainer');
    	var fieldset = fieldcontainer.up('fieldset');
    	var withdrawfromprogramgeneralform = btn.up('withdrawfromprogramgeneralform');
    	
    	fieldset.remove(fieldcontainer);
    	setTimeout(function(){
        	me.validateWFPFormGeneral(null, withdrawfromprogramgeneralform);
    	},300);
    },
    validateWFPFormGeneral: function(btn, form){
    	var me = this;
    	if(!isNullOrEmpty(btn)){
    		var withdrawfromprogramgeneralform = btn.up('withdrawfromprogramgeneralform');
    	}
    	else{
    		var withdrawfromprogramgeneralform = form;
    	}
    	withdrawfromprogramgeneralform.isValid();
    	withdrawfromprogramgeneralform.getForm().clearInvalid();
    },

    /**
     * THis is used to set data in Transfer Form 
     * @param form ref
     */
    setTransferGeneralData: function(form) {
        var data = null;
        var id = this.getContentPanel().getActiveTab().getRequestId();
        param = {
        		serviceRequestId : id
        };
        var me = this;
        this.getRecord(SERVERURL.TRANSFER_FIND_BY_ID, param, function(option, success, response) {
        	
        	if(!isNullOrEmpty(response.responseText)){
        		data = Ext.decode(response.responseText);
                 form.down('#transferRemark').setValue(data.remark);
        		if(data.approvedBy !== null){
       			 form.down('#approvedById').setValue(data.approvedBy.value);
       		 	}
                 form.down('#transferReason').setValue(data.reason.value);
                 var record = me.getCompletionData();
                 form.down('#startDate').setValue(dateRender(record.effectiveDate));
        	}
        });
    },

   /* *//**
     * This is used to hide Print Certificate Button in case Of Passing Out
     * @param formRef
     *//*
    hideButton: function(formRef) {
        var Btn = formRef.down('#printCertificate');
        Btn.setVisible(false);
        Btn.setDisabled(true);
    },*/

    /**
     * This method is used to hide withdrwal Reason combo on passing Out Quick Search
     * @param formRef
     */
    hideCombo: function(formRef) {
        var combo = formRef.down('#withdrawalReason');
        var statusCombo = formRef.down('#status');
        var store = Ext.create('Academia.store.completion.completionform.PassOutStatus');
        combo.setVisible(false);
        combo.setDisabled(true);
        statusCombo.bindStore(store);
    },

    /**
     * This is used to change Combo name of termination quick search in case of transfer REason
     * @param formRef
     */
    changeComboName: function(formRef) {
        var textField = formRef.down('#terminationReason');
        textField.setFieldLabel(getCompletionModuleTranslation('TRANSFER_REASON'));
        textField.bindStore('servicerequest.TransferReasons');
        textField.name = 'TRANSFER_REASON';
    },

    /**
     * This is used to chnage termination combo name in case of debarment reason
     */
    changeTerminationComboName : function(formRef){
    	var textField = formRef.down('#terminationReason');
        textField.setFieldLabel(getCompletionModuleTranslation('DEBARMNET_REASON'));
    },
    /**
     * This is used to hide check box field Container in case of Temporary Termination 
     * @param formRef
     */
    hideCheckBoxFieldContainer: function(formRef) {
        var field = formRef.down('#checkBoxFieldContainer');
        field.setVisible(false);
        field.setDisabled(true);
    },

    /**
     * THis is used to load Issue Certificate Grid 
     * @param formRef
     */
    loadIssueGrid: function(grid) {
        var store = grid.getStore();
        var id = this.getContentPanel().getActiveTab().getCompletionId();
        store.getProxy().api.read = SERVERURL.ISSUE_CERTIFICATE_GIRD_URL + id;
        store.load();
    },

    /**
     * This method is used to change status of Certificate
     * @param buttonRef
     */
    markAsComplete: function(buttonRef) {

    	var this$ = this;
        var grid =  buttonRef.up('form').down('#issueCertificatesGridId');
        if (grid.getSelectionModel().getCount()>0) {
            var records = grid.getSelectionModel().getSelection();
            var  recordIds = new Array();
            Ext.each(records, function(record){
            	recordIds.push(record.get("id"));
            });
            var completionId = this.getContentPanel().getActiveTab().getCompletionId();
            var passingOutProfileView = this$.getPassingOutProfileView();
            var submitData = {
            		completionId :completionId ,
            		ids : recordIds 
            };
            var jsonFormatFormData = Ext.encode(submitData);
            this$.sendSaveAjaxRequest(SERVERURL.COMPLETION_MARK_AS_COMPLETE,'POST', jsonFormatFormData, function(opt, success, response) {
                if (success) {
                	grid.getStore().reload();
                	grid.getSelectionModel().deselectAll(true);
                    showSuccessMessage(getCompletionModuleTranslation('CERTIFICATE_DETAILS'), getCompletionModuleTranslation('SAVEDSUCCESSFULLY'));
                    this$.setProfileView(passingOutProfileView,completionId);
                }
            });
        } else {
        	showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /**
     * This is used to load check list combo after render
     * @param cmb
     */
    loadCheckListCombo: function(cmb) {
    	var tabPanel = null;
    	var tabName = null;
    	var btnItemId = null;
    	if(this.getContentPanel().getActiveTab().title.indexOf(getCompletionModuleTranslation('PASSING_OUT_DETAILS_COLON'))>-1){
    		tabPanel = this.getContentPanel().getActiveTab().down('#passingOutTabPanel');
    		tabName = 'passingoutgeneralform';
    		btnItemId = '#generalSave';
    	}
    	if(this.getContentPanel().getActiveTab().title.indexOf(getCompletionModuleTranslation('TERMINATION_DETAILS_COLON'))>-1){
    		tabPanel = this.getContentPanel().getActiveTab().down('#terminationTabPanel');
    		tabName = 'terminationgeneralform';
    		btnItemId = '#generalSubmitBtn';
    	}
    	if(this.getContentPanel().getActiveTab().title.indexOf(getCompletionModuleTranslation('TRANSFER_DETAILS_COLON'))>-1){
    		tabPanel = this.getContentPanel().getActiveTab().down('#transferTabPanel');
    		tabName = 'transfergeneralform';
    		btnItemId = '#transferGeneralSubmitBtn';
    	}
    	if(this.getContentPanel().getActiveTab().title.indexOf(getCompletionModuleTranslation('WITHDRAW_DETAILS_COLON'))>-1){
    		tabPanel = this.getContentPanel().getActiveTab().down('#withdrawProgramTabPanel');
    		tabName = 'withdrawfromprogramgeneralform';
    		btnItemId = '#withdrawGeneralSubmitBtn';
    	}
        this.disableAllButtonLessEffectiveDate(tabPanel,tabName,btnItemId);
        var store = cmb.getStore();
        var id = this.getContentPanel().getActiveTab().getCompletionId();
        store.getProxy().api.read = SERVERURL.COMPLETION_CHEKLIST_URL + id;
        store.load();
    },

    /**
     * This method is used to update check list
     * @param button ref 
     */
    updateCheckList: function(button) {
        var this$ = this;
        var form = button.up('form');
        var formData = form.getValues();
        var passingOutProfileView = this$.getPassingOutProfileView();
        var id = this.getContentPanel().getActiveTab().getCompletionId();
        formData.completionId = id;
        var jsonFormatFormData = Ext.encode(formData);
        this$.sendSaveAjaxRequest(SERVERURL.UPDATE_COMPLETION_CHEKLIST,'PUT', jsonFormatFormData, function(opt, success, response) {
            if (success) {
                showSuccessMessage(getCompletionModuleTranslation('CHEKLIST_DETAILS'), getCompletionModuleTranslation('SAVEDSUCCESSFULLY'));
                this$.setProfileView(passingOutProfileView,id);
            }
        });
    },

    /**
     * This is used to change name of NameCombo
     * @param combo ref
     */
    changeNameFieldConfig: function(combo) {
        var nameField = combo.up('form').down('#selectedName');
        if (nameField != undefined) {
            nameField.setFieldLabel(combo.getRawValue());
            nameField.name = combo.getValue();
        }
    },

    /**
     * THis is used to hide till date field in termination general form in case of termination 
     * @param form reference
     */
    hideTillDateField: function(form) {
    	  var tillDate = form.down('#endDate');
    	  var submitBtn =  form.down('#generalSubmitBtn');
    	  form.down('#startDate').setDisabled(true);
    	   tillDate.setDisabled(true);
    	   tillDate.setVisible(false);
    	   submitBtn.formBind = false;
    	   submitBtn.setDisabled(true);
    },
    
    /** This is used to load payding payment grid 
     * @param formRef
     */
    loadPendingPaymentGrid: function(formRef) {
        var grid = formRef.down('#pendingPaymentGrid');
        var store = grid.getStore();
        var id = this.getContentPanel().getActiveTab().getCompletionId();
        store.getProxy().api.read = SERVERURL.PENDING_PAYMENT_GRID_URL;
        store.load({
        	params : {
        		id : id,
        		billedUserType : 'STUDENT',
        		adjustmentType : 'Bill Payable',
        		feePlanType : ''
        	}
        });
    },
    
    /** This is used to load refund History grid 
     * @param formRef
     */
    loadRefundHistoryGrid: function(formRef) {
        var grid = formRef.down('#refundhistorygridId');
        var store = grid.getStore();
        var id = this.getContentPanel().getActiveTab().getCompletionId();
        store.getProxy().api.read = SERVERURL.REFUND_HISTORY_GIRD_URL;
        store.load({
        	params : {
        		id : id,
        		billedUserType : 'STUDENT',
        		adjustmentType : 'Bill Payable',
        		feePlanType : ''
        	}
        });
    },
    
    /** This is used to load refund History grid 
     * @param formRef
     */
    loadRefundablePaymentGrid: function(formRef) {
        var grid = formRef.down('#refundablepaymentgridId');
        var store = grid.getStore();
        var id = this.getContentPanel().getActiveTab().getCompletionId();
        store.getProxy().api.read = SERVERURL.REFUNDABLE_PAYMENTS_GIRD_URL;
        store.load({
        	params : {
        		id : id,
        		billedUserType : 'STUDENT',
        		adjustmentType : 'Bill Payable',
        		feePlanType : ''
        	}
        });
    },
    
    loadStudentDocument:function(grid) {
 	  var store = grid.getStore();
 	  var studentId = this.getContentPanel().getActiveTab().getStudentId();
 	 var admissionId = this.getContentPanel().getActiveTab().getAdmissionId();
 	   store.load({
 		   params:{
 			  studentId:studentId,
 			 admissionId:admissionId
 		   }
 	   });
    },
    
    /**
     * This method is used to set profile data 
     */
    //TODO
    setProfileView : function(view,id){
    	 var data = this.getCompletionData(id);
    	if(data !== null){
    		 if(data.mobileNumber === null){
   			  data.mobileNumber = getCompletionModuleTranslation('N_A');
   		  }
   		  var templateDataArray=new Array();
   		  templateDataArray.push(data);
   		  view.getStore().loadData(templateDataArray);
   		  var tab= this.getContentPanel().getActiveTab();
   		  tab.setAdmissionId(data.admissionId);
   		  tab.setStudentId(data.studentId);
   		  if(view.itemId !== 'checkListItemId'){
   			  this.setUploadedPhotoToPersonProfile(SERVERURL.PERSON_IMAGE_DOWNLOAD);
   		  }
    	}
		 
		 
    },
    
    /**
     * this method is used to get COmpletion Data 
     * @param id
     */
    getCompletionData : function(id){
    	var data = null;
        var completionId = null;
        var me = this;
        var admissionCode = null;
        var gridWith = this.getWithdrawalProgramSearchResultGrid();
        if(gridWith != undefined) {
        	 Ext.apply(gridWith,{
         		personId:null,
      		  setPersonId : function(personId){
      			 gridWith.personId = personId;
      		  },
      		  getPersonId:function(){
      			  return gridWith.personId;
      		  }
     		});
        }
        if(!(me.getContentPanel().getActiveTab().xtype =="completionpanel")){
            var grid = me.getContentPanel().getActiveTab().down('grid');
            if (grid.getSelectionModel().getCount() > 0) {
             admissionCode = grid.getSelectionModel().getSelection()[0].data.ADMISSION_ID;
             if(isNullOrEmpty(admissionCode)){
            	 admissionCode = grid.getSelectionModel().getSelection()[0].data.admissionCode;
             }
        	}
        } else {
            admissionCode = me.getContentPanel().getActiveTab().getAdmissionCode();
        }
        if(isNullOrEmpty(id)){
      	  completionId = me.getContentPanel().getActiveTab().getCompletionId();
        }else{
            completionId = id;
        }
	  Ext.Ajax.request({
         type: 'rest',
         async: false,
         method: 'GET',
         url: SERVERURL.GET_COMPLETION_PROFILE_STATUS, 
         params: {
       	  id : completionId,
       	  admissionCode : admissionCode
         },
         success: function(response, action) {
       	  if(!isNullOrEmpty(response.responseText)){
       		  data = Ext.decode(response.responseText);
       		  if(gridWith != undefined)
       		  if(!isNullOrEmpty(gridWith)){
       		    gridWith.setPersonId(data.personId);
       		  }
       	  }            	  
         }
     });
   	  return data ;
    },
    
    /**
     * Set photo to person profile image 
     * @param  form
     * @param personId
     * @param personId
     */
    setUploadedPhotoToPersonProfile : function(downloadUrl){
    	var this$ = this;
    	var personProfile = this$.getContentPanel().getActiveTab();
    	var studentId = this$.getContentPanel().getActiveTab().getStudentId();
    	var grid = this$.getWithdrawalProgramSearchResultGrid();
    	var personId = studentId;
    	if(grid != undefined && !isNullOrEmpty(grid)) {
    		personId = grid.getPersonId();
    	}
    	if(!isNullOrEmpty(personId)){
    		Ext.Ajax.request({
                type: 'rest',
                binary: true,
                url: downloadUrl+'?personId='+personId,
                method: 'GET',
                success : function(response){
                	if(response.responseBytes.length>0){
    					 var blob = new Blob([response.responseBytes], {type: 'image/jpg'});
    					 var url = window.URL.createObjectURL(blob);
    					 var a=personProfile.down("#student_profile_image");
    					 a.getEl().dom.src=url;
    					 a.setVisible(false);
    				}
               }

            });
    	}
    	
    },
    
    /**
     * This is used to load selected checklist in itemselector
     * @param form
     */
    loadSelectedChekList : function(form){
    	
    	var itemSelector = form.down('#checkListSelector');
    	var id = this.getContentPanel().getActiveTab().getCompletionId();
    	dataUrl = SERVERURL.UPDATE_COMPLETION_CHEKLIST + '/' + id;	
    	
    	  Ext.Ajax.request({
              type: 'rest',
              method: 'GET',
              url: dataUrl, 
              success: function(response, action) {
            	  if(!isNullOrEmpty(response.responseText)){
            		var data = Ext.decode(response.responseText);
          			var valueArray = new Array();
          			Ext.each(data, function(value) {
          				valueArray.push(value.id);
          			});
          			itemSelector.setValue(valueArray);
            	  }            	  
              }
    	});
    	  itemSelector.doLayout();	
    },
    
    /**
     * This method is used to get document controller 
     */
  	getDocumentController : function(){
    	var this$ = this;
    	return this$.getController('Academia.controller.document.DocumentController');
    },
   /**
    * This method is used to open document form on click of edit button
    */
    editCompletionDoc : function (isView){
    	var this$ = this;
    	var form = null;
        var tab = this$.getContentPanel().getActiveTab();
        var grid = tab.down('completiondocumentgrid');

        if (grid.getSelectionModel().getCount() > 0) {
        	var records = grid.getSelectionModel().getSelection()[0];
        	if(!isEmpty(records)){
        		var documentId = records.get("documentId");
        		this$.getDocumentController().editDocumentFormWindow('completionDocForm', 'EXT_DOCUMENT', documentId);
        		form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
        		form.down('#documentTypeRadioGroup').setReadOnly(true);
        		Ext.apply(form, {
        			isEditable: true
        		});
            	if (isView) {
                    form.down('#documentFormSubmitButtonId').setVisible(false);
                    form = form.getForm();
                    toggleReadOnlyFormItems(form, true);
                }else{
                	form.down('#documentTypeCombo').setReadOnly(true);
                }
            	
        	}
		}else {
            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * show Document form
     */
    showDocumentFormWindowPopUp : function (){
    	var this$ = this;
    	this$.getDocumentController().showDocumentFormWindow('completionDocForm', 'EXT_DOCUMENT');
    	form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
		Ext.apply(form, {
			isEditable: false
		});
    },
    /**
     * This is used to close document form
     */
    closeDocumentWindow: function() {
        var this$ = this;
        this$.getDocumentController().closeDocumentFormWindow();
    },
    	
    /**
     * This is used to get completion status 
     */
    getCompletionStatus : function(){
    	 var status = null;
    	 var id = this.getContentPanel().getActiveTab().getCompletionId();
    	  Ext.Ajax.request({
              type: 'rest',
              async: false,
              method: 'GET',
              url: SERVERURL.GET_COMPLETION_STATUS, 
              params: {
            	  id : id
              },
              success: function(response, action) {
            	  if(!isNullOrEmpty(response.responseText)){
            		  status = Ext.decode(response.responseText);
    }
              }
          });
    	 return status ;
    },
    
    /**
     * This is used to save completion document form
     */
    saveCompletionDocumentForm : function(){
    	var this$ = this;
    	var successMsg, submitUrl;
    	var tab = this$.getContentPanel().getActiveTab();
        var grid = tab.down('completiondocumentgrid');
    	var studentId = tab.getStudentId();
    	var admissionId = tab.getAdmissionId();
    	var isTransient = false;
    	var module = 'student';
    	var entityId = studentId;
    	var entityType = 'student';
    	this$.getDocumentController().saveDocumentForm(entityId, module, entityType, 'EXT_DOCUMENT', function(success, response, isCallBackTransient){
    		
    		if(success){
    			var documentJson = new Object();
    			if(isCallBackTransient == false){
        			var form = this$.getDocumentController().getDocumentTypeForm('EXT_DOCUMENT');
        			var id = form.down('#document_hidden_field');
        	        if (isNullOrEmpty(id.getSubmitValue()) && !(form.isEditable)) {
        	        	submitUrl = SERVERURL.STUDENT_DOCUMENT_SAVE;
        	        	successMsg = getPersonModuleTranslation('DOCUMENT_ADD_SUCCESS');
        	        }else{
        	        	submitUrl = SERVERURL.STUDENT_DOCUMENT_UPDATE;
        	        	successMsg = getPersonModuleTranslation('DOCUMENT_UPDATE_SUCCESS');
        	        	if (grid.getSelectionModel().getCount() > 0) {
                            var records = grid.getSelectionModel().getSelection()[0];
                            documentJson.id = records.get("id");
        	        	}
        	        }
        	        var documentId = Ext.JSON.decode(response.responseText);
            		var student = new Object();
            		var document = new Object();
            		var admission = new Object();
            		admission.id = admissionId;
            		student.id = studentId;
            		document.id = documentId;
            		documentJson.student = student;
            		documentJson.document = document;
            		documentJson.admission =  admission;
            		var docType = form.down('#documentTypeCombo').getValue();
            		var documentStatus = form.down('#documentStatus').getValue();
					if(!isNaN(documentStatus)) {
                         documentStatus=form.down('#documentStatus').valueModels[0].data.code
                    }
            		documentJson.documentType = {
						id: docType
					};
					documentJson.status = documentStatus;
        	        Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        jsonData: documentJson,
                        method: 'POST',
                        success : function(){
                        	this$.getDocumentController().closeDocumentFormWindow();
                        	grid.getStore().reload();
                        	grid.getSelectionModel().deselectAll();
                        	showSuccessMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), successMsg);
                        }
                    });
            		
        		}
    		}
    		
    	}, isTransient);
    },
    /**
     * This is used to delete document form
     */
    deleteDocumentRecord : function(){
    	  var this$ = this;
    	  var tab = this$.getContentPanel().getActiveTab();
          var grid = tab.down('completiondocumentgrid');

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection()[0];
                        var id = "";
                        if (!isNullOrEmpty(records.get("id"))) {
                        	id = records.get("id");
                        	documentId = records.get("documentId");
                        	Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.STUDENT_DOCUMENT_DELETE,
                                method: 'DELETE',
                                params: {
                                    id: id
                                },
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                	grid.getStore().reload();
                                    showSuccessMessage(getPersonModuleTranslation('SUCCESS'), getPersonModuleTranslation('DOCUMENT_DELETE_SUCCESS'));
                                    
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     * This function is used to show total pending items of student on click of cheklist coloumn of passing out list
     * @param grid
     * @author Pritam.Patil
     */
    
    showPendingItems : function(grid){
    	var this$ = this;
    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
    	if(parseInt(selectedRecord.get('CHECKLIST')) != 0) {
	    	var popup = this$.showWindow('showcheklistpopup');
	    	popup.setTitle(getCompletionModuleTranslation('CHECK_LIST')),
	    	templateContainer = popup.down('dataview#checkListItemId');
	    	var id = selectedRecord.get('COMPLETION_ID');
	    	this$.setProfileView(templateContainer,id);
    	}
    },
    showPassoutCheckList : function(grid){
    	var this$ = this;
    	if(grid.getSelectionModel().getCount() == 1) {
    		var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	if(parseInt(selectedRecord.get('checkList')) != 0) {
    	    	var popup = this$.showWindow('completiondetailwindow');
    	    	popup.setTitle(getCompletionModuleTranslation('CHECK_LIST'));
    	    	popup.down('#completionCheckListDetailGrid').setVisible(true);
    	    	popup.down('#completionCertificateDetailGrid').setVisible(false);
    	    	popup.down('form').setVisible(false);
    	    	var store = popup.down('#completionCheckListDetailGrid').getStore();
    	        var id = selectedRecord.get('completionId');
    	        store.getProxy().api.read = SERVERURL.GET_COMPLETION_CHEKLIST_URL + id;
    	        this.resetPageSetting(store);
    	        store.load();
        	}
    	} else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD'));
    	}
    },
    showPassoutPendingFees : function(grid){
    	var this$ = this;
    	if(grid.getSelectionModel().getCount() == 1) {
    		var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	if(parseInt(selectedRecord.get('completionId')) != 0) {
    	    	var popup = this$.showWindow('showfeesduepopup');
    	    	popup.setTitle(getProgramandcourseTranslation('FEE_DUES')),
    	    	templateContainer = popup.down('dataview#checkListItemId');
    	    	var id = selectedRecord.get('completionId');
    	    	this$.setProfileView(templateContainer,id);
        	}
    	}else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD'));
    	}
    },
    showPassoutCeritificate : function(grid){
    	var this$ = this;
    	if(grid.getSelectionModel().getCount() == 1) {
    		var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	if(parseInt(selectedRecord.get('certificate')) != 0) {
    	    	var popup = this$.showWindow('completiondetailwindow');
    	    	popup.setTitle(getProgramandcourseTranslation('CERTIFICATES'));
    	    	popup.down('#completionCheckListDetailGrid').setVisible(false);
    	    	popup.down('#completionCertificateDetailGrid').setVisible(true);
    	    	popup.down('form').setVisible(false);
    	    	var store = popup.down('#completionCertificateDetailGrid').getStore();
    	        var id = selectedRecord.get('completionId');
    	        store.getProxy().api.read = SERVERURL.GET_COMPLETION_CERTIFICATE_URL + id;
    	        this.resetPageSetting(store);
    	        store.load();
        	}
    	}else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD'));
    	}
    },
    
    printCertificate:function(button,gridRef,rec) {
    	var grid = null;
    	if(button){
    		   grid =  button.up('form').down('#issueCertificatesGridId');
    		   if (grid.getSelectionModel().getCount()>0) {
    			   var record = grid.getSelectionModel().getSelection()[0];
    		       this.printFunction(grid,record);
    		   } else{
    			   showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		   }
    	}else{
			grid= gridRef;
			this.printFunction(grid,rec);
		}        
    },
    
    
    printFunction : function(grid,record){
    	
    	var completionId =this.getContentPanel().getActiveTab().getCompletionId() ;
        var csvForm = Ext.create('Ext.form.Panel',{
               items:[{
                      xtype : 'textfield',
                      itemId : 'completionId',
                      name : 'completionId'
               },{
             	  xtype:'textfield',
             	  itemId : 'certificateId',
                   name : 'certificateId'	  
               }]
        });                                                    
        csvForm.down('#certificateId').setValue(record.get("certificateId"));
        csvForm.down('#completionId').setValue(completionId);
        
        csvForm.getForm().submit({
                   target: '_blank',
                   method:'POST',
                   params :{access_token : Ext.Ajax.defaultHeaders.access_token},
                   headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                           
                   url : SERVERURL.PRINT_COMPLETION_CERTIFICATE,
                   standardSubmit :true
        });  

    },
    
    updateSearchCheckboxStatus:function(button) {
    	var grid = button.up('panel').up('panel').down('grid');
    	 if (grid.getSelectionModel().getCount() > 0) {
    		 var record = grid.getSelectionModel().getSelection()[0];
    		 var completionId = record.get('COMPLETION_ID');
    		 var url = SERVERURL.UPDATE_SEARCH_CHECKBOX_STATUS;
    		  var params = {
    				  completionId:completionId
    		  };
    		 this.sendGetAjaxRequest(url,'GET',params,function(option, success, response){
    			 if(success){
    				 showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
    			 }
    		 });
    	 } else {
             showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
         }
    },
    
  //TODO 
    /**
     * this is used to send message 
     */
    sendMessage : function (button){
    	var grid = null;
    	if(button) {
    		grid =  button.up('form').down('grid');
    		var $this = this;
    		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    		var structure = Ext.widget('completionsendmessage', {
    			itemId: 'completionSendMessageWindows'
    		});
    		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
    		/**
    		 * This is to remove tab from content panel and open same tab again
    		 */
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
    		var formWindowTab = $this.getCompletionsendmessage();
    		formWindowTab.down("#selectTemplate").allowBlank=true;
    		formWindowTab.down("#selectTemplate").setVisible(false);
    		formWindowTab.down("#messageName").allowBlank=true;   
    		formWindowTab.down("#messageName").setVisible(false);
    		var templateStore = formWindowTab.down('#selectTemplate').getStore();
    		templateStore.getProxy().extraParams={
    			msgRecipientTypeId:2
    		};
    		templateStore.load();

    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method : "GET",
    			type : 'rest',
    			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode=StudentTemplatebe539740-692d-4ae1-bc17-338c4002874d',	//Committeebe539740-692d-4ae1-bc17-338c4002874d',
    			headers : {
    				'Content-Type' : 'application/json'
    			},
    			success : function(form,action) {
    				var data = Ext.JSON.decode(form.responseText);
    				formWindowTab.down("#id").setValue(data.id);
    				formWindowTab.down("#code").setValue(data.code);
    				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
    				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
    				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
    				Ext.getBody().unmask();

    				//grid.getStore().reload();
    				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
    			}

    		});
    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_TWO);
    		setTimeout(function(){
    			formWindowTab.down("#templateId").setVisible(false);
    		},100);
    		/*if (grid.getSelectionModel().getCount()>0) {
    			   var record = grid.getSelectionModel().getSelection()[0];
    			   console.log(record)
    		   } else{
    			   showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		   }*/
    	}     
    },
    //TODO 
    /**
     * this is used to email  certificate 
     */
    emailCertificate : function(button){
    	var grid = null;
    	if(button){
    		   grid =  button.up('form').down('#issueCertificatesGridId');
    		   var completionId = this.getContentPanel().getActiveTab().getCompletionId() ;
    		   var selection = grid.getSelectionModel().getSelection();
    		   if (grid.getSelectionModel().getCount()>0) {
				   var certificateIds = [];
				   for(var i = 0; i < selection.length; i++) {
                	certificateIds.push(selection[i].get('certificateId'));
        		   }
        		   certificateIds = certificateIds.join(",")
				   Ext.Ajax.request({
		                method: "GET",
		                type: 'rest',
		                url: SERVERURL.SEND_PASSOUT_EMAIL_TO_STUDENTS,
		                params: {
		                       completionIds: completionId,
		                       certificateIds : certificateIds
		                   },
		                success : function(form, action) {
		                    var msg = form.responseText;
		                    if(msg!='' && msg=='SUCCESS'){
		                        grid.getStore().reload();
		                        showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
		                    }
		                    else{
								showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('NO_TEMPLATE_MAPPED'));
							}
		                }
		            });
				   
    		   } else{
    			   showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		   }
    	}      
    },
    
    //TODO 
    /**
     * this is used to send message 
     */
    sendNotification : function (button){
    	var grid = null;
    	if(button){
    		   grid =  button.up('form').down('grid');
    		   if (grid.getSelectionModel().getCount()>0) {
    			   var record = grid.getSelectionModel().getSelection()[0];
    			   console.log(record)
    		   } else{
    			   showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    		   }
    	}     
    },
    /*Start :- added for adhoc messsaging*/
    openTermisionSendMessage:function(obj){

    	//var grid = this.getIssuecertificatesform();
    	var admissionId = this.getContentPanel().getActiveTab().getAdmissionId();
    	grid =  obj.up('form').down('grid');
    	var gridName = grid.itemId;
    	var termiantionCustomUrl = null;
    	if(obj.up('form').up('panel').id.indexOf('withdrawprogramtabpanel') != -1){
    		if(gridName == "completionPendingRefundablesBillGrid"){
    			termiantionCustomUrl = 'withdrawalRefundableTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "issueCertificatesGridId"){
    			termiantionCustomUrl = 'withdrawalTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "completionDocumentGridId"){
    			termiantionCustomUrl = 'withdrawalDocumentTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "completionpendingBillGrid"){
    			termiantionCustomUrl = 'withdrawalPaymentTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}	
    	}else if(obj.up('form').up('panel').id.indexOf('terminationtabpanel') != -1){
    		if(gridName == "completionPendingRefundablesBillGrid"){
    			termiantionCustomUrl = 'terminationRefundableTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "issueCertificatesGridId"){
    			termiantionCustomUrl = 'terminationTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "completionDocumentGridId"){
    			termiantionCustomUrl = 'terminationDocumentTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "completionpendingBillGrid"){
    			termiantionCustomUrl = 'terminationPaymentTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}	
    	}else if(obj.up('form').up('panel').id.indexOf('transfertabpanel') != -1){
    		if(gridName == "completionPendingRefundablesBillGrid"){
    			termiantionCustomUrl = 'transferRefundableTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "issueCertificatesGridId"){
    			termiantionCustomUrl = 'transferTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "completionDocumentGridId"){
    			termiantionCustomUrl = 'transferDocumentTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}else if(gridName == "completionpendingBillGrid"){
    			termiantionCustomUrl = 'transferPaymentTemplatebe539740-692d-4ae1-bc17-338c4002874d';
    		}	
    	}
		
    	//var gridMSG = this.getStaticDocumentAttachmentGrid();
//    	if(grid.getSelectionModel().getCount()>0) {

    		var $this=this;
    		var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
    		var structure = Ext.widget('terminationsendmessages',{
    			itemId:'terminationSendMsgID'
    		});
    		var tabName = getMessagingModuleTranslation('ANNOUNCEMENTS');
    		/**
    		 * This is to remove tab from content panel and open same tab again
    		 */
    		var getcontroller=this.getController('menu.CoreERPNavigationController');
    		var getTab=getcontroller.getTab(tabName);
    		if(getTab!=null){
    			contentPanel.remove(getTab, true);
    		}
    		var formWindowTab = $this.getTerminationsendmessages();
    		formWindowTab.down("#selectTemplate").allowBlank=true;
    		formWindowTab.down("#selectTemplate").setVisible(false);
    		formWindowTab.down("#messageName").allowBlank=true;   
    		formWindowTab.down("#messageName").setVisible(false);
    		var templateStore = formWindowTab.down('#selectTemplate').getStore();
    		templateStore.getProxy().extraParams={
    			msgRecipientTypeId:2
    		};
    		templateStore.load();    		

    		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    		Ext.Ajax.request({
    			method : "GET",
    			type : 'rest',
    			url : SERVERURL.FIND_MESSAGE_TEMPLATE_CODE+'?msgCode='+termiantionCustomUrl,
    			headers : {
    				'Content-Type' : 'application/json'
    			},
    			success : function(form,action) {
    				var data = Ext.JSON.decode(form.responseText);
    				formWindowTab.down("#id").setValue(data.id);
    				formWindowTab.down("#code").setValue(data.code);
    				formWindowTab.down("#templateConfigName").setValue(data.templateConfigName);
    				formWindowTab.down("#msgSubCategoryId").setValue(data.msgSubCategoryId);
    				formWindowTab.down("#msgCategoryId").setValue(data.msgCategoryId);
    				Ext.getBody().unmask();

    				//grid.getStore().reload();
    				//showSuccessMessage(getPlacementTranslation('PROGRAM_PERIOD'),getPlacementTranslation('PATH_PLACEMENT_CAMPUS_PERIOD_DELETED_SUCCESSFULLY'));
    			}

    		});
    		openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_SIX);

    	/*} else {
    		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}*/
    },
   
    selectTermisionSectionMessageType : function(val,nV,oV){

    	var $this =  this;
    	var formWin = $this.getTerminationsendmessages();

    	//var value = nV.1;
    	if(nV.messageType==2){
    		formWin.down("#messageId").hide();
    		formWin.down("#selectTemplate").allowBlank=true;
    		formWin.down("#selectTemplate").setVisible(false);     		 
    		formWin.down("#messageName").allowBlank=true;   
    		formWin.down("#messageName").setVisible(false);
    		formWin.down("#msgTempletId").setVisible(true);
    		formWin.down("#msgTempletId").allowBlank=false;
    		formWin.down("#msgTempletId").reset();
    		formWin.down("#subject").setVisible(true);
    		formWin.down("#subject").allowBlank=false;
    		formWin.down("#subject").reset();
    		formWin.down("#discriptionId").setVisible(true);
    		formWin.down("#discriptionId").reset();
    		formWin.down('#smsDiscription').reset();
    		formWin.down('#smsDiscription').hide();
    		formWin.down('#smsDiscriptionNotice').hide();
    	}else{
    		formWin.down("#msgTempletId").allowBlank=true;
    		formWin.down("#msgTempletId").setVisible(false);     		
    		formWin.down("#messageId").setVisible(true);
    		formWin.down("#selectTemplate").setVisible(true);     		
    		formWin.down("#messageName").setVisible(true);
    		formWin.down("#messageName").reset();
    		formWin.down("#subject").allowBlank=true;
    		formWin.down("#subject").setVisible(false);
    		formWin.down("#discriptionId").setVisible(false);
    		formWin.down("#messageName").allowBlank=false;  
    		formWin.down("#selectTemplate").allowBlank=false;
    		formWin.down("#selectTemplate").reset();
    		formWin.down("#terminationDocumentMessageAttachmentGrid").setVisible(false);
    		formWin.down("#staticUploadFileField").setVisible(false);
    		formWin.down('#smsDiscription').reset();
    		formWin.down('#smsDiscription').hide();
    		formWin.down('#smsDiscriptionNotice').hide();
    		var allowblankFalse = '<span class="required" style="color:red"> *</span>';
    		formWin.down("#messageName").setFieldLabel(getMessagingModuleTranslation('MESSAGE_NAME')+allowblankFalse);
    		formWin.down("#selectTemplate").setFieldLabel(getMessagingModuleTranslation('SELECT_TEMPLATE')+allowblankFalse);
    	}
    },
    selectTermisionMessageTemp: function(obj,rec){
    	var $this =  this;
    	var formWin = $this.getTerminationsendmessages();
    	if(rec[0].data.value == "SMS")
    	{
    		formWin.down("#subject").allowBlank=true;
    		formWin.down("#subject").hide();
    		formWin.down("#staticUploadFileField").hide();
    		formWin.down("#terminationDocumentMessageAttachmentGrid").hide();
    		formWin.down('#discriptionId').reset();
    		formWin.down('#discriptionId').hide();	       		 
    		formWin.down('#subject').reset();
    		formWin.down('#smsDiscription').show();
    		formWin.down('#smsDiscriptionNotice').show();
    	}else
    	{
    		formWin.down('#discriptionId').reset();
    		formWin.down('#smsDiscription').reset();
    		formWin.down('#smsDiscription').hide();
    		formWin.down('#smsDiscriptionNotice').hide();
    		formWin.down("#staticUploadFileField").show();
    		formWin.down("#terminationDocumentMessageAttachmentGrid").show()
    		formWin.down("#subject").show();
    		formWin.down("#subject").allowBlank=false;
    		formWin.down('#discriptionId').show();    		
    	}
    },
    /**
     * upload static document file for Student
     */
    uploadTermisionStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts){
    	var this$ = this;
    	var setupForm = fileField.up('terminationsendmessages');
    	var grid = setupForm.down('#terminationStaticDocumentAttachmentGridMessage');
    	fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
    	if(!isNullOrEmpty(fileUploadPath)){
    		var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
    		if (extension == "gif" || extension == "png" || extension == "bmp"
    			|| extension == "jpeg" || extension == "jpg" || extension == "pdf" 
    				|| extension == "doc" || extension == "docx" || extension == "txt"
    					|| extension == "xls" || extension == "csv" || extension == "xml") {
    			var entityId = 'completion';
    			var module = 'messaging';
    			var entityType = 'template';
    			var documentType = 'DOCUMENT';
    			var isTransient = true;
    			var this$ = this;
    			this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient){
    				if(success){
    					var path = Ext.JSON.decode(action.response.responseText).path;
    					var user = this$.getCurrentlyLoggedInUser();
    					var store = grid.getStore();
    					var documentStatus = "SUBMITTED";
    					var documentType = null;
    					if(!isNullOrEmpty(path)){
    						store.add({
    							id: '',
    							name: fileUploadPath,
    							path: path ,
    							createdBy : {
    								id :user.id,
    								value : user.value,
    								code : user.code
    							},
    							status : documentStatus,
    							documentType : documentType,
    							templateConfigDocId: '',
    							submissionDate: Ext.Date.format(new Date(), 'd-m-Y')

    						});
    						this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
    						showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
    					}

    					fileField.reset();
    				}

    			}, isTransient);
    		}else{
    			fileField.reset();
    			showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
    		}
    	}
    },

    /**
     * Add value to grid
     */
    loadGridWithFileNameMessage:function(grid,value,store){
    	grid.bindStore(store);
    },
    /**
     * Remove entry from grid
     */
    deleteTermisionStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
    	var grid = view.up('#terminationStaticDocumentAttachmentGridMessage');
    	var panel = this.getContentPanel().getActiveTab();
    	var tabTitle = panel.title;
    	var store = grid.getStore();
    	var templateConfigDocId = record.get('templateConfigDocId');
    	var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
    	if(!(tabTitle == viewTitle)){
    		if(!isNullOrEmpty(templateConfigDocId)){
    			showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
    				if (btn == 'yes') {
    					Ext.Ajax.request({
    						type: 'rest',
    						url: SERVERURL.STATIC_DOC_DELETE,
    						method: 'DELETE',
    						params: {
    							templateConfigDocId : templateConfigDocId
    						},
    						headers: {
    							'Content-Type': 'application/json'
    						},
    						success: function(form, action) {
    							store.remove(record);
    							showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
    						}
    					});
    				}
    			});

    		}else{
    			store.remove(record);
    			showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
    		}
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
    	}

    },
    /**
     * save document file. It's external call method
     * @param entityId : person id, It's mandatory. 
     * @param module : module name, for student module 'student', It's mandatory.
     * @param entityType : entity type, It's mandatory.
     * @param documentType : document type, It's mandatory.
     * @param isTransient : true or false (send json back to module controller or not)
     * @param callBackFunction : callback function return in module controller. It's mandatory.
     */
    saveStaticDocumentFormMessage : function(entityId, module, entityType, documentType, callBackFunction, isTransient){
    	var submitUrl = '';
    	var templateTab = this.getContentPanel();
    	var formWin =  this.getTerminationsendmessages();
    	if(!formWin) {
    		formWin = this.getCompletionsendmessage();
    	}
    	var form = formWin.down('#msgDetailsForm');
    	var id = form.down('#document_hidden_field');
    	if (isNullOrEmpty(id.getSubmitValue())) {
    		submitUrl = SERVERURL.DOCUMENT_FILE_ADD;
    	}
    	var data = new Object();
    	if(!isNullOrEmpty(entityId)){
    		data.entityId = entityId;
    	}else{
    		data.entityId = null;
    	}
    	if(!isNullOrEmpty(module)){
    		data.module = module;
    	}else{
    		data.module = null;
    	}
    	if(!isNullOrEmpty(entityType)){
    		data.entityType = entityType;
    	}else{
    		data.entityType = null;
    	}
    	form.getForm().setValues(data);
    	form.getForm().submit({
    		method : 'POST',
    		url : submitUrl,
    		success : function(form, action){
    			callBackFunction(true, action, isTransient);

    		}
    	});
    }, 
    /**
     * This method is to enable schedule field
     */
    loadTermisionScheduleField : function(radio,newValue, oldValue){
    	var adhocMessageForm = radio.up('form');
    	var scheduleDateField = adhocMessageForm.down('#scheduleDate');
    	var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
    	var radioValue = radio.getValue().sendingPriority;

    	if(radioValue=='IMMEDIATE'){
    		scheduleDateField.setVisible(false);
    		scheduleDateField.setDisabled(true);
    		scheduleTimeField.setVisible(false);
    		scheduleTimeField.setDisabled(true);    		
    	}
    	else if(radioValue=='SCHEDULE'){
    		scheduleDateField.setVisible(true);
    		scheduleDateField.setDisabled(false);
    		scheduleTimeField.setVisible(true);
    		scheduleTimeField.setDisabled(false);
    	}
    },
    /*End added adhoc messaging*/ 
    checkEligibility : function(){
    	var grid = this.getPassingoutgrid();
    	if(grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		var passingOutModels =[]; 
    		for(var rec in records){
    			var passingOutModel = Ext.create('Academia.model.completion.completionform.PassingOutGridModel');
    			passingOutModel.set("admissionId",records[rec].get('admissionId'));
    			passingOutModel.set("batchId",records[rec].get('batchId'));
    			passingOutModel.set("completionId",records[rec].get('completionId'));
    			delete passingOutModel.data.version;
    			delete passingOutModel.data.admissionCode;
    			delete passingOutModel.data.studentCode;
    			delete passingOutModel.data.studentName;
    			delete passingOutModel.data.studentLastName;
    			delete passingOutModel.data.programName;
    			delete passingOutModel.data.batchName;
    			delete passingOutModel.data.sectionName;
    			delete passingOutModel.data.checkList;
    			delete passingOutModel.data.effectionTransferDate;
    			delete passingOutModel.data.effectivePassoutCommunicationDate;
    			delete passingOutModel.data.status;
    			delete passingOutModel.data.certificate;
    			delete passingOutModel.data.studentId;
    			delete passingOutModel.data.personId;
    			delete passingOutModel.data.passoutEligibility;
    			delete passingOutModel.data.rejectedById;
    			
    			passingOutModels.push(passingOutModel.data);
    		}
 	    	  var formData = Ext.encode(passingOutModels);
 	    	  Ext.Ajax.request({
 	    		  type : 'rest',
 	    		  url : SERVERURL.COMPUTE_STUDENT_PASSOUT_ELIGIBILITY,
 	    		  jsonData : formData,
 	    		  method : 'POST',
 	    		  success : function(form, action) {
 	    			 var msg = form.responseText;
 	    			if(msg!='' && msg=='SUCCESS'){
 	    				grid.getStore().reload();
 	    				showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
 	    			}
 	    		  }
 	    	  });
    	} else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    exportPrintCertificates : function() {
    	var grid = this.getPassingoutgrid();
    	if(grid.getSelectionModel().getCount() > 0) {
    		var selection = grid.getSelectionModel().getSelection();
    		var completionIds = [];
    		for(var i = 0; i < selection.length; i++) {
    			completionIds.push(selection[i].get('completionId'));
    		}
    		var popup = this.showWindow('printcertificatewindow');
    		var certificateNameStore = popup.down('#certificateNameId').getStore();
    		certificateNameStore.getProxy().extraParams = {
    			completionIds: completionIds.join(",")
    		};
    		certificateNameStore.load();
    		popup.down('#completionIds').setValue(completionIds.join(","));
    	} else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
    	}
    	/*var grid = this.getPassingoutgrid();
    	if(grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		var completionIdss =[]; 
    		for(var rec in records){
    			completionIdss.push(records[rec].get('completionId'))
    		}
    		var csvForm = Ext.create('Ext.form.Panel',{
                items:[{
                       xtype : 'textfield',
                       itemId : 'completionId',
                       name : 'completionIdss'
                }]
         });                                                    
         csvForm.down('#completionId').setValue(completionIdss.join());
         
         csvForm.getForm().submit({
                    target: '_blank',
                    method:'POST',
                    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
                    headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                           
                    url : SERVERURL.EXPORT_PASSING_CERTIFICATES_ZIP,
                    standardSubmit :true
         });
    	} else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
    	}*/
    },
    
    emailCertificates : function(grid,btn,url) {
	if(!Ext.isDefined(url) || isNullOrEmpty(url)){
			url=SERVERURL.SEND_PASSOUT_EMAIL_TO_STUDENTS;
		}
	var win=btn.up("window");
	var certificateemail=win.down("#certificateemailId");
	if(!isNullOrEmpty(certificateemail.getValue())){
		var tempCertificateemail=certificateemail.getValue();
		var certificateemailIds = [];
		for(var i = 0; i < tempCertificateemail.length; i++) {
			if(typeof tempCertificateemail[i] == "object"){
				certificateemailIds.push(tempCertificateemail[i].data.certificateId);
			}
			else if(!isNullOrEmpty(tempCertificateemail[i])){
				certificateemailIds.push(tempCertificateemail[i]);
			}
		}
    	if(grid.getSelectionModel().getCount() > 0) {
    		var selection = grid.getSelectionModel().getSelection();
    		var completionIds = [];
    		for(var i = 0; i < selection.length; i++) {
				if(!Ext.isDefined(selection[i].raw.completionId)){
	    			completionIds.push(selection[i].raw.COMPLETION_ID);
				}else{
					completionIds.push(selection[i].raw.completionId);
				}
    		}
    		var completionIds = completionIds.join(",")
    		Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: url,
    			params: {
			   		completionIds: completionIds,
					certificateIds:certificateemailIds.join(",")
		   		},
    			success : function(form, action) {
    				var msg = form.responseText;
    				if(msg!='' && msg=='SUCCESS'){
    					grid.getStore().reload();
    					showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
    				}else if(msg!='' && msg=='NO_TEMPLATE_MAPPING'){
						showWarningMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('NO_TEMPLATE_MAPPED'));
					}
					win.close();
    			}
    		});
    	} else {
	
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
    	}
	}else{
		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
	}
	
    },
    
    markCompleteCompletion : function() {
    	var this$ = this;
    	var grid = this.getPassingoutgrid();
    	var selectedRecord = grid.getSelectionModel().getSelection();
    	if(grid.getSelectionModel().getCount() > 0) {
    		for(var rec in selectedRecord) {
    			if(selectedRecord[rec].get('status') == "PASSED_OUT") {
    				showWarningMessage(getCompletionModuleTranslation('ALERT'), getProgramandcourseTranslation('PASSOUT_STUDENT_SELECTED'));
    				return;
    			}
    		}
	    	var popup = this$.showWindow('completiondetailwindow');
	    	popup.setTitle(getProgramandcourseTranslation('MARK_COMPLETE'));
	    	popup.down('#completionCheckListDetailGrid').setVisible(false);
	    	popup.down('#completionCertificateDetailGrid').setVisible(false);
	    	popup.down('form').setVisible(true);
    	} else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    completeCompletionProcess : function() {
    	var this$ = this;
    	var formWindow = this.getCompletiondetailwindow();
    	var markCheckList = formWindow.down('#markCheckListComplete').getValue()
    	var markCertificate = formWindow.down('#markCertificateComplete').getValue();
    	var effectiveTransferDate = formWindow.down('form').down('#effectiveTrasferDate').getValue()
    	var effectivePassoutCommunicationDate = formWindow.down('form').down('#effectivePassoutCommunicationDate').getValue()
    	var decisionNumber = formWindow.down('form').down('#decisionNumber').getValue()
    	var grid = this.getPassingoutgrid();
    	if(grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		var completionIdss =[];
    		for(var rec in records){
    			completionIdss.push(records[rec].get('completionId'))
    		}
    		var passingOutModel = Ext.create('Academia.model.completion.completionform.PassoutMarkCompleteModel');
			passingOutModel.set("completionIds",completionIdss.join());
			passingOutModel.set("markCheckList",markCheckList);
			passingOutModel.set("markCertificate",markCertificate);
			passingOutModel.set("effectiveTransferDate",effectiveTransferDate);
			passingOutModel.set("effectivePassoutCommunicationDate",effectivePassoutCommunicationDate);
			passingOutModel.set("decisionNumber",decisionNumber);
			
			delete passingOutModel.data.version;
	    	var formData = Ext.encode(passingOutModel.data);
    		Ext.Ajax.request({
    			method: "POST",
    			type: 'rest',
    			url: SERVERURL.MARK_COMPLETE_PASSING_OUT_COMPLETION,
    			jsonData : formData,
    			success : function(form, action) {
    				var msg = form.responseText;
    				if(msg!='' && msg=='SUCCESS'){
    					formWindow.close();
    					grid.getStore().reload();
    					showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
    				}
    			}
    		});
    	}
    },
    getValidateFields :function(win ,currentField,valueOfCuurentField){
    	var saveBtn = win.down('#completeCompletionSaveItemId');
    	var markCheckListComplete = win.down('#markCheckListComplete');
    	var markCertificateComplete = win.down('#markCertificateComplete');
    	var effectiveTrasferDate = win.down('#effectiveTrasferDate');
    	var effectivePassoutCommunicationDate = win.down('#effectivePassoutCommunicationDate');
    	var decisionNumber = win.down('#decisionNumber');
    	
    	var saveEnable = false;
    	
    	
    	var formFieldsItems = win.down('form').getForm().getFields().items;
    	
    	
    	for(var i=0 ;i < formFieldsItems.length ;i++){
                 if(formFieldsItems[i].isVisible && formFieldsItems[i].isMandatory){
        		
        		if(formFieldsItems[i].getValue()){
        			saveEnable =true;
        		}else{
        			saveEnable =false;
        			break;
        		}
        	}if(formFieldsItems[i].isVisible && !formFieldsItems[i].isMandatory){ 
        		
        			saveEnable =true;
        		
        	}	
    	}
    	if(saveEnable){
    		saveBtn.enable();
    	}else{
    		saveBtn.disable();
    		
    	}
    },
    
     exportCompletionCertificate : function(btn){
		   var form = this.getWithdrawProgramQuickSearchForm();
		   var programId = form.down('#programId').value;
		   var store=Ext.create('Academia.store.common.GraduationCertificateToBePrintStore');
    	  var grid = this.getPassingoutgrid();
    	  if(grid.getSelectionModel().getCount() > 0) {
     	  var records = grid.getSelectionModel().getSelection();
    		var completionIdss =[]; 
    	    var code;
    		var studentIdss=[];
    		for(var rec in records){
    			completionIdss.push(records[rec].get('completionId'));
    			studentIdss.push(records[rec].get('studentId'));
    			code=records[rec].get('code');
    			programId = records[0].get('programId');
    		}
    		store.load();
            //store.
           var $this = this;
          
			   user=$this.getCurrentlyLoggedInUser();  
			   var contentPanel=$this.getContentPanel();
			   var studentId=contentPanel.getActiveTab().userId;
			   var studentPersonId=contentPanel.getActiveTab().personId;
			   var title= contentPanel.getActiveTab().title+"-"+ new Date().getTime();
			   var admissionId = contentPanel.getActiveTab().admissionId;
 			   
 			   var reportParams =new Object();
 			   reportParams.id=completionIdss.join();
			   reportParams.reportTitle=title;
			   reportParams.academyLocationId = $this.getCurrentAcademyLocation();
			   if(isNullOrEmpty(code)){
			   	reportParams.code='NECB_CERTIFICATE';
			   }else{
				reportParams.code=code.trim();
			   }
			   reportParams.studentIds = studentIdss.join();
			   reportParams.programId=programId;
			   reportParams.documentType = btn.up('window').down('radiogroup').getValue().docType;
			   $this.exportJRXMLReport(reportParams.code,reportParams,title,'.pdf',SERVERURL.EXPORT_COMPLETION_CERTIFICATES);  
			   if(btn.up('window')) {
				   btn.up('window').close();
			   }
    	} else {
    		showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
    	}
    },
    hidePublishGraduationCertificateButton :function(grid,permissionsMap){
    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	var publishGraduationCertificate = grid.down('#publishGraduationCertificate');
		var certificateBtnId = grid.down('#certificateBtnId');
    	publishGraduationCertificate.setVisible(false);
        var emailCertificate = grid.down('#emailCertificateButtonId');
        var printCertificate = grid.down('#printCertificateButtonId');
    	emailCertificate.setVisible(false);
		certificateBtnId.setVisible(false);
		printCertificate.setVisible(false); 
    	Ext.each(permissionList, function(privilege) {
    		if (privilege == 'PUBLISH_GRADUATION_CERTIFICATE') {
    			if(!isNullOrEmpty(publishGraduationCertificate)){
    				publishGraduationCertificate.setVisible(true);	
    			}
			} else if (privilege == 'EMAIL_CERTIFICATE') {
				if (!isNullOrEmpty(emailCertificate)) {
					emailCertificate.setVisible(true);
				}
			}else if (privilege == 'PRINT_GRADUATION_CERTIFICATE') {
    			if(!isNullOrEmpty(certificateBtnId)){ 
    				certificateBtnId.setVisible(true);	
    			}
    		}else if (privilege == 'PRINT_CERTIFICATE') {
    			if(!isNullOrEmpty(printCertificate)){ 
    				printCertificate.setVisible(true);	
    			}
    		}
    	});
	},
    publishGraduationCertificate : function() {
    	var this$ = this;
        var grid = this.getPassingoutgrid();
    	if(grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection();
    		var completionIdss =[];
    		for(var rec in records){
    			completionIdss.push(records[rec].get('completionId'))
    		}
    		
	    	Ext.Ajax.request({
    			method: "GET",
    			type: 'rest',
    			url: SERVERURL.PUBLISH_GRADUATION_CERTIFICATE,
    			params:{
    				ids: completionIdss.join()
    			},
    			success : function(form, action) {
    				grid.getStore().reload();
    					showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
    				
    			}
    		});
    	}
    },
    disableWithDrawAndPassOutBypassButtonsPivileges:function(structure,permissionMap){

    	var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		
		if (permissionList.indexOf('PENDING_PAYMENT') != -1) {
			structure.insert(2, {
				xtype: 'pendingpaymentform',
				title: getCompletionModuleTranslation('PENDING_PAYMENT'),
				itemId: 'completion_pending_payments',
				closable: false,
				border: false,
				cls: 'panelNoSpace',
				bodyStyle: {
					overflow: 'auto !important'
				}
			});
		}
		 if (permissionList.indexOf('REFUND_HISTORY') != -1) {
			structure.insert(3, {
				xtype : 'pendingrefundsform',
				title: getCompletionModuleTranslation('REFUND_HISTORY'),
				itemId : 'completion_pending_refunds',
	            closable: false,
	            border : false,
		        cls:'panelNoSpace',
                bodyStyle: {
                    overflow: 'auto !important'
                }
			});
		}
		 if (permissionList.indexOf('PENDING_REFUNDABLE') != -1) {
			structure.insert(4, {
				xtype : 'pendingrefundablesform',
				title: getCompletionModuleTranslation('PENDING_REFUNDABLES'),
				itemId : 'completion_pending_refundables',
	            closable: false,
	            border : false,
		        cls:'panelNoSpace',
                bodyStyle: {
                    overflow: 'auto !important'
                }
			});
		}
		 if (permissionList.indexOf('ISSUE_CERTIFICATES') != -1) {
			structure.insert(5, {
				xtype : 'issuecertificatesform',
				title:getCompletionModuleTranslation('ISSUE_CERTIFICATES'),
				itemId : 'completion_issue_certificate',
	            closable: false,
	            border : false,
		        cls:'panelNoSpace',
                bodyStyle: {
                    overflow: 'auto !important'
                }
			});
		}
		if (permissionList.indexOf('DOCUMENTS') != -1) {
			structure.insert(6, {
				xtype : 'documentform',
				title:getCompletionModuleTranslation('DOCUMENT'),
				itemId : 'completion_document',
	            closable: false,
	            border : false,
		        cls:'panelNoSpace',
                bodyStyle: {
                    overflow: 'auto !important'
                }
			});
		}
		var byPassPendingRefBtn = structure.down('#byPassPendingRefBtn');
		var byPassPendingBtn = structure.down('#byPassPendingBtn');
		var byPassPendingCheckBox = structure.down('#byPassPendingCheck');
		var byPassPendingRefCheck = structure.down('#byPassPendingRefCheck');
		var emailCertificateBtn = structure.down('#emailCertificateBtn');
		
		if(!isNullOrEmpty(byPassPendingRefBtn)){
			byPassPendingRefBtn.setVisible(false);
		}	
		if(!isNullOrEmpty(byPassPendingBtn)){
			byPassPendingBtn.setVisible(false);
		}
		if(!isNullOrEmpty(byPassPendingCheckBox)){
			byPassPendingCheckBox.setVisible(false);
		}
		if(!isNullOrEmpty(byPassPendingRefCheck)){
			byPassPendingRefCheck.setVisible(false);
		}		
		if(!isNullOrEmpty(emailCertificateBtn)){
			emailCertificateBtn.setVisible(false);
		}
    	

    	Ext.each(permissionList, function(privilege) {
    		
    		if (privilege === 'BYPASS_PENDING_REFUNDABLE_VALIDATION') {
        		if(!isNullOrEmpty(byPassPendingRefBtn)&& !isNullOrEmpty(byPassPendingCheckBox)){
        			byPassPendingRefBtn.setVisible(true);
        			byPassPendingCheckBox.setVisible(true);
        		}        		
        	}
    		if (privilege === 'BYPASS_PENDING_PAYMENTS_VALIDATION') {
        		if(!isNullOrEmpty(byPassPendingBtn) && !isNullOrEmpty(byPassPendingRefCheck)){
        			byPassPendingBtn.setVisible(true);
        			byPassPendingRefCheck.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PASSINGOUT_BYPASS_PENDING_REFUNDABLE_VALIDATION') {
        		if(!isNullOrEmpty(byPassPendingRefBtn) && !isNullOrEmpty(byPassPendingCheckBox)){
        			byPassPendingRefBtn.setVisible(true);
        			byPassPendingCheckBox.setVisible(true);
        		}        		
        	}
    		if (privilege === 'PASSINGOUT_BYPASS_PENDING_PAYMENTS_VALIDATION') {
        		if(!isNullOrEmpty(byPassPendingBtn)&& !isNullOrEmpty(byPassPendingRefCheck)){
        			byPassPendingBtn.setVisible(true);
        			byPassPendingRefCheck.setVisible(true);
        		}        		
        	}if (privilege === 'EMAIL_ISSUE_CERTIFICATE') {
        		if(!isNullOrEmpty(emailCertificateBtn)){
        			emailCertificateBtn.setVisible(true);
        			
        		}        		
			}
    });
   },
   getPayementBypassStatus:function(structure,completionId){
	   var byPassPendingBtn = structure.down('#byPassPendingBtn');
	   var byPassPendingRefBtn = structure.down('#byPassPendingBtn');
	   isPaymentByPassDone=false;
	   isRefundableByPassDone=false;
	   Ext.Ajax.request({
		   method : "GET",
		   type : 'rest',
		   url : SERVERURL.GET_PENDING_PAYMENT_AND_REFUNDS,
		   params: {
			   id: completionId,
		   },
		   success : function(response) {
			   var data = Ext.decode(response.responseText);
			   if(data[0].PENDING_PAYMENTS=='True'){
				   byPassPendingBtn.setDisabled(true);
				   isPaymentByPassDone=true;
			   }
			   if(data[0].PENDING_REFUNDS=='True'){
				   byPassPendingRefBtn.setDisabled(true);
				   isRefundableByPassDone=true;
			   }
		   }
	   });
   },
   
   onPrintCertificateSubmit: function(btn) {
	   var vals = btn.up('form').getValues();
	   var grid = this.getPassingoutgrid();
	   /*var selection = grid.getSelectionModel().getSelection();*/
	   /*var completionIds = [];
	   for(var i = 0; i < selection.length; i++) {
		   completionIds.push(selection[i].get('completionId'));
	   }*/
	   /*var certificateIds = [];
	   for(var j = 0; j < vals.completionIds.length; j++) {
		   certificateIds.push(vals.completionIds[j].get('certificateId'));
	   }*/
	   btn.up('form').getForm().submit({
		   target: '_blank',
		   method:'POST',
		   params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		   headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                           
		   url : SERVERURL.EXPORT_PASSING_CERTIFICATES_ZIP,
		   standardSubmit :true
	   });
	   btn.up('window').close();
	   grid.getSelectionModel().deselectAll();
	   grid.getStore().reload();
	   /*Ext.Ajax.request({
		   //params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		   //headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                           
		   url : SERVERURL.EXPORT_PASSING_CERTIFICATES_ZIP,
		   method: "POST",
		   //type: 'rest',
		   //url: SERVERURL.PATH_EXPORT_PASSING_COMPLETION_CERTIFICATES,
		   jsonData : {
			   completionIds: completionIds.join(","),
			   certificateIds: certificateIds.join(","),
			   isPrintWordDoc: vals.printAsWordFile
		   },
		   success : function(form, action) {
			   var msg = form.responseText;
			   if(msg!='' && msg=='SUCCESS'){
				   formWindow.close();
				   grid.getStore().reload();
				   showSuccessMessage(getCompletionModuleTranslation('COMPLETION'), getCommonTranslation('SUCCESS'));
			   }
		   }
	   });*/
   },
   
   onPrintCertificateSendTo: function(btn) {
	   var vals = btn.up('form').getValues();
	   var grid = this.getPassingoutgrid();
	   var selection = grid.getSelectionModel().getSelection();
	   var completionIds = [];
	   for(var i = 0; i < selection.length; i++) {
		   completionIds.push(selection[i].get('completionId'));
	   }
	   /*var certificateIds = [];
	   for(var j = 0; j < vals.completionIds.length; j++) {
		   certificateIds.push(vals.completionIds[j].get('certificateId'));
	   }*/
	   /*btn.up('form').getForm().submit({
		   target: '_blank',
		   method:'POST',
		   params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		   headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                           
		   url : SERVERURL.PATH_SEND_CERT_TO_STUDENT,
		   standardSubmit :true
	   });*/
	   Ext.Ajax.request({
		   //params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		   //headers :{'Accept':'application/pdf','Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},                                           
		   url : SERVERURL.PATH_SEND_CERT_TO_STUDENT + '?completionIds='+vals.completionIds+'&certificateIds='+vals.certificateIds+'&isPrintWordDoc='+vals.isPrintWordDoc,
		   method: "POST",
		   //type: 'rest',
		   //url: SERVERURL.PATH_EXPORT_PASSING_COMPLETION_CERTIFICATES,
		   /*jsonData : {
			   completionIds: vals.completionIds,
			   certificateIds: vals.certificateIds,
			   isPrintWordDoc: vals.isPrintWordDoc
		   },*/
		   success : function(form, action) {
			   var msg = form.responseText;
			   if(msg!='' && msg=='true'){
				   btn.up('window').close();
				   grid.getStore().reload();
				   showSuccessMessage(getCompletionModuleTranslation('ALERT'), getCommonTranslation('SUCCESS'));
			   }
		   }
	   });
   },
   showDebarmentReasonsWindow: function(grid){
	   var formWindow = this.getDebarmentreasonswindow();
	   if (!formWindow) {
		   Ext.widget('debarmentreasonswindow');
		   formWindow = this.getDebarmentreasonswindow();
	   }
	   formWindow.show();
   },
   
   loadStudentScheduleField: function(radio, newValue, oldValue) {
	   var adhocMessageForm = radio.up('form');
	   var scheduleDateField = adhocMessageForm.down('#scheduleDate');
	   var scheduleTimeField = adhocMessageForm.down('#scheduleTime');
	   var radioValue = radio.getValue().sendingPriority;

	   if(radioValue == 'IMMEDIATE') {
		   scheduleDateField.setVisible(false);
		   scheduleDateField.setDisabled(true);
		   scheduleTimeField.setVisible(false);
		   scheduleTimeField.setDisabled(true);            
	   }
	   else if(radioValue == 'SCHEDULE') {
		   scheduleDateField.setVisible(true);
		   scheduleDateField.setDisabled(false);
		   scheduleTimeField.setVisible(true);
		   scheduleTimeField.setDisabled(false);
	   }
   },
   
   selectMessageTemp: function(obj, rec) {
	   var $this = this;
	   var formWin = $this.getCompletionsendmessage();
	   var subject = formWin.down('#subject');
	   var smsDiscription = formWin.down('#smsDiscription');
	   var smsDiscriptionNotice = formWin.down('#smsDiscriptionNotice');
	   var pushNotificationDiscription = formWin.down('#pushNotificationDiscription');
	   var pushNotificationDiscriptionNotice = formWin.down('#pushNotificationDiscriptionNotice');
	   if(rec[0].data.value == "SMS") {
		   formWin.down("#templateId").setVisible(false);
		   formWin.down("#templateId").allowBlank = true;
		   Ext.Ajax.request({
			   type: 'rest',
			   async: false,
			   url: SERVERURL.COMMON_FORM_FIELD_INFO,
			   params: {
				   screenName: 'completionsendmessage',
				   academyLocationId: this.getCurrentAcademyLocation(),
				   languageCode: 'en'
			   },
			   method: 'GET',
			   success: function(res, action) {
				   var response = Ext.decode(res.responseText);
				   if( Object.keys(response).length > 0 ){
					   var records = response.completionsendmessage;
					   for(i in records) {
						   var curRec = records[i];
						   var inputType = curRec.formFieldInputType;
						   var fieldId = curRec.formFieldId;
						   var isMandatory = curRec.isMandatory;
						   var visibility = curRec.isVisible;
						   if(inputType == 'textfield' && fieldId == 'templateId' && visibility == true) {
							   formWin.down("#templateId").setVisible(true);
						   }
						   if(inputType == 'textfield' && fieldId == 'templateId' && isMandatory == true) {
							   formWin.down("#templateId").allowBlank = false;
						   }
						   if(inputType == 'textfield' && fieldId == 'templateId' && isMandatory == true && visibility == false) {
							   formWin.down("#templateId").allowBlank = true;
						   }
					   }
				   }
				   else {
					   formWin.down("#templateId").setVisible(false);
					   formWin.down("#templateId").allowBlank=true;
				   }
			   }
		   });
		   this.setAllowBlank (formWin.down("#subject"), true);
		   formWin.down("#subject").hide();
		   formWin.down("#staticUploadFileField").hide();
		   formWin.down("#studentDocumentMessageAttachmentGrid").hide();
		   formWin.down('#discriptionId').reset();
		   formWin.down('#discriptionId').hide();	       		 
		   formWin.down('#subject').reset();
		   formWin.down('#smsDiscription').show();
		   formWin.down('#smsDiscriptionNotice').show();
		   pushNotificationDiscription.hide();
		   pushNotificationDiscriptionNotice.hide();
		   pushNotificationDiscription.reset();
	   }
	   else {
		   formWin.down("#templateId").hide();
		   formWin.down("#templateId").allowBlank = true;
		   formWin.down('#discriptionId').reset();
		   formWin.down('#smsDiscription').reset();
		   formWin.down('#smsDiscription').hide();
		   formWin.down('#smsDiscriptionNotice').hide();
		   formWin.down("#staticUploadFileField").show();
		   formWin.down("#studentDocumentMessageAttachmentGrid").show();
		   formWin.down("#subject").reset();
		   formWin.down("#subject").show();
		   this.setAllowBlank (formWin.down("#subject"), false);
		   formWin.down('#discriptionId').show();
		   pushNotificationDiscription.hide();
		   pushNotificationDiscriptionNotice.hide();
		   pushNotificationDiscription.reset();
	   }
   },
      
   selectSectionMessageType: function(val, nV, oV) {
	   var $this = this;
	   var formWin = $this.getCompletionsendmessage();
	   formWin.down('#recieverTypeIncludeMySelf').setValue(false);
	   if(nV.messageType == 2) {
		   formWin.down("#messageId").hide();
		   formWin.down("#selectTemplate").allowBlank=true;
		   formWin.down("#selectTemplate").setVisible(false);     		 
		   formWin.down("#messageName").allowBlank=true;   
		   formWin.down("#messageName").setVisible(false);
		   formWin.down("#msgTempletId").setVisible(true);
		   formWin.down("#msgTempletId").allowBlank=false;
		   formWin.down("#msgTempletId").reset();
		   formWin.down("#subject").setVisible(true);
		   formWin.down("#subject").reset();
		   formWin.down("#discriptionId").setVisible(true);
		   formWin.down("#discriptionId").reset();
		   formWin.down('#smsDiscription').reset();
		   formWin.down('#smsDiscription').hide();
		   formWin.down('#smsDiscriptionNotice').hide();
		   formWin.down('#pushNotificationDiscription').hide();
		   formWin.down('#pushNotificationDiscriptionNotice').hide();
		   formWin.down('#recieverTypeIncludeMySelf').setVisible(true);
		   this.setAllowBlank (formWin.down("#subject"),false);
	   }
	   else {
		   formWin.down("#msgTempletId").allowBlank=true;
		   formWin.down("#msgTempletId").setVisible(false);     		
		   formWin.down("#messageId").setVisible(true);
		   formWin.down("#selectTemplate").setVisible(true);     		
		   formWin.down("#messageName").setVisible(true);
		   formWin.down("#messageName").reset();
		   this.setAllowBlank (formWin.down("#subject"),true);
		   formWin.down("#subject").setVisible(false);
		   formWin.down("#discriptionId").setVisible(false);
		   formWin.down("#messageName").allowBlank=false;  
		   formWin.down("#selectTemplate").allowBlank=false;
		   formWin.down("#selectTemplate").reset();
		   formWin.down("#studentDocumentMessageAttachmentGrid").setVisible(false);
		   formWin.down("#staticUploadFileField").setVisible(false);
		   formWin.down('#smsDiscription').reset();
		   formWin.down('#smsDiscription').hide();
		   formWin.down('#smsDiscriptionNotice').hide();
		   formWin.down('#pushNotificationDiscription').hide();
		   formWin.down('#pushNotificationDiscriptionNotice').hide();
		   formWin.down('#recieverTypeIncludeMySelf').setVisible(false);
		   this.setAllowBlank (formWin.down("#messageName"),false);
		   this.setAllowBlank (formWin.down("#selectTemplate"),false);
	   }
   },
   
   uploadStudentStaticDocumentFileMessage: function(fileField, fileUploadPath, eOpts) {
	   var this$ = this;
	   var setupForm = fileField.up('completionsendmessage');
	   var grid = setupForm.down('#studentStaticDocumentAttachmentGridMessage');
	   fileUploadPath = fileUploadPath.replace('C:\\fakepath\\', '');
	   fileField.setRawValue(fileUploadPath);
	   var file = fileField.fileInputEl.dom.files[0];
	   fileField.setRawValue(fileUploadPath);
	   var fileSizeLimit = '5';
	   var url = SERVERURL.FILE_PRIORITY;
	   Ext.Ajax.request({
		   type: 'rest',
		   url: url+'?type=emailFileSize',
		   method: 'GET',
		   success : function(response, action){
			   var responseData = Ext.JSON.decode(response.responseText);
			   if(responseData.length > 0 && responseData[0].value != undefined && !isNullOrEmpty(responseData[0].value)) {
				   fileSizeLimit=responseData[0].value;
			   }
			   if((file.size / 1048576) <=  fileSizeLimit ) {
				   if(!isNullOrEmpty(fileUploadPath)){
					   var extension = fileUploadPath.substring(fileUploadPath.lastIndexOf('.') + 1).toLowerCase();
					   if (extension == "gif" || extension == "png" || extension == "bmp"
						   || extension == "jpeg" || extension == "jpg" || extension == "pdf" 
							   || extension == "doc" || extension == "docx" || extension == "txt"
								   || extension == "xls" || extension == "csv" || extension == "xml" 
									   || extension == "zip" || extension == "xlsx" || extension == "ppt" || extension == "pptx") {
						   var entityId = 'student';
						   var module = 'messaging';
						   var entityType = 'template';
						   var documentType = 'DOCUMENT';
						   var isTransient = true;
						   Ext.getBody().mask(getCommonTranslation('LOADING'), 'x-mask-loading');
						   this$.saveStaticDocumentFormMessage(entityId, module, entityType, documentType, function(success, action, isTransient) {
							   if(success) {
								   Ext.getBody().unmask();
								   var path = Ext.JSON.decode(action.response.responseText).path;
								   var user = this$.getCurrentlyLoggedInUser();
								   var store = grid.getStore();
								   var documentStatus = "SUBMITTED";
								   var documentType = null;
								   if(!isNullOrEmpty(path)) {
									   store.add({
										   id: '',
										   name: fileUploadPath,
										   path: path ,
										   createdBy : {
											   id :user.id,
											   value : user.value,
											   code : user.code
										   },
										   status : documentStatus,
										   documentType : documentType,
										   templateConfigDocId: '',
										   submissionDate: Ext.Date.format(new Date(), 'd-m-Y')
									   });
									   this$.loadGridWithFileNameMessage(grid,fileUploadPath,store);
									   showSuccessMessage(getMessagingModuleTranslation('SUCCESS'), getMessagingModuleTranslation('FILE_UPLOADED_SUCCESS'));
								   }
								   var form=this$.getCompletionsendmessage();
								   var subject = form.down('#subject').getValue();
								   if(!isNullOrEmpty(subject)){
									   if(subject == ' '){
										   form.down('#subject').reset();
									   }
								   }
								   fileField.reset();
							   }

						   }, isTransient);
					   }
					   else {
						   fileField.reset();
						   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('UPLOAD_VALID_FILE'));
					   }
				   }
			   }
			   else {
				   fileField.reset();
				   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ATTACHMENT_LIMIT_EXCEEDS')+' '+fileSizeLimit+' MB');
			   }
		   }
	   });
   },
   
   deleteStudentStaticMessageDocument : function(view, rowIndex, colIndex, item, e, record, row){
	   var grid = view.up('#studentStaticDocumentAttachmentGridMessage');
	   var panel = this.getContentPanel().getActiveTab();
	   var tabTitle = panel.title;
	   var store = grid.getStore();
	   var templateConfigDocId = record.get('templateConfigDocId');
	   var viewTitle = getMessagingModuleTranslation('VIEW_TEMPLATE');
	   if(!(tabTitle == viewTitle)){
		   if(!isNullOrEmpty(templateConfigDocId)){
			   showConfirmMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				   if (btn == 'yes') {
					   Ext.Ajax.request({
						   type: 'rest',
						   url: SERVERURL.STATIC_DOC_DELETE,
						   method: 'DELETE',
						   params: {
							   templateConfigDocId: templateConfigDocId
						   },
						   headers: {
							   'Content-Type': 'application/json'
						   },
						   success: function(form, action) {
							   store.remove(record);
							   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
						   }
					   });
				   }
			   });
		   }
		   else{
			   store.remove(record);
			   showSuccessMessage(getMessagingModuleTranslation('STATIC_DOCUMENT_ATTACHMENT'), getMessagingModuleTranslation('STATIC_DOCUMENT_DELETE'));
		   }
	   }
	   else{
		   showWarningMessage(getCommonTranslation('ALERT'), getMessagingModuleTranslation('CANNOT_DELETE_DOCUMENT'));
	   }
   },
   
   sendAdhocMsg: function(obj) {
	   var isForAll = false;
	   var jsonFormatFormData = this.createJsonFormatForStudentListFilter();
	   var grid = this.getPassingoutgrid();
	   var completionsendmessage = this.getCompletionsendmessage();;

	   var sendMessageLable = completionsendmessage.down("#sendMsgCountItemId");
	   if (sendMessageLable.isVisible()) {
		   isForAll = true;
	   }
	   var formPnl = obj.up('form');
	   var isMySelfChecked = false;
	   var fldValues = formPnl.getForm().getFieldValues();
	   isMySelfChecked = fldValues.recieverType;
	   if(fldValues.recieverType[0] == false && fldValues.recieverType[1]==false && fldValues.recieverType[2]==false ){
		   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('SEND_MESSAGE_ALERT_FOR_MYSELF'));
		   return;
	   }
	   var currentlyLoggedInUserId= this.getCurrentlyLoggedInUser().id;
	   var wsMsgEventRecipientConfigsUpdated = [];
	   var formData = obj.up('form').getValues();

	   var sendMessageToOptions = formData.recieverType;
	   var isStudentChecked = false;
	   var isParentChecked = false;
	   var isFeePayerChecked = false;

	   if(sendMessageToOptions != null && sendMessageToOptions != undefined ){
		   if(sendMessageToOptions.constructor === Array){
			   if(sendMessageToOptions.length > 0){
				   sendMessageToOptions.forEach(function(current_value, index, initial_array) {
					   if(current_value == 1 || current_value == '1'){
						   isStudentChecked = true;
					   }
					   if(current_value == 2 || current_value == '2'){
						   isParentChecked = true;
					   }
					   if(current_value == 3 || current_value == '3'){
						   isFeePayerChecked = true;
					   }
				   });
			   }
		   }else{
			   if(sendMessageToOptions == 1 || sendMessageToOptions == '1'){
				   isStudentChecked = true;
			   }
			   if(sendMessageToOptions == 2 || sendMessageToOptions == '2'){
				   isParentChecked = true;
			   }
			   if(sendMessageToOptions == 3 || sendMessageToOptions == '3'){
				   isFeePayerChecked = true;
			   }
		   }
	   }

	   if( !isParentChecked && !isFeePayerChecked ){ // No checkbox is checked
		   completionsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
	   }else{
		   var recipientIds;
		   if(grid.itemId == 'passingOutSearchResultGrid'){
			   recipientIds = this.getStudentReceipientIdsForSendingMessages(grid);
			   recipientIds = Ext.encode(recipientIds);
		   }

		   var RecipientTypeCodes = ["Fee Payer Adhoc","Parent Adhoc"];

		   if(isParentChecked && isFeePayerChecked){ // Both checkboxes are cheked 
			   // Ajax Call to get Parent Ids by Admission Ids
			   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			   Ext.Ajax.request({
				   type: 'rest',
				   url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
				   jsonData: RecipientTypeCodes,
				   method: 'POST',
				   success: function(response) {
					   var RecipientTypeCodesData = Ext.decode(response.responseText);
					   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					   Ext.Ajax.request({
						   type: 'rest',
						   url:SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS,
						   jsonData: recipientIds,
						   method: 'POST',
						   success: function(response) {
							   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
							   // update wsMsgEventRecipientConfigsUpdated with parent ids
							   var wsMsgEventRecipientConfigsParents = {
									   msgRecipientTypeId: 66,
									   msgTemplateConfigId: 0,	//formData.id, 
									   selectiveRecipientIds: []
							   };
							   if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
								   wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
							   }
							   wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
							   wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);

							   // Ajax Call to get Fee Payer Ids by Admission Ids
							   Ext.Ajax.request({
								   type: 'rest',
								   url: SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS,
								   jsonData: recipientIds,
								   method: 'POST',
								   success: function(response) {
									   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
									   // update wsMsgEventRecipientConfigsUpdated with fee payer ids
									   var wsMsgEventRecipientConfigsFeePayer = {
											   msgRecipientTypeId: 67,
											   msgTemplateConfigId: 0,	//formData.id, 
											   selectiveRecipientIds: []
									   };

									   if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
										   wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
									   }

									   wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
									   wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
									   completionsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated, isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
								   }
							   });
						   }
					   });
				   }
			   });
		   }else{ // Only one checkbox is selected
			   var urlNew = '';
			   if(isParentChecked) { // If Parent checkbox is selected
				   // url for getting parent ids
				   urlNew = SERVERURL.FIND_ALL_PARENT_BY_ADMISSION_IDS;
			   }
			   if(isFeePayerChecked) { // If Fee Payer checkbox is selected
				   // url for getting fee payer ids
				   urlNew = SERVERURL.FIND_ALL_FEE_PAYER_BY_ADMISSION_IDS;
			   }

			   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			   Ext.Ajax.request({
				   type: 'rest',
				   url:SERVERURL.FIND_ALL_RECIPIENT_TYPE_BY_CODE,
				   jsonData: RecipientTypeCodes,
				   method: 'POST',
				   success: function(response) {
					   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					   var RecipientTypeCodesData = Ext.decode(response.responseText);

					   Ext.Ajax.request({
						   type: 'rest',
						   url: urlNew,
						   jsonData: recipientIds,
						   method: 'POST',
						   success: function(response) {
							   Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
							   if(isParentChecked) { // If Parent checkbox is selected
								   // update wsMsgEventRecipientConfigsUpdated with parent ids
								   var wsMsgEventRecipientConfigsParents = {
										   msgRecipientTypeId: 66,
										   msgTemplateConfigId: 0,	//formData.id, 
										   selectiveRecipientIds: []
								   };
								   if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Parent_Adhoc != null){
									   wsMsgEventRecipientConfigsParents.msgRecipientTypeId = RecipientTypeCodesData.Parent_Adhoc;
								   }
								   wsMsgEventRecipientConfigsParents.selectiveRecipientIds = Ext.decode(response.responseText);
								   wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsParents);
							   }
							   if(isFeePayerChecked) { // If Fee Payer checkbox is selected
								   // update wsMsgEventRecipientConfigsUpdated with fee payer ids
								   var wsMsgEventRecipientConfigsFeePayer = {
										   msgRecipientTypeId: 67,
										   msgTemplateConfigId: 0,	//formData.id, 
										   selectiveRecipientIds: []
								   };
								   if(RecipientTypeCodesData != undefined && RecipientTypeCodesData.Fee_Payer_Adhoc != null){
									   wsMsgEventRecipientConfigsFeePayer.msgRecipientTypeId = RecipientTypeCodesData.Fee_Payer_Adhoc;
								   }
								   wsMsgEventRecipientConfigsFeePayer.selectiveRecipientIds = Ext.decode(response.responseText);
								   wsMsgEventRecipientConfigsUpdated.push(wsMsgEventRecipientConfigsFeePayer);
							   }
							   completionsendmessage.sendMessage(obj,grid, wsMsgEventRecipientConfigsUpdated,isStudentChecked,isMySelfChecked,currentlyLoggedInUserId, isForAll, jsonFormatFormData);
						   }
					   });
				   }
			   });
		   }
		   //studentsendmessage.sendMessage(obj,grid);
	   }
   },
   createJsonFormatForStudentListFilter: function() {
	   var this$=this;
	   var formValues = new Array();
	   var values = new Object();
	   var searchcriteria = new Array();

	   values.configCode = CONSTANTS.CB.STUDENT_LIST_BASIC_CONFIGCODE;

	   formValues ={ACADEMIC_TERM: "",ADMISSION_FROM_DATE: "",ADMISSION_NUMBER: "",ADMISSION_STATUS: true,ADMISSION_TO_DATE: Ext.Date.format(new Date(), 'Y-m-d'), ADVISOR_ID: "",COURSE_NAME: "",EMAIL_ID: "",
			   EXTERNAL_SYSTEM_REFERENCE_1: "",GENDER: "",INTAKE_YEAR: "",MODE_OF_DELIVERY: "",NATIONAL_ID: "",PHONE_NO: "",PROGRAM_CATEGORY: "",PROGRAM_GROUP: "",PROGRAM_NAME: "",
			   PROGRAM_STATUS: "",SEAT_TYPE: "",STATUS: true,STUDENT_ID: "",STUDENT_STATUS_CSM:undefined,customData: []};            

	   if(!isNullOrEmpty(formValues.ADMISSION_TO_DATE)){formValues.ADMISSION_TO_DATE = formValues.ADMISSION_TO_DATE+' 23:59:59';}

	   for (var key in formValues) {
		   var value = formValues[key];            
		   if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField' && 
				   key !== 'STUDENT_ID' && key !== 'ADMISSION_NUMBER' && key !== 'STUDENT_STATUS_CSM' ){
			   var keyValueJsonObject = this$.getJsonObject( key , value);
			   this$.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
		   }
	   }
	   if(formValues["ADMISSION_STATUS"]){
		   var academyLocationIds =this$.getUserAccessibleAL();
		   var ACCESSIBLE_AL_ID = this$.getJsonObject( 'ACCESSIBLE_AL_ID' , academyLocationIds);
		   this$.pushJsonObjectInArray(ACCESSIBLE_AL_ID,searchcriteria);
	   }
	   var academyLocationId = this.getCurrentAcademyLocation();


	   if(!isNullOrEmpty(formValues.STUDENT_ID)){
		   var studentRec = studentField.getStore().getById(formValues.STUDENT_ID);
		   if(!isNullOrEmpty(studentRec)){
			   var studetnRecObj = this$.getJsonObject( 'STUDENT_ID' , studentRec.data.studentCode);
			   this$.pushJsonObjectInArray(studetnRecObj,searchcriteria);
		   }
	   }
	   if(!isNullOrEmpty(formValues.ADMISSION_NUMBER)){
		   var admissionRec = admissionField.getStore().findRecord('id',formValues.ADMISSION_NUMBER);
		   if(!isNullOrEmpty(admissionRec)){
			   var admissionRecObj = this$.getJsonObject( 'ADMISSION_NUMBER' , admissionRec.data.code);
			   this$.pushJsonObjectInArray(admissionRecObj,searchcriteria);
		   }
	   }
	   var academyLocationObj = this$.getJsonObject( 'ACADEMY_LOCATION_ID' , academyLocationId);
	   this$.pushJsonObjectInArray(academyLocationObj,searchcriteria);

	   if(!isNullOrEmpty(formValues.religion)){
		   var religionId = this$.getJsonObject( 'RELIGION_ID' , formValues.religion.id);
		   this$.pushJsonObjectInArray(religionId,searchcriteria);
	   }

	   if(!isNullOrEmpty(formValues.castCategory)){
		   var casteCatergoryId = this$.getJsonObject( 'CASTE_CATERGORY_ID' , formValues.castCategory.id);
		   this$.pushJsonObjectInArray(casteCatergoryId,searchcriteria);
	   }

	   var debaredStudentsCheckBoxChecked = false;

	   if( !isNullOrEmpty(formValues.debaredStudents) && formValues.debaredStudents ){
		   debaredStudentsCheckBoxChecked = true;
	   }

	   if(formValues.STATUS  && formValues.ADMISSION_STATUS){
		   var exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
		   this$.pushJsonObjectInArray(exitDate,searchcriteria);
	   }else{
		   if(!formValues.STATUS  && !formValues.ADMISSION_STATUS){
			   var exitDate = this$.getJsonObject( 'EXIT_DATE_NOT_NULL' , true);
			   if( debaredStudentsCheckBoxChecked ){
				   exitDate = this$.getJsonObject( 'EXIT_DATE_NULL' , true);
			   }
			   this$.pushJsonObjectInArray(exitDate,searchcriteria);
		   }
	   }
	   if((!isNullOrEmpty(formValues.COURSE_NAME) || !isNullOrEmpty(formValues.COURSE_VARIENT_ID)) && formValues.STATUS  && formValues.ADMISSION_STATUS){
		   var enrollementExitDate = this$.getJsonObject('ENROLLMENT_EXIT_DATE_NULL' , true);
		   this$.pushJsonObjectInArray(enrollementExitDate,searchcriteria);
	   }
	   if(!isNullOrEmpty(formValues.STUDENT_STATUS_CSM)){
		   var studentStatusCSMComboArr = formValues.STUDENT_STATUS_CSM;
		   var studentStatusCSMArr = [];
		   for(i in studentStatusCSMComboArr){
			   if( !isNullOrEmpty(studentStatusCSMComboArr[i].data) ){
				   var studentStatusCSMId = studentStatusCSMComboArr[i].data.id;
				   studentStatusCSMArr.push(studentStatusCSMId);
			   }
		   }
		   if( studentStatusCSMArr.length != 0 ){
			   var studentStatusCSMObj = {
					   "paramCode": 'STUDENT_STATUS_CSM_ID_LIST',
					   "paramValues": studentStatusCSMArr
			   };
			   this$.pushJsonObjectInArray(studentStatusCSMObj,searchcriteria);
		   }
	   }

	   values.searchCriterias = searchcriteria;
	   return values;
   },
   getJsonObject: function(key, value, additionalValue) {
	   if (!isNullOrEmpty(value) && additionalValue == undefined) {
		   return {
			   "paramCode": key,
			   "paramValues": [value]
		   };
	   } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
		   return {
			   "paramCode": key,
			   "paramValues": [value, additionalValue]
		   };
	   }
   },
   pushJsonObjectInArray: function(object, array) {
	   if (object) {
		   array.push(object);
	   }
   },
   getUserAccessibleAL:function(){
	   var academyLocationId = [];
	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
	   for(var i=0; i<academyLocationList.length; i++){
		   academyLocationId.push(academyLocationList[i].id);
	   }
	   return academyLocationId.join();
   },
   
   getStudentReceipientIdsForSendingMessages : function(grid){
	   if (grid.getSelectionModel().getCount() > 0) {
		   var records = grid.getSelectionModel().getSelection();
		   var ids=[];
		   if(grid.itemId == 'passingOutSearchResultGrid'){
			   for(var i in records) {
				   ids.push(records[i].data.admissionId);
			   }
		   }			
	   }
	   return ids;
   },
    openPrintCertificateWindow: function(btn) {
	   var me = this;
	   var grid = me.getPassingoutgrid();
	   if(grid.getSelectionModel().getCount() > 0) {
		   var radioItems = [{
			   boxLabel: getCommonTranslation('NONE'),
			   inputValue: 'None',
			   checked: true
		   }, {
			   boxLabel: getCommonTranslation('DUPLICATE'),
			   inputValue: 'Duplicate'
		   }, {
			   boxLabel: getCommonTranslation('REPRINT'),
			   inputValue: 'Reprint'
		   }];
		   var maxWidth = 0;
		   Ext.each(radioItems, function(item) {
			   var labelWidth = Ext.util.TextMetrics.measure(Ext.getBody(), item.boxLabel).width;
			   maxWidth = maxWidth + labelWidth;
		   });
		   maxWidth = maxWidth + 130;

		   Ext.create('Ext.window.Window', {
			   modal: true,
			   frame: true,
			   height: 280,
			   minWidth: maxWidth + 90,
			   title: getCompletionModuleTranslation('PRINT_CERTIFICATE'),
			   defaults: {
				   width: '100%'
			   },
			   items: [{
				   xtype: 'radiogroup',
				   fieldLabel: getCommonTranslation('DOCUMENT_TYPE'),
				   labelAlign: 'top',
				   name: 'documentType',
				   width: maxWidth,
				   defaults: {
					   name: 'docType',
					   margin: '0 12 0 0'
				   },
				   layout: 'hbox',
				   items: radioItems
			   }, {
				   xtype:'fieldcontainer',
	               width:'auto',
				   items: [{
					   xtype: 'button',
					   text: getExaminationTranslation('SUBMIT'),
					   ui: 'CustomBtnSubmit',
					   scale: CONSTANTS.BUTTONSIZE,
					   handler: function(btn) {
						   me.exportCompletionCertificate(btn);
					   }
				   }, {
					   xtype: 'button',
					   text: getCommonTranslation('CANCEL'),
					   ui: 'CustomBtnCancel',
					   scale: CONSTANTS.BUTTONSIZE,
					   handler: function(btn) {
						   btn.up('window').close();
					   }
				   }]
			   }]
		   }).show();
	   }
	   else {
		   showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
	   }
   },
   openPrintEmailDocWindow: function(btn, url,type) {
	   var me = this;
		var grid = me.getPassingoutgrid();
		if(Ext.isDefined(btn)){
			grid=btn.up("grid");
		}
	   if(!Ext.isDefined(type) || isNullOrEmpty(type)){
			type="PASSING_OUT";
		}
	   if(grid.getSelectionModel().getCount() > 0) {
		var selection = grid.getSelectionModel().getSelection();
    		var completionIds = [];
    		for(var i = 0; i < selection.length; i++) {
			if(!Ext.isDefined(selection[i].raw.completionId)){
    			completionIds.push(selection[i].raw.COMPLETION_ID);
			}else{
				completionIds.push(selection[i].raw.completionId);
			}

    		}
		var store=Ext.create('Academia.store.completion.completionform.CompletionCertificateDataStore');
		store.proxy.api.read=SERVERURL.GET_COMPLETION_CERTIFICATE_BY_IDS_URL;
		store.proxy.extraParams={
			ids:completionIds.join(","),
			type:type
		};
    	store.load();
		
		   var maxWidth =  230;
		   Ext.create('Ext.window.Window', {
			   modal: true,
			   frame: true,
			   height: 280,
			   minWidth: maxWidth + 90,
			   title: getProgramandcourseTranslation('EMAIL_CERTIFICATE'),
			   defaults: {
				   width: '100%'
			   },
			   items: [{
                    xtype: 'multiselectcombofield',
                    fieldLabel:  getProgramandcourseTranslation('EMAIL_CERTIFICATE'),
					labelAlign: 'top',
					width: maxWidth,                
                    name: 'certificate',
                    itemId : 'certificateemailId',   
                    displayField : 'certificate',
                    valueField:'certificateId',
                    store: store,
                    allowBlank: false,
                    editable: false,
					layout: 'hbox',
					defaults: {
					   name: 'docType',
					   margin: '0 12 0 0'
				   },
                   
                },{
                  xtype:'fieldcontainer',
                  width:'auto',
				   items: [{
					   xtype: 'button',
					   text: getExaminationTranslation('SUBMIT'),
					   ui: 'CustomBtnSubmit',
					   scale: CONSTANTS.BUTTONSIZE,
					   handler: function(btn) {
						   me.emailCertificates(grid,btn,url);
					   }
				   }, {
					   xtype: 'button',
					   text: getCommonTranslation('CANCEL'),
					   ui: 'CustomBtnCancel',
					   scale: CONSTANTS.BUTTONSIZE,
					   handler: function(btn) {
						   btn.up('window').close();
					   }
				   }]
			   }]
		   }).show();
	   }
	   else {
		   showWarningMessage(getCompletionModuleTranslation('ALERT'), getCompletionModuleTranslation('PLEASE_SELECT_RECORD'));
	   }
   },
   onPrintCertificateWinRender: function(win) {
		var btns = win.query('button');
		/*var winWidth = 72;
		for(var i = 0; i < btns.length; i++) {
			winWidth = winWidth + btns[i].getWidth();
		}
		win.setWidth(winWidth);
		Ext.apply(win, {
			minWidth: winWidth
		});*/
		var associatedAcadLocationIds = new Array();
    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
        var permissionsMap = this.getCOMPLETION_PASSING_OUT_PERMISSION();
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        var sendToStudentBtn = win.down('#sendToStudentProfileBtn');
        var form = win.down('form');
        var isPrintWordDoc = form.getForm().findField('isPrintWordDoc');
        sendToStudentBtn.setVisible(false);
	    isPrintWordDoc.setVisible(false);
        Ext.each(permissionList, function(privilege) {
    		if (privilege == 'SEND_TO_STUDENT_PROFILE') {
    			if(!isNullOrEmpty(sendToStudentBtn)){
    				sendToStudentBtn.setVisible(true);	
    			}
			} if (privilege == 'PRINT_AS_WORD_FILE') {
    			 if (!isNullOrEmpty(isPrintWordDoc)) {
                isPrintWordDoc.setVisible(true);
            }
			}
    	});	
	},
	isSameDate :function(inputDate) {
	    var currentDate = new Date();

	    // Extract year, month, and day from the input date and current date
	    var currentYear = currentDate.getFullYear();
	    var currentMonth = currentDate.getMonth();  // Month is 0-indexed
	    var currentDay = currentDate.getDate();

	    var inputYear = inputDate.getFullYear();
	    var inputMonth = inputDate.getMonth();  // Month is 0-indexed
	    var inputDay = inputDate.getDate();

	    // Compare the year, month, and day
	    var currentdate = currentYear === inputYear && currentMonth === inputMonth && currentDay === inputDay;
	    var isFutureDate = inputDate > currentDate;
	    if (currentdate) {
	       return false;
	    } else if (isFutureDate) {
	       return true;
	    } else {
	    	return false;
	    }
	}

});
