Ext.define('Academia.controller.course.academylocation.AcademyLocationController', {
	//extend : 'Ext.app.Controller',
	extend :'Academia.controller.base.BaseController',
	models : ['course.academyLocation.AcademyLocationModel'],
	stores : ['course.academyLocation.AcademyLocationStore'
	          ,'course.academyLocation.TempAcademyLocationStore'
	          ],
	          views : ['course.academylocation.AcademyLocationStructure',
	                   'course.academylocation.AcademyLocationGrid',
	                   'course.academylocation.TempAcademyLocationGrid',
	                   'course.CourseTabStructure'
	                   ],	           
	               	config: {
	               		LINKACADEMYLOCATION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LINKACADEMYLOCATION_PRIVILEGES')  		  
	                },
	                   refs : [{
	                	   ref : 'academylocationgrid',
	                	   selector : 'academylocationgrid'
	                   },{
	                	   ref : 'tempacademylocationgrid',
	                	   selector : 'tempacademylocationgrid'	
	                   },{
	                	   ref : 'coursetabstructure',
	                	   selector : 'coursetabstructure'			
	                   }],

	                   init : function() {

	                	   this.control({
	                		   'academylocationgrid' : {
	                			   select: this.selectAlGrid,
	                			   deselect: this.deSelectAlGrid,
	                			   render : this.academyLocationGridRender,
	                			   afterrender:function(grid){
	               					var viewMode = this.getCoursetabstructure().getForm().findField('courseViewMode').getValue();
	               					if(viewMode == "View"){
	               						grid.down('#btnAdd').setVisible(false);
	               					}
	               				}
	                		   },
	                		   'academylocationgrid button[itemId=btnAdd]' : {
	                			   click : this.acedemyLocationMapping
	                			  },
	                		   'academylocationgrid actioncolumn[itemId=actioncolumn]' : {
	                			   click : function(){
	                				   this.tempAcedemyLocationMapping();
	                			   } 
                      		 },
                      		 /*'academylocationgrid checkcolumn[itemId=checkMapping]':{
                      			checkchange:function(f, rowIndex, checked, eOpts){
                      				this.gridSelectionChange(rowIndex,checked);
                     	        }
                      		 },*/
                      		 
                      		/*'academylocationgrid':{
                      			cellclick: this.cellClickStudentSearchResultGrid,
                      		},*/
                      		 
                      		'academylocationgrid button[itemId=selectAllbtn]':{
      	        			  click:function(obj){
      	        				  var $this=this;
      	        				  $this.checkedAllrecords();
      	        			}
      	        		  },
                      		
      	        		/*'academylocationstructure':{
		      	        	afterrender : function(structure){
		    	        		var grid = structure.down('academylocationgrid');
		    	        	    this.getGridHeaderFreeze(grid,structure);
		    	        	}
      	        		},*/
	                	});
	                   },
	                   tempAcedemyLocationMapping : function(records,checked){
	                	   
	                	   var $this = this;
	                	   var grid = $this.getTempacademylocationgrid();
	                	   var store = grid.getStore();

	                	   var data = {
	                			   id : records.id,
	                			   wsAcademyLocation:records.wsAcademyLocation,
	                			   mappingFlag :checked
	                	   };

	                	   store.loadRawData(data, true);

	                   },
	                   
	                   gridSelectionChange: function(rowIndex,checked) {
	                	  var $this = this;
	                	   var store=$this.getStore('course.academyLocation.AcademyLocationStore');
	     	        	   var rec=store.getAt(rowIndex);
	                	   var records = rec.data;
	                	   this.tempAcedemyLocationMapping(records,checked);
                         },
                         
                         gridDeSelectionChange: function(rowIndex,checked) {
   	                	  var $this = this;
   	                	   var store=$this.getStore('course.academyLocation.AcademyLocationStore');
   	     	        	   var rec=store.getAt(rowIndex);
   	                	   var records = rec.data;
   	                	   this.tempAcedemyLocationMapping(records,checked);
                            },
	                   
	                   acedemyLocationMapping : function(button){
	                	   button.setDisabled(true);
	                	   var $this = this;
                           var acdemylocGrid = $this.getAcademylocationgrid();
	                	   var grdStore = acdemylocGrid.getStore();
	                	   var grid = $this.getTempacademylocationgrid();
	                	   var store = grid.getStore();
	                	   var myItems = store.getRange();


	                	   var tabStcrFrm = $this.getCoursetabstructure().getForm();
	                	   var courseId = tabStcrFrm.findField("ids").getValue();


	                	   var submitData=[];
	                	   for(var i in myItems){
	                		   
	                	   //if (acdemylocGrid.getSelectionModel().getCount() > 0) {
	                		   
	                		   var wsAcademyLocation = myItems[i].get('wsAcademyLocation');
	                		  
	                		   submitData.push({
	                			   "id":myItems[i].get('id'),
	                			   "wsAcademyLocation":{
	                				   "id":wsAcademyLocation.id,
	                				   "version":wsAcademyLocation.version,
	                				   "academy":{
	                					   "id":wsAcademyLocation.academy.id,
	                					   "academyCode":wsAcademyLocation.academy.academyCode,
	                					   "organizationId":wsAcademyLocation.academy.organizationId,
	                					   "academyType":wsAcademyLocation.academy.academyType,
	                					   "academyName":wsAcademyLocation.academy.academyName,
	                					   "startDate":wsAcademyLocation.academy.startDate,
	                					   "tillDate":wsAcademyLocation.academy.tillDate,
	                					   "status":wsAcademyLocation.academy.status
	                				   },
	                				   "location":{
	                					   "id":wsAcademyLocation.location.id,
	                					   "version":wsAcademyLocation.location.version,
	                					   "locationCode":wsAcademyLocation.location.locationCode,
	                					   "name":wsAcademyLocation.location.name,
	                					   "startDate":wsAcademyLocation.location.startDate,
	                					   "tillDate":wsAcademyLocation.location.tillDate,
	                					   "status":wsAcademyLocation.location.status,
	                					   "organizationId":wsAcademyLocation.location.organizationId
	                				   },
	                				   "currentTransactionDate":wsAcademyLocation.currentTransactionDate,
	                				   "isAssociatedCalendar":wsAcademyLocation.isAssociatedCalendar,
	                				   "academyLocationName":wsAcademyLocation.academyLocationName,
	                				   "academyLocationSettings":wsAcademyLocation.academyLocationSettings
	                			   },
	                			   "mappingFlag":myItems[i].get('mappingFlag')
	                		   });
	                	   }
	                	   var submitUrl = SERVERURL.COURSE_ACADEMY_LOCATION_UPDATE+'?courseId='+courseId;
	                	  // var submitUrl = SERVERURL.COURSE_ACADEMY_LOCATION_UPDATE+'?courseId=5';
	                	   if(submitData.length>0){
	                		   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                		   Ext.Ajax.request({
	                			   url: submitUrl,
	                			   jsonData: submitData,
	                			   method: 'POST',
	                			   success: function(response) {
	                				   Ext.getBody().unmask();
	                				   button.setDisabled(false);
	                				   grdStore.reload();
	                				   showSuccessMessage(getCommonTranslation('TITLE_ACADEMY'),getCommonTranslation('SUCCESS'));
	                				   grid.getStore().removeAll(); 
	                			   }
	                		   });
	                	   }else{
	                		   button.setDisabled(false);
	                		   showWarningMessage(getCommonTranslation('TITLE_ACADEMY'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                	   }

	                   },

	                   showHideAcademic : function(model,record){

	                   },
	                   /*
	                    * @method
	                    * method to load the store manually after the rendering of the grid.
	                    */
	                   academyLocationGridRender : function(obj){
	                	   this.doAccessControlValidation(obj, this.getLINKACADEMYLOCATION_PERMISSIONS());
	                	   
	                	   var $this = this;
	                	   var tabStcrFrm = $this.getCoursetabstructure().getForm();
	                	   var courseId = tabStcrFrm.findField("ids").getValue();
	                	   
	                	   //obj.down('#selectAllbtn').setVisible(true);
	                	   
	                	   var store = this.getAcademylocationgrid().getStore();
	                	   store.getProxy().extraParams = {
	                		    courseId:courseId,
	                		    userId:1
	                	   };
	                	   //store.load();
	                	   var algrid = this.getAcademylocationgrid();
	                	   store.load({
	        					callback:function(record){
	        						for(var i=0;i<record.length;i++){
	        							var rec=record[i];
	        						   if(rec.data.mappingFlag){
	    	                			   algrid.getSelectionModel().select(rec,true);
	    	                			   $this.gridSelectionChange(rec.index,true);
	    	                		   }
	    	                	   }
	        					}
	                   		});
	                   },
	                   
	                   /**
	     	           * Unchecked All selected records button.
	     	           */
	     	          checkedAllrecords : function() {
	     	        	  
	     	        	  var academyLocationGrid = this.getAcademylocationgrid();
	     	        	  var alStore = academyLocationGrid.getStore();
	     	        	  var myItems = alStore.getRange();
	     	        	  for(var i in myItems){
	     	        		 myItems[i].set('mappingFlag', true);
	     	        	  }
	     	          },
	     	          
	     	        selectAlGrid: function(view, td, cellIndex) {
	     	        	 var this$ = this;
	     	        	 this$.gridSelectionChange(td.index,true);
	     	        },
	     	        
	     	       deSelectAlGrid: function(view, td, cellIndex) {
	     	        	var this$ = this;
      					this$.gridDeSelectionChange(td.index,false);
	     	        }
});
