/*
 * @author Rajkumar.patidar
 */

Ext.define('Academia.controller.course.courseComponent.CourseComponentController', {
    extend: 'Academia.controller.base.BaseController',
	models : ['course.coursecomponent.CourseComponentModel'],
	stores : ['course.coursecomponent.CourseComponentStore','course.coursecomponent.CourseComponentCombo'],
	views : ['course.courseComponent.CourseComponentGrid','course.courseComponent.CourseComponentForm','course.CourseTabStructure'],
	config:{
		/*
       	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
        		   	 */
        	   	/**
        	        * @cfg {Array} COURSECOMPONENT_PERMISSIONS array (required)
        	        * The array of permissions to use for Access control wise enabling and disabling buttons.
        	        * @accessor
        	        */
     COURSECOMPONENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSECOMPONENT_PRIVILEGES')  	
	},

	refs : [{
		ref : 'coursecomponentsgrid',
		selector : 'coursecomponentsgrid'
	},{
		ref :'coursecomponentform',
		selector :'coursecomponentform'	 
	},{
		ref :'coursecomponentForm',
		selector :'coursecomponentform form'
	},{
		ref : 'coursetabstructure',
		selector : 'coursetabstructure'		
	},{
        ref: 'coursetabstructure',
        selector: 'coursetabstructure'
    }],

	init : function() {

		
		this.control({
			'coursecomponentsgrid' : {
				render :function(grid){
					this.courseComponentGridRender(grid);
				},
				afterrender:function(grid){
					var viewMode = this.getCoursetabstructure().getForm().findField('courseViewMode').getValue();
					if(viewMode == "View"){
						grid.down('#btnEdit').setVisible(false);
						grid.down('#btnDelete').setVisible(false);
						grid.down('#btnAdd').setVisible(false);
					}
				} 
			},
			'coursecomponentform button[itemId=courseComponentSaveBtnId]' : {
				click : this.saveCourseComponent
			},
			'coursecomponentform button[itemId=courseComponentCancelBtnId]' : {
				click : this.closeFormWindow
			},
			'coursecomponentform numberfield#componentCutOff' : {
    			blur : this.MinMaxValidate
    		},
    		'coursecomponentform numberfield#componentMaxMark' : {
    			blur : this.MinMaxValidate
    		},
			'coursecomponentsgrid button[itemId=btnAdd]' : {
				click : this.showFormWindow
			},
			'coursecomponentsgrid button[itemId=btnEdit]' : {
				click:  this.editFormWindow
			},
			'coursecomponentsgrid button[itemId=btnDelete]' : {
				click : this.deleteFormWindow
			},
			'coursecomponentsgrid button[itemId=btnView]' : {
				click : this.viewFormWindow
			},'coursecomponentform customcombobox[itemId=componentName]' : {
					select : function(obj, record) {
        				var componentCode = record[0].data.code;
						var form=this.getCoursecomponentform();
						form.down('#componentCodeId').setValue(componentCode);
						form.down('#componentNameToBePrintedId').setValue(componentCode);
						form.down('#componentCourseCodeToBePrintedId').setValue(componentCode);
				}
			},
		});
	},
	closeFormWindow : function() {
		this.getCoursecomponentform().close();
	},
	saveCourseComponent : function(btn){
		btn.setDisabled(true);
		var $this = this;

		var store = $this.getCoursecomponentsgrid();
		var grdStore = store.getStore();

		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		var cId = tabStcrFrm.findField("ids").getValue();

		var frmWin = $this.getCoursecomponentForm().getForm();
		var componentsId = frmWin.findField("componentName").getValue();
		var componentsName = frmWin.findField("componentName").getRawValue();
		var componentCode = frmWin.findField("componentName").valueModels[0].data.code;
		var value = frmWin.getValues();

		var courseComponents = new Academia.model.course.coursecomponent.CourseComponentModel();

		courseComponents.set("componentType",$this.getIdValueCodeJson(componentsId, componentsName, componentCode));
		courseComponents.set("componentDesc",value.componentDesc);
		courseComponents.set("componentStatus",value.componentStatus);
		courseComponents.set("componentCredit",isNullOrEmpty(value.componentCredit) ? 0:value.componentCredit);
		courseComponents.set("whetherComponentExempted",value.whetherComponentExemption);
		courseComponents.set("customFieldDatas",value.customFieldDatas);
		courseComponents.set("componentNameToBePrinted",value.componentNameToBePrinted);
		courseComponents.set("componentCourseCodeToBePrinted",value.componentCourseCodeToBePrinted);
		courseComponents.set("weighting",isNullOrEmpty(value.weighting) ? 0: value.weighting);
		
		var values = tabStcrFrm.getValues();
		var gradeMark = values.courseMarksGrades;
		if (gradeMark == 'MARK') {
			courseComponents.set("componentCutOff", value.componentCutOff);
			courseComponents.set("componentMaxMark", value.componentMaxMark);
		} else if (gradeMark == 'GRADE') {
			courseComponents.set("componentCutOff", value.gradeMinCutOff);
			courseComponents.set("componentMaxMark", value.gradeMaxCutOff);
		}
		
		courseComponents.set("course",$this.getIdValueJson(cId));
		
		if (value.id == null ||value.id == "") {
			submitUrl = SERVERURL.COURSE_COMPONENT_CREATE;
		} else {
			courseComponents.set("id",value.id);
			submitUrl = SERVERURL.COURSE_COMPONENT_UPDATE;
		}

		var submitData = Ext.encode(courseComponents.data);
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			url: submitUrl,
			jsonData: submitData,
			method: 'POST',
			success: function(response) {
				Ext.getBody().unmask();
				var mssg = response.responseText;
				btn.setDisabled(false);
				if(mssg=="success"){
					grdStore.reload();
					$this.closeFormWindow();
					showSuccessMessage(getCommonTranslation('COURSE_COMPONENTS'),getCommonTranslation('SUCCESS'));
				}else{
					showWarningMessage(getCommonTranslation('COURSE_COMPONENTS'),getCommonTranslation('CREDITMESSAGE'));//Please select a record
				}

			}
		});
	},
	editFormWindow: function() {
		
		var $this = this;

		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		var courseId = tabStcrFrm.findField("ids").getValue();
		var grid = $this.getCoursecomponentsgrid();
		
		var values = tabStcrFrm.getValues();
		var gradeType = values.courseMaxMarkCombo;
		
		if (grid.getSelectionModel().getCount() > 0) {
			this.showFormWindow();
			var form = $this.getCoursecomponentForm();
			var record = grid.getSelectionModel().getSelection()[0];
			var id = record.get("id");
			var editUrl = SERVERURL.COURSE_COMPONENT_FINDBYID;
            Ext.Ajax.request({
                method: "GET",
                type: 'rest',
                url: editUrl,
                params: {
                    id: id
                },
                success: function(f, action) {
                    var componentData = Ext.JSON.decode(f.responseText);
                    var courseComponents = new Academia.model.course.coursecomponent.CourseComponentModel(componentData);
		

			/*var store=this.getStore('course.coursecomponent.CourseComponentStore');
			var selectedRecord = grid.getSelectionModel().getSelection()[0];
			var row = store.indexOf(selectedRecord);
			var records=store.getAt(row);*/

				form.loadRecord(courseComponents);
				form.down('#componentName').setReadOnly(true);
				var radio = form.down('#componentStatus');
				var status = courseComponents.data.componentStatus;
				var component  = courseComponents.data.componentType;
				var exemptionRadio = form.down('#whetherComponentExemption');
				var exemptionStatus = courseComponents.data.whetherComponentExempted;
				if(exemptionStatus){
					exemptionRadio.items.items[0].setValue(true);
				}
				if(!status){
					radio.items.items[1].setValue(true);
				}
				if(component!=null){
					var componentId = component.id;
				}
				if(!isNullOrEmpty(componentData.componentType)){
					form.down('#componentCodeId').setValue(componentData.componentType.code);
				}
		//		var store = $this.getStore('course.coursecomponent.CourseComponentCombo');
				var componentName = form.down("#componentName");
				componentName.store.load({
		    		 params:{
		    			 componentId:componentId
		    		 },
		    		 callback: function(records, operation, success) {
		    			 if (success) {
		    				 componentName.setValue(componentId);
		    			 }
		    		 }
		    	 });
				
				var gradeMinCutOff = form.down("#gradeMinCutOff");
				gradeMinCutOff.store.load({
					params:{
						gradeType : gradeType
					},
					callback: function(records, operation, success) {
						if (success) {
							gradeMinCutOff.setValue(courseComponents.data.componentCutOff);
						}
					}
				});
				var gradeMaxCutOff = form.down("#gradeMaxCutOff");
				gradeMaxCutOff.store.load({
					params:{
						gradeType : gradeType
					},
					callback: function(records, operation, success) {
						if (success) {
							gradeMaxCutOff.setValue(courseComponents.data.componentMaxMark);
						}
					}
				});
				
                }
              });

		} else {
			showWarningMessage(getCommonTranslation('COURSE_COMPONENTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	showFormWindow : function() {
		
		var $this= this;
		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		var sectionAtComponentLevelFlag = tabStcrFrm.findField("sectionAtComponentLevelFlag").getValue();
		var whetherCourseExempted = tabStcrFrm.findField("whetherCourseExempted").getValue();
	
		var formWindow = $this.getCoursecomponentform();
		if (!formWindow) {
			Ext.widget('coursecomponentform');
			formWindow = $this.getCoursecomponentform();
		}
		
		var frm = $this.getCoursecomponentForm();
		var courseComponentForm = frm.getForm();
		
		var values = tabStcrFrm.getValues();
		var gradeMark = values.courseMarksGrades;
		var gradeType = values.courseMaxMarkCombo;
		
		if(sectionAtComponentLevelFlag=='true'){
			if (gradeMark == 'MARK') {
				courseComponentForm.findField("gradeMinCutOff").hide();
				courseComponentForm.findField("gradeMaxCutOff").hide();

				courseComponentForm.findField("componentCutOff").setVisible(true);
				courseComponentForm.findField("componentCutOff").allowBlank = false;
				courseComponentForm.findField("componentMaxMark").setVisible(true);
				courseComponentForm.findField("componentMaxMark").allowBlank = false;
			} else if (gradeMark == 'GRADE') {
				courseComponentForm.findField("componentCutOff").hide();
				courseComponentForm.findField("componentMaxMark").hide();

				courseComponentForm.findField("gradeMinCutOff").setVisible(true);
				courseComponentForm.findField("gradeMinCutOff").allowBlank = false;
				courseComponentForm.findField("gradeMaxCutOff").setVisible(true);
				courseComponentForm.findField("gradeMaxCutOff").allowBlank = false;

				if (!isNullOrEmpty(gradeType)) {
					var store = $this.getStore('examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades');
					store.getProxy().extraParams = {
						gradeType : gradeType
					};
					store.load();
				}
			}
		
			if(whetherCourseExempted =='false'){
				frm.down("#whetherComponentExemption").setVisible(true);
			}
		}
		
		formWindow.show();
		
		
		
	},
	viewFormWindow : function(){

		this.editFormWindow();
		var form =this.getCoursecomponentForm();
		if (form) {
			form.down('#courseComponentSaveBtnId').setVisible(false);
			form = form.getForm();
			toggleReadOnlyFormItems(form, true);
		}
	},
	deleteFormWindow: function() {
		var $this = this;
		var grid = $this.getCoursecomponentsgrid();
		var grdStore = grid.getStore();

		if(grid.getSelectionModel().getCount()>0){
			showConfirmMessage(getCommonTranslation('COURSE_COMPONENTS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
				if (btn == 'yes') {
					var records=grid.getSelectionModel().getSelection();						        
					var id=records[0].get("id");
					Ext.Ajax.request({
						method: "DELETE",
						type: 'rest',
						url: SERVERURL.COURSE_COMPONENT_DELETE+'?id='+id,
						headers: {
							'Content-Type': 'application/json'
						},
						params:{
							id:id
						},
						success:function(form, action){
							if(form.responseText == "DEPENDENT_RECORD_EXISTS"){
								showWarningMessage(getCommonTranslation('ALERT'),
										 getProgramandcourseTranslation('DEPENDENT_RECORD_EXISTS_COMPONENT'));
							}else{
							grdStore.reload();
							showSuccessMessage(getCommonTranslation('COURSE_COMPONENTS'),getCommonTranslation('SUCCESS'));
							}
						}
					});
				}
			});
		}else{
			showWarningMessage(getCommonTranslation('COURSE_COMPONENTS'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
		}

	},
	courseComponentGridRender : function(grid){
		var $this = this;
		$this.doAccessControlValidation(grid, $this.getCOURSECOMPONENT_PERMISSIONS());
		var tabStcrFrm = $this.getCoursetabstructure().getForm();
		var cId = tabStcrFrm.findField("ids").getValue();
		
		var store = this.getCoursecomponentsgrid().getStore();
		store.getProxy().extraParams = {
			id:cId
		};
		store.load();
		
		var store1 = $this.getStore('course.coursecomponent.CourseComponentCombo');
		  store1.getProxy().extraParams = {
			  courseId: cId
		  };
		  store1.load(); 
		  
	},
	getIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
	},
	getIdValueCodeJson: function(id, value, code) {
		if (id) return {
			id: id,
			value: value,
			code: code
		};
	},
      MinMaxValidate : function() {

      	var $this = this;
      	var form = $this.getCoursecomponentForm().getForm();

      	var cutOffMarks = form.findField("componentCutOff").getValue();
      	var maxMarks = form.findField("componentMaxMark")
      	.getValue();

      	if (cutOffMarks != null && maxMarks != null) {
      		if (cutOffMarks > maxMarks) {
      			form.findField("componentCutOff").setValue(null);
      			form.findField("componentMaxMark").setValue(null);
      			showWarningMessage(getCommonTranslation('COURSE'),
      					getCommonTranslation('COURSE_COMPONENT_MAX_MIN_MSSG'));
      		}
      	}

      }
});
