/*
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['common.IdValueDataModel','enquiry.AcademicBatchModel',
	          'coursetransaction.sectionmanagement.ProgramBatchSection',
	          'coursetransaction.sectionmanagement.ProgramBatchSectionSubmit',
	          'coursetransaction.sectionmanagement.ProgramBatchSectionStudent',
	          'coursetransaction.sectionmanagement.CourseSectionSubmitModel',
	          'coursetransaction.sectionmanagement.CourseSectionStudent',
	          'course.coursecomponent.CourseComponentModel',
	          'course.CreateCourseModel'
	          ],
      stores : ['common.ProgramStore','enquiry.AcademicBatchStore',
                'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
                'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
                'coursetransaction.sectionmanagement.CourseSectionCombo',
                'coursetransaction.facultytopicassignment.CourseComboStore',
                'coursetransaction.facultytopicassignment.PBSTopicStore',
                'coursetransaction.facultytopicassignment.AssignFacultyStore',
                'coursetransaction.facultytopicassignment.CourseSectionByIDStore',
                'coursetransaction.facultytopicassignment.AlternateFacultyStore',
                'coursetransaction.facultytopicassignment.CSTopicStore',
                'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
                'course.coursetopic.CourseComponentStore'
                ],
    views : [
             'coursetransaction.facultyTopicAssignment.CourseSectionFTAGrid',
             'coursetransaction.facultyTopicAssignment.CourseSectionFTASearch',
             'coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentStructure',
             'coursetransaction.facultyTopicAssignment.ProgramBatchSectionFTAGrid',
             'coursetransaction.facultyTopicAssignment.ProgramBatchSectionFTASearch',
             'coursetransaction.facultyTopicAssignment.AssignFacultyWindow'
             ],	 
             
       config:{
         	    
               	 /*
                 	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
                  		   	 */
                  	   	/**
                  	        * @cfg {Array} FACULTY_TOPICASSIGNMENT_PERMISSIONS array (required)
                  	        * The array of permissions to use for Access control wise enabling and disabling buttons.
                  	        * @accessor
                  	        */
    	   FACULTY_TOPICASSIGNMENTDETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_TOPICASSIGNMENTDETAILS_PRIVILEGES')
               	
      },           
     refs : [{
    	 ref : 'facultytopicassignmentstructure',
    	 selector : 'facultytopicassignmentstructure'
     },{
    	 ref : 'coursesectionftasearch',
    	 selector : 'coursesectionftasearch'
     },{
    	 ref : 'coursesectionftagrid',
    	 selector : 'coursesectionftagrid'
     },{
    	 ref : 'programbatchsectionftasearch',
    	 selector : 'programbatchsectionftasearch'
     },{
    	 ref : 'programbatchsectionftagrid',
    	 selector : 'programbatchsectionftagrid'
     },{
    	 ref : 'assignfacultywindow',
    	 selector : 'assignfacultywindow'
     },{
    	 ref : 'assignfacultyWindow',
    	 selector : 'assignfacultywindow form'
     }],
     
     init : function() {
    	 this.control({
    		 'facultytopicassignmentstructure':{
    			 
    			 render : this.getCourseProgramRender
    		 },
    		 'facultytopicassignmentstructure radiogroup[itemId=facultytopicassignment]' : {
    			 change : function(val,nV,oV){
    				 this.selectSection(val,nV,oV);
    			 }	
    		 },
    		 'programbatchsectionftasearch customcombobox#programId': {
    			 select: function(obj, record) {
    				 this$=this;
    				 var form= this$.getProgrambatchsectionftasearch();
    				 var programId = record[0].get("id");
    				 if(programId > 0){
    					 var store = this.getStore('enquiry.AcademicBatchStore');

    					 store.getProxy().extraParams = {
    						 id: programId
    					 };
    					 store.load({


  						   callback: function(records, operation, success) {
  							   if (success) {
  								   if(records.length==0){
  								   }
  								   if(records.length==1){
  									   form.down("#batchId").setValue(records[0].get('id'));
  									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
  									   store.getProxy().extraParams = {
  										   id: records[0].get('id'),
  										   isCurrentPeriod:true
  									   };
  									   store.load({
  										   callback: function(records, operation, success) {
  											   if (success) {
  												   if(records.length==0){
  													   if(wheatherSchool) {
  														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

  													   } 
  												   }
  												   if(records.length==1){
  													 form.down("#periodId").setValue(records[0].get('id'));
  								    				 var periodId = records[0].get("id");
  								    				 if(periodId > 0){
  								    					 var store = this$.getStore('coursetransaction.facultytopicassignment.CourseComboStore');
  								    					 store.getProxy().extraParams = {
  								    						 periodId : periodId
  								    					 };
  								    					 store.load();
  								    				 }
  								    			 
  												   }
  											   }
  										   }
  									   });
  								   }
  							   }
  						   }
  					   
     					 
    					 });
    				 }
    			 }
    		 },
    		 'programbatchsectionftasearch customcombobox#batchId': {
    			 select: function(obj, record) {
    				 this$=this;
    				 var form= this$.getProgrambatchsectionftasearch();

    				 var batchId = record[0].get("id");
    				 if(batchId > 0){
    					 var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');

    					 store.getProxy().extraParams = {
    						 id : batchId
    					 };
    					 store.load({


  						   callback: function(records, operation, success) {
  							   if (success) {
  								   if(records.length==0){
  									   if(wheatherSchool) {
  										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

  									   } 
  								   }
  								   if(records.length==1){
  									   form.down("#periodId").setValue(records[0].get('id'));
  									 var periodId = records[0].get("id");
					    				 if(periodId > 0){
					    					 var store = this$.getStore('coursetransaction.facultytopicassignment.CourseComboStore');
					    					 store.getProxy().extraParams = {
					    						 periodId : periodId
					    					 };
					    					 store.load();
					    				 }
  								   }
  							   }
  						   }
  					   
     					 
    					 });
    				 }
    			 }
    		 },
    		 'programbatchsectionftasearch customcombobox#periodId': {
    			 select: function(obj, record) {
    				 var periodId = record[0].get("id");
    				 if(periodId > 0){
    					 var store = this.getStore('coursetransaction.facultytopicassignment.CourseComboStore');
    					 store.getProxy().extraParams = {
    						 periodId : periodId
    					 };
    					 store.load();
    				 }
    			 }
    		 },
    		 'programbatchsectionftasearch customcombobox#courseCodeId': {
    			 select: function(obj, record) {
    				 var $this=this;
    				 var courseId = record[0].get("id");
    				 var periodId=obj.previousSibling().items.items[1].getValue();
    				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore');
    				 var componentField = this.getProgrambatchsectionftasearch().down("#componentSectionItemId");
    				 var sectionField = this.getProgrambatchsectionftasearch().down("#courseSectionId");
    				 
    				 if(record[0].data.sectionAtComponentLevel){
    					 componentField.show();
    					 componentField.allowBlank=false;
    					 sectionField.setDisabled(true);
    					 sectionField.clearValue();
        				 if(courseId > 0){//section on the bases of component
        					 componentField.getStore().getProxy().extraParams = {
        						 id : courseId
        					 };
        					 componentField.getStore().load();
        				 }
    				 }else{
    					 componentField.hide();
    					 componentField.reset();
    					 componentField.allowBlank=true;
    					 sectionField.setDisabled(false);
    				 if(courseId > 0 && periodId>0){
    					 sectionStore.getProxy().extraParams = {
    						 courseId : courseId,
    						 periodId : periodId
    					 };
    					 sectionStore.load();
    				 }
    				 }
    			 }
    		 },
    		 'programbatchsectionftasearch customcombobox#componentSectionItemId': {
    			 select: function(obj, record) {
    				 var $this=this;
    				 var form=$this.getProgrambatchsectionftasearch().getForm();
    				 this.getProgrambatchsectionftasearch().down("#courseSectionId").setDisabled(false);
    				 var formValues=form.getFieldValues();
    				 var componentId=record[0].get("id");
    				 var courseId = formValues.COURSE_ID;
    				 var periodId=formValues.PROGRAM_BATCH_PERIOD_CONFIG_ID;
    				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore');
    				 if(courseId > 0 && periodId>0&&componentId>0){
    					 sectionStore.getProxy().extraParams = {
    						 periodId : periodId,
    						 componentId:componentId
    					 };
    					 sectionStore.load();
    				 }
    			 }
    		 },
    		 'coursesectionftasearch customcombobox#courseId': {
    			 select: function(obj, record) {
    				 var courseId = record[0].get("id");
    				 var alinfomodel = Academia.model.authentication.ALInfoModel;
                	 var whetherSchool = alinfomodel.get('wheatherSchool');
    				 var sectionAtComponentLevel = record[0].get("sectionAtComponentLevel");
    				 var componentField = this.getCoursesectionftasearch().down("#componentSectionId");
    				 var form = this.getCoursesectionftasearch();
    				 if(sectionAtComponentLevel){
    					 componentField.show();
    					 componentField.allowBlank=false;
    					 form.down("#courseSectionId").setVisible(true);
    					 form.down("#courseSectionId").clearValue();
    					 form.down("#courseSectionId").setDisabled(true);
    					 //obj.nextSibling().clearValue();
    					 componentField.getStore().getProxy().extraParams = {
    						 id : courseId,
    						 whetherSchool:whetherSchool
    					 };
    					 componentField.getStore().load();
    				 }else{
    					 componentField.hide();
    					 componentField.clearValue();
    					 componentField.allowBlank=true;
    					 form.down("#courseSectionId").setDisabled(false);
    				 if(courseId > 0){
    					 var store = this.getStore('coursetransaction.facultytopicassignment.CourseSectionByIDStore');
    					 store.getProxy().extraParams = {
    						 courseId : courseId,
    						 whetherSchool:whetherSchool
    					 };
    					 store.load();
    				 }
    				 }
    			 }
    		 },
    		 'coursesectionftasearch customcombobox#componentSectionId': {
    			 select: function(obj, record) {
    				 var $this=this;
    				 obj.nextSibling().clearValue();
    				 this.getCoursesectionftasearch().down("#courseSectionId").setDisabled(false);
    				 var componentId=record[0].get("id");
    				 var sectionStore = $this.getStore('coursetransaction.facultytopicassignment.CourseSectionByIDStore');
    				 if(componentId>0){
    					 sectionStore.getProxy().extraParams = {
    						 componentId:componentId
    					 };
    					 sectionStore.load();
    				 }
    			 }
    		 },
    		 'programbatchsectionftasearch button[itemId=SearchBtn]': {
    			 click : this.getProgramSearch
    		 },
    		 'coursesectionftasearch button[itemId=searchBtn]': {
    			 click : this.getCourseSearch
    		 },
    		 'programbatchsectionftagrid button[itemId=btnAdd]': {
    			 click : function(){
    				  var $this=this;
        			   var grid =  $this.getProgrambatchsectionftagrid();
                	   var records = grid.selModel.getSelection();
        			   if(records.length>0){
        					this.checkFacultyFormParameter();
        					
        				   /*var formWindow = $this.getAssignfacultywindow();
     				        if (!formWindow) {
     				            Ext.widget('assignfacultywindow');
     				            formWindow = $this.getAssignfacultywindow();
     				        }
     				        formWindow.show();*/   
        			   }else{
        				   showWarningMessage(getCourseTxCommonTranslation('FACULTY_TOPIC_ASSIGNED'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
        			   }
    			 }//this.assignFacultyToTopicProgram
    		 },
    		 'coursesectionftagrid button[itemId=btnAdd]':{
    			 click : function(){
    			   var $this=this;
    			   var grid =  $this.getCoursesectionftagrid();
            	   var records = grid.selModel.getSelection();
    			   if(records.length>0){
    				   var formWindow = $this.getAssignfacultywindow();
 				        if (!formWindow) {
 				            Ext.widget('assignfacultywindow');
 				            formWindow = $this.getAssignfacultywindow();
 				        }
 				        formWindow.show();   
    			   }else{
    				   showWarningMessage(getCourseTxCommonTranslation('FACULTY_TOPIC_ASSIGNED'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
    			   }
    			   
    			 }//this.assignFacultyToTopicCourse
    		 },
    		 'coursesectionftagrid customcombobox#facultyeName1' :{
    			 select: function(obj, record) {
    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				 var form = $this.getCoursesectionftasearch().getForm();
    				 var courseSectionId = form.findField("courseSectionId").getValue();
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 var id = record[0].get("id");
    							 var value = record[0].get("code");
    							 var selectedModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];
    							 selectedModel.set('fId1',facultyId);
    							 selectedModel.set('alternateFaculty1',value);
    							 selectedModel.set('alternateFacultyId1',id);
    						 }	 
    					 }

    					 });

    				 }
    			 }
    		 },
    		 'coursesectionftagrid customcombobox#facultyeName2' :{
    			 select: function(obj, record) {
    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				 var form = $this.getCoursesectionftasearch().getForm();
    				 var courseSectionId = form.findField("courseSectionId").getValue();
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 var id = record[0].get("id");
    							 var value = record[0].get("code");
    							 var selectedModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];
    							 selectedModel.set('fId2',facultyId);
    							 selectedModel.set('alternateFaculty2',value);
    							 selectedModel.set('alternateFacultyId2',id);
    						 }	 
    					 }

    					 });

    				 }
    			 }
    		 },
    		 'coursesectionftagrid customcombobox#facultyeName3' :{
    			 select: function(obj, record) {
    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				 var form = $this.getCoursesectionftasearch().getForm();
    				 var courseSectionId = form.findField("courseSectionId").getValue();
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 var id = record[0].get("id");
    							 var value = record[0].get("code");
    							 var selectedModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];
    							 selectedModel.set('alternateFaculty3',value);
    							 selectedModel.set('alternateFacultyId3',id);
    						 }	 
    					 }

    					 });

    				 }
    			 }
    		 },
    		 'programbatchsectionftagrid customcombobox#facultyeName1' :{
    			 select: function(obj, record) {

    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				 var form = $this.getProgrambatchsectionftasearch().getForm();
    				 var courseSectionId = form.findField("courseSectionId").getValue();
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 var id = record[0].get("id");
    							 var value = record[0].get("code");
    							 var selectedModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];
    							 selectedModel.set('fId1',facultyId);
    							 selectedModel.set('alternateFaculty1',value);
    							 selectedModel.set('alternateFacultyId1',id);
    						 }	 
    					 }
    					 });
    				 };
    			 }	 
    		 },
    		 'programbatchsectionftagrid customcombobox#facultyeName2' :{
    			 select: function(obj, record) {
    				 var $this = this;
    				 var facultyId = record[0].get("id");

    				 var form = $this.getProgrambatchsectionftasearch().getForm();
    				 var courseSectionId = form.findField("courseSectionId").getValue();

    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 var id = record[0].get("id");
    							 var value = record[0].get("code");
    							 var selectedModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];
    							 selectedModel.set('fId2',facultyId);
    							 selectedModel.set('alternateFaculty2',value);
    							 selectedModel.set('alternateFacultyId2',id);
    						 }	 
    					 }
    					 });
    				 }
    			 }
    		 },
    		 'programbatchsectionftagrid customcombobox#facultyeName3' :{
    			 select: function(obj, record) {
    				 var $this = this;
    				 var facultyId = record[0].get("id");

    				 var form = $this.getProgrambatchsectionftasearch().getForm();
    				 var courseSectionId = form.findField("courseSectionId").getValue();

    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success) {
    							 var id = record[0].get("id");
    							 var value = record[0].get("code");
    							 var selectedModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];
    							 selectedModel.set('alternateFaculty3',value);
    							 selectedModel.set('alternateFacultyId3',id);
    						 }	 
    					 }
    					 });
    				 }
    			 }
    		 },
    		 'assignfacultywindow customcombobox#assignFaculty_1_ItemId':{	
    			 select:function(obj,record){
    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				 //check for course section and program batch section
    				 var formStructure=$this.getFacultytopicassignmentstructure();
    				 var  radio=formStructure.items.items[1];
    				 var courseSectionId=null;
    				 var courseId=null;
        			 var periodId=null;
        			 var componentId=null;
    				 if(radio.items.items[1].checked){
        				 var courseForm = $this.getCoursesectionftasearch().getForm();
        				 var componentField=courseForm.findField('componentSectionId');
        				 var courseSectionId = $this.getCoursesectionftasearch().down("#courseSectionId").getValue();
        				  if(!componentField.isHidden()){
        						 componentId=componentField.getValue();
        					 }else{
        						 courseId = courseForm.findField("courseId").getValue();
        					 }
    				 }else{
    					 var prorgamForm = $this.getProgrambatchsectionftasearch().getForm();
    					 var componentField=prorgamForm.findField('componentSectionId');
        				 courseSectionId = prorgamForm.findField("courseSectionId").getValue();
    					 periodId=prorgamForm.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
    					 if(!componentField.isHidden()){
    						 componentId=componentField.getValue();
    					 }else{
    						 courseId = prorgamForm.findField("COURSE_ID").getValue();
    					 }
    				 }
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId,
    						 courseId : courseId,
    						 periodId:periodId,
    						 componentId:componentId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success&&record.length>0) {
    							 obj.nextSibling().setValue(record[0].data.value);
    							 obj.nextSibling().nextSibling().setValue(record[0].data.id);
    						 }	 
    					   }
    					 });
    				 }
    				 obj.store.remove(record);
    				 var assignFaculty2Field=Ext.ComponentQuery.query('customcombobox#assignFaculty_2_ItemId')[0];
    				     assignFaculty2Field.enable();
    			 }
    		 },
    		 'assignfacultywindow customcombobox#assignFaculty_2_ItemId':{	
    			 select:function(obj,record){
    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				//check for course section and program batch section
    				 var formStructure=$this.getFacultytopicassignmentstructure();
    				 var  radio=formStructure.items.items[1];
    				 var courseSectionId=null;
    				 var courseId=null;
        			 var periodId=null;
        			 var componentId=null;
    				 if(radio.items.items[0].checked){
        				 var courseForm = $this.getCoursesectionftasearch().getForm();
        				 var componentField=courseForm.findField('componentSectionId');
        				  courseSectionId = courseForm.findField("courseSectionId").getValue();
        				  if(!componentField.isHidden()){
        						 componentId=componentField.getValue();
        					 }else{
        						 courseId = courseForm.findField("courseId").getValue();
        					 }
    				 }else{
    					 var prorgamForm = $this.getProgrambatchsectionftasearch().getForm();
    					 var componentField=prorgamForm.findField('componentSectionId');
        				 courseSectionId = prorgamForm.findField("courseSectionId").getValue();
    					 periodId=prorgamForm.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
    					 if(!componentField.isHidden()){
    						 componentId=componentField.getValue()
    					 }else{
    						 courseId = prorgamForm.findField("COURSE_ID").getValue();
    					 }
    				 }
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId,
    						 courseId : courseId,
    						 periodId:periodId,
    						 componentId:componentId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success&&record.length>0) {
    							 obj.nextSibling().setValue(record[0].data.value);
    							 obj.nextSibling().nextSibling().setValue(record[0].data.id);
    						 }	 
    					   }
    					 });
    				 }
    				 obj.store.remove(record);
    				 var assignFaculty3Field=Ext.ComponentQuery.query('customcombobox#assignFaculty_3_ItemId')[0];
				     assignFaculty3Field.enable();
    			 }
    		 },
    		 'assignfacultywindow customcombobox#assignFaculty_3_ItemId':{	
    			 select:function(obj,record){
    				 var $this = this;
    				 var facultyId = record[0].get("id");
    				//check for course section and program batch section
    				 var formStructure=$this.getFacultytopicassignmentstructure();
    				 var  radio=formStructure.items.items[1];
    				 var courseSectionId=null;
    				 var courseId=null;
        			 var periodId=null;
        			 var componentId=null;
    				 if(radio.items.items[0].checked){
        				 var courseForm = $this.getCoursesectionftasearch().getForm();
        				 var componentField=courseForm.findField('componentSectionId');
        				  courseSectionId = courseForm.findField("courseSectionId").getValue();
        				  if(!componentField.isHidden()){
        						 componentId=componentField.getValue();
        					 }else{
        						 courseId = courseForm.findField("courseId").getValue();
        					 }
    				 }else{
    					 var prorgamForm = $this.getProgrambatchsectionftasearch().getForm();
    					 var componentField=prorgamForm.findField('componentSectionId');
        				 courseSectionId = prorgamForm.findField("courseSectionId").getValue();
        				 courseId = prorgamForm.findField("COURSE_ID").getValue();
    					 periodId=prorgamForm.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
    					 if(!componentField.isHidden()){
    						 componentId=componentField.getValue();
    					 }else{
    						 courseId = prorgamForm.findField("COURSE_ID").getValue();
    					 }
    				 }
    				 if(facultyId > 0 && courseSectionId > 0){
    					 var store = $this.getStore('coursetransaction.facultytopicassignment.AlternateFacultyStore');
    					 store.load({params:{
    						 sectionId : courseSectionId,
    						 facultyId : facultyId,
    						 courseId : courseId,
    						 periodId:periodId,
    						 componentId:componentId
    					 },
    					 callback: function(record, operation, success) {
    						 if (success&&record.length>0) {
    							 obj.nextSibling().setValue(record[0].data.value);
    							 obj.nextSibling().nextSibling().setValue(record[0].data.id);
    						 }	 
    					   }
    					 });
    				 }
    			 }
    		 },
    		 'assignfacultywindow button[itemId=assignFacultyCnclBtnId]':{
    			 click : function(){
    			   var $this=this;
    			   var formWindow = $this.getAssignfacultywindow();
			       formWindow.close();
    			 }
    		 },
    		 'assignfacultywindow button[itemId=assignFacultyAddBtnId]':{
    			 click :function(){
    				 var $this=this;
    				 var formStructure=$this.getFacultytopicassignmentstructure();
    				 var assignmentType = formStructure.getForm().findField('facultytopicassignment').getValue();
    				 //var  radio=formStructure.items.items[1];
    				 
    				 
    				 //if(radio.items.items[0].checked){
    				 if(!assignmentType){
    					 $this.saveAssignfacultyCoursewindow();
    				 }else{
    					 $this.assignFacultyToTopicProgram();
    				 }
    			 } 
    		 },
    		 'assignfacultywindow':{
    			 show:function(){
//    				 this.checkFacultyFormParameter();
    		
    				 var $this=this;
    				 var formStructure=$this.getFacultytopicassignmentstructure();
    				 //var radio=formStructure.items.items[1];
    				 var courseForm = $this.getCoursesectionftasearch().getForm();
    				 var prorgamForm = $this.getProgrambatchsectionftasearch().getForm();
    				 var componentField=prorgamForm.findField('componentSectionId');
    				 var componentCourseField=courseForm.findField('componentSectionId');
    				 var windowForm=$this.getAssignfacultyWindow();
    				 var courseSectionId=null;
        			 var courseId=null;
        			 var periodId=null;
        			 var componentId=null;
        			 var assignmentType = formStructure.getForm().findField('facultytopicassignment').getValue();
    				 
    				 if(!assignmentType){
    					 courseSectionId = courseForm.findField("courseSectionId").getValue();
    					 if(!componentCourseField.isHidden()){
    						 componentId=componentCourseField.getValue();
    					 }else{
    						 courseId = courseForm.findField("courseId").getValue();
    					 }
    				 }else{
    					 courseSectionId = prorgamForm.findField("courseSectionId").getValue();
    					 periodId=prorgamForm.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
    					 if(!componentField.isHidden()){
    						 componentId=componentField.getValue();
    					 }else{
    						 courseId = prorgamForm.findField("COURSE_ID").getValue();
    					 }
    				 }
    				 
    				 var facultyStore = $this.getStore('coursetransaction.facultytopicassignment.AssignFacultyStore');
    				 facultyStore.getProxy().extraParams = {
    					 sectionId:courseSectionId,
						 courseId : courseId,
						 periodId:periodId,
						 componentId:componentId
					 };
    				 facultyStore.load({
    					 callback:function(record, operation, success){
//    				if(record.length > 0){
    					  if(record.length==1){
    						  windowForm.down('#fieldAssignFaculty2').setVisible(false);
    						  windowForm.down('#assignFaculty_2_ItemId').allowBlank=true;
    						  windowForm.down('#fieldAssignFaculty3').setVisible(false);
    						  windowForm.down('#assignFaculty_3_ItemId').allowBlank=true;
    						  //windowForm.items.items[1].hide();
    						  //windowForm.items.items[2].hide();
    					  }
                          if(record.length==2){
                        	  windowForm.down('#fieldAssignFaculty3').setVisible(false);
                        	  windowForm.down('#assignFaculty_3_ItemId').allowBlank=true;
                        	  //windowForm.items.items[2].hide();
    					  }
//    				}
    				 /*else{
    					showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('NO_FACULTY_ASSIGN'));
    				}*/
    				 }});
    			 }
    		 }
    	 });
     },
     selectSection : function(val,nV,oV){
    	 var $this =  this;
    	 var form = $this.getFacultytopicassignmentstructure();
    	 var value = form.getForm().findField('facultytopicassignment').getValue();

    	 if(value){
    		 form.down("#coursesectionftasearch").hide();
    		 form.down("#coursesectionftagrid").hide();
    		 form.down("#programbatchsectionftasearch").show();
    		 form.down("#programbatchsectionftagrid").show();

    	 }else{
    		 form.down("#coursesectionftasearch").show();
    		 form.down("#coursesectionftagrid").show();
    		 form.down("#programbatchsectionftasearch").hide();
    		 form.down("#programbatchsectionftagrid").hide();
    	 }

     },

     // to get topic list based on courseId

     getProgramSearch : function(){

    	 var $this = this;
    	 var form = $this.getProgrambatchsectionftasearch().getForm();
    	 var courseId = form.findField("COURSE_ID").getValue();
    	 var courseSectionId = form.findField("courseSectionId").getValue();
    	 var periodId=form.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
    	 var sectionId = form.findField("courseSectionId").getValue();
    	 var grid = $this.getProgrambatchsectionftagrid();
    	 $this.doAccessControlValidation(grid, $this.getFACULTY_TOPICASSIGNMENTDETAILS_PERMISSIONS());
    	 var store = grid.getStore();
    	 var component=form.findField('componentSectionId');
    	 if(component.isHidden()){
    		store.getProxy().extraParams = {
            		 courseId:courseId,
            		 sectionId:sectionId
            	 };
            	 store.load();
          }else{
        	store.getProxy().extraParams = {
        		 componentId:component.getValue(),
        		 sectionId:sectionId
        	 };
        	 store.load();
        	 courseId=null;
          }
    	 
    	

    	 var store1 = $this.getStore('coursetransaction.facultytopicassignment.AssignFacultyStore');
    	 store1.load({params:{
    		 sectionId:courseSectionId,
    		 courseId : courseId,
			 periodId:periodId,
			 componentId:component.getValue()
			 },
    		 callback: function(record, operation, success) {
    			 
    			   for(var i=0;i<grid.columns;i++){
    				   grid.columns[i].setVisible(true);
    			    }
    			   if(record.length==1){
    		    		grid.columns[4].setVisible(false);
    		    		grid.columns[5].setVisible(false);
    		    		grid.columns[6].setVisible(false);
    		    		grid.columns[7].setVisible(false);
    		    	}
    		    	if(record.length==2){
    		    		grid.columns[6].setVisible(false);
    		    		grid.columns[7].setVisible(false);
    		    	}
    		 }
    	 });
     },
     getCourseSearch : function(){
    	 var $this = this;
    	 
    	 var form = $this.getCoursesectionftasearch().getForm();
    	 var courseId = form.findField("courseId").getValue();
    	 var sectionId = form.findField("courseSectionId").getValue();
    	 var componentField= form.findField("componentSectionId");
    	  var componentId = componentField.getValue();
    	 var grid = $this.getCoursesectionftagrid();
    	 $this.doAccessControlValidation(grid, $this.getFACULTY_TOPICASSIGNMENTDETAILS_PERMISSIONS());
    	 var store = $this.getStore('coursetransaction.facultytopicassignment.CSTopicStore');
    	
    	 if(componentField.isHidden()){
    	 store.getProxy().extraParams = {
    		 courseId:courseId,
    		 sectionId:sectionId
    	 };
    	 }else{
    		 store.getProxy().extraParams = {
    			 componentId:componentId,
        		 sectionId:sectionId
        	 };
    		 courseId=null;
    	 }
    	 store.load();
    	 var store1 = $this.getStore('coursetransaction.facultytopicassignment.AssignFacultyStore');

    	 store1.load({params:{
    		 sectionId:sectionId,
    		 courseId:courseId,
    		 componentId:componentField.getValue() 
    	    },
    		 callback: function(record, operation, success) {
    			 
    		    	/*for(var i=0;i<grid.columns;i++){
    				   grid.columns[i].setVisible(true);
    			    }*/	 
    			 
    		    	if(record.length==1){
    		    		grid.columns[5].setVisible(false);
    		    		grid.columns[6].setVisible(false);
    		    		grid.columns[7].setVisible(false);
    		    		grid.columns[8].setVisible(false);
    		    	}
    		    	if(record.length==2){
    		    		grid.columns[7].setVisible(false);
    		    		grid.columns[8].setVisible(false);
    		    	}
    		 }
    	 });
    	 
    	 
     },

     // save topic and faculty (program section)
     assignFacultyToTopicProgram : function(){
    	 var $this = this;
    	 var grid =  $this.getProgrambatchsectionftagrid();
    	 var form =  $this.getProgrambatchsectionftasearch().getForm();
         var formWindow =  $this.getAssignfacultyWindow();
         var assignForm =  formWindow.getForm();
         formWindow.down('#assignFacultyAddBtnId').setDisabled(true);
    	 
         var assignfaculty1 = assignForm.findField("assignfaculty1").getValue();
    	 var assignfaculty2 = assignForm.findField("assignfaculty2").getValue();
    	 var assignfaculty3 = assignForm.findField("assignfaculty3").getValue();
    	 
    	 var alternateFacultyId1 = assignForm.findField("alternateFacultyId1").getValue();
    	 var alternateFacultyId2 = assignForm.findField("alternateFacultyId2").getValue();
    	 var alternateFacultyId3 = assignForm.findField("alternateFacultyId3").getValue();
    	 
    	 
    	 var sId =   form.findField("courseSectionId").getValue();
    	 var sName = form.findField("courseSectionId").getRawValue();
    	 var periodId=form.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
    	 var courseId=form.findField("COURSE_ID").getValue();

    	 
    	 var grdStore = grid.getStore();
    	 var records = grid.selModel.getSelection();
    	 if(records.length>0){

    		 var facultyTopic1=[];
    		 var facultyTopic2=[];
    		 var facultyTopic3=[];

    		 var facultyUrl1=SERVERURL.TOPIC_ASSIGNMENT_CREATE;
    	     var facultyUrl2=SERVERURL.TOPIC_ASSIGNMENT_CREATE;
    		 var facultyUrl3=SERVERURL.TOPIC_ASSIGNMENT_CREATE;
    		 
    		 for(var i in records) {
    			 var assignFacultyTableId1=null;
    			 var courseVariantId1=null;
    			 if(records[i].data.faculty!=null&&records[i].data.faculty.length>0){//records[i].data.faculty.length>0
    				 assignFacultyTableId1=records[i].data.faculty[0].id;
    				 courseVariantId1=records[i].data.faculty[0].courseVariantId;
    				// facultyUrl1=SERVERURL.TOPIC_ASSIGNMENT_UPDATE_URL;
    			 }
    			 if(courseVariantId1){
    				 courseVariantId1 =$this.getIdValueJson(courseVariantId1);
    			 }
    				 facultyTopic1.push({
    					 "id":assignFacultyTableId1,
    					 "courseTopic": $this.getIdValueJson(records[i].data.topic.id,records[i].data.topic.value),
    					 "section":$this.getIdValueJson(sId,sName),
    					 "facultyByAlternateFacultyId":$this.getIdValueJson(alternateFacultyId1),
    					 "facultyByFacultyId" :$this.getIdValueJson(assignfaculty1),
    					 "whetherAlternateFaculty":true,
    					 "courseVariant":courseVariantId1,
    					 "periodId":periodId,
    					 "courseId":courseId,
    					 "facultyAssignSequence":0
    				 });
    		 };

    		 if(assignfaculty2>0){
    		 for(var i in records){
    			 var assignFacultyTableId2=null;
    			 var courseVariantId2=null;
    			 if(records[i].data.faculty!=null&&records[i].data.faculty.length>1){//records[i].data.faculty.length>1
    				 assignFacultyTableId2=records[i].data.faculty[1].id;
    				 courseVariantId2=records[i].data.faculty[1].courseVariantId;
    				// facultyUrl2=SERVERURL.TOPIC_ASSIGNMENT_UPDATE_URL;
    			 }
    			 if(courseVariantId2){
    				 courseVariantId2 =$this.getIdValueJson(courseVariantId2);
    			 }
    				 facultyTopic2.push({
    					 "id":assignFacultyTableId2,
    					 "courseTopic": $this.getIdValueJson(records[i].data.topic.id,records[i].data.topic.value),
    					 "section":$this.getIdValueJson(sId,sName),
    					 "facultyByAlternateFacultyId":$this.getIdValueJson(alternateFacultyId2),
    					 "facultyByFacultyId" :$this.getIdValueJson(assignfaculty2),
    					 "whetherAlternateFaculty":true,
    					 "courseVariant":courseVariantId2,
    					 "periodId":periodId,
    					 "courseId":courseId,
    					 "facultyAssignSequence":1
    				 });
    		 };
    		 }

    		 if(assignfaculty3>0){
    		 for(var i in records){
    			 var assignFacultyTableId3=null;
    			 var courseVariantId3=null;
    			 if(records[i].data.faculty!=null&&records[i].data.faculty.length>2){//records[i].data.faculty.length>2
    				 assignFacultyTableId3=records[i].data.faculty[2].id;
    				 courseVariantId3=records[i].data.faculty[2].courseVariantId;
    				 //facultyUrl3=SERVERURL.TOPIC_ASSIGNMENT_UPDATE_URL;
    			 }
    			 if(courseVariantId3){
    				 courseVariantId3 =$this.getIdValueJson(courseVariantId3);
    			 }
    				 facultyTopic3.push({
    					 "id":assignFacultyTableId3,
    					 "courseTopic": $this.getIdValueJson(records[i].data.topic.id,records[i].data.topic.value),
    					 "section":$this.getIdValueJson(sId,sName),
    					 "facultyByAlternateFacultyId":$this.getIdValueJson(alternateFacultyId3),
    					 "facultyByFacultyId" :$this.getIdValueJson(assignfaculty3),
    					 "whetherAlternateFaculty":true,
    					 "courseVariant":courseVariantId3,
    					 "periodId":periodId,
    					 "courseId":courseId,
    					 "facultyAssignSequence":2
    				 });
    		 };
    		 }

    		 var submitData1 = facultyTopic1;
    		 var submitData2 = facultyTopic2;
    		 var submitData3 = facultyTopic3;
    		 
    		 if(facultyTopic1.length>0){
    			 Ext.Ajax.request({
    				 url: facultyUrl1,
    				 jsonData: submitData1,
    				 method: 'POST',
    				 success: function(response) {
    					 var MSSG = response.responseText;
    					 showSuccessMessage(getCommonTranslation('FACULTY_TOPIC_ASSIGNED'), getCommonTranslation('SUCCESS'));
    					 grdStore.reload();
    					 grid.getSelectionModel().deselectAll();
    					 
    				 }
    			 });
    		 }

    		 if(facultyTopic2.length>0){
    			 Ext.Ajax.request({
    				 url: facultyUrl2,
    				 jsonData: submitData2,
    				 method: 'POST',
    				 success: function(response) {
    					 var MSSG = response.responseText;
    				 }
    			 });
    		 }
    		 if(facultyTopic3.length>0){
    			 Ext.Ajax.request({
    				 url: facultyUrl3,
    				 jsonData: submitData3,
    				 method: 'POST',
    				 success: function(response) {
    					 var MSSG = response.responseText;
    				 }
    			 });
    		 }
    	 }
    	 $this.getAssignfacultywindow().close();
     },

     // save topic and faculty (course section)
     saveAssignfacultyCoursewindow : function(){

    	 var $this = this;
    	 var grid =  $this.getCoursesectionftagrid();
    	 var form =  $this.getCoursesectionftasearch().getForm();
    	 var formWindow =  $this.getAssignfacultyWindow();
    	 var assignForm =  formWindow.getForm();
    	 formWindow.down('#assignFacultyAddBtnId').setDisabled(true);
    	 
    	 var assignfaculty1 = assignForm.findField("assignfaculty1").getValue();
    	 var assignfaculty2 = assignForm.findField("assignfaculty2").getValue();
    	 var assignfaculty3 = assignForm.findField("assignfaculty3").getValue();
    	 
    	 var alternateFacultyId1 = assignForm.findField("alternateFacultyId1").getValue();
    	 var alternateFacultyId2 = assignForm.findField("alternateFacultyId2").getValue();
    	 var alternateFacultyId3 = assignForm.findField("alternateFacultyId3").getValue();
    	 
    	 var sId = form.findField("courseSectionId").getValue();
    	 var sName = form.findField("courseSectionId").getRawValue();

    	 var grdStore = grid.getStore();
    	 var records = grid.selModel.getSelection();
    	 if(records.length>0){

    		 var facultyTopic1=[];
    		 var facultyTopic2=[];
    		 var facultyTopic3=[];
              
    		 var facultyUrl1=SERVERURL.TOPIC_ASSIGNMENT_CREATE_COURSE_SECTION;
    	     var facultyUrl2=SERVERURL.TOPIC_ASSIGNMENT_CREATE_COURSE_SECTION;
    		 var facultyUrl3=SERVERURL.TOPIC_ASSIGNMENT_CREATE_COURSE_SECTION;
    		 for(var i in records) {
    			 var assignFacultyTableId1=null;
    			 var courseVariantId1=null;
    			 if(records[i].data.faculty!=null&&records[i].data.faculty.length>0){//&&records[i].data.faculty.length>0
    				 assignFacultyTableId1=records[i].data.faculty[0].id;
    				 courseVariantId1=records[i].data.faculty[0].courseVariantId;
    				 //facultyUrl1=SERVERURL.TOPIC_ASSIGNMENT_UPDATE_URL;
    			 }
    			
    			 if(courseVariantId1){
    				 courseVariantId1 =$this.getIdValueJson(courseVariantId1);
    			 }
    		
    				 facultyTopic1.push({
    					 "id":assignFacultyTableId1,
    					 "courseTopic": $this.getIdValueJson(records[i].data.topic.id,records[i].data.topic.value),
    					 "section":$this.getIdValueJson(sId,sName),
    					 "facultyByAlternateFacultyId":$this.getIdValueJson(alternateFacultyId1),
    					 "facultyByFacultyId" :$this.getIdValueJson(assignfaculty1),
    					 "whetherAlternateFaculty":true,
    					 "courseVariant":courseVariantId1,
    					 "facultyAssignSequence":0
    				 });
    		 };
    		 if(assignfaculty2>0){
    		 for(var i in records){
    			 var assignFacultyTableId2=null;
    			 var courseVariantId2=null;
    			 if(records[i].data.faculty!=null&&records[i].data.faculty.length>1){//records[i].data.faculty.length>1
    				 assignFacultyTableId2=records[i].data.faculty[1].id;
    				 courseVariantId2=records[i].data.faculty[1].courseVariantId;
    				// facultyUrl2=SERVERURL.TOPIC_ASSIGNMENT_UPDATE_URL;
    			 }
    			 if(courseVariantId2){
    				 courseVariantId2 =$this.getIdValueJson(courseVariantId2);
    			 }
    				 facultyTopic2.push({
    					 "id":assignFacultyTableId2,
    					 "courseTopic": $this.getIdValueJson(records[i].data.topic.id,records[i].data.topic.value),
    					 "section":$this.getIdValueJson(sId,sName),
    					 "facultyByAlternateFacultyId":$this.getIdValueJson(alternateFacultyId2),
    					 "facultyByFacultyId" :$this.getIdValueJson(assignfaculty2),
    					 "whetherAlternateFaculty":true,
    					 "courseVariant":courseVariantId2,
    					 "facultyAssignSequence":1
    				 });
    		 };
    		 }
    		 
    		 if(assignfaculty3>0){
    		 for(var i in records){
    			 var assignFacultyTableId3=null;
    			 var courseVariantId3=null;
    			 if(records[i].data.faculty!=null&&records[i].data.faculty.length>2){//records[i].data.faculty.length>2
    				 assignFacultyTableId3=records[i].data.faculty[2].id;
    				 courseVariantId3=records[i].data.faculty[2].courseVariantId;
    				 //facultyUrl3=SERVERURL.TOPIC_ASSIGNMENT_UPDATE_URL;
    			 }
    			 if(courseVariantId3){
    				 courseVariantId3 =$this.getIdValueJson(courseVariantId3);
    			 }
    				 facultyTopic3.push({
    					 "id":assignFacultyTableId3,
    					 "courseTopic": $this.getIdValueJson(records[i].data.topic.id,records[i].data.topic.value),
    					 "section":$this.getIdValueJson(sId,sName),
    					 "facultyByAlternateFacultyId":$this.getIdValueJson(alternateFacultyId3),
    					 "facultyByFacultyId" :$this.getIdValueJson(assignfaculty3),
    					 "whetherAlternateFaculty":true,
    					 "courseVariant":courseVariantId3,
    					 "facultyAssignSequence":2
    				 });
    		 };
    		 }
    		 
    		 var submitData1 = facultyTopic1;
    		 var submitData2 = facultyTopic2;
    		 var submitData3 = facultyTopic3;

    		 if(facultyTopic1.length>0){
    			 Ext.Ajax.request({
    				 url: facultyUrl1,
    				 jsonData: submitData1,
    				 method: 'POST',
    				 success: function(response) {
    					 var MSSG = response.responseText;
    					 showSuccessMessage(getCommonTranslation('FACULTY_TOPIC_ASSIGNED'), getCommonTranslation('SUCCESS'));
    					 grdStore.reload();
    					 grid.getSelectionModel().deselectAll();
    				 }
    			 });
    		 }

    		 if(facultyTopic2.length>0){
    			 Ext.Ajax.request({
    				 url: facultyUrl2,
    				 jsonData: submitData2,
    				 method: 'POST',
    				 success: function(response) {
    					 var MSSG = response.responseText;
    				 }
    			 });
    		 }
    		 if(facultyTopic3.length>0){
    			 Ext.Ajax.request({
    				 url: facultyUrl3,
    				 jsonData: submitData3,
    				 method: 'POST',
    				 success: function(response) {
    					 var MSSG = response.responseText;
    				 }
    			 });
    		 }
    		 
    	 }
    	 $this.getAssignfacultywindow().close();
     },
     getIdValueJson: function(id, value) {
    	 if (id) return {
    		 id: id,
    		 value: value
    	 };
     },
    getCourseProgramRender : function(){
    	  var $this = this;
    	  var alinfomodel = Academia.model.authentication.ALInfoModel;
    	  var wheatherSchool = alinfomodel.get('wheatherSchool');
    	  var form= $this.getProgrambatchsectionftasearch();
		 if(wheatherSchool) {
				 form.down('#periodId').setVisible(false);
		 }
    	 $this.getCourseSearch();
    	 $this.getProgramSearch();
    	 $this.selectSection();
     },
     checkFacultyFormParameter:function(){
		 var $this=this;
		 var formStructure=$this.getFacultytopicassignmentstructure();
		 //var radio=formStructure.items.items[1];
		 var courseForm = $this.getCoursesectionftasearch().getForm();
		 var prorgamForm = $this.getProgrambatchsectionftasearch().getForm();
		 var componentField=prorgamForm.findField('componentSectionId');
		 var componentCourseField=courseForm.findField('componentSectionId');
		 var windowForm=$this.getAssignfacultyWindow();
		 var courseSectionId=null;
		 var courseId=null;
		 var periodId=null;
		 var componentId=null;
		 var assignmentType = formStructure.getForm().findField('facultytopicassignment').getValue();
		 
		 if(!assignmentType){
			 courseSectionId = courseForm.findField("courseSectionId").getValue();
			 if(!componentCourseField.isHidden()){
				 componentId=componentCourseField.getValue();
			 }else{
				 courseId = courseForm.findField("courseId").getValue();
			 }
		 }else{
			 courseSectionId = prorgamForm.findField("courseSectionId").getValue();
			 periodId=prorgamForm.findField("PROGRAM_BATCH_PERIOD_CONFIG_ID").getValue();
			 if(!componentField.isHidden()){
				 componentId=componentField.getValue();
			 }else{
				 courseId = prorgamForm.findField("COURSE_ID").getValue();
			 }
		 }
		 
		 var facultyStore = $this.getStore('coursetransaction.facultytopicassignment.AssignFacultyStore');
		 facultyStore.getProxy().extraParams = {
			 sectionId:courseSectionId,
			 courseId : courseId,
			 periodId:periodId,
			 componentId:componentId
		 };
		 facultyStore.load({
			 callback:function(record, operation, success){
				 if(record.length > 0){
					 $this.showFacultyWindow();
					 /*if(record.length==1){
						 windowForm.down('#fieldAssignFaculty2').setVisible(false);
						 windowForm.down('#assignFaculty_2_ItemId').allowBlank=true;
						 windowForm.down('#fieldAssignFaculty3').setVisible(false);
						 windowForm.down('#assignFaculty_3_ItemId').allowBlank=true;
						 //windowForm.items.items[1].hide();
						 //windowForm.items.items[2].hide();
					 }
					 if(record.length==2){
						 windowForm.down('#fieldAssignFaculty3').setVisible(false);
						 windowForm.down('#assignFaculty_3_ItemId').allowBlank=true;
						 //windowForm.items.items[2].hide();
					 }*/
				 }else{
			//$this.getAssignfacultywindow().close();
			showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('NO_FACULTY_ASSIGN'));
		}
		 }});
     },
    showFacultyWindow:function(){
    	var $this = this;
    	 var formWindow = $this.getAssignfacultywindow();
	        if (!formWindow) {
	            Ext.widget('assignfacultywindow');
	            formWindow = $this.getAssignfacultywindow();
	        }
	        formWindow.show();
     }
    
});
