/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.coursetransaction.managedistribution.ManageDistributionController', {
	extend : 'Academia.controller.base.BaseController',

	models : [],
	
	stores : ['common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore','attendance.SectionAndFacultyByPeriodID',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	          'coursetransaction.managedistributionlist.ManageDistributionList','coursetransaction.managedistributionlist.CreateDistributionListStore',
	          'coursetransaction.studymaterialdistributionnew.DistributionListStr','coursetransaction.managedistributionlist.DistributionListCurrentStockStr',
	          'common.AcademyLocationNameSeparated','common.AccesibleAcademyLocationNameSeparated'],
	          
	views : ['coursetransaction.managedistribution.DistributionListStructure','coursetransaction.managedistribution.CreateDistributionSearch',
	         'coursetransaction.managedistribution.ManageDistributionStructure','coursetransaction.managedistribution.ManageDistributionSearch',
	         'coursetransaction.managedistribution.ManageDistributionList','coursetransaction.managedistribution.CreateDistributionList',
	         'coursetransaction.managedistribution.DistributionListWin'
	         ],	           

	         config:{
            	 
	        	 MANAGE_DISTRIBUTION_LIST_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MANAGE_DISTRIBUTION_LIST_PRIVILEGES')  		  
               },
               
               refs :[{
            	   ref : 'contentPanel',
            	   selector : 'contentPanel'
               },{
            	   ref : 'managedistributionlist',
            	   selector : 'managedistributionlist'
               },{
            	   ref : 'createdistributionlist',
            	   selector : 'createdistributionlist'
               },{
            	   ref : 'distributionliststructure',
            	   selector : 'distributionliststructure'
               },{
            	   ref : 'managedistributionstructure',
            	   selector : 'managedistributionstructure'
               },{
            	   ref : 'createdistributionsearch',
            	   selector : 'createdistributionsearch'
               },{
            	   ref : 'distributionlistwin',
            	   selector : 'distributionlistwin'
               },{
            	   ref : 'distributionListwin',
            	   selector : 'distributionlistwin form'
               },{
            	   ref : 'distributionListWin',
            	   selector : 'distributionlistwin grid'
               },{
            	   ref : 'managedistributionsearch',
            	   selector : 'managedistributionsearch'
               }],

	init : function() {
		this.control({
			
			'managedistributionstructure':{
				beforerender:function(){
					this.getManagedistributionlist().getStore().removeAll();
					this.doAccessControlValidation(this.getManagedistributionlist(), this.getMANAGE_DISTRIBUTION_LIST_PERMISSIONS());
				},
				afterrender : function(structure){
					var grid = structure.down('managedistributionlist');
					this.getGridHeaderFreeze(grid,structure,true);
				}
			},
			'managedistributionsearch':{
				render:function(obj){
					var form = this.getManagedistributionsearch();
					var academyLocationId =this.getCurrentAcademyLocation();
					var academyLocationCombo = form.down('#multiselectAcademyLocationId');
					var academyLocationComboStore=academyLocationCombo.getStore();
					academyLocationComboStore.load({
						 callback: function(record, operation, success) {
							   if (success) {
								   academyLocationCombo.setValue(academyLocationId);
							   }
						 }
					});
					
				}
			},
			'managedistributionsearch multiselectcombofield#multiselectAcademyLocationId' : {
   			 blur : function(obj, record) {
   				 var programCombo = obj.up('form').down('#programId');
   				 var batchCombo = obj.up('form').down('#batchId');
   				 var periodCombo = obj.up('form').down('#periodId');
   				 var sectionCombo = obj.up('form').down('#sectionId');
   				 var distributionListCombo = obj.up('form').down('#distributionId');
   				 var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
   	  				var alIds=[];
   					var academyLocationIds; 
   					if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
   						for(var i in academyLocationId){
   							if(Ext.isObject(academyLocationId[0])){
   								alIds.push(academyLocationId[i].get("id"));
   							}else{
   								alIds.push(academyLocationId[i]);
   							}
   						}
   						academyLocationIds = alIds.join();
   					} else {
   						alIds.push(this.getCurrentAcademyLocation());
   						academyLocationIds = alIds.join();
   					}
           		programCombo.reset();
           		batchCombo.reset();
           		periodCombo.reset();
           		sectionCombo.reset();
           		batchCombo.setDisabled(true);
           		periodCombo.setDisabled(true);
           		sectionCombo.setDisabled(true);
           		var programStore=programCombo.getStore();
           		programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
           		programStore.load();
           		distributionListCombo.reset();
           		var distributionList=distributionListCombo.getStore();
           		distributionList.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
           		distributionList.load();
   			 }
   		 },
			'managedistributionsearch customcombobox#programId' : {
				render:function(obj){
					var $this = this;
					var academyLocationId = $this.getCurrentAcademyLocation();
					var programCombo = obj.up('form').down('#programId');
					var periodStore = programCombo.getStore();
					periodStore.getProxy().extraParams = {
						academyLocationId : academyLocationId
					};
					//periodStore.load();
					
				},
				select : function(obj, record) {
   				 var batchComboBox = obj.up('form').down('#batchId');
				 var periodComboBox = obj.up('form').down('#periodId');
				 var sectionComboBox = obj.up('form').down('#sectionId');
				 batchComboBox.clearValue();
				 periodComboBox.clearValue();
				 sectionComboBox.clearValue();
				 batchComboBox.setDisabled(false);
				 periodComboBox.setDisabled(true);
				 sectionComboBox.setDisabled(true);

           	   var programId = record[0].get("id");
          	   var form = obj.up('form');
          	   var batch = form.down('#batchId');
          	   batch.reset();
          	   batch.setDisabled(false);
          	   if(programId > 0){
          		   var store = batch.getStore();
          		   store.getProxy().extraParams = {
          			   id: programId,
          			   isActive:true
          		   };
          		   store.load({

						   callback: function(record, operation, success) {
							   if (success) {
								   if(record.length==0){
									   form.down("#sectionId").setDisabled(true);
									   form.down("#sectionId").clearValue();
								   }
								   if(record.length==1){
									   form.down("#batchId").setValue(record[0].get('id'));
									   form.down("#periodId").setDisabled(false);
									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
									   store.getProxy().extraParams = {
										   id: record[0].get('id'),
										   isCurrentPeriod:true
									   };
									   store.load({
										   callback: function(record, operation, success) {
											   if (success) {
												   if(record.length==0){
													   if(wheatherSchool) {
														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

													   } 
												   }
												   else if(record.length==1){
													   form.down("#periodId").setValue(record[0].get('id'));
													   form.down("#sectionId").setDisabled(false);
													   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
													   store.getProxy().extraParams = {
														 periodId: record[0].get('id')
													   };
													   store.load({
														   callback: function(record, operation, success) {
															   if (success) {
																   if(record.length==1){
																	   form.down("#sectionId").setValue(record[0].get('sectionId'));
																   }
															   }
														   }
													   });

												   }else{
													   form.down('#periodId').setVisible(true); 
												   }
											   }
										   }
									   });
								   }
							   }
						   }
					   
          		   });
          	   }
             
			}
			},
			'managedistributionsearch customcombobox#batchId' : {
				select : function(obj, record) {
	 				   this$=this;
	            	   var form = obj.up('form');
					   var period = form.down('#periodId');
					   period.reset();
					   period.setDisabled(false);
					   var batchId = record[0].get("id");
					   if(batchId > 0){	    	        					  
						   var store = period.getStore();
						   store.getProxy().extraParams = {
							   id: batchId
						   };
						   store.load({

							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==0){
										   var sectionId = form.down('#sectionId');
			        					   sectionId.clearValue();
			        					   sectionId.setDisabled(true);
										   if(wheatherSchool) {
											   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

										   } 
									   }
									   else if(records.length==1){
										   form.down("#periodId").setValue(records[0].get('id'))
										   form.down("#sectionId").setDisabled(false);
										   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
			            				   var courseVariantPBSId = form.down('#courseVariantPBSId');
			        					   var batch = form.down('#batchId');
			        					   var sectionId = form.down('#sectionId');
			        					   sectionId.reset();
			        					   /*sectionId.setDisabled(false);
			        					   var storeSection = sectionId.getStore();
			        					   storeSection.getProxy().extraParams = {
			        						   periodId:periodId
			        					   };
			        					   storeSection.load();*/
										   store.getProxy().extraParams = {
											   periodId: records[0].get('id')
										   };
										   store.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   form.down("#sectionId").setValue(record[0].get('sectionId'));
													   }
												   }
											   }
										   });

									   }else{
										   form.down('#periodId').setVisible(true);
										   var sectionId = form.down('#sectionId');
			        					   sectionId.clearValue();
			        					   sectionId.setDisabled(true);
									   }
								   }
							   }
						   
						   });
					   }
				   }
			},
			 'managedistributionsearch customcombobox#periodId' : {
    			 select : function(obj, record) {
    				 var periodId = record[0].get("id");
    				 var programId= obj.up('form').down('#programId').getValue();
    				 var batchId=obj.up('form').down('#batchId').getValue();
    				 var sectionCombo = obj.up('form').down('#sectionId');
    				 var distributionCombo = obj.up('form').down('#distributionId');
    				 sectionCombo.clearValue();
    				 distributionCombo.clearValue();
    				 sectionCombo.setDisabled(false);
    				 var sectionStore =sectionCombo.getStore(); 
    				 sectionStore.getProxy().extraParams = {	
    					 periodId: periodId
    				 };
    				 sectionStore.load();
    				 var distributionStore =distributionCombo.getStore();
    				 distributionStore.getProxy().extraParams = {	
    					 programId: programId > 0 ? programId : 0,
    					 batchId:batchId > 0 ? batchId : 0,
    				     periodId:periodId > 0 ? periodId : 0,
    				 };
    				 distributionStore.load();
    				 
    			 }
    		 },
    		 /**********************************************/
    		 'createdistributionsearch multiselectcombofield#multiselectAcademyLocationId' : {
    			 blur : function(obj, record) {
    				 var programCombo = obj.up('form').down('#programId');
    				 var academyLocationId = obj.up('form').down('#multiselectAcademyLocationId').getValue();
    	  				var alIds=[];
    					var academyLocationIds; 
    					if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
    						for(var i in academyLocationId){
    							if(Ext.isObject(academyLocationId[0])){
    								alIds.push(academyLocationId[i].get("id"));
    							}else{
    								alIds.push(academyLocationId[i]);
    							}
    						}
    						academyLocationIds = alIds.join();
    					} else {
    						alIds.push(this.getCurrentAcademyLocation());
    						academyLocationIds = alIds.join();
    					}
            		programCombo.reset();
            		var programStore=programCombo.getStore();
            		programStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds
					};
            		programStore.load();
    			 }
    		 },
			'createdistributionsearch customcombobox#programId' : {
				render:function(obj){
					var $this = this;
					var academyLocationId = $this.getCurrentAcademyLocation();
//					var programCombo = $this.getPromotionsearch().down('#programId');
					var programCombo = obj.up('form').down('#programId');

					var periodStore = programCombo.getStore();
					periodStore.getProxy().extraParams = {
						academyLocationId : academyLocationId
					};
					periodStore.load();
				},
				select : function(obj, record) {
    				 var batchComboBox = obj.up('form').down('#batchId');
    				 var periodComboBox = obj.up('form').down('#periodId');
    				 var sectionComboBox = obj.up('form').down('#sectionId');
    				 batchComboBox.clearValue();
    				 periodComboBox.clearValue();
    				 sectionComboBox.clearValue();
    				 batchComboBox.setDisabled(false);
    				 periodComboBox.setDisabled(true);
    				 sectionComboBox.setDisabled(true);

               	   var programId = record[0].get("id");
              	   var form = obj.up('form');
              	   var batch = form.down('#batchId');
              	   batch.reset();
              	   batch.setDisabled(false);
              	   if(programId > 0){
              		   var store = batch.getStore();
              		   store.getProxy().extraParams = {
              			   id: programId,
              			   isActive:true
              		   };
              		   store.load({

  						   callback: function(record, operation, success) {
  							   if (success) {
  								   if(record.length==0){
  									   form.down("#sectionId").setDisabled(true);
  									   form.down("#sectionId").clearValue();
  								   }
  								   if(record.length==1){
  									   form.down("#batchId").setValue(record[0].get('id'));
  									   form.down("#periodId").setDisabled(false);
  									   var store = this$.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
  									   store.getProxy().extraParams = {
  										   id: record[0].get('id'),
  										   isCurrentPeriod:true
  									   };
  									   store.load({
  										   callback: function(record, operation, success) {
  											   if (success) {
  												   if(record.length==0){
  													   if(wheatherSchool) {
  														   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

  													   } 
  												   }
  												   else if(record.length==1){
  													   form.down("#periodId").setValue(record[0].get('id'));
  													   form.down("#sectionId").setDisabled(false);
  													   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
  													   store.getProxy().extraParams = {
  														 periodId: record[0].get('id')
  													   };
  													   store.load({
  														   callback: function(record, operation, success) {
  															   if (success) {
  																   if(record.length==1){
  																	//   form.down("#sectionId").setValue(record[0].get('sectionId'));
  																   }
  															   }
  														   }
  													   });

  												   }else{
  													   form.down('#periodId').setVisible(true); 
  												   }
  											   }
  										   }
  									   });
  								   }
  							   }
  						   }
  					   
              		   });
              	   }
                 
				}
			},
			'createdistributionsearch customcombobox#batchId' : {
				select : function(obj, record) {
 				   this$=this;
            	   var form = obj.up('form');
				   var period = form.down('#periodId');
				   period.reset();
				   period.setDisabled(false);
				   var batchId = record[0].get("id");
				   if(batchId > 0){	    	        					  
					   var store = period.getStore();
					   store.getProxy().extraParams = {
						   id: batchId
					   };
					   store.load({

						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==0){
									   if(wheatherSchool) {
										   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));

									   } 
								   }
								   else if(records.length==1){
									   form.down("#periodId").setValue(records[0].get('id'))
									   form.down("#sectionId").setDisabled(false);
									   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
		            				   var courseVariantPBSId = form.down('#courseVariantPBSId');
		        					   var batch = form.down('#batchId');
		        					   var sectionId = form.down('#sectionId');
		        					   sectionId.reset();
		        					   sectionId.setDisabled(false);
		        					   var storeSection = sectionId.getStore();
		        					   storeSection.getProxy().extraParams = {
		        						   periodId:periodId
		        					   };
		        					   storeSection.load();
									   store.getProxy().extraParams = {
										   periodId: records[0].get('id')
									   };
									   store.load({
										   callback: function(records, operation, success) {
											   if (success) {
												   if(records.length==1){
													   form.down("#sectionId").setValue(record[0].get('sectionId'));
												   }
											   }
										   }
									   });

								   }else{
									   form.down('#periodId').setVisible(true); 
								   }
							   }
						   }
					   
					   });
				   }
			   }
			},
			 'createdistributionsearch customcombobox#periodId' : {
    			 select : function(obj, record) {
  				   var periodId = record[0].get("id");
            	   var form = obj.up('form');
				   if(periodId > 0){
					   var batch = form.down('#batchId');
					   var sectionId = form.down('#sectionId');
					   sectionId.reset();
					   sectionId.setDisabled(false);
					   var storeSection = sectionId.getStore();
					   storeSection.getProxy().extraParams = {
						   periodId:periodId
					   };
					   storeSection.load();
				   }
			   }
    		 },
    		 'createdistributionsearch button[itemId=searchBtn]' : {
    			 click :function(obj){ 
    				 this.loadCoursereadingData(obj);
    			 }
    		 },
    		 'createdistributionsearch button[itemId=resetBtn]' : {
    			 click : function(obj){
    				 obj.up('form').getForm().reset();
    			 }
    		 },
    		 'managedistributionsearch button[itemId=resetBtn]' : {
    			 click : function(obj){
    				 var form = obj.up('form');
    				 form.getForm().reset();
    				 distributionComboStore = form.getForm().findField('distributionId').getStore();
    				 distributionComboStore.getProxy().extraParams = {
    					 query:''
    				 };
    				 distributionComboStore.load();
    				 form.down('#batchId').setDisabled(true);
    				 form.down('#periodId').setDisabled(true);
    				 form.down('#sectionId').setDisabled(true);
    				 
    			 }
    		 },
    		 'managedistributionsearch button[itemId=searchBtn]' : {
    			 click : function(obj){
    				 this.loadManageDistributionList(obj);
    			 }
    		 },
    		 'managedistributionlist button[itemId=btnAdd]':{
    			 click: function(){
    				this.showCreateDistributionList();
    				 this.getCreatedistributionlist().getStore().removeAll();
    			 }
    		 },
    		 'managedistributionlist button[itemId=btnEdit]':{
    			 click: function(){
    				this.editCreateDistributionList(); 
    			 }
    		 },
    		 'managedistributionlist button[itemId=btnDelete]':{
    			 click: function(){
    				this.deleteManageDistribution(); 
    			 }
    		 },
    		 'distributionliststructure button[itemId=submitBtn]' : {
    			 click : function(){
    				 this.saveDistributionRecord();
    			 }
    		 },
    		 'managedistributionlist':{
    			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

    				 var searchResultGrid = this.getManagedistributionlist();
    				 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

    				 if(columnName=='listName'){
    					 if (e.target.tagName == 'A') {
    						 this.openDistributionListWin(grid, rowIndex, record);
    					 }
    				 }

    			 }
 			},
 			
		});
	},
	showCreateDistributionList:function(){
   	 var me = this;
   	 var contentpanel = me.getContentPanel();
   	 var distributionliststructure = Ext.widget('distributionliststructure');
   	 var tabName = getCourseTxCommonTranslation('CREATE_DISTRIBUTION_LIST');
   	 
   	 var getcontroller=me.getController('menu.CoreERPNavigationController');
	 var getTab=getcontroller.getTab(tabName);
	 if(getTab!=null){
		 contentpanel.remove(getTab, true);
	 }
   	 openTab(contentpanel, tabName, distributionliststructure,CONSTANTS.MENU_COLOR_THREE);
   	 var createDistributionForm=this.getCreatedistributionsearch();
   	 var multiALBox=createDistributionForm.down('#multiselectAcademyLocationId');
   	 var multiALBoxStore=multiALBox.getStore();
   	 multiALBoxStore.load({
		callback : function(records,operation,success) {
			if (success) {
				multiALBox.setValue(me.getCurrentAcademyLocation());
			}
		}
   	 });
	},
	loadManageDistributionList:function(obj){
		var $this=this;
		var objForm = obj.up('form');
		objForm.down('#searchBtn').setDisabled(true);
		var form = objForm.getForm();
		var values = form.getValues();
		var programId = values.programId;
		var batchId = values.batchId;
		var periodId = values.periodId;
		var sectionId = values.sectionId;
		var distributionId = values.distributionId;
		var academyLocationId=values.multiselectAcademyLocation;
		 var alIds=[];
		 var academyLocationIds; 
		if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
			for(var i in academyLocationId){
				if(Ext.isObject(academyLocationId[0])){
					alIds.push(academyLocationId[i].get("id"));
				}else{
					alIds.push(academyLocationId[i]);
				}
			}
			academyLocationIds = alIds.join();
		} else {
			alIds.push(this.getCurrentAcademyLocation());
			academyLocationIds = alIds.join();
		}
		
		var grid = this.getManagedistributionlist();
		var store = grid.getStore();
		store.getProxy().extraParams = {
			programId: programId > 0 ? programId : 0,
			batchId:batchId > 0 ? batchId : 0,
			periodId:periodId > 0 ? periodId : 0,
			distributionId:distributionId > 0 ? distributionId : 0,
			sectionId:sectionId > 0 ? sectionId : 0 ,
			academyLocationIds:academyLocationIds,
		};
		$this.resetPageSetting(store);
		store.load({
			callback : function(records,operation,success) {
				if (success) {
					objForm.down('#searchBtn').setDisabled(false);
				}
			}
		});
		grid.config.searchFilterForm = obj.up('form');
	},
	
	loadCoursereadingData : function(obj){
		var from = obj.up('form').getForm();
		var values = from.getValues();
		programId = values.programId;
		batchId = values.batchId;
		periodId = values.periodId;
		sectionId = values.sectionId;
		
		var grid = this.getCreatedistributionlist();
		var store = grid.getStore();
		store.getProxy().extraParams = {
			programId: programId,
			batchId:batchId,
			periodId:periodId,
			sectionId:sectionId > 0 ? sectionId : 0,
			listId:0
		};
		store.load();
	},
	saveDistributionRecord:function(){
		var $this = this;
		var form = $this.getCreatedistributionsearch().getForm();
		var values = form.getValues();
		var listName = values.listName;
		var programId = values.programId;
		var batchId = values.batchId;
		var periodId = values.periodId;
		var sectionId = values.sectionId;
		

		var invtDistributionItemList = [];
		var grid = $this.getCreatedistributionlist();
		
		if (grid.getSelectionModel().getCount() > 0) {
			var selected = grid.selModel.getSelection();
			
			if( selected.length > 0){
				for(var i in selected){
					invtDistributionItemList.push({
						"courseReadingVariantId" : selected[i].data.courseReadingVariantId,
						"courseReadingId" : selected[i].data.courseReadingId
					});
				}	

			}
		var data = {
				"id":values.id,
				"listName":listName,
				"programId" :programId,
				"batchId":batchId,
				"periodId":periodId,
				"sectionId":sectionId,
				"invtDistributionItemLists" :invtDistributionItemList
		};
        		var dataFormate;
        		if(!isNullOrEmpty(values.id) && values.id > 0){
        			dataFormate = data;
        			submitUrl = SERVERURL.UPDATE_DISTRIBUTION_LIST;
        			
        		}else{
        		 submitUrl = SERVERURL.SAVE_DISTRIBUTION_LIST;
        		 dataFormate = [data];
        		}
        	 	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        		
    			 Ext.Ajax.request({
    				 type : 'rest',
    				 url : submitUrl,
    				 jsonData : dataFormate,
    				 method : 'POST',
    				 success : function(form, action) {
    					 Ext.getBody().unmask();
	            			$this.getContentPanel().getActiveTab().close();
    					 showSuccessMessage(getCourseTxCommonTranslation('CREATE_DISTRIBUTION_LIST'),getCommonTranslation('SUCCESS'));
    					 $this.getCreatedistributionlist().getStore().load();
    					 var activeTab = $this.getDistributionliststructure().up('panel');
            			 $this.closeTab(activeTab);
    				 }
    			 });
				
		}else{
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));			
		}	
	
	},
	  closeTab : function(tabReference) {
     	 tabReference.close();
      },
	editCreateDistributionList:function(){
		var $this = this;
		var grid = this.getManagedistributionlist();
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			$this.showCreateDistributionList();
			var searcForm = $this.getCreatedistributionsearch();
			searcForm.down('#searchBtn').setVisible(false);
			searcForm.down('#resetBtn').setVisible(false);
			var form = searcForm.getForm();
			if (records != undefined && records != ""&& records != null) {
				var id = records[0].data.id;
				var alId=records[0].data.academyLocationId;
				
				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.DISTRIBUTION_LIST_FIND_BY_ID,
					params : {
						id : id
					},
					method : 'GET',
					success : function(response) {
						var data = Ext.decode(response.responseText);
						form.findField('id').setValue(data.id);

						var listNameField = form.findField('listName');
						var multiAlCombo = form.findField('multiselectAcademyLocation');
						var programCombo = form.findField('programId');
						var batchCombo = form.findField('batchId');
						var periodCombo = form.findField('periodId');
						var sectionCombo = form.findField('sectionId');
						multiAlCombo.allowBlank=true;
						multiAlCombo.hide();
						programCombo.setDisabled(false);
						batchCombo.setDisabled(false);
						periodCombo.setDisabled(false);
						programCombo.setReadOnly(true);
						batchCombo.setReadOnly(true);
						periodCombo.setReadOnly(true);
						sectionCombo.setDisabled(false);
						sectionCombo.setReadOnly(true);
						
						
						if(!isNullOrEmpty(data.listName)){
							listNameField.setValue(data.listName);
						}
						var academyLocationId;
						if(isNullOrEmpty(alId)){
							academyLocationId=$this.getCurrentAcademyLocation();
						}else{
							academyLocationId=alId;
						}
						
						if(!isNullOrEmpty(data.programId)){
							programCombo.getStore().getProxy().extraParams = {
								academyLocationId : academyLocationId
							};
							programCombo.store.load({
								callback : function(records,operation,success) {
									if (success) {
										programCombo.setValue(data.programId);
									}
								}
							});
						}
						
						if(!isNullOrEmpty(data.batchId)){
							batchCombo.getStore().getProxy().extraParams = {
								id: data.programId,
								isActive:true
							};
							batchCombo.store.load({
								callback : function(records,operation,success) {
									if (success) {
										batchCombo.setValue(data.batchId);
									}
								}
							});
						}
						
						if(!isNullOrEmpty(data.periodId)){
							periodCombo.getStore().getProxy().extraParams = {
								id: data.batchId,
								isCurrentPeriod : true
							};
							periodCombo.store.load({
								callback : function(records,operation,success) {
									if (success) {
										periodCombo.setValue(data.periodId);
									}
								}
							});
						}
						
						if(!isNullOrEmpty(data.sectionId)){
							sectionCombo.getStore().getProxy().extraParams = {
								periodId: data.periodId
							};
							sectionCombo.store.load({
								callback : function(records,operation,success) {
									if (success) {
										sectionCombo.setValue(data.sectionId);
									}
								}
							});
						}
						
						var cGrid = $this.getCreatedistributionlist();
						var store = cGrid.getStore();
						store.getProxy().extraParams = {
							programId: data.programId,
							batchId:data.batchId,
							periodId:data.periodId,
							sectionId:data.sectionId > 0 ? data.sectionId : 0,
							listId:data.id
						};
						store.load();
						
					}
				});
			}
		} else {
			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
		}
	},
	deleteManageDistribution : function(o, r) {
     	 var $this = this;
     	 var grid = $this.getManagedistributionlist();
     	 if (grid.getSelectionModel().getCount() > 0) {
     		showConfirmMessage(getCourseTxCommonTranslation('MANAGE_DISTRIBUTION_LIST'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
     				 function(btn, text) {
     					 if (btn == 'yes') {
     						 var records = grid.getSelectionModel().getSelection()[0];
     						 var id = records.data.id;
     						 Ext.Ajax.request({
     							 method : "DELETE",
     							 type : 'rest',
     							 url : SERVERURL.DELETE_DISTRIBUTION_LIST + '?id=' + id,
     							 headers : {
     								 'Content-Type' : 'application/json'
     							 },
     							 params : {
     								 id : id
     							 },
     							 success : function(form, action) {
     								if(form.responseText == "DEPENDENT_RECORD_EXISTS"){
   									 showWarningMessage(getCommonTranslation('ALERT'),
   											 getProgramandcourseTranslation('DEPENDENT_RECORD_EXISTS_DISTRIBUTION_LIST'));
   								 }else{
     									 showSuccessMessage(getCourseTxCommonTranslation('MANAGE_DISTRIBUTION_LIST'), getCommonTranslation('SUCCESS'));
     									 grid.getStore().reload();
     							 }
     							 }
     						 });
     					 }
     				 });
     	 } else {
     		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     	 }

     },
     openDistributionListWin:function(grid, rowIndex, record){

    	 var $this = this;
    	 var formWindow = $this.getDistributionlistwin();
    	 if (!formWindow) {
    		 Ext.widget('distributionlistwin');
    		 formWindow = $this.getDistributionlistwin();
    	 }
    	 formWindow.show();

    	 var form = $this.getDistributionListwin().getForm();
    	 if(!isNullOrEmpty(record.data.listName)){
    		 form.findField('listName').setValue(record.data.listName);
    	 }

    	 
    	 var store = $this.getDistributionListWin().getStore();
     			store.getProxy().extraParams = {
     				courseReadingVariantIds:record.data.courseReadingVariantsIds.join()
     			};
     			store.load();
     }
});
